/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-04-27 07:08:36 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT 1,
  `ts_status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT 0,
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_mo_files_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_path` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_path_md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not_imported',
  `num_of_strings` int(11) NOT NULL DEFAULT 0,
  `last_modified` int(11) NOT NULL,
  `component_type` enum('plugin','theme','other') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `component_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_path_md5_UNIQUE` (`file_path_md5`)
) ENGINE=MyISAM AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_batches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `batch_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_packages` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kind_slug` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kind` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `edit_link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `view_link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` int(11) DEFAULT NULL,
  `word_count` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `url_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_to_url_id` (`url_id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mo_string` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `translation_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_string_lang_url` (`language`,`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `location` bigint(20) unsigned DEFAULT NULL,
  `wrap_tag` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain_name_context_md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_priority` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `word_count` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`),
  KEY `icl_strings_name` (`name`),
  KEY `icl_strings_translation_priority` (`translation_priority`),
  KEY `context` (`context`),
  KEY `string_package_id` (`string_package_id`)
) ENGINE=MyISAM AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `field_type` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_wrap_tag` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deadline_date` datetime DEFAULT NULL,
  `completed_date` datetime DEFAULT NULL,
  `editor` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editor_job_id` bigint(20) unsigned DEFAULT NULL,
  `edit_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_downloads` (
  `editor_job_id` bigint(20) unsigned NOT NULL,
  `download_url` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lock_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`editor_job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `translation_package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `links_fixed` tinyint(4) NOT NULL DEFAULT 0,
  `_prevstate` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT 1,
  `ts_status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=655 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=7813 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=150375 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1601 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(9) NOT NULL DEFAULT -1,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `absolute` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `owner` bigint(20) NOT NULL,
  `ord` mediumint(10) NOT NULL DEFAULT 0,
  `oldCustomOrder` mediumint(10) DEFAULT NULL,
  `contentCustomOrder` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `restrictions` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cnt` mediumint(10) DEFAULT NULL,
  `importId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_icl_count` (
  `fid` mediumint(9) NOT NULL,
  `cnt_da` mediumint(10) DEFAULT NULL,
  `cnt_en` mediumint(10) DEFAULT NULL,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `realmedialibrary_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `realmedialibrary_id` (`realmedialibrary_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_posts` (
  `attachment` bigint(20) NOT NULL,
  `fid` mediumint(9) NOT NULL DEFAULT -1,
  `isShortcut` bigint(20) NOT NULL DEFAULT 0,
  `nr` bigint(20) DEFAULT NULL,
  `oldCustomNr` bigint(20) DEFAULT NULL,
  `importData` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attachment`,`isShortcut`),
  KEY `rmljoin` (`attachment`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_tmp` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(9) NOT NULL DEFAULT -1,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ord` mediumint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  `term_order` int(4) DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/* DUPLICATOR PRO TABLE CREATION END */
INSERT INTO `wp_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2021-03-28 17:18:48","2021-03-28 17:18:48","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","comment","0","0");

INSERT INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1619726346,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": false,\n    \"lkp\": \"\",\n    \"license_limit\": 15,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1619506343,\n    \"initial_activation_timestamp\": 1617305978,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": null,\n    \"lkp\": \"oPnq9fSgUpQUkAUbKnfgGA==\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1619507315,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}"),
("4","DUP_PRO_Package_Template_Entity","{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":0,\"installer_opts_secure_pass\":\"\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");

INSERT INTO `wp_duplicator_pro_packages` VALUES 
("6","20210420_milo","670f71a1ba9008e28524_20210420090904","100","2021-04-20 09:09:11","raffinaderiet","{\n    \"Created\": \"2021-04-20 09:09:04\",\n    \"Version\": \"4.0.2\",\n    \"VersionWP\": \"5.7.1\",\n    \"VersionDB\": \"10.5.9\",\n    \"VersionPHP\": \"8.0.3\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 6,\n    \"Name\": \"20210420_milo\",\n    \"Hash\": \"670f71a1ba9008e28524_20210420090904\",\n    \"NameHash\": \"20210420_milo_670f71a1ba9008e28524_20210420090904\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_scan.json\",\n    \"timer_start\": 1618909761.801305,\n    \"Runtime\": \"68.568 sec.\",\n    \"ExeSize\": \"77.77KB\",\n    \"ZipSize\": \"211.08MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.opcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.tmb\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.htaccess\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.user.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/php.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/web.config\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\",\n        \"Size\": 221333928,\n        \"Dirs\": null,\n        \"DirCount\": 2093,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 18248,\n        \"file_count\": 20341,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_installer.php\",\n        \"Size\": 79640,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"milo_web_db\",\n            \"tablesBaseCount\": 43,\n            \"tablesFinalCount\": 43,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 11576,\n            \"tablesSizeOnDisk\": 3235858,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 7492\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 9840\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 1024\n                },\n                \"wp_icl_content_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_core_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_flags\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": 65,\n                    \"size\": 4388\n                },\n                \"wp_icl_languages\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": 65,\n                    \"size\": 11252\n                },\n                \"wp_icl_languages_translations\": {\n                    \"inaccurateRows\": 4225,\n                    \"insertedRows\": 4225,\n                    \"size\": 228012\n                },\n                \"wp_icl_locale_map\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 2088\n                },\n                \"wp_icl_message_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"inaccurateRows\": 80,\n                    \"insertedRows\": 80,\n                    \"size\": 19224\n                },\n                \"wp_icl_node\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_reminders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_batches\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 2152\n                },\n                \"wp_icl_string_pages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_positions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_translations\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 4224\n                },\n                \"wp_icl_string_urls\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_icl_strings\": {\n                    \"inaccurateRows\": 152,\n                    \"insertedRows\": 152,\n                    \"size\": 64168\n                },\n                \"wp_icl_translate\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_translate_job\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_icl_translation_batches\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 2112\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_icl_translation_status\": {\n                    \"inaccurateRows\": 156,\n                    \"insertedRows\": 156,\n                    \"size\": 14832\n                },\n                \"wp_icl_translations\": {\n                    \"inaccurateRows\": 587,\n                    \"insertedRows\": 587,\n                    \"size\": 93100\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 396,\n                    \"insertedRows\": 396,\n                    \"size\": 1387892\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 4670,\n                    \"insertedRows\": 4670,\n                    \"size\": 906352\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 575,\n                    \"insertedRows\": 575,\n                    \"size\": 344864\n                },\n                \"wp_realmedialibrary\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": 59,\n                    \"size\": 6232\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": 59,\n                    \"size\": 2638\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"inaccurateRows\": 308,\n                    \"insertedRows\": 308,\n                    \"size\": 22552\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": 64,\n                    \"size\": 6464\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": 18,\n                    \"size\": 4804\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 10448\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": 18,\n                    \"size\": 13968\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": 59,\n                    \"size\": 15296\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 8456\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.5.9\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2685886,\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\\/20210420_milo_670f71a1ba9008e28524_20210420090904_database.sql\"\n    },\n    \"Status\": \"100.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1618909830,\n        \"initialized\": true,\n        \"installer_built\": true,\n        \"archive_started\": true,\n        \"archive_has_database\": false,\n        \"archive_built\": true,\n        \"database_script_built\": true,\n        \"failed\": false,\n        \"next_archive_file_index\": 18248,\n        \"next_archive_dir_index\": 8372,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_icl_content_status\",\n            \"wp_icl_core_status\",\n            \"wp_icl_flags\",\n            \"wp_icl_languages\",\n            \"wp_icl_languages_translations\",\n            \"wp_icl_locale_map\",\n            \"wp_icl_message_status\",\n            \"wp_icl_mo_files_domains\",\n            \"wp_icl_node\",\n            \"wp_icl_reminders\",\n            \"wp_icl_string_batches\",\n            \"wp_icl_string_packages\",\n            \"wp_icl_string_pages\",\n            \"wp_icl_string_positions\",\n            \"wp_icl_string_status\",\n            \"wp_icl_string_translations\",\n            \"wp_icl_string_urls\",\n            \"wp_icl_strings\",\n            \"wp_icl_translate\",\n            \"wp_icl_translate_job\",\n            \"wp_icl_translation_batches\",\n            \"wp_icl_translation_downloads\",\n            \"wp_icl_translation_status\",\n            \"wp_icl_translations\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_realmedialibrary\",\n            \"wp_realmedialibrary_icl_count\",\n            \"wp_realmedialibrary_meta\",\n            \"wp_realmedialibrary_posts\",\n            \"wp_realmedialibrary_tmp\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_usermeta\",\n            \"wp_users\"\n        ],\n        \"validationStage1\": true,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": true,\n        \"startTime\": 1618909761.806282,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 11577,\n            \"impreciseTotalRows\": 11577,\n            \"tables\": {\n                \"wp_commentmeta\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_comments\": {\n                    \"start\": \"1\",\n                    \"end\": \"1\",\n                    \"count\": 1\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": \"5\",\n                    \"end\": \"5\",\n                    \"count\": 5\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": \"1\",\n                    \"end\": \"1\",\n                    \"count\": 1\n                },\n                \"wp_icl_content_status\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_core_status\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_flags\": {\n                    \"start\": \"65\",\n                    \"end\": \"65\",\n                    \"count\": 65\n                },\n                \"wp_icl_languages\": {\n                    \"start\": \"65\",\n                    \"end\": \"65\",\n                    \"count\": 65\n                },\n                \"wp_icl_languages_translations\": {\n                    \"start\": \"4225\",\n                    \"end\": \"4225\",\n                    \"count\": 4225\n                },\n                \"wp_icl_locale_map\": {\n                    \"start\": \"2\",\n                    \"end\": \"2\",\n                    \"count\": 2\n                },\n                \"wp_icl_message_status\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"start\": \"80\",\n                    \"end\": \"80\",\n                    \"count\": 80\n                },\n                \"wp_icl_node\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_reminders\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_string_batches\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_string_packages\": {\n                    \"start\": \"1\",\n                    \"end\": \"1\",\n                    \"count\": 1\n                },\n                \"wp_icl_string_pages\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_string_positions\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_string_status\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_string_translations\": {\n                    \"start\": \"4\",\n                    \"end\": \"4\",\n                    \"count\": 4\n                },\n                \"wp_icl_string_urls\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_strings\": {\n                    \"start\": \"152\",\n                    \"end\": \"152\",\n                    \"count\": 152\n                },\n                \"wp_icl_translate\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_translate_job\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_translation_batches\": {\n                    \"start\": \"1\",\n                    \"end\": \"1\",\n                    \"count\": 1\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_icl_translation_status\": {\n                    \"start\": \"156\",\n                    \"end\": \"156\",\n                    \"count\": 156\n                },\n                \"wp_icl_translations\": {\n                    \"start\": \"587\",\n                    \"end\": \"587\",\n                    \"count\": 587\n                },\n                \"wp_links\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_options\": {\n                    \"start\": \"396\",\n                    \"end\": \"396\",\n                    \"count\": 396\n                },\n                \"wp_postmeta\": {\n                    \"start\": \"4670\",\n                    \"end\": \"4670\",\n                    \"count\": 4670\n                },\n                \"wp_posts\": {\n                    \"start\": \"575\",\n                    \"end\": \"575\",\n                    \"count\": 575\n                },\n                \"wp_realmedialibrary\": {\n                    \"start\": \"59\",\n                    \"end\": \"59\",\n                    \"count\": 59\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"start\": \"59\",\n                    \"end\": \"59\",\n                    \"count\": 59\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"start\": \"308\",\n                    \"end\": \"308\",\n                    \"count\": 308\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"start\": \"0\",\n                    \"end\": \"0\",\n                    \"count\": 0\n                },\n                \"wp_term_relationships\": {\n                    \"start\": \"64\",\n                    \"end\": \"64\",\n                    \"count\": 64\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": \"18\",\n                    \"end\": \"18\",\n                    \"count\": 18\n                },\n                \"wp_termmeta\": {\n                    \"start\": \"4\",\n                    \"end\": \"4\",\n                    \"count\": 4\n                },\n                \"wp_terms\": {\n                    \"start\": \"18\",\n                    \"end\": \"18\",\n                    \"count\": 18\n                },\n                \"wp_usermeta\": {\n                    \"start\": \"59\",\n                    \"end\": \"59\",\n                    \"count\": 59\n                },\n                \"wp_users\": {\n                    \"start\": \"2\",\n                    \"end\": \"2\",\n                    \"count\": 2\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1618909830,\n            \"stopped_timestamp\": 1618909830\n        }\n    ],\n    \"active_storage_id\": -2,\n    \"template_id\": 5\n}"),
("7","20210427_milo","bb153f4003903e991589_20210427070818","20","2021-04-27 07:08:24","sgsmedia","{\n    \"Created\": \"2021-04-27 07:08:18\",\n    \"Version\": \"4.0.2\",\n    \"VersionWP\": \"5.7.1\",\n    \"VersionDB\": \"10.5.9\",\n    \"VersionPHP\": \"8.0.3\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 7,\n    \"Name\": \"20210427_milo\",\n    \"Hash\": \"bb153f4003903e991589_20210427070818\",\n    \"NameHash\": \"20210427_milo_bb153f4003903e991589_20210427070818\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210427_milo_bb153f4003903e991589_20210427070818_scan.json\",\n    \"timer_start\": 1619507315.68267,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.opcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.tmb\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.htaccess\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.user.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/php.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/web.config\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": \"20210427_milo_bb153f4003903e991589_20210427070818_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\",\n        \"Size\": 308366105,\n        \"Dirs\": null,\n        \"DirCount\": 2093,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 18325,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20210427_milo_bb153f4003903e991589_20210427070818_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"milo_web_db\",\n            \"tablesBaseCount\": 43,\n            \"tablesFinalCount\": 43,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 66911,\n            \"tablesSizeOnDisk\": 10963478,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 7492\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 9840\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 28240\n                },\n                \"wp_icl_content_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_core_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_flags\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 4388\n                },\n                \"wp_icl_languages\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 11252\n                },\n                \"wp_icl_languages_translations\": {\n                    \"inaccurateRows\": 4225,\n                    \"insertedRows\": false,\n                    \"size\": 228012\n                },\n                \"wp_icl_locale_map\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 2088\n                },\n                \"wp_icl_message_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"inaccurateRows\": 82,\n                    \"insertedRows\": false,\n                    \"size\": 19492\n                },\n                \"wp_icl_node\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_reminders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_batches\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2152\n                },\n                \"wp_icl_string_pages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_positions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_translations\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 4224\n                },\n                \"wp_icl_string_urls\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_icl_strings\": {\n                    \"inaccurateRows\": 152,\n                    \"insertedRows\": false,\n                    \"size\": 64168\n                },\n                \"wp_icl_translate\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translate_job\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translation_batches\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2112\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_icl_translation_status\": {\n                    \"inaccurateRows\": 168,\n                    \"insertedRows\": false,\n                    \"size\": 15264\n                },\n                \"wp_icl_translations\": {\n                    \"inaccurateRows\": 615,\n                    \"insertedRows\": false,\n                    \"size\": 98668\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 401,\n                    \"insertedRows\": false,\n                    \"size\": 1435696\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 59631,\n                    \"insertedRows\": false,\n                    \"size\": 8477000\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 862,\n                    \"insertedRows\": false,\n                    \"size\": 416812\n                },\n                \"wp_realmedialibrary\": {\n                    \"inaccurateRows\": 61,\n                    \"insertedRows\": false,\n                    \"size\": 6364\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"inaccurateRows\": 61,\n                    \"insertedRows\": false,\n                    \"size\": 2658\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"inaccurateRows\": 338,\n                    \"insertedRows\": false,\n                    \"size\": 25200\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": false,\n                    \"size\": 6632\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 4804\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 10448\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 13968\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": false,\n                    \"size\": 16064\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 8456\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.5.9\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": \"20210427_milo_bb153f4003903e991589_20210427070818_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\\/20210427_milo_bb153f4003903e991589_20210427070818_database.sql\"\n    },\n    \"Status\": \"20.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1619507316,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_icl_content_status\",\n            \"wp_icl_core_status\",\n            \"wp_icl_flags\",\n            \"wp_icl_languages\",\n            \"wp_icl_languages_translations\",\n            \"wp_icl_locale_map\",\n            \"wp_icl_message_status\",\n            \"wp_icl_mo_files_domains\",\n            \"wp_icl_node\",\n            \"wp_icl_reminders\",\n            \"wp_icl_string_batches\",\n            \"wp_icl_string_packages\",\n            \"wp_icl_string_pages\",\n            \"wp_icl_string_positions\",\n            \"wp_icl_string_status\",\n            \"wp_icl_string_translations\",\n            \"wp_icl_string_urls\",\n            \"wp_icl_strings\",\n            \"wp_icl_translate\",\n            \"wp_icl_translate_job\",\n            \"wp_icl_translation_batches\",\n            \"wp_icl_translation_downloads\",\n            \"wp_icl_translation_status\",\n            \"wp_icl_translations\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_realmedialibrary\",\n            \"wp_realmedialibrary_icl_count\",\n            \"wp_realmedialibrary_meta\",\n            \"wp_realmedialibrary_posts\",\n            \"wp_realmedialibrary_tmp\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_usermeta\",\n            \"wp_users\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1619507315.689488,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 66912,\n            \"tables\": {\n                \"wp_commentmeta\": {\n                    \"start\": \"0\",\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_content_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_core_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_flags\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_languages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_languages_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_locale_map\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_message_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_node\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_reminders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_batches\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_pages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_positions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_urls\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_strings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translate\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translate_job\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_batches\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");

INSERT INTO `wp_icl_flags` VALUES 
("1","ar","ar.png","0"),
("2","az","az.png","0"),
("3","bg","bg.png","0"),
("4","bn","bn.png","0"),
("5","bs","bs.png","0"),
("6","ca","ca.png","0"),
("7","cs","cs.png","0"),
("8","cy","cy.png","0"),
("9","da","da.png","0"),
("10","de","de.png","0"),
("11","el","el.png","0"),
("12","en","en.png","0"),
("13","eo","eo.png","0"),
("14","es","es.png","0"),
("15","et","et.png","0"),
("16","eu","eu.png","0"),
("17","fa","fa.png","0"),
("18","fi","fi.png","0"),
("19","fr","fr.png","0"),
("20","ga","ga.png","0"),
("21","gl","gl.png","0"),
("22","he","he.png","0"),
("23","hi","hi.png","0"),
("24","hr","hr.png","0"),
("25","hu","hu.png","0"),
("26","hy","hy.png","0"),
("27","id","id.png","0"),
("28","is","is.png","0"),
("29","it","it.png","0"),
("30","ja","ja.png","0"),
("31","ko","ko.png","0"),
("32","ku","ku.png","0"),
("33","lt","lt.png","0"),
("34","lv","lv.png","0"),
("35","mk","mk.png","0"),
("36","mn","mn.png","0"),
("37","ms","ms.png","0"),
("38","mt","mt.png","0"),
("39","ne","ne.png","0"),
("40","nl","nl.png","0"),
("41","no","no.png","0"),
("42","pa","pa.png","0"),
("43","pl","pl.png","0"),
("44","pt-br","pt-br.png","0"),
("45","pt-pt","pt-pt.png","0"),
("46","qu","qu.png","0"),
("47","ro","ro.png","0"),
("48","ru","ru.png","0"),
("49","sk","sk.png","0"),
("50","sl","sl.png","0"),
("51","so","so.png","0"),
("52","sq","sq.png","0"),
("53","sr","sr.png","0"),
("54","sv","sv.png","0"),
("55","ta","ta.png","0"),
("56","th","th.png","0"),
("57","tr","tr.png","0"),
("58","uk","uk.png","0"),
("59","ur","ur.png","0"),
("60","uz","uz.png","0"),
("61","vi","vi.png","0"),
("62","yi","yi.png","0"),
("63","zh-hans","zh.png","0"),
("64","zh-hant","zh.png","0"),
("65","zu","zu.png","0");

INSERT INTO `wp_icl_languages` VALUES 
("1","en","English","1","1","en_US","en","0"),
("2","es","Spanish","1","0","es_ES","es","0"),
("3","de","German","1","0","de_DE","de","0"),
("4","fr","French","1","0","fr_FR","fr","0"),
("5","ar","Arabic","0","0","ar","ar","0"),
("6","bs","Bosnian","0","0","bs_BA","bs","0"),
("7","bg","Bulgarian","0","0","bg_BG","bg","0"),
("8","ca","Catalan","0","0","ca","ca","0"),
("9","cs","Czech","0","0","cs_CZ","cs","0"),
("10","sk","Slovak","0","0","sk_SK","sk","0"),
("11","cy","Welsh","0","0","cy_GB","cy","0"),
("12","da","Danish","1","1","da_DK","da","0"),
("13","el","Greek","0","0","el","el","0"),
("14","eo","Esperanto","0","0","eo_UY","eo","0"),
("15","et","Estonian","0","0","et","et","0"),
("16","eu","Basque","0","0","eu_ES","eu","0"),
("17","fa","Persian","0","0","fa_IR","fa","0"),
("18","fi","Finnish","0","0","fi","fi","0"),
("19","ga","Irish","0","0","ga_IE","ga","0"),
("20","he","Hebrew","0","0","he_IL","he","0"),
("21","hi","Hindi","0","0","hi_IN","hi","0"),
("22","hr","Croatian","0","0","hr","hr","0"),
("23","hu","Hungarian","0","0","hu_HU","hu","0"),
("24","hy","Armenian","0","0","hy_AM","hy","0"),
("25","id","Indonesian","0","0","id_ID","id","0"),
("26","is","Icelandic","0","0","is_IS","is","0"),
("27","it","Italian","1","0","it_IT","it","0"),
("28","ja","Japanese","1","0","ja","ja","0"),
("29","ko","Korean","0","0","ko_KR","ko","0"),
("30","ku","Kurdish","0","0","ckb","ku","0"),
("31","lv","Latvian","0","0","lv_LV","lv","0"),
("32","lt","Lithuanian","0","0","lt_LT","lt","0"),
("33","mk","Macedonian","0","0","mk_MK","mk","0"),
("34","mt","Maltese","0","0","mt_MT","mt","0"),
("35","mn","Mongolian","0","0","mn_MN","mn","0"),
("36","ne","Nepali","0","0","ne","ne","0"),
("37","nl","Dutch","1","0","nl_NL","nl","0"),
("38","no","Norwegian Bokmål","0","0","nb_NO","no","0"),
("39","pa","Punjabi","0","0","pa_IN","pa","0"),
("40","pl","Polish","0","0","pl_PL","pl","0"),
("41","pt-pt","Portuguese, Portugal","0","0","pt_PT","pt-pt","0"),
("42","pt-br","Portuguese, Brazil","0","0","pt_BR","pt-br","0"),
("43","qu","Quechua","0","0","quz_PE","qu","0"),
("44","ro","Romanian","0","0","ro_RO","ro","0"),
("45","ru","Russian","1","0","ru_RU","ru","0"),
("46","sl","Slovenian","0","0","sl_SI","sl","0"),
("47","so","Somali","0","0","so_SO","so","0"),
("48","sq","Albanian","0","0","sq_AL","sq","0"),
("49","sr","Serbian","0","0","sr_RS","sr","0"),
("50","sv","Swedish","0","0","sv_SE","sv","0"),
("51","ta","Tamil","0","0","ta_IN","ta","0"),
("52","th","Thai","0","0","th","th","0"),
("53","tr","Turkish","0","0","tr_TR","tr","0"),
("54","uk","Ukrainian","0","0","uk","uk","0"),
("55","ur","Urdu","0","0","ur","ur","0"),
("56","uz","Uzbek","0","0","uz_UZ","uz","0"),
("57","vi","Vietnamese","0","0","vi_VN","vi","0"),
("58","yi","Yiddish","0","0","","yi","0"),
("59","zh-hans","Chinese (Simplified)","1","0","zh_CN","zh-hans","0"),
("60","zu","Zulu","0","0","","zu","0"),
("61","zh-hant","Chinese (Traditional)","1","0","zh_TW","zh-hant","0"),
("62","ms","Malay","0","0","ms_MY","ms","0"),
("63","gl","Galician","0","0","gl_ES","gl","0"),
("64","bn","Bengali","0","0","bn_BD","bn","0"),
("65","az","Azerbaijani","0","0","az","az","0");

INSERT INTO `wp_icl_languages_translations` VALUES 
("1","en","en","English"),
("2","en","es","Inglés"),
("3","en","de","Englisch"),
("4","en","fr","Anglais"),
("5","en","ar","الإنجليزية"),
("6","en","bs","English"),
("7","en","bg","Английски"),
("8","en","ca","English"),
("9","en","cs","Angličtina"),
("10","en","sk","Angličtina"),
("11","en","cy","English"),
("12","en","da","English"),
("13","en","el","Αγγλικά"),
("14","en","eo","English"),
("15","en","et","English"),
("16","en","eu","English"),
("17","en","fa","English"),
("18","en","fi","Englanti"),
("19","en","ga","English"),
("20","en","he","אנגלית"),
("21","en","hi","English"),
("22","en","hr","Engleski"),
("23","en","hu","Angol"),
("24","en","hy","English"),
("25","en","id","English"),
("26","en","is","English"),
("27","en","it","Inglese"),
("28","en","ja","英語"),
("29","en","ko","영어"),
("30","en","ku","English"),
("31","en","lv","English"),
("32","en","lt","English"),
("33","en","mk","English"),
("34","en","mt","English"),
("35","en","mn","English"),
("36","en","ne","English"),
("37","en","nl","Engels"),
("38","en","no","Engelsk"),
("39","en","pa","English"),
("40","en","pl","Angielski"),
("41","en","pt-pt","Inglês"),
("42","en","pt-br","Inglês"),
("43","en","qu","English"),
("44","en","ro","Engleză"),
("45","en","ru","Английский"),
("46","en","sl","Angleščina"),
("47","en","so","English"),
("48","en","sq","English"),
("49","en","sr","енглески"),
("50","en","sv","Engelska"),
("51","en","ta","English"),
("52","en","th","อังกฤษ"),
("53","en","tr","İngilizce"),
("54","en","uk","English"),
("55","en","ur","English"),
("56","en","uz","English"),
("57","en","vi","English"),
("58","en","yi","English"),
("59","en","zh-hans","英语"),
("60","en","zu","English"),
("61","en","zh-hant","英語"),
("62","en","ms","English"),
("63","en","gl","English"),
("64","en","bn","English"),
("65","en","az","Ingilis"),
("66","es","en","Spanish"),
("67","es","es","Español"),
("68","es","de","Spanisch"),
("69","es","fr","Espagnol"),
("70","es","ar","الأسبانية"),
("71","es","bs","Spanish"),
("72","es","bg","Испански"),
("73","es","ca","Spanish"),
("74","es","cs","Španělský"),
("75","es","sk","Španielčina"),
("76","es","cy","Spanish"),
("77","es","da","Spanish"),
("78","es","el","Ισπανικά"),
("79","es","eo","Spanish"),
("80","es","et","Spanish"),
("81","es","eu","Spanish"),
("82","es","fa","Spanish"),
("83","es","fi","Espanja"),
("84","es","ga","Spanish"),
("85","es","he","ספרדית"),
("86","es","hi","Spanish"),
("87","es","hr","španjolski"),
("88","es","hu","Spanyol"),
("89","es","hy","Spanish"),
("90","es","id","Spanish"),
("91","es","is","Spanish"),
("92","es","it","Spagnolo"),
("93","es","ja","スペイン語"),
("94","es","ko","스페인어"),
("95","es","ku","Spanish"),
("96","es","lv","Spanish"),
("97","es","lt","Spanish"),
("98","es","mk","Spanish"),
("99","es","mt","Spanish"),
("100","es","mn","Spanish"),
("101","es","ne","Spanish"),
("102","es","nl","Spaans"),
("103","es","no","Spansk"),
("104","es","pa","Spanish"),
("105","es","pl","Hiszpański"),
("106","es","pt-pt","Espanhol"),
("107","es","pt-br","Espanhol"),
("108","es","qu","Spanish"),
("109","es","ro","Spaniolă"),
("110","es","ru","Испанский"),
("111","es","sl","Španščina"),
("112","es","so","Spanish"),
("113","es","sq","Spanish"),
("114","es","sr","шпански"),
("115","es","sv","Spanska"),
("116","es","ta","Spanish"),
("117","es","th","สเปน"),
("118","es","tr","İspanyolca"),
("119","es","uk","Spanish"),
("120","es","ur","Spanish"),
("121","es","uz","Spanish"),
("122","es","vi","Spanish"),
("123","es","yi","Spanish"),
("124","es","zh-hans","西班牙语"),
("125","es","zu","Spanish"),
("126","es","zh-hant","西班牙語"),
("127","es","ms","Spanish"),
("128","es","gl","Spanish"),
("129","es","bn","Spanish"),
("130","es","az","Spanish"),
("131","de","en","German"),
("132","de","es","Alemán"),
("133","de","de","Deutsch"),
("134","de","fr","Allemand"),
("135","de","ar","الألمانية"),
("136","de","bs","German"),
("137","de","bg","Немски"),
("138","de","ca","German"),
("139","de","cs","Němec"),
("140","de","sk","Nemčina"),
("141","de","cy","German"),
("142","de","da","German"),
("143","de","el","Γερμανικά"),
("144","de","eo","German"),
("145","de","et","German"),
("146","de","eu","German"),
("147","de","fa","German"),
("148","de","fi","Saksa"),
("149","de","ga","German"),
("150","de","he","גרמנית"),
("151","de","hi","German"),
("152","de","hr","Njemački"),
("153","de","hu","Német"),
("154","de","hy","German"),
("155","de","id","German"),
("156","de","is","German"),
("157","de","it","Tedesco"),
("158","de","ja","ドイツ語"),
("159","de","ko","독어"),
("160","de","ku","German"),
("161","de","lv","German"),
("162","de","lt","German"),
("163","de","mk","German"),
("164","de","mt","German"),
("165","de","mn","German"),
("166","de","ne","German"),
("167","de","nl","Duits"),
("168","de","no","Tysk"),
("169","de","pa","German"),
("170","de","pl","Niemiecki"),
("171","de","pt-pt","Alemão"),
("172","de","pt-br","Alemão"),
("173","de","qu","German"),
("174","de","ro","Germană"),
("175","de","ru","Немецкий"),
("176","de","sl","Nemščina"),
("177","de","so","German"),
("178","de","sq","German"),
("179","de","sr","немачки"),
("180","de","sv","Tyska"),
("181","de","ta","German"),
("182","de","th","เยอรมัน"),
("183","de","tr","Almanca"),
("184","de","uk","German"),
("185","de","ur","German"),
("186","de","uz","German"),
("187","de","vi","German"),
("188","de","yi","German"),
("189","de","zh-hans","德语"),
("190","de","zu","German"),
("191","de","zh-hant","德語"),
("192","de","ms","German"),
("193","de","gl","German"),
("194","de","bn","German"),
("195","de","az","German"),
("196","fr","en","French"),
("197","fr","es","Francés"),
("198","fr","de","Französisch"),
("199","fr","fr","Français"),
("200","fr","ar","الفرنسية"),
("201","fr","bs","French"),
("202","fr","bg","Френски"),
("203","fr","ca","French"),
("204","fr","cs","Francouzština"),
("205","fr","sk","Francúzština"),
("206","fr","cy","French"),
("207","fr","da","French"),
("208","fr","el","Γαλλικά"),
("209","fr","eo","French"),
("210","fr","et","French"),
("211","fr","eu","French"),
("212","fr","fa","French"),
("213","fr","fi","Ranska"),
("214","fr","ga","French"),
("215","fr","he","צרפתית"),
("216","fr","hi","French"),
("217","fr","hr","Francuski"),
("218","fr","hu","Francia"),
("219","fr","hy","French"),
("220","fr","id","French"),
("221","fr","is","French"),
("222","fr","it","Francese"),
("223","fr","ja","フランス語"),
("224","fr","ko","불어"),
("225","fr","ku","French"),
("226","fr","lv","French"),
("227","fr","lt","French"),
("228","fr","mk","French"),
("229","fr","mt","French"),
("230","fr","mn","French"),
("231","fr","ne","French"),
("232","fr","nl","Frans"),
("233","fr","no","Fransk"),
("234","fr","pa","French"),
("235","fr","pl","Francuski"),
("236","fr","pt-pt","Francês"),
("237","fr","pt-br","Francês"),
("238","fr","qu","French"),
("239","fr","ro","Franceză"),
("240","fr","ru","Французский"),
("241","fr","sl","Francoščina"),
("242","fr","so","French"),
("243","fr","sq","French"),
("244","fr","sr","француски"),
("245","fr","sv","Franska"),
("246","fr","ta","French"),
("247","fr","th","ฝรั่งเศส"),
("248","fr","tr","Fransızca"),
("249","fr","uk","French"),
("250","fr","ur","French"),
("251","fr","uz","French"),
("252","fr","vi","French"),
("253","fr","yi","French"),
("254","fr","zh-hans","法语"),
("255","fr","zu","French"),
("256","fr","zh-hant","法語"),
("257","fr","ms","French"),
("258","fr","gl","French"),
("259","fr","bn","French"),
("260","fr","az","French"),
("261","ar","en","Arabic"),
("262","ar","es","Árabe"),
("263","ar","de","Arabisch"),
("264","ar","fr","Arabe"),
("265","ar","ar","العربية"),
("266","ar","bs","Arabic"),
("267","ar","bg","Арабски"),
("268","ar","ca","Arabic"),
("269","ar","cs","Arabština"),
("270","ar","sk","Arabčina"),
("271","ar","cy","Arabic"),
("272","ar","da","Arabic"),
("273","ar","el","Αραβικά"),
("274","ar","eo","Arabic"),
("275","ar","et","Arabic"),
("276","ar","eu","Arabic"),
("277","ar","fa","Arabic"),
("278","ar","fi","Arabia"),
("279","ar","ga","Arabic"),
("280","ar","he","ערבית"),
("281","ar","hi","Arabic"),
("282","ar","hr","Arapski"),
("283","ar","hu","Arab"),
("284","ar","hy","Arabic"),
("285","ar","id","Arabic"),
("286","ar","is","Arabic"),
("287","ar","it","Arabo"),
("288","ar","ja","アラビア語"),
("289","ar","ko","아랍어"),
("290","ar","ku","Arabic"),
("291","ar","lv","Arabic"),
("292","ar","lt","Arabic"),
("293","ar","mk","Arabic"),
("294","ar","mt","Arabic"),
("295","ar","mn","Arabic"),
("296","ar","ne","Arabic"),
("297","ar","nl","Arabisch"),
("298","ar","no","Arabisk"),
("299","ar","pa","Arabic"),
("300","ar","pl","Arabski"),
("301","ar","pt-pt","Árabe"),
("302","ar","pt-br","Árabe"),
("303","ar","qu","Arabic"),
("304","ar","ro","Arabică"),
("305","ar","ru","Арабский"),
("306","ar","sl","Arabščina"),
("307","ar","so","Arabic"),
("308","ar","sq","Arabic"),
("309","ar","sr","арапски"),
("310","ar","sv","Arabiska"),
("311","ar","ta","Arabic"),
("312","ar","th","อารบิก"),
("313","ar","tr","Arapça"),
("314","ar","uk","Arabic"),
("315","ar","ur","Arabic"),
("316","ar","uz","Arabic"),
("317","ar","vi","Arabic"),
("318","ar","yi","Arabic"),
("319","ar","zh-hans","阿拉伯语"),
("320","ar","zu","Arabic"),
("321","ar","zh-hant","阿拉伯語"),
("322","ar","ms","Arabic"),
("323","ar","gl","Arabic"),
("324","ar","bn","Arabic"),
("325","ar","az","Arabic"),
("326","bs","en","Bosnian"),
("327","bs","es","Bosnio"),
("328","bs","de","Bosnisch"),
("329","bs","fr","Bosnien"),
("330","bs","ar","البوسنية"),
("331","bs","bs","Bosnian"),
("332","bs","bg","Босненски"),
("333","bs","ca","Bosnian"),
("334","bs","cs","Bosenština"),
("335","bs","sk","Bosniačtina"),
("336","bs","cy","Bosnian"),
("337","bs","da","Bosnian"),
("338","bs","el","Βοσνιακά"),
("339","bs","eo","Bosnian"),
("340","bs","et","Bosnian"),
("341","bs","eu","Bosnian"),
("342","bs","fa","Bosnian"),
("343","bs","fi","Bosnia"),
("344","bs","ga","Bosnian"),
("345","bs","he","בוסנית"),
("346","bs","hi","Bosnian"),
("347","bs","hr","Bosanski"),
("348","bs","hu","Bosnyák"),
("349","bs","hy","Bosnian"),
("350","bs","id","Bosnian"),
("351","bs","is","Bosnian"),
("352","bs","it","Bosniaco"),
("353","bs","ja","ボスニア語"),
("354","bs","ko","보즈니아어"),
("355","bs","ku","Bosnian"),
("356","bs","lv","Bosnian"),
("357","bs","lt","Bosnian"),
("358","bs","mk","Bosnian"),
("359","bs","mt","Bosnian"),
("360","bs","mn","Bosnian"),
("361","bs","ne","Bosnian"),
("362","bs","nl","Bosnisch"),
("363","bs","no","Bosnisk"),
("364","bs","pa","Bosnian"),
("365","bs","pl","Bośniacki"),
("366","bs","pt-pt","Bósnio"),
("367","bs","pt-br","Bósnio"),
("368","bs","qu","Bosnian"),
("369","bs","ro","Bosniacă"),
("370","bs","ru","Боснийский"),
("371","bs","sl","Bosanski"),
("372","bs","so","Bosnian"),
("373","bs","sq","Bosnian"),
("374","bs","sr","босански"),
("375","bs","sv","Bosniska"),
("376","bs","ta","Bosnian"),
("377","bs","th","บอสเนียน"),
("378","bs","tr","Boşnakça"),
("379","bs","uk","Bosnian"),
("380","bs","ur","Bosnian"),
("381","bs","uz","Bosnian"),
("382","bs","vi","Bosnian"),
("383","bs","yi","Bosnian"),
("384","bs","zh-hans","波斯尼亚语"),
("385","bs","zu","Bosnian"),
("386","bs","zh-hant","波士尼亞語"),
("387","bs","ms","Bosnian"),
("388","bs","gl","Bosnian"),
("389","bs","bn","Bosnian"),
("390","bs","az","Bosnian"),
("391","bg","en","Bulgarian"),
("392","bg","es","Búlgaro"),
("393","bg","de","Bulgarisch"),
("394","bg","fr","Bulgare"),
("395","bg","ar","البلغارية"),
("396","bg","bs","Bulgarian"),
("397","bg","bg","Български"),
("398","bg","ca","Bulgarian"),
("399","bg","cs","Bulharština"),
("400","bg","sk","Bulharčina"),
("401","bg","cy","Bulgarian"),
("402","bg","da","Bulgarian"),
("403","bg","el","Βουλγαρικά"),
("404","bg","eo","Bulgarian"),
("405","bg","et","Bulgarian"),
("406","bg","eu","Bulgarian"),
("407","bg","fa","Bulgarian"),
("408","bg","fi","Bulgaria"),
("409","bg","ga","Bulgarian"),
("410","bg","he","בולגרית"),
("411","bg","hi","Bulgarian"),
("412","bg","hr","Bugarski"),
("413","bg","hu","Bolgár"),
("414","bg","hy","Bulgarian"),
("415","bg","id","Bulgarian"),
("416","bg","is","Bulgarian"),
("417","bg","it","Bulgaro"),
("418","bg","ja","ブルガリア語"),
("419","bg","ko","불가리아어"),
("420","bg","ku","Bulgarian"),
("421","bg","lv","Bulgarian"),
("422","bg","lt","Bulgarian"),
("423","bg","mk","Bulgarian"),
("424","bg","mt","Bulgarian"),
("425","bg","mn","Bulgarian"),
("426","bg","ne","Bulgarian"),
("427","bg","nl","Bulgaars"),
("428","bg","no","Bulgarian"),
("429","bg","pa","Bulgarian"),
("430","bg","pl","Bułgarski"),
("431","bg","pt-pt","Búlgaro"),
("432","bg","pt-br","Búlgaro"),
("433","bg","qu","Bulgarian"),
("434","bg","ro","Bulgară"),
("435","bg","ru","Болгарский"),
("436","bg","sl","Bolgarščina"),
("437","bg","so","Bulgarian"),
("438","bg","sq","Bulgarian"),
("439","bg","sr","бугарски"),
("440","bg","sv","Bulgariska"),
("441","bg","ta","Bulgarian"),
("442","bg","th","บัลแกเรียน"),
("443","bg","tr","Bulgarca"),
("444","bg","uk","Bulgarian"),
("445","bg","ur","Bulgarian"),
("446","bg","uz","Bulgarian"),
("447","bg","vi","Bulgarian"),
("448","bg","yi","Bulgarian"),
("449","bg","zh-hans","保加利亚语"),
("450","bg","zu","Bulgarian"),
("451","bg","zh-hant","保加利亞語"),
("452","bg","ms","Bulgarian"),
("453","bg","gl","Bulgarian"),
("454","bg","bn","Bulgarian"),
("455","bg","az","Bulgarian"),
("456","ca","en","Catalan"),
("457","ca","es","Catalán"),
("458","ca","de","Katalanisch"),
("459","ca","fr","Catalan"),
("460","ca","ar","الكاتالوينية"),
("461","ca","bs","Catalan"),
("462","ca","bg","Каталонски"),
("463","ca","ca","Català"),
("464","ca","cs","Katalánština"),
("465","ca","sk","Katalánčina"),
("466","ca","cy","Catalan"),
("467","ca","da","Catalan"),
("468","ca","el","Καταλανικά"),
("469","ca","eo","Catalan"),
("470","ca","et","Catalan"),
("471","ca","eu","Catalan"),
("472","ca","fa","Catalan"),
("473","ca","fi","Katalaani"),
("474","ca","ga","Catalan"),
("475","ca","he","קטלאנית"),
("476","ca","hi","Catalan"),
("477","ca","hr","Katalonski"),
("478","ca","hu","Katalán"),
("479","ca","hy","Catalan"),
("480","ca","id","Catalan"),
("481","ca","is","Catalan"),
("482","ca","it","Catalano"),
("483","ca","ja","カタルーニャ語"),
("484","ca","ko","카탈로니아어"),
("485","ca","ku","Catalan"),
("486","ca","lv","Catalan"),
("487","ca","lt","Catalan"),
("488","ca","mk","Catalan"),
("489","ca","mt","Catalan"),
("490","ca","mn","Catalan"),
("491","ca","ne","Catalan"),
("492","ca","nl","Catalaans"),
("493","ca","no","catalan"),
("494","ca","pa","Catalan"),
("495","ca","pl","Kataloński"),
("496","ca","pt-pt","Catalão"),
("497","ca","pt-br","Catalão"),
("498","ca","qu","Catalan"),
("499","ca","ro","Catalană"),
("500","ca","ru","Каталанский"),
("501","ca","sl","Katalonščina"),
("502","ca","so","Catalan"),
("503","ca","sq","Catalan"),
("504","ca","sr","каталонски"),
("505","ca","sv","Katalanska"),
("506","ca","ta","Catalan"),
("507","ca","th","คะตะลาน"),
("508","ca","tr","Katalan dili"),
("509","ca","uk","Catalan"),
("510","ca","ur","Catalan"),
("511","ca","uz","Catalan"),
("512","ca","vi","Catalan"),
("513","ca","yi","Catalan"),
("514","ca","zh-hans","加泰罗尼亚语"),
("515","ca","zu","Catalan"),
("516","ca","zh-hant","加泰羅尼亞語"),
("517","ca","ms","Catalan"),
("518","ca","gl","Catalan"),
("519","ca","bn","Catalan"),
("520","ca","az","Catalan"),
("521","cs","en","Czech"),
("522","cs","es","Checo"),
("523","cs","de","Tschechisch"),
("524","cs","fr","Tchèque"),
("525","cs","ar","التشيكية"),
("526","cs","bs","Czech"),
("527","cs","bg","Чешки"),
("528","cs","ca","Czech"),
("529","cs","cs","Čeština"),
("530","cs","sk","Čeština"),
("531","cs","cy","Czech"),
("532","cs","da","Czech"),
("533","cs","el","Τσεχικά"),
("534","cs","eo","Czech"),
("535","cs","et","Czech"),
("536","cs","eu","Czech"),
("537","cs","fa","Czech"),
("538","cs","fi","Tsekki"),
("539","cs","ga","Czech"),
("540","cs","he","צ\'כית"),
("541","cs","hi","Czech"),
("542","cs","hr","češki"),
("543","cs","hu","Cseh"),
("544","cs","hy","Czech"),
("545","cs","id","Czech"),
("546","cs","is","Czech"),
("547","cs","it","Ceco"),
("548","cs","ja","チェコ語"),
("549","cs","ko","체코슬로바키아어"),
("550","cs","ku","Czech"),
("551","cs","lv","Czech"),
("552","cs","lt","Czech"),
("553","cs","mk","Czech"),
("554","cs","mt","Czech"),
("555","cs","mn","Czech"),
("556","cs","ne","Czech"),
("557","cs","nl","Tsjechisch"),
("558","cs","no","Czech"),
("559","cs","pa","Czech"),
("560","cs","pl","Czeski"),
("561","cs","pt-pt","Tcheco"),
("562","cs","pt-br","Tcheco"),
("563","cs","qu","Czech"),
("564","cs","ro","Cehă"),
("565","cs","ru","Чешский"),
("566","cs","sl","Češčina"),
("567","cs","so","Czech"),
("568","cs","sq","Czech"),
("569","cs","sr","чешки"),
("570","cs","sv","Tjeckiska"),
("571","cs","ta","Czech"),
("572","cs","th","เช็ก"),
("573","cs","tr","Çekçe"),
("574","cs","uk","Czech"),
("575","cs","ur","Czech"),
("576","cs","uz","Czech"),
("577","cs","vi","Czech"),
("578","cs","yi","Czech"),
("579","cs","zh-hans","捷克语"),
("580","cs","zu","Czech"),
("581","cs","zh-hant","捷克語"),
("582","cs","ms","Czech"),
("583","cs","gl","Czech"),
("584","cs","bn","Czech"),
("585","cs","az","Czech"),
("586","sk","en","Slovak"),
("587","sk","es","Eslavo"),
("588","sk","de","Slowakisch"),
("589","sk","fr","Slave"),
("590","sk","ar","السلافية"),
("591","sk","bs","Slovak"),
("592","sk","bg","Словашки"),
("593","sk","ca","Slovak"),
("594","sk","cs","Slovenština"),
("595","sk","sk","Slovenčina"),
("596","sk","cy","Slovak"),
("597","sk","da","Slovak"),
("598","sk","el","Σλαβική"),
("599","sk","eo","Slovak"),
("600","sk","et","Slovak"),
("601","sk","eu","Slovak"),
("602","sk","fa","Slovak"),
("603","sk","fi","Slaavi"),
("604","sk","ga","Slovak"),
("605","sk","he","סלאבית"),
("606","sk","hi","Slovak"),
("607","sk","hr","Slovački"),
("608","sk","hu","Szlovák"),
("609","sk","hy","Slovak"),
("610","sk","id","Slovak"),
("611","sk","is","Slovak"),
("612","sk","it","Slavo"),
("613","sk","ja","スラヴ語派"),
("614","sk","ko","슬라브어"),
("615","sk","ku","Slovak"),
("616","sk","lv","Slovak"),
("617","sk","lt","Slovak"),
("618","sk","mk","Slovak"),
("619","sk","mt","Slovak"),
("620","sk","mn","Slovak"),
("621","sk","ne","Slovak"),
("622","sk","nl","Slavisch"),
("623","sk","no","Slovak"),
("624","sk","pa","Slovak"),
("625","sk","pl","Słowacki"),
("626","sk","pt-pt","Eslavo"),
("627","sk","pt-br","Eslavo"),
("628","sk","qu","Slovak"),
("629","sk","ro","Slavă"),
("630","sk","ru","Славянский"),
("631","sk","sl","Slovaščina"),
("632","sk","so","Slovak"),
("633","sk","sq","Slovak"),
("634","sk","sr","словачки"),
("635","sk","sv","Slavisk"),
("636","sk","ta","Slovak"),
("637","sk","th","สลาวิก"),
("638","sk","tr","Slav dili"),
("639","sk","uk","Slovak"),
("640","sk","ur","Slovak"),
("641","sk","uz","Slovak"),
("642","sk","vi","Slovak"),
("643","sk","yi","Slovak"),
("644","sk","zh-hans","斯拉夫语"),
("645","sk","zu","Slovak"),
("646","sk","zh-hant","斯拉夫語"),
("647","sk","ms","Slovak"),
("648","sk","gl","Slovak"),
("649","sk","bn","Slovak"),
("650","sk","az","Slovak"),
("651","cy","en","Welsh"),
("652","cy","es","Galés"),
("653","cy","de","Walisisch"),
("654","cy","fr","Gallois"),
("655","cy","ar","الولزية"),
("656","cy","bs","Welsh"),
("657","cy","bg","Уелски"),
("658","cy","ca","Welsh"),
("659","cy","cs","Velšský"),
("660","cy","sk","Welština"),
("661","cy","cy","Cymraeg"),
("662","cy","da","Welsh"),
("663","cy","el","Oυαλικά"),
("664","cy","eo","Welsh"),
("665","cy","et","Welsh"),
("666","cy","eu","Welsh"),
("667","cy","fa","Welsh"),
("668","cy","fi","Kymri"),
("669","cy","ga","Welsh"),
("670","cy","he","וולשית"),
("671","cy","hi","Welsh"),
("672","cy","hr","Velški"),
("673","cy","hu","Vels"),
("674","cy","hy","Welsh"),
("675","cy","id","Welsh"),
("676","cy","is","Welsh"),
("677","cy","it","Gallese"),
("678","cy","ja","ウェールズ語"),
("679","cy","ko","웨일즈어"),
("680","cy","ku","Welsh"),
("681","cy","lv","Welsh"),
("682","cy","lt","Welsh"),
("683","cy","mk","Welsh"),
("684","cy","mt","Welsh"),
("685","cy","mn","Welsh"),
("686","cy","ne","Welsh"),
("687","cy","nl","Welsh"),
("688","cy","no","Welsh"),
("689","cy","pa","Welsh"),
("690","cy","pl","Walijski"),
("691","cy","pt-pt","Galês"),
("692","cy","pt-br","Galês"),
("693","cy","qu","Welsh"),
("694","cy","ro","Galeză"),
("695","cy","ru","Валлийский"),
("696","cy","sl","Welsh"),
("697","cy","so","Welsh"),
("698","cy","sq","Welsh"),
("699","cy","sr","велшки"),
("700","cy","sv","Walesiska"),
("701","cy","ta","Welsh"),
("702","cy","th","เวลช์"),
("703","cy","tr","Galce"),
("704","cy","uk","Welsh"),
("705","cy","ur","Welsh"),
("706","cy","uz","Welsh"),
("707","cy","vi","Welsh"),
("708","cy","yi","Welsh"),
("709","cy","zh-hans","威尔士语"),
("710","cy","zu","Welsh"),
("711","cy","zh-hant","威爾士語"),
("712","cy","ms","Welsh"),
("713","cy","gl","Welsh"),
("714","cy","bn","Welsh"),
("715","cy","az","Welsh"),
("716","da","en","Danish"),
("717","da","es","Danés"),
("718","da","de","Dänisch"),
("719","da","fr","Danois"),
("720","da","ar","الدانماركية"),
("721","da","bs","Danish"),
("722","da","bg","Датски"),
("723","da","ca","Danish"),
("724","da","cs","Dánský"),
("725","da","sk","Dánčina"),
("726","da","cy","Danish"),
("727","da","da","Dansk"),
("728","da","el","Δανέζικα"),
("729","da","eo","Danish"),
("730","da","et","Danish"),
("731","da","eu","Danish"),
("732","da","fa","Danish"),
("733","da","fi","Tanska"),
("734","da","ga","Danish"),
("735","da","he","דנית"),
("736","da","hi","Danish"),
("737","da","hr","Danski"),
("738","da","hu","Dán"),
("739","da","hy","Danish"),
("740","da","id","Danish"),
("741","da","is","Danish"),
("742","da","it","Danese"),
("743","da","ja","デンマーク語"),
("744","da","ko","덴마크어"),
("745","da","ku","Danish"),
("746","da","lv","Danish"),
("747","da","lt","Danish"),
("748","da","mk","Danish"),
("749","da","mt","Danish"),
("750","da","mn","Danish"),
("751","da","ne","Danish"),
("752","da","nl","Deens"),
("753","da","no","Danish"),
("754","da","pa","Danish"),
("755","da","pl","Duński"),
("756","da","pt-pt","Dinamarquês"),
("757","da","pt-br","Dinamarquês"),
("758","da","qu","Danish"),
("759","da","ro","Daneză"),
("760","da","ru","Датский"),
("761","da","sl","Danščina"),
("762","da","so","Danish"),
("763","da","sq","Danish"),
("764","da","sr","дански"),
("765","da","sv","Danska"),
("766","da","ta","Danish"),
("767","da","th","เดนมาร์ก"),
("768","da","tr","Danca"),
("769","da","uk","Danish"),
("770","da","ur","Danish"),
("771","da","uz","Danish"),
("772","da","vi","Danish"),
("773","da","yi","Danish"),
("774","da","zh-hans","丹麦语"),
("775","da","zu","Danish"),
("776","da","zh-hant","丹麥語"),
("777","da","ms","Danish"),
("778","da","gl","Danish"),
("779","da","bn","Danish"),
("780","da","az","Danish"),
("781","el","en","Greek"),
("782","el","es","Griego"),
("783","el","de","Griechisch"),
("784","el","fr","Grec moderne"),
("785","el","ar","اليونانية"),
("786","el","bs","Greek"),
("787","el","bg","Гръцки"),
("788","el","ca","Greek"),
("789","el","cs","Řečtina"),
("790","el","sk","Gréčtina"),
("791","el","cy","Greek"),
("792","el","da","Greek"),
("793","el","el","Ελληνικά"),
("794","el","eo","Greek"),
("795","el","et","Greek"),
("796","el","eu","Greek"),
("797","el","fa","Greek"),
("798","el","fi","Kreikka"),
("799","el","ga","Greek"),
("800","el","he","יוונית"),
("801","el","hi","Greek"),
("802","el","hr","Grčki"),
("803","el","hu","Görög"),
("804","el","hy","Greek"),
("805","el","id","Greek"),
("806","el","is","Greek"),
("807","el","it","Greco"),
("808","el","ja","ギリシア語"),
("809","el","ko","그리스어"),
("810","el","ku","Greek"),
("811","el","lv","Greek"),
("812","el","lt","Greek"),
("813","el","mk","Greek"),
("814","el","mt","Greek"),
("815","el","mn","Greek"),
("816","el","ne","Greek"),
("817","el","nl","Grieks"),
("818","el","no","Gresk"),
("819","el","pa","Greek"),
("820","el","pl","Grecki"),
("821","el","pt-pt","Grego"),
("822","el","pt-br","Grego"),
("823","el","qu","Greek"),
("824","el","ro","Greacă"),
("825","el","ru","Греческий"),
("826","el","sl","Greek"),
("827","el","so","Greek"),
("828","el","sq","Greek"),
("829","el","sr","грчки"),
("830","el","sv","Grekiska"),
("831","el","ta","Greek"),
("832","el","th","กรีก"),
("833","el","tr","Yunanca"),
("834","el","uk","Greek"),
("835","el","ur","Greek"),
("836","el","uz","Greek"),
("837","el","vi","Greek"),
("838","el","yi","Greek"),
("839","el","zh-hans","希腊语"),
("840","el","zu","Greek"),
("841","el","zh-hant","希臘語"),
("842","el","ms","Greek"),
("843","el","gl","Greek"),
("844","el","bn","Greek"),
("845","el","az","Greek"),
("846","eo","en","Esperanto"),
("847","eo","es","Esperanto"),
("848","eo","de","Esperanto"),
("849","eo","fr","Espéranto"),
("850","eo","ar","الاسبرانتو"),
("851","eo","bs","Esperanto"),
("852","eo","bg","Есперанто"),
("853","eo","ca","Esperanto"),
("854","eo","cs","Esperanto"),
("855","eo","sk","Esperanto"),
("856","eo","cy","Esperanto"),
("857","eo","da","Esperanto"),
("858","eo","el","Εσπεράντο"),
("859","eo","eo","Esperanta"),
("860","eo","et","Esperanto"),
("861","eo","eu","Esperanto"),
("862","eo","fa","Esperanto"),
("863","eo","fi","Esperanto"),
("864","eo","ga","Esperanto"),
("865","eo","he","אספרנטו"),
("866","eo","hi","Esperanto"),
("867","eo","hr","Esperanto"),
("868","eo","hu","Eszperantó"),
("869","eo","hy","Esperanto"),
("870","eo","id","Esperanto"),
("871","eo","is","Esperanto"),
("872","eo","it","Esperanto"),
("873","eo","ja","エスペラント語"),
("874","eo","ko","에스페란토어"),
("875","eo","ku","Esperanto"),
("876","eo","lv","Esperanto"),
("877","eo","lt","Esperanto"),
("878","eo","mk","Esperanto"),
("879","eo","mt","Esperanto"),
("880","eo","mn","Esperanto"),
("881","eo","ne","Esperanto"),
("882","eo","nl","Esperanto"),
("883","eo","no","Esperanto"),
("884","eo","pa","Esperanto"),
("885","eo","pl","Esperanto"),
("886","eo","pt-pt","Esperanto"),
("887","eo","pt-br","Esperanto"),
("888","eo","qu","Esperanto"),
("889","eo","ro","Esperanto"),
("890","eo","ru","Эсперанто"),
("891","eo","sl","Esperanto"),
("892","eo","so","Esperanto"),
("893","eo","sq","Esperanto"),
("894","eo","sr","есперанто"),
("895","eo","sv","Esperanto"),
("896","eo","ta","Esperanto"),
("897","eo","th","เอสเปอรันโต"),
("898","eo","tr","Esperanto"),
("899","eo","uk","Esperanto"),
("900","eo","ur","Esperanto"),
("901","eo","uz","Esperanto"),
("902","eo","vi","Esperanto"),
("903","eo","yi","Esperanto"),
("904","eo","zh-hans","世界语"),
("905","eo","zu","Esperanto"),
("906","eo","zh-hant","世界語"),
("907","eo","ms","Esperanto"),
("908","eo","gl","Esperanto"),
("909","eo","bn","Esperanto"),
("910","eo","az","Esperanto"),
("911","et","en","Estonian"),
("912","et","es","Estonio"),
("913","et","de","Estnisch"),
("914","et","fr","Estonien"),
("915","et","ar","الأستونية"),
("916","et","bs","Estonian"),
("917","et","bg","Естонски"),
("918","et","ca","Estonian"),
("919","et","cs","Estonština"),
("920","et","sk","Estónčina"),
("921","et","cy","Estonian"),
("922","et","da","Estonian"),
("923","et","el","Εσθονικά"),
("924","et","eo","Estonian"),
("925","et","et","Eesti"),
("926","et","eu","Estonian"),
("927","et","fa","Estonian"),
("928","et","fi","Eesti"),
("929","et","ga","Estonian"),
("930","et","he","אסטונית"),
("931","et","hi","Estonian"),
("932","et","hr","Estonski"),
("933","et","hu","észt"),
("934","et","hy","Estonian"),
("935","et","id","Estonian"),
("936","et","is","Estonian"),
("937","et","it","Estone"),
("938","et","ja","エストニア語"),
("939","et","ko","에스토니아어"),
("940","et","ku","Estonian"),
("941","et","lv","Estonian"),
("942","et","lt","Estonian"),
("943","et","mk","Estonian"),
("944","et","mt","Estonian"),
("945","et","mn","Estonian"),
("946","et","ne","Estonian"),
("947","et","nl","Ests"),
("948","et","no","Estonian"),
("949","et","pa","Estonian"),
("950","et","pl","Estoński"),
("951","et","pt-pt","Estoniano"),
("952","et","pt-br","Estoniano"),
("953","et","qu","Estonian"),
("954","et","ro","Estoniană"),
("955","et","ru","Эстонский"),
("956","et","sl","Estonščina"),
("957","et","so","Estonian"),
("958","et","sq","Estonian"),
("959","et","sr","естонски"),
("960","et","sv","Estniska"),
("961","et","ta","Estonian"),
("962","et","th","เอสโตเนียน"),
("963","et","tr","Estonya dili"),
("964","et","uk","Estonian"),
("965","et","ur","Estonian"),
("966","et","uz","Estonian"),
("967","et","vi","Estonian"),
("968","et","yi","Estonian"),
("969","et","zh-hans","爱沙尼亚语"),
("970","et","zu","Estonian"),
("971","et","zh-hant","愛沙尼亞語"),
("972","et","ms","Estonian"),
("973","et","gl","Estonian"),
("974","et","bn","Estonian"),
("975","et","az","Estonian"),
("976","eu","en","Basque"),
("977","eu","es","Euskera"),
("978","eu","de","Baskisch"),
("979","eu","fr","Basque"),
("980","eu","ar","لغة الباسك"),
("981","eu","bs","Basque"),
("982","eu","bg","Баски"),
("983","eu","ca","Basque"),
("984","eu","cs","Basque"),
("985","eu","sk","Baskičtina"),
("986","eu","cy","Basque"),
("987","eu","da","Basque"),
("988","eu","el","Βασκικά"),
("989","eu","eo","Basque"),
("990","eu","et","Basque"),
("991","eu","eu","Euskara"),
("992","eu","fa","Basque"),
("993","eu","fi","Baski"),
("994","eu","ga","Basque"),
("995","eu","he","בסקית"),
("996","eu","hi","Basque"),
("997","eu","hr","Baskijski"),
("998","eu","hu","Baszk"),
("999","eu","hy","Basque"),
("1000","eu","id","Basque"),
("1001","eu","is","Basque"),
("1002","eu","it","Basco"),
("1003","eu","ja","バスク語"),
("1004","eu","ko","바스크어"),
("1005","eu","ku","Basque"),
("1006","eu","lv","Basque"),
("1007","eu","lt","Basque"),
("1008","eu","mk","Basque"),
("1009","eu","mt","Basque"),
("1010","eu","mn","Basque"),
("1011","eu","ne","Basque"),
("1012","eu","nl","Baskisch"),
("1013","eu","no","Basque"),
("1014","eu","pa","Basque"),
("1015","eu","pl","Baskijski"),
("1016","eu","pt-pt","Basco"),
("1017","eu","pt-br","Basco"),
("1018","eu","qu","Basque"),
("1019","eu","ro","Bască"),
("1020","eu","ru","Баскский"),
("1021","eu","sl","Baskovščina"),
("1022","eu","so","Basque"),
("1023","eu","sq","Basque"),
("1024","eu","sr","баскијски"),
("1025","eu","sv","Baskiska"),
("1026","eu","ta","Basque"),
("1027","eu","th","บาสค์"),
("1028","eu","tr","Bask dili"),
("1029","eu","uk","Basque"),
("1030","eu","ur","Basque"),
("1031","eu","uz","Basque"),
("1032","eu","vi","Basque"),
("1033","eu","yi","Basque"),
("1034","eu","zh-hans","巴斯克语"),
("1035","eu","zu","Basque"),
("1036","eu","zh-hant","巴斯克語"),
("1037","eu","ms","Basque"),
("1038","eu","gl","Basque"),
("1039","eu","bn","Basque"),
("1040","eu","az","Basque"),
("1041","fa","en","Persian"),
("1042","fa","es","Persa"),
("1043","fa","de","Persisch"),
("1044","fa","fr","Perse"),
("1045","fa","ar","الفارسية"),
("1046","fa","bs","Persian"),
("1047","fa","bg","Персийски"),
("1048","fa","ca","Persian"),
("1049","fa","cs","Perský"),
("1050","fa","sk","Perzština"),
("1051","fa","cy","Persian"),
("1052","fa","da","Persian"),
("1053","fa","el","Περσικά"),
("1054","fa","eo","Persian"),
("1055","fa","et","Persian"),
("1056","fa","eu","Persian"),
("1057","fa","fa","فارسی"),
("1058","fa","fi","Persia"),
("1059","fa","ga","Persian"),
("1060","fa","he","פרסית"),
("1061","fa","hi","Persian"),
("1062","fa","hr","Perzijski"),
("1063","fa","hu","Perzsa"),
("1064","fa","hy","Persian"),
("1065","fa","id","Persian"),
("1066","fa","is","Persian"),
("1067","fa","it","Persiano"),
("1068","fa","ja","ペルシア語"),
("1069","fa","ko","페르시아어"),
("1070","fa","ku","Persian"),
("1071","fa","lv","Persian"),
("1072","fa","lt","Persian"),
("1073","fa","mk","Persian"),
("1074","fa","mt","Persian"),
("1075","fa","mn","Persian"),
("1076","fa","ne","Persian"),
("1077","fa","nl","Perzisch"),
("1078","fa","no","Persisk"),
("1079","fa","pa","Persian"),
("1080","fa","pl","Perski"),
("1081","fa","pt-pt","Persa"),
("1082","fa","pt-br","Persa"),
("1083","fa","qu","Persian"),
("1084","fa","ro","Persană"),
("1085","fa","ru","Персидский"),
("1086","fa","sl","Perzijski"),
("1087","fa","so","Persian"),
("1088","fa","sq","Persian"),
("1089","fa","sr","персијски"),
("1090","fa","sv","Persiska"),
("1091","fa","ta","Persian"),
("1092","fa","th","เปอร์เซียน"),
("1093","fa","tr","Farsça"),
("1094","fa","uk","Persian"),
("1095","fa","ur","Persian"),
("1096","fa","uz","Persian"),
("1097","fa","vi","Persian"),
("1098","fa","yi","Persian"),
("1099","fa","zh-hans","波斯语"),
("1100","fa","zu","Persian"),
("1101","fa","zh-hant","波斯語"),
("1102","fa","ms","Persian"),
("1103","fa","gl","Persian"),
("1104","fa","bn","Persian"),
("1105","fa","az","Persian"),
("1106","fi","en","Finnish"),
("1107","fi","es","Finlandés"),
("1108","fi","de","Finnisch"),
("1109","fi","fr","Finnois"),
("1110","fi","ar","الفنلندية"),
("1111","fi","bs","Finnish"),
("1112","fi","bg","Фински"),
("1113","fi","ca","Finnish"),
("1114","fi","cs","Finský"),
("1115","fi","sk","Fínština"),
("1116","fi","cy","Finnish"),
("1117","fi","da","Finnish"),
("1118","fi","el","Φινλανδικά"),
("1119","fi","eo","Finnish"),
("1120","fi","et","Finnish"),
("1121","fi","eu","Finnish"),
("1122","fi","fa","Finnish"),
("1123","fi","fi","Suomi"),
("1124","fi","ga","Finnish"),
("1125","fi","he","פינית"),
("1126","fi","hi","Finnish"),
("1127","fi","hr","Finski"),
("1128","fi","hu","Finn"),
("1129","fi","hy","Finnish"),
("1130","fi","id","Finnish"),
("1131","fi","is","Finnish"),
("1132","fi","it","Finlandese"),
("1133","fi","ja","フィンランド語"),
("1134","fi","ko","핀란드어"),
("1135","fi","ku","Finnish"),
("1136","fi","lv","Finnish"),
("1137","fi","lt","Finnish"),
("1138","fi","mk","Finnish"),
("1139","fi","mt","Finnish"),
("1140","fi","mn","Finnish"),
("1141","fi","ne","Finnish"),
("1142","fi","nl","Fins"),
("1143","fi","no","Finsk"),
("1144","fi","pa","Finnish"),
("1145","fi","pl","Fiński"),
("1146","fi","pt-pt","Finlandês"),
("1147","fi","pt-br","Finlandês"),
("1148","fi","qu","Finnish"),
("1149","fi","ro","Finlandeză"),
("1150","fi","ru","Финский"),
("1151","fi","sl","Finski"),
("1152","fi","so","Finnish"),
("1153","fi","sq","Finnish"),
("1154","fi","sr","фински"),
("1155","fi","sv","Finska"),
("1156","fi","ta","Finnish"),
("1157","fi","th","ฟินนิช"),
("1158","fi","tr","Fince"),
("1159","fi","uk","Finnish"),
("1160","fi","ur","Finnish"),
("1161","fi","uz","Finnish"),
("1162","fi","vi","Finnish"),
("1163","fi","yi","Finnish"),
("1164","fi","zh-hans","芬兰语"),
("1165","fi","zu","Finnish"),
("1166","fi","zh-hant","芬蘭語"),
("1167","fi","ms","Finnish"),
("1168","fi","gl","Finnish"),
("1169","fi","bn","Finnish"),
("1170","fi","az","Finnish"),
("1171","ga","en","Irish"),
("1172","ga","es","Irlandés"),
("1173","ga","de","Irisch"),
("1174","ga","fr","Irlandais"),
("1175","ga","ar","الأيرلندية"),
("1176","ga","bs","Irish"),
("1177","ga","bg","Ирландски"),
("1178","ga","ca","Irish"),
("1179","ga","cs","Irský"),
("1180","ga","sk","Írština"),
("1181","ga","cy","Irish"),
("1182","ga","da","Irish"),
("1183","ga","el","Ιρλανδικά"),
("1184","ga","eo","Irish"),
("1185","ga","et","Irish"),
("1186","ga","eu","Irish"),
("1187","ga","fa","Irish"),
("1188","ga","fi","Iiri"),
("1189","ga","ga","Gaeilge"),
("1190","ga","he","אירית"),
("1191","ga","hi","Irish"),
("1192","ga","hr","Irski"),
("1193","ga","hu","ír"),
("1194","ga","hy","Irish"),
("1195","ga","id","Irish"),
("1196","ga","is","Irish"),
("1197","ga","it","Irlandese"),
("1198","ga","ja","アイルランド語"),
("1199","ga","ko","아일랜드어"),
("1200","ga","ku","Irish"),
("1201","ga","lv","Irish"),
("1202","ga","lt","Irish"),
("1203","ga","mk","Irish"),
("1204","ga","mt","Irish"),
("1205","ga","mn","Irish"),
("1206","ga","ne","Irish"),
("1207","ga","nl","Iers"),
("1208","ga","no","Irish"),
("1209","ga","pa","Irish"),
("1210","ga","pl","Irlandzki"),
("1211","ga","pt-pt","Irlandês"),
("1212","ga","pt-br","Irlandês"),
("1213","ga","qu","Irish"),
("1214","ga","ro","Irlandeză"),
("1215","ga","ru","Ирландский"),
("1216","ga","sl","Irski"),
("1217","ga","so","Irish"),
("1218","ga","sq","Irish"),
("1219","ga","sr","ирски"),
("1220","ga","sv","Irländska"),
("1221","ga","ta","Irish"),
("1222","ga","th","ไอริช"),
("1223","ga","tr","İrlanda dili"),
("1224","ga","uk","Irish"),
("1225","ga","ur","Irish"),
("1226","ga","uz","Irish"),
("1227","ga","vi","Irish"),
("1228","ga","yi","Irish"),
("1229","ga","zh-hans","爱尔兰语"),
("1230","ga","zu","Irish"),
("1231","ga","zh-hant","愛爾蘭語"),
("1232","ga","ms","Irish"),
("1233","ga","gl","Irish"),
("1234","ga","bn","Irish"),
("1235","ga","az","Irish"),
("1236","he","en","Hebrew"),
("1237","he","es","Hebreo"),
("1238","he","de","Hebräisch"),
("1239","he","fr","Hébreu"),
("1240","he","ar","العبرية"),
("1241","he","bs","Hebrew"),
("1242","he","bg","Иврит"),
("1243","he","ca","Hebrew"),
("1244","he","cs","Hebrejština"),
("1245","he","sk","Hebrejčina"),
("1246","he","cy","Hebrew"),
("1247","he","da","Hebrew"),
("1248","he","el","Εβραϊκά"),
("1249","he","eo","Hebrew"),
("1250","he","et","Hebrew"),
("1251","he","eu","Hebrew"),
("1252","he","fa","Hebrew"),
("1253","he","fi","Heprea"),
("1254","he","ga","Hebrew"),
("1255","he","he","עברית"),
("1256","he","hi","Hebrew"),
("1257","he","hr","Hebrejski"),
("1258","he","hu","Héber"),
("1259","he","hy","Hebrew"),
("1260","he","id","Hebrew"),
("1261","he","is","Hebrew"),
("1262","he","it","Ebraico"),
("1263","he","ja","ヘブライ語"),
("1264","he","ko","히브리어"),
("1265","he","ku","Hebrew"),
("1266","he","lv","Hebrew"),
("1267","he","lt","Hebrew"),
("1268","he","mk","Hebrew"),
("1269","he","mt","Hebrew"),
("1270","he","mn","Hebrew"),
("1271","he","ne","Hebrew"),
("1272","he","nl","Hebreeuws"),
("1273","he","no","Hebraisk"),
("1274","he","pa","Hebrew"),
("1275","he","pl","Hebrajski"),
("1276","he","pt-pt","Hebraico"),
("1277","he","pt-br","Hebraico"),
("1278","he","qu","Hebrew"),
("1279","he","ro","Ebraică"),
("1280","he","ru","Иврит"),
("1281","he","sl","Hebrejščina"),
("1282","he","so","Hebrew"),
("1283","he","sq","Hebrew"),
("1284","he","sr","Хебрејски"),
("1285","he","sv","Hebreiska"),
("1286","he","ta","Hebrew"),
("1287","he","th","ฮิบรู"),
("1288","he","tr","İbranice"),
("1289","he","uk","Hebrew"),
("1290","he","ur","Hebrew"),
("1291","he","uz","Hebrew"),
("1292","he","vi","Hebrew"),
("1293","he","yi","Hebrew"),
("1294","he","zh-hans","希伯来语"),
("1295","he","zu","Hebrew"),
("1296","he","zh-hant","希伯來語"),
("1297","he","ms","Hebrew"),
("1298","he","gl","Hebrew"),
("1299","he","bn","Hebrew"),
("1300","he","az","Hebrew"),
("1301","hi","en","Hindi"),
("1302","hi","es","Hindi"),
("1303","hi","de","Hindi"),
("1304","hi","fr","Hindi"),
("1305","hi","ar","الهندية"),
("1306","hi","bs","Hindi"),
("1307","hi","bg","Хинди"),
("1308","hi","ca","Hindi"),
("1309","hi","cs","Hindština"),
("1310","hi","sk","Hindčina"),
("1311","hi","cy","Hindi"),
("1312","hi","da","Hindi"),
("1313","hi","el","Ινδικά"),
("1314","hi","eo","Hindi"),
("1315","hi","et","Hindi"),
("1316","hi","eu","Hindi"),
("1317","hi","fa","Hindi"),
("1318","hi","fi","Hindi"),
("1319","hi","ga","Hindi"),
("1320","hi","he","הודית"),
("1321","hi","hi","हिन्दी"),
("1322","hi","hr","Hindski"),
("1323","hi","hu","Hindi"),
("1324","hi","hy","Hindi"),
("1325","hi","id","Hindi"),
("1326","hi","is","Hindi"),
("1327","hi","it","Hindi"),
("1328","hi","ja","ヒンディー語"),
("1329","hi","ko","힌두어"),
("1330","hi","ku","Hindi"),
("1331","hi","lv","Hindi"),
("1332","hi","lt","Hindi"),
("1333","hi","mk","Hindi"),
("1334","hi","mt","Hindi"),
("1335","hi","mn","Hindi"),
("1336","hi","ne","Hindi"),
("1337","hi","nl","Hindi"),
("1338","hi","no","Hindi"),
("1339","hi","pa","Hindi"),
("1340","hi","pl","Hindi"),
("1341","hi","pt-pt","Hindi"),
("1342","hi","pt-br","Hindi"),
("1343","hi","qu","Hindi"),
("1344","hi","ro","Hindi"),
("1345","hi","ru","Хинди"),
("1346","hi","sl","Hindi"),
("1347","hi","so","Hindi"),
("1348","hi","sq","Hindi"),
("1349","hi","sr","хинди"),
("1350","hi","sv","Hindi"),
("1351","hi","ta","Hindi"),
("1352","hi","th","ฮินดิ"),
("1353","hi","tr","Hintçe"),
("1354","hi","uk","Hindi"),
("1355","hi","ur","Hindi"),
("1356","hi","uz","Hindi"),
("1357","hi","vi","Hindi"),
("1358","hi","yi","Hindi"),
("1359","hi","zh-hans","印地语"),
("1360","hi","zu","Hindi"),
("1361","hi","zh-hant","印地語"),
("1362","hi","ms","Hindi"),
("1363","hi","gl","Hindi"),
("1364","hi","bn","Hindi"),
("1365","hi","az","Hindi"),
("1366","hr","en","Croatian"),
("1367","hr","es","Croata"),
("1368","hr","de","Kroatisch"),
("1369","hr","fr","Croate"),
("1370","hr","ar","الكرواتية"),
("1371","hr","bs","Croatian"),
("1372","hr","bg","Хърватски"),
("1373","hr","ca","Croatian"),
("1374","hr","cs","Chorvatský"),
("1375","hr","sk","Chorvátština"),
("1376","hr","cy","Croatian"),
("1377","hr","da","Croatian"),
("1378","hr","el","Κροατικά"),
("1379","hr","eo","Croatian"),
("1380","hr","et","Croatian"),
("1381","hr","eu","Croatian"),
("1382","hr","fa","Croatian"),
("1383","hr","fi","Kroatia"),
("1384","hr","ga","Croatian"),
("1385","hr","he","קרוטאית"),
("1386","hr","hi","Croatian"),
("1387","hr","hr","Hrvatski"),
("1388","hr","hu","Horvát"),
("1389","hr","hy","Croatian"),
("1390","hr","id","Croatian"),
("1391","hr","is","Croatian"),
("1392","hr","it","Croato"),
("1393","hr","ja","クロアチア語"),
("1394","hr","ko","크로아시아어"),
("1395","hr","ku","Croatian"),
("1396","hr","lv","Croatian"),
("1397","hr","lt","Croatian"),
("1398","hr","mk","Croatian"),
("1399","hr","mt","Croatian"),
("1400","hr","mn","Croatian"),
("1401","hr","ne","Croatian"),
("1402","hr","nl","Kroatisch"),
("1403","hr","no","Kroatisk"),
("1404","hr","pa","Croatian"),
("1405","hr","pl","Chorwacki"),
("1406","hr","pt-pt","Croata"),
("1407","hr","pt-br","Croata"),
("1408","hr","qu","Croatian"),
("1409","hr","ro","Croată"),
("1410","hr","ru","Хорватский"),
("1411","hr","sl","Hrvaški"),
("1412","hr","so","Croatian"),
("1413","hr","sq","Croatian"),
("1414","hr","sr","хрватски"),
("1415","hr","sv","Kroatiska"),
("1416","hr","ta","Croatian"),
("1417","hr","th","โครเอเชีย"),
("1418","hr","tr","Hırvatça"),
("1419","hr","uk","Croatian"),
("1420","hr","ur","Croatian"),
("1421","hr","uz","Croatian"),
("1422","hr","vi","Croatian"),
("1423","hr","yi","Croatian"),
("1424","hr","zh-hans","克罗地亚语"),
("1425","hr","zu","Croatian"),
("1426","hr","zh-hant","克羅地亞語"),
("1427","hr","ms","Croatian"),
("1428","hr","gl","Croatian"),
("1429","hr","bn","Croatian"),
("1430","hr","az","Croatian"),
("1431","hu","en","Hungarian"),
("1432","hu","es","Húngaro"),
("1433","hu","de","Ungarisch"),
("1434","hu","fr","Hongrois"),
("1435","hu","ar","الهنغارية"),
("1436","hu","bs","Hungarian"),
("1437","hu","bg","Унгарски"),
("1438","hu","ca","Hungarian"),
("1439","hu","cs","Maďarština"),
("1440","hu","sk","Maďarčina"),
("1441","hu","cy","Hungarian"),
("1442","hu","da","Hungarian"),
("1443","hu","el","Ουγγρικά"),
("1444","hu","eo","Hungarian"),
("1445","hu","et","Hungarian"),
("1446","hu","eu","Hungarian"),
("1447","hu","fa","Hungarian"),
("1448","hu","fi","Unkari"),
("1449","hu","ga","Hungarian"),
("1450","hu","he","הונגרית"),
("1451","hu","hi","Hungarian"),
("1452","hu","hr","Mađarski"),
("1453","hu","hu","Magyar"),
("1454","hu","hy","Hungarian"),
("1455","hu","id","Hungarian"),
("1456","hu","is","Hungarian"),
("1457","hu","it","Ungherese"),
("1458","hu","ja","ハンガリー語"),
("1459","hu","ko","헝가리어"),
("1460","hu","ku","Hungarian"),
("1461","hu","lv","Hungarian"),
("1462","hu","lt","Hungarian"),
("1463","hu","mk","Hungarian"),
("1464","hu","mt","Hungarian"),
("1465","hu","mn","Hungarian"),
("1466","hu","ne","Hungarian"),
("1467","hu","nl","Hongaars"),
("1468","hu","no","Ungarsk"),
("1469","hu","pa","Hungarian"),
("1470","hu","pl","Węgierski"),
("1471","hu","pt-pt","Húngaro"),
("1472","hu","pt-br","Húngaro"),
("1473","hu","qu","Hungarian"),
("1474","hu","ro","Ungară"),
("1475","hu","ru","Венгерский"),
("1476","hu","sl","Madžarski"),
("1477","hu","so","Hungarian"),
("1478","hu","sq","Hungarian"),
("1479","hu","sr","мађарски"),
("1480","hu","sv","Ungerska"),
("1481","hu","ta","Hungarian"),
("1482","hu","th","ฮังการี"),
("1483","hu","tr","Macarca"),
("1484","hu","uk","Hungarian"),
("1485","hu","ur","Hungarian"),
("1486","hu","uz","Hungarian"),
("1487","hu","vi","Hungarian"),
("1488","hu","yi","Hungarian"),
("1489","hu","zh-hans","匈牙利语"),
("1490","hu","zu","Hungarian"),
("1491","hu","zh-hant","匈牙利語"),
("1492","hu","ms","Hungarian"),
("1493","hu","gl","Hungarian"),
("1494","hu","bn","Hungarian"),
("1495","hu","az","Hungarian"),
("1496","hy","en","Armenian"),
("1497","hy","es","Armenio"),
("1498","hy","de","Armenisch"),
("1499","hy","fr","Arménien"),
("1500","hy","ar","الأرمينية"),
("1501","hy","bs","Armenian"),
("1502","hy","bg","Арменски"),
("1503","hy","ca","Armenian"),
("1504","hy","cs","Arménský"),
("1505","hy","sk","Arménčina"),
("1506","hy","cy","Armenian"),
("1507","hy","da","Armenian"),
("1508","hy","el","Αρμένικα"),
("1509","hy","eo","Armenian"),
("1510","hy","et","Armenian"),
("1511","hy","eu","Armenian"),
("1512","hy","fa","Armenian"),
("1513","hy","fi","Armenia"),
("1514","hy","ga","Armenian"),
("1515","hy","he","ארמנית"),
("1516","hy","hi","Armenian"),
("1517","hy","hr","Armenski"),
("1518","hy","hu","örmény"),
("1519","hy","hy","Հայերեն"),
("1520","hy","id","Armenian"),
("1521","hy","is","Armenian"),
("1522","hy","it","Armeno"),
("1523","hy","ja","アルメニア語"),
("1524","hy","ko","아르메니아어"),
("1525","hy","ku","Armenian"),
("1526","hy","lv","Armenian"),
("1527","hy","lt","Armenian"),
("1528","hy","mk","Armenian"),
("1529","hy","mt","Armenian"),
("1530","hy","mn","Armenian"),
("1531","hy","ne","Armenian"),
("1532","hy","nl","Armeens"),
("1533","hy","no","Armensk"),
("1534","hy","pa","Armenian"),
("1535","hy","pl","Ormiański"),
("1536","hy","pt-pt","Arménio"),
("1537","hy","pt-br","Arménio"),
("1538","hy","qu","Armenian"),
("1539","hy","ro","Armeană"),
("1540","hy","ru","Армянский"),
("1541","hy","sl","Armenski"),
("1542","hy","so","Armenian"),
("1543","hy","sq","Armenian"),
("1544","hy","sr","јерменски"),
("1545","hy","sv","Armeniska"),
("1546","hy","ta","Armenian"),
("1547","hy","th","อาร์เมเนีย"),
("1548","hy","tr","Ermenice"),
("1549","hy","uk","Armenian"),
("1550","hy","ur","Armenian"),
("1551","hy","uz","Armenian"),
("1552","hy","vi","Armenian"),
("1553","hy","yi","Armenian"),
("1554","hy","zh-hans","亚美尼亚语"),
("1555","hy","zu","Armenian"),
("1556","hy","zh-hant","亞美尼亞語"),
("1557","hy","ms","Armenian"),
("1558","hy","gl","Armenian"),
("1559","hy","bn","Armenian"),
("1560","hy","az","Armenian"),
("1561","id","en","Indonesian"),
("1562","id","es","Indonesio"),
("1563","id","de","Indonesisch"),
("1564","id","fr","Indonésien"),
("1565","id","ar","الأندونيسية"),
("1566","id","bs","Indonesian"),
("1567","id","bg","Индонезийски"),
("1568","id","ca","Indonesian"),
("1569","id","cs","Indonéský"),
("1570","id","sk","Indonézčina"),
("1571","id","cy","Indonesian"),
("1572","id","da","Indonesian"),
("1573","id","el","Ινδονησιακά"),
("1574","id","eo","Indonesian"),
("1575","id","et","Indonesian"),
("1576","id","eu","Indonesian"),
("1577","id","fa","Indonesian"),
("1578","id","fi","Indonesia"),
("1579","id","ga","Indonesian"),
("1580","id","he","אינדונזית"),
("1581","id","hi","Indonesian"),
("1582","id","hr","Indonezijski"),
("1583","id","hu","Indonéz"),
("1584","id","hy","Indonesian"),
("1585","id","id","Indonesia"),
("1586","id","is","Indonesian"),
("1587","id","it","Indonesiano"),
("1588","id","ja","インドネシア語"),
("1589","id","ko","인도네시아어"),
("1590","id","ku","Indonesian"),
("1591","id","lv","Indonesian"),
("1592","id","lt","Indonesian"),
("1593","id","mk","Indonesian"),
("1594","id","mt","Indonesian"),
("1595","id","mn","Indonesian"),
("1596","id","ne","Indonesian"),
("1597","id","nl","Indonesisch"),
("1598","id","no","Indonesian"),
("1599","id","pa","Indonesian"),
("1600","id","pl","Indonezyjski"),
("1601","id","pt-pt","Indonésio"),
("1602","id","pt-br","Indonésio"),
("1603","id","qu","Indonesian"),
("1604","id","ro","Indoneziană"),
("1605","id","ru","Индонезийский"),
("1606","id","sl","Indonezijski"),
("1607","id","so","Indonesian"),
("1608","id","sq","Indonesian"),
("1609","id","sr","индонезијски"),
("1610","id","sv","Indonesiska"),
("1611","id","ta","Indonesian"),
("1612","id","th","อินโดนีเซีย"),
("1613","id","tr","Endonezya dili"),
("1614","id","uk","Indonesian"),
("1615","id","ur","Indonesian"),
("1616","id","uz","Indonesian"),
("1617","id","vi","Indonesian"),
("1618","id","yi","Indonesian"),
("1619","id","zh-hans","印度尼西亚语"),
("1620","id","zu","Indonesian"),
("1621","id","zh-hant","印尼語"),
("1622","id","ms","Indonesian"),
("1623","id","gl","Indonesian"),
("1624","id","bn","Indonesian"),
("1625","id","az","Indonesian"),
("1626","is","en","Icelandic"),
("1627","is","es","Islandés"),
("1628","is","de","Isländisch"),
("1629","is","fr","Islandais"),
("1630","is","ar","الأيسلاندية"),
("1631","is","bs","Icelandic"),
("1632","is","bg","Исландски"),
("1633","is","ca","Icelandic"),
("1634","is","cs","Islandský"),
("1635","is","sk","Islančina"),
("1636","is","cy","Icelandic"),
("1637","is","da","Icelandic"),
("1638","is","el","Ισλανδικά"),
("1639","is","eo","Icelandic"),
("1640","is","et","Icelandic"),
("1641","is","eu","Icelandic"),
("1642","is","fa","Icelandic"),
("1643","is","fi","Islanti"),
("1644","is","ga","Icelandic"),
("1645","is","he","איסלנדית"),
("1646","is","hi","Icelandic"),
("1647","is","hr","Islandski"),
("1648","is","hu","Izlandi"),
("1649","is","hy","Icelandic"),
("1650","is","id","Icelandic"),
("1651","is","is","Íslenska"),
("1652","is","it","Islandese"),
("1653","is","ja","アイスランド語"),
("1654","is","ko","아이슬랜드어"),
("1655","is","ku","Icelandic"),
("1656","is","lv","Icelandic"),
("1657","is","lt","Icelandic"),
("1658","is","mk","Icelandic"),
("1659","is","mt","Icelandic"),
("1660","is","mn","Icelandic"),
("1661","is","ne","Icelandic"),
("1662","is","nl","Ijslands"),
("1663","is","no","Islandsk"),
("1664","is","pa","Icelandic"),
("1665","is","pl","Islandzki"),
("1666","is","pt-pt","Islandês"),
("1667","is","pt-br","Islandês"),
("1668","is","qu","Icelandic"),
("1669","is","ro","Islandeză"),
("1670","is","ru","Исландский"),
("1671","is","sl","Islandski"),
("1672","is","so","Icelandic"),
("1673","is","sq","Icelandic"),
("1674","is","sr","исландски"),
("1675","is","sv","Isländska"),
("1676","is","ta","Icelandic"),
("1677","is","th","ไอซ์แลนด์"),
("1678","is","tr","İzlandaca"),
("1679","is","uk","Icelandic"),
("1680","is","ur","Icelandic"),
("1681","is","uz","Icelandic"),
("1682","is","vi","Icelandic"),
("1683","is","yi","Icelandic"),
("1684","is","zh-hans","冰岛语"),
("1685","is","zu","Icelandic"),
("1686","is","zh-hant","冰島語"),
("1687","is","ms","Icelandic"),
("1688","is","gl","Icelandic"),
("1689","is","bn","Icelandic"),
("1690","is","az","Icelandic"),
("1691","it","en","Italian"),
("1692","it","es","Italiano"),
("1693","it","de","Italienisch"),
("1694","it","fr","Italien"),
("1695","it","ar","الإيطالية"),
("1696","it","bs","Italian"),
("1697","it","bg","Италиански"),
("1698","it","ca","Italian"),
("1699","it","cs","Ital"),
("1700","it","sk","Taliančina"),
("1701","it","cy","Italian"),
("1702","it","da","Italian"),
("1703","it","el","Ιταλικά"),
("1704","it","eo","Italian"),
("1705","it","et","Italian"),
("1706","it","eu","Italian"),
("1707","it","fa","Italian"),
("1708","it","fi","Italia"),
("1709","it","ga","Italian"),
("1710","it","he","איטלקית"),
("1711","it","hi","Italian"),
("1712","it","hr","Talijanski"),
("1713","it","hu","Olasz"),
("1714","it","hy","Italian"),
("1715","it","id","Italian"),
("1716","it","is","Italian"),
("1717","it","it","Italiano"),
("1718","it","ja","イタリア語"),
("1719","it","ko","이태리어"),
("1720","it","ku","Italian"),
("1721","it","lv","Italian"),
("1722","it","lt","Italian"),
("1723","it","mk","Italian"),
("1724","it","mt","Italian"),
("1725","it","mn","Italian"),
("1726","it","ne","Italian"),
("1727","it","nl","Italiaans"),
("1728","it","no","Italiensk"),
("1729","it","pa","Italian"),
("1730","it","pl","Włoski"),
("1731","it","pt-pt","Italiano"),
("1732","it","pt-br","Italiano"),
("1733","it","qu","Italian"),
("1734","it","ro","Italiană"),
("1735","it","ru","Итальянский"),
("1736","it","sl","Italijanski"),
("1737","it","so","Italian"),
("1738","it","sq","Italian"),
("1739","it","sr","италијански"),
("1740","it","sv","Italienska"),
("1741","it","ta","Italian"),
("1742","it","th","อิตาลี"),
("1743","it","tr","İtalyanca"),
("1744","it","uk","Italian"),
("1745","it","ur","Italian"),
("1746","it","uz","Italian"),
("1747","it","vi","Italian"),
("1748","it","yi","Italian"),
("1749","it","zh-hans","意大利语"),
("1750","it","zu","Italian"),
("1751","it","zh-hant","義大利語"),
("1752","it","ms","Italian"),
("1753","it","gl","Italian"),
("1754","it","bn","Italian"),
("1755","it","az","Italian"),
("1756","ja","en","Japanese"),
("1757","ja","es","Japonés"),
("1758","ja","de","Japanisch"),
("1759","ja","fr","Japonais"),
("1760","ja","ar","اليابانية"),
("1761","ja","bs","Japanese"),
("1762","ja","bg","Японски"),
("1763","ja","ca","Japanese"),
("1764","ja","cs","Japonský"),
("1765","ja","sk","Japonština"),
("1766","ja","cy","Japanese"),
("1767","ja","da","Japanese"),
("1768","ja","el","Ιαπωνικά"),
("1769","ja","eo","Japanese"),
("1770","ja","et","Japanese"),
("1771","ja","eu","Japanese"),
("1772","ja","fa","Japanese"),
("1773","ja","fi","Japani"),
("1774","ja","ga","Japanese"),
("1775","ja","he","יפנית"),
("1776","ja","hi","Japanese"),
("1777","ja","hr","Japanski"),
("1778","ja","hu","Japán"),
("1779","ja","hy","Japanese"),
("1780","ja","id","Japanese"),
("1781","ja","is","Japanese"),
("1782","ja","it","Giapponese"),
("1783","ja","ja","日本語"),
("1784","ja","ko","일어"),
("1785","ja","ku","Japanese"),
("1786","ja","lv","Japanese"),
("1787","ja","lt","Japanese"),
("1788","ja","mk","Japanese"),
("1789","ja","mt","Japanese"),
("1790","ja","mn","Japanese"),
("1791","ja","ne","Japanese"),
("1792","ja","nl","Japans"),
("1793","ja","no","Japansk"),
("1794","ja","pa","Japanese"),
("1795","ja","pl","Japoński"),
("1796","ja","pt-pt","Japonês"),
("1797","ja","pt-br","Japonês"),
("1798","ja","qu","Japanese"),
("1799","ja","ro","Japoneză"),
("1800","ja","ru","Японский"),
("1801","ja","sl","Japonski"),
("1802","ja","so","Japanese"),
("1803","ja","sq","Japanese"),
("1804","ja","sr","јапански"),
("1805","ja","sv","Japanska"),
("1806","ja","ta","Japanese"),
("1807","ja","th","ญี่ปุ่น"),
("1808","ja","tr","Japonca"),
("1809","ja","uk","Japanese"),
("1810","ja","ur","Japanese"),
("1811","ja","uz","Japanese"),
("1812","ja","vi","Japanese"),
("1813","ja","yi","Japanese"),
("1814","ja","zh-hans","日语"),
("1815","ja","zu","Japanese"),
("1816","ja","zh-hant","日語"),
("1817","ja","ms","Japanese"),
("1818","ja","gl","Japanese"),
("1819","ja","bn","Japanese"),
("1820","ja","az","Japanese"),
("1821","ko","en","Korean"),
("1822","ko","es","Coreano"),
("1823","ko","de","Koreanisch"),
("1824","ko","fr","Coréen"),
("1825","ko","ar","الكورية"),
("1826","ko","bs","Korean"),
("1827","ko","bg","Корейски"),
("1828","ko","ca","Korean"),
("1829","ko","cs","Korejský"),
("1830","ko","sk","Kórejčina"),
("1831","ko","cy","Korean"),
("1832","ko","da","Korean"),
("1833","ko","el","Κορεάτικα"),
("1834","ko","eo","Korean"),
("1835","ko","et","Korean"),
("1836","ko","eu","Korean"),
("1837","ko","fa","Korean"),
("1838","ko","fi","Korea"),
("1839","ko","ga","Korean"),
("1840","ko","he","קוראנית"),
("1841","ko","hi","Korean"),
("1842","ko","hr","Korejski"),
("1843","ko","hu","Koreai"),
("1844","ko","hy","Korean"),
("1845","ko","id","Korean"),
("1846","ko","is","Korean"),
("1847","ko","it","Coreano"),
("1848","ko","ja","韓国語"),
("1849","ko","ko","한국어"),
("1850","ko","ku","Korean"),
("1851","ko","lv","Korean"),
("1852","ko","lt","Korean"),
("1853","ko","mk","Korean"),
("1854","ko","mt","Korean"),
("1855","ko","mn","Korean"),
("1856","ko","ne","Korean"),
("1857","ko","nl","Koreaans"),
("1858","ko","no","Koreanske"),
("1859","ko","pa","Korean"),
("1860","ko","pl","Koreański"),
("1861","ko","pt-pt","Coreano"),
("1862","ko","pt-br","Coreano"),
("1863","ko","qu","Korean"),
("1864","ko","ro","Coreană"),
("1865","ko","ru","Корейский"),
("1866","ko","sl","Korejski"),
("1867","ko","so","Korean"),
("1868","ko","sq","Korean"),
("1869","ko","sr","корејски"),
("1870","ko","sv","Koreanska"),
("1871","ko","ta","Korean"),
("1872","ko","th","เกาหลี"),
("1873","ko","tr","Kore dili"),
("1874","ko","uk","Korean"),
("1875","ko","ur","Korean"),
("1876","ko","uz","Korean"),
("1877","ko","vi","Korean"),
("1878","ko","yi","Korean"),
("1879","ko","zh-hans","韩语"),
("1880","ko","zu","Korean"),
("1881","ko","zh-hant","韓語"),
("1882","ko","ms","Korean"),
("1883","ko","gl","Korean"),
("1884","ko","bn","Korean"),
("1885","ko","az","Korean"),
("1886","ku","en","Kurdish"),
("1887","ku","es","Kurdo"),
("1888","ku","de","Kurdisch"),
("1889","ku","fr","Kurde"),
("1890","ku","ar","الكردية"),
("1891","ku","bs","Kurdish"),
("1892","ku","bg","Кюрдски"),
("1893","ku","ca","Kurdish"),
("1894","ku","cs","Kurdský"),
("1895","ku","sk","Kurdština"),
("1896","ku","cy","Kurdish"),
("1897","ku","da","Kurdish"),
("1898","ku","el","Κουρδικά"),
("1899","ku","eo","Kurdish"),
("1900","ku","et","Kurdish"),
("1901","ku","eu","Kurdish"),
("1902","ku","fa","Kurdish"),
("1903","ku","fi","Kurdi"),
("1904","ku","ga","Kurdish"),
("1905","ku","he","כורדית"),
("1906","ku","hi","Kurdish"),
("1907","ku","hr","Kurdski"),
("1908","ku","hu","Kurd"),
("1909","ku","hy","Kurdish"),
("1910","ku","id","Kurdish"),
("1911","ku","is","Kurdish"),
("1912","ku","it","Curdo"),
("1913","ku","ja","クルド語"),
("1914","ku","ko","쿠르드어"),
("1915","ku","ku","Kurdish"),
("1916","ku","lv","Kurdish"),
("1917","ku","lt","Kurdish"),
("1918","ku","mk","Kurdish"),
("1919","ku","mt","Kurdish"),
("1920","ku","mn","Kurdish"),
("1921","ku","ne","Kurdish"),
("1922","ku","nl","Koerdish"),
("1923","ku","no","Kurdisk"),
("1924","ku","pa","Kurdish"),
("1925","ku","pl","Kurdyjski"),
("1926","ku","pt-pt","Curdo"),
("1927","ku","pt-br","Curdo"),
("1928","ku","qu","Kurdish"),
("1929","ku","ro","Kurdă"),
("1930","ku","ru","Курдский"),
("1931","ku","sl","Kurdščina"),
("1932","ku","so","Kurdish"),
("1933","ku","sq","Kurdish"),
("1934","ku","sr","курдски"),
("1935","ku","sv","Kurdiska"),
("1936","ku","ta","Kurdish"),
("1937","ku","th","เคอร์ดิช"),
("1938","ku","tr","Kürtçe"),
("1939","ku","uk","Kurdish"),
("1940","ku","ur","Kurdish"),
("1941","ku","uz","Kurdish"),
("1942","ku","vi","Kurdish"),
("1943","ku","yi","Kurdish"),
("1944","ku","zh-hans","库尔德语"),
("1945","ku","zu","Kurdish"),
("1946","ku","zh-hant","庫爾德語"),
("1947","ku","ms","Kurdish"),
("1948","ku","gl","Kurdish"),
("1949","ku","bn","Kurdish"),
("1950","ku","az","Kurdish"),
("1951","lv","en","Latvian"),
("1952","lv","es","Letón"),
("1953","lv","de","Lettisch"),
("1954","lv","fr","Letton"),
("1955","lv","ar","اللاتفية"),
("1956","lv","bs","Latvian"),
("1957","lv","bg","Латвийски"),
("1958","lv","ca","Latvian"),
("1959","lv","cs","Lotyština"),
("1960","lv","sk","Lotyština"),
("1961","lv","cy","Latvian"),
("1962","lv","da","Latvian"),
("1963","lv","el","Λετονικά"),
("1964","lv","eo","Latvian"),
("1965","lv","et","Latvian"),
("1966","lv","eu","Latvian"),
("1967","lv","fa","Latvian"),
("1968","lv","fi","Latvia"),
("1969","lv","ga","Latvian"),
("1970","lv","he","לטבית"),
("1971","lv","hi","Latvian"),
("1972","lv","hr","Latvijski"),
("1973","lv","hu","Lett"),
("1974","lv","hy","Latvian"),
("1975","lv","id","Latvian"),
("1976","lv","is","Latvian"),
("1977","lv","it","Lettone"),
("1978","lv","ja","ラトビア語"),
("1979","lv","ko","라트비아어"),
("1980","lv","ku","Latvian"),
("1981","lv","lv","Latviešu"),
("1982","lv","lt","Latvian"),
("1983","lv","mk","Latvian"),
("1984","lv","mt","Latvian"),
("1985","lv","mn","Latvian"),
("1986","lv","ne","Latvian"),
("1987","lv","nl","Lets"),
("1988","lv","no","Latvisk"),
("1989","lv","pa","Latvian"),
("1990","lv","pl","łotewski"),
("1991","lv","pt-pt","Letão"),
("1992","lv","pt-br","Letão"),
("1993","lv","qu","Latvian"),
("1994","lv","ro","Letoniană"),
("1995","lv","ru","латышский"),
("1996","lv","sl","Latvijščina"),
("1997","lv","so","Latvian"),
("1998","lv","sq","Latvian"),
("1999","lv","sr","летонски"),
("2000","lv","sv","Lettiska"),
("2001","lv","ta","Latvian"),
("2002","lv","th","ลัตเวีย"),
("2003","lv","tr","Letonca"),
("2004","lv","uk","Latvian"),
("2005","lv","ur","Latvian"),
("2006","lv","uz","Latvian"),
("2007","lv","vi","Latvian"),
("2008","lv","yi","Latvian"),
("2009","lv","zh-hans","拉脱维亚语"),
("2010","lv","zu","Latvian"),
("2011","lv","zh-hant","拉脫維亞語"),
("2012","lv","ms","Latvian"),
("2013","lv","gl","Latvian"),
("2014","lv","bn","Latvian"),
("2015","lv","az","Latvian"),
("2016","lt","en","Lithuanian"),
("2017","lt","es","Lituano"),
("2018","lt","de","Litauisch"),
("2019","lt","fr","Lituanien"),
("2020","lt","ar","اللتوانية"),
("2021","lt","bs","Lithuanian"),
("2022","lt","bg","Литовски"),
("2023","lt","ca","Lithuanian"),
("2024","lt","cs","Litevský"),
("2025","lt","sk","Litovčina"),
("2026","lt","cy","Lithuanian"),
("2027","lt","da","Lithuanian"),
("2028","lt","el","Λιθουανικά"),
("2029","lt","eo","Lithuanian"),
("2030","lt","et","Lithuanian"),
("2031","lt","eu","Lithuanian"),
("2032","lt","fa","Lithuanian"),
("2033","lt","fi","Liettua"),
("2034","lt","ga","Lithuanian"),
("2035","lt","he","ליטאית"),
("2036","lt","hi","Lithuanian"),
("2037","lt","hr","Litavski"),
("2038","lt","hu","Litván"),
("2039","lt","hy","Lithuanian"),
("2040","lt","id","Lithuanian"),
("2041","lt","is","Lithuanian"),
("2042","lt","it","Lituano"),
("2043","lt","ja","リトアニア語"),
("2044","lt","ko","리투아니아어"),
("2045","lt","ku","Lithuanian"),
("2046","lt","lv","Lithuanian"),
("2047","lt","lt","Lietuvių"),
("2048","lt","mk","Lithuanian"),
("2049","lt","mt","Lithuanian"),
("2050","lt","mn","Lithuanian"),
("2051","lt","ne","Lithuanian"),
("2052","lt","nl","Litouws"),
("2053","lt","no","Litauisk"),
("2054","lt","pa","Lithuanian"),
("2055","lt","pl","Litewski"),
("2056","lt","pt-pt","Lituano"),
("2057","lt","pt-br","Lituano"),
("2058","lt","qu","Lithuanian"),
("2059","lt","ro","Lituaniană"),
("2060","lt","ru","Литовский"),
("2061","lt","sl","Litovščina"),
("2062","lt","so","Lithuanian"),
("2063","lt","sq","Lithuanian"),
("2064","lt","sr","литвански"),
("2065","lt","sv","Litauiska"),
("2066","lt","ta","Lithuanian"),
("2067","lt","th","ลิธัวเนีย"),
("2068","lt","tr","Litvanyaca"),
("2069","lt","uk","Lithuanian"),
("2070","lt","ur","Lithuanian"),
("2071","lt","uz","Lithuanian"),
("2072","lt","vi","Lithuanian"),
("2073","lt","yi","Lithuanian"),
("2074","lt","zh-hans","立陶宛语"),
("2075","lt","zu","Lithuanian"),
("2076","lt","zh-hant","立陶宛語"),
("2077","lt","ms","Lithuanian"),
("2078","lt","gl","Lithuanian"),
("2079","lt","bn","Lithuanian"),
("2080","lt","az","Lithuanian"),
("2081","mk","en","Macedonian"),
("2082","mk","es","Macedonio"),
("2083","mk","de","Mazedonisch"),
("2084","mk","fr","Macédonien"),
("2085","mk","ar","المقدونية"),
("2086","mk","bs","Macedonian"),
("2087","mk","bg","Македонски"),
("2088","mk","ca","Macedonian"),
("2089","mk","cs","Makedonský"),
("2090","mk","sk","Macedónština"),
("2091","mk","cy","Macedonian"),
("2092","mk","da","Macedonian"),
("2093","mk","el","Μακεδονικά"),
("2094","mk","eo","Macedonian"),
("2095","mk","et","Macedonian"),
("2096","mk","eu","Macedonian"),
("2097","mk","fa","Macedonian"),
("2098","mk","fi","Makedonia"),
("2099","mk","ga","Macedonian"),
("2100","mk","he","מקדונית"),
("2101","mk","hi","Macedonian"),
("2102","mk","hr","Makedonski"),
("2103","mk","hu","Macedón"),
("2104","mk","hy","Macedonian"),
("2105","mk","id","Macedonian"),
("2106","mk","is","Macedonian"),
("2107","mk","it","Macedone"),
("2108","mk","ja","マケドニア語"),
("2109","mk","ko","마케도니아어"),
("2110","mk","ku","Macedonian"),
("2111","mk","lv","Macedonian"),
("2112","mk","lt","Macedonian"),
("2113","mk","mk","македонски"),
("2114","mk","mt","Macedonian"),
("2115","mk","mn","Macedonian"),
("2116","mk","ne","Macedonian"),
("2117","mk","nl","Macedonisch"),
("2118","mk","no","Makedonsk"),
("2119","mk","pa","Macedonian"),
("2120","mk","pl","Macedoński"),
("2121","mk","pt-pt","Macedônio"),
("2122","mk","pt-br","Macedônio"),
("2123","mk","qu","Macedonian"),
("2124","mk","ro","Macedoniană"),
("2125","mk","ru","Македонский"),
("2126","mk","sl","Makedonski"),
("2127","mk","so","Macedonian"),
("2128","mk","sq","Macedonian"),
("2129","mk","sr","македонски"),
("2130","mk","sv","Makedonska"),
("2131","mk","ta","Macedonian"),
("2132","mk","th","มาซิโดเนีย"),
("2133","mk","tr","Makedonyaca"),
("2134","mk","uk","Macedonian"),
("2135","mk","ur","Macedonian"),
("2136","mk","uz","Macedonian"),
("2137","mk","vi","Macedonian"),
("2138","mk","yi","Macedonian"),
("2139","mk","zh-hans","马其顿语"),
("2140","mk","zu","Macedonian"),
("2141","mk","zh-hant","馬其頓語"),
("2142","mk","ms","Macedonian"),
("2143","mk","gl","Macedonian"),
("2144","mk","bn","Macedonian"),
("2145","mk","az","Macedonian"),
("2146","mt","en","Maltese"),
("2147","mt","es","Maltés"),
("2148","mt","de","Maltesisch"),
("2149","mt","fr","Maltais"),
("2150","mt","ar","المالطية"),
("2151","mt","bs","Maltese"),
("2152","mt","bg","Малтийски"),
("2153","mt","ca","Maltese"),
("2154","mt","cs","Maltština"),
("2155","mt","sk","Maltézština"),
("2156","mt","cy","Maltese"),
("2157","mt","da","Maltese"),
("2158","mt","el","Μαλτέζικα"),
("2159","mt","eo","Maltese"),
("2160","mt","et","Maltese"),
("2161","mt","eu","Maltese"),
("2162","mt","fa","Maltese"),
("2163","mt","fi","Malta"),
("2164","mt","ga","Maltese"),
("2165","mt","he","מלטזית"),
("2166","mt","hi","Maltese"),
("2167","mt","hr","Malteški"),
("2168","mt","hu","Máltai"),
("2169","mt","hy","Maltese"),
("2170","mt","id","Maltese"),
("2171","mt","is","Maltese"),
("2172","mt","it","Maltese"),
("2173","mt","ja","マルタ語"),
("2174","mt","ko","몰타어"),
("2175","mt","ku","Maltese"),
("2176","mt","lv","Maltese"),
("2177","mt","lt","Maltese"),
("2178","mt","mk","Maltese"),
("2179","mt","mt","Malti"),
("2180","mt","mn","Maltese"),
("2181","mt","ne","Maltese"),
("2182","mt","nl","Maltees"),
("2183","mt","no","Maltese"),
("2184","mt","pa","Maltese"),
("2185","mt","pl","Maltański"),
("2186","mt","pt-pt","Maltês"),
("2187","mt","pt-br","Maltês"),
("2188","mt","qu","Maltese"),
("2189","mt","ro","Malteză"),
("2190","mt","ru","Мальтийский"),
("2191","mt","sl","Malteški"),
("2192","mt","so","Maltese"),
("2193","mt","sq","Maltese"),
("2194","mt","sr","малтешки"),
("2195","mt","sv","Maltesiska"),
("2196","mt","ta","Maltese"),
("2197","mt","th","มอลทีส"),
("2198","mt","tr","Malta dili"),
("2199","mt","uk","Maltese"),
("2200","mt","ur","Maltese"),
("2201","mt","uz","Maltese"),
("2202","mt","vi","Maltese"),
("2203","mt","yi","Maltese"),
("2204","mt","zh-hans","马耳他语"),
("2205","mt","zu","Maltese"),
("2206","mt","zh-hant","馬爾他語"),
("2207","mt","ms","Maltese"),
("2208","mt","gl","Maltese"),
("2209","mt","bn","Maltese"),
("2210","mt","az","Maltese"),
("2211","mn","en","Mongolian"),
("2212","mn","es","Mongol"),
("2213","mn","de","Mongolisch"),
("2214","mn","fr","Mongol"),
("2215","mn","ar","المنغولية"),
("2216","mn","bs","Mongolian"),
("2217","mn","bg","Монголски"),
("2218","mn","ca","Mongolian"),
("2219","mn","cs","Mongolský"),
("2220","mn","sk","Mongolština"),
("2221","mn","cy","Mongolian"),
("2222","mn","da","Mongolian"),
("2223","mn","el","Μογγολικά"),
("2224","mn","eo","Mongolian"),
("2225","mn","et","Mongolian"),
("2226","mn","eu","Mongolian"),
("2227","mn","fa","Mongolian"),
("2228","mn","fi","Mongoli"),
("2229","mn","ga","Mongolian"),
("2230","mn","he","מונגולית"),
("2231","mn","hi","Mongolian"),
("2232","mn","hr","Mongolski"),
("2233","mn","hu","Mongol"),
("2234","mn","hy","Mongolian"),
("2235","mn","id","Mongolian"),
("2236","mn","is","Mongolian"),
("2237","mn","it","Mongolo"),
("2238","mn","ja","モンゴル語"),
("2239","mn","ko","몽골어"),
("2240","mn","ku","Mongolian"),
("2241","mn","lv","Mongolian"),
("2242","mn","lt","Mongolian"),
("2243","mn","mk","Mongolian"),
("2244","mn","mt","Mongolian"),
("2245","mn","mn","Mongolian"),
("2246","mn","ne","Mongolian"),
("2247","mn","nl","Mongools"),
("2248","mn","no","Mongolsk"),
("2249","mn","pa","Mongolian"),
("2250","mn","pl","Mongolski"),
("2251","mn","pt-pt","Mongolian"),
("2252","mn","pt-br","Mongolian"),
("2253","mn","qu","Mongolian"),
("2254","mn","ro","Mongoleză"),
("2255","mn","ru","Монгольский"),
("2256","mn","sl","Mongolski"),
("2257","mn","so","Mongolian"),
("2258","mn","sq","Mongolian"),
("2259","mn","sr","монголски"),
("2260","mn","sv","Mongoliska"),
("2261","mn","ta","Mongolian"),
("2262","mn","th","มองโกเลีย"),
("2263","mn","tr","Mongolca"),
("2264","mn","uk","Mongolian"),
("2265","mn","ur","Mongolian"),
("2266","mn","uz","Mongolian"),
("2267","mn","vi","Mongolian"),
("2268","mn","yi","Mongolian"),
("2269","mn","zh-hans","蒙古语"),
("2270","mn","zu","Mongolian"),
("2271","mn","zh-hant","蒙古語"),
("2272","mn","ms","Mongolian"),
("2273","mn","gl","Mongolian"),
("2274","mn","bn","Mongolian"),
("2275","mn","az","Mongolian"),
("2276","ne","en","Nepali"),
("2277","ne","es","Nepalí"),
("2278","ne","de","Nepali"),
("2279","ne","fr","Népalais"),
("2280","ne","ar","النيبالية"),
("2281","ne","bs","Nepali"),
("2282","ne","bg","Непалски"),
("2283","ne","ca","Nepali"),
("2284","ne","cs","Nepálský"),
("2285","ne","sk","Nepálčina"),
("2286","ne","cy","Nepali"),
("2287","ne","da","Nepali"),
("2288","ne","el","Νεπαλικά"),
("2289","ne","eo","Nepali"),
("2290","ne","et","Nepali"),
("2291","ne","eu","Nepali"),
("2292","ne","fa","Nepali"),
("2293","ne","fi","Nepali"),
("2294","ne","ga","Nepali"),
("2295","ne","he","נפאלית"),
("2296","ne","hi","Nepali"),
("2297","ne","hr","Nepali"),
("2298","ne","hu","Nepáli"),
("2299","ne","hy","Nepali"),
("2300","ne","id","Nepali"),
("2301","ne","is","Nepali"),
("2302","ne","it","Nepalese"),
("2303","ne","ja","ネパール語"),
("2304","ne","ko","네팔어"),
("2305","ne","ku","Nepali"),
("2306","ne","lv","Nepali"),
("2307","ne","lt","Nepali"),
("2308","ne","mk","Nepali"),
("2309","ne","mt","Nepali"),
("2310","ne","mn","Nepali"),
("2311","ne","ne","Nepali"),
("2312","ne","nl","Nepalees"),
("2313","ne","no","Nepali"),
("2314","ne","pa","Nepali"),
("2315","ne","pl","Nepalski"),
("2316","ne","pt-pt","Nepali"),
("2317","ne","pt-br","Nepali"),
("2318","ne","qu","Nepali"),
("2319","ne","ro","Nepaleză"),
("2320","ne","ru","Непальский"),
("2321","ne","sl","Nepalščina"),
("2322","ne","so","Nepali"),
("2323","ne","sq","Nepali"),
("2324","ne","sr","непалски"),
("2325","ne","sv","Nepalesiska"),
("2326","ne","ta","Nepali"),
("2327","ne","th","เนปาล"),
("2328","ne","tr","Nepal dili"),
("2329","ne","uk","Nepali"),
("2330","ne","ur","Nepali"),
("2331","ne","uz","Nepali"),
("2332","ne","vi","Nepali"),
("2333","ne","yi","Nepali"),
("2334","ne","zh-hans","尼泊尔语"),
("2335","ne","zu","Nepali"),
("2336","ne","zh-hant","尼泊爾語"),
("2337","ne","ms","Nepali"),
("2338","ne","gl","Nepali"),
("2339","ne","bn","Nepali"),
("2340","ne","az","Nepali"),
("2341","nl","en","Dutch"),
("2342","nl","es","Holandés"),
("2343","nl","de","Niederländisch"),
("2344","nl","fr","Néerlandais"),
("2345","nl","ar","الهولندية"),
("2346","nl","bs","Dutch"),
("2347","nl","bg","Холандски"),
("2348","nl","ca","Dutch"),
("2349","nl","cs","Holandský"),
("2350","nl","sk","Holandčina"),
("2351","nl","cy","Dutch"),
("2352","nl","da","Dutch"),
("2353","nl","el","Ολλανδικά"),
("2354","nl","eo","Dutch"),
("2355","nl","et","Dutch"),
("2356","nl","eu","Dutch"),
("2357","nl","fa","Dutch"),
("2358","nl","fi","Hollanti"),
("2359","nl","ga","Dutch"),
("2360","nl","he","הולנדית"),
("2361","nl","hi","Dutch"),
("2362","nl","hr","Nizozemski"),
("2363","nl","hu","Holland"),
("2364","nl","hy","Dutch"),
("2365","nl","id","Dutch"),
("2366","nl","is","Dutch"),
("2367","nl","it","Olandese"),
("2368","nl","ja","オランダ語"),
("2369","nl","ko","화란어"),
("2370","nl","ku","Dutch"),
("2371","nl","lv","Dutch"),
("2372","nl","lt","Dutch"),
("2373","nl","mk","Dutch"),
("2374","nl","mt","Dutch"),
("2375","nl","mn","Dutch"),
("2376","nl","ne","Dutch"),
("2377","nl","nl","Nederlands"),
("2378","nl","no","Nederlandsk"),
("2379","nl","pa","Dutch"),
("2380","nl","pl","Holenderski"),
("2381","nl","pt-pt","Holandês"),
("2382","nl","pt-br","Holandês"),
("2383","nl","qu","Dutch"),
("2384","nl","ro","Olaneză"),
("2385","nl","ru","Голландский"),
("2386","nl","sl","Nizozemščina"),
("2387","nl","so","Dutch"),
("2388","nl","sq","Dutch"),
("2389","nl","sr","холандски"),
("2390","nl","sv","Nederländska"),
("2391","nl","ta","Dutch"),
("2392","nl","th","ดัตช์"),
("2393","nl","tr","Hollandaca"),
("2394","nl","uk","Dutch"),
("2395","nl","ur","Dutch"),
("2396","nl","uz","Dutch"),
("2397","nl","vi","Dutch"),
("2398","nl","yi","Dutch"),
("2399","nl","zh-hans","荷兰语"),
("2400","nl","zu","Dutch"),
("2401","nl","zh-hant","荷蘭語"),
("2402","nl","ms","Dutch"),
("2403","nl","gl","Dutch"),
("2404","nl","bn","Dutch"),
("2405","nl","az","Dutch"),
("2406","no","en","Norwegian Bokmål"),
("2407","no","es","Bokmål"),
("2408","no","de","Norwegisch (Buchsprache)"),
("2409","no","fr","Norvégien Bokmål"),
("2410","no","ar","البوكمالية النرويجية"),
("2411","no","bs","Norwegian Bokmål"),
("2412","no","bg","Норвежки книжовен"),
("2413","no","ca","Norwegian Bokmål"),
("2414","no","cs","Norwegian bokmål"),
("2415","no","sk","Nórsky jazyk Bokmål"),
("2416","no","cy","Norwegian Bokmål"),
("2417","no","da","Norwegian Bokmål"),
("2418","no","el","Νορβηγικά"),
("2419","no","eo","Norwegian Bokmål"),
("2420","no","et","Norwegian Bokmål"),
("2421","no","eu","Norwegian Bokmål"),
("2422","no","fa","Norwegian Bokmål"),
("2423","no","fi","Kirjanorja"),
("2424","no","ga","Norwegian Bokmål"),
("2425","no","he","נורווגית"),
("2426","no","hi","Norwegian Bokmål"),
("2427","no","hr","Književni norveški"),
("2428","no","hu","Norvég bokmål"),
("2429","no","hy","Norwegian Bokmål"),
("2430","no","id","Norwegian Bokmål"),
("2431","no","is","Norwegian Bokmål"),
("2432","no","it","Norvegese Bokmål"),
("2433","no","ja","ノルウェー・ブークモール"),
("2434","no","ko","노르웨이 보크말어"),
("2435","no","ku","Norwegian Bokmål"),
("2436","no","lv","Norwegian Bokmål"),
("2437","no","lt","Norwegian Bokmål"),
("2438","no","mk","Norwegian Bokmål"),
("2439","no","mt","Norwegian Bokmål"),
("2440","no","mn","Norwegian Bokmål"),
("2441","no","ne","Norwegian Bokmål"),
("2442","no","nl","Noors Bokmål"),
("2443","no","no","Norsk bokmål"),
("2444","no","pa","Norwegian Bokmål"),
("2445","no","pl","Norweski bokmål"),
("2446","no","pt-pt","Norueguês"),
("2447","no","pt-br","Norueguês"),
("2448","no","qu","Norwegian Bokmål"),
("2449","no","ro","Bokmål (norvegiană)"),
("2450","no","ru","Норвежский букмол"),
("2451","no","sl","Knjižna norveščina"),
("2452","no","so","Norwegian Bokmål"),
("2453","no","sq","Norwegian Bokmål"),
("2454","no","sr","Норвешки бокмал"),
("2455","no","sv","Norskt Bokmål"),
("2456","no","ta","Norwegian Bokmål"),
("2457","no","th","นอร์วิเจียนบอกมาล"),
("2458","no","tr","Bokmal Norveç dili"),
("2459","no","uk","Norwegian Bokmål"),
("2460","no","ur","Norwegian Bokmål"),
("2461","no","uz","Norwegian Bokmål"),
("2462","no","vi","Norwegian Bokmål"),
("2463","no","yi","Norwegian Bokmål"),
("2464","no","zh-hans","挪威布克莫尔语"),
("2465","no","zu","Norwegian Bokmål"),
("2466","no","zh-hant","挪威布克莫爾語"),
("2467","no","ms","Norwegian Bokmål"),
("2468","no","gl","Norwegian Bokmål"),
("2469","no","bn","Norwegian Bokmål"),
("2470","no","az","Norwegian Bokmål"),
("2471","pa","en","Punjabi"),
("2472","pa","es","Panyabí"),
("2473","pa","de","Pandschabi"),
("2474","pa","fr","Panjabi"),
("2475","pa","ar","البنجابية"),
("2476","pa","bs","Punjabi"),
("2477","pa","bg","Панджабски"),
("2478","pa","ca","Punjabi"),
("2479","pa","cs","Punjabi"),
("2480","pa","sk","Pandžábčina"),
("2481","pa","cy","Punjabi"),
("2482","pa","da","Punjabi"),
("2483","pa","el","Παντζάμπι"),
("2484","pa","eo","Punjabi"),
("2485","pa","et","Punjabi"),
("2486","pa","eu","Punjabi"),
("2487","pa","fa","Punjabi"),
("2488","pa","fi","Pandzabi"),
("2489","pa","ga","Punjabi"),
("2490","pa","he","פנג\'אבית"),
("2491","pa","hi","Punjabi"),
("2492","pa","hr","Pendžabljanin"),
("2493","pa","hu","Pandzsábi"),
("2494","pa","hy","Punjabi"),
("2495","pa","id","Punjabi"),
("2496","pa","is","Punjabi"),
("2497","pa","it","Panjabi"),
("2498","pa","ja","パンジャーブ語"),
("2499","pa","ko","펀자브어"),
("2500","pa","ku","Punjabi"),
("2501","pa","lv","Punjabi"),
("2502","pa","lt","Punjabi"),
("2503","pa","mk","Punjabi"),
("2504","pa","mt","Punjabi"),
("2505","pa","mn","Punjabi"),
("2506","pa","ne","Punjabi"),
("2507","pa","nl","Punjabi"),
("2508","pa","no","Punjabi"),
("2509","pa","pa","Punjabi"),
("2510","pa","pl","Pendżabi"),
("2511","pa","pt-pt","Panjabi"),
("2512","pa","pt-br","Panjabi"),
("2513","pa","qu","Punjabi"),
("2514","pa","ro","Punjabi"),
("2515","pa","ru","Панджаби"),
("2516","pa","sl","Pandžabščina"),
("2517","pa","so","Punjabi"),
("2518","pa","sq","Punjabi"),
("2519","pa","sr","панџаби"),
("2520","pa","sv","Punjabi"),
("2521","pa","ta","Punjabi"),
("2522","pa","th","ปัญจาบ"),
("2523","pa","tr","Pencapça"),
("2524","pa","uk","Punjabi"),
("2525","pa","ur","Punjabi"),
("2526","pa","uz","Punjabi"),
("2527","pa","vi","Punjabi"),
("2528","pa","yi","Punjabi"),
("2529","pa","zh-hans","旁遮普语"),
("2530","pa","zu","Punjabi"),
("2531","pa","zh-hant","旁遮普語"),
("2532","pa","ms","Punjabi"),
("2533","pa","gl","Punjabi"),
("2534","pa","bn","Punjabi"),
("2535","pa","az","Punjabi"),
("2536","pl","en","Polish"),
("2537","pl","es","Polaco"),
("2538","pl","de","Polnisch"),
("2539","pl","fr","Polonais"),
("2540","pl","ar","البولندية"),
("2541","pl","bs","Polish"),
("2542","pl","bg","Полски"),
("2543","pl","ca","Polish"),
("2544","pl","cs","Polský"),
("2545","pl","sk","Polština"),
("2546","pl","cy","Polish"),
("2547","pl","da","Polish"),
("2548","pl","el","Πολωνικά"),
("2549","pl","eo","Polish"),
("2550","pl","et","Polish"),
("2551","pl","eu","Polish"),
("2552","pl","fa","Polish"),
("2553","pl","fi","Puola"),
("2554","pl","ga","Polish"),
("2555","pl","he","פולנית"),
("2556","pl","hi","Polish"),
("2557","pl","hr","Poljski"),
("2558","pl","hu","Lengyel"),
("2559","pl","hy","Polish"),
("2560","pl","id","Polish"),
("2561","pl","is","Polish"),
("2562","pl","it","Polacco"),
("2563","pl","ja","ポーランド語"),
("2564","pl","ko","폴란드어"),
("2565","pl","ku","Polish"),
("2566","pl","lv","Polish"),
("2567","pl","lt","Polish"),
("2568","pl","mk","Polish"),
("2569","pl","mt","Polish"),
("2570","pl","mn","Polish"),
("2571","pl","ne","Polish"),
("2572","pl","nl","Pools"),
("2573","pl","no","Polsk"),
("2574","pl","pa","Polish"),
("2575","pl","pl","Polski"),
("2576","pl","pt-pt","Polonês"),
("2577","pl","pt-br","Polonês"),
("2578","pl","qu","Polish"),
("2579","pl","ro","Poloneză"),
("2580","pl","ru","Польский"),
("2581","pl","sl","Poljski"),
("2582","pl","so","Polish"),
("2583","pl","sq","Polish"),
("2584","pl","sr","пољски"),
("2585","pl","sv","Polska"),
("2586","pl","ta","Polish"),
("2587","pl","th","โปแลนด์"),
("2588","pl","tr","Polonyaca"),
("2589","pl","uk","Polish"),
("2590","pl","ur","Polish"),
("2591","pl","uz","Polish"),
("2592","pl","vi","Polish"),
("2593","pl","yi","Polish"),
("2594","pl","zh-hans","波兰语"),
("2595","pl","zu","Polish"),
("2596","pl","zh-hant","波蘭語"),
("2597","pl","ms","Polish"),
("2598","pl","gl","Polish"),
("2599","pl","bn","Polish"),
("2600","pl","az","Polish"),
("2601","pt-pt","en","Portuguese (Portugal)"),
("2602","pt-pt","es","Portugués, Portugal"),
("2603","pt-pt","de","Portugiesisch, Portugal"),
("2604","pt-pt","fr","Portugais - du Portugal"),
("2605","pt-pt","ar","البرتغالية ، البرتغال"),
("2606","pt-pt","bs","Portuguese, Portugal"),
("2607","pt-pt","bg","Португалски (Португалия)"),
("2608","pt-pt","ca","Portuguese, Portugal"),
("2609","pt-pt","cs","Portugalština ( Portugalsko)"),
("2610","pt-pt","sk","Portugalština"),
("2611","pt-pt","cy","Portuguese, Portugal"),
("2612","pt-pt","da","Portuguese, Portugal"),
("2613","pt-pt","el","Πορτογαλικά"),
("2614","pt-pt","eo","Portuguese, Portugal"),
("2615","pt-pt","et","Portuguese, Portugal"),
("2616","pt-pt","eu","Portuguese, Portugal"),
("2617","pt-pt","fa","Portuguese, Portugal"),
("2618","pt-pt","fi","Portugali"),
("2619","pt-pt","ga","Portuguese, Portugal"),
("2620","pt-pt","he","פורטוגזית"),
("2621","pt-pt","hi","Portuguese, Portugal"),
("2622","pt-pt","hr","Portugalski (Portugal)"),
("2623","pt-pt","hu","Portugál"),
("2624","pt-pt","hy","Portuguese, Portugal"),
("2625","pt-pt","id","Portuguese, Portugal"),
("2626","pt-pt","is","Portuguese, Portugal"),
("2627","pt-pt","it","Portoghese, Portogallo"),
("2628","pt-pt","ja","ポルトガル語"),
("2629","pt-pt","ko","포르투갈 포르투갈어"),
("2630","pt-pt","ku","Portuguese, Portugal"),
("2631","pt-pt","lv","Portuguese, Portugal"),
("2632","pt-pt","lt","Portuguese, Portugal"),
("2633","pt-pt","mk","Portuguese, Portugal"),
("2634","pt-pt","mt","Portuguese, Portugal"),
("2635","pt-pt","mn","Portuguese, Portugal"),
("2636","pt-pt","ne","Portuguese, Portugal"),
("2637","pt-pt","nl","Portugees, Portugal"),
("2638","pt-pt","no","Portugisisk (Portugal)"),
("2639","pt-pt","pa","Portuguese, Portugal"),
("2640","pt-pt","pl","Portugalski, Portugalia"),
("2641","pt-pt","pt-pt","Português"),
("2642","pt-pt","pt-br","Português"),
("2643","pt-pt","qu","Portuguese, Portugal"),
("2644","pt-pt","ro","Portugheză (Portugalia)"),
("2645","pt-pt","ru","Португальский, Португалия"),
("2646","pt-pt","sl","Portugalščina ( Portugalska )"),
("2647","pt-pt","so","Portuguese, Portugal"),
("2648","pt-pt","sq","Portuguese, Portugal"),
("2649","pt-pt","sr","Португалски (Португалија)"),
("2650","pt-pt","sv","Portugisiska, Portugal"),
("2651","pt-pt","ta","Portuguese, Portugal"),
("2652","pt-pt","th","โปรตุเกส"),
("2653","pt-pt","tr","Portekizce, Portekiz"),
("2654","pt-pt","uk","Portuguese, Portugal"),
("2655","pt-pt","ur","Portuguese, Portugal"),
("2656","pt-pt","uz","Portuguese, Portugal"),
("2657","pt-pt","vi","Portuguese, Portugal"),
("2658","pt-pt","yi","Portuguese, Portugal"),
("2659","pt-pt","zh-hans","葡萄牙语（葡萄牙）"),
("2660","pt-pt","zu","Portuguese, Portugal"),
("2661","pt-pt","zh-hant","葡萄牙語（葡萄牙）"),
("2662","pt-pt","ms","Portuguese, Portugal"),
("2663","pt-pt","gl","Portuguese, Portugal"),
("2664","pt-pt","bn","Portuguese, Portugal"),
("2665","pt-pt","az","Portuguese, Portugal"),
("2666","pt-br","en","Portuguese (Brazil)"),
("2667","pt-br","es","Portugués, Brasil"),
("2668","pt-br","de","Portugiesisch, Brasilien"),
("2669","pt-br","fr","Portugais - du Brésil"),
("2670","pt-br","ar","البرتغالية ،البرازيل"),
("2671","pt-br","bs","Portuguese, Brazil"),
("2672","pt-br","bg","Португалски (Бразилия)"),
("2673","pt-br","ca","Portuguese, Brazil"),
("2674","pt-br","cs","Portugalština ( Brazílie)"),
("2675","pt-br","sk","Brazílska Portugalština"),
("2676","pt-br","cy","Portuguese, Brazil"),
("2677","pt-br","da","Portuguese, Brazil"),
("2678","pt-br","el","Πορτογαλικά Βραζιλίας"),
("2679","pt-br","eo","Portuguese, Brazil"),
("2680","pt-br","et","Portuguese, Brazil"),
("2681","pt-br","eu","Portuguese, Brazil"),
("2682","pt-br","fa","Portuguese, Brazil"),
("2683","pt-br","fi","Brasilian portugali"),
("2684","pt-br","ga","Portuguese, Brazil"),
("2685","pt-br","he","פורטוגזית - ברזיל"),
("2686","pt-br","hi","Portuguese, Brazil"),
("2687","pt-br","hr","Portugalski (Brazil)"),
("2688","pt-br","hu","Brazil"),
("2689","pt-br","hy","Portuguese, Brazil"),
("2690","pt-br","id","Portuguese, Brazil"),
("2691","pt-br","is","Portuguese, Brazil"),
("2692","pt-br","it","Portoghese, Brasile"),
("2693","pt-br","ja","ポルトガル語（ブラジル）"),
("2694","pt-br","ko","브라질 포르투갈어"),
("2695","pt-br","ku","Portuguese, Brazil"),
("2696","pt-br","lv","Portuguese, Brazil"),
("2697","pt-br","lt","Portuguese, Brazil"),
("2698","pt-br","mk","Portuguese, Brazil"),
("2699","pt-br","mt","Portuguese, Brazil"),
("2700","pt-br","mn","Portuguese, Brazil"),
("2701","pt-br","ne","Portuguese, Brazil"),
("2702","pt-br","nl","Portugees, Brazilië"),
("2703","pt-br","no","Portugisisk (Brasil)"),
("2704","pt-br","pa","Portuguese, Brazil"),
("2705","pt-br","pl","Portugalski, Brazylia"),
("2706","pt-br","pt-pt","Português"),
("2707","pt-br","pt-br","Português"),
("2708","pt-br","qu","Portuguese, Brazil"),
("2709","pt-br","ro","Portugheză (Brazilia)"),
("2710","pt-br","ru","Португальский, Бразилия"),
("2711","pt-br","sl","Portugalščina ( Brazilija )"),
("2712","pt-br","so","Portuguese, Brazil"),
("2713","pt-br","sq","Portuguese, Brazil"),
("2714","pt-br","sr","Португалски (Бразил)"),
("2715","pt-br","sv","Portugisiska, Brasilien"),
("2716","pt-br","ta","Portuguese, Brazil"),
("2717","pt-br","th","โปรตุเกสบราซิล"),
("2718","pt-br","tr","Portekizce, Brezilya"),
("2719","pt-br","uk","Portuguese, Brazil"),
("2720","pt-br","ur","Portuguese, Brazil"),
("2721","pt-br","uz","Portuguese, Brazil"),
("2722","pt-br","vi","Portuguese, Brazil"),
("2723","pt-br","yi","Portuguese, Brazil"),
("2724","pt-br","zh-hans","葡萄牙语（巴西）"),
("2725","pt-br","zu","Portuguese, Brazil"),
("2726","pt-br","zh-hant","葡萄牙語（巴西）"),
("2727","pt-br","ms","Portuguese, Brazil"),
("2728","pt-br","gl","Portuguese, Brazil"),
("2729","pt-br","bn","Portuguese, Brazil"),
("2730","pt-br","az","Portuguese, Brazil"),
("2731","qu","en","Quechua"),
("2732","qu","es","Quechua"),
("2733","qu","de","Quechua"),
("2734","qu","fr","Quechua"),
("2735","qu","ar","الكويتشوا"),
("2736","qu","bs","Quechua"),
("2737","qu","bg","Кечуа"),
("2738","qu","ca","Quechua"),
("2739","qu","cs","Quechua"),
("2740","qu","sk","Jazyk Quechua"),
("2741","qu","cy","Quechua"),
("2742","qu","da","Quechua"),
("2743","qu","el","Κέτσουα"),
("2744","qu","eo","Quechua"),
("2745","qu","et","Quechua"),
("2746","qu","eu","Quechua"),
("2747","qu","fa","Quechua"),
("2748","qu","fi","Ketsua"),
("2749","qu","ga","Quechua"),
("2750","qu","he","קצ\'ואה"),
("2751","qu","hi","Quechua"),
("2752","qu","hr","Quechua"),
("2753","qu","hu","Quechua"),
("2754","qu","hy","Quechua"),
("2755","qu","id","Quechua"),
("2756","qu","is","Quechua"),
("2757","qu","it","Quechua"),
("2758","qu","ja","ケチュア語"),
("2759","qu","ko","케추아어"),
("2760","qu","ku","Quechua"),
("2761","qu","lv","Quechua"),
("2762","qu","lt","Quechua"),
("2763","qu","mk","Quechua"),
("2764","qu","mt","Quechua"),
("2765","qu","mn","Quechua"),
("2766","qu","ne","Quechua"),
("2767","qu","nl","Quechua"),
("2768","qu","no","Quechua"),
("2769","qu","pa","Quechua"),
("2770","qu","pl","Keczua"),
("2771","qu","pt-pt","Quechua"),
("2772","qu","pt-br","Quechua"),
("2773","qu","qu","Quechua"),
("2774","qu","ro","Quechuană"),
("2775","qu","ru","Кечуа"),
("2776","qu","sl","Quechua"),
("2777","qu","so","Quechua"),
("2778","qu","sq","Quechua"),
("2779","qu","sr","Кечуа"),
("2780","qu","sv","Quechua"),
("2781","qu","ta","Quechua"),
("2782","qu","th","คิวชัว"),
("2783","qu","tr","Quechua dili"),
("2784","qu","uk","Quechua"),
("2785","qu","ur","Quechua"),
("2786","qu","uz","Quechua"),
("2787","qu","vi","Quechua"),
("2788","qu","yi","Quechua"),
("2789","qu","zh-hans","盖丘亚语"),
("2790","qu","zu","Quechua"),
("2791","qu","zh-hant","蓋丘亞語"),
("2792","qu","ms","Quechua"),
("2793","qu","gl","Quechua"),
("2794","qu","bn","Quechua"),
("2795","qu","az","Quechua"),
("2796","ro","en","Romanian"),
("2797","ro","es","Rumano"),
("2798","ro","de","Rumänisch"),
("2799","ro","fr","Roumain"),
("2800","ro","ar","الرومانية"),
("2801","ro","bs","Romanian"),
("2802","ro","bg","Румънски"),
("2803","ro","ca","Romanian"),
("2804","ro","cs","Rumunština"),
("2805","ro","sk","Rumunčina"),
("2806","ro","cy","Romanian"),
("2807","ro","da","Romanian"),
("2808","ro","el","Ρουμανικά"),
("2809","ro","eo","Romanian"),
("2810","ro","et","Romanian"),
("2811","ro","eu","Romanian"),
("2812","ro","fa","Romanian"),
("2813","ro","fi","Romania"),
("2814","ro","ga","Romanian"),
("2815","ro","he","רומנית"),
("2816","ro","hi","Romanian"),
("2817","ro","hr","Rumunjski"),
("2818","ro","hu","Román"),
("2819","ro","hy","Romanian"),
("2820","ro","id","Romanian"),
("2821","ro","is","Romanian"),
("2822","ro","it","Rumeno"),
("2823","ro","ja","ルーマニア語"),
("2824","ro","ko","로마니아어"),
("2825","ro","ku","Romanian"),
("2826","ro","lv","Romanian"),
("2827","ro","lt","Romanian"),
("2828","ro","mk","Romanian"),
("2829","ro","mt","Romanian"),
("2830","ro","mn","Romanian"),
("2831","ro","ne","Romanian"),
("2832","ro","nl","Roemeens"),
("2833","ro","no","Rumensk"),
("2834","ro","pa","Romanian"),
("2835","ro","pl","Rumuński"),
("2836","ro","pt-pt","Romeno"),
("2837","ro","pt-br","Romeno"),
("2838","ro","qu","Romanian"),
("2839","ro","ro","Română"),
("2840","ro","ru","Румынский"),
("2841","ro","sl","Romunščina"),
("2842","ro","so","Romanian"),
("2843","ro","sq","Romanian"),
("2844","ro","sr","румунски"),
("2845","ro","sv","Rumänska"),
("2846","ro","ta","Romanian"),
("2847","ro","th","โรมาเนีย"),
("2848","ro","tr","Rumence"),
("2849","ro","uk","Romanian"),
("2850","ro","ur","Romanian"),
("2851","ro","uz","Romanian"),
("2852","ro","vi","Romanian"),
("2853","ro","yi","Romanian"),
("2854","ro","zh-hans","罗马尼亚语"),
("2855","ro","zu","Romanian"),
("2856","ro","zh-hant","羅馬尼亞語"),
("2857","ro","ms","Romanian"),
("2858","ro","gl","Romanian"),
("2859","ro","bn","Romanian"),
("2860","ro","az","Romanian"),
("2861","ru","en","Russian"),
("2862","ru","es","Ruso"),
("2863","ru","de","Russisch"),
("2864","ru","fr","Russe"),
("2865","ru","ar","الروسية"),
("2866","ru","bs","Russian"),
("2867","ru","bg","Руски"),
("2868","ru","ca","Russian"),
("2869","ru","cs","Ruský"),
("2870","ru","sk","Ruština"),
("2871","ru","cy","Russian"),
("2872","ru","da","Russian"),
("2873","ru","el","Ρωσικά"),
("2874","ru","eo","Russian"),
("2875","ru","et","Russian"),
("2876","ru","eu","Russian"),
("2877","ru","fa","Russian"),
("2878","ru","fi","Venäjä"),
("2879","ru","ga","Russian"),
("2880","ru","he","רוסית"),
("2881","ru","hi","Russian"),
("2882","ru","hr","Ruski"),
("2883","ru","hu","Orosz"),
("2884","ru","hy","Russian"),
("2885","ru","id","Russian"),
("2886","ru","is","Russian"),
("2887","ru","it","Russo"),
("2888","ru","ja","ロシア語"),
("2889","ru","ko","러시아어"),
("2890","ru","ku","Russian"),
("2891","ru","lv","Russian"),
("2892","ru","lt","Russian"),
("2893","ru","mk","Russian"),
("2894","ru","mt","Russian"),
("2895","ru","mn","Russian"),
("2896","ru","ne","Russian"),
("2897","ru","nl","Russisch"),
("2898","ru","no","Russisk"),
("2899","ru","pa","Russian"),
("2900","ru","pl","Rosyjski"),
("2901","ru","pt-pt","Russo"),
("2902","ru","pt-br","Russo"),
("2903","ru","qu","Russian"),
("2904","ru","ro","Rusă"),
("2905","ru","ru","Русский"),
("2906","ru","sl","Ruščina"),
("2907","ru","so","Russian"),
("2908","ru","sq","Russian"),
("2909","ru","sr","руски"),
("2910","ru","sv","Ryska"),
("2911","ru","ta","Russian"),
("2912","ru","th","รัสเซีย"),
("2913","ru","tr","Rusça"),
("2914","ru","uk","Russian"),
("2915","ru","ur","Russian"),
("2916","ru","uz","Russian"),
("2917","ru","vi","Russian"),
("2918","ru","yi","Russian"),
("2919","ru","zh-hans","俄语"),
("2920","ru","zu","Russian"),
("2921","ru","zh-hant","俄語"),
("2922","ru","ms","Russian"),
("2923","ru","gl","Russian"),
("2924","ru","bn","Russian"),
("2925","ru","az","Russian"),
("2926","sl","en","Slovenian"),
("2927","sl","es","Esloveno"),
("2928","sl","de","Slowenisch"),
("2929","sl","fr","Slovène"),
("2930","sl","ar","السلوفانية"),
("2931","sl","bs","Slovenian"),
("2932","sl","bg","Словенски"),
("2933","sl","ca","Slovenian"),
("2934","sl","cs","Slovinština"),
("2935","sl","sk","Slovinčina"),
("2936","sl","cy","Slovenian"),
("2937","sl","da","Slovenian"),
("2938","sl","el","Σλοβενικά"),
("2939","sl","eo","Slovenian"),
("2940","sl","et","Slovenian"),
("2941","sl","eu","Slovenian"),
("2942","sl","fa","Slovenian"),
("2943","sl","fi","Sloveeni"),
("2944","sl","ga","Slovenian"),
("2945","sl","he","סלובנית"),
("2946","sl","hi","Slovenian"),
("2947","sl","hr","Slovenski"),
("2948","sl","hu","Szlovén"),
("2949","sl","hy","Slovenian"),
("2950","sl","id","Slovenian"),
("2951","sl","is","Slovenian"),
("2952","sl","it","Sloveno"),
("2953","sl","ja","スロベニア語"),
("2954","sl","ko","슬로베니아어"),
("2955","sl","ku","Slovenian"),
("2956","sl","lv","Slovenian"),
("2957","sl","lt","Slovenian"),
("2958","sl","mk","Slovenian"),
("2959","sl","mt","Slovenian"),
("2960","sl","mn","Slovenian"),
("2961","sl","ne","Slovenian"),
("2962","sl","nl","Sloveens"),
("2963","sl","no","Slovensk"),
("2964","sl","pa","Slovenian"),
("2965","sl","pl","Słoweński"),
("2966","sl","pt-pt","Esloveno"),
("2967","sl","pt-br","Esloveno"),
("2968","sl","qu","Slovenian"),
("2969","sl","ro","Slovenă"),
("2970","sl","ru","Словенский"),
("2971","sl","sl","Slovenščina"),
("2972","sl","so","Slovenian"),
("2973","sl","sq","Slovenian"),
("2974","sl","sr","словеначки"),
("2975","sl","sv","Slovenska"),
("2976","sl","ta","Slovenian"),
("2977","sl","th","สโลวีเนียน"),
("2978","sl","tr","Sloven dili"),
("2979","sl","uk","Slovenian"),
("2980","sl","ur","Slovenian"),
("2981","sl","uz","Slovenian"),
("2982","sl","vi","Slovenian"),
("2983","sl","yi","Slovenian"),
("2984","sl","zh-hans","斯洛文尼亚语"),
("2985","sl","zu","Slovenian"),
("2986","sl","zh-hant","斯洛文尼亞語"),
("2987","sl","ms","Slovenian"),
("2988","sl","gl","Slovenian"),
("2989","sl","bn","Slovenian"),
("2990","sl","az","Slovenian"),
("2991","so","en","Somali"),
("2992","so","es","Somalí"),
("2993","so","de","Somali"),
("2994","so","fr","Somali"),
("2995","so","ar","الصومالية"),
("2996","so","bs","Somali"),
("2997","so","bg","Сомалийски"),
("2998","so","ca","Somali"),
("2999","so","cs","Somali"),
("3000","so","sk","Somálčina"),
("3001","so","cy","Somali"),
("3002","so","da","Somali"),
("3003","so","el","Σομαλικά"),
("3004","so","eo","Somali"),
("3005","so","et","Somali"),
("3006","so","eu","Somali"),
("3007","so","fa","Somali"),
("3008","so","fi","Somali"),
("3009","so","ga","Somali"),
("3010","so","he","סומלית"),
("3011","so","hi","Somali"),
("3012","so","hr","Somalski"),
("3013","so","hu","Szomáli"),
("3014","so","hy","Somali"),
("3015","so","id","Somali"),
("3016","so","is","Somali"),
("3017","so","it","Somalo"),
("3018","so","ja","ソマリ語"),
("3019","so","ko","소말리아어"),
("3020","so","ku","Somali"),
("3021","so","lv","Somali"),
("3022","so","lt","Somali"),
("3023","so","mk","Somali"),
("3024","so","mt","Somali"),
("3025","so","mn","Somali"),
("3026","so","ne","Somali"),
("3027","so","nl","Somalisch"),
("3028","so","no","Somali"),
("3029","so","pa","Somali"),
("3030","so","pl","Somalijski"),
("3031","so","pt-pt","Somali"),
("3032","so","pt-br","Somali"),
("3033","so","qu","Somali"),
("3034","so","ro","Somaleză"),
("3035","so","ru","Сомалийский"),
("3036","so","sl","Somalski"),
("3037","so","so","Somali"),
("3038","so","sq","Somali"),
("3039","so","sr","Сомалијски"),
("3040","so","sv","Somaliska"),
("3041","so","ta","Somali"),
("3042","so","th","โซมาลี"),
("3043","so","tr","Somalice"),
("3044","so","uk","Somali"),
("3045","so","ur","Somali"),
("3046","so","uz","Somali"),
("3047","so","vi","Somali"),
("3048","so","yi","Somali"),
("3049","so","zh-hans","索马里语"),
("3050","so","zu","Somali"),
("3051","so","zh-hant","索馬里語"),
("3052","so","ms","Somali"),
("3053","so","gl","Somali"),
("3054","so","bn","Somali"),
("3055","so","az","Somali"),
("3056","sq","en","Albanian"),
("3057","sq","es","Albanés"),
("3058","sq","de","Albanisch"),
("3059","sq","fr","Albanais"),
("3060","sq","ar","الألبانية"),
("3061","sq","bs","Albanian"),
("3062","sq","bg","Албански"),
("3063","sq","ca","Albanian"),
("3064","sq","cs","Albánský"),
("3065","sq","sk","Albánčina"),
("3066","sq","cy","Albanian"),
("3067","sq","da","Albanian"),
("3068","sq","el","Αλβανικά"),
("3069","sq","eo","Albanian"),
("3070","sq","et","Albanian"),
("3071","sq","eu","Albanian"),
("3072","sq","fa","Albanian"),
("3073","sq","fi","Albania"),
("3074","sq","ga","Albanian"),
("3075","sq","he","אלבנית"),
("3076","sq","hi","Albanian"),
("3077","sq","hr","Albanski"),
("3078","sq","hu","Albán"),
("3079","sq","hy","Albanian"),
("3080","sq","id","Albanian"),
("3081","sq","is","Albanian"),
("3082","sq","it","Albanese"),
("3083","sq","ja","アルバニア語"),
("3084","sq","ko","알바니아어"),
("3085","sq","ku","Albanian"),
("3086","sq","lv","Albanian"),
("3087","sq","lt","Albanian"),
("3088","sq","mk","Albanian"),
("3089","sq","mt","Albanian"),
("3090","sq","mn","Albanian"),
("3091","sq","ne","Albanian"),
("3092","sq","nl","Albaans"),
("3093","sq","no","Albansk"),
("3094","sq","pa","Albanian"),
("3095","sq","pl","Albański"),
("3096","sq","pt-pt","Albanês"),
("3097","sq","pt-br","Albanês"),
("3098","sq","qu","Albanian"),
("3099","sq","ro","Albaneză"),
("3100","sq","ru","Албанский"),
("3101","sq","sl","Albanski"),
("3102","sq","so","Albanian"),
("3103","sq","sq","Albanian"),
("3104","sq","sr","албански"),
("3105","sq","sv","Albanska"),
("3106","sq","ta","Albanian"),
("3107","sq","th","อัลเบเนีย"),
("3108","sq","tr","Arnavutça"),
("3109","sq","uk","Albanian"),
("3110","sq","ur","Albanian"),
("3111","sq","uz","Albanian"),
("3112","sq","vi","Albanian"),
("3113","sq","yi","Albanian"),
("3114","sq","zh-hans","阿尔巴尼亚语"),
("3115","sq","zu","Albanian"),
("3116","sq","zh-hant","阿爾巴尼亞語"),
("3117","sq","ms","Albanian"),
("3118","sq","gl","Albanian"),
("3119","sq","bn","Albanian"),
("3120","sq","az","Albanian"),
("3121","sr","en","Serbian"),
("3122","sr","es","Serbio"),
("3123","sr","de","Serbisch"),
("3124","sr","fr","Serbe"),
("3125","sr","ar","الصربية"),
("3126","sr","bs","Serbian"),
("3127","sr","bg","Сръбски"),
("3128","sr","ca","Serbian"),
("3129","sr","cs","Srbský"),
("3130","sr","sk","Srbština"),
("3131","sr","cy","Serbian"),
("3132","sr","da","Serbian"),
("3133","sr","el","Σερβικά"),
("3134","sr","eo","Serbian"),
("3135","sr","et","Serbian"),
("3136","sr","eu","Serbian"),
("3137","sr","fa","Serbian"),
("3138","sr","fi","Serbia"),
("3139","sr","ga","Serbian"),
("3140","sr","he","סרבית"),
("3141","sr","hi","Serbian"),
("3142","sr","hr","Srpski"),
("3143","sr","hu","Szerb"),
("3144","sr","hy","Serbian"),
("3145","sr","id","Serbian"),
("3146","sr","is","Serbian"),
("3147","sr","it","Serbo"),
("3148","sr","ja","セルビア語"),
("3149","sr","ko","세르비아어"),
("3150","sr","ku","Serbian"),
("3151","sr","lv","Serbian"),
("3152","sr","lt","Serbian"),
("3153","sr","mk","Serbian"),
("3154","sr","mt","Serbian"),
("3155","sr","mn","Serbian"),
("3156","sr","ne","Serbian"),
("3157","sr","nl","Servisch"),
("3158","sr","no","Serbisk"),
("3159","sr","pa","Serbian"),
("3160","sr","pl","Serbski"),
("3161","sr","pt-pt","Sérvio"),
("3162","sr","pt-br","Sérvio"),
("3163","sr","qu","Serbian"),
("3164","sr","ro","Sârbă"),
("3165","sr","ru","Сербский"),
("3166","sr","sl","Srbski"),
("3167","sr","so","Serbian"),
("3168","sr","sq","Serbian"),
("3169","sr","sr","српски"),
("3170","sr","sv","Serbiska"),
("3171","sr","ta","Serbian"),
("3172","sr","th","เซอร์เบีย"),
("3173","sr","tr","Sırpça"),
("3174","sr","uk","Serbian"),
("3175","sr","ur","Serbian"),
("3176","sr","uz","Serbian"),
("3177","sr","vi","Serbian"),
("3178","sr","yi","Serbian"),
("3179","sr","zh-hans","赛尔维亚语"),
("3180","sr","zu","Serbian"),
("3181","sr","zh-hant","賽爾維亞語"),
("3182","sr","ms","Serbian"),
("3183","sr","gl","Serbian"),
("3184","sr","bn","Serbian"),
("3185","sr","az","Serbian"),
("3186","sv","en","Swedish"),
("3187","sv","es","Sueco"),
("3188","sv","de","Schwedisch"),
("3189","sv","fr","Suédois"),
("3190","sv","ar","السويدية"),
("3191","sv","bs","Swedish"),
("3192","sv","bg","Шведски"),
("3193","sv","ca","Swedish"),
("3194","sv","cs","Švédský"),
("3195","sv","sk","Švédština"),
("3196","sv","cy","Swedish"),
("3197","sv","da","Swedish"),
("3198","sv","el","Σουηδικά"),
("3199","sv","eo","Swedish"),
("3200","sv","et","Swedish"),
("3201","sv","eu","Swedish"),
("3202","sv","fa","Swedish"),
("3203","sv","fi","Ruotsi"),
("3204","sv","ga","Swedish"),
("3205","sv","he","שוודית"),
("3206","sv","hi","Swedish"),
("3207","sv","hr","švedski"),
("3208","sv","hu","Svéd"),
("3209","sv","hy","Swedish"),
("3210","sv","id","Swedish"),
("3211","sv","is","Swedish"),
("3212","sv","it","Svedese"),
("3213","sv","ja","スウェーデン語"),
("3214","sv","ko","스웨덴어"),
("3215","sv","ku","Swedish"),
("3216","sv","lv","Swedish"),
("3217","sv","lt","Swedish"),
("3218","sv","mk","Swedish"),
("3219","sv","mt","Swedish"),
("3220","sv","mn","Swedish"),
("3221","sv","ne","Swedish"),
("3222","sv","nl","Zweeds"),
("3223","sv","no","Swedish"),
("3224","sv","pa","Swedish"),
("3225","sv","pl","Szwedzki"),
("3226","sv","pt-pt","Sueco"),
("3227","sv","pt-br","Sueco"),
("3228","sv","qu","Swedish"),
("3229","sv","ro","Suedeză"),
("3230","sv","ru","Шведский"),
("3231","sv","sl","Švedščina"),
("3232","sv","so","Swedish"),
("3233","sv","sq","Swedish"),
("3234","sv","sr","шведски"),
("3235","sv","sv","Svenska"),
("3236","sv","ta","Swedish"),
("3237","sv","th","สวีเดน"),
("3238","sv","tr","İsveççe"),
("3239","sv","uk","Swedish"),
("3240","sv","ur","Swedish"),
("3241","sv","uz","Swedish"),
("3242","sv","vi","Swedish"),
("3243","sv","yi","Swedish"),
("3244","sv","zh-hans","瑞典语"),
("3245","sv","zu","Swedish"),
("3246","sv","zh-hant","瑞典語"),
("3247","sv","ms","Swedish"),
("3248","sv","gl","Swedish"),
("3249","sv","bn","Swedish"),
("3250","sv","az","Swedish"),
("3251","ta","en","Tamil"),
("3252","ta","es","Tamil"),
("3253","ta","de","Tamil"),
("3254","ta","fr","Tamoul"),
("3255","ta","ar","التاميلية"),
("3256","ta","bs","Tamil"),
("3257","ta","bg","Тамилски"),
("3258","ta","ca","Tamil"),
("3259","ta","cs","Tamil"),
("3260","ta","sk","Tamilčina"),
("3261","ta","cy","Tamil"),
("3262","ta","da","Tamil"),
("3263","ta","el","Ταμίλ"),
("3264","ta","eo","Tamil"),
("3265","ta","et","Tamil"),
("3266","ta","eu","Tamil"),
("3267","ta","fa","Tamil"),
("3268","ta","fi","Tamili"),
("3269","ta","ga","Tamil"),
("3270","ta","he","טמילית"),
("3271","ta","hi","Tamil"),
("3272","ta","hr","Tamil"),
("3273","ta","hu","Tamil"),
("3274","ta","hy","Tamil"),
("3275","ta","id","Tamil"),
("3276","ta","is","Tamil"),
("3277","ta","it","Tamil"),
("3278","ta","ja","タミル語"),
("3279","ta","ko","타밀어"),
("3280","ta","ku","Tamil"),
("3281","ta","lv","Tamil"),
("3282","ta","lt","Tamil"),
("3283","ta","mk","Tamil"),
("3284","ta","mt","Tamil"),
("3285","ta","mn","Tamil"),
("3286","ta","ne","Tamil"),
("3287","ta","nl","Tamil"),
("3288","ta","no","Tamil"),
("3289","ta","pa","Tamil"),
("3290","ta","pl","Tamilski"),
("3291","ta","pt-pt","Tamil"),
("3292","ta","pt-br","Tamil"),
("3293","ta","qu","Tamil"),
("3294","ta","ro","Tamilă"),
("3295","ta","ru","Тамильский"),
("3296","ta","sl","Tamilščina"),
("3297","ta","so","Tamil"),
("3298","ta","sq","Tamil"),
("3299","ta","sr","тамилски"),
("3300","ta","sv","Tamil"),
("3301","ta","ta","Tamil"),
("3302","ta","th","ทมิฬ"),
("3303","ta","tr","Tamil dili"),
("3304","ta","uk","Tamil"),
("3305","ta","ur","Tamil"),
("3306","ta","uz","Tamil"),
("3307","ta","vi","Tamil"),
("3308","ta","yi","Tamil"),
("3309","ta","zh-hans","泰米尔语"),
("3310","ta","zu","Tamil"),
("3311","ta","zh-hant","泰米爾語"),
("3312","ta","ms","Tamil"),
("3313","ta","gl","Tamil"),
("3314","ta","bn","Tamil"),
("3315","ta","az","Tamil"),
("3316","th","en","Thai"),
("3317","th","es","Tailandés"),
("3318","th","de","Thai"),
("3319","th","fr","Thaï"),
("3320","th","ar","التايلندية"),
("3321","th","bs","Thai"),
("3322","th","bg","Тайски"),
("3323","th","ca","Thai"),
("3324","th","cs","Thai"),
("3325","th","sk","Thajština"),
("3326","th","cy","Thai"),
("3327","th","da","Thai"),
("3328","th","el","Ταϊλανδέζικα"),
("3329","th","eo","Thai"),
("3330","th","et","Thai"),
("3331","th","eu","Thai"),
("3332","th","fa","Thai"),
("3333","th","fi","Thai"),
("3334","th","ga","Thai"),
("3335","th","he","תאילנדית"),
("3336","th","hi","Thai"),
("3337","th","hr","Thai"),
("3338","th","hu","Tájföldi"),
("3339","th","hy","Thai"),
("3340","th","id","Thai"),
("3341","th","is","Thai"),
("3342","th","it","Thai"),
("3343","th","ja","タイ語"),
("3344","th","ko","태국어"),
("3345","th","ku","Thai"),
("3346","th","lv","Thai"),
("3347","th","lt","Thai"),
("3348","th","mk","Thai"),
("3349","th","mt","Thai"),
("3350","th","mn","Thai"),
("3351","th","ne","Thai"),
("3352","th","nl","Thai"),
("3353","th","no","Thai"),
("3354","th","pa","Thai"),
("3355","th","pl","Tajski"),
("3356","th","pt-pt","Tailandês"),
("3357","th","pt-br","Tailandês"),
("3358","th","qu","Thai"),
("3359","th","ro","Tailandeză"),
("3360","th","ru","Тайский"),
("3361","th","sl","Tajski"),
("3362","th","so","Thai"),
("3363","th","sq","Thai"),
("3364","th","sr","Тајландски"),
("3365","th","sv","Thailändska"),
("3366","th","ta","Thai"),
("3367","th","th","ไทย"),
("3368","th","tr","Tayca"),
("3369","th","uk","Thai"),
("3370","th","ur","Thai"),
("3371","th","uz","Thai"),
("3372","th","vi","Thai"),
("3373","th","yi","Thai"),
("3374","th","zh-hans","泰语"),
("3375","th","zu","Thai"),
("3376","th","zh-hant","泰語"),
("3377","th","ms","Thai"),
("3378","th","gl","Thai"),
("3379","th","bn","Thai"),
("3380","th","az","Thai"),
("3381","tr","en","Turkish"),
("3382","tr","es","Turco"),
("3383","tr","de","Türkisch"),
("3384","tr","fr","Turc"),
("3385","tr","ar","التركية"),
("3386","tr","bs","Turkish"),
("3387","tr","bg","Турски"),
("3388","tr","ca","Turkish"),
("3389","tr","cs","Turečtina"),
("3390","tr","sk","Turečtina"),
("3391","tr","cy","Turkish"),
("3392","tr","da","Turkish"),
("3393","tr","el","Τουρκικά"),
("3394","tr","eo","Turkish"),
("3395","tr","et","Turkish"),
("3396","tr","eu","Turkish"),
("3397","tr","fa","Turkish"),
("3398","tr","fi","Turkki"),
("3399","tr","ga","Turkish"),
("3400","tr","he","תורכית"),
("3401","tr","hi","Turkish"),
("3402","tr","hr","Turski"),
("3403","tr","hu","Török"),
("3404","tr","hy","Turkish"),
("3405","tr","id","Turkish"),
("3406","tr","is","Turkish"),
("3407","tr","it","Turco"),
("3408","tr","ja","トルコ語"),
("3409","tr","ko","터어키어"),
("3410","tr","ku","Turkish"),
("3411","tr","lv","Turkish"),
("3412","tr","lt","Turkish"),
("3413","tr","mk","Turkish"),
("3414","tr","mt","Turkish"),
("3415","tr","mn","Turkish"),
("3416","tr","ne","Turkish"),
("3417","tr","nl","Turks"),
("3418","tr","no","Turkish"),
("3419","tr","pa","Turkish"),
("3420","tr","pl","Turecki"),
("3421","tr","pt-pt","Turco"),
("3422","tr","pt-br","Turco"),
("3423","tr","qu","Turkish"),
("3424","tr","ro","Turcă"),
("3425","tr","ru","Турецкий"),
("3426","tr","sl","Turščina"),
("3427","tr","so","Turkish"),
("3428","tr","sq","Turkish"),
("3429","tr","sr","турски"),
("3430","tr","sv","Turkiska"),
("3431","tr","ta","Turkish"),
("3432","tr","th","ตุรกี"),
("3433","tr","tr","Türkçe"),
("3434","tr","uk","Turkish"),
("3435","tr","ur","Turkish"),
("3436","tr","uz","Turkish"),
("3437","tr","vi","Turkish"),
("3438","tr","yi","Turkish"),
("3439","tr","zh-hans","土耳其语"),
("3440","tr","zu","Turkish"),
("3441","tr","zh-hant","土耳其語"),
("3442","tr","ms","Turkish"),
("3443","tr","gl","Turkish"),
("3444","tr","bn","Turkish"),
("3445","tr","az","Turkish"),
("3446","uk","en","Ukrainian"),
("3447","uk","es","Ucraniano"),
("3448","uk","de","Ukrainisch"),
("3449","uk","fr","Ukrainien"),
("3450","uk","ar","الأوكرانية"),
("3451","uk","bs","Ukrainian"),
("3452","uk","bg","Украински"),
("3453","uk","ca","Ukrainian"),
("3454","uk","cs","Ukrajinský"),
("3455","uk","sk","Ukrajinčina"),
("3456","uk","cy","Ukrainian"),
("3457","uk","da","Ukrainian"),
("3458","uk","el","Ουκρανικά"),
("3459","uk","eo","Ukrainian"),
("3460","uk","et","Ukrainian"),
("3461","uk","eu","Ukrainian"),
("3462","uk","fa","Ukrainian"),
("3463","uk","fi","Ukraina"),
("3464","uk","ga","Ukrainian"),
("3465","uk","he","אוקראינית"),
("3466","uk","hi","Ukrainian"),
("3467","uk","hr","Ukrajinski"),
("3468","uk","hu","Ukrán"),
("3469","uk","hy","Ukrainian"),
("3470","uk","id","Ukrainian"),
("3471","uk","is","Ukrainian"),
("3472","uk","it","Ucraino"),
("3473","uk","ja","ウクライナ語"),
("3474","uk","ko","우크라이나어"),
("3475","uk","ku","Ukrainian"),
("3476","uk","lv","Ukrainian"),
("3477","uk","lt","Ukrainian"),
("3478","uk","mk","Ukrainian"),
("3479","uk","mt","Ukrainian"),
("3480","uk","mn","Ukrainian"),
("3481","uk","ne","Ukrainian"),
("3482","uk","nl","Oekraïens"),
("3483","uk","no","Ukrainsk"),
("3484","uk","pa","Ukrainian"),
("3485","uk","pl","Ukraiński"),
("3486","uk","pt-pt","Ucraniano"),
("3487","uk","pt-br","Ucraniano"),
("3488","uk","qu","Ukrainian"),
("3489","uk","ro","Ucrainiană"),
("3490","uk","ru","Украинский"),
("3491","uk","sl","Ukrajinski"),
("3492","uk","so","Ukrainian"),
("3493","uk","sq","Ukrainian"),
("3494","uk","sr","украјински"),
("3495","uk","sv","Ukrainska"),
("3496","uk","ta","Ukrainian"),
("3497","uk","th","ยูเครน"),
("3498","uk","tr","Ukraynaca"),
("3499","uk","uk","Українська"),
("3500","uk","ur","Ukrainian"),
("3501","uk","uz","Ukrainian"),
("3502","uk","vi","Ukrainian"),
("3503","uk","yi","Ukrainian"),
("3504","uk","zh-hans","乌克兰语"),
("3505","uk","zu","Ukrainian"),
("3506","uk","zh-hant","烏克蘭語"),
("3507","uk","ms","Ukrainian"),
("3508","uk","gl","Ukrainian"),
("3509","uk","bn","Ukrainian"),
("3510","uk","az","Ukrainian"),
("3511","ur","en","Urdu"),
("3512","ur","es","Urdu"),
("3513","ur","de","Urdu"),
("3514","ur","fr","Ourdu"),
("3515","ur","ar","الأردية"),
("3516","ur","bs","Urdu"),
("3517","ur","bg","Урду"),
("3518","ur","ca","Urdu"),
("3519","ur","cs","Urdu"),
("3520","ur","sk","Urdština"),
("3521","ur","cy","Urdu"),
("3522","ur","da","Urdu"),
("3523","ur","el","Ούρντου"),
("3524","ur","eo","Urdu"),
("3525","ur","et","Urdu"),
("3526","ur","eu","Urdu"),
("3527","ur","fa","Urdu"),
("3528","ur","fi","Urdu"),
("3529","ur","ga","Urdu"),
("3530","ur","he","אורדו"),
("3531","ur","hi","Urdu"),
("3532","ur","hr","Urdski"),
("3533","ur","hu","Urdu"),
("3534","ur","hy","Urdu"),
("3535","ur","id","Urdu"),
("3536","ur","is","Urdu"),
("3537","ur","it","Urdu"),
("3538","ur","ja","ウルドゥー語"),
("3539","ur","ko","우르두어"),
("3540","ur","ku","Urdu"),
("3541","ur","lv","Urdu"),
("3542","ur","lt","Urdu"),
("3543","ur","mk","Urdu"),
("3544","ur","mt","Urdu"),
("3545","ur","mn","Urdu"),
("3546","ur","ne","Urdu"),
("3547","ur","nl","Urdu"),
("3548","ur","no","Urdu"),
("3549","ur","pa","Urdu"),
("3550","ur","pl","Urdu"),
("3551","ur","pt-pt","Urdu"),
("3552","ur","pt-br","Urdu"),
("3553","ur","qu","Urdu"),
("3554","ur","ro","Urdu"),
("3555","ur","ru","Урду"),
("3556","ur","sl","Urdujščina"),
("3557","ur","so","Urdu"),
("3558","ur","sq","Urdu"),
("3559","ur","sr","урду"),
("3560","ur","sv","Urdu"),
("3561","ur","ta","Urdu"),
("3562","ur","th","อุรดู"),
("3563","ur","tr","Urduca"),
("3564","ur","uk","Urdu"),
("3565","ur","ur","اردو "),
("3566","ur","uz","Urdu"),
("3567","ur","vi","Urdu"),
("3568","ur","yi","Urdu"),
("3569","ur","zh-hans","乌尔都语"),
("3570","ur","zu","Urdu"),
("3571","ur","zh-hant","烏爾都語"),
("3572","ur","ms","Urdu"),
("3573","ur","gl","Urdu"),
("3574","ur","bn","Urdu"),
("3575","ur","az","Urdu"),
("3576","uz","en","Uzbek"),
("3577","uz","es","Uzbeko"),
("3578","uz","de","Usbekisch"),
("3579","uz","fr","Ouzbek"),
("3580","uz","ar","الاوزباكية"),
("3581","uz","bs","Uzbek"),
("3582","uz","bg","Узбекски"),
("3583","uz","ca","Uzbek"),
("3584","uz","cs","Uzbek"),
("3585","uz","sk","Uzbekčina"),
("3586","uz","cy","Uzbek"),
("3587","uz","da","Uzbek"),
("3588","uz","el","Ουζμπεκικά"),
("3589","uz","eo","Uzbek"),
("3590","uz","et","Uzbek"),
("3591","uz","eu","Uzbek"),
("3592","uz","fa","Uzbek"),
("3593","uz","fi","Uzbekki"),
("3594","uz","ga","Uzbek"),
("3595","uz","he","אוזבקית"),
("3596","uz","hi","Uzbek"),
("3597","uz","hr","Uzbečki"),
("3598","uz","hu","üzbég"),
("3599","uz","hy","Uzbek"),
("3600","uz","id","Uzbek"),
("3601","uz","is","Uzbek"),
("3602","uz","it","Uzbeco"),
("3603","uz","ja","ウズベク語"),
("3604","uz","ko","우즈베크어"),
("3605","uz","ku","Uzbek"),
("3606","uz","lv","Uzbek"),
("3607","uz","lt","Uzbek"),
("3608","uz","mk","Uzbek"),
("3609","uz","mt","Uzbek"),
("3610","uz","mn","Uzbek"),
("3611","uz","ne","Uzbek"),
("3612","uz","nl","Oezbeeks"),
("3613","uz","no","Usbekisk"),
("3614","uz","pa","Uzbek"),
("3615","uz","pl","Uzbecki"),
("3616","uz","pt-pt","Uzbeque"),
("3617","uz","pt-br","Uzbeque"),
("3618","uz","qu","Uzbek"),
("3619","uz","ro","Uzbecă"),
("3620","uz","ru","Узбекский"),
("3621","uz","sl","Uzbek"),
("3622","uz","so","Uzbek"),
("3623","uz","sq","Uzbek"),
("3624","uz","sr","Узбек"),
("3625","uz","sv","Uzbekiska"),
("3626","uz","ta","Uzbek"),
("3627","uz","th","อุซเบก"),
("3628","uz","tr","Özbekçe"),
("3629","uz","uk","Uzbek"),
("3630","uz","ur","Uzbek"),
("3631","uz","uz","Uzbek"),
("3632","uz","vi","Uzbek"),
("3633","uz","yi","Uzbek"),
("3634","uz","zh-hans","乌兹别克语"),
("3635","uz","zu","Uzbek"),
("3636","uz","zh-hant","烏茲別克語"),
("3637","uz","ms","Uzbek"),
("3638","uz","gl","Uzbek"),
("3639","uz","bn","Uzbek"),
("3640","uz","az","Uzbek"),
("3641","vi","en","Vietnamese"),
("3642","vi","es","Vietnamita"),
("3643","vi","de","Vietnamesisch"),
("3644","vi","fr","Vietnamien"),
("3645","vi","ar","الفيتنامية"),
("3646","vi","bs","Vietnamese"),
("3647","vi","bg","Виетнамски"),
("3648","vi","ca","Vietnamese"),
("3649","vi","cs","Vietnamský"),
("3650","vi","sk","Vietnamčina"),
("3651","vi","cy","Vietnamese"),
("3652","vi","da","Vietnamese"),
("3653","vi","el","Βιετναμέζικα"),
("3654","vi","eo","Vietnamese"),
("3655","vi","et","Vietnamese"),
("3656","vi","eu","Vietnamese"),
("3657","vi","fa","Vietnamese"),
("3658","vi","fi","Vietnam"),
("3659","vi","ga","Vietnamese"),
("3660","vi","he","וייטנאמית"),
("3661","vi","hi","Vietnamese"),
("3662","vi","hr","Vijetnamski"),
("3663","vi","hu","Vietnámi"),
("3664","vi","hy","Vietnamese"),
("3665","vi","id","Vietnamese"),
("3666","vi","is","Vietnamese"),
("3667","vi","it","Vietnamita"),
("3668","vi","ja","ベトナム語"),
("3669","vi","ko","베트남어"),
("3670","vi","ku","Vietnamese"),
("3671","vi","lv","Vietnamese"),
("3672","vi","lt","Vietnamese"),
("3673","vi","mk","Vietnamese"),
("3674","vi","mt","Vietnamese"),
("3675","vi","mn","Vietnamese"),
("3676","vi","ne","Vietnamese"),
("3677","vi","nl","Vietnamees"),
("3678","vi","no","Vietnamesisk"),
("3679","vi","pa","Vietnamese"),
("3680","vi","pl","Wietnamski"),
("3681","vi","pt-pt","Vietnamita"),
("3682","vi","pt-br","Vietnamita"),
("3683","vi","qu","Vietnamese"),
("3684","vi","ro","Vietnameză"),
("3685","vi","ru","Вьетнамский"),
("3686","vi","sl","Vietnamščina"),
("3687","vi","so","Vietnamese"),
("3688","vi","sq","Vietnamese"),
("3689","vi","sr","вијетнамски"),
("3690","vi","sv","Vietnamesiska"),
("3691","vi","ta","Vietnamese"),
("3692","vi","th","เวียดนาม"),
("3693","vi","tr","Vietnamca"),
("3694","vi","uk","Vietnamese"),
("3695","vi","ur","Vietnamese"),
("3696","vi","uz","Vietnamese"),
("3697","vi","vi","Tiếng Việt"),
("3698","vi","yi","Vietnamese"),
("3699","vi","zh-hans","越南语"),
("3700","vi","zu","Vietnamese"),
("3701","vi","zh-hant","越南語"),
("3702","vi","ms","Vietnamese"),
("3703","vi","gl","Vietnamese"),
("3704","vi","bn","Vietnamese"),
("3705","vi","az","Vietnamese"),
("3706","yi","en","Yiddish"),
("3707","yi","es","Yidis"),
("3708","yi","de","Jiddisch"),
("3709","yi","fr","Yiddish"),
("3710","yi","ar","اليديشية"),
("3711","yi","bs","Yiddish"),
("3712","yi","bg","Идиш"),
("3713","yi","ca","Yiddish"),
("3714","yi","cs","Jidiš"),
("3715","yi","sk","Jidiš"),
("3716","yi","cy","Yiddish"),
("3717","yi","da","Yiddish"),
("3718","yi","el","Γίντις"),
("3719","yi","eo","Yiddish"),
("3720","yi","et","Yiddish"),
("3721","yi","eu","Yiddish"),
("3722","yi","fa","Yiddish"),
("3723","yi","fi","Jiddi"),
("3724","yi","ga","Yiddish"),
("3725","yi","he","יידיש"),
("3726","yi","hi","Yiddish"),
("3727","yi","hr","Jidiš"),
("3728","yi","hu","Jiddis"),
("3729","yi","hy","Yiddish"),
("3730","yi","id","Yiddish"),
("3731","yi","is","Yiddish"),
("3732","yi","it","Yiddish"),
("3733","yi","ja","イディッシュ語"),
("3734","yi","ko","이디시어"),
("3735","yi","ku","Yiddish"),
("3736","yi","lv","Yiddish"),
("3737","yi","lt","Yiddish"),
("3738","yi","mk","Yiddish"),
("3739","yi","mt","Yiddish"),
("3740","yi","mn","Yiddish"),
("3741","yi","ne","Yiddish"),
("3742","yi","nl","Jiddisch"),
("3743","yi","no","Yiddish"),
("3744","yi","pa","Yiddish"),
("3745","yi","pl","Jidysz"),
("3746","yi","pt-pt","Yiddish"),
("3747","yi","pt-br","Yiddish"),
("3748","yi","qu","Yiddish"),
("3749","yi","ro","Idiş"),
("3750","yi","ru","Идиш"),
("3751","yi","sl","Jidiš"),
("3752","yi","so","Yiddish"),
("3753","yi","sq","Yiddish"),
("3754","yi","sr","јидиш"),
("3755","yi","sv","Jiddisch"),
("3756","yi","ta","Yiddish"),
("3757","yi","th","ยิชดิช"),
("3758","yi","tr","Eski İbranice"),
("3759","yi","uk","Yiddish"),
("3760","yi","ur","Yiddish"),
("3761","yi","uz","Yiddish"),
("3762","yi","vi","Yiddish"),
("3763","yi","yi","Yiddish"),
("3764","yi","zh-hans","依地语"),
("3765","yi","zu","Yiddish"),
("3766","yi","zh-hant","依地語"),
("3767","yi","ms","Yiddish"),
("3768","yi","gl","Yiddish"),
("3769","yi","bn","Yiddish"),
("3770","yi","az","Yiddish"),
("3771","zh-hans","en","Chinese (Simplified)"),
("3772","zh-hans","es","Chino simplificado"),
("3773","zh-hans","de","Vereinfachtes Chinesisch"),
("3774","zh-hans","fr","Chinois simplifié"),
("3775","zh-hans","ar","الصينية المبسطة"),
("3776","zh-hans","bs","Chinese (Simplified)"),
("3777","zh-hans","bg","Китайски  (опростен)"),
("3778","zh-hans","ca","Chinese (Simplified)"),
("3779","zh-hans","cs","Čínština ( Zjednodušený )"),
("3780","zh-hans","sk","Zjednodušená Čínština"),
("3781","zh-hans","cy","Chinese (Simplified)"),
("3782","zh-hans","da","Chinese (Simplified)"),
("3783","zh-hans","el","Κινεζικά (Απλοποιημένα)"),
("3784","zh-hans","eo","Chinese (Simplified)"),
("3785","zh-hans","et","Chinese (Simplified)"),
("3786","zh-hans","eu","Chinese (Simplified)"),
("3787","zh-hans","fa","Chinese (Simplified)"),
("3788","zh-hans","fi","Kiina"),
("3789","zh-hans","ga","Chinese (Simplified)"),
("3790","zh-hans","he","סינית"),
("3791","zh-hans","hi","Chinese (Simplified)"),
("3792","zh-hans","hr","Kineski (pojednostavljeni)"),
("3793","zh-hans","hu","Egyszerűsített kínai"),
("3794","zh-hans","hy","Chinese (Simplified)"),
("3795","zh-hans","id","Chinese (Simplified)"),
("3796","zh-hans","is","Chinese (Simplified)"),
("3797","zh-hans","it","Cinese semplificato"),
("3798","zh-hans","ja","簡体中国語"),
("3799","zh-hans","ko","중국어 간체"),
("3800","zh-hans","ku","Chinese (Simplified)"),
("3801","zh-hans","lv","Chinese (Simplified)"),
("3802","zh-hans","lt","Chinese (Simplified)"),
("3803","zh-hans","mk","Chinese (Simplified)"),
("3804","zh-hans","mt","Chinese (Simplified)"),
("3805","zh-hans","mn","Chinese (Simplified)"),
("3806","zh-hans","ne","Chinese (Simplified)"),
("3807","zh-hans","nl","Vereenvoudigd Chinees"),
("3808","zh-hans","no","Kinesisk (forenklet)"),
("3809","zh-hans","pa","Chinese (Simplified)"),
("3810","zh-hans","pl","Chiński uproszczony"),
("3811","zh-hans","pt-pt","Chinês (Simplificado)"),
("3812","zh-hans","pt-br","Chinês (Simplificado)"),
("3813","zh-hans","qu","Chinese (Simplified)"),
("3814","zh-hans","ro","Chineza simplificată"),
("3815","zh-hans","ru","Китайский (упрощенный)"),
("3816","zh-hans","sl","Kitajščina (poenostavljena )"),
("3817","zh-hans","so","Chinese (Simplified)"),
("3818","zh-hans","sq","Chinese (Simplified)"),
("3819","zh-hans","sr","Кинески (поједностављени)"),
("3820","zh-hans","sv","Förenklad kinesiska"),
("3821","zh-hans","ta","Chinese (Simplified)"),
("3822","zh-hans","th","จีนประยุกต์"),
("3823","zh-hans","tr","Modern Çince"),
("3824","zh-hans","uk","Chinese (Simplified)"),
("3825","zh-hans","ur","Chinese (Simplified)"),
("3826","zh-hans","uz","Chinese (Simplified)"),
("3827","zh-hans","vi","Chinese (Simplified)"),
("3828","zh-hans","yi","Chinese (Simplified)"),
("3829","zh-hans","zh-hans","简体中文"),
("3830","zh-hans","zu","Chinese (Simplified)"),
("3831","zh-hans","zh-hant","簡體中文"),
("3832","zh-hans","ms","Chinese (Simplified)"),
("3833","zh-hans","gl","Chinese (Simplified)"),
("3834","zh-hans","bn","Chinese (Simplified)"),
("3835","zh-hans","az","Chinese (Simplified)"),
("3836","zu","en","Zulu"),
("3837","zu","es","Zulú"),
("3838","zu","de","Zulu"),
("3839","zu","fr","Zoulou"),
("3840","zu","ar","الزولو"),
("3841","zu","bs","Zulu"),
("3842","zu","bg","Зулу"),
("3843","zu","ca","Zulu"),
("3844","zu","cs","Zulu"),
("3845","zu","sk","Jazyk Zulu"),
("3846","zu","cy","Zulu"),
("3847","zu","da","Zulu"),
("3848","zu","el","Ζουλού"),
("3849","zu","eo","Zulu"),
("3850","zu","et","Zulu"),
("3851","zu","eu","Zulu"),
("3852","zu","fa","Zulu"),
("3853","zu","fi","Zulu"),
("3854","zu","ga","Zulu"),
("3855","zu","he","זולו "),
("3856","zu","hi","Zulu"),
("3857","zu","hr","Zulu"),
("3858","zu","hu","Zulu"),
("3859","zu","hy","Zulu"),
("3860","zu","id","Zulu"),
("3861","zu","is","Zulu"),
("3862","zu","it","Zulu"),
("3863","zu","ja","ズールー語"),
("3864","zu","ko","줄루어"),
("3865","zu","ku","Zulu"),
("3866","zu","lv","Zulu"),
("3867","zu","lt","Zulu"),
("3868","zu","mk","Zulu"),
("3869","zu","mt","Zulu"),
("3870","zu","mn","Zulu"),
("3871","zu","ne","Zulu"),
("3872","zu","nl","Zulu"),
("3873","zu","no","Zulu"),
("3874","zu","pa","Zulu"),
("3875","zu","pl","Zuluski"),
("3876","zu","pt-pt","Zulu"),
("3877","zu","pt-br","Zulu"),
("3878","zu","qu","Zulu"),
("3879","zu","ro","Zulu"),
("3880","zu","ru","Зулу"),
("3881","zu","sl","Zulu"),
("3882","zu","so","Zulu"),
("3883","zu","sq","Zulu"),
("3884","zu","sr","зулу"),
("3885","zu","sv","Zulu"),
("3886","zu","ta","Zulu"),
("3887","zu","th","ซูลู"),
("3888","zu","tr","Zulu dili"),
("3889","zu","uk","Zulu"),
("3890","zu","ur","Zulu"),
("3891","zu","uz","Zulu"),
("3892","zu","vi","Zulu"),
("3893","zu","yi","Zulu"),
("3894","zu","zh-hans","祖鲁语"),
("3895","zu","zu","Zulu"),
("3896","zu","zh-hant","祖魯語"),
("3897","zu","ms","Zulu"),
("3898","zu","gl","Zulu"),
("3899","zu","bn","Zulu"),
("3900","zu","az","Zulu"),
("3901","zh-hant","en","Chinese (Traditional)"),
("3902","zh-hant","es","Chino tradicional"),
("3903","zh-hant","de","Traditionelles Chinesisch"),
("3904","zh-hant","fr","Chinois traditionnel"),
("3905","zh-hant","ar","الصينية التقليدية"),
("3906","zh-hant","bs","Chinese (Traditional)"),
("3907","zh-hant","bg","Китайски (традиционен)"),
("3908","zh-hant","ca","Chinese (Traditional)"),
("3909","zh-hant","cs","Čínština (tradiční )"),
("3910","zh-hant","sk","Tradičná Čínština"),
("3911","zh-hant","cy","Chinese (Traditional)"),
("3912","zh-hant","da","Chinese (Traditional)"),
("3913","zh-hant","el","Κινεζικά (Παραδοσιακά)"),
("3914","zh-hant","eo","Chinese (Traditional)"),
("3915","zh-hant","et","Chinese (Traditional)"),
("3916","zh-hant","eu","Chinese (Traditional)"),
("3917","zh-hant","fa","Chinese (Traditional)"),
("3918","zh-hant","fi","Perinteinen kiina"),
("3919","zh-hant","ga","Chinese (Traditional)"),
("3920","zh-hant","he","סינית מסורתית"),
("3921","zh-hant","hi","Chinese (Traditional)"),
("3922","zh-hant","hr","Kineski (tradicionalni)"),
("3923","zh-hant","hu","Hagyományos kínai"),
("3924","zh-hant","hy","Chinese (Traditional)"),
("3925","zh-hant","id","Chinese (Traditional)"),
("3926","zh-hant","is","Chinese (Traditional)"),
("3927","zh-hant","it","Cinese tradizionale"),
("3928","zh-hant","ja","繁体中国語"),
("3929","zh-hant","ko","중국어 번체"),
("3930","zh-hant","ku","Chinese (Traditional)"),
("3931","zh-hant","lv","Chinese (Traditional)"),
("3932","zh-hant","lt","Chinese (Traditional)"),
("3933","zh-hant","mk","Chinese (Traditional)"),
("3934","zh-hant","mt","Chinese (Traditional)"),
("3935","zh-hant","mn","Chinese (Traditional)"),
("3936","zh-hant","ne","Chinese (Traditional)"),
("3937","zh-hant","nl","Traditioneel Chinees"),
("3938","zh-hant","no","Kinesisk (tradisjonell)"),
("3939","zh-hant","pa","Chinese (Traditional)"),
("3940","zh-hant","pl","Chiński tradycyjny"),
("3941","zh-hant","pt-pt","Chinês (Tradicional)"),
("3942","zh-hant","pt-br","Chinês (Tradicional)"),
("3943","zh-hant","qu","Chinese (Traditional)"),
("3944","zh-hant","ro","Chineza tradiţională"),
("3945","zh-hant","ru","Китайский (традиционный)"),
("3946","zh-hant","sl","Kitajščina (tradicionalna)"),
("3947","zh-hant","so","Chinese (Traditional)"),
("3948","zh-hant","sq","Chinese (Traditional)"),
("3949","zh-hant","sr","Кинески (традиционални)"),
("3950","zh-hant","sv","Traditionell kinesiska"),
("3951","zh-hant","ta","Chinese (Traditional)"),
("3952","zh-hant","th","จีนดั้งเดิม"),
("3953","zh-hant","tr","Klasik Çince"),
("3954","zh-hant","uk","Chinese (Traditional)"),
("3955","zh-hant","ur","Chinese (Traditional)"),
("3956","zh-hant","uz","Chinese (Traditional)"),
("3957","zh-hant","vi","Chinese (Traditional)"),
("3958","zh-hant","yi","Chinese (Traditional)"),
("3959","zh-hant","zh-hans","繁体中文"),
("3960","zh-hant","zu","Chinese (Traditional)"),
("3961","zh-hant","zh-hant","繁體中文"),
("3962","zh-hant","ms","Chinese (Traditional)"),
("3963","zh-hant","gl","Chinese (Traditional)"),
("3964","zh-hant","bn","Chinese (Traditional)"),
("3965","zh-hant","az","Chinese (Traditional)"),
("3966","ms","en","Malay"),
("3967","ms","es","Malayo"),
("3968","ms","de","Malaiisch"),
("3969","ms","fr","Malay"),
("3970","ms","ar","لغة الملايو"),
("3971","ms","bs","Malay"),
("3972","ms","bg","Малайски"),
("3973","ms","ca","Malay"),
("3974","ms","cs","Malajský"),
("3975","ms","sk","Malay"),
("3976","ms","cy","Malay"),
("3977","ms","da","Malay"),
("3978","ms","el","Malay"),
("3979","ms","eo","Malay"),
("3980","ms","et","Malay"),
("3981","ms","eu","Malay"),
("3982","ms","fa","Malay"),
("3983","ms","fi","Malay"),
("3984","ms","ga","Malay"),
("3985","ms","he","מלאית"),
("3986","ms","hi","Malay"),
("3987","ms","hr","Malajski"),
("3988","ms","hu","Malay"),
("3989","ms","hy","Malay"),
("3990","ms","id","Malay"),
("3991","ms","is","Malay");

INSERT INTO `wp_icl_languages_translations` VALUES 
("3992","ms","it","Malay"),
("3993","ms","ja","Malay"),
("3994","ms","ko","Malay"),
("3995","ms","ku","Malay"),
("3996","ms","lv","Malay"),
("3997","ms","lt","Malay"),
("3998","ms","mk","Malay"),
("3999","ms","mt","Malay"),
("4000","ms","mn","Malay"),
("4001","ms","ne","Malay"),
("4002","ms","nl","Malay"),
("4003","ms","no","Malay"),
("4004","ms","pa","Malay"),
("4005","ms","pl","Malay"),
("4006","ms","pt-pt","Malaio"),
("4007","ms","pt-br","Malaio"),
("4008","ms","qu","Malay"),
("4009","ms","ro","Malay"),
("4010","ms","ru","Малайский"),
("4011","ms","sl","Malajščina"),
("4012","ms","so","Malay"),
("4013","ms","sq","Malay"),
("4014","ms","sr","малајски"),
("4015","ms","sv","Malay"),
("4016","ms","ta","Malay"),
("4017","ms","th","Malay"),
("4018","ms","tr","Malay"),
("4019","ms","uk","Malay"),
("4020","ms","ur","Malay"),
("4021","ms","uz","Malay"),
("4022","ms","vi","Malay"),
("4023","ms","yi","Malay"),
("4024","ms","zh-hans","Malay"),
("4025","ms","zu","Malay"),
("4026","ms","zh-hant","Malay"),
("4027","ms","ms","Melayu"),
("4028","ms","gl","Malay"),
("4029","ms","bn","Malay"),
("4030","ms","az","Malay"),
("4031","gl","en","Galician"),
("4032","gl","es","Gallego"),
("4033","gl","de","Galicisch"),
("4034","gl","fr","Galicien"),
("4035","gl","ar","Galician"),
("4036","gl","bs","Galician"),
("4037","gl","bg","Galician"),
("4038","gl","ca","Galician"),
("4039","gl","cs","Galician"),
("4040","gl","sk","Galician"),
("4041","gl","cy","Galician"),
("4042","gl","da","Galician"),
("4043","gl","el","Galician"),
("4044","gl","eo","Galician"),
("4045","gl","et","Galician"),
("4046","gl","eu","Galician"),
("4047","gl","fa","Galician"),
("4048","gl","fi","Galician"),
("4049","gl","ga","Galician"),
("4050","gl","he","Galician"),
("4051","gl","hi","Galician"),
("4052","gl","hr","Galician"),
("4053","gl","hu","Galician"),
("4054","gl","hy","Galician"),
("4055","gl","id","Galician"),
("4056","gl","is","Galician"),
("4057","gl","it","Gallego"),
("4058","gl","ja","Galician"),
("4059","gl","ko","Galician"),
("4060","gl","ku","Galician"),
("4061","gl","lv","Galician"),
("4062","gl","lt","Galician"),
("4063","gl","mk","Galician"),
("4064","gl","mt","Galician"),
("4065","gl","mn","Galician"),
("4066","gl","ne","Galician"),
("4067","gl","nl","Galician"),
("4068","gl","no","Galician"),
("4069","gl","pa","Galician"),
("4070","gl","pl","Galician"),
("4071","gl","pt-pt","Galego"),
("4072","gl","pt-br","Galego"),
("4073","gl","qu","Galician"),
("4074","gl","ro","Galician"),
("4075","gl","ru","Галисийский"),
("4076","gl","sl","Galician"),
("4077","gl","so","Galician"),
("4078","gl","sq","Galician"),
("4079","gl","sr","Galician"),
("4080","gl","sv","Galician"),
("4081","gl","ta","Galician"),
("4082","gl","th","Galician"),
("4083","gl","tr","Galician"),
("4084","gl","uk","Galician"),
("4085","gl","ur","Galician"),
("4086","gl","uz","Galician"),
("4087","gl","vi","Galician"),
("4088","gl","yi","Galician"),
("4089","gl","zh-hans","Galician"),
("4090","gl","zu","Galician"),
("4091","gl","zh-hant","Galician"),
("4092","gl","ms","Galician"),
("4093","gl","gl","Galego"),
("4094","gl","bn","Galician"),
("4095","gl","az","Galician"),
("4096","bn","en","Bengali"),
("4097","bn","es","Bengalí"),
("4098","bn","de","Bengalisch"),
("4099","bn","fr","Bengali"),
("4100","bn","ar","Bengali"),
("4101","bn","bs","Bengali"),
("4102","bn","bg","Bengali"),
("4103","bn","ca","Bengali"),
("4104","bn","cs","Bengali"),
("4105","bn","sk","Bengali"),
("4106","bn","cy","Bengali"),
("4107","bn","da","Bengali"),
("4108","bn","el","Bengali"),
("4109","bn","eo","Bengali"),
("4110","bn","et","Bengali"),
("4111","bn","eu","Bengali"),
("4112","bn","fa","Bengali"),
("4113","bn","fi","Bengali"),
("4114","bn","ga","Bengali"),
("4115","bn","he","Bengali"),
("4116","bn","hi","Bengali"),
("4117","bn","hr","Bengali"),
("4118","bn","hu","Bengali"),
("4119","bn","hy","Bengali"),
("4120","bn","id","Bengali"),
("4121","bn","is","Bengali"),
("4122","bn","it","Bengalese"),
("4123","bn","ja","Bengali"),
("4124","bn","ko","Bengali"),
("4125","bn","ku","Bengali"),
("4126","bn","lv","Bengali"),
("4127","bn","lt","Bengali"),
("4128","bn","mk","Bengali"),
("4129","bn","mt","Bengali"),
("4130","bn","mn","Bengali"),
("4131","bn","ne","Bengali"),
("4132","bn","nl","Bengali"),
("4133","bn","no","Bengali"),
("4134","bn","pa","Bengali"),
("4135","bn","pl","Bengali"),
("4136","bn","pt-pt","Bengalês"),
("4137","bn","pt-br","Bengalês"),
("4138","bn","qu","Bengali"),
("4139","bn","ro","Bengali"),
("4140","bn","ru","Бенгальский"),
("4141","bn","sl","Bengali"),
("4142","bn","so","Bengali"),
("4143","bn","sq","Bengali"),
("4144","bn","sr","Bengali"),
("4145","bn","sv","Bengali"),
("4146","bn","ta","Bengali"),
("4147","bn","th","Bengali"),
("4148","bn","tr","Bengali"),
("4149","bn","uk","Bengali"),
("4150","bn","ur","Bengali"),
("4151","bn","uz","Bengali"),
("4152","bn","vi","Bengali"),
("4153","bn","yi","Bengali"),
("4154","bn","zh-hans","Bengali"),
("4155","bn","zu","Bengali"),
("4156","bn","zh-hant","Bengali"),
("4157","bn","ms","Bengali"),
("4158","bn","gl","Bengali"),
("4159","bn","bn","বাংলাদেশ"),
("4160","bn","az","Bengali"),
("4161","az","en","Azerbaijani"),
("4162","az","es","Azerí"),
("4163","az","de","Aserbeidschanisch"),
("4164","az","fr","Azéri"),
("4165","az","ar","الأذربيجانية"),
("4166","az","bs","Azerbaijani"),
("4167","az","bg","Azerbaijani"),
("4168","az","ca","Azerbaijani"),
("4169","az","cs","Azerbaijani"),
("4170","az","sk","Azerbaijani"),
("4171","az","cy","Azerbaijani"),
("4172","az","da","Azerbaijani"),
("4173","az","el","Azerbaijani"),
("4174","az","eo","Azerbaijani"),
("4175","az","et","Azerbaijani"),
("4176","az","eu","Azerbaijani"),
("4177","az","fa","Azerbaijani"),
("4178","az","fi","Azerbaijani"),
("4179","az","ga","Azerbaijani"),
("4180","az","he","אזרביג\'נית"),
("4181","az","hi","Azerbaijani"),
("4182","az","hr","Azerbaijani"),
("4183","az","hu","Azerbaijani"),
("4184","az","hy","Azerbaijani"),
("4185","az","id","Azerbaijani"),
("4186","az","is","Azerbaijani"),
("4187","az","it","Azerbaigiano"),
("4188","az","ja","アゼルバイジャン語"),
("4189","az","ko","Azerbaijani"),
("4190","az","ku","Azerbaijani"),
("4191","az","lv","Azerbaijani"),
("4192","az","lt","Azerbaijani"),
("4193","az","mk","Azerbaijani"),
("4194","az","mt","Azerbaijani"),
("4195","az","mn","Azerbaijani"),
("4196","az","ne","Azerbaijani"),
("4197","az","nl","Azerbaijani"),
("4198","az","no","Azerbaijani"),
("4199","az","pa","Azerbaijani"),
("4200","az","pl","Azerski"),
("4201","az","pt-pt","Azerbaijano"),
("4202","az","pt-br","Azerbaijano"),
("4203","az","qu","Azerbaijani"),
("4204","az","ro","Azerbaijani"),
("4205","az","ru","Азербайджанский"),
("4206","az","sl","Azerbaijani"),
("4207","az","so","Azerbaijani"),
("4208","az","sq","Azerbaijani"),
("4209","az","sr","Azerbaijani"),
("4210","az","sv","Azerbaijani"),
("4211","az","ta","Azerbaijani"),
("4212","az","th","Azerbaijani"),
("4213","az","tr","Azerbaijani"),
("4214","az","uk","Azerbaijani"),
("4215","az","ur","Azerbaijani"),
("4216","az","uz","Azerbaijani"),
("4217","az","vi","Azerbaijani"),
("4218","az","yi","Azerbaijani"),
("4219","az","zh-hans","阿塞拜疆语"),
("4220","az","zu","Azerbaijani"),
("4221","az","zh-hant","Azerbaijani"),
("4222","az","ms","Azerbaijani"),
("4223","az","gl","Azerbaijani"),
("4224","az","bn","Azerbaijani"),
("4225","az","az","Azərbaycan");

INSERT INTO `wp_icl_locale_map` VALUES 
("da","da_DK"),
("en","en_US");

INSERT INTO `wp_icl_mo_files_domains` VALUES 
("1","wp-content\\plugins\\advanced-custom-fields-table-field\\lang\\acf-table-da_DK.mo","07c328ccfe5e19f72de995bde312036e","acf-table","not_imported","0","1615360998","plugin","advanced-custom-fields-table-field/acf-table.php"),
("2","wp-content\\languages\\da_DK.mo","6941a0e905106caa37d26c234a0314b2","default","not_imported","0","1618771073","other",""),
("3","wp-content\\plugins\\real-media-library\\vendor\\matthiasweb\\wordpress-plugin-updater\\plugin-update-checker-4.4\\languages\\plugin-update-checker-da_DK.mo","d27af8f6216e9564d58b474fd0f9e82a","plugin-update-checker","not_imported","0","1617176096","plugin","real-media-library/index.php"),
("4","wp-content\\languages\\admin-da_DK.mo","60f647ad42a6b08cb26a7ce5da5cbe27","default","not_imported","0","1618771073","other",""),
("5","wp-content\\languages\\da_DK-320f4ad9792aaa6dedb1e71cbdf85d57.json","5e818885d36c3f303f822f68eaa730b3","default-wp-a11y","not_imported","0","1618771073","other",""),
("6","wp-content\\languages\\da_DK-81c889563f09dd13de1701135dc62941.json","d471083e38f8eafb76c533cb3c09e8bd","default-media-views","not_imported","0","1618771073","other",""),
("7","wp-content\\languages\\da_DK-77fdfadaf2e1ca3a027d1956b910bc50.json","78b4469b3dea2f70830556488db18bf8","default-common","not_imported","0","1618771073","other",""),
("8","wp-content\\languages\\da_DK-93882e8f9976382d7f724ac595ed7151.json","461d9a99f1d2339cf6190cbbdb3ba1e9","default-wp-auth-check","not_imported","0","1618771073","other",""),
("9","wp-content\\languages\\da_DK-f575f481034e90e21d832e415fd95fcf.json","6d71e8527c7a5e09a3408f12526be409","default-media-editor","not_imported","0","1618771073","other",""),
("10","wp-content\\languages\\da_DK-1d17475f620f63a92e2c5d2681c51ee8.json","379ac0e7e1537dfd79e78a535abb3e03","default-image-edit","not_imported","0","1618771073","other",""),
("11","wp-content\\languages\\da_DK-7d5ca435e60d92f024d46c9257aaa0f7.json","48f081a5c414d944f43ac374edaa79fe","default-tags-suggest","not_imported","0","1618562139","other",""),
("12","wp-content\\languages\\da_DK-9b256ea9cd54df92095e04c76758ceb0.json","bb029278e3a7fb4782b07484cb45f076","default-inline-edit-post","not_imported","0","1618562139","other",""),
("13","wp-content\\languages\\da_DK-50278328b502f4eb3f2b8b7ab49324a1.json","7aa515bed5eb8149910a623b3b8a022b","default-postbox","not_imported","0","1618562139","other",""),
("14","wp-content\\languages\\da_DK-9d47a87c240c1d10701cd6a02b28aa1b.json","5a99100cc3f8154a7038a02bc1697304","default-tags-box","not_imported","0","1618562139","other",""),
("15","wp-content\\languages\\da_DK-569e85ef168299eb8c8f24d8ef8c8a78.json","2c0c22e72b8ba35fd49256fe5e5ad10c","default-post","not_imported","0","1618562139","other",""),
("16","wp-content\\languages\\da_DK-9c3519f4870fac83dc0dbf18cb6bd4c4.json","f94b09b062fc8a5f27094e9fdb83c6d2","default-wp-color-picker","not_imported","0","1618771073","other",""),
("17","wp-content\\languages\\da_DK-0eebe503220d4a00341eb011b92769b4.json","8c8a60e9723140c83428fa1ec8c4b19f","default-password-strength-meter","not_imported","0","1618562139","other",""),
("18","wp-content\\languages\\da_DK-81d6f084cb273e02e15b01bd9ece87f7.json","123907a4ea17e717053ef80acaa69bae","default-user-profile","not_imported","0","1618562139","other",""),
("19","wp-content\\languages\\da_DK-bf23b24175490c2e46aaf92ff6a0c70f.json","6a6b6a9d02b0df69bf2e7484374bbdeb","default-wp-pointer","not_imported","0","1618562139","other",""),
("20","wp-content\\languages\\da_DK-a25d1cc7bf7ca0b4e114f6bea64943f4.json","726cbde9012e60fa40dbe4eaabfde1ea","default-wp-keycodes","not_imported","0","1618562139","other",""),
("21","wp-content\\languages\\da_DK-1a0cd6a7128913b15c1a10dd68951869.json","ff0330ed49440a3b919c61872d02fd6d","default-wp-blocks","not_imported","0","1618562139","other",""),
("22","wp-content\\languages\\da_DK-7f13c36c641b114bf18cd0bcc9ecc7e0.json","e68773046171c2b09b454580bd0baa37","default-wp-components","not_imported","0","1618562139","other",""),
("23","wp-content\\languages\\da_DK-803bf1ce2131e13efc590c1bc47851fc.json","6f74e1619d493da02e26894232649e2a","default-wp-block-editor","not_imported","0","1618562139","other",""),
("24","wp-content\\languages\\da_DK-1bba9045bb07c89671c88a3f328548e8.json","33e999c2e39f1c4a9e557df6d09e9e72","default-wp-api-fetch","not_imported","0","1618562139","other",""),
("25","wp-content\\languages\\da_DK-49c6d4acf36cf3aca9f0b2a77617304f.json","60cd403fca5ddb3e0dadafdebb97e3a5","default-wp-core-data","not_imported","0","1618562139","other",""),
("26","wp-content\\languages\\da_DK-1780a2033cf98d69ce13c2e5c8510004.json","63e713333da3656b01c5903b6d025152","default-wp-reusable-blocks","not_imported","0","1618562139","other",""),
("27","wp-content\\languages\\da_DK-e2791ba830489d23043be8650a22a22b.json","9c7d424f0d5c894fa7f714be9e71a452","default-wp-server-side-render","not_imported","0","1618562139","other",""),
("28","wp-content\\languages\\da_DK-f8f49d9fc4a9cf7d78ec99285417bd9c.json","ff61bc9f275e9a97053957751a76d570","default-wp-block-library","not_imported","0","1618562139","other",""),
("29","wp-content\\languages\\da_DK-daeb084aab42199d26393a56c3465bc0.json","e06a64ed6fcc9ffa4bf68cae40411d02","default-wp-media-utils","not_imported","0","1618562139","other",""),
("30","wp-content\\languages\\da_DK-bf0f094965d3d4a95b47babcb35fc136.json","4883a7912bf50c933ef1b8923aac483e","default-wp-editor","not_imported","0","1618562139","other",""),
("31","wp-content\\languages\\da_DK-8860e58c20c6a2ab5876a0f07be43bd9.json","ca00c4c21216ba70919fd3c773ef1833","default-wp-edit-post","not_imported","0","1618562139","other",""),
("32","wp-content\\languages\\da_DK-68f2cec7514bf8563c723a4d675fcfe6.json","5f119f1d1ee1491314bdfae2e5ddc34a","default-wp-format-library","not_imported","0","1618562139","other",""),
("33","wp-content\\languages\\da_DK-947c76bb5095da30e16668eec15406b2.json","d1df5bc5cddec675d3a06cf6409fe7df","default-wp-block-directory","not_imported","0","1618562139","other",""),
("34","wp-content\\languages\\continents-cities-da_DK.mo","094c85624e366115de1b221eba6e131f","continents-cities","not_imported","0","1618562139","other",""),
("35","wp-content\\languages\\da_DK-a9dc201dcd011fe71849743133052619.json","89c06df31c61ea554651ee2d2dd161fc","default-nav-menu","not_imported","0","1618562139","other",""),
("36","wp-content\\languages\\da_DK-2b390f85a3048c5b4255fb45960b6514.json","e90f6bd87012e077c912c1864e0bbb62","default-updates","not_imported","0","1618771073","other",""),
("37","wp-content\\languages\\da_DK-7436b7ee9e4f11ac0d618d8cc886eb66.json","98e523b5230604852b77d7ed2f0321ae","default-plugin-install","not_imported","0","1618771073","other",""),
("38","wp-content\\languages\\plugins\\duplicate-post-da_DK.mo","1092e60ef656509aaf5a8826b279236c","duplicate-post","not_imported","0","1618771078","plugin","duplicate-post/duplicate-post.php"),
("39","wp-content/plugins/advanced-custom-fields-table-field/lang/acf-table-da_DK.mo","2e261604c46fad2921b67c2c7f262fe7","acf-table","not_imported","0","1618778514","plugin","advanced-custom-fields-table-field/acf-table.php"),
("40","wp-content/languages/plugins/duplicate-post-da_DK.mo","7e40a654690ddb80ca2ba329b5fb370c","duplicate-post","not_imported","0","1618778514","plugin","duplicate-post/duplicate-post.php"),
("41","wp-content/languages/da_DK.mo","bd64ebfa57da4a7590c2d35e1aca5695","default","not_imported","0","1618778514","other",""),
("42","wp-content/plugins/real-media-library/vendor/matthiasweb/wordpress-plugin-updater/plugin-update-checker-4.4/languages/plugin-update-checker-da_DK.mo","3ea3e156d0bdf70694df11b558577208","plugin-update-checker","not_imported","0","1618778516","plugin","real-media-library/index.php"),
("43","wp-content/languages/da_DK-0eebe503220d4a00341eb011b92769b4.json","2bbbde1cfbde106240549d5a8ef66a42","default-password-strength-meter","not_imported","0","1618778514","other",""),
("44","wp-content/languages/da_DK-81d6f084cb273e02e15b01bd9ece87f7.json","7c4465349d89e7819d7b7d182a117547","default-user-profile","not_imported","0","1618778514","other",""),
("45","wp-content/languages/admin-da_DK.mo","24691194ee620ec7e35031935099184e","default","not_imported","0","1618778514","other",""),
("46","wp-content/languages/da_DK-320f4ad9792aaa6dedb1e71cbdf85d57.json","a8627b2cefd3d93d29f33c0cc7934bff","default-wp-a11y","not_imported","0","1618778514","other",""),
("47","wp-content/languages/da_DK-81c889563f09dd13de1701135dc62941.json","36cc82e3bda8dd6460773dd257775373","default-media-views","not_imported","0","1618778514","other",""),
("48","wp-content/languages/da_DK-77fdfadaf2e1ca3a027d1956b910bc50.json","92be1d9811a8d926327469cba7370267","default-common","not_imported","0","1618778514","other",""),
("49","wp-content/languages/da_DK-93882e8f9976382d7f724ac595ed7151.json","c57078eb8129a54970dd5568b9956cc4","default-wp-auth-check","not_imported","0","1618778514","other",""),
("50","wp-content/languages/da_DK-f575f481034e90e21d832e415fd95fcf.json","8e8d876c3bad4a9d933d8f90ceb9c9d0","default-media-editor","not_imported","0","1618778514","other",""),
("51","wp-content/languages/da_DK-1d17475f620f63a92e2c5d2681c51ee8.json","39c63e34a5bc488478cadaae3614e117","default-image-edit","not_imported","0","1618778514","other",""),
("52","wp-content/languages/da_DK-4a38fe1c0c45989e44682ba6109d9f46.json","8ad4db6d8b283f7095bb827f533d3986","default-site-health","not_imported","0","1618778514","other",""),
("53","wp-content/languages/da_DK-6025add6bde16aaeb12787d250f9b414.json","94bc9a9511a14ede88457f30a3367d36","default-admin-comments","not_imported","0","1618778514","other",""),
("54","wp-content/languages/da_DK-50278328b502f4eb3f2b8b7ab49324a1.json","bb00d7bb80523d7930bcefcec852bc3b","default-postbox","not_imported","0","1618778514","other",""),
("55","wp-content/languages/da_DK-e2e4c4b80f3adf2c70b431bfdb1b4872.json","c62b807903e546cda1e9d460622a7647","default-dashboard","not_imported","0","1618778514","other",""),
("56","wp-content/languages/da_DK-7436b7ee9e4f11ac0d618d8cc886eb66.json","64604b0f2263ffb6d332c729ecb6f669","default-plugin-install","not_imported","0","1618778514","other",""),
("57","wp-content/languages/da_DK-2b390f85a3048c5b4255fb45960b6514.json","737b713cd266199b945311be93a4f07a","default-updates","not_imported","0","1618778514","other",""),
("58","wp-content/languages/da_DK-9c3519f4870fac83dc0dbf18cb6bd4c4.json","c6050b29d05a7cab1f0abebb0abac6b0","default-wp-color-picker","not_imported","0","1618778514","other",""),
("59","wp-content/languages/da_DK-7d5ca435e60d92f024d46c9257aaa0f7.json","643e218add3d60860f796a18b0872e2b","default-tags-suggest","not_imported","0","1618778514","other",""),
("60","wp-content/languages/da_DK-9d47a87c240c1d10701cd6a02b28aa1b.json","7e96cea81a95c74d6011904626374077","default-tags-box","not_imported","0","1618778514","other",""),
("61","wp-content/languages/da_DK-569e85ef168299eb8c8f24d8ef8c8a78.json","27f21c4a1172d2d234ad7f885b190cc4","default-post","not_imported","0","1618778514","other",""),
("62","wp-content/languages/da_DK-9b256ea9cd54df92095e04c76758ceb0.json","8648c8b6c9ab5dbc1fb9ed1ccc3d5a14","default-inline-edit-post","not_imported","0","1618778514","other",""),
("63","wp-content/languages/da_DK-a25d1cc7bf7ca0b4e114f6bea64943f4.json","90933e53f2e9bc383ad84bf85dbb0b17","default-wp-keycodes","not_imported","0","1618778514","other",""),
("64","wp-content/languages/da_DK-1a0cd6a7128913b15c1a10dd68951869.json","5625571a643c7d5f2c50e50a7ecd7036","default-wp-blocks","not_imported","0","1618778514","other",""),
("65","wp-content/languages/da_DK-7f13c36c641b114bf18cd0bcc9ecc7e0.json","6810d63511a5a99ed25356ea16c411c2","default-wp-components","not_imported","0","1618778514","other",""),
("66","wp-content/languages/da_DK-803bf1ce2131e13efc590c1bc47851fc.json","6a301ac5e4a679fbbd1ecab1697a8792","default-wp-block-editor","not_imported","0","1618778514","other",""),
("67","wp-content/languages/da_DK-1bba9045bb07c89671c88a3f328548e8.json","f76dfdbf2fdbc87318d78e479412f140","default-wp-api-fetch","not_imported","0","1618778514","other",""),
("68","wp-content/languages/da_DK-49c6d4acf36cf3aca9f0b2a77617304f.json","3281c8b84d68f8e432080ad90ccafe8d","default-wp-core-data","not_imported","0","1618778514","other",""),
("69","wp-content/languages/da_DK-1780a2033cf98d69ce13c2e5c8510004.json","d54ca8b4e01aa7e00a56668877a74184","default-wp-reusable-blocks","not_imported","0","1618778514","other",""),
("70","wp-content/languages/da_DK-e2791ba830489d23043be8650a22a22b.json","0bffe58bfdb0024f9b05753d0ad73fee","default-wp-server-side-render","not_imported","0","1618778514","other",""),
("71","wp-content/languages/da_DK-f8f49d9fc4a9cf7d78ec99285417bd9c.json","ee7e4e1bc7c5c897defc965b542cc318","default-wp-block-library","not_imported","0","1618778514","other",""),
("72","wp-content/languages/da_DK-daeb084aab42199d26393a56c3465bc0.json","c718651e6ee2560c4fa1c2e0cb08c1ad","default-wp-media-utils","not_imported","0","1618778514","other",""),
("73","wp-content/languages/da_DK-bf0f094965d3d4a95b47babcb35fc136.json","1bfd7f526f8094ea27ecc72537f30212","default-wp-editor","not_imported","0","1618778514","other",""),
("74","wp-content/languages/da_DK-8860e58c20c6a2ab5876a0f07be43bd9.json","45ae091cf006616ca71917b7095fe552","default-wp-edit-post","not_imported","0","1618778514","other",""),
("75","wp-content/languages/da_DK-68f2cec7514bf8563c723a4d675fcfe6.json","5be4f22d8e64d19f95422024b32cfb09","default-wp-format-library","not_imported","0","1618778514","other",""),
("76","wp-content/languages/da_DK-947c76bb5095da30e16668eec15406b2.json","ed907fc20880834ebf5dd97dc461b853","default-wp-block-directory","not_imported","0","1618778514","other",""),
("77","wp-content/languages/da_DK-7b74c8457eaa7fcc50db41b431f8a003.json","378ff918b6b94019472b41dc39e8beef","default-admin-tags","not_imported","0","1618778514","other",""),
("78","wp-content/languages/da_DK-ca28138671823450e87dfd354f7afc6b.json","9192e3ff091cce446f45f487ef34a2b7","default-inline-edit-tax","not_imported","0","1618778514","other",""),
("79","wp-content/languages/da_DK-a9dc201dcd011fe71849743133052619.json","c503c24ab0471ce268a4aa1c8c6e1bcb","default-nav-menu","not_imported","0","1618778514","other",""),
("80","wp-content/languages/da_DK-bf23b24175490c2e46aaf92ff6a0c70f.json","fb9be4fe286e0359181b7edb933239d4","default-wp-pointer","not_imported","0","1618778514","other",""),
("81","wp-content/languages/continents-cities-da_DK.mo","c44c62ce5944211c8d0ecabdb6d4a4cf","continents-cities","not_imported","0","1618778514","other",""),
("82","wp-content/languages/da_DK-7289286ed59e90a8f36ae797df62220b.json","1ee2189ef95508d7cfd89ea80f0e88c9","default-media","not_imported","0","1618778514","other","");

INSERT INTO `wp_icl_string_packages` VALUES 
("1","gutenberg","Gutenberg","1248","Page Builder Page 1248","","","1248","{\"total\":8,\"to_translate\":{\"da\":8}}");

INSERT INTO `wp_icl_string_translations` VALUES 
("1","148","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("2","149","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("3","150","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("4","151","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42");

INSERT INTO `wp_icl_strings` VALUES 
("1","en","admin_texts_cptui_post_types","[cptui_post_types][country]label","Milo - Countries",NULL,NULL,"","LINE",NULL,"0","","dfef94161687439f939aa8069f867541","optional",NULL),
("2","en","admin_texts_cptui_post_types","[cptui_post_types][country]singular_label","Country",NULL,NULL,"","LINE",NULL,"0","","ec9015367efd4ad9fb17e017f933e15a","optional",NULL),
("3","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","396d00a8c8b9166d549963010dc6c4f2","optional",NULL),
("4","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","cf7e0ab11faf0a560d6fd7ff94f137bb","optional",NULL),
("5","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","8cca295183875672b82db44972d90258","optional",NULL),
("6","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","52de426c43bd190cff8c890acecf923f","optional",NULL),
("7","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","41ab37f403c20c1240659704ddef3101","optional",NULL),
("8","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","a496bceab1501e319e92b77264b1b0f6","optional",NULL),
("9","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","9137e5a7028c44e8abfa4dcdd351c698","optional",NULL),
("10","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","be40c292dec6f038ccc9da5c0173cfeb","optional",NULL),
("11","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","40c495a8a91e06a46d170e8265b444e1","optional",NULL),
("12","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","fb5b2d7ab80b9d1a0bbcd39144d50bf6","optional",NULL),
("13","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","40cc57caf57e99e67420752661f9878f","optional",NULL),
("14","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","971136ef1e6d74e87a745ed270937784","optional",NULL),
("15","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","58e8f85b14c3025b7494af6fd24108e2","optional",NULL),
("16","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","e7b2b4cf37078c4115b05346e2d13a08","optional",NULL),
("17","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","da75256312552a3390e8b6c9421ecb54","optional",NULL),
("18","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","300facef9fc72b63316d5632aef04107","optional",NULL),
("19","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","18af464b300fb289f9e4598eefd7c360","optional",NULL),
("20","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","67dce5a7a7fdf6609a4f00d7fce85d25","optional",NULL),
("21","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","0a3a70bf737cdd6fea820dfd567faead","optional",NULL),
("22","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","06d3af4116528186bab053e22a31f870","optional",NULL),
("23","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","778f68620245bf3d61c5e421347460d0","optional",NULL),
("24","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","caca95e26513cf2466ffa7bf873c600c","optional",NULL),
("25","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","b1d0184a9febb9c0a4224fb1cc16ad69","optional",NULL),
("26","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","9772893cee6e7a4c9583d0185d089cc8","optional",NULL),
("27","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","87ae6899efc1e5085ee6e2f930c42ac9","optional",NULL),
("28","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","27d45f817fee1fbe88178e6698c887f1","optional",NULL),
("29","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","e517f3ced79a741b0c41c879b0015140","optional",NULL),
("30","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","d120e1072a7627487c29a202202129c5","optional",NULL),
("31","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","02566eb9e57f234a02168add1b4d57f9","optional",NULL),
("32","en","admin_texts_cptui_post_types","[cptui_post_types][assets]label","Milo - Assets",NULL,NULL,"","LINE",NULL,"0","","77e75b0d294a64b71df4e67c2426308a","optional",NULL),
("33","en","admin_texts_cptui_post_types","[cptui_post_types][assets]singular_label","Milo Asset",NULL,NULL,"","LINE",NULL,"0","","b43d214c4ca3fdc9ea12be531f11659a","optional",NULL),
("34","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","ad390b17dfb18f2e99d381e00ab7ad97","optional",NULL),
("35","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","4d572ef3357a4b1d0664a89bf1276816","optional",NULL),
("36","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","a1c11f12a209191fbac19a6be760997c","optional",NULL),
("37","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","7cf98c120504cc2b5c2752bc70298c3c","optional",NULL),
("38","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","4c8de09819a8112497d05ca804bbe821","optional",NULL),
("39","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","bdf84ccab083d4ed9a4c3a26ec31790f","optional",NULL),
("40","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","d19ad8fb4c0d2471e6950e22ff18d49d","optional",NULL),
("41","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","81f544861d5bc9bcbc565092082bd725","optional",NULL),
("42","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","8379060b9065873020c8463b64cc760b","optional",NULL),
("43","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","9602a13449dc7dd46c0441e23c501a87","optional",NULL),
("44","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","896667442597519ee549a02dd8e020eb","optional",NULL),
("45","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","d7e1c086cf9d444cb92ae83f3a8f7b86","optional",NULL),
("46","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","dfa486ba920f8760468fd60c89eb0c96","optional",NULL),
("47","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","80a4f62d4a16ddb5f4f2d8be42251cdf","optional",NULL),
("48","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","33ba6e791bd43157e024b219bd02517a","optional",NULL),
("49","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","b1b899c1d5bde8c5e254abf88a7401ef","optional",NULL),
("50","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","9d2d9d71e0c4f771b71ba27909e5f1c3","optional",NULL),
("51","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","a664eefbe73c2fe28c8d9424a41ec8b7","optional",NULL),
("52","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","3844fdae0edc470bc12e3b3dd41eb62a","optional",NULL),
("53","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","7dce8c628c81e2f9cf711d6b67ac8cd8","optional",NULL),
("54","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","c911c37375e31b1726554fce77fc9365","optional",NULL),
("55","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","70c5fbdbd8d37a0b54d44d8718ca35f5","optional",NULL),
("56","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","34ce9d9da0c4e72c7895418d7ee361ca","optional",NULL),
("57","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","12022f46bfee11e09a3b5dafcb26030a","optional",NULL),
("58","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","6a68689b629076abc4ccb66ee437c319","optional",NULL),
("59","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","b593e3e24769a42bc2394cd8e790d078","optional",NULL),
("60","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","4c528962a8d83e1171ddd9b347339f9d","optional",NULL),
("61","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","f43142a8c83a148d2976d888cc79c016","optional",NULL),
("62","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","9694702f87d3756266a30344f4ba6419","optional",NULL),
("63","en","admin_texts_cptui_post_types","[cptui_post_types][statement]label","Milo - Statements",NULL,NULL,"","LINE",NULL,"0","","b187ec1867e6e7f3bc15e4dd5e2faefe","optional",NULL),
("64","en","admin_texts_cptui_post_types","[cptui_post_types][statement]singular_label","Statement",NULL,NULL,"","LINE",NULL,"0","","3b57aaa4c58cdc9ba146adfaa5f9679a","optional",NULL),
("65","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","3bc832c9996b01b1271841eb11258e8d","optional",NULL),
("66","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","2d2affe7e59c765353b5a014445df0fe","optional",NULL),
("67","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","b37233eb9c53534c9fe4548aa8dc4003","optional",NULL),
("68","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","2fd1da3f886f59ec80ce210ef248b605","optional",NULL),
("69","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","74c686419f2f07662cd23d568c9b98dd","optional",NULL),
("70","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","2f771e93889c2b8ef0caaacfdd37d5f9","optional",NULL),
("71","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","1cce888d8338eb688204fab72359c06f","optional",NULL),
("72","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","3c112e095aa038d9a7108814a3824fdc","optional",NULL),
("73","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","501c38f133f9e912cadca064cb6c90c4","optional",NULL),
("74","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","b640316437e6e6b952816be27602b06f","optional",NULL),
("75","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","d7cc1378661b46073eb9a292aee2195d","optional",NULL),
("76","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","9da38de97143e926ccfb213e90cb977f","optional",NULL),
("77","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","280de6725f1ba2f82ee42b31bd7b5546","optional",NULL),
("78","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","72cf569bb9166bbfedcd2587276074b6","optional",NULL),
("79","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","bfe03cd4497ce6589784c1c6a54316b0","optional",NULL),
("80","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","e570511503163a94f3fa6b00ec07f407","optional",NULL),
("81","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","fa5cc8df2257ad9212513e27a74f9a34","optional",NULL),
("82","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","5109e4473daea6c8cc43370b2635aa7a","optional",NULL),
("83","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","8a4da81efdba8e50374ca41262326b46","optional",NULL),
("84","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","a2a0d6d5ff80bb9395445ac23bc2d2e1","optional",NULL),
("85","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","5c631ca9a32b91e26443d44f1286ac17","optional",NULL),
("86","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","d5f62d1d7967b3184e981119089d3bbe","optional",NULL),
("87","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","2aa83aed929d49fae313b10ecec27dd2","optional",NULL),
("88","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","7f1fcbcf40a8052091a5c5d9b8e0ada3","optional",NULL),
("89","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","3436c2ba642a682f00bb83a9e0628eea","optional",NULL),
("90","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","3bbbd30e034de92c9ca8dced58bd6b07","optional",NULL),
("91","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","f13b3dbfad352d694a00564964f0037b","optional",NULL),
("92","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","9f9b2cb9c0d9a14f27134da40817a6e5","optional",NULL),
("93","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","5f9b6eb63bbca49fa8396044e4a7371a","optional",NULL),
("94","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks]label","Milo - Global",NULL,NULL,"","LINE",NULL,"0","","d86a1d258c565ddb64f55aec94c16f59","optional",NULL),
("95","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks]singular_label","Global block",NULL,NULL,"","LINE",NULL,"0","","27878f2458b7089695effe800a48c3c1","optional",NULL),
("96","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","84d2831e8b35c9ad3468150316413313","optional",NULL),
("97","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","00e62159152cf7f97aa3293fe848dacf","optional",NULL),
("98","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","e9fd5f8c4762822ae5aabcab92238298","optional",NULL),
("99","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","9c22df04fb5b03cda57852c9802832dd","optional",NULL),
("100","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","3962cce3e05f6638bacb01ec10969c0d","optional",NULL),
("101","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","664d36e2f59c0e79cbc6d942d8819740","optional",NULL),
("102","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","bd451f05034638fb321e2190a130b8b6","optional",NULL),
("103","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","d5e0d5b8a07d04895abf475303e6f10b","optional",NULL),
("104","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","30e3b6bf4342a2e5c481ad940d9fe7c0","optional",NULL),
("105","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","8490a4277cdcf3345308cddf32745f09","optional",NULL),
("106","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","b942a8cf3d7efb3c1d5704c72b09535a","optional",NULL),
("107","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","c82fa5e8df766ffc36c1d3a9a8611f46","optional",NULL),
("108","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","816b80ab406926de40ed4b3a28957a15","optional",NULL),
("109","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","f190061f616c04e5a4f1aa58e97c05f2","optional",NULL),
("110","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","6a223ee2f32f474468861a380a197cc3","optional",NULL),
("111","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","78211be7740ca2d6d2326b147c72389a","optional",NULL),
("112","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","ac2e8bcd28043cfe783e55e78d0c3c98","optional",NULL),
("113","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","a8ecb94b31bb1e7e639e11949808918f","optional",NULL),
("114","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","7f029a8594c8d69e41496dddb0b7d1a1","optional",NULL),
("115","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","53a47df522c73d91a10d795b6b786794","optional",NULL),
("116","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","88c0e8f4b867c8f5008e8c0ee254256e","optional",NULL),
("117","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","7c3fbea6b7e11711c6e267d531ed3444","optional",NULL),
("118","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","526f410118c2dc1daf69d5f3164510e9","optional",NULL),
("119","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","e48b8c5614bf422db6fa4f560f2b07f7","optional",NULL),
("120","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","a833ce7d1f8d8d4c01a70c496ee34168","optional",NULL),
("121","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","76620701c3e4c15555dd72562f9bc00e","optional",NULL),
("122","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","005ee8e7f8d9fe9ba97cc4f057d5a8cf","optional",NULL),
("123","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","cbfbf5756888dadb299d376f9ad39d18","optional",NULL),
("124","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","7e36c3b0c52553aae421274aaaa63d24","optional",NULL),
("125","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region]label","Regions",NULL,NULL,"","LINE",NULL,"0","","2bbb20749a39bd48aee6055b92dce552","optional",NULL),
("126","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region]singular_label","Region",NULL,NULL,"","LINE",NULL,"0","","8c55165ad686932d2ce36aecc333d8cc","optional",NULL),
("127","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","3efc83be8452ecbc60e7012f0fa98af1","optional",NULL),
("128","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","deff088e19ea9c5cd37e5b79c2cd65ff","optional",NULL),
("129","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","5b38d47405f2be417c588eba26d1828c","optional",NULL),
("130","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","e0dfa1b833c031cb7cbd32bbee8a9be4","optional",NULL),
("131","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]update_item","",NULL,NULL,"","LINE",NULL,"0","","af2bfd3c650a484f9f20f1f8c41639a9","optional",NULL),
("132","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","1ae9401d40bb56b8af854f661177da2f","optional",NULL),
("133","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]new_item_name","",NULL,NULL,"","LINE",NULL,"0","","08e03deeefbd282007e48b75a6c78bf8","optional",NULL),
("134","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]parent_item","",NULL,NULL,"","LINE",NULL,"0","","e103b7c8c4a6c65fed6777c7b26718af","optional",NULL),
("135","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","e21324f9ba700f1424b14c6f30e5f94f","optional",NULL),
("136","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","28f6958f8b727daf495a7769eb8b1264","optional",NULL),
("137","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]popular_items","",NULL,NULL,"","LINE",NULL,"0","","45657cbfdabda6155841b470a733f7b0","optional",NULL),
("138","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]separate_items_with_commas","",NULL,NULL,"","LINE",NULL,"0","","3e5d4957b6a03c71a50e2345dc08e5e5","optional",NULL),
("139","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]add_or_remove_items","",NULL,NULL,"","LINE",NULL,"0","","ce82e5d4094d12b3ce48bac67b5423d8","optional",NULL),
("140","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]choose_from_most_used","",NULL,NULL,"","LINE",NULL,"0","","6f517ab2dcb1b4c45e3e56419a04f72d","optional",NULL),
("141","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","31904ca4827215c5177e9b2e1adda3b6","optional",NULL),
("142","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]no_terms","",NULL,NULL,"","LINE",NULL,"0","","3f28186f117abd3629e6a27eda8177a2","optional",NULL),
("143","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","05baeb38f2745d3ae6c1844c2e6d9385","optional",NULL),
("144","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","ab6da9110417d82cde7adce10dea91a6","optional",NULL),
("145","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]back_to_items","",NULL,NULL,"","LINE",NULL,"0","","fd9d35e8a4f0d8dd408759201f35dc38","optional",NULL),
("146","en","WP","Blog Title","Milo",NULL,NULL,"","LINE",NULL,"0","","5ff0887b4c486c0329311e8d30610d58","optional",NULL),
("147","en","WP","Tagline","Just another WordPress site",NULL,NULL,"","LINE",NULL,"0","","6e70f8f3e0f8c134711af40ab6e4931b","optional",NULL),
("148","en","WordPress","URL slug: country","country",NULL,NULL,"","LINE",NULL,"10","","c4873741705585a9909a274363b9a956","optional",NULL),
("149","en","WordPress","URL slug: assets","assets",NULL,NULL,"","LINE",NULL,"10","","d4cd0aceb06768d8a9b86bfd71be4c4a","optional",NULL),
("150","en","WordPress","URL slug: statement","statement",NULL,NULL,"","LINE",NULL,"10","","9f5c81d657290e7153b02f96e2f95b0f","optional",NULL),
("151","en","WordPress","URL slug: section_blocks","section_blocks",NULL,NULL,"","LINE",NULL,"10","","9b8cc2ce9ae8ca99673d7fbd17ec94b4","optional",NULL),
("152","en","gutenberg-1248","07fbe196fb74a9ff11f1fe3572fbbfd3","This is content from the default Wordpress template.","1","1","","LINE","core/paragraph","0","","82260087ff605457be8e4a06f72649ef","optional","8");

INSERT INTO `wp_icl_translation_batches` VALUES 
("1","Manual Translations from April the 18th, 2021",NULL,NULL,"2021-04-18 14:32:43");

INSERT INTO `wp_icl_translation_status` VALUES 
("1","436","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("2","437","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("3","438","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("4","439","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("5","440","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("6","441","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("7","442","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("8","443","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("9","444","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("10","445","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("11","446","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("12","447","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("13","448","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("14","449","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("15","450","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("16","451","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("17","452","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("18","453","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("19","454","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("20","455","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("21","456","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("22","457","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("23","458","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("24","459","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("25","460","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("26","461","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("27","462","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("28","463","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("29","464","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("30","465","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("31","466","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("32","467","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("33","468","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("34","469","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("35","470","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("36","471","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("37","472","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("38","473","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("39","474","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("40","475","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("41","476","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("42","477","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("43","478","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("44","479","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("45","480","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("46","481","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("47","482","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("48","483","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("49","484","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("50","485","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("51","486","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("52","487","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("53","488","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("54","489","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("55","490","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("56","491","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("57","492","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("58","493","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("59","494","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("60","495","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("61","496","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("62","497","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("63","498","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("64","499","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("65","500","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("66","501","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("67","502","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("68","503","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("69","504","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("70","505","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("71","506","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("72","507","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("73","508","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("74","509","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("75","510","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("76","511","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("77","512","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("78","513","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("79","514","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("80","515","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("81","516","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("82","517","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("83","518","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("84","519","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("85","520","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("86","521","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("87","522","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("88","523","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("89","524","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("90","525","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("91","526","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("92","527","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("93","528","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("94","529","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("95","530","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("96","531","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("97","532","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("98","533","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("99","534","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("100","535","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("101","536","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("102","537","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("103","538","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("104","539","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("105","540","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("106","541","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("107","542","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("108","543","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("109","544","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("110","545","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("111","546","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("112","547","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("113","548","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("114","549","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("115","550","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("116","551","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("117","552","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("118","553","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("119","554","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("120","555","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("121","556","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("122","557","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("123","558","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("124","559","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("125","560","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("126","561","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("127","562","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("128","563","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("129","564","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("130","565","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("131","566","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("132","567","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("133","568","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("134","569","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("135","570","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("136","571","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("137","572","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("138","573","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("139","574","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("140","575","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("141","576","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("142","577","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("143","578","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("144","579","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("145","580","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("146","581","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("147","582","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("148","583","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("149","584","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("150","585","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("151","586","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("152","587","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("153","588","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("154","589","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("155","590","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("156","591","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("162","604","9","0","0","","","0","","2021-04-20 11:25:25","0",NULL,NULL,NULL,"1",NULL),
("163","606","9","0","0","","","0","","2021-04-20 11:25:25","0",NULL,NULL,NULL,"1",NULL),
("165","610","9","0","0","","","0","","2021-04-20 11:38:51","0",NULL,NULL,NULL,"1",NULL),
("166","621","9","0","0","","","0","","2021-04-20 13:53:22","0",NULL,NULL,NULL,"1",NULL),
("168","627","9","0","0","","","0","","2021-04-23 08:06:30","0",NULL,NULL,NULL,"1",NULL),
("170","631","9","0","0","","","0","","2021-04-23 09:08:55","0",NULL,NULL,NULL,"1",NULL),
("171","634","9","0","0","","","0","","2021-04-23 11:12:39","0",NULL,NULL,NULL,"1",NULL),
("173","638","9","0","0","","","0","","2021-04-23 11:34:01","0",NULL,NULL,NULL,"1",NULL),
("174","640","9","0","0","","","0","","2021-04-23 11:44:06","0",NULL,NULL,NULL,"1",NULL),
("176","644","9","0","0","","","0","","2021-04-23 12:39:42","0",NULL,NULL,NULL,"1",NULL),
("178","649","9","0","0","","","0","","2021-04-23 13:32:34","0",NULL,NULL,NULL,"1",NULL),
("179","652","9","0","0","","","0","","2021-04-26 14:32:11","0",NULL,NULL,NULL,"1",NULL);

INSERT INTO `wp_icl_translations` VALUES 
("1","post_acf-field","7","7","en",NULL),
("2","post_acf-field","10","10","en",NULL),
("3","post_acf-field","59","59","en",NULL),
("4","post_acf-field","60","60","en",NULL),
("5","post_acf-field","61","61","en",NULL),
("6","post_acf-field","62","62","en",NULL),
("7","post_acf-field","63","63","en",NULL),
("8","post_acf-field","64","64","en",NULL),
("9","post_acf-field","65","65","en",NULL),
("10","post_acf-field","101","101","en",NULL),
("11","post_acf-field","102","102","en",NULL),
("12","post_acf-field","123","123","en",NULL),
("13","post_acf-field","126","126","en",NULL),
("14","post_acf-field","129","129","en",NULL),
("15","post_acf-field","130","130","en",NULL),
("16","post_acf-field","138","138","en",NULL),
("17","post_acf-field","148","148","en",NULL),
("18","post_acf-field","149","149","en",NULL),
("19","post_acf-field","150","150","en",NULL),
("20","post_acf-field","151","151","en",NULL),
("21","post_acf-field","152","152","en",NULL),
("22","post_acf-field","156","156","en",NULL),
("23","post_acf-field","159","159","en",NULL),
("24","post_acf-field","163","163","en",NULL),
("25","post_acf-field","174","174","en",NULL),
("26","post_acf-field","179","179","en",NULL),
("27","post_acf-field","180","180","en",NULL),
("28","post_acf-field","181","181","en",NULL),
("29","post_acf-field","182","182","en",NULL),
("30","post_acf-field","183","183","en",NULL),
("31","post_acf-field","184","184","en",NULL),
("32","post_acf-field","185","185","en",NULL),
("33","post_acf-field","186","186","en",NULL),
("34","post_acf-field","187","187","en",NULL),
("35","post_acf-field","189","189","en",NULL),
("36","post_acf-field","190","190","en",NULL),
("37","post_acf-field","191","191","en",NULL),
("38","post_acf-field","192","192","en",NULL),
("39","post_acf-field","193","193","en",NULL),
("40","post_acf-field","194","194","en",NULL),
("41","post_acf-field","195","195","en",NULL),
("42","post_acf-field","235","235","en",NULL),
("43","post_acf-field","236","236","en",NULL),
("44","post_acf-field","250","250","en",NULL),
("45","post_acf-field","251","251","en",NULL),
("46","post_acf-field","252","252","en",NULL),
("47","post_acf-field","253","253","en",NULL),
("48","post_acf-field","254","254","en",NULL),
("49","post_acf-field","260","260","en",NULL),
("50","post_acf-field","263","263","en",NULL),
("51","post_acf-field","264","264","en",NULL),
("52","post_acf-field","265","265","en",NULL),
("53","post_acf-field","273","273","en",NULL),
("54","post_acf-field","280","280","en",NULL),
("55","post_acf-field","281","281","en",NULL),
("56","post_acf-field","282","282","en",NULL),
("57","post_acf-field","283","283","en",NULL),
("58","post_acf-field","284","284","en",NULL),
("59","post_acf-field","287","287","en",NULL),
("60","post_acf-field","290","290","en",NULL),
("61","post_acf-field","293","293","en",NULL),
("62","post_acf-field","294","294","en",NULL),
("63","post_acf-field","318","318","en",NULL),
("64","post_acf-field","320","320","en",NULL),
("65","post_acf-field","321","321","en",NULL),
("66","post_acf-field","339","339","en",NULL),
("67","post_acf-field","352","352","en",NULL),
("68","post_acf-field","353","353","en",NULL),
("69","post_acf-field","354","354","en",NULL),
("70","post_acf-field","355","355","en",NULL),
("71","post_acf-field","360","360","en",NULL),
("72","post_acf-field","361","361","en",NULL),
("73","post_acf-field","362","362","en",NULL),
("74","post_acf-field","363","363","en",NULL),
("75","post_acf-field","370","370","en",NULL),
("76","post_acf-field","374","374","en",NULL),
("77","post_acf-field","375","375","en",NULL),
("78","post_acf-field","376","376","en",NULL),
("79","post_acf-field","377","377","en",NULL),
("80","post_acf-field","378","378","en",NULL),
("81","post_acf-field","379","379","en",NULL),
("82","post_acf-field","388","388","en",NULL),
("83","post_acf-field","400","400","en",NULL),
("84","post_acf-field","401","401","en",NULL),
("85","post_acf-field","402","402","en",NULL),
("86","post_acf-field","406","406","en",NULL),
("87","post_acf-field","407","407","en",NULL),
("88","post_acf-field","408","408","en",NULL),
("89","post_acf-field","413","413","en",NULL),
("90","post_acf-field","414","414","en",NULL),
("91","post_acf-field","415","415","en",NULL),
("92","post_acf-field","416","416","en",NULL),
("93","post_acf-field","417","417","en",NULL),
("94","post_acf-field","418","418","en",NULL),
("95","post_acf-field","419","419","en",NULL),
("96","post_acf-field","429","429","en",NULL),
("97","post_acf-field","430","430","en",NULL),
("98","post_acf-field","431","431","en",NULL),
("99","post_acf-field","432","432","en",NULL),
("100","post_acf-field","435","435","en",NULL),
("101","post_acf-field","436","436","en",NULL),
("102","post_acf-field","437","437","en",NULL),
("103","post_acf-field","438","438","en",NULL),
("104","post_acf-field","439","439","en",NULL),
("105","post_acf-field","448","448","en",NULL),
("106","post_acf-field","449","449","en",NULL),
("107","post_acf-field","450","450","en",NULL),
("108","post_acf-field","451","451","en",NULL),
("109","post_acf-field","453","453","en",NULL),
("110","post_acf-field","456","456","en",NULL),
("111","post_acf-field","457","457","en",NULL),
("112","post_acf-field","458","458","en",NULL),
("113","post_acf-field","459","459","en",NULL),
("114","post_acf-field","460","460","en",NULL),
("115","post_acf-field","467","467","en",NULL),
("116","post_acf-field","468","468","en",NULL),
("117","post_acf-field","469","469","en",NULL),
("118","post_acf-field","470","470","en",NULL),
("119","post_acf-field","471","471","en",NULL),
("120","post_acf-field","479","479","en",NULL),
("121","post_acf-field","486","486","en",NULL),
("122","post_acf-field","489","489","en",NULL),
("123","post_acf-field","490","490","en",NULL),
("124","post_acf-field","503","503","en",NULL),
("125","post_acf-field","516","516","en",NULL),
("126","post_acf-field","523","523","en",NULL),
("127","post_acf-field","524","524","en",NULL),
("128","post_acf-field","525","525","en",NULL),
("129","post_acf-field","526","526","en",NULL),
("130","post_acf-field","530","530","en",NULL),
("131","post_acf-field","531","531","en",NULL),
("132","post_acf-field","545","545","en",NULL),
("133","post_acf-field","546","546","en",NULL),
("134","post_acf-field","547","547","en",NULL),
("135","post_acf-field","548","548","en",NULL),
("136","post_acf-field","555","555","en",NULL),
("137","post_acf-field","573","573","en",NULL),
("138","post_acf-field","584","584","en",NULL),
("139","post_acf-field","585","585","en",NULL),
("140","post_acf-field","606","606","en",NULL),
("141","post_acf-field","607","607","en",NULL),
("142","post_acf-field","630","630","en",NULL),
("143","post_acf-field","650","650","en",NULL),
("144","post_acf-field","852","852","en",NULL),
("145","post_acf-field","861","861","en",NULL),
("146","post_acf-field","878","878","en",NULL),
("147","post_acf-field","879","879","en",NULL),
("148","post_acf-field","880","880","en",NULL),
("149","post_acf-field","885","885","en",NULL),
("154","post_acf-field","916","916","en",NULL),
("155","post_acf-field","917","917","en",NULL),
("156","post_acf-field","918","918","en",NULL),
("157","post_acf-field","919","919","en",NULL),
("158","post_acf-field","920","920","en",NULL),
("159","post_acf-field","921","921","en",NULL),
("160","post_acf-field","922","922","en",NULL),
("161","post_acf-field","923","923","en",NULL),
("162","post_acf-field","1012","1012","en",NULL),
("163","post_acf-field","1013","1013","en",NULL),
("164","post_acf-field","1014","1014","en",NULL),
("165","post_acf-field","1033","1033","en",NULL),
("166","post_acf-field","1034","1034","en",NULL),
("167","post_acf-field","1035","1035","en",NULL),
("168","post_acf-field","1036","1036","en",NULL),
("169","post_acf-field-group","6","6","en",NULL),
("170","post_acf-field-group","147","147","en",NULL),
("171","post_acf-field-group","249","249","en",NULL),
("172","post_acf-field-group","279","279","en",NULL),
("173","post_acf-field-group","412","412","en",NULL),
("174","post_acf-field-group","629","629","en",NULL),
("175","post_acf-field-group","877","877","en",NULL),
("177","post_acf-field-group","915","915","en",NULL),
("178","post_assets","256","256","en",NULL),
("179","post_assets","266","266","en",NULL),
("180","post_country","157","157","en",NULL),
("181","post_country","158","158","en",NULL),
("182","post_country","881","881","en",NULL),
("183","post_country","882","882","en",NULL),
("184","post_country","883","883","en",NULL),
("185","post_country","884","884","en",NULL),
("186","post_country","898","898","en",NULL),
("187","post_country","899","899","en",NULL),
("188","post_country","900","900","en",NULL),
("189","post_country","902","902","en",NULL),
("190","post_country","903","903","en",NULL),
("191","post_country","905","905","en",NULL),
("192","post_country","906","906","en",NULL),
("193","post_country","907","907","en",NULL),
("194","post_nav_menu_item","929","929","en",NULL),
("211","post_nav_menu_item","928","928","en",NULL),
("212","post_nav_menu_item","930","930","en",NULL),
("213","post_nav_menu_item","931","931","en",NULL),
("214","post_nav_menu_item","932","932","en",NULL),
("215","post_nav_menu_item","933","933","en",NULL),
("216","post_nav_menu_item","937","937","en",NULL),
("217","post_nav_menu_item","938","938","en",NULL),
("218","post_nav_menu_item","939","939","en",NULL),
("219","post_nav_menu_item","940","940","en",NULL),
("220","post_page","3","3","en",NULL),
("221","post_page","2","2","en",NULL),
("222","post_page","586","586","en",NULL),
("223","post_page","614","614","en",NULL),
("224","post_page","636","636","en",NULL),
("225","post_page","656","656","en",NULL),
("226","post_page","670","670","en",NULL),
("227","post_page","688","688","en",NULL),
("228","post_page","701","701","en",NULL),
("229","post_page","714","714","en",NULL),
("230","post_page","742","742","en",NULL),
("231","post_page","755","755","en",NULL),
("232","post_page","778","778","en",NULL),
("233","post_page","793","793","en",NULL),
("234","post_page","810","810","en",NULL),
("235","post_page","1011","1011","en",NULL),
("236","post_post","1","1","en",NULL),
("237","post_post","298","298","en",NULL),
("238","post_post","303","303","en",NULL),
("239","post_post","305","305","en",NULL),
("240","post_post","309","309","en",NULL),
("241","post_post","314","314","en",NULL),
("242","post_post","316","316","en",NULL),
("243","post_post","334","334","en",NULL),
("244","post_post","844","844","en",NULL),
("245","post_section_blocks","426","426","en",NULL),
("246","post_section_blocks","433","433","en",NULL),
("247","post_section_blocks","461","461","en",NULL),
("248","post_section_blocks","527","527","en",NULL),
("249","post_section_blocks","533","533","en",NULL),
("250","post_section_blocks","549","549","en",NULL),
("251","post_statement","285","285","en",NULL),
("252","post_statement","719","719","en",NULL),
("253","post_statement","757","757","en",NULL),
("254","post_statement","822","822","en",NULL),
("255","tax_category","1","1038","en",NULL),
("256","tax_category","6","1043","en",NULL),
("257","tax_category","7","1044","en",NULL),
("258","tax_category","8","1045","en",NULL),
("259","tax_category","9","1046","en",NULL),
("260","tax_nav_menu","5","1052","en",NULL),
("261","tax_nav_menu","10","1057","en",NULL),
("262","tax_region","2","1060","en",NULL),
("263","tax_region","3","1061","en",NULL),
("264","tax_region","4","1062","en",NULL),
("265","comment","1","1064","en",NULL),
("266","tax_category","11","1038","da","en"),
("267","post_attachment","25","1090","en",NULL),
("268","post_attachment","26","1091","en",NULL),
("269","post_attachment","27","1092","en",NULL),
("270","post_attachment","28","1093","en",NULL),
("271","post_attachment","69","1134","en",NULL),
("272","post_attachment","70","1135","en",NULL),
("273","post_attachment","71","1136","en",NULL),
("274","post_attachment","131","1196","en",NULL),
("275","post_attachment","257","1322","en",NULL),
("276","post_attachment","258","1323","en",NULL),
("277","post_attachment","259","1324","en",NULL),
("278","post_attachment","267","1332","en",NULL),
("279","post_attachment","268","1333","en",NULL),
("280","post_attachment","269","1334","en",NULL),
("281","post_attachment","286","1351","en",NULL),
("282","post_attachment","289","1354","en",NULL),
("283","post_attachment","295","1360","en",NULL),
("284","post_attachment","299","1364","en",NULL),
("285","post_attachment","300","1365","en",NULL),
("286","post_attachment","301","1366","en",NULL),
("287","post_attachment","310","1375","en",NULL),
("288","post_attachment","311","1376","en",NULL),
("289","post_attachment","312","1377","en",NULL),
("290","post_attachment","364","1429","en",NULL),
("291","post_attachment","365","1430","en",NULL),
("292","post_attachment","366","1431","en",NULL),
("293","post_attachment","367","1432","en",NULL),
("294","post_attachment","380","1445","en",NULL),
("295","post_attachment","381","1446","en",NULL),
("296","post_attachment","382","1447","en",NULL),
("297","post_attachment","383","1448","en",NULL),
("298","post_attachment","441","1506","en",NULL),
("299","post_attachment","443","1508","en",NULL),
("300","post_attachment","454","1519","en",NULL),
("301","post_attachment","462","1527","en",NULL),
("302","post_attachment","463","1528","en",NULL),
("303","post_attachment","464","1529","en",NULL),
("304","post_attachment","472","1537","en",NULL),
("305","post_attachment","473","1538","en",NULL),
("306","post_attachment","474","1539","en",NULL),
("307","post_attachment","475","1540","en",NULL),
("308","post_attachment","477","1542","en",NULL),
("309","post_attachment","491","1556","en",NULL),
("310","post_attachment","506","1571","en",NULL),
("311","post_attachment","507","1572","en",NULL),
("312","post_attachment","528","1593","en",NULL),
("313","post_attachment","535","1600","en",NULL),
("314","post_attachment","536","1601","en",NULL),
("315","post_attachment","537","1602","en",NULL),
("316","post_attachment","538","1603","en",NULL),
("317","post_attachment","539","1604","en",NULL),
("318","post_attachment","540","1605","en",NULL),
("319","post_attachment","543","1608","en",NULL),
("320","post_attachment","615","1680","en",NULL),
("321","post_attachment","619","1684","en",NULL),
("322","post_attachment","620","1685","en",NULL),
("323","post_attachment","621","1686","en",NULL),
("324","post_attachment","622","1687","en",NULL),
("325","post_attachment","637","1702","en",NULL),
("326","post_attachment","645","1710","en",NULL),
("327","post_attachment","646","1711","en",NULL),
("328","post_attachment","657","1722","en",NULL),
("329","post_attachment","677","1742","en",NULL),
("330","post_attachment","678","1743","en",NULL),
("331","post_attachment","679","1744","en",NULL),
("332","post_attachment","680","1745","en",NULL),
("333","post_attachment","681","1746","en",NULL),
("334","post_attachment","682","1747","en",NULL),
("335","post_attachment","683","1748","en",NULL),
("336","post_attachment","684","1749","en",NULL),
("337","post_attachment","693","1758","en",NULL),
("338","post_attachment","696","1761","en",NULL),
("339","post_attachment","702","1767","en",NULL),
("340","post_attachment","706","1771","en",NULL),
("341","post_attachment","708","1773","en",NULL),
("342","post_attachment","711","1776","en",NULL),
("343","post_attachment","720","1785","en",NULL),
("344","post_attachment","738","1803","en",NULL),
("345","post_attachment","743","1808","en",NULL),
("346","post_attachment","748","1813","en",NULL),
("347","post_attachment","749","1814","en",NULL),
("348","post_attachment","750","1815","en",NULL),
("349","post_attachment","753","1818","en",NULL),
("350","post_attachment","756","1821","en",NULL),
("351","post_attachment","758","1823","en",NULL),
("352","post_attachment","759","1824","en",NULL),
("353","post_attachment","760","1825","en",NULL),
("354","post_attachment","761","1826","en",NULL),
("355","post_attachment","762","1827","en",NULL),
("356","post_attachment","776","1841","en",NULL),
("357","post_attachment","779","1844","en",NULL),
("358","post_attachment","784","1849","en",NULL),
("359","post_attachment","785","1850","en",NULL),
("360","post_attachment","786","1851","en",NULL),
("361","post_attachment","787","1852","en",NULL),
("362","post_attachment","788","1853","en",NULL),
("363","post_attachment","789","1854","en",NULL),
("364","post_attachment","794","1859","en",NULL),
("365","post_attachment","823","1888","en",NULL),
("366","post_attachment","845","1910","en",NULL),
("367","post_attachment","849","1914","en",NULL),
("368","post_attachment","850","1915","en",NULL),
("369","post_attachment","870","1935","en",NULL),
("370","post_attachment","871","1936","en",NULL),
("371","post_attachment","872","1937","en",NULL),
("372","post_attachment","886","1951","en",NULL),
("373","post_attachment","887","1952","en",NULL),
("374","post_attachment","888","1953","en",NULL),
("375","post_attachment","889","1954","en",NULL),
("376","post_attachment","890","1955","en",NULL),
("377","post_attachment","891","1956","en",NULL),
("378","post_attachment","892","1957","en",NULL),
("379","post_attachment","893","1958","en",NULL),
("380","post_attachment","894","1959","en",NULL),
("381","post_attachment","895","1960","en",NULL),
("382","post_attachment","896","1961","en",NULL),
("383","post_attachment","897","1962","en",NULL),
("384","post_attachment","904","1969","en",NULL),
("385","post_attachment","908","1973","en",NULL),
("386","post_attachment","924","1989","en",NULL),
("387","post_attachment","941","2006","en",NULL),
("388","post_attachment","942","2007","en",NULL),
("389","post_attachment","945","2010","en",NULL),
("390","post_attachment","946","2011","en",NULL),
("391","post_attachment","947","2012","en",NULL),
("392","post_attachment","949","2014","en",NULL),
("393","post_attachment","951","2016","en",NULL),
("394","post_attachment","954","2019","en",NULL),
("395","post_attachment","956","2021","en",NULL),
("396","post_attachment","958","2023","en",NULL),
("397","post_attachment","965","2030","en",NULL),
("398","post_attachment","966","2031","en",NULL),
("399","post_attachment","967","2032","en",NULL),
("400","post_attachment","968","2033","en",NULL),
("401","post_attachment","969","2034","en",NULL),
("402","post_attachment","970","2035","en",NULL),
("403","post_attachment","972","2037","en",NULL),
("404","post_attachment","974","2039","en",NULL),
("405","post_attachment","977","2042","en",NULL),
("406","post_attachment","979","2044","en",NULL),
("407","post_attachment","981","2046","en",NULL),
("408","post_attachment","989","2054","en",NULL),
("409","post_attachment","990","2055","en",NULL),
("410","post_attachment","991","2056","en",NULL),
("411","post_attachment","992","2057","en",NULL),
("412","post_attachment","993","2058","en",NULL),
("413","post_attachment","994","2059","en",NULL),
("414","post_attachment","995","2060","en",NULL),
("415","post_attachment","996","2061","en",NULL),
("416","post_attachment","997","2062","en",NULL),
("417","post_attachment","998","2063","en",NULL),
("418","post_attachment","999","2064","en",NULL),
("419","post_attachment","1002","2067","en",NULL),
("420","post_attachment","1003","2068","en",NULL),
("421","post_attachment","1004","2069","en",NULL),
("422","post_attachment","1008","2073","en",NULL),
("424","tax_translation_priority","12","2074","en",NULL),
("425","tax_translation_priority","13","2074","da","en"),
("427","tax_translation_priority","14","2075","en",NULL),
("428","tax_translation_priority","15","2075","da","en"),
("430","tax_translation_priority","16","2076","en",NULL),
("431","tax_translation_priority","17","2076","da","en"),
("432","post_post","1032","3109","en",NULL),
("433","post_section_blocks","424","3534","en",NULL),
("434","post_section_blocks","532","3642","en",NULL),
("435","post_section_blocks","421","3531","en",NULL),
("436","post_attachment","1079","1090","da","en"),
("437","post_attachment","1080","1091","da","en"),
("438","post_attachment","1081","1092","da","en"),
("439","post_attachment","1082","1093","da","en"),
("440","post_attachment","1083","1134","da","en"),
("441","post_attachment","1084","1135","da","en"),
("442","post_attachment","1085","1136","da","en"),
("443","post_attachment","1086","1196","da","en"),
("444","post_attachment","1087","1322","da","en"),
("445","post_attachment","1088","1323","da","en"),
("446","post_attachment","1089","1324","da","en"),
("447","post_attachment","1090","1332","da","en"),
("448","post_attachment","1091","1333","da","en"),
("449","post_attachment","1092","1334","da","en"),
("450","post_attachment","1093","1351","da","en"),
("451","post_attachment","1094","1354","da","en"),
("452","post_attachment","1095","1360","da","en"),
("453","post_attachment","1096","1364","da","en"),
("454","post_attachment","1097","1365","da","en"),
("455","post_attachment","1098","1366","da","en"),
("456","post_attachment","1099","1375","da","en"),
("457","post_attachment","1100","1376","da","en"),
("458","post_attachment","1101","1377","da","en"),
("459","post_attachment","1102","1429","da","en"),
("460","post_attachment","1103","1430","da","en"),
("461","post_attachment","1104","1431","da","en"),
("462","post_attachment","1105","1432","da","en"),
("463","post_attachment","1106","1445","da","en"),
("464","post_attachment","1107","1446","da","en"),
("465","post_attachment","1108","1447","da","en"),
("466","post_attachment","1109","1448","da","en"),
("467","post_attachment","1110","1506","da","en"),
("468","post_attachment","1111","1508","da","en"),
("469","post_attachment","1112","1519","da","en"),
("470","post_attachment","1113","1527","da","en"),
("471","post_attachment","1114","1528","da","en"),
("472","post_attachment","1115","1529","da","en"),
("473","post_attachment","1116","1537","da","en"),
("474","post_attachment","1117","1538","da","en"),
("475","post_attachment","1118","1539","da","en"),
("476","post_attachment","1119","1540","da","en"),
("477","post_attachment","1120","1542","da","en"),
("478","post_attachment","1121","1556","da","en"),
("479","post_attachment","1122","1571","da","en"),
("480","post_attachment","1123","1572","da","en"),
("481","post_attachment","1124","1593","da","en"),
("482","post_attachment","1125","1600","da","en"),
("483","post_attachment","1126","1601","da","en"),
("484","post_attachment","1127","1602","da","en"),
("485","post_attachment","1128","1603","da","en"),
("486","post_attachment","1129","1604","da","en"),
("487","post_attachment","1130","1605","da","en"),
("488","post_attachment","1131","1608","da","en"),
("489","post_attachment","1132","1680","da","en"),
("490","post_attachment","1133","1684","da","en"),
("491","post_attachment","1134","1685","da","en"),
("492","post_attachment","1135","1686","da","en"),
("493","post_attachment","1136","1687","da","en"),
("494","post_attachment","1137","1702","da","en"),
("495","post_attachment","1138","1710","da","en"),
("496","post_attachment","1139","1711","da","en"),
("497","post_attachment","1140","1722","da","en"),
("498","post_attachment","1141","1742","da","en"),
("499","post_attachment","1142","1743","da","en"),
("500","post_attachment","1143","1744","da","en"),
("501","post_attachment","1144","1745","da","en"),
("502","post_attachment","1145","1746","da","en"),
("503","post_attachment","1146","1747","da","en"),
("504","post_attachment","1147","1748","da","en"),
("505","post_attachment","1148","1749","da","en"),
("506","post_attachment","1149","1758","da","en"),
("507","post_attachment","1150","1761","da","en"),
("508","post_attachment","1151","1767","da","en"),
("509","post_attachment","1152","1771","da","en"),
("510","post_attachment","1153","1773","da","en"),
("511","post_attachment","1154","1776","da","en"),
("512","post_attachment","1155","1785","da","en"),
("513","post_attachment","1156","1803","da","en"),
("514","post_attachment","1157","1808","da","en"),
("515","post_attachment","1158","1813","da","en"),
("516","post_attachment","1159","1814","da","en"),
("517","post_attachment","1160","1815","da","en"),
("518","post_attachment","1161","1818","da","en"),
("519","post_attachment","1162","1821","da","en"),
("520","post_attachment","1163","1823","da","en"),
("521","post_attachment","1164","1824","da","en"),
("522","post_attachment","1165","1825","da","en"),
("523","post_attachment","1166","1826","da","en"),
("524","post_attachment","1167","1827","da","en"),
("525","post_attachment","1168","1841","da","en"),
("526","post_attachment","1169","1844","da","en"),
("527","post_attachment","1170","1849","da","en"),
("528","post_attachment","1171","1850","da","en"),
("529","post_attachment","1172","1851","da","en"),
("530","post_attachment","1173","1852","da","en"),
("531","post_attachment","1174","1853","da","en"),
("532","post_attachment","1175","1854","da","en"),
("533","post_attachment","1176","1859","da","en"),
("534","post_attachment","1177","1888","da","en"),
("535","post_attachment","1178","1910","da","en"),
("536","post_attachment","1179","1914","da","en"),
("537","post_attachment","1180","1915","da","en"),
("538","post_attachment","1181","1935","da","en"),
("539","post_attachment","1182","1936","da","en"),
("540","post_attachment","1183","1937","da","en"),
("541","post_attachment","1184","1951","da","en"),
("542","post_attachment","1185","1952","da","en"),
("543","post_attachment","1186","1953","da","en"),
("544","post_attachment","1187","1954","da","en"),
("545","post_attachment","1188","1955","da","en"),
("546","post_attachment","1189","1956","da","en"),
("547","post_attachment","1190","1957","da","en"),
("548","post_attachment","1191","1958","da","en"),
("549","post_attachment","1192","1959","da","en"),
("550","post_attachment","1193","1960","da","en"),
("551","post_attachment","1194","1961","da","en"),
("552","post_attachment","1195","1962","da","en"),
("553","post_attachment","1196","1969","da","en"),
("554","post_attachment","1197","1973","da","en"),
("555","post_attachment","1198","1989","da","en"),
("556","post_attachment","1199","2006","da","en"),
("557","post_attachment","1200","2007","da","en"),
("558","post_attachment","1201","2010","da","en"),
("559","post_attachment","1202","2011","da","en"),
("560","post_attachment","1203","2012","da","en"),
("561","post_attachment","1204","2014","da","en"),
("562","post_attachment","1205","2016","da","en"),
("563","post_attachment","1206","2019","da","en"),
("564","post_attachment","1207","2021","da","en"),
("565","post_attachment","1208","2023","da","en"),
("566","post_attachment","1209","2030","da","en"),
("567","post_attachment","1210","2031","da","en"),
("568","post_attachment","1211","2032","da","en"),
("569","post_attachment","1212","2033","da","en"),
("570","post_attachment","1213","2034","da","en"),
("571","post_attachment","1214","2035","da","en"),
("572","post_attachment","1215","2037","da","en"),
("573","post_attachment","1216","2039","da","en"),
("574","post_attachment","1217","2042","da","en"),
("575","post_attachment","1218","2044","da","en"),
("576","post_attachment","1219","2046","da","en"),
("577","post_attachment","1220","2054","da","en"),
("578","post_attachment","1221","2055","da","en"),
("579","post_attachment","1222","2056","da","en"),
("580","post_attachment","1223","2057","da","en"),
("581","post_attachment","1224","2058","da","en"),
("582","post_attachment","1225","2059","da","en"),
("583","post_attachment","1226","2060","da","en"),
("584","post_attachment","1227","2061","da","en"),
("585","post_attachment","1228","2062","da","en"),
("586","post_attachment","1229","2063","da","en"),
("587","post_attachment","1230","2064","da","en"),
("588","post_attachment","1231","2067","da","en"),
("589","post_attachment","1232","2068","da","en"),
("590","post_attachment","1233","2069","da","en"),
("591","post_attachment","1234","2073","da","en"),
("596","tax_category","18","1044","da","en"),
("598","post_page","1248","3643","en",NULL),
("600","package_gutenberg","1","3644","en",NULL),
("601","post_page","1261","3645","en",NULL),
("602","post_page","1279","3646","en",NULL),
("603","post_attachment","1304","3647","en",NULL),
("604","post_attachment","1305","3647","da","en"),
("605","post_attachment","1306","3648","en",NULL),
("606","post_attachment","1307","3648","da","en"),
("608","post_attachment","1312","3649","da",NULL),
("609","post_attachment","1314","3650","en",NULL),
("610","post_attachment","1315","3650","da","en"),
("611","post_page","1324","3651","en",NULL),
("612","post_page","1338","3652","en",NULL),
("615","post_nav_menu_item","1350","3655","en",NULL),
("617","post_page","1353","3657","en",NULL),
("618","post_nav_menu_item","1355","3658","en",NULL),
("619","post_nav_menu_item","1363","3659","en",NULL),
("620","post_attachment","1364","3660","en",NULL),
("621","post_attachment","1365","3660","da","en"),
("623","post_attachment","1372","3661","da",NULL),
("624","post_page","1374","3662","en",NULL),
("625","post_page","1376","3663","en",NULL),
("626","post_attachment","1390","3664","en",NULL),
("627","post_attachment","1391","3664","da","en"),
("629","post_attachment","1394","3665","da",NULL),
("630","post_attachment","1401","3666","en",NULL),
("631","post_attachment","1402","3666","da","en"),
("632","post_page","1408","3667","en",NULL),
("633","post_attachment","1434","3668","en",NULL),
("634","post_attachment","1435","3668","da","en"),
("636","post_attachment","1449","3669","da",NULL),
("637","post_attachment","1450","3670","en",NULL),
("638","post_attachment","1451","3670","da","en"),
("639","post_attachment","1455","3671","en",NULL),
("640","post_attachment","1456","3671","da","en"),
("642","post_attachment","1478","3672","da",NULL),
("643","post_attachment","1482","3673","en",NULL),
("644","post_attachment","1483","3673","da","en"),
("646","post_attachment","1490","3674","da",NULL),
("647","post_nav_menu_item","1504","3675","en",NULL),
("648","post_attachment","1512","3676","en",NULL),
("649","post_attachment","1513","3676","da","en"),
("650","post_page","1527","3677","en",NULL),
("651","post_attachment","1563","3678","en",NULL),
("652","post_attachment","1564","3678","da","en"),
("653","post_section_blocks","1575","3679","en",NULL),
("654","post_page","1578","3680","en",NULL);

INSERT INTO `wp_options` VALUES 
("1","siteurl","https://milo.sgsmedia.dk/wp","yes"),
("2","home","https://milo.sgsmedia.dk/wp","yes"),
("3","blogname","Milo","yes"),
("4","blogdescription","Just another WordPress site","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","info@sgsmedia.dk","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","0","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:165:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"region/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:42:\"region/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:23:\"region/([^/]+)/embed/?$\";s:39:\"index.php?region=$matches[1]&embed=true\";s:35:\"region/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?region=$matches[1]&paged=$matches[2]\";s:17:\"region/([^/]+)/?$\";s:28:\"index.php?region=$matches[1]\";s:35:\"country/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"country/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"country/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"country/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"country/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"country/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"country/([^/]+)/embed/?$\";s:40:\"index.php?country=$matches[1]&embed=true\";s:28:\"country/([^/]+)/trackback/?$\";s:34:\"index.php?country=$matches[1]&tb=1\";s:36:\"country/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?country=$matches[1]&paged=$matches[2]\";s:43:\"country/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?country=$matches[1]&cpage=$matches[2]\";s:32:\"country/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?country=$matches[1]&page=$matches[2]\";s:24:\"country/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"country/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"country/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"country/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"country/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"country/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"assets/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"assets/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"assets/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"assets/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"assets/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"assets/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"assets/([^/]+)/embed/?$\";s:39:\"index.php?assets=$matches[1]&embed=true\";s:27:\"assets/([^/]+)/trackback/?$\";s:33:\"index.php?assets=$matches[1]&tb=1\";s:35:\"assets/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?assets=$matches[1]&paged=$matches[2]\";s:42:\"assets/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?assets=$matches[1]&cpage=$matches[2]\";s:31:\"assets/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?assets=$matches[1]&page=$matches[2]\";s:23:\"assets/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"assets/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"assets/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"assets/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"assets/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"assets/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"statement/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"statement/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"statement/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"statement/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"statement/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"statement/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"statement/([^/]+)/embed/?$\";s:42:\"index.php?statement=$matches[1]&embed=true\";s:30:\"statement/([^/]+)/trackback/?$\";s:36:\"index.php?statement=$matches[1]&tb=1\";s:38:\"statement/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?statement=$matches[1]&paged=$matches[2]\";s:45:\"statement/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?statement=$matches[1]&cpage=$matches[2]\";s:34:\"statement/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?statement=$matches[1]&page=$matches[2]\";s:26:\"statement/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"statement/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"statement/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"statement/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"statement/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"statement/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"section_blocks/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"section_blocks/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"section_blocks/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"section_blocks/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"section_blocks/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"section_blocks/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"section_blocks/([^/]+)/embed/?$\";s:47:\"index.php?section_blocks=$matches[1]&embed=true\";s:35:\"section_blocks/([^/]+)/trackback/?$\";s:41:\"index.php?section_blocks=$matches[1]&tb=1\";s:43:\"section_blocks/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?section_blocks=$matches[1]&paged=$matches[2]\";s:50:\"section_blocks/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?section_blocks=$matches[1]&cpage=$matches[2]\";s:39:\"section_blocks/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?section_blocks=$matches[1]&page=$matches[2]\";s:31:\"section_blocks/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"section_blocks/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"section_blocks/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"section_blocks/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"section_blocks/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"section_blocks/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1376&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:12:{i:0;s:48:\"advanced-custom-fields-table-field/acf-table.php\";i:1;s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";i:2;s:18:\"acfml/wpml-acf.php\";i:3;s:34:\"advanced-custom-fields-pro/acf.php\";i:4;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:28:\"real-media-library/index.php\";i:7;s:40:\"sitepress-multilingual-cms/sitepress.php\";i:8;s:34:\"wpml-string-translation/plugin.php\";i:9;s:38:\"wpml-translation-management/plugin.php\";i:10;s:33:\"duplicate-post/duplicate-post.php\";i:11;s:33:\"duplicator-pro/duplicator-pro.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:2:{i:0;s:66:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/themes/milo/style.css\";i:1;s:0:\"\";}","no"),
("40","template","milo","yes"),
("41","stylesheet","milo","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","49752","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","0","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:1:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";a:2:{i:0;s:24:\"ADBC_Advanced_DB_Cleaner\";i:1;s:14:\"aDBc_uninstall\";}}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","1376","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1632503928","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","initial_db_version","49752","yes"),
("99","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("100","fresh_site","0","yes"),
("101","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("106","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}","yes"),
("107","cron","a:11:{i:1619507928;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1619513342;a:1:{s:41:\"puc_cron_check_updates-real-media-library\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1619528282;a:1:{s:24:\"update_wpml_config_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1619528342;a:1:{s:32:\"wpml-tm-check-overdue-jobs-event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1619543928;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1619543951;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1619543952;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1619787808;a:1:{s:27:\"wpml_tm_send_summary_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1620062328;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1621169882;a:1:{s:25:\"otgs_send_components_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}","yes"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","recovery_keys","a:0:{}","yes"),
("119","theme_mods_twentytwentyone","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617005827;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes"),
("120","https_detection_errors","a:0:{}","yes"),
("132","can_compress_scripts","1","no"),
("145","recently_activated","a:1:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";i:1618767055;}","yes"),
("146","acf_version","5.9.5","yes"),
("149","cptui_new_install","false","yes"),
("154","finished_updating_comment_type","1","yes"),
("155","acf_pro_license","YToyOntzOjM6ImtleSI7czo3NjoiYjNKa1pYSmZhV1E5TVRjd05qWXdmSFI1Y0dVOVpHVjJaV3h2Y0dWeWZHUmhkR1U5TWpBeE9TMHdPUzB4T1NBd09EbzFNRG94T0E9PSI7czozOiJ1cmwiO3M6Mjc6Imh0dHBzOi8vbWlsby5zZ3NtZWRpYS5kay93cCI7fQ==","yes"),
("156","edd_sl_dd9b23a13775ccc12b5389d301f8ef5d","a:2:{s:7:\"timeout\";i:1616962821;s:5:\"value\";s:26768:\"{\"new_version\":\"2.5.2\",\"stable_version\":\"2.5.2\",\"name\":\"ACF Theme Code Pro\",\"slug\":\"acf_theme_code_pro\",\"url\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/?changelog=1\",\"last_updated\":\"2021-02-19 15:29:30\",\"homepage\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\",\"changelog\":\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-128x128.jpg\",\"2x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-256x256.jpg\"},\"stable_tag\":\"\",\"tested\":\"\",\"description\":[\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"]}\";}","no"),
("160","hookturn_acftcp_license_key","19c84a6f7537c23321ace60f5b0466a2","yes"),
("163","hookturn_acftcp_license_status","valid","yes"),
("164","edd_sl_2800905b53e41bc246e398fbd91c4ed9","a:2:{s:7:\"timeout\";i:1619518083;s:5:\"value\";s:27162:\"{\"new_version\":\"2.5.2\",\"stable_version\":\"2.5.2\",\"name\":\"ACF Theme Code Pro\",\"slug\":\"acf_theme_code_pro\",\"url\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/?changelog=1\",\"last_updated\":\"2021-02-19 15:29:30\",\"homepage\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/\",\"package\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTYxOTYyOTY4MzoxOWM4NGE2Zjc1MzdjMjMzMjFhY2U2MGY1YjA0NjZhMjoxNTphYjIxN2IwZDQ0NzFiZTFlMjUzMTc4ZThhYzhlMDUyNjpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"download_link\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTYxOTYyOTY4MzoxOWM4NGE2Zjc1MzdjMjMzMjFhY2U2MGY1YjA0NjZhMjoxNTphYjIxN2IwZDQ0NzFiZTFlMjUzMTc4ZThhYzhlMDUyNjpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"sections\":{\"description\":\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\",\"changelog\":\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-128x128.jpg\",\"2x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-256x256.jpg\"},\"stable_tag\":\"\",\"tested\":\"\",\"description\":[\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"]}\";}","no"),
("185","current_theme","Milo","yes"),
("186","theme_mods_milo","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"header-menu\";i:5;s:11:\"footer-menu\";i:10;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:871;s:17:\"theme_logo_footer\";s:80:\"https://milo.sgsmedia.dk/wp/wp-content/uploads/2021/04/Milo_Logo_Equinox_RGB.svg\";}","yes"),
("187","theme_switched","","yes"),
("188","recovery_mode_email_last_sent","1618311376","yes"),
("190","rml_cqs","2","yes"),
("191","rml_db_version","4.13.4","yes"),
("192","real_utils-transients","{\"RML\":{\"raa\":true,\"nr\":1624783743}}","no"),
("194","external_updates-real-media-library","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1619501169;s:14:\"checkedVersion\";s:6:\"4.13.4\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:18:\"real-media-library\";s:7:\"version\";s:6:\"4.13.4\";s:12:\"download_url\";s:124:\"https://license.matthias-web.com/api/v1/packages/real-media-library/download?activation=bd94c180-906b-11eb-8a29-9b06769da92b\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:47:\"https://devowl.io/wordpress-real-media-library/\";s:6:\"tested\";s:3:\"5.7\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:28:\"real-media-library/index.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p4_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}","no"),
("195","rml_load_frontend","1","yes"),
("196","rml_licenseActivated-expire","1648543743","yes"),
("197","rml_licenseActivated","","yes"),
("198","rml_importTaxNotice-expire","1648543764","yes"),
("199","rml_importTaxNotice","","yes"),
("200","wpls_license_real-media-library","edc0a653-3ae0-42e4-bd5f-315e558ef4da","no"),
("201","envato_purchase_code_00000000","edc0a653-3ae0-42e4-bd5f-315e558ef4da","no"),
("202","wpls_activation_id_real-media-library","bd94c180-906b-11eb-8a29-9b06769da92b","no"),
("266","cptui_post_types","a:4:{s:7:\"country\";a:30:{s:4:\"name\";s:7:\"country\";s:5:\"label\";s:16:\"Milo - Countries\";s:14:\"singular_label\";s:7:\"Country\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:4:\"true\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:6:\"assets\";a:30:{s:4:\"name\";s:6:\"assets\";s:5:\"label\";s:13:\"Milo - Assets\";s:14:\"singular_label\";s:10:\"Milo Asset\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:9:\"statement\";a:30:{s:4:\"name\";s:9:\"statement\";s:5:\"label\";s:17:\"Milo - Statements\";s:14:\"singular_label\";s:9:\"Statement\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:14:\"section_blocks\";a:30:{s:4:\"name\";s:14:\"section_blocks\";s:5:\"label\";s:13:\"Milo - Global\";s:14:\"singular_label\";s:12:\"Global block\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}","yes"),
("349","cptui_taxonomies","a:1:{s:6:\"region\";a:25:{s:4:\"name\";s:6:\"region\";s:5:\"label\";s:7:\"Regions\";s:14:\"singular_label\";s:6:\"Region\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"show_ui\";s:4:\"true\";s:12:\"show_in_menu\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";s:17:\"show_admin_column\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:18:\"show_in_quick_edit\";s:0:\"\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:6:\"labels\";a:19:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:11:\"update_item\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:13:\"new_item_name\";s:0:\"\";s:11:\"parent_item\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:13:\"popular_items\";s:0:\"\";s:26:\"separate_items_with_commas\";s:0:\"\";s:19:\"add_or_remove_items\";s:0:\"\";s:21:\"choose_from_most_used\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:8:\"no_terms\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:13:\"back_to_items\";s:0:\"\";}s:11:\"meta_box_cb\";s:0:\"\";s:12:\"default_term\";s:0:\"\";s:12:\"object_types\";a:1:{i:0;s:7:\"country\";}}}","yes"),
("352","cpto_options","a:7:{s:23:\"show_reorder_interfaces\";a:4:{s:4:\"post\";s:4:\"show\";s:10:\"attachment\";s:4:\"show\";s:8:\"wp_block\";s:4:\"show\";s:7:\"country\";s:4:\"show\";}s:8:\"autosort\";s:0:\"\";s:9:\"adminsort\";i:1;s:18:\"use_query_ASC_DESC\";s:0:\"\";s:17:\"archive_drag_drop\";i:1;s:10:\"capability\";s:14:\"manage_options\";s:21:\"navigation_sort_apply\";i:1;}","yes"),
("353","CPT_configured","TRUE","yes"),
("368","duplicator_pro_reset_user_settings_required","0","yes"),
("369","duplicator_pro_plugin_version","4.0.2","yes"),
("370","duplicator_pro_license_key","80d49998f6265a26aa780fc8df4eab33","yes"),
("388","a42f12af0b7084cf112c3f1a6f6224b7","a:2:{s:7:\"timeout\";i:1619590678;s:5:\"value\";s:1139:\"{\"new_version\":\"4.0.2\",\"stable_version\":\"4.0.2\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/snapcreek.com\\/downloads\\/duplicator-pro\\/?changelog=1\",\"last_updated\":\"2021-04-12 11:27:01\",\"homepage\":\"https:\\/\\/snapcreek.com\\/duplicator\",\"package\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTYyMDYwMjI3Nzo4MGQ0OTk5OGY2MjY1YTI2YWE3ODBmYzhkZjRlYWIzMzozMTo5YTFkMDNkYWNhMjY5NTAyOTczMGUyMGYxNmQxMzk5ZDpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"download_link\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTYyMDYwMjI3Nzo4MGQ0OTk5OGY2MjY1YTI2YWE3ODBmYzhkZjRlYWIzMzozMTo5YTFkMDNkYWNhMjY5NTAyOTczMGUyMGYxNmQxMzk5ZDpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"sections\":{\"description\":\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\",\"changelog\":\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":\"a:0:{}\",\"tested\":\"5.7\",\"description\":[\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\"],\"changelog\":[\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\"]}\";}","yes"),
("405","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("801","WPLANG","","yes"),
("802","new_admin_email","info@sgsmedia.dk","yes"),
("1712","duplicate_post_copytitle","1","yes"),
("1713","duplicate_post_copydate","0","yes"),
("1714","duplicate_post_copystatus","0","yes"),
("1715","duplicate_post_copyslug","0","yes"),
("1716","duplicate_post_copyexcerpt","1","yes"),
("1717","duplicate_post_copycontent","1","yes"),
("1718","duplicate_post_copythumbnail","1","yes"),
("1719","duplicate_post_copytemplate","1","yes"),
("1720","duplicate_post_copyformat","1","yes"),
("1721","duplicate_post_copyauthor","0","yes"),
("1722","duplicate_post_copypassword","0","yes"),
("1723","duplicate_post_copyattachments","0","yes"),
("1724","duplicate_post_copychildren","0","yes"),
("1725","duplicate_post_copycomments","0","yes"),
("1726","duplicate_post_copymenuorder","1","yes"),
("1727","duplicate_post_taxonomies_blacklist","a:0:{}","yes"),
("1728","duplicate_post_blacklist","","yes"),
("1729","duplicate_post_types_enabled","a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}","yes"),
("1730","duplicate_post_show_original_column","0","yes"),
("1731","duplicate_post_show_original_in_post_states","0","yes"),
("1732","duplicate_post_show_original_meta_box","0","yes"),
("1733","duplicate_post_show_link","a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}","yes"),
("1734","duplicate_post_show_link_in","a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}","yes"),
("1735","duplicate_post_show_notice","0","no"),
("1736","duplicate_post_version","4.1.2","yes"),
("2089","options_social_media_icons_0_social_media_item_name","Facebook","no"),
("2090","_options_social_media_icons_0_social_media_item_name","field_606ead15579e4","no"),
("2091","options_social_media_icons_0_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n  <path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>\r\n","no"),
("2092","_options_social_media_icons_0_social_media_item_icon","field_606ead32579e5","no"),
("2093","options_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("2094","_options_social_media_icons_0_social_media_item_url","field_606ead3d579e6","no"),
("2095","options_social_media_icons_1_social_media_item_name","Youtube","no"),
("2096","_options_social_media_icons_1_social_media_item_name","field_606ead15579e4","no"),
("2097","options_social_media_icons_1_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n  <path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>\r\n","no"),
("2098","_options_social_media_icons_1_social_media_item_icon","field_606ead32579e5","no"),
("2099","options_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("2100","_options_social_media_icons_1_social_media_item_url","field_606ead3d579e6","no"),
("2101","options_social_media_icons_2_social_media_item_name","Instagram","no"),
("2102","_options_social_media_icons_2_social_media_item_name","field_606ead15579e4","no"),
("2103","options_social_media_icons_2_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n  <path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>\r\n","no"),
("2104","_options_social_media_icons_2_social_media_item_icon","field_606ead32579e5","no"),
("2105","options_social_media_icons_2_social_media_item_url","https://instagram.com","no"),
("2106","_options_social_media_icons_2_social_media_item_url","field_606ead3d579e6","no"),
("2107","options_social_media_icons","3","no"),
("2108","_options_social_media_icons","field_606eacf3a8d94","no"),
("2109","options_theme_header_scripts_head","<script>\r\nconsole.log(\"Within <head>\");\r\n</script>","no"),
("2110","_options_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("2111","options_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"After opening <body>\");\r\n</script>","no"),
("2112","_options_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("2113","options_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"Footer script\");\r\n</script>","no"),
("2114","_options_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("2194","options_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("2195","_options_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("2196","options_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("2197","_options_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("2198","options_theme_404_reuseable_section_rules","","no"),
("2199","_options_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("2200","options_theme_404_theme_404_text","<h2>404</h2>\r\n<strong>This page doesn\'t exist.</strong>\r\n\r\nPlease try again.","no"),
("2201","_options_theme_404_theme_404_text","field_606eff990ac3e","no"),
("2202","options_theme_404","","no"),
("2203","_options_theme_404","field_606eff05095e9","no"),
("2210","options_theme_404_header_theme","dark","no"),
("2211","_options_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3097","icl_sitepress_version","4.4.10","yes"),
("3098","icl_sitepress_settings","a:60:{s:19:\"hide_upgrade_notice\";s:6:\"4.4.10\";s:25:\"icl_capabilities_verified\";b:1;s:16:\"active_languages\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:21:\"interview_translators\";i:1;s:34:\"existing_content_language_verified\";i:1;s:25:\"language_negotiation_type\";s:1:\"1\";s:18:\"icl_lso_link_empty\";i:0;s:18:\"sync_page_ordering\";i:1;s:16:\"sync_page_parent\";i:1;s:18:\"sync_page_template\";i:1;s:16:\"sync_ping_status\";i:1;s:19:\"sync_comment_status\";i:1;s:16:\"sync_sticky_flag\";i:1;s:13:\"sync_password\";i:1;s:17:\"sync_private_flag\";i:1;s:16:\"sync_post_format\";i:1;s:11:\"sync_delete\";i:0;s:15:\"sync_delete_tax\";i:0;s:20:\"sync_post_taxonomies\";i:1;s:14:\"sync_post_date\";i:0;s:21:\"sync_taxonomy_parents\";i:0;s:25:\"translation_pickup_method\";i:0;s:15:\"notify_complete\";i:1;s:26:\"translated_document_status\";i:1;s:17:\"remote_management\";i:0;s:15:\"auto_adjust_ids\";i:1;s:11:\"alert_delay\";i:0;s:12:\"promote_wpml\";i:0;s:18:\"automatic_redirect\";i:0;s:17:\"remember_language\";i:24;s:28:\"icl_lang_sel_copy_parameters\";s:0:\"\";s:28:\"translated_document_page_url\";s:13:\"auto-generate\";s:27:\"sync_comments_on_duplicates\";i:0;s:3:\"seo\";a:3:{s:10:\"head_langs\";i:1;s:27:\"canonicalization_duplicates\";i:1;s:19:\"head_langs_priority\";i:1;}s:22:\"posts_slug_translation\";a:2:{s:2:\"on\";i:1;s:20:\"string_name_migrated\";b:1;}s:4:\"urls\";a:5:{s:30:\"directory_for_default_language\";i:0;s:12:\"show_on_root\";s:0:\"\";s:19:\"root_html_file_path\";s:0:\"\";s:9:\"root_page\";i:0;s:23:\"hide_language_switchers\";i:1;}s:12:\"xdomain_data\";s:1:\"1\";s:24:\"custom_posts_sync_option\";a:13:{s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;s:10:\"custom_css\";s:1:\"0\";s:19:\"customize_changeset\";s:1:\"0\";s:12:\"oembed_cache\";s:1:\"0\";s:12:\"user_request\";s:1:\"0\";s:15:\"acf-field-group\";s:1:\"0\";s:7:\"country\";s:1:\"0\";s:6:\"assets\";s:1:\"2\";s:9:\"statement\";s:1:\"2\";s:14:\"section_blocks\";s:1:\"2\";}s:22:\"taxonomies_sync_option\";a:3:{s:8:\"category\";i:1;s:8:\"post_tag\";i:1;s:20:\"translation_priority\";i:1;}s:28:\"tm_block_retranslating_terms\";i:1;s:22:\"admin_default_language\";s:9:\"_default_\";s:22:\"taxonomy_names_checked\";b:1;s:14:\"setup_complete\";i:1;s:18:\"ajx_health_checked\";b:1;s:2:\"st\";a:17:{s:25:\"db_ok_for_gettext_context\";b:1;s:41:\"WPML_ST_Upgrade_Migrate_Originals_has_run\";b:1;s:48:\"WPML_ST_Upgrade_Db_Cache_Command_2.4.2_2_has_run\";b:1;s:52:\"WPML_ST_Upgrade_Display_Strings_Scan_Notices_has_run\";b:1;s:37:\"WPML_ST_Upgrade_MO_Scanning_4_has_run\";b:1;s:46:\"WPML_ST_Upgrade_DB_String_Name_Index_2_has_run\";b:1;s:48:\"WPML_ST_Upgrade_DB_Longtext_String_Value_has_run\";b:1;s:53:\"WPML\\ST\\MO\\Generate\\Process\\Status_background_has_run\";b:1;s:64:\"WPML\\ST\\Upgrade\\Command\\RegenerateMoFilesWithStringNames_has_run\";b:1;s:42:\"WPML\\ST\\MO\\Generate\\Process\\Status_has_run\";b:1;s:16:\"strings_per_page\";i:10;s:15:\"icl_st_auto_reg\";s:7:\"disable\";s:16:\"strings_language\";s:2:\"en\";s:16:\"translated-users\";a:0:{}s:2:\"sw\";a:0:{}s:53:\"WPML_ST_Upgrade_DB_String_Packages_Word_Count_has_run\";b:1;s:48:\"WPML_ST_Upgrade_DB_String_Packages_2.4.2_has_run\";b:1;}s:18:\"default_categories\";a:2:{s:2:\"en\";s:1:\"1\";s:2:\"da\";i:11;}s:16:\"default_language\";s:2:\"en\";s:17:\"setup_wizard_step\";i:6;s:66:\"admin_text_3_2_migration_complete_0e76ff20c1fe93878b4cf152f317989a\";b:1;s:22:\"translation-management\";a:14:{s:25:\"custom_fields_translation\";a:116:{s:5:\"title\";i:2;s:11:\"description\";i:2;s:8:\"keywords\";i:2;s:10:\"_edit_last\";i:0;s:10:\"_edit_lock\";i:0;s:17:\"_wp_page_template\";i:0;s:23:\"_wp_attachment_metadata\";i:0;s:16:\"original_post_id\";i:0;s:22:\"_wpml_original_post_id\";i:0;s:12:\"_wp_old_slug\";i:0;s:20:\"_icl_translator_note\";i:0;s:14:\"_alp_processed\";i:0;s:7:\"_pingme\";i:0;s:10:\"_encloseme\";i:0;s:22:\"_icl_lang_duplicate_of\";i:0;s:13:\"_thumbnail_id\";i:0;s:17:\"_wp_attached_file\";i:0;s:24:\"_wp_attachment_image_alt\";i:2;s:22:\"country_dealor_locator\";i:3;s:24:\"country_announcement_bar\";i:3;s:20:\"theme_settings_group\";i:1;s:18:\"social_media_icons\";i:0;s:22:\"social_media_item_name\";i:0;s:22:\"social_media_item_icon\";i:0;s:21:\"social_media_item_url\";i:0;s:21:\"_theme_settings_group\";i:1;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_0_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_1_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_2_social_media_item_url\";i:0;s:39:\"theme_settings_group_social_media_icons\";i:0;s:15:\"statement_slide\";i:3;s:16:\"_statement_slide\";i:1;s:50:\"flex_items_6_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_6_reuseable_buttons_button_custom_items\";i:1;s:37:\"reuseable_buttons_button_custom_items\";i:3;s:38:\"_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_1_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_1_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_0_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_0_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_4_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_4_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_5_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_5_reuseable_buttons_button_custom_items\";i:1;s:19:\"button_custom_items\";i:3;s:20:\"_button_custom_items\";i:1;s:84:\"global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:3;s:85:\"_global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:1;s:29:\"adventure_category_block_item\";i:3;s:30:\"_adventure_category_block_item\";i:1;s:20:\"product_assets_items\";i:3;s:21:\"_product_assets_items\";i:1;s:17:\"global_flex_items\";i:3;s:18:\"_global_flex_items\";i:1;s:36:\"global_adventure_category_block_item\";i:3;s:37:\"_global_adventure_category_block_item\";i:1;s:41:\"global_flex_items_0_whats_in_the_box_spec\";i:3;s:42:\"_global_flex_items_0_whats_in_the_box_spec\";i:1;s:21:\"whats_in_the_box_spec\";i:3;s:22:\"_whats_in_the_box_spec\";i:1;s:37:\"global_flex_items_0_global_specs_item\";i:3;s:38:\"_global_flex_items_0_global_specs_item\";i:1;s:17:\"global_specs_item\";i:3;s:18:\"_global_specs_item\";i:1;s:35:\"global_flex_items_0_global_faq_item\";i:3;s:36:\"_global_flex_items_0_global_faq_item\";i:1;s:15:\"global_faq_item\";i:3;s:16:\"_global_faq_item\";i:1;s:10:\"flex_items\";i:3;s:11:\"_flex_items\";i:1;s:23:\"_country_dealor_locator\";i:1;s:25:\"_country_announcement_bar\";i:1;s:24:\"flex_items_10_step_items\";N;s:50:\"flex_items_7_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_7_reuseable_buttons_button_custom_items\";i:1;s:24:\"flex_items_11_step_items\";N;s:23:\"flex_items_3_step_items\";N;s:50:\"flex_items_8_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_8_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_9_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_9_reuseable_buttons_button_custom_items\";i:1;s:51:\"flex_items_10_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_10_reuseable_buttons_button_custom_items\";i:1;s:51:\"flex_items_11_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_11_reuseable_buttons_button_custom_items\";i:1;s:23:\"flex_items_2_step_items\";N;s:23:\"flex_items_1_step_items\";N;s:23:\"flex_items_7_step_items\";N;s:29:\"flex_items_1_content_gridcol2\";N;s:29:\"flex_items_3_content_gridcol2\";N;s:29:\"flex_items_4_content_gridcol2\";N;s:23:\"flex_items_5_step_items\";N;s:29:\"flex_items_2_content_gridcol2\";N;s:29:\"flex_items_5_content_gridcol2\";N;s:29:\"flex_items_6_content_gridcol2\";N;s:29:\"flex_items_7_content_gridcol2\";N;s:23:\"flex_items_4_step_items\";N;s:50:\"flex_items_2_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_2_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_3_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_3_reuseable_buttons_button_custom_items\";i:1;s:23:\"flex_items_9_step_items\";N;s:24:\"flex_items_13_step_items\";N;s:24:\"flex_items_15_step_items\";N;s:24:\"flex_items_16_step_items\";N;s:23:\"flex_items_6_step_items\";N;s:24:\"flex_items_17_step_items\";N;s:24:\"flex_items_18_step_items\";N;s:51:\"flex_items_18_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_18_reuseable_buttons_button_custom_items\";i:1;}s:29:\"custom_fields_readonly_config\";a:18:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:24:\"_wp_attachment_image_alt\";}s:32:\"custom_fields_translation_custom\";a:0:{}s:41:\"custom_fields_translation_custom_readonly\";a:0:{}s:22:\"doc_translation_method\";i:0;s:35:\"__custom_types_readonly_config_prev\";a:0:{}s:28:\"custom_types_readonly_config\";a:0:{}s:36:\"__custom_fields_readonly_config_prev\";a:18:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:24:\"_wp_attachment_image_alt\";}s:41:\"__custom_term_fields_readonly_config_prev\";a:0:{}s:34:\"custom_term_fields_readonly_config\";a:0:{}s:26:\"taxonomies_readonly_config\";a:1:{s:20:\"translation_priority\";i:1;}s:28:\"custom-types_readonly_config\";a:2:{s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;}s:12:\"notification\";a:9:{s:7:\"new-job\";i:1;s:13:\"include_xliff\";i:0;s:19:\"completed_frequency\";i:3;s:9:\"completed\";i:1;s:8:\"resigned\";i:1;s:7:\"overdue\";i:1;s:14:\"overdue_offset\";i:7;s:9:\"dashboard\";b:1;s:9:\"purge-old\";i:7;}s:30:\"custom_term_fields_translation\";a:98:{s:22:\"country_dealor_locator\";i:3;s:24:\"country_announcement_bar\";i:3;s:20:\"theme_settings_group\";i:1;s:18:\"social_media_icons\";i:0;s:22:\"social_media_item_name\";i:0;s:22:\"social_media_item_icon\";i:0;s:21:\"social_media_item_url\";i:0;s:21:\"_theme_settings_group\";i:1;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_0_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_1_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_2_social_media_item_url\";i:0;s:39:\"theme_settings_group_social_media_icons\";i:0;s:15:\"statement_slide\";i:3;s:16:\"_statement_slide\";i:1;s:50:\"flex_items_6_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_6_reuseable_buttons_button_custom_items\";i:1;s:37:\"reuseable_buttons_button_custom_items\";i:3;s:38:\"_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_1_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_1_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_0_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_0_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_4_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_4_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_5_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_5_reuseable_buttons_button_custom_items\";i:1;s:19:\"button_custom_items\";i:3;s:20:\"_button_custom_items\";i:1;s:84:\"global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:3;s:85:\"_global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:1;s:29:\"adventure_category_block_item\";i:3;s:30:\"_adventure_category_block_item\";i:1;s:20:\"product_assets_items\";i:3;s:21:\"_product_assets_items\";i:1;s:17:\"global_flex_items\";i:3;s:18:\"_global_flex_items\";i:1;s:36:\"global_adventure_category_block_item\";i:3;s:37:\"_global_adventure_category_block_item\";i:1;s:41:\"global_flex_items_0_whats_in_the_box_spec\";i:3;s:42:\"_global_flex_items_0_whats_in_the_box_spec\";i:1;s:21:\"whats_in_the_box_spec\";i:3;s:22:\"_whats_in_the_box_spec\";i:1;s:37:\"global_flex_items_0_global_specs_item\";i:3;s:38:\"_global_flex_items_0_global_specs_item\";i:1;s:17:\"global_specs_item\";i:3;s:18:\"_global_specs_item\";i:1;s:35:\"global_flex_items_0_global_faq_item\";i:3;s:36:\"_global_flex_items_0_global_faq_item\";i:1;s:15:\"global_faq_item\";i:3;s:16:\"_global_faq_item\";i:1;s:10:\"flex_items\";i:3;s:11:\"_flex_items\";i:1;s:23:\"_country_dealor_locator\";i:1;s:25:\"_country_announcement_bar\";i:1;s:24:\"flex_items_10_step_items\";N;s:50:\"flex_items_7_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_7_reuseable_buttons_button_custom_items\";i:1;s:24:\"flex_items_11_step_items\";N;s:23:\"flex_items_3_step_items\";N;s:50:\"flex_items_8_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_8_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_9_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_9_reuseable_buttons_button_custom_items\";i:1;s:51:\"flex_items_10_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_10_reuseable_buttons_button_custom_items\";i:1;s:51:\"flex_items_11_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_11_reuseable_buttons_button_custom_items\";i:1;s:23:\"flex_items_2_step_items\";N;s:23:\"flex_items_1_step_items\";N;s:23:\"flex_items_7_step_items\";N;s:29:\"flex_items_1_content_gridcol2\";N;s:29:\"flex_items_3_content_gridcol2\";N;s:29:\"flex_items_4_content_gridcol2\";N;s:23:\"flex_items_5_step_items\";N;s:29:\"flex_items_2_content_gridcol2\";N;s:29:\"flex_items_5_content_gridcol2\";N;s:29:\"flex_items_6_content_gridcol2\";N;s:29:\"flex_items_7_content_gridcol2\";N;s:23:\"flex_items_4_step_items\";N;s:50:\"flex_items_2_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_2_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_3_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_3_reuseable_buttons_button_custom_items\";i:1;s:23:\"flex_items_9_step_items\";N;s:24:\"flex_items_13_step_items\";N;s:24:\"flex_items_15_step_items\";N;s:24:\"flex_items_16_step_items\";N;s:23:\"flex_items_6_step_items\";N;s:24:\"flex_items_17_step_items\";N;s:24:\"flex_items_18_step_items\";N;s:51:\"flex_items_18_reuseable_buttons_button_custom_items\";i:3;s:52:\"_flex_items_18_reuseable_buttons_button_custom_items\";i:1;}}s:24:\"custom-types_sync_option\";a:2:{s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;}s:29:\"language_selector_initialized\";i:1;s:15:\"languages_order\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:27:\"dont_show_help_admin_notice\";b:1;s:8:\"site_key\";s:10:\"62PcN7ptS9\";s:14:\"xliff_newlines\";i:2;s:16:\"tm_xliff_version\";s:2:\"12\";s:21:\"site_does_not_use_icl\";b:1;s:31:\"language_per_domain_sso_enabled\";b:0;s:28:\"custom_posts_unlocked_option\";a:13:{s:4:\"post\";s:1:\"0\";s:4:\"page\";s:1:\"0\";s:10:\"attachment\";s:1:\"0\";s:10:\"custom_css\";s:1:\"0\";s:19:\"customize_changeset\";s:1:\"0\";s:12:\"oembed_cache\";s:1:\"0\";s:12:\"user_request\";s:1:\"0\";s:8:\"wp_block\";s:1:\"0\";s:15:\"acf-field-group\";s:1:\"0\";s:7:\"country\";s:1:\"0\";s:6:\"assets\";s:1:\"0\";s:9:\"statement\";s:1:\"0\";s:14:\"section_blocks\";s:1:\"0\";}}","yes"),
("3099","_wpml_media","a:2:{s:20:\"new_content_settings\";a:3:{s:22:\"always_translate_media\";b:1;s:15:\"duplicate_media\";b:0;s:18:\"duplicate_featured\";b:0;}s:13:\"starting_help\";i:1;}","yes"),
("3101","wpml_dependencies:needs_validation","","yes"),
("3102","wpml_dependencies:valid_plugins","a:3:{i:0;s:26:\"sitepress-multilingual-cms\";i:1;s:23:\"wpml-string-translation\";i:2;s:27:\"wpml-translation-management\";}","yes"),
("3103","wpml_dependencies:invalid_plugins","a:0:{}","yes"),
("3104","wpml_dependencies:expected_versions","a:8:{s:26:\"sitepress-multilingual-cms\";s:6:\"4.4.10\";s:23:\"wpml-string-translation\";s:5:\"3.1.8\";s:27:\"wpml-translation-management\";s:6:\"2.10.6\";s:24:\"woocommerce-multilingual\";s:5:\"4.7.8\";s:22:\"wpml-media-translation\";s:5:\"2.6.4\";s:17:\"wpml-sticky-links\";s:5:\"1.5.0\";s:12:\"wpml-cms-nav\";s:5:\"1.5.0\";s:25:\"gravityforms-multilingual\";s:5:\"1.5.0\";}","yes"),
("3105","wpml_config_index","O:8:\"stdClass\":2:{s:7:\"plugins\";a:77:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:33:\"10bit WooCommerce Gateway Yaadpay\";s:14:\"override_local\";b:1;s:4:\"path\";s:61:\"wpml-config/10bit-woocommerce-gateway-yaadpay/wpml-config.xml\";s:7:\"updated\";i:1464939780;s:4:\"hash\";s:32:\"ebdce80f3b6bfa13112b1d4c6a31b560\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Atomic Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/atomic-blocks/wpml-config.xml\";s:7:\"updated\";i:1585156226;s:4:\"hash\";s:32:\"8d93d53d0fa037f291aaf9aa5980c287\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Book Now\";s:14:\"override_local\";b:0;s:4:\"path\";s:36:\"wpml-config/book-now/wpml-config.xml\";s:7:\"updated\";i:1505319840;s:4:\"hash\";s:32:\"d123c0bb22d447095c3c443cb41c273a\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"Beaver Builder Plugin (Lite Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Beaver Builder Plugin (Pro Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Cornerstone\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/cornerstone/wpml-config.xml\";s:7:\"updated\";i:1615980863;s:4:\"hash\";s:32:\"72c530c79ebe68006852d7969faa920d\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/custom-post-type-ui/wpml-config.xml\";s:7:\"updated\";i:1604075857;s:4:\"hash\";s:32:\"c35b9664bea4b9d9b83b5748e14be9b0\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"Divi Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/divi-builder/wpml-config.xml\";s:7:\"updated\";i:1618826946;s:4:\"hash\";s:32:\"6c2c50dafeb044c0c6dc19f22a6ef9fa\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Event Tickets Plus\";s:14:\"override_local\";b:0;s:4:\"path\";s:46:\"wpml-config/event-tickets-plus/wpml-config.xml\";s:7:\"updated\";i:1477310580;s:4:\"hash\";s:32:\"f333802d6c6c9836466d3ff52cfe2bd7\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WPBakery Visual Composer\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:37:\"Uncode Page Builder (Visual Composer)\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Uncode WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"The7 WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/js_composer-dt-the7/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"caf05daa7509c1127194c88dee427879\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"MailChimp for WordPress\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/mailchimp-for-wp/wpml-config.xml\";s:7:\"updated\";i:1509614640;s:4:\"hash\";s:32:\"c4f8573312cdf0f71d9329ae82d4ec49\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Members\";s:14:\"override_local\";b:0;s:4:\"path\";s:35:\"wpml-config/members/wpml-config.xml\";s:7:\"updated\";i:1497367620;s:4:\"hash\";s:32:\"37e638f5a56f59208150c3649c291e41\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:46:\"Multibanco (IfthenPay gateway) for WooCommerce\";s:14:\"override_local\";b:0;s:4:\"path\";s:72:\"wpml-config/multibanco-ifthenpay-gateway-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1441014780;s:4:\"hash\";s:32:\"3cddef77fd163e090472f995aa2388d4\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"NW ADCart for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:53:\"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734260;s:4:\"hash\";s:32:\"91d62df0659fc7b561a3932a7a52de6a\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:22:\"PayPal for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:50:\"wpml-config/paypal-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1504696980;s:4:\"hash\";s:32:\"8d98b39c86e95094e6b7727fda7a6f00\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Product Enquiry Pro for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734500;s:4:\"hash\";s:32:\"305232f06370d52a29c346d6b711f50a\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Sensei\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1608203125;s:4:\"hash\";s:32:\"fa341db21f78fc003f66f7b13a239fd2\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Sensei LMS\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1608203125;s:4:\"hash\";s:32:\"fa341db21f78fc003f66f7b13a239fd2\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Subscriptio\";s:14:\"override_local\";b:0;s:4:\"path\";s:39:\"wpml-config/subscriptio/wpml-config.xml\";s:7:\"updated\";i:1519647600;s:4:\"hash\";s:32:\"a23128c1dde651ef63093336042948e5\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPML Multilingual CMS\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/sitepress-multilingual-cms/wpml-config.xml\";s:7:\"updated\";i:1611515848;s:4:\"hash\";s:32:\"262f1fffdf41236fd99cfab04ed45b26\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"The Events Calendar\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/the-events-calendar/wpml-config.xml\";s:7:\"updated\";i:1597940433;s:4:\"hash\";s:32:\"9dc1b1aa9bdd03cb5f8057ebb4976651\";}i:25;O:8:\"stdClass\":5:{s:4:\"name\";s:31:\"The Events Calendar: Filter Bar\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/events-filterbar/wpml-config.xml\";s:7:\"updated\";i:1529671740;s:4:\"hash\";s:32:\"787231e7b7cdb54ca447512234be0768\";}i:26;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Woocomerce Brands Pro\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/woo-brand/wpml-config.xml\";s:7:\"updated\";i:1442243400;s:4:\"hash\";s:32:\"dc7eeb10cd6e0eb80b7960eb8b6058a4\";}i:27;O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"WooCommerce Additional Variation Images\";s:14:\"override_local\";b:1;s:4:\"path\";s:67:\"wpml-config/woocommerce-additional-variation-images/wpml-config.xml\";s:7:\"updated\";i:1479214860;s:4:\"hash\";s:32:\"39b5f72684021b09b12b53b7ff9c7100\";}i:28;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"WooCommerce Advanced Product Labels\";s:14:\"override_local\";b:0;s:4:\"path\";s:63:\"wpml-config/woocommerce-advanced-product-labels/wpml-config.xml\";s:7:\"updated\";i:1441177080;s:4:\"hash\";s:32:\"4b29c29516a1a33b328d90ffc5c4aad7\";}i:29;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Bookings\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-bookings/wpml-config.xml\";s:7:\"updated\";i:1518696060;s:4:\"hash\";s:32:\"cf704fa60399163e82de88dfca25b644\";}i:30;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"WooCommerce Catalog Visibility Options\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml\";s:7:\"updated\";i:1408625580;s:4:\"hash\";s:32:\"d10bd6388a88521e488f7e4ba295c94c\";}i:31;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Composite Products\";s:14:\"override_local\";b:0;s:4:\"path\";s:58:\"wpml-config/woocommerce-composite-products/wpml-config.xml\";s:7:\"updated\";i:1491207900;s:4:\"hash\";s:32:\"a6c0ed6554be69f56779f64506ab96d1\";}i:32;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Currency Converter\";s:14:\"override_local\";b:1;s:4:\"path\";s:58:\"wpml-config/woocommerce-currency-converter/wpml-config.xml\";s:7:\"updated\";i:1452009180;s:4:\"hash\";s:32:\"b2191d7affaf1efe74e6a3ca4b0494c6\";}i:33;O:8:\"stdClass\":5:{s:4:\"name\";s:32:\"WooCommerce DIBS FlexWin Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:60:\"wpml-config/woocommerce-dibs-flexwin-gateway/wpml-config.xml\";s:7:\"updated\";i:1459514460;s:4:\"hash\";s:32:\"d9237f895f0f133c8e11f4753d96eeca\";}i:34;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Embed Slides\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-embed-slides/wpml-config.xml\";s:7:\"updated\";i:1499457300;s:4:\"hash\";s:32:\"243e3a54d920cc2ddf96f17f4ff38f2d\";}i:35;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Local Pickup Plus\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-local-pickup-plus/wpml-config.xml\";s:7:\"updated\";i:1442582820;s:4:\"hash\";s:32:\"816774f477bfa1c481cdba021d33f705\";}i:36;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Multilingual\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-multilingual/wpml-config.xml\";s:7:\"updated\";i:1582106737;s:4:\"hash\";s:32:\"11b7488184353144fae7147f143b5150\";}i:37;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Memberships\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-memberships/wpml-config.xml\";s:7:\"updated\";i:1585587094;s:4:\"hash\";s:32:\"b12275a5491bc1858f181f56158b7a91\";}i:38;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Name Your Price\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-name-your-price/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"055de38e55802236ee636eec63bdde5e\";}i:39;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Paymill Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-paymill-gateway/wpml-config.xml\";s:7:\"updated\";i:1408626540;s:4:\"hash\";s:32:\"46409842584ff8df43a2aa922ad1d388\";}i:40;O:8:\"stdClass\":5:{s:4:\"name\";s:40:\"WooCommerce PDF Invoices & Packing Slips\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-pdf-invoices-packing-slips/wpml-config.xml\";s:7:\"updated\";i:1461579300;s:4:\"hash\";s:32:\"34ecf8066c5c9042a0bd60b5d40c4c55\";}i:41;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"WooCommerce Plivo\";s:14:\"override_local\";b:1;s:4:\"path\";s:45:\"wpml-config/woocommerce-plivo/wpml-config.xml\";s:7:\"updated\";i:1409734680;s:4:\"hash\";s:32:\"539d172825c4714d69b8a42ad1826c5d\";}i:42;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce PostePay\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-postepay/wpml-config.xml\";s:7:\"updated\";i:1409063100;s:4:\"hash\";s:32:\"b08722979a25b15ba4a02a16fb555ccc\";}i:43;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"WooCommerce Price by Country\";s:14:\"override_local\";b:1;s:4:\"path\";s:56:\"wpml-config/woocommerce-price-by-country/wpml-config.xml\";s:7:\"updated\";i:1415282880;s:4:\"hash\";s:32:\"9b296d64ba8afee80cb1ff4fac80144b\";}i:44;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Add-ons\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-add-ons/wpml-config.xml\";s:7:\"updated\";i:1476961740;s:4:\"hash\";s:32:\"69f94bed6e4b3546cc7be2fbd2bf392b\";}i:45;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Bundles\";s:14:\"override_local\";b:0;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-bundles/wpml-config.xml\";s:7:\"updated\";i:1487080740;s:4:\"hash\";s:32:\"7cddba745169acd899b12f24e3580dcc\";}i:46;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Product Gift Wrap\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml\";s:7:\"updated\";i:1429639980;s:4:\"hash\";s:32:\"dd3371d64d2ee01e6e42fd7e0bd134cf\";}i:47;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"Woocommerce Social Media Share Buttons\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-social-media-share-buttons/wpml-config.xml\";s:7:\"updated\";i:1464934800;s:4:\"hash\";s:32:\"3130bbf2a35424d9ecd8d6c3255bf817\";}i:48;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"WooCommerce Stripe Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/woocommerce-gateway-stripe/wpml-config.xml\";s:7:\"updated\";i:1409061480;s:4:\"hash\";s:32:\"4139e23bcdd0bb3e78cb079fa851ce85\";}i:49;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Tab Manager\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-tab-manager/wpml-config.xml\";s:7:\"updated\";i:1505158140;s:4:\"hash\";s:32:\"477be025d13abe1c1b89bb7666564ed6\";}i:50;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WooCommerce Video Tab\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/woocommerce-video-tab/wpml-config.xml\";s:7:\"updated\";i:1415284320;s:4:\"hash\";s:32:\"7f9769bc2769e07ae730f3b4cd307741\";}i:51;O:8:\"stdClass\":5:{s:4:\"name\";s:14:\"WP Job Manager\";s:14:\"override_local\";b:0;s:4:\"path\";s:42:\"wpml-config/wp-job-manager/wpml-config.xml\";s:7:\"updated\";i:1499098260;s:4:\"hash\";s:32:\"36842c6b8a11a733ef00ef8d9bc410b9\";}i:52;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"WPML Test Config\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/wpml-test-config/wpml-config.xml\";s:7:\"updated\";i:1429103280;s:4:\"hash\";s:32:\"9c3bb313d5a4f028bebfa8fc8af990a3\";}i:53;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/yoast-seo/wpml-config.xml\";s:7:\"updated\";i:1530098880;s:4:\"hash\";s:32:\"4014a9b37ac42f0cc726390fb9088ebc\";}i:54;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/wordpress-seo/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:55;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"Yoast SEO Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/wordpress-seo-premium/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:56;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Elementor\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/elementor/wpml-config.xml\";s:7:\"updated\";i:1615983959;s:4:\"hash\";s:32:\"8e4061e7a2a47e83af0f14ee2bc8c361\";}i:57;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Exit Popup\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/exit-popup/wpml-config.xml\";s:7:\"updated\";i:1532441340;s:4:\"hash\";s:32:\"9759f24db8621dfa772d7222c9c336dd\";}i:58;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Ninja Forms\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/ninja-forms/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"7b3321902299b49238e59d0741ce1f8d\";}i:59;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Rezgo Online Booking\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/rezgo/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"6f3433a4c5eafa13eaf125eea7d84239\";}i:60;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"MasterSlider\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/master-slider/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"2b5b8d5c1d934ee19a547b66d6c76b69\";}i:61;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Advanced Comment Form\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/comment-form/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a84c0e28e4c97dec1a3053c316c27892\";}i:62;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Search & Filter\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/search-filter/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"104b64d62b408a4ae7c5da7ff0acd0b2\";}i:63;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"KingComposer\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/kingcomposer/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"cadb27cc7ba0e61d3fd2acaf27fef4df\";}i:64;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Ultimate Member\";s:14:\"override_local\";b:1;s:4:\"path\";s:43:\"wpml-config/ultimate-member/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"c80a46117b6be17e1099cb0640f8e722\";}i:65;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"Google Analytics Opt-Out\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/google-analytics-opt-out/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"823965222ce323c88eadbcf95dcde0ff\";}i:66;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"Ajax Search Lite\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/ajax-search-lite/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"79dc60103bbc2eaaf6ac2ff25ca8dfa7\";}i:67;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Paid Memberships Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/paid-memberships-pro/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a26838992708887d6825bd1fbdceca59\";}i:68;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Forminator\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/forminator/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"ae0a6b1f1bc9fc80ada4833f9ee8917c\";}i:69;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"WooCommerce Mix and Match\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/woocommerce-mix-and-match-products/wpml-config.xml\";s:7:\"updated\";i:1578929211;s:4:\"hash\";s:32:\"82f7fa28a3b0a601056911af209995a2\";}i:70;O:8:\"stdClass\":5:{s:4:\"name\";s:47:\"Kadence Blocks - Gutenberg Page Builder Toolkit\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/kadence-blocks/wpml-config.xml\";s:7:\"updated\";i:1589279268;s:4:\"hash\";s:32:\"e3fa847064d1728f8cc936efdbb8077d\";}i:71;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"Ultimate Addons for Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/ultimate-addons-for-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1611145301;s:4:\"hash\";s:32:\"af52385e3657708d91a1d28c046342a1\";}i:72;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Advanced Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1597406669;s:4:\"hash\";s:32:\"76d5552bcf5216438a355122de2a4b76\";}i:73;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"PublishPress Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1597406669;s:4:\"hash\";s:32:\"76d5552bcf5216438a355122de2a4b76\";}i:74;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Click to Chat\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/click-to-chat-for-whatsapp/wpml-config.xml\";s:7:\"updated\";i:1595252694;s:4:\"hash\";s:32:\"ddd29301ed98494707ce5145d2f25ecd\";}i:75;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Rank Math SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/seo-by-rank-math/wpml-config.xml\";s:7:\"updated\";i:1595411877;s:4:\"hash\";s:32:\"0afae267f73a47afd09ae1d322c41735\";}i:76;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Stackable - Gutenberg Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/stackable-ultimate-gutenberg-blocks/wpml-config.xml\";s:7:\"updated\";i:1610535270;s:4:\"hash\";s:32:\"81a1302839deec3105eb9bebcedb4270\";}}s:6:\"themes\";a:25:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Avada\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/avada/wpml-config.xml\";s:7:\"updated\";i:1617612951;s:4:\"hash\";s:32:\"57f25f9087aafe2c8f171f8734107152\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Astra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/astra/wpml-config.xml\";s:7:\"updated\";i:1611238423;s:4:\"hash\";s:32:\"fcaa309ae11fe39ec0e9c99c34bc3efb\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Brooklyn\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/brooklyn/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"960edb3057ad96e2863221e82a4c69d2\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Canvas\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/canvas/wpml-config.xml\";s:7:\"updated\";i:1476729660;s:4:\"hash\";s:32:\"ea1da43b18f87c4aa73982113067cd95\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Customizr\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/customizr/wpml-config.xml\";s:7:\"updated\";i:1440909000;s:4:\"hash\";s:32:\"d63f73a0df72ab558bdbfaadaeb9c737\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Divi\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/Divi/wpml-config.xml\";s:7:\"updated\";i:1619003983;s:4:\"hash\";s:32:\"db498a4b54844c8a38a6750cc969b12c\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"The7\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/dt-the7/wpml-config.xml\";s:7:\"updated\";i:1534160160;s:4:\"hash\";s:32:\"b99fe39e5d53275b0237a65894036893\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Extra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/extra/wpml-config.xml\";s:7:\"updated\";i:1576677617;s:4:\"hash\";s:32:\"6f40ff074142d6392f49267cbb1176f2\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Emerald CV\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/emerald-cv/wpml-config.xml\";s:7:\"updated\";i:1460387160;s:4:\"hash\";s:32:\"3ab5fd101b71e7b306e48a07801c7557\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Enfold\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/enfold/wpml-config.xml\";s:7:\"updated\";i:1617117834;s:4:\"hash\";s:32:\"a9a32a365b8191be61a5151099f07559\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Function\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/function/wpml-config.xml\";s:7:\"updated\";i:1476729720;s:4:\"hash\";s:32:\"bb6dd583fb2a28ee5c4e2a264a770d60\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Genesis\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/genesis/wpml-config.xml\";s:7:\"updated\";i:1456825680;s:4:\"hash\";s:32:\"795657d127a84e450ad21218284bdd28\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"IDStore - Responsive WordPress Theme\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml\";s:7:\"updated\";i:1499457240;s:4:\"hash\";s:32:\"1c49e6754e661e5eb1c301f8874829da\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Luster\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/luster/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"82a924b258dea8a7d87ba0002b561b1a\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Port\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/port/wpml-config.xml\";s:7:\"updated\";i:1426496160;s:4:\"hash\";s:32:\"788cce209545b94cfede660d543d7013\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:3:\"Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:31:\"wpml-config/pro/wpml-config.xml\";s:7:\"updated\";i:1532099940;s:4:\"hash\";s:32:\"dcb42604ed20598ed1bee40a90e45f39\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Relevanssi\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/relevanssi/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Relevanssi Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/relevanssi-premium/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Resort\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/resort/wpml-config.xml\";s:7:\"updated\";i:1491314280;s:4:\"hash\";s:32:\"363adea9467157a4e0b49d50c2be3b3f\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Reveal\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/reveal/wpml-config.xml\";s:7:\"updated\";i:1461595980;s:4:\"hash\";s:32:\"58db88b09a090c9fcff3d65bd031d14a\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"ReWalk Parent\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/rewalk-parent/wpml-config.xml\";s:7:\"updated\";i:1480345020;s:4:\"hash\";s:32:\"7b17377ed5e4226bc7e3d44270bc7924\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Scrollider\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/scrollider/wpml-config.xml\";s:7:\"updated\";i:1479395940;s:4:\"hash\";s:32:\"83fbe85052a8e7eb7ac61496187c7271\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Uncode\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/uncode/wpml-config.xml\";s:7:\"updated\";i:1612368753;s:4:\"hash\";s:32:\"5fc00f036d83b26035262343c7d3d2db\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:1:\"X\";s:14:\"override_local\";b:1;s:4:\"path\";s:29:\"wpml-config/x/wpml-config.xml\";s:7:\"updated\";i:1534248540;s:4:\"hash\";s:32:\"0d41ca410c22810705838d664c5fa296\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"GeneratePress\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/generatepress/wpml-config.xml\";s:7:\"updated\";i:1591094953;s:4:\"hash\";s:32:\"4fba6e5837b20c7b3e763a4edb85dc47\";}}}","no");

INSERT INTO `wp_options` VALUES 
("3106","wpml_config_index_updated","1619441899","no"),
("3107","wpml_config_files_arr","O:8:\"stdClass\":2:{s:6:\"themes\";a:0:{}s:7:\"plugins\";a:2:{s:19:\"Custom Post Type UI\";s:316:\"<wpml-config>\n    <admin-texts>\n        <key name=\"cptui_*\">\n            <key name=\"*\">\n                <key name=\"label\"/>\n                <key name=\"singular_label\"/>\n                <key name=\"labels\">\n                    <key name=\"*\" /></key>\n            </key>\n        </key>\n    </admin-texts>\n</wpml-config>\n\";s:21:\"WPML Multilingual CMS\";s:13980:\"<wpml-config>\n	<custom-fields>\n		<custom-field action=\"translate\">title</custom-field>\n		<custom-field action=\"translate\">description</custom-field>\n		<custom-field action=\"translate\">keywords</custom-field>\n		<custom-field action=\"ignore\">_edit_last</custom-field>\n		<custom-field action=\"ignore\">_edit_lock</custom-field>\n		<custom-field action=\"ignore\">_wp_page_template</custom-field>\n		<custom-field action=\"ignore\">_wp_attachment_metadata</custom-field>\n		<custom-field action=\"ignore\">original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wpml_original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wp_old_slug</custom-field>\n		<custom-field action=\"ignore\">_icl_translator_note</custom-field>\n		<custom-field action=\"ignore\">_alp_processed</custom-field>\n		<custom-field action=\"ignore\">_pingme</custom-field>\n		<custom-field action=\"ignore\">_encloseme</custom-field>\n		<custom-field action=\"ignore\">_icl_lang_duplicate_of</custom-field>\n		<custom-field action=\"ignore\">_thumbnail_id</custom-field>\n		<custom-field action=\"ignore\">_wp_attached_file</custom-field>\n		<custom-field action=\"translate\">_wp_attachment_image_alt</custom-field>\n	</custom-fields>\n	<taxonomies>\n		<taxonomy translate=\"1\">translation_priority</taxonomy>\n	</taxonomies>\n	<language-switcher-settings>\n		<key name=\"link_empty\">0</key>\n		<key name=\"statics\">\n			<key name=\"footer\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">1</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n				<key name=\"font_current_normal\">#444444</key>\n				<key name=\"font_current_hover\">#000000</key>\n				<key name=\"background_current_normal\">#ffffff</key>\n				<key name=\"background_current_hover\">#eeeeee</key>\n				<key name=\"font_other_normal\">#444444</key>\n				<key name=\"font_other_hover\">#000000</key>\n				<key name=\"background_other_normal\">#ffffff</key>\n				<key name=\"background_other_hover\">#eeeeee</key>\n				<key name=\"border\">#cdcdcd</key>\n			</key>\n			<key name=\"post_translations\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">0</key>\n				<key name=\"display_before_content\">1</key>\n				<key name=\"display_after_content\">0</key>\n				<key name=\"availability_text\">This post is also available in: %s</key>\n			</key>\n			<key name=\"shortcode_actions\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n			</key>\n		</key>\n	</language-switcher-settings>\n	<custom-types>\n		<custom-type translate=\"1\">attachment</custom-type>\n		<custom-type translate=\"1\">wp_block</custom-type>\n	</custom-types>\n	<shortcode-list>call_to_action,newsletter,tours_shortcode,cta_button,woocommerce_thankyou,woocommerce_shop,table,custom_profile,symple_heading,row,tagcloud,sform,nano,add_eventon_list,che,era,essa,nel,gli,per,come,anima,ella,quel,show_gd_mylist_btn,su_spoiler,email,vul,wpv-view,wpv-post-field,accordion_item,citation,gallery,foogallery,user-submitted-posts,chronologie,adresse,get_unit_label,get_reference_label,woocommerce_api_manager_lost_api_key,wp-knowledgebase,testimonials_slider,rpwe,posts,nowotworu,intima-media,dostarcza,standaryzowany,jako,czarny,ekstrakt,kwas,std,dwuwodzian,stm_icon_box,ess_grid,rev_slider,linkview,dropcap,permalinklist,testimonial_slider,woocommerce_software_lost_license,text-blocks,wp_sitemap_page,wcmp_vendor,vendor_registration,efsrow,efscolumn,efsbutton,md_rev_slider,md_live_text,md_imagebox_full,flagallery,pbr_quicklinksmenu,rev_slider_vc,opalhotel_reservation_form,pbr_title_heading,pbr_testimonials,embedyt,yith_wcwl_wishlist,wcm_content_restricted,feature_box,woocommerce_en_check,wc_box,wc_row,wc_column,wc_fullwidth,wc_center,wp_social_sharing,infoboxes,testimonials,woocommerce_social_media_share_buttons,wcv_vendor_dashboard,wcv_shop_settings,wcv_orders,inplayer,useyourdrive,wp_blog_designer,us_blog,tt_address,tt_dashboard,envira-gallery,hotspotitem,woocommerce_klarna_checkout,wpml_mailto,contact-field,ux_banner,advanced_iframe,siteorigin_widget,ec_store,simpay_payment_receipt,su-mensaje,borlabs_cookie,contact_info,stm_boats_video,packages_orderdata,yith_ywraq_request_quote,woocommerce_pay,button,supsystic-tables,clean-login,woocommerce_pay,pdf-embedder,insertgenerator,youzer_register,wysija_form,video,customer-area,customer-area-dashboard,customer-area-private-files-home,customer-area-private-files,customer-account-home,customer-area-account,customer-area-logout,bookly-form,bookly-cancellation-confirmation,stm_classic_filter,popup_trigger,mainwp_archived_lists,wcv_vendorslist,dotpay_content,formularz,cyberactive_school_courses_selection_form,cyberactive_school_session_timeout,ditty_news_ticker,donationcampaign,das-list-events,event_embed,sectiontitle,learn_press_profile,ticket-submit,tickets,aanduiding,datum,thim-icon-box,ngg_images,wpdomainchecker,visualizer,mk_page_section,rssreviews,animate_this,simple-sitemap,gravityform,stm_tech_info,fep_submission_form,ucaddon_diagonal_event_box,wcv_feedback_form,newsletters_management,wcv_pro_dashboard,tm_pb_section,wwof_product_listing,res_map,jssupportticket,socialbar,socialbar_service,front-end-pm,stm_sidebar,give_receipt,donation_history,simpay_error,tm_pb_contact_field,jwp,woocommerce_checkout,mk_custom_list,sg_popup,icon,extra_wrap,frontier-post,invierno,appbox,highlight,ci_alert,vc_mad_products,dt_list,geoip-continent,geoip-country,geoip-region,geoip-city,geoip-postalcode,geoip-latitude,geoip-longitude,geoip-location,woocommerce_notices,stm_icon_box,post-timeline,tt_address,private-message,visualizer,ga_optout,manage_serial_key_usage,ut_header,site_name,bfname,order_id,menu-country,menu-prefer,accordion-item,mini-icon,gvlogic,stm_gmap,contact-form,iconbox,woocommerce_my_account,super_form,wpdm-all-packages,photoblocks,et_pb_map_pin,ginger_reset_cookie,su_divider,fbl_login_button,gmw_single_location,one_full,recent_products,custom_list,endif,jours,wpuf-login,lyte,product_table,wpuf-registration,wpuf_dashboard,amazon,member-pricing-table,rozinky,ngg_images,add_to_cart_url,srizonfbgallery,wysija_form,cl-itext,embedyt,icon_counter,text_block,vtftable,header_static,bookingcalendar,flexslider,anova-geoip-meta,zp_vc_slideshow_element,zp_scrollto,my_calendar_upcoming,wpv-post-url,fusion_button,su_tab,freeconsultation_technical_forum_link,vc_images_carousel,otgs_logo_url,wpv-conditional,wpv-view,teaser,dt_fancy_image,fusion_tagline_box,contact_us_add,content_box,tagline_box,us_iconbox,fusion_tab,fisicamente,one_half_sidebar,action-btn,invicta_contacts,pricing_price,button,icon_link,slideshow,vcex_milestone,secondary-demo,vh_pricing_table,category_name,blogurl,q_team,tab_nav_item</shortcode-list>\n\n	<built-with-page-builder><![CDATA[/<!-- wp:/]]></built-with-page-builder>\n\n	<gutenberg-blocks>\n		<gutenberg-block type=\"core/paragraph\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/heading\" translate=\"1\">\n			<xpath>//*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/button\" translate=\"1\">\n			<xpath>//a</xpath>\n			<xpath type=\'link\'>//a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/image\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure//img/@alt</xpath>\n			<xpath>//figure//img/@title</xpath>\n			<xpath type=\'link\'>//figure/a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/gallery\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/media-text\" translate=\"1\">\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/list\" translate=\"1\">\n			<xpath>//ul/li|//ol/li</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/quote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/audio\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/video\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/file\" translate=\"1\">\n			<xpath>//div/a</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/cover\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<!-- Since WP 5.0.0 core/cover-image is replaced with core/cover -->\n		<gutenberg-block type=\"core/cover-image\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/subhead\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/verse\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/table\" translate=\"1\">\n			<xpath>//th</xpath>\n			<xpath>//td</xpath>\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/preformatted\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/pullquote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/column\" translate=\"0\" />\n		<gutenberg-block type=\"core/columns\" translate=\"0\" />\n		<gutenberg-block type=\"core/code\" translate=\"0\" />\n		<gutenberg-block type=\"core/more\" translate=\"0\" />\n		<gutenberg-block type=\"core/nextpage\" translate=\"0\" />\n		<gutenberg-block type=\"core/separator\" translate=\"0\" />\n		<gutenberg-block type=\"core/spacer\" translate=\"0\" />\n		<gutenberg-block type=\"core/shortcode\" translate=\"0\" />\n		<gutenberg-block type=\"core-embed/twitter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/youtube\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/facebook\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/instagram\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/vimeo\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/soundcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/spotify\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/flickr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/animoto\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/collegehumor\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/dailymotion\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/funnyordie\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/hulu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/imgur\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/issuu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/kickstarter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/meetup-com\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/mixcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/polldaddy\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reddit\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reverbnation\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/screencast\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/scribd\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/slideshare\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/smugmug\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/speaker\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/ted\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/tumblr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/videopress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress-tv\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/html\" translate=\"1\">\n			<xpath>/*</xpath>\n		</gutenberg-block>\n	</gutenberg-blocks>\n</wpml-config>\n\";}}","no"),
("3108","icl_admin_messages","a:2:{s:8:\"messages\";a:0:{}s:16:\"instant_messages\";a:0:{}}","yes"),
("3109","wp_installer_settings","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","no"),
("3111","wpml_dependencies:installed_plugins","a:3:{s:26:\"sitepress-multilingual-cms\";s:6:\"4.4.10\";s:23:\"wpml-string-translation\";s:5:\"3.1.8\";s:27:\"wpml-translation-management\";s:6:\"2.10.6\";}","yes"),
("3115","WPML(ST)","a:1:{s:50:\"WPML\\ST\\Batch\\Translation\\Records_schema_installed\";b:1;}","yes"),
("3116","WPML_Group_Keys","a:1:{i:0;s:8:\"WPML(ST)\";}","yes"),
("3121","acfml_options_page_revert_done","1","yes"),
("3123","acfml_block_migration_result","done","yes"),
("3125","_icl_admin_option_names","a:2:{s:16:\"cptui_post_types\";a:4:{s:7:\"country\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:6:\"assets\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:9:\"statement\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:14:\"section_blocks\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}}s:16:\"cptui_taxonomies\";a:1:{s:6:\"region\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:19:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:9:\"edit_item\";i:1;s:9:\"view_item\";i:1;s:11:\"update_item\";i:1;s:12:\"add_new_item\";i:1;s:13:\"new_item_name\";i:1;s:11:\"parent_item\";i:1;s:17:\"parent_item_colon\";i:1;s:12:\"search_items\";i:1;s:13:\"popular_items\";i:1;s:26:\"separate_items_with_commas\";i:1;s:19:\"add_or_remove_items\";i:1;s:21:\"choose_from_most_used\";i:1;s:9:\"not_found\";i:1;s:8:\"no_terms\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:13:\"back_to_items\";i:1;}}}}","yes"),
("3127","wpml_language_switcher","a:9:{s:8:\"migrated\";i:0;s:18:\"converted_menu_ids\";i:0;s:15:\"languages_order\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:10:\"link_empty\";i:0;s:14:\"additional_css\";s:0:\"\";s:15:\"copy_parameters\";s:0:\"\";s:5:\"menus\";a:0:{}s:8:\"sidebars\";a:0:{}s:7:\"statics\";a:3:{s:6:\"footer\";O:19:\"WPML_LS_Footer_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:21:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:6:\"footer\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:1;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:7:\"#444444\";s:18:\"font_current_hover\";s:7:\"#000000\";s:25:\"background_current_normal\";s:7:\"#ffffff\";s:24:\"background_current_hover\";s:7:\"#eeeeee\";s:17:\"font_other_normal\";s:7:\"#444444\";s:16:\"font_other_hover\";s:7:\"#000000\";s:23:\"background_other_normal\";s:7:\"#ffffff\";s:22:\"background_other_hover\";s:7:\"#eeeeee\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"post_translations\";O:30:\"WPML_LS_Post_Translations_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:24:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"post_translations\";s:4:\"show\";i:0;s:8:\"template\";s:29:\"wpml-legacy-post-translations\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;s:22:\"display_before_content\";i:0;s:21:\"display_after_content\";i:0;s:17:\"availability_text\";s:34:\"This post is also available in: %s\";}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"shortcode_actions\";O:30:\"WPML_LS_Shortcode_Actions_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:21:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"shortcode_actions\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:0:\"\";s:18:\"font_current_hover\";s:0:\"\";s:25:\"background_current_normal\";s:0:\"\";s:24:\"background_current_hover\";s:0:\"\";s:17:\"font_other_normal\";s:0:\"\";s:16:\"font_other_hover\";s:0:\"\";s:23:\"background_other_normal\";s:0:\"\";s:22:\"background_other_hover\";s:0:\"\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}}}","yes"),
("3128","category_children_en","a:0:{}","yes"),
("3129","category_children_all","a:0:{}","yes"),
("3133","otgs_share_local_components","a:1:{s:4:\"wpml\";i:0;}","yes"),
("3134","otgs_active_components","a:2:{s:6:\"plugin\";a:11:{i:0;a:3:{s:4:\"File\";s:48:\"advanced-custom-fields-table-field/acf-table.php\";s:4:\"Name\";s:35:\"Advanced Custom Fields: Table Field\";s:7:\"Version\";s:6:\"1.3.12\";}i:1;a:3:{s:4:\"File\";s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";s:4:\"Name\";s:38:\"Advanced Custom Fields: Theme Code Pro\";s:7:\"Version\";s:5:\"2.5.2\";}i:2;a:3:{s:4:\"File\";s:18:\"acfml/wpml-acf.php\";s:4:\"Name\";s:35:\"Advanced Custom Fields Multilingual\";s:7:\"Version\";s:5:\"1.8.2\";}i:3;a:3:{s:4:\"File\";s:34:\"advanced-custom-fields-pro/acf.php\";s:4:\"Name\";s:26:\"Advanced Custom Fields PRO\";s:7:\"Version\";s:5:\"5.9.5\";}i:4;a:3:{s:4:\"File\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:4:\"Name\";s:19:\"Custom Post Type UI\";s:7:\"Version\";s:5:\"1.9.0\";}i:5;a:3:{s:4:\"File\";s:33:\"duplicator-pro/duplicator-pro.php\";s:4:\"Name\";s:14:\"Duplicator Pro\";s:7:\"Version\";s:5:\"4.0.2\";}i:6;a:3:{s:4:\"File\";s:28:\"real-media-library/index.php\";s:4:\"Name\";s:18:\"Real Media Library\";s:7:\"Version\";s:6:\"4.13.4\";}i:7;a:3:{s:4:\"File\";s:40:\"sitepress-multilingual-cms/sitepress.php\";s:4:\"Name\";s:21:\"WPML Multilingual CMS\";s:7:\"Version\";s:6:\"4.4.10\";}i:8;a:3:{s:4:\"File\";s:34:\"wpml-string-translation/plugin.php\";s:4:\"Name\";s:23:\"WPML String Translation\";s:7:\"Version\";s:5:\"3.1.8\";}i:9;a:3:{s:4:\"File\";s:38:\"wpml-translation-management/plugin.php\";s:4:\"Name\";s:27:\"WPML Translation Management\";s:7:\"Version\";s:6:\"2.10.6\";}i:10;a:3:{s:4:\"File\";s:33:\"duplicate-post/duplicate-post.php\";s:4:\"Name\";s:20:\"Yoast Duplicate Post\";s:7:\"Version\";s:5:\"4.1.2\";}}s:5:\"theme\";a:1:{i:0;a:3:{s:8:\"Template\";s:4:\"milo\";s:4:\"Name\";s:4:\"Milo\";s:7:\"Version\";s:3:\"1.0\";}}}","yes");

INSERT INTO `wp_options` VALUES 
("3136","wpml_start_version","4.4.10","yes"),
("3137","wpml_string_table_ok_for_mo_import","yes","yes"),
("3140","wpml_update_statuses","a:36:{s:31:\"wpml-upgrade-localization-files\";b:1;s:41:\"wpml-upgrade-fix-non-admin-with-admin-cap\";b:1;s:42:\"wpml-upgrade-table-translate-job-for-3-9-0\";b:1;s:50:\"wpml-upgrade-remove-translation-services-transient\";b:1;s:35:\"wpml-upgrade-display-mode-for-posts\";b:1;s:42:\"wpml-add-uuid-column-to-translation-status\";b:1;s:46:\"wpml-upgrade-element-type-length-and-collation\";b:1;s:45:\"wpml-upgrade-add-word-count-column-to-strings\";b:1;s:35:\"wpml-upgrade-media-without-language\";b:1;s:38:\"wpml-upgrade-media-duplication-in-core\";b:1;s:26:\"wpml-upgrade-chinese-flags\";b:1;s:51:\"wpml-upgrade-add-editor-column-to-icl-translate-job\";b:1;s:25:\"wpml-upgrade-wpml-site-id\";b:1;s:35:\"wpml-upgrade-wpml-site-id-remaining\";b:1;s:43:\"wpml-upgrade-add-location-column-to-strings\";b:1;s:41:\"wpml-upgrade-add-wrap-column-to-translate\";b:1;s:39:\"wpml-upgrade-add-wrap-column-to-strings\";b:1;s:46:\"wpml\\upgrade\\commands\\addcontextindextostrings\";b:1;s:56:\"wpml\\upgrade\\commands\\addstatusindextostringtranslations\";b:1;s:54:\"wpml\\upgrade\\commands\\addstringpackageidindextostrings\";b:1;s:46:\"wpml\\upgrade\\command\\disableoptionsautoloading\";b:1;s:46:\"wpml\\upgrade\\commands\\removerestdisablednotice\";b:1;s:54:\"wpml\\upgrade\\commands\\dropcodelocaleindexfromlocalemap\";b:1;s:46:\"wpml\\upgrade\\commands\\addprimarykeytolocalemap\";b:1;s:48:\"wpml-tm-upgrade-translation-priorities-for-posts\";b:1;s:43:\"wpml-tm-upgrade-default-editor-for-old-jobs\";b:1;s:41:\"wpml-tm-upgrade-service-redirect-to-field\";b:1;s:46:\"wpml-tm-add-tp-id-column-to-translation-status\";b:1;s:67:\"wpml-tm-add-tp-revision-and-ts-status-columns-to-translation-status\";b:1;s:60:\"wpml-tm-add-tp-revision-and-ts-status-columns-to-core-status\";b:1;s:32:\"wpml-tm-upgrade-wpml-site-id-ate\";b:1;s:45:\"wpml\\tm\\upgrade\\commands\\migrateaterepository\";b:1;s:61:\"wpml\\tm\\upgrade\\commands\\synchronizesourceidofatejobs\\command\";b:1;s:52:\"wpml\\tm\\upgrade\\commands\\createatedownloadqueuetable\";b:1;s:51:\"wpml\\tm\\upgrade\\commands\\refreshtranslationservices\";b:1;s:34:\"wpml-tm-upgrade-cancel-orphan-jobs\";b:1;}","yes"),
("3143","wpml_st_display_strings_scan_notices","1","yes"),
("3144","acfml_field_groups_default_editor","1","yes"),
("3145","WPML_Upgrade_All_Admins_To_Manage_Translations_Has_Run","1","yes"),
("3146","wpml-package-translation-string-packages-table-updated","0.0.2","yes"),
("3147","wpml-package-translation-string-table-updated","1","yes"),
("3148","wpml-package-translation-db-updates-run","a:1:{i:0;s:5:\"0.0.2\";}","yes"),
("3149","wpml-package-translation-refresh-required","no","no"),
("3150","wpml_base_slug_translation","1","yes"),
("3151","widget_text_icl","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("3152","widget_icl_lang_sel_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("3155","translation_priority_children_en","a:0:{}","yes"),
("3156","translation_priority_children_da","a:0:{}","yes"),
("3157","translation_priority_children_all","a:0:{}","yes"),
("3158","wpml-old-jobs-editor","wpml","yes"),
("3159","wpml_translation_services_timestamp","1618577941","yes"),
("3160","wpml_tp_com_log","front.net/production/logos/memoq.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_memoq.png\",\"project_details_url\":\"\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"c6e1c5624529722f2bc138dcd0c63ee5\",\"doc_url\":\"https://wpml.org/translation-service/memoq\",\"notification\":true,\"tms\":true,\"has_language_pairs\":true,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"Your translation provider will provide your memoQ Connection key and Connection url\",\"how_to_get_credentials_url\":\"https://wpml.org/translation-service/memoq/#requesting-an-account\",\"client_create_account_page_url\":\"https://wpml.org/translation-service/memoq/#requesting-an-account\",\"partner\":false,\"review_url\":\"https://wpml.org/submit-your-review/?parent_translation-service_id=1403359\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Connection key\",\"name\":\"api_key\",\"type\":\"text\"},{\"label\":\"Connection url\",\"name\":\"api_url\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":true,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":false},{\"id\":82,\"name\":\"Pseudo Translation Services\",\"description\":\"This is a demo service for learning and practicing the WPML workflow for professional translation. To authenticate please use any string as an API Token.\",\"url\":\"http://lvh.me/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pseudo-translation-services.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pseudo-translation-services.png\",\"project_details_url\":\"\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"a31f833a7b129003abe76987b06c8e44\",\"doc_url\":\"http://lvh.me/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"API Key\",\"name\":\"api_key\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":false},{\"id\":83,\"name\":\"Lilt\",\"description\":\"Lilt is the new engine for enterprise translation workflows. We increase quality and speed with the neural feedback loop which combines human ingenuity and machine intelligence in a virtuous cycle.\",\"url\":\"https://lilt.com\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lilt.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lilt.png\",\"project_details_url\":\"https://lilt.com/app/projects/details/{project_id}/documents\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"ffad5fa853bba0b6c9eda94b382b0201\",\"doc_url\":\"https://wpml.org/translation-service/lilt/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"API Key\",\"name\":\"api_key\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":117,\"name\":\"Smartcat\",\"description\":\"Smartcat is an all-in-one platform connecting businesses and translators into a continuous translation delivery loop by combining a collaborative workflow solution, a marketplace, and a network of translation professionals.\\r\\n\",\"url\":\"https://www.smartcat.ai/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartcat.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartcat.png\",\"project_details_url\":\"%{server_url}/projects/%{project_id}\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"d1c696251639dde597dd81b6fec113a9\",\"doc_url\":\"https://wpml.org/translation-service/smartcat/\",\"notification\":true,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":null,\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Server URL\",\"name\":\"server_url\",\"type\":\"text\"},{\"label\":\"API key\",\"name\":\"api_key\",\"type\":\"text\"},{\"label\":\"Account ID\",\"name\":\"account_id\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"api\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":121,\"name\":\"Smartling\",\"description\":\"Smartling is a translation management platform and language services provider to localize content across devices and platforms. Author of Enterprise Translation Cloud, a data-driven approach to localization that helps customers achieve higher quality translation at a lower total cost.\",\"url\":\"https://www.smartling.com/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartling.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartling.png\",\"project_details_url\":\"https://dashboard.smartling.com/app/accounts/{account_id}/account-jobs/{project_id}:{job_id}\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"3f1d34db7a1c34e0840e81b4aceb97db\",\"doc_url\":\"https://wpml.org/translation-service/smartling/\",\"notification\":true,\"tms\":true,\"has_language_pairs\":true,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"User Identifier\",\"name\":\"user_identifier\",\"type\":\"text\"},{\"label\":\"User Secret\",\"name\":\"user_secret\",\"type\":\"text\"},{\"label\":\"Account UID\",\"name\":\"account_uid\",\"type\":\"text\"},{\"label\":\"Project ID\",\"name\":\"project_id\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":144,\"name\":\"SDL Language Cloud TMS\",\"description\":\"The SDL Language Cloud TMS connector for WPML provides a seamless link between WPML and SDL Language Cloud TMS, allowing fast and easy management of multilingual web content and translation projects from within WordPress.\",\"url\":\"https://languagecloud.sdl.com/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/sdl-language-cloud-tms.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_sdl-language-cloud-tms.png\",\"project_details_url\":\"https://languagecloud.sdl.com/en/cp/dashboard\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"a87dad5a887e062d5a269574bd54fc3b\",\"doc_url\":\"https://wpml.org/translation-service/sdl-language-cloud/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"Your username and password are the same as the credentials you use to login to SDL Language Cloud\",\"how_to_get_credentials_url\":\"https://wpml.org/translation-service/sdl-language-cloud/#connecting-to-language-cloud\",\"client_create_account_page_url\":\"https://oos.sdl.com/asp/products/ssl/RegisterUser.aspx\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Username\",\"name\":\"username\",\"type\":\"text\"},{\"label\":\"Password\",\"name\":\"password\",\"type\":\"text\"},{\"label\":\"Client ID\",\"name\":\"client_id\",\"type\":\"text\"},{\"label\":\"Client Secret\",\"name\":\"client_secret\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":true,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true}]\n}\r\n","no"),
("3161","wpml_translation_services","a:102:{i:0;C:15:\"WPML_TP_Service\":2570:{a:38:{s:2:\"id\";i:67;s:8:\"logo_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/icanlocalize.png\";s:16:\"logo_preview_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_icanlocalize.png\";s:4:\"name\";s:12:\"ICanLocalize\";s:11:\"description\";s:300:\"	\r\nICanLocalize\'s seamless WPML integration ensures quick delivery of translations while our professional linguists focus on quality and accuracy. ICanLocalize provides a safe environment for the translation of your website in 45+ languages. Choose ICanLocalize by OnTheGoSystems, the makers of WPML.\";s:7:\"doc_url\";s:50:\"https://wpml.org/translation-service/icanlocalize/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API Token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:4;s:15:\"quality_ranking\";d:4;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4154;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:42.95;s:7:\"primary\";d:4.85;s:15:\"primary_ranking\";d:42.95;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:51:\"https://www.icanlocalize.com/wpml/registrations/new\";s:19:\"project_details_url\";s:73:\"https://www.icanlocalize.com/wpml/websites/%{website_id}/translation_jobs\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"dd17d48516ca4bce0b83043583fabd2e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:272:\"<a href=\"https://www.icanlocalize.com/wpml/registrations/new\" target=\"_blank\">Sign up</a> to ICanLocalize to receive your API token.<br />Already have an account? Log-in and <a href=\"https://www.icanlocalize.com/wpml/websites/api_token\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:52:\"Your API Token is found on your ICanLocalize account\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/icanlocalize/#creating-account\";s:30:\"client_create_account_page_url\";s:51:\"https://www.icanlocalize.com/users/new?utype=Client\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}}}}i:1;C:15:\"WPML_TP_Service\":2851:{a:38:{s:2:\"id\";i:12;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/blend.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_blend.png\";s:4:\"name\";s:5:\"BLEND\";s:11:\"description\";s:254:\"BLEND is a global localization service provider brought by the makers of OneHourTranslation. As an end-to-end AI-powered multi-market enabler, BLEND is empowering global brands to establish a native presence in fundamentally different markets, worldwide.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/blend/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Secret Key\";s:4:\"name\";s:10:\"secret_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Public Key\";s:4:\"name\";s:10:\"public_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5443;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:38.57;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:38.57;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:44:\"https://app.getblend.com/affiliate/wpml_otgs\";s:19:\"project_details_url\";s:56:\"https://www.onehourtranslation.com/my-projects/customer/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8850fd4bfdaae2a2d63e51fb1f2ac3e4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:246:\"<a href=\"https://app.getblend.com/affiliate/wpml_otgs\" target=\"_blank\">Register</a> to BLEND to generate your API Keys.<br />Already have an account? Log-in and <a href=\"https://wpml.org/go/onehourtranslation/\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:110:\"Your Secret Key and Public Key are located under \"Profile > API Keys\" on your OneHourTranslation Control panel\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/onehourtranslation/#api-secret-public-keys\";s:30:\"client_create_account_page_url\";s:71:\"https://wpml.org/translation-service/onehourtranslation/#create-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Israel\";s:4:\"code\";s:2:\"IL\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Romania\";s:4:\"code\";s:2:\"RO\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Ukraine\";s:4:\"code\";s:2:\"UA\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:2;C:15:\"WPML_TP_Service\":2243:{a:38:{s:2:\"id\";i:45;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/avanti-language-services.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_avanti-language-services.png\";s:4:\"name\";s:24:\"Avanti Language Services\";s:11:\"description\";s:279:\"Why choose Avanti?\r\n1. Ultra-fast service (offer within the hour, rapid turnaround time)\r\n2. Top quality (3x ISO certified, watertight QA processes)\r\n3. Competitive charges (incl. 70% discount on repetitions)\r\nAvanti: 100% satisfaction guarantee. Ask for a free test translation!\";s:7:\"doc_url\";s:62:\"https://wpml.org/translation-service/avanti-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5168;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:37.38;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:37.38;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/avanti/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"65ead6792983d81081190fb784e73b0a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:51:\"The AVANTI team will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:49:\"https://www.avanti-nl.com/en/wpml/#content-sturen\";s:30:\"client_create_account_page_url\";s:88:\"https://wpml.org/translation-service/avanti-language-services/#requesting-avanti-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}}}}i:3;C:15:\"WPML_TP_Service\":1954:{a:38:{s:2:\"id\";i:78;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/alfabeta.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_alfabeta.png\";s:4:\"name\";s:8:\"AlfaBeta\";s:11:\"description\";s:254:\"AlfaBeta is an Italian language services consultancy specializing in international communication, mainly in the food, wine, tourism, fashion industries. We provide web translation and copywriting, multilingual SEO/SEM and social media marketing services.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/alfabeta/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:36.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/alfabeta/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e00168c56d4b60275ee38701221c5911\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:4;C:15:\"WPML_TP_Service\":2160:{a:38:{s:2:\"id\";i:58;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acstraduction.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acstraduction.png\";s:4:\"name\";s:13:\"ACSTraduction\";s:11:\"description\";s:255:\"Nous sommes votre partenaire idéal pour la traduction spécialisée multilingue de sites Internet. Une équipe réactive à taille humaine est à votre écoute. The new standard in specialised website translation. It’s simple:  Click. Quality. Connect.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/acstraduction/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5480;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.15;s:7:\"primary\";d:4.75;s:15:\"primary_ranking\";d:36.15;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/acstraduction/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cba138bf154930c7878e8b5ba61ec7d4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:33:\"Request your API Token to connect\";s:26:\"how_to_get_credentials_url\";s:66:\"https://www.acs-traduction.com/web/traduction-site-wordpress-wpml/\";s:30:\"client_create_account_page_url\";s:70:\"https://wpml.org/translation-service/acstraduction/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}}}}i:5;C:15:\"WPML_TP_Service\":2099:{a:38:{s:2:\"id\";i:122;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/commit-global.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_commit-global.png\";s:4:\"name\";s:13:\"Commit Global\";s:11:\"description\";s:296:\"Commit Global provides translation and localization in 80+ language combinations. As an ISO-certified company, it applies strict QA procedures in its everyday work. Its key strengths include experienced personnel, responsiveness and flexibility, competitive prices and commitment to high quality.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/commit-global/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.03;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:36.03;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/commit-global/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"14dde982a9f3acf6c185ab11b06cb41c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:6;C:15:\"WPML_TP_Service\":2271:{a:38:{s:2:\"id\";i:101;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/k-j-translations.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_k-j-translations.png\";s:4:\"name\";s:16:\"K&J Translations\";s:11:\"description\";s:249:\"K&J Translations is currently active on markets in Germany, Slovenia, Slovakia, Czechia and ex-Yugoslavian countries. It is known for its fast, quality translation services for businesses and effective communication during whole translation process.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/kj-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:34.78;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:34.78;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:35:\"https://wpml.org/go/kjtranslations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"37bf80898cc416edd1eb8bab6d4bb11d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Croatia\";s:4:\"code\";s:2:\"HR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"Czech Republic\";s:4:\"code\";s:2:\"CZ\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovakia\";s:4:\"code\";s:2:\"SK\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovenia\";s:4:\"code\";s:2:\"SI\";}}}}i:7;C:15:\"WPML_TP_Service\":2145:{a:38:{s:2:\"id\";i:69;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/leemeta.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_leemeta.png\";s:4:\"name\";s:7:\"Leemeta\";s:11:\"description\";s:255:\"Leemeta is known for its turnkey translations™. Their job is to make sure you don’t have any additional work: they translate and proofread the texts, design them for printing or prepare for digital distribution and transfer them onto the website/apps.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/leemeta\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4282;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:34.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:34.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/leemeta/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"dff20624a4352b67c960083b3a5df494\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:58:\"A Leemeta team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/leemeta/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:64:\"https://wpml.org/translation-service/leemeta/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovenia\";s:4:\"code\";s:2:\"SI\";}}}}i:8;C:15:\"WPML_TP_Service\":1975:{a:38:{s:2:\"id\";i:127;s:8:\"logo_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/gte-localize.png\";s:16:\"logo_preview_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_gte-localize.png\";s:4:\"name\";s:12:\"GTE Localize\";s:11:\"description\";s:251:\"GTE Localize is an ISO qualified translation and localization agency specializing in Asian languages. We offer professional website translation services for a full range of contents including life-science, legal-business, engineering, IT and software.\";s:7:\"doc_url\";s:50:\"https://wpml.org/translation-service/gte-localize/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:33.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:33.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/gtelocalize/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c2fcfc33c5f86c92027cf7e5c0e64448\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Viet Nam\";s:4:\"code\";s:2:\"VN\";}}}}i:9;C:15:\"WPML_TP_Service\":2691:{a:38:{s:2:\"id\";i:33;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/semantix.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_semantix.png\";s:4:\"name\";s:8:\"Semantix\";s:11:\"description\";s:195:\"Semantix is a market-leading language technology company in the Nordics, offering a broad range of translation and interpretation services. We help people and businesses to shine in any language.\";s:7:\"doc_url\";s:24:\"https://www.semantix.eu/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Customer ID\";s:4:\"name\";s:11:\"customer_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5490;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:33.23;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:33.23;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:29:\"https://wpml.org/go/semantix/\";s:19:\"project_details_url\";s:44:\"https://xtrf.semantix.eu/customers/main.html\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cf3d9e7244ec6d0a5192462c93e81bee\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:72:\"Amesto will send you a Username, Password, and Customer ID to your email\";s:26:\"how_to_get_credentials_url\";s:79:\"https://www.semantix.eu/translation/technology/api/multilingual-wordpress-site/\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/amesto/#connecting-to-amesto\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Norway\";s:4:\"code\";s:2:\"NO\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Sweden\";s:4:\"code\";s:2:\"SE\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:10;C:15:\"WPML_TP_Service\":2106:{a:38:{s:2:\"id\";i:75;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/okodia.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_okodia.png\";s:4:\"name\";s:6:\"Okodia\";s:11:\"description\";s:242:\"Okodia is a human-translation company certified by ISO 9001 & ISO 17100 certificates working with 80+ languages around the world. Our 1500+ specialized professional native linguists translate over 10+ millon words yearly in almost all fields.\";s:7:\"doc_url\";s:26:\"https://wpml.org/go/okodia\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5475;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:32.45;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:32.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/okodia/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"94ee301596730c533be57728ca1634ef\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:59:\"An Okodia team member will email a unique API Token to you.\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/okodia/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/okodia/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:11;C:15:\"WPML_TP_Service\":1964:{a:38:{s:2:\"id\";i:99;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/euro-text.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_euro-text.png\";s:4:\"name\";s:9:\"Euro:Text\";s:11:\"description\";s:262:\"Your partner for multilingual translation – fast, cost-efficient and reliable, with particular expertise in Spanish and Portuguese, including European and other variants (Mexican, Chilean,Peruvian, Argentinian and Colombian Spanish, Brazilian Portuguese, etc.)\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/eurotext/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:32.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:32.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/eurotext\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"aef0362e0b668d69886108e01a4c2930\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:12;C:15:\"WPML_TP_Service\":2148:{a:38:{s:2:\"id\";i:48;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/spokenhere.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_spokenhere.png\";s:4:\"name\";s:10:\"SpokenHere\";s:11:\"description\";s:226:\"SpokenHere is an American service offering translations, telephonic interpreting, and voiceovers in more than 250 languages. For the last 15 years, it has worked with small to medium-size businesses in a variety of industries.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/spokenhere/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5510;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/spokenhere/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"4d967c459583c6811cc325aaf1fbcd8d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A SpokenHere team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/spokenhere/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/spokenhere/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:13;C:15:\"WPML_TP_Service\":1961:{a:38:{s:2:\"id\";i:120;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/trusted-translations.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_trusted-translations.png\";s:4:\"name\";s:20:\"Trusted Translations\";s:11:\"description\";s:179:\"Trusted Translations, Inc. is an internationally recognized multilingual translation and interpretation service with over 10,000 expert linguists and over 5,000 satisfied clients.\";s:7:\"doc_url\";s:70:\"https://wpml.org/?post_type=translation-service&p=4277301&preview=true\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/trustedtranslations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a967159995deeeb503da9761406a542e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:14;C:15:\"WPML_TP_Service\":1981:{a:38:{s:2:\"id\";i:109;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/jublo-translations.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_jublo-translations.png\";s:4:\"name\";s:18:\"Jublo Translations\";s:11:\"description\";s:233:\"Jublo is translation agency born in Yorkshire, England specialising in IT, travel, machinery and marketing. It provides services all over the globe, bringing only high quality and professionalism to some of the worlds biggest brands.\";s:7:\"doc_url\";s:55:\"https://wpml.org/translation-service/jublo-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/jublo/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"d9d4148b846f06d38f17b6bf80faa269\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:15;C:15:\"WPML_TP_Service\":1918:{a:38:{s:2:\"id\";i:79;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ad-verbum.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ad-verbum.png\";s:4:\"name\";s:9:\"AD VERBUM\";s:11:\"description\";s:213:\"AD VERBUM is a northern European translation and localization company working in 90+ target languages. It specializes in various fields including pharmacy, healthcare and legal for small to medium-size businesses.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/ad-verbum/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/adverbum/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"456cf5b648e41fadadd6f94c13605dbe\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Latvia\";s:4:\"code\";s:2:\"LV\";}}}}i:16;C:15:\"WPML_TP_Service\":2118:{a:38:{s:2:\"id\";i:110;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transline.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transline.png\";s:4:\"name\";s:10:\"Transline \";s:11:\"description\";s:258:\"With its experienced teams of specialized translators, proofreaders and project managers, language service provider Transline has been helping companies in the DACH region to successfully market their products on an international scale for the past 30 years.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/transline-deutschland/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5368;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.87;s:7:\"primary\";d:4.5;s:15:\"primary_ranking\";d:30.87;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/transline/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"7485434837a20872046f85e7e77b5f89\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:17;C:15:\"WPML_TP_Service\":2201:{a:38:{s:2:\"id\";i:94;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/morningside-translations.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_morningside-translations.png\";s:4:\"name\";s:24:\"Morningside Translations\";s:11:\"description\";s:213:\"Morningside Translations is an American language service provider. Specializing in highly regulated industries, Morningside provides ISO-certified translation and localization solutions in more than 150 languages.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/morningside-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5408;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.6;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.6;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/morningside/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fa41303ea2e844c16f7e20bd5e12cf8c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Israel\";s:4:\"code\";s:2:\"IL\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:18;C:15:\"WPML_TP_Service\":2041:{a:38:{s:2:\"id\";i:84;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translation-boulevard.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translation-boulevard.png\";s:4:\"name\";s:21:\"Translation Boulevard\";s:11:\"description\";s:271:\"Translation Boulevard LLC provides translation, website localization, subtitling, transcription, transcreation, voice over, and other services in all major languages pairs. Our company is operated according to Christian values and we provide quality translation services.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/translation-boulevard/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://wpml.org/go/translation-blvd/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e85c18272a7e00b0cd4b941ea1340d5d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:19;C:15:\"WPML_TP_Service\":2123:{a:38:{s:2:\"id\";i:91;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/language-insight.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_language-insight.png\";s:4:\"name\";s:16:\"Language Insight\";s:11:\"description\";s:295:\"Quality and security are a priority for Language Insight as demonstrated by their ISO 9001, 27001 and 17100 accreditations. Their specialist teams provide language services to clients worldwide, including a variety of digital services such as website translation, multilingual SEO, PPC and more.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/language-insight/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5484;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:36:\"https://wpml.org/go/language-insight\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"9cd6dacb4cfa2c94991babf0ffdb88f3\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:20;C:15:\"WPML_TP_Service\":2094:{a:38:{s:2:\"id\";i:108;s:8:\"logo_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/quality-translation-services.png\";s:16:\"logo_preview_url\";s:95:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_quality-translation-services.png\";s:4:\"name\";s:28:\"Quality Translation Services\";s:11:\"description\";s:299:\"Quality Translation Services is a professional translation company which offers high quality translation and website localization services at very attractive prices. They employ the latest translation tools and apply a rigorous translation process to ensure quality, consistency and timely delivery.\";s:7:\"doc_url\";s:66:\"https://wpml.org/translation-service/quality-translation-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/quality-translation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8853226d14818dfdc7d325c53a290436\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Lebanon\";s:4:\"code\";s:2:\"LB\";}}}}i:21;C:15:\"WPML_TP_Service\":3058:{a:38:{s:2:\"id\";i:23;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/textmaster.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_textmaster.png\";s:4:\"name\";s:10:\"TextMaster\";s:11:\"description\";s:220:\"TextMaster was founded in 2011 and offers 40 languages with specializations like fashion, electronics and home décor. Clients can create a dedicated team of translators and communicate through a live messaging system.  \";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/textmaster/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"API secret\";s:4:\"name\";s:10:\"api_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4831;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:28.97;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:28.97;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:56:\"https://www.textmaster.com/?pid=57be8e7208104100441aa3fc\";s:19:\"project_details_url\";s:47:\"https://www.app.textmaster.com/clients/projects\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3db36a7c23cefa52d577ab4307882110\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:255:\"<a href=\"https://www.textmaster.com/?pid=57be8e7208104100441aa3fc\" target=\"_blank\">Register</a> to TextMaster to receive your API token.<br />Already have an account? Log-in and <a href=\"https://wpml.org/go/textmaster/\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:110:\"Your API Key and API Secret are located under  \"lightning menu icon > API & Loop\" on your TextMaster dashboard\";s:26:\"how_to_get_credentials_url\";s:83:\"https://wpml.org/translation-service/textmaster/#connecting-your-site-to-textmaster\";s:30:\"client_create_account_page_url\";s:67:\"https://www.app.textmaster.com/sign_up?pid=57be8e7208104100441aa3fc\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:6;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:22;C:15:\"WPML_TP_Service\":1977:{a:38:{s:2:\"id\";i:123;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ontranslation.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ontranslation.png\";s:4:\"name\";s:13:\"Ontranslation\";s:11:\"description\";s:247:\"Ontranslation translation agency is a multilingual communication company based in Barcelona with 10 years experience. 9001 ISO-certified for the management of multilingual communication projects. Experts in digital marketing and international SEO.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/ontranslation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5427;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/ontranslation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8a78f966b150358b51ec34d653badfd1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:23;C:15:\"WPML_TP_Service\":1873:{a:38:{s:2:\"id\";i:135;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/berba.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_berba.png\";s:4:\"name\";s:5:\"Berba\";s:11:\"description\";s:250:\"With over 1000 native translators working in 700+ language combinations, Berba delivers high-quality translations 3x faster than the industry average. Its AI tools and a dedicated project manager guarantee quality and consistency across your website.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/berba/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5485;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.77;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.77;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/berba/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6e66d4c5c83a5db041820eabbbed19fb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:24;C:15:\"WPML_TP_Service\":1970:{a:38:{s:2:\"id\";i:95;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ubiqus.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ubiqus.png\";s:4:\"name\";s:6:\"Ubiqus\";s:11:\"description\";s:277:\"Ubiqus is an international Paris-based ISO-certified translation service. Providing translation services for all types of media ranging from websites to video to text, Ubiqus has vast experience translating content for various industries such as corporate, legal and financial.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/ubiqus\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5395;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.43;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.43;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/ubiqus/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"00f941032a272372a9aaa2485f8d1786\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}}}}i:25;C:15:\"WPML_TP_Service\":1953:{a:38:{s:2:\"id\";i:136;s:8:\"logo_url\";s:62:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ast.png\";s:16:\"logo_preview_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ast.png\";s:4:\"name\";s:3:\"AST\";s:11:\"description\";s:249:\"AST is a specialist provider of quality-certified and innovative website translation and software localisation services to fintech developers, e-retailers, food & drink brands, engineering companies, and marketing agencies in the UK and worldwide.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/ast-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/ast/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"02689341577b112381f20556ad8520ce\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:26;C:15:\"WPML_TP_Service\":1972:{a:38:{s:2:\"id\";i:80;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/bigtranslation.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_bigtranslation.png\";s:4:\"name\";s:14:\"BigTranslation\";s:11:\"description\";s:247:\"BigTranslation – Translation agency with years of experience in the market and competitive rates. They work exclusively with native translators in over 50 target languages, offering tailored services that adapt perfectly to our clients’ needs.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/bigtranslation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:27;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:35:\"https://wpml.org/go/bigtranslation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a12d879958cec6a27953c1ed284f8032\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:27;C:15:\"WPML_TP_Service\":2363:{a:38:{s:2:\"id\";i:133;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/skrivanek.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_skrivanek.png\";s:4:\"name\";s:9:\"Skrivanek\";s:11:\"description\";s:242:\"Skrivanek helps businesses reach new foreign clients and partners by providing trusthworthy language solutions. Our specialists also have relevant experience in SEO and SEM, essential in maximizing traffic and return on marketing investments.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/skrivanek/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:5143;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.97;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:26.97;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/skrivanek/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"0438c6682b3419cdec4599252fc0fddb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Bulgaria\";s:4:\"code\";s:2:\"BG\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Latvia\";s:4:\"code\";s:2:\"LV\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Lithuania\";s:4:\"code\";s:2:\"LT\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}i:6;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovakia\";s:4:\"code\";s:2:\"SK\";}}}}i:28;C:15:\"WPML_TP_Service\":2005:{a:38:{s:2:\"id\";i:125;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/2m-language-services.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_2m-language-services.png\";s:4:\"name\";s:20:\"2M Language Services\";s:11:\"description\";s:256:\"2M Language Services is one of Australia\'s leading translation company with offices in Europe & South America. Covering over 250 languages and with a network of carefully selected translators, 2M is the go-to for quality technical and general translations.\";s:7:\"doc_url\";s:58:\"https://wpml.org/translation-service/2m-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5249;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.9;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:26.9;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"https://wpml.org/go/2m/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"5a492ffae3952aabc1b3d62dc1b42027\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Australia\";s:4:\"code\";s:2:\"AU\";}}}}i:29;C:15:\"WPML_TP_Service\":2364:{a:38:{s:2:\"id\";i:89;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/simply-translate.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_simply-translate.png\";s:4:\"name\";s:16:\"Simply Translate\";s:11:\"description\";s:260:\"Simply Translate is a professional translation agency for online companies. The combination of in-house language expertise, its user-friendly client platform, and professional translators make it a reliable business partner for your multilingual communication.\";s:7:\"doc_url\";s:53:\"https://wpml.org/translation-service/simply-translate\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:5:\"Email\";s:4:\"name\";s:5:\"email\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5368;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.27;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:26.27;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:68:\"https://www.simplytranslate.com/services/ecommerce-translation/wpml/\";s:19:\"project_details_url\";s:77:\"https://platform.simplytranslate.nl/Client/Project/TranslationProjectOverview\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"edc57d14528262a9d1f19999aef77aef\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:30;C:15:\"WPML_TP_Service\":2072:{a:38:{s:2:\"id\";i:65;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/at-language-solutions.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_at-language-solutions.png\";s:4:\"name\";s:21:\"AT Language Solutions\";s:11:\"description\";s:243:\"AT Language Solutions is a translation services and technology provider with over 20 years’ experience. Specialized in the translation of websites and apps, the development of CAT-tools, cloud and machine translation and tech custom projects\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/at-language-solutions/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API Token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:26;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:41:\"https://wpml.org/go/at-languagesolutions/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e5ad0596522cb049733698b311916864\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:31;C:15:\"WPML_TP_Service\":2069:{a:38:{s:2:\"id\";i:107;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/inpokulis-translations.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_inpokulis-translations.png\";s:4:\"name\";s:22:\"Inpokulis Translations\";s:11:\"description\";s:304:\"Founded almost 20 years ago, Inpokulis is an experienced Portuguese LSP with ISO17100 certification. The skilled in-house team works daily with a network of over 200 translators specialised in different language combinations and areas such as localisation, SEO, legal, tourism, marketing, technical, etc.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/inpokulis-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5460;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/inpokulis/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"420cbf3ca2b01f664c1346c0f80c5cfe\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Portugal\";s:4:\"code\";s:2:\"PT\";}}}}i:32;C:15:\"WPML_TP_Service\":1991:{a:38:{s:2:\"id\";i:131;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/star-translation.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/star-translation.png\";s:4:\"name\";s:16:\"STAR Translation\";s:11:\"description\";s:285:\"STAR is the Technical Translation Specialist, supporting 200+ languages. Particular expertise in Automotive, Cyber-Security Software, Engineering, Heavy Equipment,  Machinery, Agri-Tech, Rail and Transport.  ISO 9001 | ISO 17100 Quality Certified. 50 offices | 35 Countries | 1 Partner\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/star-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:75:\"https://www.star-ts.com/how-do-you-translate-a-wordpress-website-with-wpml/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"f807fe74b8dcd708a354eca5dd3b0e05\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:33;C:15:\"WPML_TP_Service\":2112:{a:38:{s:2:\"id\";i:124;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/traduality.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_traduality.png\";s:4:\"name\";s:11:\"Traduality \";s:11:\"description\";s:251:\"Get your web content translated by professionals who specialize in what you are selling, whether it is products or services. Traduality handpicks the best and offers you Satisfaction Warranty for any language. Globalize your success! We got your back.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/traduality/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/traduality/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"917176f33fae512fbd05bac36acd851e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Costa Rica\";s:4:\"code\";s:2:\"CR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Mexico\";s:4:\"code\";s:2:\"MX\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:34;C:15:\"WPML_TP_Service\":2403:{a:38:{s:2:\"id\";i:35;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/cultures-connection.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_cultures-connection.png\";s:4:\"name\";s:19:\"Cultures Connection\";s:11:\"description\";s:295:\"Cultures Connection is a global company which offers SEO-optimized website translations in more than 250 different languages for companies of all sizes. It was founded in 2007 and has more than 740 professional translators. It specializes in finance, medicine, law, e-commerce and IT industries.\";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/cultures-connection/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.45;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/cultures-connection/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"7ed3f4bbe8a3193a8c81252f3f5a199a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:34:\"Request your API Token to connect!\";s:26:\"how_to_get_credentials_url\";s:70:\"https://culturesconnection.com/wordpress-website-translation-services/\";s:30:\"client_create_account_page_url\";s:99:\"https://wpml.org/translation-service/cultures-connection/#requesting-an-cultures-connection-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Argentina\";s:4:\"code\";s:2:\"AR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:35;C:15:\"WPML_TP_Service\":1967:{a:38:{s:2:\"id\";i:112;s:8:\"logo_url\";s:63:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/mtlt.png\";s:16:\"logo_preview_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_mtlt.png\";s:4:\"name\";s:4:\"MTLT\";s:11:\"description\";s:282:\"MTLT is a network of professional translators offering high-end language services to communicate effectively across different markets & cultures. Take advantage of their skills in translating your content into the language of your target audience with culturally sensitive accuracy.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/mtlt/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5488;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.43;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.43;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:25:\"https://wpml.org/go/mtlt/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c569723b18f7a32e5fe64d152931a331\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}}}}i:36;C:15:\"WPML_TP_Service\":2316:{a:38:{s:2:\"id\";i:102;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/powerling.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_powerling.png\";s:4:\"name\";s:9:\"Powerling\";s:11:\"description\";s:251:\"Powerling supports its customers’ global development by providing high quality multilingual solutions in various business sectors. The company offers services in 75+ languages, including translation, localization, desktop publishing or interpreting.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/powerling\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/powerling/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"94114df20b2adeb581e0c7f3fd7ed85d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:37;C:15:\"WPML_TP_Service\":2740:{a:38:{s:2:\"id\";i:51;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lingo24.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lingo24.png\";s:4:\"name\";s:7:\"Lingo24\";s:11:\"description\";s:277:\"Lingo24 makes it easy for global companies to work in multiple languages. Since 2001, it has provided a technology-led translation approach to enterprises in e-commerce, marketing, and product information content among others. Its 4,000 native translators are spread worldwide.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/lingo24/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:18:\"Authorization Code\";s:4:\"name\";s:18:\"authorization_code\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5447;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.13;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.13;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:28:\"https://wpml.org/go/lingo24/\";s:19:\"project_details_url\";s:33:\"https://ease.lingo24.com/projects\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"26f9d66db808f184a585c9b1ebc854d1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:1;s:9:\"oauth_url\";s:40:\"https://ease.lingo24.com/oauth/authorize\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:101:\"Lingo24 will email you information on how to complete your registration and retrieve your credentials\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/lingo24/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/lingo24/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Panama\";s:4:\"code\";s:2:\"PA\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Philippines\";s:4:\"code\";s:2:\"PH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Romania\";s:4:\"code\";s:2:\"RO\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:38;C:15:\"WPML_TP_Service\":2166:{a:38:{s:2:\"id\";i:105;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/quicksilver-translate.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_quicksilver-translate.png\";s:4:\"name\";s:21:\"Quicksilver Translate\";s:11:\"description\";s:258:\"Multilingual translation and desktop publishing solutions that make multilingual documentation easier. Global reach, all languages, all formats. State-of-the-art software and qualified, bilingual translators carry out large projects in very short timeframes.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/quicksilver-translate/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/quicksilver/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"be1c1d266f78c4dd7778d8afec990b1c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:39;C:15:\"WPML_TP_Service\":2562:{a:38:{s:2:\"id\";i:6;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translatemedia.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translatemedia.png\";s:4:\"name\";s:14:\"TranslateMedia\";s:11:\"description\";s:90:\"Connect your Wordpress site to STREAM™ - TranslateMedia\'s translation management service\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/translatemedia/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:3972;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.87;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.87;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:35:\"https://wpml.org/go/translatemedia/\";s:19:\"project_details_url\";s:85:\"https://services.translatemedia.com/2_0/CorporatePortal/CPFileManager.aspx?platform=3\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"37cfcdf04d20f326391990eee25dd54d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:106:\"Your API key is located under \"Development Center page > API KEY\" on your TranslateMedia account Dashboard\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/translatemedia/#connect-site\";s:30:\"client_create_account_page_url\";s:92:\"https://www.tm-stream.com/2_0/DeveloperCentre/Registration.aspx?platform=uyvm2o1gQZ4!$%C2%A3\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Portugal\";s:4:\"code\";s:2:\"PT\";}}}}i:40;C:15:\"WPML_TP_Service\":2002:{a:38:{s:2:\"id\";i:106;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/world-translation.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_world-translation.png\";s:4:\"name\";s:17:\"World Translation\";s:11:\"description\";s:250:\"World Translation is a Danish company supplying translations and other language services in all languages to companies all over the world. They act as a dynamic partner to their customers and provide quality solutions to strengthen their reputations.\";s:7:\"doc_url\";s:55:\"https://wpml.org/translation-service/world-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5327;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.73;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.73;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/world-translation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e04c35767882abf1c91cfef3695a24a9\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}}}}i:41;C:15:\"WPML_TP_Service\":1990:{a:38:{s:2:\"id\";i:130;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/dadan-translations.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_dadan-translations.png\";s:4:\"name\";s:18:\"DADAN Translations\";s:11:\"description\";s:250:\"Polish company offering translation and localization into European languages. 15 years of experience. Coverage of world\'s biggest brands. Deep knowledge of IT and technical terminology. SEO-compliant. Good marketing taste. Quick delivery, low prices.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/dadan-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/dadan/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3c161bc121001abe14643dea46159b92\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:42;C:15:\"WPML_TP_Service\":2023:{a:38:{s:2:\"id\";i:118;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/datasource-international.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_datasource-international.png\";s:4:\"name\";s:24:\"DataSource International\";s:11:\"description\";s:251:\"DataSource offers professional website translations using native linguists for retail, e-commerce, luxury, finance. They serve clients globally since 2002 and are praised for being accurate, reliable, and flexible.  Easy WPML integration.  Try it now!\";s:7:\"doc_url\";s:62:\"https://wpml.org/translation-service/datasource-international/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/datasource/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"441e5f269caaed31ecd7db9e88e973cc\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}}}}i:43;C:15:\"WPML_TP_Service\":2199:{a:38:{s:2:\"id\";i:104;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/elite-asia.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_elite-asia.png\";s:4:\"name\";s:10:\"Elite Asia\";s:11:\"description\";s:285:\"Headquartered in Singapore, Elite Asia offers translation services in over 70 language pairs, as well as global digital marketing solutions and mass localization technology. It has since managed over 26,000 projects in 26 countries with a talented network of more than 4,000 linguists.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/elite-asia\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/elite-asia/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"b14cb2eee9c013ce014629e5ead4839c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Malaysia\";s:4:\"code\";s:2:\"MY\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Singapore\";s:4:\"code\";s:2:\"SG\";}}}}i:44;C:15:\"WPML_TP_Service\":2223:{a:38:{s:2:\"id\";i:42;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lat-multilingual.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lat-multilingual.png\";s:4:\"name\";s:16:\"LAT Multilingual\";s:11:\"description\";s:246:\"Founded in 1999, LAT provides translation services in most languages, including French Canadian. We work for a wide variety of clients across multiple industries such as tourism, education, food and health, engineering, pharmaceutical and retail.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/lat-multilingual/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5475;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.7;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:23.7;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://wpml.org/go/lat-multilingual/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"17e8abb612636cdd96e60afba259d884\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:64:\"A LAT Multilingual team member will email you a unique API Token\";s:26:\"how_to_get_credentials_url\";s:75:\"https://wpml.org/translation-service/lat-multilingual/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:92:\"https://wpml.org/translation-service/lat-multilingual/#requesting-a-lat-multilingual-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Canada\";s:4:\"code\";s:2:\"CA\";}}}}i:45;C:15:\"WPML_TP_Service\":1957:{a:38:{s:2:\"id\";i:100;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translators-family.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translators-family.png\";s:4:\"name\";s:18:\"Translators Family\";s:11:\"description\";s:205:\"Boutique translation agency specialising in business/marketing and technical translations. It will transcreate and localize your message so that it appeals to your clients. Working with all main languages.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/translators-family/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:23.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/translatorsfamily/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fe7a207a617ad4d4e9a989004eeb6b58\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:46;C:15:\"WPML_TP_Service\":1999:{a:38:{s:2:\"id\";i:126;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/maris-multilingual.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_maris-multilingual.png\";s:4:\"name\";s:18:\"Maris Multilingual\";s:11:\"description\";s:258:\"Maris Multilingual is a Finnish company founded in 2001, with a reputation of a highly professional and quality oriented service provider. It specialises in translations to and from Finnish, but it offers services in all major European and Asian languages.\r\n\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/maris-multilingual/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:23.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/maris/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ebe12b1e2e227a99097e47c2ef401fc5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}}}}i:47;C:15:\"WPML_TP_Service\":2299:{a:38:{s:2:\"id\";i:37;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/espresso-translations.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_espresso-translations.png\";s:4:\"name\";s:21:\"Espresso Translations\";s:11:\"description\";s:275:\"Espresso Translations is a professional translation agency offering a full range of translation services to businesses and individuals worldwide. We offer translation, proofreading, transcription and interpretation services in all languages across a vast array of industries.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/espresso-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:42:\"https://wpml.org/go/espresso-translations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ab06600c2ae77b6fb2945304f3ea8b87\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:33:\"Request your API Token to connect\";s:26:\"how_to_get_credentials_url\";s:65:\"https://www.espressotranslations.com/translate-website-with-wpml/\";s:30:\"client_create_account_page_url\";s:81:\"https://wpml.org/translation-service/espresso-translations/#requesting-an-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:48;C:15:\"WPML_TP_Service\":2330:{a:38:{s:2:\"id\";i:55;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translate-by-humans.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translate-by-humans.png\";s:4:\"name\";s:19:\"Translate By Humans\";s:11:\"description\";s:247:\"Translate By Humans is a London-based translation service with more than a 1,000 language pairs available. Since it was created five years ago, it has served small to medium-size businesses in the legal, medical and travel industries among others.\";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/translate-by-humans/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:65:\"https://www.translatebyhumans.com/en/translation-integration/wpml\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"829a35138840fe2563d620278b5f2239\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:70:\"A Translate by Humans team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:77:\"https://wpml.org/translation-service/translate-by-humans/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:76:\"https://wpml.org/translation-service/translate-by-humans/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"India\";s:4:\"code\";s:2:\"IN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:49;C:15:\"WPML_TP_Service\":1931:{a:38:{s:2:\"id\";i:86;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/alba-translating.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_alba-translating.png\";s:4:\"name\";s:16:\"Alba Translating\";s:11:\"description\";s:189:\"Alba is a Russian ISO qualified translation company with more than 10 years of experience. With an in-house team of expert linguists we can ensure fast and professional-quality translation.\";s:7:\"doc_url\";s:53:\"https://wpml.org/translation-service/alba-translating\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:25:\"https://wpml.org/go/alba/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"14b2bc872d010f0faa5a20fecfbf9ade\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Russian Federation\";s:4:\"code\";s:2:\"RU\";}}}}i:50;C:15:\"WPML_TP_Service\":1956:{a:38:{s:2:\"id\";i:98;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/brightlines-translation.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_brightlines-translation.png\";s:4:\"name\";s:23:\"Brightlines Translation\";s:11:\"description\";s:179:\"Brightlines is a full-service translation agency. We work with the world’s most discerning brands to deliver exceptional marketing translation and multilingual artwork services.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/brightlines-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5501;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.48;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.48;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/brightlines/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"56c2d53d830b84e03980730ae13fbf2a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:51;C:15:\"WPML_TP_Service\":1996:{a:38:{s:2:\"id\";i:81;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/comtec.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_comtec.png\";s:4:\"name\";s:6:\"Comtec\";s:11:\"description\";s:296:\"Comtec supports businesses to reach new markets online in over 200 languages. Comtec provides website translation services by a global network of professional linguists specializing in translation for all key business sectors and complying with ISO 9001:2015 and ISO 17100:2015 quality standards.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/comtec/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:21.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:21.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/comtec/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e18d99ce7d5a481a040f56872065cbb4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:52;C:15:\"WPML_TP_Service\":1968:{a:38:{s:2:\"id\";i:119;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translabel.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translabel.png\";s:4:\"name\";s:10:\"Translabel\";s:11:\"description\";s:249:\"Translabel is a Dutch company which supports businesses throughout the world to reach new markets in over 150 languages. It provides high-quality translations for various industries such as tourism, technology, financial, legal, healthcare and more.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/translabel/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:21.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:21.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/translabel/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6bbbf512b0002189f00c51e120001360\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}}}}i:53;C:15:\"WPML_TP_Service\":1946:{a:38:{s:2:\"id\";i:103;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lengoo.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lengoo.png\";s:4:\"name\";s:6:\"Lengoo\";s:11:\"description\";s:251:\"Lengoo is a large European platform for expert translations with an AI edge. Lengoo rethinks the concept of translation by uniting human creativity with the precision of AI for the highest quality, consistency, and fast results at an unbeatable price.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/lengoo\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5497;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:20.45;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:20.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/lengoo/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e10eca4deecddfa2957f68f5d2f71f28\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}}}}i:54;C:15:\"WPML_TP_Service\":2816:{a:38:{s:2:\"id\";i:87;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/mars-translation.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_mars-translation.png\";s:4:\"name\";s:16:\"Mars Translation\";s:11:\"description\";s:256:\"Mars Translation is an international leader in the translation marketplace that offers a transparent, intuitive and cost-effective online portal to customers who need documents, web content, and video content translated guaranteeing high-quality and speed.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/mars-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:20.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:20.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:36:\"https://wpml.org/go/marstranslation/\";s:19:\"project_details_url\";s:47:\"https://www.marstranslation.com/client/list/all\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"79fe9fda7f31390d11dc1db053cf7f40\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:78:\"Visit our Customer Support online resource to learn more about API Credentials\";s:26:\"how_to_get_credentials_url\";s:106:\"https://www.marstranslation.com/detail/additional-support/how-to-get-api-credentials?affiliate=GgyhEa8h39Y\";s:30:\"client_create_account_page_url\";s:61:\"https://www.marstranslation.com/contact?affiliate=GgyhEa8h39Y\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Pakistan\";s:4:\"code\";s:2:\"PK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:55;C:15:\"WPML_TP_Service\":2477:{a:38:{s:2:\"id\";i:27;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acclaro.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acclaro.png\";s:4:\"name\";s:7:\"Acclaro\";s:11:\"description\";s:178:\"Acclaro specializes in adapting global brands, products, and services to new markets. Acclaro was founded in 2002 and now has offices and affiliates on four different continents.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/acclaro/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:18.78;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:18.78;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/acclaro/\";s:19:\"project_details_url\";s:59:\"https://my.acclaro.com/portal/vieworder.php?id={project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ec87968ba4f260c3872d0edccd130d16\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:43:\"Acclaro will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:66:\"https://wpml.org/translation-service/acclaro/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:75:\"https://wpml.org/translation-service/acclaro/#requesting-an-acclaro-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Argentina\";s:4:\"code\";s:2:\"AR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:56;C:15:\"WPML_TP_Service\":1858:{a:38:{s:2:\"id\";i:129;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nexya.png\";s:16:\"logo_preview_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nexya.png\";s:4:\"name\";s:5:\"Nexya\";s:11:\"description\";s:249:\"The NEXYA team consists of language specialists and localisation engineers. They use technology and agile principles to deliver projects faster and to guarantee quality. NEXYA specialises in localisation for websites, software and digital marketing.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/nexya/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:16.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:16.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"http://www.nexyaloc.com\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ba0378d80e17720d3b96889b29c0ce0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:57;C:15:\"WPML_TP_Service\":2112:{a:38:{s:2:\"id\";i:30;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/language-solutions-inc.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_language-solutions-inc.png\";s:4:\"name\";s:22:\"Language Solutions Inc\";s:11:\"description\";s:190:\"Language Solutions Inc is an American translation and localization firm which specializes in working with healthcare, technical and marketing businesses of all sizes. It was founded in 1998.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/language-solutions-inc/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:15.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:15.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:39:\"https://wpml.org/go/language-solutions/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"265c044355b0bff5f17755503470b225\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:63:\"Language Solutions Inc team will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:81:\"https://wpml.org/translation-service/language-solutions-inc/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:58;C:15:\"WPML_TP_Service\":1963:{a:38:{s:2:\"id\";i:93;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/tomedes.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_tomedes.png\";s:4:\"name\";s:7:\"TOMEDES\";s:11:\"description\";s:259:\"TOMEDES is an Israel-based professional human translation service. Over 10,000 expert translators and linguists will carry out your translation, localization, content and SEO needs. Tomedes provides 24/7 human support and 1-year guarantee on all translations.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/tomedes/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:15.18;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:15.18;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/tomedes/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"0fb9b77c89fae9d873ec66aa9a5c08aa\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:59;C:15:\"WPML_TP_Service\":2522:{a:38:{s:2:\"id\";i:72;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/betranslated-com.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_betranslated-com.png\";s:4:\"name\";s:16:\"BeTranslated.com\";s:11:\"description\";s:294:\"BeTranslated is a network of translation project managers operating as a decentralized translation agency to serve the website and document translation needs of small, medium and large companies across Europe and North America. We specialize in marketing, travel, IT and technical translations.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/betranslated\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:33:\"https://wpml.org/go/betranslated/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fa663ae2188d9dfc589f5b8f6a5c2b0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:63:\"A BeTranslated team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:70:\"https://wpml.org/translation-service/betranslated/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:69:\"https://wpml.org/translation-service/betranslated/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Dominican Republic\";s:4:\"code\";s:2:\"DO\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:60;C:15:\"WPML_TP_Service\":2659:{a:38:{s:2:\"id\";i:10;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translations-com.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translations-com.png\";s:4:\"name\";s:16:\"Translations.com\";s:11:\"description\";s:254:\"Translations.com is one of the largest providers of enterprise localization services and technology solutions. More than 5,000 global organizations employ Translations.com’s GlobalLink® Product Suite to simplify the management of multilingual content.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/translations-com/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:19:\"GlobalLink (GL) URL\";s:4:\"name\";s:3:\"url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:17:\"Project Shortcode\";s:4:\"name\";s:17:\"project_shortcode\";s:4:\"type\";s:4:\"text\";}i:4;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"File Format\";s:4:\"name\";s:11:\"file_format\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.63;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.63;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"http://translations.com/\";s:19:\"project_details_url\";s:37:\"%{connector_url}/#userMenuSUBMISSIONS\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"523d1d409ecdbfb1afa1d29e20b1917b\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:135:\"Your Project Director URL, username, password, and project code are found in the “GlobalLink Technology Configuration” PDF document\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/translations-com/#create-account\";s:30:\"client_create_account_page_url\";s:69:\"https://wpml.org/translation-service/translations-com/#create-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:61;C:15:\"WPML_TP_Service\":1942:{a:38:{s:2:\"id\";i:115;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/tatutrad.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_tatutrad.png\";s:4:\"name\";s:8:\"Tatutrad\";s:11:\"description\";s:241:\"Tatutrad is a language services company with +10 years of experience. They offer creative translation and website localization services of the best quality. Their priority is to make customers’ life easier and let their products go global.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/tatutrad/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/tatutrad/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"553da43ae096e5bf40a25d587618aaf0\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:62;C:15:\"WPML_TP_Service\":2515:{a:38:{s:2:\"id\";i:63;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/simultrans.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_simultrans.png\";s:4:\"name\";s:10:\"SimulTrans\";s:11:\"description\";s:248:\"SimulTrans provides website, software, and document localization services, translating text into over 100 languages. Established in 1984, SimulTrans has international offices and focuses on quality, exemplified by ISO 9001 and 17100 certifications.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/simultrans/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5144;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:13.73;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:13.73;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/simultrans/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c52494d5479d5a888ec98b78965ea2fb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A SimulTrans team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/simultrans/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/simultrans/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Ireland\";s:4:\"code\";s:2:\"IE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:63;C:15:\"WPML_TP_Service\":2395:{a:38:{s:2:\"id\";i:74;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/the-geo-group.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_the-geo-group.png\";s:4:\"name\";s:13:\"The Geo Group\";s:11:\"description\";s:239:\"The Geo Group Corporation is a full-service translation agency based in Madison, WI, since 1991. It has more than 500 translators working in more than 120 languages. It works with small to medium-size businesses in a variety of industries.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/the-geo-group/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5426;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.93;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.93;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/thegeogroup/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cd018f1ac09ae85bc8dfec7a72eb56c3\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:60:\"A Geo Group team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:71:\"https://wpml.org/translation-service/the-geo-group/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:70:\"https://wpml.org/translation-service/the-geo-group/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Korea, Republic of\";s:4:\"code\";s:2:\"KR\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}}}}i:64;C:15:\"WPML_TP_Service\":2218:{a:38:{s:2:\"id\";i:53;s:8:\"logo_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/geacom-gmbh.png\";s:16:\"logo_preview_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_geacom-gmbh.png\";s:4:\"name\";s:11:\"Geacom GmbH\";s:11:\"description\";s:303:\"Geacom offers translations into European, Asian as well as rare languages. Itsnative translators are specialized in areas such as technology, software, law, science, marketing and politics. Geacom\'s project management flow is fast and we are happy to help with any technical or organizational questions.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/geacom-gmbh/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/geacom/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"db61e1e11638127f0e69871d38d15d4b\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:62:\"A Geacom GmbH team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/geacom-gmbh/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/geacom-gmbh/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}}}}i:65;C:15:\"WPML_TP_Service\":1903:{a:38:{s:2:\"id\";i:132;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pantoglot.png\";s:16:\"logo_preview_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pantoglot.png\";s:4:\"name\";s:9:\"Pantoglot\";s:11:\"description\";s:275:\"Its passion for innovation drives Pantoglot to bring effective and efficient technology solutions to market. Today’s leading technology, quality control and agile management practices benefit Pantoglot customers and employee’s improving their experience and satisfaction.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/pantoglot/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.pantoglot.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"351817da1692629dc6a43a4c6b71f48a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:66;C:15:\"WPML_TP_Service\":2313:{a:38:{s:2:\"id\";i:8;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/gengo.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_gengo.png\";s:4:\"name\";s:5:\"Gengo\";s:11:\"description\";s:148:\"Gengo’s people-powered translation platform helps you translate content into over 36 languages through a selective, global network of translators.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/gengo/\";s:3:\"tms\";b:0;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Public key\";s:4:\"name\";s:10:\"public_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5229;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:17:\"http://gengo.com/\";s:19:\"project_details_url\";s:34:\"https://gengo.com/auth/form/login/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"63f155572eb659a462aac247ee1bbf8d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:70:\"Your public and secret keys are found on your Gengo Customer Dashboard\";s:26:\"how_to_get_credentials_url\";s:61:\"https://wpml.org/translation-service/gengo/#generate-api-keys\";s:30:\"client_create_account_page_url\";s:64:\"https://wpml.org/translation-service/gengo/#create-gengo-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Philippines\";s:4:\"code\";s:2:\"PH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:67;C:15:\"WPML_TP_Service\":1831:{a:38:{s:2:\"id\";i:139;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/innovalang.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_innovalang.png\";s:4:\"name\";s:10:\"InnovaLang\";s:11:\"description\";s:245:\"InnovaLang, professional translation: rooted in the patent world, and with burgeoning expertise, we’ve branched out in every field. Helping you to communicate quickly and easily, candidly and effectively. From every language to every language.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.innovalang.eu/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"49f481c1478679b4d4841de986c74b58\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:68;C:15:\"WPML_TP_Service\":2170:{a:38:{s:2:\"id\";i:114;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lionbridge.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lionbridge.png\";s:4:\"name\";s:10:\"Lionbridge\";s:11:\"description\";s:39:\"Lionbridge Connector for Wordpress WPML\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/lionbridge\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Base API URL\";s:4:\"name\";s:12:\"base_api_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:3902;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:10.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:10.58;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:31:\"https://wpml.org/go/lionbridge/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fc480f21118190585ff5d5e5384ae931\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:69;C:15:\"WPML_TP_Service\":1992:{a:38:{s:2:\"id\";i:76;s:8:\"logo_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/rws-moravia.png\";s:16:\"logo_preview_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_rws-moravia.png\";s:4:\"name\";s:11:\"RWS Moravia\";s:11:\"description\";s:124:\"Based in Germany, RWS Moravia has more than 60 years of experience working with medium to large businesses around the world.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/rws-language-solutions/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:10.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:10.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/rws/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"1bdc360fc2fe2ebb177e8a6cb2952d9c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:70;C:15:\"WPML_TP_Service\":1951:{a:38:{s:2:\"id\";i:142;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translations-universe.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translations-universe.png\";s:4:\"name\";s:21:\"Translations Universe\";s:11:\"description\";s:251:\"Translations Universe supports businesses with professional translation skills. It combines human know-how and software to offer translation solutions in 33 languages and 16 expertise areas. Their tools are built to save time and optimize investments.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:9.75;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:9.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://www.translationsuniverse.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"630c5775afcee39ae7f29ef3861f7e1a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:71;C:15:\"WPML_TP_Service\":2481:{a:38:{s:2:\"id\";i:50;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/meridian-linguistics.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_meridian-linguistics.png\";s:4:\"name\";s:20:\"Meridian Linguistics\";s:11:\"description\";s:257:\"Meridian Linguistics is a Hong Kong-based translation services company with stringent quality assurance procedures, specializing in technology, law, business, and more. We offer 200+ languages, with particular expertise in Asia, the Middle East, and Europe.\";s:7:\"doc_url\";s:58:\"https://wpml.org/translation-service/meridian-linguistics/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:8.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/meridian/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"edecb5dee7049e4f69459611e2573779\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:68:\"A Meridian Linguistics team member will email you a unique API Token\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/meridian-linguistics/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:101:\"https://wpml.org/translation-service/meridian-linguistics/#requesting-an-meridian-linguistics-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Korea, Republic of\";s:4:\"code\";s:2:\"KR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:72;C:15:\"WPML_TP_Service\":2005:{a:38:{s:2:\"id\";i:137;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/abroadlink-translations.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_abroadlink-translations.png\";s:4:\"name\";s:23:\"AbroadLink Translations\";s:11:\"description\";s:250:\"AbroadLink is an ISO 13485 (medical devices), ISO 9001 (project management) and ISO 17100 (translation services) certified company offering localization, translation and desktop publishing to multinational corporations and SMB’s into 90+ languages.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/abroadlink-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:8.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.abroadlink.com\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fbd36b346006a2c4bf00c192b0bf7a06\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:73;C:15:\"WPML_TP_Service\":2223:{a:38:{s:2:\"id\";i:138;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/act-translations.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_act-translations.png\";s:4:\"name\";s:16:\"ACT Translations\";s:11:\"description\";s:272:\"ACT Translations uses state-of-the-art strategies and technologies to adapt your content to its target country in terms of its language and culture. The professional processing of e.g. websites, newsletters, blogs and social media content is part of our everyday business.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/a-c-t-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5400;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.25;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:8.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/act/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"1c9ee90afe1cd16780a64a199860d004\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Austria\";s:4:\"code\";s:2:\"AT\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:74;C:15:\"WPML_TP_Service\":2074:{a:38:{s:2:\"id\";i:70;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/speakt.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_speakt.png\";s:4:\"name\";s:6:\"Speakt\";s:11:\"description\";s:199:\"Speakt is a British translation service founded in 2010 and works with small to medium-size businesses. It offers professional human translations for more than 35 languages and 2,000 language pairs. \";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/speakt\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:7.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:7.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/speakt/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"4a52b62404d73d86b86e9cbb05a38eaa\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:57:\"A Speakt team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/speakt/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/speakt/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}}}}i:75;C:15:\"WPML_TP_Service\":2234:{a:38:{s:2:\"id\";i:64;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pluslingua.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pluslingua.png\";s:4:\"name\";s:10:\"PlusLingua\";s:11:\"description\";s:226:\"PlusLingua has offices across Europe and predominantly deals with small to medium-size businesses. Since 2006, it has offered a range of translations for technical documentation, legal documents, marketing and business papers.\";s:7:\"doc_url\";s:80:\"https://wpml.org/translation-service/pluslingua-technical-communication-services\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:7.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:7.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/pluslingua/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ba11f752696ef6a4f922417b1fddb42f\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A PlusLingua team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:101:\"https://wpml.org/translation-service/pluslingua-technical-communication-services/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:100:\"https://wpml.org/translation-service/pluslingua-technical-communication-services/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:76;C:15:\"WPML_TP_Service\":2098:{a:38:{s:2:\"id\";i:29;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pozena.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pozena.png\";s:4:\"name\";s:6:\"Pozena\";s:11:\"description\";s:214:\"POZENA is a Polish localization and translation service with more than 20 years\' experience adapting small to medium-size businesses to new language markets. It has more than 400 clients in 22 different countries. \";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/pozena/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5509;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:5.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:5.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:19:\"https://pozena.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3dbcaf177b3b8a0ffd38c4f077f17df7\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:60:\"A POZENA team member will email your unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/pozena/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:72:\"https://wpml.org/translation-service/pozena/#requesting-a-pozena-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:77;C:15:\"WPML_TP_Service\":2239:{a:38:{s:2:\"id\";i:62;s:8:\"logo_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transfluent-translation-agency.png\";s:16:\"logo_preview_url\";s:97:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transfluent-translation-agency.png\";s:4:\"name\";s:30:\"Transfluent Translation Agency\";s:11:\"description\";s:189:\"Transfluent was founded in 2011 and has bases in USA and Finland. It works with small to medium-size businesses from small game developers to Nasdaq listed companies in dozens of countries.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/transfluent/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/transfluent/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"84e36198cb7f9085ca621971ba0c205b\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:62:\"A Transfluent team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/transfluent/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/transfluent/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:78;C:15:\"WPML_TP_Service\":2665:{a:38:{s:2:\"id\";i:21;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/capita.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_capita.png\";s:4:\"name\";s:6:\"Capita\";s:11:\"description\";s:236:\"CAPITA TI is a British company which has been translating content for commercial businesses and public sector organizations since 1984. It specializes in legal, financial, manufacturing and e-Learning translations in over 180 languages.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/capita/\";s:3:\"tms\";b:0;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Customer Name\";s:4:\"name\";s:13:\"customer_name\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Contact Name\";s:4:\"name\";s:12:\"contact_name\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5486;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.63;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.63;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:27:\"https://wpml.org/go/capita/\";s:19:\"project_details_url\";s:97:\"https://mtpflow.capita-ti.com/module/client/default/request_overview.jsp?request_id=%{request_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3393562c8687d38db9c447854bd20957\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:103:\"The username, password, customer name, and contact name will be provided upon creating a Capita account\";s:26:\"how_to_get_credentials_url\";s:75:\"https://wpml.org/translation-service/capita/#connecting-your-site-to-capita\";s:30:\"client_create_account_page_url\";s:57:\"https://www.capitatranslationinterpreting.com/contact-us/\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:79;C:15:\"WPML_TP_Service\":2038:{a:38:{s:2:\"id\";i:77;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/moncur-consulting.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_moncur-consulting.png\";s:4:\"name\";s:17:\"Moncur Consulting\";s:11:\"description\";s:286:\"Moncur Consulting is a localization agency in Minneapolis, MN. Their leadership has 20+ years of experience in the industry, having worked with agency clients (GMMB, Merkley+Partners, Momentum) and enterprise clients alike (Abbott, General Mills, Mayo Medical Laboratories, Target, etc)\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/moncur-consulting\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/moncur-consulting/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ef1de71437e8348003fc227feb22838f\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:80;C:15:\"WPML_TP_Service\":2041:{a:38:{s:2:\"id\";i:111;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/linguarum.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_linguarum.png\";s:4:\"name\";s:9:\"Linguarum\";s:11:\"description\";s:257:\"As a German agency, Linguarum provides handcrafted translations that are completed by native and specialist translators. Along with individual consulting goes the localization and SEO for your website. Choosing Linguarum means your website is in safe hands.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/linguarum/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5483;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.18;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.18;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/linguarum/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"5ecaa5833688ffb39f39d58b174985f1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:81;C:15:\"WPML_TP_Service\":2006:{a:38:{s:2:\"id\";i:134;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/glyph-language-services.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_glyph-language-services.png\";s:4:\"name\";s:23:\"Glyph Language Services\";s:11:\"description\";s:240:\"Glyph Language Services is a translation and localization company that specializes in high-quality output for complex business cases by utilizing technology and scalable, repeatable workflows with professional talent of the highest caliber.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/glyph-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/glyph/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"99935b523062655817b5579fd3c6fb3c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:82;C:15:\"WPML_TP_Service\":2315:{a:38:{s:2:\"id\";i:56;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nativy-translations.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_nativy-translations.png\";s:4:\"name\";s:19:\"Nativy Translations\";s:11:\"description\";s:194:\"Nativy is a Vienna-based online translation agency offering professional translation services for over 500 language combinations in over 52 areas of specialization like tourism, IT, legal, etc. \";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/nativy-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.75;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/nativy/\";s:19:\"project_details_url\";s:36:\"https://www.nativy.com/client/orders\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"406abbd6c5ab8df7b17f8acc68415b0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:76:\"Contact your Nativy project manager and request your API Key and Private Key\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/nativy-translations/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:79:\"https://wpml.org/translation-service/nativy-translations/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Austria\";s:4:\"code\";s:2:\"AT\";}}}}i:83;C:15:\"WPML_TP_Service\":1997:{a:38:{s:2:\"id\";i:113;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/versacom.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_versacom.png\";s:4:\"name\";s:8:\"Versacom\";s:11:\"description\";s:297:\"Versacom defines what world class means in the translation industry. In addition to multilingual translation services, Versacom offers consulting and numerous specialized services. A whole universe of languages and dialects is within your reach with Versacom\'s professional quality and efficiency.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/versacom/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/versacom/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ea5d9737d96c68da0921eddf3496ca3e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Canada\";s:4:\"code\";s:2:\"CA\";}}}}i:84;C:15:\"WPML_TP_Service\":1862:{a:38:{s:2:\"id\";i:143;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/europa-traduction.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_europa-traduction.png\";s:4:\"name\";s:17:\"Europa Traduction\";s:11:\"description\";s:244:\"Europa Traduction and Tradest are translation companies based in Lyon, France with 25 years + experience in the field of commercial and technical translation.\r\nWe translate multi-language websites with a focus on quality and technical accuracy.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:33:\"https://www.europatraduction.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"9e2f7bbd05eae396b78ffa05cf4d6061\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:85;C:15:\"WPML_TP_Service\":2196:{a:38:{s:2:\"id\";i:73;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/atenao.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_atenao.png\";s:4:\"name\";s:6:\"Atenao\";s:11:\"description\";s:253:\"Trusted translation partner for groups such as Lacoste, L’Oréal, Olympus and Fujifilm Medical Systems, Atenao’s team of professional, native, experienced translators has translated hundreds of marketing, e-commerce, tourism and technology websites.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/atenao/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:2.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:2.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/atenao/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"f249d570e4a79bf3e32907034b4f2f61\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:58:\"An Atenao team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/atenao/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/atenao/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}}}}i:86;C:15:\"WPML_TP_Service\":1879:{a:38:{s:2:\"id\";i:140;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/amplexor.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_amplexor.png\";s:4:\"name\";s:8:\"Amplexor\";s:11:\"description\";s:246:\"At Amplexor, content is a passion. For the past 30 years we have been helping organizations across industries and geographies to leverage content as a strategic differentiator, ensuring efficiency, compliance and exceptional customer experiences.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/amplexor/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:2.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:2.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/amplexor/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6179437065c3a0e537dafd5e967b7bbc\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:87;C:15:\"WPML_TP_Service\":1983:{a:38:{s:2:\"id\";i:116;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/topcontent.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_topcontent.png\";s:4:\"name\";s:10:\"Topcontent\";s:11:\"description\";s:275:\"Topcontent fully integrates with WPML and delivers human made translations of the Northern European languages. Specialized in translations to and from German, Swedish, Norwegian, Finnish, English, Danish, Dutch and Russian. Also experts in iGaming content for online casinos.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/topcontent/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:1.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:1.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/topcontent/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"07e1ea00b30ff50fa156de5853018024\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Malta\";s:4:\"code\";s:2:\"MT\";}}}}i:88;C:15:\"WPML_TP_Service\":2289:{a:38:{s:2:\"id\";i:57;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acculing.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acculing.png\";s:4:\"name\";s:8:\"Acculing\";s:11:\"description\";s:150:\"AccuLing brings together the right combination of people, processes, and technology to provide accuracy, speed, and cost-effectiveness in translation.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/acculing/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:15:\"client_username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:15:\"client_password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:0.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0.83;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:19:\"http://acculing.com\";s:19:\"project_details_url\";s:84:\"https://fluencyserver.com/Acculing/FluencyFlow/CustomerPortal/CustomerDashboard.aspx\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"38a623f611a08d65a565ec91588e74ba\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:102:\"Acculing will email you information on how to complete your registration and retrieve your credentials\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/acculing/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/acculing/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:89;C:15:\"WPML_TP_Service\":2097:{a:38:{s:2:\"id\";i:49;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ulatus.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ulatus.png\";s:4:\"name\";s:6:\"Ulatus\";s:11:\"description\";s:217:\"Ulatus is an American company focusing on Asian languages - explicitly Japanese, Chinese, Korean and Indic languages.  It was founded in 2005 and has 1200 in-territory translators working with a variety of industries.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/ulatus/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:0.75;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"https://www.ulatus.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a922e13546c96ba8d78160d7adc2f9be\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:57:\"A Ulatus team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/ulatus/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/ulatus/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:90;C:15:\"WPML_TP_Service\":2159:{a:38:{s:2:\"id\";i:2;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/cloudwords.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_cloudwords.png\";s:4:\"name\";s:10:\"Cloudwords\";s:11:\"description\";s:268:\"Cloudwords offers quality translation for both small and large websites. In-context review guarantees that all published content meets high standards and you can work with your favorite translation service or locate a translation service in the Cloudwords Marketplace.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/cloudwords/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:26:\"http://www.cloudwords.com/\";s:19:\"project_details_url\";s:56:\"https://app.cloudwords.com/cust.htm#project/{project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:50;s:4:\"suid\";s:32:\"b0a9c2513a2d679dfae1d5ec9846a0d5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:102:\"Your API Token is located under \"Settings >My Account  > API\" tab on your Cloudwords account Dashboard\";s:26:\"how_to_get_credentials_url\";s:61:\"https://wpml.org/translation-service/cloudwords/#connect-site\";s:30:\"client_create_account_page_url\";s:34:\"https://www.cloudwords.com/contact\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:91;C:15:\"WPML_TP_Service\":2434:{a:38:{s:2:\"id\";i:14;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/wordbee-beebox.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_wordbee-beebox.png\";s:4:\"name\";s:14:\"Wordbee Beebox\";s:11:\"description\";s:187:\"Translation service connector. Send content for translation to your preferred language service provider (LSP). Ask your LSP for your authentication details and click below to get started.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/wordbee-beebox/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API URL\";s:4:\"name\";s:7:\"api_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:15:\"API Project Key\";s:4:\"name\";s:15:\"api_project_key\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"API Username\";s:4:\"name\";s:12:\"api_username\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"API Password\";s:4:\"name\";s:12:\"api_password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"http://www.wordbee.com/\";s:19:\"project_details_url\";s:27:\"Translation Service API URL\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"582b86fafdf60f1eba580abc6c56f8ad\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:111:\"Your API URL, API Project Key, API Username and API Password will be provided by your Language Service Provider\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/wordbee-beebox/#connect-site\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/wordbee-beebox/#connect-site\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:92;C:15:\"WPML_TP_Service\":2356:{a:38:{s:2:\"id\";i:15;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transifex.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transifex.png\";s:4:\"name\";s:9:\"Transifex\";s:11:\"description\";s:165:\"The Transifex platform enables companies to produce high-quality translations by connecting their sources of digital content to the translation team of their choice.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/transifex/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:17:\"Organization slug\";s:4:\"name\";s:8:\"org_slug\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Repository URL\";s:4:\"name\";s:8:\"repo_url\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:20:\"http://transifex.com\";s:19:\"project_details_url\";s:33:\"https://www.transifex.com/signin/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"581080d8aad81654458e7d9efa8b9c5a\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:108:\"Your username, password, and organization slug are what you have created during your Transifex account setup\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/transifex/#transifex-account-configuration\";s:30:\"client_create_account_page_url\";s:33:\"https://www.transifex.com/signup/\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:93;C:15:\"WPML_TP_Service\":2191:{a:38:{s:2:\"id\";i:26;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/poeditor.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_poeditor.png\";s:4:\"name\";s:8:\"POEditor\";s:11:\"description\";s:273:\"Warning! To achieve the best results please use POEditor for strings translation only. POEditor is a collaborative platform, built to easily manage the translation of apps, websites or related software, in a team or independently, and to automate the localization workflow.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/poeditor/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:29:\"https://wpml.org/go/poeditor/\";s:19:\"project_details_url\";s:50:\"https://poeditor.com/projects/view?id={project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"97956a8eed5fa652b8c2ec2b9eda6988\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:94:\"Your API Token is located under \"Account Settings > API Access\" tab on your POEditor Dashboard\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/poeditor/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:74:\"https://wpml.org/translation-service/poeditor/#creating-a-poeditor-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:94;C:15:\"WPML_TP_Service\":2288:{a:38:{s:2:\"id\";i:32;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/multitrans.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_multitrans.png\";s:4:\"name\";s:10:\"MultiTrans\";s:11:\"description\";s:214:\"MultiTrans TMS includes Terminology Management, Translation Memories and many other project management and BI modules. With over 25 years of experience, it provides a full range of linguistic products and services.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/multitrans\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Flow URL\";s:4:\"name\";s:8:\"flow_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Customer name\";s:4:\"name\";s:13:\"customer_name\";s:4:\"type\";s:4:\"text\";}i:4;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Contact name\";s:4:\"name\";s:12:\"contact_name\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/multitrans/\";s:19:\"project_details_url\";s:22:\"Project\'s custom field\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e036dae66d3cc50ba9119f3770256b9d\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:95;C:15:\"WPML_TP_Service\":2104:{a:38:{s:2:\"id\";i:46;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/matecat.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_matecat.png\";s:4:\"name\";s:7:\"MateCat\";s:11:\"description\";s:142:\"MateCat is a free translation platform to translate your WordPress content yourself or to assign the translation to a professional translator.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/matecat/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"API Secret\";s:4:\"name\";s:10:\"api_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:28:\"https://wpml.org/go/matecat/\";s:19:\"project_details_url\";s:30:\"https://www.matecat.com/manage\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8cce487cb1cb5f6c7643235e2da82fa4\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:73:\"A member of the MateCat team will email you an API Key and API Secret Key\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/matecat/#receiving-api-keys\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/matecat/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:96;C:15:\"WPML_TP_Service\":2149:{a:38:{s:2:\"id\";i:59;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/memoq.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_memoq.png\";s:4:\"name\";s:5:\"memoQ\";s:11:\"description\";s:212:\"The memoQ connector for WordPress offers a fully automated translation workflow between WPML and memoQ server and provides an easy way to manage multilingual web content and translation projects within WordPress.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/memoq\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Connection key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Connection url\";s:4:\"name\";s:7:\"api_url\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/memoq/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c6e1c5624529722f2bc138dcd0c63ee5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:83:\"Your translation provider will provide your memoQ Connection key and Connection url\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/memoq/#requesting-an-account\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/memoq/#requesting-an-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:97;C:15:\"WPML_TP_Service\":1789:{a:38:{s:2:\"id\";i:82;s:8:\"logo_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pseudo-translation-services.png\";s:16:\"logo_preview_url\";s:94:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pseudo-translation-services.png\";s:4:\"name\";s:27:\"Pseudo Translation Services\";s:11:\"description\";s:153:\"This is a demo service for learning and practicing the WPML workflow for professional translation. To authenticate please use any string as an API Token.\";s:7:\"doc_url\";s:14:\"http://lvh.me/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:14:\"http://lvh.me/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a31f833a7b129003abe76987b06c8e44\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:98;C:15:\"WPML_TP_Service\":1854:{a:38:{s:2:\"id\";i:83;s:8:\"logo_url\";s:63:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lilt.png\";s:16:\"logo_preview_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lilt.png\";s:4:\"name\";s:4:\"Lilt\";s:11:\"description\";s:197:\"Lilt is the new engine for enterprise translation workflows. We increase quality and speed with the neural feedback loop which combines human ingenuity and machine intelligence in a virtuous cycle.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/lilt/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:16:\"https://lilt.com\";s:19:\"project_details_url\";s:60:\"https://lilt.com/app/projects/details/{project_id}/documents\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ffad5fa853bba0b6c9eda94b382b0201\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:99;C:15:\"WPML_TP_Service\":2088:{a:38:{s:2:\"id\";i:117;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartcat.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartcat.png\";s:4:\"name\";s:8:\"Smartcat\";s:11:\"description\";s:225:\"Smartcat is an all-in-one platform connecting businesses and translators into a continuous translation delivery loop by combining a collaborative workflow solution, a marketplace, and a network of translation professionals.\r\n\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/smartcat/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Server URL\";s:4:\"name\";s:10:\"server_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Account ID\";s:4:\"name\";s:10:\"account_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:24:\"https://www.smartcat.ai/\";s:19:\"project_details_url\";s:36:\"%{server_url}/projects/%{project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"d1c696251639dde597dd81b6fec113a9\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:100;C:15:\"WPML_TP_Service\":2339:{a:38:{s:2:\"id\";i:121;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartling.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartling.png\";s:4:\"name\";s:9:\"Smartling\";s:11:\"description\";s:285:\"Smartling is a translation management platform and language services provider to localize content across devices and platforms. Author of Enterprise Translation Cloud, a data-driven approach to localization that helps customers achieve higher quality translation at a lower total cost.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/smartling/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:15:\"User Identifier\";s:4:\"name\";s:15:\"user_identifier\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"User Secret\";s:4:\"name\";s:11:\"user_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Account UID\";s:4:\"name\";s:11:\"account_uid\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Project ID\";s:4:\"name\";s:10:\"project_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.smartling.com/\";s:19:\"project_details_url\";s:92:\"https://dashboard.smartling.com/app/accounts/{account_id}/account-jobs/{project_id}:{job_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3f1d34db7a1c34e0840e81b4aceb97db\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:101;C:15:\"WPML_TP_Service\":2496:{a:38:{s:2:\"id\";i:144;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/sdl-language-cloud-tms.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_sdl-language-cloud-tms.png\";s:4:\"name\";s:22:\"SDL Language Cloud TMS\";s:11:\"description\";s:221:\"The SDL Language Cloud TMS connector for WPML provides a seamless link between WPML and SDL Language Cloud TMS, allowing fast and easy management of multilingual web content and translation projects from within WordPress.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/sdl-language-cloud/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:30:\"https://languagecloud.sdl.com/\";s:19:\"project_details_url\";s:45:\"https://languagecloud.sdl.com/en/cp/dashboard\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a87dad5a887e062d5a269574bd54fc3b\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:97:\"Your username and password are the same as the credentials you use to login to SDL Language Cloud\";s:26:\"how_to_get_credentials_url\";s:85:\"https://wpml.org/translation-service/sdl-language-cloud/#connecting-to-language-cloud\";s:30:\"client_create_account_page_url\";s:54:\"https://oos.sdl.com/asp/products/ssl/RegisterUser.aspx\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}}","no");

INSERT INTO `wp_options` VALUES 
("3162","wpml_shortcode_list","a:291:{i:0;s:14:\"call_to_action\";i:1;s:10:\"newsletter\";i:2;s:15:\"tours_shortcode\";i:3;s:10:\"cta_button\";i:4;s:20:\"woocommerce_thankyou\";i:5;s:16:\"woocommerce_shop\";i:6;s:5:\"table\";i:7;s:14:\"custom_profile\";i:8;s:14:\"symple_heading\";i:9;s:3:\"row\";i:10;s:8:\"tagcloud\";i:11;s:5:\"sform\";i:12;s:4:\"nano\";i:13;s:16:\"add_eventon_list\";i:14;s:3:\"che\";i:15;s:3:\"era\";i:16;s:4:\"essa\";i:17;s:3:\"nel\";i:18;s:3:\"gli\";i:19;s:3:\"per\";i:20;s:4:\"come\";i:21;s:5:\"anima\";i:22;s:4:\"ella\";i:23;s:4:\"quel\";i:24;s:18:\"show_gd_mylist_btn\";i:25;s:10:\"su_spoiler\";i:26;s:5:\"email\";i:27;s:3:\"vul\";i:28;s:8:\"wpv-view\";i:29;s:14:\"wpv-post-field\";i:30;s:14:\"accordion_item\";i:31;s:8:\"citation\";i:32;s:7:\"gallery\";i:33;s:10:\"foogallery\";i:34;s:20:\"user-submitted-posts\";i:35;s:11:\"chronologie\";i:36;s:7:\"adresse\";i:37;s:14:\"get_unit_label\";i:38;s:19:\"get_reference_label\";i:39;s:36:\"woocommerce_api_manager_lost_api_key\";i:40;s:16:\"wp-knowledgebase\";i:41;s:19:\"testimonials_slider\";i:42;s:4:\"rpwe\";i:43;s:5:\"posts\";i:44;s:9:\"nowotworu\";i:45;s:12:\"intima-media\";i:46;s:9:\"dostarcza\";i:47;s:14:\"standaryzowany\";i:48;s:4:\"jako\";i:49;s:6:\"czarny\";i:50;s:8:\"ekstrakt\";i:51;s:4:\"kwas\";i:52;s:3:\"std\";i:53;s:10:\"dwuwodzian\";i:54;s:12:\"stm_icon_box\";i:55;s:8:\"ess_grid\";i:56;s:10:\"rev_slider\";i:57;s:8:\"linkview\";i:58;s:7:\"dropcap\";i:59;s:13:\"permalinklist\";i:60;s:18:\"testimonial_slider\";i:61;s:33:\"woocommerce_software_lost_license\";i:62;s:11:\"text-blocks\";i:63;s:15:\"wp_sitemap_page\";i:64;s:11:\"wcmp_vendor\";i:65;s:19:\"vendor_registration\";i:66;s:6:\"efsrow\";i:67;s:9:\"efscolumn\";i:68;s:9:\"efsbutton\";i:69;s:13:\"md_rev_slider\";i:70;s:12:\"md_live_text\";i:71;s:16:\"md_imagebox_full\";i:72;s:10:\"flagallery\";i:73;s:18:\"pbr_quicklinksmenu\";i:74;s:13:\"rev_slider_vc\";i:75;s:26:\"opalhotel_reservation_form\";i:76;s:17:\"pbr_title_heading\";i:77;s:16:\"pbr_testimonials\";i:78;s:7:\"embedyt\";i:79;s:18:\"yith_wcwl_wishlist\";i:80;s:22:\"wcm_content_restricted\";i:81;s:11:\"feature_box\";i:82;s:20:\"woocommerce_en_check\";i:83;s:6:\"wc_box\";i:84;s:6:\"wc_row\";i:85;s:9:\"wc_column\";i:86;s:12:\"wc_fullwidth\";i:87;s:9:\"wc_center\";i:88;s:17:\"wp_social_sharing\";i:89;s:9:\"infoboxes\";i:90;s:12:\"testimonials\";i:91;s:38:\"woocommerce_social_media_share_buttons\";i:92;s:20:\"wcv_vendor_dashboard\";i:93;s:17:\"wcv_shop_settings\";i:94;s:10:\"wcv_orders\";i:95;s:8:\"inplayer\";i:96;s:12:\"useyourdrive\";i:97;s:16:\"wp_blog_designer\";i:98;s:7:\"us_blog\";i:99;s:10:\"tt_address\";i:100;s:12:\"tt_dashboard\";i:101;s:14:\"envira-gallery\";i:102;s:11:\"hotspotitem\";i:103;s:27:\"woocommerce_klarna_checkout\";i:104;s:11:\"wpml_mailto\";i:105;s:13:\"contact-field\";i:106;s:9:\"ux_banner\";i:107;s:15:\"advanced_iframe\";i:108;s:17:\"siteorigin_widget\";i:109;s:8:\"ec_store\";i:110;s:22:\"simpay_payment_receipt\";i:111;s:10:\"su-mensaje\";i:112;s:14:\"borlabs_cookie\";i:113;s:12:\"contact_info\";i:114;s:15:\"stm_boats_video\";i:115;s:18:\"packages_orderdata\";i:116;s:24:\"yith_ywraq_request_quote\";i:117;s:15:\"woocommerce_pay\";i:118;s:6:\"button\";i:119;s:16:\"supsystic-tables\";i:120;s:11:\"clean-login\";i:121;s:15:\"woocommerce_pay\";i:122;s:12:\"pdf-embedder\";i:123;s:15:\"insertgenerator\";i:124;s:15:\"youzer_register\";i:125;s:11:\"wysija_form\";i:126;s:5:\"video\";i:127;s:13:\"customer-area\";i:128;s:23:\"customer-area-dashboard\";i:129;s:32:\"customer-area-private-files-home\";i:130;s:27:\"customer-area-private-files\";i:131;s:21:\"customer-account-home\";i:132;s:21:\"customer-area-account\";i:133;s:20:\"customer-area-logout\";i:134;s:11:\"bookly-form\";i:135;s:32:\"bookly-cancellation-confirmation\";i:136;s:18:\"stm_classic_filter\";i:137;s:13:\"popup_trigger\";i:138;s:21:\"mainwp_archived_lists\";i:139;s:15:\"wcv_vendorslist\";i:140;s:14:\"dotpay_content\";i:141;s:9:\"formularz\";i:142;s:41:\"cyberactive_school_courses_selection_form\";i:143;s:34:\"cyberactive_school_session_timeout\";i:144;s:17:\"ditty_news_ticker\";i:145;s:16:\"donationcampaign\";i:146;s:15:\"das-list-events\";i:147;s:11:\"event_embed\";i:148;s:12:\"sectiontitle\";i:149;s:19:\"learn_press_profile\";i:150;s:13:\"ticket-submit\";i:151;s:7:\"tickets\";i:152;s:10:\"aanduiding\";i:153;s:5:\"datum\";i:154;s:13:\"thim-icon-box\";i:155;s:10:\"ngg_images\";i:156;s:15:\"wpdomainchecker\";i:157;s:10:\"visualizer\";i:158;s:15:\"mk_page_section\";i:159;s:10:\"rssreviews\";i:160;s:12:\"animate_this\";i:161;s:14:\"simple-sitemap\";i:162;s:11:\"gravityform\";i:163;s:13:\"stm_tech_info\";i:164;s:19:\"fep_submission_form\";i:165;s:26:\"ucaddon_diagonal_event_box\";i:166;s:17:\"wcv_feedback_form\";i:167;s:22:\"newsletters_management\";i:168;s:17:\"wcv_pro_dashboard\";i:169;s:13:\"tm_pb_section\";i:170;s:20:\"wwof_product_listing\";i:171;s:7:\"res_map\";i:172;s:15:\"jssupportticket\";i:173;s:9:\"socialbar\";i:174;s:17:\"socialbar_service\";i:175;s:12:\"front-end-pm\";i:176;s:11:\"stm_sidebar\";i:177;s:12:\"give_receipt\";i:178;s:16:\"donation_history\";i:179;s:12:\"simpay_error\";i:180;s:19:\"tm_pb_contact_field\";i:181;s:3:\"jwp\";i:182;s:20:\"woocommerce_checkout\";i:183;s:14:\"mk_custom_list\";i:184;s:8:\"sg_popup\";i:185;s:4:\"icon\";i:186;s:10:\"extra_wrap\";i:187;s:13:\"frontier-post\";i:188;s:8:\"invierno\";i:189;s:6:\"appbox\";i:190;s:9:\"highlight\";i:191;s:8:\"ci_alert\";i:192;s:15:\"vc_mad_products\";i:193;s:7:\"dt_list\";i:194;s:15:\"geoip-continent\";i:195;s:13:\"geoip-country\";i:196;s:12:\"geoip-region\";i:197;s:10:\"geoip-city\";i:198;s:16:\"geoip-postalcode\";i:199;s:14:\"geoip-latitude\";i:200;s:15:\"geoip-longitude\";i:201;s:14:\"geoip-location\";i:202;s:19:\"woocommerce_notices\";i:203;s:12:\"stm_icon_box\";i:204;s:13:\"post-timeline\";i:205;s:10:\"tt_address\";i:206;s:15:\"private-message\";i:207;s:10:\"visualizer\";i:208;s:9:\"ga_optout\";i:209;s:23:\"manage_serial_key_usage\";i:210;s:9:\"ut_header\";i:211;s:9:\"site_name\";i:212;s:6:\"bfname\";i:213;s:8:\"order_id\";i:214;s:12:\"menu-country\";i:215;s:11:\"menu-prefer\";i:216;s:14:\"accordion-item\";i:217;s:9:\"mini-icon\";i:218;s:7:\"gvlogic\";i:219;s:8:\"stm_gmap\";i:220;s:12:\"contact-form\";i:221;s:7:\"iconbox\";i:222;s:22:\"woocommerce_my_account\";i:223;s:10:\"super_form\";i:224;s:17:\"wpdm-all-packages\";i:225;s:11:\"photoblocks\";i:226;s:13:\"et_pb_map_pin\";i:227;s:19:\"ginger_reset_cookie\";i:228;s:10:\"su_divider\";i:229;s:16:\"fbl_login_button\";i:230;s:19:\"gmw_single_location\";i:231;s:8:\"one_full\";i:232;s:15:\"recent_products\";i:233;s:11:\"custom_list\";i:234;s:5:\"endif\";i:235;s:5:\"jours\";i:236;s:10:\"wpuf-login\";i:237;s:4:\"lyte\";i:238;s:13:\"product_table\";i:239;s:17:\"wpuf-registration\";i:240;s:14:\"wpuf_dashboard\";i:241;s:6:\"amazon\";i:242;s:20:\"member-pricing-table\";i:243;s:7:\"rozinky\";i:244;s:10:\"ngg_images\";i:245;s:15:\"add_to_cart_url\";i:246;s:15:\"srizonfbgallery\";i:247;s:11:\"wysija_form\";i:248;s:8:\"cl-itext\";i:249;s:7:\"embedyt\";i:250;s:12:\"icon_counter\";i:251;s:10:\"text_block\";i:252;s:8:\"vtftable\";i:253;s:13:\"header_static\";i:254;s:15:\"bookingcalendar\";i:255;s:10:\"flexslider\";i:256;s:16:\"anova-geoip-meta\";i:257;s:23:\"zp_vc_slideshow_element\";i:258;s:11:\"zp_scrollto\";i:259;s:20:\"my_calendar_upcoming\";i:260;s:12:\"wpv-post-url\";i:261;s:13:\"fusion_button\";i:262;s:6:\"su_tab\";i:263;s:37:\"freeconsultation_technical_forum_link\";i:264;s:18:\"vc_images_carousel\";i:265;s:13:\"otgs_logo_url\";i:266;s:15:\"wpv-conditional\";i:267;s:8:\"wpv-view\";i:268;s:6:\"teaser\";i:269;s:14:\"dt_fancy_image\";i:270;s:18:\"fusion_tagline_box\";i:271;s:14:\"contact_us_add\";i:272;s:11:\"content_box\";i:273;s:11:\"tagline_box\";i:274;s:10:\"us_iconbox\";i:275;s:10:\"fusion_tab\";i:276;s:11:\"fisicamente\";i:277;s:16:\"one_half_sidebar\";i:278;s:10:\"action-btn\";i:279;s:16:\"invicta_contacts\";i:280;s:13:\"pricing_price\";i:281;s:6:\"button\";i:282;s:9:\"icon_link\";i:283;s:9:\"slideshow\";i:284;s:14:\"vcex_milestone\";i:285;s:14:\"secondary-demo\";i:286;s:16:\"vh_pricing_table\";i:287;s:13:\"category_name\";i:288;s:7:\"blogurl\";i:289;s:6:\"q_team\";i:290;s:12:\"tab_nav_item\";}","yes"),
("3163","wpml_built_with_page_builder","a:1:{i:0;s:10:\"/<!-- wp:/\";}","yes"),
("3164","wpml-gutenberg-config","a:59:{s:14:\"core/paragraph\";a:1:{s:5:\"xpath\";a:1:{i:0;s:3:\"//p\";}}s:12:\"core/heading\";a:1:{s:5:\"xpath\";a:1:{i:0;s:73:\"//*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]\";}}s:11:\"core/button\";a:1:{s:5:\"xpath\";a:2:{i:0;s:3:\"//a\";i:1;a:2:{s:5:\"value\";s:9:\"//a/@href\";s:4:\"type\";s:4:\"LINK\";}}}s:10:\"core/image\";a:1:{s:5:\"xpath\";a:4:{i:0;s:19:\"//figure/figcaption\";i:1;s:18:\"//figure//img/@alt\";i:2;s:20:\"//figure//img/@title\";i:3;a:2:{s:5:\"value\";s:16:\"//figure/a/@href\";s:4:\"type\";s:4:\"LINK\";}}}s:12:\"core/gallery\";a:1:{s:5:\"xpath\";a:2:{i:0;s:19:\"//figure/figcaption\";i:1;s:17:\"//figure/img/@alt\";}}s:15:\"core/media-text\";a:1:{s:5:\"xpath\";a:1:{i:0;s:17:\"//figure/img/@alt\";}}s:9:\"core/list\";a:1:{s:5:\"xpath\";a:1:{i:0;s:15:\"//ul/li|//ol/li\";}}s:10:\"core/quote\";a:1:{s:5:\"xpath\";a:2:{i:0;s:14:\"//blockquote/p\";i:1;s:17:\"//blockquote/cite\";}}s:10:\"core/audio\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:10:\"core/video\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:9:\"core/file\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/a\";}}s:10:\"core/cover\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/p\";}}s:16:\"core/cover-image\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/p\";}}s:12:\"core/subhead\";a:1:{s:5:\"xpath\";a:1:{i:0;s:3:\"//p\";}}s:10:\"core/verse\";a:1:{s:5:\"xpath\";a:1:{i:0;s:5:\"//pre\";}}s:10:\"core/table\";a:1:{s:5:\"xpath\";a:3:{i:0;s:4:\"//th\";i:1;s:4:\"//td\";i:2;s:19:\"//figure/figcaption\";}}s:17:\"core/preformatted\";a:1:{s:5:\"xpath\";a:1:{i:0;s:5:\"//pre\";}}s:14:\"core/pullquote\";a:1:{s:5:\"xpath\";a:2:{i:0;s:14:\"//blockquote/p\";i:1;s:17:\"//blockquote/cite\";}}s:11:\"core/column\";a:0:{}s:12:\"core/columns\";a:0:{}s:9:\"core/code\";a:0:{}s:9:\"core/more\";a:0:{}s:13:\"core/nextpage\";a:0:{}s:14:\"core/separator\";a:0:{}s:11:\"core/spacer\";a:0:{}s:14:\"core/shortcode\";a:0:{}s:18:\"core-embed/twitter\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/youtube\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:19:\"core-embed/facebook\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/instagram\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/vimeo\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/soundcloud\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/spotify\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/flickr\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/animoto\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/collegehumor\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/dailymotion\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/funnyordie\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:15:\"core-embed/hulu\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/imgur\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/issuu\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/kickstarter\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/meetup-com\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:19:\"core-embed/mixcloud\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/photobucket\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/polldaddy\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/reddit\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/reverbnation\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/screencast\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/scribd\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/slideshare\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/smugmug\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/speaker\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:14:\"core-embed/ted\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/tumblr\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/videopress\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/wordpress\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/wordpress-tv\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:9:\"core/html\";a:1:{s:5:\"xpath\";a:1:{i:0;s:2:\"/*\";}}}","yes"),
("3165","wpml-tm-translation-jobs-migration","1","yes"),
("3166","wpml-tm-all-translation-jobs-migration","3","yes"),
("3178","wpml_strings_need_links_fixed","a:0:{}","yes"),
("3197","otgs-installer-log","a:7:{i:0;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-27-04 06:04:25\";}i:1;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-26-04 06:04:56\";}i:2;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-23-04 06:04:39\";}i:3;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-21-04 08:04:15\";}i:4;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-20-04 08:04:11\";}i:5;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-19-04 08:04:13\";}i:6;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:35:\"Subscriptions updated successfully.\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-18-04 07:04:00\";}}","yes"),
("3207","installer_repositories_with_theme","a:1:{i:0;s:7:\"toolset\";}","yes"),
("3221","wpml_registered_endpoints","a:0:{}","yes"),
("3270","icl_translation_jobs_basket","a:1:{s:16:\"target_languages\";a:0:{}}","no"),
("3297","options_theme_settings_group_theme_header_scripts_head","<script>\r\nconsole.log(\"head tag here\");\r\n</script>","no"),
("3298","_options_theme_settings_group_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("3299","options_theme_settings_group_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"after body opening\");\r\n</script>","no"),
("3300","_options_theme_settings_group_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("3301","options_theme_settings_group_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"in the footer\");\r\n</script>","no"),
("3302","_options_theme_settings_group_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("3303","options_theme_settings_group_social_media_icons_0_social_media_item_name","Facebook","no"),
("3304","_options_theme_settings_group_social_media_icons_0_social_media_item_name","field_607c285af4ce0","no"),
("3305","options_theme_settings_group_social_media_icons_0_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>","no"),
("3306","_options_theme_settings_group_social_media_icons_0_social_media_item_icon","field_607c2867f4ce1","no"),
("3307","options_theme_settings_group_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("3308","_options_theme_settings_group_social_media_icons_0_social_media_item_url","field_607c287af4ce2","no"),
("3309","options_theme_settings_group_social_media_icons_1_social_media_item_name","Youtube","no"),
("3310","_options_theme_settings_group_social_media_icons_1_social_media_item_name","field_607c285af4ce0","no"),
("3311","options_theme_settings_group_social_media_icons_1_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>","no"),
("3312","_options_theme_settings_group_social_media_icons_1_social_media_item_icon","field_607c2867f4ce1","no"),
("3313","options_theme_settings_group_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("3314","_options_theme_settings_group_social_media_icons_1_social_media_item_url","field_607c287af4ce2","no"),
("3315","options_theme_settings_group_social_media_icons_2_social_media_item_name","Instagram","no"),
("3316","_options_theme_settings_group_social_media_icons_2_social_media_item_name","field_607c285af4ce0","no"),
("3317","options_theme_settings_group_social_media_icons_2_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>","no"),
("3318","_options_theme_settings_group_social_media_icons_2_social_media_item_icon","field_607c2867f4ce1","no"),
("3319","options_theme_settings_group_social_media_icons_2_social_media_item_url","https://instagram","no"),
("3320","_options_theme_settings_group_social_media_icons_2_social_media_item_url","field_607c287af4ce2","no"),
("3321","options_theme_settings_group_social_media_icons","3","no"),
("3322","_options_theme_settings_group_social_media_icons","field_607c284af4cdf","no"),
("3323","options_theme_settings_group_theme_404_header_theme","dark","no"),
("3324","_options_theme_settings_group_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3325","options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("3326","_options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("3327","options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("3328","_options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("3329","options_theme_settings_group_theme_404_reuseable_section_rules","","no"),
("3330","_options_theme_settings_group_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("3331","options_theme_settings_group_theme_404_theme_404_text","<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.","no"),
("3332","_options_theme_settings_group_theme_404_theme_404_text","field_606eff990ac3e","no"),
("3333","options_theme_settings_group_theme_404","","no"),
("3334","_options_theme_settings_group_theme_404","field_606eff05095e9","no"),
("3335","options_theme_settings_group","","no"),
("3336","_options_theme_settings_group","field_607c280aa71fc","no"),
("3394","options_da_theme_settings_group_theme_header_scripts_head","<script>\r\nconsole.log(\"head tag\");\r\n</script>","no"),
("3395","_options_da_theme_settings_group_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("3396","options_da_theme_settings_group_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"after body opening\");\r\n</script>","no"),
("3397","_options_da_theme_settings_group_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("3398","options_da_theme_settings_group_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"in the footer\");\r\n</script>","no"),
("3399","_options_da_theme_settings_group_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("3400","options_da_theme_settings_group_social_media_icons_0_social_media_item_name","Facebook","no"),
("3401","_options_da_theme_settings_group_social_media_icons_0_social_media_item_name","field_607c285af4ce0","no"),
("3402","options_da_theme_settings_group_social_media_icons_0_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>","no"),
("3403","_options_da_theme_settings_group_social_media_icons_0_social_media_item_icon","field_607c2867f4ce1","no"),
("3404","options_da_theme_settings_group_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("3405","_options_da_theme_settings_group_social_media_icons_0_social_media_item_url","field_607c287af4ce2","no"),
("3406","options_da_theme_settings_group_social_media_icons_1_social_media_item_name","Youtube","no"),
("3407","_options_da_theme_settings_group_social_media_icons_1_social_media_item_name","field_607c285af4ce0","no"),
("3408","options_da_theme_settings_group_social_media_icons_1_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>","no"),
("3409","_options_da_theme_settings_group_social_media_icons_1_social_media_item_icon","field_607c2867f4ce1","no"),
("3410","options_da_theme_settings_group_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("3411","_options_da_theme_settings_group_social_media_icons_1_social_media_item_url","field_607c287af4ce2","no"),
("3412","options_da_theme_settings_group_social_media_icons_2_social_media_item_name","Instagram","no"),
("3413","_options_da_theme_settings_group_social_media_icons_2_social_media_item_name","field_607c285af4ce0","no"),
("3414","options_da_theme_settings_group_social_media_icons_2_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>","no"),
("3415","_options_da_theme_settings_group_social_media_icons_2_social_media_item_icon","field_607c2867f4ce1","no"),
("3416","options_da_theme_settings_group_social_media_icons_2_social_media_item_url","https://instagram","no"),
("3417","_options_da_theme_settings_group_social_media_icons_2_social_media_item_url","field_607c287af4ce2","no"),
("3418","options_da_theme_settings_group_social_media_icons","3","no"),
("3419","_options_da_theme_settings_group_social_media_icons","field_607c284af4cdf","no"),
("3420","options_da_theme_settings_group_theme_404_header_theme","dark","no"),
("3421","_options_da_theme_settings_group_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3422","options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("3423","_options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("3424","options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("3425","_options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("3426","options_da_theme_settings_group_theme_404_reuseable_section_rules","","no"),
("3427","_options_da_theme_settings_group_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("3428","options_da_theme_settings_group_theme_404_theme_404_text","<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.","no"),
("3429","_options_da_theme_settings_group_theme_404_theme_404_text","field_606eff990ac3e","no"),
("3430","options_da_theme_settings_group_theme_404","","no"),
("3431","_options_da_theme_settings_group_theme_404","field_606eff05095e9","no"),
("3432","options_da_theme_settings_group","a:5:{s:19:\"field_606df4d8c1f9d\";s:45:\"<script>\r\nconsole.log(\"head tag\");\r\n</script>\";s:19:\"field_606df57ec1f9e\";s:55:\"<script>\r\nconsole.log(\"after body opening\");\r\n</script>\";s:19:\"field_606df5c2c1f9f\";s:50:\"<script>\r\nconsole.log(\"in the footer\");\r\n</script>\";s:19:\"field_607c284af4cdf\";a:3:{i:0;a:3:{s:19:\"field_607c285af4ce0\";s:8:\"Facebook\";s:19:\"field_607c2867f4ce1\";s:386:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:20:\"https://facebook.com\";}i:1;a:3:{s:19:\"field_607c285af4ce0\";s:7:\"Youtube\";s:19:\"field_607c2867f4ce1\";s:592:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:19:\"https://youtube.com\";}i:2;a:3:{s:19:\"field_607c285af4ce0\";s:9:\"Instagram\";s:19:\"field_607c2867f4ce1\";s:1046:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:17:\"https://instagram\";}}s:19:\"field_606eff05095e9\";a:3:{s:39:\"field_606f0135bbcfd_field_606cc823a35b8\";s:4:\"dark\";s:39:\"field_606eff6d0ac3d_field_606469c2a9cc1\";a:2:{s:19:\"field_606469f51d054\";s:0:\"\";s:19:\"field_60646a081d055\";s:7:\"default\";}s:19:\"field_606eff990ac3e\";s:82:\"<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.\";}}","no"),
("3433","_options_da_theme_settings_group","field_607c280aa71fc","no"),
("3566","wpml-previous-default-language","en","yes"),
("3685","category_children_da","a:0:{}","yes"),
("3690","_wpml_batch_report","a:1:{i:1;a:1:{s:5:\"en|da\";a:5:{i:0;a:3:{s:10:\"element_id\";s:3:\"586\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"1\";}i:1;a:3:{s:10:\"element_id\";s:3:\"822\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"2\";}i:2;a:3:{s:10:\"element_id\";s:3:\"426\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"3\";}i:3;a:3:{s:10:\"element_id\";s:3:\"305\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"4\";}i:4;a:3:{s:10:\"element_id\";s:3:\"266\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"5\";}}}}","no"),
("3727","acfml_synchronise_repeater_fields","a:2:{i:822;b:0;i:266;b:1;}","yes"),
("3776","wpml_notices","a:1:{s:26:\"taxonomy-term-help-notices\";a:2:{s:8:\"post_tag\";O:11:\"WPML_Notice\":24:{s:30:\"\0WPML_Notice\0display_callbacks\";a:1:{i:0;a:2:{i:0;O:37:\"WPML_Taxonomy_Translation_Help_Notice\":2:{s:57:\"\0WPML_Taxonomy_Translation_Help_Notice\0wpml_admin_notices\";O:12:\"WPML_Notices\":6:{s:27:\"\0WPML_Notices\0notice_render\";O:18:\"WPML_Notice_Render\":3:{s:38:\"\0WPML_Notice_Render\0dismiss_html_added\";b:0;s:35:\"\0WPML_Notice_Render\0hide_html_added\";b:0;s:39:\"\0WPML_Notice_Render\0collapse_html_added\";b:0;}s:21:\"\0WPML_Notices\0notices\";a:1:{s:26:\"taxonomy-term-help-notices\";N;}s:31:\"\0WPML_Notices\0notices_to_remove\";a:1:{s:12:\"requirements\";a:0:{}}s:23:\"\0WPML_Notices\0dismissed\";a:0:{}s:28:\"\0WPML_Notices\0user_dismissed\";a:0:{}s:34:\"\0WPML_Notices\0original_notices_md5\";s:32:\"40cd750bba9870f18aada2478b24840a\";}s:45:\"\0WPML_Taxonomy_Translation_Help_Notice\0notice\";r:3;}i:1;s:26:\"should_display_help_notice\";}}s:15:\"\0WPML_Notice\0id\";s:8:\"post_tag\";s:17:\"\0WPML_Notice\0text\";s:218:\"Translating Tags? Use the <a href=\"https://milo.sgsmedia.dk/wp/wp-admin/admin.php?page=sitepress-multilingual-cms/menu/taxonomy-translation.php&#038;taxonomy=post_tag\"> Tag translation</a> table for easier translation.\";s:27:\"\0WPML_Notice\0collapsed_text\";N;s:18:\"\0WPML_Notice\0group\";s:26:\"taxonomy-term-help-notices\";s:35:\"\0WPML_Notice\0restricted_to_user_ids\";a:0:{}s:20:\"\0WPML_Notice\0actions\";a:1:{i:0;O:18:\"WPML_Notice_Action\":9:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:0;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:0;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:7:\"Dismiss\";s:23:\"\0WPML_Notice_Action\0url\";s:1:\"#\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";s:26:\"taxonomy-term-help-notices\";s:31:\"\0WPML_Notice_Action\0js_callback\";s:40:\"wpml_dismiss_taxonomy_translation_notice\";s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:1;s:31:\"\0WPML_Notice_Action\0link_target\";N;}}s:28:\"\0WPML_Notice\0css_class_types\";a:1:{i:0;s:4:\"info\";}s:24:\"\0WPML_Notice\0css_classes\";a:0:{}s:24:\"\0WPML_Notice\0dismissible\";b:0;s:31:\"\0WPML_Notice\0exclude_from_pages\";a:0:{}s:21:\"\0WPML_Notice\0hideable\";b:0;s:24:\"\0WPML_Notice\0collapsable\";b:0;s:30:\"\0WPML_Notice\0restrict_to_pages\";a:0:{}s:38:\"\0WPML_Notice\0restrict_to_page_prefixes\";a:0:{}s:35:\"\0WPML_Notice\0restrict_to_screen_ids\";a:0:{}s:34:\"\0WPML_Notice\0hide_if_notice_exists\";N;s:43:\"\0WPML_Notice\0dismissible_for_different_text\";b:1;s:31:\"\0WPML_Notice\0default_group_name\";s:7:\"default\";s:25:\"\0WPML_Notice\0capabilities\";a:0:{}s:26:\"\0WPML_Notice\0dismiss_reset\";b:0;s:18:\"\0WPML_Notice\0flash\";b:0;s:25:\"\0WPML_Notice\0nonce_action\";N;s:22:\"\0WPML_Notice\0text_only\";b:0;}s:8:\"category\";O:11:\"WPML_Notice\":24:{s:30:\"\0WPML_Notice\0display_callbacks\";a:1:{i:0;a:2:{i:0;O:37:\"WPML_Taxonomy_Translation_Help_Notice\":2:{s:57:\"\0WPML_Taxonomy_Translation_Help_Notice\0wpml_admin_notices\";O:12:\"WPML_Notices\":6:{s:27:\"\0WPML_Notices\0notice_render\";O:18:\"WPML_Notice_Render\":3:{s:38:\"\0WPML_Notice_Render\0dismiss_html_added\";b:0;s:35:\"\0WPML_Notice_Render\0hide_html_added\";b:0;s:39:\"\0WPML_Notice_Render\0collapse_html_added\";b:0;}s:21:\"\0WPML_Notices\0notices\";a:1:{s:26:\"taxonomy-term-help-notices\";N;}s:31:\"\0WPML_Notices\0notices_to_remove\";a:1:{s:12:\"requirements\";a:0:{}}s:23:\"\0WPML_Notices\0dismissed\";a:0:{}s:28:\"\0WPML_Notices\0user_dismissed\";a:0:{}s:34:\"\0WPML_Notices\0original_notices_md5\";s:32:\"6234fbbebe4298eece45ef9cc4a493be\";}s:45:\"\0WPML_Taxonomy_Translation_Help_Notice\0notice\";r:55;}i:1;s:26:\"should_display_help_notice\";}}s:15:\"\0WPML_Notice\0id\";s:8:\"category\";s:17:\"\0WPML_Notice\0text\";s:229:\"Translating Categories? Use the <a href=\"https://milo.sgsmedia.dk/wp/wp-admin/admin.php?page=sitepress-multilingual-cms/menu/taxonomy-translation.php&#038;taxonomy=category\"> Category translation</a> table for easier translation.\";s:27:\"\0WPML_Notice\0collapsed_text\";N;s:18:\"\0WPML_Notice\0group\";s:26:\"taxonomy-term-help-notices\";s:35:\"\0WPML_Notice\0restricted_to_user_ids\";a:0:{}s:20:\"\0WPML_Notice\0actions\";a:1:{i:0;O:18:\"WPML_Notice_Action\":9:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:0;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:0;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:7:\"Dismiss\";s:23:\"\0WPML_Notice_Action\0url\";s:1:\"#\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";s:26:\"taxonomy-term-help-notices\";s:31:\"\0WPML_Notice_Action\0js_callback\";s:40:\"wpml_dismiss_taxonomy_translation_notice\";s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:1;s:31:\"\0WPML_Notice_Action\0link_target\";N;}}s:28:\"\0WPML_Notice\0css_class_types\";a:1:{i:0;s:4:\"info\";}s:24:\"\0WPML_Notice\0css_classes\";a:0:{}s:24:\"\0WPML_Notice\0dismissible\";b:0;s:31:\"\0WPML_Notice\0exclude_from_pages\";a:0:{}s:21:\"\0WPML_Notice\0hideable\";b:0;s:24:\"\0WPML_Notice\0collapsable\";b:0;s:30:\"\0WPML_Notice\0restrict_to_pages\";a:0:{}s:38:\"\0WPML_Notice\0restrict_to_page_prefixes\";a:0:{}s:35:\"\0WPML_Notice\0restrict_to_screen_ids\";a:0:{}s:34:\"\0WPML_Notice\0hide_if_notice_exists\";N;s:43:\"\0WPML_Notice\0dismissible_for_different_text\";b:1;s:31:\"\0WPML_Notice\0default_group_name\";s:7:\"default\";s:25:\"\0WPML_Notice\0capabilities\";a:0:{}s:26:\"\0WPML_Notice\0dismiss_reset\";b:0;s:18:\"\0WPML_Notice\0flash\";b:0;s:25:\"\0WPML_Notice\0nonce_action\";N;s:22:\"\0WPML_Notice\0text_only\";b:0;}}}","no"),
("3824","category_children","a:0:{}","yes"),
("3866","_icl_cache","a:2:{s:25:\"language_name_cache_class\";a:77:{s:21:\"language_details_sqen\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:21:\"language_details_aren\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:21:\"language_details_hyen\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:21:\"language_details_azen\";a:10:{s:4:\"code\";s:2:\"az\";s:2:\"id\";s:2:\"65\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:11:\"Azərbaycan\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"az\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"az\";s:12:\"display_name\";s:11:\"Azerbaijani\";}s:21:\"language_details_euen\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:21:\"language_details_bnen\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:24:\"বাংলাদেশ\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:21:\"language_details_bsen\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:21:\"language_details_bgen\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:21:\"language_details_caen\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:26:\"language_details_zh-hansen\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:26:\"language_details_zh-hanten\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:21:\"language_details_hren\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:21:\"language_details_csen\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:21:\"language_details_daen\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:21:\"language_details_nlen\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:21:\"language_details_enen\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:21:\"language_details_eoen\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:21:\"language_details_eten\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:21:\"language_details_fien\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:21:\"language_details_fren\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:21:\"language_details_glen\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:21:\"language_details_deen\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:21:\"language_details_elen\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:21:\"language_details_heen\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:21:\"language_details_hien\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:21:\"language_details_huen\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:21:\"language_details_isen\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:21:\"language_details_iden\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:21:\"language_details_gaen\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:21:\"language_details_iten\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:21:\"language_details_jaen\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:21:\"language_details_koen\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:21:\"language_details_kuen\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:21:\"language_details_lven\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:21:\"language_details_lten\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:9:\"Lietuvių\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:21:\"language_details_mken\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:21:\"language_details_msen\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:21:\"language_details_mten\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:21:\"language_details_mnen\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:21:\"language_details_neen\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:21:\"language_details_noen\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:21:\"language_details_faen\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:21:\"language_details_plen\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:24:\"language_details_pt-bren\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:24:\"language_details_pt-pten\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:21:\"language_details_paen\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pa_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:21:\"language_details_quen\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:21:\"language_details_roen\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:21:\"language_details_ruen\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:21:\"language_details_sren\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:21:\"language_details_sken\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:21:\"language_details_slen\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:21:\"language_details_soen\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:21:\"language_details_esen\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:21:\"language_details_sven\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:21:\"language_details_taen\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:21:\"language_details_then\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:21:\"language_details_tren\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:21:\"language_details_uken\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:21:\"language_details_uren\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ur\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:21:\"language_details_uzen\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:21:\"language_details_vien\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:21:\"language_details_cyen\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:21:\"language_details_yien\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:21:\"language_details_zuen\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}s:29:\"all_language_en__english_name\";a:65:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"az\";a:10:{s:4:\"code\";s:2:\"az\";s:2:\"id\";s:2:\"65\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:11:\"Azərbaycan\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"az\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"az\";s:12:\"display_name\";s:11:\"Azerbaijani\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:24:\"বাংলাদেশ\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:9:\"Lietuvių\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pa_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ur\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}s:28:\"in_language_en__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}s:21:\"language_details_dada\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Dansk\";}s:21:\"language_details_enda\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:28:\"in_language_da__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Dansk\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}s:4:\"dada\";s:5:\"Dansk\";s:4:\"enen\";s:7:\"English\";s:4:\"enda\";s:7:\"English\";s:4:\"daen\";s:6:\"Danish\";s:22:\"language_details_daall\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:22:\"language_details_enall\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:29:\"in_language_all__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}}s:17:\"flags_cache_class\";a:2:{s:2:\"da\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"da.png\";s:13:\"from_template\";s:1:\"0\";}s:2:\"en\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"en.png\";s:13:\"from_template\";s:1:\"0\";}}}","no"),
("4324","aDBc_settings","a:5:{s:9:\"left_menu\";s:1:\"1\";s:16:\"menu_under_tools\";s:1:\"1\";s:14:\"plugin_version\";s:5:\"3.0.3\";s:12:\"installed_on\";s:10:\"2021/04/18\";s:9:\"keep_last\";a:1:{s:8:\"revision\";i:0;}}","no"),
("4350","wpml_language_switcher_template_objects","a:6:{s:20:\"wpml-legacy-dropdown\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:124:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:8:\"Dropdown\";s:4:\"slug\";s:20:\"wpml-legacy-dropdown\";s:8:\"base_uri\";s:113:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/\";s:3:\"css\";a:1:{i:1;s:126:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/style.min.css\";}s:2:\"js\";a:1:{i:1;s:126:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/script.min.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:124:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:26:\"wpml-legacy-dropdown-click\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:130:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:14:\"Dropdown click\";s:4:\"slug\";s:26:\"wpml-legacy-dropdown-click\";s:8:\"base_uri\";s:119:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/\";s:3:\"css\";a:1:{i:1;s:132:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/style.min.css\";}s:2:\"js\";a:1:{i:1;s:132:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/script.min.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:130:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:27:\"wpml-legacy-horizontal-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:131:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:15:\"Horizontal List\";s:4:\"slug\";s:27:\"wpml-legacy-horizontal-list\";s:8:\"base_uri\";s:120:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/\";s:3:\"css\";a:1:{i:1;s:133:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:131:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:25:\"wpml-legacy-vertical-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:129:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:13:\"Vertical List\";s:4:\"slug\";s:25:\"wpml-legacy-vertical-list\";s:8:\"base_uri\";s:118:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/\";s:3:\"css\";a:1:{i:1;s:131:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:129:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:29:\"wpml-legacy-post-translations\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:133:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:17:\"Post translations\";s:4:\"slug\";s:29:\"wpml-legacy-post-translations\";s:8:\"base_uri\";s:122:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/\";s:3:\"css\";a:1:{i:1;s:135:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:17:\"post_translations\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:133:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:14:\"wpml-menu-item\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:118:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:9:\"Menu Item\";s:4:\"slug\";s:14:\"wpml-menu-item\";s:8:\"base_uri\";s:107:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/\";s:3:\"css\";a:1:{i:1;s:120:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:5:\"menus\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:118:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}}","yes"),
("4427","wpml_wp_updated_mo_files","a:3:{s:4:\"core\";a:1:{s:7:\"default\";i:1618771080;}s:6:\"plugin\";a:4:{s:34:\"advanced-custom-fields-table-field\";i:1618771080;s:7:\"akismet\";i:1618771080;s:11:\"hello-dolly\";i:1618771080;s:14:\"duplicate-post\";i:1618771080;}s:5:\"theme\";a:2:{s:12:\"twentytwenty\";i:1618771080;s:15:\"twentytwentyone\";i:1618771080;}}","no"),
("4463","duplicator_pro_exe_safe_mode","0","yes"),
("4466","duplicator_pro_migration_data","{\n    \"archivePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/20210418_milo_571_2847e58e825cacda1618_20210418184128_archive.zip\",\n    \"packageHash\": \"2847e58-18184128\",\n    \"installerPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/installer(5).php\",\n    \"installerBootLog\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer-bootlog__c497ba3-18184128.txt\",\n    \"installerLog\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\\/dup-installer-log__c497ba3-18184128.txt\",\n    \"dupInstallerPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\\/original_files_2847e58-18184128\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"restoreBackupMode\": false\n}","no"),
("4625","_transient_health-check-site-status-result","{\"good\":\"12\",\"recommended\":\"7\",\"critical\":\"1\"}","yes"),
("4655","_site_transient_timeout_browser_d4e252f9cf1badbf8d0f65373387d123","1619511937","no"),
("4656","_site_transient_browser_d4e252f9cf1badbf8d0f65373387d123","a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:6:\"13.1.2\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("4677","_transient_wpml_admin_text_import:parse_config:66823ee484531a2e6a0d0f031798dc23","0e76ff20c1fe93878b4cf152f317989a","yes"),
("4767","duplicator_pro_package_active","{\n    \"Created\": \"2021-04-27 07:08:18\",\n    \"Version\": \"4.0.2\",\n    \"VersionWP\": \"5.7.1\",\n    \"VersionDB\": \"10.5.9\",\n    \"VersionPHP\": \"8.0.3\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": null,\n    \"Name\": \"20210427_milo\",\n    \"Hash\": \"bb153f4003903e991589_20210427070818\",\n    \"NameHash\": \"20210427_milo_bb153f4003903e991589_20210427070818\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210427_milo_bb153f4003903e991589_20210427070818_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": null,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.opcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.tmb\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.htaccess\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.user.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/php.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/web.config\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\",\n        \"Size\": 308366105,\n        \"Dirs\": null,\n        \"DirCount\": 2093,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 18325,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": null,\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"milo_web_db\",\n            \"tablesBaseCount\": 43,\n            \"tablesFinalCount\": 43,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 66911,\n            \"tablesSizeOnDisk\": 10963478,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 7492\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 9840\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 28240\n                },\n                \"wp_icl_content_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_core_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_flags\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 4388\n                },\n                \"wp_icl_languages\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 11252\n                },\n                \"wp_icl_languages_translations\": {\n                    \"inaccurateRows\": 4225,\n                    \"insertedRows\": false,\n                    \"size\": 228012\n                },\n                \"wp_icl_locale_map\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 2088\n                },\n                \"wp_icl_message_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"inaccurateRows\": 82,\n                    \"insertedRows\": false,\n                    \"size\": 19492\n                },\n                \"wp_icl_node\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_reminders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_batches\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2152\n                },\n                \"wp_icl_string_pages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_positions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_translations\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 4224\n                },\n                \"wp_icl_string_urls\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_icl_strings\": {\n                    \"inaccurateRows\": 152,\n                    \"insertedRows\": false,\n                    \"size\": 64168\n                },\n                \"wp_icl_translate\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translate_job\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translation_batches\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2112\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_icl_translation_status\": {\n                    \"inaccurateRows\": 168,\n                    \"insertedRows\": false,\n                    \"size\": 15264\n                },\n                \"wp_icl_translations\": {\n                    \"inaccurateRows\": 615,\n                    \"insertedRows\": false,\n                    \"size\": 98668\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 401,\n                    \"insertedRows\": false,\n                    \"size\": 1435696\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 59631,\n                    \"insertedRows\": false,\n                    \"size\": 8477000\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 862,\n                    \"insertedRows\": false,\n                    \"size\": 416812\n                },\n                \"wp_realmedialibrary\": {\n                    \"inaccurateRows\": 61,\n                    \"insertedRows\": false,\n                    \"size\": 6364\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"inaccurateRows\": 61,\n                    \"insertedRows\": false,\n                    \"size\": 2658\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"inaccurateRows\": 338,\n                    \"insertedRows\": false,\n                    \"size\": 25200\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": false,\n                    \"size\": 6632\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 4804\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 10448\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 13968\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": false,\n                    \"size\": 16064\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 8456\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.5.9\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": null,\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": null,\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": null\n    },\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": null,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": -1,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}","yes"),
("5434","nav_menu_children_en","a:0:{}","yes"),
("5435","nav_menu_children_da","a:0:{}","yes"),
("5436","nav_menu_children_all","a:0:{}","yes"),
("5797","_site_transient_timeout_browser_1509ab70d6a2d319ec457fb7f46a8933","1619765468","no"),
("5798","_site_transient_browser_1509ab70d6a2d319ec457fb7f46a8933","a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"88.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("6739","_transient_timeout_acf_plugin_updates","1619590679","no"),
("6740","_transient_acf_plugin_updates","a:4:{s:7:\"plugins\";a:0:{}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.9.5\";}}","no"),
("7025","_site_transient_timeout_php_check_75809dde56e3fe2c2fb740f1b55807ac","1620045391","no"),
("7026","_site_transient_php_check_75809dde56e3fe2c2fb740f1b55807ac","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no"),
("7659","_site_transient_timeout_available_translations","1619461102","no"),
("7660","_site_transient_available_translations","a:126:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-02-23 11:41:38\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-21 20:16:59\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.16\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.16/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-25 05:49:11\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.17/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"5.4.5\";s:7:\"updated\";s:19:\"2020-07-01 06:36:01\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.4.5/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"5.4.5\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.4.5/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-25 07:27:37\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:10:23\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-19 06:51:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 10:32:41\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-20 06:42:13\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:43:41\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.7.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-14 20:06:52\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/5.7.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-14 20:06:23\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-10 19:15:18\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:41:08\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 13:33:04\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.7.1/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-20 12:15:27\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 07:31:22\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:12:40\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 07:22:30\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:12:51\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 04:12:28\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-18 09:35:35\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 02:05:34\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-10 15:04:44\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-03 15:32:45\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-11 17:28:23\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-24 16:46:30\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.6.3\";s:7:\"updated\";s:19:\"2020-12-11 02:12:59\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.6.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:5:\"5.4.5\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.4.5/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.10\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.10/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 02:05:15\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-16 02:17:21\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-16 13:07:32\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-18 11:35:03\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-02 13:52:39\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-01 11:39:36\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 05:08:24\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-24 19:13:29\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-25 10:15:04\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.16\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.16/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 18:17:43\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.17/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.24\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.24/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-16 12:47:15\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.4.5\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-14 11:07:41\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-15 13:34:18\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.7.1/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-23 17:06:16\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-24 02:11:27\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.17/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-25 18:51:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-20 23:32:04\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.17/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nutugne\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-29 10:00:46\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-11 22:04:53\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.7.1/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.17/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.10\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.10/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2020-09-30 14:08:59\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.17/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರೆಸಿ\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-21 08:25:29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-02-28 14:29:24\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.7.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ຕໍ່\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-03-23 12:35:40\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-16 19:35:51\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.7.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"5.4.5\";s:7:\"updated\";s:19:\"2020-07-01 09:16:57\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.4.5/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.17\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.17/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"