<?php
	$theme_header = "";
	$theme_header_custom_field = get_field( 'header_theme' );

	if( is_404() == 1) :

		if ( have_rows( 'theme_settings_group', 'option' ) ) :
			while ( have_rows( 'theme_settings_group', 'option' ) ) : the_row();
				if ( have_rows( 'theme_404' ) ) :
					while ( have_rows( 'theme_404' ) ) : the_row();
						$theme_header_custom_field = get_sub_field( 'header_theme' );
					endwhile;
				endif;
			endwhile;
		endif;
	endif;
/*
		if ( have_rows( 'theme_404', 'option' ) ) :
			while ( have_rows( 'theme_404', 'option' ) ) : the_row();
				$theme_header_custom_field = get_sub_field( 'header_theme' );
			endwhile;
		endif;
	endif;
*/
	if($theme_header_custom_field == "dark") :
		$theme_header = " light-background";
	endif;

   $custom_logo_id = get_theme_mod( 'custom_logo' );
   $logo_image_obj = wp_get_attachment_image( $custom_logo_id, 'full');
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="<?php echo $theme_header; ?>">
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
		<?php //if ( is_singular() ) wp_enqueue_script( "comment-reply" ); ?>
		
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>

		<?php
			global $arr_country_assets;
			$announcement_bar_items = $arr_country_assets[0]['announcement_bar'];
			$announcement_bar_total_items = count($arr_country_assets[0]['announcement_bar']);
		?>
		<?php if($announcement_bar_total_items > 0) : ?>
			<div class="announcement-bar">
			    <div class="container">
			        <div class="grid-col grid-col-<?php echo $announcement_bar_total_items; ?>">
						<?php foreach ($announcement_bar_items as $key => $value) : ?>
			            	<div class="announcement-bar-item"><?php echo $value; ?></div>
						<?php endforeach; ?>
			        </div>
			    </div>
			</div>
		<?php endif; ?>

		<button class="close-x nav-main-toggle hide-mobile-navigation"></button>
		<header class="header">
		    <div class="container">
		        <a href="javascript:void(0)" class="nav-main-toggle show-mobile-navigation">
		            <i class="icon">
		                <svg><use xlink:href="#icon-menu"/></svg>
		            </i>
		        </a>

		        <nav class="nav-main">
					<?php 
						// Header Menu
						wp_nav_menu(
								array(
								'theme_location'  => 'header-menu',
								'container'       => false,
								'container_id'    => false,
								'container_class' => false,
								'menu_id'         => 'header-menu-nav',
								'menu_class'      => 'header-menu-nav',
								'walker' => new Header_Menu_Nav_Walker()
							)
						);
					?>
				</nav>

		        <div class="header-logo">
		            <a href="<?php echo get_home_url(); ?>">
		                <?php echo $logo_image_obj; ?>
		            </a>
		        </div>
		        <ul class="header-social-links list-icon-links">
					<?php get_template_part('parts/section-social_icons'); ?>
		        </ul>

		        <ul class="header-cart-links list-icon-links">
		             <li class="header-globe">
		                <a href="javascript:void(0)" class="js-toggle-locations">
		                    <i class="icon">
		                        <svg>
									<svg id="icon-globe" viewBox="0 0 365.1 365.1">
							            <path d="M182.6 0C81.7 0 0 81.7 0 182.6c0 100.8 81.7 182.6 182.6 182.6 100.8 0 182.6-81.7 182.6-182.6C365.1 81.7 283.4 0 182.6 0m74.2 255.3c-1.1 2.8-2.4 5.4-3.7 8.1-20.2-4.5-40.8-7-61.5-7.7v-73.1h78.1c.3 36.9-9.9 65.2-12.9 72.7m-148.7 0c-3-7.5-13.1-35.8-13-72.7h78.3v73.1c-20.8.5-41.5 3-61.8 7.4-1.2-2.6-2.5-5.2-3.5-7.8m-28.9-89.4H17.5c3.2-31.9 15.6-61 34.3-85 14.8 6.8 30.1 12.5 45.6 16.8-2.1 4.4-4.1 8.8-5.8 13.3-7.4 19-11 37.6-12.4 54.9m27.9-48.9a171 171 0 0 1 6.7-15.2c19.6 4.4 39.6 6.8 59.6 7.4v56.7H95.8c1.4-15.5 4.8-32 11.3-48.9m84.6-83.2c20 13.7 36.9 31.1 49.8 51.3-16.4 3.4-33.1 5.3-49.8 5.9V33.8zm-18.3-.1V91c-16.8-.5-33.5-2.5-50.1-5.8 13-20.3 30-37.8 50.1-51.5m0 240.2v62.6c-21.6-14.8-39.7-34.1-53-56.5 17.5-3.6 35.2-5.6 53-6.1m18.3.1c17.7.6 35.3 2.7 52.7 6.3-13.2 22.2-31.2 41.3-52.7 56.1V274zm0-108.1v-56.7c20-.6 39.8-3 59.4-7.4 2.5 5 4.7 10 6.7 15.2 6.5 16.9 9.9 33.4 11.3 48.9h-77.4zm81.7-54.9c-1.8-4.6-3.8-9-5.9-13.4 15.6-4.4 30.9-10.1 45.7-16.9 18.8 24 31.2 53.2 34.4 85.2h-61.8c-1.5-17.3-5.1-35.9-12.4-54.9m27.2-44.8c-13.7 6.1-27.7 11-42 14.8-15.3-25.4-36.2-47.2-61.3-63.6C237.6 21 273.8 39 300.6 66.2M167.5 17.4c-25.1 16.4-46.1 38.2-61.3 63.7C92 77.3 78 72.4 64.3 66.4c26.8-27.3 63-45.3 103.2-49m-89 165.2c-.1 40.1 10.9 70.8 14.1 78.9.8 1.9 1.7 3.8 2.6 5.7-15.1 4.2-29.9 9.4-44.3 15.8-21.3-27.9-34.2-62.7-34.2-100.4h61.8zm-15.2 115c13.1-5.6 26.5-10.1 40.2-13.7 13.7 24.6 32.6 45.9 55.4 62.6-37.3-5.3-70.6-23-95.6-48.9m142.6 49c22.7-16.6 41.5-37.9 55.2-62.3 13.6 3.7 27 8.3 40.1 13.9-24.9 25.6-58.1 43.1-95.3 48.4m107.9-63c-14.4-6.4-29.2-11.8-44.3-16 .9-2 1.9-4 2.7-6 3.3-8.1 14.3-38.8 14.1-78.9h62c.1 37.9-12.9 72.9-34.5 100.9"></path>
							        </svg>
		                        </svg>
		                    </i>
		                </a>
		            </li>
		            <li class="header-shop-btn">
		                <div class="button-wrap">
							<?php $country_label_shop_milo_url = get_sub_field( 'country_label_shop_milo_url' ); ?>
							<?php if ( $_SESSION['country_assets'][0]['label_shop_milo_url'] ) : ?>
			                    <a href="<?php echo esc_url( $_SESSION['country_assets'][0]['label_shop_milo_url']['url'] ); ?>" target="<?php echo esc_attr( $_SESSION['country_assets'][0]['label_shop_milo_url']['target'] ); ?>" class="button button--hyperion button-header">
			                        <span>
			                            <span><?php echo $_SESSION['country_assets'][0]['label_shop_milo']; ?></span>
			                        </span>
			                    </a>
		                    <?php endif; ?>
		                </div>
		            </li>
		        </ul>
		        <ul class="header-cart-links list-icon-links tablet-only">
		            <li class="header-globe">
		                <a href="javascript:void(0)" class="js-toggle-locations">
		                    <i class="icon">
		                        <svg>
									<svg id="icon-globe" viewBox="0 0 365.1 365.1">
							            <path d="M182.6 0C81.7 0 0 81.7 0 182.6c0 100.8 81.7 182.6 182.6 182.6 100.8 0 182.6-81.7 182.6-182.6C365.1 81.7 283.4 0 182.6 0m74.2 255.3c-1.1 2.8-2.4 5.4-3.7 8.1-20.2-4.5-40.8-7-61.5-7.7v-73.1h78.1c.3 36.9-9.9 65.2-12.9 72.7m-148.7 0c-3-7.5-13.1-35.8-13-72.7h78.3v73.1c-20.8.5-41.5 3-61.8 7.4-1.2-2.6-2.5-5.2-3.5-7.8m-28.9-89.4H17.5c3.2-31.9 15.6-61 34.3-85 14.8 6.8 30.1 12.5 45.6 16.8-2.1 4.4-4.1 8.8-5.8 13.3-7.4 19-11 37.6-12.4 54.9m27.9-48.9a171 171 0 0 1 6.7-15.2c19.6 4.4 39.6 6.8 59.6 7.4v56.7H95.8c1.4-15.5 4.8-32 11.3-48.9m84.6-83.2c20 13.7 36.9 31.1 49.8 51.3-16.4 3.4-33.1 5.3-49.8 5.9V33.8zm-18.3-.1V91c-16.8-.5-33.5-2.5-50.1-5.8 13-20.3 30-37.8 50.1-51.5m0 240.2v62.6c-21.6-14.8-39.7-34.1-53-56.5 17.5-3.6 35.2-5.6 53-6.1m18.3.1c17.7.6 35.3 2.7 52.7 6.3-13.2 22.2-31.2 41.3-52.7 56.1V274zm0-108.1v-56.7c20-.6 39.8-3 59.4-7.4 2.5 5 4.7 10 6.7 15.2 6.5 16.9 9.9 33.4 11.3 48.9h-77.4zm81.7-54.9c-1.8-4.6-3.8-9-5.9-13.4 15.6-4.4 30.9-10.1 45.7-16.9 18.8 24 31.2 53.2 34.4 85.2h-61.8c-1.5-17.3-5.1-35.9-12.4-54.9m27.2-44.8c-13.7 6.1-27.7 11-42 14.8-15.3-25.4-36.2-47.2-61.3-63.6C237.6 21 273.8 39 300.6 66.2M167.5 17.4c-25.1 16.4-46.1 38.2-61.3 63.7C92 77.3 78 72.4 64.3 66.4c26.8-27.3 63-45.3 103.2-49m-89 165.2c-.1 40.1 10.9 70.8 14.1 78.9.8 1.9 1.7 3.8 2.6 5.7-15.1 4.2-29.9 9.4-44.3 15.8-21.3-27.9-34.2-62.7-34.2-100.4h61.8zm-15.2 115c13.1-5.6 26.5-10.1 40.2-13.7 13.7 24.6 32.6 45.9 55.4 62.6-37.3-5.3-70.6-23-95.6-48.9m142.6 49c22.7-16.6 41.5-37.9 55.2-62.3 13.6 3.7 27 8.3 40.1 13.9-24.9 25.6-58.1 43.1-95.3 48.4m107.9-63c-14.4-6.4-29.2-11.8-44.3-16 .9-2 1.9-4 2.7-6 3.3-8.1 14.3-38.8 14.1-78.9h62c.1 37.9-12.9 72.9-34.5 100.9"></path>
							        </svg>
		                        </svg>
		                    </i>
		                </a>
		            </li>
		        </ul>
		    </div>
		</header>