<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_60635ce10dc0e',
	'title' => 'Country',
	'fields' => array(
		array(
			'key' => 'field_606e0c90e3a55',
			'label' => 'Country flag',
			'name' => 'country_flag',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_60635dec5273b',
			'label' => 'Disable prices',
			'name' => 'country_disable_prices',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_60635d7a5273a',
			'label' => 'Disable country from menu',
			'name' => 'country_disable_from_menu',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_60635cf352737',
			'label' => 'Country shortcode',
			'name' => 'country_shortcode',
			'type' => 'text',
			'instructions' => 'This shortcode needs to match the corresponding country code in WPML (except for the global site)',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_60635d4752739',
			'label' => 'Currency symbol',
			'name' => 'country_currency_symbol',
			'type' => 'text',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_60635f05efb59',
			'label' => 'Currency code',
			'name' => 'country_currency_code',
			'type' => 'text',
			'instructions' => '(USD, DKK, NOK etc.)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_60635d1252738',
			'label' => 'Product list - Price',
			'name' => 'country_product_list_price',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_6069b1fa4ec82',
			'label' => 'Labels',
			'name' => 'country_labels',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_606ec78d10138',
					'label' => 'Introduction',
					'name' => 'country_introduction',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
				array(
					'key' => 'field_606ec7bb10139',
					'label' => 'Location not listed?',
					'name' => 'country_location_not_listed',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
				array(
					'key' => 'field_60637499e8da6',
					'label' => 'Product list price',
					'name' => 'country_label_product_list',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'List Price',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_606444766cc8d',
					'label' => 'Milo Shop',
					'name' => 'country_label_shop_milo',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Shop Milo',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_60783e22f7310',
					'label' => 'Milo Shop - URL',
					'name' => 'country_label_shop_milo_url',
					'type' => 'link',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
				),
				array(
					'key' => 'field_60783d635c591',
					'label' => 'Find reseller',
					'name' => 'country_label_find_reseller',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Find reseller',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6069b21003f39',
					'label' => 'Milo Stories',
					'name' => 'country_label_stories',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Milo Stories',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6069b24103f3a',
					'label' => 'Explore',
					'name' => 'country_label_explore',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Explore',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6069b2c0e9313',
					'label' => 'Copyright',
					'name' => 'country_label_copyright',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'All rights reserved.',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_606afedea87b0',
					'label' => 'Share Milo with your outdoor buddies',
					'name' => 'country_share_milo',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606aff5109f1c',
							'label' => 'Text',
							'name' => 'country_share_milo_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 0,
						),
						array(
							'key' => 'field_606ecf5e52491',
							'label' => 'Use defined Facebook url?',
							'name' => 'country_share_use_facebook_url',
							'type' => 'true_false',
							'instructions' => 'Checking this will use the Facebook url defined instead of the dynamic Facebook Share functionality.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_606aff6509f1d',
							'label' => 'Facebook url',
							'name' => 'country_share_milo_facebook_url',
							'type' => 'url',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
						),
						array(
							'key' => 'field_606aff8709f1e',
							'label' => 'Contact',
							'name' => 'country_share_milo_contact',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_606cae50c0c42',
			'label' => 'Dealor locator - disable',
			'name' => 'country_dealor_locator_disable',
			'type' => 'true_false',
			'instructions' => 'An option to toggle (hide) visibility of the added dealors.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_606c754a78933',
			'label' => 'Dealor locator - Text',
			'name' => 'country_dealor_locator_text_intro',
			'type' => 'wysiwyg',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_6069c77cc0779',
			'label' => 'Dealor locator',
			'name' => 'country_dealor_locator',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_6069c792d91f1',
					'label' => 'Dealor name',
					'name' => 'country_dealor_name',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6069c7a3d91f2',
					'label' => 'Dealor logo',
					'name' => 'country_dealor_logo',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_6069c7ccd91f3',
					'label' => 'Dealor url',
					'name' => 'country_dealor_url',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
			),
		),
		array(
			'key' => 'field_60657dd51dbd8',
			'label' => 'Announcement bar',
			'name' => 'country_announcement_bar',
			'type' => 'repeater',
			'instructions' => 'Recommended max. items are 3.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_6065896c81ddc',
					'label' => 'Announcement bar item',
					'name' => 'country_announcement_bar_item',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'country',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'the_content',
		1 => 'excerpt',
		2 => 'discussion',
		3 => 'comments',
		4 => 'author',
		5 => 'format',
		6 => 'page_attributes',
		7 => 'featured_image',
		8 => 'categories',
		9 => 'tags',
		10 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606eb7ae58fc4',
	'title' => 'Country Region - settings',
	'fields' => array(
		array(
			'key' => 'field_606eb91cd57de',
			'label' => 'Disable region?',
			'name' => 'region_disable',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'region',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606196ead9c73',
	'title' => 'Flexible items',
	'fields' => array(
		array(
			'key' => 'field_606196ff604e4',
			'label' => 'Flex section blocks',
			'name' => 'flex_items',
			'type' => 'flexible_content',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'layouts' => array(
				'layout_606afaba8d0fc' => array(
					'key' => 'layout_606afaba8d0fc',
					'name' => 'app',
					'label' => 'App',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606afac98d0fd',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606afb698d101',
							'label' => 'Clone: Background type',
							'name' => 'cloned_background_type',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646b53b3b9a',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606afb148d0ff',
							'label' => 'Content',
							'name' => 'app_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606afb038d0fe',
							'label' => 'Clone: Buttons',
							'name' => 'cloned_buttons',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646a6e66ee0',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606afb358d100',
							'label' => 'Image',
							'name' => 'app_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_6061eda1228b4' => array(
					'key' => 'layout_6061eda1228b4',
					'name' => 'content_regular',
					'label' => 'Content - Regular',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606c5334a719a',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_6061edb4228b5',
							'label' => 'Content',
							'name' => 'content_regular_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_6086c35a9b8bb',
							'label' => 'Clone: Buttons',
							'name' => 'cloned_buttons',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646a6e66ee0',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
							'wpml_cf_preferences' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_6075950000551' => array(
					'key' => 'layout_6075950000551',
					'name' => 'content_regular_2col',
					'label' => 'Content - Regular - 2 columns',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6075950000552',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_6075950000553',
							'label' => 'Content - Column 1',
							'name' => 'content_regular_2col_col1_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_6075954200554',
							'label' => 'Content - Column 2',
							'name' => 'content_regular_2col_col2_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606b24166cc8f' => array(
					'key' => 'layout_606b24166cc8f',
					'name' => 'content_2col',
					'label' => 'Content - 2 columns images',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606b26ac62306',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606b2c5d9c78e',
							'label' => 'Content images to the right?',
							'name' => 'content_gridcol2_images_to_the_right',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '34',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_606b362cd931c',
							'label' => 'No image max-width?',
							'name' => 'content_gridcol2_no_image_max-width',
							'type' => 'true_false',
							'instructions' => 'Pr. default max-width is applied to the image. Check here to disable.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_606d5b186ddf4',
							'label' => 'No image max-height?',
							'name' => 'content_gridcol2_no_image_max-height',
							'type' => 'true_false',
							'instructions' => 'Pr. default max-height is applied to the image. Check here to disable.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_606b3ae5601c3',
							'label' => 'Center content?',
							'name' => 'content_gridcol2_center_content',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_606b246a6cc90',
							'label' => 'Content',
							'name' => 'content_gridcol2',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => '',
							'sub_fields' => array(
								array(
									'key' => 'field_606b2550a2ccf',
									'label' => 'Image',
									'name' => 'content_gridcol2_row_image_gallery',
									'type' => 'gallery',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'thumbnail',
									'insert' => 'append',
									'library' => 'all',
									'min' => '',
									'max' => '',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_606b25c5a2cd0',
									'label' => 'Content',
									'name' => 'content_gridcol2_row_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_606b2996efab6',
									'label' => 'Clone: Buttons',
									'name' => 'cloned_buttons',
									'type' => 'clone',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'clone' => array(
										0 => 'field_60646a6e66ee0',
									),
									'display' => 'seamless',
									'layout' => 'block',
									'prefix_label' => 0,
									'prefix_name' => 0,
								),
								array(
									'key' => 'field_606b266662305',
									'label' => 'Clone: Overwrite List Price',
									'name' => 'cloned_overwrite_list_price',
									'type' => 'clone',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'clone' => array(
										0 => 'field_60646bbc6efc6',
									),
									'display' => 'seamless',
									'layout' => 'block',
									'prefix_label' => 0,
									'prefix_name' => 0,
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606abfad55589' => array(
					'key' => 'layout_606abfad55589',
					'name' => 'section_block',
					'label' => 'Global blocks',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606accbdb3def',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606abfce5558a',
							'label' => 'Reference section block',
							'name' => 'choose_reference_section_block',
							'type' => 'post_object',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'section_blocks',
							),
							'taxonomy' => '',
							'allow_null' => 0,
							'multiple' => 0,
							'return_format' => 'object',
							'ui' => 1,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_6062d951c9dfb' => array(
					'key' => 'layout_6062d951c9dfb',
					'name' => 'gofarstayclose',
					'label' => 'Go far stay close',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6062f6d2ecf6f',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_6062d990c9e05',
							'label' => 'Image',
							'name' => 'gofarstayclose_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_6062d9adc9e06',
							'label' => 'Content',
							'name' => 'gofarstayclose_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_6062f6e0ecf70',
							'label' => 'Clone: Buttons',
							'name' => 'cloned_buttons',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'wpml_cf_preferences' => 0,
							'clone' => array(
								0 => 'field_60646a6e66ee0',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606379c3cd8b6',
							'label' => 'Clone: Overwrite List Price',
							'name' => 'cloned_overwrite_list_price',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646bbc6efc6',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_60619707ae5f4' => array(
					'key' => 'layout_60619707ae5f4',
					'name' => 'hero',
					'label' => 'Hero',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6062fbbf24a05',
							'label' => 'Clone: Background type',
							'name' => 'cloned_background_type',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646b53b3b9a',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_6061985b79832',
							'label' => 'Text',
							'name' => 'hero_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_6062e8d7d7168',
							'label' => 'Clone: Buttons',
							'name' => 'cloned_buttons',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646a6e66ee0',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606839e515720' => array(
					'key' => 'layout_606839e515720',
					'name' => 'milo_assets',
					'label' => 'Milo Assets',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606847caf6fe0',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606839fb15721',
							'label' => 'Asset reference',
							'name' => 'assets_reference',
							'type' => 'post_object',
							'instructions' => 'The actual content of all Milo product related assets are controlled from the "Milo assets" menu.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'assets',
							),
							'taxonomy' => '',
							'allow_null' => 0,
							'multiple' => 0,
							'return_format' => 'object',
							'ui' => 1,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606978c45d939' => array(
					'key' => 'layout_606978c45d939',
					'name' => 'milo_stories',
					'label' => 'Milo Stories',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606978d05d93a',
							'label' => 'Show by:',
							'name' => 'stories_show_by',
							'type' => 'radio',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'category' => 'Category',
								'single' => 'Single selection',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'category',
							'layout' => 'vertical',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_6069aec080840',
							'label' => 'Item max. limit',
							'name' => 'stories_item_limit',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_606978d05d93a',
										'operator' => '==',
										'value' => 'category',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 3,
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => 3,
							'max' => '',
							'step' => '',
						),
						array(
							'key' => 'field_606979385d93c',
							'label' => 'Select category',
							'name' => 'stories_select_category',
							'type' => 'taxonomy',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_606978d05d93a',
										'operator' => '==',
										'value' => 'category',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'taxonomy' => 'category',
							'field_type' => 'multi_select',
							'allow_null' => 0,
							'add_term' => 0,
							'save_terms' => 0,
							'load_terms' => 0,
							'return_format' => 'id',
							'multiple' => 0,
						),
						array(
							'key' => 'field_60697a67c199d',
							'label' => 'Select by single selection',
							'name' => 'stories:select_by_single_selection',
							'type' => 'relationship',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_606978d05d93a',
										'operator' => '==',
										'value' => 'single',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'post',
							),
							'taxonomy' => '',
							'filters' => array(
								0 => 'search',
								1 => 'post_type',
								2 => 'taxonomy',
							),
							'elements' => array(
								0 => 'featured_image',
							),
							'min' => '',
							'max' => '',
							'return_format' => 'object',
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606afff599341' => array(
					'key' => 'layout_606afff599341',
					'name' => 'share',
					'label' => 'Share with your buddies',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606c5e9de8ab2',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606b003099343',
							'label' => 'Background image',
							'name' => 'share_background_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606890433eb11' => array(
					'key' => 'layout_606890433eb11',
					'name' => 'statements',
					'label' => 'Statements',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6068904b3eb12',
							'label' => 'Statement reference',
							'name' => 'statement_reference',
							'type' => 'post_object',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'statement',
							),
							'taxonomy' => '',
							'allow_null' => 0,
							'multiple' => 0,
							'return_format' => 'object',
							'ui' => 1,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_6061ee18524c6' => array(
					'key' => 'layout_6061ee18524c6',
					'name' => 'steps',
					'label' => 'Steps',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6062ea8cbb0b1',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606cbd9348804',
							'label' => 'Clone: Buttons',
							'name' => 'cloned_buttons',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_60646a6e66ee0',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606cbde848805',
							'label' => 'Text',
							'name' => 'step_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_6061ee32524c7',
							'label' => 'Step items',
							'name' => 'step_items',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => '',
							'sub_fields' => array(
								array(
									'key' => 'field_6061eeccb85bc',
									'label' => 'Step icon',
									'name' => 'step_item_icon',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_6061eeddb85bd',
									'label' => 'Step Content',
									'name' => 'step_item_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_6061ef01b85be',
									'label' => 'Step Image or Video',
									'name' => 'step_item_image_video',
									'type' => 'radio',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'Image' => 'Image',
										'Video' => 'Video',
									),
									'allow_null' => 1,
									'other_choice' => 0,
									'default_value' => '',
									'layout' => 'vertical',
									'return_format' => 'value',
									'save_other_choice' => 0,
								),
								array(
									'key' => 'field_6061ef3cb85bf',
									'label' => 'Step Image',
									'name' => 'step_item_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_6061ef01b85be',
												'operator' => '==',
												'value' => 'Image',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_6061ef55b85c0',
									'label' => 'Step Video',
									'name' => 'step_item_video',
									'type' => 'file',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_6061ef01b85be',
												'operator' => '==',
												'value' => 'Video',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'library' => 'all',
									'min_size' => '',
									'max_size' => '',
									'mime_types' => '',
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_6068b07155f95' => array(
					'key' => 'layout_6068b07155f95',
					'name' => 'video',
					'label' => 'Video',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606daeb848105',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606da7460f9d6',
							'label' => 'Video properties',
							'name' => 'video_properties',
							'type' => 'radio',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'full' => 'Video full width',
								'inline' => 'Video inline',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inline',
							'layout' => 'vertical',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_6068b07a55f96',
							'label' => 'Placeholder image',
							'name' => 'video_placeholder_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_6068b0a755f97',
							'label' => 'Video embed url',
							'name' => 'video_embed_url',
							'type' => 'url',
							'instructions' => 'Supported embeds: Vimeo
Url example: https://player.vimeo.com/video/518949975',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606b2ece62301' => array(
					'key' => 'layout_606b2ece62301',
					'name' => 'video_inline_autoloop',
					'label' => 'Video - Inline - Auto loop',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606b2f0162303',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606b2ee162302',
							'label' => 'Video source',
							'name' => 'video_inline_autoloop_source',
							'type' => 'file',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_size' => '',
							'max_size' => '',
							'mime_types' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Row',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_template',
				'operator' => '==',
				'value' => 'templates/template-flexible-sections.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'the_content',
		1 => 'excerpt',
		2 => 'discussion',
		3 => 'comments',
		4 => 'slug',
		5 => 'author',
		6 => 'format',
		7 => 'featured_image',
		8 => 'categories',
		9 => 'tags',
		10 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606ae98bd2834',
	'title' => 'Global section blocks',
	'fields' => array(
		array(
			'key' => 'field_606ae997e7610',
			'label' => 'Global flex items',
			'name' => 'global_flex_items',
			'type' => 'flexible_content',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'layouts' => array(
				'layout_606ae9b3a87c3' => array(
					'key' => 'layout_606ae9b3a87c3',
					'name' => 'global_adventure_categories_block',
					'label' => 'Adventure categories',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606ae9ec145a5',
							'label' => 'Adventure categories',
							'name' => 'global_adventure_categories',
							'type' => 'group',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'block',
							'sub_fields' => array(
								array(
									'key' => 'field_606aea33145a6',
									'label' => 'Headline',
									'name' => 'global_adventure_category_block_headline',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_606aea53145a7',
									'label' => 'Item',
									'name' => 'global_adventure_category_block_item',
									'type' => 'repeater',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'wpml_cf_preferences' => 3,
									'collapsed' => '',
									'min' => 0,
									'max' => 0,
									'layout' => 'table',
									'button_label' => '',
									'sub_fields' => array(
										array(
											'key' => 'field_606aea6c09116',
											'label' => 'Title',
											'name' => 'global_category_block_title',
											'type' => 'text',
											'instructions' => '',
											'required' => 0,
											'conditional_logic' => 0,
											'wrapper' => array(
												'width' => '',
												'class' => '',
												'id' => '',
											),
											'default_value' => '',
											'placeholder' => '',
											'prepend' => '',
											'append' => '',
											'maxlength' => '',
										),
										array(
											'key' => 'field_606aea7f09117',
											'label' => 'Image',
											'name' => 'global_category_block_image',
											'type' => 'image',
											'instructions' => '',
											'required' => 0,
											'conditional_logic' => 0,
											'wrapper' => array(
												'width' => '',
												'class' => '',
												'id' => '',
											),
											'return_format' => 'array',
											'preview_size' => 'medium',
											'library' => 'all',
											'min_width' => '',
											'min_height' => '',
											'min_size' => '',
											'max_width' => '',
											'max_height' => '',
											'max_size' => '',
											'mime_types' => '',
										),
										array(
											'key' => 'field_606aea8d09118',
											'label' => 'Url',
											'name' => 'global_category_block_url',
											'type' => 'link',
											'instructions' => '',
											'required' => 0,
											'conditional_logic' => 0,
											'wrapper' => array(
												'width' => '',
												'class' => '',
												'id' => '',
											),
											'return_format' => 'array',
										),
									),
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606b701f653df' => array(
					'key' => 'layout_606b701f653df',
					'name' => 'global_comparison_table',
					'label' => 'Comparison table',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606b7023653e0',
							'label' => 'Text',
							'name' => 'global_comparison_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606b706b653e1',
							'label' => 'Table',
							'name' => 'global_comparison_table',
							'type' => 'table',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'use_header' => 0,
							'use_caption' => 2,
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606c02ec27779' => array(
					'key' => 'layout_606c02ec27779',
					'name' => 'global_faq',
					'label' => 'FAQ',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606c03192777a',
							'label' => 'Text',
							'name' => 'global_faq_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606c03272777b',
							'label' => 'FAQ item',
							'name' => 'global_faq_item',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'wpml_cf_preferences' => 3,
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => '',
							'sub_fields' => array(
								array(
									'key' => 'field_606c034a57f81',
									'label' => 'Headline',
									'name' => 'global_faq_item_headline',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_606c035957f82',
									'label' => 'Content',
									'name' => 'global_faq_item_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606af657138e6' => array(
					'key' => 'layout_606af657138e6',
					'name' => 'global_interactive_product_rotation',
					'label' => 'Interactive: Product rotation',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606af672138e7',
							'label' => 'Text',
							'name' => 'global_interactive_product_rotation_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606af6e5138e8',
							'label' => 'Rotation SVG text',
							'name' => 'global_interactive_product_rotation_SVG_text',
							'type' => 'textarea',
							'instructions' => 'A new set of SVG elements needs be saved out for each different country.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
		 viewBox="0 0 737.6 627.9" style="enable-background:new 0 0 737.6 627.9;" xml:space="preserve">
<style type="text/css">
		.st0{fill:none;stroke:#000000;stroke-width:2;stroke-miterlimit:10;}
		.st1{fill:none;stroke:#000000;stroke-width:2;stroke-miterlimit:10;stroke-dasharray:4;}
</style>

<g class="rotation-svg-item" id="rotation_x5F_mute">
		<g>
				<path d="M519.4,111.6v17.8h-1.7v-14.9l-6.5,9.3h-0.3l-6.5-9.3v14.9h-1.7v-17.8h1.5l6.9,9.9l6.9-9.9
						C518,111.6,519.4,111.6,519.4,111.6z"/>
				<path d="M535.1,129.4h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L535.1,129.4L535.1,129.4z"/>
				<path d="M542.2,118.1v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L542.2,118.1L542.2,118.1z"/>
				<path d="M548.7,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C551.1,129.7,548.7,127,548.7,123.1z M558.9,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H558.9z"/>
				<path d="M573.3,118.1v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H569v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L573.3,118.1L573.3,118.1z"/>
				<path d="M592.4,121.9v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C590.7,116.4,592.4,118.5,592.4,121.9z"/>
				<path d="M595.7,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C598,129.7,595.7,127,595.7,123.1z M605.9,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H605.9z"/>
				<path d="M636.9,121.8v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C635,116.4,636.9,118.3,636.9,121.8z"/>
				<path d="M641,111.6h2v2.5h-2V111.6z M641.2,116.7h1.6v12.7h-1.6V116.7z"/>
				<path d="M652.5,129.7c-3.8,0-6.2-2.8-6.2-6.7s2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6h-1.7c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C657.8,127.7,655.7,129.7,652.5,129.7z"/>
				<path d="M665.2,117.8c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C668.5,118.7,667.3,117.8,665.2,117.8z"/>
				<path d="M518.6,147.3l-4.2,12.7h-1.5l-3.5-11l-3.5,11h-1.5l-4.2-12.7h1.8l3.2,10.5l3.4-10.5h1.6l3.4,10.5l3.2-10.5H518.6z"/>
				<path d="M521,142.2h2v2.5h-2V142.2z M521.2,147.3h1.6V160h-1.6V147.3z"/>
				<path d="M529.9,148.7v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4h-5.1L529.9,148.7L529.9,148.7z"/>
				<path d="M548.9,152.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H538v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C547.2,147,548.9,149.1,548.9,152.5z"/>
				<path d="M571.4,153.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C568.9,147,571.4,149.8,571.4,153.7z
						 M560.4,153.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C562.3,148.4,560.4,150.6,560.4,153.7z"/>
				<path d="M585.8,152.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C584.1,147,585.8,149.1,585.8,152.5z"/>
				<path d="M589.2,153.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H591v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C591.5,160.3,589.2,157.6,589.2,153.7z M599.4,152.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H599.4z"/>
				<path d="M611.2,147.3h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9
						l0,0v7.7h-1.6V147.3z M621.9,153.7c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C620.1,158.9,621.9,156.7,621.9,153.7z"/>
				<path d="M634.6,147.2v1.9c-3.9-0.3-6,1.3-6,5.4v5.6H627v-12.7h1.6v3.5C629.6,148.2,631.7,147.2,634.6,147.2z"/>
				<path d="M636.1,153.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C638.4,160.3,636.1,157.6,636.1,153.7z M646.3,152.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H646.3z"/>
				<path d="M655.3,148.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7c0,2.6-2,3.8-4.8,3.8
						c-3.3,0-5.3-1.8-5.5-4.7h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5
						c0-2.7,2.2-3.6,4.6-3.6c2.9,0,4.7,1.4,5,4.3h-1.6C658.5,149.3,657.3,148.4,655.3,148.4z"/>
				<path d="M667.7,148.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7c0,2.6-2,3.8-4.8,3.8
						c-3.3,0-5.3-1.8-5.5-4.7h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5
						c0-2.7,2.2-3.6,4.6-3.6c2.9,0,4.7,1.4,5,4.3h-1.6C671,149.3,669.8,148.4,667.7,148.4z"/>
		</g>
		<path class="st0" d="M421.6,276.9c52.5-32.9,105.1-65.8,157.6-98.7"/>
</g>
<g class="rotation-svg-item" id="rotation_x5F_waterproof">
		<g>
				<path d="M623.2,323l-5.3,17.8h-1.6l-4.9-15.1l-4.9,15.1h-1.6l-5.3-17.8h1.7l4.4,15.4l5.1-15.4h1.3l5.1,15.4l4.4-15.4H623.2z"/>
				<path d="M634.8,332.4v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C632.9,327.8,634.8,329.6,634.8,332.4z M633.2,335.9v-1.4H631
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C631.2,339.7,633.1,338,633.2,335.9z"/>
				<path d="M641.4,329.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V324h1.6v4.1h5.1v1.4H641.4z"/>
				<path d="M648,334.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C650.3,341.1,648,338.4,648,334.5z M658.2,333.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H658.2z"/>
				<path d="M671,328v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C666,329,668.2,328,671,328z"/>
				<path d="M674,328.1h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9l0,0
						v7.7H674V328.1z M684.7,334.5c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C683,339.7,684.7,337.5,684.7,334.5z"/>
				<path d="M697.4,328v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C692.4,329,694.6,328,697.4,328z"/>
				<path d="M711.4,334.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C708.9,327.8,711.4,330.6,711.4,334.5z
						 M700.5,334.5c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S700.5,331.4,700.5,334.5z"/>
				<path d="M726.5,334.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C724,327.8,726.5,330.6,726.5,334.5z
						 M715.5,334.5c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C717.4,329.2,715.5,331.4,715.5,334.5z"/>
				<path d="M732.5,326.9v1.2h5.1v1.4h-5.1v11.3h-1.6v-11.3h-2.8v-1.4h2.8v-1.2c0-2.5,1.7-4.2,4.4-4.2c0.9,0,1.6,0.2,2.4,0.5v1.5
						c-0.9-0.4-1.7-0.5-2.4-0.5C733.5,324.2,732.5,325.2,732.5,326.9z"/>
		</g>
		<line class="st0" x1="500.1" y1="333.2" x2="578" y2="332.2"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_lanyard">
		<g>
				<path d="M562.1,457.9v1.5h-11.4v-17.8h1.7V458h9.7V457.9z"/>
				<path d="M575.6,450.9v8.4H574v-2.4l0,0c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V451
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C573.7,446.3,575.6,448,575.6,450.9z M574,454.4V453h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C572.1,458.1,574,456.5,574,454.4z"/>
				<path d="M590.9,451.7v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H580v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C589.2,446.3,590.9,448.4,590.9,451.7z"/>
				<path d="M605.1,446.6l-6,15.2c-0.8,2-2.5,3-4.4,3c-1.1,0-2-0.2-2.9-0.6v-1.6c1.2,0.7,2.1,0.8,2.9,0.8c1.2,0,2.5-0.6,3.1-2.1
						l0.6-1.6l-5.6-13h1.8l4.5,11l4.2-11L605.1,446.6L605.1,446.6z"/>
				<path d="M617.1,450.9v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V451
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C615.1,446.3,617.1,448,617.1,450.9z M615.5,454.4V453h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C613.5,458.1,615.4,456.5,615.5,454.4z"/>
				<path d="M629.1,446.4v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C624,447.5,626.2,446.4,629.1,446.4z"/>
				<path d="M630.5,452.9c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C632.9,459.6,630.5,456.8,630.5,452.9z M632.1,452.9c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C633.9,447.7,632.1,449.9,632.1,452.9z"/>
		</g>
		<g>
				<path d="M528.5,477.6c0,3.2,1.3,6.4,2.9,8.4h-1.3c-1.5-2.1-2.7-5.1-2.7-8.4s1.2-5.7,2.7-7.7h1.3
						C529.9,471.8,528.5,474.3,528.5,477.6z"/>
				<path d="M545.3,474.9l-3,9h-1l-2.5-7.8l-2.5,7.8h-1l-3-9h1.3l2.2,7.4l2.4-7.4h1.1l2.4,7.4l2.2-7.4H545.3z"/>
				<path d="M552.5,474.8v1.3c-2.7-0.2-4.2,0.9-4.2,3.8v3.9h-1.2v-9h1.2v2.5C549,475.5,550.5,474.8,552.5,474.8z"/>
				<path d="M554.5,471.3h1.4v1.8h-1.4V471.3z M554.6,474.9h1.2v9h-1.2V474.9z"/>
				<path d="M561.7,475.6c-1.2,0-2.1,0.5-2.1,1.5c0,1.1,0.9,1.2,2.5,1.6c1.9,0.5,3.3,0.8,3.3,2.6c0,1.8-1.4,2.7-3.4,2.7
						c-2.3,0-3.7-1.2-3.9-3.3h1.1c0.1,1.5,1.1,2.4,2.7,2.4c1.2,0,2.3-0.5,2.3-1.7c0-1.1-0.8-1.2-2.5-1.7c-1.9-0.5-3.3-0.7-3.3-2.5
						c0-1.9,1.6-2.6,3.3-2.6c2.1,0,3.3,1,3.5,3h-1.1C564,476.3,563.1,475.6,561.7,475.6z"/>
				<path d="M569.6,475.9v5.2c0,1.2,0.7,1.9,1.9,1.9c0.5,0,1-0.1,1.5-0.4v1.1c-0.4,0.2-0.9,0.3-1.5,0.3c-1.9,0-3.1-1.2-3.1-3v-5.2
						h-1.9v-1h0.3c1.2,0,1.6-0.3,1.6-1.4V472h1.2v2.9h3.6v1H569.6z"/>
				<path d="M579.3,478.4v1h-5.2v-1H579.3z"/>
				<path d="M584.9,475.6c-1.2,0-2.1,0.5-2.1,1.5c0,1.1,0.9,1.2,2.5,1.6c1.9,0.5,3.3,0.8,3.3,2.6c0,1.8-1.4,2.7-3.4,2.7
						c-2.3,0-3.7-1.2-3.9-3.3h1.1c0.1,1.5,1.1,2.4,2.7,2.4c1.2,0,2.3-0.5,2.3-1.7c0-1.1-0.8-1.2-2.5-1.7c-1.9-0.5-3.3-0.7-3.3-2.5
						c0-1.9,1.6-2.6,3.3-2.6c2.1,0,3.3,1,3.5,3h-1.1C587.2,476.3,586.3,475.6,584.9,475.6z"/>
				<path d="M592.8,475.9v5.2c0,1.2,0.7,1.9,1.9,1.9c0.5,0,1-0.1,1.5-0.4v1.1c-0.4,0.2-0.9,0.3-1.5,0.3c-1.9,0-3.1-1.2-3.1-3v-5.2
						h-1.9v-1h0.3c1.2,0,1.6-0.3,1.6-1.4V472h1.2v2.9h3.6v1H592.8z"/>
				<path d="M603.9,474.8v1.3c-2.7-0.2-4.2,0.9-4.2,3.8v3.9h-1.2v-9h1.2v2.5C600.4,475.5,601.9,474.8,603.9,474.8z"/>
				<path d="M612.3,477.9v5.9h-1.1v-1.7l0,0c-0.4,0.9-1.6,1.8-3.4,1.8c-1.7,0-2.9-1-2.9-2.5c0-1.7,1.3-3,4.8-3h1.6v-0.6
						c0-1.4-0.9-2.3-2.4-2.3c-1.4,0-2.3,0.7-2.4,2h-1.2c0.1-1.9,1.5-3,3.6-3C610.9,474.7,612.3,475.9,612.3,477.9z M611.2,480.4v-1
						h-1.6c-2.8,0-3.6,0.9-3.6,2.1c0,1,0.8,1.6,2,1.6C609.8,483,611.1,481.9,611.2,480.4z"/>
				<path d="M615.4,474.9h1.2v2l0,0c0.5-1.4,1.8-2.2,3.2-2.2c2.6,0,4.3,2,4.3,4.7s-1.7,4.7-4.3,4.7c-1.5,0-2.8-0.8-3.2-2.1l0,0v5.5
						h-1.2V474.9z M622.9,479.4c0-2.1-1.2-3.7-3.2-3.7c-1.9,0-3.3,1.5-3.3,3.6v0.2c0,2.1,1.4,3.6,3.3,3.6
						C621.7,483.1,622.9,481.5,622.9,479.4z"/>
				<path d="M634.8,484.1c-2.7,0-4.4-2-4.4-4.7s1.7-4.7,4.4-4.7c2.3,0,3.7,1.4,4,3.3h-1.2c-0.3-1.3-1.2-2.3-2.8-2.3
						c-2,0-3.2,1.6-3.2,3.7s1.2,3.7,3.2,3.7c1.7,0,2.6-1,2.9-2.4h1.2C638.6,482.6,637.2,484.1,634.8,484.1z"/>
				<path d="M643.2,484c-1.3,0-2.1-0.9-2.1-2.2v-10.5h1.2v10.4c0,0.8,0.4,1.3,1.1,1.3c0.3,0,0.6-0.1,1.1-0.3v1.1
						C644,483.9,643.6,484,643.2,484z"/>
				<path d="M646.3,471.3h1.4v1.8h-1.4V471.3z M646.5,474.9h1.2v9h-1.2V474.9z"/>
				<path d="M650.8,474.9h1.2v2l0,0c0.5-1.4,1.8-2.2,3.2-2.2c2.6,0,4.3,2,4.3,4.7s-1.7,4.7-4.3,4.7c-1.5,0-2.8-0.8-3.2-2.1l0,0v5.5
						h-1.2V474.9z M658.3,479.4c0-2.1-1.2-3.7-3.2-3.7c-1.9,0-3.3,1.5-3.3,3.6v0.2c0,2.1,1.4,3.6,3.3,3.6
						C657.1,483.1,658.3,481.5,658.3,479.4z"/>
				<path d="M662.2,469.8c1.5,2.1,2.7,4.4,2.7,7.7c0,3.3-1.2,6.3-2.7,8.4H661c1.6-2,2.9-5.1,2.9-8.4s-1.3-5.7-2.9-7.7H662.2z"/>
		</g>
		<path class="st0" d="M424,477.8c0,0,46.8,31.1,82.1,34.4c35.3,3.3,42.4,2.7,56.9,0s29-9.8,29.6-10.7"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_battery">
		<g>
				<path d="M278,587c0,3-2.3,4.8-6.1,4.8h-7.4V574h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3C276.5,583.2,278,584.8,278,587z
						 M266.2,581.9h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2h-5.7V581.9z M276.3,586.8c0-1.8-1.4-3.5-4.5-3.5h-5.6v7.1h5.5
						C274.2,590.4,276.3,589.3,276.3,586.8z"/>
				<path d="M292.4,591.9h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6v12.7H292.4z"/>
				<path d="M296.6,574h2v2.5h-2V574z M296.8,579.1h1.6v12.7h-1.6V579.1z"/>
				<path d="M305.9,592c-1.8,0-3-1.3-3-3.1V574h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C306.9,591.9,306.3,592,305.9,592z"/>
				<path d="M312.7,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H312.7z"/>
				<path d="M326.6,584.1v1.4h-7.4v-1.4H326.6z"/>
				<path d="M330.4,574h2v2.5h-2V574z M330.6,579.1h1.6v12.7h-1.6V579.1z"/>
				<path d="M347.6,584.3v7.6H346v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C345.9,578.8,347.6,580.9,347.6,584.3z"/>
				<path d="M360.2,589L360.2,589v2.8h-1.6V574h1.6v7.7l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.9-2.4,6.7-6.1,6.7
						C362.7,592.1,361,591,360.2,589z M360.1,585.3v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C362.1,580.2,360.1,582.3,360.1,585.3z"/>
				<path d="M383.9,583.4v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C382,578.8,383.9,580.6,383.9,583.4z M382.4,586.9v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C380.4,590.7,382.3,589,382.4,586.9z"/>
				<path d="M390.6,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H390.6z"/>
				<path d="M401.3,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H397v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H401.3z"/>
				<path d="M407.9,585.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C410.2,592.1,407.9,589.4,407.9,585.5z M418.1,584.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H418.1z"/>
				<path d="M430.9,579v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C425.8,580,428,579,430.9,579z"/>
				<path d="M444.7,579.1l-6,15.2c-0.8,2-2.5,3-4.4,3c-1.1,0-2-0.2-2.9-0.6V595c1.2,0.7,2.1,0.8,2.9,0.8c1.2,0,2.5-0.6,3.1-2.1
						l0.6-1.6l-5.6-13h1.8l4.5,11l4.2-11L444.7,579.1L444.7,579.1z"/>
				<path d="M236,622.7c-3.8,0-6.2-2.8-6.2-6.7c0-3.8,2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6H240c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C241.3,620.7,239.3,622.7,236,622.7z"/>
				<path d="M255.9,614.9v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H245v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C254.1,609.4,255.9,611.5,255.9,614.9z"/>
				<path d="M269.7,614v8.4h-1.6V620H268c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V614
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C267.8,609.4,269.7,611.2,269.7,614z M268.1,617.5v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C266.2,621.3,268.1,619.6,268.1,617.5z"/>
				<path d="M281.7,609.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C276.7,610.6,278.9,609.6,281.7,609.6z"/>
				<path d="M296.3,610.4c-1.4,0-2.5,0.2-3.5,0.4c0.8,0.7,1.3,1.8,1.3,3c0,2.6-2.2,4.3-5.4,4.3c-0.9,0-1.7-0.1-2.4-0.4
						c-0.4,0.5-0.7,1-0.7,1.5c0,0.7,0.6,1,1.6,1h3.4c2.7,0,4.3,1.4,4.3,3.4c0,2.4-2.8,4.2-6.2,4.2c-3.7,0-6-1.6-6-3.7
						c0-1.5,1-2.6,2.8-2.9c-0.8-0.3-1.2-0.9-1.2-1.6c0-0.9,0.7-1.7,1.3-2.2c-1.3-0.8-2.1-2-2.1-3.6c0-2.6,2.2-4.4,5.4-4.4
						c1.4,0,2.6,0.4,3.5,1c0.8-1,2.2-1.8,4-1.8L296.3,610.4L296.3,610.4z M286.8,621.8c-1.5,0-2.4,0.8-2.4,2.2c0,1.5,1.6,2.5,4.5,2.5
						c2.4,0,4.4-1.1,4.4-2.8c0-1.1-0.9-2-2.7-2L286.8,621.8L286.8,621.8z M292.6,613.8c0-1.9-1.6-3.1-3.8-3.1c-2.2,0-3.7,1.2-3.7,3.1
						c0,1.8,1.5,3.1,3.7,3.1C291,616.9,292.6,615.6,292.6,613.8z"/>
				<path d="M297.6,616.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C300,622.7,297.6,620,297.6,616.1z M307.8,615.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H307.8z"/>
				<path d="M312,616.1c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C314.4,622.7,312,619.9,312,616.1z M313.6,616.1c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1V616c0-3-2-5.1-4.6-5.1
						C315.3,610.8,313.6,613,313.6,616.1z"/>
				<path d="M347.1,616.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C344.6,609.4,347.1,612.3,347.1,616.1z
						 M336.1,616.1c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C338,610.8,336.1,613,336.1,616.1z"/>
				<path d="M360.8,609.7l-5.4,12.7h-1.6l-5.4-12.7h1.8l4.3,10.9l4.4-10.9H360.8z"/>
				<path d="M362.3,616.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H364v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C364.6,622.7,362.3,620,362.3,616.1z M372.5,615.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H372.5z"/>
				<path d="M385.3,609.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C380.2,610.6,382.4,609.6,385.3,609.6z"/>
				<path d="M409.2,604.6v11.1c0,4.4-2.9,7-7,7s-7-2.6-7-7v-11.1h1.7v11.2c0,3.4,2.2,5.4,5.3,5.4c3.1,0,5.3-2,5.3-5.4v-11.2H409.2z"/>
				<path d="M420.8,621.3c2.6,0,4.6-1.3,4.6-3.5s-1.8-2.8-5-3.6c-3.7-1-6.2-1.8-6.2-4.9c0-3.1,2.3-4.8,6-4.8s6.2,1.9,6.6,5.9H425
						c-0.3-3.1-2-4.4-4.7-4.4c-2.6,0-4.4,1.2-4.4,3.3c0,1.8,0.9,2.5,4.9,3.6c3.1,0.8,6.2,1.6,6.2,5c0,3-2.5,5-6.3,5
						c-4.3,0-7-2.6-7.2-6.8h1.8C415.6,619.3,417.7,621.3,420.8,621.3z"/>
				<path d="M445.2,617.6c0,3-2.3,4.8-6.1,4.8h-7.4v-17.8h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3
						C443.7,613.8,445.2,615.4,445.2,617.6z M433.4,612.5h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2h-5.7V612.5z M443.5,617.4
						c0-1.8-1.4-3.5-4.5-3.5h-5.6v7.1h5.5C441.4,621,443.5,619.9,443.5,617.4z"/>
				<path d="M456.8,614.7v1.4h-7.4v-1.4H456.8z"/>
				<path d="M468.9,622.7c-5.1,0-8.5-3.9-8.5-9.2s3.4-9.2,8.5-9.2c4.1,0,6.8,2.2,7.5,6h-1.8c-0.6-2.9-2.5-4.6-5.7-4.6
						c-4.1,0-6.7,3.3-6.7,7.7s2.6,7.8,6.7,7.8c3.1,0,5-1.7,5.6-4.4h1.9C475.7,620.5,473,622.7,468.9,622.7z"/>
		</g>
		<line class="st0" x1="352" y1="500.9" x2="352" y2="551.9"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_microphones">
		<g>
				<path d="M38.5,447.4c0,3.5-2.6,5.9-6.2,5.9c-2.1,0-3.9-0.9-5-2.4s-1.8-3.6-1.8-6.5c0-6.2,2.9-9.5,6.9-9.5c2.4,0,5.1,1.2,5.9,4.7
						h-1.8c-0.5-2.4-2.3-3.2-4-3.2c-3.2,0-5.5,2.9-5.4,8.9c0.8-2.3,2.8-3.8,5.4-3.8C36,441.5,38.5,444,38.5,447.4z M36.8,447.4
						c0-2.6-1.8-4.5-4.5-4.5c-2.6,0-4.5,1.7-4.5,4.3c0,2.6,1.9,4.6,4.6,4.6C35,451.9,36.8,450,36.8,447.4z"/>
				<path d="M68,445.4v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1H49v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C66.1,440,68,441.9,68,445.4z"/>
				<path d="M72.1,435.2h2v2.5h-2V435.2z M72.3,440.3h1.6V453h-1.6V440.3z"/>
				<path d="M83.6,453.3c-3.8,0-6.2-2.8-6.2-6.7c0-3.8,2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6h-1.7c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C88.9,451.3,86.8,453.3,83.6,453.3z"/>
				<path d="M100.1,440.2v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C95.1,441.2,97.3,440.2,100.1,440.2z"/>
				<path d="M114.1,446.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C111.6,440,114.1,442.8,114.1,446.7z
						 M103.2,446.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C105,441.4,103.2,443.6,103.2,446.7z"/>
				<path d="M117.6,440.3h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9
						l0,0v7.7h-1.6V440.3z M128.3,446.7c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C126.6,451.9,128.3,449.7,128.3,446.7z"/>
				<path d="M144.4,445.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C142.7,440,144.4,442.1,144.4,445.5z"/>
				<path d="M160.2,446.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C157.7,440,160.2,442.8,160.2,446.7z
						 M149.3,446.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C151.1,441.4,149.3,443.6,149.3,446.7z"/>
				<path d="M174.7,445.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C173,440,174.7,442.1,174.7,445.5z"/>
				<path d="M178,446.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C180.3,453.3,178,450.6,178,446.7z M188.2,445.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H188.2z"/>
				<path d="M197.2,441.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C200.5,442.3,199.3,441.4,197.2,441.4z"/>
				<path d="M74.6,480.8L74.6,480.8v2.8H73v-17.8h1.6v7.7l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.8-2.4,6.7-6.1,6.7
						C77.1,483.9,75.3,482.7,74.6,480.8z M74.4,477.1v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C76.4,472,74.5,474.1,74.4,477.1z"/>
				<path d="M99.5,483.6h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L99.5,483.6L99.5,483.6z"/>
				<path d="M103.7,465.8h2v2.5h-2V465.8z M103.9,470.9h1.6v12.7h-1.6V470.9z"/>
				<path d="M113,483.8c-1.8,0-3-1.3-3-3.1v-14.9h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C114,483.7,113.4,483.8,113,483.8z"/>
				<path d="M119.8,472.3v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7V471h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L119.8,472.3L119.8,472.3z"/>
				<path d="M133.7,475.9v1.4h-7.4v-1.4H133.7z"/>
				<path d="M137.5,465.8h2v2.5h-2V465.8z M137.7,470.9h1.6v12.7h-1.6V470.9z"/>
				<path d="M154.7,476.1v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C153,470.6,154.7,472.7,154.7,476.1z"/>
		</g>
		<line class="st0" x1="342.2" y1="467.5" x2="205" y2="466.5"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_bluetooth">
		<g>
				<path d="M13.5,305c0,3-2.3,4.8-6.1,4.8H0V292h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3C12,301.2,13.5,302.8,13.5,305z
						 M1.7,299.9h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2H1.7V299.9z M11.8,304.8c0-1.8-1.4-3.5-4.5-3.5H1.7v7.1h5.5
						C9.8,308.4,11.8,307.3,11.8,304.8z"/>
				<path d="M20.6,310c-1.8,0-3-1.3-3-3.1V292h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C21.7,309.9,21.1,310,20.6,310z"/>
				<path d="M35.5,309.8h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5V297h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6v12.7L35.5,309.8L35.5,309.8z"/>
				<path d="M39,303.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H40.7v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9h1.8
						c-0.7,2.7-2.8,4.3-5.7,4.3C41.3,310.1,39,307.4,39,303.5z M49.2,302.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H49.2z"/>
				<path d="M56.8,298.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4H53c1.8,0,2.2-0.4,2.2-2V293h1.6v4.1h5.1v1.4H56.8z"/>
				<path d="M75.9,303.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C73.4,296.8,75.9,299.6,75.9,303.5z M65,303.5
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S65,300.4,65,303.5z"/>
				<path d="M90.9,303.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C88.4,296.8,90.9,299.6,90.9,303.5z M80,303.5
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S80,300.4,80,303.5z"/>
				<path d="M96.9,298.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4H93c1.8,0,2.2-0.4,2.2-2V293h1.6v4.1h5.1v1.4H96.9z"/>
				<path d="M116,302.3v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H105V292h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C114.3,296.8,116,298.9,116,302.3z"/>
				<path d="M22.6,334.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C20.1,327.4,22.6,330.2,22.6,334.1z
						 M11.6,334.1c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C13.5,328.8,11.6,331,11.6,334.1z"/>
				<path d="M33.7,327.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C28.7,328.6,30.9,327.6,33.7,327.6z"/>
				<path d="M59.8,327.7l-4.2,12.7h-1.5l-3.5-11l-3.5,11h-1.5l-4.2-12.7h1.8l3.2,10.5l3.4-10.5h1.6l3.4,10.5l3.2-10.5H59.8z"/>
				<path d="M62.1,322.6h2v2.5h-2V322.6z M62.3,327.7h1.6v12.7h-1.6V327.7z"/>
				<path d="M76.1,327.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7H70v3.5C71,328.6,73.2,327.6,76.1,327.6z"/>
				<path d="M77.5,334.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H79.2v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C79.9,340.7,77.5,338,77.5,334.1z M87.7,333.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H87.7z
						"/>
				<path d="M91.9,334c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C94.3,340.7,91.9,337.9,91.9,334z M93.5,334c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C95.2,328.8,93.5,331,93.5,334z"/>
				<path d="M22.5,363.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C20.8,358,22.5,360.1,22.5,363.5z"/>
				<path d="M25.8,364.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H27.5v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C28.1,371.3,25.8,368.6,25.8,364.7z M36,363.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H36z"
						/>
				<path d="M50.7,362.6v8.4h-1.6v-2.4H49c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2H49v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C48.8,358,50.7,359.8,50.7,362.6z M49.1,366.1v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C47.2,369.9,49,368.2,49.1,366.1z"/>
				<path d="M54,364.6c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6V371h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C56.4,371.3,54,368.5,54,364.6z M55.6,364.6c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C57.4,359.4,55.6,361.6,55.6,364.6z"/>
				<path d="M74.8,359.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C78.1,360.3,76.8,359.4,74.8,359.4z"/>
				<path d="M82.4,364.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H84.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C84.7,371.3,82.4,368.6,82.4,364.7z M92.6,363.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H92.6z"/>
				<path d="M100.3,359.7v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H96v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L100.3,359.7L100.3,359.7z"/>
		</g>
		<line class="st1" x1="121.7" y1="332.8" x2="172.4" y2="332.8"/>
</g>


<g class="rotation-svg-item" id="rotation_x5F_volume">
		<g>
				<path d="M42.6,111.6l-7.1,17.8H34l-7.1-17.8h1.8l6,15.6l6-15.6C40.7,111.6,42.6,111.6,42.6,111.6z"/>
				<path d="M55.5,123.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C53,116.4,55.5,119.2,55.5,123.1z M44.6,123.1
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C46.4,117.8,44.6,120,44.6,123.1z"/>
				<path d="M62,129.6c-1.8,0-3-1.3-3-3.1v-14.9h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C63,129.5,62.4,129.6,62,129.6z"/>
				<path d="M76.8,129.4h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L76.8,129.4L76.8,129.4z"/>
				<path d="M100.5,121.8v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C98.6,116.4,100.5,118.3,100.5,121.8z"/>
				<path d="M103.8,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C106.1,129.7,103.8,127,103.8,123.1z M114,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H114
						z"/>
				<path d="M137.6,121.5h-5.3v5.5h-1.5v-5.5h-5.3V120h5.3v-5.4h1.5v5.4h5.3V121.5z"/>
				<path d="M149,111.6l-6.6,17.8h-1.6l6.6-17.8C147.4,111.6,149,111.6,149,111.6z"/>
				<path d="M159.5,121.7v1.4h-7.4v-1.4H159.5z"/>
		</g>
		<polyline class="st0" points="103.4,143.6 124.1,174.1 240.8,174.1	 "/>
</g>


<g class="rotation-svg-item" id="rotation_x5F_speak">
		<line class="st0" x1="352" y1="33.6" x2="352" y2="123.1"/>
		<g>
				<path d="M266.8,16.9c2.6,0,4.6-1.3,4.6-3.5s-1.8-2.8-5-3.6c-3.7-1-6.2-1.8-6.2-4.9s2.3-4.8,6-4.8s6.2,1.9,6.6,5.9H271
						c-0.3-3.1-2-4.4-4.7-4.4c-2.6,0-4.4,1.2-4.4,3.3c0,1.8,0.9,2.5,4.9,3.6c3.1,0.8,6.2,1.6,6.2,5c0,3-2.5,5-6.3,5
						c-4.3,0-7-2.6-7.2-6.8h1.8C261.5,15,263.6,16.9,266.8,16.9z"/>
				<path d="M277.1,5.4h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9l0,0
						v7.7h-1.6V5.4z M287.8,11.8c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1C286.1,17,287.8,14.8,287.8,11.8z"
						/>
				<path d="M291.9,11.8c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6V12h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C294.2,18.4,291.9,15.7,291.9,11.8z M302.1,10.8c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H302.1z"/>
				<path d="M316.8,9.7v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V9.7
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C314.9,5.1,316.8,6.9,316.8,9.7z M315.2,13.2v-1.4H313
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C313.3,17,315.1,15.3,315.2,13.2z"/>
				<path d="M326.3,11.6h-3.5v6.6h-1.6V0.3h1.6v9.8h3.4l3.8-4.7h2l-4.4,5.4l4.9,7.3h-2L326.3,11.6z"/>
				<path d="M333.7,11.8c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6V12h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C336.1,18.4,333.7,15.7,333.7,11.8z M343.9,10.8c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H343.9z"/>
				<path d="M356.7,5.3v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6V5.4h1.6v3.5C351.7,6.3,353.9,5.3,356.7,5.3z"/>
				<path d="M368,15.3L368,15.3v2.8h-1.6V0.3h1.6V8l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.9-2.4,6.7-6.1,6.7
						C370.5,18.4,368.7,17.2,368,15.3z M367.9,11.6v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C369.8,6.5,367.9,8.6,367.9,11.6z"/>
				<path d="M392.9,18.1h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5V5.4h1.6V13c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						V5.4h1.6v12.7H392.9z"/>
				<path d="M397.1,0.3h2v2.5h-2V0.3z M397.3,5.4h1.6v12.7h-1.6V5.4z"/>
				<path d="M406.4,18.3c-1.8,0-3-1.3-3-3.1V0.3h1.6V15c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4V18
						C407.4,18.2,406.8,18.3,406.4,18.3z"/>
				<path d="M413.2,6.8v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2V6.8h-2.7
						V5.4h0.5c1.8,0,2.2-0.4,2.2-2V1.3h1.6v4.1h5.1v1.4C418.3,6.8,413.2,6.8,413.2,6.8z"/>
				<path d="M427.1,10.4v1.4h-7.4v-1.4H427.1z"/>
				<path d="M430.9,0.3h2v2.5h-2V0.3z M431.1,5.4h1.6v12.7h-1.6V5.4z"/>
				<path d="M448.2,10.6v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6V5.4h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C446.4,5.1,448.2,7.2,448.2,10.6z"/>
		</g>
</g>
</svg>
</div>
</div>
<div class="rotation-svgs rotation-copy">
<div class="rotation-svgs-inner">
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
		 viewBox="0 0 737.6 627.9" style="enable-background:new 0 0 737.6 627.9;" xml:space="preserve">
<style type="text/css">
		.st0{fill:none;stroke:#000000;stroke-width:2;stroke-miterlimit:10;}
		.st1{fill:none;stroke:#000000;stroke-width:2;stroke-miterlimit:10;stroke-dasharray:4;}
</style>

<g class="rotation-svg-item" id="rotation_x5F_mute">
		<g>
				<path d="M519.4,111.6v17.8h-1.7v-14.9l-6.5,9.3h-0.3l-6.5-9.3v14.9h-1.7v-17.8h1.5l6.9,9.9l6.9-9.9
						C518,111.6,519.4,111.6,519.4,111.6z"/>
				<path d="M535.1,129.4h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L535.1,129.4L535.1,129.4z"/>
				<path d="M542.2,118.1v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L542.2,118.1L542.2,118.1z"/>
				<path d="M548.7,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C551.1,129.7,548.7,127,548.7,123.1z M558.9,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H558.9z"/>
				<path d="M573.3,118.1v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H569v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L573.3,118.1L573.3,118.1z"/>
				<path d="M592.4,121.9v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C590.7,116.4,592.4,118.5,592.4,121.9z"/>
				<path d="M595.7,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C598,129.7,595.7,127,595.7,123.1z M605.9,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H605.9z"/>
				<path d="M636.9,121.8v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C635,116.4,636.9,118.3,636.9,121.8z"/>
				<path d="M641,111.6h2v2.5h-2V111.6z M641.2,116.7h1.6v12.7h-1.6V116.7z"/>
				<path d="M652.5,129.7c-3.8,0-6.2-2.8-6.2-6.7s2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6h-1.7c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C657.8,127.7,655.7,129.7,652.5,129.7z"/>
				<path d="M665.2,117.8c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C668.5,118.7,667.3,117.8,665.2,117.8z"/>
				<path d="M518.6,147.3l-4.2,12.7h-1.5l-3.5-11l-3.5,11h-1.5l-4.2-12.7h1.8l3.2,10.5l3.4-10.5h1.6l3.4,10.5l3.2-10.5H518.6z"/>
				<path d="M521,142.2h2v2.5h-2V142.2z M521.2,147.3h1.6V160h-1.6V147.3z"/>
				<path d="M529.9,148.7v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4h-5.1L529.9,148.7L529.9,148.7z"/>
				<path d="M548.9,152.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H538v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C547.2,147,548.9,149.1,548.9,152.5z"/>
				<path d="M571.4,153.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C568.9,147,571.4,149.8,571.4,153.7z
						 M560.4,153.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C562.3,148.4,560.4,150.6,560.4,153.7z"/>
				<path d="M585.8,152.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C584.1,147,585.8,149.1,585.8,152.5z"/>
				<path d="M589.2,153.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H591v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C591.5,160.3,589.2,157.6,589.2,153.7z M599.4,152.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H599.4z"/>
				<path d="M611.2,147.3h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9
						l0,0v7.7h-1.6V147.3z M621.9,153.7c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C620.1,158.9,621.9,156.7,621.9,153.7z"/>
				<path d="M634.6,147.2v1.9c-3.9-0.3-6,1.3-6,5.4v5.6H627v-12.7h1.6v3.5C629.6,148.2,631.7,147.2,634.6,147.2z"/>
				<path d="M636.1,153.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C638.4,160.3,636.1,157.6,636.1,153.7z M646.3,152.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H646.3z"/>
				<path d="M655.3,148.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7c0,2.6-2,3.8-4.8,3.8
						c-3.3,0-5.3-1.8-5.5-4.7h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5
						c0-2.7,2.2-3.6,4.6-3.6c2.9,0,4.7,1.4,5,4.3h-1.6C658.5,149.3,657.3,148.4,655.3,148.4z"/>
				<path d="M667.7,148.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7c0,2.6-2,3.8-4.8,3.8
						c-3.3,0-5.3-1.8-5.5-4.7h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5
						c0-2.7,2.2-3.6,4.6-3.6c2.9,0,4.7,1.4,5,4.3h-1.6C671,149.3,669.8,148.4,667.7,148.4z"/>
		</g>
		<path class="st0" d="M421.6,276.9c52.5-32.9,105.1-65.8,157.6-98.7"/>
</g>
<g class="rotation-svg-item" id="rotation_x5F_waterproof">
		<g>
				<path d="M623.2,323l-5.3,17.8h-1.6l-4.9-15.1l-4.9,15.1h-1.6l-5.3-17.8h1.7l4.4,15.4l5.1-15.4h1.3l5.1,15.4l4.4-15.4H623.2z"/>
				<path d="M634.8,332.4v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C632.9,327.8,634.8,329.6,634.8,332.4z M633.2,335.9v-1.4H631
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C631.2,339.7,633.1,338,633.2,335.9z"/>
				<path d="M641.4,329.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V324h1.6v4.1h5.1v1.4H641.4z"/>
				<path d="M648,334.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C650.3,341.1,648,338.4,648,334.5z M658.2,333.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H658.2z"/>
				<path d="M671,328v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C666,329,668.2,328,671,328z"/>
				<path d="M674,328.1h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9l0,0
						v7.7H674V328.1z M684.7,334.5c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C683,339.7,684.7,337.5,684.7,334.5z"/>
				<path d="M697.4,328v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C692.4,329,694.6,328,697.4,328z"/>
				<path d="M711.4,334.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C708.9,327.8,711.4,330.6,711.4,334.5z
						 M700.5,334.5c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S700.5,331.4,700.5,334.5z"/>
				<path d="M726.5,334.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C724,327.8,726.5,330.6,726.5,334.5z
						 M715.5,334.5c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C717.4,329.2,715.5,331.4,715.5,334.5z"/>
				<path d="M732.5,326.9v1.2h5.1v1.4h-5.1v11.3h-1.6v-11.3h-2.8v-1.4h2.8v-1.2c0-2.5,1.7-4.2,4.4-4.2c0.9,0,1.6,0.2,2.4,0.5v1.5
						c-0.9-0.4-1.7-0.5-2.4-0.5C733.5,324.2,732.5,325.2,732.5,326.9z"/>
		</g>
		<line class="st0" x1="500.1" y1="333.2" x2="578" y2="332.2"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_lanyard">
		<g>
				<path d="M562.1,457.9v1.5h-11.4v-17.8h1.7V458h9.7V457.9z"/>
				<path d="M575.6,450.9v8.4H574v-2.4l0,0c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V451
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C573.7,446.3,575.6,448,575.6,450.9z M574,454.4V453h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C572.1,458.1,574,456.5,574,454.4z"/>
				<path d="M590.9,451.7v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H580v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C589.2,446.3,590.9,448.4,590.9,451.7z"/>
				<path d="M605.1,446.6l-6,15.2c-0.8,2-2.5,3-4.4,3c-1.1,0-2-0.2-2.9-0.6v-1.6c1.2,0.7,2.1,0.8,2.9,0.8c1.2,0,2.5-0.6,3.1-2.1
						l0.6-1.6l-5.6-13h1.8l4.5,11l4.2-11L605.1,446.6L605.1,446.6z"/>
				<path d="M617.1,450.9v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V451
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C615.1,446.3,617.1,448,617.1,450.9z M615.5,454.4V453h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C613.5,458.1,615.4,456.5,615.5,454.4z"/>
				<path d="M629.1,446.4v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C624,447.5,626.2,446.4,629.1,446.4z"/>
				<path d="M630.5,452.9c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C632.9,459.6,630.5,456.8,630.5,452.9z M632.1,452.9c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C633.9,447.7,632.1,449.9,632.1,452.9z"/>
		</g>
		<g>
				<path d="M528.5,477.6c0,3.2,1.3,6.4,2.9,8.4h-1.3c-1.5-2.1-2.7-5.1-2.7-8.4s1.2-5.7,2.7-7.7h1.3
						C529.9,471.8,528.5,474.3,528.5,477.6z"/>
				<path d="M545.3,474.9l-3,9h-1l-2.5-7.8l-2.5,7.8h-1l-3-9h1.3l2.2,7.4l2.4-7.4h1.1l2.4,7.4l2.2-7.4H545.3z"/>
				<path d="M552.5,474.8v1.3c-2.7-0.2-4.2,0.9-4.2,3.8v3.9h-1.2v-9h1.2v2.5C549,475.5,550.5,474.8,552.5,474.8z"/>
				<path d="M554.5,471.3h1.4v1.8h-1.4V471.3z M554.6,474.9h1.2v9h-1.2V474.9z"/>
				<path d="M561.7,475.6c-1.2,0-2.1,0.5-2.1,1.5c0,1.1,0.9,1.2,2.5,1.6c1.9,0.5,3.3,0.8,3.3,2.6c0,1.8-1.4,2.7-3.4,2.7
						c-2.3,0-3.7-1.2-3.9-3.3h1.1c0.1,1.5,1.1,2.4,2.7,2.4c1.2,0,2.3-0.5,2.3-1.7c0-1.1-0.8-1.2-2.5-1.7c-1.9-0.5-3.3-0.7-3.3-2.5
						c0-1.9,1.6-2.6,3.3-2.6c2.1,0,3.3,1,3.5,3h-1.1C564,476.3,563.1,475.6,561.7,475.6z"/>
				<path d="M569.6,475.9v5.2c0,1.2,0.7,1.9,1.9,1.9c0.5,0,1-0.1,1.5-0.4v1.1c-0.4,0.2-0.9,0.3-1.5,0.3c-1.9,0-3.1-1.2-3.1-3v-5.2
						h-1.9v-1h0.3c1.2,0,1.6-0.3,1.6-1.4V472h1.2v2.9h3.6v1H569.6z"/>
				<path d="M579.3,478.4v1h-5.2v-1H579.3z"/>
				<path d="M584.9,475.6c-1.2,0-2.1,0.5-2.1,1.5c0,1.1,0.9,1.2,2.5,1.6c1.9,0.5,3.3,0.8,3.3,2.6c0,1.8-1.4,2.7-3.4,2.7
						c-2.3,0-3.7-1.2-3.9-3.3h1.1c0.1,1.5,1.1,2.4,2.7,2.4c1.2,0,2.3-0.5,2.3-1.7c0-1.1-0.8-1.2-2.5-1.7c-1.9-0.5-3.3-0.7-3.3-2.5
						c0-1.9,1.6-2.6,3.3-2.6c2.1,0,3.3,1,3.5,3h-1.1C587.2,476.3,586.3,475.6,584.9,475.6z"/>
				<path d="M592.8,475.9v5.2c0,1.2,0.7,1.9,1.9,1.9c0.5,0,1-0.1,1.5-0.4v1.1c-0.4,0.2-0.9,0.3-1.5,0.3c-1.9,0-3.1-1.2-3.1-3v-5.2
						h-1.9v-1h0.3c1.2,0,1.6-0.3,1.6-1.4V472h1.2v2.9h3.6v1H592.8z"/>
				<path d="M603.9,474.8v1.3c-2.7-0.2-4.2,0.9-4.2,3.8v3.9h-1.2v-9h1.2v2.5C600.4,475.5,601.9,474.8,603.9,474.8z"/>
				<path d="M612.3,477.9v5.9h-1.1v-1.7l0,0c-0.4,0.9-1.6,1.8-3.4,1.8c-1.7,0-2.9-1-2.9-2.5c0-1.7,1.3-3,4.8-3h1.6v-0.6
						c0-1.4-0.9-2.3-2.4-2.3c-1.4,0-2.3,0.7-2.4,2h-1.2c0.1-1.9,1.5-3,3.6-3C610.9,474.7,612.3,475.9,612.3,477.9z M611.2,480.4v-1
						h-1.6c-2.8,0-3.6,0.9-3.6,2.1c0,1,0.8,1.6,2,1.6C609.8,483,611.1,481.9,611.2,480.4z"/>
				<path d="M615.4,474.9h1.2v2l0,0c0.5-1.4,1.8-2.2,3.2-2.2c2.6,0,4.3,2,4.3,4.7s-1.7,4.7-4.3,4.7c-1.5,0-2.8-0.8-3.2-2.1l0,0v5.5
						h-1.2V474.9z M622.9,479.4c0-2.1-1.2-3.7-3.2-3.7c-1.9,0-3.3,1.5-3.3,3.6v0.2c0,2.1,1.4,3.6,3.3,3.6
						C621.7,483.1,622.9,481.5,622.9,479.4z"/>
				<path d="M634.8,484.1c-2.7,0-4.4-2-4.4-4.7s1.7-4.7,4.4-4.7c2.3,0,3.7,1.4,4,3.3h-1.2c-0.3-1.3-1.2-2.3-2.8-2.3
						c-2,0-3.2,1.6-3.2,3.7s1.2,3.7,3.2,3.7c1.7,0,2.6-1,2.9-2.4h1.2C638.6,482.6,637.2,484.1,634.8,484.1z"/>
				<path d="M643.2,484c-1.3,0-2.1-0.9-2.1-2.2v-10.5h1.2v10.4c0,0.8,0.4,1.3,1.1,1.3c0.3,0,0.6-0.1,1.1-0.3v1.1
						C644,483.9,643.6,484,643.2,484z"/>
				<path d="M646.3,471.3h1.4v1.8h-1.4V471.3z M646.5,474.9h1.2v9h-1.2V474.9z"/>
				<path d="M650.8,474.9h1.2v2l0,0c0.5-1.4,1.8-2.2,3.2-2.2c2.6,0,4.3,2,4.3,4.7s-1.7,4.7-4.3,4.7c-1.5,0-2.8-0.8-3.2-2.1l0,0v5.5
						h-1.2V474.9z M658.3,479.4c0-2.1-1.2-3.7-3.2-3.7c-1.9,0-3.3,1.5-3.3,3.6v0.2c0,2.1,1.4,3.6,3.3,3.6
						C657.1,483.1,658.3,481.5,658.3,479.4z"/>
				<path d="M662.2,469.8c1.5,2.1,2.7,4.4,2.7,7.7c0,3.3-1.2,6.3-2.7,8.4H661c1.6-2,2.9-5.1,2.9-8.4s-1.3-5.7-2.9-7.7H662.2z"/>
		</g>
		<path class="st0" d="M424,477.8c0,0,46.8,31.1,82.1,34.4c35.3,3.3,42.4,2.7,56.9,0s29-9.8,29.6-10.7"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_battery">
		<g>
				<path d="M278,587c0,3-2.3,4.8-6.1,4.8h-7.4V574h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3C276.5,583.2,278,584.8,278,587z
						 M266.2,581.9h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2h-5.7V581.9z M276.3,586.8c0-1.8-1.4-3.5-4.5-3.5h-5.6v7.1h5.5
						C274.2,590.4,276.3,589.3,276.3,586.8z"/>
				<path d="M292.4,591.9h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6v12.7H292.4z"/>
				<path d="M296.6,574h2v2.5h-2V574z M296.8,579.1h1.6v12.7h-1.6V579.1z"/>
				<path d="M305.9,592c-1.8,0-3-1.3-3-3.1V574h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C306.9,591.9,306.3,592,305.9,592z"/>
				<path d="M312.7,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H312.7z"/>
				<path d="M326.6,584.1v1.4h-7.4v-1.4H326.6z"/>
				<path d="M330.4,574h2v2.5h-2V574z M330.6,579.1h1.6v12.7h-1.6V579.1z"/>
				<path d="M347.6,584.3v7.6H346v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C345.9,578.8,347.6,580.9,347.6,584.3z"/>
				<path d="M360.2,589L360.2,589v2.8h-1.6V574h1.6v7.7l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.9-2.4,6.7-6.1,6.7
						C362.7,592.1,361,591,360.2,589z M360.1,585.3v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C362.1,580.2,360.1,582.3,360.1,585.3z"/>
				<path d="M383.9,583.4v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C382,578.8,383.9,580.6,383.9,583.4z M382.4,586.9v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C380.4,590.7,382.3,589,382.4,586.9z"/>
				<path d="M390.6,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H390.6z"/>
				<path d="M401.3,580.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H397v-1.4h0.5c1.8,0,2.2-0.4,2.2-2V575h1.6v4.1h5.1v1.4H401.3z"/>
				<path d="M407.9,585.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C410.2,592.1,407.9,589.4,407.9,585.5z M418.1,584.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H418.1z"/>
				<path d="M430.9,579v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C425.8,580,428,579,430.9,579z"/>
				<path d="M444.7,579.1l-6,15.2c-0.8,2-2.5,3-4.4,3c-1.1,0-2-0.2-2.9-0.6V595c1.2,0.7,2.1,0.8,2.9,0.8c1.2,0,2.5-0.6,3.1-2.1
						l0.6-1.6l-5.6-13h1.8l4.5,11l4.2-11L444.7,579.1L444.7,579.1z"/>
				<path d="M236,622.7c-3.8,0-6.2-2.8-6.2-6.7c0-3.8,2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6H240c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C241.3,620.7,239.3,622.7,236,622.7z"/>
				<path d="M255.9,614.9v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H245v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C254.1,609.4,255.9,611.5,255.9,614.9z"/>
				<path d="M269.7,614v8.4h-1.6V620H268c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V614
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C267.8,609.4,269.7,611.2,269.7,614z M268.1,617.5v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C266.2,621.3,268.1,619.6,268.1,617.5z"/>
				<path d="M281.7,609.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C276.7,610.6,278.9,609.6,281.7,609.6z"/>
				<path d="M296.3,610.4c-1.4,0-2.5,0.2-3.5,0.4c0.8,0.7,1.3,1.8,1.3,3c0,2.6-2.2,4.3-5.4,4.3c-0.9,0-1.7-0.1-2.4-0.4
						c-0.4,0.5-0.7,1-0.7,1.5c0,0.7,0.6,1,1.6,1h3.4c2.7,0,4.3,1.4,4.3,3.4c0,2.4-2.8,4.2-6.2,4.2c-3.7,0-6-1.6-6-3.7
						c0-1.5,1-2.6,2.8-2.9c-0.8-0.3-1.2-0.9-1.2-1.6c0-0.9,0.7-1.7,1.3-2.2c-1.3-0.8-2.1-2-2.1-3.6c0-2.6,2.2-4.4,5.4-4.4
						c1.4,0,2.6,0.4,3.5,1c0.8-1,2.2-1.8,4-1.8L296.3,610.4L296.3,610.4z M286.8,621.8c-1.5,0-2.4,0.8-2.4,2.2c0,1.5,1.6,2.5,4.5,2.5
						c2.4,0,4.4-1.1,4.4-2.8c0-1.1-0.9-2-2.7-2L286.8,621.8L286.8,621.8z M292.6,613.8c0-1.9-1.6-3.1-3.8-3.1c-2.2,0-3.7,1.2-3.7,3.1
						c0,1.8,1.5,3.1,3.7,3.1C291,616.9,292.6,615.6,292.6,613.8z"/>
				<path d="M297.6,616.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C300,622.7,297.6,620,297.6,616.1z M307.8,615.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H307.8z"/>
				<path d="M312,616.1c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C314.4,622.7,312,619.9,312,616.1z M313.6,616.1c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1V616c0-3-2-5.1-4.6-5.1
						C315.3,610.8,313.6,613,313.6,616.1z"/>
				<path d="M347.1,616.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C344.6,609.4,347.1,612.3,347.1,616.1z
						 M336.1,616.1c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C338,610.8,336.1,613,336.1,616.1z"/>
				<path d="M360.8,609.7l-5.4,12.7h-1.6l-5.4-12.7h1.8l4.3,10.9l4.4-10.9H360.8z"/>
				<path d="M362.3,616.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H364v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C364.6,622.7,362.3,620,362.3,616.1z M372.5,615.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H372.5z"/>
				<path d="M385.3,609.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C380.2,610.6,382.4,609.6,385.3,609.6z"/>
				<path d="M409.2,604.6v11.1c0,4.4-2.9,7-7,7s-7-2.6-7-7v-11.1h1.7v11.2c0,3.4,2.2,5.4,5.3,5.4c3.1,0,5.3-2,5.3-5.4v-11.2H409.2z"/>
				<path d="M420.8,621.3c2.6,0,4.6-1.3,4.6-3.5s-1.8-2.8-5-3.6c-3.7-1-6.2-1.8-6.2-4.9c0-3.1,2.3-4.8,6-4.8s6.2,1.9,6.6,5.9H425
						c-0.3-3.1-2-4.4-4.7-4.4c-2.6,0-4.4,1.2-4.4,3.3c0,1.8,0.9,2.5,4.9,3.6c3.1,0.8,6.2,1.6,6.2,5c0,3-2.5,5-6.3,5
						c-4.3,0-7-2.6-7.2-6.8h1.8C415.6,619.3,417.7,621.3,420.8,621.3z"/>
				<path d="M445.2,617.6c0,3-2.3,4.8-6.1,4.8h-7.4v-17.8h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3
						C443.7,613.8,445.2,615.4,445.2,617.6z M433.4,612.5h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2h-5.7V612.5z M443.5,617.4
						c0-1.8-1.4-3.5-4.5-3.5h-5.6v7.1h5.5C441.4,621,443.5,619.9,443.5,617.4z"/>
				<path d="M456.8,614.7v1.4h-7.4v-1.4H456.8z"/>
				<path d="M468.9,622.7c-5.1,0-8.5-3.9-8.5-9.2s3.4-9.2,8.5-9.2c4.1,0,6.8,2.2,7.5,6h-1.8c-0.6-2.9-2.5-4.6-5.7-4.6
						c-4.1,0-6.7,3.3-6.7,7.7s2.6,7.8,6.7,7.8c3.1,0,5-1.7,5.6-4.4h1.9C475.7,620.5,473,622.7,468.9,622.7z"/>
		</g>
		<line class="st0" x1="352" y1="500.9" x2="352" y2="551.9"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_microphones">
		<g>
				<path d="M38.5,447.4c0,3.5-2.6,5.9-6.2,5.9c-2.1,0-3.9-0.9-5-2.4s-1.8-3.6-1.8-6.5c0-6.2,2.9-9.5,6.9-9.5c2.4,0,5.1,1.2,5.9,4.7
						h-1.8c-0.5-2.4-2.3-3.2-4-3.2c-3.2,0-5.5,2.9-5.4,8.9c0.8-2.3,2.8-3.8,5.4-3.8C36,441.5,38.5,444,38.5,447.4z M36.8,447.4
						c0-2.6-1.8-4.5-4.5-4.5c-2.6,0-4.5,1.7-4.5,4.3c0,2.6,1.9,4.6,4.6,4.6C35,451.9,36.8,450,36.8,447.4z"/>
				<path d="M68,445.4v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1H49v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C66.1,440,68,441.9,68,445.4z"/>
				<path d="M72.1,435.2h2v2.5h-2V435.2z M72.3,440.3h1.6V453h-1.6V440.3z"/>
				<path d="M83.6,453.3c-3.8,0-6.2-2.8-6.2-6.7c0-3.8,2.4-6.7,6.2-6.7c3.2,0,5.2,2,5.7,4.6h-1.7c-0.4-1.9-1.7-3.2-4-3.2
						c-2.8,0-4.6,2.2-4.6,5.3s1.8,5.3,4.6,5.3c2.4,0,3.7-1.5,4.1-3.4h1.6C88.9,451.3,86.8,453.3,83.6,453.3z"/>
				<path d="M100.1,440.2v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C95.1,441.2,97.3,440.2,100.1,440.2z"/>
				<path d="M114.1,446.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C111.6,440,114.1,442.8,114.1,446.7z
						 M103.2,446.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C105,441.4,103.2,443.6,103.2,446.7z"/>
				<path d="M117.6,440.3h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9
						l0,0v7.7h-1.6V440.3z M128.3,446.7c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1
						C126.6,451.9,128.3,449.7,128.3,446.7z"/>
				<path d="M144.4,445.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C142.7,440,144.4,442.1,144.4,445.5z"/>
				<path d="M160.2,446.7c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C157.7,440,160.2,442.8,160.2,446.7z
						 M149.3,446.7c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C151.1,441.4,149.3,443.6,149.3,446.7z"/>
				<path d="M174.7,445.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C173,440,174.7,442.1,174.7,445.5z"/>
				<path d="M178,446.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C180.3,453.3,178,450.6,178,446.7z M188.2,445.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H188.2z"/>
				<path d="M197.2,441.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C200.5,442.3,199.3,441.4,197.2,441.4z"/>
				<path d="M74.6,480.8L74.6,480.8v2.8H73v-17.8h1.6v7.7l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.8-2.4,6.7-6.1,6.7
						C77.1,483.9,75.3,482.7,74.6,480.8z M74.4,477.1v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C76.4,472,74.5,474.1,74.4,477.1z"/>
				<path d="M99.5,483.6h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L99.5,483.6L99.5,483.6z"/>
				<path d="M103.7,465.8h2v2.5h-2V465.8z M103.9,470.9h1.6v12.7h-1.6V470.9z"/>
				<path d="M113,483.8c-1.8,0-3-1.3-3-3.1v-14.9h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C114,483.7,113.4,483.8,113,483.8z"/>
				<path d="M119.8,472.3v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7V471h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L119.8,472.3L119.8,472.3z"/>
				<path d="M133.7,475.9v1.4h-7.4v-1.4H133.7z"/>
				<path d="M137.5,465.8h2v2.5h-2V465.8z M137.7,470.9h1.6v12.7h-1.6V470.9z"/>
				<path d="M154.7,476.1v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-12.7h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C153,470.6,154.7,472.7,154.7,476.1z"/>
		</g>
		<line class="st0" x1="342.2" y1="467.5" x2="205" y2="466.5"/>
</g>

<g class="rotation-svg-item" id="rotation_x5F_bluetooth">
		<g>
				<path d="M13.5,305c0,3-2.3,4.8-6.1,4.8H0V292h7.6c3.3,0,5.4,1.7,5.4,4.3c0,2.1-1.3,3.5-3.3,4.3C12,301.2,13.5,302.8,13.5,305z
						 M1.7,299.9h5.2c3,0,4.4-1.4,4.4-3.2c0-2-1.5-3.2-3.9-3.2H1.7V299.9z M11.8,304.8c0-1.8-1.4-3.5-4.5-3.5H1.7v7.1h5.5
						C9.8,308.4,11.8,307.3,11.8,304.8z"/>
				<path d="M20.6,310c-1.8,0-3-1.3-3-3.1V292h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C21.7,309.9,21.1,310,20.6,310z"/>
				<path d="M35.5,309.8h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5V297h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6v12.7L35.5,309.8L35.5,309.8z"/>
				<path d="M39,303.5c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H40.7v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9h1.8
						c-0.7,2.7-2.8,4.3-5.7,4.3C41.3,310.1,39,307.4,39,303.5z M49.2,302.5c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H49.2z"/>
				<path d="M56.8,298.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4H53c1.8,0,2.2-0.4,2.2-2V293h1.6v4.1h5.1v1.4H56.8z"/>
				<path d="M75.9,303.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C73.4,296.8,75.9,299.6,75.9,303.5z M65,303.5
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S65,300.4,65,303.5z"/>
				<path d="M90.9,303.5c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C88.4,296.8,90.9,299.6,90.9,303.5z M80,303.5
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3S80,300.4,80,303.5z"/>
				<path d="M96.9,298.5v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						h-2.7v-1.4H93c1.8,0,2.2-0.4,2.2-2V293h1.6v4.1h5.1v1.4H96.9z"/>
				<path d="M116,302.3v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7H105V292h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C114.3,296.8,116,298.9,116,302.3z"/>
				<path d="M22.6,334.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7c0-3.8,2.5-6.7,6.3-6.7C20.1,327.4,22.6,330.2,22.6,334.1z
						 M11.6,334.1c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C13.5,328.8,11.6,331,11.6,334.1z"/>
				<path d="M33.7,327.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7h1.6v3.5C28.7,328.6,30.9,327.6,33.7,327.6z"/>
				<path d="M59.8,327.7l-4.2,12.7h-1.5l-3.5-11l-3.5,11h-1.5l-4.2-12.7h1.8l3.2,10.5l3.4-10.5h1.6l3.4,10.5l3.2-10.5H59.8z"/>
				<path d="M62.1,322.6h2v2.5h-2V322.6z M62.3,327.7h1.6v12.7h-1.6V327.7z"/>
				<path d="M76.1,327.6v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6v-12.7H70v3.5C71,328.6,73.2,327.6,76.1,327.6z"/>
				<path d="M77.5,334.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H79.2v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C79.9,340.7,77.5,338,77.5,334.1z M87.7,333.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H87.7z
						"/>
				<path d="M91.9,334c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6v17.8h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C94.3,340.7,91.9,337.9,91.9,334z M93.5,334c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C95.2,328.8,93.5,331,93.5,334z"/>
				<path d="M22.5,363.5v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6v-17.8h1.6v7.9c0.8-2.1,2.5-3.1,4.5-3.1
						C20.8,358,22.5,360.1,22.5,363.5z"/>
				<path d="M25.8,364.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H27.5v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C28.1,371.3,25.8,368.6,25.8,364.7z M36,363.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H36z"
						/>
				<path d="M50.7,362.6v8.4h-1.6v-2.4H49c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2H49v-0.8
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C48.8,358,50.7,359.8,50.7,362.6z M49.1,366.1v-1.4h-2.2
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C47.2,369.9,49,368.2,49.1,366.1z"/>
				<path d="M54,364.6c0-3.8,2.4-6.6,6.1-6.6c2.1,0,4.1,1.1,4.7,2.9h0.1v-7.7h1.6V371h-1.6v-2.8l0,0c-0.7,1.9-2.7,3.1-4.8,3.1
						C56.4,371.3,54,368.5,54,364.6z M55.6,364.6c0,3,1.8,5.3,4.6,5.3c2.7,0,4.6-2.1,4.6-5.1v-0.3c0-3-2-5.1-4.6-5.1
						C57.4,359.4,55.6,361.6,55.6,364.6z"/>
				<path d="M74.8,359.4c-1.7,0-3,0.8-3,2.1c0,1.5,1.2,1.7,3.5,2.3c2.7,0.7,4.7,1.1,4.7,3.7s-2,3.8-4.8,3.8c-3.3,0-5.3-1.8-5.5-4.7
						h1.6c0.2,2.1,1.5,3.4,3.9,3.4c1.7,0,3.2-0.7,3.2-2.4c0-1.5-1.1-1.8-3.5-2.4c-2.7-0.7-4.7-1-4.7-3.5c0-2.7,2.2-3.6,4.6-3.6
						c2.9,0,4.7,1.4,5,4.3h-1.6C78.1,360.3,76.8,359.4,74.8,359.4z"/>
				<path d="M82.4,364.7c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3H84.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C84.7,371.3,82.4,368.6,82.4,364.7z M92.6,363.7c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H92.6z"/>
				<path d="M100.3,359.7v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2v-7.3
						H96v-1.4h0.5c1.8,0,2.2-0.4,2.2-2v-2.1h1.6v4.1h5.1v1.4L100.3,359.7L100.3,359.7z"/>
		</g>
		<line class="st1" x1="121.7" y1="332.8" x2="172.4" y2="332.8"/>
</g>


<g class="rotation-svg-item" id="rotation_x5F_volume">
		<g>
				<path d="M42.6,111.6l-7.1,17.8H34l-7.1-17.8h1.8l6,15.6l6-15.6C40.7,111.6,42.6,111.6,42.6,111.6z"/>
				<path d="M55.5,123.1c0,3.8-2.5,6.7-6.2,6.7c-3.8,0-6.3-2.8-6.3-6.7s2.5-6.7,6.3-6.7C53,116.4,55.5,119.2,55.5,123.1z M44.6,123.1
						c0,3,1.8,5.3,4.7,5.3c2.8,0,4.7-2.2,4.7-5.3s-1.8-5.3-4.7-5.3C46.4,117.8,44.6,120,44.6,123.1z"/>
				<path d="M62,129.6c-1.8,0-3-1.3-3-3.1v-14.9h1.6v14.7c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4v1.5
						C63,129.5,62.4,129.6,62,129.6z"/>
				<path d="M76.8,129.4h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5v-7.6h1.6v7.6c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						v-6.7h1.6L76.8,129.4L76.8,129.4z"/>
				<path d="M100.5,121.8v7.6h-1.6v-7.5c0-2.8-1.2-4.1-3.3-4.1c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-7.5c0-2.8-1.3-4.1-3.3-4.1
						c-2.6,0-3.8,1.7-3.8,4.5v7.1h-1.6v-12.7h1.6v2.3c0.7-1.8,2.1-2.6,4-2.6c2.1,0,3.7,1,4.4,2.9c0.8-2,2.4-2.9,4.4-2.9
						C98.6,116.4,100.5,118.3,100.5,121.8z"/>
				<path d="M103.8,123.1c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6v0.3h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C106.1,129.7,103.8,127,103.8,123.1z M114,122.1c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3H114
						z"/>
				<path d="M137.6,121.5h-5.3v5.5h-1.5v-5.5h-5.3V120h5.3v-5.4h1.5v5.4h5.3V121.5z"/>
				<path d="M149,111.6l-6.6,17.8h-1.6l6.6-17.8C147.4,111.6,149,111.6,149,111.6z"/>
				<path d="M159.5,121.7v1.4h-7.4v-1.4H159.5z"/>
		</g>
		<polyline class="st0" points="103.4,143.6 124.1,174.1 240.8,174.1	 "/>
</g>


<g class="rotation-svg-item" id="rotation_x5F_speak">
		<line class="st0" x1="352" y1="33.6" x2="352" y2="123.1"/>
		<g>
				<path d="M266.8,16.9c2.6,0,4.6-1.3,4.6-3.5s-1.8-2.8-5-3.6c-3.7-1-6.2-1.8-6.2-4.9s2.3-4.8,6-4.8s6.2,1.9,6.6,5.9H271
						c-0.3-3.1-2-4.4-4.7-4.4c-2.6,0-4.4,1.2-4.4,3.3c0,1.8,0.9,2.5,4.9,3.6c3.1,0.8,6.2,1.6,6.2,5c0,3-2.5,5-6.3,5
						c-4.3,0-7-2.6-7.2-6.8h1.8C261.5,15,263.6,16.9,266.8,16.9z"/>
				<path d="M277.1,5.4h1.6v2.8l0,0c0.7-1.9,2.5-3.1,4.6-3.1c3.7,0,6.1,2.8,6.1,6.7c0,3.8-2.4,6.6-6.1,6.6c-2.1,0-3.9-1.1-4.6-2.9l0,0
						v7.7h-1.6V5.4z M287.8,11.8c0-3-1.8-5.3-4.6-5.3c-2.7,0-4.6,2.1-4.6,5.1v0.3c0,3,2,5.1,4.6,5.1C286.1,17,287.8,14.8,287.8,11.8z"
						/>
				<path d="M291.9,11.8c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6V12h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C294.2,18.4,291.9,15.7,291.9,11.8z M302.1,10.8c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H302.1z"/>
				<path d="M316.8,9.7v8.4h-1.6v-2.4h-0.1c-0.6,1.3-2.2,2.6-4.8,2.6c-2.5,0-4.1-1.4-4.1-3.5c0-2.4,1.8-4.2,6.7-4.2h2.2V9.7
						c0-2-1.3-3.2-3.3-3.2s-3.3,1-3.4,2.8h-1.6c0.1-2.7,2.1-4.2,5.1-4.2C314.9,5.1,316.8,6.9,316.8,9.7z M315.2,13.2v-1.4H313
						c-3.9,0-5.1,1.2-5.1,2.9c0,1.4,1.1,2.2,2.9,2.2C313.3,17,315.1,15.3,315.2,13.2z"/>
				<path d="M326.3,11.6h-3.5v6.6h-1.6V0.3h1.6v9.8h3.4l3.8-4.7h2l-4.4,5.4l4.9,7.3h-2L326.3,11.6z"/>
				<path d="M333.7,11.8c0-3.9,2.4-6.7,6.1-6.7c3.6,0,5.8,2.8,5.8,6.6V12h-10.1v0.1c0.1,2.9,1.8,4.8,4.3,4.8c1.7,0,3.3-0.9,3.9-2.9
						h1.8c-0.7,2.7-2.8,4.3-5.7,4.3C336.1,18.4,333.7,15.7,333.7,11.8z M343.9,10.8c-0.1-2.5-1.6-4.3-4.1-4.3c-2.4,0-4,1.7-4.3,4.3
						H343.9z"/>
				<path d="M356.7,5.3v1.9c-3.9-0.3-6,1.3-6,5.4v5.6h-1.6V5.4h1.6v3.5C351.7,6.3,353.9,5.3,356.7,5.3z"/>
				<path d="M368,15.3L368,15.3v2.8h-1.6V0.3h1.6V8l0,0c0.7-1.8,2.5-2.9,4.6-2.9c3.7,0,6.1,2.8,6.1,6.6c0,3.9-2.4,6.7-6.1,6.7
						C370.5,18.4,368.7,17.2,368,15.3z M367.9,11.6v0.3c0,3,1.9,5.1,4.6,5.1c2.8,0,4.6-2.2,4.6-5.3c0-3-1.8-5.2-4.6-5.2
						C369.8,6.5,367.9,8.6,367.9,11.6z"/>
				<path d="M392.9,18.1h-1.6v-2.7c-0.9,2-2.5,3-4.6,3c-3.1,0-4.8-2.1-4.8-5.5V5.4h1.6V13c0,2.5,1.3,4,3.3,4c2.6,0,4.4-1.9,4.4-4.8
						V5.4h1.6v12.7H392.9z"/>
				<path d="M397.1,0.3h2v2.5h-2V0.3z M397.3,5.4h1.6v12.7h-1.6V5.4z"/>
				<path d="M406.4,18.3c-1.8,0-3-1.3-3-3.1V0.3h1.6V15c0,1.1,0.6,1.8,1.5,1.8c0.4,0,0.8-0.1,1.5-0.4V18
						C407.4,18.2,406.8,18.3,406.4,18.3z"/>
				<path d="M413.2,6.8v7.3c0,1.7,1,2.8,2.8,2.8c0.7,0,1.4-0.1,2.2-0.5v1.5c-0.6,0.3-1.3,0.5-2.2,0.5c-2.7,0-4.4-1.7-4.4-4.2V6.8h-2.7
						V5.4h0.5c1.8,0,2.2-0.4,2.2-2V1.3h1.6v4.1h5.1v1.4C418.3,6.8,413.2,6.8,413.2,6.8z"/>
				<path d="M427.1,10.4v1.4h-7.4v-1.4H427.1z"/>
				<path d="M430.9,0.3h2v2.5h-2V0.3z M431.1,5.4h1.6v12.7h-1.6V5.4z"/>
				<path d="M448.2,10.6v7.6h-1.6v-7.6c0-2.5-1.3-4-3.3-4c-2.6,0-4.4,1.9-4.4,4.8v6.7h-1.6V5.4h1.6v2.8c0.8-2.1,2.5-3.1,4.5-3.1
						C446.4,5.1,448.2,7.2,448.2,10.6z"/>
		</g>
</g>
</svg>',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => 10,
							'new_lines' => '',
						),
						array(
							'key' => 'field_606af783138e9',
							'label' => 'Button label',
							'name' => 'global_interactive_product_rotation_button_label',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_606af7a6138ea',
							'label' => 'Button link',
							'name' => 'global_interactive_product_rotation_button_url',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606b5f5d6c0a5' => array(
					'key' => 'layout_606b5f5d6c0a5',
					'name' => 'global_specifications',
					'label' => 'Specifications',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606b61516c0a6',
							'label' => 'Text',
							'name' => 'global_specs_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606b61756c0a7',
							'label' => 'Specification item',
							'name' => 'global_specs_item',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'wpml_cf_preferences' => 3,
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => '',
							'sub_fields' => array(
								array(
									'key' => 'field_606b61976c0a8',
									'label' => 'Icon',
									'name' => 'global_specs_item_icon',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_606b61bd6c0a9',
									'label' => 'Content',
									'name' => 'global_specs_item_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
				'layout_606b0c0f8ba17' => array(
					'key' => 'layout_606b0c0f8ba17',
					'name' => 'global_whats_in_the_box',
					'label' => 'What\'s in the box',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606b0c3f8ba18',
							'label' => 'Text',
							'name' => 'whats_in_the_box_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
						array(
							'key' => 'field_606b0c4b8ba19',
							'label' => 'Image',
							'name' => 'whats_in_the_box_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_606b0c578ba1a',
							'label' => 'Specifications',
							'name' => 'whats_in_the_box_spec',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'wpml_cf_preferences' => 3,
							'collapsed' => '',
							'min' => 0,
							'max' => 0,
							'layout' => 'table',
							'button_label' => '',
							'sub_fields' => array(
								array(
									'key' => 'field_606b0c8d8ba1b',
									'label' => 'Item',
									'name' => 'whats_in_the_box_spec_item_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_606b0cae8ba1c',
									'label' => 'Image',
									'name' => 'whats_in_the_box_spec_item_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'thumbnail',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
							),
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Row',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'section_blocks',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606cc80fa72dd',
	'title' => 'Header theme',
	'fields' => array(
		array(
			'key' => 'field_606cc823a35b8',
			'label' => 'Choose your header theme',
			'name' => 'header_theme',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'light' => 'Light style',
				'dark' => 'Dark style',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'default_value' => 'light',
			'layout' => 'vertical',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606835ad623ab',
	'title' => 'Product assets',
	'fields' => array(
		array(
			'key' => 'field_60684289c5bba',
			'label' => 'Presentation style',
			'name' => 'presentation',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'product' => 'Available in 3 colors',
				'accessories' => 'Accessories',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'default_value' => '',
			'layout' => 'vertical',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_606836bca5d30',
			'label' => 'Content',
			'name' => 'product_assets_copy_text',
			'type' => 'wysiwyg',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 1,
			'delay' => 0,
		),
		array(
			'key' => 'field_60683766a5d31',
			'label' => 'Asset items',
			'name' => 'product_assets_items',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_606837baefcc6',
					'label' => 'Image',
					'name' => 'product_assets_item_image',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_606837eaefcc7',
					'label' => 'Label',
					'name' => 'product_assets_item_label',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_60683b4c397c5',
			'label' => 'Clone: Overwrite List Price',
			'name' => 'cloned_overwrite_list_price',
			'type' => 'clone',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'clone' => array(
				0 => 'field_60646bbc6efc6',
			),
			'display' => 'seamless',
			'layout' => 'block',
			'prefix_label' => 0,
			'prefix_name' => 0,
		),
		array(
			'key' => 'field_60683820efcc8',
			'label' => 'Clone: Buttons',
			'name' => 'cloned_buttons',
			'type' => 'clone',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'clone' => array(
				0 => 'field_60646a6e66ee0',
			),
			'display' => 'seamless',
			'layout' => 'block',
			'prefix_label' => 0,
			'prefix_name' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'assets',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'the_content',
		1 => 'excerpt',
		2 => 'discussion',
		3 => 'comments',
		4 => 'revisions',
		5 => 'author',
		6 => 'format',
		7 => 'featured_image',
		8 => 'categories',
		9 => 'tags',
		10 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606469a60e305',
	'title' => 'Re-useable modules',
	'fields' => array(
		array(
			'key' => 'field_606469c2a9cc1',
			'label' => 'Section rules',
			'name' => 'reuseable_section_rules',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_606469f51d054',
					'label' => 'Styling',
					'name' => 'section_rules_styling',
					'type' => 'checkbox',
					'instructions' => 'Note: Only choose to overwrite default section behaviour',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'paddingTopEnabled' => 'Padding - top - enable',
						'paddingTopDisabled' => 'Padding - top - disable',
						'paddingBottomEnabled' => 'Padding - bottom - enable',
						'paddingBottomDisabled' => 'Padding - bottom - disable',
						'paddingSidesDisabled' => 'Padding - sides - disable',
					),
					'allow_custom' => 0,
					'default_value' => array(
					),
					'layout' => 'vertical',
					'toggle' => 0,
					'return_format' => 'value',
					'save_custom' => 0,
				),
				array(
					'key' => 'field_60646a081d055',
					'label' => 'Theme',
					'name' => 'section_rules_theme',
					'type' => 'select',
					'instructions' => 'Note: Themed sections isn\'t guaranteed to work with all content types, but is aimed at more simple text driven sections',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'default' => 'Default',
						'white' => 'White - background',
						'bluedark' => 'Blue - Dark - background',
						'bluedarkgray' => 'Blue gray - Dark - background',
						'red' => 'Red - background',
						'graylight' => 'Gray - Light - background',
					),
					'default_value' => 'default',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'array',
					'ajax' => 0,
					'placeholder' => '',
				),
			),
		),
		array(
			'key' => 'field_60646a6e66ee0',
			'label' => 'Buttons',
			'name' => 'reuseable_buttons',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_60646a7866ee1',
					'label' => 'Button - Milo Shop',
					'name' => 'button_shop_milo',
					'type' => 'true_false',
					'instructions' => 'Will display the default "Milo Shop" button.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6078445b8bf20',
					'label' => 'Button - Find Reseller',
					'name' => 'button_find_reseller',
					'type' => 'true_false',
					'instructions' => 'Will display the default "Find Reseller" button.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6078533e8bf21',
					'label' => 'Button - Show after custom buttons',
					'name' => 'button_shopreseller_show_after',
					'type' => 'true_false',
					'instructions' => 'This only applies if custom buttons are created.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_60646a8f66ee2',
					'label' => 'Button - Custom',
					'name' => 'button_custom',
					'type' => 'true_false',
					'instructions' => 'Want to add a custom button?',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_60646aa766ee3',
					'label' => 'Customs button items',
					'name' => 'button_custom_items',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_60646a8f66ee2',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'wpml_cf_preferences' => 3,
					'collapsed' => '',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => '',
					'sub_fields' => array(
						array(
							'key' => 'field_60646acb42dd5',
							'label' => 'Button title',
							'name' => 'button_custom_title',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_60646ad742dd6',
							'label' => 'Button link',
							'name' => 'button_custom_link',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_60646b53b3b9a',
			'label' => 'Background type',
			'name' => 'reuseable_background_type_imagevideo',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_60646b60b3b9b',
					'label' => 'Choose your background type',
					'name' => 'background_choice',
					'type' => 'radio',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'Image' => 'Image',
						'Video' => 'Video',
					),
					'allow_null' => 1,
					'other_choice' => 0,
					'default_value' => '',
					'layout' => 'vertical',
					'return_format' => 'value',
					'save_other_choice' => 0,
				),
				array(
					'key' => 'field_60646b7d245ae',
					'label' => 'Image background',
					'name' => 'image_background',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_60646b60b3b9b',
								'operator' => '==',
								'value' => 'Image',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_60646b9c245af',
					'label' => 'Video background',
					'name' => 'video_background',
					'type' => 'file',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_60646b60b3b9b',
								'operator' => '==',
								'value' => 'Video',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'library' => 'all',
					'min_size' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_606899c86335e',
					'label' => 'Enable dimmed overlay',
					'name' => 'background_dimmed_overlay',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_60646bbc6efc6',
			'label' => 'List price',
			'name' => 'reuseable_list_price',
			'type' => 'group',
			'instructions' => 'List price is defined in the country settings. You can overwrite it below if needed.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_60683bc5d8356',
					'label' => 'Show list price?',
					'name' => 'overwrite_list_price_showprice_bool',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_60646bce578a5',
					'label' => 'Overwrite list price?',
					'name' => 'overwrite_list_price_bool',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_60646bda578a6',
					'label' => 'Text',
					'name' => 'overwrite_list_price_text',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_60646bce578a5',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
			),
		),
		array(
			'key' => 'field_606ada53baeac',
			'label' => 'Adventure categories',
			'name' => 'reuseable_adventure_categories',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_606ada64baead',
					'label' => 'Headline',
					'name' => 'adventure_category_block_headline',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
				array(
					'key' => 'field_606ada92baeae',
					'label' => 'Item',
					'name' => 'adventure_category_block_item',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'wpml_cf_preferences' => 3,
					'collapsed' => '',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => '',
					'sub_fields' => array(
						array(
							'key' => 'field_606adaa11267e',
							'label' => 'Title',
							'name' => 'category_block_title',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_606adaaf1267f',
							'label' => 'Image',
							'name' => 'category_block_image',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'medium',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_606adaba12680',
							'label' => 'Url',
							'name' => 'category_block_url',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
						),
					),
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_template',
				'operator' => '==',
				'value' => 'templates/template-flexible-sections.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'the_content',
		1 => 'excerpt',
		2 => 'discussion',
		3 => 'comments',
		4 => 'slug',
		5 => 'author',
		6 => 'format',
		7 => 'featured_image',
		8 => 'categories',
		9 => 'tags',
		10 => 'send-trackbacks',
	),
	'active' => false,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_60688e18811ff',
	'title' => 'Statements',
	'fields' => array(
		array(
			'key' => 'field_60688e7867e1a',
			'label' => 'Title',
			'name' => 'statement_title',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_60688f32686c7',
			'label' => 'Clone: Background type',
			'name' => 'cloned_background_type',
			'type' => 'clone',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'clone' => array(
				0 => 'field_60646b53b3b9a',
			),
			'display' => 'seamless',
			'layout' => 'block',
			'prefix_label' => 0,
			'prefix_name' => 0,
		),
		array(
			'key' => 'field_60688ea667e1b',
			'label' => 'Statement slide',
			'name' => 'statement_slide',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 3,
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_60688ebf686c4',
					'label' => 'Quote',
					'name' => 'statement_quote',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 0,
					'delay' => 0,
				),
				array(
					'key' => 'field_60688efc686c5',
					'label' => 'Author',
					'name' => 'statement_author',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'statement',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_606df4b08c5e0',
	'title' => 'Theme settings',
	'fields' => array(
		array(
			'key' => 'field_607c280aa71fc',
			'label' => 'Settings',
			'name' => 'theme_settings_group',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'wpml_cf_preferences' => 1,
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_606df4d8c1f9d',
					'label' => 'Scripts - within [head]\'tag',
					'name' => 'theme_header_scripts_head',
					'type' => 'textarea',
					'instructions' => 'Paste <script> tags within the head\'tag',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_606df57ec1f9e',
					'label' => 'Scripts - after opening [body]\'tag',
					'name' => 'theme_header_scripts_body_after_opening',
					'type' => 'textarea',
					'instructions' => 'Paste scripts needed after the opening body\'tag',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_606df5c2c1f9f',
					'label' => 'Scripts - footer',
					'name' => 'theme_header_scripts_body_before_end',
					'type' => 'textarea',
					'instructions' => 'Paste scripts before the closing body\'tag. NOTE: If in any doubt, your script should be placed here.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_607c284af4cdf',
					'label' => 'Social media icons',
					'name' => 'social_media_icons',
					'type' => 'repeater',
					'instructions' => 'Icons will display in the header and footer',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'wpml_cf_preferences' => 0,
					'collapsed' => '',
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => '',
					'sub_fields' => array(
						array(
							'key' => 'field_607c285af4ce0',
							'label' => 'Name',
							'name' => 'social_media_item_name',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'wpml_cf_preferences' => 0,
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_607c2867f4ce1',
							'label' => 'Icon',
							'name' => 'social_media_item_icon',
							'type' => 'textarea',
							'instructions' => 'Needs to be HTML/XML',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
							'wpml_cf_preferences' => 0,
						),
						array(
							'key' => 'field_607c287af4ce2',
							'label' => 'Url',
							'name' => 'social_media_item_url',
							'type' => 'url',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'wpml_cf_preferences' => 0,
						),
					),
				),
				array(
					'key' => 'field_606eff05095e9',
					'label' => '404 page',
					'name' => 'theme_404',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_606f0135bbcfd',
							'label' => 'Clone: Header theme',
							'name' => 'cloned_header_theme',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606cc823a35b8',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606eff6d0ac3d',
							'label' => 'Clone: Section rules',
							'name' => 'cloned_section_rules',
							'type' => 'clone',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'clone' => array(
								0 => 'field_606469c2a9cc1',
							),
							'display' => 'seamless',
							'layout' => 'block',
							'prefix_label' => 0,
							'prefix_name' => 0,
						),
						array(
							'key' => 'field_606eff990ac3e',
							'label' => 'Text',
							'name' => 'theme_404_text',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 0,
						),
					),
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'theme-general-settings',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'permalink',
		1 => 'the_content',
		2 => 'excerpt',
		3 => 'discussion',
		4 => 'comments',
		5 => 'revisions',
		6 => 'slug',
		7 => 'author',
		8 => 'format',
		9 => 'page_attributes',
		10 => 'featured_image',
		11 => 'categories',
		12 => 'tags',
		13 => 'send-trackbacks',
	),
	'active' => true,
	'description' => '',
));

endif;