<?php
add_action('init', 'add_country_country_code_reference');
function add_country_country_code_reference(){
    if ( ! is_admin() ) {
        global $get_CurrencyCode;
        $get_CurrencyCode = "global";

        if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
            if(ICL_LANGUAGE_CODE != "en") { // en = global
                $get_CurrencyCode = ICL_LANGUAGE_CODE;
            }
        }
    }
}

add_action('init', 'session_init');
function session_init() {

    if ( ! is_admin() ) {
        if (!session_id()) {
            session_start();
            //session_destroy();
        }

        return true;
    }
}

add_action('init', 'get_country_assets');
function get_country_assets(){
    if ( ! is_admin() ) {
        global $get_CurrencyCode;

        // create some country fallback in case nothing is defined
        if($get_CurrencyCode == "" || $get_CurrencyCode == "undefined" || $get_CurrencyCode == "null") {
            $get_CurrencyCode = "global";
        }
        
        $args = array(
            'numberposts' => -1,
            'posts_per_page' => -1,
            'post_type'   => 'country',
            'post_status' => 'publish',
            'meta_query' => array(
                array(
                    'key'     => 'country_shortcode',
                    'value'   => $get_CurrencyCode,
                )
            )
        );

        // query
        $the_query = new WP_Query( $args );

        // misc variables
        $country_count = $the_query->found_posts; //query count
        
        // save assets in an object for global usage
        global $arr_country_assets;
        global $disable_prices;
        global $label_shop_milo;
        global $label_shop_milo_url;
        global $label_find_reseller;
        global $label_explore;
        global $label_copyright;
        global $label_stories;
        global $dealor_locator_disable;
        global $dealor_locator_text_intro;
        global $dealor_locators;
        global $share_info;
        global $label_country_introduction_text;
        global $label_country_footer_text;
        global $label_share_text;
        global $label_share_use_social_facebook_url;
        global $label_share_social_facebook_url;
        global $label_share_contact_url;

        $arr_country_assets = [];
        $dealor_locators = [];
        $count_up = 0;
        $count_up_dealor = 0;

        if( $the_query->have_posts() ): ?>
            <?php while( $the_query->have_posts() ) : $the_query->the_post();
                $disable_prices = get_field( 'country_disable_prices' );
                $disable_from_menu = get_field( 'country_disable_from_menu' );
                $country_shortcode = get_field( 'country_shortcode' );
                $currency_symbol = get_field( 'country_currency_symbol' );
                $currency_code = get_field( 'country_currency_code' );
                $product_list_price = get_field( 'country_product_list_price' );
                $dealor_locator_text_intro = get_field( 'country_dealor_locator_text_intro' );
                $dealor_locator_disable = get_field( 'country_dealor_locator_disable' );
    /*
                echo "disable_prices ".$disable_prices;
                echo "<br>disable_from_menu ".$disable_from_menu;
                echo "<br>country_shortcode ".$country_shortcode;
                echo "<br>currency_symbol ".$currency_symbol;
                echo "<br>currency_code ".$currency_code;
                echo "<br>product_list_label ".$product_list_label;
                echo "<br>product_list_price ".$product_list_price;
    */
                $arr_country_assets[$count_up]['country_disable_prices'] = $disable_prices;
                $arr_country_assets[$count_up]['disable_from_menu'] = $disable_from_menu;
                $arr_country_assets[$count_up]['country_shortcode'] = $country_shortcode;
                $arr_country_assets[$count_up]['currency_symbol'] = $currency_symbol;
                $arr_country_assets[$count_up]['currency_code'] = $currency_code;
                $arr_country_assets[$count_up]['product_list_price'] = $product_list_price;
                
                if ( have_rows( 'country_labels' ) ) :
                    while ( have_rows( 'country_labels' ) ) : the_row();
                        $label_product_list_price = get_sub_field( 'country_label_product_list' );
                        $label_shop_milo = get_sub_field( 'country_label_shop_milo' );
                        $label_shop_milo_url = get_sub_field( 'country_label_shop_milo_url' );
                        $label_find_reseller = get_sub_field( 'country_label_find_reseller' );
                        $label_stories = get_sub_field( 'country_label_stories' );
                        $label_explore = get_sub_field( 'country_label_explore' );
                        $label_copyright = get_sub_field( 'country_label_copyright' );
                        $label_country_introduction_text = get_sub_field( 'country_introduction' );
                        $label_country_footer_text = get_sub_field( 'country_location_not_listed' );

                        $arr_country_assets[$count_up]['label_product_list_price'] = $label_product_list_price;
                        $arr_country_assets[$count_up]['label_shop_milo'] = $label_shop_milo;
                        $arr_country_assets[$count_up]['label_shop_milo_url'] = $label_shop_milo_url;
                        $arr_country_assets[$count_up]['label_find_reseller'] = $label_find_reseller;
                        $arr_country_assets[$count_up]['label_stories'] = $label_stories;
                        $arr_country_assets[$count_up]['label_explore'] = $label_explore;
                        $arr_country_assets[$count_up]['label_copyright'] = $label_copyright;
                        $arr_country_assets[$count_up]['label_country_introduction_text'] = $label_country_introduction_text;
                        $arr_country_assets[$count_up]['label_country_footer_text'] = $label_country_footer_text;

                        if ( have_rows( 'country_share_milo' ) ) :
                            while ( have_rows( 'country_share_milo' ) ) : the_row();
                                $label_share_text = get_sub_field( 'country_share_milo_text' );
                                $label_share_use_social_facebook_url = get_sub_field( 'country_share_use_facebook_url' );
                                $label_share_social_facebook_url = get_sub_field( 'country_share_milo_facebook_url' );

                                $country_share_milo_contact = get_sub_field( 'country_share_milo_contact' );
                                if ( $country_share_milo_contact ) :
                                    $label_share_contact_url = esc_url( $country_share_milo_contact['url'] );
                                endif;

                                // save to country object
                                $arr_country_assets[$count_up]['label_share_text'] = $label_share_text;
                                $arr_country_assets[$count_up]['label_share_use_social_facebook_url'] = $label_share_use_social_facebook_url;
                                $arr_country_assets[$count_up]['label_share_social_facebook_url'] = $label_share_social_facebook_url;
                                $arr_country_assets[$count_up]['label_share_contact_url'] = $label_share_contact_url;
                            endwhile;
                        endif;
                    endwhile;
                endif;

                $arr_country_assets[$count_up]['dealor_text_intro'] = $dealor_locator_text_intro;
                $arr_country_assets[$count_up]['dealor_locator_disable'] = $dealor_locator_disable;

                if ( have_rows( 'country_dealor_locator' ) ) :
                    while ( have_rows( 'country_dealor_locator' ) ) : the_row();
                        $dealor_name = get_sub_field( 'country_dealor_name' );
                        $country_dealor_logo = get_sub_field( 'country_dealor_logo' );
                        $country_dealor_logo_src = esc_url( $country_dealor_logo['url'] );
                        $country_dealor_logo_url = get_sub_field( 'country_dealor_url' );

                        $dealor_locators[$count_up_dealor]['dealor_name'] = $dealor_name;
                        $dealor_locators[$count_up_dealor]['dealor_logo_src'] = $country_dealor_logo_src;
                        $dealor_locators[$count_up_dealor]['dealor_logo_url'] = $country_dealor_logo_url;
                        $dealor_locators[$count_up_dealor]['dealor_logo'] = $country_dealor_logo;

                        $count_up_dealor++;
                    endwhile;
                    //var_dump($dealor_locators);
                endif;

                if ( have_rows( 'country_announcement_bar' ) ) :
                    while ( have_rows( 'country_announcement_bar' ) ) : the_row();
                        $arr_country_assets[$count_up]['announcement_bar'][] = get_sub_field( 'country_announcement_bar_item' );
                    endwhile;
                else :
                    $arr_country_assets[$count_up]['announcement_bar'][] = "";
                endif;

                // concatenate list price
                $arr_country_assets[$count_up]['product_list_price_grouped'] = $label_product_list_price." ".$currency_symbol.$product_list_price;

                $count_up++;
            endwhile;

            //var_dump($arr_country_assets);

            // add custom body class
            add_filter( 'body_class','my_custom_body_classes' );
        endif;
        wp_reset_postdata(); wp_reset_query(); // Restore global post data stomped by the_post().
    }
}

function get_session_var() {
    if ( ! is_admin() ) {
        global $get_CurrencyCode;
        $sessions_countrycode;

        function setSessionVars() {
            global $arr_country_assets;
            $_SESSION['uid'] = session_id();
            $_SESSION['countrycode'] = $arr_country_assets[0]['country_shortcode'];
            $_SESSION['country_assets'] = $arr_country_assets;
        }

        if(session_id() && isset($_SESSION['uid'])) {
      
            //echo "Session - ALREADY SET";
            $sessions_countrycode = $_SESSION['country_assets'][0]['country_shortcode'];

            // if session is active and country code changed, then reset everything
            if($get_CurrencyCode != $sessions_countrycode) {
                //echo "SESSION - RESET - COUNTRY CODE CHANGED";

                // re-instantiate session object
                session_destroy();
                session_init();

                // re-fresh session vars
                setSessionVars();
            }
        } else {
            //echo "Session - NOONE - set it for the first time";
            setSessionVars();
        }

        //var_dump($_SESSION);
    }
}
add_action('init', 'get_session_var');

function themeSettingsHead() {
    if ( have_rows( 'theme_settings_group', 'option' ) ) :
        while ( have_rows( 'theme_settings_group', 'option' ) ) : the_row();
            the_sub_field( 'theme_header_scripts_head', 'option' );
        endwhile;
    endif;
}
add_action('wp_head', 'themeSettingsHead');

function themeSettingsAfterBodyOpening() {
    if ( have_rows( 'theme_settings_group', 'option' ) ) :
        while ( have_rows( 'theme_settings_group', 'option' ) ) : the_row();
            the_sub_field( 'theme_header_scripts_body_after_opening', 'option' );
        endwhile;
    endif;
}
add_action('wp_body_open', 'themeSettingsAfterBodyOpening', 1);

function themeSettingsFooter() {
    if ( have_rows( 'theme_settings_group', 'option' ) ) :
        while ( have_rows( 'theme_settings_group', 'option' ) ) : the_row();
            the_sub_field( 'theme_header_scripts_body_before_end', 'option' );
        endwhile;
    endif;
}
add_action('wp_footer', 'themeSettingsFooter', 100);

function my_custom_body_classes( $classes ) {
    global $disable_prices;

    if($disable_prices == 1) :
         $classes[] = "no-prices";
    endif;

    return $classes;
}

function my_acf_admin_head() {
    ?>
<style type="text/css">

    .acf-flexible-content .layout .acf-fc-layout-handle {
        background-color: #f1f1f1;
        border-style: solid;
        border-width: 1px;
        border-color: #d3d3d3;
        padding: 20px;
    }
    
    .acf-repeater .acf-row-handle span{
        font-weight: normal;
        margin-top: 50%;
        font-size: 16px;
        display: block;
        position: relative;
    }
    
    .acf-flexible-content .layout{
        border: none;
    }
    
    .hndle.ui-sortable-handle{
        background-color: #f1f1f1;
        margin: 0 0 20px 0;
        border-style: solid;
        border-width: 1px;
        border-color: #d3d3d3;
    }
    
    .ui-sortable .acf-fields > .acf-field{
        border-top: none;
        transition:all 0.5s;
        padding: 20px;
    }
    
     .ui-sortable .acf-fields > .acf-field:hover{
        -webkit-box-shadow:inset 0 0 10px 0 #ccc;
        box-shadow:inset 0 0 10px 0 #ccc;
     }
    
    .acf-actions{
        padding: 10px;
    }
    
    .hndle.ui-sortable-handle span{
        color: #000;
    }

    .acf-repeater.-row > table > tbody > tr > td,
    .acf-repeater.-block > table > tbody > tr > td {
        border-top: 1px solid #ccc;
    }

    .acf-repeater .acf-row-handle {
        vertical-align: top !important;
        padding-top: 16px;
    }

    .acf-repeater .acf-row-handle span {
        font-size: 20px;
        font-weight: bold;
        color: #202428;
    }

    .imageUpload img {
        width: 75px;
    }

    .acf-repeater .acf-row-handle .acf-icon.-minus {
        top: 30px;
    }
    
    .edit-post-meta-boxes-area .postbox{
        display: block;
        position: relative;
        clear: both;
        margin: 0 0 20px 0;
    }
    
    .acf-fields > .acf-field{
        border-style: solid;
        border-width: 1px;
        border-color: #d3d3d3;
    }
    
    
    .acf-postbox > .hndle .acf-hndle-cog {
        color: #000 !important;
    }
    
    .edit-post-meta-boxes-area .postbox>.inside{
        border-bottom: none;
    }

    /* SGS */
    .acf-field .acf-input .values .acf-fields .acf-field .acf-label {
        font-size: 18px;
        color: #000000;
    }

    .acf-field div.values {
        opacity: 0.8;
    }

</style>

    <?php
}

add_action('acf/input/admin_head', 'my_acf_admin_head');