<?php

define('ASSETS_URL', get_template_directory_uri() . '/assets');

if( function_exists('acf_add_options_page') ) {
    
    acf_add_options_page(array(
        'page_title'    => 'Theme General Settings',
        'menu_title'    => 'Theme Settings',
        'menu_slug'     => 'theme-general-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));
/*    
    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Header Settings',
        'menu_title'    => 'Header',
        'parent_slug'   => 'theme-general-settings',
    ));
    
    acf_add_options_sub_page(array(
        'page_title'    => 'Theme Footer Settings',
        'menu_title'    => 'Footer',
        'parent_slug'   => 'theme-general-settings',
    ));
*/
}

function override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
} add_filter('tiny_mce_before_init', 'override_mce_options');

// Add featured image on blog posts
add_theme_support( 'post-thumbnails' );

// Add custom logo
add_theme_support( 'custom-logo', array(
    'height'      => 100,
    'width'       => 400,
    'flex-height' => true,
    'flex-width'  => true,
    'header-text' => array( 'site-title', 'site-description' ),
) );

function theme_customizer_setting($wp_customize) {
// add a setting 
    $wp_customize->add_setting('theme_logo_footer');
// Add a control to upload the hover logo
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'theme_logo_footer', array(
        'label' => 'Logo - Footer',
        'section' => 'title_tagline', //this is the section where the custom-logo from WordPress is
        'settings' => 'theme_logo_footer',
        'priority' => 8 // show it just below the custom-logo
    )));
}

add_action('customize_register', 'theme_customizer_setting');

/* setup and register menu */
add_action('after_setup_theme', function () {
    // Register Menus
    register_nav_menus(
        array(
            'header-menu' => esc_html__('Header Menu', 'milo'),
            'footer-menu' => esc_html__('Footer Menu', 'milo')
        )
    );
});

/**
 * Allow new file type upload in media library
 */
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
  global $wp_version;
  if ( $wp_version !== '4.7.1' ) {
     return $data;
  }

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext'             => $filetype['ext'],
      'type'            => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function cc_mime_types( $mimes ){
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'cc_mime_types' );

add_action( 'wp_body_open', function() {
    ?>
    <svg class="svg-sprite" xmlns="http://www.w3.org/2000/svg" style="display: none;">  
        <symbol id="icon-logo" viewBox="0 0 598.2 242.8">
            <g id="milo_logo_Equinox">
                <path class="st0" d="M276.2,0c-15.5,0-28.1,12.6-28.1,28.1c0,15.5,12.6,28.1,28.1,28.1s28.1-12.6,28.1-28.1c0,0,0,0,0,0

                C304.3,12.6,291.8,0,276.2,0z" />
                <path class="st0" d="M155.4,91.1V238c0,1.5,1.3,2.8,2.8,2.8c0,0,0,0,0,0h42.7c1.5,0,2.8-1.2,2.8-2.8c0,0,0,0,0,0V97.4

                c0-6.6-5.3-11.9-11.9-11.9H161C157.9,85.5,155.4,88,155.4,91.1C155.4,91.1,155.4,91.1,155.4,91.1z" />
                <path class="st0" d="M0,97.4V238c0,1.5,1.3,2.8,2.8,2.8c0,0,0,0,0,0h42.7c1.5,0,2.8-1.2,2.8-2.8c0,0,0,0,0,0V91.1

                c0-3.1-2.5-5.6-5.6-5.6c0,0,0,0,0,0H11.9C5.3,85.5,0,90.8,0,97.4z" />
                <path class="st0" d="M126,153.2V91.1c0-3.1-2.5-5.6-5.6-5.6H83.3c-3.1,0-5.6,2.5-5.6,5.6v62.1c0,6.5,5.2,11.8,11.7,11.8

                c0,0,0,0,0.1,0h24.9C120.8,165,126,159.7,126,153.2C126,153.2,126,153.2,126,153.2z" />
                <path class="st0" d="M252.1,97.4V238c0,1.5,1.3,2.8,2.8,2.8c0,0,0,0,0,0h42.7c1.5,0,2.8-1.2,2.8-2.8c0,0,0,0,0,0V97.4

                c0-6.6-5.3-11.9-11.9-11.9l0,0H264C257.4,85.5,252.1,90.8,252.1,97.4z" />
                <path class="st0" d="M348.8,17.9V238c0,1.5,1.3,2.8,2.8,2.8c0,0,0,0,0,0h42.7c1.5,0,2.8-1.2,2.8-2.8c0,0,0,0,0,0V17.9

                c0-6.6-5.4-11.9-11.9-11.9h-24.5C354.1,6,348.8,11.3,348.8,17.9z" />
                <path class="st0" d="M518.6,83.5c-44,0-79.6,35.7-79.6,79.6s35.7,79.6,79.6,79.6s79.6-35.7,79.6-79.6

                C598.2,119.2,562.5,83.6,518.6,83.5z M555.2,163.1c0,20.2-16.4,36.6-36.6,36.6S482,183.4,482,163.1s16.4-36.6,36.6-36.6

                C538.8,126.6,555.1,143,555.2,163.1L555.2,163.1z" />
                <path class="st0" d="M609.6,105.9l-3.2-5.6h-3.9v5.6h-1.1V94h5.3c2.1,0,3.6,1.3,3.6,3.1c0,1.6-1.2,3-2.8,3.1l3.4,5.7L609.6,105.9

                z M602.6,99.3h4.2c1.3,0.1,2.3-0.9,2.4-2.1c0-0.1,0-0.1,0-0.2c0-1.2-1.1-2.2-2.3-2.1c-0.1,0-0.1,0-0.2,0h-4.2L602.6,99.3z" />
                <path class="st0" d="M605.4,111.5c-6.4,0-11.6-5.2-11.6-11.6c0-6.4,5.2-11.6,11.6-11.6c6.4,0,11.6,5.2,11.6,11.6c0,0,0,0,0,0

                C617,106.3,611.8,111.5,605.4,111.5z M605.4,89.3c-5.9,0-10.6,4.7-10.6,10.6c0,5.9,4.7,10.6,10.6,10.6c5.9,0,10.6-4.7,10.6-10.6

                c0,0,0,0,0,0C616,94.1,611.3,89.3,605.4,89.3z" />
            </g>
        </symbol>
        <symbol id="icon-menu" viewBox="0 0 448 512">
            <path d="M442 114H6a6 6 0 0 1-6-6V84a6 6 0 0 1 6-6h436a6 6 0 0 1 6 6v24a6 6 0 0 1-6 6zm0 160H6a6 6 0 0 1-6-6v-24a6 6 0 0 1 6-6h436a6 6 0 0 1 6 6v24a6 6 0 0 1-6 6zm0 160H6a6 6 0 0 1-6-6v-24a6 6 0 0 1 6-6h436a6 6 0 0 1 6 6v24a6 6 0 0 1-6 6z" />
        </symbol>
        <symbol id="icon-search" viewBox="0 0 512 512">
            <path d="M508.5 481.6l-129-129c-2.3-2.3-5.3-3.5-8.5-3.5h-10.3C395 312 416 262.5 416 208 416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c54.5 0 104-21 141.1-55.2V371c0 3.2 1.3 6.2 3.5 8.5l129 129c4.7 4.7 12.3 4.7 17 0l9.9-9.9c4.7-4.7 4.7-12.3 0-17zM208 384c-97.3 0-176-78.7-176-176S110.7 32 208 32s176 78.7 176 176-78.7 176-176 176z" />
        </symbol>
        <symbol id="icon-instagram" viewBox="0 0 448 512">
            <path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z" />
        </symbol>
        <symbol id="icon-facebook" viewBox="0 0 512 512">
            <path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z" />
        </symbol>
        <symbol id="icon-youtube" viewBox="0 0 576 512">
            <path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"></path>
        </symbol>
        <symbol id="icon-vimeo" viewBox="0 0 576 512">
            <path d="M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z" />
        </symbol>
        <symbol id="icon-cart" viewBox="0 0 266.7 300">
            <path d="M266.4 287.7h.2l-22.2-200h-.2c-.6-5.5-5.2-9.9-10.9-9.9h-22.2c0-42.9-34.9-77.8-77.8-77.8S55.6 34.9 55.6 77.8H33.3c-5.7 0-10.2 4.4-10.9 9.9h-.2L0 287.7h.2c0 .4-.2.8-.2 1.2C0 295 5 300 11.1 300h244.4c6.1 0 11.1-5 11.1-11.1.1-.4-.1-.8-.2-1.2M133.3 22.2c30.6 0 55.6 24.9 55.6 55.6H77.8c0-30.7 24.9-55.6 55.5-55.6M23.5 277.8L43.3 100h180.1l19.8 177.8H23.5z" />
        </symbol>
        <symbol id="icon-globe" viewBox="0 0 365.1 365.1">
            <path d="M182.6 0C81.7 0 0 81.7 0 182.6c0 100.8 81.7 182.6 182.6 182.6 100.8 0 182.6-81.7 182.6-182.6C365.1 81.7 283.4 0 182.6 0m74.2 255.3c-1.1 2.8-2.4 5.4-3.7 8.1-20.2-4.5-40.8-7-61.5-7.7v-73.1h78.1c.3 36.9-9.9 65.2-12.9 72.7m-148.7 0c-3-7.5-13.1-35.8-13-72.7h78.3v73.1c-20.8.5-41.5 3-61.8 7.4-1.2-2.6-2.5-5.2-3.5-7.8m-28.9-89.4H17.5c3.2-31.9 15.6-61 34.3-85 14.8 6.8 30.1 12.5 45.6 16.8-2.1 4.4-4.1 8.8-5.8 13.3-7.4 19-11 37.6-12.4 54.9m27.9-48.9a171 171 0 0 1 6.7-15.2c19.6 4.4 39.6 6.8 59.6 7.4v56.7H95.8c1.4-15.5 4.8-32 11.3-48.9m84.6-83.2c20 13.7 36.9 31.1 49.8 51.3-16.4 3.4-33.1 5.3-49.8 5.9V33.8zm-18.3-.1V91c-16.8-.5-33.5-2.5-50.1-5.8 13-20.3 30-37.8 50.1-51.5m0 240.2v62.6c-21.6-14.8-39.7-34.1-53-56.5 17.5-3.6 35.2-5.6 53-6.1m18.3.1c17.7.6 35.3 2.7 52.7 6.3-13.2 22.2-31.2 41.3-52.7 56.1V274zm0-108.1v-56.7c20-.6 39.8-3 59.4-7.4 2.5 5 4.7 10 6.7 15.2 6.5 16.9 9.9 33.4 11.3 48.9h-77.4zm81.7-54.9c-1.8-4.6-3.8-9-5.9-13.4 15.6-4.4 30.9-10.1 45.7-16.9 18.8 24 31.2 53.2 34.4 85.2h-61.8c-1.5-17.3-5.1-35.9-12.4-54.9m27.2-44.8c-13.7 6.1-27.7 11-42 14.8-15.3-25.4-36.2-47.2-61.3-63.6C237.6 21 273.8 39 300.6 66.2M167.5 17.4c-25.1 16.4-46.1 38.2-61.3 63.7C92 77.3 78 72.4 64.3 66.4c26.8-27.3 63-45.3 103.2-49m-89 165.2c-.1 40.1 10.9 70.8 14.1 78.9.8 1.9 1.7 3.8 2.6 5.7-15.1 4.2-29.9 9.4-44.3 15.8-21.3-27.9-34.2-62.7-34.2-100.4h61.8zm-15.2 115c13.1-5.6 26.5-10.1 40.2-13.7 13.7 24.6 32.6 45.9 55.4 62.6-37.3-5.3-70.6-23-95.6-48.9m142.6 49c22.7-16.6 41.5-37.9 55.2-62.3 13.6 3.7 27 8.3 40.1 13.9-24.9 25.6-58.1 43.1-95.3 48.4m107.9-63c-14.4-6.4-29.2-11.8-44.3-16 .9-2 1.9-4 2.7-6 3.3-8.1 14.3-38.8 14.1-78.9h62c.1 37.9-12.9 72.9-34.5 100.9" />
        </symbol>
        <symbol id="icon-play" viewBox="0 0 221 244.4">
            <path fill="#FF0046" d="M192 122.2L110.5 168.8 29 215.4 29 122.2 29 29 110.5 75.6z" />
            <path fill="none" stroke="#FF0046" stroke-width="58" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M192 122.2L110.5 168.8 29 215.4 29 122.2 29 29 110.5 75.6z" />
        </symbol>
        <symbol id="icon-mail" viewBox="0 0 1051 1024">
            <path d="M512 0C229.2 0 0 229.2 0 512s229.2 512 512 512 512-229.2 512-512S794.8 0 512 0m275.6 676.6c0 7.4-6 13.4-13.4 13.4H249.9c-7.4 0-13.4-6-13.4-13.4V352.7c0-7.4 6-13.4 13.4-13.4h524.3c7.4 0 13.4 6 13.4 13.4v323.9z" />
            <path fill="none" stroke-width="26" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M215 334L512 562.9 809 334" />
        </symbol>
        <symbol id="icon-close" viewBox="0 0 320 512">
            <path d="M193.94 256L296.5 153.44l21.15-21.15c3.12-3.12 3.12-8.19 0-11.31l-22.63-22.63c-3.12-3.12-8.19-3.12-11.31 0L160 222.06 36.29 98.34c-3.12-3.12-8.19-3.12-11.31 0L2.34 120.97c-3.12 3.12-3.12 8.19 0 11.31L126.06 256 2.34 379.71c-3.12 3.12-3.12 8.19 0 11.31l22.63 22.63c3.12 3.12 8.19 3.12 11.31 0L160 289.94 262.56 392.5l21.15 21.15c3.12 3.12 8.19 3.12 11.31 0l22.63-22.63c3.12-3.12 3.12-8.19 0-11.31L193.94 256z" />
        </symbol>
        <symbol id="icon-check" viewBox="0 0 448 512">
            <path d="M413.505 91.951L133.49 371.966l-98.995-98.995c-4.686-4.686-12.284-4.686-16.971 0L6.211 284.284c-4.686 4.686-4.686 12.284 0 16.971l118.794 118.794c4.686 4.686 12.284 4.686 16.971 0l299.813-299.813c4.686-4.686 4.686-12.284 0-16.971l-11.314-11.314c-4.686-4.686-12.284-4.686-16.97 0z" />
        </symbol>
        <symbol id="icon-arrow" viewBox="0 0 320 512">
            <path d="M443.5 162.6l-7.1-7.1c-4.7-4.7-12.3-4.7-17 0L224 351 28.5 155.5c-4.7-4.7-12.3-4.7-17 0l-7.1 7.1c-4.7 4.7-4.7 12.3 0 17l211 211.1c4.7 4.7 12.3 4.7 17 0l211-211.1c4.8-4.7 4.8-12.3.1-17z" />
        </symbol>
        <symbol id="icon-australia" viewBox="0 0 95 63.5">
            <path fill="#0037A6" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M19.1 18.8H28.6V31.8H19.1z" />
            <path fill="#FFFFFF" d="M0.2 31.7L5.4 31.7 23.4 18.9 18.2 15.2 0.2 28z" />
            <path fill="#E60026" d="M3.7 31.7L19.1 20.7 15.6 20.7 0.2 31.7z" />
            <path fill="#FFFFFF" d="M42.3 31.7L47.5 31.7 47.5 28 29.6 15.2 24.4 18.9z" />
            <path fill="#E60026" d="M47.5 31.7L47.5 29.3 35.5 20.7 32.1 20.7z" />
            <path fill="#FFFFFF" d="M47.5 0.2L42.3 0.2 24.4 13.1 29.5 16.8 47.5 3.9z" />
            <path fill="#E60026" d="M44 0.2L28.6 11.3 32.1 11.3 47.5 0.2z" />
            <path fill="#FFFFFF" d="M5.4 0.2L0.2 0.2 0.2 3.9 18.2 16.8 23.3 13.1z" />
            <path fill="#FFFFFF" d="M0.2 11.3H19.4V20.8H0.2z" />
            <path fill="#FFFFFF" d="M19.1 0.2H28.6V13.1H19.1z" />
            <path fill="#E60026" d="M0.2 0.2L0.2 2.7 12.2 11.2 15.6 11.2z" />
            <path fill="#FFFFFF" d="M28.2 11.3H47.5V20.8H28.2z" />
            <path fill="#E60026" d="M26.7 13.2L26.7 0.2 21 0.2 21 13.1 0.2 13.1 0.2 18.8 21 18.8 21 18.8 21 18.8 21 31.8 26.7 31.8 26.7 18.8 47.5 18.8 47.5 13.2z" />
            <path fill="#FFFFFF" d="M23.9 38L25.7 43.7 31.2 41.6 28 46.6 33.1 49.6 27.1 50.1 28 56 23.9 51.7 19.8 56 20.6 50.1 14.6 49.6 19.8 46.6 16.5 41.6 22 43.7z" />
            <path fill="#FFFFFF" d="M72 48.2L72.9 51 75.5 50 74 52.3 76.4 53.8 73.6 54 74 56.8 72 54.8 70.1 56.8 70.4 54 67.6 53.8 70.1 52.3 68.5 50 71.2 51z" />
            <path fill="#FFFFFF" d="M56.3 23.3L57.1 26 59.8 25 58.2 27.4 60.7 28.8 57.8 29 58.2 31.9 56.3 29.8 54.3 31.9 54.7 29 51.9 28.8 54.3 27.4 52.7 25 55.4 26z" />
            <path fill="#FFFFFF" d="M72 6.2L72.9 8.9 75.5 7.9 74 10.3 76.4 11.7 73.6 12 74 14.8 72 12.7 70.1 14.8 70.4 12 67.6 11.7 70.1 10.3 68.5 7.9 71.2 8.9z" />
            <path fill="#FFFFFF" d="M86 19.1L86.9 21.8 89.5 20.8 88 23.2 90.4 24.6 87.6 24.9 88 27.7 86 25.6 84.1 27.7 84.5 24.9 81.6 24.6 84.1 23.2 82.5 20.8 85.2 21.8z" />
            <path fill="#FFFFFF" d="M78.3 31.8L79 33.4 80.8 33.6 79.4 34.7 79.9 36.5 78.3 35.5 76.8 36.5 77.2 34.7 75.8 33.6 77.6 33.4z" />
        </symbol>
        <symbol id="icon-austria" viewBox="0 0 95 63.5">
            <path fill="#FF0005" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M0 21.2H95V42.2H0z" />
        </symbol>
        <symbol id="icon-canada" viewBox="0 0 95 63.5">
            <path fill="#FF0000" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M23.9 0H71.19999999999999V63.5H23.9z" />
            <path d="M29.3 30.9l-2 1 9.7 8c.4.3.6.8.4 1.3l-.8 2.8c3.3-.4 6.3-1 9.7-1.3.3 0 .8.5.8.8l-.4 10.3h1.6L48 43.5c0-.3.4-.9.7-.8 3.3.4 6.3 1 9.7 1.3l-.8-2.8c-.1-.5 0-1 .4-1.3l9.7-8-2-1c-.9-.3-.6-.8-.3-2l1.5-5.4-5.7 1.2c-.4.1-.9-.2-1-.6l-.7-2.5-4.5 5c-.6.8-1.9.8-1.5-1.1l1.9-10.2-2.5 1.3c-.7.4-1.4.5-1.8-.2l-3.5-6.6-3.6 6.6c-.4.7-1.1.7-1.8.2l-2.6-1.3 1.9 10.2c.4 1.9-.9 1.9-1.5 1.1l-4.5-5-.7 2.5c-.1.4-.6.7-1 .6l-5.6-1.2 1.5 5.4c.2 1.2.5 1.7-.4 2z" fill="#FF0000" />
        </symbol>
        <symbol id="icon-denmark" viewBox="0 0 95 63.5">
            <path fill="#FF0005" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M27.4 0H36.099999999999994V63.5H27.4z" />
            <path fill="#FFFFFF" d="M0 27.4H95V36.099999999999994H0z" />
        </symbol>
        <symbol id="icon-france" viewBox="0 0 95 63.5">
            <path fill="#FF0005" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M0.2 0H63.2V63.5H0.2z" />
            <path fill="#004AAF" d="M0 0H31.8V63.5H0z" />
        </symbol>
        <symbol id="icon-germany" viewBox="0 0 95 63.5">
            <path fill="#050807" d="M0 0H95V63.3H0z" />
            <path fill="#FF0005" d="M0 21.1H95V63.300000000000004H0z" />
            <path fill="#FFDC00" d="M0 42.2H95V63.300000000000004H0z" />
        </symbol>
        <symbol id="icon-italy" viewBox="0 0 95 63.5">
            <path fill="#199900" d="M0 0H31.7V63.3H0z" />
            <path fill="#FF0000" d="M63.3 0H95V63.3H63.3z" />
            <path fill="#FFFFFF" d="M31.7 0H63.4V63.3H31.7z" />
        </symbol>
        <symbol id="icon-mexico" viewBox="0 0 95 63.5">
            <path fill="#FFFFFF" d="M0 0H95V63.5H0z" />
            <path fill="#00804B" d="M0 0H31.8V63.5H0z" />
            <path fill="#E6001B" d="M63.3 0H95V63.5H63.3z" />
            <path d="M41.6 24.5h-1.1c-.5-.1-.4-1.2-.4-1.3s-.3-.3-.2-.6.9-1 1-1h.2s.2-.2.3-.2.2.1.1.2-.3.2-.3.4c0 .1 0 .3-.1.4-.1.1-.2.3-.3.4 0 .1-.1.2 0 .2.2 0 .4 0 .6-.1.1-.1.3-.2.4-.2 0 0-.1.3-.4.4s-.4.2-.6.2-.1.4.3.4c.2 0 .5 0 .7-.1l-.2.9zM39 27.3c.2.1.3.3.3.5 0 .4-.4.7-.4 1.4s.1.7 1 1.4c.1.1.2.3.3.4.1.2.2 1.5 1.1 1.5s1-.5 1-.5l-.3-.5c-.2 0-.3.1-.5 0-.2 0-.3-.2-.4-.4l-.3-.9c-.4-.5-1-.6-1-1.2s.4-.6.3-1.3-.9-1-.9-1l-.3-.1-.1.7h.2z" fill="#A6AC56" />
            <path d="M41.4 22.5c.3-.1.1-.8.1-.8l-.2.2c.1.1.1.2.1.3.1.1.1.2 0 .3z" fill="#F1A720" />
            <path d="M42 30.1l-.2-.1c-.1-.1-.6-.4-.5-1.5s1.9-1.9 2-2.4.5-.8-.9-1.9l-.3.4.6.4s.1-.1.1.1-.2.3-.2.4c-.3.3-.6.6-1 .8-.1.1-.5.4-.5.4-.2.2-.3.5-.5.7-.1.4-.2.7-.1 1.1.1.9.7 1.5 1.5 1.6z" fill="#A6AC56" />
            <path d="M41.1 30.8l.1.5-.3.1h-.2l-.2.2v-.1-.3l.3.1h.2l.1-.3v-.2zm-.9.1l-.1-.2s-.1-.1-.2-.1l.2-.1h.2v.2l-.1.2zm.5-.8c.1 0 .1.1.2.2l.1.2h-.3l-.3-.1.2-.2.1-.1zm-.1 2.1s-.1-.1-.1-.2-.1-.2-.1-.3h.2l.3.1h.1l-.1.2-.3.2z" fill="#6A7311" />
            <path d="M41.5 31.5s-.2-.1-.2-.2-.1-.1-.1-.1l-.1.3-.1.3h.2c.1 0 .1-.1.2-.2l.1-.1zm-.9.8l.2.1c.1 0 .1.1.2.1l.1-.1.1-.2h-.5l-.1.1z" fill="#6A7311" />
            <path d="M41.4 32.1l.5-.3v-.2l-.1-.1H41.5l-.1.3v.3zm-.3.4c.3.1.6.1.9-.1.2-.1.3-.2.3-.2H42l-.2.2-.7.1zm-.4-3.5c0-.1-.1-.2-.1-.2v-.2l.2.1.2.2-.2.1h-.1zm.3.7s-.1-.1-.1-.2-.1-.1-.1-.2h.2l.2.1-.2.3z" fill="#6A7311" />
            <path d="M40 22.5c0 .1-.1.3.1.3s.4 0 .8-.4c.1-.1.1-.3.1-.4l.1-.2c-.1-.1-.3-.1-.4 0-.2.1-.5.4-.7.7z" fill="#C6C7A6" />
            <path d="M41 21.8s.1 0 0 0c.1.1 0 .1 0 .1s-.1 0 0-.1c-.1 0 0 0 0 0z" fill="#1C242F" />
            <path d="M40.6 21.9l-.3.3c.2-.1.3-.1.5-.3.1-.1.3-.1.5-.1.1 0 0-.1 0-.1-.1-.1-.2-.1-.3 0-.1 0-.3.1-.4.2z" fill="#A6AC56" />
            <path d="M41.3 28.9v-.2-.2l-.2.1-.1.2.3.1zm-.8-.4v-.4c0-.2 0-.4.1-.5l.1.2.3.4.1.1-.2.2h-.4zm1-.6z" fill="#6A7311" />
            <path d="M41.3 28.4v-.2c0-.1.1-.1.1-.2-.1.1-.2.1-.2.2l-.1.1.1.1h.1zm-.6-1.1c0-.1.1-.2.2-.3l.2-.3.1.4.1.4v.1h-.1s-.3 0-.3-.1l-.2-.2zm.8.5l.2-.1.2-.2-.5.1.1.2zm-.3-1.1c.1 0 .1-.1.2-.2l.2-.1.1.6-.3-.1-.2-.2z" fill="#6A7311" />
            <path fill="#6A7311" d="M41.9 27.5L41.9 27.5 42.2 27.1 41.7 27 41.8 27.4z" />
            <path d="M42.1 26.6V26c-.1.1-.2.1-.2.2-.1.1-.1.1-.2.1l.1.1.2.1.1.1zm.5-.6v-.5c0 .1-.1.1-.2.2l-.1.1.2.1.1.1zm.2.6l.3-.2.3-.3h-.7v.3l.1.2z" fill="#6A7311" />
            <path fill="#6A7311" d="M41.2 24.1L41.1 24.2 41.1 24.6 41.1 24.6 41.7 24.6 41.6 24.4 41.4 24.2z" />
            <path d="M42.3 27l.3-.2.2-.2-.6-.1v.5h.1zm1.1-1c0-.1.1-.3 0-.5v-.3l-.4.3.1.2.2.2.1.1zm-.8-.5l.1-.2v-.1h.5l-.2.2v.1h-.4zm.7-.3l-.2-.4c0-.1-.1-.1-.1-.2l-.2.5.5.1z" fill="#6A7311" />
            <path d="M39.2 28.5l-.1.1c.1-.1.3-.1.4-.1.2 0 .4.2.4.2v-.2s-.2-.2-.4-.2c-.1.1-.3.1-.3.2zm.1-1c.1-.1.2-.1.3-.2.1-.1.2-.1.3 0 0-.1-.1-.1-.2-.2-.1 0-.2 0-.3.1 0 .1-.1.2-.1.3zm.7.7c0-.1-.1-.2-.2-.2s-.3 0-.4.1v.1c.1-.1.3-.1.4-.1l.3.3-.1-.2zm-.8-.8s.1-.2.2-.3l.2-.2-.1-.1-.2.2c-.1.2-.1.3-.1.4zm-.1-.4c0-.1.1-.1.2-.2h-.1c-.1 0-.1.1-.1.2v.3h.1c-.1-.1-.1-.3-.1-.3zm1.3-3.3c.1 0 .2-.1.2-.1-.1.1-.2.3-.1.5-.1.1-.1.3-.2.4h.1c0-.1.1-.2.1-.3.1.1.2.3.3.4h.2c0-.1 0-.3.1-.4.1.1.2.2.3.2l-.3-.3.3-.3.1.1-.1-.1h-.1l-.3.3c-.1-.1-.1-.2-.1-.3h.1c-.2 0-.3.1-.3.3 0-.2.1-.3.2-.4v-.2l-.5.2c-.2 0-.3 0-.3.1v.1c.1-.1.2-.1.3-.2zm.3.4l.3-.3c0 .1.1.2.1.3-.1.1-.1.3-.1.4-.1-.1-.2-.2-.3-.4zm-1.3 3.6v.1c.1-.1.2-.1.3-.1.1 0 .3.1.4.1v-.2c-.2-.1-.5-.1-.7.1zm3.7-1.9l-.1-.2h.1l.3-.3-.1-.1h-.5s0-.2.1-.3c0-.1.1-.2.1-.2l-.1-.1s0 .1-.2.1-.3-.1-.5-.1v.1s.3.1.4.1h.2c0 .1-.1.2-.1.2v.2c0 .1 0 0 0 0v.1h.6c-.1.1-.2.2-.3.2h-.1l-.2-.3v.1c0 .1.1.1.1.2h-.3l-.1.1v.4l-.3-.1H42l-.1.1c0 .2-.1.4 0 .5-.2 0-.3-.1-.4-.2l-.1.1v.5c-.2 0-.3-.1-.4-.2l-.1.1s.1.5.1.8v.1c-.2 0-.3-.1-.4-.2l-.1.2c0 .3.2.5.3.7h.2c-.1.1-.3.2-.5.2v.1s.2.1.3.2c-.1.1-.2.1-.3.1l.5-.1c.1 0 .2.1.3.1v-.1c-.1 0-.2 0-.3-.1.1-.1.2-.2.2-.3v-.2c-.1 0-.1-.1-.2-.1.3-.2.3-.3.3-.3l.1-.1c-.1 0-.1-.1-.2-.2.2 0 .3-.1.5-.1-.1-.1-.1-.3-.2-.4.2.1.5.1.5.1l.1-.1c0-.1-.1-.3-.1-.4h.5c-.1-.2-.1-.3-.2-.5h.7V26l-.3-.3.4.1zm-1.8 2.6c-.1.1-.1.2-.2.3H41c-.1 0-.2-.1-.2-.2 0 0 .1 0 .4-.3 0 .1 0 .2.1.2zm.1-.5l-.3.3s-.1 0-.1-.1c-.2-.2-.3-.4-.3-.6.1.1.2.2.4.2h.2c0 .1 0 .1.1.2zm.4-.4c-.2 0-.3.1-.5.1v-.1c-.1-.2-.1-.5-.1-.7.1.1.3.2.4.2.1.3.2.5.2.5zm-.1-.6v-.5c.1.1.3.2.4.2v.4c-.2 0-.3 0-.4-.1zm1-.3h-.5v-.1-.5c.1 0 .2.1.4.1 0 .1 0 .3.1.5zm0-.6v-.5h.3c0 .1 0 .2.1.2.1.1.1.2.2.2-.2.1-.4.1-.6.1zm-1.3 3.2v-.1c-.1.1-.2.1-.2.2l-.3-.1v.1s.2.1.3.1l-.1.2v.1c0-.1 0-.2.1-.3h.2v.1c0 .1-.1.2-.1.2h.5l-.1-.1H41.4c0-.1 0-.1.1-.2v-.2h-.2c0 .1 0 0 .1 0zm-2-.2c.1 0 .3.1.4.1V29s-.2-.2-.4-.2-.3.1-.5.2v.2c.2-.1.3-.2.5-.2zm2.3 3.3c-.1.1-.3.1-.5.1.1-.1.1-.2.1-.3.2 0 .4-.2.5-.4v-.1c-.1.2-.3.3-.5.4.1-.2.1-.4.1-.6h-.1l-.3.3c.1-.1.1-.3.1-.5v-.1c-.1.1-.2.1-.3.1h-.1c.1-.2.2-.4.3-.5v-.1c-.1.2-.2.4-.3.5l-.1.1c-.1 0-.3-.1-.4-.2v.1c.1.1.2.1.3.1l-.2.2v.2s.3 0 .5.1c-.1.1-.2.3-.3.4l.1.1c.2 0 .4 0 .6-.1-.1.1-.1.2-.2.3.3.2.6.1.7-.1.2 0 .3-.1.4-.2H42c0 .1-.2.2-.3.2zm-1.2-.7c.1-.1.1-.2.2-.2.3.1.3 0 .3 0s0 .1-.1.4c-.1 0-.2-.1-.4-.2zm.3.6l.2-.3c.2 0 .3-.1.4-.2 0 .2 0 .3-.1.5h-.5zm-.4-1.7c.2 0 .4.1.6.1v-.1c-.2 0-.3-.1-.5-.1l.3-.3h-.1s-.1 0-.2.2l-.1.2c-.2-.1-.3 0-.5 0v.1c.2 0 .3-.1.5-.1l-.2.4v.1l.2-.5zm-.5-1.1v-.1c-.2-.1-.3-.1-.5 0-.1.1-.3.2-.3.3l.1.1.3-.3h.4zm.5.4l-.2-.1c-.1 0-.3.1-.4.2-.1.1-.2.3-.2.4 0 .1.1.1.1.1 0-.1.1-.3.2-.4.3 0 .4-.1.5-.2zm-.6-.1c.1-.1.2-.1.3-.2H40c-.1 0-.3.1-.4.1-.1.1-.2.2-.3.4l.2.1c0-.1.2-.2.3-.4zm.9-7.7c.1-.2.3-.2.3-.2h.1c-.1.2-.1.3-.1.4 0 .2-.1.2-.2.3-.1.1-.2.3-.2.5 0 .1 0 .2.1.3l.1-.1h-.1c-.1 0 0 0 0-.1 0-.2.1-.3.2-.5.1-.1.1-.2.2-.4 0-.1.1-.3.1-.4H41c-.2 0-.3.1-.3.2-.1.1-.2.2-.3.2.1 0 .2 0 .3-.2z" fill="#FFFFFF" />
            <path fill="#6A7311" d="M41.5 23.7L41.1 23.7 41.2 24.1z" />
            <path d="M41 23.7c-.1-.1-.1-.1-.2-.1l-.2.1v.3l.4-.3zm-.1.9l-.3-.5-.2.4H40.7l.2.1zm1.3 7.7c-.2.2-.5.2-.8.2-.2 0-.4-.1-.6-.2l-.3-.3c-.1-.2-.1-.4-.2-.7 0-.2-.1-.4-.2-.6l-.6-.6c-.3-.2-.5-.5-.5-.9v-.1c0-.3.1-.5.2-.8.1-.2.2-.4.2-.6v-.1c-.1-.1-.1-.2-.3-.3-.1 0-.1-.1-.2-.1h-.2.2c.1 0 .2.1.2.1.1.1.2.2.2.3v.1c0 .2-.1.4-.2.6-.1.3-.2.5-.2.8v.1c0 .4.2.7.5.9.2.2.4.3.6.6.1.3.2.6.2.9 0 .2.1.3.1.4.1.1.2.3.3.3.2.1.4.2.6.2.5.1.8 0 1-.2z" fill="#6A7311" />
            <path d="M41.8 31.4c-.1 0-.1.1-.2.1s-.2 0-.3-.1c-.1-.1-.2-.3-.2-.4 0-.2-.1-.4-.2-.6-.2-.3-.4-.5-.6-.6-.2-.2-.5-.4-.5-.6v-.1c0-.2.1-.4.2-.5.1-.2.2-.4.2-.7v-.1c-.1-.3-.3-.6-.5-.8-.1-.1-.3-.2-.5-.2.2.1.4.2.5.3.2.2.4.4.4.7v.1c0 .2-.1.5-.2.7-.1.2-.1.4-.2.6v.1c.1.3.3.5.5.6l.6.6c.1.2.1.4.2.6 0 .2.1.3.2.4.1.1.2.1.3.1.2-.1.3-.1.3-.2z" fill="#6A7311" />
            <path d="M43.4 30.1s.3.1.3.3c0 .2-.1.4-.2.6l-.4-.4.2-.2.1-.1v-.2z" fill="#A6AC56" />
            <path d="M38.3 27.2s-.3.1-.4 0v-.3s-.2 0-.2-.2.2-.2.3-.2 0-.3.2-.2.2.2.2.2l-.1.7z" fill="#FFAD1A" />
            <path d="M38.3 27.2H38V26.9h-.1v-.1s0-.1.1-.1h.2v-.1-.1h.1c.1 0 .1 0 .2.1v.1l-.2.7.2-.7s0-.1-.1-.1c0-.1-.1-.1-.2-.1h-.1l-.1.1h-.2c-.1 0-.1.1-.1.2s0 .1.1.2v.2s0 .1.1.1h.1c.1 0 .2 0 .3-.1z" fill="#8F5E36" />
            <path d="M38.6 27.3s-.2.1-.3 0 0-.3 0-.3-.2-.1-.2-.2.2-.1.2-.1.1-.2.2-.2.2.1.2.2c.1-.2 0 .4-.1.6z" fill="#FFAD1A" />
            <path d="M38.6 27.3h-.2-.1v-.1-.1s-.1 0-.1-.1v-.1-.1h.2v-.1l.1-.1.1-.1c.1 0 .1 0 .1.1 0 0 0 .1-.1.3s0 .4 0 .4.1-.1.1-.3.1-.3.1-.3v-.1c0-.1-.1-.1-.2-.1h-.1l-.1.1h-.1l-.1.1c0 .1 0 .1.1.1v.2l.1.1c.1 0 .2 0 .2-.1v.3z" fill="#8F5E36" />
            <path d="M39 27.3c0 .1-.1.1-.2.1-.2 0-.1-.3-.2-.3s-.2-.1-.1-.2.2-.1.2-.2.1-.3.2-.2.2.2.2.3-.2.1-.3.2c.1.1.1.2.2.3z" fill="#FFAD1A" />
            <path d="M39 27.3c-.1.1-.1.1-.2.1h-.1v-.1-.1-.1l-.1-.1v-.1-.1h.2l.1-.1c.1 0 .1 0 .1.1l.1.1s-.1 0-.1.1c-.1 0-.1.1-.2.2 0 .1.1.2.1.3-.1-.1-.1-.2-.1-.3V27c0-.1.1-.1.2-.2h.2c0-.1 0-.1-.1-.1 0 0-.1-.1-.2-.1h-.1l-.1.1v.1h-.1l-.1.1c0 .1 0 .1.1.2l.1.1V27.5h.1l.2-.2c0 .1 0 .1 0 0z" fill="#8F5E36" />
            <path d="M43 30.1s-.2-.2-.4-.5c-.1-.2-.3-.3-.4-.5l-.4-.2-.2-.4V28l.1-.3.2-.2s-.8.3-.4 1.8c.1.3.3.6.6.7h.7l.2.1z" fill="#AF7029" />
            <path d="M42.6 25c.1 0 .1 0 .1.1v.2c-.3.6-.8.9-1.3 1.2-.3.2-.5.4-.7.7-.2.3-.3.7-.3 1.1v.1c0 .6.2 1.2.7 1.6.3.2.6.3.9.3h1.1c.1 0 .1 0 .2.1v.1c0 .1 0 .1-.1.2 0 0-.1.1-.2.1.1 0 .1-.1.2-.1.1-.1.1-.1.1-.2v-.1c-.1-.1-.1-.1-.2-.1L43 30c-.3 0-.5 0-.8.1-.3 0-.6-.1-.9-.3-.5-.4-.7-1-.7-1.6 0-.4.1-.8.3-1.1.3-.4.6-.7 1-.9.4-.2.8-.6 1-1v-.1-.1c0-.1-.1-.1-.2-.1l-.1.1z" fill="#816C2A" />
            <path d="M43.7 30.3s-.2.3-.2.4c.1 0 .2.1.2.1v.1c-.1-.1-.2-.1-.3-.2v-.1c.1 0 .1-.1.2-.1.1-.1.1-.2.2-.3l-.1.1z" fill="#FFFFFF" />
            <path d="M44.4 30.5l-.5.1-.2-.1c0-.1 0-.2-.1-.3-.1-.1-.2-.1-.3-.1h-.4l-.8-.9h.3l.5-.1h.7l.3.1.1.1.1.1.2.2.1.3v.6z" fill="#FFAD1A" />
            <path d="M44.4 30.5h-.7v.1c0 .1-.1.2-.1.2v.5l.5.1.2-.1.1-.6v-.2z" fill="#AF7029" />
            <path fill="#FFAD1A" d="M44.3 30.3L44.3 30.3 44.3 30.5 44.4 30.5 44.4 30.3z" />
            <path d="M43.9 25.1v-.4l-.1-.2-.2-.3-.3-.2-.1-.1v-.1h-.5l-.3.3c.4.3.7.6.9 1 .2.1.4.2.5.3l.1-.3z" fill="#FFAD1A" />
            <path d="M43.4 25.5c0 .2 0 .4-.1.6l.3-.3.2-.4c-.1-.1-.3-.2-.5-.3.1.2.1.3.1.4z" fill="#AF7029" />
            <path d="M44.1 31.2s-.1-.2-.2-.3l-.2-.2c.1 0 .1.1.2.1l.2.2v.2z" fill="#816C2A" />
            <path d="M44.4 30.8c0 .1-.1.2-.2.3-.1.1-.2.2-.4.2l.5.2.3-.3-.2-.4z" fill="#6F5B24" />
            <path fill="#404118" d="M44.4 31.2L44.3 31.3 44.3 31.4 44.4 30.9 44.4 30.9 44.5 31.1 44.5 31.1 44.5 31.2z" />
            <path fill="#FFAD1A" d="M53.7 40.1L53.7 40.1 53.7 40.9 54 40.7 53.8 40z" />
            <path fill="#A6AC56" d="M53.8 40L53.6 40.1 53.6 40.1 53.7 40.1 53.7 40.1 53.8 40.1 54 40.7 53.7 40.8 53.7 40.1 53.7 40.1 53.7 40.1 53.7 40.1 53.7 40.1 53.6 40.1 53.7 40.9 54 40.7z" />
            <path d="M53.9 39.9c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2 0 .2.2z" fill="#FFAD1A" />
            <path d="M53.9 39.9c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2c0-.2-.1-.3-.3-.3-.1 0-.3.1-.3.2s.1.3.2.3h.1c.1 0 .3-.1.3-.2zm-.1.2c0 .1 0 .1 0 0l-.1.2.1-.2z" fill="#A6AC56" />
            <path d="M53.8 40c0 .1-.1.1-.2.1s-.2-.1-.2-.2v-.2c0-.1-.1.1-.1.1v.2l.1.1h.4V40z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M54.6 41.3L54.6 41.3 54 40.8 53.8 41 54.5 41.4z" />
            <path fill="#A6AC56" d="M54.5 41.4L54.6 41.3 54.6 41.3 54.6 41.3 54.6 41.3 54.5 41.4 53.8 41 54 40.8 54.6 41.3 54.6 41.3 54.6 41.3 54.6 41.3 54.6 41.3 54.6 41.3 54 40.7 53.7 41z" />
            <path d="M54.5 41.6c-.1-.1 0-.3.1-.3.1-.1.3-.1.3 0 .1.1 0 .3-.1.3 0 .1-.2.1-.3 0z" fill="#FFAD1A" />
            <path d="M54.5 41.6v-.1c0-.1 0-.1.1-.2h.2c.1 0 .1 0 .2.1v.1c0 .1 0 .1-.1.2h-.2c-.1 0-.2 0-.2-.1 0 .1.1.2.2.2s.1 0 .2-.1.1-.1.1-.2v-.2c0-.1-.1-.1-.2-.1s-.1 0-.2.1c-.1 0-.1.1-.1.3 0-.1 0 0 0 0z" fill="#A6AC56" />
            <path d="M54.6 41.3h-.1l-.6-.3.7.4v-.1z" fill="#A6AC56" />
            <path d="M55 41.4c0 .1-.1.1-.1.2-.1.1-.2.1-.3 0 0-.1-.1-.1-.1-.2v.1l.1.1.2.1h.2l.1-.1v-.1l-.1-.1z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M58.9 33.2L58.9 33.2 59.5 33.8 59.6 33.5 59 33.2z" />
            <path fill="#A6AC56" d="M59 33.1L58.9 33.2 58.9 33.2 58.9 33.2 58.9 33.2 59 33.2 59.5 33.5 59.5 33.8 58.9 33.2 58.9 33.2 58.9 33.2 58.9 33.2 58.9 33.2 58.9 33.2 59.5 33.8 59.6 33.5z" />
            <path d="M59.1 33.1c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2c.1-.1.2 0 .2.2z" fill="#FFAD1A" />
            <path d="M59.1 33.1c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2 0 .2.2c0-.1-.1-.3-.3-.3s-.3.1-.3.3.1.3.3.3c.2-.1.3-.2.3-.3zm.1.1c0 .1 0 .1 0 0v.2l-.2-.1.2-.1z" fill="#A6AC56" />
            <path d="M59.1 33c0 .1-.2.3-.3.2-.1 0-.2-.2-.1-.3.1-.1 0 0 0 0v.2l.1.1h.1l.1-.1.1-.1z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M60.5 33.6L60.5 33.6 59.6 33.8 59.6 33.5 60.4 33.5z" />
            <path fill="#A6AC56" d="M60.4 33.5L60.4 33.6 60.5 33.6 60.5 33.5 60.5 33.6 60.5 33.5 60.4 33.4 59.6 33.5 59.5 33.8 60.5 33.6 60.5 33.5 60.5 33.6 60.5 33.6 60.5 33.5 59.6 33.8 59.7 33.5z" />
            <path d="M60.8 33.4c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2z" fill="#FFAD1A" />
            <path d="M60.8 33.4c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2c0-.1-.1-.3-.3-.3s-.3.1-.3.3c0 .1.1.3.3.3s.3-.1.3-.3z" fill="#A6AC56" />
            <path d="M60.8 33.3s-.1.3-.2.3-.2-.1-.2-.2v.1l.1.1.1.1h.1l.1-.1V33.3z" fill="#A6AC56" />
            <path d="M60.2 33.5s0 .1-.1.1l-.2.1.5-.1v-.1h-.2z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M57.5 37.9L57.5 37.9 56.9 37.1 57 37 57.6 37.8z" />
            <path fill="#A6AC56" d="M57.6 37.8L57.5 37.9 57.5 37.9 57.5 37.9 57.5 37.9 57.5 37.9 57.7 37.8 57 37 56.9 37.1 57.5 38 57.5 37.9 57.5 37.9 57.5 37.9 57.5 37.9 57 37.1 57 37.1z" />
            <path d="M56.9 36.6c.1 0 .2.1.2.2s-.1.2-.2.2-.2-.1-.2-.2.1-.2.2-.2z" fill="#FFAD1A" />
            <path d="M57.1 36.9c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2c0-.1-.1-.3-.3-.3s-.3.1-.3.3.1.3.3.3.3-.2.3-.3zm.2.4c0 .1 0 .1 0 0v.2l-.3-.4h.1l.2.2z" fill="#A6AC56" />
            <path d="M57.1 36.9c-.1.1-.2.2-.3.1-.1-.1-.2-.3-.1-.3h-.1V37l.1.1H57l.1-.2c0 .1.1-.1 0 0z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M57.5 37.9L57.5 37.9 58.2 38.1 58.2 38 57.7 37.7z" />
            <path fill="#A6AC56" d="M57.6 37.7L57.5 38 57.5 38 57.5 37.9 57.5 38 57.7 37.8 58.2 38 58.2 38 57.5 37.9 57.5 37.9 57.5 38 57.5 37.9 57.5 37.9 57.5 38 58.2 38.1 58.2 38z" />
            <path d="M58.7 38.1c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2 0 .2.2z" fill="#FFAD1A" />
            <path d="M58.7 38.1c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2c.1-.1.2 0 .2.2 0-.1-.1-.3-.3-.3s-.3.1-.3.3.1.3.3.3.3-.2.3-.3zm-.6-.2h-.4.4z" fill="#A6AC56" />
            <path d="M58.6 38c0 .1 0 .2-.2.3h-.1c-.1 0-.2-.1-.2-.3v.2l.1.1h.2l.1-.1.1-.2z" fill="#A6AC56" />
            <path d="M61.3 31.6c0 .7-.7 1-1 1.2-.2.1-.4.3-.5.5l-.1.4v1.4l.5-.3.3-.1h.1c-.2.2-.4.5-.5.8-.2.4-.4 1.2-.9 1.5s-.8.2-1 .3-.2.2-.2.2l-.2.3-.3.2-.2.1-.1.1v.3c0 .2-.1.4-.1.4.1 0 .1-.1.2-.1h.2c-.1.1-.1.1-.1.2 0 .5-.2.9-.6 1.2-.7.3-1.5.4-2.3.3l-.3.1-.3.4-.3.3v.1l-.3.3-.5.3h.4l.6.3c-.2 0-.4 0-.6.1-.6.3-1.3.6-2 .7-.6 0-1.4-.8-1.4-.8l-.4-.3-.6-.1h-.7v-.2h.7c.3 0 .5.2.8.2.2.1.4.1.6 0 .1 0 1-.8 1-.8l1-.4.4.1h.4c0 .1-.1.1-.2.2s-.2.1-.2.2l.1.1.6-.1.2.1h.1c0-.1 0-.2.1-.2.2-.2.4-.3.6-.5.1 0 .2-.1.2-.2l.3-.6v-.3l.7-.7.5-.5.2-.6v-.1c.1.2.2.3.1.5 0 .2 0 .3-.1.5.2-.2.5-.3.7-.5.1-.1.3-.1.4-.1.1-.1.3-.2.4-.3.2-.2.2-.3.2-.3v-1.7l.4-.9.6-.5.1-.1c0 .1 0 .1-.1.2v.2c.1-.2.3-.4.5-.5h.1c.1-.1.1-.2.1-.3v-1l-.1-.4-.3-.8v-1l-.2-.3s.2 0 .5.3c.2.3.3.5.3.9l.6-1.8c.1.2.2.4.3.5.1.2.1.4.1.6l.2-.5v.2c.1.4.2.7.3 1.1zM49.7 42.8s-.1-.3-.7-.5c-.3-.2-.7-.3-1-.3v.2l.9.4.4.3.4-.1z" fill="#A6AC56" />
            <path d="M53.6 41.2c.2-.2.5-.4.8-.6.2-.1.4-.1.5-.1.4 0 .8-.2 1.1-.4.4-.3.8-.6 1.1-1 .1-.1.3-.1.4-.1l-.6.7c-.3.3-.6.6-1 .8-.4.2-.9.3-1.3.3-.3 0-.5.2-.7.4-.1.1-.2.2-.3.4-.1-.3-.1-.4 0-.4zm2.1-2.2c-.4.3-.7.8-.9 1.2 0 0 .6-.5.9-.8.3-.2.7-.4 1-.6.2-.2.2-.3.3-.5l.2-.2s-.3-.2-1.5.9zm-1.5 1.4c.2-.1.3-.2.4-.4 0-.2.1-.3.2-.5l1-1c.3-.3.4-.6.2-1 0 .2 0 .3-.1.5-.2.2-1.1.9-1.2 1.2-.1.2-.1.4-.1.6-.1.3-.2.5-.4.6zm-.5 1.9c-.2-.2-.4-.3-.7-.3-.8 0-1.5.6-2.1.6s-.8-.3-1.2-.5c-.5-.2-1-.3-1.6-.3v.1c.4 0 .7 0 1.1.1.6.2 1 .8 1.7.8l2.1-.6c.7-.1.8 0 .7.1zm-4.1-.5c.4.1.8 0 1.2-.2.4-.4.9-.7 1.4-.9.2 0 .5 0 .7.1-.2-.1-.5-.2-.8-.2-.3 0-.7.1-1 .2-.3.2-.5.5-.8.7-.2.2-.5.3-.7.3zm-.1.9c-.1 0-.2.1-.2 0-.2-.1-.3-.2-.5-.3-.2-.1-.5-.2-.7-.2.2.1.4.2.7.2.2.1.3.2.5.4.1.1.2.1.3.1.2 0 .2-.1.2-.2s-.3-.1-.3 0zm.4-.6c.2.1.4.2.7.1.9 0 1.5-.6 2.1-.9.3-.1.6-.1.9 0-.2-.1-.4-.2-.7-.2-.8.1-1.6.4-2.3.8-.2.1-.4.2-.7.2zm9.7-6.9c-.4.5-.7 1-1 1.6-.2.2-.4.3-.6.5-.2.2-.4.5-.5.7-.1.1-.1.1-.2.1s-.1.1 0 0 .1-.1.3-.2c.1-.2.2-.3.4-.5.3-.2.6-.5.9-.7.2-.3.7-1.3.9-1.5.2-.2.4-.3.7-.4-.1-.1-.4-.2-.9.4zM58 37.1c0-.2.1-.3.2-.5.2-.3.3-.2.5-.6.2-.4.3-.8.4-1.2.1-.3.2-.6.4-.8-.2 0-.4.2-.5.3-.3.5-.6 1-.8 1.5-.1.5-.2.9-.2 1.3zm-.3.4s.1 0 .1-.5 0-1.1.1-1.6l.9-1.2c-.3.1-.5.2-.8.4-.4.3-.6.7-.6 1.2 0 .3.2.7.2 1.1l.1.6zm1.8-3.5s.2-.7.3-.9c.1-.3.3-.5.5-.7.2-.2.4-.5.5-.8.1-.4.1-.9.1-1.3-.1.1-.1.2-.2.3-.1.2 0 .8-.2 1.1-.2.4-.4.8-.6 1.1v-1c.1-.3.2-.7.3-1v-1.2c-.2.2-.3.4-.4.6-.1.4-.2.9-.2 1.3s.1.8.1 1c0 .2 0 .4-.1.6-.1.1-.1.2-.1.3-.1.3-.1.5-.1.5l.1.1zm-.6-3.7c.1.2.2.4.2.6-.1.4-.1.8 0 1.1.1.3.3.4.4.6 0 .2.1.4.1.6v-1c-.1-.2-.1-.1-.2-.3s0-.8-.1-1.1c-.1-.2-.2-.4-.4-.5z" fill="#6A7311" />
            <path d="M41.4 39.8c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2z" fill="#FFAD1A" />
            <path d="M41.4 39.8c0 .1-.1.2-.2.2h-.1v-.1-.1l.1-.1s.1 0 .1.1c.1-.1.1 0 .1 0 0-.1 0-.1-.1-.2l-.1-.1c-.1 0-.1 0-.1.1s-.1.1 0 .2v.2l.1.1c.1 0 .2-.1.2-.3z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M41.4 40.2L41.4 40.2 41.6 41.1 41.3 41 41.3 40.3z" />
            <path fill="#A6AC56" d="M41.3 40.3L41.4 40.3 41.4 40.2 41.4 40.2 41.4 40.2 41.4 40.2 41.2 40.2 41.3 41 41.6 41.1 41.4 40.2 41.4 40.2 41.4 40.2 41.4 40.2 41.4 40.2 41.5 41.1 41.4 41z" />
            <path d="M41.6 39.9c.1.1-.1.3-.2.4s-.4 0-.4-.2.3-.1.3-.1.2-.2.3-.1z" fill="#FFAD1A" />
            <path d="M41.6 39.9c0 .1 0 .1 0 0 0 .1 0 .2-.1.2s-.1.1-.2.1H41l-.1-.1V40h.5s.1 0 .2-.1c-.1 0 0 0 0 0s-.1-.1-.1 0h-.1l-.2.1H41h-.1l-.1.1c0 .1 0 .1.1.2H41.2c.1 0 .1-.1.2-.1.2 0 .3-.1.2-.3.1.1.1.1 0 0z" fill="#A6AC56" />
            <path d="M41.6 40s0 .2-.2.3-.3 0-.3-.1c0 0-.1-.1 0-.1v.1l.1.1H41.5l.1-.1.1-.1-.1-.1zm-.2.4c-.1.1-.1.2-.1.2l.1-.2z" fill="#A6AC56" />
            <path d="M40.4 41.3c0 .1-.1.2-.3.2s-.3-.1-.3-.2.1-.2.3-.2.3.1.3.2z" fill="#FFAD1A" />
            <path d="M40.4 41.3s0 .1-.1.1-.1.1-.2.1-.1 0-.2-.1l-.1-.1s0-.1.1-.1h.4s.1 0 .1.1c0-.1 0-.1-.1-.2s-.3-.1-.4 0c-.1 0-.1.1-.1.2s0 .1.1.2.3.1.4 0c0-.1.1-.2.1-.2z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M40.5 41.2L40.5 41.2 41.4 41.2 41.2 41 40.5 41.1z" />
            <path fill="#A6AC56" d="M40.5 41.1L40.5 41.2 40.5 41.2 40.5 41.2 40.6 41.2 40.6 41.1 41.2 41 41.3 41.2 40.5 41.2 40.5 41.2 40.6 41.2 40.5 41.2 40.5 41.2 40.5 41.2 41.4 41.2 41.2 41z" />
            <path d="M40.6 41.1c.1.2.1.5-.2.5s-.2-.2-.2-.3-.2-.3 0-.4.4 0 .4.2z" fill="#FFAD1A" />
            <path d="M40.6 41.1v.4l-.1.1h-.1l-.1-.1v-.1s-.1-.2-.1-.3V41h.1s.1 0 .2.1h.1l-.1-.1c0-.1-.1-.1-.2-.1 0 0-.1 0-.1.1 0 0-.1.1-.1.2s.1.2.1.3v.2s0 .1.1.1c0 0 .1.1.1 0 .1 0 .1 0 .2-.1v-.2-.4zm.2 0c-.1 0-.1 0 0 0 .1.1.1.1.2.1h-.3v-.1h.1z" fill="#A6AC56" />
            <path d="M40.7 41.3c0 .2 0 .3-.2.2-.1 0-.2-.1-.2-.2v-.1.1l.1.2H40.7v-.2zm-.9-.1c0 .1.1.2.2.2h.2v.1H39.9v-.1l-.1-.2z" fill="#A6AC56" />
            <path d="M37.9 36.3c.1 0 .2.1.2.2s-.1.2-.2.2-.2-.1-.2-.2.1-.2.2-.2z" fill="#FFAD1A" />
            <path d="M38.1 36.6v.2l-.1.1s-.1 0-.1-.1v-.2-.2l.1-.1s.1 0 .1.1v0l-.1-.1c-.1 0-.1 0-.1.1-.1.1-.1.3 0 .4l.1.1c.1 0 .1 0 .1-.1v-.2z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M37.9 37.1L37.9 37.1 37.9 38 37.7 37.8 37.8 37.1z" />
            <path fill="#A6AC56" d="M37.8 37.1L37.9 37.2 37.9 37.1 37.9 37.1 37.9 37.1 37.9 37.1 37.7 37.1 37.7 37.8 38 38 37.9 37.1 37.9 37.1 37.9 37.1 37.9 37.1 37.9 37.1 37.9 37.9 37.8 37.8z" />
            <path d="M38.2 36.9c0 .2-.2.3-.4.2s-.3-.1-.3-.3.3-.1.3-.1.4-.1.4.2z" fill="#FFAD1A" />
            <path d="M38.2 36.9c0 .1 0 .1-.1.1s-.1.1-.2.1h-.1c-.1 0-.1 0-.2-.1 0 0-.1-.1-.1-.2v-.1h.6c.1.1.1.1.1.2 0-.1-.1-.1-.1-.2h-.5-.1l-.1.1c0 .1 0 .1.1.2s.1.1.2.1h.1c.1 0 .2 0 .2-.1.2 0 .2 0 .2-.1z" fill="#A6AC56" />
            <path d="M38.2 36.9c-.1.3-.4.3-.6.2l-.1-.1s-.1-.1-.1-.2v.1l.1.1.2.1h.5l.1-.1-.1-.1zm-.3.4s-.1 0 0 0l-.2.1v-.2h.2v.1z" fill="#A6AC56" />
            <path d="M36.8 37.8c0 .1-.1.1-.3.1s-.3-.1-.3-.1.1-.1.3-.1.3.1.3.1z" fill="#FFAD1A" />
            <path d="M36.8 37.8c-.1 0-.2.1-.2.1h-.2c.1 0 .2-.1.2-.1h.2c-.1-.1-.2-.2-.3-.2h-.2-.1v.1c.1.1.2.1.3.1.1.1.2.1.3 0-.1.1 0 .1 0 0z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M37 37.8L37 37.8 37.6 37.8 37.9 38 37 38z" />
            <path fill="#A6AC56" d="M37 38L37 37.8 37 37.8 37 37.9 37 37.8 37 37.8 37 38 38 38 37.6 37.8 37 37.8 37 37.8 37 37.8 37 37.8 37 37.9 37.6 37.8 37.8 38z" />
            <path d="M36.8 37.5c.2 0 .3.2.3.4s-.2.4-.3.3c-.1 0-.2-.1-.1-.2 0 0 .1-.1.1-.2v-.3c0-.1-.1 0 0 0z" fill="#FFAD1A" />
            <path d="M36.8 37.5c.1 0 .1 0 .2.1 0 .1.1.1.1.2 0 .2-.1.3-.3.3 0 0-.1 0-.1-.1v-.2-.1-.2h.1l-.2.1v.5l.1.1c.2 0 .3-.2.3-.3v-.1c0-.1 0-.2-.1-.2 0-.1-.1-.1-.2-.1h.1z" fill="#A6AC56" />
            <path d="M37.1 37.8c.3.1.4.1.6.2H37v-.1l.1-.1z" fill="#A6AC56" />
            <path d="M37 37.9c0 .2-.1.4-.3.3s-.1-.1-.1-.2v.2H36.9l.1-.1v-.2zm-.4 0h-.4v.1h.1l.3-.1z" fill="#A6AC56" />
            <path d="M36.3 32.6c-.1.1-.2.2-.3.2s0-.2 0-.3.2-.2.2-.1.1.1.1.2z" fill="#FFAD1A" />
            <path d="M36.3 32.6l-.1.1h-.1v-.1c0-.1 0-.1.1-.2 0-.1.1-.1.2-.1v.1c-.1.1-.1.2-.1.2.1-.1.1-.1.1-.2s0-.1-.1-.1h-.1c-.1 0-.2.1-.2.2s-.1.1-.1.2v.1h.1s.1 0 .1-.1c.1 0 .1 0 .2-.1z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M35.6 33.9L35.6 33.9 35.9 33.1 35.9 33 35.5 33.6z" />
            <path fill="#A6AC56" d="M35.4 33.6L35.6 34 35.6 33.9 35.6 33.9 35.6 33.9 35.5 33.6 35.9 33 35.9 33.1 35.5 33.9 35.6 33.9 35.6 33.9 35.6 33.9 35.6 33.9 35.6 33.9 35.9 33 35.9 33z" />
            <path d="M35.8 33.1c-.2-.1-.2-.2-.2-.4s.2 0 .2 0 .1.1.2.1.2 0 .2.1c.1.1.1.1 0 .2s-.2.1-.4 0z" fill="#FFAD1A" />
            <path d="M35.8 33.1c-.1-.1-.2-.2-.2-.3v-.1s0-.1.1-.1h.1s.1.1.2.1h.1s.1 0 .1.1v.1s0 .1-.1.1h-.2l-.1.1h.4l.1-.1v-.1l-.1-.1h-.1s-.1 0-.1-.1h-.1c-.1 0-.1 0-.1.1v.1c-.1 0 0 .1 0 .2z" fill="#A6AC56" />
            <path d="M36.3 32.9v.1c-.1.1-.2.1-.3 0-.1-.1-.2-.1-.3-.2l.1.1.1.1h.4l.1-.1h-.1zm-.5.2v.3l.2-.3-.2-.1v.1z" fill="#A6AC56" />
            <path d="M34.4 33c.1.1.2.2.2.3s-.2.1-.3 0-.3-.2-.2-.3.2-.1.3 0z" fill="#FFAD1A" />
            <path d="M34.4 33c.1 0 .1.1.2.2l-.1.1h-.2c-.1 0-.1-.1-.2-.2h.1c.1-.1.1-.1.2-.1h-.2c-.1 0-.1 0-.2.1v.1c0 .1.1.2.2.2s.1.1.2.1.1 0 .2-.1v-.1c0-.1-.1-.2-.2-.3z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M34.8 33.3L34.8 33.3 35.4 33.7 35.4 34 34.7 33.4z" />
            <path fill="#A6AC56" d="M34.7 33.4L34.8 33.3 34.8 33.3 34.7 33.3 34.8 33.3 34.7 33.3 34.7 33.4 35.4 34.1 35.4 33.7 34.8 33.3 34.7 33.3 34.8 33.3 34.8 33.3 34.7 33.3 35.4 33.7 35.4 34z" />
            <path d="M34.8 33.4c-.1.2-.3.2-.4.1s0-.2 0-.2c.1 0 .1-.1.1-.1 0-.1 0-.2.1-.2s.2 0 .2.1c.1 0 .1.2 0 .3z" fill="#FFAD1A" />
            <path d="M34.8 33.4c-.1.1-.2.1-.2.1h-.1v-.1-.1c.1 0 .1-.1.2-.1v-.1s0-.1.1-.1h.1s.1 0 .1.1v.1c-.2.1-.2.2-.2.2s.1-.1.1-.2v-.1c0-.1-.1-.1-.2-.1h-.1l-.1.1v.1l-.1.1v.1s0 .1.1.1h.1c.1 0 .2-.1.3-.2l-.1.1z" fill="#A6AC56" />
            <path d="M34.9 33.4c.1.2.3.4.4.5l-.6-.5.1-.1.1.1zm-.2.1h-.2c-.1 0-.2 0-.2-.1v-.1.2h.4zm-.3-.3c-.2 0-.3-.1-.3-.1l.1.1h.2zm10.8 9.5s.1-.2.5-.4.8-.4 1.2-.5c.1 0 0 .3 0 .3l-.5.1-.4.2-.4.3h-.4z" fill="#A6AC56" />
            <path d="M46.4 41.5c-.3 0-.7.1-1 .2 0 0-.1.1-.2 0l-.3-.3-.1-.1v.4l-1-.8-.1.5-.1.2-.8-.6v.6h-.2l-.6-.4-.2.1.2.4-.8.1c-.1 0-.1.1-.2.1l-.1.1v.1h.3c.1 0 .1-.1.1-.1s0 .2.2.2.5-.3.7-.2-.4.3-.3.5.5.1.7 0 .5-.5.6-.3-.4.4-.3.7.5.2.6.1.6-.7.7-.6-.4.4-.2.6.4 0 .6-.1.3-.4.5-.6.2-.1.3-.1.3-.2.3-.2l.6-.3h.3l.2.1h.2v-.2c-.2-.1-.4-.2-.6-.1zm-4.7 0l.1-.2-.1-.1c-.1-.1-.3-.2-.4-.3l-.3-.3c-.1 0-.4-.2-.4-.2l-.1-.5-.1-.1-.2.1-.3-1-.1-.2h-.1l-.2.6-.3-.4-.1-.9-.2.2-.2.2-.4-.8v.5c-.2-.1-.4-.2-.5-.4-.2-.1-.4-.3-.5-.5l-.3-.4.2-.4.1-.4-.4.2-.1-1-.1-.3-.5.7c-.1-.1-.1-.2-.2-.3v-.6l-.2.4c-.1-.2-.2-.3-.3-.5v-.8c-.1-.3-.2-.5-.2-.8s.2-.3.2-.4-.2.1-.1-.1.7-.5.5-.8-.7.3-.6 0 .7-.4.7-.8c0-.3-.5.2-.6 0s.3-.5.3-.6.1-.2 0-.3-.4.4-.4.4L35 30l-.1.5-.1.5-.4-.3.1.5.1.5-.5-.1.2.5.3.3.2.3.2.1.2.2.1.3.1.3v1c-.1 0-.2-.1-.3 0s.3.3.2.4-.5-.1-.6.1c0 .2.1.4.3.4.3.1.9.2.8.3s-.8-.4-.8 0c0 .3.2.5.5.6.2.1.9 0 .8.2s-.6 0-.6.2.4.3.5.3c.2 0 .3 0 .5.1.1.1.5.5.8.7s.7.5.8.6c-.1 0-.4 0-.5.1s1 .5.7.6-.7-.3-.8-.1.2.5.4.6 1.2 0 1 .2-.9-.2-.9.1.5.7.7.7.5-.4.6-.2-.2.3 0 .4.4-.2.7-.2c.3.1.7.2.9.5.4.1.6.4.6.3z" fill="#A6AC56" />
            <path d="M45.5 42.6c.1 0 .2 0 .2.1l.6-.4c.2-.1.4-.2.7-.2-.3.1-.5.2-.7.3-.3.2-.5.3-.5.4s-.1.1-.3.1-.2-.1-.2-.2 0-.1.2-.1zm1.5-.7c-.1 0-.2 0-.2-.1-.1-.1-.3-.1-.5-.1-.3 0-.5.1-.7.3-.1.1-.2.2-.3.2.1 0 .2-.1.3-.2.2-.1.4-.2.6-.2.1 0 .3 0 .4.1.2.1.3.1.4.1v-.1zm-8.7-3.6v-.1c-.1-.1-.3-.1-.4-.2-.3-.2-.6-.4-.9-.7l.5.5c.3.2.5.4.8.5zm6.1 4.4s.1-.1.2-.4c.1-.1.2-.3.3-.4l-.1-.2v-.2c0 .1.1.2.2.2l.2.2s.2 0 .2-.1v-.1h-.2c-.1 0-.3-.4-.4-.5s0 .4-.1.4-.4-.7-.8-.8-.4 0-.4.1.4.5.3.6-.6-.7-.9-.7-.4.1-.3.2.4.1.3.4-.4-.4-.7-.3-.3 0-.3.1.1.2.1.2c-.1 0-.3.1-.4.1l-.4.4c.1-.2.3-.3.5-.3h1c-.1 0-.1-.1-.2-.1-.1-.1-.1-.2-.2-.3 0 0 .2.1.3.3.1.1.2.2.3.2.1 0 .2 0 .3.1 0 0 0 .1-.1.2l-.3.3.2-.3.2-.2h.2s0-.1-.1-.3l-.3-.4c.1.1.2.2.3.4.2.2.2.3.2.3h.2c.1 0 0 .1-.1.3-.1.1-.2.3-.2.4l.3-.3c.1-.1.2-.3.2-.3h.3c.1 0 0-.1-.1-.3-.1-.1-.1-.3-.1-.5.1.2.1.3.2.4.2.2.2.3.2.3h.2s0 .1-.1.3c.1.3.1.4-.1.6zm-3.7-2.2c.1 0 .2.1.3.1-.2-.1-.3-.2-.4-.4-.1-.2 0-.8-.1-.8s-.2.4-.3.3 0-.8-.1-1-.5-.5-.5-.4 0 .7-.2.6 0-.7 0-.9-.2-.4-.3-.4 0 .5-.1.5-.2-.3-.2-.3-.1.1-.1 0 0-.3-.1-.3-.1.2 0 .3c0 .1.1.2.1.3 0 .1.2.1.2.2s-.1.1-.2.1h-.3c.1 0 .2.1.3.1h.3l.2.3c0-.1.1-.3.1-.4 0-.2-.1-.3-.1-.5 0 .2.1.3.1.5s-.1.5-.1.5.2.2.1.2h-.5c-.2 0-.4 0-.6-.1.2.1.3.1.5.2h.7l.3.3c.1-.2.1-.3.2-.5v-.5c0 .2.1.3.1.5s0 .4-.1.7c-.1.1-.2.1-.3.2-.2 0-.6.1-.6.1h.7c.3-.1.3-.1.4-.1.1 0 .1.1.1.1l.2.2s-.1.1-.2.1l-.2.1.4-.1.2-.1h.1V40c0-.1 0-.2-.1-.3.1.1.1.2.1.3v.3l.2.1-.2.1zm-5.3-6.1c0-.2.1-.4.1-.6 0-.3-.1-.6-.3-.9l-.1-.1.2-.2-.2.2c-.1 0-.1 0-.2-.1-.1 0-.1-.1-.1-.2.1 0 .1.1.2.1h.1l-.1-.3c-.1-.1-.2-.1-.3-.2-.2-.1-.3-.2-.4-.3 0 0 .3.2.5.3.1 0 .2.1.3.1.1 0 .2-.1.3-.1.1 0 .3-.2.3-.2-.1.1-.2.1-.3.1h-.3v-.4l-.2-.2c-.1-.2-.2-.3-.3-.5l.3.3.2.2.3-.2.5-.4c-.2.1-.3.2-.5.2l-.4.2v-.3c0-.1.1-.2.1-.3s-.1 0-.1-.1c0-.2 0-.3.1-.5v.2c0 .1 0 .2.1.2.2-.1.4-.3.6-.5 0-.1.1-.3-.1-.2s-.2.3-.4.3-.1-.3-.2-.2c-.1.1-.2.3-.3.4 0 .2 0 .5-.1.5s-.2-.3-.4-.3-.2.3-.2.4.5.6.3.7-.5-.4-.7-.1.6.7.7.8 0 .1.2.3.3.2.4.3c.2.3.3.6.4 1v.6zm2 2.9c-.1-.2-.2-.4-.1-.6.1-.4.3-1 .2-1.1s-.3.4-.4.3.2-.7 0-1-.1-.4-.3-.4-.3.8-.4.6.1-.5 0-.6-.1-.2-.2-.2-.2.4-.2.4-.2-.4-.4-.3.4.8.4.8c.1-.1.1-.1.1-.2.1-.1.1-.2.1-.2v.3c0 .1-.1.2-.1.3h-.3c-.1 0-.3-.1-.4-.1.1.1.2.1.4.2l.5.1.2.2.2.2c.1-.1.1-.2.1-.4.1-.2.2-.6.2-.6s0 .5-.1.7-.1.5-.1.5-.2 0-.5-.1l-.8-.1c.2.1.4.1.6.2l.5.1.2.3.2-.2c.1-.1.1-.2.2-.3 0 .1-.1.3-.1.4l-.1.2h-.7c.1 0 .3.1.4.1h.3c0 .1.1.2.1.2.1.2.2.2.3.3z" fill="#6A7311" />
            <path d="M46.5 43.8c-.1-.1-.2-.1-.2-.2-.2-.1-.2 0-.2 0H46l.1-.3 1-.9.2-.9h.6v1.2l.2.1 1.1.6v.3H49s-.1 0-.1.1h-.4l-.7-.5-.4-.3-.5.7-.4.1z" fill="#FFFFFF" />
            <path d="M47.3 41.3v1.2c0 .1-.6.3-.8.6s-.3.5-.3.5c-.1 0-.2 0-.3.1-.1 0-.2.1-.3.2.1-.3.3-.6.6-.9.2-.2.5-.4.8-.5v-1c0-.1.1-.1.1-.1.1-.1.1-.1.2-.1zm1.2 2.7c0-.1.1-.1.1-.2s.1-.1.2-.1l-.2-.1c-.2-.1-.4-.1-.6-.2-.1-.1-.3-.2-.4-.3l-.2.2.3.3c.1.1.5.2.6.3 0 0 .1 0 .2.1z" fill="#016848" />
            <path d="M47.8 41.3h.3v1c0 .2-.1.4-.2.5l-.7.6c-.1.2-.3.3-.4.5 0-.1-.1-.1-.1-.2-.1-.1-.1-.1-.1-.2.1-.2.3-.4.6-.6.3-.2.6-.5.7-.8-.1-.2-.1-.5-.1-.8z" fill="#E92736" />
            <path d="M49.7 43.6c-.1-.1-.2-.1-.3-.1h-.2l-.3-.3c-.2-.1-.4-.1-.6-.3-.1-.1-.3-.2-.3-.4l.2-.3c.1.2.3.3.4.4.2.2.7.3.8.4s.3.6.3.6z" fill="#E92736" />
            <path d="M51.8 39.5s-.6-.2-.6-.5 1.4-.6 1.4-.6V38c-.2 0-.4 0-.5.1-.5.2-1 .2-1.5.3-.2 0-.4 0-.7-.1-.1 0-4.8-.3-5-.3h-.3c-.6 0-1-1-1-1h-.3s.1.5-.1.5c-.8-.2-1.6-.6-2.4-1l-.1.5s1.3.7 1.2.9-.4.2-.4.2l.2.3c.1 0 2.1.1 2.1.7 0 .2-.5.4-.5.4l.2.2v.3c.5 0 .9.1 1.4.2.3.2.5.4.9.6 1.1.2 2.3.2 3.4.1.5-.1.8-.7 1.5-.9.3-.1.7-.2 1-.2l.1-.3z" fill="#30C2DC" />
            <path d="M51.8 39.5c-.1 0-.2-.1-.3-.2-.1 0-.1-.1-.2-.1l-.1-.1.1-.1c.2-.1.5-.2.8-.3l.4-.1h.2v-.4h-.1c-.2 0-.4 0-.5.1-.5.2-1 .2-1.5.3-.2 0-.4 0-.7-.1h-.3l-2.6-.3-1.4-.1h-.8c-.2 0-.3-.1-.4-.2-.2-.1-.3-.3-.4-.5l-.1-.2v-.1l-.4.1v.5h-.2c-.4-.2-.9-.4-1.3-.6l-.6-.3-.2-.1H41l-.1.5c.1.1.4.2.7.4l.3.3.1.1v.1s-.1.1-.2.1h-.2l.2.4h.1c.4 0 .8.1 1.2.2.2 0 .4.1.6.2l.2.2s.1.1.1.2c0 0 0 .1-.1.1-.1.1-.2.1-.2.2h-.2l.2.2v.1h1.2c.1 0 .2 0 .2.1.1.1.3.2.4.3.1.1.3.2.5.3.1 0 .2.1.2.1.5.1 1 .1 1.5.1h1.1l.2.1h.3c.2-.1.5-.2.7-.4.2-.2.5-.4.8-.5.4-.1.6-.2.8-.2H51.9l-.1-.4v.3c-.3 0-.7.1-1 .2-.3.1-.6.3-.9.5-.2.2-.4.3-.6.4h-.2c-.5 0-1 .1-1.5.1h-1.4l-.2-.1c-.2-.1-.3-.2-.5-.3-.1-.1-.3-.2-.4-.3-.1-.1-.2-.1-.4-.1-.3-.1-.7-.2-1.1-.2v-.1l-.2-.2c.1 0 .2-.1.3-.1.1 0 .1-.1.2-.1s.1-.1.1-.2 0-.2-.1-.2c-.1-.1-.3-.2-.5-.3-.3-.1-.7-.2-1-.2H41.8l-.2-.3h.2c.1 0 .1 0 .1-.1 0 0 .1-.1.1-.2v-.1l-.3-.3-.9-.6.1-.5s.5.3 1 .5c.3.1.5.3.8.3.1 0 .2.1.3.1h.4v-.1-.1-.3h.3c.1.2.2.3.3.5l.3.3c.1.1.3.2.5.2h.5l2.7.2 1.4.1H50c.2.1.4.1.7.1.5 0 1-.1 1.5-.3.2-.1.3-.1.5-.1v.4s-.3.1-.7.2c-.2.1-.3.1-.5.2-.1 0-.1.1-.2.1v.2c0 .1.1.1.1.1.1.3.2.4.4.4z" fill="#0872A7" />
            <path d="M41.7 38.6c0 .2-.2.4-.4.4s-.3-.2-.3-.4.2-.4.4-.4.3.2.3.4z" fill="#FFFFFF" />
            <path d="M41.7 38.6c-.1.1-.2.3-.4.3s-.3-.1-.3-.3.1-.3.3-.3.4.1.4.3c.1-.2 0-.5-.3-.5-.2 0-.5.1-.5.4v.1c0 .2.1.5.4.5.2 0 .5-.1.5-.4 0 0 0-.1-.1-.1z" fill="#0872A7" />
            <path d="M43.8 36.9c0 .2-.2.4-.4.4s-.4-.2-.4-.4.2-.4.4-.4.4.2.4.4z" fill="#FFFFFF" />
            <path d="M43.8 36.9c-.1.1-.2.3-.4.3s-.3-.1-.3-.3.1-.3.3-.3.3.2.4.3c.1-.2-.1-.5-.4-.5-.2 0-.5.2-.5.5s.2.5.5.5.5-.3.4-.5z" fill="#0872A7" />
            <path d="M52.4 39.6c0 .2-.2.4-.4.4s-.4-.2-.4-.4.2-.4.4-.4c.3 0 .4.2.4.4z" fill="#FFFFFF" />
            <path d="M52.4 39.6c-.1.2-.2.3-.4.3s-.3-.1-.3-.3.1-.3.3-.3c.2 0 .3.1.4.3.1-.3-.1-.5-.4-.5-.2 0-.5.2-.5.4 0 .3.2.5.5.5s.5-.2.4-.4z" fill="#0872A7" />
            <path d="M39.8 36.4c-.1.3.3.8.7.8s.5 0 .6-.2c0-.1 0-.3-.1-.4-.3-.3-1.1-.5-1.2-.2z" fill="#FFAD1A" />
            <path d="M40.8 36.8c0-.2-.3-.3-.5-.3s-.3 0-.3.1.5.2.5.3-.1.1-.1.2.2 0 .2 0 .2-.2.2-.3z" fill="#FFFFFF" />
            <path d="M43.7 39.9c.1.2-.1.4-.3.5-.3.1-.6.1-.8-.2-.1-.2.2-.5.5-.6s.5.1.6.3z" fill="#FFAD1A" />
            <path d="M43.2 40c.1 0 .1.1.2.1s.2-.1.1-.2-.2-.2-.3-.2c-.1 0-.5.3-.5.4s.1.1.2 0 .2-.1.3-.1z" fill="#FFFFFF" />
            <path d="M52.5 38.6c.2.3.6 0 .7-.1s.4-.3.3-.5-.3-.2-.5-.2-.4.2-.5.3v.5z" fill="#FFAD1A" />
            <path d="M52.6 38.5s0-.3.3-.3.2 0 .3.1.2-.1.2-.1 0 .2-.2.2-.1-.1-.3-.1-.3.2-.3.2z" fill="#FFFFFF" />
            <path d="M47.8 37.8l-.2-.1h-1.1l.6 1.7.7 1 .3.1h.5l.1-.3-.2-1.6-.7-.8z" fill="#F9AA51" />
            <path d="M47.8 37.8l-.1-.1h-1.1l.6 1.7.7 1 .3.1h.5l.1-.3-.2-1.6-.8-.8.8.8.2 1.6-.1.2H48l-.7-1-.6-1.7h1.1v.1z" fill="#953220" />
            <path d="M45.9 37.9v-.2h.7c.2.2.4.5.5.8.1.3.3.8.5 1.2s.5.8.5.8h-.7l-.3-.1-1-1.5-.2-1z" fill="#F9AA51" />
            <path d="M45.9 37.9v-.2h.6c.2.2.4.5.5.8l.2.6c.1.2.1.4.2.6.2.3.5.8.5.9h-.7l-.2-.2-1-1.5-.1-1-.2-.1.3 1 1 1.5.3.1h.7s0-.1-.1-.1c-.2-.2-.3-.5-.5-.8-.1-.2-.2-.4-.2-.6-.1-.2-.2-.4-.2-.6-.1-.2-.2-.4-.3-.5l-.2-.2-.1-.1H45.8v.2l.1.2z" fill="#953220" />
            <path d="M45.5 37.7h.4c.3.2.5.6.7.9.1.4.2.7.3 1.1.1.3.3.6.5.8h-1c-.4-.1-.5-.1-.6-.2-.1-.1-.2-.2-.3-.2h-.4l.1-.5-.1-1.2v-.6l.4-.1z" fill="#F9AA51" />
            <path d="M45.5 37.7h.4c.3.2.5.5.6.9.1.2.1.3.1.5s.1.4.2.5c.1.3.3.6.6.9h-1l-.4-.1h-.2l-.2-.2-.1-.1h-.3l.1-.5-.1-1.2V38l.3-.1-.3.1v.6l.1 1.2-.1.5h.4c.1.1.2.1.3.2l.1.1c.2.1.4.1.5.1h1c-.2-.2-.4-.5-.5-.8-.1-.2-.1-.3-.2-.5 0-.2-.1-.4-.1-.5-.1-.2-.2-.5-.4-.7l-.3-.4-.1-.1h-.4z" fill="#953220" />
            <path d="M49.5 38l-.6-.3-1.2-.1s0 .3.1.6c.1.5.2.9.4 1.3.1.3.3.6.5.8.1.1.8-.2.8-.2l.4-.1-.1-.5-.1-.2.1-1.4v.1h-.3z" fill="#F9AA51" />
            <path d="M49.5 38l-.6-.3-1.2-.1s0 .3.1.6c.1.5.2.9.5 1.3l.3.5.1.2.1.1h.2c.2 0 .3-.1.5-.2l.5-.1m0 .2l-.1-.5-.1-.1.1-1.4V38h-.3.3l.1.2-.1 1.4.1.1v.5h-.6l-.3.1c-.1 0-.2 0-.3.1l-.1-.1c-.1-.2-.2-.5-.4-.7-.2-.4-.4-.9-.4-1.3 0-.2 0-.3-.1-.4s0-.2 0-.2l1.2.1.6.3.4 2.1z" fill="#953220" />
            <path d="M44.8 39c0 .2.1.4.3.6 0 0-.3.2-.3.5 0 .2.2.4.4.4s.5-.1.5-.3c0-.2-.1-.3-.3-.3-.1 0-.2.1-.2.1v-2c0 .2.2.2.2.2.1 0 .2-.1.2-.3 0-.2-.2-.4-.4-.4s-.4.3-.4.5.2.3.2.4c-.1.2-.2.4-.2.6z" fill="#F9AA51" />
            <path d="M45.2 38.1c0 .1.1.2.1.2h.1c.1 0 .1 0 .1-.1.1-.1.1-.2.1-.2 0-.1 0-.2-.1-.3-.1-.1-.2-.1-.3-.1-.1 0-.3.1-.3.2-.1.1-.1.2-.1.4 0 .1 0 .2.1.3l.1.1s-.1.1-.1.2c-.1.1-.1.3-.1.4 0 .2.1.3.2.5 0 .1.1.1.2.2-.1 0-.1.1-.2.2s-.1.2-.2.3c0 .1.1.2.2.3.1.1.2.1.3.1.1 0 .2 0 .3-.1l.1-.1s.1-.1.1-.2 0-.2-.1-.2-.1-.1-.2-.1h-.2l-.1.1v-.1h.1c.1 0 .1 0 .2.1.1 0 .1.1.1.2v.1c0 .1-.1.1-.2.1h-.2c-.1 0-.2 0-.3-.1-.1-.1-.1-.2-.1-.3 0-.1.1-.2.1-.3l.1-.1c-.1-.2-.2-.4-.1-.7 0-.1 0-.3.1-.4 0 0 0-.1.1-.1v-.1c0-.1-.1-.1-.1-.2-.1-.1-.1-.1-.1-.2s0-.2.1-.3c.1-.1.2-.2.3-.2.1 0 .2 0 .2.1.1.1.1.1.1.2s0 .1-.1.2h-.1-.2z" fill="#953220" />
            <path d="M49.6 39.9c-.1 0-.3.1-.3.3s.3.3.4.3c.2 0 .4-.2.4-.4V40c0-.2-.1-.4-.3-.5.1-.2.2-.4.2-.6 0-.3-.1-.4-.1-.4.1-.1.2-.3.2-.4 0-.2-.2-.4-.4-.5-.2 0-.4.1-.4.3s.1.2.2.2.2 0 .2-.2l.1 2c0 .1-.1 0-.2 0z" fill="#F9AA51" />
            <path d="M49.7 38.2c-.1.1-.1.1-.2.1v-.2-.1l.1-.1H49.9l.1.1c.1.1.1.2.1.2 0 .1 0 .2-.1.3 0 0 0 .1-.1.1 0 0 .1.1.1.3 0 .1 0 .3-.1.4l-.1.1.1.1c.1.1.1.2.1.3 0 .1 0 .2-.1.3-.1.1-.1.1-.2.1s-.2 0-.3-.1l-.1-.1v-.1c0-.1 0-.2.1-.2l.1-.1s.1 0 .1.1l.1.1m.1.1c0-.1 0-.1-.1-.2 0-.1-.1-.1-.2-.1s-.2 0-.2.1c-.1.1-.1.2-.1.3 0 .1 0 .1.1.2 0 .1.1.1.2.2h.2c.1 0 .2 0 .3-.1.1-.1.2-.2.2-.4 0-.1-.1-.3-.2-.4 0 0-.1-.1-.2-.1.1-.2.2-.4.2-.6 0-.1 0-.2-.1-.3 0-.1-.1-.1-.1-.1l.1-.1c.1-.1.1-.2.1-.3 0-.1-.1-.3-.2-.4l-.2-.1h-.2c-.1 0-.2 0-.3.1l-.1.1v.2c0 .1 0 .2.1.2 0 0 .1.1.2.1h.1l.1-.1V38l.3 1.9z" fill="#953220" />
            <path d="M45.7 40s0 .1 0 0c.1.2.1.3.2.3.5.1 1.1.2 1.6.2s1 0 1.5-.1c.2-.1.2-.3.3-.4s.2-.1.2-.1l-.2.1v.2l.1.1c0 .1-.1.1-.1.1-.1.1-.3.1-.4.1h-2.6c-.3 0-.3 0-.4-.1-.1 0-.1-.1-.2-.2V40zm3.4-2.1l.2.1s-.2 0-.3.4 0 .5-.1.5h-1l-.2-.4 1.4-.6z" fill="#953220" />
            <path d="M52.1 37.8c-.1 0-.2-.1-.2-.2-.1-.1-.1-.3-.1-.3s.2.1.2.2.1.3.1.3zm1.7-.5c0 .1.1.2.2.2l.2.1c-.1 0-.2 0-.3-.1-.1-.1-.1-.2-.2-.3l.1.1z" fill="#04534E" />
            <path d="M54.4 37.5h-.3c-.1 0-.2-.1-.2-.2s.1 0 .2 0 .2.1.3.2zm.9-.8c-.1.1-.1.1-.2.1s-.3 0-.3-.1.2-.1.3-.1l.2.1zm-1.4-1.8c-.1 0-.2.1-.3.2-.1.1-.1.2 0 .2s.1-.1.1-.2l.2-.2zm-.9.5c-.1 0-.1.1-.2.2 0 .1-.1.3 0 .3s.1-.1.1-.2.1-.3.1-.3z" fill="#04534E" />
            <path d="M51.4 36.5l-.5.5c.6.3 1.3.5 2 .6.7-.1 1.4-.4 1.9-.8.1-.3 0-.7-.1-1-.2-.3-.6-.5-.9-.6-.4.1-.7.4-1 .7-.4.4-.3.7-.8.7l-.6-.1z" fill="#8CBEBF" />
            <path d="M51.4 36.5l-.5.5c.2.1.4.2.7.3.4.2.9.3 1.3.3h.1c.5 0 .9-.2 1.3-.4.2-.1.3-.2.5-.3l.2-.1.1-.1v-.1-.1-.4c0-.1 0-.2-.1-.3 0-.1-.1-.1-.2-.2s-.3-.2-.4-.3c-.1 0-.1-.1-.2-.1H54c-.2 0-.3.1-.5.2-.2.2-.4.3-.6.5-.1.1-.3.3-.4.5 0 0-.1.1-.2.1H51.4h.6c.2 0 .4-.1.5-.3l.3-.3c.2-.2.4-.3.5-.5.1-.1.3-.2.4-.2.1 0 .1 0 .2.1s.3.2.4.3l.2.2.1.1c.1.1.1.2.1.3v.7c-.2.2-.5.3-.7.5-.3.2-.7.3-1.1.3h-.1c-.4 0-.9-.1-1.3-.3l-.4-.4H51l.4-.5z" fill="#04534E" />
            <path d="M51.3 36.7s1.2.2 1.6-.1.7-.9 1-1.1c.1-.1.2-.1.4-.1.1.1.2.1.3.2l.3.2.1.6v.3l-.5.3-.7.3-.7.2h-.6l-1.2-.3-.2-.2-.1-.1.3-.2z" fill="#0C8489" />
            <path d="M53.2 36c0-.1.1-.1.2-.1s.2 0 .2.1-.1.2-.2.2-.2-.1-.2-.2zm.4.3c0-.1.1-.1.2-.1s.2.1.2.2-.1.2-.2.2c-.1-.1-.2-.2-.2-.3zm-.1.7c0-.1.1-.1.2-.1s.2 0 .2.2c0 .1-.1.2-.2.2-.2-.1-.2-.2-.2-.3zm-.7-.2c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2c0 .1-.2-.1-.2-.2zm-1 .1c0-.1.1-.3.2-.3s.3.1.3.2v.1c0 .1-.1.3-.2.3s-.3-.1-.3-.3c0 .1 0 0 0 0z" fill="#04534E" />
            <path d="M53.6 36.3c0-.1.1-.1.2-.1s.1.1.1.2-.1.1-.1.1c0-.1-.2-.2-.2-.2zm-.1.7c0-.1.1-.1.2-.1s.2 0 .2.1-.1.2-.2.2-.2-.1-.2-.2zm-.7-.2c0-.1.2-.2.2-.2s.1.1.1.2 0 .2-.1.2-.2-.1-.2-.2zm.3-.8c0-.1.1-.1.1-.1s.1 0 .1.1 0 .2-.1.2-.1-.1-.1-.2zm-1.3.8c0-.1.1-.2.2-.2s.3 0 .3.2-.2.3-.3.3c-.1 0-.2-.1-.2-.3z" fill="#8CBEBF" />
            <path d="M52.3 36.6c-.1 0-.2.1-.3.1-.1.1-.1.2 0 .2s.1-.1.1-.1c.1 0 .1-.1.2-.2zm.8-.1s-.2.1-.2.2v.2s.1-.1.1-.2 0-.3.1-.2z" fill="#04534E" />
            <path d="M53.2 36.6c-.1 0-.1 0-.2.1s-.1.2-.1.2.1 0 .1-.1.2-.2.2-.2zm.2-.9l-.1.1s-.1.2 0 .2.1 0 .1-.1v-.2zm.6.4s-.2 0-.2.1-.1.2 0 .2.1 0 .1-.1.1-.2.1-.2zm-.1.7c0 .1-.1.1-.1.2-.1.1-.1.1-.2 0s0-.1.1-.1l.2-.1z" fill="#04534E" />
            <path d="M54.9 36.3c0 .2 0 .4-.2.5-.5.4-1.2.6-1.9.7-.6-.1-1.1-.2-1.6-.5H51l.2.1.6.2.7.2h.8l.7-.2.6-.3.3-.2.1-.1-.1-.4zM39.7 32s.2.2.2.3-.1.2-.1.2v-.2c0-.1 0-.2-.1-.3zm1.3 1.2s0 .2-.1.2-.2-.1-.1-.1h.1l.1-.1zm-2.8.1c0 .1.1.1.2.2.1 0 .2-.1.2-.1h-.1l-.3-.1zm.5 1.1c.1.1.2.1.3.2.1 0 .2 0 .2-.1H39l-.3-.1zm.9.7s.2 0 .3-.1.1-.2 0-.2-.1.1-.1.2c-.1 0-.1.1-.2.1z" fill="#04534E" />
            <path d="M41.1 34.5c.1-.7-.2-1.3-.7-1.8-.8-.7-1.4-.6-1.7-.3-.5.6-.4 1.4.2 1.9l.1.1c.6.5 1.3.7 2 .5l.1-.4z" fill="#8CBEBF" />
            <path d="M41.1 34.5v-.2c0-.6-.3-1.2-.7-1.6-.3-.3-.7-.5-1.1-.5-.2 0-.5.1-.6.2-.2.2-.3.5-.3.8 0 .5.3 1 .7 1.2.5.4 1 .6 1.6.6h.4v-.5l-.1.5h-.4c-.6 0-1.1-.2-1.6-.6-.4-.3-.6-.7-.6-1.2 0-.3.1-.5.2-.7.2-.2.4-.2.6-.2.4 0 .8.2 1.1.5.4.4.7.9.7 1.5 0 .1 0 .1.1.2z" fill="#04534E" />
            <path d="M38.5 33.4s0-.6.3-.8c.6-.3 1.3-.1 1.6.5.3.5.5 1.1.3 1.7h-.5l-.7-.3-.6-.5c0 .1-.4-.6-.4-.6z" fill="#0C8489" />
            <path d="M41 34.7c-.1.1-.3.2-.5.2-1-.1-1.8-.8-2.1-1.7v.4l.1.3.3.4.4.3.5.2.3.1.4.1h.2l.4-.3z" fill="#04534E" />
            <path d="M40.2 34.3c0-.1.1-.1.1-.1s.2 0 .2.1-.1.3-.2.3-.1-.2-.1-.3zm.1-.7c0-.1.1-.2.1-.2.1 0 .2.1.2.1 0 .1-.1.2-.1.2-.2.1-.2 0-.2-.1zm-.7.8c0-.1.1-.1.2-.1s.2 0 .2.1-.2.2-.3.2-.1-.2-.1-.2zm0-.8c0-.1 0-.1.1-.1s.2 0 .2.1-.1.2-.2.2-.1-.1-.1-.2zm-.6.1c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2zm.1-.7c0-.1.1-.1.2-.1s.2 0 .2.1-.1.2-.2.2-.2-.1-.2-.2zm.6-.1c0-.1.1-.1.2-.1s.2.1.2.1c0 .1-.1.2-.2.2s-.2-.1-.2-.2z" fill="#04534E" />
            <path d="M39.1 33c0-.1.1-.1.1-.1.1 0 .2 0 .2.1s-.1.2-.1.2c-.2 0-.2-.1-.2-.2zm-.1.7c0-.1 0-.2.1-.2s.2 0 .2.1-.1.2-.2.2-.1 0-.1-.1zm.7-.7c0-.1 0-.1.1-.1s.1 0 .1.1-.1.1-.2.1c.1 0 0 0 0-.1zm-.1.6c0 .1.1.2.1.2.1 0 .2-.1.2-.2s-.1-.2-.2-.2-.1.1-.1.2zm.7-.1c0 .1.1.2.2.2s.2 0 .2-.1 0-.2-.1-.2h-.1c-.1 0-.2 0-.2.1zm-.7.9c0-.1.1-.1.2-.2.1 0 .1 0 .2.1 0 .1-.1.2-.2.2s-.2-.1-.2-.1zm.6-.1c0-.1.1-.1.2-.1s.2 0 .2.1-.1.2-.2.2l-.2-.2z" fill="#8CBEBF" />
            <path d="M40.4 33.2c0 .1.1.1.1.2v.2l-.1-.1v-.3zm-.6-.6c0 .1.1.1.1.2s0 .2-.1.2 0-.1 0-.1v-.3zm-.6.1c0 .1.1.1.1.2s0 .2-.1.2 0-.1 0-.2v-.2z" fill="#04534E" />
            <path d="M39 32.8c.1 0 .1 0 .2.1s.1.1.1.2-.1 0-.1-.1l-.2-.2zm.5.7c.1 0 .1 0 .2.1s.1.1.1.2-.1 0-.2-.1c0-.1-.1-.2-.1-.2zm-.6 0c.1 0 .1 0 .2.1 0 0 .1.1 0 .1s-.1 0-.1-.1c-.1 0-.1-.1-.1-.1zm1.4.4v.4s-.1-.1-.1-.2c0 0 .1-.1.1-.2z" fill="#04534E" />
            <path d="M40.1 34.1c.1 0 .1 0 .1.1 0 0 .1.1 0 .1s-.1-.1-.1-.1v-.1zm-.6.1h.2s.1.2 0 .2-.1 0-.1-.1l-.1-.1zm-.3-2s-.6.1-.7.5c-.1.3-.1.5-.1.8V33l.1-.3.2-.3.2-.2.2-.1.1.1zm1.8 2.2s.1-.1-.1-.6c-.1-.3-.3-.7-.5-1l.3.3.2.3.1.3v.7zm.6-.7s.2.1.2.2v.1s-.1-.1-.2-.1v-.2zm-.8 2.2c0-.1.1-.2.2-.2.1-.1.2-.1.2 0s-.1.1-.2.2h-.2zm1.3.5c.1 0 .2-.1.2-.2.1-.1.1-.2.1-.2s-.2 0-.2.1 0 .2-.1.3z" fill="#04534E" />
            <path d="M42 36.3c0-.1.1-.2.1-.2 0-.1.1-.1.2-.1v.2c-.1 0-.2 0-.3.1z" fill="#04534E" />
            <path d="M44.3 35.2c-.5-.7-1.3-1.2-2.2-1.3-.7-.1-1.3.5-1.4 1.1v.1c0 .3.4.9 1.9 1s1.7-.7 1.7-.7v-.2z" fill="#8CBEBF" />
            <path d="M44.3 35.2l-.6-.6c-.5-.4-1-.6-1.6-.7H42c-.4 0-.8.2-1 .5-.1.1-.2.3-.2.4 0 .1-.1.2-.1.3 0 .3.5 1 1.9 1.1h.3c.4 0 .8-.1 1.2-.4.1-.1.2-.2.2-.3v-.1-.2.2c-.1.2-.2.3-.4.4-.3.2-.6.3-1 .2h-.3c-1.4-.1-1.8-.7-1.8-1 0-.1 0-.2.1-.3.1-.2.2-.4.4-.5.2-.2.5-.2.8-.2h.1c.6 0 1.1.3 1.6.7.2.1.3.3.4.4l.1.1z" fill="#04534E" />
            <path d="M43.3 34.4c.2.1.4.3.5.5.2.2.2.4.1.4-.5-.3-1-.6-1.5-.8-.6-.2-1.2 0-1.3.3-.2.3-.1.7.2 1 .5.2 1.1.3 1.7.4 0 0 .6-.1.7-.1l.4-.2.1-.2.1-.3v-.1l-.3-.4-.7-.5z" fill="#0C8489" />
            <path d="M42.2 34.5c0 .1-.1.1-.2.1s-.2 0-.2-.1.1-.1.1-.1c.2 0 .3.1.3.1zm-.8.3c0-.1.1-.1.2-.1s.2.1.2.1c0 .1-.1.2-.2.2-.2 0-.2-.1-.2-.2zm.8.5c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2z" fill="#04534E" />
            <path d="M41.6 35.5c0-.1.1-.1.2-.1s.2.1.2.2-.1.2-.2.2-.2-.2-.2-.3z" fill="#8CBEBF" />
            <path d="M42.8 35.8c0-.1 0-.1.1-.1s.2 0 .2.1-.1.1-.2.2c-.1-.1-.1-.1-.1-.2zm.5-.4c0-.1 0-.1.1-.1s.2 0 .2.1-.1.1-.2.1-.1 0-.1-.1z" fill="#04534E" />
            <path d="M42.1 34.5c0 .1 0 .1-.1.1s-.2 0-.2-.1 0-.1.1-.1.2 0 .2.1zm-.4.3c0 .1-.1.1-.2.1s-.1-.1-.1-.1c0-.1.1-.1.1-.1s.2 0 .2.1zm.2.7c0 .1 0 .1-.1.1s-.2 0-.2-.1 0-.1.1-.1.2 0 .2.1zm.7-.3c0 .1-.1.2-.2.2s-.1-.1-.1-.2.1-.1.1-.1c.1 0 .2 0 .2.1zm1 .3c0 .1-.1.1-.2.1s-.1-.1-.1-.2 0-.2.2-.1.1.1.1.2zm-.6.3c0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1s.1 0 .1.1z" fill="#8CBEBF" />
            <path d="M43.1 35.3h.2c.1 0 .1 0 .1.1s-.1 0-.1 0l-.2-.1zm-.6.5c.1 0 .1-.1.2-.1s.2 0 .2.1 0 .1-.1.1-.2 0-.3-.1zm-.4-.8s.2.1.3.2.1.1 0 .2-.1 0-.1-.1l-.2-.3zm0 .3H42.4h-.3zm-.6 0c.1 0 .2 0 .2.1v.1h-.1l-.1-.2zm0 .3s.1-.1.2-.1h.2l-.1.1h-.3zm-.2-.9c.1 0 .1 0 .2.1.1 0 .1.1.1.1h-.2c0-.1-.1-.1-.1-.2zm.4-.5c.1 0 .2.1.3.2.1.1.1.2 0 .2s-.1 0-.2-.1c0-.1-.1-.2-.1-.3z" fill="#04534E" />
            <path d="M44.1 35.7c-.4.3-.9.4-1.3.3-.8 0-1.5-.3-2-.9l.1.2.2.3.7.3.7.2h.5l.5-.1.4-.2c.1 0 .1-.1.2-.1zm.1-.5l-.4-.4c-.3-.3-.7-.5-1.1-.8l.7.3.5.4.3.5zm0-.8c.1 0 .2.1.3.1l.1.1s-.1.2-.1.1c-.1 0-.1-.1-.1-.2-.1 0-.1 0-.2-.1zm.7-.4c.1 0 .2.1.3.2.1.1.1.2 0 .2s-.2-.1-.2-.2-.1-.2-.1-.2z" fill="#04534E" />
            <path d="M45.2 34c.1.1.2.1.2.2s.1.2 0 .2-.2-.1-.2-.1-.1-.3 0-.3zm1.1.2c.1 0 .2.1.2.2v.2l-.1-.1v-.1s0-.2-.1-.2zm.3.1l.2.2v.2c0 .1-.1-.1-.1-.2l-.1-.2zm-2.1 2.6h.2c.1 0 .2-.1.2-.2s-.1-.1-.1 0 0 .1-.1.1l-.2.1zm1.2.3c.1 0 .2-.1.3-.1.1-.1.2-.2.1-.2s-.1 0-.2.1-.1.2-.2.2zm1 .1c.1 0 .1-.1.2-.2s.1-.1.1-.2c0 0-.1-.1-.1 0v.1c-.1.1-.2.2-.2.3z" fill="#04534E" />
            <path d="M46.9 37.3c.1-.1.1-.2.2-.2v-.2c-.1 0-.1 0-.1.1s0 .3-.1.3z" fill="#04534E" />
            <path d="M44 35.7c0-.4.6-1.4 1.3-1.4.4 0 .9.2 1.3.3.4.2.5.4.8.4h.6l.9-.1-.7 1-.2.2c-.2.3-.5.5-.8.7-.7.2-1.4.2-2.1 0-.6 0-1-.5-1.1-1.1z" fill="#8CBEBF" />
            <path d="M44 35.7c0-.1 0-.3.1-.4.1-.2.3-.5.5-.7.2-.2.4-.3.7-.3.2 0 .4 0 .6.1.2.1.5.2.7.2.2.1.3.2.4.2.1.1.2.1.3.2h.7l.8-.1-.7 1.1-.2.2c-.2.3-.5.5-.8.6-.2.1-.5.1-.8.1-.4 0-.9 0-1.3-.1-.2-.1-.5-.2-.7-.4-.1-.2-.3-.4-.3-.7 0 .3.1.6.3.8.2.2.4.3.7.4.4.1.9.2 1.3.2.3 0 .5 0 .8-.1.3-.1.6-.4.8-.7l.2-.2.7-1-1 .1h-.6c-.1 0-.2-.1-.3-.2-.1-.1-.3-.2-.4-.3-.2-.1-.5-.2-.7-.2-.2-.1-.4-.1-.6-.1-.2 0-.4.1-.5.2l-.6.6c0 .1-.1.3-.1.5z" fill="#04534E" />
            <path d="M48.2 35.9H48c-.1 0-2-1.2-2.6-1.1s-1.2.3-1.2.9.1.6.3.8c.4.2.8.3 1.3.4h.7l.6-.1.5-.3.3-.2.2-.2.1-.2z" fill="#0C8489" />
            <path d="M45.2 35.5c0 .1 0 .2-.2.2s-.2 0-.2-.2.1-.2.2-.2.2.1.2.2zm.2-.5c0-.1.1-.2.2-.2s.2 0 .2.1-.1.2-.2.2c-.1.1-.2 0-.2-.1zm1.1.3c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2zm.2.7c0-.1.1-.2.2-.2s.2 0 .2.2 0 .2-.1.2-.3-.1-.3-.2zm-.5.5c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2c-.1-.1-.2-.1-.2-.2zm-1.1-.2c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2z" fill="#04534E" />
            <path d="M45.2 35.5c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.1.2-.1.2 0 .2.1zm.5-.5c0 .1 0 .2-.1.2s-.2-.1-.2-.2.1-.2.2-.2c0 0 .1.1.1.2zm1.1.3c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2.1.2.2z" fill="#8CBEBF" />
            <path d="M46.2 35.8c0 .1 0 .2-.2.2s-.2-.1-.2-.2.1-.2.2-.2.2 0 .2.2z" fill="#04534E" />
            <path d="M45.4 36.2c0 .1-.1.2-.2.2s-.2-.1-.2-.2.1-.1.2-.1.2 0 .2.1zm.8-.5c0 .1-.1.2-.1.2-.1 0-.2-.1-.2-.2s.1-.2.2-.2c0 .1.1.1.1.2zm.9.3c0 .1-.1.2-.2.2s-.2-.1-.2-.2 0-.1.1-.1.3 0 .3.1zm-.6.4c0 .1-.1.2-.1.2-.1 0-.2-.1-.2-.2s.1-.1.2-.1.1 0 .1.1z" fill="#8CBEBF" />
            <path d="M46.6 35.9h.3c.1 0 .1.1.1.1h-.2c0-.1-.1-.1-.2-.1zm-.3-.9c.1 0 .2.1.3.1.1.1.1.2.1.2h-.2c-.1-.1-.1-.2-.2-.3zm-.6.4c.1.1.2.1.3.2.1.1.1.1 0 .2s-.2 0-.2 0l-.1-.4z" fill="#04534E" />
            <path d="M45.6 35.6c.1 0 .2 0 .3.1.1 0 .1 0 .1.1 0 0 0 .1-.1.1s-.1 0-.2-.1l-.1-.2zm-.4-.8c.1 0 .2 0 .3.1.1 0 .1.2 0 .2s-.1 0-.2-.1c.1-.1 0-.2-.1-.2zm-.6.4c.1.1.2.1.3.2 0 .1.1.1 0 .2s-.2-.1-.2-.2 0-.1-.1-.2z" fill="#04534E" />
            <path d="M44.5 35.5h.5s-.1.1-.2.1l-.3-.1zm1.5 1s.2-.1.3-.1.1 0 .1.1-.1 0-.2 0H46zm-1-.2s.1-.1.2-.1h.1l-.1.1H45z" fill="#04534E" />
            <path d="M48 36.2c-.2.2-.4.4-.7.5-.4.2-.8.2-1.3.2-.4 0-.8-.1-1.2-.3-.3-.1-.5-.3-.7-.6 0-.1.1.2.1.2l.3.4.4.2.6.1.6.1h.4l.5-.1.3-.1.2-.1.2-.2.3-.3zm-.6-1.1s-.2 0-.5-.2c-.4-.3-1-.5-1.5-.5-.4 0-.8.2-1.1.6.1-.2.2-.3.3-.5l.3-.2h.6l.3.1.3.1.3.1.3.2.4.2.3.1zm1.1.3h-.6c-.1 0-.1 0-.2.1v.1l-.1-.3.6-.1.3.1v.1z" fill="#04534E" />
            <path d="M47.6 38.5c0 .1.1.2.2.2H48.7l.2-.2.1-.6.2-.2.6-.3.5-.1h.3l.4-.3.3-.2.1-.2.1-.3-.1-.4-.3-.5-.6-.2H50l-.5.2-1 .2c-.3.1-.6.4-.7.6-.2.3-.3.6-.2 1-.1.6-.1 1.3 0 1.3z" fill="#0C8489" />
            <path d="M47.6 38.5s0 .1.1.1c0 0 .1.1.2.1H48.8l.2-.3.1-.6.1-.1.1-.1.3-.2.2-.1.5-.1h.3l.4-.2.3-.2.2-.2.2-.3-.2-.3-.3-.5-.6-.2h-.5l-.5.2-1 .2c-.1 0-.2.1-.3.2-.2.1-.3.3-.5.5-.1.2-.2.3-.2.5s-.1.4-.1.6v.7c0 .2 0 .4.1.3-.1-.2-.1-.3-.1-.5v-.7c0-.2 0-.4.1-.6 0-.2.1-.3.2-.5s.3-.3.4-.5l.2-.1h.1l1-.2.5-.2h.5l.6.2.3.4.1.4-.1.3-.1.2-.3.3-.4.2h-.3l-.5.2-.3.2-.2.1h-.1l-.1.2-.1.5-.2.2H47.9h-.1s0-.1-.1-.1h-.1z" fill="#04534E" />
            <path d="M47.9 38.3c.2 0 0-.3.2-.7.1-.3.3-.5.5-.8.1 0 .1.1.2 0 .1 0 .2-.1.2-.2s.1-.3.2-.4c.1-.1.3-.2.5-.3h.2s-.1.1 0 .1.2 0 .3-.1v-.2c.1-.1.2-.1.3-.1.2 0 .2 0 .2.1s-.1.1-.1.2v.1c0 .1 0 .2.2.2.1 0 .1 0 .2-.1V36v-.1s0-.1 0 0 .3.3.3.2v-.3l-.3-.4-.5-.2-.7.1-.7.4-.7.3s0 .5-.2.4-.2-.3-.2-.2-.2.5-.2.6c-.1.3-.2.7-.2 1 0 .2.1.5.2.5h.1z" fill="#8CBEBF" />
            <path d="M48.5 37.5c-.1 0-.1 0-.1.1v.2c0 .1.1.1.1.1H48.8l.1-.1c0-.1 0-.1-.1-.1l-.3-.2zm1.1-.9c-.1 0-.1 0-.2.1v.1s0 .1.1.2.2.1.2 0 .1-.1.1-.2-.1-.1-.1-.1l-.1-.1zm.8.2s-.1-.1-.1 0c-.1 0-.1.1-.1.2s.1.1.2.1.1-.1.1-.2c-.1 0-.1 0-.1-.1zm-2.5.2c0 .1.1.2.2.2s.2-.1.2-.2-.1.1-.2.1 0 0-.2-.1c.1 0 .1 0 0 0z" fill="#8CBEBF" />
            <path d="M48.8 37.7c0 .1 0 .1-.1.2h-.2-.1l-.1-.1c0 .1.1.1.2.1.1-.1.2-.1.3-.2zm2.3-1.5c0 .1 0 .1-.1.2 0 0-.1.1-.2 0-.1 0-.1 0-.1-.1V36s.1.3.2.3c.1.1.1 0 .2-.1zm-2.1.6s-.1.2-.2.2-.1 0-.1-.1.1 0 .1 0c.1-.1.1-.1.2-.1zm.4-.1v.2s.1.1.2.1.1 0 .2-.1v-.1.1l-.1.1c-.1 0-.1 0-.2-.1v-.2zm.7-.7v.2h-.3.2c.1-.1.1-.1.1-.2z" fill="#04534E" />
            <path d="M47.8 38.7s.9 0 1-.1-.1-.6.5-1c.4-.3.8-.4 1.3-.4s.9-.3 1-.8c.1-.3-.4-.4-.6-.7s-.6-.2-.7-.2c-.3 0-.5.1-.8.2-.1.1-.1.3-.2.4s-.7 0-.7.1v.3l-.2-.1v-.5l.8-.5.9-.5h.6l.6.3.3.3c0 .1.1.3.1.4v.3c-.2.5-.6.8-1.2.9-.4 0-.9.2-1.2.4-.2.2-.4.9-.4 1-.3.2-.7.2-1.1.2z" fill="#04534E" />
            <path d="M48.2 36.9h-.1v-.4.3s.1 0 .1.1c0 0 0-.1 0 0zm.6-.1v-.2c.1-.1.2-.2.3-.2l-.1.2c-.1 0-.2.2-.2.2zm-.3.9v-.2c0-.1.2-.3.2-.3s0 .2-.1.2 0 .1-.1.3c.1-.1.1 0 0 0z" fill="#04534E" />
            <path d="M49 37.4l-.2.2c-.1 0-.2.1-.2.1s0-.1.1-.2c.1 0 .2 0 .3-.1zm.7-1.1l-.2.2c0 .1-.1.2 0 .2s.1-.1.1-.2.1-.2.1-.2z" fill="#04534E" />
            <path d="M50 36.7c-.1 0-.1-.1-.2-.1h-.2l-.1.1s.1 0 .1-.1h.2l.2.1zm-.2-.7s.1 0 .2-.1c0-.1.1-.1.1-.2l-.1.1c-.1 0-.2.2-.2.2zm1.2-.1c-.1 0-.1.1-.2.1-.1.1-.1.2-.1.2s.1 0 .1-.1c.1 0 .2-.1.2-.2zm-.3.8c0 .1-.1.1-.2.2s-.2.1-.2.1v-.1h.2l.2-.2z" fill="#04534E" />
            <path fill="#FFAD1A" d="M43.3 32.8L43.3 32.8 43 33.5 43.2 33.5 43.3 32.8z" />
            <path d="M42.5 34c-.1.4.1.8.4.8s.5-.2.6-.7-.1-.8-.4-.8-.6.3-.6.7z" fill="#FFAD1A" />
            <path fill="#A6AC56" d="M43.4 32.8L43.2 32.7 43.2 32.8 43.3 32.8 43.2 32.8 43.3 32.8 43.2 33.4 43 33.5 43.3 32.8 43.3 32.8 43.2 32.8 43.3 32.8 43.3 32.8 43.2 32.8 42.9 33.5 43.2 33.5z" />
            <path d="M43.4 32.5c-.1 0-.2.1-.2.2s0 .2.1.2.2 0 .2-.1v-.1c.1-.2 0-.3-.1-.2 0-.1 0-.1 0 0z" fill="#FFAD1A" />
            <path d="M43.4 32.5c-.1 0-.2.1-.2.2s.1.2.2.2.2-.1.2-.2-.1-.2-.2-.2c.1 0 .2.1.2.2s-.1.2-.2.2-.1-.1-.1-.2c-.1-.2 0-.3.1-.2z" fill="#A6AC56" />
            <path d="M43.5 32.5s-.2 0-.2.2c0 .1.1.2.2.2h-.1V32.6l.1-.1z" fill="#A6AC56" />
            <path d="M43.3 33s-.1 0 0 0l-.2.2.2-.4h.1l-.1.2z" fill="#A6AC56" />
            <path fill="#FFAD1A" d="M37.6 30.4L37.6 30.4 38 31.2 38.2 31 37.8 30.3z" />
            <path fill="#A6AC56" d="M37.8 30.3L37.6 30.3 37.6 30.4 37.6 30.4 37.6 30.4 37.7 30.4 38.2 31 38 31.2 37.7 30.4 37.6 30.4 37.6 30.4 37.6 30.4 37.6 30.4 37.6 30.4 38 31.2 38.2 31z" />
            <path d="M37.5 30c-.1.1-.1.2 0 .3.1.1.2.1.3 0 .1-.1.1-.2 0-.3-.1-.1-.2-.1-.3 0z" fill="#FFAD1A" />
            <path d="M39 31.7c.2.4.2.8-.1 1s-.6-.1-.8-.5-.2-.8.1-1 .6.1.8.5z" fill="#F15770" />
            <path d="M39 31.7c.2.4.2.8-.1 1s-.6-.1-.8-.5-.2-.8.1-1 .6.1.8.5z" fill="#FFAD1A" />
            <path d="M37.5 30c-.1 0-.1.1-.1.2s0 .1.1.2c0 .1.1.1.2.1s.1 0 .2-.1c.1 0 .1-.1.1-.2s0-.1-.1-.2c0-.1-.1-.1-.2-.1s-.2.1-.2.1h.1c.1 0 .1 0 .2.1 0 0 .1.1 0 .1 0 .1 0 .1-.1.1h-.1c-.1 0-.1 0-.2-.1v-.1l.1-.1z" fill="#A6AC56" />
            <path d="M37.6 30c-.1.1-.1.2 0 .3.1.1.2.1.3 0 .1-.1 0 0 0 0l-.1.1h-.2l-.1-.1v-.1l.1-.2zm.2.5v.4l-.2-.5.2.1z" fill="#A6AC56" />
            <path d="M37.6 31.8h.2c.1 0 .1-.1.1-.1v-.2c0-.1-.1-.2-.2-.2h-.2v-.1s-.3.3-.2.3h.1v.2c.1 0 .2.1.2.1zm.2-.6s.1.2.2.2h.2s.2-.1.2-.2V30.9h-.1v-.1s-.5.2-.4.2h.1c-.1.1-.1.2-.2.2z" fill="#E92736" />
            <path d="M38.8 31.1v-.3s-.1 0-.1-.1v-.1c0-.1-.4 0-.4.1s.1 0 .1 0l-.1.1V31.1H38.6l.1-.1.1.1z" fill="#E92736" />
            <path d="M37.9 31.4v.2h-.2v-.1s.1-.2.2-.1c-.1-.1 0 0 0 0zm0-.2v.1h.2c.1-.1.1-.2.1-.3h-.1c-.1.1-.2.1-.2.2zm.5-.3v.1c.1 0 .1.1.2.1l.1-.2-.1-.1c-.1.1-.1.1-.2.1z" fill="#FFAD1A" />
            <path d="M42.5 33.4l.2.2h.2s.1 0 .1-.1.1-.2 0-.2l-.1-.1v-.1c0-.1-.3 0-.3 0s.1 0 0 .1l-.1.1v.1z" fill="#E92736" />
            <path d="M43 33.2v.2c0 .1.1.1.1.1h.2l.1-.1s.1-.1.1-.2v-.1l.1-.1c.1-.1-.4-.2-.4-.1v.1c0 .1-.2.2-.2.2z" fill="#E92736" />
            <path d="M43.6 33.7s.2-.1.2-.2v-.1h.1c.1 0-.3-.3-.3-.2v.1h-.1l-.1.1v.2s0 .1.2.1c-.1 0-.1 0 0 0z" fill="#E92736" />
            <path d="M42.9 33.3s-.1.1-.2.1-.1-.2-.1-.2l.1-.1h.2v.2zm.2-.1s-.1.1 0 0c-.1.1 0 .2 0 .2l.2-.1s0-.1-.1-.1h-.1zm.4.2s-.1 0 0 0c-.1.1-.1.2-.1.2h.2c.1 0 0 0 0-.1s-.1-.1-.1-.1z" fill="#FFAD1A" />
            <path fill="#A64D21" d="M45 23.8L44.9 23.5 44.5 23.4 44.4 23.3 44.5 23.1 44.8 23 45.1 23 45.4 23 45.6 23.1 45.6 23.1 45.8 23.5 45.1 23.9 45 23.9z" />
            <path d="M47.3 19.6s-1.2-.2-1.2.8c0 .3.1.4.3.5.4 0 .9.2 1.2.5.3.2.5.5.5.9 0 .2 0 .3-.1.5l.3 1.3.3 1 .8-.5.5-1.5-.6-2.6-2-.9z" fill="#C8731E" />
            <path d="M47.3 19.6H47c-.2 0-.4 0-.6.1-.2.1-.4.4-.3.7 0 .1 0 .2.1.4.1.1.2.1.3.2.1 0 .3.1.5.1.2.1.5.2.7.4.2.1.3.3.4.5.1.1.1.2.1.4v.4l.3 1.4.3 1 .9-.5.5-1.5-.6-2.6-2-.9v.1l1.9.9.6 2.6-.5 1.4-.9.3-.3-1-.4-1.3c.1-.1.1-.3.1-.5 0-.1 0-.3-.1-.4-.1-.2-.2-.4-.4-.5-.2-.2-.4-.3-.6-.3-.2-.1-.4-.1-.5-.1-.1 0-.2-.1-.2-.1 0-.1-.1-.2-.1-.3 0-.2.1-.5.3-.6.2-.1.4-.1.6-.1l.2-.2z" fill="#8C380E" />
            <path d="M48.5 24.7c.2-.1.4-.3.5-.5 0-.1-.4-.5-.4-.5.1.1.2.1.3.2.1.1.2.1.2.1s.2-.5.2-.6c-.1-.2-.2-.3-.4-.5-.1-.1-.3-.1-.4-.1h.5c.2.1.2.2.2.2 0-.2 0-.4-.1-.6l-.3-.3h-.4c.1-.1.3-.1.5-.1.2.1.2.2.2.1 0-.2-.1-.3-.2-.5-.1-.1-.2-.2-.4-.3h-.4c.1-.1.2-.1.4-.1s.2.1.2.1l-.2-.1c-.2-.1-.5-.2-.7-.3h-.6c0-.1.1-.2.2-.2h.2c-.1-.1-.3-.1-.5-.1h-.9c0-.1.1-.1.1-.2.1 0 .1-.1.2-.1.2 0-.1-.2-.1-.2l.2-.2.7.1 1.4.8.7.6.4 1.1-.1 1.9-1 .8h-.4l.2-.5z" fill="#8C380E" />
            <path d="M47.2 20.1v-.3-.2c-.3 0-.6 0-.8.2-.2.2-.2.5-.1.7.1-.1.2-.2.3-.2h.5s-.1-.2-.2-.2h-.4c.2-.1.4-.1.5-.1.2 0 .3.1.2.1z" fill="#D2A567" />
            <path d="M48.7 24.8l-.3.1.2 1.3 1.2 2.1.7-.1.2-.4c.1 0 .1 0 .2.1s.3.5.5.6.3 0 .5.2l.9 1.2v-.4l-.2-.6-.2-.4v-.1h.3l.2.1.3.3.2.2.1.2v.2l.1.3.2.4.2.4.1-.1-.1-.4-.3-1-.2-.4c.1.1.2.2.3.2.1 0 .3.4.3.4l.2.4.1.3.1.3.1.3.2-.1v-.2l-.2-.7-.1-.8c.1 0 .2.1.2.1.1.1.2.3.2.4l.1.7.1.6-.1.5.2.4.1.2v-.3l-.3-2.8v-.1l.1.1c.1.1.1.2.2.3l.1.4v.3l.1.6.1.6.3.7.2.4.1-.4-.1-3 .1-.1.2.2c0 .1.1.1.2.2l.1.6.1 1.9.1.5.5-4.9.3-.1v-.1l-.2-.2-.5-.9-.4-.8-.7-1.2-1.1-1.4s-.7-.6-.9-.7c-.1-.1-.2-.2-.3-.2l.1-.2.2-.3h-.2l-.4.1-.4-.1-.8-.5-.8-.4-.5-.2-1.2-.3-1.1-.1H48l-.5.1c-.1.1-.2.1-.3.2-.1.1-.1.3-.1.5s.2.3.5.5c.4.2.7.4 1.1.6l.4.4.1.2v.1l.2 1.9-.5 1-.2.1z" fill="#A64D21" />
            <path d="M49.9 27.8c.1.2.2.2.4.1 0 0 .1 0 .1-.1.3-.3-.1-1-.1-1.1s.1-.1.1-.1l.2.4c.1.2.1.4.1.5-.1.2-.2.5-.4.6l-.4-.1v-.2z" fill="#C8731E" />
            <path d="M57 32.3l-.3-.8s-.1-.5-.1-.6 0-1.4-.1-1.6 0-.5 0-.5l-.3-.4-.1-.1h.1s.1.1.1 0c0-.3 0-.5-.1-.8-.2-.5-.4-1-.7-1.4h.1l.2.2.3.3.7.3.4.1.2.5c.1.4.1.8.2 1.3 0 .4-.1.8-.2 1.2-.1.7-.2 1.3-.2 2 0 .1 0 .3-.1.4l-.1-.1z" fill="#8C380E" />
            <path d="M57 30c.1-.1.2-.3.2-.4.1-.8.1-1.6-.1-2.4-.2-.2-.4-.3-.7-.4 0 .2.1.4.2.6.1.1.1.2.1.2 0 .1.1.2.1.3.1.3.1.7.2 1V30z" fill="#A64D21" />
            <path d="M56 31.2v-1.5c0-.7-.1-.7-.2-.9-.2-.3-.3-.7-.4-1.1-.1-.4-.2-.7-.3-1.1l-.3-.3v.2l-.3-.1-.1-.2.1-.3v.1-.2l.3.3.7.5.3 1.4.3.9v3l-.1-.7zm.4-4.2c.1.1.2.2.3.2.1.1.3.2.3.2-.1 0-.3-.1-.4-.1-.1 0-.1-.1-.2-.1V27z" fill="#8C380E" />
            <path d="M55 30.9c.1-.2.1-.5.1-.7 0-.5-.1-1-.3-1.5-.2-.3-.4-.5-.6-.9-.2-.5-.2-.6-.3-.8l-.3-.4V26l.6.3.3.1.3 1.5.3.4.1.6.2 1.4.1 1.1v.1l-.5-.6zm-.7-.7c0-.3 0-.6-.1-.8-.1-.3-.2-.6-.3-.8-.3-.3-.5-.6-.7-.9-.2-.3-.4-.6-.7-.9v-.6l.3.3.4.2.2.6.2.5.3.4.2.2.1.7.1.4.2.6v.3l-.2-.2zm-.5 0l-.2-.2c.1-.1.1-.2 0-.3 0-.2-.1-.4-.2-.6 0-.1-.1-.3-.2-.4-.1-.1-.6-.6-.8-.7-.2-.2-.4-.4-.6-.5-.1-.1-.2-.1-.3-.1l-.1-.7s.2.3.4.4l.4.1.5.9.2.2.5.4.2.4.1.4.2.6-.1.1zm-1-.1c-.1-.2-.3-.3-.3-.5s0-.2-.1-.5-.4-.6-.6-.8c-.2-.2-.6-.5-.6-.6s.1-.2.1-.2l.2.1.8.8.2.4.2.5.1.2.1.3-.1.3zm2.8-4.1s.5.6.7 0c0-.3-.1-.5-.2-.8 0 0-.5-.9-.7-1.1l-1-1.3-.6-.3.2.4c.4.4.7.9 1 1.4.4.6.5 1.2.6 1.7zm-3.1-3.9c.6.6 1.2 1.2 1.7 1.9.7 1 .9 1.6.8 1.7s-.6-.1-.8-.3c-.3-.5-.6-1-1-1.5-.2-.3-.6-.6-.9-.8l-.3-.8.5-.2zm-.5 2.1c.3.3.7.6 1 .9.2.2.4.5.6.7l.2.2s-.2-.3-.1-.4h.2l-2-2.1.1.7zm-.1.1c.1.3.3.5.5.7l.7.7.1.5s-.9-.7-.9-.5c0 .2.1.4.2.5l-.2-.2-.4-.5-.2-.5-.3-.7h.5z" fill="#8C380E" />
            <path d="M49.1 26.4s.5.4.7 0c.2-.3.2-.6.1-.9 0 0 .7 1 .8.1 0-.2-.4-.8-.4-.8l.2-.1.3.6c.2-.1.3-.3.3-.5 0-.3-.1-.6-.3-.9l.3.4s.6 0 .6-.4-.4-.9-.4-.9.4 0 .4-.2-.6-.4-.6-.6c0-.2.1-.3.3-.3h.1c.3.1.6.2.8 0s0-.3 0-.3l-.4-.1-.6-.3-.5-.2h-.4l.2.4.1 1v.5l.1 1-.2.8-.1.1-.1.1-.2.4-.3.3-.4.5-.4.3z" fill="#8C380E" />
            <path d="M52.5 28.3c-.1-.2-.2-.4-.4-.5-.2-.1-.4-.2-.7-.2l.7.7h.4zm.9.1c-.1-.3-.3-.5-.5-.7-.3-.3-.4-.6-.5-.6h-.1l.1.6.5.5c0-.1.4.3.5.2zm.8 0c-.1-.3-.2-.7-.4-1-.1-.3-.3-.5-.5-.7l.1.5.2.5.3.5.3.2zm.7-.3c.1-.5.1-.9 0-1.4-.1-.2-.3-.3-.5-.4l-.1.2.1.8.2.6.3.2zm.6-1.8c.2.1.3.3.3.4.2.5.4 1 .5 1.5h-.1l-.7-1v-.9z" fill="#C8731E" />
            <path d="M51 27.6s.3-.1.3-.2-.4-.4-.3-.6.3 0 .4-.1-.4-.5-.3-.7.4.6.4.6.2.4.1.5c-.2.7-.6.5-.6.5zm.8-.8s.5.1.5 0-.5-.5-.5-.5l-.1-.2h.4c.1 0-.4-.5-.4-.6s.1 0 .1 0c.2.2.3.4.5.5.2.2.3.6.2.9.1.4-.7 0-.7-.1zm2.4-.8s-.1-.4 0-.4.1-.1.2-.1c-.1-.1-.3-.1-.4-.2h-.2l.2.4.2.3z" fill="#D2A567" />
            <path d="M52.6 26.3c.3.1.6.1.8.1 0-.1-.6-.7-.6-.7v-.2h.4c.1 0 0 .2 0 .2l.3.4s-.1-.5 0-.6.3.3.4.3.5.4.6.2.1-.2.1-.3.2.5-.1.5c-.2 0-.3 0-.5-.1l-.2-.1-.1-.1s.1.4 0 .5H53l-.4-.1z" fill="#D2A567" />
            <path d="M41.6 24.5h-1.1c-.2 0-.4-.4-.3-1.2v-.1c-.1-.1-.2-.3-.2-.5s.9-.9 1-1h.2c.1-.1.2-.1.3-.2 0 0 .1 0 .1.1v.1l-.1.1c-.1.1-.2.2-.2.3v.1c0 .1 0 .2-.1.3l-.2.1c-.1.1-.1.2-.2.3V23.2c.2 0 .4 0 .6-.1.1-.1.2-.1.3-.2h.1c-.1.2-.2.3-.4.4l-.2.1c-.1.1-.2.1-.3.1v.3c.1.1.2.1.3.1.2 0 .5 0 .7-.1l-.3.9v-.2zm.3-.9c-.2.1-.5.1-.7.1-.1 0-.2 0-.3-.1v-.2c.1 0 .2 0 .3-.1.1 0 .1-.1.2-.1.2-.1.3-.2.4-.4h-.1c-.1.1-.2.1-.3.2-.2.1-.4.1-.6.1V23v-.1c0-.1.1-.2.2-.3l.1-.1c0-.1.1-.2.1-.3v-.1c0-.1.1-.2.2-.2s.1-.1.1-.1v-.1c0-.1-.1-.1-.1-.1-.1 0-.2.2-.3.2 0 0-.2-.1-.3 0s-1 .7-1 1c0 .2.1.4.2.5v.1c0 .3 0 1.2.4 1.2h1.1l.4-1z" fill="#6A7311" />
            <path d="M54.4 25.8s.8.5.9.4-.2-1.3-.2-1.4.7 1.4.4 1.6-.4 0-.4 0l-.4-.2-.3-.4zm2.4 2.1c.1 0 .1.1.2.1h.1l-.3-.1zm-.8-2.8s.1 0 .1.1l.1.1H56v-.2zm-.3-.4h.2c.1-.1.1-.1.1-.2s-.2 0-.2-.1l-.1-.1H55.4l.3.4zm.8 2.4c.1.1.2.1.3.2.1 0 .2.1.2.1h-.3c-.1-.1-.1 0-.1 0l-.1-.3zm-1.4-3.9h.2c0 .1 0 .2-.1.3-.1 0-.2.1-.2.1l-.3-.4h.4zm-1.3-1h.2c.1 0 .2 0 .3.1.1.2.1.4.1.7 0 .1-.6-.3-.6-.4s-.3-.4-.3-.4h.3zm-.5-.3s.4 0 .4-.2-.1-.3-.2-.4l-.5.4.3.2zm-1.1-.5h.2c.1 0 .5-.5.7-.5h.3v.4c-.2.1-.5.3-.8.4h-.2l-.2-.1v-.2zm-.2-.7c-.1-.2-.3-.3-.4-.3s.2.3.3.6v.6h.1v-.8-.1zm-1-.4c-.3-.3-.6-.5-.9-.6 0 0 .7.4.9.6.1.3.1.7.1.8s.1 0 .2 0 .1-.1 0-.1 0-.2 0-.2l-.1-.2-.1-.1-.1-.2z" fill="#D2A567" />
            <path d="M50.1 19.9c-.5-.4-1.1-.6-1.7-.5-.6 0-.9 0-.8.4s.4.5.9.5c.3-.1.6-.1.9 0l.6.3c-.1-.2-.3-.3-.4-.5-.3-.2-.4-.3-.4-.3s0-.1.3-.1c.4 0 .7.2.9.6.1.2.1.3.1.5 0 .1.1 0 .1 0v-.1-.2c-.1-.1-.1-.3-.2-.4-.2-.2-.3-.2-.3-.2zm-1.6 4.9c.5-.2.9-.6.9-1.2 0-.8-.1-1.5-.4-2.2-.1-.1.2-.1.3.1.3.6.4 1.2.4 1.8.1.5-.1 1-.5 1.3-.2.2-.4.3-.7.3v-.1zm.8 2s.1.2.3.1.7-.3.7-.7-.3-.5-.3-.5v-.2l.3.1.1.4s.1.1.2.1.4-.3.4-.5-.4-.5-.4-.6v-.2h.3l.1.3c0 .1.1.1.2.1.2 0 .4-.3.3-.4s-.2-.4-.3-.5v-.1l.1.1h.3c.2-.1.4-.2.4-.3s-.2-.3-.2-.3v-.1h.1l.2.2v.2l-.1.1-.2.3-.2.1h-.1l.2.3v.2l-.2.2-.3.2v.3l-.2.4-.4.2h-.1v.2l-.2.3-.4.3-.3.1-.3-.4zm2.2-3.6s.7.2.7-.2c0-.2-.7-.8-.7-.9v-.2l.3.3s.4.1.5-.1 0-.4 0-.4H52.6v.3l-.2 1s.1.4-.2.4c-.2 0-.4-.1-.7-.2zm.7 5.1c0-.1-.1-.2-.1-.3-.1-.1-.3-.2-.5-.3l.5.6h.1zm.9 0c-.1-.2-.3-.4-.4-.5-.1-.1-.2-.5-.4-.5s.1.5.1.5l.5.5h.2zm1 0s-.3-.5-.4-.7c-.1-.3-.2-.5-.4-.7-.2-.1 0 .2 0 .2l.2.6.3.5.3.1zm.6-.4c0-.3 0-.5-.1-.8 0-.2-.2-.4-.3-.6v.6l.4.8zm1.4.3s-.2-.6-.3-.8c-.1-.3-.2-.5-.3-.7 0 .2 0 .3.1.5l.3.8.2.2zm1.2-1.4c-.2-.2-.4-.3-.7-.4-.3-.1-.6-.2-.9-.2l.1.1.2.2.5.2.6.1h.2z" fill="#D2A567" />
            <path d="M52.4 27.1c0 .2.1.5.2.6l.8.8c.1.3.2.7.3 1 .1.4.2.8.2.9s.2.3.1.3-.2-.1-.2-.3V30c-.1-.5-.2-1-.5-1.4-.4-.3-.8-.7-1.1-1.1-.2-.3-.2-.4-.2-.4h.4z" fill="#59270E" />
            <path d="M53.5 29.7c-.1-.2-.2-.5-.2-.7-.2-.3-.5-.5-.8-.7h-.4c-.1 0-.6-.7-.6-.7l-.1.1.8.8c.2.3.4.6.5 1 .2.3.1.3.1.4s.1.3.2.3.1 0 .1-.1c-.2-.2-.3-.4-.4-.6-.1-.4-.2-.7-.4-1h.2c.3.1.6.4.8.7 0 .1.1.4.2.5.1.3.2.5.4.7-.2-.2-.3-.4-.4-.7zm-.9-3.4c.2.1.4.2.5.3h.2c0 .4.2.8.4 1.2.1.2.3.4.5.6 0 .5.1.9.2 1.4.2.4.3.9.2 1.4 0 .1-.2-.3-.4-.7s-.2-.8-.3-1.1c-.1-.3-.2-.5-.4-.8-.1-.1 0-.1 0 0 .2.2.3.5.4.8.1.4.2.9.3.9.1 0 .1-.1.1-.1 0-.1-.1-.3-.2-.7 0-.3-.1-.5-.2-.8-.2-.2-.3-.4-.4-.6-.2-.3-.3-.6-.4-.9V27c-.1 0-.2-.1-.3-.1 0-.3-.2-.4-.2-.6zm1.1-.2c.1.1.3.2.4.3.1 0 .2.1.3.1 0 .4.1.8.2 1.2.2.3.3.5.6.7 0 0 0 .2.1 1.2s.1 1 .1 1.4v1.8c-.2-.2 0-.9-.1-1.3-.2-.4-.4-.8-.5-1.3-.2-.9-.1-1.1-.2-1.4s-.3-.4-.3-.4c.2 0 .3.2.4.3.1.3.1 1 .2 1.4.1.4.3.9.5 1.3 0 0-.1-1.1-.2-1.7 0-.4-.1-.9-.2-1.3-.1-.2-.3-.4-.5-.7-.1-.3-.2-.7-.3-1.1-.1-.2-.1-.1-.2-.1-.2 0-.3-.2-.3-.4z" fill="#59270E" />
            <path d="M54.4 25.8c.2.2.3.3.5.4.2.1.3.1.5.2 0 .4.1.9.3 1.3.3.6.5.6.5.7s.1 1.8.1 2.4.1 2.5-.2 2.5 0-1.5-.2-1.8c-.1-.2-.1-.3-.2-.5-.1-.3-.1-1.4-.3-2-.1-.5-.3-.5-.3-.5.2.1.3.3.3.5.1.4.1 1.7.3 1.9.1.2.3.4.3.7 0-.9 0-1.8-.1-2.7-.3-.5-.5-1.1-.6-1.7 0-.5-.1-.6-.1-.6-.2 0-.3-.1-.5-.2 0-.3-.2-.5-.3-.6z" fill="#59270E" />
            <path d="M55.6 26.1c.2.2.4.4.7.5.3.1.7.2 1 .2.3.5.4 1.2.4 1.8 0 .6-.1 1.2-.3 1.7-.2.8-.2 2.6-.2 2.8-.1.1-.1.2-.1.3 0 .2 0 .5-.1.5s-.2-.2-.2-.4c.1-.3.1-.7.2-1.1 0-.4-.1-.7-.2-1.1-.1-.5-.1-2.3-.1-2.5-.1-.2-.2-.4-.4-.5.2.1.3.3.4.4.1.2.1 2.2.2 2.6s.1-.1.1-.3c.1-.6.1-1.1.1-1.7 0-.6-.2-1.2-.4-1.8.1.1.1.2.2.4l.1.1c.1 0 .2.1.2.1H57l-.2-.1c.1.4.2.9.2 1.3-.1.9-.1 1.9 0 2.8.1 0 .1-1 .3-1.9s.3-1 .3-1.7c0-.6-.2-1.1-.4-1.6-.2-.1-.6-.1-1-.3s-.7-.5-.6-.5zm-6.1.9h.3c.2-.1.6-.4.6-.6v-.3s0 .1.1.1c.2-.1.4-.2.5-.4v-.5c0-.1.1.1.2 0s.4-.3.4-.5-.1-.3-.2-.4h.3c.1 0 .4-.2.4-.4s-.1-.5-.4-.5h.4c.2 0 .3-.2.3-.4-.1-.3-.2-.5-.5-.7-.1 0 .4.1.5-.1.1-.1.1-.3.1-.4 0-.1-.1-.1-.1-.1.2 0 .3 0 .5-.1s.4-.3.7-.3c.1 0-.4.3-.4.5s.2.2.4.4c.2 0 .4.1.5.1h-.4c.4.3.7.6 1 .9 0 0 .1.1.2.1H54.8c.2.3.4.6.6.8 0 .1.1.1.2.1h0l.6 1c-.3-.6-.7-1.1-1.2-1.6-.6-.7-.8-.8-.8-.7.2.4.5.8.8 1.1.3.5.5 1 .5 1-.4-.8-.9-1.5-1.5-2.2-.9-.8-1-1-1.1-.9s-.2.6-.1.8.7.6 1.3 1.3c.5.6.9 1.2 1.3 1.8-.4-.6-.9-1.2-1.4-1.7-.8-.7-1.2-.9-1.2-.9s-.1.2-.2.3-.3.1-.3.2c.3.3.6.6.9.8.2.1.2 0 .3.1.1 0 .2.1.2.2-.1 0-.2-.1-.3-.1h-.2c.2.3.4.6.7.8.1 0 .2 0 .3.1.1.1.2.1.3.2-.1-.1-.2-.1-.3-.1H54s.5.6.4.6-.7-.8-1.3-1.3-.8-.6-.8-.6 0 .2-.2.2-.3.1-.3.1l.9.9c.4.4.7.8.7.8l-.8-.8c-.4-.4-.6-.5-.7-.5v.3s.8.9.8 1-.9-1-.9-1-.1.1-.1.2-.3.1-.3.1l1.2 1.3c-.3-.3-.6-.6-1-.8l.4.9s-.9-1.2-1-1.2 0 .1-.2.2-.3.1-.3.1l.8 1s-.8-.9-.9-.8v.1c.1.2.2.4.2.6l-.3-.5-.2.2c-.1.1-.2.1-.2.1s.2.1.2.3c.1.1.1.3.1.4-.1-.1-.1-.3-.2-.4-.1-.1-.2-.2-.3-.2-.1 0-.1 0-.2.1V27z" fill="#59270E" />
            <path d="M57.3 26.8s.3 0 .3-.1-.1 0-.3-.3-.9-2.1-1.6-3c-.6-.8-1.3-1.6-2.2-2.2.9.6 1.6 1.3 2.2 2.1 1 1.4 1.2 2.6 1.5 2.9s.5.4.5.4c0 .1-.1.2-.2.2h-.2zm-8.3-.4c.1 0 .5-.3.4-.4-.1 0-.2-.1-.3-.2-.1-.1-.1-.2-.2-.3.1.1.1.2.2.3.1.1.2.1.3 0s.6-.4.5-.6c-.1 0-.2 0-.3-.1-.1-.1-.2-.2-.2-.3.1.1.1.2.2.2.1.1.2.1.3 0 0 0 .4-.5.3-.6-.1 0-.2 0-.3-.1-.1-.1-.2-.2-.2-.4l.3.3c.2 0 .3 0 .4-.2 0-.1.1-.6 0-.8H50c.1-.1 0-.2 0-.3.1.1.2.2.3.2.1 0 .3 0 .3-.2v-.5c-.1-.1-.2-.1-.2-.4 0 0-.1.1-.3.1s-.4-.3-.4-.3c.1.1.3.2.4.2.2 0 .3-.1.3-.3 0-.1-.1-.2-.2-.4s-.1-.3-.1-.3-.1.1-.3.1c-.1 0-.3-.1-.3-.2.1.1.2.1.3.1.2 0 .2-.1.2-.2s0-.3-.4-.6-.6-.5-.6-.5c.2.1.5.3.7.5.2.1.3.3.4.5 0 0 .3.1.3 0s0-.3-.1-.4c-.1-.2-.2-.3-.4-.4.2.1.3.3.4.5.1.1.1.3.1.5.4.1.6.1.9.1.1-.1.1-.2 0-.4l-.2-.3c.1.1.2.2.2.3.1.2.2.3.1.4l-.1.1c.1.1.3.2.4.2.2.1.4.2.4.1V21c0-.2-.1-.3-.1-.5.1.1.1.3.2.5v.4c.1 0 .1.1.2.1-.1.1-.2.1-.4 0s-1.3-.6-1.4-.6.5.4.8.6c.1.1.3.3.4.5-.1-.1-.2-.2-.4-.3-.3-.1-.5-.3-.8-.4l.2.1s-.2.2-.2.3.8.6.8.7-.2.2-.2.2l-.4-.3s.2.2.2.3-.2.1-.1.2.5.5.5.6-.2.2-.2.3.3.4.3.4c-.1-.1-.2-.2-.3-.2-.1-.1-.2-.3-.2-.2-.1.1-.1.3-.2.4 0 .1.2.2.2.4v.4c-.1-.1-.2-.2-.3-.4-.1 0-.1 0-.2.1s-.2.4-.2.4.3.1.3.3c0 .2-.1.3-.2.4 0 0-.3-.4-.4-.4l-.4.4s.2.2.2.3-.2 0-.3 0c-.1 0-.2.1-.3.1l-.2.3z" fill="#59270E" />
            <path d="M53.5 21.2c0-.1 0-.1.1-.2 0-.1.3-.3.2-.3h-.5c-.1 0-.3 0-.8-.4-1.2-.8-2.6-1.2-4.1-1.3-.8 0-1.1.2-1.2.4.3-.3.6-.4 1-.3 1.5.1 2.9.5 4.1 1.2.2.2.6.4.9.4.4 0 .5-.1.5 0s-.1.2-.2.3c.1.1 0 .2 0 .2zm-4.3.4c-.1-.2-.3-.4-.5-.5-.4-.3-.9-.5-1.4-.7.5.2.9.5 1.3.8.3 0 .5.2.6.4z" fill="#59270E" />
            <path d="M49.2 23.3c-.1-.1-.2-.2-.3-.2-.1-.1-.3-.1-.4-.2.2 0 .3 0 .5.1.1.1.2.2.2.3zm-.1-.9c-.1-.1-.2-.2-.4-.2-.1-.1-.2-.1-.4-.1.2-.1.3-.1.5 0s.2.2.3.3zm-.2-.8c-.1-.1-.2-.2-.3-.2-.1-.1-.3-.1-.5-.1.2-.1.4-.1.5 0 .2 0 .3.2.3.3zm-.3-.4s-.1-.1-.6-.2c-.2-.1-.5-.1-.7-.1h.9c.2 0 .3.1.4.3zm-.9-.6c-.2 0-.4-.1-.6-.1h-.8c.4-.1.7-.1 1.1-.1.2.1.3.2.3.2z" fill="#D2A567" />
            <path d="M44.8 31.3c.1.2.3.3.5.3.3 0 .5.4.5.4l-.3.3h-.8l-.3-.3.4-.7z" fill="#FFAD1A" />
            <path d="M44.8 31.3l.1.1c.1.1.2.1.4.1.1 0 .3.1.4.2l.1.1-.3.3h-.8l-.2-.1.3-.7-.4.7.3.4h.8l.3-.3c0-.1-.1-.2-.2-.2-.1-.1-.2-.2-.4-.2-.1 0-.2-.1-.3-.1l-.1-.1v-.2z" fill="#8F5E36" />
            <path d="M44.8 31c-.1-.3-.2-.5-.4-.7-.2-.1.1.2 0 .3 0 .1-.1.2-.1.2s.2.2.1.3.4-.1.4-.1z" fill="#FFAD1A" />
            <path d="M44.8 31v-.1c-.1-.1-.1-.2-.2-.3-.1-.1-.1-.2-.2-.2h-.1v.2c0 .1-.1.2-.1.2l.1.1v.2h.1l.2-.1h.2-.2l-.1.1V31v-.2l-.1-.1c0-.1 0-.2.1-.2v-.2l.3.3c0 .1.1.1.1.2s0 .1-.1.2z" fill="#8F5E36" />
            <path d="M45 31.8c.1 0 .2-.1.2-.1l-.5.1c.1 0 .2.1.3 0z" fill="#FFAD1A" />
            <path d="M44.7 31.8H45c.1 0 .2-.1.2-.1-.1.1-.1.1-.2.1H44.7z" fill="#8F5E36" />
            <path d="M44.6 31.6s.5-.3.4-.5-.1-.2-.2-.1-.3.2-.3.3c0 .1 0 .2.1.3z" fill="#FFAD1A" />
            <path d="M44.6 31.6l.2-.2.1-.2s.1-.1.1-.2 0-.1-.1-.1h-.2l-.2.1-.1.1v.1c.1.2.2.3.2.4v-.2-.2c0-.1.1-.1.2-.2l.1-.1h.2s0 .1.1.1c0 0 0 .1-.1.1-.1.1-.1.2-.2.2l-.3.3z" fill="#8F5E36" />
            <path d="M44.2 31.8s.1.2.2.2.3-.1.4-.2-.2-.2-.2-.3-.3.1-.3.1l-.1.2z" fill="#FFAD1A" />
            <path d="M44.2 31.8s0 .1.1.1c0 .1.1.1.2.1s.2 0 .2-.1c0 0 .1 0 .1-.1v-.1c0-.1 0-.1-.1-.2 0-.1-.1-.1-.2-.1h-.4l.1.4v-.3c.1 0 .1-.1.2-.1s.1.1.2.1l.1.1c-.1.1-.2.1-.3.1 0 .2-.1.2-.2.1z" fill="#8F5E36" />
            <path d="M44.7 31.5c0 .1-.3.2-.4.2s-.3-.2-.3-.2.2 0 .2-.1.1-.1.1-.1.2 0 .2.1.2.1.2.1z" fill="#FFAD1A" />
            <path d="M44.7 31.5l-.2.1h-.2l-.1-.1v-.1c.1 0 .2 0 .2-.1l.1-.1h.1s.1 0 .1.1v0-.1l-.1-.1h-.1l-.1.1c-.1 0-.2 0-.2.1v.1l.1.1.1.1c.1 0 .2 0 .2-.1h.1v-.1.1z" fill="#8F5E36" />
            <path d="M44.4 31.7s-.4.6-.6.6.1-.8.1-.8c.1 0 .1.1.2.1.1-.1.2 0 .3.1z" fill="#FFAD1A" />
            <path d="M44.4 31.7c-.1.2-.2.3-.3.4l-.2.1h-.1v-.1c0-.1 0-.3.1-.4V31.4c.1 0 .2.1.2.1l.2.1c.1 0 .1.1.1.1 0-.1 0-.1-.1-.1l-.3-.1-.2-.1c-.1.2-.1.5-.2.7v.1s0 .1.1.1.1 0 .2-.1c.2-.1.4-.3.5-.5z" fill="#8F5E36" />
            <path d="M43.6 31.3s.6.1.6.2-.3.2-.4.2-.2-.4-.2-.4z" fill="#FFAD1A" />
            <path d="M43.6 31.3l.4.1h.1c-.1.1-.2.1-.4.1l-.1-.1v-.1.2l.1.1c.1 0 .2 0 .3-.1 0 0 .1 0 .1-.1 0 0 .1 0 .1-.1-.1 0-.2-.1-.3-.1l-.3.1z" fill="#8F5E36" />
            <path d="M42.2 32.2s.1.3.3.3c.2 0 .4-.1.5-.2l-.6-.3-.2.2z" fill="#59270E" />
            <path d="M42.2 32.2s0 .1.1.1c.1.1.2.1.3.2.2 0 .4-.1.5-.3l-.7-.2-.2.2.2-.2.6.2c-.1.1-.3.2-.4.2-.1 0-.2-.1-.2-.1l-.2-.1z" fill="#4B4139" />
            <path d="M42.3 32.1c.1.1.2.2.4.2s.4-.1.6-.2l-.5-.4c0-.1-.5.4-.5.4z" fill="#59270E" />
            <path d="M42.3 32.1c.1.1.3.2.4.2.2 0 .4-.1.6-.3l-.5-.4-.5.5.4-.4.5.4c-.1.1-.3.2-.5.2-.1 0-.2-.1-.4-.2.1 0 .1 0 0 0z" fill="#4B4139" />
            <path d="M42.4 32.1c.1.1.2.1.3.1h.4l-.2.1H42.6l-.1-.1-.1-.1z" fill="#4B4139" />
            <path d="M42.7 31.9s.2.3.4.3.3-.2.3-.2l-.3-.5-.4.4z" fill="#59270E" />
            <path d="M42.7 31.9c0 .1.1.1.1.2.1.1.2.2.3.2.1 0 .2 0 .3-.1v-.1l-.3-.5-.4.3.3-.4.3.5s0 .2-.3.2c-.1 0-.2-.1-.3-.1.1-.2 0-.2 0-.2z" fill="#4B4139" />
            <path d="M42.8 31.9s.2.2.3.2c.1 0 .2 0 .3-.1h-.5l-.1-.1zm-.6.4c.1.1.2.1.3.2.1 0 .2 0 .3-.1l-.1.1H42.4l-.1-.1-.1-.1z" fill="#4B4139" />
            <path d="M43.5 31.3c.1 0 .4.4.4.5s-.1.5-.2.5-.5-.3-.5-.4-.1-.2-.1-.3c.2-.2.3-.3.4-.3z" fill="#FFAD1A" />
            <path d="M43.5 31.3h.1l.2.2c0 .1.1.2.1.2v.3s0 .1-.1.1h-.1-.1c-.2-.1-.3-.2-.4-.4 0-.1-.1-.2-.1-.2s0-.1.1-.1l.2-.1h.1l-.1.2-.1.1s-.1 0-.1.1v.1c0 .1.1.2.1.3.1.1.1.2.2.3l.2.1.1.1s.1 0 .1-.1c.1-.3.1-.5.1-.6 0-.1-.1-.3-.2-.4 0-.1-.1-.1-.1-.1 0-.1 0-.1-.2-.1z" fill="#8F5E36" />
            <path d="M42.2 31.3s-.2-.2-.3-.1c-.1.1-.1.3 0 .5.1.1.3-.1.3-.1v-.3z" fill="#FFAD1A" />
            <path d="M42.2 31.3c-.1-.1-.2-.1-.3-.1h-.1c0 .1-.1.1-.1.2v.2h.1l.2-.1.2-.2-.1.2-.1.1h-.1v-.1-.1-.2c.1 0 .1 0 .2.1h.1z" fill="#8F5E36" />
            <path d="M42.1 31.5s-.3 0-.3.2c0 .1.1.2.2.3l.3-.1-.2-.4z" fill="#FFAD1A" />
            <path d="M42.1 31.5H42l-.1.1s-.1.1 0 .1c0 .1 0 .1.1.2v.1h.1c.1 0 .2-.1.2-.1l-.2-.4.2.4-.1.1h-.1s0 .1-.1.1l-.1-.1c0-.1-.1-.1-.1-.2v-.1s.1-.1.2-.1l.1-.1z" fill="#8F5E36" />
            <path d="M42.2 31.8s-.3.1-.3.2.1.3.2.3.2-.2.2-.2l-.1-.3z" fill="#FFAD1A" />
            <path d="M42.2 31.8c-.1 0-.1 0-.2.1 0 0-.1 0-.1.1l-.1.1c0 .1 0 .1.1.2 0 0 0 .1.1.1h.2l.1-.1.1-.1v-.1l-.2-.3.1.1v.1l-.1.1-.1.1H42l-.1-.1V32l.2-.1h.1v-.1z" fill="#8F5E36" />
            <path d="M42.4 30.9h-.2c-.2.1-.3.2-.2.4 0 .1 0 .2.1.3l.5-.2-.2-.5z" fill="#FFAD1A" />
            <path d="M42.4 30.9h-.1-.1c-.1 0-.1.1-.2.2s-.1.2-.1.2c0 .1.1.2.1.3l.5-.2-.1-.5.1.5-.5.1v-.3c0-.1 0-.2.1-.2 0-.1.1-.1.2-.1h.1z" fill="#8F5E36" />
            <path d="M42.4 31.2s-.4.1-.4.3c0 .1.1.3.2.3s.4-.3.4-.3l-.2-.3z" fill="#FFAD1A" />
            <path d="M42.4 31.2c-.1 0-.1 0-.2.1-.1 0-.1.1-.2.1l-.1.1c0 .1 0 .1.1.2 0 .1.1.1.2.1h.1c.1-.1.2-.2.3-.2l-.2-.4.2.3-.2.2-.1.1h-.1l-.1-.1v-.2s0-.1.1-.1.1-.1.2-.1v-.1z" fill="#8F5E36" />
            <path d="M42.8 31.9c-.1.1-.3.2-.4.3-.1-.1-.2-.2-.2-.3 0-.1.3-.2.4-.3s.2.3.2.3z" fill="#FFAD1A" />
            <path d="M42.8 31.9l-.2.1-.2.1h-.1c-.1-.1-.1-.2-.1-.2 0-.1.1-.1.2-.1s.1-.1.2-.1c.1-.1.1 0 .2.2-.1-.1-.1-.1 0 0-.1 0-.1 0 0 0-.1 0-.1-.1-.1-.1s0-.1-.1-.1l-.2.1c-.1 0-.1.1-.2.2 0 .1 0 .1.1.2v.1h.1l.2-.1.2-.3z" fill="#8F5E36" />
            <path d="M43.1 30.5c-.1-.1-.2-.1-.4-.1s-.4.3-.4.5 0 .4.1.5.6-.4.6-.4l.1-.5z" fill="#FFAD1A" />
            <path d="M43.1 30.5c-.1-.1-.2-.1-.3-.1-.1 0-.2.1-.3.2-.1.1-.1.2-.2.3V31.2c0 .1 0 .1.1.1s.1 0 .2-.1.3-.2.4-.3l.1-.4-.1.5h-.1c-.1.1-.2.1-.3.2l-.1.1h-.1l-.1-.1V31v-.1c0-.1.1-.2.1-.3.1-.1.2-.2.3-.2.2 0 .3 0 .4.1z" fill="#8F5E36" />
            <path d="M42.6 31.6c-.2 0-.3-.2-.3-.4.1-.2.3-.3.5-.4.2 0 .1.5.1.5s-.1.3-.3.3z" fill="#FFAD1A" />
            <path d="M42.6 31.6c-.1 0-.1-.1-.2-.1 0-.1-.1-.1-.1-.2 0 0 0-.1.1-.1l.2-.2c.1 0 .1-.1.2-.1h.1c0 .1.1.2.1.3v.1l-.1.2c-.1.1-.2.1-.3.1.1 0 .2 0 .3-.1l.1-.1v-.1-.3-.1h-.1c-.1 0-.2.1-.3.1-.1 0-.1.1-.1.1l-.1.1c0 .1 0 .2.1.2 0 .2.1.2.1.2z" fill="#8F5E36" />
            <path d="M43.2 31.6c-.1.1-.1.2-.2.3-.2.1-.3 0-.4-.1s0-.2.1-.3c.1-.1.2-.1.3-.1 0-.1.2.2.2.2z" fill="#FFAD1A" />
            <path d="M43.2 31.6c0 .1-.1.2-.2.2h-.1-.1l-.1-.1v-.1-.1l.1-.1.2-.1h.1l.1.3-.2-.3h-.1c-.1 0-.1 0-.2.1l-.1.1-.1.1v.1l.1.1h.2c.2 0 .3-.1.4-.2z" fill="#8F5E36" />
            <path d="M42.9 31.1s-.2.1-.1.3.2.2.3.2.2 0 .3-.1.2-.2.2-.3c0-.1-.1-.2-.2-.3-.1-.1-.4 0-.5.2z" fill="#FFAD1A" />
            <path d="M42.9 31.1c-.1.1-.1.1-.1.2v.1c0 .1.1.1.2.2.1 0 .1.1.2.1h.1c.1 0 .2-.1.3-.2l.2-.1c.1 0 .1-.1.1-.2s-.1-.3-.2-.3h-.1c-.4 0-.6.1-.7.2.1-.1.3-.2.5-.2h.1c.1.1.2.2.2.3 0 .1 0 .1-.1.1 0 0-.1.1-.2.1-.1.1-.1.1-.2.1s-.1 0-.2-.1c-.1 0-.1-.1-.1-.2v-.1c-.1.1-.1.1 0 0z" fill="#8F5E36" />
            <path d="M43.4 30.4h-.3c-.1.1-.2.2-.2.4v.4c.1 0 .2-.1.3-.2.1-.1.2-.1.2-.2s-.1-.1-.1-.2c-.1-.2.1-.3.1-.2z" fill="#59270E" />
            <path d="M43.4 30.4h-.3c-.1.1-.2.2-.2.3v0c0-.1.1-.2.3-.3 0-.1.1-.1.2 0z" fill="#4B4139" />
            <path fill="#59270E" d="M50.4 32.5L50.4 32.5 50.4 31.6 47.8 32.3 48.8 33.3z" />
            <path d="M45.7 30.9l-.2-.2c-.1 0-.2-.1-.2-.1h-.2v.1l.2.3.4.2.1.1h.1l-.2-.4z" fill="#D2A567" />
            <path fill="#D2A567" d="M45.4 31.3L45.5 31.3 45.6 31.3 45.8 31.3 45.9 31.5 46 31.6 46.1 31.9 46.2 32 45.9 31.9 45.9 31.9 45 31.7 45.1 31.5 45.3 31.4z" />
            <path fill="#D2A567" d="M46.4 30.5L45.7 29.8 45.6 30.2 45.8 31 45.9 31.5 46.2 32 46.2 32 46.3 31.9 46.4 31.9 46.3 31.5z" />
            <path d="M45.7 30.1v.3c.1.4.2.8.4 1.2.2.4-.2-.3-.2-.3-.2-.4-.3-.9-.3-1.4 0-.5.1.2.1.2z" fill="#C8731E" />
            <path d="M46.2 30.6c-.1.1-.2.3-.2.4v.4s0-.2.1-.2.1.4.1.5.1-.8.1-.8l-.1-.3zm0 1.7c-.3 0-.5-.1-.8-.2-.4-.2-.6-.3-.6-.4s.7 0 .8 0 .4.2.4.2h.2l.3-.1v.3l-.3.2zm-1.2-.1s.2.1.1.2h-.4l.7.2.2-.1-.6-.3z" fill="#C8731E" />
            <path d="M44.8 32s0 .1.3.1h.4l.1.1h.1l-.1.2-.5-.1-.3-.1V32z" fill="#D2A567" />
            <path fill="#C8731E" d="M46.7 31L46.4 30.8 46.4 30.8 46.5 31.6 46.6 31.8 46.7 31.4z" />
            <path d="M45.7 30.9l-.2-.4-.3-.5.2-.3.2.3v.4c0 .2.1.4.1.5z" fill="#8C380E" />
            <path d="M44.2 32.3c.1-.1.2-.2.3-.2h.4l.5.2.1.2-.9-.1-.4-.1z" fill="#D2A567" />
            <path d="M46.5 30.7v.7c0 .2.1.3.1.4s0 .1-.2.1h-.3s.2 0 .2-.1-.1-.2-.1-.4V31l-.1.1c0-.2.1-.5.1-.7.1 0 .3.3.3.3z" fill="#A64D21" />
            <path d="M44.9 32.1l-.1-.1c.1.2.4.3.6.3h.6s0 .2-.1.2l-.4.2-.1.1v-.4l-.4-.2-.1-.1z" fill="#C8731E" />
            <path d="M45.7 30.9c-.3-.3-.5-.6-.7-.9-.1-.3-.1-.6-.1-.9l.5.7v.3c.1.3.2.6.3.8z" fill="#A64D21" />
            <path d="M45.4 33c0-.1 0-.2.1-.3.3-.3.7-.6 1.2-.7v.5l-1.2.5h-.1z" fill="#C8731E" />
            <path d="M45.4 32.6l.2-.2s-.1-.1-.4-.1c-.2 0-.3-.1-.4-.2.1.1.3.2.4.3.1 0 .1.1.1.1l.1.1zm1.5.1c-.1-.1-.1-.2-.2-.4 0-.1 0-.2-.1-.4 0 0-.1.1-.2.1l-.3.1s.3 0 .3.1-.5.2-.5.2.4-.1.4 0-.2.1-.4.2c-.1.1-.3.1-.4.2 0 0-.1 0-.1.1h.2c.2 0 .3-.1.5-.1l.8-.1z" fill="#A64D21" />
            <path d="M46.9 32.7s-.2-.1-.3-.8c-.1-.3-.1-.7-.1-1l.3.2.3.5-.2 1.1z" fill="#C8731E" />
            <path d="M47 31.5c-.1.2-.1.4-.1.7v.6c.1.1.2.3.3.4l.1-.1V32.2l-.3-.7z" fill="#A64D21" />
            <path d="M47.4 32s.1 1.1-.2 1.1c-.1 0-.3-.4-.3-.4s.2.4.3.3.1-1.1.2-1zm-.5.7l-.1-.2c-.1-.2 0 .1-.6.3s-.8.2-.8.2.2.2.8 0c.2 0 .4-.1.6-.2l.1-.1z" fill="#59270E" />
            <path d="M45.8 31.3c.1.1.1.2.2.3l.2.4c0-.1-.1-.3-.2-.4-.1-.2-.4-.5-.4-.5l.2.2z" fill="#C8731E" />
            <path d="M45.4 32.7s.1-.2 0-.2h-.5c-.2 0-.5-.1-.7-.1.2.1.3.2.5.2l.6.1h.1z" fill="#A64D21" />
            <path d="M45.4 32.7s0-.1 0 0c0-.1-.1-.1-.6-.2-.2 0-.4-.1-.6-.2l.6.3.6.1z" fill="#59270E" />
            <path d="M45.7 31.3c-.2 0-.3 0-.5.1l-.3.3h.2c0-.1 0-.2.1-.3.1-.1.3-.2.5-.1z" fill="#C8731E" />
            <path d="M45 30.6l.3.3c.1 0 .3.1.4.2.1.1.1.2.2.3l-.6-.3c-.2-.2-.3-.4-.3-.5z" fill="#A64D21" />
            <path d="M45.5 30.7c-.1-.1-.1-.1-.2-.1H45l.2.3h.1s-.3-.2-.3-.3.4.1.5.1z" fill="#A64D21" />
            <path fill="#59270E" d="M46.7 30.8L46.9 30 49.8 28.5 49.8 28.5 51.2 30.5 48.6 31.1 47.3 31.2z" />
            <path d="M49 34.5l.3-.1.3-.2.1.4-.3.2h-.3l-.1-.1v-.2z" fill="#FFAD1A" />
            <path d="M49 34.5l.3-.1.3-.2.1.4-.3.2h-.2l-.2-.1v-.2.2l.2.1h.3l.3-.2-.1-.4-.1.1-.2.1-.2.1H49z" fill="#8F5E36" />
            <path d="M48.6 34.5h.2c.2 0 .2-.1.2 0s.1.2.1.2l-.1.2-.2.1-.2-.1v-.4z" fill="#FFAD1A" />
            <path d="M48.6 34.5h.4v.2l-.2.1-.2-.1v-.2h-.1v.3l.2.1.3-.2.1-.1v-.2H49l-.4.1z" fill="#8F5E36" />
            <path d="M50.7 34.4c0-.1-.1-.1-.2-.2l-.4-.3v.8h.4l.2-.3z" fill="#FFAD1A" />
            <path d="M50.7 34.4c0-.1-.1-.1-.2-.2l-.2-.2-.1-.1v.9h.4l.2-.3v-.1.1l-.2.2h-.4v-.8l.4.3.1.2z" fill="#8F5E36" />
            <path d="M48.6 34.5c-.1-.1-.1-.1-.2-.1-.2 0-.3.2-.4.3s0 .4.1.5c.1.1.3.1.4 0 .4-.2.7-.4 1.1-.6h-.4c-.1.1-.2.1-.3.2-.1 0-.2 0-.2-.1-.1-.1-.1-.1-.1-.2z" fill="#FFAD1A" />
            <path d="M48.6 34.5c-.1-.1-.1-.1-.2-.1s-.2 0-.2.1c-.1 0-.1.1-.1.2V35c0 .1 0 .1.1.2s.2.1.2.1h.2l.2-.1c.3-.2.8-.5.8-.5h-.5c-.1.1-.2.1-.2.2h-.1v-.1-.2.2s0 .1.1.1l.1.1c.1 0 .2-.1.3-.2h.5l-.2.1c-.1.1-.3.2-.5.3l-.3.1-.2.1h-.2c-.1 0-.2 0-.2-.1 0 0-.1-.1-.1-.2v-.2-.1c0-.1.1-.1.1-.2.1 0 .1-.1.2-.1h.2z" fill="#8F5E36" />
            <path d="M47.7 35.5s-.1-.2 0-.3.3 0 .4 0 .1-.3 0-.3c0-.1-.1-.1-.1-.2 0 0-.6 0-.6.4-.1.2.1.4.3.4z" fill="#59270E" />
            <path d="M49.2 34.8c-.1 0-.1.1-.2.1s-.2.1-.2.1l.1.3.4.1.2-.2v-.3l-.3-.1z" fill="#FFAD1A" />
            <path d="M49.2 34.8l-.2.1-.1.1h-.1l.1.3.4.1.2-.2v-.3l-.3-.1h.3v.2l-.2.2-.4-.1-.1-.1h.1l.1-.1.2-.1z" fill="#8F5E36" />
            <path d="M51 34.6l-.1-.1c0-.1-.1-.1-.2-.1l-.2.2v.2l.2.1h.2l.2-.1-.1-.2z" fill="#FFAD1A" />
            <path d="M51 34.6c-.1-.2-.2-.2-.3-.2l-.2.2v.2l.2.1h.2l.2-.1-.1-.2.1.2-.2.1h-.1l-.2-.1v-.2l.1-.1.1-.1c.1 0 .1 0 .2.1v.1z" fill="#8F5E36" />
            <path d="M49.7 34.5c-.1 0-.2.1-.3.2l-.2.2c.1.1.1.2.2.2h.2l.4-.3v-.3h-.3z" fill="#FFAD1A" />
            <path d="M49.7 34.5c-.1 0-.2.1-.3.2l-.1.1v.1l.2.2h.2l.4-.3v-.3h-.4l.3-.1v.2l-.4.3h-.2l-.1-.1-.1-.1s.1-.1.2-.1c0 0 .1-.1.2-.1h.1z" fill="#8F5E36" />
            <path d="M51.3 34.8l-.1-.1c-.1-.1-.1-.1-.2-.1l-.2.3v.1l.2.2.3.1.2-.2-.2-.3z" fill="#FFAD1A" />
            <path d="M51.3 34.8l-.1-.1c-.1-.1-.1-.1-.2-.1l-.1.1-.1.1v.1l.2.2.3.1.2-.2-.2-.2.1.1-.2.2H51l-.2-.1v-.1l.1-.1.1-.1s.1 0 .2.1l.1.1v-.1z" fill="#8F5E36" />
            <path d="M49.1 35.9c.1-.1.2-.2.2-.3l.1-.1c.1-.1.3-.2.4-.3h1v.1h.1c0 .1.1.3.2.3h.4c.1-.1.1 0 .1 0l.3-.4s0-.1-.1-.1c0 0 .1-.3-.2-.3h-.4s-.2.3-.3.3l-.1-.1s-.1-.1-.1-.2h-.2l-.2-.2c-.1 0-.1 0-.2-.1l-.1-.1-.3.2s0 .1-.2.2c-.1.1-.2.1-.3.1 0 0 0 .3-.3.2-.1-.1-.3-.1-.3-.3-.1 0-.2 0-.2.1-.1.1-.1.2-.1.3 0 .1.1.3.1.4.3.3.5.4.7.3z" fill="#FFAD1A" />
            <path d="M50.6 35.2h.2s0 .1.1.1h.1c0 .1.1.3.2.4h.4l.3-.4v-.1l-.1-.1V35v-.2c0-.1-.1-.1-.2-.1h-.4v.3h-.1s-.1 0-.1-.1l-.1-.1h-.1l-.1-.1h-.2l-.1-.1-.3.2s0 .1-.2.2c-.1 0-.1.1-.2.1h-.4v.1c0 .1-.1.1-.1.1-.1 0-.2-.1-.2-.1l-.2-.2c-.1 0-.2 0-.2.1 0 0-.1.1-.1.2v.2c0 .1 0 .2.1.2 0 .1.1.1.1.2.1.1.2.2.3.2h.2c.1-.1.2-.2.2-.3v-.1s.1 0 .1-.1c.1-.1.3-.2.4-.3-.1 0-.3.2-.4.3l-.1.1v.1c0 .1-.1.2-.2.2H49c-.1 0-.2-.1-.3-.1 0 0-.1-.1-.1-.2v-.2-.1s.1-.1.1-.2.1-.1.2-.1l.1.1c.1.1.2.1.3.2.1 0 .2-.1.2-.1V35c.1 0 .2-.1.3-.1.2-.1.2-.2.2-.3l.3-.2.1.1s.1 0 .1.1h.1c0 .1.1.1.2.2h.1l.1.2.1.1h.1l.2-.2h.4c.1 0 .1 0 .1.1v.1l-.3.4h-.1-.4l-.2-.2v-.1-.1h-.2l-.1.1z" fill="#8F5E36" />
            <path d="M50.2 33.4v1.2c-.1.2-.5.1-.5 0v-.5l.5-.7z" fill="#FFAD1A" />
            <path d="M50.2 33.4v1.2c-.1.1-.2.1-.2.1h-.2s-.1 0-.1-.1v-.5l.6-.6-.6.6V34.7l.1.1h.2c.1 0 .2 0 .3-.1.1-.1.1-.2.1-.3V33.5l-.2-.1z" fill="#8F5E36" />
            <path d="M48.6 36.4s-.2-.3-.1-.4.2-.1.2-.1.1-.1 0-.3-.2-.2-.2-.3c-.2.1-.4.3-.3.5 0 .4.2.6.4.6zm3.1-.3s.6.2.7-.4c0-.2-.1-.5-.4-.5-.1 0-.1 0-.2.2s-.2.2-.1.3.2-.1.3.1-.3.3-.3.3z" fill="#59270E" />
            <path fill="#FFAD1A" d="M50.2 35.1L50.2 35.1 50.2 35.1z" />
            <path d="M50.2 35.1c0 .1 0 .2.2.2.1 0 .2-.1.2-.2h-.4zm0 0zm-.2.2h.2v-.1h-.4c0-.1-.1 0 .2.1z" fill="#FFAD1A" />
            <path d="M49.8 35.1v.2h.2c.1 0 .1 0 .2-.1l.1-.1v.1c0 .1.1.1.2.1s.2 0 .2-.1v-.1.1c0 .1-.1.1-.2.1s-.1 0-.2-.1v-.1.1s-.1.1-.1 0h-.1l-.3-.1z" fill="#8F5E36" />
            <path d="M48.6 36.4c-.3-.1-.5-.3-.5-.6s.3-.4.3-.4-.3.2-.3.4c0 .3.2.6.5.6zm-.9-.9c-.2-.1-.3-.2-.3-.5 0-.4.6-.4.6-.4s-.6 0-.6.4.3.5.3.5zm4 .6h.3c.2 0 .3-.1.4-.3.1-.2 0-.4-.1-.5-.1-.1-.2-.1-.2-.1.1 0 .1.1.2.2s.2.3.1.5-.2.3-.4.3l-.3-.1z" fill="#4B4139" />
            <path fill="#8C380E" d="M50.7 31.6L50.8 30.9 54.4 34 54.4 34 54 34.3 53.2 34 51.4 32.3z" />
            <path d="M55.4 33.4s-.9-.7-2.1-1.6l-2.6-2 .1.9 3 2.8 1 .5.5-.2.2-.3-.1-.1z" fill="#8C380E" />
            <path d="M50.8 31.2l1.8 1.8c.8.6 1.6 1.3 1.7 1.2s.1-.2.1-.2l-3.7-3 .1.2z" fill="#A64D21" />
            <path fill="#8C380E" d="M50.7 31.6L53.3 34.2 53 34.5 53 34.5 52.5 34.3 50.3 32 50.4 31.6z" />
            <path d="M55.4 33.4s-.3.7-.9.5c-1.3-1-2.6-2-3.8-3.2v.3s3.2 3 3.9 3.1 1.1-.4 1.1-.5l-.3-.2z" fill="#59270E" />
            <path d="M50.4 31.6c.5.6 1 1.2 1.6 1.8.5.5 1 .9 1.2.8s-.1-.2-.1-.2l-1.6-1.5-.8-.8c0-.1-.3-.2-.3-.1z" fill="#A64D21" />
            <path d="M50.7 31.6s2.6 2.7 2.8 2.7c.4.1 1.1-.3 1.1-.3l-.2-.1v.1s-.1.3-.7.2-2.9-2.6-2.9-2.6h-.1z" fill="#59270E" />
            <path fill="#8C380E" d="M50.7 33.1L50.5 32.7 50.4 32.3 52.3 34.2 52.3 34.2 52.1 34.4 51.8 34.3 51.7 34.2z" />
            <path d="M53.4 34.2s-.2.3-.5.3c-.2 0-.4-.2-.5-.3l-1.8-1.8v-.3c.7.8 1.5 1.5 2.4 2.2.3.1.5-.2.5-.2l-.1.1z" fill="#59270E" />
            <path d="M52.4 34.2c0 .1-.2.2-.3.2-.1 0-.3-.1-.4-.1L50.6 33v-.4c.4.6.9 1.2 1.5 1.7 0 0 .2 0 .3-.1-.1-.1-.1-.1 0 0z" fill="#59270E" />
            <path d="M51.2 30.7s1.1.9 1.2 1 .5.1.5.1-.2 0-.3.1.5.5.6.5.5 0 .5.1-.3 0-.3.1.5.4.6.4c.2 0 .4 0 .7.1 0 .1-.5 0-.5.1s.8.6.8.7-.9-.6-1-.6-.1.3-.1.3v-.4c-.2-.2-.4-.4-.6-.5-.1 0 0 .3-.1.3s0-.3 0-.4c-.2-.2-.4-.4-.7-.5-.1 0 0 .2-.1.2s0-.2-.1-.3c-.4-.5-.8-.9-1.1-1.3z" fill="#B07229" />
            <path d="M49.3 33.7s0 .4-.2.5-.5-.8-.5-.8l-.1-.8.5.5c.1.1.3.6.3.6zm1.5-.2v-.9l-.1-.3-.1-.2h-.1l-.3.2-.1.3.2.5.1.5.2.1.2-.2zm-.4.7c.1 0-.1-.6-.1-.6l-.3-.8-.1-.3-.3-.1-.2.2v.3s.3.5.4.7.4.6.6.6z" fill="#8C380E" />
            <path d="M50.1 32.4c.1.1.2.3.2.4.1.2.2.4.2.7 0 .1-.2.1-.2.1s.3.3.4.3 0-.3 0-.4-.1 0-.2-.1c-.1-.2-.1-.5-.2-.7v-.5c.2.2.2.5.2.8l.1.1s-.1-.4-.1-.5c0-.1-.1-.3-.1-.4V32v-.2s.1.1.2.1.1-.1.1-.3v-1l-1 1.4.4.4z" fill="#59270E" />
            <path d="M50.1 32.3c0 .3 0 .6.1.8.1.2.1.3.2.5v.6s-.3-.8-.4-1.1-.1-.5-.2-.5h-.1l.4-.3z" fill="#59270E" />
            <path d="M50 34.5V33.9l-.4-.8-.4-.4-.2-.4v.7c.1.3.3.6.5.9.1.2.5.6.5.6z" fill="#8C380E" />
            <path d="M48.3 32.6c0 .1.1.2.1.3v.2s.2.3.3.6.3.5.4.5c.1-.1.2-.2.2-.3 0 0-.1.2-.2.2-.2-.4-.3-.7-.4-1.1l-.2-.2c-.1 0-.1-.1-.2-.2zm1.2 1c-.1-.2-.2-.4-.3-.5-.1-.2-.2-.3-.2-.3l-.1-.3.3.3c.2.1.3.1.3.1v.7z" fill="#59270E" />
            <path d="M48.8 33c.1.2.1.3.2.5s.3.3.4.5c-.2-.2-.3-.3-.4-.5-.1-.2-.2-.3-.2-.5z" fill="#5C3A1D" />
            <path d="M49.6 32.7l.1-.2h.2c-.1 0-.2-.1-.2-.1l-.2-.2c-.1-.1.1.2.1.3v.2zm-.1.1s.3.7.4 1c.1.2.1.4.1.6 0-.2-.1-.3-.1-.5-.1-.2-.4-.8-.4-.9v-.2z" fill="#59270E" />
            <path d="M50 32.3l.1-1-.1-.4-.5-1s0 .2-.1.1c-.2 0-.4-.2-.5-.3 0 .2.1.3 0 .5 0 .1 0 .2-.1.4l.9 1.7c0-.1.3 0 .3 0z" fill="#8C380E" />
            <path d="M48.2 33s.1.2.2.1 0-.3-.1-.5c-.4-.6-.8-1.2-1.3-1.7.3.7.7 1.4 1.2 2.1z" fill="#A64D21" />
            <path d="M48.9 32.4c0 .1.1.5-.1.6s-1.5-1.6-1.7-1.8c0 0-.8-.5-.8-.6s.8.2.8.2l1.6 1.6c.2-.1.2-.1.2 0z" fill="#A64D21" />
            <path d="M48.9 32.4v.3c0 .1 0 .3-.1.3s-.2-.1-.3-.3c-.5-.5-.9-1-1.3-1.6H47l-.4-.3-.2-.2c.2 0 .3.1.5.1l.3.1 1.6 1.6v.1c0-.1 0-.1-.1-.1l-1.5-1.6c-.2-.1-.5-.2-.8-.2 0 .1.1.1.1.1.2.2.7.5.7.5.1.1.4.6.8 1 .2.2.4.4.5.6s.3.3.4.3c.1 0 .1-.2.1-.3 0-.3 0-.4-.1-.4z" fill="#5C3A1D" />
            <path d="M48.2 33c-.1-.1-.1-.3-.2-.4 0-.1 0-.2-.1-.3 0-.1-.9-1.3-1-1.4-.1-.1-.3-.2-.4-.2v.4c.2.4.4.7.7 1l1 .9z" fill="#59270E" />
            <path d="M49.5 32.8c.1-.1.1-.5 0-.6s-.8-1.6-.8-1.6l-.2.1-.4-.3-.2-.2c0 .2.1.4.1.5v.3l.6 1 .9.8zm.8-.9l.2-.2-.1-.8-.5-1.6h-.2c-.1-.1-.2-.1-.2-.2l.1 1 .5 1.4v.4h.2z" fill="#8C380E" />
            <path d="M48.8 32.3c-.2-.2-.4-.5-.6-.8l-.3-.5h-.3c-.1-.1-.3-.2-.4-.3 0 0-.1.3.6 1s1 .7 1 .6z" fill="#59270E" />
            <path d="M50 32.4c.2-.1.2-.9 0-1.5-.1-.4-.3-.7-.5-1.1.2.4.3.9.5 1.3.1.4 0 .6-.1.6s-.1-.2-.2-.6c-.1-.2-.2-.3-.3-.5 0 0 .6 1.5.4 1.5-.4-.5-.7-1.1-1-1.8l-.1.1c.1.1.7 2.2 1.3 2z" fill="#A64D21" />
            <path d="M50.4 28.3l.3.7.1.8v.6s0 1.3-.1 1.3-.2 0-.2-.1l-.3-1.4-.3-1.5.1-.1v-.2h.2l.2-.1z" fill="#8C380E" />
            <path d="M49.5 32.8c.1 0 0-.4 0-.4s-.1.2-.2 0-.2-.3-.2-.5l-.1-.2s-.1.3-.2.3-.8-1.1-.8-1.1l-.1.1s.9 1.9 1.6 1.8z" fill="#A64D21" />
            <path d="M49.1 31.9c.1-.2.1-.3.1-.5-.1-.3-.2-.6-.4-.9h-.2c-.1-.1-.3-.1-.4-.2.1.3.2.5.4.8.1.4.5.9.5.8zm.5-.3c-.1-.4-.2-.8-.3-1.1-.1-.3-.3-.5-.5-.7v.6c.2.1.3.2.4.4.2.2.3.5.4.8zm.7-1.1c0-.3-.1-.7-.1-1-.1-.4-.2-.9-.2-.9s0-.1.1-.1h.1c.1 0 .2.4.2.4v-.6H50v.2s-.1 0-.1-.1v.1c0 .1 0 .2.1.3v.3c.1.2.1.4.2.6 0 .4.1.6.1.8z" fill="#59270E" />
            <path d="M50.9 30.5c.1-.5 0-1-.1-1.5-.1-.3-.2-.5-.4-.7l-.1.1c.2.3.3.6.4 1 .1.4.2 1.1.2 1.1zm-.9.4s-.1-.7-.2-1.2-.2-.6-.2-.6l-.2-.1c0 .2.1.4.1.6v.2c.1.2.1.3.2.5s.2.5.3.6z" fill="#59270E" />
            <path d="M50.5 32.1c.2 0 0-1 0-1.3s-.5-1.5-.5-1.5.5 1.8.5 1.9-.3-.5-.3-.5.4 1.2.2 1.2-.2-.2-.2-.2v.3c-.1 0 .1.1.3.1zm.2-.6c.1 0 0-1-.1-1.4s-.3-1.3-.3-1.3c.2.4.3.8.4 1.3.1.7.2 1.6.1 1.6s-.2-.1-.2-.1v-.2c0 .1 0 .1.1.1z" fill="#A64D21" />
            <path d="M49 32.7c0 .1 0 .4-.2.4-.3-.1-.5-.3-.6-.5 0 0 .4.4.5.4s.1-.4.1-.5.2.2.2.2z" fill="#59270E" />
            <path d="M49.9 28c.1.1.3.1.4 0 .2-.1.3-.3.3-.5 0-.1 0-.3-.1-.4-.1-.1.2.1.2.4s0 .7-.4.8-.2 0-.2 0l-.2-.3z" fill="#D2A567" />
            <path d="M49.6 27.2c.2.3.3.6.4.9.1.4.1.6 0 .6s-.1 0-.1-.1-.3-1.4-.3-1.4z" fill="#A64D21" />
            <path fill="#59270E" d="M44.8 27.8L44.8 27.8 46.6 30.4 48.9 27.8 47.4 26.3z" />
            <path fill="#8C380E" d="M48 27.9L48.1 27.6 48.2 27.2 48.3 27.2 48.6 27.3 48.8 27 49.1 26.5 49 26.3 49 26.1 48.5 25.3 48.3 25.6 48.2 25.7 47.9 25.6 47.6 26 47.2 25.8 47.1 26.1 47.1 26.1 47 26.5 47.2 27.3 47.6 27.6z" />
            <path d="M48 28c.1-.1.1-.2.1-.3v-1.1c0-.2-.2-.8-.3-.7.1.4.2.7.2 1.1 0 .6 0 .8-.2.9s.1 0 .1 0v.1zm.1-1.1s.3.4.5.3.1-.7 0-.9c-.1-.2-.1-.3-.2-.5l.1-.1.2.6c0 .2.2.9 0 1s-.6-.3-.6-.3v-.1z" fill="#59270E" />
            <path d="M47.1 27.2l.2-.2h.2l.1.4.2.4.2.2h-.2c-.2-.1-.3-.2-.4-.2l-.1-.1-.2-.5z" fill="#A64D21" />
            <path d="M47.8 30.9c-.1.1-.5-.1-.7-.2L46 29.5l-.1-.5.4.1.7-.3.1-.2.8-.4.4-.2h1l.2-.5c.2.3.3.5.4.8.1.3.1.7 0 1-.1 0-.4-.2-.4-.2s.2 1 0 1-.6-.4-.6-.4.2.9 0 .9c-.3-.1-.6-.2-.9-.5 0 0 .2.7 0 .9l-.2-.1z" fill="#D2A567" />
            <path d="M47.7 29.8l.2.3v.6c-.1.2-.3-.2-.4-.5 0 0-.3-.6-.4-.7s.6.3.6.3zm1.8-2.3s.3 1.4.2 1.5-.6-.4-.7-.5l-.7-1.1-.1-.1v-.1l.3.1 1 .2zm-2.4 2.7c-.1 0-.2-.2-.3-.2s-.3-.3-.5-.6c-.2-.1-.3-.3-.4-.4l-.1-.2.1-.1h.2c.3.3.7.5 1 .9.1.1.1.4 0 .6zm1.4 0c-.4-.2-.7-.4-.9-.8l-.6-.9c-.1-.2-.1-.3-.1-.3h.2c.5.8 1 1.4 1.4 2zm.3-.6s-.3-.2-.5-.4c-.1-.1-.1-.3-.1-.5l.6.9zm.3-.1c-.1 0-.4-.4-.7-.9s-.3-.4-.3-.4c-.1 0-.1-.1-.2-.1h.1l.1-.1.2-.2.7 1.4s.2.3.1.3z" fill="#A64D21" />
            <path d="M47.2 30.7s0 .1-.2.1c-.7-.3-1.3-.7-1.7-1.3l-.5-.9.2-.2 1.7 1.9c-.1-.1.5.4.5.4z" fill="#C8731E" />
            <path d="M47.2 30.7c0 .1-.1.1-.2.1-.5-.2-.9-.5-1.2-.9-.4-.4-.7-.8-.9-1.3v-.3l.2-.1 1.1 1.7 1 .8z" fill="#A64D21" />
            <path d="M48.3 29.9c-.2-.1-.4-.3-.6-.5-.3-.3-.5-.6-.7-1 0-.1.2-.1.2-.1v-.4l.3.1.4.5.1.2s.3.6.2.7-.2-.4-.3-.3.4.8.4.8zm-.6-.1s.1.2.1.3-.1.2-.3-.1c-.1-.2-.2-.4-.4-.5 0 0 0 .4-.1.4s-.3-.3-.5-.6-.4-.7-.4-.7v-.4-.4.2s0 .1.1.1l.6.7.2-.1.4.7.3.4zm-2.4-1.1c.3.5.6.9.9 1.3.3.3.6.5 1 .7L45.8 29l-.5-.3zm3.7.5c-.2-.2-.4-.4-.5-.6-.2-.3-.3-.6-.3-.9 0-.2.1-.6.1-.6.2.2.4.5.6.8l.3.6-.4-.2s.3.9.2.9z" fill="#8C380E" />
            <path d="M49.5 28.7c-.1 0-.3-.3-.4-.4 0-.2-.1-.4-.1-.5l-.2-.5v-.6h.2l.3.5c.1.2.1.4.1.6.2.3.2.6.1.9zm-3.8 1.4c-.3-.3-.5-.7-.7-1.1l-.1-.5.1.1c.2.5.4.9.8 1.2.2.3.5.5.8.7 0 0 .1.4.1.5-.4-.3-.7-.6-1-.9z" fill="#8C380E" />
            <path d="M46.4 30.9c-.4-.3-.7-.7-1-1.1-.3-.4-.5-.7-.8-1.1l.2-.2c.2.4.4.9.7 1.3l.9 1.1zm.8-.2l-1-1c-.2-.2-.4-.5-.5-.8l.3.1c.1.2.2.4.4.6l.8 1.1zm-.1-1.2s-.4-.4-.5-.7l-.3-.6s.5.6.6.6h.1v.4l.1.3zm.1-1.8v.5c0 .2-.1.2-.1.2.1.1.2.3.3.4.1.1.4.3.4.3s-.2-.3-.3-.5-.2-.3-.2-.5.4.1.4.2.4.5.4.5l-.3-.6c-.1-.2-.6-.5-.6-.5z" fill="#59270E" />
            <path d="M48.7 28.6l-.3-.7-.3-.9v.5c0 .2-.1.5-.2.6s-.1.1-.3 0 .1.1.1.1c.1 0 .1-.1.2-.1.1-.1.1-.3.2-.2s.2.3.2.4c.2 0 .3.1.4.3z" fill="#59270E" />
            <path d="M48.1 27s.4.4.5.2.1-.7.1-.7.2.1.3 0 0-.3 0-.3l.6.9c.1.3.2.7.3 1-.2-.3-.4-.7-.5-1-.1-.5-.4-.6-.4-.6-.1.2-.1.3 0 .5 0 .2.2.4.3.6s.2.6.2.6l-.3-.4-.3-.3c-.1-.1-.2-.2-.3-.2-.1 0-.3-.1-.3-.1V27h-.2zm-1.2 1.7c.1.2.2.4.4.6l.4.5-.5-.5-.3-.6z" fill="#59270E" />
            <path d="M49.2 28.8H49c0 .2.1.3.2.4.1.1.2.1.2.1v-.2-.3h-.2z" fill="#A64D21" />
            <path d="M45.1 26.3l-.2.1-.2.5.1.9.4.5c.1.2.6.7.7.7s.2-.4.3-.6 0-.6 0-.6c.1.1.2.3.3.4l.4.4.4-.6-.7-1.7-.3-.1-1.2.1z" fill="#D2A567" />
            <path d="M46.6 27.7s.1.4.2.6 0 .4 0 .4c.2-.2.3-.4.4-.7 0-.4 0-.7-.1-1.1-.1-.7 0-.9 0-.9l-.2-.2-.3.7v1.2zm-1.2-.4s.1.6.1.9.2.6.2.6c.2-.2.3-.5.3-.8-.1-.3-.2-.7-.1-1 0-.7-.1-.8-.1-.8l-.4 1.1z" fill="#C8731E" />
            <path d="M44.5 26c-.3.4-.4.8-.5 1.2 0 .4.1.3.2.7.1.3.2.7.2 1 0 0 .1 0 .1-.1V26z" fill="#45392D" />
            <path d="M44.5 26.1c-.2.3-.4.7-.4 1.1 0 .3.1.5.2.8.1.3.1.6.1 1 .1 0 .2-.1.3-.2.1-.1.2-.2.3-.4l-.1-.4c-.1-.1-.1-.2-.1-.3l-.1-.2v-.7l.1-.5v-.2h-.3z" fill="#C8731E" />
            <path d="M47 27.3c-.1 0-.2-.1-.3-.1-.1 0-.1-.1-.1-.2v-.1l.4.4z" fill="#DBAD6C" />
            <path d="M44.6 26.1c-.2.4-.3.8-.3 1.2 0 .4.2.8.3 1.1v-.2-1.5l.2-.5V26l-.2.1z" fill="#D2A567" />
            <path d="M45.4 26.3v.3c0 .1-.2.2-.3.4s-.2.5-.2.5c0-.1.1-.2.2-.3.1-.1.2-.2.2-.1v.4c-.1.1-.1.2-.2.3v.4s0-.2.1-.4c0-.1.1-.1.1-.2l.2.4v-.3c0-.1.2-.3.2-.3s.1 0-.1-.1c-.1-.3-.1-.5 0-.8 0 0 .3 0 .3-.1-.1-.1-.2-.3-.3-.4l-.4.4.2-.1z" fill="#A64D21" />
            <path d="M47 27.8h-.2c-.1 0-.1 0-.1-.1v-.1l.2.1.1.1z" fill="#DBAD6C" />
            <path d="M44.8 27.9c0 .1-.1.2-.1.2 0 .1-.1.2-.1.3 0 0 0-.3-.1-.6s0-.4-.1-.4-.1.1-.1.1v-.4c0-.1.1-.3 0-.3s-.1 0-.2.1l-.1.2c0-.1.1-.2.1-.3 0-.1.3-.4.3-.5v-.2h.2s.2.1.2.3-.2.1-.2.1-.2 0-.2.6.1.5.1.8h.3zm1.6-1.5v.4c-.1.1-.1.2-.2.3 0 .1-.1.3-.1.4 0-.1 0-.2.1-.2 0-.1.1-.2.1-.2.1.1.1.2.1.3 0 .2.1.4.1.4v-.2h.1c.1 0 .1.1.2.1 0-.1-.1-.1-.1-.2-.1-.1-.2-.1-.2-.3v-.4c0-.1.1 0 .2.1l.2.2h.1v-.5-.4c0-.1.1-.3 0-.3-.2.1-.4.3-.6.5z" fill="#A64D21" />
            <path d="M48.3 25.7c0 .2 0 .4.1.6 0 .2.2.7.2.7l-.3-.6-.2-.6s-.2.1-.2.3c0 .3.1.5.2.7-.1-.1-.2-.3-.2-.4l-.1-.4v.4c0 .2.1.3.2.5l-.2-.2-.1-.1c0 .1 0 .2.1.4.1.1.2.3.2.3-.1-.1-.2-.1-.2-.2l-.1-.1c0 .2.1.4.1.6.1.2.3.5.3.5-.1-.1-.3-.3-.3-.5-.1-.4-.2-.9-.2-1.4 0 0 .1-.2.2-.3.1-.3.2-.5.2-.8.1.3.1.5.3.7-.2-.1-.1-.1 0-.1z" fill="#59270E" />
            <path d="M46.8 25.5c0 .1.1.2.1.2 0 .1.1.1.1.2-.1.1-.3.2-.4.4-.2.2-.5.3-.5.2v-.2c.1-.1.3-.2.4-.3.1-.1.2-.2.3-.4v-.1zm-1.9.6s0 .4.2.4.6-.5.7-.5c0-.1.1-.1.1-.2v-.1s-.5.5-.7.5c-.1.1-.2 0-.3-.1zm.1-.5v.4s-.4.1-.4 0v-.3h.3c0 .1.1-.1.1-.1z" fill="#8C380E" />
            <path d="M48.5 25.1c.1.2.2.4.2.6.1.2.2.5.2.5s-.2-.3-.3-.4l-.2-.2v-.2c0-.1 0-.3.1-.3z" fill="#59270E" />
            <path d="M44.4 25.9H44.7l.1-.2v.4c0 .2.2.2.2.2.1 0 .3-.1.4-.2.1-.1.2-.2.4-.3v.5c.1.2.2.2.4.1s.3-.3.5-.5c0-.1.1-.1.1-.2l.2-.1.2-.9-.1-.1-.2.1-.3-.1-.1-.1-.2.3-.2.1H45.8l-.1-.2v-.1h-.1l-.4.4H45l-.2.4-.2.2-.2.3z" fill="#DBAD6C" />
            <path d="M46.5 24.9c0 .2 0 .4-.1.6-.1.2-.2.5-.3.7.3-.2.5-.4.6-.7.1-.3.2-.7.2-1l-.4.4zm.5-.4v.4c0 .2-.1.5-.1.7l.1.2c0 .1.2.3.3.3.2-.1.3-.2.4-.4.1-.2.1-.3.2-.5h.1s0 .2.2.3.2.2.3.2c.1 0 .1-.1.1-.2s-.2-.7-.2-.7l-.4-.7-.2-.3h-.5l-.3.7z" fill="#A64D21" />
            <path d="M47.8 23.9c.1.2.1.4.2.6 0 .2 0 .4-.1.6v-.6c0-.2-.1-.3-.1-.5v-.1z" fill="#C8731E" />
            <path d="M48.5 25.1v.4c0 .1-.2-.1-.3-.5-.1-.2-.1-.5-.2-.7-.1-.1-.1-.3-.1-.4h.1l.5 1.2zm-1.2.8c.3-.3.5-.7.5-1.1 0-.3-.1-.7-.2-1 0 .4-.1.7-.2 1.1-.2.4-.3.7-.3.7.1 0 .1-.1.2-.1 0-.1.1-.1.1-.2v.3l-.1.3zm-.4-1.4c0 .1-.1.3-.2.3-.2.1-.4.2-.5.3.1-.1.3-.3.3-.5.1-.1.1-.2 0-.4 0 .1-.1.2-.1.2-.1.1-.2.1-.3.1 0-.1.1-.2.1-.2v-.1c.1-.1.1-.3.2-.4.1.1.1.2.2.4l.3.3z" fill="#8C380E" />
            <path d="M48.3 23.6c.1.2.1.4.2.7v.9c-.1-.2-.2-.3-.3-.5-.1-.1-.1-.4-.1-.5 0-.1-.1-.1-.2-.2h-.2l.2-.2v-.2c.1 0 .1.1.2.1.1-.1.1-.1.2-.1zm-1 1.7c.2-.2.3-.5.3-.8.1-.2.1-.4 0-.6-.1 0-.1 0-.2-.1s-.2-.2-.2-.3v.5c-.1.2-.2.4-.3.5h.2c.1-.1.2-.3.2-.4v.4c.1.2 0 .5 0 .8z" fill="#59270E" />
            <path d="M44.3 25.9c-.1 0 .2-.4.3-.6l.4-.6h.1c.2 0 .3-.1.4-.3.1-.1.1-.3.2-.4 0 .2 0 .4.2.5l.2.2c0 .2 0 .3-.1.5s-.1.6-.1.6v-.6c-.1-.1-.1 0-.2.2 0 .1-.1.2-.2.3.1-.1.1-.3.2-.4.1-.2 0-.2 0-.2l-.1.1-.1.1c.1 0 .1-.1.1-.2s.1-.2.2-.3c0 0 .1-.1.1-.2v-.1s-.1 0-.2.2-.2.2-.2.2c-.1.1-.1.3-.2.5 0 .2-.1.3-.2.5l-.1.1.1-.4c.1-.2.1-.4.2-.6h-.1s-.2.2-.3.5-.2.5-.2.5l-.4-.1z" fill="#A64D21" />
            <path d="M48.5 23.3c0 .1-.1.2-.2.3h-.4v-.2l.6-.1z" fill="#874F20" />
            <path d="M45.1 23.9c0 .1-.1.2-.1.4-.1.2-.3.4-.2.4.1.1.2.1.2.1.1 0 .2-.9.1-.9z" fill="#8C380E" />
            <path d="M47.2 23.4s-.1 1.1-.4 1.1-.4-.5-.4-.5 0 .8-.4.8c-.2 0-.4-.6-.3-.7 0 .2-.1.4-.3.5-.4.3-.6.1-.6.1.2-.2.3-.5.3-.8 0 0 .1 0 .2-.1s.1-.3.2-.2c.2 0 .4-.1.5-.2l.2-.3s0 .1.2 0c.1-.1.2-.2.2-.3l.5.4.1.2z" fill="#DBAD6C" />
            <path d="M46 22.4s.3.4.5.6l.1-.1.1.2s-.2.4-.1.6v-.3c.1-.2.1-.2.2-.2s.1 1 .2 1 .2-.5.2-.8.1-.1.1 0 .3.5.5.4.2-.5.2-.6c0-.2-.1-.4-.2-.6l-1-.7-.1.3c-.2.3-.7.1-.7.2z" fill="#8C380E" />
            <path d="M47.5 22.3s.1 0 .2.3.1 1.1 0 1.1c-.2 0-.3-.1-.4-.3 0-.1 0-.5-.1-.6-.1-.1-.2-.3-.2-.5V22l.2-.1.3.4z" fill="#A64D21" />
            <path d="M47.4 22l.5.7.4.6c.1 0 .1 0 .2.1-.1.2-.4.2-.5.1-.2-.1-.1-.4-.3-.8-.1-.3-.3-.5-.5-.6l.1-.1c-.1-.1.1 0 .1 0z" fill="#8C380E" />
            <path d="M47.2 21.6c.2.1.4.3.5.5.2.3.2.5.4.8.1.1.2.3.3.4h-.2l-.3-.3c-.1-.1-.3-.6-.4-.7-.1-.1-.3-.2-.4-.3 0 0 .1.1.3.4.1.2.2.3.2.5 0 0 0-.1-.2-.4S47 22 47 22c.1.2.1.4.2.5.1.2.2.4.2.6 0 0-.1-.2-.3-.5l-.3-.3-.2-.3h.3c.2-.2.3-.3.3-.4z" fill="#59270E" />
            <path d="M46.2 22.4H46.8c0 .1.1.2.1.2 0 .1-.1.4-.1.4s0-.2-.1-.3c-.2-.1-.4-.2-.5-.3z" fill="#A64D21" />
            <path d="M46.3 23v.7c0 .3-.2.6-.3.8-.1 0 0-.4-.1-.7v-.1l-.1.3.1-.4v-.1l.3-.4.1-.1z" fill="#8C380E" />
            <path d="M45.8 23.3c-.1.1-.2.1-.3.1s-.1.2-.1.2.1-.1.1 0 .1 0 0 .2-.2.4-.4.5c.2-.1.3-.3.5-.4.1-.1.1-.2.1-.3 0-.1.1-.1.2-.1 0 0 .1 0 .1.1s.1.4.1.4c.1-.1.1-.3.1-.4v-.5h-.1c-.1 0-.2-.1-.3-.1.1.1 0 .2 0 .3z" fill="#A64D21" />
            <path d="M47.2 21.4c.1.2 0 .3-.1.5-.1.1-.2.1-.2.1-.1 0-.2 0-.3-.1l-.7-.3-.3-.1h-.2v-.2h.5l.5.2.2.1h.5c.1-.1.1-.2.1-.2z" fill="#DBAD6C" />
            <path d="M47.2 21.4c0 .1 0 .2-.1.2h-.3c-.2 0-.4-.2-.6-.2-.2-.1-.4-.1-.6-.1-.2 0-.1-.1-.1-.1.3 0 .5 0 .8.1.2.1.4.2.7.2.2-.1.2-.2.2-.1z" fill="#C8731E" />
            <path d="M45.4 21.1H45.7v.1s-.2 0-.3-.1c0 .1 0 0 0 0z" fill="#8C380E" />
            <path d="M46.7 22s.2.2.2.4l-.5-.2-.7-.3-.4-.1v-.1l.1-.1v-.1l.5.1.5.1.3.3zm-.5.3s.4.5.3.7l-1-.6-.3.6-.8-.4s.7-.5.7-.6.1-.1.1-.1l.4.1.6.2v.1z" fill="#DBAD6C" />
            <path d="M46 21.5c.2 0 .4.1.6.2.2.1.3.1.5.1-.1.1-.2.2-.4.2-.1 0-.3-.1-.4-.2l-.3-.3z" fill="#C8731E" />
            <path d="M45.4 21.3c.1 0 .3.1.4.1.2.1.2 0 .2 0s0 .1-.1.1-.2 0-.3-.1h-.3l.1-.1z" fill="#8C380E" />
            <path d="M46.7 22.3s.2.1.1.1-.2.1-.3.1c-.1 0-.2 0-.3-.1-.1 0-.2-.2-.4-.3-.2-.1-.3-.1-.5-.2h-.2l.2-.1.6.1.5.1.3.1v.2zm-.9.3l.1.4-.1.3-.2.1h-.1v-.1-.2c-.1-.1-.2-.2-.3-.2 0 0 .1-.2.2-.3s.1-.2.1-.2l.3.2z" fill="#C8731E" />
            <path d="M45.2 21.7c.1.1.2.1.3.1.1 0 .3 0 .4.1h.2l-.1.1c.2 0 .3.1.4.1.1 0 .2.1.3.2l-.3-.2c-.2-.1-.4-.1-.5-.1-.2 0-.5-.1-.7-.1-.1 0 0 0 .1-.1-.1 0-.1-.1-.1-.1z" fill="#8C380E" />
            <path d="M46.5 22.9s.1.1 0 .1c-.2.1-.4 0-.6-.1 0-.1-.1-.1-.1-.2-.1-.1-.3-.2-.4-.3-.1-.1 0-.1 0-.1s.5.2.6.3c.2.1.3.2.5.3z" fill="#C8731E" />
            <path d="M46.5 22.9c-.2-.3-.5-.4-.8-.6h-.3l-.4-.1s-.1 0-.1.1-.1.1-.1.2h.4c.2 0 .2.1.2.2s-.3.3-.3.3.2-.3.3-.2c.1 0 .2.1.2.1v-.1l-.2-.2c.2 0 .4.1.6.2.2 0 .4.1.5.1z" fill="#8C380E" />
            <path d="M45.5 22.4c.3.1.5.4.5.6 0 .5-.4.4-.4.2s0 .1.2.1.2-.2.2-.4c0-.1-.1-.3-.2-.4-.1.1-.3-.1-.3-.1z" fill="#DBAD6C" />
            <path d="M43.4 21.2l-.1.4c-.1.3-.2.5-.4.7-.4.4-.6.4-.5.6s.2.1.2.1l.7-1 .2-.6-.1-.2z" fill="#59270E" />
            <path d="M45.1 20.5c.1.3.2.6.1.9-.1.6-.8 1.1-.8 1.1l-1.1.8h-.5-.1c-.1 0-.1-.1-.2-.1l-.1-.2.2-.2.4-.4.2-.4c.1-.1.1-.3.1-.4v-.3l.1.1v.6l.3-.2.4-.2s.1 0 .2-.2.1-.4.1-.7v-.3c.1.1.1.2.1.3 0 .1.1.5.1.5l.2-.2c.1-.1.1-.2.2-.2.1-.1.1-.2.1-.3z" fill="#DBAD6C" />
            <path d="M45.2 23.3s.1.1 0 .3c0 .2-.1.3-.3.3v-.3l-.2-.2-.3-.1c.1-.1.2-.1.3-.1l.5.1z" fill="#A64D21" />
            <path d="M45 23.3c.1 0 .1.1.2 0 .1 0 .2-.2.1-.3-.1-.1 0 .2-.1.2s-.2-.2-.3-.2c-.1 0-.2 0-.3.1 0 .1.2 0 .2 0h.2v.2z" fill="#C8731E" />
            <path d="M43.5 22.5h.3c.2 0 .4-.1.5-.2.1-.1.2-.1.3-.2.3-.2.5-.5.6-.9 0-.3 0-.5-.1-.8.3.4.4 1 .1 1.4-.2.3-.4.5-.6.6 0 0 .6-.2.6 0v.4s.3.1.4.2-.4-.1-.7 0c-.2 0-.3.1-.4.3 0 0 0-.1-.3-.1s-.4.1-.5.1-.6-.1-.7-.2.1-.1.3-.4.2-.1.2-.2z" fill="#A64D21" />
            <path d="M44.7 21.2c.1-.1.2-.3.3-.4 0-.1.1-.2.1-.3 0 .1 0 .3-.1.4l-.3.3z" fill="#C8731E" />
            <path d="M44.6 20.7s.2.8 0 1.1c-.3.3-.7.5-1.1.7.4-.2.7-.5.9-.8.1-.2.2-.5.2-.8v-.2z" fill="#A64D21" />
            <path d="M43.8 22.6c.2 0 .3 0 .5-.1.1-.1.3-.2.4-.3 0 0-.2.2-.3.2s-.1-.1-.1-.2c0 .1-.1.2-.2.2-.1.1-.2.1-.3.2zm.6-1c.2-.2.3-.5.2-.8 0-.5-.2-.4-.2-.4s.2.1.1.5c.1.3 0 .5-.1.7zm.3.1c.1 0 .3-.1.4-.2.1-.1.1-.3.1-.5 0 .1-.1.3-.1.4-.1.1-.3.2-.4.3zm-.2 1.6s.1-.3.3-.2c.1 0 .2.1.2.2 0-.1-.1-.1-.2-.1s-.2.1-.3.1zm-.5-.4s.4-.1.6-.2.5-.2.5-.2c-.1.2-.3.3-.5.4-.2.1-.3.2-.5.2 0 0 .5-.2.6-.3-.2 0-.5 0-.7.1z" fill="#59270E" />
            <path d="M43.4 22.9c.2-.2.2-.5 0-.6l-.5.7c.2.1.4 0 .5-.1z" fill="#FFFFFF" />
            <path d="M43.4 22.9c.2-.2.2-.4 0-.6l-.5.7c.2 0 .4 0 .5-.1z" fill="#F16E16" />
            <path d="M43.2 22.8c.1 0 .2 0 .2-.1s-.1-.2-.1-.2l-.3.3h.2z" />
            <path d="M43.2 22.7s0 .1 0 0m0-.1c0 .1 0 .1 0 0z" fill="#D5D3CA" />
            <path d="M43.5 22c.2-.2.3-.4.3-.6v-.5l.2.1v.3l-.1.4c.1 0 .2 0 .3-.1.2-.3.2-.7.2-1.1.1.2.1.4 0 .7 0 .3-.2.6-.6.8-.3.2-.5.4-.7.7-.1.2-.3.4-.4.5.1-.2.2-.3.3-.5.1-.2.2-.3.3-.5l.2-.2z" fill="#C8731E" />
            <path d="M43.4 22.2c.1-.2.1-.4.1-.5 0-.1-.1-.3-.1-.4 0 0 .2 0 .2.4s-.1.3-.2.5z" fill="#A64D21" />
            <path d="M43.9 21.7c.1-.2.1-.3.1-.5 0-.1-.1-.3-.2-.4 0 0 .2 0 .2.4s0 .4-.1.5z" fill="#8C380E" />
            <path d="M42.7 23.1c0-.1-.1-.1-.1-.2s0-.1.2-.4c.2-.2.3-.3.4-.5.1-.2.2-.5.1-.8.1.3 0 .5-.1.7-.2.2-.3.5-.6.6-.2.1-.2.2-.2.3s0 .2.1.2c.1.1.1.1.2.1z" fill="#C8731E" />
            <path d="M45 23.9s.1 0 0 0c.1-.1.1-.2.1-.3-.1-.1-.2-.2-.3-.2h-.3c.1.1.1.2.2.2s.2 0 .3.1v.2z" fill="#6C4119" />
            <path d="M45 23.9c.2-.1.3-.3.3-.5 0 .1.1.1.1.1h.1s-.2.5-.5.4z" fill="#6C4119" />
            <path d="M43.2 23.9c.1 0 .1.1.1.1 0 .1.1.1.2.1l.6-.2.2-.2-.2-.3h-.5c.1.1-.4.5-.4.5z" fill="#B36B24" />
            <path d="M44.7 23.7l-.1-.2c0-.1-.1-.1-.1-.1-.2 0-.3-.1-.5 0l-.3.1h-.2c-.2 0-.3-.1-.5-.2l-.3-.1c-.1 0-.2-.1-.3-.1-.1.1-.2.1-.2.2v.1h-.1c-.3.2-.5.4-.6.7-.1.5.8 1.2 1.1.8 0 0-.5-.4-.4-.6.1-.3.4-.5.7-.5.2 0 .4 0 .6-.2.2-.2.5-.1.7 0 .2.2-.8.5-.8.5l.1.2c-.1 0 1.3-.5 1.2-.6z" fill="#FFAD1A" />
            <path d="M44.7 23.7l-.1-.2c0-.1-.1-.1-.1-.1H44l-.3.1h-.2l-.3-.1-.2-.2-.3-.1H42.4h-.1l-.2.2v.2h.1-.1c-.1.1-.2.1-.3.2-.2.1-.3.3-.3.6v.1c0 .2.1.4.3.6.2.2.4.3.6.3.1 0 .2 0 .2-.1l-.2-.2c-.1-.1-.1-.2-.2-.3v-.1c0-.1.1-.3.2-.3.1-.1.3-.1.4-.1.1 0 .3 0 .4-.1.1 0 .1-.1.2-.1.1-.1.2-.1.3-.1.1 0 .2.1.3.1.2-.1.1 0 0 0-.1.1-.3.1-.4.1H43.3l.2.2.6-.2c.1-.1.3-.1.4-.2.1 0 .1-.1.1-.1.1 0 .1-.1.1-.1s0-.1 0 0c0-.1 0-.1 0 0-.1.1-.2.2-.3.2l-.6.3-.2.1h-.1l-.1-.3.5-.1c.1 0 .2-.1.3-.1l.1-.1v-.1-.1c-.1-.1-.2-.2-.4-.2-.1 0-.2 0-.3.1-.1 0-.1.1-.2.1h-.3c-.2 0-.3.1-.5.1-.1.1-.2.2-.2.4v.1c0 .2.1.3.2.4l.2.2c-.1.1-.1.1-.2.1-.2 0-.4-.1-.6-.3-.2-.1-.3-.3-.3-.5v-.1c0-.2.1-.4.3-.5.1-.1.1-.1.2-.1h.2v-.1l.1-.1.1-.1H42.9l.3.1c.1.1.3.1.5.2h.1c.1 0 .1 0 .2-.1l.3-.1h.5s.1 0 .1.1l.1.2-.3.3z" fill="#A64D21" />
            <path d="M42.2 24.8s-.5-.1-.5-.6c0-.3.3-.6.6-.7.1 0 .1-.3.2-.3s.2 0 .3.1c.1.1.2.1.2.1s-1 .4-1 1c0 .3.2.4.2.4z" fill="#FCF3D8" />
            <path d="M44.7 23.6s-.1 0 0 0c-.2-.2-.4-.3-.6-.2-.2 0-.4.1-.6.1h-.3c-.2 0-.6-.3-.7-.3-.1 0-.1.1-.1.2 0 0-.2.1-.2 0s.1-.3.3-.3c.5 0 .8.3 1 .3s.3-.1.6-.1.6.1.6.3z" fill="#FDEAAF" />
            <path d="M43.2 24c.1 0 .2-.1.4-.1.2-.1.4-.1.4-.1l-.4.2h-.4z" fill="#513625" />
            <path d="M42.5 25.1s-.2 0-.5-.2c-.2-.1-.3-.3-.4-.5 0-.2.1-.5.2-.7.3-.3.4-.2.4-.2l-.3.2-.1.2-.1.2v.2l.1.2.4.3.3.3z" fill="#FFAD1A" />
            <path d="M42.3 23.2l-.1.1s0 .1.1.1h.2m0 0H42.2l.1-.1v.1h.2z" fill="#8B5122" />
            <path d="M43.2 23.7s-.6.2-.7.2h.8c.2-.1.8-.3.8-.1s-.7.4-.7.4v.1l.6-.1.3-.2.1-.2-.3-.2h-.7l-.2.1z" fill="#FFAD1A" />
            <path d="M42.3 24.6c0 .2.1.3.3.4 0 0-.1.1-.3 0-.4-.1-.6-.4-.7-.7v.1l.1.2.2.2.3.2h.4l.1-.1-.2-.2-.2-.4c-.1.2-.1.3 0 .3z" fill="#A64D21" />
            <path fill="#FFAD1A" d="M44.4 30.3L44.4 30.3 44.4 30.5 44.3 30.5 44.3 30.2z" />
            <path fill="#FFAD1A" d="M43.6 24.4L43.6 24.4 43.4 24.1 43.3 24.1 43.5 24.4z" />
            <path d="M44.4 30.8c-.1-.1-.2-.1-.3-.2-.1-.1-.3-.1-.4-.1v.1c.1 0 .2.1.4.1l.2.1h.1zm0-.6h-.5c-.1 0-.2.1-.2.1.1 0 .1-.1.2-.1h.5zm-.1-.4s-.3.1-.4.2l-.3.2.1-.1.2-.1.3-.1.1-.1zm-.3-.5c0 .1 0 .1-.1.2l-.1.1-.2.4-.2.2.2-.3.2-.2.1-.1c.1-.1.2-.2.1-.3zm-.3-.2V29.4c0 .1-.1.3-.2.4l-.1.2v.1l.3-.6c0-.1.1-.2 0-.4.1.1.1 0 0 0zm-.4 0v.5c0 .1-.1.2-.1.3l-.1.1.2-.5v-.3-.1zm-.3 0v.5c0 .2-.1.4-.1.4h.1v-.1l.1-.3c-.1-.2-.1-.4-.1-.5zm-.3 0s0 .1 0 0v.5c0 .1-.1.3-.1.4v-.1-.3-.2c.2-.2.2-.3.1-.3zm-.2 0v.4c0 .1-.1.2-.1.3v.2l.1-.5c.1-.1.1-.2 0-.4zm-.3.1v.1c0 .1 0 .2-.1.4-.1.1-.1.2-.2.3h-.1c.2-.1.3-.2.4-.4.1-.1.1-.2 0-.4zm-.1-.1c0 .1-.1.2-.2.3l-.2.2-.1.1c.1-.1.3-.2.4-.3.1-.1.1-.2.1-.3zm-.3-.1l-.1.1-.1.1-.2.1-.1.1.1-.1c.1 0 .1-.1.2-.1s.2 0 .2-.2zm-.1-.2l-.2.2-.1.1h-.1s.1 0 .1-.1c.2 0 .3-.1.3-.2z" fill="#816C2A" />
            <path d="M41.6 28.7s-.1.1-.2.1l-.1.1v.1h.1c.1 0 .2-.1.2-.2v-.1zm0-.1l-.1.1h-.2.1l.2-.1zm-.1-.2c-.1.1-.2.1-.2.1.1 0 .1 0 .2-.1zm0-.4l-.1.1c-.1 0-.1.1-.1.2h.1c0-.1.1-.1.1-.1l.1-.1-.1-.1zm1.9-2.2h.3-.3zm0-.2h.1c.1 0 .1-.1.2-.1h0c-.1 0-.1.1-.2.1 0 0-.1.1-.1 0zm0-.2h.1l.2-.1s.1-.1.2-.1V25h-.1c-.1 0-.1.1-.2.1-.1.1-.2.1-.2.3zm-.1-.3c.1-.1.2-.1.3-.2l.3-.2c-.1.1-.2.1-.3.2-.1.1-.2.2-.3.2zm-.2-.3c.1-.1.4-.3.6-.4l-.6.4zm-.2-.2c.1-.1.2-.2.3-.2l.3-.2-.3.2c-.1 0-.2.1-.3.2zm-.2-.2l.3-.2.2-.1.1-.1h-.2l-.4.4z" fill="#816C2A" />
            <path d="M43.1 23.9c.2.1.3.3.4.4.2.2.3.5.3.7v.1c-.1.3-.2.6-.4.9-.4.4-.8.8-1.2 1.1-.2.2-.4.3-.5.5-.1.2-.2.4-.2.6 0 .2.1.4.2.6.1.2.3.3.5.3h.1c.3 0 .7-.1 1-.1.3 0 .6.1.8.3.2.3.3.6.3 1 0 .2 0 .5-.1.7V31.3h.1c.1-.3.1-.7.1-1 0-.4-.1-.7-.3-1-.2-.2-.5-.3-.8-.3-.3 0-.7.1-1 .1h-.1c-.2 0-.4-.1-.5-.3-.1-.2-.2-.4-.2-.6 0-.3.1-.5.3-.7.3-.4.8-.7 1.2-1.1.4-.3.7-.8.8-1.3V25c0-.3-.2-.6-.4-.8-.1-.1-.2-.2-.4-.3z" fill="#6A7311" />
            <path d="M43.2 23.9h-.1.1z" fill="#A64D21" />
            <path d="M44.2 31.4h.1v.1l-.1-.1z" fill="#8F5E36" />
            <path fill="#A6AC56" d="M42.7 24.4L42.7 24.4 42.6 24.4 42.6 24.4 42.7 24.5z" />
            <path fill="#A6AC56" d="M42.9 24.6L42.9 24.6 42.8 24.5 42.8 24.5 42.8 24.6z" />
            <path fill="#6A7311" d="M43.1 24.8L43.1 24.8 43.1 24.8 43 24.8 43.1 24.9z" />
            <path fill="#6A7311" d="M43.3 25.1L43.3 25.1 43.3 25 43.2 25.1 43.3 25.1z" />
            <path fill="#6A7311" d="M43.4 25.4L43.4 25.4 43.4 25.3 43.4 25.3 43.3 25.4z" />
            <path fill="#6A7311" d="M43.4 25.6L43.4 25.6 43.4 25.5 43.4 25.5 43.4 25.6z" />
            <path fill="#6A7311" d="M43.4 25.8L43.4 25.8 43.4 25.7 43.4 25.7 43.4 25.8z" />
            <path d="M41.3 28.3v-.1c0-.1 0 0 0 0v.1z" fill="#6A7311" />
            <path fill="#6A7311" d="M41.3 28.8L41.3 28.8 41.3 28.7 41.3 28.7 41.3 28.8z" />
            <path fill="#FFFFFF" d="M41.3 29L41.3 29 41.3 28.9 41.3 28.9 41.3 29z" />
            <path fill="#FFFFFF" d="M41.3 29.2L41.3 29.2 41.3 29.1 41.3 29.2 41.3 29.2z" />
            <path fill="#FFFFFF" d="M41.4 29.5L41.4 29.5 41.4 29.4 41.4 29.4 41.4 29.5z" />
            <path fill="#A6AC56" d="M41.6 29.8L41.6 29.8 41.5 29.7 41.5 29.7 41.5 29.8z" />
            <path d="M41.8 30zm1.7.2c-.1 0-.1 0 0 0-.1.1 0 0 0 0z" fill="#A6AC56" />
            <path d="M43.7 30.4zm0 .2s0-.1 0 0z" fill="#A6AC56" />
            <path fill="#FFFFFF" d="M43.6 30.8L43.6 30.8 43.6 30.8 43.6 30.8 43.6 30.8z" />
            <path d="M41 21.9s.1 0 0 0c0 .1 0-.1 0 0z" fill="#FFFFFF" />
            <path d="M54.7 35.2c-.3.3-.5.7-.3.8s.5.1.8-.2.5-.6.3-.8-.5-.1-.8.2z" fill="#FFAD1A" />
            <path fill="#FFAD1A" d="M56.1 34.3L56.1 34.3 55.3 35 55.6 35 56.1 34.4z" />
            <path fill="#A6AC56" d="M56.2 34.4L56.1 34.2 56 34.3 56.1 34.3 56 34.3 56.1 34.4 55.6 35 55.4 35 56.1 34.3 56.1 34.3 56 34.3 56.1 34.3 56.1 34.3 56 34.3 55.3 35 55.6 35.1z" />
            <path d="M56.4 34c-.1-.1-.3 0-.3.1-.1.1 0 .2.1.3.1.1.3 0 .3-.1s0-.2-.1-.3z" fill="#FFAD1A" />
            <path d="M56.4 34h-.1c-.1 0-.2.1-.2.1v.1c0 .1.1.2.1.2h.1c.1 0 .2-.1.2-.1v-.1c0-.1 0-.2-.1-.2.1 0 .1.1.1.2v.1c0 .1-.1.1-.2.1h-.1c-.1 0-.1-.1-.1-.2v-.1c0-.1.1-.1.2-.1h.1z" fill="#A6AC56" />
            <path d="M56.5 34.1c-.1-.1-.3 0-.4.1-.1.1 0 .2.1.3.1 0 0 0 0 0l-.2-.2v-.2l.1-.1.1-.1h.1l.2.2z" fill="#A6AC56" />
            <path d="M56 34.5h-.1l-.2.1.4-.4.1.1-.2.2z" fill="#A6AC56" />
            <path d="M55 34.7c0 .1 0 .1.1.2l.1.1h.1c.1 0 .1-.1.2-.2v-.2c0-.1.1 0 .1 0s-.3-.2-.3-.1v.1h-.1l-.2.1z" fill="#E92736" />
            <path d="M55.4 34.8l-.1.1v.1c0 .1.1.1.2.1h.1s.1 0 .1-.1v-.1c0-.1.1 0 .1 0l-.2-.3v.1c0 .1-.2.1-.2.1z" fill="#E92736" />
            <path d="M55.5 35.4h.2s0-.1.1-.1h.1c.1 0 0-.3 0-.3v.1s0-.1-.1-.1h-.2-.1v.4z" fill="#E92736" />
            <path d="M55.3 34.8h-.2c-.1 0 0-.2 0-.2h.1l.1.1c.1 0 .1.1 0 .1zm.2 0s-.1 0 0 0c-.1 0-.1.1-.1.2h.2v-.1c0-.1-.1-.1-.1-.1zm.2.4c-.1-.1-.1-.1 0 0-.1 0-.2.1-.2.1l.1.1.1-.2z" fill="#FFAD1A" />
        </symbol>
        <symbol id="icon-new-zealand" viewBox="0 0 95 63.5">
            <path fill="#0037A6" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M19.1 18.8H28.6V31.8H19.1z" />
            <path fill="#FFFFFF" d="M0.2 31.7L5.4 31.7 23.4 18.9 18.2 15.2 0.2 28z" />
            <path fill="#E60026" d="M3.7 31.7L19.1 20.7 15.6 20.7 0.2 31.7z" />
            <path fill="#FFFFFF" d="M42.3 31.7L47.5 31.7 47.5 28 29.6 15.2 24.4 18.9z" />
            <path fill="#E60026" d="M47.5 31.7L47.5 29.3 35.5 20.7 32.1 20.7z" />
            <path fill="#FFFFFF" d="M47.5 0.2L42.3 0.2 24.4 13.1 29.5 16.8 47.5 3.9z" />
            <path fill="#E60026" d="M44 0.2L28.6 11.3 32.1 11.3 47.5 0.2z" />
            <path fill="#FFFFFF" d="M5.4 0.2L0.2 0.2 0.2 3.9 18.2 16.8 23.3 13.1z" />
            <path fill="#FFFFFF" d="M0.2 11.3H19.4V20.8H0.2z" />
            <path fill="#FFFFFF" d="M19.1 0.2H28.6V13.1H19.1z" />
            <path fill="#E60026" d="M0.2 0.2L0.2 2.7 12.2 11.2 15.6 11.2z" />
            <path fill="#FFFFFF" d="M28.2 11.3H47.5V20.8H28.2z" />
            <path fill="#E60026" d="M26.7 13.2L26.7 0.2 21 0.2 21 13.1 0.2 13.1 0.2 18.8 21 18.8 21 18.8 21 18.8 21 31.8 26.7 31.8 26.7 18.8 47.5 18.8 47.5 13.2z" />
            <path fill="#FFFFFF" d="M73.1 7.7L76.1 17 68.2 11.3 77.9 11.3 70.1 17z" />
            <path fill="#E60026" d="M73.1 9.5L75 15.5 69.9 11.8 76.2 11.8 71.1 15.5z" />
            <path fill="#FFFFFF" d="M73.1 45L76.4 55.2 67.7 48.9 78.4 48.9 69.8 55.2z" />
            <path fill="#E60026" d="M73.1 46.8L75.3 53.8 69.4 49.5 76.8 49.5 70.8 53.8z" />
            <path fill="#FFFFFF" d="M85.6 19.1L88.2 27.4 81.2 22.3 89.9 22.3 82.9 27.4z" />
            <path fill="#E60026" d="M85.6 20.9L87.2 25.9 82.9 22.8 88.2 22.8 83.9 25.9z" />
            <path fill="#FFFFFF" d="M58.5 22.4L61.5 31.6 53.7 25.9 63.4 25.9 55.5 31.6z" />
            <path fill="#E60026" d="M58.5 24.2L60.5 30.2 55.4 26.5 61.7 26.5 56.6 30.2z" />
        </symbol>
        <symbol id="icon-norway" viewBox="0 0 95 63.5">
            <path fill="#FF0015" d="M0 0H95V63.3H0z" />
            <path fill="#FFFFFF" d="M23.8 0H39.6V63.3H23.8z" />
            <path fill="#FFFFFF" d="M0 23.8H95V39.6H0z" />
            <path fill="#0037A6" d="M27.7 0H35.6V63.3H27.7z" />
            <path fill="#0037A6" d="M0 27.7H95V35.6H0z" />
        </symbol>
        <symbol id="icon-spain" viewBox="0 0 95 63.5">
            <path fill="#E5000E" d="M0 0H95V63.5H0z" />
            <path fill="#FFD500" d="M0 16H95V47.5H0z" />
            <path d="M38 24.9l-.3.7-.5.7-1.4.9h-8.3l-1.1-.8-.8-.9.1-.5-.2-.2c.7-.6 1.6-.9 2.5-.9 1.8.1 1.4-.6 3.8-.6s2 .7 3.8.6c.9 0 1.8.4 2.4 1z" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 26.8c-1.4 0-2.9.2-4.3.5-.1 0-.1 0-.2-.1 0-.1 0-.1.1-.2 1.4-.4 2.9-.6 4.4-.6 1.5 0 3 .2 4.4.6.1 0 .1.1.1.2s-.1.1-.2.1c-1.4-.4-2.9-.5-4.3-.5" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 25.5h.1v.2c0 .3.3.6.6.6s.5-.2.6-.4l.1-.2v.2c0 .3.3.5.6.5s.6-.2.6-.6v-.1l.2-.2.1.2c-.1.3 0 .6.2.8.1 0 .2.1.3.1.2 0 .4-.1.5-.2l.1-.1v.2c0 .2.1.4.3.4.2 0 .4-.1.5-.2.2-.1.3-.3.5-.4v.2c-.1.2-.3.4-.5.5h-.5c-.2 0-.3-.2-.4-.3-.1.1-.3.1-.4.1-.3 0-.7-.2-.8-.5-.2.2-.4.3-.7.3-.3 0-.5-.1-.7-.3-.4.3-1 .3-1.3-.1v-.1c-.2.2-.5.4-.8.4-.2 0-.4-.1-.6-.2-.2.2-.4.3-.7.3-.2 0-.5-.1-.6-.3-.1.3-.5.5-.8.5-.2 0-.3 0-.4-.1-.1.2-.2.3-.4.3s-.4 0-.5-.1c-.2-.1-.4-.3-.5-.5v-.2c.1.2.3.3.5.4.1.1.3.2.5.2s.3-.2.3-.4v-.2l.1.1c.1.2.3.3.5.2.3 0 .6-.2.6-.5 0-.1 0-.2-.1-.3l.1-.2.2.2v.1c0 .3.3.6.6.6s.6-.2.6-.5v-.2l.1.2c.1.2.3.4.6.4s.6-.2.6-.6v-.2h.1m3-1.1l-.2.1-.3-.4c.3-.2.5-.5.5-.8v-.1c0-.5-.7-1-1.5-1-.4 0-.8.1-1.1.3v-.2c.3-.2.7-.3 1.1-.3 1 0 1.7.5 1.8 1.2v.1c0 .3-.1.7-.4.9l.1.2zm-6-.2c-.3-.2-.4-.5-.4-.9v-.1c0-.6.8-1.2 1.8-1.2.4 0 .8.1 1.1.3v.2c-.3-.2-.7-.3-1.1-.3-.8 0-1.5.5-1.5 1v.1c0 .3.2.6.5.8l-.3.4-.2-.1.1-.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 21.9c.2 0 .4.1.5.3v.7c0 .4.1.7.2 1.1l-.7.6-.7-.6c.1-.3.2-.7.2-1v-.1-.6c0-.2.2-.4.5-.4" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 22.1c.1 0 .2.1.2.2 0 .2 0 .4.1.5v.2c0 .3.1.7.2 1l-.4.4-.6-.4c.1-.3.2-.7.2-1v-.1-.5c0-.2.1-.3.3-.3m3 2.3c.3-.2.5-.6.5-1s-.3-.8-.7-1c.2.2.4.5.4.8v.1c0 .3-.1.7-.4.9l.2.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M37.8 24.9c.2-.2.3-.5.3-.8 0-.2 0-.3-.1-.5-.5-.7-1.3-1-2.1-1-.3 0-.5 0-.8.1 0 .1.1.1.1.2.2 0 .4-.1.6-.1.7-.1 1.5.2 1.9.8.1.1.1.3.1.4 0 .3-.1.5-.3.7l.3.5.2-.2-.2-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M37.4 23c.2.1.4.3.5.5.1.2.1.3.1.5 0 .3-.1.6-.3.8l.2.3c.2-.2.3-.5.3-.8 0-.6-.3-1.1-.8-1.3m-8.6 1.2c-.3-.2-.4-.5-.4-.9v-.1c0-.3.2-.6.4-.8-.4.2-.7.6-.7 1s.2.7.5 1l.2-.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M25.8 24.9l-.2.3.2.2.3-.5c-.2-.2-.3-.4-.4-.7 0-.1 0-.3.1-.4.4-.6 1.2-.9 1.9-.8.2 0 .4 0 .6.1 0-.1.1-.1.1-.2-.3-.1-.5-.1-.8-.1-.8-.1-1.6.3-2.1 1-.1.2-.1.3-.1.5.1.1.2.3.4.6" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M26.1 23c-.5.2-.8.7-.9 1.3 0 .3.1.6.3.8l.2-.3c-.2-.2-.3-.5-.3-.8 0-.2 0-.3.1-.5.2-.2.4-.4.6-.5" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M25.2 25.3c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zM25 25c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1s-.1 0-.1-.1zm-.1-.4c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1zm0-.4c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1zm.1-.4c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1s-.1 0-.1-.1zm.2-.4c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1s-.1 0-.1-.1zm.3-.3c0-.1.1-.1.1-.1.1 0 .1.1.1.1l-.1.1c-.1 0-.1 0-.1-.1zm.3-.2c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1l-.1-.1zm.4-.3c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zm.4-.1c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zm.4-.1c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1 0 .1-.1 0-.1-.1zm.5 0c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1c-.1 0-.1 0-.1-.1zm.4 0c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1s-.1 0-.1-.1zm.4 0c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1s-.1 0-.1-.1zm-.2.4c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1s-.1 0-.1-.1m-.1.4c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1l-.1-.1m0 .4c0-.1.1-.1.1-.1.1 0 .1.1.1.1l-.1.1s-.1 0-.1-.1m.1.3c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1s-.1 0-.1-.1m.3.4c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1m.2-2.2c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zm.4-.1c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zm.4-.2c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1zm.5 0c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1zm.4 0c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1l-.1-.1zm.4 0c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1 0 .1-.1 0-.1-.1zm.4.2c0-.1.1-.1.1-.1l.1.1c0 .1-.1.1-.1.1s-.1 0-.1-.1zm.4 2.1c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2zm0-.5c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2c-.1.1-.2 0-.2-.2m.1-.4c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2c-.2-.1-.2-.1-.2-.2m0-.5c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1c0 .1-.1 0-.1-.1m0-.3c0-.1 0-.1.1-.1s.1 0 .1.1 0 .1-.1.1l-.1-.1m6.6 3.1c-.1 0-.1 0-.1-.1s.1-.1.1-.1c.1 0 .1.1.1.1s0 .1-.1.1zm.2-.4c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1zm.1-.4c-.1 0-.1 0-.1-.1s.1-.1.1-.1c.1 0 .1.1.1.1 0 .1 0 .1-.1.1zm0-.4c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1c0 .1 0 .1-.1.1zm-.1-.4c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1 0 .1-.1.1zm-.2-.4c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1 0 .1-.1.1zm-.3-.3c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1 0 .1.1s0 .1-.1.1zm-.3-.2c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1s0 .1-.1.1zm-.4-.2c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1s0 .1-.1.1zm-.4-.2c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1 0 .1.1s0 .1-.1.1zm-.5-.1c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1c.1.1 0 .2-.1.1 0 .1 0 .1 0 0zm-.4 0c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1 0 .1.1s0 .1-.1.1zm-.4 0c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1 0 .1-.1.1zm-.5 0c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1c.1.1 0 .1-.1.1zm.4.3c0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1 0-.1.1 0 .1.1m.1.4c0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1 0-.1.1 0 .1.1m0 .4c0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1s.1-.1.1-.1c0-.1.1 0 .1.1m-.1.3c0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1m-.3.4c0 .1-.1.1-.1.1-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1-.1.1 0 .1.1m-.4-2c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1 0 .1.1.1 0 0 .1-.1.1zm-.4-.2c-.1 0-.1 0-.1-.1s.1-.1.1-.1c.1 0 .1.1.1.1.1 0 0 .1-.1.1zm-.4-.1c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1 0 .1.1.1 0 0 .1-.1.1zm-.4-.1c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1s0 .1-.1.1zm-.4 0c-.1 0-.1 0-.1-.1s.1-.1.1-.1l.1.1s0 .1-.1.1zm-.5.1c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1.1 0 0 .1-.1.1zm-.4.1c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l.1.1c.1 0 0 .1-.1.1z" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.2 21.4c0-.3.2-.6.5-.6s.6.2.6.5-.2.6-.5.6-.6-.2-.6-.5" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.3 21.3h-.4v-.8h.3v-.3h-.3v-.3h-.3v.3h-.3v.3h.3v.8h-.4V21.6h1c0-.1.1-.2.1-.3 0 .1 0 0 0 0zm-3.5 4.4l-.1-.1v-.2c-.1 0-.2-.1-.2-.1H28v.1l.1.1c-.2 0-.3.1-.4.3.1.1.3.1.5.1v.2h.1c.1 0 .2-.1.3-.1 0-.1.1-.2.2-.3zm3.2-.2v-.2c0-.1 0-.1-.1-.2.1-.1.2-.1.2-.1.1 0 .2-.1.3-.1h.2v.2c.2 0 .4.1.5.2-.1.1-.3.2-.5.2v.2h-.2c-.1 0-.2 0-.3-.1 0 0-.1 0-.1-.1zm-4.6.3c-.2-.1-.3-.1-.5-.1v-.2c-.1 0-.1.1-.2.1-.1.1-.2.1-.3.2 0 .1-.1.1-.1.2v-.5c0-.1-.1-.2-.2-.2v.1c-.1-.1-.2-.1-.3-.1-.2 0-.4.2-.4.4.1 0 .3 0 .4.1.1.1.2.2.3.4.1-.1.2-.1.3 0l.1.1h.7v-.1l-.1-.1c.1 0 .2-.1.3-.3zm1.7-.1v-.1c0-.1 0-.1-.1-.1l.2-.2c.1 0 .2-.1.3-.1h.1v.2c.2 0 .3 0 .5.1-.1.1-.2.2-.4.3 0 0 0 .1.1.1v.1h-.4c-.2-.2-.2-.3-.3-.3zm2.5-.2s-.1-.1-.1-.2 0-.1.1-.2c-.1-.1-.2-.1-.2-.1-.1 0-.2-.1-.3-.1h-.2v.2c-.2 0-.4.1-.5.2.1.1.3.2.5.2v.2h.1c.1 0 .2 0 .3-.1.1 0 .2 0 .3-.1z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.1 24.4c-.1 0-.1.1-.1.1 0-.2-.1-.4-.2-.5-.1.1-.2.3-.2.5l-.1-.1h-.2l.1.2s0 .2.1.3c0 .1.1.2.1.2.1-.1.1-.1.2-.1s.2 0 .2.1c0-.1.1-.1.1-.2s.1-.3.1-.3l.1-.2h-.2zm-3 .4c-.1 0-.1 0 0 0-.1-.1-.2-.2-.4-.3-.1.1-.1.3-.1.5h-.1-.1l.1.1c0 .1.1.2.1.3 0 .1.1.1.1.2 0-.1.1-.1.2-.1s.1 0 .2.1c0-.1.1-.1.1-.2v-.3-.2c-.1-.2-.1-.2-.1-.1zm5.3.7c0-.1 0-.1.1-.1l-.2-.2c-.1-.1-.2-.1-.3-.1h-.1v.2c-.2 0-.3 0-.5.1.1.1.2.2.4.3 0 0 0 .1-.1.1v.1h.4c.1 0 .2-.1.2-.1.1-.2.1-.2.1-.3z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M35.1 24.9H35c0-.2 0-.3-.1-.5-.1.1-.2.2-.3.4l-.1-.1h-.1v.5c0 .1 0 .1.1.2.1 0 .1-.1.2-.1s.1.1.2.1l.2-.2c.1-.1.1-.2.1-.3h-.1s0-.1 0 0z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M35.3 25.9c.2 0 .3 0 .5-.1-.1-.1-.2-.2-.4-.3l.1-.1v-.1h-.4c-.1 0-.2 0-.2.1v.2c0 .1 0 .1-.1.1l.2.2c.1.1.2.1.3.1h.1c0-.1-.1-.1-.1-.1zm2.5-.5c-.1 0-.2 0-.3.1v-.1c-.1 0-.2.1-.2.2v.5c-.1-.2-.2-.4-.4-.4-.1 0-.1-.1-.2-.1v.2c-.2 0-.3 0-.5.1l.3.3-.1.1v.1h.7c0-.1 0-.1.1-.1.1-.1.2-.1.3 0 .1-.1.2-.3.3-.4.1-.1.3-.1.4-.1 0-.3-.2-.4-.4-.4z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M28.6 25.5c0-.1.1-.3.3-.3.1 0 .3.1.3.2s-.1.3-.2.3h-.1c-.1.1-.3 0-.3-.2 0 .1 0 .1 0 0m5.8 0c0-.1.1-.3.3-.3.1 0 .3.1.2.3 0 .1-.1.3-.3.2-.1.1-.2 0-.2-.2m3 .6c-.1-.1-.2-.1-.3 0-.1.1-.1.2-.1.3.1.1.2.1.3 0 .1 0 .2-.2.1-.3m-11.3 0c.1-.1.2-.1.3 0 .1.1.1.2.1.3-.1.1-.2.1-.3 0-.1-.1-.1-.2-.1-.3m5.4-.8c0-.1.1-.3.3-.3.1 0 .3.1.3.3 0 .1-.1.3-.3.3-.2 0-.3-.1-.3-.3" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 28.8c-1.3 0-2.6-.1-3.9-.5-.1 0-.1-.1-.1-.2s0-.1.1-.1c1.3-.3 2.6-.5 3.9-.5 1.3 0 2.6.1 3.9.5.1 0 .1.1.1.1 0 .1 0 .1-.1.2-1.3.3-2.6.5-3.9.5" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 27.5c-1.3 0-2.6.1-3.9.5.1 0 0-.1-.1-.4s-.3-.3-.3-.3c1.4-.4 2.8-.5 4.3-.5s2.9.2 4.3.5c0 0-.2 0-.3.3s-.1.4 0 .4c-1.3-.3-2.7-.5-4-.5" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M36 26.2c0-.1 0-.2-.1-.2s-.2 0-.2.1 0 .2.1.2.2.1.2-.1m-2.7-.5c0-.1 0-.2-.1-.2s-.2.1-.2.2 0 .2.1.2.2-.1.2-.2m-3.1 0c0-.1 0-.2.1-.2s.2.1.2.2 0 .2-.1.2-.2-.1-.2-.2m-2.7.5c0-.1 0-.2.1-.2s.2 0 .2.1 0 .2-.1.2c-.1.1-.2 0-.2-.1m3.1 1c0-.1 0-.1.1-.2h.1c.1 0 .1 0 .1.1s-.1.1-.1.1c-.2.1-.2 0-.2 0 0-.1 0-.1 0 0" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.4 27.3c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1h.8c.1 0 .1.1.1.1 0 .1-.1.1-.1.1h-.8z" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M30 27.1l-.6.1c-.1 0-.1.1-.1.1 0 .1.1.1.2.1l.6-.1c.1 0 .1-.1.1-.1-.1-.1-.1-.1-.2-.1z" fill="#058E6E" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M28.5 27.4c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M27.6 27.6l.1-.2h.4l-.3.2h-.2z" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M34.1 27.4c.1 0 .1 0 .1-.1s0-.1-.1-.1l-.6-.1c-.1 0-.1 0-.1.1s0 .1.1.1l.6.1z" fill="#058E6E" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.7 27.2c0-.1.1-.1.1-.1.1 0 .1 0 .1.1s-.1.1-.1.1-.1 0-.1-.1m2.1.2c0-.1.1-.1.1-.1.1 0 .1.1.1.1 0 .1-.1.1-.1.1-.1 0-.1 0-.1-.1" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M36 27.6l-.2-.2h-.4l.3.2h.3zm-4.2 1c-1.2 0-2.4-.1-3.6-.4 1.2-.3 2.4-.4 3.6-.4 1.2 0 2.4.1 3.6.4-1.2.3-2.4.4-3.6.4" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M28 28.2c1.2-.3 2.5-.5 3.8-.4 1.3 0 2.5.1 3.8.4" fill="none" stroke="#802000" stroke-width="3.000000e-02" stroke-linecap="round" stroke-linejoin="round" />
            <path d="M31.9 28.6v-.8m-.3.8v-.8m-.2.8v-.8" fill="none" stroke="#802000" stroke-width="1.000000e-02" />
            <path d="M31.2 28.6v-.8m-.2.8v-.8m-.3.7v-.7m.2.7v-.8m-.5.8v-.7m.1.7v-.7" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M29.9 28.5v-.6m.1.6v-.6m.2.6v-.6m-.4.6v-.6m-.2.5v-.5" fill="none" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M29.5 28.4v-.5m-.4.5V28m.2.4V28m-.3.3V28" fill="none" stroke="#802000" stroke-width="4.000000e-02" />
            <path d="M28.8 28.3V28m-.1.3V28m-.2.2V28" fill="none" stroke="#802000" stroke-width="5.000000e-02" />
            <path d="M32.8 28.5v-.7m-.4.7v-.8m-.3.9v-.8" fill="none" />
            <path d="M41.2 28c0 .1-.1.1-.2.1s-.2-.1-.2-.1l-.1.1c-.1 0-.2-.1-.2-.1 0 .1-.1.1-.1.1h-.2s0 .1-.1.1H40v-.1h-.1V28v-.1c0-.1.1-.2.3-.2h.3c.1-.1.3-.1.4-.1.1 0 .3 0 .4.1.1-.1.2-.1.4-.1.1 0 .3 0 .4.1h.3c.2 0 .3.1.3.2v.2h-.1l-.1.1h-.1-.1s-.1 0-.1-.1h-.1c-.1 0-.1-.1-.2-.1 0 0-.1.1-.2.1s-.1 0-.1-.1c0 0-.1.1-.2.1s-.1-.1-.2-.1" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M42.1 28.2c-.1 0-.2 0-.2-.1-.1 0-.1-.1-.1-.1s-.1.1-.2.1-.1 0-.1-.1c0 0-.1.1-.2.1s-.2-.1-.2-.1c0 .1-.1.1-.2.1s-.1 0-.1-.1l-.1.1c-.1 0-.1 0-.2-.1l-.1.1h-.2v.2c.3-.1.6-.1.9-.1h1" fill="#E5AC00" />
            <path d="M41.2 27.9c0 .1.1.2.2.1 0 0 .1 0 .1-.1v.1c0 .1.1.1.1.1.1 0 .1-.1.1-.1v.1c0 .1.1.1.1.1h.1s0 .1.1.1h.1l.1-.1v.1c0 .1-.1.1-.1.1H42s-.1 0-.1-.1h-.1c-.1 0-.1 0-.2-.1l-.1.1c-.1 0-.1 0-.2-.1 0 0-.1.1-.1 0-.1 0-.1 0-.2-.1 0 .1-.1.1-.2.1h-.1s-.1.1-.2.1-.1 0-.2-.1c0 .1-.1.1-.2.1H40s0 .1-.1.1h-.1l-.1-.1v-.1l.1.1h.1s.1 0 .1-.1c0 0 .1.1.1 0 .1 0 .1 0 .1-.1V28h.1c0 .1 0 .1.1.1s.1 0 .2-.1c0 .1.1.1.2.1l.1-.1m.1-.5c0-.1.1-.2.2-.2s.2.1.2.2-.1.2-.2.2-.2-.1-.2-.2" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M41.1 27.5c0-.1 0-.2.1-.2s.1.1.1.2 0 .2-.1.2-.1-.1-.1-.2m-.1-.3c0-.1 0-.1.1-.1s.1 0 .1.1 0 .1-.1.1-.1 0-.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M41.2 27.2L41.2 27 41.3 27 41.3 26.9 41.2 26.9 41.2 26.9 41.1 26.9 41.1 26.9 41 26.9 41 27 41.1 27 41.1 27.2 41 27.2 41 27.2 41.3 27.2 41.3 27.2z" />
            <path d="M40.3 28.5s0-.1-.1-.1c.3-.1.7-.1 1-.1.3 0 .7 0 1 .1l-.1.1s-.1.1 0 .1c-.3-.1-.6-.1-.9-.1h-.9c.1.1.1 0 0 0" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M41.2 28.8c.3 0 .5 0 .8-.1.1 0 .1-.1.1-.1-.6-.1-1.1-.1-1.7 0 0 0 0 .1.1.1.2.1.4.1.7.1m0-.6c-.3 0-.7 0-1 .1.7-.2 1.3-.2 2 0-.4 0-.7-.1-1-.1" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M41.2 28.6c-.3 0-.5 0-.8.1.5.1 1.1.1 1.6 0-.3-.1-.6-.1-.8-.1z" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M40.8 28.4c.1 0 .1 0 0 0" fill="#FFFFFF" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M41.3 28.3H41m0 .1h.2-.2z" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M40.6 28.4h-.2.2c.1-.1.1-.1 0 0 .1-.1 0 0 0 0z" fill="#058E6E" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" d="M40.2 28.5L40.2 28.5 40.3 28.5 40.3 28.5z" />
            <path d="M41.4 28.4h0c.1.1 0 .1 0 0" fill="#FFFFFF" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M41.9 28.4h-.2.2z" fill="#058E6E" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" d="M42.1 28.5L42 28.5 42 28.5 42.1 28.5z" />
            <path fill="#E5AC00" d="M42.1 28.1L42.1 28.1 42.1 28.1z" />
            <path d="M42.1 28c0-.1 0 0 0 0m0 0s-.1 0 0 0c-.1 0-.1 0-.1.1 0 0 .1 0 .1-.1 0 0 0-.1 0 0z" fill="#802000" />
            <path d="M41.5 27.9s-.1 0 0 0l-.1.1s.1 0 .1-.1c0 .1 0 0 0 0z" fill="#802000" />
            <path fill="#E5AC00" d="M40.8 28L40.8 28 40.8 28z" />
            <path d="M40.8 27.9c0 .1 0 .1.1.1l-.1-.1c.1 0 .1 0 0 0z" fill="#802000" />
            <path fill="#E5AC00" d="M40.2 28.1L40.2 28.1 40.2 28.1z" />
            <path d="M40.2 28c0 .1 0 .1 0 0 0 .1.1.1 0 0 .1.1.1.1 0 0 .1 0 0 0 0 0z" fill="#802000" />
            <path d="M41.9 27.6c.1-.1.1 0 .1 0h-.1c.1.1.1.1 0 0 0 .1 0 0 0 0zm0-.2zm-.2-.1s0-.1 0 0c.1 0 .1 0 0 0m.1 0c0 .1-.1 0 0 0zm-.3-.1s.1 0 0 0c.1-.1.1-.1.1 0 .1.1 0 .1-.1 0 .1.1.1.1 0 0 .1.1 0 .1 0 0zm-.1 0c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0 0 .1 0 .1 0 0z" fill="#FFFFFF" stroke="#802000" stroke-width="1.000000e-02" />
            <path d="M42.5 28v-.1c0-.2-.1-.4-.3-.4H42" fill="none" stroke="#802000" stroke-width="2.000000e-02" stroke-linecap="round" />
            <path d="M41.8 27.7v-.1c0-.1-.2-.2-.3-.2h-.2" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M42.6 27.8c0-.1 0 0 0 0 .1.1 0 .1 0 .1s-.1-.1 0-.1zm-.1-.2c.1-.1.1 0 .1 0s0 .1-.1 0c0 .1 0 0 0 0zm-.1-.1c0-.1 0-.1 0 0 0-.1.1-.1 0 0zm-.2-.1c0-.1 0-.1 0 0 .1-.1.1 0 .1 0h-.1c.1 0 0 0 0 0zm-.2 0c0-.1 0-.1 0 0 .1-.1.1-.1.1 0H42c.1 0 .1 0 0 0 .1 0 0 0 0 0zm-1.7.2s0-.1 0 0c.1 0 .1 0 0 0 .1 0 .1 0 0 0 0 .1 0 0 0 0zm0-.2c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0 0 .1 0 .1 0 0zm.2-.1s0-.1 0 0c.1-.1.1 0 .1 0s-.1.1-.1 0zm.1-.1s.1 0 0 0c.1-.1.1-.1.1 0 .1.1 0 .1-.1 0 .1.1.1.1 0 0 .1.1 0 .1 0 0zm.2 0s.1 0 0 0c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0z" fill="#FFFFFF" stroke="#802000" stroke-width="1.000000e-02" />
            <path d="M39.8 28v-.1c0-.2.2-.4.3-.4h.2" fill="none" stroke="#802000" stroke-width="2.000000e-02" stroke-linecap="round" />
            <path d="M40.5 27.7v-.1c0-.1.2-.2.3-.2h.2" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M39.7 27.8s0-.1 0 0m0 0c0 .1 0 0 0 0zm0-.2c.1-.1.1 0 .1 0s0 .1-.1 0c0 .1 0 0 0 0zm.1-.1c0-.1 0-.1 0 0 .1-.1.1-.1 0 0m.1 0s-.1 0 0 0zm.1-.1c0-.1 0-.1 0 0 0-.1 0 0 0 0zm.2 0s0-.1 0 0h0z" fill="#FFFFFF" stroke="#802000" stroke-width="1.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M40.7 27.8L40.5 27.9 40.6 27.7 40.5 27.7 40.4 27.8 40.5 27.9 40.3 27.9 40.3 28 40.3 28 40.5 28 40.5 27.9 40.7 28 40.7 27.9z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M39.9 28L39.9 28.1 39.9 28.1 40.1 28.1 40.1 28 40 28z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M41.2 27.8L41.3 27.7 41.2 27.6 41 27.7 41.1 27.8 41 27.8 40.9 27.9 41 28 41.1 27.9 41.2 27.9 41.3 28 41.4 27.9 41.3 27.8z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M42 27.9L41.8 27.9 41.9 27.8 41.9 27.7 41.8 27.7 41.8 27.9 41.6 27.8 41.6 27.9 41.6 28 41.8 27.9 41.8 28 42 28 42 28z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M42.3 28L42.2 28 42.2 28.1 42.4 28.1 42.4 28.1 42.4 28z" />
            <path d="M39.8 27.9h-.1.1v.1c.1 0 .1 0 0-.1.1 0 0 0 0 0zm2.7 0h-.1v.1l.1-.1c.1 0 0 0 0 0zm-2.1 0s.1 0 0 0c.1-.1.1-.1.1 0 .1.1 0 .1-.1 0 .1.1 0 .1 0 0m.7 0c0-.1 0-.1 0 0 .1-.1.1 0 .1 0h-.1m.6 0s.1 0 0 0c.1-.1.1-.1.1 0 .1.1 0 .1-.1 0 .1.1 0 .1 0 0" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" d="M39.9 28.2L39.9 28.1 39.9 28.2z" />
            <path d="M39.9 28.1v.1h.1l-.1-.1c.1 0 .1 0 0 0z" fill="#802000" />
            <path fill="#E5AC00" d="M42.3 28.2L42.3 28.1 42.4 28.2z" />
            <path d="M42.4 28c-.1.1-.1.1 0 0l-.1.1h.1V28c0 .1 0 .1 0 0z" fill="#802000" />
            <path d="M23.4 28.3c.1 0 .2-.1.3-.2.5-.4-.1-.8-.4-.7-.3-.2-.6-.2-.9-.1-.3-.1-.6 0-.9.1-.2-.1-.9.3-.4.7.1.1.2.1.3.2h2z" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 28.2h-.6l-.1-.5c-.2-.2-.3-.4-.4-.3 0 0 0-.1.1-.1.1-.1.5.1.7.5l.1.1h.5l.1-.1c.2-.3.5-.5.7-.5l.1.1s-.2.1-.4.3l-.2.5h-.6z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M21.4 27.4c.1-.1.4.1.6.5m1.4-.5c-.1-.1-.4.1-.6.5" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.2 27.4c0-.2.1-.3.2-.3s.2.1.2.3-.1.3-.2.3-.2-.1-.2-.3z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.3 27.4c0-.1 0-.3.1-.3s.1.1.1.3 0 .3-.1.3-.1-.1-.1-.3z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.3 27.1c0-.1 0-.1.1-.1s.1 0 .1.1 0 .1-.1.1-.1 0-.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.6 27.1l-.3.1v-.1h.1v-.2h-.1v-.1h.1v-.1h.1v.1h.1v.1h-.1v.2h.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M23.4 28.2l-1-.2-1 .3v.1c.3-.1.6-.1 1-.1.3-.1.6-.1 1-.1" fill="#E5AC00" />
            <path d="M21.5 28.5s0-.1-.1-.1c.3-.1.7-.1 1-.1.3 0 .7 0 1 .1 0 0 0 .1-.1.1v.1c-.3-.1-.6-.1-.9-.1-.3 0-.6 0-.9.1v-.1" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 28.8c.3 0 .5 0 .8-.1.1 0 .1-.1.1-.1-.3-.1-.6-.1-.8-.1-.3 0-.6 0-.9.1 0 0 0 .1.1.1.2.1.5.1.7.1" fill="#E5AC00" />
            <path d="M22.4 28.8c.3 0 .5 0 .8-.1.1 0 .1-.1.1-.1-.3-.1-.6-.1-.8-.1-.3 0-.6 0-.9.1 0 0 0 .1.1.1.2.1.5.1.7.1zm1-.6c-.1-.1-.2-.1-.2-.1-.1.1-.2-.1-.2-.1s-.1.1-.2.1-.1 0-.1-.1c-.1 0-.1.1-.2.1s-.1-.1-.1-.1-.1.1-.2.1-.1-.1-.1-.1c0 .1-.1.1-.1.1-.1 0-.1 0-.2-.1l-.1.1h-.2v.1c.3-.1.6-.1 1-.1.3 0 .6 0 .9.1z" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 27.9c0 .1.1.1.1.1.1 0 .1 0 .1-.1v.1c0 .1.1.1.1.1.1 0 .2 0 .2-.1 0 .1.1.1.1.1s.1 0 .1-.1c0 0 0 .1.1.1h.1l.1-.1c0 .1-.1.1-.1.1h-.1s-.1 0-.1-.1H23c-.1 0-.1 0-.2-.1l-.1.1c-.1 0-.1 0-.2-.1 0 0-.1.1-.1 0-.1 0-.1 0-.2-.1 0 .1-.1.1-.2.1h-.1l-.1.1c-.1 0-.1 0-.1-.1 0 .1-.1.1-.2.1h-.1s0 .1-.1.1h-.1c-.1 0-.1-.1-.1-.1l.1.1h.1s.1 0 .1-.1l.1.1c.1 0 .1-.1.1-.1 0 .1.1.1.1.1.1 0 .1-.1.1-.1 0 .1.1.1.1.1.1 0 .1-.1.1-.1l.4-.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 28.3c-.3 0-.7 0-1 .1.3-.1.7-.2 1-.1.3 0 .7 0 1 .1-.3-.1-.7-.1-1-.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" stroke-linejoin="round" />
            <path d="M22 28.4s0-.1 0 0c.1 0 .1 0 0 0m.1 0c-.1 0-.1 0 0 0z" fill="#FFFFFF" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 28.4h-.1.2-.1" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M21.8 28.5h.1-.1" fill="#058E6E" />
            <path d="M21.8 28.5h.1-.1" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.7 28.4s0-.1 0 0c.1-.1.1 0 .1 0s0 .1-.1 0c0 .1 0 0 0 0z" fill="#FFFFFF" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M23.1 28.5h-.2.2z" fill="#058E6E" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M22.4 28.8c-.3 0-.5 0-.8-.1.3-.1.5-.1.8-.1.3 0 .5 0 .8.1-.3 0-.5.1-.8.1z" fill="#E51623" stroke="#802000" stroke-width="2.000000e-02" stroke-linejoin="round" />
            <path fill="#E5AC00" d="M23.3 28.1L23.3 28.1 23.3 28.1z" />
            <path d="M23.4 28c0 .1 0 0 0 0m0 0c-.1 0-.1.1-.1.1l.1-.1c0 .1 0 0 0 0z" fill="#802000" />
            <path d="M22.7 27.9v0z" fill="#802000" />
            <path fill="#E5AC00" d="M22.1 28L22 28 22.1 28z" />
            <path d="M22.1 28s-.1 0 0 0c-.1 0-.1.1 0 0 0 .1 0 .1 0 0 0 0-.1-.1 0 0z" fill="#802000" />
            <path fill="#E5AC00" d="M21.5 28.1L21.4 28.1 21.5 28.1z" />
            <path d="M21.5 28c-.1 0-.1 0 0 0-.1.1-.1.1 0 0v0z" fill="#802000" />
            <path d="M22.4 27.6l-.1.1.1.2h.1l-.1-.3zm-.2.3h.2-.2zm.4 0h-.2.2zm-.9-.2v.2-.2zm-.2.3h.2-.2zm.5-.1v.1h-.2v-.1h.2zm-.6.1l-.2.1.2-.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M21.7 27.9c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0 0 .1 0 .1 0 0" fill="#E5AC00" />
            <path d="M21.7 27.9c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0 0 .1 0 .1 0 0z" fill="none" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M23.1 27.7v.2H23v-.2h.1zm.2.3h-.2.2zm-.5-.1l.2.1v-.1h-.2zm.6.1l.2.1-.2-.1zm-1-.1c-.1 0 0-.1 0 0 0-.1 0-.1 0 0 .1-.1.1 0 .1 0h-.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M23 27.9c.1-.1.1 0 .1 0 0 .1 0 .1-.1 0 0 .1 0 .1 0 0zm-1.9.2L21 28h.2c-.1 0-.1.1-.1.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" d="M21.2 28.2L21.1 28.1 21.2 28.2z" />
            <path d="M21.1 28c0 .1 0 .1 0 0v.1h.1V28v-.1l-.1.1z" fill="#802000" />
            <path d="M23.7 28.1l.2-.1h-.1c-.1 0-.1 0-.1.1 0-.1 0 0 0 0z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" d="M23.6 28.2L23.6 28.2 23.6 28.2z" />
            <path d="M23.6 28.1c.1 0 .1 0 0 0m0 0s-.1 0 0 0c-.1 0-.1 0 0 0l-.1.1h.1v-.1z" fill="#802000" />
            <path d="M21.4 40.4h2v-10h-2v10z" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M22.8 30.4v10m.3-10v10" fill="none" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M20.8 37.9c-.3.2-.5.3-.5.4s.1.1.2.2.3.4.2.5c.2-.1.3-.3.3-.6 0-.2-.1-.4-.2-.5m4.7-3.8c-.7-.2-1.4-.4-2.1-.3-.3 0-.7 0-1 .1-1.2.2-2.2.7-2.1 1.1 0 0-.5-1-.5-1.1-.1-.4 1-1 2.3-1.2.4-.1.8-.1 1.2-.1.7 0 1.4.1 2.1.3l.1 1.2" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M21.4 35.3c-.6 0-1-.2-1-.4s.1-.4.5-.6h.5v1m2-.7c.3 0 .5.1.8.3.1.1-.2.4-.8.7v-1" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M20.1 37.3c-.1-.2.5-.5 1.3-.8.4-.1.6-.3 1-.4 1.1-.5 1.9-1 1.8-1.2.1.3.1.7.1 1 .1.2-.6.7-1.6 1.2-.3.2-1 .4-1.3.5-.6.2-1.1.6-1.1.7l-.2-1" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M21.2 33.6c.2-.1.4-.2.3-.4s-.2-.2-.4-.1l-.3.1.3.8h.2l-.1-.4zm-.1-.4c.2 0 .2 0 .3.1 0 .1 0 .2-.1.2h-.1l-.1-.3m.9-.3h-.2l.2.8.5-.1v-.1l-.3.1-.2-.7m1.1.7c.1-.3.2-.6.4-.8h-.1c-.1.2-.1.4-.2.6l-.3-.6h-.2c.1.3.3.5.5.8h-.1m1.2-.6l.1-.1c-.1 0-.1-.1-.2-.1-.2 0-.4.1-.4.2s.4.3.4.4-.1.1-.2.1-.2-.1-.2-.2v.1c.1 0 .1.1.2.1.2 0 .4-.1.4-.2s-.5-.2-.4-.3.1-.1.2-.1c0 0 .1 0 .1.1" fill="#E5AC00" />
            <path d="M24.4 41.9c-.2 0-.3 0-.5-.1-.3-.1-.7-.1-1 0-.2.1-.3.1-.5.1s-.3 0-.5-.1c-.1-.1-.3-.1-.5-.1s-.3 0-.5.1-.3.1-.5.1v.3c.2 0 .4 0 .6-.1.2-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1.3 0 .5-.1c.3-.2.7-.2 1 0 .1.1.3.1.5.1l-.1-.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M24.4 42.2c-.2 0-.3 0-.5-.1-.3-.2-.7-.2-1 0-.2.1-.3.1-.5.1s-.3 0-.5-.1-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1v.3c.2 0 .3 0 .5-.1s.3-.1.5-.1.3 0 .5.1.3.1.5.1.3 0 .5-.1c.3-.1.7-.1 1 0 .1.1.3.1.5.1v-.3" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M24.4 42.5c-.2 0-.3 0-.5-.1-.3-.1-.7-.1-1 0-.2.1-.3.1-.5.1s-.3 0-.5-.1c-.1-.1-.3-.1-.5-.1s-.3 0-.5.1-.3.1-.5.1v.3c.2 0 .3 0 .5-.1s.3-.1.5-.1.3 0 .5.1.3.1.5.1.3 0 .5-.1c.3-.1.7-.1 1 0 .1.1.3.1.5.1v-.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M24.4 43.1c-.2 0-.3 0-.5-.1s-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1-.3 0-.5-.1c-.1-.1-.3-.1-.5-.1s-.3 0-.4.1c-.2.1-.3.1-.5.1v-.3c.2 0 .3 0 .5-.1s.3-.1.5-.1.3 0 .5.1.3.1.5.1.3 0 .5-.1c.3-.1.7-.1 1 0 .2.1.3.1.5.1l-.1.3" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M24.4 43.4c-.2 0-.3 0-.5-.1-.3-.2-.7-.2-1 0-.2.1-.3.1-.5.1s-.3 0-.5-.1c-.1-.1-.3-.1-.5-.1s-.3 0-.5.1-.3.1-.5.1v-.3c.2 0 .4 0 .6-.1.2-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1.3 0 .5-.1.3-.1.5-.1.3 0 .5.1.3.1.5.1l-.1.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M21.3 40.7c0 .3-.2.4-.3.4h2.9c-.2 0-.3-.1-.3-.3v-.1h-2.3m.1-.2h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1s0-.1.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M21 41.8h2.9v-.7H21v.7zm0-12.2h2.8v-.7H21v.7zm.3.4h2.2c-.1 0-.1-.1-.1-.2s.1-.1.1-.2H21.2c.1 0 .1.1.1.2.1.1.1.2 0 .2m.1 0h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1-.1-.1 0-.1.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M21.4 29.6h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1s0-.1.1-.1m18.4 0h2.8v-.7h-2.8v.7zm2.5.4h-2.2c.1 0 .1-.1.1-.2s-.1-.1-.1-.2H42.4c-.1 0-.1.1-.1.2-.1.1-.1.2 0 .2m-2.2 0h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1s0-.1.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M40.1 29.6h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1s0-.1.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.2 41.9c.2 0 .3 0 .5-.1.3-.1.7-.1 1 0 .2.1.3.1.5.1s.3 0 .5-.1c.1-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1v.3c-.2 0-.3 0-.5-.1s-.4-.1-.5-.1c-.2 0-.3 0-.5.1s-.3.1-.5.1-.3 0-.5-.1c-.3-.2-.7-.2-1 0-.2.1-.3.1-.5.1v-.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.2 42.2c.2 0 .3 0 .5-.1.3-.2.7-.2 1 0 .2.1.3.1.5.1s.3 0 .5-.1c.1-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1v.3c-.2 0-.3 0-.5-.1s-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1-.3 0-.5-.1c-.3-.1-.7-.1-1 0-.2.1-.3.1-.5.1v-.3" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.2 42.5c.2 0 .3 0 .5-.1.3-.1.7-.1 1 0 .2.1.3.1.5.1s.3 0 .5-.1c.1-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1v.3c-.2 0-.3 0-.5-.1s-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1-.3 0-.5-.1c-.3-.1-.7-.1-1 0-.2.1-.3.1-.5.1v-.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.2 43.1c.2 0 .3 0 .5-.1s.3-.1.5-.1.3 0 .5.1.3.1.5.1.3 0 .5-.1c.1-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1v-.3c-.2 0-.3 0-.5-.1s-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1-.3 0-.5-.1c-.3-.1-.7-.1-1 0-.2.1-.3.1-.5.1v.3" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.2 43.4c.2 0 .3 0 .5-.1.3-.2.7-.2 1 0 .2.1.3.1.5.1s.3 0 .5-.1c.1-.1.3-.1.5-.1s.3 0 .5.1.3.1.5.1v-.3c-.2 0-.3 0-.5-.1s-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1-.3 0-.5-.1-.3-.1-.5-.1-.3 0-.5.1-.3.1-.5.1v.3" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M42.3 40.7c0 .3.2.4.4.4h-2.9c.2 0 .3-.1.3-.3v-.1h2.2m-2.2-.2h2.1c.1 0 .1 0 .1.1s-.1.1-.1.1h-2.1c-.1 0-.1 0-.1-.1s0-.1.1-.1" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.7 41.8h2.9v-.7h-2.9v.7z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M42.8 37.9c.3.2.5.3.5.4s-.1.1-.2.2-.3.4-.2.5c-.2-.1-.3-.3-.3-.6-.1-.2 0-.4.2-.5" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M40.1 40.4h2v-10h-2v10z" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M41.6 30.4v10m.2-10.1v10" fill="none" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M38 34.1c.7-.2 1.4-.4 2.1-.3.3 0 .7 0 1 .1 1.2.2 2.2.7 2.1 1.1 0 0 .5-1 .5-1.1.1-.4-1-1-2.3-1.2-.4-.1-.8-.1-1.2-.1-.7 0-1.4.1-2.1.3l-.1 1.2" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M42.2 35.3c.6 0 1-.2 1-.4s-.2-.4-.5-.6h-.5v1m-2.1-.7c-.3 0-.5.1-.8.3-.1.1.2.4.8.7v-1" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M43.5 37.3c0-.2-.5-.5-1.3-.8-.4-.1-.7-.3-1-.4-1.1-.5-1.9-1-1.8-1.2-.1.3-.1.7-.1 1-.1.2.6.7 1.6 1.2.3.2 1 .4 1.3.5.6.2 1.1.6 1.1.7l.2-1" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M39.3 33.7l.3-.9h-.2c0 .2-.1.4-.2.6-.1-.2-.2-.4-.4-.5h-.2c.2.2.4.5.5.8h.2m.8-.9h-.2v.8h.6-.3l-.1-.8m.9.1h.3l-.8-.1h.3l-.1.7h.2l.1-.7m.3.9h.2l.1-.4.1.2.1.3h.2v-.1c-.1-.1-.1-.3-.2-.4.1 0 .2 0 .3-.2 0-.1 0-.2-.1-.2h-.3l-.3-.1-.1.9m.4-.7c.1 0 .2 0 .2.1v.1c0 .1-.1.2-.3.1l.1-.3m1.1 1v.3l.1.1.1.1.1-.9-.9.4h.2l.2-.2.2.2zm-.3-.2l.3-.2v.3l-.3-.1" fill="#E5AC00" />
            <path d="M31.8 43.6c-1.6 0-3.2-.4-4.6-1.1-1-.5-1.7-1.5-1.7-2.7v-4.2h12.6v4.2c0 1.1-.7 2.2-1.7 2.7-1.4.8-3 1.1-4.6 1.1" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.1 41.8c0-.1 0-.1 0 0v-.2H32l-.1.1v-.1l-.1-.1-.1.1-.1.1s-.1 0-.1-.1h-.2l.1.1v.1c-.2 0-.4.2-.4.5s.3.6.7.5c.3 0 .6-.2.7-.5.1-.3-.1-.5-.3-.5z" fill="#FFD691" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.1 42.7h-.7s.2.1.2.2c.1.1.3.2.4.2.3.1.5.1.8 0-.2-.1-.5-.2-.7-.4zm1.5.1c-.3.1-.5.2-.7.4h.7c.2 0 .4-.1.5-.2l.2-.1c-.2-.1-.4-.2-.7-.1z" fill="#058E6E" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 41.8c-.3.2-.3.6-.1.9l.1.1c.3-.3.3-.7 0-1 .1 0 0 0 0 0z" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.9 42.8c-.1.1-.1.2-.1.3 0 .1 0 .2-.1.3h.2v-.3-.3z" fill="#058E6E" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 28.7h-6.3v11.2c.1 1.7 1.6 3.1 3.3 3 1.6-.1 2.9-1.4 3-3V28.7z" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.8 35.7h-.7v6.1c.5-.5.7-1.2.7-1.9v-4.2zm-4.9 0v6.7c.2.1.5.2.7.3v-7h-.7zm-1.4 0v4.2c0 .7.2 1.4.7 1.9v-6.1h-.7zm4.2 0v7c.2-.1.5-.2.7-.3v-6.7h-.7zm-1.4 0v7.2h.7v-7.2h-.7z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path fill="none" stroke="#802000" stroke-width="3.000000e-02" d="M31.1 35.7L26.2 35.7" />
            <path d="M31.8 35.7h6.3v-7h-6.3v7z" fill="#FFFFFF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M38.1 35.7v4.2c0 1.7-1.4 3.2-3.2 3.2-1.7 0-3.2-1.4-3.2-3.2v-4.2h6.4" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M34.6 39.1s0-.1 0 0l-.5-.1v-.2h.5L34 38l.2-.1.7.7v-1h.1v1l.6-.7.2.1-.6.7v.1h.5v.2h-.5v.1l.6.7-.2.1-.6-.7v1.1h-.2v-1.1l-.6.7-.2-.1.6-.7m1.1 2.5c-.2.1-.3.1-.5.1 0-.1-.1-.2-.2-.2v-.9h-.2v.9c-.1 0-.2.1-.2.2-.2 0-.3-.1-.5-.1l-.1.2c.2.1.4.1.6.2 0 .2.2.3.3.2.2 0 .3-.1.3-.2.2 0 .4-.1.6-.2l-.1-.2zm-.8.4c-.1 0-.1-.1-.2-.1 0-.1.1-.1.2-.1s.1.1.1.1c.1.1 0 .1-.1.1zm2.1-1.3c.1-.2.1-.4.2-.6H37c0 .2-.1.4-.1.5h-.2l-.6-.6-.2.1.5.6c-.1.1-.1.3 0 .4-.1.1-.3.2-.4.3l.1.2c.2-.1.3-.2.5-.4.1 0 .2 0 .3-.1.2-.1.2-.3.1-.4zm-.2.3c-.1.1-.2.1-.2 0-.1-.1-.1-.1 0-.2s.1-.1.2 0 .1.2 0 .2zm.6-2.1c0-.1-.1-.3-.2-.3v-.7H37v.7c-.1 0-.2.1-.2.2h-.6v.2h.6c0 .1.1.2.2.2v.5h.2v-.5c.1 0 .2-.1.2-.3zm-.4.2c-.1 0-.1-.1-.2-.1 0-.1.1-.1.2-.1s.1.1.1.1c.1 0 0 .1-.1.1zm0-2.8c-.1 0-.3.1-.3.2h-.6v.2h.6l-.8.9.2.1.8-.9v.7h.2v-.7c.2-.1.3-.3.2-.4-.1-.1-.2-.2-.3-.1zm0 .4c-.1 0-.2 0-.2-.1s0-.2.1-.2h.1c.1 0 .1.1.1.1 0 .2 0 .2-.1.2zm-1.8-.2c0-.1-.2-.2-.3-.2-.1 0-.3.1-.3.2h-.5v.2h.5c0 .1.1.2.2.2v.4h.2v-.4c.1 0 .2-.1.2-.2h.5v-.2h-.5zm-.3.2c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1.1.1 0 .1-.1.1zm-1.8.1s0-.1 0 0l.6-.1v-.2h-.6c-.1-.1-.2-.2-.3-.2-.2 0-.3.1-.3.3 0 .1.1.3.2.3v.7h.2v-.7l.8.9.2-.1-.8-.9zm-.3 0c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1.1 0 .1.1.1.1l-.1.1zm.3 2c0-.1-.1-.2-.2-.2v-.7h-.2v.7c-.1 0-.2.2-.2.3 0 .1.1.3.2.3v.5h.2v-.5c.1 0 .2-.1.2-.2h.6v-.2h-.6zm-.3.3c-.1 0-.1-.1-.2-.1 0-.1.1-.1.2-.1s.1.1.1.1c.1 0 0 .1-.1.1zm.6 2c.1-.1.1-.3 0-.4l.5-.6-.1-.1-.5.6h-.2c-.1-.2-.1-.4-.1-.5h-.2c0 .2.1.4.2.6-.1.1-.1.3 0 .4.1.1.2.1.3.1.1.2.3.3.5.4l.1-.2c-.3-.1-.4-.2-.5-.3zm-.2-.1c-.1.1-.1.1-.2 0-.1 0-.1-.1 0-.2s.2-.1.2 0c.1.1.1.2 0 .2z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M32.7 40.2h-.2v-.6l.2-.1v.7zm.2-.7l.2.1v.6l-.2.1v-.8z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M32.7 37.4L32.5 37.5 32.5 38 32.7 38.1 32.7 37.4" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M32.9 37.4L33.1 37.5 33.1 38 32.9 38.1 32.9 37.4" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M34.3 36.7L34.2 36.9 33.6 36.9 33.5 36.7 34.3 36.7" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M34.3 36.5L34.2 36.3 33.6 36.3 33.5 36.5 34.3 36.5" />
            <path d="M33.6 41.3c.2.1.4.3.6.3v-.2c-.2-.1-.4-.1-.5-.3l-.1.2m-.1.2c.2.1.4.3.6.3l-.1.2c-.2-.1-.4-.1-.5-.3v-.2" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.8 40.3L34 40.4 34.4 40 34.3 39.8 33.8 40.3" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.7 40.2L33.5 40 33.9 39.5 34.1 39.6 33.7 40.2" />
            <path d="M37.1 40.2h.2v-.6l-.2-.1v.7zm-.2-.7l-.2.1v.6l.2.1v-.8m-.7 1.8c-.2.1-.4.3-.6.3l-.1-.2c.2-.1.4-.1.5-.3l.2.2m.1.2c-.2.1-.4.3-.6.3l.2.2c.2-.1.4-.1.5-.3l-.1-.2" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.9 37.4L36.7 37.5 36.7 38 36.9 38.1 36.9 37.4" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M37.1 37.4L37.3 37.5 37.3 38 37.1 38.1 37.1 37.4" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36 40.3L35.8 40.4 35.4 40 35.5 39.8 36 40.3" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.2 40.2L36.3 40 35.9 39.5 35.7 39.6 36.2 40.2" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.8 37.5L34 37.4 34.4 37.9 34.3 38 33.8 37.5" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.6 37.7L33.5 37.8 33.9 38.3 34.1 38.2 33.6 37.7" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36 37.5L35.8 37.4 35.5 37.9 35.6 38 36 37.5" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.2 37.7L36.3 37.8 36 38.3 35.7 38.2 36.2 37.7" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.5 38.8L33.6 38.6 34.2 38.6 34.3 38.8 33.5 38.8" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M33.5 39L33.6 39.2 34.2 39.2 34.3 39 33.5 39" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.3 38.8L36.2 38.6 35.7 38.6 35.6 38.8 36.3 38.8" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.3 39L36.2 39.2 35.7 39.2 35.6 39 36.3 39" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35 40.9L35.2 40.8 35.2 40.2 35 40.2 35 40.9" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M34.8 40.9L34.6 40.8 34.6 40.2 34.8 40.2 34.8 40.9" />
            <path d="M34.8 37.2l-.2.1v.6l.2.1v-.8m.2 0l.2.1v.6l-.2-.1v-.6" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.6 36.7L35.7 36.9 36.2 36.9 36.3 36.7 35.6 36.7" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.6 36.5L35.7 36.3 36.2 36.3 36.3 36.5 35.6 36.5" />
            <path d="M34.6 38.9c0-.2.2-.3.3-.3.2 0 .3.1.3.3 0 .2-.2.3-.3.3-.2.1-.3-.1-.3-.3" fill="#058E6E" stroke="#802000" stroke-width="2.000000e-02" />
            <path d="M27.6 30.3h-.1v-.1h-.2v.5h.2v.3h-.4v.9h.2v1.9h-.5v1h3.6v-1H30v-1.9h.2V31h-.4v-.3h.2v-.5h-.2v.1h-.1v-.1h-.2v.1h-.2v-.1h-.2v.5h.2v.3h-.4v-1h.2v-.5h-.2v.1h-.1v-.1h-.2v.1h-.1v-.1h-.2v.5h.2v1H28v-.3h.2v-.5H28v.1h-.1v-.1h-.2l-.1.1zm-.7 4.4h3.6m-3.6-.2h3.6m-3.6-.2h3.6m-3.6-.3h3.6m-3.6-.3h3.6m-3.2-.2H30m-2.6-.2H30m-2.6-.2H30m-2.6-.3H30m-2.6-.2H30m-2.6-.2H30m-2.6-.3H30m-2.9-.2h3.1m-3.1-.2h3.1m-3.1-.3h3.1m-3.1-.2h3.1m-2.7-.2h2.2m-1.3-.2h.4m-.4-.3h.4m-.4-.2h.4m-.4-.2h.4m-.6-.3h.9m-1.6 1h.5m-.7-.3h.9m-.9 4.3v-.3m0-.2V34m-.2.2v.2m.4.1v-.2m.3.4v-.2m0-.2V34m0-.3v-.2m0-.2V33m-.3 1.1v-.3m-.4.3v-.3m.9 0v.2m.2-.3v-.2m-.7-.2v.2m.5-.2v.2m.4-.2v.2m-.2-.2V33m.2-.2v.2m0-.6v.2m-.2-.5v.2m.2-.4v.2m-.4-.2v.2m-.5-.2v.2m-.2-.4v.2m.5-.2v.2m.4-.2v.2m.2-.4v.2m-.4-.2v.2m-.5-.2v.2m-.2-.5v.2m.9-.2v.2m-.4-.6v.2m2-.2h-.5m.7-.3h-.9m.9 4.2v-.2m0-.2V34m.2.2v.2m-.4.1v-.2m-.2.4v-.2m0-.2V34m0-.3v-.2m0-.2V33m.2 1.1v-.3m.4.3v-.3m-.9 0v.2m-.2-.3v-.2m.7-.2v.2m-.5-.2v.2m-.4-.2v.2m.2-.2V33m-.2-.2v.2m0-.6v.2m.2-.5v.2m-.2-.4v.2m.4-.2v.2m.5-.2v.2m.2-.4v.2m-.4-.2v.2m-.5-.2v.2m-.2-.5v.2m.4-.2v.2m.5-.2v.2m.2-.4v.2m-.9-.2v.2m.5-.7v.3m-.9 2.3V33m0-.6v-.2m0 .6v-.2m0-.7v-.2m0-.2v-.2m0-.5v-.2m0-.3v-.2m-1.1.6h.4m.4-.7h.4m.5.7h.5" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M29.2 34.7v-.6c0-.1-.1-.5-.6-.5s-.6.4-.6.5v.6h1.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M28.3 34.2H28c0-.1 0-.3.1-.3l.3.2c-.1-.1-.1 0-.1.1zm.7 0h.3c0-.1 0-.3-.1-.3l-.2.1v.2zm-.2-.3l.1-.3c-.1 0-.2-.1-.3-.1-.1 0-.2 0-.2.1l.1.3h.3zm-.6-.8v-.6c0-.2-.1-.3-.3-.3-.2 0-.3.1-.3.3v.6h.6zm.9 0v-.6c0-.2.1-.3.3-.4s.3.1.4.3v.7h-.7zm-.2-1.5V31h-.5v.6h.5zm.4 0l-.1-.6h.6l-.1.6h-.4zm-1.3 0V31h-.5l.1.6h.4z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M29 34.7v-.5c0-.2-.2-.4-.4-.4s-.4.1-.4.3v.5h.8zm-.9-1.6v-.6c0-.1-.1-.3-.2-.3s-.3.1-.3.3v.6h.5zm1 0v-.6c0-.1.1-.3.2-.3s.3.1.3.2v.7h-.5z" fill="#1966FF" />
            <path d="M29.8 35.7c.1-1.1 1.2-1.9 2.3-1.8 1.1.1 1.9 1.2 1.8 2.3-.1 1.1-1 1.8-2.1 1.8-1.2-.1-2.1-1.1-2-2.3" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M30.4 35.7c.1-.8.9-1.3 1.7-1.2.8.1 1.3.9 1.2 1.7-.1.7-.7 1.2-1.4 1.2-1-.1-1.6-.9-1.5-1.7" fill="#1966FF" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.4 35.1c-.1 0-.1 0-.2.1 0-.1.1-.2.1-.3 0-.1-.1-.3-.2-.4-.1.1-.2.2-.2.4 0 .1 0 .2.1.3 0-.1-.1-.1-.2-.1s-.2.1-.2.2v.1l.1.1.1-.1c.1 0 .1.1.1.1v.2l-.1.2h.1l.1.1.1-.1h.1l-.1-.2v-.2c0-.1.1-.1.1-.1s.1 0 .1.1l.1-.1v-.1c.2-.1.1-.2 0-.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M30.9 35.7h.5v-.1h-.5v.1zm1.8-.6c-.1 0-.1.1-.2.1 0-.1.1-.2.1-.3 0-.1-.1-.3-.2-.4-.1.1-.2.2-.2.4 0 .1 0 .2.1.3 0-.1-.1-.1-.2-.1s-.2.1-.2.2v.1l.1.1.1-.1c.1 0 .1 0 .1.1v.2l-.1.2h.1l.1.1.1-.1h.1l-.1-.2v-.2c0-.1.1-.1.1-.1.1 0 .1 0 .1.1 0-.1.1-.1.1-.2.2-.2.1-.2 0-.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.2 35.7h.5v-.1h-.5v.1zm-.1.5c-.1 0-.1.1-.2.1.1-.1.1-.2.1-.3 0-.1-.1-.3-.2-.4-.1.1-.2.2-.2.4 0 .1 0 .2.1.3 0-.1-.1-.1-.2-.1s-.2.1-.2.2.1.1.1.2l.1-.1c.1 0 .1 0 .1.1v.4h.1l.1.1.1-.1h.1l-.1-.2v-.2c0-.1.1-.1.1-.1s.1 0 .1.1c0-.1.1-.1.1-.2s0-.2-.1-.2z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M31.5 36.8h.5v-.1h-.5v.1z" fill="#E5AC00" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M32.8 30.5c-.1 0-.1 0-.2.1v.2l.1-.1h.2v-.1-.1m2.1-.1v-.1h-.3c-.1 0-.2-.1-.3-.2-.1-.1-.1-.1-.2-.1s-.2 0-.3.1c.1 0 .2.1.2.2.1.1.1.2.2.2h.4l.3-.1" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M37.3 29.6c-.2.2-.3.2-.4.5 0-.1 0-.3-.1-.4 0 .3-.3.6-.2 1 0 .1 0 .3-.1.4 0 .2.1.4.1.6.1.2.2.8-.2.9s-.6-.2-.7-.4c-.1-.2-.2-.5-.3-.7 0 0 .1 0 .1.1l.1.1v-.3c0-.1 0-.2-.1-.2.1.1.2.2.2.3 0-.1 0-.3-.1-.4.1 0 .2.1.3.2v-.2c0-.1-.1-.1-.1-.2 0 0-.1-.1-.1-.2v-.1s.1 0 .1.1l.1.1v-.1-.1-.4l-.3-.3c-.1-.1-.2-.2-.4-.2-.1 0-.1 0-.2.1 0 0 0 .1-.1.1h-.4v.1c0 .1.1.1.3.1s.1.1.1.2-.2.1-.3.1h-.2s.2.1.2.2-.1.1-.1.1h-.3-.2c-.1-.1-.2-.1-.3-.2-.1 0-.2-.1-.2-.1-.1-.1-.1-.1-.1-.2V30l.1-.1h-.1s-.1 0-.1-.1v.2s-.1-.1-.2-.1-.1.2-.1.2l-.1.1s0 .1.1.1.1.1.1.1h-.2c-.1 0 0 .1 0 .1v.1s0 .1.1.1h.1s.1 0 .1.1l.1.1s.1.1.2.1h-.1c-.1 0-.1 0-.2.1.2 0 .3 0 .5.1l-.2.1c.3.2.4 0 .7.4l-.2.1-.2.1h-.3c-.1 0-.1-.1-.1-.1s-.1 0-.1.1l-.1.1s0 .1.1.1.1 0 .1.1-.1 0-.2 0 0 0 0 .1v.1h.2s0 .1-.1.1 0 .1 0 .1h.2l.1-.1v-.2c0-.1.1-.1.2-.1s.1-.1.2-.1 0 .2 0 .2c.1-.1.2-.2.3-.4v.3c.1-.1.2-.2.4-.3 0 .1.1.1.1.2.1.1.2.2.2.3.1.1.5.2.5.2h-.6c-.1 0-.2.1-.3.2v.3c0 .1 0 .1.1.2v-.1l.1-.1V33.4l.1-.1s0-.1.1-.1v.2l-.2.1c-.1 0-.2 0-.3-.1-.1-.1 0-.1-.1-.2s-.1.1-.1.1l-.1.1c-.1 0 0 .1 0 .1v.1c0 .1-.1 0-.2 0s0 .1 0 .1 0 .1.1.1h.2c.1 0 0 0 0 .1v.1h.2s.1 0 .1-.1 0-.1.1-.1H35.4l.1-.1c0-.1 0-.2-.1-.3V33c0-.1.1 0 .2 0h.2c-.1.3 0 .6.3.8v-.3l.2.3v-.3c0 .2.1.3.1.5.1.1.1.2 0 .2h-.1c-.1 0-.1-.1-.2 0s0 .1 0 .1v.1s.1.1.1 0h.1s0 .1-.1.1-.1.1-.1.1.1 0 .1.1.1.1.1.1v-.1-.1.2s.1 0 .1-.1.1 0 .1 0v-.2-.2c0-.1.1-.2.1-.3l.2-.2v-.1s0-.1-.1-.1c0 0-.1 0-.2-.1s-.2-.1-.2-.3c0-.1.1-.2.2-.3.2 0 .3-.1.4-.2.2-.2.2-.4.2-.6-.1-.2-.2-.5-.2-.7 0-.1-.1-.5.1-.6.4-.2.1-.4.5-.6h-.3c-.1-.1.1-.2.1-.6z" fill="#FF80D4" stroke="#802000" stroke-width="3.000000e-02" stroke-miterlimit="10" />
            <path d="M35.2 29.9c.1 0 .2.1.2 0-.1 0-.1-.1-.2 0 0-.1-.1-.1 0 0zm-.5.1c-.1 0-.1 0 0 0 0-.1.1-.1 0 0 0-.1.1-.1 0 0" fill="#802000" />
            <path d="M33.2 30h.2v-.1c0-.1-.1-.2-.2-.2v.1c.1.1 0 .2 0 .2m-.2.1c0-.1-.1-.1-.2-.1s-.1 0-.2.1h.2v.1c.1.1.1.1.2-.1 0 .1 0 .1 0 0" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M33.1 31.8h-.2c-.1 0-.1.1-.2.1h.1v.1l.1-.1.2-.1m-.1.4h-.1s-.1.1-.1.2h.2v-.2m.2.3v.2l.1.1v-.1-.1l-.1-.1m.9.9s-.1-.1-.2-.1-.1 0-.2.1h.1l.1.1.2-.1m-.2.4h-.2v.2c0-.1.1-.1.2-.2l.1.1v-.2m.1.5s-.1.1 0 .1l.1.1v-.1l.1-.1h-.2m1.6.1h-.2c-.1 0-.1.2-.1.2s.1-.1.2-.1h.1v-.1m0 .4s-.1.1 0 .1c0 0 0 .1.1.1v-.1h.1l-.1-.1h-.1m.4.1v.2l.1.1s-.1-.1 0-.2c0 0 0-.1.1-.1h-.2" fill="#E51623" stroke="#802000" stroke-width="3.000000e-02" />
            <path d="M36.1 30c0-.1-.1-.1 0 0-.1-.1-.1-.1 0 0m-.1-.1c-.1-.1-.1-.1 0 0-.1-.1-.1-.1 0-.1l-.1.1v-.1h-.1v-.1h-.1c-.1 0-.1-.1-.1-.2V29.8c.1 0 .3.1.4.2l.3.3.1-.1h.2s-.5-.2-.5-.3H36z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" stroke-linecap="round" stroke-linejoin="round" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.7 29.3L35.6 29.3 35.6 29.4 35.6 29.4 35.6 29.4 35.7 29.4z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.6 29.4L35.6 29.3 35.5 29.4 35.5 29.4 35.6 29.5 35.6 29.4z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.6 29.4L35.6 29.4 35.6 29.5 35.7 29.5 35.7 29.5 35.7 29.4z" />
            <path fill="#E5AC00" d="M35.6 29.5L35.6 29.5 35.6 29.5z" />
            <path d="M35.6 29.4s0 .1 0 0c0 .2.1.2 0 0z" fill="#802000" />
            <path d="M35.3 29.2h-.1.1l-.1.1c.1 0 .2-.1.1-.1z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.4 29.3L35.3 29.3 35.3 29.3 35.3 29.3 35.4 29.4 35.4 29.3z" />
            <path fill="#E5AC00" d="M35.3 29.4L35.3 29.4 35.3 29.4z" />
            <path d="M35.3 29.3s0-.1 0 0z" fill="#802000" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36 29.5L35.9 29.5 35.9 29.6 35.9 29.6 35.9 29.6 36 29.5z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.8 29.5L35.8 29.5 35.8 29.6 35.9 29.6 35.9 29.6 35.9 29.6z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M35.9 29.6L35.9 29.6 35.9 29.6 35.9 29.7 36 29.7 36 29.6z" />
            <path fill="#E5AC00" d="M35.9 29.6L35.8 29.6 35.9 29.6z" />
            <path d="M35.9 29.6s-.1 0 0 0c-.1 0-.1-.1 0 0z" fill="#802000" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.2 29.7L36.2 29.7 36.1 29.8 36.1 29.8 36.1 29.8 36.2 29.8z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.1 29.8L36.1 29.8 36.1 29.8 36.1 29.9 36.2 29.9 36.2 29.9z" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.1 29.7L36 29.7 36 29.8 36.1 29.8 36.1 29.8 36.1 29.8z" />
            <path fill="#E5AC00" d="M36.1 29.9L36.1 29.9 36.1 29.9z" />
            <path d="M36 29.8c0 .1 0 .1 0 0 .1.1.1 0 0 0z" fill="#802000" />
            <path d="M36.4 30h-.1.1s.1 0 0 0c.1 0 .1.1 0 0z" fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" />
            <path fill="#E5AC00" stroke="#802000" stroke-width="2.000000e-02" d="M36.3 30L36.2 30 36.2 30 36.3 30.1 36.3 30.1 36.3 30.1z" />
            <path fill="#E5AC00" d="M36.3 30.1L36.3 30.1 36.3 30.1z" />
            <path d="M34.1 30.9c-.1 0-.1 0-.1.1v.1H34.6s-.1.1-.1.2v.1c0 .1 0 .2-.1.2l.2-.1c.1 0 .2-.1.2-.1l.1-.1v.4l.1-.1c.1-.1.1-.2.2-.2 0 .1.1.3.1.4 0-.1 0-.1.1-.1 0-.1.1-.2.1-.2v.1m-1.5 0c.1-.1.3-.2.4-.3m.1.7l.2-.1c.1 0 .1-.1.1-.1m.5.9s.3.2.2.3c0 .1-.1.2-.1.3" fill="none" stroke="#802000" stroke-width="3.000000e-02" />
        </symbol>
        <symbol id="icon-sweden" viewBox="0 0 95 63.5">
            <path fill="#006DD9" d="M0 0H95V63.3H0z" />
            <path fill="#FFD500" d="M28.8 0H41.5V63.3H28.8z" />
            <path fill="#FFD500" d="M0 25.3H95V38H0z" />
        </symbol>
        <symbol id="icon-switzerland" viewBox="0 0 95 63.5">
            <path fill="#FF0005" d="M0 0H95V63.5H0z" />
            <path fill="#FFFFFF" d="M27.9 25.8H67V37.6H27.9z" />
            <path fill="#FFFFFF" d="M41.6 12.1H53.3V51.5H41.6z" />
        </symbol>
        <symbol id="icon-usa" viewBox="0 0 95 63.5">
            <path fill="#FFFFFF" d="M0 0H95V63.3H0z" />
            <path fill="#E60013" d="M0 0H95V4.9H0z" />
            <path fill="#E60013" d="M0 9.7H95V14.6H0z" />
            <path fill="#E60013" d="M0 19.5H95V24.4H0z" />
            <path fill="#E60013" d="M0 29.2H95V34.1H0z" />
            <path fill="#E60013" d="M0 39H95V43.9H0z" />
            <path fill="#E60013" d="M0 48.7H95V53.6H0z" />
            <path fill="#E60013" d="M0 58.5H95V63.4H0z" />
            <path fill="#0020BF" d="M0 0H48.1V34.1H0z" />
            <path fill="#FFFFFF" d="M4.1 1.4L3.7 2.8 2.3 2.8 3.4 3.6 3 4.9 4.1 4.1 5.3 4.9 4.8 3.6 6 2.8 4.6 2.8z" />
            <path fill="#FFFFFF" d="M12.1 1.4L11.7 2.8 10.2 2.8 11.4 3.6 10.9 4.9 12.1 4.1 13.2 4.9 12.8 3.6 13.9 2.8 12.5 2.8z" />
            <path fill="#FFFFFF" d="M20.1 1.4L19.6 2.8 18.2 2.8 19.4 3.6 18.9 4.9 20.1 4.1 21.2 4.9 20.8 3.6 21.9 2.8 20.5 2.8z" />
            <path fill="#FFFFFF" d="M28.1 1.4L27.6 2.8 26.2 2.8 27.4 3.6 26.9 4.9 28.1 4.1 29.2 4.9 28.8 3.6 29.9 2.8 28.5 2.8z" />
            <path fill="#FFFFFF" d="M36 1.4L35.6 2.8 34.2 2.8 35.3 3.6 34.9 4.9 36 4.1 37.2 4.9 36.8 3.6 37.9 2.8 36.5 2.8z" />
            <path fill="#FFFFFF" d="M43.3 3.6L42.9 4.9 44 4.1 45.2 4.9 44.7 3.6 45.9 2.8 44.5 2.8 44 1.4 43.6 2.8 42.2 2.8z" />
            <path fill="#FFFFFF" d="M8.1 4.8L7.7 6.2 6.2 6.2 7.4 7 7 8.4 8.1 7.5 9.2 8.4 8.8 7 10 6.2 8.6 6.2z" />
            <path fill="#FFFFFF" d="M16.1 4.8L15.6 6.2 14.2 6.2 15.4 7 14.9 8.4 16.1 7.5 17.2 8.4 16.8 7 17.9 6.2 16.5 6.2z" />
            <path fill="#FFFFFF" d="M24.1 4.8L23.6 6.2 22.2 6.2 23.4 7 22.9 8.4 24.1 7.5 25.2 8.4 24.8 7 25.9 6.2 24.5 6.2z" />
            <path fill="#FFFFFF" d="M32 4.8L31.6 6.2 30.2 6.2 31.3 7 30.9 8.4 32 7.5 33.2 8.4 32.8 7 33.9 6.2 32.5 6.2z" />
            <path fill="#FFFFFF" d="M40 4.8L39.6 6.2 38.2 6.2 39.3 7 38.9 8.4 40 7.5 41.2 8.4 40.7 7 41.9 6.2 40.5 6.2z" />
            <path fill="#FFFFFF" d="M4.1 8.3L3.7 9.6 2.3 9.6 3.4 10.4 3 11.8 4.1 11 5.3 11.8 4.8 10.4 6 9.6 4.6 9.6z" />
            <path fill="#FFFFFF" d="M12.1 8.3L11.7 9.6 10.2 9.6 11.4 10.4 10.9 11.8 12.1 11 13.2 11.8 12.8 10.4 13.9 9.6 12.5 9.6z" />
            <path fill="#FFFFFF" d="M20.1 8.3L19.6 9.6 18.2 9.6 19.4 10.4 18.9 11.8 20.1 11 21.2 11.8 20.8 10.4 21.9 9.6 20.5 9.6z" />
            <path fill="#FFFFFF" d="M28.1 8.3L27.6 9.6 26.2 9.6 27.4 10.4 26.9 11.8 28.1 11 29.2 11.8 28.8 10.4 29.9 9.6 28.5 9.6z" />
            <path fill="#FFFFFF" d="M36 8.3L35.6 9.6 34.2 9.6 35.3 10.4 34.9 11.8 36 11 37.2 11.8 36.8 10.4 37.9 9.6 36.5 9.6z" />
            <path fill="#FFFFFF" d="M44 8.3L43.6 9.6 42.2 9.6 43.3 10.4 42.9 11.8 44 11 45.2 11.8 44.7 10.4 45.9 9.6 44.5 9.6z" />
            <path fill="#FFFFFF" d="M8.1 11.7L7.7 13 6.2 13 7.4 13.9 7 15.2 8.1 14.4 9.2 15.2 8.8 13.9 10 13 8.6 13z" />
            <path fill="#FFFFFF" d="M16.1 11.7L15.6 13 14.2 13 15.4 13.9 14.9 15.2 16.1 14.4 17.2 15.2 16.8 13.9 17.9 13 16.5 13z" />
            <path fill="#FFFFFF" d="M24.1 11.7L23.6 13 22.2 13 23.4 13.9 22.9 15.2 24.1 14.4 25.2 15.2 24.8 13.9 25.9 13 24.5 13z" />
            <path fill="#FFFFFF" d="M32 11.7L31.6 13 30.2 13 31.3 13.9 30.9 15.2 32 14.4 33.2 15.2 32.8 13.9 33.9 13 32.5 13z" />
            <path fill="#FFFFFF" d="M40 11.7L39.6 13 38.2 13 39.3 13.9 38.9 15.2 40 14.4 41.2 15.2 40.7 13.9 41.9 13 40.5 13z" />
            <path fill="#FFFFFF" d="M4.1 15.1L3.7 16.5 2.3 16.5 3.4 17.3 3 18.6 4.1 17.8 5.3 18.6 4.8 17.3 6 16.5 4.6 16.5z" />
            <path fill="#FFFFFF" d="M12.1 15.1L11.7 16.5 10.2 16.5 11.4 17.3 10.9 18.6 12.1 17.8 13.2 18.6 12.8 17.3 13.9 16.5 12.5 16.5z" />
            <path fill="#FFFFFF" d="M20.1 15.1L19.6 16.5 18.2 16.5 19.4 17.3 18.9 18.6 20.1 17.8 21.2 18.6 20.8 17.3 21.9 16.5 20.5 16.5z" />
            <path fill="#FFFFFF" d="M28.1 15.1L27.6 16.5 26.2 16.5 27.4 17.3 26.9 18.6 28.1 17.8 29.2 18.6 28.8 17.3 29.9 16.5 28.5 16.5z" />
            <path fill="#FFFFFF" d="M36 15.1L35.6 16.5 34.2 16.5 35.3 17.3 34.9 18.6 36 17.8 37.2 18.6 36.8 17.3 37.9 16.5 36.5 16.5z" />
            <path fill="#FFFFFF" d="M44 15.1L43.6 16.5 42.2 16.5 43.3 17.3 42.9 18.6 44 17.8 45.2 18.6 44.7 17.3 45.9 16.5 44.5 16.5z" />
            <path d="M8.1 18.5l-.4 1.4H6.2l1.2.8L7 22l1.1-.8 1.2.8-.5-1.3 1.2-.8H8.6l-.5-1.4zm8 0l-.4 1.4h-1.4l1.1.8-.4 1.4 1.2-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.5-1.4zm8 0l-.4 1.4h-1.4l1.1.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.4-1.4zm7.9 0l-.4 1.4h-1.4l1.1.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.4-1.4zm8 0l-.4 1.4h-1.4l1.2.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.5-1.4z" fill="#FFFFFF" />
            <path fill="#FFFFFF" d="M4.1 21.9L3.7 23.3 2.3 23.3 3.4 24.1 3 25.5 4.1 24.6 5.3 25.5 4.8 24.1 6 23.3 4.6 23.3z" />
            <path d="M12.1 21.9l-.4 1.4h-1.4l1.1.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.5l-.3-1.4zm8 0l-.4 1.4h-1.4l1.1.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.4-1.4zm8 0l-.4 1.4h-1.4l1.1.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.4-1.4zm7.9 0l-.4 1.4h-1.4l1.2.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.5-1.4zm8 0l-.4 1.4h-1.4l1.2.8-.4 1.4 1.1-.8 1.1.8-.4-1.4 1.1-.8h-1.4l-.5-1.4z" fill="#FFFFFF" />
            <path fill="#FFFFFF" d="M8.6 26.7L8.1 25.4 7.7 26.7 6.2 26.7 7.4 27.5 7 28.9 8.1 28.1 9.2 28.9 8.8 27.5 10 26.7z" />
            <path fill="#FFFFFF" d="M16.5 26.7L16.1 25.4 15.6 26.7 14.2 26.7 15.4 27.5 14.9 28.9 16.1 28.1 17.2 28.9 16.8 27.5 17.9 26.7z" />
            <path fill="#FFFFFF" d="M24.5 26.7L24.1 25.4 23.6 26.7 22.2 26.7 23.4 27.5 22.9 28.9 24.1 28.1 25.2 28.9 24.8 27.5 25.9 26.7z" />
            <path fill="#FFFFFF" d="M32.5 26.7L32 25.4 31.6 26.7 30.2 26.7 31.3 27.5 30.9 28.9 32 28.1 33.2 28.9 32.8 27.5 33.9 26.7z" />
            <path fill="#FFFFFF" d="M40.5 26.7L40 25.4 39.6 26.7 38.2 26.7 39.3 27.5 38.9 28.9 40 28.1 41.2 28.9 40.7 27.5 41.9 26.7z" />
            <path fill="#FFFFFF" d="M4.6 30.1L4.1 28.8 3.7 30.1 2.3 30.1 3.4 31 3 32.3 4.1 31.5 5.3 32.3 4.8 31 6 30.1z" />
            <path fill="#FFFFFF" d="M12.5 30.1L12.1 28.8 11.7 30.1 10.2 30.1 11.4 31 10.9 32.3 12.1 31.5 13.2 32.3 12.8 31 13.9 30.1z" />
            <path fill="#FFFFFF" d="M20.5 30.1L20.1 28.8 19.6 30.1 18.2 30.1 19.4 31 18.9 32.3 20.1 31.5 21.2 32.3 20.8 31 21.9 30.1z" />
            <path fill="#FFFFFF" d="M28.5 30.1L28.1 28.8 27.6 30.1 26.2 30.1 27.4 31 26.9 32.3 28.1 31.5 29.2 32.3 28.8 31 29.9 30.1z" />
            <path fill="#FFFFFF" d="M36.5 30.1L36 28.8 35.6 30.1 34.2 30.1 35.3 31 34.9 32.3 36 31.5 37.2 32.3 36.8 31 37.9 30.1z" />
            <path fill="#FFFFFF" d="M44.5 30.1L44 28.8 43.6 30.1 42.2 30.1 43.3 31 42.9 32.3 44 31.5 45.2 32.3 44.7 31 45.9 30.1z" />
        </symbol>
    </svg>
    <?php
});

class Header_Menu_Nav_Walker extends Walker_Nav_Menu {
    public function start_lvl( &$output, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        
        $indent = str_repeat( $t, $depth );
 
        $classes = array();

        $class_names = implode( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

        if ( $depth == 0 ) {
            $output .= "{$n}{$indent}" . '<div class="nav-main-sublayer-1">' . "{$n}";
            $output .= "{$n}{$indent}" . '<button class="close-x"></button>' . "{$n}";
            $output .= "{$n}{$indent}" . '<div class="nav-main-sublayer-1-inner">' . "{$n}";
        }

        $output .= "{$n}{$indent}<ul$class_names>{$n}";
    }

    public function end_lvl( &$output, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }

        $indent  = str_repeat( $t, $depth );
        $output .= "$indent</ul>{$n}";
        
        if ( $depth == 0 ) {
            $output .= "$indent</div>{$n}";
            $output .= "$indent</div>{$n}";
        }
    }


    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

        $class_names = implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );

        if ( strpos( $class_names, 'current-menu-item' ) !== false ) {
            $output .= '<li class="selected">';
        } else {
            $output .= '<li>';
        }

        $atts = array();
        $atts['title'] = ! empty( $item->attr_title ) ? $item->attr_title : '';
        $atts['target'] = ! empty( $item->target ) ? $item->target : '';
        if ( '_blank' === $item->target && empty( $item->xfn ) ) {
            $atts['rel'] = 'noopener';
        } else {
            $atts['rel'] = $item->xfn;
        }
        $atts['href'] = ! empty( $item->url ) ? $item->url : '';
        $atts['aria-current'] = $item->current ? 'page' : '';

        $custom_classes = array_filter( get_post_meta( $item->ID, '_menu_item_classes', true ) );

        $custom_classes = empty( $custom_classes ) ? array() : (array) $custom_classes;

        if ( $depth == 0 ) {
            $custom_classes[] = 'main-menu-item';
        }

        $atts['class'] = trim( implode( ' ', $custom_classes ) );

        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );
 
        $attributes = '';
        foreach ( $atts as $attr => $value ) {
            if ( is_scalar( $value ) && '' !== $value && false !== $value ) {
                $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
 
        $title = apply_filters( 'the_title', $item->title, $item->ID );

        $title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );
 
        $item_output  = $args->before;
        $item_output .= '<a' . $attributes . '>';
        $item_output .= $args->link_before . '<span>' . $title . '</span>' . $args->link_after;
        
        if ( $depth == 0 ) {
            $item_output .= '<svg><use xlink:href="#icon-arrow"/></svg>';
        }

        $item_output .= '</a>';
        $item_output .= $args->after;
        
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }

    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        
        $output .= "</li>{$n}";
    }
}

class Footer_Menu_Nav_Walker extends Walker_Nav_Menu {
    public function start_lvl( &$output, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        
        $indent = str_repeat( $t, $depth );
 
        $classes = array();

        $class_names = implode( ' ', apply_filters( 'nav_menu_submenu_css_class', $classes, $args, $depth ) );
        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

        $output .= "{$n}{$indent}<ul$class_names>{$n}";
    }

    public function end_lvl( &$output, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }

        $indent  = str_repeat( $t, $depth );
        $output .= "$indent</ul>{$n}";
    }


    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

        $class_names = implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );

        if ( strpos( $class_names, 'current-menu-item' ) !== false ) {
            $output .= '<li class="selected">';
        } else {
            $output .= '<li>';
        }

        $atts = array();
        $atts['title'] = ! empty( $item->attr_title ) ? $item->attr_title : '';
        $atts['target'] = ! empty( $item->target ) ? $item->target : '';
        if ( '_blank' === $item->target && empty( $item->xfn ) ) {
            $atts['rel'] = 'noopener';
        } else {
            $atts['rel'] = $item->xfn;
        }
        $atts['href'] = ! empty( $item->url ) ? $item->url : '';
        $atts['aria-current'] = $item->current ? 'page' : '';

        $custom_classes = array_filter( get_post_meta( $item->ID, '_menu_item_classes', true ) );

        $custom_classes = empty( $custom_classes ) ? array() : (array) $custom_classes;

        $atts['class'] = trim( implode( ' ', $custom_classes ) );

        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );
 
        $attributes = '';
        foreach ( $atts as $attr => $value ) {
            if ( is_scalar( $value ) && '' !== $value && false !== $value ) {
                $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
 
        $title = apply_filters( 'the_title', $item->title, $item->ID );

        $title = apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth );
 
        $item_output  = $args->before;
        $item_output .= '<a' . $attributes . '>';
        $item_output .= $args->link_before . '<span>' . $title . '</span>' . $args->link_after;
        
        if ( $depth == 0 && $args->walker->has_children ) {
            $item_output .= '<svg><use xlink:href="#icon-arrow"/></svg>';
        }

        $item_output .= '</a>';
        $item_output .= $args->after;
        
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }

    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        
        $output .= "</li>{$n}";
    }
}