<?php if ( get_row_layout() == 'global_adventure_categories_block' ) : ?>

	<?php if ( have_rows( 'global_adventure_categories' ) ) : ?>
		<?php while ( have_rows( 'global_adventure_categories' ) ) : the_row(); ?>
			<section class="section-categories<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
			    <?php the_sub_field( 'global_adventure_category_block_headline' ); ?>
			    <ul class="list-categories">

				<?php if ( have_rows( 'global_adventure_category_block_item' ) ) : ?>
					<?php while ( have_rows( 'global_adventure_category_block_item' ) ) : the_row(); ?>
						<?php $global_category_block_image = get_sub_field( 'global_category_block_image' ); ?>
						<?php $global_category_block_url = get_sub_field( 'global_category_block_url' ); ?>

				        <li>
				            <a href="<?php echo esc_url( $global_category_block_url['url'] ); ?>" target="<?php echo esc_attr( $global_category_block_url['target'] ); ?>">
				                <span class="list-categories-image">
									<?php if ( $global_category_block_image ) : ?>

									<?php
										$section_img = $global_category_block_image;

										// print <img> with srcset
										get_template_part( 
										    'parts/_element-img_src_srcset', 
										    null,
											array( 
											    'img_object' => $section_img,
											    'img_custom_class' => '',
											    'img_size' => 'large',
											    'img_lazy_load' => '',
											    'img_size_attr' => '',
											)
										);
									?>
									<?php endif; ?>
				                </span>
				                <span class="list-categories-title"><?php the_sub_field( 'global_category_block_title' ); ?></span>
				            </a>
				        </li>

					<?php endwhile; ?>
				<?php else : ?>
					<?php // no rows found ?>
				<?php endif; ?>

			    </ul>
			</section>
		<?php endwhile; ?>
	<?php endif; ?>
<?php endif; ?>