<?php if ( get_row_layout() == 'global_faq' ) : ?>
	<?php
		// section rules
		get_template_part('parts/_code_loop_section_rules');
	?>

	<section class="section-faq<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
	    <?php the_sub_field( 'global_faq_text' ); ?>
	    <div class="schema-faq-code" itemscope="" itemtype="https://schema.org/FAQPage">
			<?php if ( have_rows( 'global_faq_item' ) ) : ?>
				<?php while ( have_rows( 'global_faq_item' ) ) : the_row(); ?>
					<?php
						$faq_content = get_sub_field( 'global_faq_item_content' );

						// rewrite WYSIWYG <p> tags to <span>
						$faq_replace = preg_replace('/<p>(.*?)<\/p>/i', '<span>$1</span>', $faq_content);
						//$strip_faq_content = strip_tags($faq_content, ['&nbsp;', '<br>','<br />','<br/>','br']);
					?>
		            <div itemscope="" itemprop="mainEntity" itemtype="https://schema.org/Question" class="faq-question <?php echo (get_row_index() == 1 ? 'active' : ''); ?>">
		                <h3 itemprop="name" class="faq-q"><a class="faq-trigger" href="javascript:void(0)"><?php the_sub_field( 'global_faq_item_headline' ); ?></a></h3>
		                <div itemscope="" itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
		                    <p itemprop="text" class="faq-a"><?php echo $faq_replace; ?></p>
		                </div>
		            </div>
				<?php endwhile; ?>
			<?php endif; ?>
	    </div>
	</section>

<?php endif; ?>