<?php if ( get_row_layout() == 'milo_stories' ) : ?>
	<?php
		// section rules
		//get_template_part('parts/_code_loop_section_rules');

		global $label_explore;
		global $label_stories;
	?>
	<?php $stories_show_by = get_sub_field( 'stories_show_by' ); ?>
	<?php $stories_select_category = get_sub_field( 'stories_select_category' ); ?>

	<?php if($stories_show_by == "category") : ?>
		<?php $items_limit = get_sub_field( 'stories_item_limit' ); ?>
		<?php if ( $stories_select_category ) : ?>

			<?php
				$args = array(
				'numberposts' => $items_limit,
				'posts_per_page' => $items_limit,
				'post_type' => 'post',
	            'orderby' => 'date',
	            'order'   => 'DESC',
				'tax_query' => array(
				    array(
				    'taxonomy' => 'category',
				    'field' => 'term_id',
				    'terms' => $stories_select_category
				     )
				  )
				);

				$the_query = new WP_Query( $args );
				$item_count = $the_query->found_posts; //query count
				$slide_arrow_toggle = ($item_count > 3 ? " slide-button-show" : "");

				//var_dump($the_query);
			?>

<section class="section-articles">
    <div class="container">
    	<h2 class="section-title"><?php echo $label_stories; ?></h2>
    	<ul class="list-articles slider-container-item<?php echo $slide_arrow_toggle; ?>" data-total-slides="<?php echo $item_count; ?>">

			<?php if( $the_query->have_posts() ) : ?>
				<?php while( $the_query->have_posts() ) : $the_query->the_post();
					$id = get_the_ID();
					$get_title = get_the_title();
					$get_permalink = get_permalink();
					//$get_featured_img = the_post_thumbnail();

					//echo $id;
					//echo $get_title;
					//echo $get_permalink;
					//echo $get_featured_img;

				?>

		            <li class="list-article">
		                <div class="list-article-image">
		                    <?php echo the_post_thumbnail(); ?>
		                </div>
		                <h3 class="list-article-title text-shade">
		                	<a href="story.html" tabindex="-1"><?php echo $get_title; ?></a>
		                </h3>
		                <a href="<?php echo $get_permalink; ?>" class="button button--hyperion ">
		                    <span>
		                        <span><?php echo $label_explore; ?></span>
		                    </span>
		                </a>
		            </li>

				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
			<?php endif; ?>
		<?php endif; ?>

	<?php else : // single selection ?>

		<?php $stories_select_by_single_selection = get_sub_field( 'stories:select_by_single_selection' ); ?>
		<?php if ( $stories_select_by_single_selection ) :
			$item_count = count($stories_select_by_single_selection);
			$slide_arrow_toggle = ($item_count > 3 ? " slide-button-show" : "");
		?>

<section class="section-articles">
    <div class="container">
    	<h2 class="section-title">Milo stories</h2>
    	<ul class="list-articles slider-container-item<?php echo $slide_arrow_toggle; ?>" data-total-slides="<?php echo $item_count; ?>">

			<?php foreach ( $stories_select_by_single_selection as $post ) : ?>
				<?php setup_postdata ( $post ); ?>
				<?php
					$id = get_the_ID();
					$get_title = get_the_title();
					$get_permalink = get_permalink();
					//$get_featured_img = the_post_thumbnail();

					//echo $id;
					//echo $get_title;
					//echo $get_permalink;
					//echo $get_featured_img;
				?>

	            <li class="list-article">
	                <div class="list-article-image">
	                    <?php echo the_post_thumbnail(); ?>
	                </div>
	                <h3 class="list-article-title text-shade">
	                	<a href="story.html" tabindex="-1"><?php echo $get_title; ?></a>
	                </h3>
	                <a href="<?php echo $get_permalink; ?>" class="button button--hyperion ">
	                    <span>
	                        <span>Explore</span>
	                    </span>
	                </a>
	            </li>

			<?php endforeach; ?>
			<?php wp_reset_postdata(); ?>
		<?php endif; ?>

	<?php endif; // end single selection ?>
		</ul>
    </div>
</section>
<?php endif; ?>