<?php if ( get_row_layout() == 'steps' ) : ?>
<?php
	// section rules
	get_template_part('parts/_code_loop_section_rules');
?>

	
		<section class="section-rows<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
			<div class="container-smaller">
				<?php the_sub_field( 'step_text' ); ?>
			</div>
	<?php if ( have_rows( 'step_items' ) ) : ?>
		   <div class="info-rows">
			<?php while ( have_rows( 'step_items' ) ) : the_row(); ?>
			<?php
				$step_item_icon = get_sub_field( 'step_item_icon' );
				$step_item_content = get_sub_field( 'step_item_content' );
				$step_item_image_or_video = get_sub_field( 'step_item_image_video' );
				$step_item_image = get_sub_field( 'step_item_image' );
				$step_item_video = get_sub_field( 'step_item_video' );
			?>
		        <div class="info-row info-content-step">
		            <div class="container-smaller">
		            	
		                <div class="info-row-text rellax" data-rellax-speed="0.5" data-rellax-mobile-speed="0.5">
		                	<?php if ( $step_item_icon ) : ?>
								<img src="<?php echo esc_url( $step_item_icon['url'] ); ?>" class="step-icon" alt="<?php echo esc_attr( $step_item_icon['alt'] ); ?>" />
							<?php endif; ?>

							<?php echo $step_item_content; ?>
		                </div>
		                <div class="info-row-video">
		                    <div class="video-placeholder">
		                        <div class="section-background video-wrapper169">
		                        	<?php if($step_item_image_or_video == "Image" && $step_item_image) : ?>
										<?php
											$section_img = $step_item_image;

											// print <img> with srcset
											get_template_part( 
											    'parts/_element-img_src_srcset', 
											    null,
												array( 
												    'img_object' => $section_img,
												    'img_custom_class' => '',
												    'img_size' => 'large',
												    'img_lazy_load' => '',
												    'img_size_attr' => '',
												)
											);
										?>
		                        	<?php endif; ?>
		                        	<?php if($step_item_image_or_video == "Video" && $step_item_video) : ?>
			                            <video class="video-item lazy" data-src="<?php echo esc_url( $step_item_video['url'] ); ?>" preload="metadata" autoplay="true" loop="true" muted="true" playsinline>
			                                <source data-src="<?php echo esc_url( $step_item_video['url'] ); ?>" type="video/mp4">
			                            </video>
		                        	<?php endif; ?>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
			<?php endwhile; ?>
			<?php get_template_part('parts/_code_loop_buttons_display_dom'); ?>
		    </div>
		</section>
	<?php endif; ?>
<?php endif; ?>