var themeRotation = null;
var currentProgress;

(function($) {
  "use strict";

	themeRotation = {
		bindEvent: function(element, eventName, eventHandler) {
		  if (element.addEventListener){
		      element.addEventListener(eventName, eventHandler, false);
		  } else if (element.attachEvent) {
		      element.attachEvent('on' + eventName, eventHandler);
		  }
		},
		rotateToggle: function(progress) {
			console.log(progress); // returns  the percentage of completed scroll
			currentProgress = progress;

			if(window.objModel)
				//window.objModel.rotation.y =  currentProgress * 360 * Math.PI / 180.0;
				window.objModel.rotation.y = 0;


			//Possible methods - you can name it differently ofcourse
			// trigger: "full-rotation", "single-animation" // from current rotation angle
			// trigger: "$deg", "single-animation", "plus" // from current rotation angle
			// trigger: "$deg", "single-animation", "minus" // from current rotation angle
			// trigger: "$deg", "frame-by-frame", "plus" // from current rotation angle
			// trigger: "$deg", "frame-by-frame", "minus" // from current rotation angle
			// trigger: "to-start", "single-animation", "plus" // from current rotation angle
			// trigger: "to-start", "single-animation", "minus" // from current rotation angle

			//// in generel rotation plus and minus should be accepted.
			//// being able to rotate Z/Y would be really cool - but X rotation is first priority and perhaps good start
		},
		rotateHandler: function(method) {
			console.log(method); // method from click on debug buttons
		},
		onReady: function() {
			//console.log("onReady");

			gsap.registerPlugin(ScrollTrigger);

			//round 2
			//const text = document.querySelectorAll('.section-title')

			//const tl = gsap.timeline().to('..rotation-text-container', {width: 150, height: 150}).fromTo(text, {x: -100}, {x: 0, stagger: 0.3})

			ScrollTrigger.create({
				trigger: '.section-single-product',
				//animation: tl,
				pin: true,
				start: 'center center',
				end: '+=2500 bottom',
				scrub: 1, // I like the 1 sec delay, set to true for exact anime on scroll
				markers: true,
				onEnterBack: function() {
					console.log("onEnterBack");
					//theme.disableMouseWheel(true);
				},
				onEnter: function() {
					console.log("onEnter");
					//theme.disableMouseWheel(true);
				},
				onLeaveBack: function() {
					console.log("onLeaveBack");
					//theme.disableMouseWheel(false);
				},
				onLeave: function() {
					console.log("onLeave");
					//theme.disableMouseWheel(false);
				},
				onUpdate: trigger => themeRotation.rotateToggle(trigger.progress)
			})

			// for debugging
			var debugItems = document.querySelectorAll('.debug-item');

			for(let i = 0; i < debugItems.length; i++) {
				debugItems[i].addEventListener('click', (event) => {
					event.preventDefault();
					var that = event.target;
					var thatDataRotateAttr = that.getAttribute('data-rotate');

					themeRotation.rotateHandler(thatDataRotateAttr);
				});
			}

			const theViewer = new Viewer('threejsContainer1');
		},
		onLoad: function() {
		    //console.log("onLoad");
		},
		onResize: function() {
		    //console.log("onResize");
		}
	};

	document.addEventListener('DOMContentLoaded', themeRotation.onReady);
	window.addEventListener('load', themeRotation.onLoad);
	window.addEventListener("resize", themeRotation.onResize);
})();
