var themeRotation = null;
var currentProgress;

(function($) {
  "use strict";

	themeRotation = {
		bindEvent: function(element, eventName, eventHandler) {
		  if (element.addEventListener){
		      element.addEventListener(eventName, eventHandler, false);
		  } else if (element.attachEvent) {
		      element.attachEvent('on' + eventName, eventHandler);
		  }
		},
		rotateToggle: function(progress) {
			//console.log(progress); // returns  the percentage of completed scroll
			//currentProgress = progress;

			//Possible methods
			// trigger: "full-rotation", "single-animation" // from current rotation angle
			// trigger: "$deg", "single-animation", "plus" // from current rotation angle
			// trigger: "$deg", "single-animation", "minus" // from current rotation angle
			// trigger: "$deg", "frame-by-frame", "plus" // from current rotation angle
			// trigger: "$deg", "frame-by-frame", "minus" // from current rotation angle
			// trigger: "to-start", "single-animation", "plus" // from current rotation angle
			// trigger: "to-start", "single-animation", "minus" // from current rotation angle

			//// in generel rotation plus and minus should be accepted.
			//// being able to rotate Z/Y would be really cool - but X rotation is first priority and perhaps good start
		},
		rotateHandler: function(method) {
			console.log(method); // method from click on debug buttons
		},
		onReady: function() {
			//console.log("onReady");

			if(document.getElementsByClassName('canvas-wrapper').length > 0) {
				gsap.registerPlugin(ScrollTrigger);

				//console.clear();

				// setup timeline for text
				var rotationCopyContainer = document.querySelector('.rotation-copy');
				var targetsCopy = document.querySelectorAll(".rotation-copy .rotation-svg-item");

				const tlTextCopy = gsap.timeline(

				{
				  scrollTrigger: {
				    trigger: '.section-single-product',
				    start: 'center 20%',
				    end: '+=2500 bottom',
				    //pin: true,
				    scrub: 0.5,
					onEnterBack: function() {
						//document.querySelector('.section-single-product').classList.remove('scroll-done');
					},
					onEnter: function() {

					},
					onLeaveBack: function() {

					},
					onLeave: function() {
						//document.querySelector('.section-single-product').classList.add('scroll-done');
						//tlText.seek(0);
					}
				  }
				})
				.fromTo(targetsCopy,
				{
					autoAlpha: 1,
					y: 0,
				},
				{
					duration: 4,
					y: 20,
					autoAlpha: 0,
					stagger: 5,
					ease: "back.out(2)"
				})
				.to({}, {duration: 5})


var rotationMainContainer = document.querySelector('.rotation-main');
var targets = document.querySelectorAll(".rotation-main .rotation-svg-item");

/*
				var rotationMainContainer = document.querySelector('.rotation-main');
				var rotationCopyContainer = document.querySelector('.rotation-copy');

				// setup timeline for text
				var targets = document.querySelectorAll(".rotation-main .rotation-svg-item");
				var targetsCopy = document.querySelectorAll(".rotation-copy .rotation-svg-item");


const anim = gsap.timeline({ });

anim.from(targets, {
	duration: 4,
	y: 20,
	autoAlpha: 0,
	stagger: 10,
	ease: "back.out(2)"
});

const animCopy = gsap.timeline({ });
animCopy.from(targetsCopy, {
	duration: 4,
	y: 20,
	autoAlpha: 0,
	stagger: 10,
	ease: "back.out(2)"
});


ScrollTrigger.create({
  trigger: '.section-single-product',
  animation: anim,
  start: 'center center',
  end: '+=5500 bottom',
  scrub: 0.5,
  onEnter: function() {
		anim.play();
		document.querySelector('.section-single-product').classList.remove('scroll-done');
  },
  onEnterBack: function() {
  	anim.play();
  	document.querySelector('.section-single-product').classList.remove('scroll-done');
  },
	onLeaveBack: function() {
		if(rotationCopyContainer.classList.contains('active')) {
			document.querySelector('.section-single-product').classList.add('scroll-done');
			setTimeout(function(){
				rotationMainContainer.classList.add('active');
				rotationCopyContainer.classList.remove('active');
			}, 550);
		}
	},
	onLeave: function() {
		document.querySelector('.section-single-product').classList.add('scroll-done');
		rotationMainContainer.classList.remove('active');
		rotationCopyContainer.classList.add('active');
		//tlText.seek(0);
	}
});

ScrollTrigger.create({
  trigger: '.section-single-product',
  animation: animCopy,
  start: "center center",
  end: '+=5500 bottom',
  scrub: 0.5,
  onLeave: () => animCopy.pause(0),
  onLeaveBack: () => animCopy.pause(0)
});

*/

				const tlText = gsap.timeline({
				  scrollTrigger: {
				    trigger: '.section-single-product',
				    start: 'center 20%',
				    end: '+=2500 bottom',
				    //pin: true,
				    scrub: 0.5,
				    //toggleActions: "play none none none", //onEnter, onLeave, onEnterBack, and onLeaveBack
					onEnterBack: function() {
						//document.querySelector('.section-single-product').classList.remove('scroll-done');
					},
					onEnter: function() {
						//document.querySelector('.section-single-product').classList.remove('scroll-done');
					},
					onLeaveBack: function() {
						if(rotationMainContainer.classList.contains('active')) {
							//document.querySelector('.section-single-product').classList.add('scroll-done');
							setTimeout(function(){
								//rotationMainContainer.classList.add('active');
								//rotationCopyContainer.classList.remove('active');
							}, 550);
						}
					},
					onLeave: function() {
						//document.querySelector('.section-single-product').classList.add('scroll-done');
						//rotationMainContainer.classList.remove('active');
						//rotationCopyContainer.classList.add('active');
						//tlText.seek(0);

						//trigger.disable(false);
					}
				  }
				})
				.from(targets,
				{
					duration: 4,
					y: 20,
					autoAlpha: 0,
					stagger: 10,
					ease: "back.out(2)"
				})
				.to({}, {duration: 5})

				// setup canvas image timeline
				const canvas = document.getElementById("hero-lightpass");
				const context = canvas.getContext("2d");
				let imgPath;
				/*
				if ( ["localhost", "127.0.0.1", ""].includes(window.location.hostname) ) {
					//imgPath = "https://milo.sgsmedia.dk/frontend/assets/img/scrolltrigger_anim/image";
					//imgPath = sgsBaseVar.themeurl+"/assets/img/scrolltrigger_anim/image";
				} else {
					imgPath = sgsBaseVar.themeurl+"/assets/img/scrolltrigger_anim/image";
				}
				*/
				if (typeof sgsBaseVar !== 'undefined') {
				    // the variable is defined
				    imgPath = sgsBaseVar.themeurl+"/assets/img/scrolltrigger_anim/image";
				} else {
					imgPath = "https://milo.sgsmedia.dk/frontend/assets/img/scrolltrigger_anim/image";
				}

				canvas.width = 711;
				canvas.height = 400;

				const frameCount = 141;
				const currentFrame = index => (
				  //`../assets/img/scrolltrigger_anim/image${(index + 1).toString().padStart(3, '0')}.jpg`
				  imgPath+`${(index + 1).toString().padStart(3, '0')}.jpg`
				);

				const images = []
				const airpods = {
				  frame: 0
				};

				for (let i = 0; i < frameCount; i++) {
				  const img = new Image();
				  img.src = currentFrame(i);
				  images.push(img);
				}

				var tlRotate = gsap.timeline({});

				tlRotate.to(airpods, {
				  frame: frameCount - 1,
				  snap: "frame",
				  onUpdate: render // use animation onUpdate instead of scrollTrigger's onUpdate
				});

				// setup image scrolltrigger
				const rotationProduct = ScrollTrigger.create({
					trigger: '.section-single-product',
					animation: tlRotate,
					pin: true,
					start: 'center center',
					end: '+=2700 bottom',
					scrub: 1, // I like the 1 sec delay, set to true for exact anime on scroll
					//markers: true,
					onEnterBack: function() {
						console.log("onEnterBack");
						//theme.disableMouseWheel(true);

						document.querySelector('body').classList.add('pinned-content');
						document.querySelector('.section-single-product').classList.remove('scroll-done');
					},
					onEnter: function() {
						console.log("onEnter");
						//theme.disableMouseWheel(true);
						document.querySelector('body').classList.add('pinned-content');
						document.querySelector('.section-single-product').classList.remove('scroll-done');
					},
					onLeaveBack: function() {
						console.log("onLeaveBack");
						//theme.disableMouseWheel(false);
						document.querySelector('body').classList.remove('pinned-content');

						if(rotationCopyContainer.classList.contains('active')) {
							document.querySelector('.section-single-product').classList.add('scroll-done');
							setTimeout(function(){
								rotationMainContainer.classList.add('active');
								rotationCopyContainer.classList.remove('active');
							}, 250);
						}

					},
					onLeave: function() {
						console.log("onLeave");
						//theme.disableMouseWheel(false);

						document.querySelector('body').classList.remove('pinned-content');

						//rotationCopyContainer.classList.add('active');
						//rotationMainContainer.classList.remove('active');

						document.querySelector('.section-single-product').classList.add('scroll-done');
						rotationMainContainer.classList.remove('active');
						rotationCopyContainer.classList.add('active');

						//trigger.disable(false);
						//ScrollTrigger.getAll().forEach(ST => ST.disable(false));

						setTimeout(function() {
							var scrollDiv = document.querySelector(".section-single-product").offsetTop;
							//window.scrollTo({ top: scrollDiv, behavior: 'smooth'});
						}, 100)


/*
						document.querySelector('.section-app').scrollIntoView({
							behavior: 'smooth', // Defines the transition animation. default: auto
							block: 'start', // Defines vertical alignment. default: start
							inline: 'start' // Defines horizontal alignment. default: nearest
						});
*/
					}
					//onUpdate: trigger => console.log(trigger.progress)
				})

				// toggle images
				images[0].onload = render;

				function render() {
				  context.clearRect(0, 0, canvas.width, canvas.height);
				  context.drawImage(images[airpods.frame], 0, 0); 
				}

			}
		},
		onLoad: function() {
		    //console.log("onLoad");
		},
		onResize: function() {
		    //console.log("onResize");
		}
	};

	document.addEventListener('DOMContentLoaded', themeRotation.onReady);
	window.addEventListener('load', themeRotation.onLoad);
	window.addEventListener("resize", themeRotation.onResize);
})();
