var theme = null;
var hasLinePresentation;
var currentActiveVideo;
var currentActiveType;
var isMenuActive = false;
var headroomInstance;

var screenWidth;
var screenHeight;

var isCurrentBreakpoint;
var isTabletAbove = false;
var isTabletBelow = false;
var isTabletBreakpoint = 835;
var triggerOnInit = false;

// flickity instances
var productOptionSlider;
var reviewsSlider;
var articlesSlider;
var accessoriesSlider;
var articlesSliderPlus;

// social
var facebookShareLoaded;

/**
 * Store the scroll top position as applying overflow:hidden to the body makes it jump to 0
 * @type int
 */
var scrollPos;

(function($) {
  "use strict";

	theme = {
		bindEvent: function(element, eventName, eventHandler) {
		  if (element.addEventListener){
		      element.addEventListener(eventName, eventHandler, false);
		  } else if (element.attachEvent) {
		      element.attachEvent('on' + eventName, eventHandler);
		  }
		},
		getParam: function (name, url) {
		  if (!url) url = window.location.href;
		  if (name) {
		    url = url.toLowerCase(); // This is just to avoid case sensitiveness
		    name = name.replace(/[\[\]]/g, "\\$&").toLowerCase(); // This is just to avoid case sensitiveness for query parameter name
		    var regex = new RegExp("[#\&]" + name + "(=([^&#]*)|&|#|$)"),
		      results = regex.exec(url);
		    if (!results) return null;
		    if (!results[2]) return '';
		    return decodeURIComponent(results[2].replace(/\+/g, " "));
		  } else {
		    return url.split('#').pop();
		  }
		},
		refreshScrollPosition: function() {
			scrollPos = window.scrollY || window.scrollTop || document.getElementsByTagName("html")[0].scrollTop;
		},
		validateEmail: function(email) {
		  var emailReg = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		  return emailReg.test(email);
		},
		getScreenWidth: function() {
			screenWidth = window.innerWidth
				|| document.documentElement.clientWidth
				|| document.body.clientWidth;

			return screenWidth;
		},
		getScreenHeight: function() {
			screenHeight = window.innerHeight
				|| document.documentElement.clientHeight
				|| document.body.clientHeight;

			return screenWidth;
		},
		getBreakpoint: function() {
			if(theme.getScreenWidth() > isTabletBreakpoint) {
				isCurrentBreakpoint = "desktop";
			} else {
				isCurrentBreakpoint = "mobile";
			}

			return isCurrentBreakpoint;
		},
		getIsTablet: function() {
			if(theme.getScreenWidth() > isTabletBreakpoint) {
				isTabletAbove = true;
				isTabletBelow = false;
			} else {
				isTabletAbove = false;
				isTabletBelow = true;
			}

			return isTabletBelow;
		},
		createTextLineHover: function(i, element) {
			var getLineMask = element.querySelector('.line-mask');
			var getLineText = element.querySelector('.text-reveal-item');
			var getInnerContainer = element.querySelector('.line-container-reveal-inner');

			var tl_frame = gsap.timeline({paused: true});
			tl_frame.from(getLineMask, {
				duration: 0.3,
				width: "0%",
				autoAlpha: 0,
				ease: "power2.inOut"
			});
			tl_frame.from(getLineText, {
				duration: 0.3,
				top: 20,
				autoAlpha: 0,
				ease: "back.inOut(1.7)"
			}, "-=0.1");
			tl_frame.from(getInnerContainer, {
				duration: 0.2,
				y: "+=30%",
				x: "+=10%",
				ease: "power2.inOut"
			}, "-=0.3");

			hasLinePresentation[i].addEventListener('mouseenter', (event) => {
				tl_frame.play();
			});
			
			hasLinePresentation[i].addEventListener('mouseleave', (event) => {
				tl_frame.reverse();
			});
		},
		playVideo: function(targetTrigger, openState) {
			var toggleVideoVisibility = openState;

			if(toggleVideoVisibility == true || toggleVideoVisibility == false) {
				if(!toggleVideoVisibility && currentActiveType == "overlay") {
					currentActiveVideo.innerHTML = "";
				}
			} else {
				var videoModal;
				var videoDOM;
				var videoTargetContainer;
				var videoTrigger = targetTrigger;
				var videoPath = videoTrigger.getAttribute('data-video');
				var videoType = videoTrigger.getAttribute('data-video-type');

				if(videoPath != '' && videoPath != null) {
					if(videoType != '' && videoType != null) {
						if(videoType == 'inline') {
							videoTargetContainer = videoTrigger.previousElementSibling;

							videoDOM = '<div class="section-background video-wrapper169">' +
											'<iframe class="video-frame" src="'  + videoPath + '?autoplay=1" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture; fullscreen" allowTransparency="true" allowfullscreen="" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>' +
										'</div>';
						}
						if(videoType == 'overlay') {
							videoTargetContainer = document.querySelector('.video-modal-wrapper');
							videoModal = document.querySelector('.video-modal');
							videoModal.classList.add('active');

							videoDOM = '<div class="preloader"><div class="la-ball-fall la-2x"><div></div><div></div><div></div></div></div>' +
										'<iframe class="video-frame" src="'  + videoPath + '?autoplay=1" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture; fullscreen" allowTransparency="true" allowfullscreen="" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
							// var videoDOM = '<iframe class="video-frame" src="'  + videoPath + '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowTransparency="true" allowfullscreen=""></iframe>';
							//videoDOM = '<div class="preloader"><div class="la-ball-fall la-2x"><div></div><div></div><div></div></div></div><iframe class="video-frame" src="'  + videoPath + '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture; fullscreen" allowTransparency="true" allowfullscreen="" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
						}
					}

					// append video
					videoTargetContainer.insertAdjacentHTML(
						'beforeend', videoDOM
					);
					//videoTargetContainer.appendChild = videoDOM;

					// reference active video container globally
					currentActiveVideo = videoTargetContainer;
					currentActiveType = videoType;
				}
			}
		},
		buildStickyMenu: function() {
			var menuCopy = document.querySelector('header').cloneNode(true);
			menuCopy.classList.add('header-sticky');

			setTimeout(function() {
				//document.querySelector('body').appendChild(menuCopy);
			}, 250);

			document.querySelector('body').appendChild(menuCopy);
			

			return true;
		},
		disableMouseWheel: function(state) {
			// call this to Disable
			function disableScroll() {
				headroomInstance.freeze();
			}

			// call this to Enable
			function enableScroll() {
				headroomInstance.unfreeze();
			}

			if(state == true && !isMenuActive) {
				isMenuActive = true;
				disableScroll();
			}
			if(state == false && isMenuActive) {
				isMenuActive = false;
				enableScroll();
			}
		},
		refreshSliders: function(breakpoint) {
			if(triggerOnInit) {
				console.log("LETS RESIZE IT ALL");
/*
				var sliderObjects = [
					articlesSlider,
					productOptionSlider,
					reviewsSlider,
					accessoriesSlider
				];

				if(sliderObjects.length > 0) {
					for(let i = 0; i < sliderObjects.length; i++) {
						if(sliderObjects[i] != undefined || sliderObjects[i] != "undefined") {
							console.log(i);
							sliderObjects[i].flkty.resize();
						}
					}
				}
*/
//reviewsSlider.resize();

			}

			/**
			 * Slider
			 */
			if(document.getElementsByClassName("section-reviews-slider").length > 0) {
				reviewsSlider = new Flickity( '.section-reviews-slider', {
					cellAlign: 'left',
					contain: true,
					pageDots: false,
					autoPlay: 3000,
					arrowShape: 'M0,50l66.9,48.9l2.4-3.1L7,50L69.4,4.2l-2.1-2.8L0,50z',
					imagesLoaded: true,
					lazyLoad: true,
					wrapAround: true
					// M0,50l66.9,48.9l2.4-3.1L7,50L69.4,4.2l-2.1-2.8L0,50z
				});
			}

			if (breakpoint == "desktop") {
				if(!triggerOnInit) {
					triggerOnInit = true;

					if(document.getElementsByClassName("list-articles").length > 0) {
/*
						var sliders = document.querySelectorAll('.list-articles');

						if(sliders.length > 0) {
							for(let i = 0; i<sliders.length; i++) {
								var innerSlideItems = sliders[i].querySelectorAll('.list-article');
								var innerSlideItemLength = innerSlideItems.length;

								if(innerSlideItemLength >= 4) {
									sliders[i].classList.add('slide-buttons-show');
								}
							}
						}
*/
						
						articlesSlider = new Flickity( '.list-articles', {
							cellAlign: 'left',
							contain: true,
							pageDots: false,
							//initialIndex: 1,
							prevNextButtons: true,
							draggable: '>3',
							arrowShape: 'M0,50l66.9,48.9l2.4-3.1L7,50L69.4,4.2l-2.1-2.8L0,50z',
							wrapAround: true,
							imagesLoaded: true,
							lazyLoad: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});

					}

					if(document.getElementsByClassName("articles-plus").length > 0) {
						articlesSliderPlus = new Flickity( '.articles-plus', {
							cellAlign: 'right',
							contain: true,
							pageDots: true,
							//initialIndex: 1,
							prevNextButtons: true,
							draggable: '>3',
							arrowShape: 'M0,50l66.9,48.9l2.4-3.1L7,50L69.4,4.2l-2.1-2.8L0,50z',
							wrapAround: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});
					}

					if(document.getElementsByClassName("list-product-options").length > 0) {
						articlesSlider = new Flickity( '.list-product-options', {
							cellAlign: 'left',
							contain: true,
							pageDots: false,
							//initialIndex: 1,
							prevNextButtons: true,
							draggable: '>3',
							arrowShape: 'M0,50l66.9,48.9l2.4-3.1L7,50L69.4,4.2l-2.1-2.8L0,50z',
							wrapAround: false,
							imagesLoaded: true,
							lazyLoad: true
						});
					}
				}
			}

			// Mobile Sliders
			if (breakpoint == "mobile") {
				if(!triggerOnInit) {
					triggerOnInit = true;

					if(document.getElementsByClassName("list-articles").length > 0) {
						console.log("init here");
						articlesSlider = new Flickity( '.list-articles', {
							cellAlign: 'center',
							contain: false,
							pageDots: false,
							initialIndex: 1,
							prevNextButtons: false,
							wrapAround: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});
					}

					if(document.getElementsByClassName("articles-plus").length > 0) {
						articlesSliderPlus = new Flickity( '.articles-plus', {
							cellAlign: 'center',
							contain: false,
							pageDots: false,
							initialIndex: 1,
							prevNextButtons: false,
							wrapAround: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});
					}

					if(document.getElementsByClassName("list-product-options").length > 0) {
						
						productOptionSlider = new Flickity( '.list-product-options', {
							cellAlign: 'center',
							contain: false,
							pageDots: false,
							initialIndex: 1,
							prevNextButtons: false,
							wrapAround: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});

						

						productOptionSlider.on( 'change', function( index ) {
							console.log(index);

							console.log(productOptionSlider.selectedElements);
						});
					}

					if(document.getElementsByClassName("list-accessories").length > 0) {
						accessoriesSlider = new Flickity( '.list-accessories', {
							cellAlign: 'center',
							contain: false,
							pageDots: false,
							initialIndex: 1,
							prevNextButtons: false,
							wrapAround: true,
							dragThreshold: 15,
							selectedAttraction: 0.02,
							friction: 0.3
						});

						accessoriesSlider.on( 'pointerDown', function() {
						  console.log('pointerDown');
						  //theme.toggleClasses(document.querySelector('body'), 'overflow', false);
						});
						accessoriesSlider.on( 'pointerUp', function() {
						  console.log('pointerUp');
						  //theme.toggleClasses(document.querySelector('body'), 'overflow', true);
						});
					}

				}
			}
		},
		toggleClasses: function(target, stateType, state) {
			var thatTarget = target;
			var thatType = stateType;
			var thatState = state;

			if(stateType == "overflow") {
				if(state) {
					target.classList.remove('no-overflow');
				} else {
					target.classList.add('no-overflow');
				}
			}
		},
		shareFacebook: function(getUrl) {

	    	function shareProperties() {
              FB.ui({
                  method: 'share',
                  href: getUrl
              }, function(response){
              	console.log(response);
              });
	    	}

		    if(!facebookShareLoaded) {

		        window.fbAsyncInit = function() {
		            FB.init({
		              appId      : '453144156012235',
		              autoLogAppEvents : true,
		              xfbml      : true,
		              version    : 'v10.0'
		            });

		          // Delay FB.ui code until Facebook is fully initialized
		          FB.getLoginStatus(function(response){
		              shareProperties();
		              facebookShareLoaded = true;
		          });
		        };

		        function loadFbSdk() {
			        (function(d, s, id){
			             var js, fjs = d.getElementsByTagName(s)[0];
			             if (d.getElementById(id)) {return;}
			             js = d.createElement(s); js.id = id;
			             js.src = "//connect.facebook.net/en_US/sdk.js";
			             fjs.parentNode.insertBefore(js, fjs);
			        }(document, 'script', 'facebook-jssdk'));
		        }

				loadFbSdk();

			} else {
				shareProperties();
			}
	        
	      return false;
		},
		onReady: function() {
			//console.log("onReady");

			// refresh global variables onReady
		    theme.getScreenWidth();
		    theme.getScreenHeight();
		    theme.getIsTablet();
		    theme.getBreakpoint();

			/**
			 * Sticky header
			 */
			 if(theme.buildStickyMenu()) {
				var headerMenuSticky = document.querySelector('.header-sticky');

				headroomInstance = new Headroom(headerMenuSticky, {
					"offset": 200,
					"classes": {
					    "initial": "animated",
					    "pinned": "slideDown",
					    "unpinned": "slideUp"
					},
					onTop : function() {
						//console.log("onTop");
						headerMenuSticky.classList.remove('slideDown');

					},
					onNotTop : function() {
						//console.log("onNotTop");
					}
				});
				headroomInstance.init();
				// Sticky header END

				/**
				 * Modal - Location - Toggle
				 */
				var locationModalToggle = document.querySelectorAll('.js-toggle-locations');

				if(locationModalToggle.length > 0) {
					for(let i = 0; i < locationModalToggle.length; i++) {
						locationModalToggle[i].addEventListener('click', (event) => {
							event.preventDefault();
							document.querySelector('.location-modal').classList.add('active');
						});
					}
				}

				/**
				 * Modal - Close button toggle
				 */
				var modalCloseSelector = document.querySelectorAll('.modal-close-trigger');

				if(modalCloseSelector.length > 0) {
					for(let i = 0; i < modalCloseSelector.length; i++) {
						modalCloseSelector[i].addEventListener('click', (event) => {
							event.preventDefault();
							var that = event.target;
							var targetContainer = that.closest('.modal-item.active');

							targetContainer.classList.toggle('active');

							if(targetContainer.classList.contains('video-modal')) {
								theme.playVideo(null, false);
							}
						});
					}
				}

				// Mobile Navigation
				var mobileButtonShow = document.querySelectorAll('.show-mobile-navigation');
				var mobileButtonClose = document.querySelectorAll('.hide-mobile-navigation');

				function closeMobileMenu() {
					theme.disableMouseWheel(false);

					var thatBody = document.querySelector('body');

					thatBody.classList.remove('state-sticky');
					thatBody.classList.remove('state-normal');
					thatBody.classList.remove('mobile-menu-opened');
					document.querySelector('html').style.overflow = "";
					document.body.scrollTop = scrollPos; //when removing overflow, reset to initial scroll position
				}

				if(mobileButtonShow.length > 0) {
					for(let i = 0; i < mobileButtonShow.length; i++) {
						mobileButtonShow[i].addEventListener('click', (event) => {
							event.preventDefault();
							theme.disableMouseWheel(true);

							var thatHeaderContainer = event.target.closest('.header');
							var thatBody = document.querySelector('body');

							if(thatHeaderContainer.classList.contains('header-sticky')) {
								thatBody.classList.add('state-sticky');
							} else {
								thatBody.classList.add('state-normal');
							}

							theme.refreshScrollPosition(); //refresh scrollPos for when we close the menu
							thatBody.classList.add('mobile-menu-opened');
							document.querySelector('html').style.overflow = "hidden";
						});
					}
				}
				if(mobileButtonClose.length > 0) {
					for(let i = 0; i < mobileButtonClose.length; i++) {
						mobileButtonClose[i].addEventListener('click', (event) => {
							event.preventDefault();
							closeMobileMenu();
						});
					}
				}
				// Mobile Navigation END

				// Main Navigation - mobile specific
				var mainMenuMobile = document.querySelectorAll('.nav-main li a:first-child');

				if(mainMenuMobile.length > 0) {
					for(let i = 0; i < mainMenuMobile.length; i++) {
						mainMenuMobile[i].addEventListener('click', (event) => {
							if(screenWidth < 1005) {
								//event.preventDefault();
								console.log("click");
								var that = event.target;
								var thatitem = that.closest('li');
								//var getActiveItem = document.querySelector

								if(!that.classList.contains('main-menu-item')) {
									that = that.closest('.main-menu-item');
								}

								if(that.classList.contains('main-menu-item')) {
									var isSelected = that.closest('li').classList.contains('selected');

									function toggleItem() {
										thatitem.classList.add('selected');
									}

									if(!isSelected) {
										// reset any other selected items
										var getSubMenuItems = document.querySelectorAll('.nav-main li');

										for(let j = 0; j < getSubMenuItems.length; j++) {
											getSubMenuItems[j].classList.remove('selected');

											if(j == getSubMenuItems.length - 1) {
												toggleItem();
											}
										}
									} else {
										thatitem.classList.toggle('selected');
									}
								}
							}
						});
					}
				}

				// Main Navigation
				var mainMenu = document.querySelectorAll('.nav-main');
				var mainMenuItems = document.querySelectorAll('.nav-main ul li');
				var menuHasSub;

				if(document.getElementsByClassName('nav-main-sublayer-1').length > 0) {
					menuHasSub = true;
				}

				initMenuListeners();
				function initMenuListeners() {
					if(menuHasSub) {
						if(mainMenu.length > 0 && screenWidth > 1000) {
							for(let i = 0; i < mainMenu.length; i++) {
								mainMenu[i].addEventListener('mouseenter', (event) => {
									if(screenWidth > 1000) {
										document.querySelector('body').classList.add('desktop-menu-opened');
										theme.disableMouseWheel(true);
									}

								});
								mainMenu[i].addEventListener('mouseleave', (event) => {
									if(screenWidth > 1000) {
										document.querySelector('body').classList.remove('desktop-menu-opened');
										theme.disableMouseWheel(false);

										var activeSubMenu = document.querySelector('.nav-main-sublayer-1-inner li.active');

										if(activeSubMenu != null) {
											activeSubMenu.classList.remove('active');
										}
									}
								});
							}
		/*
							for(let i = 0; i < mainMenuItems.length; i++) {
								mainMenuItems[i].addEventListener('mouseenter', (event) => {
									if(screenWidth > 1000) {
										document.querySelector('body').classList.add('desktop-menu-opened');
										var that = event.target;

										if(that.getElementsByClassName('nav-main-sublayer-1').length > 0) {
											console.log("has sub items");
											console.log(that.querySelector('.nav-main-sublayer-1'));
										}
										

									}

								});
								mainMenuItems[i].addEventListener('mouseleave', (event) => {
									if(screenWidth > 1000) {
										document.querySelector('body').classList.remove('desktop-menu-opened');
									}
								});
							}
		*/
						}

					}

				}


				// Main Navigation
/*
				var mainMenu = document.querySelectorAll('.nav-main');

				if(mainMenu.length > 0 && screenWidth > 1000) {
					for(let i = 0; i < mainMenu.length; i++) {
						mainMenu[i].addEventListener('mouseenter', (event) => {
							if(screenWidth > 1000) {
								document.querySelector('body').classList.add('desktop-menu-opened');
								theme.disableMouseWheel(true);
							}

						});
						mainMenu[i].addEventListener('mouseleave', (event) => {
							if(screenWidth > 1000) {
								document.querySelector('body').classList.remove('desktop-menu-opened');
								theme.disableMouseWheel(false);

								var activeSubMenu = document.querySelector('.nav-main-sublayer-1-inner li.active');

								if(activeSubMenu != null) {
									activeSubMenu.classList.remove('active');
								}
							}
						});
					}
				}
*/
				// Menu navigation - close
				var mainMenuCloseX = document.querySelectorAll('.nav-main .close-x');

				if(mainMenuCloseX.length > 0) {
					for(let i = 0; i < mainMenuCloseX.length; i++) {
						mainMenuCloseX[i].addEventListener('click', (event) => {
							event.preventDefault();
							theme.disableMouseWheel(false);
							document.querySelector('body').classList.remove('desktop-menu-opened');

							var selecSubMenuLayer = document.querySelectorAll('.nav-main');

							if(selecSubMenuLayer.length > 0) {
								for(let i = 0; i < selecSubMenuLayer.length; i++) {
									selecSubMenuLayer[i].classList.add('sub-close');

									setTimeout(function(){
										selecSubMenuLayer[i].classList.remove('sub-close');
									}, 200);
								}
							}
						});
					}
				}

				// Main Navigation - mobile open close
/*
				var mainNavigation = document.querySelectorAll('.nav-main-toggle');

				if(mainNavigation.length > 0) {
					for(let i = 0; i < mainNavigation.length; i++) {
						mainNavigation[i].addEventListener('click', (event) => {
							console.log("open");
							document.querySelector('html').classList.add('desktop-menu-opened');
						});
						mainNavigation[i].addEventListener('click', (event) => {
							console.log("close");
							document.querySelector('html').classList.remove('desktop-menu-opened');
						});
					}
				}
*/
				// Main Navigation END

				/**
				 * MENU - slider toggle
				 */
				var menuItemWidthSlide = document.querySelectorAll('.nav-main-sublayer-1-inner li a.menu-item-link');
				var getActiveContainer;
				var thatToggleItem;
				var thatContainer;
				var menuItemAnimDelay = 0;

				for(let i = 0; i<menuItemWidthSlide.length; i++) {
					var findListcontainer = menuItemWidthSlide[i].closest('li');

					findListcontainer.addEventListener("mouseenter", event => {
						event.stopPropagation();
						//console.log("over");
						//console.log(event.target);

						var that = event.target;
						var hasNestedContent = event.target.querySelector('a').classList.contains('js-toggle-menu-slide');

						if (screenWidth > 835) {
							if(hasNestedContent) {
								thatToggleItem = that.querySelector('a');

								if(thatToggleItem.classList.contains('js-toggle-menu-slide')) {
									thatContainer = that;
									getActiveContainer = document.querySelector('.nav-main-sublayer-1-inner li.active');

									if(that != getActiveContainer) {
										// remove possible current active class
										if(getActiveContainer != null && getActiveContainer != thatContainer) {
											getActiveContainer.classList.remove('active');

											//create possible delay on new slide out
											//menuItemAnimDelay = 400;
										}

										// toggle current click
										setTimeout(function(){
											thatContainer.classList.toggle('active');
										}, menuItemAnimDelay);
									}
								}
							} else {
								var getPossibleActiveMenuItem = document.querySelector('.nav-main li.selected .nav-main-sublayer-1-inner li.active');

								if(getPossibleActiveMenuItem != null && getPossibleActiveMenuItem != undefined) {
									getPossibleActiveMenuItem.classList.remove('active');
								}
							}

						}

					});
					menuItemWidthSlide[i].addEventListener("mouseleave", event => {
						event.stopPropagation();

						if (screenWidth > 768) {
							//console.log("out");
						}
					});
				}

				/**
				 * SHOP MILO - Button toggle
				 */
				var buttonShop = document.querySelectorAll('.js-toggle-shop-list');
				var modalShop = document.querySelector('.shop-modal');

				if(buttonShop.length > 0) {
					for(let i = 0; i<buttonShop.length; i++) {
						buttonShop[i].addEventListener('click', (event) => {
							event.preventDefault();
							modalShop.classList.add('active');
						});
					}
				}

			 } // theme.buildStickyMenu()

	
			// FAQ Accordion

			var faqSelectors = document.querySelectorAll('.faq-trigger');

			if(faqSelectors.length > 0) {
				for(let i = 0; i < faqSelectors.length; i++) {
					faqSelectors[i].addEventListener('click', (event) => {
						event.preventDefault();
						event.target.parentNode.parentNode.classList.toggle('active');
					});
				}
			}

			/**
			 * Text line reveal animation
			 */
			hasLinePresentation = document.querySelectorAll('.has-presentation');

			if(hasLinePresentation.length > 0) {
				for(let i = 0; i<hasLinePresentation.length; i++) {
					theme.createTextLineHover(i, hasLinePresentation[i]);
				}
			}

			/**
			 * Video play
			 */
			var hasVideoTrigger = document.querySelectorAll('.video-trigger');

			if(hasVideoTrigger.length > 0) {
				for(let i = 0; i<hasVideoTrigger.length; i++) {
					hasVideoTrigger[i].addEventListener('click', (event) => {
						event.preventDefault();
						var that = event.target;
						var videoTargetContainer = that;

						// handle event bubbling
						if(!that.classList.contains('video-trigger')) {
							videoTargetContainer = that.closest('.video-trigger');
						}

						theme.playVideo(videoTargetContainer);
					});
				}
			}

			/**
			 * Footer mobile accordion
			 */
			var footerNavigation = document.querySelectorAll('.footer-navigation ul li');

			if(footerNavigation.length > 0) {
				for(let i = 0; i < footerNavigation.length; i++) {
					footerNavigation[i].addEventListener('click', (event) => {
						var that = event.target;
						var thatMain = that.closest('.footer-main');
						var thatTarget = thatMain.closest('li');

						if(!thatMain.classList.contains('has-link')) {
							event.preventDefault();
						}

						function toggleItem() {
							thatTarget.classList.toggle('active');
						}

						var activeFooter = document.querySelectorAll('.footer-navigation ul li.active');
						if(activeFooter.length > 0) {
							if(thatTarget.classList.contains('active')) {
								toggleItem();
							} else {
								for(let i = 0; i<activeFooter.length; i++) {
									activeFooter[i].classList.remove('active');

									if(i == activeFooter.length - 1) {
										toggleItem();
									}
								}
							}

						} else {
							toggleItem();
						}
					});
				}
			}

				// Footer Mobile Accordion END
			// Mobile Sliders END

			/**
			 * Social share
			 */
			var sociaShareTrigger = document.querySelectorAll('.trigger-fb-share');

			if(sociaShareTrigger.length > 0) {
				for(let i = 0; i < sociaShareTrigger.length; i++) {
					sociaShareTrigger[i].addEventListener('click', (event) => {
						var shareUrl;

						if (typeof sgsBaseVar !== 'undefined') {
						    // the variable is defined
						    shareUrl = sgsBaseVar.currentpageurl;
						} else {
							shareUrl = "https://facebook.com";
						}
						theme.shareFacebook(shareUrl);
					});
				}
			}

			// init rellax
			/*
			setTimeout(function(){
				var rellax = new Rellax('.rellax', {
					speed: 1,
					center: true,
					//wrapper: null,
					//round: true,
					//vertical: true,
					//horizontal: false
				});	
			}, 100);
			*/

			// build sliders
			theme.refreshSliders(isCurrentBreakpoint);
			
			/**
			 * Init lazyload on videos
			 */
			var lazyLoadElement = document.querySelectorAll('.lazy');

			if(lazyLoadElement.length > 0) {
				var lazyLoadInstance = new LazyLoad({
				  // Your custom settings go here
				});
			}


			// save some helper variables
			//isPageInitBreakpoint = theme.getBreakpoint();

			//const theViewer = new Viewer('threejsContainer');
		},
		onLoad: function() {
		    //console.log("onLoad");
		},
		onResize: function() {
		    //console.log("onResize");

		    //console.log("theme.getIsTablet "+theme.getIsTablet());
		    //console.log("isCurrentBreakpoint "+isCurrentBreakpoint);

		    if(theme.getIsTablet() && isCurrentBreakpoint == "desktop") {
		    	//console.log("Switch to Mobile");
		    	theme.refreshSliders('mobile');
		    	//theme.refreshSliders(isCurrentBreakpoint);
		    }
		    if(!theme.getIsTablet() && isCurrentBreakpoint == "mobile") {
		    	//console.log("Switch to Desktop");
		    	theme.refreshSliders('desktop');
		    	//theme.refreshSliders(isCurrentBreakpoint);
		    }

			// refresh global variables onResize
		    theme.getScreenWidth();
		    theme.getScreenHeight();
		    theme.getIsTablet();
		    theme.getBreakpoint();

		    if(screenWidth > 1000) {
		    	if(document.querySelector('body').classList.contains('mobile-menu-opened')) {
		    		document.querySelector('body').classList.remove('mobile-menu-opened');
		    		document.querySelector('html').style.overflow = "";
		    	}
		    }
		}
	};

	document.addEventListener('DOMContentLoaded', theme.onReady);
	window.addEventListener('load', theme.onLoad);
	window.addEventListener("resize", theme.onResize);
})();
