<?php

/**
 * Load theme assets
 */
function theme_enqueue_scripts() {
    $theme = wp_get_theme();
    $version = $theme->get('Version');

    # Custom CSS
    wp_enqueue_style('customtheme', ASSETS_URL . '/css/style.css', array(), '');
    # Theme CSS
    wp_enqueue_style('theme', get_stylesheet_uri(), array(), $version);

    // JS Files
    # All Jquery
    //wp_deregister_script('jquery');
    wp_enqueue_script('gsap',  ASSETS_URL . '/js/gsap.min.js', array(), '', true);
    wp_enqueue_script('ScrollTrigger', ASSETS_URL . '/js/ScrollTrigger.min.js', array(), '', true);
    wp_enqueue_script('rotation', ASSETS_URL . '/js/rotation.js', array(), '', true);
    wp_enqueue_script('flickity',  ASSETS_URL . '/js/flickity.pkgd.min.js', array(), '', true);
    wp_enqueue_script('rellax',  ASSETS_URL . '/js/rellax.min.js', array(), '', true);
    wp_enqueue_script('headroom',  ASSETS_URL . '/js/headroom.js', array(), '', true);
    wp_enqueue_script('lazyload',  ASSETS_URL . '/js/lazyload.min.js', array(), '', true);
    wp_enqueue_script('customscript', ASSETS_URL . '/js/script.js', array(), '', true);

    //$wp = array();

    // // Send data to theme.jquery.js
    //$wp["ajaxurl"]  = admin_url('admin-ajax.php');
    //$wp["themeurl"] = get_template_directory_uri();
    //$wp["homeurl"] 	= get_home_url();
    //wp_localize_script( 'custom_milo', 'wp', $wp );

  wp_localize_script( 'customscript', 'sgsBaseVar', array(
    //'ajax_url' => admin_url( 'admin-ajax.php' ),
    'themeurl' => get_template_directory_uri(),
    'templateurl' => get_stylesheet_directory_uri(),
    'homeurl' => get_home_url(),
    'currentpageurl' => get_permalink()
  ) );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_scripts', 100 );

/**
 * Output additional code in head
 */
add_action('wp_head', function () { ?>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
<?php });

function enqueueAdminStyles( $hook)
{
    wp_enqueue_style('custom-backend', ASSETS_URL . '/css/backend.css', array(), '');
}
add_action( 'admin_enqueue_scripts', 'enqueueAdminStyles');

/**
 * Disable wp-embed
 */
function disable_embeds_code_init() {

 // Remove the REST API endpoint.
 remove_action( 'rest_api_init', 'wp_oembed_register_route' );

 // Turn off oEmbed auto discovery.
 add_filter( 'embed_oembed_discover', '__return_false' );

 // Don't filter oEmbed results.
 remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );

 // Remove oEmbed discovery links.
 remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );

 // Remove oEmbed-specific JavaScript from the front-end and back-end.
 remove_action( 'wp_head', 'wp_oembed_add_host_js' );
 add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );

 // Remove all embeds rewrite rules.
 add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );

 // Remove filter of the oEmbed result before any HTTP requests are made.
 remove_filter( 'pre_oembed_result', 'wp_filter_pre_oembed_result', 10 );
}

if(!is_admin()) {
  add_action( 'init', 'disable_embeds_code_init', 9999 );
}

function disable_embeds_tiny_mce_plugin($plugins) {
    return array_diff($plugins, array('wpembed'));
}

function disable_embeds_rewrites($rules) {
    foreach($rules as $rule => $rewrite) {
        if(false !== strpos($rewrite, 'embed=true')) {
            unset($rules[$rule]);
        }
    }
    return $rules;
}

/**
 * Disable the emoji's
 */
function disable_emojis() {
  remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
  remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
  remove_action( 'wp_print_styles', 'print_emoji_styles' );
  remove_action( 'admin_print_styles', 'print_emoji_styles' );  
  remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
  remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );  
  remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
  
  // Remove from TinyMCE
  add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
}
if(!is_admin()) {
  add_action( 'init', 'disable_emojis' );
}