<?php if ( get_row_layout() == 'global_whats_in_the_box' ) : ?>
<?php
	// section rules
	get_template_part('parts/_code_loop_section_rules');
?>
<section class="section-product-box<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
    <div class="container-small">
    	<?php the_sub_field( 'whats_in_the_box_text' ); ?>
    	
    	<div class="product-box">
			<?php $whats_in_the_box_image = get_sub_field( 'whats_in_the_box_image' ); ?>
			<?php if ( $whats_in_the_box_image ) : ?>
				<div class="image-wrap">
					<?php
						$section_img = $whats_in_the_box_image;

						// print <img> with srcset
						get_template_part( 
						    'parts/_element-img_src_srcset', 
						    null,
							array( 
							    'img_object' => $section_img,
							    'img_custom_class' => '',
							    'img_size' => 'large',
							    'img_lazy_load' => '',
							    'img_size_attr' => '',
							)
						);
					?>
				</div>
			<?php endif; ?>

			<ul class="list-product-box">

				<?php if ( have_rows( 'whats_in_the_box_spec' ) ) : ?>
					<?php while ( have_rows( 'whats_in_the_box_spec' ) ) : the_row(); ?>

		                <li>
		                	<?php $whats_in_the_box_spec_item_image = get_sub_field( 'whats_in_the_box_spec_item_image' ); ?>
		                	<?php if ( $whats_in_the_box_spec_item_image ) : ?>
			                    <div class="list-product-box-image">
			                        <img src="<?php echo esc_url( $whats_in_the_box_spec_item_image['url'] ); ?>" alt="<?php echo esc_attr( $whats_in_the_box_spec_item_image['alt'] ); ?>" />
			                    </div>
		                    <?php endif; ?>
		                    <h3><?php the_sub_field( 'whats_in_the_box_spec_item_text' ); ?></h3>
		                </li>

					<?php endwhile; ?>
				<?php endif; ?>

			</ul>
    	</div>
    </div>
</section>

<?php endif; ?>