<?php if ( get_row_layout() == 'milo_assets' ) : ?>
	<?php
		// section rules
		get_template_part('parts/_code_loop_section_rules');
	?>
	<?php $assets_reference = get_sub_field( 'assets_reference' ); ?>
	<?php if ( $assets_reference ) : ?>
		<?php $post = $assets_reference; ?>
		<?php setup_postdata( $post ); ?>
		<?php
			$post_wysiwyg = get_field( 'product_assets_copy_text', $post->ID );
			$presentation_style = get_field( 'presentation' );
		?>

		<?php if($presentation_style == "accessories") : ?>

			<section class="section-accessories<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
			    <div class="container">
					<?php echo $post_wysiwyg; ?> 

					<?php if ( have_rows( 'product_assets_items' ) ) : ?>

						<?php
							$slides_total = count(get_field('product_assets_items'));
							$slide_arrow_toggle = ($slides_total > 3 ? " slide-button-show" : "");
						?>
					    <div class="container-small">
					        <ul class="list-accessories slider-container-item<?php echo $slide_arrow_toggle; ?>" data-total-slides="<?php echo $slides_total; ?>">
							<?php while ( have_rows( 'product_assets_items' ) ) : the_row(); ?>
								<li>
									<?php $product_assets_item_image = get_sub_field( 'product_assets_item_image' ); ?>
									<?php if ( $product_assets_item_image ) : ?>
										<div class="image-wrap">

											<?php
												$section_img = $product_assets_item_image;

												// print <img> with srcset
												get_template_part( 
												    'parts/_element-img_src_srcset', 
												    null,
													array( 
													    'img_object' => $section_img,
													    'img_custom_class' => '',
													    'img_size' => 'large',
													    'img_lazy_load' => '',
													    'img_size_attr' => '',
													)
												);
											?>

										</div>
									<?php endif; ?>
									<h3><?php the_sub_field( 'product_assets_item_label' ); ?></h3>
								</li>
							<?php endwhile; ?>
					        
					        </ul>
					    </div>
					<?php endif; ?>

				    <?php get_template_part('parts/_code_loop_list_price_display_dom'); ?>
					<?php get_template_part('parts/_code_loop_buttons_display_dom'); ?>
			    </div>
			</section>

		<?php else : ?>

			<section class="section-product-options<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
			    <div class="container">
			    	<?php echo $post_wysiwyg; ?> 

			    	<?php if ( have_rows( 'product_assets_items' ) ) : ?>
						<?php
							$slides_total = count(get_field('product_assets_items'));
							$slide_arrow_toggle = ($slides_total > 3 ? " slide-button-show" : "");
						?>
			    		<ul class="list-product-options slider-container-item<?php echo $slide_arrow_toggle; ?>" data-total-slides="<?php echo $slides_total; ?>">
			    			<?php while ( have_rows( 'product_assets_items' ) ) : the_row(); ?>
			    				<li class="has-presentation">
					                <a href="javascript:void(0)">
										<?php $product_assets_item_image = get_sub_field( 'product_assets_item_image' ); ?>
										<?php if ( $product_assets_item_image ) : ?>

											<?php
												$section_img = $product_assets_item_image;

												// print <img> with srcset
												get_template_part( 
												    'parts/_element-img_src_srcset', 
												    null,
													array( 
													    'img_object' => $section_img,
													    'img_custom_class' => '',
													    'img_size' => 'large',
													    'img_lazy_load' => '',
													    'img_size_attr' => '',
													)
												);
											?>

					                    <?php endif; ?>
					                    <h3 class="tablet-only"><?php the_sub_field( 'product_assets_item_label' ); ?></h3>
					                </a>
					                <div class="line-reveal-container">
					                    <div class="line-container-reveal-inner">
					                        <div class="text-reveal">
					                            <span class="text-reveal-item"><?php the_sub_field( 'product_assets_item_label' ); ?></span>
					                        </div>

					                        <div class="line-reveal-wrap">
					                            <div class="line-mask">
					                                <div class="line-reveal-inner"></div>
					                            </div>
					                        </div>
					                    </div>
					                </div>
			    				</li>
			    			<?php endwhile; ?>
			    		</ul>
			    	<?php endif; ?>

				    <?php get_template_part('parts/_code_loop_list_price_display_dom'); ?>
					<?php get_template_part('parts/_code_loop_buttons_display_dom'); ?>
			    </div>
			</section>

		<?php endif; ?>
	<?php wp_reset_postdata(); ?>
	<?php endif; ?>
<?php endif; ?>