/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-04-20 09:09:22 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT 1,
  `ts_status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT 0,
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4226 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_mo_files_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_path` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_path_md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not_imported',
  `num_of_strings` int(11) NOT NULL DEFAULT 0,
  `last_modified` int(11) NOT NULL,
  `component_type` enum('plugin','theme','other') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `component_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_path_md5_UNIQUE` (`file_path_md5`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_batches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `batch_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_packages` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kind_slug` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kind` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `edit_link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `view_link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` int(11) DEFAULT NULL,
  `word_count` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `url_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_to_url_id` (`url_id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mo_string` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `translation_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_string_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_string_lang_url` (`language`,`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `location` bigint(20) unsigned DEFAULT NULL,
  `wrap_tag` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain_name_context_md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_priority` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `word_count` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`),
  KEY `icl_strings_name` (`name`),
  KEY `icl_strings_translation_priority` (`translation_priority`),
  KEY `context` (`context`),
  KEY `string_package_id` (`string_package_id`)
) ENGINE=MyISAM AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `field_type` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_wrap_tag` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deadline_date` datetime DEFAULT NULL,
  `completed_date` datetime DEFAULT NULL,
  `editor` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editor_job_id` bigint(20) unsigned DEFAULT NULL,
  `edit_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_downloads` (
  `editor_job_id` bigint(20) unsigned NOT NULL,
  `download_url` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lock_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`editor_job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT 0,
  `translation_package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  `links_fixed` tinyint(4) NOT NULL DEFAULT 0,
  `_prevstate` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT 1,
  `ts_status` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=602 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=4770 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=85000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(9) NOT NULL DEFAULT -1,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `absolute` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `owner` bigint(20) NOT NULL,
  `ord` mediumint(10) NOT NULL DEFAULT 0,
  `oldCustomOrder` mediumint(10) DEFAULT NULL,
  `contentCustomOrder` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `restrictions` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cnt` mediumint(10) DEFAULT NULL,
  `importId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_icl_count` (
  `fid` mediumint(9) NOT NULL,
  `cnt_da` mediumint(10) DEFAULT NULL,
  `cnt_en` mediumint(10) DEFAULT NULL,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `realmedialibrary_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `realmedialibrary_id` (`realmedialibrary_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_posts` (
  `attachment` bigint(20) NOT NULL,
  `fid` mediumint(9) NOT NULL DEFAULT -1,
  `isShortcut` bigint(20) NOT NULL DEFAULT 0,
  `nr` bigint(20) DEFAULT NULL,
  `oldCustomNr` bigint(20) DEFAULT NULL,
  `importData` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attachment`,`isShortcut`),
  KEY `rmljoin` (`attachment`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_realmedialibrary_tmp` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(9) NOT NULL DEFAULT -1,
  `name` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ord` mediumint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  `term_order` int(4) DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/* DUPLICATOR PRO TABLE CREATION END */
INSERT INTO `wp_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2021-03-28 17:18:48","2021-03-28 17:18:48","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","comment","0","0");

INSERT INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1619726346,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": false,\n    \"lkp\": \"\",\n    \"license_limit\": 15,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1618906441,\n    \"initial_activation_timestamp\": 1617305978,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": null,\n    \"lkp\": \"oPnq9fSgUpQUkAUbKnfgGA==\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1618909761,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}"),
("4","DUP_PRO_Package_Template_Entity","{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":0,\"installer_opts_secure_pass\":\"\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");

INSERT INTO `wp_duplicator_pro_packages` VALUES 
("6","20210420_milo","670f71a1ba9008e28524_20210420090904","20","2021-04-20 09:09:11","raffinaderiet","{\n    \"Created\": \"2021-04-20 09:09:04\",\n    \"Version\": \"4.0.2\",\n    \"VersionWP\": \"5.7.1\",\n    \"VersionDB\": \"10.5.9\",\n    \"VersionPHP\": \"8.0.3\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 6,\n    \"Name\": \"20210420_milo\",\n    \"Hash\": \"670f71a1ba9008e28524_20210420090904\",\n    \"NameHash\": \"20210420_milo_670f71a1ba9008e28524_20210420090904\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/milo.sgsmedia.dk\\/wp\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_scan.json\",\n    \"timer_start\": 1618909761.801305,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.opcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.tmb\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/ai1wm-backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-lite\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backupwordpress\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/bps-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/content\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/contents\\/cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/managewp\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/old-cache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/updraft\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wfcache\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/wishlist-backup\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.htaccess\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/.user.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/php.ini\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/web.config\",\n            \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\",\n        \"Size\": 297414800,\n        \"Dirs\": null,\n        \"DirCount\": 2093,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 18248,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"milo_web_db\",\n            \"tablesBaseCount\": 43,\n            \"tablesFinalCount\": 43,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 11576,\n            \"tablesSizeOnDisk\": 3235858,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 7492\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 9840\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_content_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_core_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_flags\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 4388\n                },\n                \"wp_icl_languages\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": false,\n                    \"size\": 11252\n                },\n                \"wp_icl_languages_translations\": {\n                    \"inaccurateRows\": 4225,\n                    \"insertedRows\": false,\n                    \"size\": 228012\n                },\n                \"wp_icl_locale_map\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 2088\n                },\n                \"wp_icl_message_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"inaccurateRows\": 80,\n                    \"insertedRows\": false,\n                    \"size\": 19224\n                },\n                \"wp_icl_node\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_reminders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_batches\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2152\n                },\n                \"wp_icl_string_pages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_positions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_status\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_string_translations\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 4224\n                },\n                \"wp_icl_string_urls\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_icl_strings\": {\n                    \"inaccurateRows\": 152,\n                    \"insertedRows\": false,\n                    \"size\": 64168\n                },\n                \"wp_icl_translate\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translate_job\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_icl_translation_batches\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2112\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 16384\n                },\n                \"wp_icl_translation_status\": {\n                    \"inaccurateRows\": 156,\n                    \"insertedRows\": false,\n                    \"size\": 14832\n                },\n                \"wp_icl_translations\": {\n                    \"inaccurateRows\": 587,\n                    \"insertedRows\": false,\n                    \"size\": 93100\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": 396,\n                    \"insertedRows\": false,\n                    \"size\": 1387892\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": 4670,\n                    \"insertedRows\": false,\n                    \"size\": 906352\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": 575,\n                    \"insertedRows\": false,\n                    \"size\": 344864\n                },\n                \"wp_realmedialibrary\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": false,\n                    \"size\": 6232\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": false,\n                    \"size\": 2638\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"inaccurateRows\": 308,\n                    \"insertedRows\": false,\n                    \"size\": 22552\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": 64,\n                    \"insertedRows\": false,\n                    \"size\": 6464\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 4804\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": false,\n                    \"size\": 10448\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": false,\n                    \"size\": 13968\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": 59,\n                    \"insertedRows\": false,\n                    \"size\": 15296\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 8456\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.5.9\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": \"20210420_milo_670f71a1ba9008e28524_20210420090904_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/wp-content\\/backups-dup-pro\\/tmp\\/20210420_milo_670f71a1ba9008e28524_20210420090904_database.sql\"\n    },\n    \"Status\": \"20.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1618909762,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_icl_content_status\",\n            \"wp_icl_core_status\",\n            \"wp_icl_flags\",\n            \"wp_icl_languages\",\n            \"wp_icl_languages_translations\",\n            \"wp_icl_locale_map\",\n            \"wp_icl_message_status\",\n            \"wp_icl_mo_files_domains\",\n            \"wp_icl_node\",\n            \"wp_icl_reminders\",\n            \"wp_icl_string_batches\",\n            \"wp_icl_string_packages\",\n            \"wp_icl_string_pages\",\n            \"wp_icl_string_positions\",\n            \"wp_icl_string_status\",\n            \"wp_icl_string_translations\",\n            \"wp_icl_string_urls\",\n            \"wp_icl_strings\",\n            \"wp_icl_translate\",\n            \"wp_icl_translate_job\",\n            \"wp_icl_translation_batches\",\n            \"wp_icl_translation_downloads\",\n            \"wp_icl_translation_status\",\n            \"wp_icl_translations\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_realmedialibrary\",\n            \"wp_realmedialibrary_icl_count\",\n            \"wp_realmedialibrary_meta\",\n            \"wp_realmedialibrary_posts\",\n            \"wp_realmedialibrary_tmp\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_usermeta\",\n            \"wp_users\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1618909761.806282,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 11577,\n            \"tables\": {\n                \"wp_commentmeta\": {\n                    \"start\": \"0\",\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_content_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_core_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_flags\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_languages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_languages_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_locale_map\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_message_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_mo_files_domains\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_node\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_reminders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_batches\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_pages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_positions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_string_urls\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_strings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translate\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translate_job\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_batches\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_downloads\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translation_status\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_icl_translations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_icl_count\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_realmedialibrary_tmp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                },\n                \"wp_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");

INSERT INTO `wp_icl_flags` VALUES 
("1","ar","ar.png","0"),
("2","az","az.png","0"),
("3","bg","bg.png","0"),
("4","bn","bn.png","0"),
("5","bs","bs.png","0"),
("6","ca","ca.png","0"),
("7","cs","cs.png","0"),
("8","cy","cy.png","0"),
("9","da","da.png","0"),
("10","de","de.png","0"),
("11","el","el.png","0"),
("12","en","en.png","0"),
("13","eo","eo.png","0"),
("14","es","es.png","0"),
("15","et","et.png","0"),
("16","eu","eu.png","0"),
("17","fa","fa.png","0"),
("18","fi","fi.png","0"),
("19","fr","fr.png","0"),
("20","ga","ga.png","0"),
("21","gl","gl.png","0"),
("22","he","he.png","0"),
("23","hi","hi.png","0"),
("24","hr","hr.png","0"),
("25","hu","hu.png","0"),
("26","hy","hy.png","0"),
("27","id","id.png","0"),
("28","is","is.png","0"),
("29","it","it.png","0"),
("30","ja","ja.png","0"),
("31","ko","ko.png","0"),
("32","ku","ku.png","0"),
("33","lt","lt.png","0"),
("34","lv","lv.png","0"),
("35","mk","mk.png","0"),
("36","mn","mn.png","0"),
("37","ms","ms.png","0"),
("38","mt","mt.png","0"),
("39","ne","ne.png","0"),
("40","nl","nl.png","0"),
("41","no","no.png","0"),
("42","pa","pa.png","0"),
("43","pl","pl.png","0"),
("44","pt-br","pt-br.png","0"),
("45","pt-pt","pt-pt.png","0"),
("46","qu","qu.png","0"),
("47","ro","ro.png","0"),
("48","ru","ru.png","0"),
("49","sk","sk.png","0"),
("50","sl","sl.png","0"),
("51","so","so.png","0"),
("52","sq","sq.png","0"),
("53","sr","sr.png","0"),
("54","sv","sv.png","0"),
("55","ta","ta.png","0"),
("56","th","th.png","0"),
("57","tr","tr.png","0"),
("58","uk","uk.png","0"),
("59","ur","ur.png","0"),
("60","uz","uz.png","0"),
("61","vi","vi.png","0"),
("62","yi","yi.png","0"),
("63","zh-hans","zh.png","0"),
("64","zh-hant","zh.png","0"),
("65","zu","zu.png","0");

INSERT INTO `wp_icl_languages` VALUES 
("1","en","English","1","1","en_US","en","0"),
("2","es","Spanish","1","0","es_ES","es","0"),
("3","de","German","1","0","de_DE","de","0"),
("4","fr","French","1","0","fr_FR","fr","0"),
("5","ar","Arabic","0","0","ar","ar","0"),
("6","bs","Bosnian","0","0","bs_BA","bs","0"),
("7","bg","Bulgarian","0","0","bg_BG","bg","0"),
("8","ca","Catalan","0","0","ca","ca","0"),
("9","cs","Czech","0","0","cs_CZ","cs","0"),
("10","sk","Slovak","0","0","sk_SK","sk","0"),
("11","cy","Welsh","0","0","cy_GB","cy","0"),
("12","da","Danish","1","1","da_DK","da","0"),
("13","el","Greek","0","0","el","el","0"),
("14","eo","Esperanto","0","0","eo_UY","eo","0"),
("15","et","Estonian","0","0","et","et","0"),
("16","eu","Basque","0","0","eu_ES","eu","0"),
("17","fa","Persian","0","0","fa_IR","fa","0"),
("18","fi","Finnish","0","0","fi","fi","0"),
("19","ga","Irish","0","0","ga_IE","ga","0"),
("20","he","Hebrew","0","0","he_IL","he","0"),
("21","hi","Hindi","0","0","hi_IN","hi","0"),
("22","hr","Croatian","0","0","hr","hr","0"),
("23","hu","Hungarian","0","0","hu_HU","hu","0"),
("24","hy","Armenian","0","0","hy_AM","hy","0"),
("25","id","Indonesian","0","0","id_ID","id","0"),
("26","is","Icelandic","0","0","is_IS","is","0"),
("27","it","Italian","1","0","it_IT","it","0"),
("28","ja","Japanese","1","0","ja","ja","0"),
("29","ko","Korean","0","0","ko_KR","ko","0"),
("30","ku","Kurdish","0","0","ckb","ku","0"),
("31","lv","Latvian","0","0","lv_LV","lv","0"),
("32","lt","Lithuanian","0","0","lt_LT","lt","0"),
("33","mk","Macedonian","0","0","mk_MK","mk","0"),
("34","mt","Maltese","0","0","mt_MT","mt","0"),
("35","mn","Mongolian","0","0","mn_MN","mn","0"),
("36","ne","Nepali","0","0","ne","ne","0"),
("37","nl","Dutch","1","0","nl_NL","nl","0"),
("38","no","Norwegian Bokmål","0","0","nb_NO","no","0"),
("39","pa","Punjabi","0","0","pa_IN","pa","0"),
("40","pl","Polish","0","0","pl_PL","pl","0"),
("41","pt-pt","Portuguese, Portugal","0","0","pt_PT","pt-pt","0"),
("42","pt-br","Portuguese, Brazil","0","0","pt_BR","pt-br","0"),
("43","qu","Quechua","0","0","quz_PE","qu","0"),
("44","ro","Romanian","0","0","ro_RO","ro","0"),
("45","ru","Russian","1","0","ru_RU","ru","0"),
("46","sl","Slovenian","0","0","sl_SI","sl","0"),
("47","so","Somali","0","0","so_SO","so","0"),
("48","sq","Albanian","0","0","sq_AL","sq","0"),
("49","sr","Serbian","0","0","sr_RS","sr","0"),
("50","sv","Swedish","0","0","sv_SE","sv","0"),
("51","ta","Tamil","0","0","ta_IN","ta","0"),
("52","th","Thai","0","0","th","th","0"),
("53","tr","Turkish","0","0","tr_TR","tr","0"),
("54","uk","Ukrainian","0","0","uk","uk","0"),
("55","ur","Urdu","0","0","ur","ur","0"),
("56","uz","Uzbek","0","0","uz_UZ","uz","0"),
("57","vi","Vietnamese","0","0","vi_VN","vi","0"),
("58","yi","Yiddish","0","0","","yi","0"),
("59","zh-hans","Chinese (Simplified)","1","0","zh_CN","zh-hans","0"),
("60","zu","Zulu","0","0","","zu","0"),
("61","zh-hant","Chinese (Traditional)","1","0","zh_TW","zh-hant","0"),
("62","ms","Malay","0","0","ms_MY","ms","0"),
("63","gl","Galician","0","0","gl_ES","gl","0"),
("64","bn","Bengali","0","0","bn_BD","bn","0"),
("65","az","Azerbaijani","0","0","az","az","0");

INSERT INTO `wp_icl_languages_translations` VALUES 
("1","en","en","English"),
("2","en","es","Inglés"),
("3","en","de","Englisch"),
("4","en","fr","Anglais"),
("5","en","ar","الإنجليزية"),
("6","en","bs","English"),
("7","en","bg","Английски"),
("8","en","ca","English"),
("9","en","cs","Angličtina"),
("10","en","sk","Angličtina"),
("11","en","cy","English"),
("12","en","da","English"),
("13","en","el","Αγγλικά"),
("14","en","eo","English"),
("15","en","et","English"),
("16","en","eu","English"),
("17","en","fa","English"),
("18","en","fi","Englanti"),
("19","en","ga","English"),
("20","en","he","אנגלית"),
("21","en","hi","English"),
("22","en","hr","Engleski"),
("23","en","hu","Angol"),
("24","en","hy","English"),
("25","en","id","English"),
("26","en","is","English"),
("27","en","it","Inglese"),
("28","en","ja","英語"),
("29","en","ko","영어"),
("30","en","ku","English"),
("31","en","lv","English"),
("32","en","lt","English"),
("33","en","mk","English"),
("34","en","mt","English"),
("35","en","mn","English"),
("36","en","ne","English"),
("37","en","nl","Engels"),
("38","en","no","Engelsk"),
("39","en","pa","English"),
("40","en","pl","Angielski"),
("41","en","pt-pt","Inglês"),
("42","en","pt-br","Inglês"),
("43","en","qu","English"),
("44","en","ro","Engleză"),
("45","en","ru","Английский"),
("46","en","sl","Angleščina"),
("47","en","so","English"),
("48","en","sq","English"),
("49","en","sr","енглески"),
("50","en","sv","Engelska"),
("51","en","ta","English"),
("52","en","th","อังกฤษ"),
("53","en","tr","İngilizce"),
("54","en","uk","English"),
("55","en","ur","English"),
("56","en","uz","English"),
("57","en","vi","English"),
("58","en","yi","English"),
("59","en","zh-hans","英语"),
("60","en","zu","English"),
("61","en","zh-hant","英語"),
("62","en","ms","English"),
("63","en","gl","English"),
("64","en","bn","English"),
("65","en","az","Ingilis"),
("66","es","en","Spanish"),
("67","es","es","Español"),
("68","es","de","Spanisch"),
("69","es","fr","Espagnol"),
("70","es","ar","الأسبانية"),
("71","es","bs","Spanish"),
("72","es","bg","Испански"),
("73","es","ca","Spanish"),
("74","es","cs","Španělský"),
("75","es","sk","Španielčina"),
("76","es","cy","Spanish"),
("77","es","da","Spanish"),
("78","es","el","Ισπανικά"),
("79","es","eo","Spanish"),
("80","es","et","Spanish"),
("81","es","eu","Spanish"),
("82","es","fa","Spanish"),
("83","es","fi","Espanja"),
("84","es","ga","Spanish"),
("85","es","he","ספרדית"),
("86","es","hi","Spanish"),
("87","es","hr","španjolski"),
("88","es","hu","Spanyol"),
("89","es","hy","Spanish"),
("90","es","id","Spanish"),
("91","es","is","Spanish"),
("92","es","it","Spagnolo"),
("93","es","ja","スペイン語"),
("94","es","ko","스페인어"),
("95","es","ku","Spanish"),
("96","es","lv","Spanish"),
("97","es","lt","Spanish"),
("98","es","mk","Spanish"),
("99","es","mt","Spanish"),
("100","es","mn","Spanish"),
("101","es","ne","Spanish"),
("102","es","nl","Spaans"),
("103","es","no","Spansk"),
("104","es","pa","Spanish"),
("105","es","pl","Hiszpański"),
("106","es","pt-pt","Espanhol"),
("107","es","pt-br","Espanhol"),
("108","es","qu","Spanish"),
("109","es","ro","Spaniolă"),
("110","es","ru","Испанский"),
("111","es","sl","Španščina"),
("112","es","so","Spanish"),
("113","es","sq","Spanish"),
("114","es","sr","шпански"),
("115","es","sv","Spanska"),
("116","es","ta","Spanish"),
("117","es","th","สเปน"),
("118","es","tr","İspanyolca"),
("119","es","uk","Spanish"),
("120","es","ur","Spanish"),
("121","es","uz","Spanish"),
("122","es","vi","Spanish"),
("123","es","yi","Spanish"),
("124","es","zh-hans","西班牙语"),
("125","es","zu","Spanish"),
("126","es","zh-hant","西班牙語"),
("127","es","ms","Spanish"),
("128","es","gl","Spanish"),
("129","es","bn","Spanish"),
("130","es","az","Spanish"),
("131","de","en","German"),
("132","de","es","Alemán"),
("133","de","de","Deutsch"),
("134","de","fr","Allemand"),
("135","de","ar","الألمانية"),
("136","de","bs","German"),
("137","de","bg","Немски"),
("138","de","ca","German"),
("139","de","cs","Němec"),
("140","de","sk","Nemčina"),
("141","de","cy","German"),
("142","de","da","German"),
("143","de","el","Γερμανικά"),
("144","de","eo","German"),
("145","de","et","German"),
("146","de","eu","German"),
("147","de","fa","German"),
("148","de","fi","Saksa"),
("149","de","ga","German"),
("150","de","he","גרמנית"),
("151","de","hi","German"),
("152","de","hr","Njemački"),
("153","de","hu","Német"),
("154","de","hy","German"),
("155","de","id","German"),
("156","de","is","German"),
("157","de","it","Tedesco"),
("158","de","ja","ドイツ語"),
("159","de","ko","독어"),
("160","de","ku","German"),
("161","de","lv","German"),
("162","de","lt","German"),
("163","de","mk","German"),
("164","de","mt","German"),
("165","de","mn","German"),
("166","de","ne","German"),
("167","de","nl","Duits"),
("168","de","no","Tysk"),
("169","de","pa","German"),
("170","de","pl","Niemiecki"),
("171","de","pt-pt","Alemão"),
("172","de","pt-br","Alemão"),
("173","de","qu","German"),
("174","de","ro","Germană"),
("175","de","ru","Немецкий"),
("176","de","sl","Nemščina"),
("177","de","so","German"),
("178","de","sq","German"),
("179","de","sr","немачки"),
("180","de","sv","Tyska"),
("181","de","ta","German"),
("182","de","th","เยอรมัน"),
("183","de","tr","Almanca"),
("184","de","uk","German"),
("185","de","ur","German"),
("186","de","uz","German"),
("187","de","vi","German"),
("188","de","yi","German"),
("189","de","zh-hans","德语"),
("190","de","zu","German"),
("191","de","zh-hant","德語"),
("192","de","ms","German"),
("193","de","gl","German"),
("194","de","bn","German"),
("195","de","az","German"),
("196","fr","en","French"),
("197","fr","es","Francés"),
("198","fr","de","Französisch"),
("199","fr","fr","Français"),
("200","fr","ar","الفرنسية"),
("201","fr","bs","French"),
("202","fr","bg","Френски"),
("203","fr","ca","French"),
("204","fr","cs","Francouzština"),
("205","fr","sk","Francúzština"),
("206","fr","cy","French"),
("207","fr","da","French"),
("208","fr","el","Γαλλικά"),
("209","fr","eo","French"),
("210","fr","et","French"),
("211","fr","eu","French"),
("212","fr","fa","French"),
("213","fr","fi","Ranska"),
("214","fr","ga","French"),
("215","fr","he","צרפתית"),
("216","fr","hi","French"),
("217","fr","hr","Francuski"),
("218","fr","hu","Francia"),
("219","fr","hy","French"),
("220","fr","id","French"),
("221","fr","is","French"),
("222","fr","it","Francese"),
("223","fr","ja","フランス語"),
("224","fr","ko","불어"),
("225","fr","ku","French"),
("226","fr","lv","French"),
("227","fr","lt","French"),
("228","fr","mk","French"),
("229","fr","mt","French"),
("230","fr","mn","French"),
("231","fr","ne","French"),
("232","fr","nl","Frans"),
("233","fr","no","Fransk"),
("234","fr","pa","French"),
("235","fr","pl","Francuski"),
("236","fr","pt-pt","Francês"),
("237","fr","pt-br","Francês"),
("238","fr","qu","French"),
("239","fr","ro","Franceză"),
("240","fr","ru","Французский"),
("241","fr","sl","Francoščina"),
("242","fr","so","French"),
("243","fr","sq","French"),
("244","fr","sr","француски"),
("245","fr","sv","Franska"),
("246","fr","ta","French"),
("247","fr","th","ฝรั่งเศส"),
("248","fr","tr","Fransızca"),
("249","fr","uk","French"),
("250","fr","ur","French"),
("251","fr","uz","French"),
("252","fr","vi","French"),
("253","fr","yi","French"),
("254","fr","zh-hans","法语"),
("255","fr","zu","French"),
("256","fr","zh-hant","法語"),
("257","fr","ms","French"),
("258","fr","gl","French"),
("259","fr","bn","French"),
("260","fr","az","French"),
("261","ar","en","Arabic"),
("262","ar","es","Árabe"),
("263","ar","de","Arabisch"),
("264","ar","fr","Arabe"),
("265","ar","ar","العربية"),
("266","ar","bs","Arabic"),
("267","ar","bg","Арабски"),
("268","ar","ca","Arabic"),
("269","ar","cs","Arabština"),
("270","ar","sk","Arabčina"),
("271","ar","cy","Arabic"),
("272","ar","da","Arabic"),
("273","ar","el","Αραβικά"),
("274","ar","eo","Arabic"),
("275","ar","et","Arabic"),
("276","ar","eu","Arabic"),
("277","ar","fa","Arabic"),
("278","ar","fi","Arabia"),
("279","ar","ga","Arabic"),
("280","ar","he","ערבית"),
("281","ar","hi","Arabic"),
("282","ar","hr","Arapski"),
("283","ar","hu","Arab"),
("284","ar","hy","Arabic"),
("285","ar","id","Arabic"),
("286","ar","is","Arabic"),
("287","ar","it","Arabo"),
("288","ar","ja","アラビア語"),
("289","ar","ko","아랍어"),
("290","ar","ku","Arabic"),
("291","ar","lv","Arabic"),
("292","ar","lt","Arabic"),
("293","ar","mk","Arabic"),
("294","ar","mt","Arabic"),
("295","ar","mn","Arabic"),
("296","ar","ne","Arabic"),
("297","ar","nl","Arabisch"),
("298","ar","no","Arabisk"),
("299","ar","pa","Arabic"),
("300","ar","pl","Arabski"),
("301","ar","pt-pt","Árabe"),
("302","ar","pt-br","Árabe"),
("303","ar","qu","Arabic"),
("304","ar","ro","Arabică"),
("305","ar","ru","Арабский"),
("306","ar","sl","Arabščina"),
("307","ar","so","Arabic"),
("308","ar","sq","Arabic"),
("309","ar","sr","арапски"),
("310","ar","sv","Arabiska"),
("311","ar","ta","Arabic"),
("312","ar","th","อารบิก"),
("313","ar","tr","Arapça"),
("314","ar","uk","Arabic"),
("315","ar","ur","Arabic"),
("316","ar","uz","Arabic"),
("317","ar","vi","Arabic"),
("318","ar","yi","Arabic"),
("319","ar","zh-hans","阿拉伯语"),
("320","ar","zu","Arabic"),
("321","ar","zh-hant","阿拉伯語"),
("322","ar","ms","Arabic"),
("323","ar","gl","Arabic"),
("324","ar","bn","Arabic"),
("325","ar","az","Arabic"),
("326","bs","en","Bosnian"),
("327","bs","es","Bosnio"),
("328","bs","de","Bosnisch"),
("329","bs","fr","Bosnien"),
("330","bs","ar","البوسنية"),
("331","bs","bs","Bosnian"),
("332","bs","bg","Босненски"),
("333","bs","ca","Bosnian"),
("334","bs","cs","Bosenština"),
("335","bs","sk","Bosniačtina"),
("336","bs","cy","Bosnian"),
("337","bs","da","Bosnian"),
("338","bs","el","Βοσνιακά"),
("339","bs","eo","Bosnian"),
("340","bs","et","Bosnian"),
("341","bs","eu","Bosnian"),
("342","bs","fa","Bosnian"),
("343","bs","fi","Bosnia"),
("344","bs","ga","Bosnian"),
("345","bs","he","בוסנית"),
("346","bs","hi","Bosnian"),
("347","bs","hr","Bosanski"),
("348","bs","hu","Bosnyák"),
("349","bs","hy","Bosnian"),
("350","bs","id","Bosnian"),
("351","bs","is","Bosnian"),
("352","bs","it","Bosniaco"),
("353","bs","ja","ボスニア語"),
("354","bs","ko","보즈니아어"),
("355","bs","ku","Bosnian"),
("356","bs","lv","Bosnian"),
("357","bs","lt","Bosnian"),
("358","bs","mk","Bosnian"),
("359","bs","mt","Bosnian"),
("360","bs","mn","Bosnian"),
("361","bs","ne","Bosnian"),
("362","bs","nl","Bosnisch"),
("363","bs","no","Bosnisk"),
("364","bs","pa","Bosnian"),
("365","bs","pl","Bośniacki"),
("366","bs","pt-pt","Bósnio"),
("367","bs","pt-br","Bósnio"),
("368","bs","qu","Bosnian"),
("369","bs","ro","Bosniacă"),
("370","bs","ru","Боснийский"),
("371","bs","sl","Bosanski"),
("372","bs","so","Bosnian"),
("373","bs","sq","Bosnian"),
("374","bs","sr","босански"),
("375","bs","sv","Bosniska"),
("376","bs","ta","Bosnian"),
("377","bs","th","บอสเนียน"),
("378","bs","tr","Boşnakça"),
("379","bs","uk","Bosnian"),
("380","bs","ur","Bosnian"),
("381","bs","uz","Bosnian"),
("382","bs","vi","Bosnian"),
("383","bs","yi","Bosnian"),
("384","bs","zh-hans","波斯尼亚语"),
("385","bs","zu","Bosnian"),
("386","bs","zh-hant","波士尼亞語"),
("387","bs","ms","Bosnian"),
("388","bs","gl","Bosnian"),
("389","bs","bn","Bosnian"),
("390","bs","az","Bosnian"),
("391","bg","en","Bulgarian"),
("392","bg","es","Búlgaro"),
("393","bg","de","Bulgarisch"),
("394","bg","fr","Bulgare"),
("395","bg","ar","البلغارية"),
("396","bg","bs","Bulgarian"),
("397","bg","bg","Български"),
("398","bg","ca","Bulgarian"),
("399","bg","cs","Bulharština"),
("400","bg","sk","Bulharčina"),
("401","bg","cy","Bulgarian"),
("402","bg","da","Bulgarian"),
("403","bg","el","Βουλγαρικά"),
("404","bg","eo","Bulgarian"),
("405","bg","et","Bulgarian"),
("406","bg","eu","Bulgarian"),
("407","bg","fa","Bulgarian"),
("408","bg","fi","Bulgaria"),
("409","bg","ga","Bulgarian"),
("410","bg","he","בולגרית"),
("411","bg","hi","Bulgarian"),
("412","bg","hr","Bugarski"),
("413","bg","hu","Bolgár"),
("414","bg","hy","Bulgarian"),
("415","bg","id","Bulgarian"),
("416","bg","is","Bulgarian"),
("417","bg","it","Bulgaro"),
("418","bg","ja","ブルガリア語"),
("419","bg","ko","불가리아어"),
("420","bg","ku","Bulgarian"),
("421","bg","lv","Bulgarian"),
("422","bg","lt","Bulgarian"),
("423","bg","mk","Bulgarian"),
("424","bg","mt","Bulgarian"),
("425","bg","mn","Bulgarian"),
("426","bg","ne","Bulgarian"),
("427","bg","nl","Bulgaars"),
("428","bg","no","Bulgarian"),
("429","bg","pa","Bulgarian"),
("430","bg","pl","Bułgarski"),
("431","bg","pt-pt","Búlgaro"),
("432","bg","pt-br","Búlgaro"),
("433","bg","qu","Bulgarian"),
("434","bg","ro","Bulgară"),
("435","bg","ru","Болгарский"),
("436","bg","sl","Bolgarščina"),
("437","bg","so","Bulgarian"),
("438","bg","sq","Bulgarian"),
("439","bg","sr","бугарски"),
("440","bg","sv","Bulgariska"),
("441","bg","ta","Bulgarian"),
("442","bg","th","บัลแกเรียน"),
("443","bg","tr","Bulgarca"),
("444","bg","uk","Bulgarian"),
("445","bg","ur","Bulgarian"),
("446","bg","uz","Bulgarian"),
("447","bg","vi","Bulgarian"),
("448","bg","yi","Bulgarian"),
("449","bg","zh-hans","保加利亚语"),
("450","bg","zu","Bulgarian"),
("451","bg","zh-hant","保加利亞語"),
("452","bg","ms","Bulgarian"),
("453","bg","gl","Bulgarian"),
("454","bg","bn","Bulgarian"),
("455","bg","az","Bulgarian"),
("456","ca","en","Catalan"),
("457","ca","es","Catalán"),
("458","ca","de","Katalanisch"),
("459","ca","fr","Catalan"),
("460","ca","ar","الكاتالوينية"),
("461","ca","bs","Catalan"),
("462","ca","bg","Каталонски"),
("463","ca","ca","Català"),
("464","ca","cs","Katalánština"),
("465","ca","sk","Katalánčina"),
("466","ca","cy","Catalan"),
("467","ca","da","Catalan"),
("468","ca","el","Καταλανικά"),
("469","ca","eo","Catalan"),
("470","ca","et","Catalan"),
("471","ca","eu","Catalan"),
("472","ca","fa","Catalan"),
("473","ca","fi","Katalaani"),
("474","ca","ga","Catalan"),
("475","ca","he","קטלאנית"),
("476","ca","hi","Catalan"),
("477","ca","hr","Katalonski"),
("478","ca","hu","Katalán"),
("479","ca","hy","Catalan"),
("480","ca","id","Catalan"),
("481","ca","is","Catalan"),
("482","ca","it","Catalano"),
("483","ca","ja","カタルーニャ語"),
("484","ca","ko","카탈로니아어"),
("485","ca","ku","Catalan"),
("486","ca","lv","Catalan"),
("487","ca","lt","Catalan"),
("488","ca","mk","Catalan"),
("489","ca","mt","Catalan"),
("490","ca","mn","Catalan"),
("491","ca","ne","Catalan"),
("492","ca","nl","Catalaans"),
("493","ca","no","catalan"),
("494","ca","pa","Catalan"),
("495","ca","pl","Kataloński"),
("496","ca","pt-pt","Catalão"),
("497","ca","pt-br","Catalão"),
("498","ca","qu","Catalan"),
("499","ca","ro","Catalană"),
("500","ca","ru","Каталанский"),
("501","ca","sl","Katalonščina"),
("502","ca","so","Catalan"),
("503","ca","sq","Catalan"),
("504","ca","sr","каталонски"),
("505","ca","sv","Katalanska"),
("506","ca","ta","Catalan"),
("507","ca","th","คะตะลาน"),
("508","ca","tr","Katalan dili"),
("509","ca","uk","Catalan"),
("510","ca","ur","Catalan"),
("511","ca","uz","Catalan"),
("512","ca","vi","Catalan"),
("513","ca","yi","Catalan"),
("514","ca","zh-hans","加泰罗尼亚语"),
("515","ca","zu","Catalan"),
("516","ca","zh-hant","加泰羅尼亞語"),
("517","ca","ms","Catalan"),
("518","ca","gl","Catalan"),
("519","ca","bn","Catalan"),
("520","ca","az","Catalan"),
("521","cs","en","Czech"),
("522","cs","es","Checo"),
("523","cs","de","Tschechisch"),
("524","cs","fr","Tchèque"),
("525","cs","ar","التشيكية"),
("526","cs","bs","Czech"),
("527","cs","bg","Чешки"),
("528","cs","ca","Czech"),
("529","cs","cs","Čeština"),
("530","cs","sk","Čeština"),
("531","cs","cy","Czech"),
("532","cs","da","Czech"),
("533","cs","el","Τσεχικά"),
("534","cs","eo","Czech"),
("535","cs","et","Czech"),
("536","cs","eu","Czech"),
("537","cs","fa","Czech"),
("538","cs","fi","Tsekki"),
("539","cs","ga","Czech"),
("540","cs","he","צ\'כית"),
("541","cs","hi","Czech"),
("542","cs","hr","češki"),
("543","cs","hu","Cseh"),
("544","cs","hy","Czech"),
("545","cs","id","Czech"),
("546","cs","is","Czech"),
("547","cs","it","Ceco"),
("548","cs","ja","チェコ語"),
("549","cs","ko","체코슬로바키아어"),
("550","cs","ku","Czech"),
("551","cs","lv","Czech"),
("552","cs","lt","Czech"),
("553","cs","mk","Czech"),
("554","cs","mt","Czech"),
("555","cs","mn","Czech"),
("556","cs","ne","Czech"),
("557","cs","nl","Tsjechisch"),
("558","cs","no","Czech"),
("559","cs","pa","Czech"),
("560","cs","pl","Czeski"),
("561","cs","pt-pt","Tcheco"),
("562","cs","pt-br","Tcheco"),
("563","cs","qu","Czech"),
("564","cs","ro","Cehă"),
("565","cs","ru","Чешский"),
("566","cs","sl","Češčina"),
("567","cs","so","Czech"),
("568","cs","sq","Czech"),
("569","cs","sr","чешки"),
("570","cs","sv","Tjeckiska"),
("571","cs","ta","Czech"),
("572","cs","th","เช็ก"),
("573","cs","tr","Çekçe"),
("574","cs","uk","Czech"),
("575","cs","ur","Czech"),
("576","cs","uz","Czech"),
("577","cs","vi","Czech"),
("578","cs","yi","Czech"),
("579","cs","zh-hans","捷克语"),
("580","cs","zu","Czech"),
("581","cs","zh-hant","捷克語"),
("582","cs","ms","Czech"),
("583","cs","gl","Czech"),
("584","cs","bn","Czech"),
("585","cs","az","Czech"),
("586","sk","en","Slovak"),
("587","sk","es","Eslavo"),
("588","sk","de","Slowakisch"),
("589","sk","fr","Slave"),
("590","sk","ar","السلافية"),
("591","sk","bs","Slovak"),
("592","sk","bg","Словашки"),
("593","sk","ca","Slovak"),
("594","sk","cs","Slovenština"),
("595","sk","sk","Slovenčina"),
("596","sk","cy","Slovak"),
("597","sk","da","Slovak"),
("598","sk","el","Σλαβική"),
("599","sk","eo","Slovak"),
("600","sk","et","Slovak"),
("601","sk","eu","Slovak"),
("602","sk","fa","Slovak"),
("603","sk","fi","Slaavi"),
("604","sk","ga","Slovak"),
("605","sk","he","סלאבית"),
("606","sk","hi","Slovak"),
("607","sk","hr","Slovački"),
("608","sk","hu","Szlovák"),
("609","sk","hy","Slovak"),
("610","sk","id","Slovak"),
("611","sk","is","Slovak"),
("612","sk","it","Slavo"),
("613","sk","ja","スラヴ語派"),
("614","sk","ko","슬라브어"),
("615","sk","ku","Slovak"),
("616","sk","lv","Slovak"),
("617","sk","lt","Slovak"),
("618","sk","mk","Slovak"),
("619","sk","mt","Slovak"),
("620","sk","mn","Slovak"),
("621","sk","ne","Slovak"),
("622","sk","nl","Slavisch"),
("623","sk","no","Slovak"),
("624","sk","pa","Slovak"),
("625","sk","pl","Słowacki"),
("626","sk","pt-pt","Eslavo"),
("627","sk","pt-br","Eslavo"),
("628","sk","qu","Slovak"),
("629","sk","ro","Slavă"),
("630","sk","ru","Славянский"),
("631","sk","sl","Slovaščina"),
("632","sk","so","Slovak"),
("633","sk","sq","Slovak"),
("634","sk","sr","словачки"),
("635","sk","sv","Slavisk"),
("636","sk","ta","Slovak"),
("637","sk","th","สลาวิก"),
("638","sk","tr","Slav dili"),
("639","sk","uk","Slovak"),
("640","sk","ur","Slovak"),
("641","sk","uz","Slovak"),
("642","sk","vi","Slovak"),
("643","sk","yi","Slovak"),
("644","sk","zh-hans","斯拉夫语"),
("645","sk","zu","Slovak"),
("646","sk","zh-hant","斯拉夫語"),
("647","sk","ms","Slovak"),
("648","sk","gl","Slovak"),
("649","sk","bn","Slovak"),
("650","sk","az","Slovak"),
("651","cy","en","Welsh"),
("652","cy","es","Galés"),
("653","cy","de","Walisisch"),
("654","cy","fr","Gallois"),
("655","cy","ar","الولزية"),
("656","cy","bs","Welsh"),
("657","cy","bg","Уелски"),
("658","cy","ca","Welsh"),
("659","cy","cs","Velšský"),
("660","cy","sk","Welština"),
("661","cy","cy","Cymraeg"),
("662","cy","da","Welsh"),
("663","cy","el","Oυαλικά"),
("664","cy","eo","Welsh"),
("665","cy","et","Welsh"),
("666","cy","eu","Welsh"),
("667","cy","fa","Welsh"),
("668","cy","fi","Kymri"),
("669","cy","ga","Welsh"),
("670","cy","he","וולשית"),
("671","cy","hi","Welsh"),
("672","cy","hr","Velški"),
("673","cy","hu","Vels"),
("674","cy","hy","Welsh"),
("675","cy","id","Welsh"),
("676","cy","is","Welsh"),
("677","cy","it","Gallese"),
("678","cy","ja","ウェールズ語"),
("679","cy","ko","웨일즈어"),
("680","cy","ku","Welsh"),
("681","cy","lv","Welsh"),
("682","cy","lt","Welsh"),
("683","cy","mk","Welsh"),
("684","cy","mt","Welsh"),
("685","cy","mn","Welsh"),
("686","cy","ne","Welsh"),
("687","cy","nl","Welsh"),
("688","cy","no","Welsh"),
("689","cy","pa","Welsh"),
("690","cy","pl","Walijski"),
("691","cy","pt-pt","Galês"),
("692","cy","pt-br","Galês"),
("693","cy","qu","Welsh"),
("694","cy","ro","Galeză"),
("695","cy","ru","Валлийский"),
("696","cy","sl","Welsh"),
("697","cy","so","Welsh"),
("698","cy","sq","Welsh"),
("699","cy","sr","велшки"),
("700","cy","sv","Walesiska"),
("701","cy","ta","Welsh"),
("702","cy","th","เวลช์"),
("703","cy","tr","Galce"),
("704","cy","uk","Welsh"),
("705","cy","ur","Welsh"),
("706","cy","uz","Welsh"),
("707","cy","vi","Welsh"),
("708","cy","yi","Welsh"),
("709","cy","zh-hans","威尔士语"),
("710","cy","zu","Welsh"),
("711","cy","zh-hant","威爾士語"),
("712","cy","ms","Welsh"),
("713","cy","gl","Welsh"),
("714","cy","bn","Welsh"),
("715","cy","az","Welsh"),
("716","da","en","Danish"),
("717","da","es","Danés"),
("718","da","de","Dänisch"),
("719","da","fr","Danois"),
("720","da","ar","الدانماركية"),
("721","da","bs","Danish"),
("722","da","bg","Датски"),
("723","da","ca","Danish"),
("724","da","cs","Dánský"),
("725","da","sk","Dánčina"),
("726","da","cy","Danish"),
("727","da","da","Dansk"),
("728","da","el","Δανέζικα"),
("729","da","eo","Danish"),
("730","da","et","Danish"),
("731","da","eu","Danish"),
("732","da","fa","Danish"),
("733","da","fi","Tanska"),
("734","da","ga","Danish"),
("735","da","he","דנית"),
("736","da","hi","Danish"),
("737","da","hr","Danski"),
("738","da","hu","Dán"),
("739","da","hy","Danish"),
("740","da","id","Danish"),
("741","da","is","Danish"),
("742","da","it","Danese"),
("743","da","ja","デンマーク語"),
("744","da","ko","덴마크어"),
("745","da","ku","Danish"),
("746","da","lv","Danish"),
("747","da","lt","Danish"),
("748","da","mk","Danish"),
("749","da","mt","Danish"),
("750","da","mn","Danish"),
("751","da","ne","Danish"),
("752","da","nl","Deens"),
("753","da","no","Danish"),
("754","da","pa","Danish"),
("755","da","pl","Duński"),
("756","da","pt-pt","Dinamarquês"),
("757","da","pt-br","Dinamarquês"),
("758","da","qu","Danish"),
("759","da","ro","Daneză"),
("760","da","ru","Датский"),
("761","da","sl","Danščina"),
("762","da","so","Danish"),
("763","da","sq","Danish"),
("764","da","sr","дански"),
("765","da","sv","Danska"),
("766","da","ta","Danish"),
("767","da","th","เดนมาร์ก"),
("768","da","tr","Danca"),
("769","da","uk","Danish"),
("770","da","ur","Danish"),
("771","da","uz","Danish"),
("772","da","vi","Danish"),
("773","da","yi","Danish"),
("774","da","zh-hans","丹麦语"),
("775","da","zu","Danish"),
("776","da","zh-hant","丹麥語"),
("777","da","ms","Danish"),
("778","da","gl","Danish"),
("779","da","bn","Danish"),
("780","da","az","Danish"),
("781","el","en","Greek"),
("782","el","es","Griego"),
("783","el","de","Griechisch"),
("784","el","fr","Grec moderne"),
("785","el","ar","اليونانية"),
("786","el","bs","Greek"),
("787","el","bg","Гръцки"),
("788","el","ca","Greek"),
("789","el","cs","Řečtina"),
("790","el","sk","Gréčtina"),
("791","el","cy","Greek"),
("792","el","da","Greek"),
("793","el","el","Ελληνικά"),
("794","el","eo","Greek"),
("795","el","et","Greek"),
("796","el","eu","Greek"),
("797","el","fa","Greek"),
("798","el","fi","Kreikka"),
("799","el","ga","Greek"),
("800","el","he","יוונית"),
("801","el","hi","Greek"),
("802","el","hr","Grčki"),
("803","el","hu","Görög"),
("804","el","hy","Greek"),
("805","el","id","Greek"),
("806","el","is","Greek"),
("807","el","it","Greco"),
("808","el","ja","ギリシア語"),
("809","el","ko","그리스어"),
("810","el","ku","Greek"),
("811","el","lv","Greek"),
("812","el","lt","Greek"),
("813","el","mk","Greek"),
("814","el","mt","Greek"),
("815","el","mn","Greek"),
("816","el","ne","Greek"),
("817","el","nl","Grieks"),
("818","el","no","Gresk"),
("819","el","pa","Greek"),
("820","el","pl","Grecki"),
("821","el","pt-pt","Grego"),
("822","el","pt-br","Grego"),
("823","el","qu","Greek"),
("824","el","ro","Greacă"),
("825","el","ru","Греческий"),
("826","el","sl","Greek"),
("827","el","so","Greek"),
("828","el","sq","Greek"),
("829","el","sr","грчки"),
("830","el","sv","Grekiska"),
("831","el","ta","Greek"),
("832","el","th","กรีก"),
("833","el","tr","Yunanca"),
("834","el","uk","Greek"),
("835","el","ur","Greek"),
("836","el","uz","Greek"),
("837","el","vi","Greek"),
("838","el","yi","Greek"),
("839","el","zh-hans","希腊语"),
("840","el","zu","Greek"),
("841","el","zh-hant","希臘語"),
("842","el","ms","Greek"),
("843","el","gl","Greek"),
("844","el","bn","Greek"),
("845","el","az","Greek"),
("846","eo","en","Esperanto"),
("847","eo","es","Esperanto"),
("848","eo","de","Esperanto"),
("849","eo","fr","Espéranto"),
("850","eo","ar","الاسبرانتو"),
("851","eo","bs","Esperanto"),
("852","eo","bg","Есперанто"),
("853","eo","ca","Esperanto"),
("854","eo","cs","Esperanto"),
("855","eo","sk","Esperanto"),
("856","eo","cy","Esperanto"),
("857","eo","da","Esperanto"),
("858","eo","el","Εσπεράντο"),
("859","eo","eo","Esperanta"),
("860","eo","et","Esperanto"),
("861","eo","eu","Esperanto"),
("862","eo","fa","Esperanto"),
("863","eo","fi","Esperanto"),
("864","eo","ga","Esperanto"),
("865","eo","he","אספרנטו"),
("866","eo","hi","Esperanto"),
("867","eo","hr","Esperanto"),
("868","eo","hu","Eszperantó"),
("869","eo","hy","Esperanto"),
("870","eo","id","Esperanto"),
("871","eo","is","Esperanto"),
("872","eo","it","Esperanto"),
("873","eo","ja","エスペラント語"),
("874","eo","ko","에스페란토어"),
("875","eo","ku","Esperanto"),
("876","eo","lv","Esperanto"),
("877","eo","lt","Esperanto"),
("878","eo","mk","Esperanto"),
("879","eo","mt","Esperanto"),
("880","eo","mn","Esperanto"),
("881","eo","ne","Esperanto"),
("882","eo","nl","Esperanto"),
("883","eo","no","Esperanto"),
("884","eo","pa","Esperanto"),
("885","eo","pl","Esperanto"),
("886","eo","pt-pt","Esperanto"),
("887","eo","pt-br","Esperanto"),
("888","eo","qu","Esperanto"),
("889","eo","ro","Esperanto"),
("890","eo","ru","Эсперанто"),
("891","eo","sl","Esperanto"),
("892","eo","so","Esperanto"),
("893","eo","sq","Esperanto"),
("894","eo","sr","есперанто"),
("895","eo","sv","Esperanto"),
("896","eo","ta","Esperanto"),
("897","eo","th","เอสเปอรันโต"),
("898","eo","tr","Esperanto"),
("899","eo","uk","Esperanto"),
("900","eo","ur","Esperanto"),
("901","eo","uz","Esperanto"),
("902","eo","vi","Esperanto"),
("903","eo","yi","Esperanto"),
("904","eo","zh-hans","世界语"),
("905","eo","zu","Esperanto"),
("906","eo","zh-hant","世界語"),
("907","eo","ms","Esperanto"),
("908","eo","gl","Esperanto"),
("909","eo","bn","Esperanto"),
("910","eo","az","Esperanto"),
("911","et","en","Estonian"),
("912","et","es","Estonio"),
("913","et","de","Estnisch"),
("914","et","fr","Estonien"),
("915","et","ar","الأستونية"),
("916","et","bs","Estonian"),
("917","et","bg","Естонски"),
("918","et","ca","Estonian"),
("919","et","cs","Estonština"),
("920","et","sk","Estónčina"),
("921","et","cy","Estonian"),
("922","et","da","Estonian"),
("923","et","el","Εσθονικά"),
("924","et","eo","Estonian"),
("925","et","et","Eesti"),
("926","et","eu","Estonian"),
("927","et","fa","Estonian"),
("928","et","fi","Eesti"),
("929","et","ga","Estonian"),
("930","et","he","אסטונית"),
("931","et","hi","Estonian"),
("932","et","hr","Estonski"),
("933","et","hu","észt"),
("934","et","hy","Estonian"),
("935","et","id","Estonian"),
("936","et","is","Estonian"),
("937","et","it","Estone"),
("938","et","ja","エストニア語"),
("939","et","ko","에스토니아어"),
("940","et","ku","Estonian"),
("941","et","lv","Estonian"),
("942","et","lt","Estonian"),
("943","et","mk","Estonian"),
("944","et","mt","Estonian"),
("945","et","mn","Estonian"),
("946","et","ne","Estonian"),
("947","et","nl","Ests"),
("948","et","no","Estonian"),
("949","et","pa","Estonian"),
("950","et","pl","Estoński"),
("951","et","pt-pt","Estoniano"),
("952","et","pt-br","Estoniano"),
("953","et","qu","Estonian"),
("954","et","ro","Estoniană"),
("955","et","ru","Эстонский"),
("956","et","sl","Estonščina"),
("957","et","so","Estonian"),
("958","et","sq","Estonian"),
("959","et","sr","естонски"),
("960","et","sv","Estniska"),
("961","et","ta","Estonian"),
("962","et","th","เอสโตเนียน"),
("963","et","tr","Estonya dili"),
("964","et","uk","Estonian"),
("965","et","ur","Estonian"),
("966","et","uz","Estonian"),
("967","et","vi","Estonian"),
("968","et","yi","Estonian"),
("969","et","zh-hans","爱沙尼亚语"),
("970","et","zu","Estonian"),
("971","et","zh-hant","愛沙尼亞語"),
("972","et","ms","Estonian"),
("973","et","gl","Estonian"),
("974","et","bn","Estonian"),
("975","et","az","Estonian"),
("976","eu","en","Basque"),
("977","eu","es","Euskera"),
("978","eu","de","Baskisch"),
("979","eu","fr","Basque"),
("980","eu","ar","لغة الباسك"),
("981","eu","bs","Basque"),
("982","eu","bg","Баски"),
("983","eu","ca","Basque"),
("984","eu","cs","Basque"),
("985","eu","sk","Baskičtina"),
("986","eu","cy","Basque"),
("987","eu","da","Basque"),
("988","eu","el","Βασκικά"),
("989","eu","eo","Basque"),
("990","eu","et","Basque"),
("991","eu","eu","Euskara"),
("992","eu","fa","Basque"),
("993","eu","fi","Baski"),
("994","eu","ga","Basque"),
("995","eu","he","בסקית"),
("996","eu","hi","Basque"),
("997","eu","hr","Baskijski"),
("998","eu","hu","Baszk"),
("999","eu","hy","Basque"),
("1000","eu","id","Basque"),
("1001","eu","is","Basque"),
("1002","eu","it","Basco"),
("1003","eu","ja","バスク語"),
("1004","eu","ko","바스크어"),
("1005","eu","ku","Basque"),
("1006","eu","lv","Basque"),
("1007","eu","lt","Basque"),
("1008","eu","mk","Basque"),
("1009","eu","mt","Basque"),
("1010","eu","mn","Basque"),
("1011","eu","ne","Basque"),
("1012","eu","nl","Baskisch"),
("1013","eu","no","Basque"),
("1014","eu","pa","Basque"),
("1015","eu","pl","Baskijski"),
("1016","eu","pt-pt","Basco"),
("1017","eu","pt-br","Basco"),
("1018","eu","qu","Basque"),
("1019","eu","ro","Bască"),
("1020","eu","ru","Баскский"),
("1021","eu","sl","Baskovščina"),
("1022","eu","so","Basque"),
("1023","eu","sq","Basque"),
("1024","eu","sr","баскијски"),
("1025","eu","sv","Baskiska"),
("1026","eu","ta","Basque"),
("1027","eu","th","บาสค์"),
("1028","eu","tr","Bask dili"),
("1029","eu","uk","Basque"),
("1030","eu","ur","Basque"),
("1031","eu","uz","Basque"),
("1032","eu","vi","Basque"),
("1033","eu","yi","Basque"),
("1034","eu","zh-hans","巴斯克语"),
("1035","eu","zu","Basque"),
("1036","eu","zh-hant","巴斯克語"),
("1037","eu","ms","Basque"),
("1038","eu","gl","Basque"),
("1039","eu","bn","Basque"),
("1040","eu","az","Basque"),
("1041","fa","en","Persian"),
("1042","fa","es","Persa"),
("1043","fa","de","Persisch"),
("1044","fa","fr","Perse"),
("1045","fa","ar","الفارسية"),
("1046","fa","bs","Persian"),
("1047","fa","bg","Персийски"),
("1048","fa","ca","Persian"),
("1049","fa","cs","Perský"),
("1050","fa","sk","Perzština"),
("1051","fa","cy","Persian"),
("1052","fa","da","Persian"),
("1053","fa","el","Περσικά"),
("1054","fa","eo","Persian"),
("1055","fa","et","Persian"),
("1056","fa","eu","Persian"),
("1057","fa","fa","فارسی"),
("1058","fa","fi","Persia"),
("1059","fa","ga","Persian"),
("1060","fa","he","פרסית"),
("1061","fa","hi","Persian"),
("1062","fa","hr","Perzijski"),
("1063","fa","hu","Perzsa"),
("1064","fa","hy","Persian"),
("1065","fa","id","Persian"),
("1066","fa","is","Persian"),
("1067","fa","it","Persiano"),
("1068","fa","ja","ペルシア語"),
("1069","fa","ko","페르시아어"),
("1070","fa","ku","Persian"),
("1071","fa","lv","Persian"),
("1072","fa","lt","Persian"),
("1073","fa","mk","Persian"),
("1074","fa","mt","Persian"),
("1075","fa","mn","Persian"),
("1076","fa","ne","Persian"),
("1077","fa","nl","Perzisch"),
("1078","fa","no","Persisk"),
("1079","fa","pa","Persian"),
("1080","fa","pl","Perski"),
("1081","fa","pt-pt","Persa"),
("1082","fa","pt-br","Persa"),
("1083","fa","qu","Persian"),
("1084","fa","ro","Persană"),
("1085","fa","ru","Персидский"),
("1086","fa","sl","Perzijski"),
("1087","fa","so","Persian"),
("1088","fa","sq","Persian"),
("1089","fa","sr","персијски"),
("1090","fa","sv","Persiska"),
("1091","fa","ta","Persian"),
("1092","fa","th","เปอร์เซียน"),
("1093","fa","tr","Farsça"),
("1094","fa","uk","Persian"),
("1095","fa","ur","Persian"),
("1096","fa","uz","Persian"),
("1097","fa","vi","Persian"),
("1098","fa","yi","Persian"),
("1099","fa","zh-hans","波斯语"),
("1100","fa","zu","Persian"),
("1101","fa","zh-hant","波斯語"),
("1102","fa","ms","Persian"),
("1103","fa","gl","Persian"),
("1104","fa","bn","Persian"),
("1105","fa","az","Persian"),
("1106","fi","en","Finnish"),
("1107","fi","es","Finlandés"),
("1108","fi","de","Finnisch"),
("1109","fi","fr","Finnois"),
("1110","fi","ar","الفنلندية"),
("1111","fi","bs","Finnish"),
("1112","fi","bg","Фински"),
("1113","fi","ca","Finnish"),
("1114","fi","cs","Finský"),
("1115","fi","sk","Fínština"),
("1116","fi","cy","Finnish"),
("1117","fi","da","Finnish"),
("1118","fi","el","Φινλανδικά"),
("1119","fi","eo","Finnish"),
("1120","fi","et","Finnish"),
("1121","fi","eu","Finnish"),
("1122","fi","fa","Finnish"),
("1123","fi","fi","Suomi"),
("1124","fi","ga","Finnish"),
("1125","fi","he","פינית"),
("1126","fi","hi","Finnish"),
("1127","fi","hr","Finski"),
("1128","fi","hu","Finn"),
("1129","fi","hy","Finnish"),
("1130","fi","id","Finnish"),
("1131","fi","is","Finnish"),
("1132","fi","it","Finlandese"),
("1133","fi","ja","フィンランド語"),
("1134","fi","ko","핀란드어"),
("1135","fi","ku","Finnish"),
("1136","fi","lv","Finnish"),
("1137","fi","lt","Finnish"),
("1138","fi","mk","Finnish"),
("1139","fi","mt","Finnish"),
("1140","fi","mn","Finnish"),
("1141","fi","ne","Finnish"),
("1142","fi","nl","Fins"),
("1143","fi","no","Finsk"),
("1144","fi","pa","Finnish"),
("1145","fi","pl","Fiński"),
("1146","fi","pt-pt","Finlandês"),
("1147","fi","pt-br","Finlandês"),
("1148","fi","qu","Finnish"),
("1149","fi","ro","Finlandeză"),
("1150","fi","ru","Финский"),
("1151","fi","sl","Finski"),
("1152","fi","so","Finnish"),
("1153","fi","sq","Finnish"),
("1154","fi","sr","фински"),
("1155","fi","sv","Finska"),
("1156","fi","ta","Finnish"),
("1157","fi","th","ฟินนิช"),
("1158","fi","tr","Fince"),
("1159","fi","uk","Finnish"),
("1160","fi","ur","Finnish"),
("1161","fi","uz","Finnish"),
("1162","fi","vi","Finnish"),
("1163","fi","yi","Finnish"),
("1164","fi","zh-hans","芬兰语"),
("1165","fi","zu","Finnish"),
("1166","fi","zh-hant","芬蘭語"),
("1167","fi","ms","Finnish"),
("1168","fi","gl","Finnish"),
("1169","fi","bn","Finnish"),
("1170","fi","az","Finnish"),
("1171","ga","en","Irish"),
("1172","ga","es","Irlandés"),
("1173","ga","de","Irisch"),
("1174","ga","fr","Irlandais"),
("1175","ga","ar","الأيرلندية"),
("1176","ga","bs","Irish"),
("1177","ga","bg","Ирландски"),
("1178","ga","ca","Irish"),
("1179","ga","cs","Irský"),
("1180","ga","sk","Írština"),
("1181","ga","cy","Irish"),
("1182","ga","da","Irish"),
("1183","ga","el","Ιρλανδικά"),
("1184","ga","eo","Irish"),
("1185","ga","et","Irish"),
("1186","ga","eu","Irish"),
("1187","ga","fa","Irish"),
("1188","ga","fi","Iiri"),
("1189","ga","ga","Gaeilge"),
("1190","ga","he","אירית"),
("1191","ga","hi","Irish"),
("1192","ga","hr","Irski"),
("1193","ga","hu","ír"),
("1194","ga","hy","Irish"),
("1195","ga","id","Irish"),
("1196","ga","is","Irish"),
("1197","ga","it","Irlandese"),
("1198","ga","ja","アイルランド語"),
("1199","ga","ko","아일랜드어"),
("1200","ga","ku","Irish"),
("1201","ga","lv","Irish"),
("1202","ga","lt","Irish"),
("1203","ga","mk","Irish"),
("1204","ga","mt","Irish"),
("1205","ga","mn","Irish"),
("1206","ga","ne","Irish"),
("1207","ga","nl","Iers"),
("1208","ga","no","Irish"),
("1209","ga","pa","Irish"),
("1210","ga","pl","Irlandzki"),
("1211","ga","pt-pt","Irlandês"),
("1212","ga","pt-br","Irlandês"),
("1213","ga","qu","Irish"),
("1214","ga","ro","Irlandeză"),
("1215","ga","ru","Ирландский"),
("1216","ga","sl","Irski"),
("1217","ga","so","Irish"),
("1218","ga","sq","Irish"),
("1219","ga","sr","ирски"),
("1220","ga","sv","Irländska"),
("1221","ga","ta","Irish"),
("1222","ga","th","ไอริช"),
("1223","ga","tr","İrlanda dili"),
("1224","ga","uk","Irish"),
("1225","ga","ur","Irish"),
("1226","ga","uz","Irish"),
("1227","ga","vi","Irish"),
("1228","ga","yi","Irish"),
("1229","ga","zh-hans","爱尔兰语"),
("1230","ga","zu","Irish"),
("1231","ga","zh-hant","愛爾蘭語"),
("1232","ga","ms","Irish"),
("1233","ga","gl","Irish"),
("1234","ga","bn","Irish"),
("1235","ga","az","Irish"),
("1236","he","en","Hebrew"),
("1237","he","es","Hebreo"),
("1238","he","de","Hebräisch"),
("1239","he","fr","Hébreu"),
("1240","he","ar","العبرية"),
("1241","he","bs","Hebrew"),
("1242","he","bg","Иврит"),
("1243","he","ca","Hebrew"),
("1244","he","cs","Hebrejština"),
("1245","he","sk","Hebrejčina"),
("1246","he","cy","Hebrew"),
("1247","he","da","Hebrew"),
("1248","he","el","Εβραϊκά"),
("1249","he","eo","Hebrew"),
("1250","he","et","Hebrew"),
("1251","he","eu","Hebrew"),
("1252","he","fa","Hebrew"),
("1253","he","fi","Heprea"),
("1254","he","ga","Hebrew"),
("1255","he","he","עברית"),
("1256","he","hi","Hebrew"),
("1257","he","hr","Hebrejski"),
("1258","he","hu","Héber"),
("1259","he","hy","Hebrew"),
("1260","he","id","Hebrew"),
("1261","he","is","Hebrew"),
("1262","he","it","Ebraico"),
("1263","he","ja","ヘブライ語"),
("1264","he","ko","히브리어"),
("1265","he","ku","Hebrew"),
("1266","he","lv","Hebrew"),
("1267","he","lt","Hebrew"),
("1268","he","mk","Hebrew"),
("1269","he","mt","Hebrew"),
("1270","he","mn","Hebrew"),
("1271","he","ne","Hebrew"),
("1272","he","nl","Hebreeuws"),
("1273","he","no","Hebraisk"),
("1274","he","pa","Hebrew"),
("1275","he","pl","Hebrajski"),
("1276","he","pt-pt","Hebraico"),
("1277","he","pt-br","Hebraico"),
("1278","he","qu","Hebrew"),
("1279","he","ro","Ebraică"),
("1280","he","ru","Иврит"),
("1281","he","sl","Hebrejščina"),
("1282","he","so","Hebrew"),
("1283","he","sq","Hebrew"),
("1284","he","sr","Хебрејски"),
("1285","he","sv","Hebreiska"),
("1286","he","ta","Hebrew"),
("1287","he","th","ฮิบรู"),
("1288","he","tr","İbranice"),
("1289","he","uk","Hebrew"),
("1290","he","ur","Hebrew"),
("1291","he","uz","Hebrew"),
("1292","he","vi","Hebrew"),
("1293","he","yi","Hebrew"),
("1294","he","zh-hans","希伯来语"),
("1295","he","zu","Hebrew"),
("1296","he","zh-hant","希伯來語"),
("1297","he","ms","Hebrew"),
("1298","he","gl","Hebrew"),
("1299","he","bn","Hebrew"),
("1300","he","az","Hebrew"),
("1301","hi","en","Hindi"),
("1302","hi","es","Hindi"),
("1303","hi","de","Hindi"),
("1304","hi","fr","Hindi"),
("1305","hi","ar","الهندية"),
("1306","hi","bs","Hindi"),
("1307","hi","bg","Хинди"),
("1308","hi","ca","Hindi"),
("1309","hi","cs","Hindština"),
("1310","hi","sk","Hindčina"),
("1311","hi","cy","Hindi"),
("1312","hi","da","Hindi"),
("1313","hi","el","Ινδικά"),
("1314","hi","eo","Hindi"),
("1315","hi","et","Hindi"),
("1316","hi","eu","Hindi"),
("1317","hi","fa","Hindi"),
("1318","hi","fi","Hindi"),
("1319","hi","ga","Hindi"),
("1320","hi","he","הודית"),
("1321","hi","hi","हिन्दी"),
("1322","hi","hr","Hindski"),
("1323","hi","hu","Hindi"),
("1324","hi","hy","Hindi"),
("1325","hi","id","Hindi"),
("1326","hi","is","Hindi"),
("1327","hi","it","Hindi"),
("1328","hi","ja","ヒンディー語"),
("1329","hi","ko","힌두어"),
("1330","hi","ku","Hindi"),
("1331","hi","lv","Hindi"),
("1332","hi","lt","Hindi"),
("1333","hi","mk","Hindi"),
("1334","hi","mt","Hindi"),
("1335","hi","mn","Hindi"),
("1336","hi","ne","Hindi"),
("1337","hi","nl","Hindi"),
("1338","hi","no","Hindi"),
("1339","hi","pa","Hindi"),
("1340","hi","pl","Hindi"),
("1341","hi","pt-pt","Hindi"),
("1342","hi","pt-br","Hindi"),
("1343","hi","qu","Hindi"),
("1344","hi","ro","Hindi"),
("1345","hi","ru","Хинди"),
("1346","hi","sl","Hindi"),
("1347","hi","so","Hindi"),
("1348","hi","sq","Hindi"),
("1349","hi","sr","хинди"),
("1350","hi","sv","Hindi"),
("1351","hi","ta","Hindi"),
("1352","hi","th","ฮินดิ"),
("1353","hi","tr","Hintçe"),
("1354","hi","uk","Hindi"),
("1355","hi","ur","Hindi"),
("1356","hi","uz","Hindi"),
("1357","hi","vi","Hindi"),
("1358","hi","yi","Hindi"),
("1359","hi","zh-hans","印地语"),
("1360","hi","zu","Hindi"),
("1361","hi","zh-hant","印地語"),
("1362","hi","ms","Hindi"),
("1363","hi","gl","Hindi"),
("1364","hi","bn","Hindi"),
("1365","hi","az","Hindi"),
("1366","hr","en","Croatian"),
("1367","hr","es","Croata"),
("1368","hr","de","Kroatisch"),
("1369","hr","fr","Croate"),
("1370","hr","ar","الكرواتية"),
("1371","hr","bs","Croatian"),
("1372","hr","bg","Хърватски"),
("1373","hr","ca","Croatian"),
("1374","hr","cs","Chorvatský"),
("1375","hr","sk","Chorvátština"),
("1376","hr","cy","Croatian"),
("1377","hr","da","Croatian"),
("1378","hr","el","Κροατικά"),
("1379","hr","eo","Croatian"),
("1380","hr","et","Croatian"),
("1381","hr","eu","Croatian"),
("1382","hr","fa","Croatian"),
("1383","hr","fi","Kroatia"),
("1384","hr","ga","Croatian"),
("1385","hr","he","קרוטאית"),
("1386","hr","hi","Croatian"),
("1387","hr","hr","Hrvatski"),
("1388","hr","hu","Horvát"),
("1389","hr","hy","Croatian"),
("1390","hr","id","Croatian"),
("1391","hr","is","Croatian"),
("1392","hr","it","Croato"),
("1393","hr","ja","クロアチア語"),
("1394","hr","ko","크로아시아어"),
("1395","hr","ku","Croatian"),
("1396","hr","lv","Croatian"),
("1397","hr","lt","Croatian"),
("1398","hr","mk","Croatian"),
("1399","hr","mt","Croatian"),
("1400","hr","mn","Croatian"),
("1401","hr","ne","Croatian"),
("1402","hr","nl","Kroatisch"),
("1403","hr","no","Kroatisk"),
("1404","hr","pa","Croatian"),
("1405","hr","pl","Chorwacki"),
("1406","hr","pt-pt","Croata"),
("1407","hr","pt-br","Croata"),
("1408","hr","qu","Croatian"),
("1409","hr","ro","Croată"),
("1410","hr","ru","Хорватский"),
("1411","hr","sl","Hrvaški"),
("1412","hr","so","Croatian"),
("1413","hr","sq","Croatian"),
("1414","hr","sr","хрватски"),
("1415","hr","sv","Kroatiska"),
("1416","hr","ta","Croatian"),
("1417","hr","th","โครเอเชีย"),
("1418","hr","tr","Hırvatça"),
("1419","hr","uk","Croatian"),
("1420","hr","ur","Croatian"),
("1421","hr","uz","Croatian"),
("1422","hr","vi","Croatian"),
("1423","hr","yi","Croatian"),
("1424","hr","zh-hans","克罗地亚语"),
("1425","hr","zu","Croatian"),
("1426","hr","zh-hant","克羅地亞語"),
("1427","hr","ms","Croatian"),
("1428","hr","gl","Croatian"),
("1429","hr","bn","Croatian"),
("1430","hr","az","Croatian"),
("1431","hu","en","Hungarian"),
("1432","hu","es","Húngaro"),
("1433","hu","de","Ungarisch"),
("1434","hu","fr","Hongrois"),
("1435","hu","ar","الهنغارية"),
("1436","hu","bs","Hungarian"),
("1437","hu","bg","Унгарски"),
("1438","hu","ca","Hungarian"),
("1439","hu","cs","Maďarština"),
("1440","hu","sk","Maďarčina"),
("1441","hu","cy","Hungarian"),
("1442","hu","da","Hungarian"),
("1443","hu","el","Ουγγρικά"),
("1444","hu","eo","Hungarian"),
("1445","hu","et","Hungarian"),
("1446","hu","eu","Hungarian"),
("1447","hu","fa","Hungarian"),
("1448","hu","fi","Unkari"),
("1449","hu","ga","Hungarian"),
("1450","hu","he","הונגרית"),
("1451","hu","hi","Hungarian"),
("1452","hu","hr","Mađarski"),
("1453","hu","hu","Magyar"),
("1454","hu","hy","Hungarian"),
("1455","hu","id","Hungarian"),
("1456","hu","is","Hungarian"),
("1457","hu","it","Ungherese"),
("1458","hu","ja","ハンガリー語"),
("1459","hu","ko","헝가리어"),
("1460","hu","ku","Hungarian"),
("1461","hu","lv","Hungarian"),
("1462","hu","lt","Hungarian"),
("1463","hu","mk","Hungarian"),
("1464","hu","mt","Hungarian"),
("1465","hu","mn","Hungarian"),
("1466","hu","ne","Hungarian"),
("1467","hu","nl","Hongaars"),
("1468","hu","no","Ungarsk"),
("1469","hu","pa","Hungarian"),
("1470","hu","pl","Węgierski"),
("1471","hu","pt-pt","Húngaro"),
("1472","hu","pt-br","Húngaro"),
("1473","hu","qu","Hungarian"),
("1474","hu","ro","Ungară"),
("1475","hu","ru","Венгерский"),
("1476","hu","sl","Madžarski"),
("1477","hu","so","Hungarian"),
("1478","hu","sq","Hungarian"),
("1479","hu","sr","мађарски"),
("1480","hu","sv","Ungerska"),
("1481","hu","ta","Hungarian"),
("1482","hu","th","ฮังการี"),
("1483","hu","tr","Macarca"),
("1484","hu","uk","Hungarian"),
("1485","hu","ur","Hungarian"),
("1486","hu","uz","Hungarian"),
("1487","hu","vi","Hungarian"),
("1488","hu","yi","Hungarian"),
("1489","hu","zh-hans","匈牙利语"),
("1490","hu","zu","Hungarian"),
("1491","hu","zh-hant","匈牙利語"),
("1492","hu","ms","Hungarian"),
("1493","hu","gl","Hungarian"),
("1494","hu","bn","Hungarian"),
("1495","hu","az","Hungarian"),
("1496","hy","en","Armenian"),
("1497","hy","es","Armenio"),
("1498","hy","de","Armenisch"),
("1499","hy","fr","Arménien"),
("1500","hy","ar","الأرمينية"),
("1501","hy","bs","Armenian"),
("1502","hy","bg","Арменски"),
("1503","hy","ca","Armenian"),
("1504","hy","cs","Arménský"),
("1505","hy","sk","Arménčina"),
("1506","hy","cy","Armenian"),
("1507","hy","da","Armenian"),
("1508","hy","el","Αρμένικα"),
("1509","hy","eo","Armenian"),
("1510","hy","et","Armenian"),
("1511","hy","eu","Armenian"),
("1512","hy","fa","Armenian"),
("1513","hy","fi","Armenia"),
("1514","hy","ga","Armenian"),
("1515","hy","he","ארמנית"),
("1516","hy","hi","Armenian"),
("1517","hy","hr","Armenski"),
("1518","hy","hu","örmény"),
("1519","hy","hy","Հայերեն"),
("1520","hy","id","Armenian"),
("1521","hy","is","Armenian"),
("1522","hy","it","Armeno"),
("1523","hy","ja","アルメニア語"),
("1524","hy","ko","아르메니아어"),
("1525","hy","ku","Armenian"),
("1526","hy","lv","Armenian"),
("1527","hy","lt","Armenian"),
("1528","hy","mk","Armenian"),
("1529","hy","mt","Armenian"),
("1530","hy","mn","Armenian"),
("1531","hy","ne","Armenian"),
("1532","hy","nl","Armeens"),
("1533","hy","no","Armensk"),
("1534","hy","pa","Armenian"),
("1535","hy","pl","Ormiański"),
("1536","hy","pt-pt","Arménio"),
("1537","hy","pt-br","Arménio"),
("1538","hy","qu","Armenian"),
("1539","hy","ro","Armeană"),
("1540","hy","ru","Армянский"),
("1541","hy","sl","Armenski"),
("1542","hy","so","Armenian"),
("1543","hy","sq","Armenian"),
("1544","hy","sr","јерменски"),
("1545","hy","sv","Armeniska"),
("1546","hy","ta","Armenian"),
("1547","hy","th","อาร์เมเนีย"),
("1548","hy","tr","Ermenice"),
("1549","hy","uk","Armenian"),
("1550","hy","ur","Armenian"),
("1551","hy","uz","Armenian"),
("1552","hy","vi","Armenian"),
("1553","hy","yi","Armenian"),
("1554","hy","zh-hans","亚美尼亚语"),
("1555","hy","zu","Armenian"),
("1556","hy","zh-hant","亞美尼亞語"),
("1557","hy","ms","Armenian"),
("1558","hy","gl","Armenian"),
("1559","hy","bn","Armenian"),
("1560","hy","az","Armenian"),
("1561","id","en","Indonesian"),
("1562","id","es","Indonesio"),
("1563","id","de","Indonesisch"),
("1564","id","fr","Indonésien"),
("1565","id","ar","الأندونيسية"),
("1566","id","bs","Indonesian"),
("1567","id","bg","Индонезийски"),
("1568","id","ca","Indonesian"),
("1569","id","cs","Indonéský"),
("1570","id","sk","Indonézčina"),
("1571","id","cy","Indonesian"),
("1572","id","da","Indonesian"),
("1573","id","el","Ινδονησιακά"),
("1574","id","eo","Indonesian"),
("1575","id","et","Indonesian"),
("1576","id","eu","Indonesian"),
("1577","id","fa","Indonesian"),
("1578","id","fi","Indonesia"),
("1579","id","ga","Indonesian"),
("1580","id","he","אינדונזית"),
("1581","id","hi","Indonesian"),
("1582","id","hr","Indonezijski"),
("1583","id","hu","Indonéz"),
("1584","id","hy","Indonesian"),
("1585","id","id","Indonesia"),
("1586","id","is","Indonesian"),
("1587","id","it","Indonesiano"),
("1588","id","ja","インドネシア語"),
("1589","id","ko","인도네시아어"),
("1590","id","ku","Indonesian"),
("1591","id","lv","Indonesian"),
("1592","id","lt","Indonesian"),
("1593","id","mk","Indonesian"),
("1594","id","mt","Indonesian"),
("1595","id","mn","Indonesian"),
("1596","id","ne","Indonesian"),
("1597","id","nl","Indonesisch"),
("1598","id","no","Indonesian"),
("1599","id","pa","Indonesian"),
("1600","id","pl","Indonezyjski"),
("1601","id","pt-pt","Indonésio"),
("1602","id","pt-br","Indonésio"),
("1603","id","qu","Indonesian"),
("1604","id","ro","Indoneziană"),
("1605","id","ru","Индонезийский"),
("1606","id","sl","Indonezijski"),
("1607","id","so","Indonesian"),
("1608","id","sq","Indonesian"),
("1609","id","sr","индонезијски"),
("1610","id","sv","Indonesiska"),
("1611","id","ta","Indonesian"),
("1612","id","th","อินโดนีเซีย"),
("1613","id","tr","Endonezya dili"),
("1614","id","uk","Indonesian"),
("1615","id","ur","Indonesian"),
("1616","id","uz","Indonesian"),
("1617","id","vi","Indonesian"),
("1618","id","yi","Indonesian"),
("1619","id","zh-hans","印度尼西亚语"),
("1620","id","zu","Indonesian"),
("1621","id","zh-hant","印尼語"),
("1622","id","ms","Indonesian"),
("1623","id","gl","Indonesian"),
("1624","id","bn","Indonesian"),
("1625","id","az","Indonesian"),
("1626","is","en","Icelandic"),
("1627","is","es","Islandés"),
("1628","is","de","Isländisch"),
("1629","is","fr","Islandais"),
("1630","is","ar","الأيسلاندية"),
("1631","is","bs","Icelandic"),
("1632","is","bg","Исландски"),
("1633","is","ca","Icelandic"),
("1634","is","cs","Islandský"),
("1635","is","sk","Islančina"),
("1636","is","cy","Icelandic"),
("1637","is","da","Icelandic"),
("1638","is","el","Ισλανδικά"),
("1639","is","eo","Icelandic"),
("1640","is","et","Icelandic"),
("1641","is","eu","Icelandic"),
("1642","is","fa","Icelandic"),
("1643","is","fi","Islanti"),
("1644","is","ga","Icelandic"),
("1645","is","he","איסלנדית"),
("1646","is","hi","Icelandic"),
("1647","is","hr","Islandski"),
("1648","is","hu","Izlandi"),
("1649","is","hy","Icelandic"),
("1650","is","id","Icelandic"),
("1651","is","is","Íslenska"),
("1652","is","it","Islandese"),
("1653","is","ja","アイスランド語"),
("1654","is","ko","아이슬랜드어"),
("1655","is","ku","Icelandic"),
("1656","is","lv","Icelandic"),
("1657","is","lt","Icelandic"),
("1658","is","mk","Icelandic"),
("1659","is","mt","Icelandic"),
("1660","is","mn","Icelandic"),
("1661","is","ne","Icelandic"),
("1662","is","nl","Ijslands"),
("1663","is","no","Islandsk"),
("1664","is","pa","Icelandic"),
("1665","is","pl","Islandzki"),
("1666","is","pt-pt","Islandês"),
("1667","is","pt-br","Islandês"),
("1668","is","qu","Icelandic"),
("1669","is","ro","Islandeză"),
("1670","is","ru","Исландский"),
("1671","is","sl","Islandski"),
("1672","is","so","Icelandic"),
("1673","is","sq","Icelandic"),
("1674","is","sr","исландски"),
("1675","is","sv","Isländska"),
("1676","is","ta","Icelandic"),
("1677","is","th","ไอซ์แลนด์"),
("1678","is","tr","İzlandaca"),
("1679","is","uk","Icelandic"),
("1680","is","ur","Icelandic"),
("1681","is","uz","Icelandic"),
("1682","is","vi","Icelandic"),
("1683","is","yi","Icelandic"),
("1684","is","zh-hans","冰岛语"),
("1685","is","zu","Icelandic"),
("1686","is","zh-hant","冰島語"),
("1687","is","ms","Icelandic"),
("1688","is","gl","Icelandic"),
("1689","is","bn","Icelandic"),
("1690","is","az","Icelandic"),
("1691","it","en","Italian"),
("1692","it","es","Italiano"),
("1693","it","de","Italienisch"),
("1694","it","fr","Italien"),
("1695","it","ar","الإيطالية"),
("1696","it","bs","Italian"),
("1697","it","bg","Италиански"),
("1698","it","ca","Italian"),
("1699","it","cs","Ital"),
("1700","it","sk","Taliančina"),
("1701","it","cy","Italian"),
("1702","it","da","Italian"),
("1703","it","el","Ιταλικά"),
("1704","it","eo","Italian"),
("1705","it","et","Italian"),
("1706","it","eu","Italian"),
("1707","it","fa","Italian"),
("1708","it","fi","Italia"),
("1709","it","ga","Italian"),
("1710","it","he","איטלקית"),
("1711","it","hi","Italian"),
("1712","it","hr","Talijanski"),
("1713","it","hu","Olasz"),
("1714","it","hy","Italian"),
("1715","it","id","Italian"),
("1716","it","is","Italian"),
("1717","it","it","Italiano"),
("1718","it","ja","イタリア語"),
("1719","it","ko","이태리어"),
("1720","it","ku","Italian"),
("1721","it","lv","Italian"),
("1722","it","lt","Italian"),
("1723","it","mk","Italian"),
("1724","it","mt","Italian"),
("1725","it","mn","Italian"),
("1726","it","ne","Italian"),
("1727","it","nl","Italiaans"),
("1728","it","no","Italiensk"),
("1729","it","pa","Italian"),
("1730","it","pl","Włoski"),
("1731","it","pt-pt","Italiano"),
("1732","it","pt-br","Italiano"),
("1733","it","qu","Italian"),
("1734","it","ro","Italiană"),
("1735","it","ru","Итальянский"),
("1736","it","sl","Italijanski"),
("1737","it","so","Italian"),
("1738","it","sq","Italian"),
("1739","it","sr","италијански"),
("1740","it","sv","Italienska"),
("1741","it","ta","Italian"),
("1742","it","th","อิตาลี"),
("1743","it","tr","İtalyanca"),
("1744","it","uk","Italian"),
("1745","it","ur","Italian"),
("1746","it","uz","Italian"),
("1747","it","vi","Italian"),
("1748","it","yi","Italian"),
("1749","it","zh-hans","意大利语"),
("1750","it","zu","Italian"),
("1751","it","zh-hant","義大利語"),
("1752","it","ms","Italian"),
("1753","it","gl","Italian"),
("1754","it","bn","Italian"),
("1755","it","az","Italian"),
("1756","ja","en","Japanese"),
("1757","ja","es","Japonés"),
("1758","ja","de","Japanisch"),
("1759","ja","fr","Japonais"),
("1760","ja","ar","اليابانية"),
("1761","ja","bs","Japanese"),
("1762","ja","bg","Японски"),
("1763","ja","ca","Japanese"),
("1764","ja","cs","Japonský"),
("1765","ja","sk","Japonština"),
("1766","ja","cy","Japanese"),
("1767","ja","da","Japanese"),
("1768","ja","el","Ιαπωνικά"),
("1769","ja","eo","Japanese"),
("1770","ja","et","Japanese"),
("1771","ja","eu","Japanese"),
("1772","ja","fa","Japanese"),
("1773","ja","fi","Japani"),
("1774","ja","ga","Japanese"),
("1775","ja","he","יפנית"),
("1776","ja","hi","Japanese"),
("1777","ja","hr","Japanski"),
("1778","ja","hu","Japán"),
("1779","ja","hy","Japanese"),
("1780","ja","id","Japanese"),
("1781","ja","is","Japanese"),
("1782","ja","it","Giapponese"),
("1783","ja","ja","日本語"),
("1784","ja","ko","일어"),
("1785","ja","ku","Japanese"),
("1786","ja","lv","Japanese"),
("1787","ja","lt","Japanese"),
("1788","ja","mk","Japanese"),
("1789","ja","mt","Japanese"),
("1790","ja","mn","Japanese"),
("1791","ja","ne","Japanese"),
("1792","ja","nl","Japans"),
("1793","ja","no","Japansk"),
("1794","ja","pa","Japanese"),
("1795","ja","pl","Japoński"),
("1796","ja","pt-pt","Japonês"),
("1797","ja","pt-br","Japonês"),
("1798","ja","qu","Japanese"),
("1799","ja","ro","Japoneză"),
("1800","ja","ru","Японский"),
("1801","ja","sl","Japonski"),
("1802","ja","so","Japanese"),
("1803","ja","sq","Japanese"),
("1804","ja","sr","јапански"),
("1805","ja","sv","Japanska"),
("1806","ja","ta","Japanese"),
("1807","ja","th","ญี่ปุ่น"),
("1808","ja","tr","Japonca"),
("1809","ja","uk","Japanese"),
("1810","ja","ur","Japanese"),
("1811","ja","uz","Japanese"),
("1812","ja","vi","Japanese"),
("1813","ja","yi","Japanese"),
("1814","ja","zh-hans","日语"),
("1815","ja","zu","Japanese"),
("1816","ja","zh-hant","日語"),
("1817","ja","ms","Japanese"),
("1818","ja","gl","Japanese"),
("1819","ja","bn","Japanese"),
("1820","ja","az","Japanese"),
("1821","ko","en","Korean"),
("1822","ko","es","Coreano"),
("1823","ko","de","Koreanisch"),
("1824","ko","fr","Coréen"),
("1825","ko","ar","الكورية"),
("1826","ko","bs","Korean"),
("1827","ko","bg","Корейски"),
("1828","ko","ca","Korean"),
("1829","ko","cs","Korejský"),
("1830","ko","sk","Kórejčina"),
("1831","ko","cy","Korean"),
("1832","ko","da","Korean"),
("1833","ko","el","Κορεάτικα"),
("1834","ko","eo","Korean"),
("1835","ko","et","Korean"),
("1836","ko","eu","Korean"),
("1837","ko","fa","Korean"),
("1838","ko","fi","Korea"),
("1839","ko","ga","Korean"),
("1840","ko","he","קוראנית"),
("1841","ko","hi","Korean"),
("1842","ko","hr","Korejski"),
("1843","ko","hu","Koreai"),
("1844","ko","hy","Korean"),
("1845","ko","id","Korean"),
("1846","ko","is","Korean"),
("1847","ko","it","Coreano"),
("1848","ko","ja","韓国語"),
("1849","ko","ko","한국어"),
("1850","ko","ku","Korean"),
("1851","ko","lv","Korean"),
("1852","ko","lt","Korean"),
("1853","ko","mk","Korean"),
("1854","ko","mt","Korean"),
("1855","ko","mn","Korean"),
("1856","ko","ne","Korean"),
("1857","ko","nl","Koreaans"),
("1858","ko","no","Koreanske"),
("1859","ko","pa","Korean"),
("1860","ko","pl","Koreański"),
("1861","ko","pt-pt","Coreano"),
("1862","ko","pt-br","Coreano"),
("1863","ko","qu","Korean"),
("1864","ko","ro","Coreană"),
("1865","ko","ru","Корейский"),
("1866","ko","sl","Korejski"),
("1867","ko","so","Korean"),
("1868","ko","sq","Korean"),
("1869","ko","sr","корејски"),
("1870","ko","sv","Koreanska"),
("1871","ko","ta","Korean"),
("1872","ko","th","เกาหลี"),
("1873","ko","tr","Kore dili"),
("1874","ko","uk","Korean"),
("1875","ko","ur","Korean"),
("1876","ko","uz","Korean"),
("1877","ko","vi","Korean"),
("1878","ko","yi","Korean"),
("1879","ko","zh-hans","韩语"),
("1880","ko","zu","Korean"),
("1881","ko","zh-hant","韓語"),
("1882","ko","ms","Korean"),
("1883","ko","gl","Korean"),
("1884","ko","bn","Korean"),
("1885","ko","az","Korean"),
("1886","ku","en","Kurdish"),
("1887","ku","es","Kurdo"),
("1888","ku","de","Kurdisch"),
("1889","ku","fr","Kurde"),
("1890","ku","ar","الكردية"),
("1891","ku","bs","Kurdish"),
("1892","ku","bg","Кюрдски"),
("1893","ku","ca","Kurdish"),
("1894","ku","cs","Kurdský"),
("1895","ku","sk","Kurdština"),
("1896","ku","cy","Kurdish"),
("1897","ku","da","Kurdish"),
("1898","ku","el","Κουρδικά"),
("1899","ku","eo","Kurdish"),
("1900","ku","et","Kurdish"),
("1901","ku","eu","Kurdish"),
("1902","ku","fa","Kurdish"),
("1903","ku","fi","Kurdi"),
("1904","ku","ga","Kurdish"),
("1905","ku","he","כורדית"),
("1906","ku","hi","Kurdish"),
("1907","ku","hr","Kurdski"),
("1908","ku","hu","Kurd"),
("1909","ku","hy","Kurdish"),
("1910","ku","id","Kurdish"),
("1911","ku","is","Kurdish"),
("1912","ku","it","Curdo"),
("1913","ku","ja","クルド語"),
("1914","ku","ko","쿠르드어"),
("1915","ku","ku","Kurdish"),
("1916","ku","lv","Kurdish"),
("1917","ku","lt","Kurdish"),
("1918","ku","mk","Kurdish"),
("1919","ku","mt","Kurdish"),
("1920","ku","mn","Kurdish"),
("1921","ku","ne","Kurdish"),
("1922","ku","nl","Koerdish"),
("1923","ku","no","Kurdisk"),
("1924","ku","pa","Kurdish"),
("1925","ku","pl","Kurdyjski"),
("1926","ku","pt-pt","Curdo"),
("1927","ku","pt-br","Curdo"),
("1928","ku","qu","Kurdish"),
("1929","ku","ro","Kurdă"),
("1930","ku","ru","Курдский"),
("1931","ku","sl","Kurdščina"),
("1932","ku","so","Kurdish"),
("1933","ku","sq","Kurdish"),
("1934","ku","sr","курдски"),
("1935","ku","sv","Kurdiska"),
("1936","ku","ta","Kurdish"),
("1937","ku","th","เคอร์ดิช"),
("1938","ku","tr","Kürtçe"),
("1939","ku","uk","Kurdish"),
("1940","ku","ur","Kurdish"),
("1941","ku","uz","Kurdish"),
("1942","ku","vi","Kurdish"),
("1943","ku","yi","Kurdish"),
("1944","ku","zh-hans","库尔德语"),
("1945","ku","zu","Kurdish"),
("1946","ku","zh-hant","庫爾德語"),
("1947","ku","ms","Kurdish"),
("1948","ku","gl","Kurdish"),
("1949","ku","bn","Kurdish"),
("1950","ku","az","Kurdish"),
("1951","lv","en","Latvian"),
("1952","lv","es","Letón"),
("1953","lv","de","Lettisch"),
("1954","lv","fr","Letton"),
("1955","lv","ar","اللاتفية"),
("1956","lv","bs","Latvian"),
("1957","lv","bg","Латвийски"),
("1958","lv","ca","Latvian"),
("1959","lv","cs","Lotyština"),
("1960","lv","sk","Lotyština"),
("1961","lv","cy","Latvian"),
("1962","lv","da","Latvian"),
("1963","lv","el","Λετονικά"),
("1964","lv","eo","Latvian"),
("1965","lv","et","Latvian"),
("1966","lv","eu","Latvian"),
("1967","lv","fa","Latvian"),
("1968","lv","fi","Latvia"),
("1969","lv","ga","Latvian"),
("1970","lv","he","לטבית"),
("1971","lv","hi","Latvian"),
("1972","lv","hr","Latvijski"),
("1973","lv","hu","Lett"),
("1974","lv","hy","Latvian"),
("1975","lv","id","Latvian"),
("1976","lv","is","Latvian"),
("1977","lv","it","Lettone"),
("1978","lv","ja","ラトビア語"),
("1979","lv","ko","라트비아어"),
("1980","lv","ku","Latvian"),
("1981","lv","lv","Latviešu"),
("1982","lv","lt","Latvian"),
("1983","lv","mk","Latvian"),
("1984","lv","mt","Latvian"),
("1985","lv","mn","Latvian"),
("1986","lv","ne","Latvian"),
("1987","lv","nl","Lets"),
("1988","lv","no","Latvisk"),
("1989","lv","pa","Latvian"),
("1990","lv","pl","łotewski"),
("1991","lv","pt-pt","Letão"),
("1992","lv","pt-br","Letão"),
("1993","lv","qu","Latvian"),
("1994","lv","ro","Letoniană"),
("1995","lv","ru","латышский"),
("1996","lv","sl","Latvijščina"),
("1997","lv","so","Latvian"),
("1998","lv","sq","Latvian"),
("1999","lv","sr","летонски"),
("2000","lv","sv","Lettiska"),
("2001","lv","ta","Latvian"),
("2002","lv","th","ลัตเวีย"),
("2003","lv","tr","Letonca"),
("2004","lv","uk","Latvian"),
("2005","lv","ur","Latvian"),
("2006","lv","uz","Latvian"),
("2007","lv","vi","Latvian"),
("2008","lv","yi","Latvian"),
("2009","lv","zh-hans","拉脱维亚语"),
("2010","lv","zu","Latvian"),
("2011","lv","zh-hant","拉脫維亞語"),
("2012","lv","ms","Latvian"),
("2013","lv","gl","Latvian"),
("2014","lv","bn","Latvian"),
("2015","lv","az","Latvian"),
("2016","lt","en","Lithuanian"),
("2017","lt","es","Lituano"),
("2018","lt","de","Litauisch"),
("2019","lt","fr","Lituanien"),
("2020","lt","ar","اللتوانية"),
("2021","lt","bs","Lithuanian"),
("2022","lt","bg","Литовски"),
("2023","lt","ca","Lithuanian"),
("2024","lt","cs","Litevský"),
("2025","lt","sk","Litovčina"),
("2026","lt","cy","Lithuanian"),
("2027","lt","da","Lithuanian"),
("2028","lt","el","Λιθουανικά"),
("2029","lt","eo","Lithuanian"),
("2030","lt","et","Lithuanian"),
("2031","lt","eu","Lithuanian"),
("2032","lt","fa","Lithuanian"),
("2033","lt","fi","Liettua"),
("2034","lt","ga","Lithuanian"),
("2035","lt","he","ליטאית"),
("2036","lt","hi","Lithuanian"),
("2037","lt","hr","Litavski"),
("2038","lt","hu","Litván"),
("2039","lt","hy","Lithuanian"),
("2040","lt","id","Lithuanian"),
("2041","lt","is","Lithuanian"),
("2042","lt","it","Lituano"),
("2043","lt","ja","リトアニア語"),
("2044","lt","ko","리투아니아어"),
("2045","lt","ku","Lithuanian"),
("2046","lt","lv","Lithuanian"),
("2047","lt","lt","Lietuvių"),
("2048","lt","mk","Lithuanian"),
("2049","lt","mt","Lithuanian"),
("2050","lt","mn","Lithuanian"),
("2051","lt","ne","Lithuanian"),
("2052","lt","nl","Litouws"),
("2053","lt","no","Litauisk"),
("2054","lt","pa","Lithuanian"),
("2055","lt","pl","Litewski"),
("2056","lt","pt-pt","Lituano"),
("2057","lt","pt-br","Lituano"),
("2058","lt","qu","Lithuanian"),
("2059","lt","ro","Lituaniană"),
("2060","lt","ru","Литовский"),
("2061","lt","sl","Litovščina"),
("2062","lt","so","Lithuanian"),
("2063","lt","sq","Lithuanian"),
("2064","lt","sr","литвански"),
("2065","lt","sv","Litauiska"),
("2066","lt","ta","Lithuanian"),
("2067","lt","th","ลิธัวเนีย"),
("2068","lt","tr","Litvanyaca"),
("2069","lt","uk","Lithuanian"),
("2070","lt","ur","Lithuanian"),
("2071","lt","uz","Lithuanian"),
("2072","lt","vi","Lithuanian"),
("2073","lt","yi","Lithuanian"),
("2074","lt","zh-hans","立陶宛语"),
("2075","lt","zu","Lithuanian"),
("2076","lt","zh-hant","立陶宛語"),
("2077","lt","ms","Lithuanian"),
("2078","lt","gl","Lithuanian"),
("2079","lt","bn","Lithuanian"),
("2080","lt","az","Lithuanian"),
("2081","mk","en","Macedonian"),
("2082","mk","es","Macedonio"),
("2083","mk","de","Mazedonisch"),
("2084","mk","fr","Macédonien"),
("2085","mk","ar","المقدونية"),
("2086","mk","bs","Macedonian"),
("2087","mk","bg","Македонски"),
("2088","mk","ca","Macedonian"),
("2089","mk","cs","Makedonský"),
("2090","mk","sk","Macedónština"),
("2091","mk","cy","Macedonian"),
("2092","mk","da","Macedonian"),
("2093","mk","el","Μακεδονικά"),
("2094","mk","eo","Macedonian"),
("2095","mk","et","Macedonian"),
("2096","mk","eu","Macedonian"),
("2097","mk","fa","Macedonian"),
("2098","mk","fi","Makedonia"),
("2099","mk","ga","Macedonian"),
("2100","mk","he","מקדונית"),
("2101","mk","hi","Macedonian"),
("2102","mk","hr","Makedonski"),
("2103","mk","hu","Macedón"),
("2104","mk","hy","Macedonian"),
("2105","mk","id","Macedonian"),
("2106","mk","is","Macedonian"),
("2107","mk","it","Macedone"),
("2108","mk","ja","マケドニア語"),
("2109","mk","ko","마케도니아어"),
("2110","mk","ku","Macedonian"),
("2111","mk","lv","Macedonian"),
("2112","mk","lt","Macedonian"),
("2113","mk","mk","македонски"),
("2114","mk","mt","Macedonian"),
("2115","mk","mn","Macedonian"),
("2116","mk","ne","Macedonian"),
("2117","mk","nl","Macedonisch"),
("2118","mk","no","Makedonsk"),
("2119","mk","pa","Macedonian"),
("2120","mk","pl","Macedoński"),
("2121","mk","pt-pt","Macedônio"),
("2122","mk","pt-br","Macedônio"),
("2123","mk","qu","Macedonian"),
("2124","mk","ro","Macedoniană"),
("2125","mk","ru","Македонский"),
("2126","mk","sl","Makedonski"),
("2127","mk","so","Macedonian"),
("2128","mk","sq","Macedonian"),
("2129","mk","sr","македонски"),
("2130","mk","sv","Makedonska"),
("2131","mk","ta","Macedonian"),
("2132","mk","th","มาซิโดเนีย"),
("2133","mk","tr","Makedonyaca"),
("2134","mk","uk","Macedonian"),
("2135","mk","ur","Macedonian"),
("2136","mk","uz","Macedonian"),
("2137","mk","vi","Macedonian"),
("2138","mk","yi","Macedonian"),
("2139","mk","zh-hans","马其顿语"),
("2140","mk","zu","Macedonian"),
("2141","mk","zh-hant","馬其頓語"),
("2142","mk","ms","Macedonian"),
("2143","mk","gl","Macedonian"),
("2144","mk","bn","Macedonian"),
("2145","mk","az","Macedonian"),
("2146","mt","en","Maltese"),
("2147","mt","es","Maltés"),
("2148","mt","de","Maltesisch"),
("2149","mt","fr","Maltais"),
("2150","mt","ar","المالطية"),
("2151","mt","bs","Maltese"),
("2152","mt","bg","Малтийски"),
("2153","mt","ca","Maltese"),
("2154","mt","cs","Maltština"),
("2155","mt","sk","Maltézština"),
("2156","mt","cy","Maltese"),
("2157","mt","da","Maltese"),
("2158","mt","el","Μαλτέζικα"),
("2159","mt","eo","Maltese"),
("2160","mt","et","Maltese"),
("2161","mt","eu","Maltese"),
("2162","mt","fa","Maltese"),
("2163","mt","fi","Malta"),
("2164","mt","ga","Maltese"),
("2165","mt","he","מלטזית"),
("2166","mt","hi","Maltese"),
("2167","mt","hr","Malteški"),
("2168","mt","hu","Máltai"),
("2169","mt","hy","Maltese"),
("2170","mt","id","Maltese"),
("2171","mt","is","Maltese"),
("2172","mt","it","Maltese"),
("2173","mt","ja","マルタ語"),
("2174","mt","ko","몰타어"),
("2175","mt","ku","Maltese"),
("2176","mt","lv","Maltese"),
("2177","mt","lt","Maltese"),
("2178","mt","mk","Maltese"),
("2179","mt","mt","Malti"),
("2180","mt","mn","Maltese"),
("2181","mt","ne","Maltese"),
("2182","mt","nl","Maltees"),
("2183","mt","no","Maltese"),
("2184","mt","pa","Maltese"),
("2185","mt","pl","Maltański"),
("2186","mt","pt-pt","Maltês"),
("2187","mt","pt-br","Maltês"),
("2188","mt","qu","Maltese"),
("2189","mt","ro","Malteză"),
("2190","mt","ru","Мальтийский"),
("2191","mt","sl","Malteški"),
("2192","mt","so","Maltese"),
("2193","mt","sq","Maltese"),
("2194","mt","sr","малтешки"),
("2195","mt","sv","Maltesiska"),
("2196","mt","ta","Maltese"),
("2197","mt","th","มอลทีส"),
("2198","mt","tr","Malta dili"),
("2199","mt","uk","Maltese"),
("2200","mt","ur","Maltese"),
("2201","mt","uz","Maltese"),
("2202","mt","vi","Maltese"),
("2203","mt","yi","Maltese"),
("2204","mt","zh-hans","马耳他语"),
("2205","mt","zu","Maltese"),
("2206","mt","zh-hant","馬爾他語"),
("2207","mt","ms","Maltese"),
("2208","mt","gl","Maltese"),
("2209","mt","bn","Maltese"),
("2210","mt","az","Maltese"),
("2211","mn","en","Mongolian"),
("2212","mn","es","Mongol"),
("2213","mn","de","Mongolisch"),
("2214","mn","fr","Mongol"),
("2215","mn","ar","المنغولية"),
("2216","mn","bs","Mongolian"),
("2217","mn","bg","Монголски"),
("2218","mn","ca","Mongolian"),
("2219","mn","cs","Mongolský"),
("2220","mn","sk","Mongolština"),
("2221","mn","cy","Mongolian"),
("2222","mn","da","Mongolian"),
("2223","mn","el","Μογγολικά"),
("2224","mn","eo","Mongolian"),
("2225","mn","et","Mongolian"),
("2226","mn","eu","Mongolian"),
("2227","mn","fa","Mongolian"),
("2228","mn","fi","Mongoli"),
("2229","mn","ga","Mongolian"),
("2230","mn","he","מונגולית"),
("2231","mn","hi","Mongolian"),
("2232","mn","hr","Mongolski"),
("2233","mn","hu","Mongol"),
("2234","mn","hy","Mongolian"),
("2235","mn","id","Mongolian"),
("2236","mn","is","Mongolian"),
("2237","mn","it","Mongolo"),
("2238","mn","ja","モンゴル語"),
("2239","mn","ko","몽골어"),
("2240","mn","ku","Mongolian"),
("2241","mn","lv","Mongolian"),
("2242","mn","lt","Mongolian"),
("2243","mn","mk","Mongolian"),
("2244","mn","mt","Mongolian"),
("2245","mn","mn","Mongolian"),
("2246","mn","ne","Mongolian"),
("2247","mn","nl","Mongools"),
("2248","mn","no","Mongolsk"),
("2249","mn","pa","Mongolian"),
("2250","mn","pl","Mongolski"),
("2251","mn","pt-pt","Mongolian"),
("2252","mn","pt-br","Mongolian"),
("2253","mn","qu","Mongolian"),
("2254","mn","ro","Mongoleză"),
("2255","mn","ru","Монгольский"),
("2256","mn","sl","Mongolski"),
("2257","mn","so","Mongolian"),
("2258","mn","sq","Mongolian"),
("2259","mn","sr","монголски"),
("2260","mn","sv","Mongoliska"),
("2261","mn","ta","Mongolian"),
("2262","mn","th","มองโกเลีย"),
("2263","mn","tr","Mongolca"),
("2264","mn","uk","Mongolian"),
("2265","mn","ur","Mongolian"),
("2266","mn","uz","Mongolian"),
("2267","mn","vi","Mongolian"),
("2268","mn","yi","Mongolian"),
("2269","mn","zh-hans","蒙古语"),
("2270","mn","zu","Mongolian"),
("2271","mn","zh-hant","蒙古語"),
("2272","mn","ms","Mongolian"),
("2273","mn","gl","Mongolian"),
("2274","mn","bn","Mongolian"),
("2275","mn","az","Mongolian"),
("2276","ne","en","Nepali"),
("2277","ne","es","Nepalí"),
("2278","ne","de","Nepali"),
("2279","ne","fr","Népalais"),
("2280","ne","ar","النيبالية"),
("2281","ne","bs","Nepali"),
("2282","ne","bg","Непалски"),
("2283","ne","ca","Nepali"),
("2284","ne","cs","Nepálský"),
("2285","ne","sk","Nepálčina"),
("2286","ne","cy","Nepali"),
("2287","ne","da","Nepali"),
("2288","ne","el","Νεπαλικά"),
("2289","ne","eo","Nepali"),
("2290","ne","et","Nepali"),
("2291","ne","eu","Nepali"),
("2292","ne","fa","Nepali"),
("2293","ne","fi","Nepali"),
("2294","ne","ga","Nepali"),
("2295","ne","he","נפאלית"),
("2296","ne","hi","Nepali"),
("2297","ne","hr","Nepali"),
("2298","ne","hu","Nepáli"),
("2299","ne","hy","Nepali"),
("2300","ne","id","Nepali"),
("2301","ne","is","Nepali"),
("2302","ne","it","Nepalese"),
("2303","ne","ja","ネパール語"),
("2304","ne","ko","네팔어"),
("2305","ne","ku","Nepali"),
("2306","ne","lv","Nepali"),
("2307","ne","lt","Nepali"),
("2308","ne","mk","Nepali"),
("2309","ne","mt","Nepali"),
("2310","ne","mn","Nepali"),
("2311","ne","ne","Nepali"),
("2312","ne","nl","Nepalees"),
("2313","ne","no","Nepali"),
("2314","ne","pa","Nepali"),
("2315","ne","pl","Nepalski"),
("2316","ne","pt-pt","Nepali"),
("2317","ne","pt-br","Nepali"),
("2318","ne","qu","Nepali"),
("2319","ne","ro","Nepaleză"),
("2320","ne","ru","Непальский"),
("2321","ne","sl","Nepalščina"),
("2322","ne","so","Nepali"),
("2323","ne","sq","Nepali"),
("2324","ne","sr","непалски"),
("2325","ne","sv","Nepalesiska"),
("2326","ne","ta","Nepali"),
("2327","ne","th","เนปาล"),
("2328","ne","tr","Nepal dili"),
("2329","ne","uk","Nepali"),
("2330","ne","ur","Nepali"),
("2331","ne","uz","Nepali"),
("2332","ne","vi","Nepali"),
("2333","ne","yi","Nepali"),
("2334","ne","zh-hans","尼泊尔语"),
("2335","ne","zu","Nepali"),
("2336","ne","zh-hant","尼泊爾語"),
("2337","ne","ms","Nepali"),
("2338","ne","gl","Nepali"),
("2339","ne","bn","Nepali"),
("2340","ne","az","Nepali"),
("2341","nl","en","Dutch"),
("2342","nl","es","Holandés"),
("2343","nl","de","Niederländisch"),
("2344","nl","fr","Néerlandais"),
("2345","nl","ar","الهولندية"),
("2346","nl","bs","Dutch"),
("2347","nl","bg","Холандски"),
("2348","nl","ca","Dutch"),
("2349","nl","cs","Holandský"),
("2350","nl","sk","Holandčina"),
("2351","nl","cy","Dutch"),
("2352","nl","da","Dutch"),
("2353","nl","el","Ολλανδικά"),
("2354","nl","eo","Dutch"),
("2355","nl","et","Dutch"),
("2356","nl","eu","Dutch"),
("2357","nl","fa","Dutch"),
("2358","nl","fi","Hollanti"),
("2359","nl","ga","Dutch"),
("2360","nl","he","הולנדית"),
("2361","nl","hi","Dutch"),
("2362","nl","hr","Nizozemski"),
("2363","nl","hu","Holland"),
("2364","nl","hy","Dutch"),
("2365","nl","id","Dutch"),
("2366","nl","is","Dutch"),
("2367","nl","it","Olandese"),
("2368","nl","ja","オランダ語"),
("2369","nl","ko","화란어"),
("2370","nl","ku","Dutch"),
("2371","nl","lv","Dutch"),
("2372","nl","lt","Dutch"),
("2373","nl","mk","Dutch"),
("2374","nl","mt","Dutch"),
("2375","nl","mn","Dutch"),
("2376","nl","ne","Dutch"),
("2377","nl","nl","Nederlands"),
("2378","nl","no","Nederlandsk"),
("2379","nl","pa","Dutch"),
("2380","nl","pl","Holenderski"),
("2381","nl","pt-pt","Holandês"),
("2382","nl","pt-br","Holandês"),
("2383","nl","qu","Dutch"),
("2384","nl","ro","Olaneză"),
("2385","nl","ru","Голландский"),
("2386","nl","sl","Nizozemščina"),
("2387","nl","so","Dutch"),
("2388","nl","sq","Dutch"),
("2389","nl","sr","холандски"),
("2390","nl","sv","Nederländska"),
("2391","nl","ta","Dutch"),
("2392","nl","th","ดัตช์"),
("2393","nl","tr","Hollandaca"),
("2394","nl","uk","Dutch"),
("2395","nl","ur","Dutch"),
("2396","nl","uz","Dutch"),
("2397","nl","vi","Dutch"),
("2398","nl","yi","Dutch"),
("2399","nl","zh-hans","荷兰语"),
("2400","nl","zu","Dutch"),
("2401","nl","zh-hant","荷蘭語"),
("2402","nl","ms","Dutch"),
("2403","nl","gl","Dutch"),
("2404","nl","bn","Dutch"),
("2405","nl","az","Dutch"),
("2406","no","en","Norwegian Bokmål"),
("2407","no","es","Bokmål"),
("2408","no","de","Norwegisch (Buchsprache)"),
("2409","no","fr","Norvégien Bokmål"),
("2410","no","ar","البوكمالية النرويجية"),
("2411","no","bs","Norwegian Bokmål"),
("2412","no","bg","Норвежки книжовен"),
("2413","no","ca","Norwegian Bokmål"),
("2414","no","cs","Norwegian bokmål"),
("2415","no","sk","Nórsky jazyk Bokmål"),
("2416","no","cy","Norwegian Bokmål"),
("2417","no","da","Norwegian Bokmål"),
("2418","no","el","Νορβηγικά"),
("2419","no","eo","Norwegian Bokmål"),
("2420","no","et","Norwegian Bokmål"),
("2421","no","eu","Norwegian Bokmål"),
("2422","no","fa","Norwegian Bokmål"),
("2423","no","fi","Kirjanorja"),
("2424","no","ga","Norwegian Bokmål"),
("2425","no","he","נורווגית"),
("2426","no","hi","Norwegian Bokmål"),
("2427","no","hr","Književni norveški"),
("2428","no","hu","Norvég bokmål"),
("2429","no","hy","Norwegian Bokmål"),
("2430","no","id","Norwegian Bokmål"),
("2431","no","is","Norwegian Bokmål"),
("2432","no","it","Norvegese Bokmål"),
("2433","no","ja","ノルウェー・ブークモール"),
("2434","no","ko","노르웨이 보크말어"),
("2435","no","ku","Norwegian Bokmål"),
("2436","no","lv","Norwegian Bokmål"),
("2437","no","lt","Norwegian Bokmål"),
("2438","no","mk","Norwegian Bokmål"),
("2439","no","mt","Norwegian Bokmål"),
("2440","no","mn","Norwegian Bokmål"),
("2441","no","ne","Norwegian Bokmål"),
("2442","no","nl","Noors Bokmål"),
("2443","no","no","Norsk bokmål"),
("2444","no","pa","Norwegian Bokmål"),
("2445","no","pl","Norweski bokmål"),
("2446","no","pt-pt","Norueguês"),
("2447","no","pt-br","Norueguês"),
("2448","no","qu","Norwegian Bokmål"),
("2449","no","ro","Bokmål (norvegiană)"),
("2450","no","ru","Норвежский букмол"),
("2451","no","sl","Knjižna norveščina"),
("2452","no","so","Norwegian Bokmål"),
("2453","no","sq","Norwegian Bokmål"),
("2454","no","sr","Норвешки бокмал"),
("2455","no","sv","Norskt Bokmål"),
("2456","no","ta","Norwegian Bokmål"),
("2457","no","th","นอร์วิเจียนบอกมาล"),
("2458","no","tr","Bokmal Norveç dili"),
("2459","no","uk","Norwegian Bokmål"),
("2460","no","ur","Norwegian Bokmål"),
("2461","no","uz","Norwegian Bokmål"),
("2462","no","vi","Norwegian Bokmål"),
("2463","no","yi","Norwegian Bokmål"),
("2464","no","zh-hans","挪威布克莫尔语"),
("2465","no","zu","Norwegian Bokmål"),
("2466","no","zh-hant","挪威布克莫爾語"),
("2467","no","ms","Norwegian Bokmål"),
("2468","no","gl","Norwegian Bokmål"),
("2469","no","bn","Norwegian Bokmål"),
("2470","no","az","Norwegian Bokmål"),
("2471","pa","en","Punjabi"),
("2472","pa","es","Panyabí"),
("2473","pa","de","Pandschabi"),
("2474","pa","fr","Panjabi"),
("2475","pa","ar","البنجابية"),
("2476","pa","bs","Punjabi"),
("2477","pa","bg","Панджабски"),
("2478","pa","ca","Punjabi"),
("2479","pa","cs","Punjabi"),
("2480","pa","sk","Pandžábčina"),
("2481","pa","cy","Punjabi"),
("2482","pa","da","Punjabi"),
("2483","pa","el","Παντζάμπι"),
("2484","pa","eo","Punjabi"),
("2485","pa","et","Punjabi"),
("2486","pa","eu","Punjabi"),
("2487","pa","fa","Punjabi"),
("2488","pa","fi","Pandzabi"),
("2489","pa","ga","Punjabi"),
("2490","pa","he","פנג\'אבית"),
("2491","pa","hi","Punjabi"),
("2492","pa","hr","Pendžabljanin"),
("2493","pa","hu","Pandzsábi"),
("2494","pa","hy","Punjabi"),
("2495","pa","id","Punjabi"),
("2496","pa","is","Punjabi"),
("2497","pa","it","Panjabi"),
("2498","pa","ja","パンジャーブ語"),
("2499","pa","ko","펀자브어"),
("2500","pa","ku","Punjabi"),
("2501","pa","lv","Punjabi"),
("2502","pa","lt","Punjabi"),
("2503","pa","mk","Punjabi"),
("2504","pa","mt","Punjabi"),
("2505","pa","mn","Punjabi"),
("2506","pa","ne","Punjabi"),
("2507","pa","nl","Punjabi"),
("2508","pa","no","Punjabi"),
("2509","pa","pa","Punjabi"),
("2510","pa","pl","Pendżabi"),
("2511","pa","pt-pt","Panjabi"),
("2512","pa","pt-br","Panjabi"),
("2513","pa","qu","Punjabi"),
("2514","pa","ro","Punjabi"),
("2515","pa","ru","Панджаби"),
("2516","pa","sl","Pandžabščina"),
("2517","pa","so","Punjabi"),
("2518","pa","sq","Punjabi"),
("2519","pa","sr","панџаби"),
("2520","pa","sv","Punjabi"),
("2521","pa","ta","Punjabi"),
("2522","pa","th","ปัญจาบ"),
("2523","pa","tr","Pencapça"),
("2524","pa","uk","Punjabi"),
("2525","pa","ur","Punjabi"),
("2526","pa","uz","Punjabi"),
("2527","pa","vi","Punjabi"),
("2528","pa","yi","Punjabi"),
("2529","pa","zh-hans","旁遮普语"),
("2530","pa","zu","Punjabi"),
("2531","pa","zh-hant","旁遮普語"),
("2532","pa","ms","Punjabi"),
("2533","pa","gl","Punjabi"),
("2534","pa","bn","Punjabi"),
("2535","pa","az","Punjabi"),
("2536","pl","en","Polish"),
("2537","pl","es","Polaco"),
("2538","pl","de","Polnisch"),
("2539","pl","fr","Polonais"),
("2540","pl","ar","البولندية"),
("2541","pl","bs","Polish"),
("2542","pl","bg","Полски"),
("2543","pl","ca","Polish"),
("2544","pl","cs","Polský"),
("2545","pl","sk","Polština"),
("2546","pl","cy","Polish"),
("2547","pl","da","Polish"),
("2548","pl","el","Πολωνικά"),
("2549","pl","eo","Polish"),
("2550","pl","et","Polish"),
("2551","pl","eu","Polish"),
("2552","pl","fa","Polish"),
("2553","pl","fi","Puola"),
("2554","pl","ga","Polish"),
("2555","pl","he","פולנית"),
("2556","pl","hi","Polish"),
("2557","pl","hr","Poljski"),
("2558","pl","hu","Lengyel"),
("2559","pl","hy","Polish"),
("2560","pl","id","Polish"),
("2561","pl","is","Polish"),
("2562","pl","it","Polacco"),
("2563","pl","ja","ポーランド語"),
("2564","pl","ko","폴란드어"),
("2565","pl","ku","Polish"),
("2566","pl","lv","Polish"),
("2567","pl","lt","Polish"),
("2568","pl","mk","Polish"),
("2569","pl","mt","Polish"),
("2570","pl","mn","Polish"),
("2571","pl","ne","Polish"),
("2572","pl","nl","Pools"),
("2573","pl","no","Polsk"),
("2574","pl","pa","Polish"),
("2575","pl","pl","Polski"),
("2576","pl","pt-pt","Polonês"),
("2577","pl","pt-br","Polonês"),
("2578","pl","qu","Polish"),
("2579","pl","ro","Poloneză"),
("2580","pl","ru","Польский"),
("2581","pl","sl","Poljski"),
("2582","pl","so","Polish"),
("2583","pl","sq","Polish"),
("2584","pl","sr","пољски"),
("2585","pl","sv","Polska"),
("2586","pl","ta","Polish"),
("2587","pl","th","โปแลนด์"),
("2588","pl","tr","Polonyaca"),
("2589","pl","uk","Polish"),
("2590","pl","ur","Polish"),
("2591","pl","uz","Polish"),
("2592","pl","vi","Polish"),
("2593","pl","yi","Polish"),
("2594","pl","zh-hans","波兰语"),
("2595","pl","zu","Polish"),
("2596","pl","zh-hant","波蘭語"),
("2597","pl","ms","Polish"),
("2598","pl","gl","Polish"),
("2599","pl","bn","Polish"),
("2600","pl","az","Polish"),
("2601","pt-pt","en","Portuguese (Portugal)"),
("2602","pt-pt","es","Portugués, Portugal"),
("2603","pt-pt","de","Portugiesisch, Portugal"),
("2604","pt-pt","fr","Portugais - du Portugal"),
("2605","pt-pt","ar","البرتغالية ، البرتغال"),
("2606","pt-pt","bs","Portuguese, Portugal"),
("2607","pt-pt","bg","Португалски (Португалия)"),
("2608","pt-pt","ca","Portuguese, Portugal"),
("2609","pt-pt","cs","Portugalština ( Portugalsko)"),
("2610","pt-pt","sk","Portugalština"),
("2611","pt-pt","cy","Portuguese, Portugal"),
("2612","pt-pt","da","Portuguese, Portugal"),
("2613","pt-pt","el","Πορτογαλικά"),
("2614","pt-pt","eo","Portuguese, Portugal"),
("2615","pt-pt","et","Portuguese, Portugal"),
("2616","pt-pt","eu","Portuguese, Portugal"),
("2617","pt-pt","fa","Portuguese, Portugal"),
("2618","pt-pt","fi","Portugali"),
("2619","pt-pt","ga","Portuguese, Portugal"),
("2620","pt-pt","he","פורטוגזית"),
("2621","pt-pt","hi","Portuguese, Portugal"),
("2622","pt-pt","hr","Portugalski (Portugal)"),
("2623","pt-pt","hu","Portugál"),
("2624","pt-pt","hy","Portuguese, Portugal"),
("2625","pt-pt","id","Portuguese, Portugal"),
("2626","pt-pt","is","Portuguese, Portugal"),
("2627","pt-pt","it","Portoghese, Portogallo"),
("2628","pt-pt","ja","ポルトガル語"),
("2629","pt-pt","ko","포르투갈 포르투갈어"),
("2630","pt-pt","ku","Portuguese, Portugal"),
("2631","pt-pt","lv","Portuguese, Portugal"),
("2632","pt-pt","lt","Portuguese, Portugal"),
("2633","pt-pt","mk","Portuguese, Portugal"),
("2634","pt-pt","mt","Portuguese, Portugal"),
("2635","pt-pt","mn","Portuguese, Portugal"),
("2636","pt-pt","ne","Portuguese, Portugal"),
("2637","pt-pt","nl","Portugees, Portugal"),
("2638","pt-pt","no","Portugisisk (Portugal)"),
("2639","pt-pt","pa","Portuguese, Portugal"),
("2640","pt-pt","pl","Portugalski, Portugalia"),
("2641","pt-pt","pt-pt","Português"),
("2642","pt-pt","pt-br","Português"),
("2643","pt-pt","qu","Portuguese, Portugal"),
("2644","pt-pt","ro","Portugheză (Portugalia)"),
("2645","pt-pt","ru","Португальский, Португалия"),
("2646","pt-pt","sl","Portugalščina ( Portugalska )"),
("2647","pt-pt","so","Portuguese, Portugal"),
("2648","pt-pt","sq","Portuguese, Portugal"),
("2649","pt-pt","sr","Португалски (Португалија)"),
("2650","pt-pt","sv","Portugisiska, Portugal"),
("2651","pt-pt","ta","Portuguese, Portugal"),
("2652","pt-pt","th","โปรตุเกส"),
("2653","pt-pt","tr","Portekizce, Portekiz"),
("2654","pt-pt","uk","Portuguese, Portugal"),
("2655","pt-pt","ur","Portuguese, Portugal"),
("2656","pt-pt","uz","Portuguese, Portugal"),
("2657","pt-pt","vi","Portuguese, Portugal"),
("2658","pt-pt","yi","Portuguese, Portugal"),
("2659","pt-pt","zh-hans","葡萄牙语（葡萄牙）"),
("2660","pt-pt","zu","Portuguese, Portugal"),
("2661","pt-pt","zh-hant","葡萄牙語（葡萄牙）"),
("2662","pt-pt","ms","Portuguese, Portugal"),
("2663","pt-pt","gl","Portuguese, Portugal"),
("2664","pt-pt","bn","Portuguese, Portugal"),
("2665","pt-pt","az","Portuguese, Portugal"),
("2666","pt-br","en","Portuguese (Brazil)"),
("2667","pt-br","es","Portugués, Brasil"),
("2668","pt-br","de","Portugiesisch, Brasilien"),
("2669","pt-br","fr","Portugais - du Brésil"),
("2670","pt-br","ar","البرتغالية ،البرازيل"),
("2671","pt-br","bs","Portuguese, Brazil"),
("2672","pt-br","bg","Португалски (Бразилия)"),
("2673","pt-br","ca","Portuguese, Brazil"),
("2674","pt-br","cs","Portugalština ( Brazílie)"),
("2675","pt-br","sk","Brazílska Portugalština"),
("2676","pt-br","cy","Portuguese, Brazil"),
("2677","pt-br","da","Portuguese, Brazil"),
("2678","pt-br","el","Πορτογαλικά Βραζιλίας"),
("2679","pt-br","eo","Portuguese, Brazil"),
("2680","pt-br","et","Portuguese, Brazil"),
("2681","pt-br","eu","Portuguese, Brazil"),
("2682","pt-br","fa","Portuguese, Brazil"),
("2683","pt-br","fi","Brasilian portugali"),
("2684","pt-br","ga","Portuguese, Brazil"),
("2685","pt-br","he","פורטוגזית - ברזיל"),
("2686","pt-br","hi","Portuguese, Brazil"),
("2687","pt-br","hr","Portugalski (Brazil)"),
("2688","pt-br","hu","Brazil"),
("2689","pt-br","hy","Portuguese, Brazil"),
("2690","pt-br","id","Portuguese, Brazil"),
("2691","pt-br","is","Portuguese, Brazil"),
("2692","pt-br","it","Portoghese, Brasile"),
("2693","pt-br","ja","ポルトガル語（ブラジル）"),
("2694","pt-br","ko","브라질 포르투갈어"),
("2695","pt-br","ku","Portuguese, Brazil"),
("2696","pt-br","lv","Portuguese, Brazil"),
("2697","pt-br","lt","Portuguese, Brazil"),
("2698","pt-br","mk","Portuguese, Brazil"),
("2699","pt-br","mt","Portuguese, Brazil"),
("2700","pt-br","mn","Portuguese, Brazil"),
("2701","pt-br","ne","Portuguese, Brazil"),
("2702","pt-br","nl","Portugees, Brazilië"),
("2703","pt-br","no","Portugisisk (Brasil)"),
("2704","pt-br","pa","Portuguese, Brazil"),
("2705","pt-br","pl","Portugalski, Brazylia"),
("2706","pt-br","pt-pt","Português"),
("2707","pt-br","pt-br","Português"),
("2708","pt-br","qu","Portuguese, Brazil"),
("2709","pt-br","ro","Portugheză (Brazilia)"),
("2710","pt-br","ru","Португальский, Бразилия"),
("2711","pt-br","sl","Portugalščina ( Brazilija )"),
("2712","pt-br","so","Portuguese, Brazil"),
("2713","pt-br","sq","Portuguese, Brazil"),
("2714","pt-br","sr","Португалски (Бразил)"),
("2715","pt-br","sv","Portugisiska, Brasilien"),
("2716","pt-br","ta","Portuguese, Brazil"),
("2717","pt-br","th","โปรตุเกสบราซิล"),
("2718","pt-br","tr","Portekizce, Brezilya"),
("2719","pt-br","uk","Portuguese, Brazil"),
("2720","pt-br","ur","Portuguese, Brazil"),
("2721","pt-br","uz","Portuguese, Brazil"),
("2722","pt-br","vi","Portuguese, Brazil"),
("2723","pt-br","yi","Portuguese, Brazil"),
("2724","pt-br","zh-hans","葡萄牙语（巴西）"),
("2725","pt-br","zu","Portuguese, Brazil"),
("2726","pt-br","zh-hant","葡萄牙語（巴西）"),
("2727","pt-br","ms","Portuguese, Brazil"),
("2728","pt-br","gl","Portuguese, Brazil"),
("2729","pt-br","bn","Portuguese, Brazil"),
("2730","pt-br","az","Portuguese, Brazil"),
("2731","qu","en","Quechua"),
("2732","qu","es","Quechua"),
("2733","qu","de","Quechua"),
("2734","qu","fr","Quechua"),
("2735","qu","ar","الكويتشوا"),
("2736","qu","bs","Quechua"),
("2737","qu","bg","Кечуа"),
("2738","qu","ca","Quechua"),
("2739","qu","cs","Quechua"),
("2740","qu","sk","Jazyk Quechua"),
("2741","qu","cy","Quechua"),
("2742","qu","da","Quechua"),
("2743","qu","el","Κέτσουα"),
("2744","qu","eo","Quechua"),
("2745","qu","et","Quechua"),
("2746","qu","eu","Quechua"),
("2747","qu","fa","Quechua"),
("2748","qu","fi","Ketsua"),
("2749","qu","ga","Quechua"),
("2750","qu","he","קצ\'ואה"),
("2751","qu","hi","Quechua"),
("2752","qu","hr","Quechua"),
("2753","qu","hu","Quechua"),
("2754","qu","hy","Quechua"),
("2755","qu","id","Quechua"),
("2756","qu","is","Quechua"),
("2757","qu","it","Quechua"),
("2758","qu","ja","ケチュア語"),
("2759","qu","ko","케추아어"),
("2760","qu","ku","Quechua"),
("2761","qu","lv","Quechua"),
("2762","qu","lt","Quechua"),
("2763","qu","mk","Quechua"),
("2764","qu","mt","Quechua"),
("2765","qu","mn","Quechua"),
("2766","qu","ne","Quechua"),
("2767","qu","nl","Quechua"),
("2768","qu","no","Quechua"),
("2769","qu","pa","Quechua"),
("2770","qu","pl","Keczua"),
("2771","qu","pt-pt","Quechua"),
("2772","qu","pt-br","Quechua"),
("2773","qu","qu","Quechua"),
("2774","qu","ro","Quechuană"),
("2775","qu","ru","Кечуа"),
("2776","qu","sl","Quechua"),
("2777","qu","so","Quechua"),
("2778","qu","sq","Quechua"),
("2779","qu","sr","Кечуа"),
("2780","qu","sv","Quechua"),
("2781","qu","ta","Quechua"),
("2782","qu","th","คิวชัว"),
("2783","qu","tr","Quechua dili"),
("2784","qu","uk","Quechua"),
("2785","qu","ur","Quechua"),
("2786","qu","uz","Quechua"),
("2787","qu","vi","Quechua"),
("2788","qu","yi","Quechua"),
("2789","qu","zh-hans","盖丘亚语"),
("2790","qu","zu","Quechua"),
("2791","qu","zh-hant","蓋丘亞語"),
("2792","qu","ms","Quechua"),
("2793","qu","gl","Quechua"),
("2794","qu","bn","Quechua"),
("2795","qu","az","Quechua"),
("2796","ro","en","Romanian"),
("2797","ro","es","Rumano"),
("2798","ro","de","Rumänisch"),
("2799","ro","fr","Roumain"),
("2800","ro","ar","الرومانية"),
("2801","ro","bs","Romanian"),
("2802","ro","bg","Румънски"),
("2803","ro","ca","Romanian"),
("2804","ro","cs","Rumunština"),
("2805","ro","sk","Rumunčina"),
("2806","ro","cy","Romanian"),
("2807","ro","da","Romanian"),
("2808","ro","el","Ρουμανικά"),
("2809","ro","eo","Romanian"),
("2810","ro","et","Romanian"),
("2811","ro","eu","Romanian"),
("2812","ro","fa","Romanian"),
("2813","ro","fi","Romania"),
("2814","ro","ga","Romanian"),
("2815","ro","he","רומנית"),
("2816","ro","hi","Romanian"),
("2817","ro","hr","Rumunjski"),
("2818","ro","hu","Román"),
("2819","ro","hy","Romanian"),
("2820","ro","id","Romanian"),
("2821","ro","is","Romanian"),
("2822","ro","it","Rumeno"),
("2823","ro","ja","ルーマニア語"),
("2824","ro","ko","로마니아어"),
("2825","ro","ku","Romanian"),
("2826","ro","lv","Romanian"),
("2827","ro","lt","Romanian"),
("2828","ro","mk","Romanian"),
("2829","ro","mt","Romanian"),
("2830","ro","mn","Romanian"),
("2831","ro","ne","Romanian"),
("2832","ro","nl","Roemeens"),
("2833","ro","no","Rumensk"),
("2834","ro","pa","Romanian"),
("2835","ro","pl","Rumuński"),
("2836","ro","pt-pt","Romeno"),
("2837","ro","pt-br","Romeno"),
("2838","ro","qu","Romanian"),
("2839","ro","ro","Română"),
("2840","ro","ru","Румынский"),
("2841","ro","sl","Romunščina"),
("2842","ro","so","Romanian"),
("2843","ro","sq","Romanian"),
("2844","ro","sr","румунски"),
("2845","ro","sv","Rumänska"),
("2846","ro","ta","Romanian"),
("2847","ro","th","โรมาเนีย"),
("2848","ro","tr","Rumence"),
("2849","ro","uk","Romanian"),
("2850","ro","ur","Romanian"),
("2851","ro","uz","Romanian"),
("2852","ro","vi","Romanian"),
("2853","ro","yi","Romanian"),
("2854","ro","zh-hans","罗马尼亚语"),
("2855","ro","zu","Romanian"),
("2856","ro","zh-hant","羅馬尼亞語"),
("2857","ro","ms","Romanian"),
("2858","ro","gl","Romanian"),
("2859","ro","bn","Romanian"),
("2860","ro","az","Romanian"),
("2861","ru","en","Russian"),
("2862","ru","es","Ruso"),
("2863","ru","de","Russisch"),
("2864","ru","fr","Russe"),
("2865","ru","ar","الروسية"),
("2866","ru","bs","Russian"),
("2867","ru","bg","Руски"),
("2868","ru","ca","Russian"),
("2869","ru","cs","Ruský"),
("2870","ru","sk","Ruština"),
("2871","ru","cy","Russian"),
("2872","ru","da","Russian"),
("2873","ru","el","Ρωσικά"),
("2874","ru","eo","Russian"),
("2875","ru","et","Russian"),
("2876","ru","eu","Russian"),
("2877","ru","fa","Russian"),
("2878","ru","fi","Venäjä"),
("2879","ru","ga","Russian"),
("2880","ru","he","רוסית"),
("2881","ru","hi","Russian"),
("2882","ru","hr","Ruski"),
("2883","ru","hu","Orosz"),
("2884","ru","hy","Russian"),
("2885","ru","id","Russian"),
("2886","ru","is","Russian"),
("2887","ru","it","Russo"),
("2888","ru","ja","ロシア語"),
("2889","ru","ko","러시아어"),
("2890","ru","ku","Russian"),
("2891","ru","lv","Russian"),
("2892","ru","lt","Russian"),
("2893","ru","mk","Russian"),
("2894","ru","mt","Russian"),
("2895","ru","mn","Russian"),
("2896","ru","ne","Russian"),
("2897","ru","nl","Russisch"),
("2898","ru","no","Russisk"),
("2899","ru","pa","Russian"),
("2900","ru","pl","Rosyjski"),
("2901","ru","pt-pt","Russo"),
("2902","ru","pt-br","Russo"),
("2903","ru","qu","Russian"),
("2904","ru","ro","Rusă"),
("2905","ru","ru","Русский"),
("2906","ru","sl","Ruščina"),
("2907","ru","so","Russian"),
("2908","ru","sq","Russian"),
("2909","ru","sr","руски"),
("2910","ru","sv","Ryska"),
("2911","ru","ta","Russian"),
("2912","ru","th","รัสเซีย"),
("2913","ru","tr","Rusça"),
("2914","ru","uk","Russian"),
("2915","ru","ur","Russian"),
("2916","ru","uz","Russian"),
("2917","ru","vi","Russian"),
("2918","ru","yi","Russian"),
("2919","ru","zh-hans","俄语"),
("2920","ru","zu","Russian"),
("2921","ru","zh-hant","俄語"),
("2922","ru","ms","Russian"),
("2923","ru","gl","Russian"),
("2924","ru","bn","Russian"),
("2925","ru","az","Russian"),
("2926","sl","en","Slovenian"),
("2927","sl","es","Esloveno"),
("2928","sl","de","Slowenisch"),
("2929","sl","fr","Slovène"),
("2930","sl","ar","السلوفانية"),
("2931","sl","bs","Slovenian"),
("2932","sl","bg","Словенски"),
("2933","sl","ca","Slovenian"),
("2934","sl","cs","Slovinština"),
("2935","sl","sk","Slovinčina"),
("2936","sl","cy","Slovenian"),
("2937","sl","da","Slovenian"),
("2938","sl","el","Σλοβενικά"),
("2939","sl","eo","Slovenian"),
("2940","sl","et","Slovenian"),
("2941","sl","eu","Slovenian"),
("2942","sl","fa","Slovenian"),
("2943","sl","fi","Sloveeni"),
("2944","sl","ga","Slovenian"),
("2945","sl","he","סלובנית"),
("2946","sl","hi","Slovenian"),
("2947","sl","hr","Slovenski"),
("2948","sl","hu","Szlovén"),
("2949","sl","hy","Slovenian"),
("2950","sl","id","Slovenian"),
("2951","sl","is","Slovenian"),
("2952","sl","it","Sloveno"),
("2953","sl","ja","スロベニア語"),
("2954","sl","ko","슬로베니아어"),
("2955","sl","ku","Slovenian"),
("2956","sl","lv","Slovenian"),
("2957","sl","lt","Slovenian"),
("2958","sl","mk","Slovenian"),
("2959","sl","mt","Slovenian"),
("2960","sl","mn","Slovenian"),
("2961","sl","ne","Slovenian"),
("2962","sl","nl","Sloveens"),
("2963","sl","no","Slovensk"),
("2964","sl","pa","Slovenian"),
("2965","sl","pl","Słoweński"),
("2966","sl","pt-pt","Esloveno"),
("2967","sl","pt-br","Esloveno"),
("2968","sl","qu","Slovenian"),
("2969","sl","ro","Slovenă"),
("2970","sl","ru","Словенский"),
("2971","sl","sl","Slovenščina"),
("2972","sl","so","Slovenian"),
("2973","sl","sq","Slovenian"),
("2974","sl","sr","словеначки"),
("2975","sl","sv","Slovenska"),
("2976","sl","ta","Slovenian"),
("2977","sl","th","สโลวีเนียน"),
("2978","sl","tr","Sloven dili"),
("2979","sl","uk","Slovenian"),
("2980","sl","ur","Slovenian"),
("2981","sl","uz","Slovenian"),
("2982","sl","vi","Slovenian"),
("2983","sl","yi","Slovenian"),
("2984","sl","zh-hans","斯洛文尼亚语"),
("2985","sl","zu","Slovenian"),
("2986","sl","zh-hant","斯洛文尼亞語"),
("2987","sl","ms","Slovenian"),
("2988","sl","gl","Slovenian"),
("2989","sl","bn","Slovenian"),
("2990","sl","az","Slovenian"),
("2991","so","en","Somali"),
("2992","so","es","Somalí"),
("2993","so","de","Somali"),
("2994","so","fr","Somali"),
("2995","so","ar","الصومالية"),
("2996","so","bs","Somali"),
("2997","so","bg","Сомалийски"),
("2998","so","ca","Somali"),
("2999","so","cs","Somali"),
("3000","so","sk","Somálčina"),
("3001","so","cy","Somali"),
("3002","so","da","Somali"),
("3003","so","el","Σομαλικά"),
("3004","so","eo","Somali"),
("3005","so","et","Somali"),
("3006","so","eu","Somali"),
("3007","so","fa","Somali"),
("3008","so","fi","Somali"),
("3009","so","ga","Somali"),
("3010","so","he","סומלית"),
("3011","so","hi","Somali"),
("3012","so","hr","Somalski"),
("3013","so","hu","Szomáli"),
("3014","so","hy","Somali"),
("3015","so","id","Somali"),
("3016","so","is","Somali"),
("3017","so","it","Somalo"),
("3018","so","ja","ソマリ語"),
("3019","so","ko","소말리아어"),
("3020","so","ku","Somali"),
("3021","so","lv","Somali"),
("3022","so","lt","Somali"),
("3023","so","mk","Somali"),
("3024","so","mt","Somali"),
("3025","so","mn","Somali"),
("3026","so","ne","Somali"),
("3027","so","nl","Somalisch"),
("3028","so","no","Somali"),
("3029","so","pa","Somali"),
("3030","so","pl","Somalijski"),
("3031","so","pt-pt","Somali"),
("3032","so","pt-br","Somali"),
("3033","so","qu","Somali"),
("3034","so","ro","Somaleză"),
("3035","so","ru","Сомалийский"),
("3036","so","sl","Somalski"),
("3037","so","so","Somali"),
("3038","so","sq","Somali"),
("3039","so","sr","Сомалијски"),
("3040","so","sv","Somaliska"),
("3041","so","ta","Somali"),
("3042","so","th","โซมาลี"),
("3043","so","tr","Somalice"),
("3044","so","uk","Somali"),
("3045","so","ur","Somali"),
("3046","so","uz","Somali"),
("3047","so","vi","Somali"),
("3048","so","yi","Somali"),
("3049","so","zh-hans","索马里语"),
("3050","so","zu","Somali"),
("3051","so","zh-hant","索馬里語"),
("3052","so","ms","Somali"),
("3053","so","gl","Somali"),
("3054","so","bn","Somali"),
("3055","so","az","Somali"),
("3056","sq","en","Albanian"),
("3057","sq","es","Albanés"),
("3058","sq","de","Albanisch"),
("3059","sq","fr","Albanais"),
("3060","sq","ar","الألبانية"),
("3061","sq","bs","Albanian"),
("3062","sq","bg","Албански"),
("3063","sq","ca","Albanian"),
("3064","sq","cs","Albánský"),
("3065","sq","sk","Albánčina"),
("3066","sq","cy","Albanian"),
("3067","sq","da","Albanian"),
("3068","sq","el","Αλβανικά"),
("3069","sq","eo","Albanian"),
("3070","sq","et","Albanian"),
("3071","sq","eu","Albanian"),
("3072","sq","fa","Albanian"),
("3073","sq","fi","Albania"),
("3074","sq","ga","Albanian"),
("3075","sq","he","אלבנית"),
("3076","sq","hi","Albanian"),
("3077","sq","hr","Albanski"),
("3078","sq","hu","Albán"),
("3079","sq","hy","Albanian"),
("3080","sq","id","Albanian"),
("3081","sq","is","Albanian"),
("3082","sq","it","Albanese"),
("3083","sq","ja","アルバニア語"),
("3084","sq","ko","알바니아어"),
("3085","sq","ku","Albanian"),
("3086","sq","lv","Albanian"),
("3087","sq","lt","Albanian"),
("3088","sq","mk","Albanian"),
("3089","sq","mt","Albanian"),
("3090","sq","mn","Albanian"),
("3091","sq","ne","Albanian"),
("3092","sq","nl","Albaans"),
("3093","sq","no","Albansk"),
("3094","sq","pa","Albanian"),
("3095","sq","pl","Albański"),
("3096","sq","pt-pt","Albanês"),
("3097","sq","pt-br","Albanês"),
("3098","sq","qu","Albanian"),
("3099","sq","ro","Albaneză"),
("3100","sq","ru","Албанский"),
("3101","sq","sl","Albanski"),
("3102","sq","so","Albanian"),
("3103","sq","sq","Albanian"),
("3104","sq","sr","албански"),
("3105","sq","sv","Albanska"),
("3106","sq","ta","Albanian"),
("3107","sq","th","อัลเบเนีย"),
("3108","sq","tr","Arnavutça"),
("3109","sq","uk","Albanian"),
("3110","sq","ur","Albanian"),
("3111","sq","uz","Albanian"),
("3112","sq","vi","Albanian"),
("3113","sq","yi","Albanian"),
("3114","sq","zh-hans","阿尔巴尼亚语"),
("3115","sq","zu","Albanian"),
("3116","sq","zh-hant","阿爾巴尼亞語"),
("3117","sq","ms","Albanian"),
("3118","sq","gl","Albanian"),
("3119","sq","bn","Albanian"),
("3120","sq","az","Albanian"),
("3121","sr","en","Serbian"),
("3122","sr","es","Serbio"),
("3123","sr","de","Serbisch"),
("3124","sr","fr","Serbe"),
("3125","sr","ar","الصربية"),
("3126","sr","bs","Serbian"),
("3127","sr","bg","Сръбски"),
("3128","sr","ca","Serbian"),
("3129","sr","cs","Srbský"),
("3130","sr","sk","Srbština"),
("3131","sr","cy","Serbian"),
("3132","sr","da","Serbian"),
("3133","sr","el","Σερβικά"),
("3134","sr","eo","Serbian"),
("3135","sr","et","Serbian"),
("3136","sr","eu","Serbian"),
("3137","sr","fa","Serbian"),
("3138","sr","fi","Serbia"),
("3139","sr","ga","Serbian"),
("3140","sr","he","סרבית"),
("3141","sr","hi","Serbian"),
("3142","sr","hr","Srpski"),
("3143","sr","hu","Szerb"),
("3144","sr","hy","Serbian"),
("3145","sr","id","Serbian"),
("3146","sr","is","Serbian"),
("3147","sr","it","Serbo"),
("3148","sr","ja","セルビア語"),
("3149","sr","ko","세르비아어"),
("3150","sr","ku","Serbian"),
("3151","sr","lv","Serbian"),
("3152","sr","lt","Serbian"),
("3153","sr","mk","Serbian"),
("3154","sr","mt","Serbian"),
("3155","sr","mn","Serbian"),
("3156","sr","ne","Serbian"),
("3157","sr","nl","Servisch"),
("3158","sr","no","Serbisk"),
("3159","sr","pa","Serbian"),
("3160","sr","pl","Serbski"),
("3161","sr","pt-pt","Sérvio"),
("3162","sr","pt-br","Sérvio"),
("3163","sr","qu","Serbian"),
("3164","sr","ro","Sârbă"),
("3165","sr","ru","Сербский"),
("3166","sr","sl","Srbski"),
("3167","sr","so","Serbian"),
("3168","sr","sq","Serbian"),
("3169","sr","sr","српски"),
("3170","sr","sv","Serbiska"),
("3171","sr","ta","Serbian"),
("3172","sr","th","เซอร์เบีย"),
("3173","sr","tr","Sırpça"),
("3174","sr","uk","Serbian"),
("3175","sr","ur","Serbian"),
("3176","sr","uz","Serbian"),
("3177","sr","vi","Serbian"),
("3178","sr","yi","Serbian"),
("3179","sr","zh-hans","赛尔维亚语"),
("3180","sr","zu","Serbian"),
("3181","sr","zh-hant","賽爾維亞語"),
("3182","sr","ms","Serbian"),
("3183","sr","gl","Serbian"),
("3184","sr","bn","Serbian"),
("3185","sr","az","Serbian"),
("3186","sv","en","Swedish"),
("3187","sv","es","Sueco"),
("3188","sv","de","Schwedisch"),
("3189","sv","fr","Suédois"),
("3190","sv","ar","السويدية"),
("3191","sv","bs","Swedish"),
("3192","sv","bg","Шведски"),
("3193","sv","ca","Swedish"),
("3194","sv","cs","Švédský"),
("3195","sv","sk","Švédština"),
("3196","sv","cy","Swedish"),
("3197","sv","da","Swedish"),
("3198","sv","el","Σουηδικά"),
("3199","sv","eo","Swedish"),
("3200","sv","et","Swedish"),
("3201","sv","eu","Swedish"),
("3202","sv","fa","Swedish"),
("3203","sv","fi","Ruotsi"),
("3204","sv","ga","Swedish"),
("3205","sv","he","שוודית"),
("3206","sv","hi","Swedish"),
("3207","sv","hr","švedski"),
("3208","sv","hu","Svéd"),
("3209","sv","hy","Swedish"),
("3210","sv","id","Swedish"),
("3211","sv","is","Swedish"),
("3212","sv","it","Svedese"),
("3213","sv","ja","スウェーデン語"),
("3214","sv","ko","스웨덴어"),
("3215","sv","ku","Swedish"),
("3216","sv","lv","Swedish"),
("3217","sv","lt","Swedish"),
("3218","sv","mk","Swedish"),
("3219","sv","mt","Swedish"),
("3220","sv","mn","Swedish"),
("3221","sv","ne","Swedish"),
("3222","sv","nl","Zweeds"),
("3223","sv","no","Swedish"),
("3224","sv","pa","Swedish"),
("3225","sv","pl","Szwedzki"),
("3226","sv","pt-pt","Sueco"),
("3227","sv","pt-br","Sueco"),
("3228","sv","qu","Swedish"),
("3229","sv","ro","Suedeză"),
("3230","sv","ru","Шведский"),
("3231","sv","sl","Švedščina"),
("3232","sv","so","Swedish"),
("3233","sv","sq","Swedish"),
("3234","sv","sr","шведски"),
("3235","sv","sv","Svenska"),
("3236","sv","ta","Swedish"),
("3237","sv","th","สวีเดน"),
("3238","sv","tr","İsveççe"),
("3239","sv","uk","Swedish"),
("3240","sv","ur","Swedish"),
("3241","sv","uz","Swedish"),
("3242","sv","vi","Swedish"),
("3243","sv","yi","Swedish"),
("3244","sv","zh-hans","瑞典语"),
("3245","sv","zu","Swedish"),
("3246","sv","zh-hant","瑞典語"),
("3247","sv","ms","Swedish"),
("3248","sv","gl","Swedish"),
("3249","sv","bn","Swedish"),
("3250","sv","az","Swedish"),
("3251","ta","en","Tamil"),
("3252","ta","es","Tamil"),
("3253","ta","de","Tamil"),
("3254","ta","fr","Tamoul"),
("3255","ta","ar","التاميلية"),
("3256","ta","bs","Tamil"),
("3257","ta","bg","Тамилски"),
("3258","ta","ca","Tamil"),
("3259","ta","cs","Tamil"),
("3260","ta","sk","Tamilčina"),
("3261","ta","cy","Tamil"),
("3262","ta","da","Tamil"),
("3263","ta","el","Ταμίλ"),
("3264","ta","eo","Tamil"),
("3265","ta","et","Tamil"),
("3266","ta","eu","Tamil"),
("3267","ta","fa","Tamil"),
("3268","ta","fi","Tamili"),
("3269","ta","ga","Tamil"),
("3270","ta","he","טמילית"),
("3271","ta","hi","Tamil"),
("3272","ta","hr","Tamil"),
("3273","ta","hu","Tamil"),
("3274","ta","hy","Tamil"),
("3275","ta","id","Tamil"),
("3276","ta","is","Tamil"),
("3277","ta","it","Tamil"),
("3278","ta","ja","タミル語"),
("3279","ta","ko","타밀어"),
("3280","ta","ku","Tamil"),
("3281","ta","lv","Tamil"),
("3282","ta","lt","Tamil"),
("3283","ta","mk","Tamil"),
("3284","ta","mt","Tamil"),
("3285","ta","mn","Tamil"),
("3286","ta","ne","Tamil"),
("3287","ta","nl","Tamil"),
("3288","ta","no","Tamil"),
("3289","ta","pa","Tamil"),
("3290","ta","pl","Tamilski"),
("3291","ta","pt-pt","Tamil"),
("3292","ta","pt-br","Tamil"),
("3293","ta","qu","Tamil"),
("3294","ta","ro","Tamilă"),
("3295","ta","ru","Тамильский"),
("3296","ta","sl","Tamilščina"),
("3297","ta","so","Tamil"),
("3298","ta","sq","Tamil"),
("3299","ta","sr","тамилски"),
("3300","ta","sv","Tamil"),
("3301","ta","ta","Tamil"),
("3302","ta","th","ทมิฬ"),
("3303","ta","tr","Tamil dili"),
("3304","ta","uk","Tamil"),
("3305","ta","ur","Tamil"),
("3306","ta","uz","Tamil"),
("3307","ta","vi","Tamil"),
("3308","ta","yi","Tamil"),
("3309","ta","zh-hans","泰米尔语"),
("3310","ta","zu","Tamil"),
("3311","ta","zh-hant","泰米爾語"),
("3312","ta","ms","Tamil"),
("3313","ta","gl","Tamil"),
("3314","ta","bn","Tamil"),
("3315","ta","az","Tamil"),
("3316","th","en","Thai"),
("3317","th","es","Tailandés"),
("3318","th","de","Thai"),
("3319","th","fr","Thaï"),
("3320","th","ar","التايلندية"),
("3321","th","bs","Thai"),
("3322","th","bg","Тайски"),
("3323","th","ca","Thai"),
("3324","th","cs","Thai"),
("3325","th","sk","Thajština"),
("3326","th","cy","Thai"),
("3327","th","da","Thai"),
("3328","th","el","Ταϊλανδέζικα"),
("3329","th","eo","Thai"),
("3330","th","et","Thai"),
("3331","th","eu","Thai"),
("3332","th","fa","Thai"),
("3333","th","fi","Thai"),
("3334","th","ga","Thai"),
("3335","th","he","תאילנדית"),
("3336","th","hi","Thai"),
("3337","th","hr","Thai"),
("3338","th","hu","Tájföldi"),
("3339","th","hy","Thai"),
("3340","th","id","Thai"),
("3341","th","is","Thai"),
("3342","th","it","Thai"),
("3343","th","ja","タイ語"),
("3344","th","ko","태국어"),
("3345","th","ku","Thai"),
("3346","th","lv","Thai"),
("3347","th","lt","Thai"),
("3348","th","mk","Thai"),
("3349","th","mt","Thai"),
("3350","th","mn","Thai"),
("3351","th","ne","Thai"),
("3352","th","nl","Thai"),
("3353","th","no","Thai"),
("3354","th","pa","Thai"),
("3355","th","pl","Tajski"),
("3356","th","pt-pt","Tailandês"),
("3357","th","pt-br","Tailandês"),
("3358","th","qu","Thai"),
("3359","th","ro","Tailandeză"),
("3360","th","ru","Тайский"),
("3361","th","sl","Tajski"),
("3362","th","so","Thai"),
("3363","th","sq","Thai"),
("3364","th","sr","Тајландски"),
("3365","th","sv","Thailändska"),
("3366","th","ta","Thai"),
("3367","th","th","ไทย"),
("3368","th","tr","Tayca"),
("3369","th","uk","Thai"),
("3370","th","ur","Thai"),
("3371","th","uz","Thai"),
("3372","th","vi","Thai"),
("3373","th","yi","Thai"),
("3374","th","zh-hans","泰语"),
("3375","th","zu","Thai"),
("3376","th","zh-hant","泰語"),
("3377","th","ms","Thai"),
("3378","th","gl","Thai"),
("3379","th","bn","Thai"),
("3380","th","az","Thai"),
("3381","tr","en","Turkish"),
("3382","tr","es","Turco"),
("3383","tr","de","Türkisch"),
("3384","tr","fr","Turc"),
("3385","tr","ar","التركية"),
("3386","tr","bs","Turkish"),
("3387","tr","bg","Турски"),
("3388","tr","ca","Turkish"),
("3389","tr","cs","Turečtina"),
("3390","tr","sk","Turečtina"),
("3391","tr","cy","Turkish"),
("3392","tr","da","Turkish"),
("3393","tr","el","Τουρκικά"),
("3394","tr","eo","Turkish"),
("3395","tr","et","Turkish"),
("3396","tr","eu","Turkish"),
("3397","tr","fa","Turkish"),
("3398","tr","fi","Turkki"),
("3399","tr","ga","Turkish"),
("3400","tr","he","תורכית"),
("3401","tr","hi","Turkish"),
("3402","tr","hr","Turski"),
("3403","tr","hu","Török"),
("3404","tr","hy","Turkish"),
("3405","tr","id","Turkish"),
("3406","tr","is","Turkish"),
("3407","tr","it","Turco"),
("3408","tr","ja","トルコ語"),
("3409","tr","ko","터어키어"),
("3410","tr","ku","Turkish"),
("3411","tr","lv","Turkish"),
("3412","tr","lt","Turkish"),
("3413","tr","mk","Turkish"),
("3414","tr","mt","Turkish"),
("3415","tr","mn","Turkish"),
("3416","tr","ne","Turkish"),
("3417","tr","nl","Turks"),
("3418","tr","no","Turkish"),
("3419","tr","pa","Turkish"),
("3420","tr","pl","Turecki"),
("3421","tr","pt-pt","Turco"),
("3422","tr","pt-br","Turco"),
("3423","tr","qu","Turkish"),
("3424","tr","ro","Turcă"),
("3425","tr","ru","Турецкий"),
("3426","tr","sl","Turščina"),
("3427","tr","so","Turkish"),
("3428","tr","sq","Turkish"),
("3429","tr","sr","турски"),
("3430","tr","sv","Turkiska"),
("3431","tr","ta","Turkish"),
("3432","tr","th","ตุรกี"),
("3433","tr","tr","Türkçe"),
("3434","tr","uk","Turkish"),
("3435","tr","ur","Turkish"),
("3436","tr","uz","Turkish"),
("3437","tr","vi","Turkish"),
("3438","tr","yi","Turkish"),
("3439","tr","zh-hans","土耳其语"),
("3440","tr","zu","Turkish"),
("3441","tr","zh-hant","土耳其語"),
("3442","tr","ms","Turkish"),
("3443","tr","gl","Turkish"),
("3444","tr","bn","Turkish"),
("3445","tr","az","Turkish"),
("3446","uk","en","Ukrainian"),
("3447","uk","es","Ucraniano"),
("3448","uk","de","Ukrainisch"),
("3449","uk","fr","Ukrainien"),
("3450","uk","ar","الأوكرانية"),
("3451","uk","bs","Ukrainian"),
("3452","uk","bg","Украински"),
("3453","uk","ca","Ukrainian"),
("3454","uk","cs","Ukrajinský"),
("3455","uk","sk","Ukrajinčina"),
("3456","uk","cy","Ukrainian"),
("3457","uk","da","Ukrainian"),
("3458","uk","el","Ουκρανικά"),
("3459","uk","eo","Ukrainian"),
("3460","uk","et","Ukrainian"),
("3461","uk","eu","Ukrainian"),
("3462","uk","fa","Ukrainian"),
("3463","uk","fi","Ukraina"),
("3464","uk","ga","Ukrainian"),
("3465","uk","he","אוקראינית"),
("3466","uk","hi","Ukrainian"),
("3467","uk","hr","Ukrajinski"),
("3468","uk","hu","Ukrán"),
("3469","uk","hy","Ukrainian"),
("3470","uk","id","Ukrainian"),
("3471","uk","is","Ukrainian"),
("3472","uk","it","Ucraino"),
("3473","uk","ja","ウクライナ語"),
("3474","uk","ko","우크라이나어"),
("3475","uk","ku","Ukrainian"),
("3476","uk","lv","Ukrainian"),
("3477","uk","lt","Ukrainian"),
("3478","uk","mk","Ukrainian"),
("3479","uk","mt","Ukrainian"),
("3480","uk","mn","Ukrainian"),
("3481","uk","ne","Ukrainian"),
("3482","uk","nl","Oekraïens"),
("3483","uk","no","Ukrainsk"),
("3484","uk","pa","Ukrainian"),
("3485","uk","pl","Ukraiński"),
("3486","uk","pt-pt","Ucraniano"),
("3487","uk","pt-br","Ucraniano"),
("3488","uk","qu","Ukrainian"),
("3489","uk","ro","Ucrainiană"),
("3490","uk","ru","Украинский"),
("3491","uk","sl","Ukrajinski"),
("3492","uk","so","Ukrainian"),
("3493","uk","sq","Ukrainian"),
("3494","uk","sr","украјински"),
("3495","uk","sv","Ukrainska"),
("3496","uk","ta","Ukrainian"),
("3497","uk","th","ยูเครน"),
("3498","uk","tr","Ukraynaca"),
("3499","uk","uk","Українська"),
("3500","uk","ur","Ukrainian"),
("3501","uk","uz","Ukrainian"),
("3502","uk","vi","Ukrainian"),
("3503","uk","yi","Ukrainian"),
("3504","uk","zh-hans","乌克兰语"),
("3505","uk","zu","Ukrainian"),
("3506","uk","zh-hant","烏克蘭語"),
("3507","uk","ms","Ukrainian"),
("3508","uk","gl","Ukrainian"),
("3509","uk","bn","Ukrainian"),
("3510","uk","az","Ukrainian"),
("3511","ur","en","Urdu"),
("3512","ur","es","Urdu"),
("3513","ur","de","Urdu"),
("3514","ur","fr","Ourdu"),
("3515","ur","ar","الأردية"),
("3516","ur","bs","Urdu"),
("3517","ur","bg","Урду"),
("3518","ur","ca","Urdu"),
("3519","ur","cs","Urdu"),
("3520","ur","sk","Urdština"),
("3521","ur","cy","Urdu"),
("3522","ur","da","Urdu"),
("3523","ur","el","Ούρντου"),
("3524","ur","eo","Urdu"),
("3525","ur","et","Urdu"),
("3526","ur","eu","Urdu"),
("3527","ur","fa","Urdu"),
("3528","ur","fi","Urdu"),
("3529","ur","ga","Urdu"),
("3530","ur","he","אורדו"),
("3531","ur","hi","Urdu"),
("3532","ur","hr","Urdski"),
("3533","ur","hu","Urdu"),
("3534","ur","hy","Urdu"),
("3535","ur","id","Urdu"),
("3536","ur","is","Urdu"),
("3537","ur","it","Urdu"),
("3538","ur","ja","ウルドゥー語"),
("3539","ur","ko","우르두어"),
("3540","ur","ku","Urdu"),
("3541","ur","lv","Urdu"),
("3542","ur","lt","Urdu"),
("3543","ur","mk","Urdu"),
("3544","ur","mt","Urdu"),
("3545","ur","mn","Urdu"),
("3546","ur","ne","Urdu"),
("3547","ur","nl","Urdu"),
("3548","ur","no","Urdu"),
("3549","ur","pa","Urdu"),
("3550","ur","pl","Urdu"),
("3551","ur","pt-pt","Urdu"),
("3552","ur","pt-br","Urdu"),
("3553","ur","qu","Urdu"),
("3554","ur","ro","Urdu"),
("3555","ur","ru","Урду"),
("3556","ur","sl","Urdujščina"),
("3557","ur","so","Urdu"),
("3558","ur","sq","Urdu"),
("3559","ur","sr","урду"),
("3560","ur","sv","Urdu"),
("3561","ur","ta","Urdu"),
("3562","ur","th","อุรดู"),
("3563","ur","tr","Urduca"),
("3564","ur","uk","Urdu"),
("3565","ur","ur","اردو "),
("3566","ur","uz","Urdu"),
("3567","ur","vi","Urdu"),
("3568","ur","yi","Urdu"),
("3569","ur","zh-hans","乌尔都语"),
("3570","ur","zu","Urdu"),
("3571","ur","zh-hant","烏爾都語"),
("3572","ur","ms","Urdu"),
("3573","ur","gl","Urdu"),
("3574","ur","bn","Urdu"),
("3575","ur","az","Urdu"),
("3576","uz","en","Uzbek"),
("3577","uz","es","Uzbeko"),
("3578","uz","de","Usbekisch"),
("3579","uz","fr","Ouzbek"),
("3580","uz","ar","الاوزباكية"),
("3581","uz","bs","Uzbek"),
("3582","uz","bg","Узбекски"),
("3583","uz","ca","Uzbek"),
("3584","uz","cs","Uzbek"),
("3585","uz","sk","Uzbekčina"),
("3586","uz","cy","Uzbek"),
("3587","uz","da","Uzbek"),
("3588","uz","el","Ουζμπεκικά"),
("3589","uz","eo","Uzbek"),
("3590","uz","et","Uzbek"),
("3591","uz","eu","Uzbek"),
("3592","uz","fa","Uzbek"),
("3593","uz","fi","Uzbekki"),
("3594","uz","ga","Uzbek"),
("3595","uz","he","אוזבקית"),
("3596","uz","hi","Uzbek"),
("3597","uz","hr","Uzbečki"),
("3598","uz","hu","üzbég"),
("3599","uz","hy","Uzbek"),
("3600","uz","id","Uzbek"),
("3601","uz","is","Uzbek"),
("3602","uz","it","Uzbeco"),
("3603","uz","ja","ウズベク語"),
("3604","uz","ko","우즈베크어"),
("3605","uz","ku","Uzbek"),
("3606","uz","lv","Uzbek"),
("3607","uz","lt","Uzbek"),
("3608","uz","mk","Uzbek"),
("3609","uz","mt","Uzbek"),
("3610","uz","mn","Uzbek"),
("3611","uz","ne","Uzbek"),
("3612","uz","nl","Oezbeeks"),
("3613","uz","no","Usbekisk"),
("3614","uz","pa","Uzbek"),
("3615","uz","pl","Uzbecki"),
("3616","uz","pt-pt","Uzbeque"),
("3617","uz","pt-br","Uzbeque"),
("3618","uz","qu","Uzbek"),
("3619","uz","ro","Uzbecă"),
("3620","uz","ru","Узбекский"),
("3621","uz","sl","Uzbek"),
("3622","uz","so","Uzbek"),
("3623","uz","sq","Uzbek"),
("3624","uz","sr","Узбек"),
("3625","uz","sv","Uzbekiska"),
("3626","uz","ta","Uzbek"),
("3627","uz","th","อุซเบก"),
("3628","uz","tr","Özbekçe"),
("3629","uz","uk","Uzbek"),
("3630","uz","ur","Uzbek"),
("3631","uz","uz","Uzbek"),
("3632","uz","vi","Uzbek"),
("3633","uz","yi","Uzbek"),
("3634","uz","zh-hans","乌兹别克语"),
("3635","uz","zu","Uzbek"),
("3636","uz","zh-hant","烏茲別克語"),
("3637","uz","ms","Uzbek"),
("3638","uz","gl","Uzbek"),
("3639","uz","bn","Uzbek"),
("3640","uz","az","Uzbek"),
("3641","vi","en","Vietnamese"),
("3642","vi","es","Vietnamita"),
("3643","vi","de","Vietnamesisch"),
("3644","vi","fr","Vietnamien"),
("3645","vi","ar","الفيتنامية"),
("3646","vi","bs","Vietnamese"),
("3647","vi","bg","Виетнамски"),
("3648","vi","ca","Vietnamese"),
("3649","vi","cs","Vietnamský"),
("3650","vi","sk","Vietnamčina"),
("3651","vi","cy","Vietnamese"),
("3652","vi","da","Vietnamese"),
("3653","vi","el","Βιετναμέζικα"),
("3654","vi","eo","Vietnamese"),
("3655","vi","et","Vietnamese"),
("3656","vi","eu","Vietnamese"),
("3657","vi","fa","Vietnamese"),
("3658","vi","fi","Vietnam"),
("3659","vi","ga","Vietnamese"),
("3660","vi","he","וייטנאמית"),
("3661","vi","hi","Vietnamese"),
("3662","vi","hr","Vijetnamski"),
("3663","vi","hu","Vietnámi"),
("3664","vi","hy","Vietnamese"),
("3665","vi","id","Vietnamese"),
("3666","vi","is","Vietnamese"),
("3667","vi","it","Vietnamita"),
("3668","vi","ja","ベトナム語"),
("3669","vi","ko","베트남어"),
("3670","vi","ku","Vietnamese"),
("3671","vi","lv","Vietnamese"),
("3672","vi","lt","Vietnamese"),
("3673","vi","mk","Vietnamese"),
("3674","vi","mt","Vietnamese"),
("3675","vi","mn","Vietnamese"),
("3676","vi","ne","Vietnamese"),
("3677","vi","nl","Vietnamees"),
("3678","vi","no","Vietnamesisk"),
("3679","vi","pa","Vietnamese"),
("3680","vi","pl","Wietnamski"),
("3681","vi","pt-pt","Vietnamita"),
("3682","vi","pt-br","Vietnamita"),
("3683","vi","qu","Vietnamese"),
("3684","vi","ro","Vietnameză"),
("3685","vi","ru","Вьетнамский"),
("3686","vi","sl","Vietnamščina"),
("3687","vi","so","Vietnamese"),
("3688","vi","sq","Vietnamese"),
("3689","vi","sr","вијетнамски"),
("3690","vi","sv","Vietnamesiska"),
("3691","vi","ta","Vietnamese"),
("3692","vi","th","เวียดนาม"),
("3693","vi","tr","Vietnamca"),
("3694","vi","uk","Vietnamese"),
("3695","vi","ur","Vietnamese"),
("3696","vi","uz","Vietnamese"),
("3697","vi","vi","Tiếng Việt"),
("3698","vi","yi","Vietnamese"),
("3699","vi","zh-hans","越南语"),
("3700","vi","zu","Vietnamese"),
("3701","vi","zh-hant","越南語"),
("3702","vi","ms","Vietnamese"),
("3703","vi","gl","Vietnamese"),
("3704","vi","bn","Vietnamese"),
("3705","vi","az","Vietnamese"),
("3706","yi","en","Yiddish"),
("3707","yi","es","Yidis"),
("3708","yi","de","Jiddisch"),
("3709","yi","fr","Yiddish"),
("3710","yi","ar","اليديشية"),
("3711","yi","bs","Yiddish"),
("3712","yi","bg","Идиш"),
("3713","yi","ca","Yiddish"),
("3714","yi","cs","Jidiš"),
("3715","yi","sk","Jidiš"),
("3716","yi","cy","Yiddish"),
("3717","yi","da","Yiddish"),
("3718","yi","el","Γίντις"),
("3719","yi","eo","Yiddish"),
("3720","yi","et","Yiddish"),
("3721","yi","eu","Yiddish"),
("3722","yi","fa","Yiddish"),
("3723","yi","fi","Jiddi"),
("3724","yi","ga","Yiddish"),
("3725","yi","he","יידיש"),
("3726","yi","hi","Yiddish"),
("3727","yi","hr","Jidiš"),
("3728","yi","hu","Jiddis"),
("3729","yi","hy","Yiddish"),
("3730","yi","id","Yiddish"),
("3731","yi","is","Yiddish"),
("3732","yi","it","Yiddish"),
("3733","yi","ja","イディッシュ語"),
("3734","yi","ko","이디시어"),
("3735","yi","ku","Yiddish"),
("3736","yi","lv","Yiddish"),
("3737","yi","lt","Yiddish"),
("3738","yi","mk","Yiddish"),
("3739","yi","mt","Yiddish"),
("3740","yi","mn","Yiddish"),
("3741","yi","ne","Yiddish"),
("3742","yi","nl","Jiddisch"),
("3743","yi","no","Yiddish"),
("3744","yi","pa","Yiddish"),
("3745","yi","pl","Jidysz"),
("3746","yi","pt-pt","Yiddish"),
("3747","yi","pt-br","Yiddish"),
("3748","yi","qu","Yiddish"),
("3749","yi","ro","Idiş"),
("3750","yi","ru","Идиш"),
("3751","yi","sl","Jidiš"),
("3752","yi","so","Yiddish"),
("3753","yi","sq","Yiddish"),
("3754","yi","sr","јидиш"),
("3755","yi","sv","Jiddisch"),
("3756","yi","ta","Yiddish"),
("3757","yi","th","ยิชดิช"),
("3758","yi","tr","Eski İbranice"),
("3759","yi","uk","Yiddish"),
("3760","yi","ur","Yiddish"),
("3761","yi","uz","Yiddish"),
("3762","yi","vi","Yiddish"),
("3763","yi","yi","Yiddish"),
("3764","yi","zh-hans","依地语"),
("3765","yi","zu","Yiddish"),
("3766","yi","zh-hant","依地語"),
("3767","yi","ms","Yiddish"),
("3768","yi","gl","Yiddish"),
("3769","yi","bn","Yiddish"),
("3770","yi","az","Yiddish"),
("3771","zh-hans","en","Chinese (Simplified)"),
("3772","zh-hans","es","Chino simplificado"),
("3773","zh-hans","de","Vereinfachtes Chinesisch"),
("3774","zh-hans","fr","Chinois simplifié"),
("3775","zh-hans","ar","الصينية المبسطة"),
("3776","zh-hans","bs","Chinese (Simplified)"),
("3777","zh-hans","bg","Китайски  (опростен)"),
("3778","zh-hans","ca","Chinese (Simplified)"),
("3779","zh-hans","cs","Čínština ( Zjednodušený )"),
("3780","zh-hans","sk","Zjednodušená Čínština"),
("3781","zh-hans","cy","Chinese (Simplified)"),
("3782","zh-hans","da","Chinese (Simplified)"),
("3783","zh-hans","el","Κινεζικά (Απλοποιημένα)"),
("3784","zh-hans","eo","Chinese (Simplified)"),
("3785","zh-hans","et","Chinese (Simplified)"),
("3786","zh-hans","eu","Chinese (Simplified)"),
("3787","zh-hans","fa","Chinese (Simplified)"),
("3788","zh-hans","fi","Kiina"),
("3789","zh-hans","ga","Chinese (Simplified)"),
("3790","zh-hans","he","סינית"),
("3791","zh-hans","hi","Chinese (Simplified)"),
("3792","zh-hans","hr","Kineski (pojednostavljeni)"),
("3793","zh-hans","hu","Egyszerűsített kínai"),
("3794","zh-hans","hy","Chinese (Simplified)"),
("3795","zh-hans","id","Chinese (Simplified)"),
("3796","zh-hans","is","Chinese (Simplified)"),
("3797","zh-hans","it","Cinese semplificato"),
("3798","zh-hans","ja","簡体中国語"),
("3799","zh-hans","ko","중국어 간체"),
("3800","zh-hans","ku","Chinese (Simplified)"),
("3801","zh-hans","lv","Chinese (Simplified)"),
("3802","zh-hans","lt","Chinese (Simplified)"),
("3803","zh-hans","mk","Chinese (Simplified)"),
("3804","zh-hans","mt","Chinese (Simplified)"),
("3805","zh-hans","mn","Chinese (Simplified)"),
("3806","zh-hans","ne","Chinese (Simplified)"),
("3807","zh-hans","nl","Vereenvoudigd Chinees"),
("3808","zh-hans","no","Kinesisk (forenklet)"),
("3809","zh-hans","pa","Chinese (Simplified)"),
("3810","zh-hans","pl","Chiński uproszczony"),
("3811","zh-hans","pt-pt","Chinês (Simplificado)"),
("3812","zh-hans","pt-br","Chinês (Simplificado)"),
("3813","zh-hans","qu","Chinese (Simplified)"),
("3814","zh-hans","ro","Chineza simplificată"),
("3815","zh-hans","ru","Китайский (упрощенный)"),
("3816","zh-hans","sl","Kitajščina (poenostavljena )"),
("3817","zh-hans","so","Chinese (Simplified)"),
("3818","zh-hans","sq","Chinese (Simplified)"),
("3819","zh-hans","sr","Кинески (поједностављени)"),
("3820","zh-hans","sv","Förenklad kinesiska"),
("3821","zh-hans","ta","Chinese (Simplified)"),
("3822","zh-hans","th","จีนประยุกต์"),
("3823","zh-hans","tr","Modern Çince"),
("3824","zh-hans","uk","Chinese (Simplified)"),
("3825","zh-hans","ur","Chinese (Simplified)"),
("3826","zh-hans","uz","Chinese (Simplified)"),
("3827","zh-hans","vi","Chinese (Simplified)"),
("3828","zh-hans","yi","Chinese (Simplified)"),
("3829","zh-hans","zh-hans","简体中文"),
("3830","zh-hans","zu","Chinese (Simplified)"),
("3831","zh-hans","zh-hant","簡體中文"),
("3832","zh-hans","ms","Chinese (Simplified)"),
("3833","zh-hans","gl","Chinese (Simplified)"),
("3834","zh-hans","bn","Chinese (Simplified)"),
("3835","zh-hans","az","Chinese (Simplified)"),
("3836","zu","en","Zulu"),
("3837","zu","es","Zulú"),
("3838","zu","de","Zulu"),
("3839","zu","fr","Zoulou"),
("3840","zu","ar","الزولو"),
("3841","zu","bs","Zulu"),
("3842","zu","bg","Зулу"),
("3843","zu","ca","Zulu"),
("3844","zu","cs","Zulu"),
("3845","zu","sk","Jazyk Zulu"),
("3846","zu","cy","Zulu"),
("3847","zu","da","Zulu"),
("3848","zu","el","Ζουλού"),
("3849","zu","eo","Zulu"),
("3850","zu","et","Zulu"),
("3851","zu","eu","Zulu"),
("3852","zu","fa","Zulu"),
("3853","zu","fi","Zulu"),
("3854","zu","ga","Zulu"),
("3855","zu","he","זולו "),
("3856","zu","hi","Zulu"),
("3857","zu","hr","Zulu"),
("3858","zu","hu","Zulu"),
("3859","zu","hy","Zulu"),
("3860","zu","id","Zulu"),
("3861","zu","is","Zulu"),
("3862","zu","it","Zulu"),
("3863","zu","ja","ズールー語"),
("3864","zu","ko","줄루어"),
("3865","zu","ku","Zulu"),
("3866","zu","lv","Zulu"),
("3867","zu","lt","Zulu"),
("3868","zu","mk","Zulu"),
("3869","zu","mt","Zulu"),
("3870","zu","mn","Zulu"),
("3871","zu","ne","Zulu"),
("3872","zu","nl","Zulu"),
("3873","zu","no","Zulu"),
("3874","zu","pa","Zulu"),
("3875","zu","pl","Zuluski"),
("3876","zu","pt-pt","Zulu"),
("3877","zu","pt-br","Zulu"),
("3878","zu","qu","Zulu"),
("3879","zu","ro","Zulu"),
("3880","zu","ru","Зулу"),
("3881","zu","sl","Zulu"),
("3882","zu","so","Zulu"),
("3883","zu","sq","Zulu"),
("3884","zu","sr","зулу"),
("3885","zu","sv","Zulu"),
("3886","zu","ta","Zulu"),
("3887","zu","th","ซูลู"),
("3888","zu","tr","Zulu dili"),
("3889","zu","uk","Zulu"),
("3890","zu","ur","Zulu"),
("3891","zu","uz","Zulu"),
("3892","zu","vi","Zulu"),
("3893","zu","yi","Zulu"),
("3894","zu","zh-hans","祖鲁语"),
("3895","zu","zu","Zulu"),
("3896","zu","zh-hant","祖魯語"),
("3897","zu","ms","Zulu"),
("3898","zu","gl","Zulu"),
("3899","zu","bn","Zulu"),
("3900","zu","az","Zulu"),
("3901","zh-hant","en","Chinese (Traditional)"),
("3902","zh-hant","es","Chino tradicional"),
("3903","zh-hant","de","Traditionelles Chinesisch"),
("3904","zh-hant","fr","Chinois traditionnel"),
("3905","zh-hant","ar","الصينية التقليدية"),
("3906","zh-hant","bs","Chinese (Traditional)"),
("3907","zh-hant","bg","Китайски (традиционен)"),
("3908","zh-hant","ca","Chinese (Traditional)"),
("3909","zh-hant","cs","Čínština (tradiční )"),
("3910","zh-hant","sk","Tradičná Čínština"),
("3911","zh-hant","cy","Chinese (Traditional)"),
("3912","zh-hant","da","Chinese (Traditional)"),
("3913","zh-hant","el","Κινεζικά (Παραδοσιακά)"),
("3914","zh-hant","eo","Chinese (Traditional)"),
("3915","zh-hant","et","Chinese (Traditional)"),
("3916","zh-hant","eu","Chinese (Traditional)"),
("3917","zh-hant","fa","Chinese (Traditional)"),
("3918","zh-hant","fi","Perinteinen kiina"),
("3919","zh-hant","ga","Chinese (Traditional)"),
("3920","zh-hant","he","סינית מסורתית"),
("3921","zh-hant","hi","Chinese (Traditional)"),
("3922","zh-hant","hr","Kineski (tradicionalni)"),
("3923","zh-hant","hu","Hagyományos kínai"),
("3924","zh-hant","hy","Chinese (Traditional)"),
("3925","zh-hant","id","Chinese (Traditional)"),
("3926","zh-hant","is","Chinese (Traditional)"),
("3927","zh-hant","it","Cinese tradizionale"),
("3928","zh-hant","ja","繁体中国語"),
("3929","zh-hant","ko","중국어 번체"),
("3930","zh-hant","ku","Chinese (Traditional)"),
("3931","zh-hant","lv","Chinese (Traditional)"),
("3932","zh-hant","lt","Chinese (Traditional)"),
("3933","zh-hant","mk","Chinese (Traditional)"),
("3934","zh-hant","mt","Chinese (Traditional)"),
("3935","zh-hant","mn","Chinese (Traditional)"),
("3936","zh-hant","ne","Chinese (Traditional)"),
("3937","zh-hant","nl","Traditioneel Chinees"),
("3938","zh-hant","no","Kinesisk (tradisjonell)"),
("3939","zh-hant","pa","Chinese (Traditional)"),
("3940","zh-hant","pl","Chiński tradycyjny"),
("3941","zh-hant","pt-pt","Chinês (Tradicional)"),
("3942","zh-hant","pt-br","Chinês (Tradicional)"),
("3943","zh-hant","qu","Chinese (Traditional)"),
("3944","zh-hant","ro","Chineza tradiţională"),
("3945","zh-hant","ru","Китайский (традиционный)"),
("3946","zh-hant","sl","Kitajščina (tradicionalna)"),
("3947","zh-hant","so","Chinese (Traditional)"),
("3948","zh-hant","sq","Chinese (Traditional)"),
("3949","zh-hant","sr","Кинески (традиционални)"),
("3950","zh-hant","sv","Traditionell kinesiska"),
("3951","zh-hant","ta","Chinese (Traditional)"),
("3952","zh-hant","th","จีนดั้งเดิม"),
("3953","zh-hant","tr","Klasik Çince"),
("3954","zh-hant","uk","Chinese (Traditional)"),
("3955","zh-hant","ur","Chinese (Traditional)"),
("3956","zh-hant","uz","Chinese (Traditional)"),
("3957","zh-hant","vi","Chinese (Traditional)"),
("3958","zh-hant","yi","Chinese (Traditional)"),
("3959","zh-hant","zh-hans","繁体中文"),
("3960","zh-hant","zu","Chinese (Traditional)"),
("3961","zh-hant","zh-hant","繁體中文"),
("3962","zh-hant","ms","Chinese (Traditional)"),
("3963","zh-hant","gl","Chinese (Traditional)"),
("3964","zh-hant","bn","Chinese (Traditional)"),
("3965","zh-hant","az","Chinese (Traditional)"),
("3966","ms","en","Malay"),
("3967","ms","es","Malayo"),
("3968","ms","de","Malaiisch"),
("3969","ms","fr","Malay"),
("3970","ms","ar","لغة الملايو"),
("3971","ms","bs","Malay"),
("3972","ms","bg","Малайски"),
("3973","ms","ca","Malay"),
("3974","ms","cs","Malajský"),
("3975","ms","sk","Malay"),
("3976","ms","cy","Malay"),
("3977","ms","da","Malay"),
("3978","ms","el","Malay"),
("3979","ms","eo","Malay"),
("3980","ms","et","Malay"),
("3981","ms","eu","Malay"),
("3982","ms","fa","Malay"),
("3983","ms","fi","Malay"),
("3984","ms","ga","Malay"),
("3985","ms","he","מלאית"),
("3986","ms","hi","Malay"),
("3987","ms","hr","Malajski"),
("3988","ms","hu","Malay"),
("3989","ms","hy","Malay"),
("3990","ms","id","Malay"),
("3991","ms","is","Malay");

INSERT INTO `wp_icl_languages_translations` VALUES 
("3992","ms","it","Malay"),
("3993","ms","ja","Malay"),
("3994","ms","ko","Malay"),
("3995","ms","ku","Malay"),
("3996","ms","lv","Malay"),
("3997","ms","lt","Malay"),
("3998","ms","mk","Malay"),
("3999","ms","mt","Malay"),
("4000","ms","mn","Malay"),
("4001","ms","ne","Malay"),
("4002","ms","nl","Malay"),
("4003","ms","no","Malay"),
("4004","ms","pa","Malay"),
("4005","ms","pl","Malay"),
("4006","ms","pt-pt","Malaio"),
("4007","ms","pt-br","Malaio"),
("4008","ms","qu","Malay"),
("4009","ms","ro","Malay"),
("4010","ms","ru","Малайский"),
("4011","ms","sl","Malajščina"),
("4012","ms","so","Malay"),
("4013","ms","sq","Malay"),
("4014","ms","sr","малајски"),
("4015","ms","sv","Malay"),
("4016","ms","ta","Malay"),
("4017","ms","th","Malay"),
("4018","ms","tr","Malay"),
("4019","ms","uk","Malay"),
("4020","ms","ur","Malay"),
("4021","ms","uz","Malay"),
("4022","ms","vi","Malay"),
("4023","ms","yi","Malay"),
("4024","ms","zh-hans","Malay"),
("4025","ms","zu","Malay"),
("4026","ms","zh-hant","Malay"),
("4027","ms","ms","Melayu"),
("4028","ms","gl","Malay"),
("4029","ms","bn","Malay"),
("4030","ms","az","Malay"),
("4031","gl","en","Galician"),
("4032","gl","es","Gallego"),
("4033","gl","de","Galicisch"),
("4034","gl","fr","Galicien"),
("4035","gl","ar","Galician"),
("4036","gl","bs","Galician"),
("4037","gl","bg","Galician"),
("4038","gl","ca","Galician"),
("4039","gl","cs","Galician"),
("4040","gl","sk","Galician"),
("4041","gl","cy","Galician"),
("4042","gl","da","Galician"),
("4043","gl","el","Galician"),
("4044","gl","eo","Galician"),
("4045","gl","et","Galician"),
("4046","gl","eu","Galician"),
("4047","gl","fa","Galician"),
("4048","gl","fi","Galician"),
("4049","gl","ga","Galician"),
("4050","gl","he","Galician"),
("4051","gl","hi","Galician"),
("4052","gl","hr","Galician"),
("4053","gl","hu","Galician"),
("4054","gl","hy","Galician"),
("4055","gl","id","Galician"),
("4056","gl","is","Galician"),
("4057","gl","it","Gallego"),
("4058","gl","ja","Galician"),
("4059","gl","ko","Galician"),
("4060","gl","ku","Galician"),
("4061","gl","lv","Galician"),
("4062","gl","lt","Galician"),
("4063","gl","mk","Galician"),
("4064","gl","mt","Galician"),
("4065","gl","mn","Galician"),
("4066","gl","ne","Galician"),
("4067","gl","nl","Galician"),
("4068","gl","no","Galician"),
("4069","gl","pa","Galician"),
("4070","gl","pl","Galician"),
("4071","gl","pt-pt","Galego"),
("4072","gl","pt-br","Galego"),
("4073","gl","qu","Galician"),
("4074","gl","ro","Galician"),
("4075","gl","ru","Галисийский"),
("4076","gl","sl","Galician"),
("4077","gl","so","Galician"),
("4078","gl","sq","Galician"),
("4079","gl","sr","Galician"),
("4080","gl","sv","Galician"),
("4081","gl","ta","Galician"),
("4082","gl","th","Galician"),
("4083","gl","tr","Galician"),
("4084","gl","uk","Galician"),
("4085","gl","ur","Galician"),
("4086","gl","uz","Galician"),
("4087","gl","vi","Galician"),
("4088","gl","yi","Galician"),
("4089","gl","zh-hans","Galician"),
("4090","gl","zu","Galician"),
("4091","gl","zh-hant","Galician"),
("4092","gl","ms","Galician"),
("4093","gl","gl","Galego"),
("4094","gl","bn","Galician"),
("4095","gl","az","Galician"),
("4096","bn","en","Bengali"),
("4097","bn","es","Bengalí"),
("4098","bn","de","Bengalisch"),
("4099","bn","fr","Bengali"),
("4100","bn","ar","Bengali"),
("4101","bn","bs","Bengali"),
("4102","bn","bg","Bengali"),
("4103","bn","ca","Bengali"),
("4104","bn","cs","Bengali"),
("4105","bn","sk","Bengali"),
("4106","bn","cy","Bengali"),
("4107","bn","da","Bengali"),
("4108","bn","el","Bengali"),
("4109","bn","eo","Bengali"),
("4110","bn","et","Bengali"),
("4111","bn","eu","Bengali"),
("4112","bn","fa","Bengali"),
("4113","bn","fi","Bengali"),
("4114","bn","ga","Bengali"),
("4115","bn","he","Bengali"),
("4116","bn","hi","Bengali"),
("4117","bn","hr","Bengali"),
("4118","bn","hu","Bengali"),
("4119","bn","hy","Bengali"),
("4120","bn","id","Bengali"),
("4121","bn","is","Bengali"),
("4122","bn","it","Bengalese"),
("4123","bn","ja","Bengali"),
("4124","bn","ko","Bengali"),
("4125","bn","ku","Bengali"),
("4126","bn","lv","Bengali"),
("4127","bn","lt","Bengali"),
("4128","bn","mk","Bengali"),
("4129","bn","mt","Bengali"),
("4130","bn","mn","Bengali"),
("4131","bn","ne","Bengali"),
("4132","bn","nl","Bengali"),
("4133","bn","no","Bengali"),
("4134","bn","pa","Bengali"),
("4135","bn","pl","Bengali"),
("4136","bn","pt-pt","Bengalês"),
("4137","bn","pt-br","Bengalês"),
("4138","bn","qu","Bengali"),
("4139","bn","ro","Bengali"),
("4140","bn","ru","Бенгальский"),
("4141","bn","sl","Bengali"),
("4142","bn","so","Bengali"),
("4143","bn","sq","Bengali"),
("4144","bn","sr","Bengali"),
("4145","bn","sv","Bengali"),
("4146","bn","ta","Bengali"),
("4147","bn","th","Bengali"),
("4148","bn","tr","Bengali"),
("4149","bn","uk","Bengali"),
("4150","bn","ur","Bengali"),
("4151","bn","uz","Bengali"),
("4152","bn","vi","Bengali"),
("4153","bn","yi","Bengali"),
("4154","bn","zh-hans","Bengali"),
("4155","bn","zu","Bengali"),
("4156","bn","zh-hant","Bengali"),
("4157","bn","ms","Bengali"),
("4158","bn","gl","Bengali"),
("4159","bn","bn","বাংলাদেশ"),
("4160","bn","az","Bengali"),
("4161","az","en","Azerbaijani"),
("4162","az","es","Azerí"),
("4163","az","de","Aserbeidschanisch"),
("4164","az","fr","Azéri"),
("4165","az","ar","الأذربيجانية"),
("4166","az","bs","Azerbaijani"),
("4167","az","bg","Azerbaijani"),
("4168","az","ca","Azerbaijani"),
("4169","az","cs","Azerbaijani"),
("4170","az","sk","Azerbaijani"),
("4171","az","cy","Azerbaijani"),
("4172","az","da","Azerbaijani"),
("4173","az","el","Azerbaijani"),
("4174","az","eo","Azerbaijani"),
("4175","az","et","Azerbaijani"),
("4176","az","eu","Azerbaijani"),
("4177","az","fa","Azerbaijani"),
("4178","az","fi","Azerbaijani"),
("4179","az","ga","Azerbaijani"),
("4180","az","he","אזרביג\'נית"),
("4181","az","hi","Azerbaijani"),
("4182","az","hr","Azerbaijani"),
("4183","az","hu","Azerbaijani"),
("4184","az","hy","Azerbaijani"),
("4185","az","id","Azerbaijani"),
("4186","az","is","Azerbaijani"),
("4187","az","it","Azerbaigiano"),
("4188","az","ja","アゼルバイジャン語"),
("4189","az","ko","Azerbaijani"),
("4190","az","ku","Azerbaijani"),
("4191","az","lv","Azerbaijani"),
("4192","az","lt","Azerbaijani"),
("4193","az","mk","Azerbaijani"),
("4194","az","mt","Azerbaijani"),
("4195","az","mn","Azerbaijani"),
("4196","az","ne","Azerbaijani"),
("4197","az","nl","Azerbaijani"),
("4198","az","no","Azerbaijani"),
("4199","az","pa","Azerbaijani"),
("4200","az","pl","Azerski"),
("4201","az","pt-pt","Azerbaijano"),
("4202","az","pt-br","Azerbaijano"),
("4203","az","qu","Azerbaijani"),
("4204","az","ro","Azerbaijani"),
("4205","az","ru","Азербайджанский"),
("4206","az","sl","Azerbaijani"),
("4207","az","so","Azerbaijani"),
("4208","az","sq","Azerbaijani"),
("4209","az","sr","Azerbaijani"),
("4210","az","sv","Azerbaijani"),
("4211","az","ta","Azerbaijani"),
("4212","az","th","Azerbaijani"),
("4213","az","tr","Azerbaijani"),
("4214","az","uk","Azerbaijani"),
("4215","az","ur","Azerbaijani"),
("4216","az","uz","Azerbaijani"),
("4217","az","vi","Azerbaijani"),
("4218","az","yi","Azerbaijani"),
("4219","az","zh-hans","阿塞拜疆语"),
("4220","az","zu","Azerbaijani"),
("4221","az","zh-hant","Azerbaijani"),
("4222","az","ms","Azerbaijani"),
("4223","az","gl","Azerbaijani"),
("4224","az","bn","Azerbaijani"),
("4225","az","az","Azərbaycan");

INSERT INTO `wp_icl_locale_map` VALUES 
("da","da_DK"),
("en","en_US");

INSERT INTO `wp_icl_mo_files_domains` VALUES 
("1","wp-content\\plugins\\advanced-custom-fields-table-field\\lang\\acf-table-da_DK.mo","07c328ccfe5e19f72de995bde312036e","acf-table","not_imported","0","1615360998","plugin","advanced-custom-fields-table-field/acf-table.php"),
("2","wp-content\\languages\\da_DK.mo","6941a0e905106caa37d26c234a0314b2","default","not_imported","0","1618771073","other",""),
("3","wp-content\\plugins\\real-media-library\\vendor\\matthiasweb\\wordpress-plugin-updater\\plugin-update-checker-4.4\\languages\\plugin-update-checker-da_DK.mo","d27af8f6216e9564d58b474fd0f9e82a","plugin-update-checker","not_imported","0","1617176096","plugin","real-media-library/index.php"),
("4","wp-content\\languages\\admin-da_DK.mo","60f647ad42a6b08cb26a7ce5da5cbe27","default","not_imported","0","1618771073","other",""),
("5","wp-content\\languages\\da_DK-320f4ad9792aaa6dedb1e71cbdf85d57.json","5e818885d36c3f303f822f68eaa730b3","default-wp-a11y","not_imported","0","1618771073","other",""),
("6","wp-content\\languages\\da_DK-81c889563f09dd13de1701135dc62941.json","d471083e38f8eafb76c533cb3c09e8bd","default-media-views","not_imported","0","1618771073","other",""),
("7","wp-content\\languages\\da_DK-77fdfadaf2e1ca3a027d1956b910bc50.json","78b4469b3dea2f70830556488db18bf8","default-common","not_imported","0","1618771073","other",""),
("8","wp-content\\languages\\da_DK-93882e8f9976382d7f724ac595ed7151.json","461d9a99f1d2339cf6190cbbdb3ba1e9","default-wp-auth-check","not_imported","0","1618771073","other",""),
("9","wp-content\\languages\\da_DK-f575f481034e90e21d832e415fd95fcf.json","6d71e8527c7a5e09a3408f12526be409","default-media-editor","not_imported","0","1618771073","other",""),
("10","wp-content\\languages\\da_DK-1d17475f620f63a92e2c5d2681c51ee8.json","379ac0e7e1537dfd79e78a535abb3e03","default-image-edit","not_imported","0","1618771073","other",""),
("11","wp-content\\languages\\da_DK-7d5ca435e60d92f024d46c9257aaa0f7.json","48f081a5c414d944f43ac374edaa79fe","default-tags-suggest","not_imported","0","1618562139","other",""),
("12","wp-content\\languages\\da_DK-9b256ea9cd54df92095e04c76758ceb0.json","bb029278e3a7fb4782b07484cb45f076","default-inline-edit-post","not_imported","0","1618562139","other",""),
("13","wp-content\\languages\\da_DK-50278328b502f4eb3f2b8b7ab49324a1.json","7aa515bed5eb8149910a623b3b8a022b","default-postbox","not_imported","0","1618562139","other",""),
("14","wp-content\\languages\\da_DK-9d47a87c240c1d10701cd6a02b28aa1b.json","5a99100cc3f8154a7038a02bc1697304","default-tags-box","not_imported","0","1618562139","other",""),
("15","wp-content\\languages\\da_DK-569e85ef168299eb8c8f24d8ef8c8a78.json","2c0c22e72b8ba35fd49256fe5e5ad10c","default-post","not_imported","0","1618562139","other",""),
("16","wp-content\\languages\\da_DK-9c3519f4870fac83dc0dbf18cb6bd4c4.json","f94b09b062fc8a5f27094e9fdb83c6d2","default-wp-color-picker","not_imported","0","1618771073","other",""),
("17","wp-content\\languages\\da_DK-0eebe503220d4a00341eb011b92769b4.json","8c8a60e9723140c83428fa1ec8c4b19f","default-password-strength-meter","not_imported","0","1618562139","other",""),
("18","wp-content\\languages\\da_DK-81d6f084cb273e02e15b01bd9ece87f7.json","123907a4ea17e717053ef80acaa69bae","default-user-profile","not_imported","0","1618562139","other",""),
("19","wp-content\\languages\\da_DK-bf23b24175490c2e46aaf92ff6a0c70f.json","6a6b6a9d02b0df69bf2e7484374bbdeb","default-wp-pointer","not_imported","0","1618562139","other",""),
("20","wp-content\\languages\\da_DK-a25d1cc7bf7ca0b4e114f6bea64943f4.json","726cbde9012e60fa40dbe4eaabfde1ea","default-wp-keycodes","not_imported","0","1618562139","other",""),
("21","wp-content\\languages\\da_DK-1a0cd6a7128913b15c1a10dd68951869.json","ff0330ed49440a3b919c61872d02fd6d","default-wp-blocks","not_imported","0","1618562139","other",""),
("22","wp-content\\languages\\da_DK-7f13c36c641b114bf18cd0bcc9ecc7e0.json","e68773046171c2b09b454580bd0baa37","default-wp-components","not_imported","0","1618562139","other",""),
("23","wp-content\\languages\\da_DK-803bf1ce2131e13efc590c1bc47851fc.json","6f74e1619d493da02e26894232649e2a","default-wp-block-editor","not_imported","0","1618562139","other",""),
("24","wp-content\\languages\\da_DK-1bba9045bb07c89671c88a3f328548e8.json","33e999c2e39f1c4a9e557df6d09e9e72","default-wp-api-fetch","not_imported","0","1618562139","other",""),
("25","wp-content\\languages\\da_DK-49c6d4acf36cf3aca9f0b2a77617304f.json","60cd403fca5ddb3e0dadafdebb97e3a5","default-wp-core-data","not_imported","0","1618562139","other",""),
("26","wp-content\\languages\\da_DK-1780a2033cf98d69ce13c2e5c8510004.json","63e713333da3656b01c5903b6d025152","default-wp-reusable-blocks","not_imported","0","1618562139","other",""),
("27","wp-content\\languages\\da_DK-e2791ba830489d23043be8650a22a22b.json","9c7d424f0d5c894fa7f714be9e71a452","default-wp-server-side-render","not_imported","0","1618562139","other",""),
("28","wp-content\\languages\\da_DK-f8f49d9fc4a9cf7d78ec99285417bd9c.json","ff61bc9f275e9a97053957751a76d570","default-wp-block-library","not_imported","0","1618562139","other",""),
("29","wp-content\\languages\\da_DK-daeb084aab42199d26393a56c3465bc0.json","e06a64ed6fcc9ffa4bf68cae40411d02","default-wp-media-utils","not_imported","0","1618562139","other",""),
("30","wp-content\\languages\\da_DK-bf0f094965d3d4a95b47babcb35fc136.json","4883a7912bf50c933ef1b8923aac483e","default-wp-editor","not_imported","0","1618562139","other",""),
("31","wp-content\\languages\\da_DK-8860e58c20c6a2ab5876a0f07be43bd9.json","ca00c4c21216ba70919fd3c773ef1833","default-wp-edit-post","not_imported","0","1618562139","other",""),
("32","wp-content\\languages\\da_DK-68f2cec7514bf8563c723a4d675fcfe6.json","5f119f1d1ee1491314bdfae2e5ddc34a","default-wp-format-library","not_imported","0","1618562139","other",""),
("33","wp-content\\languages\\da_DK-947c76bb5095da30e16668eec15406b2.json","d1df5bc5cddec675d3a06cf6409fe7df","default-wp-block-directory","not_imported","0","1618562139","other",""),
("34","wp-content\\languages\\continents-cities-da_DK.mo","094c85624e366115de1b221eba6e131f","continents-cities","not_imported","0","1618562139","other",""),
("35","wp-content\\languages\\da_DK-a9dc201dcd011fe71849743133052619.json","89c06df31c61ea554651ee2d2dd161fc","default-nav-menu","not_imported","0","1618562139","other",""),
("36","wp-content\\languages\\da_DK-2b390f85a3048c5b4255fb45960b6514.json","e90f6bd87012e077c912c1864e0bbb62","default-updates","not_imported","0","1618771073","other",""),
("37","wp-content\\languages\\da_DK-7436b7ee9e4f11ac0d618d8cc886eb66.json","98e523b5230604852b77d7ed2f0321ae","default-plugin-install","not_imported","0","1618771073","other",""),
("38","wp-content\\languages\\plugins\\duplicate-post-da_DK.mo","1092e60ef656509aaf5a8826b279236c","duplicate-post","not_imported","0","1618771078","plugin","duplicate-post/duplicate-post.php"),
("39","wp-content/plugins/advanced-custom-fields-table-field/lang/acf-table-da_DK.mo","2e261604c46fad2921b67c2c7f262fe7","acf-table","not_imported","0","1618778514","plugin","advanced-custom-fields-table-field/acf-table.php"),
("40","wp-content/languages/plugins/duplicate-post-da_DK.mo","7e40a654690ddb80ca2ba329b5fb370c","duplicate-post","not_imported","0","1618778514","plugin","duplicate-post/duplicate-post.php"),
("41","wp-content/languages/da_DK.mo","bd64ebfa57da4a7590c2d35e1aca5695","default","not_imported","0","1618778514","other",""),
("42","wp-content/plugins/real-media-library/vendor/matthiasweb/wordpress-plugin-updater/plugin-update-checker-4.4/languages/plugin-update-checker-da_DK.mo","3ea3e156d0bdf70694df11b558577208","plugin-update-checker","not_imported","0","1618778516","plugin","real-media-library/index.php"),
("43","wp-content/languages/da_DK-0eebe503220d4a00341eb011b92769b4.json","2bbbde1cfbde106240549d5a8ef66a42","default-password-strength-meter","not_imported","0","1618778514","other",""),
("44","wp-content/languages/da_DK-81d6f084cb273e02e15b01bd9ece87f7.json","7c4465349d89e7819d7b7d182a117547","default-user-profile","not_imported","0","1618778514","other",""),
("45","wp-content/languages/admin-da_DK.mo","24691194ee620ec7e35031935099184e","default","not_imported","0","1618778514","other",""),
("46","wp-content/languages/da_DK-320f4ad9792aaa6dedb1e71cbdf85d57.json","a8627b2cefd3d93d29f33c0cc7934bff","default-wp-a11y","not_imported","0","1618778514","other",""),
("47","wp-content/languages/da_DK-81c889563f09dd13de1701135dc62941.json","36cc82e3bda8dd6460773dd257775373","default-media-views","not_imported","0","1618778514","other",""),
("48","wp-content/languages/da_DK-77fdfadaf2e1ca3a027d1956b910bc50.json","92be1d9811a8d926327469cba7370267","default-common","not_imported","0","1618778514","other",""),
("49","wp-content/languages/da_DK-93882e8f9976382d7f724ac595ed7151.json","c57078eb8129a54970dd5568b9956cc4","default-wp-auth-check","not_imported","0","1618778514","other",""),
("50","wp-content/languages/da_DK-f575f481034e90e21d832e415fd95fcf.json","8e8d876c3bad4a9d933d8f90ceb9c9d0","default-media-editor","not_imported","0","1618778514","other",""),
("51","wp-content/languages/da_DK-1d17475f620f63a92e2c5d2681c51ee8.json","39c63e34a5bc488478cadaae3614e117","default-image-edit","not_imported","0","1618778514","other",""),
("52","wp-content/languages/da_DK-4a38fe1c0c45989e44682ba6109d9f46.json","8ad4db6d8b283f7095bb827f533d3986","default-site-health","not_imported","0","1618778514","other",""),
("53","wp-content/languages/da_DK-6025add6bde16aaeb12787d250f9b414.json","94bc9a9511a14ede88457f30a3367d36","default-admin-comments","not_imported","0","1618778514","other",""),
("54","wp-content/languages/da_DK-50278328b502f4eb3f2b8b7ab49324a1.json","bb00d7bb80523d7930bcefcec852bc3b","default-postbox","not_imported","0","1618778514","other",""),
("55","wp-content/languages/da_DK-e2e4c4b80f3adf2c70b431bfdb1b4872.json","c62b807903e546cda1e9d460622a7647","default-dashboard","not_imported","0","1618778514","other",""),
("56","wp-content/languages/da_DK-7436b7ee9e4f11ac0d618d8cc886eb66.json","64604b0f2263ffb6d332c729ecb6f669","default-plugin-install","not_imported","0","1618778514","other",""),
("57","wp-content/languages/da_DK-2b390f85a3048c5b4255fb45960b6514.json","737b713cd266199b945311be93a4f07a","default-updates","not_imported","0","1618778514","other",""),
("58","wp-content/languages/da_DK-9c3519f4870fac83dc0dbf18cb6bd4c4.json","c6050b29d05a7cab1f0abebb0abac6b0","default-wp-color-picker","not_imported","0","1618778514","other",""),
("59","wp-content/languages/da_DK-7d5ca435e60d92f024d46c9257aaa0f7.json","643e218add3d60860f796a18b0872e2b","default-tags-suggest","not_imported","0","1618778514","other",""),
("60","wp-content/languages/da_DK-9d47a87c240c1d10701cd6a02b28aa1b.json","7e96cea81a95c74d6011904626374077","default-tags-box","not_imported","0","1618778514","other",""),
("61","wp-content/languages/da_DK-569e85ef168299eb8c8f24d8ef8c8a78.json","27f21c4a1172d2d234ad7f885b190cc4","default-post","not_imported","0","1618778514","other",""),
("62","wp-content/languages/da_DK-9b256ea9cd54df92095e04c76758ceb0.json","8648c8b6c9ab5dbc1fb9ed1ccc3d5a14","default-inline-edit-post","not_imported","0","1618778514","other",""),
("63","wp-content/languages/da_DK-a25d1cc7bf7ca0b4e114f6bea64943f4.json","90933e53f2e9bc383ad84bf85dbb0b17","default-wp-keycodes","not_imported","0","1618778514","other",""),
("64","wp-content/languages/da_DK-1a0cd6a7128913b15c1a10dd68951869.json","5625571a643c7d5f2c50e50a7ecd7036","default-wp-blocks","not_imported","0","1618778514","other",""),
("65","wp-content/languages/da_DK-7f13c36c641b114bf18cd0bcc9ecc7e0.json","6810d63511a5a99ed25356ea16c411c2","default-wp-components","not_imported","0","1618778514","other",""),
("66","wp-content/languages/da_DK-803bf1ce2131e13efc590c1bc47851fc.json","6a301ac5e4a679fbbd1ecab1697a8792","default-wp-block-editor","not_imported","0","1618778514","other",""),
("67","wp-content/languages/da_DK-1bba9045bb07c89671c88a3f328548e8.json","f76dfdbf2fdbc87318d78e479412f140","default-wp-api-fetch","not_imported","0","1618778514","other",""),
("68","wp-content/languages/da_DK-49c6d4acf36cf3aca9f0b2a77617304f.json","3281c8b84d68f8e432080ad90ccafe8d","default-wp-core-data","not_imported","0","1618778514","other",""),
("69","wp-content/languages/da_DK-1780a2033cf98d69ce13c2e5c8510004.json","d54ca8b4e01aa7e00a56668877a74184","default-wp-reusable-blocks","not_imported","0","1618778514","other",""),
("70","wp-content/languages/da_DK-e2791ba830489d23043be8650a22a22b.json","0bffe58bfdb0024f9b05753d0ad73fee","default-wp-server-side-render","not_imported","0","1618778514","other",""),
("71","wp-content/languages/da_DK-f8f49d9fc4a9cf7d78ec99285417bd9c.json","ee7e4e1bc7c5c897defc965b542cc318","default-wp-block-library","not_imported","0","1618778514","other",""),
("72","wp-content/languages/da_DK-daeb084aab42199d26393a56c3465bc0.json","c718651e6ee2560c4fa1c2e0cb08c1ad","default-wp-media-utils","not_imported","0","1618778514","other",""),
("73","wp-content/languages/da_DK-bf0f094965d3d4a95b47babcb35fc136.json","1bfd7f526f8094ea27ecc72537f30212","default-wp-editor","not_imported","0","1618778514","other",""),
("74","wp-content/languages/da_DK-8860e58c20c6a2ab5876a0f07be43bd9.json","45ae091cf006616ca71917b7095fe552","default-wp-edit-post","not_imported","0","1618778514","other",""),
("75","wp-content/languages/da_DK-68f2cec7514bf8563c723a4d675fcfe6.json","5be4f22d8e64d19f95422024b32cfb09","default-wp-format-library","not_imported","0","1618778514","other",""),
("76","wp-content/languages/da_DK-947c76bb5095da30e16668eec15406b2.json","ed907fc20880834ebf5dd97dc461b853","default-wp-block-directory","not_imported","0","1618778514","other",""),
("77","wp-content/languages/da_DK-7b74c8457eaa7fcc50db41b431f8a003.json","378ff918b6b94019472b41dc39e8beef","default-admin-tags","not_imported","0","1618778514","other",""),
("78","wp-content/languages/da_DK-ca28138671823450e87dfd354f7afc6b.json","9192e3ff091cce446f45f487ef34a2b7","default-inline-edit-tax","not_imported","0","1618778514","other",""),
("79","wp-content/languages/da_DK-a9dc201dcd011fe71849743133052619.json","c503c24ab0471ce268a4aa1c8c6e1bcb","default-nav-menu","not_imported","0","1618778514","other",""),
("80","wp-content/languages/da_DK-bf23b24175490c2e46aaf92ff6a0c70f.json","fb9be4fe286e0359181b7edb933239d4","default-wp-pointer","not_imported","0","1618778514","other","");

INSERT INTO `wp_icl_string_packages` VALUES 
("1","gutenberg","Gutenberg","1248","Page Builder Page 1248","","","1248","{\"total\":8,\"to_translate\":{\"da\":8}}");

INSERT INTO `wp_icl_string_translations` VALUES 
("1","148","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("2","149","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("3","150","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42"),
("4","151","da","10","",NULL,NULL,"","0","2021-04-16 14:59:42");

INSERT INTO `wp_icl_strings` VALUES 
("1","en","admin_texts_cptui_post_types","[cptui_post_types][country]label","Milo - Countries",NULL,NULL,"","LINE",NULL,"0","","dfef94161687439f939aa8069f867541","optional",NULL),
("2","en","admin_texts_cptui_post_types","[cptui_post_types][country]singular_label","Country",NULL,NULL,"","LINE",NULL,"0","","ec9015367efd4ad9fb17e017f933e15a","optional",NULL),
("3","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","396d00a8c8b9166d549963010dc6c4f2","optional",NULL),
("4","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","cf7e0ab11faf0a560d6fd7ff94f137bb","optional",NULL),
("5","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","8cca295183875672b82db44972d90258","optional",NULL),
("6","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","52de426c43bd190cff8c890acecf923f","optional",NULL),
("7","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","41ab37f403c20c1240659704ddef3101","optional",NULL),
("8","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","a496bceab1501e319e92b77264b1b0f6","optional",NULL),
("9","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","9137e5a7028c44e8abfa4dcdd351c698","optional",NULL),
("10","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","be40c292dec6f038ccc9da5c0173cfeb","optional",NULL),
("11","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","40c495a8a91e06a46d170e8265b444e1","optional",NULL),
("12","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","fb5b2d7ab80b9d1a0bbcd39144d50bf6","optional",NULL),
("13","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","40cc57caf57e99e67420752661f9878f","optional",NULL),
("14","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","971136ef1e6d74e87a745ed270937784","optional",NULL),
("15","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","58e8f85b14c3025b7494af6fd24108e2","optional",NULL),
("16","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","e7b2b4cf37078c4115b05346e2d13a08","optional",NULL),
("17","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","da75256312552a3390e8b6c9421ecb54","optional",NULL),
("18","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","300facef9fc72b63316d5632aef04107","optional",NULL),
("19","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","18af464b300fb289f9e4598eefd7c360","optional",NULL),
("20","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","67dce5a7a7fdf6609a4f00d7fce85d25","optional",NULL),
("21","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","0a3a70bf737cdd6fea820dfd567faead","optional",NULL),
("22","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","06d3af4116528186bab053e22a31f870","optional",NULL),
("23","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","778f68620245bf3d61c5e421347460d0","optional",NULL),
("24","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","caca95e26513cf2466ffa7bf873c600c","optional",NULL),
("25","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","b1d0184a9febb9c0a4224fb1cc16ad69","optional",NULL),
("26","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","9772893cee6e7a4c9583d0185d089cc8","optional",NULL),
("27","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","87ae6899efc1e5085ee6e2f930c42ac9","optional",NULL),
("28","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","27d45f817fee1fbe88178e6698c887f1","optional",NULL),
("29","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","e517f3ced79a741b0c41c879b0015140","optional",NULL),
("30","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","d120e1072a7627487c29a202202129c5","optional",NULL),
("31","en","admin_texts_cptui_post_types","[cptui_post_types][country][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","02566eb9e57f234a02168add1b4d57f9","optional",NULL),
("32","en","admin_texts_cptui_post_types","[cptui_post_types][assets]label","Milo - Assets",NULL,NULL,"","LINE",NULL,"0","","77e75b0d294a64b71df4e67c2426308a","optional",NULL),
("33","en","admin_texts_cptui_post_types","[cptui_post_types][assets]singular_label","Milo Asset",NULL,NULL,"","LINE",NULL,"0","","b43d214c4ca3fdc9ea12be531f11659a","optional",NULL),
("34","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","ad390b17dfb18f2e99d381e00ab7ad97","optional",NULL),
("35","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","4d572ef3357a4b1d0664a89bf1276816","optional",NULL),
("36","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","a1c11f12a209191fbac19a6be760997c","optional",NULL),
("37","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","7cf98c120504cc2b5c2752bc70298c3c","optional",NULL),
("38","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","4c8de09819a8112497d05ca804bbe821","optional",NULL),
("39","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","bdf84ccab083d4ed9a4c3a26ec31790f","optional",NULL),
("40","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","d19ad8fb4c0d2471e6950e22ff18d49d","optional",NULL),
("41","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","81f544861d5bc9bcbc565092082bd725","optional",NULL),
("42","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","8379060b9065873020c8463b64cc760b","optional",NULL),
("43","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","9602a13449dc7dd46c0441e23c501a87","optional",NULL),
("44","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","896667442597519ee549a02dd8e020eb","optional",NULL),
("45","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","d7e1c086cf9d444cb92ae83f3a8f7b86","optional",NULL),
("46","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","dfa486ba920f8760468fd60c89eb0c96","optional",NULL),
("47","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","80a4f62d4a16ddb5f4f2d8be42251cdf","optional",NULL),
("48","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","33ba6e791bd43157e024b219bd02517a","optional",NULL),
("49","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","b1b899c1d5bde8c5e254abf88a7401ef","optional",NULL),
("50","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","9d2d9d71e0c4f771b71ba27909e5f1c3","optional",NULL),
("51","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","a664eefbe73c2fe28c8d9424a41ec8b7","optional",NULL),
("52","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","3844fdae0edc470bc12e3b3dd41eb62a","optional",NULL),
("53","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","7dce8c628c81e2f9cf711d6b67ac8cd8","optional",NULL),
("54","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","c911c37375e31b1726554fce77fc9365","optional",NULL),
("55","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","70c5fbdbd8d37a0b54d44d8718ca35f5","optional",NULL),
("56","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","34ce9d9da0c4e72c7895418d7ee361ca","optional",NULL),
("57","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","12022f46bfee11e09a3b5dafcb26030a","optional",NULL),
("58","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","6a68689b629076abc4ccb66ee437c319","optional",NULL),
("59","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","b593e3e24769a42bc2394cd8e790d078","optional",NULL),
("60","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","4c528962a8d83e1171ddd9b347339f9d","optional",NULL),
("61","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","f43142a8c83a148d2976d888cc79c016","optional",NULL),
("62","en","admin_texts_cptui_post_types","[cptui_post_types][assets][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","9694702f87d3756266a30344f4ba6419","optional",NULL),
("63","en","admin_texts_cptui_post_types","[cptui_post_types][statement]label","Milo - Statements",NULL,NULL,"","LINE",NULL,"0","","b187ec1867e6e7f3bc15e4dd5e2faefe","optional",NULL),
("64","en","admin_texts_cptui_post_types","[cptui_post_types][statement]singular_label","Statement",NULL,NULL,"","LINE",NULL,"0","","3b57aaa4c58cdc9ba146adfaa5f9679a","optional",NULL),
("65","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","3bc832c9996b01b1271841eb11258e8d","optional",NULL),
("66","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","2d2affe7e59c765353b5a014445df0fe","optional",NULL),
("67","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","b37233eb9c53534c9fe4548aa8dc4003","optional",NULL),
("68","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","2fd1da3f886f59ec80ce210ef248b605","optional",NULL),
("69","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","74c686419f2f07662cd23d568c9b98dd","optional",NULL),
("70","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","2f771e93889c2b8ef0caaacfdd37d5f9","optional",NULL),
("71","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","1cce888d8338eb688204fab72359c06f","optional",NULL),
("72","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","3c112e095aa038d9a7108814a3824fdc","optional",NULL),
("73","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","501c38f133f9e912cadca064cb6c90c4","optional",NULL),
("74","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","b640316437e6e6b952816be27602b06f","optional",NULL),
("75","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","d7cc1378661b46073eb9a292aee2195d","optional",NULL),
("76","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","9da38de97143e926ccfb213e90cb977f","optional",NULL),
("77","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","280de6725f1ba2f82ee42b31bd7b5546","optional",NULL),
("78","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","72cf569bb9166bbfedcd2587276074b6","optional",NULL),
("79","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","bfe03cd4497ce6589784c1c6a54316b0","optional",NULL),
("80","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","e570511503163a94f3fa6b00ec07f407","optional",NULL),
("81","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","fa5cc8df2257ad9212513e27a74f9a34","optional",NULL),
("82","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","5109e4473daea6c8cc43370b2635aa7a","optional",NULL),
("83","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","8a4da81efdba8e50374ca41262326b46","optional",NULL),
("84","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","a2a0d6d5ff80bb9395445ac23bc2d2e1","optional",NULL),
("85","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","5c631ca9a32b91e26443d44f1286ac17","optional",NULL),
("86","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","d5f62d1d7967b3184e981119089d3bbe","optional",NULL),
("87","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","2aa83aed929d49fae313b10ecec27dd2","optional",NULL),
("88","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","7f1fcbcf40a8052091a5c5d9b8e0ada3","optional",NULL),
("89","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","3436c2ba642a682f00bb83a9e0628eea","optional",NULL),
("90","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","3bbbd30e034de92c9ca8dced58bd6b07","optional",NULL),
("91","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","f13b3dbfad352d694a00564964f0037b","optional",NULL),
("92","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","9f9b2cb9c0d9a14f27134da40817a6e5","optional",NULL),
("93","en","admin_texts_cptui_post_types","[cptui_post_types][statement][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","5f9b6eb63bbca49fa8396044e4a7371a","optional",NULL),
("94","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks]label","Milo - Global",NULL,NULL,"","LINE",NULL,"0","","d86a1d258c565ddb64f55aec94c16f59","optional",NULL),
("95","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks]singular_label","Global block",NULL,NULL,"","LINE",NULL,"0","","27878f2458b7089695effe800a48c3c1","optional",NULL),
("96","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","84d2831e8b35c9ad3468150316413313","optional",NULL),
("97","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","00e62159152cf7f97aa3293fe848dacf","optional",NULL),
("98","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]add_new","",NULL,NULL,"","LINE",NULL,"0","","e9fd5f8c4762822ae5aabcab92238298","optional",NULL),
("99","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","9c22df04fb5b03cda57852c9802832dd","optional",NULL),
("100","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","3962cce3e05f6638bacb01ec10969c0d","optional",NULL),
("101","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]new_item","",NULL,NULL,"","LINE",NULL,"0","","664d36e2f59c0e79cbc6d942d8819740","optional",NULL),
("102","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","bd451f05034638fb321e2190a130b8b6","optional",NULL),
("103","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]view_items","",NULL,NULL,"","LINE",NULL,"0","","d5e0d5b8a07d04895abf475303e6f10b","optional",NULL),
("104","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","30e3b6bf4342a2e5c481ad940d9fe7c0","optional",NULL),
("105","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","8490a4277cdcf3345308cddf32745f09","optional",NULL),
("106","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]not_found_in_trash","",NULL,NULL,"","LINE",NULL,"0","","b942a8cf3d7efb3c1d5704c72b09535a","optional",NULL),
("107","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","c82fa5e8df766ffc36c1d3a9a8611f46","optional",NULL),
("108","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]featured_image","",NULL,NULL,"","LINE",NULL,"0","","816b80ab406926de40ed4b3a28957a15","optional",NULL),
("109","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]set_featured_image","",NULL,NULL,"","LINE",NULL,"0","","f190061f616c04e5a4f1aa58e97c05f2","optional",NULL),
("110","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]remove_featured_image","",NULL,NULL,"","LINE",NULL,"0","","6a223ee2f32f474468861a380a197cc3","optional",NULL),
("111","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]use_featured_image","",NULL,NULL,"","LINE",NULL,"0","","78211be7740ca2d6d2326b147c72389a","optional",NULL),
("112","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]archives","",NULL,NULL,"","LINE",NULL,"0","","ac2e8bcd28043cfe783e55e78d0c3c98","optional",NULL),
("113","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]insert_into_item","",NULL,NULL,"","LINE",NULL,"0","","a8ecb94b31bb1e7e639e11949808918f","optional",NULL),
("114","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]uploaded_to_this_item","",NULL,NULL,"","LINE",NULL,"0","","7f029a8594c8d69e41496dddb0b7d1a1","optional",NULL),
("115","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]filter_items_list","",NULL,NULL,"","LINE",NULL,"0","","53a47df522c73d91a10d795b6b786794","optional",NULL),
("116","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","88c0e8f4b867c8f5008e8c0ee254256e","optional",NULL),
("117","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","7c3fbea6b7e11711c6e267d531ed3444","optional",NULL),
("118","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]attributes","",NULL,NULL,"","LINE",NULL,"0","","526f410118c2dc1daf69d5f3164510e9","optional",NULL),
("119","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]name_admin_bar","",NULL,NULL,"","LINE",NULL,"0","","e48b8c5614bf422db6fa4f560f2b07f7","optional",NULL),
("120","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_published","",NULL,NULL,"","LINE",NULL,"0","","a833ce7d1f8d8d4c01a70c496ee34168","optional",NULL),
("121","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_published_privately","",NULL,NULL,"","LINE",NULL,"0","","76620701c3e4c15555dd72562f9bc00e","optional",NULL),
("122","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_reverted_to_draft","",NULL,NULL,"","LINE",NULL,"0","","005ee8e7f8d9fe9ba97cc4f057d5a8cf","optional",NULL),
("123","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_scheduled","",NULL,NULL,"","LINE",NULL,"0","","cbfbf5756888dadb299d376f9ad39d18","optional",NULL),
("124","en","admin_texts_cptui_post_types","[cptui_post_types][section_blocks][labels]item_updated","",NULL,NULL,"","LINE",NULL,"0","","7e36c3b0c52553aae421274aaaa63d24","optional",NULL),
("125","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region]label","Regions",NULL,NULL,"","LINE",NULL,"0","","2bbb20749a39bd48aee6055b92dce552","optional",NULL),
("126","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region]singular_label","Region",NULL,NULL,"","LINE",NULL,"0","","8c55165ad686932d2ce36aecc333d8cc","optional",NULL),
("127","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]menu_name","",NULL,NULL,"","LINE",NULL,"0","","3efc83be8452ecbc60e7012f0fa98af1","optional",NULL),
("128","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]all_items","",NULL,NULL,"","LINE",NULL,"0","","deff088e19ea9c5cd37e5b79c2cd65ff","optional",NULL),
("129","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]edit_item","",NULL,NULL,"","LINE",NULL,"0","","5b38d47405f2be417c588eba26d1828c","optional",NULL),
("130","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]view_item","",NULL,NULL,"","LINE",NULL,"0","","e0dfa1b833c031cb7cbd32bbee8a9be4","optional",NULL),
("131","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]update_item","",NULL,NULL,"","LINE",NULL,"0","","af2bfd3c650a484f9f20f1f8c41639a9","optional",NULL),
("132","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]add_new_item","",NULL,NULL,"","LINE",NULL,"0","","1ae9401d40bb56b8af854f661177da2f","optional",NULL),
("133","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]new_item_name","",NULL,NULL,"","LINE",NULL,"0","","08e03deeefbd282007e48b75a6c78bf8","optional",NULL),
("134","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]parent_item","",NULL,NULL,"","LINE",NULL,"0","","e103b7c8c4a6c65fed6777c7b26718af","optional",NULL),
("135","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]parent_item_colon","",NULL,NULL,"","LINE",NULL,"0","","e21324f9ba700f1424b14c6f30e5f94f","optional",NULL),
("136","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]search_items","",NULL,NULL,"","LINE",NULL,"0","","28f6958f8b727daf495a7769eb8b1264","optional",NULL),
("137","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]popular_items","",NULL,NULL,"","LINE",NULL,"0","","45657cbfdabda6155841b470a733f7b0","optional",NULL),
("138","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]separate_items_with_commas","",NULL,NULL,"","LINE",NULL,"0","","3e5d4957b6a03c71a50e2345dc08e5e5","optional",NULL),
("139","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]add_or_remove_items","",NULL,NULL,"","LINE",NULL,"0","","ce82e5d4094d12b3ce48bac67b5423d8","optional",NULL),
("140","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]choose_from_most_used","",NULL,NULL,"","LINE",NULL,"0","","6f517ab2dcb1b4c45e3e56419a04f72d","optional",NULL),
("141","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]not_found","",NULL,NULL,"","LINE",NULL,"0","","31904ca4827215c5177e9b2e1adda3b6","optional",NULL),
("142","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]no_terms","",NULL,NULL,"","LINE",NULL,"0","","3f28186f117abd3629e6a27eda8177a2","optional",NULL),
("143","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]items_list_navigation","",NULL,NULL,"","LINE",NULL,"0","","05baeb38f2745d3ae6c1844c2e6d9385","optional",NULL),
("144","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]items_list","",NULL,NULL,"","LINE",NULL,"0","","ab6da9110417d82cde7adce10dea91a6","optional",NULL),
("145","en","admin_texts_cptui_taxonomies","[cptui_taxonomies][region][labels]back_to_items","",NULL,NULL,"","LINE",NULL,"0","","fd9d35e8a4f0d8dd408759201f35dc38","optional",NULL),
("146","en","WP","Blog Title","Milo",NULL,NULL,"","LINE",NULL,"0","","5ff0887b4c486c0329311e8d30610d58","optional",NULL),
("147","en","WP","Tagline","Just another WordPress site",NULL,NULL,"","LINE",NULL,"0","","6e70f8f3e0f8c134711af40ab6e4931b","optional",NULL),
("148","en","WordPress","URL slug: country","country",NULL,NULL,"","LINE",NULL,"10","","c4873741705585a9909a274363b9a956","optional",NULL),
("149","en","WordPress","URL slug: assets","assets",NULL,NULL,"","LINE",NULL,"10","","d4cd0aceb06768d8a9b86bfd71be4c4a","optional",NULL),
("150","en","WordPress","URL slug: statement","statement",NULL,NULL,"","LINE",NULL,"10","","9f5c81d657290e7153b02f96e2f95b0f","optional",NULL),
("151","en","WordPress","URL slug: section_blocks","section_blocks",NULL,NULL,"","LINE",NULL,"10","","9b8cc2ce9ae8ca99673d7fbd17ec94b4","optional",NULL),
("152","en","gutenberg-1248","07fbe196fb74a9ff11f1fe3572fbbfd3","This is content from the default Wordpress template.","1","1","","LINE","core/paragraph","0","","82260087ff605457be8e4a06f72649ef","optional","8");

INSERT INTO `wp_icl_translation_batches` VALUES 
("1","Manual Translations from April the 18th, 2021",NULL,NULL,"2021-04-18 14:32:43");

INSERT INTO `wp_icl_translation_status` VALUES 
("1","436","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("2","437","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("3","438","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("4","439","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("5","440","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("6","441","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("7","442","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("8","443","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("9","444","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("10","445","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("11","446","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("12","447","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("13","448","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("14","449","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("15","450","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("16","451","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("17","452","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("18","453","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("19","454","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("20","455","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("21","456","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("22","457","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("23","458","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("24","459","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("25","460","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("26","461","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("27","462","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("28","463","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("29","464","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("30","465","9","0","0","","","0","","2021-04-18 14:41:17","0",NULL,NULL,NULL,"1",NULL),
("31","466","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("32","467","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("33","468","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("34","469","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("35","470","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("36","471","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("37","472","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("38","473","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("39","474","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("40","475","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("41","476","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("42","477","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("43","478","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("44","479","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("45","480","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("46","481","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("47","482","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("48","483","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("49","484","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("50","485","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("51","486","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("52","487","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("53","488","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("54","489","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("55","490","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("56","491","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("57","492","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("58","493","9","0","0","","","0","","2021-04-18 14:41:18","0",NULL,NULL,NULL,"1",NULL),
("59","494","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("60","495","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("61","496","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("62","497","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("63","498","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("64","499","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("65","500","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("66","501","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("67","502","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("68","503","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("69","504","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("70","505","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("71","506","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("72","507","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("73","508","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("74","509","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("75","510","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("76","511","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("77","512","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("78","513","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("79","514","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("80","515","9","0","0","","","0","","2021-04-18 14:41:19","0",NULL,NULL,NULL,"1",NULL),
("81","516","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("82","517","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("83","518","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("84","519","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("85","520","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("86","521","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("87","522","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("88","523","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("89","524","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("90","525","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("91","526","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("92","527","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("93","528","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("94","529","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("95","530","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("96","531","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("97","532","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("98","533","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("99","534","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("100","535","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("101","536","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("102","537","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("103","538","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("104","539","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("105","540","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("106","541","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("107","542","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("108","543","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("109","544","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("110","545","9","0","0","","","0","","2021-04-18 14:41:20","0",NULL,NULL,NULL,"1",NULL),
("111","546","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("112","547","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("113","548","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("114","549","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("115","550","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("116","551","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("117","552","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("118","553","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("119","554","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("120","555","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("121","556","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("122","557","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("123","558","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("124","559","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("125","560","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("126","561","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("127","562","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("128","563","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("129","564","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("130","565","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("131","566","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("132","567","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("133","568","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("134","569","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("135","570","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("136","571","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("137","572","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("138","573","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("139","574","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("140","575","9","0","0","","","0","","2021-04-18 14:41:21","0",NULL,NULL,NULL,"1",NULL),
("141","576","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("142","577","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("143","578","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("144","579","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("145","580","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("146","581","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("147","582","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("148","583","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("149","584","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("150","585","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("151","586","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("152","587","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("153","588","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("154","589","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("155","590","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL),
("156","591","9","0","0","","","0","","2021-04-18 14:41:22","0",NULL,NULL,NULL,"1",NULL);

INSERT INTO `wp_icl_translations` VALUES 
("1","post_acf-field","7","7","en",NULL),
("2","post_acf-field","10","10","en",NULL),
("3","post_acf-field","59","59","en",NULL),
("4","post_acf-field","60","60","en",NULL),
("5","post_acf-field","61","61","en",NULL),
("6","post_acf-field","62","62","en",NULL),
("7","post_acf-field","63","63","en",NULL),
("8","post_acf-field","64","64","en",NULL),
("9","post_acf-field","65","65","en",NULL),
("10","post_acf-field","101","101","en",NULL),
("11","post_acf-field","102","102","en",NULL),
("12","post_acf-field","123","123","en",NULL),
("13","post_acf-field","126","126","en",NULL),
("14","post_acf-field","129","129","en",NULL),
("15","post_acf-field","130","130","en",NULL),
("16","post_acf-field","138","138","en",NULL),
("17","post_acf-field","148","148","en",NULL),
("18","post_acf-field","149","149","en",NULL),
("19","post_acf-field","150","150","en",NULL),
("20","post_acf-field","151","151","en",NULL),
("21","post_acf-field","152","152","en",NULL),
("22","post_acf-field","156","156","en",NULL),
("23","post_acf-field","159","159","en",NULL),
("24","post_acf-field","163","163","en",NULL),
("25","post_acf-field","174","174","en",NULL),
("26","post_acf-field","179","179","en",NULL),
("27","post_acf-field","180","180","en",NULL),
("28","post_acf-field","181","181","en",NULL),
("29","post_acf-field","182","182","en",NULL),
("30","post_acf-field","183","183","en",NULL),
("31","post_acf-field","184","184","en",NULL),
("32","post_acf-field","185","185","en",NULL),
("33","post_acf-field","186","186","en",NULL),
("34","post_acf-field","187","187","en",NULL),
("35","post_acf-field","189","189","en",NULL),
("36","post_acf-field","190","190","en",NULL),
("37","post_acf-field","191","191","en",NULL),
("38","post_acf-field","192","192","en",NULL),
("39","post_acf-field","193","193","en",NULL),
("40","post_acf-field","194","194","en",NULL),
("41","post_acf-field","195","195","en",NULL),
("42","post_acf-field","235","235","en",NULL),
("43","post_acf-field","236","236","en",NULL),
("44","post_acf-field","250","250","en",NULL),
("45","post_acf-field","251","251","en",NULL),
("46","post_acf-field","252","252","en",NULL),
("47","post_acf-field","253","253","en",NULL),
("48","post_acf-field","254","254","en",NULL),
("49","post_acf-field","260","260","en",NULL),
("50","post_acf-field","263","263","en",NULL),
("51","post_acf-field","264","264","en",NULL),
("52","post_acf-field","265","265","en",NULL),
("53","post_acf-field","273","273","en",NULL),
("54","post_acf-field","280","280","en",NULL),
("55","post_acf-field","281","281","en",NULL),
("56","post_acf-field","282","282","en",NULL),
("57","post_acf-field","283","283","en",NULL),
("58","post_acf-field","284","284","en",NULL),
("59","post_acf-field","287","287","en",NULL),
("60","post_acf-field","290","290","en",NULL),
("61","post_acf-field","293","293","en",NULL),
("62","post_acf-field","294","294","en",NULL),
("63","post_acf-field","318","318","en",NULL),
("64","post_acf-field","320","320","en",NULL),
("65","post_acf-field","321","321","en",NULL),
("66","post_acf-field","339","339","en",NULL),
("67","post_acf-field","352","352","en",NULL),
("68","post_acf-field","353","353","en",NULL),
("69","post_acf-field","354","354","en",NULL),
("70","post_acf-field","355","355","en",NULL),
("71","post_acf-field","360","360","en",NULL),
("72","post_acf-field","361","361","en",NULL),
("73","post_acf-field","362","362","en",NULL),
("74","post_acf-field","363","363","en",NULL),
("75","post_acf-field","370","370","en",NULL),
("76","post_acf-field","374","374","en",NULL),
("77","post_acf-field","375","375","en",NULL),
("78","post_acf-field","376","376","en",NULL),
("79","post_acf-field","377","377","en",NULL),
("80","post_acf-field","378","378","en",NULL),
("81","post_acf-field","379","379","en",NULL),
("82","post_acf-field","388","388","en",NULL),
("83","post_acf-field","400","400","en",NULL),
("84","post_acf-field","401","401","en",NULL),
("85","post_acf-field","402","402","en",NULL),
("86","post_acf-field","406","406","en",NULL),
("87","post_acf-field","407","407","en",NULL),
("88","post_acf-field","408","408","en",NULL),
("89","post_acf-field","413","413","en",NULL),
("90","post_acf-field","414","414","en",NULL),
("91","post_acf-field","415","415","en",NULL),
("92","post_acf-field","416","416","en",NULL),
("93","post_acf-field","417","417","en",NULL),
("94","post_acf-field","418","418","en",NULL),
("95","post_acf-field","419","419","en",NULL),
("96","post_acf-field","429","429","en",NULL),
("97","post_acf-field","430","430","en",NULL),
("98","post_acf-field","431","431","en",NULL),
("99","post_acf-field","432","432","en",NULL),
("100","post_acf-field","435","435","en",NULL),
("101","post_acf-field","436","436","en",NULL),
("102","post_acf-field","437","437","en",NULL),
("103","post_acf-field","438","438","en",NULL),
("104","post_acf-field","439","439","en",NULL),
("105","post_acf-field","448","448","en",NULL),
("106","post_acf-field","449","449","en",NULL),
("107","post_acf-field","450","450","en",NULL),
("108","post_acf-field","451","451","en",NULL),
("109","post_acf-field","453","453","en",NULL),
("110","post_acf-field","456","456","en",NULL),
("111","post_acf-field","457","457","en",NULL),
("112","post_acf-field","458","458","en",NULL),
("113","post_acf-field","459","459","en",NULL),
("114","post_acf-field","460","460","en",NULL),
("115","post_acf-field","467","467","en",NULL),
("116","post_acf-field","468","468","en",NULL),
("117","post_acf-field","469","469","en",NULL),
("118","post_acf-field","470","470","en",NULL),
("119","post_acf-field","471","471","en",NULL),
("120","post_acf-field","479","479","en",NULL),
("121","post_acf-field","486","486","en",NULL),
("122","post_acf-field","489","489","en",NULL),
("123","post_acf-field","490","490","en",NULL),
("124","post_acf-field","503","503","en",NULL),
("125","post_acf-field","516","516","en",NULL),
("126","post_acf-field","523","523","en",NULL),
("127","post_acf-field","524","524","en",NULL),
("128","post_acf-field","525","525","en",NULL),
("129","post_acf-field","526","526","en",NULL),
("130","post_acf-field","530","530","en",NULL),
("131","post_acf-field","531","531","en",NULL),
("132","post_acf-field","545","545","en",NULL),
("133","post_acf-field","546","546","en",NULL),
("134","post_acf-field","547","547","en",NULL),
("135","post_acf-field","548","548","en",NULL),
("136","post_acf-field","555","555","en",NULL),
("137","post_acf-field","573","573","en",NULL),
("138","post_acf-field","584","584","en",NULL),
("139","post_acf-field","585","585","en",NULL),
("140","post_acf-field","606","606","en",NULL),
("141","post_acf-field","607","607","en",NULL),
("142","post_acf-field","630","630","en",NULL),
("143","post_acf-field","650","650","en",NULL),
("144","post_acf-field","852","852","en",NULL),
("145","post_acf-field","861","861","en",NULL),
("146","post_acf-field","878","878","en",NULL),
("147","post_acf-field","879","879","en",NULL),
("148","post_acf-field","880","880","en",NULL),
("149","post_acf-field","885","885","en",NULL),
("154","post_acf-field","916","916","en",NULL),
("155","post_acf-field","917","917","en",NULL),
("156","post_acf-field","918","918","en",NULL),
("157","post_acf-field","919","919","en",NULL),
("158","post_acf-field","920","920","en",NULL),
("159","post_acf-field","921","921","en",NULL),
("160","post_acf-field","922","922","en",NULL),
("161","post_acf-field","923","923","en",NULL),
("162","post_acf-field","1012","1012","en",NULL),
("163","post_acf-field","1013","1013","en",NULL),
("164","post_acf-field","1014","1014","en",NULL),
("165","post_acf-field","1033","1033","en",NULL),
("166","post_acf-field","1034","1034","en",NULL),
("167","post_acf-field","1035","1035","en",NULL),
("168","post_acf-field","1036","1036","en",NULL),
("169","post_acf-field-group","6","6","en",NULL),
("170","post_acf-field-group","147","147","en",NULL),
("171","post_acf-field-group","249","249","en",NULL),
("172","post_acf-field-group","279","279","en",NULL),
("173","post_acf-field-group","412","412","en",NULL),
("174","post_acf-field-group","629","629","en",NULL),
("175","post_acf-field-group","877","877","en",NULL),
("177","post_acf-field-group","915","915","en",NULL),
("178","post_assets","256","256","en",NULL),
("179","post_assets","266","266","en",NULL),
("180","post_country","157","157","en",NULL),
("181","post_country","158","158","en",NULL),
("182","post_country","881","881","en",NULL),
("183","post_country","882","882","en",NULL),
("184","post_country","883","883","en",NULL),
("185","post_country","884","884","en",NULL),
("186","post_country","898","898","en",NULL),
("187","post_country","899","899","en",NULL),
("188","post_country","900","900","en",NULL),
("189","post_country","902","902","en",NULL),
("190","post_country","903","903","en",NULL),
("191","post_country","905","905","en",NULL),
("192","post_country","906","906","en",NULL),
("193","post_country","907","907","en",NULL),
("194","post_nav_menu_item","929","929","en",NULL),
("195","post_nav_menu_item","242","242","en",NULL),
("196","post_nav_menu_item","634","634","en",NULL),
("197","post_nav_menu_item","826","826","en",NULL),
("198","post_nav_menu_item","243","243","en",NULL),
("199","post_nav_menu_item","244","244","en",NULL),
("200","post_nav_menu_item","245","245","en",NULL),
("201","post_nav_menu_item","825","825","en",NULL),
("202","post_nav_menu_item","827","827","en",NULL),
("203","post_nav_menu_item","828","828","en",NULL),
("204","post_nav_menu_item","829","829","en",NULL),
("205","post_nav_menu_item","830","830","en",NULL),
("206","post_nav_menu_item","831","831","en",NULL),
("207","post_nav_menu_item","832","832","en",NULL),
("208","post_nav_menu_item","833","833","en",NULL),
("209","post_nav_menu_item","834","834","en",NULL),
("210","post_nav_menu_item","835","835","en",NULL),
("211","post_nav_menu_item","928","928","en",NULL),
("212","post_nav_menu_item","930","930","en",NULL),
("213","post_nav_menu_item","931","931","en",NULL),
("214","post_nav_menu_item","932","932","en",NULL),
("215","post_nav_menu_item","933","933","en",NULL),
("216","post_nav_menu_item","937","937","en",NULL),
("217","post_nav_menu_item","938","938","en",NULL),
("218","post_nav_menu_item","939","939","en",NULL),
("219","post_nav_menu_item","940","940","en",NULL),
("220","post_page","3","3","en",NULL),
("221","post_page","2","2","en",NULL),
("222","post_page","586","586","en",NULL),
("223","post_page","614","614","en",NULL),
("224","post_page","636","636","en",NULL),
("225","post_page","656","656","en",NULL),
("226","post_page","670","670","en",NULL),
("227","post_page","688","688","en",NULL),
("228","post_page","701","701","en",NULL),
("229","post_page","714","714","en",NULL),
("230","post_page","742","742","en",NULL),
("231","post_page","755","755","en",NULL),
("232","post_page","778","778","en",NULL),
("233","post_page","793","793","en",NULL),
("234","post_page","810","810","en",NULL),
("235","post_page","1011","1011","en",NULL),
("236","post_post","1","1","en",NULL),
("237","post_post","298","298","en",NULL),
("238","post_post","303","303","en",NULL),
("239","post_post","305","305","en",NULL),
("240","post_post","309","309","en",NULL),
("241","post_post","314","314","en",NULL),
("242","post_post","316","316","en",NULL),
("243","post_post","334","334","en",NULL),
("244","post_post","844","844","en",NULL),
("245","post_section_blocks","426","426","en",NULL),
("246","post_section_blocks","433","433","en",NULL),
("247","post_section_blocks","461","461","en",NULL),
("248","post_section_blocks","527","527","en",NULL),
("249","post_section_blocks","533","533","en",NULL),
("250","post_section_blocks","549","549","en",NULL),
("251","post_statement","285","285","en",NULL),
("252","post_statement","719","719","en",NULL),
("253","post_statement","757","757","en",NULL),
("254","post_statement","822","822","en",NULL),
("255","tax_category","1","1038","en",NULL),
("256","tax_category","6","1043","en",NULL),
("257","tax_category","7","1044","en",NULL),
("258","tax_category","8","1045","en",NULL),
("259","tax_category","9","1046","en",NULL),
("260","tax_nav_menu","5","1052","en",NULL),
("261","tax_nav_menu","10","1057","en",NULL),
("262","tax_region","2","1060","en",NULL),
("263","tax_region","3","1061","en",NULL),
("264","tax_region","4","1062","en",NULL),
("265","comment","1","1064","en",NULL),
("266","tax_category","11","1038","da","en"),
("267","post_attachment","25","1090","en",NULL),
("268","post_attachment","26","1091","en",NULL),
("269","post_attachment","27","1092","en",NULL),
("270","post_attachment","28","1093","en",NULL),
("271","post_attachment","69","1134","en",NULL),
("272","post_attachment","70","1135","en",NULL),
("273","post_attachment","71","1136","en",NULL),
("274","post_attachment","131","1196","en",NULL),
("275","post_attachment","257","1322","en",NULL),
("276","post_attachment","258","1323","en",NULL),
("277","post_attachment","259","1324","en",NULL),
("278","post_attachment","267","1332","en",NULL),
("279","post_attachment","268","1333","en",NULL),
("280","post_attachment","269","1334","en",NULL),
("281","post_attachment","286","1351","en",NULL),
("282","post_attachment","289","1354","en",NULL),
("283","post_attachment","295","1360","en",NULL),
("284","post_attachment","299","1364","en",NULL),
("285","post_attachment","300","1365","en",NULL),
("286","post_attachment","301","1366","en",NULL),
("287","post_attachment","310","1375","en",NULL),
("288","post_attachment","311","1376","en",NULL),
("289","post_attachment","312","1377","en",NULL),
("290","post_attachment","364","1429","en",NULL),
("291","post_attachment","365","1430","en",NULL),
("292","post_attachment","366","1431","en",NULL),
("293","post_attachment","367","1432","en",NULL),
("294","post_attachment","380","1445","en",NULL),
("295","post_attachment","381","1446","en",NULL),
("296","post_attachment","382","1447","en",NULL),
("297","post_attachment","383","1448","en",NULL),
("298","post_attachment","441","1506","en",NULL),
("299","post_attachment","443","1508","en",NULL),
("300","post_attachment","454","1519","en",NULL),
("301","post_attachment","462","1527","en",NULL),
("302","post_attachment","463","1528","en",NULL),
("303","post_attachment","464","1529","en",NULL),
("304","post_attachment","472","1537","en",NULL),
("305","post_attachment","473","1538","en",NULL),
("306","post_attachment","474","1539","en",NULL),
("307","post_attachment","475","1540","en",NULL),
("308","post_attachment","477","1542","en",NULL),
("309","post_attachment","491","1556","en",NULL),
("310","post_attachment","506","1571","en",NULL),
("311","post_attachment","507","1572","en",NULL),
("312","post_attachment","528","1593","en",NULL),
("313","post_attachment","535","1600","en",NULL),
("314","post_attachment","536","1601","en",NULL),
("315","post_attachment","537","1602","en",NULL),
("316","post_attachment","538","1603","en",NULL),
("317","post_attachment","539","1604","en",NULL),
("318","post_attachment","540","1605","en",NULL),
("319","post_attachment","543","1608","en",NULL),
("320","post_attachment","615","1680","en",NULL),
("321","post_attachment","619","1684","en",NULL),
("322","post_attachment","620","1685","en",NULL),
("323","post_attachment","621","1686","en",NULL),
("324","post_attachment","622","1687","en",NULL),
("325","post_attachment","637","1702","en",NULL),
("326","post_attachment","645","1710","en",NULL),
("327","post_attachment","646","1711","en",NULL),
("328","post_attachment","657","1722","en",NULL),
("329","post_attachment","677","1742","en",NULL),
("330","post_attachment","678","1743","en",NULL),
("331","post_attachment","679","1744","en",NULL),
("332","post_attachment","680","1745","en",NULL),
("333","post_attachment","681","1746","en",NULL),
("334","post_attachment","682","1747","en",NULL),
("335","post_attachment","683","1748","en",NULL),
("336","post_attachment","684","1749","en",NULL),
("337","post_attachment","693","1758","en",NULL),
("338","post_attachment","696","1761","en",NULL),
("339","post_attachment","702","1767","en",NULL),
("340","post_attachment","706","1771","en",NULL),
("341","post_attachment","708","1773","en",NULL),
("342","post_attachment","711","1776","en",NULL),
("343","post_attachment","720","1785","en",NULL),
("344","post_attachment","738","1803","en",NULL),
("345","post_attachment","743","1808","en",NULL),
("346","post_attachment","748","1813","en",NULL),
("347","post_attachment","749","1814","en",NULL),
("348","post_attachment","750","1815","en",NULL),
("349","post_attachment","753","1818","en",NULL),
("350","post_attachment","756","1821","en",NULL),
("351","post_attachment","758","1823","en",NULL),
("352","post_attachment","759","1824","en",NULL),
("353","post_attachment","760","1825","en",NULL),
("354","post_attachment","761","1826","en",NULL),
("355","post_attachment","762","1827","en",NULL),
("356","post_attachment","776","1841","en",NULL),
("357","post_attachment","779","1844","en",NULL),
("358","post_attachment","784","1849","en",NULL),
("359","post_attachment","785","1850","en",NULL),
("360","post_attachment","786","1851","en",NULL),
("361","post_attachment","787","1852","en",NULL),
("362","post_attachment","788","1853","en",NULL),
("363","post_attachment","789","1854","en",NULL),
("364","post_attachment","794","1859","en",NULL),
("365","post_attachment","823","1888","en",NULL),
("366","post_attachment","845","1910","en",NULL),
("367","post_attachment","849","1914","en",NULL),
("368","post_attachment","850","1915","en",NULL),
("369","post_attachment","870","1935","en",NULL),
("370","post_attachment","871","1936","en",NULL),
("371","post_attachment","872","1937","en",NULL),
("372","post_attachment","886","1951","en",NULL),
("373","post_attachment","887","1952","en",NULL),
("374","post_attachment","888","1953","en",NULL),
("375","post_attachment","889","1954","en",NULL),
("376","post_attachment","890","1955","en",NULL),
("377","post_attachment","891","1956","en",NULL),
("378","post_attachment","892","1957","en",NULL),
("379","post_attachment","893","1958","en",NULL),
("380","post_attachment","894","1959","en",NULL),
("381","post_attachment","895","1960","en",NULL),
("382","post_attachment","896","1961","en",NULL),
("383","post_attachment","897","1962","en",NULL),
("384","post_attachment","904","1969","en",NULL),
("385","post_attachment","908","1973","en",NULL),
("386","post_attachment","924","1989","en",NULL),
("387","post_attachment","941","2006","en",NULL),
("388","post_attachment","942","2007","en",NULL),
("389","post_attachment","945","2010","en",NULL),
("390","post_attachment","946","2011","en",NULL),
("391","post_attachment","947","2012","en",NULL),
("392","post_attachment","949","2014","en",NULL),
("393","post_attachment","951","2016","en",NULL),
("394","post_attachment","954","2019","en",NULL),
("395","post_attachment","956","2021","en",NULL),
("396","post_attachment","958","2023","en",NULL),
("397","post_attachment","965","2030","en",NULL),
("398","post_attachment","966","2031","en",NULL),
("399","post_attachment","967","2032","en",NULL),
("400","post_attachment","968","2033","en",NULL),
("401","post_attachment","969","2034","en",NULL),
("402","post_attachment","970","2035","en",NULL),
("403","post_attachment","972","2037","en",NULL),
("404","post_attachment","974","2039","en",NULL),
("405","post_attachment","977","2042","en",NULL),
("406","post_attachment","979","2044","en",NULL),
("407","post_attachment","981","2046","en",NULL),
("408","post_attachment","989","2054","en",NULL),
("409","post_attachment","990","2055","en",NULL),
("410","post_attachment","991","2056","en",NULL),
("411","post_attachment","992","2057","en",NULL),
("412","post_attachment","993","2058","en",NULL),
("413","post_attachment","994","2059","en",NULL),
("414","post_attachment","995","2060","en",NULL),
("415","post_attachment","996","2061","en",NULL),
("416","post_attachment","997","2062","en",NULL),
("417","post_attachment","998","2063","en",NULL),
("418","post_attachment","999","2064","en",NULL),
("419","post_attachment","1002","2067","en",NULL),
("420","post_attachment","1003","2068","en",NULL),
("421","post_attachment","1004","2069","en",NULL),
("422","post_attachment","1008","2073","en",NULL),
("424","tax_translation_priority","12","2074","en",NULL),
("425","tax_translation_priority","13","2074","da","en"),
("427","tax_translation_priority","14","2075","en",NULL),
("428","tax_translation_priority","15","2075","da","en"),
("430","tax_translation_priority","16","2076","en",NULL),
("431","tax_translation_priority","17","2076","da","en"),
("432","post_post","1032","3109","en",NULL),
("433","post_section_blocks","424","3534","en",NULL),
("434","post_section_blocks","532","3642","en",NULL),
("435","post_section_blocks","421","3531","en",NULL),
("436","post_attachment","1079","1090","da","en"),
("437","post_attachment","1080","1091","da","en"),
("438","post_attachment","1081","1092","da","en"),
("439","post_attachment","1082","1093","da","en"),
("440","post_attachment","1083","1134","da","en"),
("441","post_attachment","1084","1135","da","en"),
("442","post_attachment","1085","1136","da","en"),
("443","post_attachment","1086","1196","da","en"),
("444","post_attachment","1087","1322","da","en"),
("445","post_attachment","1088","1323","da","en"),
("446","post_attachment","1089","1324","da","en"),
("447","post_attachment","1090","1332","da","en"),
("448","post_attachment","1091","1333","da","en"),
("449","post_attachment","1092","1334","da","en"),
("450","post_attachment","1093","1351","da","en"),
("451","post_attachment","1094","1354","da","en"),
("452","post_attachment","1095","1360","da","en"),
("453","post_attachment","1096","1364","da","en"),
("454","post_attachment","1097","1365","da","en"),
("455","post_attachment","1098","1366","da","en"),
("456","post_attachment","1099","1375","da","en"),
("457","post_attachment","1100","1376","da","en"),
("458","post_attachment","1101","1377","da","en"),
("459","post_attachment","1102","1429","da","en"),
("460","post_attachment","1103","1430","da","en"),
("461","post_attachment","1104","1431","da","en"),
("462","post_attachment","1105","1432","da","en"),
("463","post_attachment","1106","1445","da","en"),
("464","post_attachment","1107","1446","da","en"),
("465","post_attachment","1108","1447","da","en"),
("466","post_attachment","1109","1448","da","en"),
("467","post_attachment","1110","1506","da","en"),
("468","post_attachment","1111","1508","da","en"),
("469","post_attachment","1112","1519","da","en"),
("470","post_attachment","1113","1527","da","en"),
("471","post_attachment","1114","1528","da","en"),
("472","post_attachment","1115","1529","da","en"),
("473","post_attachment","1116","1537","da","en"),
("474","post_attachment","1117","1538","da","en"),
("475","post_attachment","1118","1539","da","en"),
("476","post_attachment","1119","1540","da","en"),
("477","post_attachment","1120","1542","da","en"),
("478","post_attachment","1121","1556","da","en"),
("479","post_attachment","1122","1571","da","en"),
("480","post_attachment","1123","1572","da","en"),
("481","post_attachment","1124","1593","da","en"),
("482","post_attachment","1125","1600","da","en"),
("483","post_attachment","1126","1601","da","en"),
("484","post_attachment","1127","1602","da","en"),
("485","post_attachment","1128","1603","da","en"),
("486","post_attachment","1129","1604","da","en"),
("487","post_attachment","1130","1605","da","en"),
("488","post_attachment","1131","1608","da","en"),
("489","post_attachment","1132","1680","da","en"),
("490","post_attachment","1133","1684","da","en"),
("491","post_attachment","1134","1685","da","en"),
("492","post_attachment","1135","1686","da","en"),
("493","post_attachment","1136","1687","da","en"),
("494","post_attachment","1137","1702","da","en"),
("495","post_attachment","1138","1710","da","en"),
("496","post_attachment","1139","1711","da","en"),
("497","post_attachment","1140","1722","da","en"),
("498","post_attachment","1141","1742","da","en"),
("499","post_attachment","1142","1743","da","en"),
("500","post_attachment","1143","1744","da","en"),
("501","post_attachment","1144","1745","da","en"),
("502","post_attachment","1145","1746","da","en"),
("503","post_attachment","1146","1747","da","en"),
("504","post_attachment","1147","1748","da","en"),
("505","post_attachment","1148","1749","da","en"),
("506","post_attachment","1149","1758","da","en"),
("507","post_attachment","1150","1761","da","en"),
("508","post_attachment","1151","1767","da","en"),
("509","post_attachment","1152","1771","da","en"),
("510","post_attachment","1153","1773","da","en"),
("511","post_attachment","1154","1776","da","en"),
("512","post_attachment","1155","1785","da","en"),
("513","post_attachment","1156","1803","da","en"),
("514","post_attachment","1157","1808","da","en"),
("515","post_attachment","1158","1813","da","en"),
("516","post_attachment","1159","1814","da","en"),
("517","post_attachment","1160","1815","da","en"),
("518","post_attachment","1161","1818","da","en"),
("519","post_attachment","1162","1821","da","en"),
("520","post_attachment","1163","1823","da","en"),
("521","post_attachment","1164","1824","da","en"),
("522","post_attachment","1165","1825","da","en"),
("523","post_attachment","1166","1826","da","en"),
("524","post_attachment","1167","1827","da","en"),
("525","post_attachment","1168","1841","da","en"),
("526","post_attachment","1169","1844","da","en"),
("527","post_attachment","1170","1849","da","en"),
("528","post_attachment","1171","1850","da","en"),
("529","post_attachment","1172","1851","da","en"),
("530","post_attachment","1173","1852","da","en"),
("531","post_attachment","1174","1853","da","en"),
("532","post_attachment","1175","1854","da","en"),
("533","post_attachment","1176","1859","da","en"),
("534","post_attachment","1177","1888","da","en"),
("535","post_attachment","1178","1910","da","en"),
("536","post_attachment","1179","1914","da","en"),
("537","post_attachment","1180","1915","da","en"),
("538","post_attachment","1181","1935","da","en"),
("539","post_attachment","1182","1936","da","en"),
("540","post_attachment","1183","1937","da","en"),
("541","post_attachment","1184","1951","da","en"),
("542","post_attachment","1185","1952","da","en"),
("543","post_attachment","1186","1953","da","en"),
("544","post_attachment","1187","1954","da","en"),
("545","post_attachment","1188","1955","da","en"),
("546","post_attachment","1189","1956","da","en"),
("547","post_attachment","1190","1957","da","en"),
("548","post_attachment","1191","1958","da","en"),
("549","post_attachment","1192","1959","da","en"),
("550","post_attachment","1193","1960","da","en"),
("551","post_attachment","1194","1961","da","en"),
("552","post_attachment","1195","1962","da","en"),
("553","post_attachment","1196","1969","da","en"),
("554","post_attachment","1197","1973","da","en"),
("555","post_attachment","1198","1989","da","en"),
("556","post_attachment","1199","2006","da","en"),
("557","post_attachment","1200","2007","da","en"),
("558","post_attachment","1201","2010","da","en"),
("559","post_attachment","1202","2011","da","en"),
("560","post_attachment","1203","2012","da","en"),
("561","post_attachment","1204","2014","da","en"),
("562","post_attachment","1205","2016","da","en"),
("563","post_attachment","1206","2019","da","en"),
("564","post_attachment","1207","2021","da","en"),
("565","post_attachment","1208","2023","da","en"),
("566","post_attachment","1209","2030","da","en"),
("567","post_attachment","1210","2031","da","en"),
("568","post_attachment","1211","2032","da","en"),
("569","post_attachment","1212","2033","da","en"),
("570","post_attachment","1213","2034","da","en"),
("571","post_attachment","1214","2035","da","en"),
("572","post_attachment","1215","2037","da","en"),
("573","post_attachment","1216","2039","da","en"),
("574","post_attachment","1217","2042","da","en"),
("575","post_attachment","1218","2044","da","en"),
("576","post_attachment","1219","2046","da","en"),
("577","post_attachment","1220","2054","da","en"),
("578","post_attachment","1221","2055","da","en"),
("579","post_attachment","1222","2056","da","en"),
("580","post_attachment","1223","2057","da","en"),
("581","post_attachment","1224","2058","da","en"),
("582","post_attachment","1225","2059","da","en"),
("583","post_attachment","1226","2060","da","en"),
("584","post_attachment","1227","2061","da","en"),
("585","post_attachment","1228","2062","da","en"),
("586","post_attachment","1229","2063","da","en"),
("587","post_attachment","1230","2064","da","en"),
("588","post_attachment","1231","2067","da","en"),
("589","post_attachment","1232","2068","da","en"),
("590","post_attachment","1233","2069","da","en"),
("591","post_attachment","1234","2073","da","en"),
("596","tax_category","18","1044","da","en"),
("598","post_page","1248","3643","en",NULL),
("600","package_gutenberg","1","3644","en",NULL),
("601","post_page","1261","3645","en",NULL);

INSERT INTO `wp_options` VALUES 
("1","siteurl","https://milo.sgsmedia.dk/wp","yes"),
("2","home","https://milo.sgsmedia.dk/wp","yes"),
("3","blogname","Milo","yes"),
("4","blogdescription","Just another WordPress site","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","info@sgsmedia.dk","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","0","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:165:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"region/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:42:\"region/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:23:\"region/([^/]+)/embed/?$\";s:39:\"index.php?region=$matches[1]&embed=true\";s:35:\"region/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?region=$matches[1]&paged=$matches[2]\";s:17:\"region/([^/]+)/?$\";s:28:\"index.php?region=$matches[1]\";s:35:\"country/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"country/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"country/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"country/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"country/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"country/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"country/([^/]+)/embed/?$\";s:40:\"index.php?country=$matches[1]&embed=true\";s:28:\"country/([^/]+)/trackback/?$\";s:34:\"index.php?country=$matches[1]&tb=1\";s:36:\"country/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?country=$matches[1]&paged=$matches[2]\";s:43:\"country/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?country=$matches[1]&cpage=$matches[2]\";s:32:\"country/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?country=$matches[1]&page=$matches[2]\";s:24:\"country/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"country/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"country/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"country/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"country/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"country/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"assets/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"assets/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"assets/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"assets/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"assets/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"assets/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"assets/([^/]+)/embed/?$\";s:39:\"index.php?assets=$matches[1]&embed=true\";s:27:\"assets/([^/]+)/trackback/?$\";s:33:\"index.php?assets=$matches[1]&tb=1\";s:35:\"assets/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?assets=$matches[1]&paged=$matches[2]\";s:42:\"assets/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?assets=$matches[1]&cpage=$matches[2]\";s:31:\"assets/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?assets=$matches[1]&page=$matches[2]\";s:23:\"assets/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"assets/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"assets/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"assets/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"assets/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"assets/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"statement/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"statement/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"statement/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"statement/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"statement/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"statement/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"statement/([^/]+)/embed/?$\";s:42:\"index.php?statement=$matches[1]&embed=true\";s:30:\"statement/([^/]+)/trackback/?$\";s:36:\"index.php?statement=$matches[1]&tb=1\";s:38:\"statement/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?statement=$matches[1]&paged=$matches[2]\";s:45:\"statement/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?statement=$matches[1]&cpage=$matches[2]\";s:34:\"statement/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?statement=$matches[1]&page=$matches[2]\";s:26:\"statement/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"statement/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"statement/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"statement/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"statement/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"statement/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"section_blocks/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"section_blocks/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"section_blocks/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"section_blocks/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"section_blocks/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"section_blocks/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"section_blocks/([^/]+)/embed/?$\";s:47:\"index.php?section_blocks=$matches[1]&embed=true\";s:35:\"section_blocks/([^/]+)/trackback/?$\";s:41:\"index.php?section_blocks=$matches[1]&tb=1\";s:43:\"section_blocks/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?section_blocks=$matches[1]&paged=$matches[2]\";s:50:\"section_blocks/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?section_blocks=$matches[1]&cpage=$matches[2]\";s:39:\"section_blocks/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?section_blocks=$matches[1]&page=$matches[2]\";s:31:\"section_blocks/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"section_blocks/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"section_blocks/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"section_blocks/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"section_blocks/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"section_blocks/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=586&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:12:{i:0;s:48:\"advanced-custom-fields-table-field/acf-table.php\";i:1;s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";i:2;s:18:\"acfml/wpml-acf.php\";i:3;s:34:\"advanced-custom-fields-pro/acf.php\";i:4;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:28:\"real-media-library/index.php\";i:7;s:40:\"sitepress-multilingual-cms/sitepress.php\";i:8;s:34:\"wpml-string-translation/plugin.php\";i:9;s:38:\"wpml-translation-management/plugin.php\";i:10;s:33:\"duplicate-post/duplicate-post.php\";i:11;s:33:\"duplicator-pro/duplicator-pro.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:2:{i:0;s:66:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/themes/milo/style.css\";i:1;s:0:\"\";}","no"),
("40","template","milo","yes"),
("41","stylesheet","milo","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","49752","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","0","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","page","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("79","uninstall_plugins","a:1:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";a:2:{i:0;s:24:\"ADBC_Advanced_DB_Cleaner\";i:1;s:14:\"aDBc_uninstall\";}}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","586","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1632503928","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","initial_db_version","49752","yes"),
("99","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:77:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("100","fresh_site","0","yes"),
("101","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("106","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}","yes"),
("107","cron","a:11:{i:1618910328;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1618923482;a:1:{s:24:\"update_wpml_config_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1618923542;a:1:{s:32:\"wpml-tm-check-overdue-jobs-event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1618939128;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1618939151;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1618939152;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1618951742;a:1:{s:41:\"puc_cron_check_updates-real-media-library\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1619182865;a:1:{s:27:\"wpml_tm_send_summary_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1619457528;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1621169882;a:1:{s:25:\"otgs_send_components_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}","yes"),
("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","recovery_keys","a:0:{}","yes"),
("119","theme_mods_twentytwentyone","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1617005827;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes"),
("120","https_detection_errors","a:0:{}","yes"),
("132","can_compress_scripts","1","no"),
("145","recently_activated","a:1:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";i:1618767055;}","yes"),
("146","acf_version","5.9.5","yes"),
("149","cptui_new_install","false","yes"),
("154","finished_updating_comment_type","1","yes"),
("155","acf_pro_license","YToyOntzOjM6ImtleSI7czo3NjoiYjNKa1pYSmZhV1E5TVRjd05qWXdmSFI1Y0dVOVpHVjJaV3h2Y0dWeWZHUmhkR1U5TWpBeE9TMHdPUzB4T1NBd09EbzFNRG94T0E9PSI7czozOiJ1cmwiO3M6Mjc6Imh0dHBzOi8vbWlsby5zZ3NtZWRpYS5kay93cCI7fQ==","yes"),
("156","edd_sl_dd9b23a13775ccc12b5389d301f8ef5d","a:2:{s:7:\"timeout\";i:1616962821;s:5:\"value\";s:26768:\"{\"new_version\":\"2.5.2\",\"stable_version\":\"2.5.2\",\"name\":\"ACF Theme Code Pro\",\"slug\":\"acf_theme_code_pro\",\"url\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/?changelog=1\",\"last_updated\":\"2021-02-19 15:29:30\",\"homepage\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\",\"changelog\":\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-128x128.jpg\",\"2x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-256x256.jpg\"},\"stable_tag\":\"\",\"tested\":\"\",\"description\":[\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"]}\";}","no"),
("160","hookturn_acftcp_license_key","19c84a6f7537c23321ace60f5b0466a2","yes"),
("163","hookturn_acftcp_license_status","valid","yes"),
("164","edd_sl_2800905b53e41bc246e398fbd91c4ed9","a:2:{s:7:\"timeout\";i:1618917937;s:5:\"value\";s:27162:\"{\"new_version\":\"2.5.2\",\"stable_version\":\"2.5.2\",\"name\":\"ACF Theme Code Pro\",\"slug\":\"acf_theme_code_pro\",\"url\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/?changelog=1\",\"last_updated\":\"2021-02-19 15:29:30\",\"homepage\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-theme-code-pro\\/\",\"package\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTYxOTAyOTUzNzoxOWM4NGE2Zjc1MzdjMjMzMjFhY2U2MGY1YjA0NjZhMjoxNTplZTljNmE5YWM1MzgyY2FkMDE5YjVhYTcwZGE2NzllNzpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"download_link\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTYxOTAyOTUzNzoxOWM4NGE2Zjc1MzdjMjMzMjFhY2U2MGY1YjA0NjZhMjoxNTplZTljNmE5YWM1MzgyY2FkMDE5YjVhYTcwZGE2NzllNzpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"sections\":{\"description\":\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\",\"changelog\":\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-128x128.jpg\",\"2x\":\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/acf-theme-code-pro-256x256.jpg\"},\"stable_tag\":\"\",\"tested\":\"\",\"description\":[\"<p><strong>ACF Theme Code Pro saves you time by automatically generating the code needed to implement ACF PRO field groups and ACF Blocks in your WordPress themes.<\\/strong><\\/p>\\n<p><em>\\u201cWork smarter, not harder! Great work on this ACF plugin!\\u201d<\\/em> - Elliot Condon, Creator of Advanced Custom Fields<\\/p>\\n<p>ACF Theme Code Pro is a premium add-on\\u00a0for the awesome\\u00a0<a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Advanced Custom Fields Pro<\\/a>\\u00a0WordPress plugin.<\\/p>\\n<p>The code required to implement your fields is displayed in the <em>Theme Code<\\/em> section at the bottom of your Edit Field Group page.<\\/p>\\n<p><strong>Features<\\/strong><\\/p>\\n<ul>\\n<li>Clipboard icons to easily copy code blocks into your theme<\\/li>\\n<li>Field names and variables are automatically updated<\\/li>\\n<li>Code generated is based on the official ACF documentation and includes escaping<\\/li>\\n<li>Support for field return types and single\\/muliple value options<\\/li>\\n<li>Great for offline ACF documentation<\\/li>\\n<\\/ul>\\n<p><strong>ACF Free, ACF Pro &amp; 3rd party fields <\\/strong><\\/p>\\n<p>Theme Code Pro generates code for all of these fields:<\\/p>\\n<p><strong>ACF Free Fields<\\/strong><\\/p>\\n<ul>\\n<li>Text<\\/li>\\n<li>Text Area<\\/li>\\n<li>Number<\\/li>\\n<li>Range<\\/li>\\n<li>Email<\\/li>\\n<li>URL<\\/li>\\n<li>Password<\\/li>\\n<li>Image<\\/li>\\n<li>File<\\/li>\\n<li>WYSIWYG<\\/li>\\n<li>oEmbed<\\/li>\\n<li>Select<\\/li>\\n<li>Checkbox<\\/li>\\n<li>Radio Button<\\/li>\\n<li>Button Group<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link<\\/li>\\n<li>Post Object<\\/li>\\n<li>Page Link<\\/li>\\n<li>Relationship<\\/li>\\n<li>Taxonomy<\\/li>\\n<li>User<\\/li>\\n<li>Google Map<\\/li>\\n<li>Date Picker<\\/li>\\n<li>Date Time Picker<\\/li>\\n<li>Color Picker<\\/li>\\n<li>Group<\\/li>\\n<\\/ul>\\n<p><strong>ACF Pro Fields<\\/strong><\\/p>\\n<ul>\\n<li>Repeater<\\/li>\\n<li>Flexible content<\\/li>\\n<li>Gallery<\\/li>\\n<li>Clone<\\/li>\\n<\\/ul>\\n<p><strong>3rd Party Fields<\\/strong><\\/p>\\n<ul>\\n<li>Font Awesome<\\/li>\\n<li>Gravityforms<\\/li>\\n<li>Ninjaforms<\\/li>\\n<li>Contact Form 7<\\/li>\\n<li>RGBA Colour<\\/li>\\n<li>Color Palette<\\/li>\\n<li>Table<\\/li>\\n<li>TablePress<\\/li>\\n<li>Sidebar Selector<\\/li>\\n<li>Nav Menu<\\/li>\\n<li>Image Aspect Ratio Crop<\\/li>\\n<li>Audio\\/Video Player<\\/li>\\n<li>SVG Icon<\\/li>\\n<li>Icon Selector<\\/li>\\n<li>Code<\\/li>\\n<li>Address<\\/li>\\n<li>Number Slider<\\/li>\\n<li>Star Rating<\\/li>\\n<li>YouTube Picker<\\/li>\\n<li>Post Type Select<\\/li>\\n<li>Smart Button<\\/li>\\n<\\/ul>\\n<p><strong>Location Rule Support<\\/strong><\\/p>\\n<p>ACF Theme Code Pro can generate code for multiple location rules in each field group. This includes more complex locations like <em>Block, Options Page, Widget, Taxonomy, Comment, Attachment, Current User and User Form.<\\/em><\\/p>\\n<p><strong>Create Blocks and Options Pages<\\/strong><\\/p>\\n<p>ACF Theme Code Pro also includes a handy <em>Location Registration Tool<\\/em> that generates the code needed to create new Blocks and Options Pages.<\\/p>\\n<p><strong>Works best with<\\/strong><\\/p>\\n<ul>\\n<li>Advanced Custom Fields Pro v5.9 or higher<\\/li>\\n<li>Advanced Custom Fields Free v5.9 or higher<\\/li>\\n<li>WordPress 5.6 or higher<\\/li>\\n<li>PHP 7.0 or higher<\\/li>\\n<\\/ul>\\n<p><strong>Try our FREE version<\\/strong><\\/p>\\n<p>If you would like to \\u2018try before you buy\\u2019 you can check out our free version <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-theme-code\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">ACF Theme Code<\\/a> on WordPress.org. This plugin supports all the field types included in free version of Advanced Custom Fields.<\\/p>\\n<p><strong>Hi! We made this<\\/strong><\\/p>\\n<p>The ACF Theme Code Plugin was created by <a href=\\\"http:\\/\\/aaronrutley.com\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">AaronRutley<\\/a> &amp; <a href=\\\"http:\\/\\/benpearson.com.au\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Ben Pearson<\\/a>, two WordPress developers based in Melbourne, Australia.<\\/p>\\n<p><strong>Theme Code Pro makes developers happy!<\\/strong><\\/p>\\n<p><em>\\u201cGreat time saver - No more constantly referring to the ACF documentation for the right ACF code.\\u201d<\\/em> - David McDonald, Freelance Web Developer<\\/p>\\n<p><em>\\u201cAwesome add-on for ACF - It will certainly speed up theme development.\\u201d<\\/em> - Matthew Heyes, Web Developer &amp; WordPress Specialist<\\/p>\\n<p><em>\\u201cI\'m going to use all the free time this plugin gives me to, I don\'t know, catch up on sleep!\\u201d<\\/em> - Joel Eade, Website Designer<\\/p>\\n<p><em>\\u201cI should have dropped the change a long time ago. AWESOME. Massive time saver. Wish I\\u2019d done it sooner.\\u201d<\\/em> - theatereleven, WordPress Developer<\\/p>\\n\"],\"changelog\":[\"<p><strong>2.5.2<\\/strong><\\/p>\\n<ul>\\n<li>Add support for the following third party fields:<\\/li>\\n<ul>\\n<li>ACF Field For Contact Form 7<\\/li>\\n<li>Advanced Custom Field: Audio\\/Video Player<\\/li>\\n<\\/ul>\\n<li>Improve code rendered for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Gravityforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>Advanced Custom Fields: Ninjaforms Add-on (including displaying forms, support for Object and ID return types and Single and Multiple values)<\\/li>\\n<li>TablePress (including support for ID and HTML return types)<\\/li>\\n<li>Table (including caption support and escaping)<\\/li>\\n<li>ACF Icon Selector Field (including escaping)<\\/li>\\n<li>ACF Smart Button (including escaping)<\\/li>\\n<li>Advanced Custom Fields: RGBA Color Field (including escaping)<\\/li>\\n<\\/ul>\\n<li>Update support for the following third party fields:<\\/li>\\n<ul>\\n<li>Advanced Custom Fields: Font Awesome Field<\\/li>\\n<li>Custom Fields: Nav Menu Field<\\/li>\\n<li>ACF Code Field<\\/li>\\n<li>Advanced Custom Fields: SVG Icon<\\/li>\\n<li>ACF YouTube Picker Field<\\/li>\\n<li>ACF Address Field<\\/li>\\n<li>Post Type Select Field for Advanced Custom Fields<\\/li>\\n<li>Advanced Custom Fields: Number Slider<\\/li>\\n<li>ACF Color Palette Field<\\/li>\\n<li>ACF Color Swatches<\\/li>\\n<\\/ul>\\n<li>Remove support for the following third party fields that no longer support the latest version of WordPress or ACF:<\\/li>\\n<ul>\\n<li>ACF qTranslate<\\/li>\\n<li>Advanced Custom Fields: Image Crop<\\/li>\\n<li>Advanced Custom Fields: Markdown Field<\\/li>\\n<li>Advanced Custom Fields: Link Picker Field<\\/li>\\n<li>ACF: Google Font Selector<\\/li>\\n<li>ACF: Focal Point<\\/li>\\n<\\/ul>\\n<li>Ignore `page` field used by Advanced Forms Pro for ACF for multi step forms<\\/li>\\n<\\/ul>\\n<p><strong>2.5.1<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.6<\\/li>\\n<li>Fix CSS and JS enqueue bugs<\\/li>\\n<li>Fix code formatting bug in \\\"Register ACF Blocks and Options Pages\\\" Tool<\\/li>\\n<li>Add link to Settings page in plugin description on core Plugins page<\\/li>\\n<li>Improve plugin update message on core Plugins page<\\/li>\\n<li>Add instructions to \\\"Download Failed\\\" error message on core Plugins page<\\/li>\\n<li>Updated licensing framework<\\/li>\\n<li>Improve plugin Settings page:\\n<ul>\\n<li>Improve instructions and validation messages<\\/li>\\n<li>Improve design and responsive styles<\\/li>\\n<li>Convert license key field from text input to password input to protect customer license keys<\\/li>\\n<\\/ul>\\n<\\/li>\\n<\\/ul>\\n<p><strong>2.5.0<\\/strong><\\/p>\\n<ul>\\n<li>Improve support for WordPress 5.4.<\\/li>\\n<li>Improve support for all field types included in ACF PRO 5.8.9 (including all their various settings).<\\/li>\\n<li>Improve codebase by syncing both free and pro foundations to facilitate faster development cycles and future features.<\\/li>\\n<li>Add escaping to code rendered to bring it in line with recent updates to ACF field documentation. See\\u00a0https:\\/\\/twitter.com\\/wp_acf\\/status\\/1181344882775875584.<\\/li>\\n<li>Improve code rendered for Taxonomy location.<\\/li>\\n<li>Add support for Current User, Current User Role, User Role locations.<\\/li>\\n<li>Add various enhancements to code rendered for the following fields and field settings:\\n<ul>\\n<li>Gallery field (return types Array, URL and ID)<\\/li>\\n<li>Image (return types Array, URL and ID)<\\/li>\\n<li>File (return types Array, URL and ID)<\\/li>\\n<li>Select (values Single and Multiple, return types Value, Label and Array)<\\/li>\\n<li>Checkbox (return types Value, Label and Array)<\\/li>\\n<li>Radio Button (return type Array)<\\/li>\\n<li>Button Group (return type Array)<\\/li>\\n<li>True \\/ False<\\/li>\\n<li>Link (return types Array and URL)<\\/li>\\n<li>Post Object (values Single and Multiple, return types Post Object and Post ID)<\\/li>\\n<li>Page Link (values Single and Multiple)<\\/li>\\n<li>Relationship (return types Post Object and Post ID)<\\/li>\\n<li>Taxonomy (appearances Checkbox, Multi Select, Radio Buttons and Select, return types Term Object and Term ID)<\\/li>\\n<li>User (values Single and Multiple, return types User Array, User Object and User ID)<\\/li>\\n<li>Google Map<\\/li>\\n<\\/ul>\\n<\\/li>\\n<li>Fixed issue with \'Copy All\' fields functionality.<\\/li>\\n<\\/ul>\\n<p><strong>2.4.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Theme Code Pro generates code to register for ACF Blocks and Options!<\\/li>\\n<li>Core: Theme Code Pro generates code for use within for ACF Blocks!<\\/li>\\n<li>Core: Radio Button field (core): Add support for all return types<\\/li>\\n<li>Core: Refactoring that will allow for the more options for the code generated in the future<\\/li>\\n<li>New Field Supported: ACF Icon Field<\\/li>\\n<li>New Field Supported: ACF Star Rating Field<\\/li>\\n<li>New Field Supported: ACF Color Palette Field<\\/li>\\n<li>New Field Supported: ACF Image Aspect Ratio Crop<\\/li>\\n<li>New Field Supported: ACF Color Swatches<\\/li>\\n<li>New Field Supported: ACF SVG Icon<\\/li>\\n<\\/ul>\\n<p><strong>2.3.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: ACF Ninja Forms add on<\\/li>\\n<li>New Field Supported: ACF Gravity Forms add on<\\/li>\\n<li>New Field Supported: ACF RGBA Colour picker<\\/li>\\n<li>New Field(s) Supported: ACF qTranslate<\\/li>\\n<li>Core: Resolved EDD Conflicts<\\/li>\\n<li>Core: Improved Widget Location Variables<\\/li>\\n<li>Fix: EDD naming conflict<\\/li>\\n<li>Fix: Location error if visual editor is disabled<\\/li>\\n<li>Fix: Select Conflict with Seamless Field Group Option<\\/li>\\n<\\/ul>\\n<p><strong>2.2.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Button Field found in ACF Pro v5.6.3<\\/li>\\n<li>New Field Supported: Range Field found in ACF Pro v5.6.2<\\/li>\\n<li>Core: Copy All Feature Added<\\/li>\\n<\\/ul>\\n<p><strong>2.1.0<\\/strong><\\/p>\\n<ul>\\n<li>New Field Supported: Group Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Link Field found in ACF Pro v5.6<\\/li>\\n<li>New Field Supported: Range Field (Third Party)<\\/li>\\n<li>New Field Supported: Focal Point Field (Third Party)<\\/li>\\n<li>Field: Code field improved to escape output by default<\\/li>\\n<li>Field: Google Map field improved to return lat, lng &amp;\\u00a0address<\\/li>\\n<li>Core: resolved an issue with legacy PHP versions<\\/li>\\n<li>Fix: Bug in File field PHP when returned as a URL<\\/li>\\n<\\/ul>\\n<p><strong>2.0.0<\\/strong><\\/p>\\n<ul>\\n<li>Core : Theme Code Pro now generates code based on your location rules!<\\/li>\\n<li>Core : Theme Code Pro now supports all official ACF Add ons!<\\/li>\\n<li>Core : Theme Code Pro now works when ACF Pro is included in a theme!<\\/li>\\n<li>Location Supported : Options Page<\\/li>\\n<li>Location Supported : Widget<\\/li>\\n<li>Location Supported : Comment<\\/li>\\n<li>Location Supported : Taxonomy Term<\\/li>\\n<li>Location Supported : User<\\/li>\\n<li>Location Supported : Attachment<\\/li>\\n<li>Add-on supported : Options Page<\\/li>\\n<li>Add on supported : Repeater Field<\\/li>\\n<li>Add on supported : Gallery Field<\\/li>\\n<li>Add on supported : Flexible Content Field<\\/li>\\n<li>Fix : Minor bug in file field example link markup<\\/li>\\n<li>Fix : Support for Quicklinks feature within locations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.0<\\/strong><\\/p>\\n<ul>\\n<li>Field : Clone - major improvements to the clone field code output<\\/li>\\n<li>New Field Supported : Address Field<\\/li>\\n<li>New Field Supported : Number Slider Field<\\/li>\\n<li>New Field Supported : Post Type Select Field<\\/li>\\n<li>New Field Supported : Code Field<\\/li>\\n<li>New Field Supported : Link Field<\\/li>\\n<li>New Field Supported : Link Picker Field<\\/li>\\n<li>New Field Supported : YouTube Picker Field<\\/li>\\n<li>Core : Special characters now removed from variable names<\\/li>\\n<li>Fix : Compatibility with CPTUI Pro Plugin<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<ul>\\n<li>Core: Quicklinks feature with anchor links to the relevant theme code block<\\/li>\\n<li>Core: Notice updates &amp; various bug fixes<\\/li>\\n<li>Core: Plugin options screen moved under Settings<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Use the_sub_field method for nested File fields with return format URL<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>Field: Fix for Post Object when using ACF 4<\\/li>\\n<li>Core: Various internal code improvements<\\/li>\\n<\\/ul>\\n\"]}\";}","no"),
("185","current_theme","Milo","yes"),
("186","theme_mods_milo","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"header-menu\";i:5;s:11:\"footer-menu\";i:10;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:871;s:17:\"theme_logo_footer\";s:80:\"https://milo.sgsmedia.dk/wp/wp-content/uploads/2021/04/Milo_Logo_Equinox_RGB.svg\";}","yes"),
("187","theme_switched","","yes"),
("188","recovery_mode_email_last_sent","1618311376","yes"),
("190","rml_cqs","2","yes"),
("191","rml_db_version","4.13.4","yes"),
("192","real_utils-transients","{\"RML\":{\"raa\":true,\"nr\":1624783743}}","no"),
("194","external_updates-real-media-library","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1618904727;s:14:\"checkedVersion\";s:6:\"4.13.4\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:18:\"real-media-library\";s:7:\"version\";s:6:\"4.13.4\";s:12:\"download_url\";s:124:\"https://license.matthias-web.com/api/v1/packages/real-media-library/download?activation=bd94c180-906b-11eb-8a29-9b06769da92b\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:47:\"https://devowl.io/wordpress-real-media-library/\";s:6:\"tested\";s:3:\"5.7\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:28:\"real-media-library/index.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p4_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}","no"),
("195","rml_load_frontend","1","yes"),
("196","rml_licenseActivated-expire","1648543743","yes"),
("197","rml_licenseActivated","","yes"),
("198","rml_importTaxNotice-expire","1648543764","yes"),
("199","rml_importTaxNotice","","yes"),
("200","wpls_license_real-media-library","edc0a653-3ae0-42e4-bd5f-315e558ef4da","no"),
("201","envato_purchase_code_00000000","edc0a653-3ae0-42e4-bd5f-315e558ef4da","no"),
("202","wpls_activation_id_real-media-library","bd94c180-906b-11eb-8a29-9b06769da92b","no"),
("266","cptui_post_types","a:4:{s:7:\"country\";a:30:{s:4:\"name\";s:7:\"country\";s:5:\"label\";s:16:\"Milo - Countries\";s:14:\"singular_label\";s:7:\"Country\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:4:\"true\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:6:\"assets\";a:30:{s:4:\"name\";s:6:\"assets\";s:5:\"label\";s:13:\"Milo - Assets\";s:14:\"singular_label\";s:10:\"Milo Asset\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:9:\"statement\";a:30:{s:4:\"name\";s:9:\"statement\";s:5:\"label\";s:17:\"Milo - Statements\";s:14:\"singular_label\";s:9:\"Statement\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:14:\"section_blocks\";a:30:{s:4:\"name\";s:14:\"section_blocks\";s:5:\"label\";s:13:\"Milo - Global\";s:14:\"singular_label\";s:12:\"Global block\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:5:\"title\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}","yes"),
("349","cptui_taxonomies","a:1:{s:6:\"region\";a:25:{s:4:\"name\";s:6:\"region\";s:5:\"label\";s:7:\"Regions\";s:14:\"singular_label\";s:6:\"Region\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"show_ui\";s:4:\"true\";s:12:\"show_in_menu\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:5:\"false\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";s:17:\"show_admin_column\";s:5:\"false\";s:12:\"show_in_rest\";s:5:\"false\";s:18:\"show_in_quick_edit\";s:0:\"\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:6:\"labels\";a:19:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:11:\"update_item\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:13:\"new_item_name\";s:0:\"\";s:11:\"parent_item\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:13:\"popular_items\";s:0:\"\";s:26:\"separate_items_with_commas\";s:0:\"\";s:19:\"add_or_remove_items\";s:0:\"\";s:21:\"choose_from_most_used\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:8:\"no_terms\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:13:\"back_to_items\";s:0:\"\";}s:11:\"meta_box_cb\";s:0:\"\";s:12:\"default_term\";s:0:\"\";s:12:\"object_types\";a:1:{i:0;s:7:\"country\";}}}","yes"),
("352","cpto_options","a:7:{s:23:\"show_reorder_interfaces\";a:4:{s:4:\"post\";s:4:\"show\";s:10:\"attachment\";s:4:\"show\";s:8:\"wp_block\";s:4:\"show\";s:7:\"country\";s:4:\"show\";}s:8:\"autosort\";s:0:\"\";s:9:\"adminsort\";i:1;s:18:\"use_query_ASC_DESC\";s:0:\"\";s:17:\"archive_drag_drop\";i:1;s:10:\"capability\";s:14:\"manage_options\";s:21:\"navigation_sort_apply\";i:1;}","yes"),
("353","CPT_configured","TRUE","yes"),
("368","duplicator_pro_reset_user_settings_required","0","yes"),
("369","duplicator_pro_plugin_version","4.0.2","yes"),
("370","duplicator_pro_license_key","80d49998f6265a26aa780fc8df4eab33","yes"),
("388","a42f12af0b7084cf112c3f1a6f6224b7","a:2:{s:7:\"timeout\";i:1619077523;s:5:\"value\";s:1139:\"{\"new_version\":\"4.0.2\",\"stable_version\":\"4.0.2\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/snapcreek.com\\/downloads\\/duplicator-pro\\/?changelog=1\",\"last_updated\":\"2021-04-12 11:27:01\",\"homepage\":\"https:\\/\\/snapcreek.com\\/duplicator\",\"package\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTYyMDA4OTEyMzo4MGQ0OTk5OGY2MjY1YTI2YWE3ODBmYzhkZjRlYWIzMzozMTphOTcyM2NhM2IxYzVlMzEzZjQ0MGIxMDI0OGI0Y2Q1NTpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"download_link\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTYyMDA4OTEyMzo4MGQ0OTk5OGY2MjY1YTI2YWE3ODBmYzhkZjRlYWIzMzozMTphOTcyM2NhM2IxYzVlMzEzZjQ0MGIxMDI0OGI0Y2Q1NTpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\",\"sections\":{\"description\":\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\",\"changelog\":\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":\"a:0:{}\",\"tested\":\"5.7\",\"description\":[\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\"],\"changelog\":[\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\"]}\";}","yes"),
("405","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("801","WPLANG","","yes"),
("802","new_admin_email","info@sgsmedia.dk","yes"),
("1712","duplicate_post_copytitle","1","yes"),
("1713","duplicate_post_copydate","0","yes"),
("1714","duplicate_post_copystatus","0","yes"),
("1715","duplicate_post_copyslug","0","yes"),
("1716","duplicate_post_copyexcerpt","1","yes"),
("1717","duplicate_post_copycontent","1","yes"),
("1718","duplicate_post_copythumbnail","1","yes"),
("1719","duplicate_post_copytemplate","1","yes"),
("1720","duplicate_post_copyformat","1","yes"),
("1721","duplicate_post_copyauthor","0","yes"),
("1722","duplicate_post_copypassword","0","yes"),
("1723","duplicate_post_copyattachments","0","yes"),
("1724","duplicate_post_copychildren","0","yes"),
("1725","duplicate_post_copycomments","0","yes"),
("1726","duplicate_post_copymenuorder","1","yes"),
("1727","duplicate_post_taxonomies_blacklist","a:0:{}","yes"),
("1728","duplicate_post_blacklist","","yes"),
("1729","duplicate_post_types_enabled","a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}","yes"),
("1730","duplicate_post_show_original_column","0","yes"),
("1731","duplicate_post_show_original_in_post_states","0","yes"),
("1732","duplicate_post_show_original_meta_box","0","yes"),
("1733","duplicate_post_show_link","a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}","yes"),
("1734","duplicate_post_show_link_in","a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}","yes"),
("1735","duplicate_post_show_notice","0","no"),
("1736","duplicate_post_version","4.1.2","yes"),
("2089","options_social_media_icons_0_social_media_item_name","Facebook","no"),
("2090","_options_social_media_icons_0_social_media_item_name","field_606ead15579e4","no"),
("2091","options_social_media_icons_0_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n  <path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>\r\n","no"),
("2092","_options_social_media_icons_0_social_media_item_icon","field_606ead32579e5","no"),
("2093","options_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("2094","_options_social_media_icons_0_social_media_item_url","field_606ead3d579e6","no"),
("2095","options_social_media_icons_1_social_media_item_name","Youtube","no"),
("2096","_options_social_media_icons_1_social_media_item_name","field_606ead15579e4","no"),
("2097","options_social_media_icons_1_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n  <path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>\r\n","no"),
("2098","_options_social_media_icons_1_social_media_item_icon","field_606ead32579e5","no"),
("2099","options_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("2100","_options_social_media_icons_1_social_media_item_url","field_606ead3d579e6","no"),
("2101","options_social_media_icons_2_social_media_item_name","Instagram","no"),
("2102","_options_social_media_icons_2_social_media_item_name","field_606ead15579e4","no"),
("2103","options_social_media_icons_2_social_media_item_icon","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n  <path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>\r\n","no"),
("2104","_options_social_media_icons_2_social_media_item_icon","field_606ead32579e5","no"),
("2105","options_social_media_icons_2_social_media_item_url","https://instagram.com","no"),
("2106","_options_social_media_icons_2_social_media_item_url","field_606ead3d579e6","no"),
("2107","options_social_media_icons","3","no"),
("2108","_options_social_media_icons","field_606eacf3a8d94","no"),
("2109","options_theme_header_scripts_head","<script>\r\nconsole.log(\"Within <head>\");\r\n</script>","no"),
("2110","_options_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("2111","options_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"After opening <body>\");\r\n</script>","no"),
("2112","_options_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("2113","options_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"Footer script\");\r\n</script>","no"),
("2114","_options_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("2194","options_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("2195","_options_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("2196","options_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("2197","_options_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("2198","options_theme_404_reuseable_section_rules","","no"),
("2199","_options_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("2200","options_theme_404_theme_404_text","<h2>404</h2>\r\n<strong>This page doesn\'t exist.</strong>\r\n\r\nPlease try again.","no"),
("2201","_options_theme_404_theme_404_text","field_606eff990ac3e","no"),
("2202","options_theme_404","","no"),
("2203","_options_theme_404","field_606eff05095e9","no"),
("2210","options_theme_404_header_theme","dark","no"),
("2211","_options_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3097","icl_sitepress_version","4.4.10","yes"),
("3098","icl_sitepress_settings","a:60:{s:19:\"hide_upgrade_notice\";s:6:\"4.4.10\";s:25:\"icl_capabilities_verified\";b:1;s:16:\"active_languages\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:21:\"interview_translators\";i:1;s:34:\"existing_content_language_verified\";i:1;s:25:\"language_negotiation_type\";s:1:\"1\";s:18:\"icl_lso_link_empty\";i:0;s:18:\"sync_page_ordering\";i:1;s:16:\"sync_page_parent\";i:1;s:18:\"sync_page_template\";i:1;s:16:\"sync_ping_status\";i:1;s:19:\"sync_comment_status\";i:1;s:16:\"sync_sticky_flag\";i:1;s:13:\"sync_password\";i:1;s:17:\"sync_private_flag\";i:1;s:16:\"sync_post_format\";i:1;s:11:\"sync_delete\";i:0;s:15:\"sync_delete_tax\";i:0;s:20:\"sync_post_taxonomies\";i:1;s:14:\"sync_post_date\";i:0;s:21:\"sync_taxonomy_parents\";i:0;s:25:\"translation_pickup_method\";i:0;s:15:\"notify_complete\";i:1;s:26:\"translated_document_status\";i:1;s:17:\"remote_management\";i:0;s:15:\"auto_adjust_ids\";i:1;s:11:\"alert_delay\";i:0;s:12:\"promote_wpml\";i:0;s:18:\"automatic_redirect\";i:0;s:17:\"remember_language\";i:24;s:28:\"icl_lang_sel_copy_parameters\";s:0:\"\";s:28:\"translated_document_page_url\";s:13:\"auto-generate\";s:27:\"sync_comments_on_duplicates\";i:0;s:3:\"seo\";a:3:{s:10:\"head_langs\";i:1;s:27:\"canonicalization_duplicates\";i:1;s:19:\"head_langs_priority\";i:1;}s:22:\"posts_slug_translation\";a:2:{s:2:\"on\";i:1;s:20:\"string_name_migrated\";b:1;}s:4:\"urls\";a:5:{s:30:\"directory_for_default_language\";i:0;s:12:\"show_on_root\";s:0:\"\";s:19:\"root_html_file_path\";s:0:\"\";s:9:\"root_page\";i:0;s:23:\"hide_language_switchers\";i:1;}s:12:\"xdomain_data\";s:1:\"1\";s:24:\"custom_posts_sync_option\";a:13:{s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;s:10:\"custom_css\";s:1:\"0\";s:19:\"customize_changeset\";s:1:\"0\";s:12:\"oembed_cache\";s:1:\"0\";s:12:\"user_request\";s:1:\"0\";s:15:\"acf-field-group\";s:1:\"0\";s:7:\"country\";s:1:\"0\";s:6:\"assets\";s:1:\"2\";s:9:\"statement\";s:1:\"2\";s:14:\"section_blocks\";s:1:\"2\";}s:22:\"taxonomies_sync_option\";a:3:{s:8:\"category\";i:1;s:8:\"post_tag\";i:1;s:20:\"translation_priority\";i:1;}s:28:\"tm_block_retranslating_terms\";i:1;s:22:\"admin_default_language\";s:9:\"_default_\";s:22:\"taxonomy_names_checked\";b:1;s:14:\"setup_complete\";i:1;s:18:\"ajx_health_checked\";b:1;s:2:\"st\";a:17:{s:25:\"db_ok_for_gettext_context\";b:1;s:41:\"WPML_ST_Upgrade_Migrate_Originals_has_run\";b:1;s:48:\"WPML_ST_Upgrade_Db_Cache_Command_2.4.2_2_has_run\";b:1;s:52:\"WPML_ST_Upgrade_Display_Strings_Scan_Notices_has_run\";b:1;s:37:\"WPML_ST_Upgrade_MO_Scanning_4_has_run\";b:1;s:46:\"WPML_ST_Upgrade_DB_String_Name_Index_2_has_run\";b:1;s:48:\"WPML_ST_Upgrade_DB_Longtext_String_Value_has_run\";b:1;s:53:\"WPML\\ST\\MO\\Generate\\Process\\Status_background_has_run\";b:1;s:64:\"WPML\\ST\\Upgrade\\Command\\RegenerateMoFilesWithStringNames_has_run\";b:1;s:42:\"WPML\\ST\\MO\\Generate\\Process\\Status_has_run\";b:1;s:16:\"strings_per_page\";i:10;s:15:\"icl_st_auto_reg\";s:7:\"disable\";s:16:\"strings_language\";s:2:\"en\";s:16:\"translated-users\";a:0:{}s:2:\"sw\";a:0:{}s:53:\"WPML_ST_Upgrade_DB_String_Packages_Word_Count_has_run\";b:1;s:48:\"WPML_ST_Upgrade_DB_String_Packages_2.4.2_has_run\";b:1;}s:18:\"default_categories\";a:2:{s:2:\"en\";s:1:\"1\";s:2:\"da\";i:11;}s:16:\"default_language\";s:2:\"en\";s:17:\"setup_wizard_step\";i:6;s:66:\"admin_text_3_2_migration_complete_0e76ff20c1fe93878b4cf152f317989a\";b:1;s:22:\"translation-management\";a:14:{s:25:\"custom_fields_translation\";a:79:{s:5:\"title\";i:2;s:11:\"description\";i:2;s:8:\"keywords\";i:2;s:10:\"_edit_last\";i:0;s:10:\"_edit_lock\";i:0;s:17:\"_wp_page_template\";i:0;s:23:\"_wp_attachment_metadata\";i:0;s:16:\"original_post_id\";i:0;s:22:\"_wpml_original_post_id\";i:0;s:12:\"_wp_old_slug\";i:0;s:20:\"_icl_translator_note\";i:0;s:14:\"_alp_processed\";i:0;s:7:\"_pingme\";i:0;s:10:\"_encloseme\";i:0;s:22:\"_icl_lang_duplicate_of\";i:0;s:13:\"_thumbnail_id\";i:0;s:17:\"_wp_attached_file\";i:0;s:24:\"_wp_attachment_image_alt\";i:2;s:22:\"country_dealor_locator\";i:3;s:24:\"country_announcement_bar\";i:3;s:20:\"theme_settings_group\";i:1;s:18:\"social_media_icons\";i:0;s:22:\"social_media_item_name\";i:0;s:22:\"social_media_item_icon\";i:0;s:21:\"social_media_item_url\";i:0;s:21:\"_theme_settings_group\";i:1;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_0_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_1_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_2_social_media_item_url\";i:0;s:39:\"theme_settings_group_social_media_icons\";i:0;s:15:\"statement_slide\";i:3;s:16:\"_statement_slide\";i:1;s:50:\"flex_items_6_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_6_reuseable_buttons_button_custom_items\";i:1;s:37:\"reuseable_buttons_button_custom_items\";i:3;s:38:\"_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_1_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_1_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_0_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_0_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_4_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_4_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_5_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_5_reuseable_buttons_button_custom_items\";i:1;s:19:\"button_custom_items\";i:3;s:20:\"_button_custom_items\";i:1;s:84:\"global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:3;s:85:\"_global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:1;s:29:\"adventure_category_block_item\";i:3;s:30:\"_adventure_category_block_item\";i:1;s:20:\"product_assets_items\";i:3;s:21:\"_product_assets_items\";i:1;s:17:\"global_flex_items\";i:3;s:18:\"_global_flex_items\";i:1;s:36:\"global_adventure_category_block_item\";i:3;s:37:\"_global_adventure_category_block_item\";i:1;s:41:\"global_flex_items_0_whats_in_the_box_spec\";i:3;s:42:\"_global_flex_items_0_whats_in_the_box_spec\";i:1;s:21:\"whats_in_the_box_spec\";i:3;s:22:\"_whats_in_the_box_spec\";i:1;s:37:\"global_flex_items_0_global_specs_item\";i:3;s:38:\"_global_flex_items_0_global_specs_item\";i:1;s:17:\"global_specs_item\";i:3;s:18:\"_global_specs_item\";i:1;s:35:\"global_flex_items_0_global_faq_item\";i:3;s:36:\"_global_flex_items_0_global_faq_item\";i:1;s:15:\"global_faq_item\";i:3;s:16:\"_global_faq_item\";i:1;s:10:\"flex_items\";i:3;s:11:\"_flex_items\";i:1;s:23:\"_country_dealor_locator\";i:1;s:25:\"_country_announcement_bar\";i:1;s:24:\"flex_items_10_step_items\";N;}s:29:\"custom_fields_readonly_config\";a:18:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:24:\"_wp_attachment_image_alt\";}s:32:\"custom_fields_translation_custom\";a:0:{}s:41:\"custom_fields_translation_custom_readonly\";a:0:{}s:22:\"doc_translation_method\";i:0;s:35:\"__custom_types_readonly_config_prev\";a:0:{}s:28:\"custom_types_readonly_config\";a:0:{}s:36:\"__custom_fields_readonly_config_prev\";a:18:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:24:\"_wp_attachment_image_alt\";}s:41:\"__custom_term_fields_readonly_config_prev\";a:0:{}s:34:\"custom_term_fields_readonly_config\";a:0:{}s:26:\"taxonomies_readonly_config\";a:1:{s:20:\"translation_priority\";i:1;}s:28:\"custom-types_readonly_config\";a:2:{s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;}s:12:\"notification\";a:9:{s:7:\"new-job\";i:1;s:13:\"include_xliff\";i:0;s:19:\"completed_frequency\";i:3;s:9:\"completed\";i:1;s:8:\"resigned\";i:1;s:7:\"overdue\";i:1;s:14:\"overdue_offset\";i:7;s:9:\"dashboard\";b:1;s:9:\"purge-old\";i:7;}s:30:\"custom_term_fields_translation\";a:61:{s:22:\"country_dealor_locator\";i:3;s:24:\"country_announcement_bar\";i:3;s:20:\"theme_settings_group\";i:1;s:18:\"social_media_icons\";i:0;s:22:\"social_media_item_name\";i:0;s:22:\"social_media_item_icon\";i:0;s:21:\"social_media_item_url\";i:0;s:21:\"_theme_settings_group\";i:1;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_0_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_0_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_1_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_1_social_media_item_url\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_name\";i:0;s:64:\"theme_settings_group_social_media_icons_2_social_media_item_icon\";i:0;s:63:\"theme_settings_group_social_media_icons_2_social_media_item_url\";i:0;s:39:\"theme_settings_group_social_media_icons\";i:0;s:15:\"statement_slide\";i:3;s:16:\"_statement_slide\";i:1;s:50:\"flex_items_6_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_6_reuseable_buttons_button_custom_items\";i:1;s:37:\"reuseable_buttons_button_custom_items\";i:3;s:38:\"_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_1_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_1_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_0_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_0_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_4_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_4_reuseable_buttons_button_custom_items\";i:1;s:50:\"flex_items_5_reuseable_buttons_button_custom_items\";i:3;s:51:\"_flex_items_5_reuseable_buttons_button_custom_items\";i:1;s:19:\"button_custom_items\";i:3;s:20:\"_button_custom_items\";i:1;s:84:\"global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:3;s:85:\"_global_flex_items_0_global_adventure_categories_global_adventure_category_block_item\";i:1;s:29:\"adventure_category_block_item\";i:3;s:30:\"_adventure_category_block_item\";i:1;s:20:\"product_assets_items\";i:3;s:21:\"_product_assets_items\";i:1;s:17:\"global_flex_items\";i:3;s:18:\"_global_flex_items\";i:1;s:36:\"global_adventure_category_block_item\";i:3;s:37:\"_global_adventure_category_block_item\";i:1;s:41:\"global_flex_items_0_whats_in_the_box_spec\";i:3;s:42:\"_global_flex_items_0_whats_in_the_box_spec\";i:1;s:21:\"whats_in_the_box_spec\";i:3;s:22:\"_whats_in_the_box_spec\";i:1;s:37:\"global_flex_items_0_global_specs_item\";i:3;s:38:\"_global_flex_items_0_global_specs_item\";i:1;s:17:\"global_specs_item\";i:3;s:18:\"_global_specs_item\";i:1;s:35:\"global_flex_items_0_global_faq_item\";i:3;s:36:\"_global_flex_items_0_global_faq_item\";i:1;s:15:\"global_faq_item\";i:3;s:16:\"_global_faq_item\";i:1;s:10:\"flex_items\";i:3;s:11:\"_flex_items\";i:1;s:23:\"_country_dealor_locator\";i:1;s:25:\"_country_announcement_bar\";i:1;s:24:\"flex_items_10_step_items\";N;}}s:24:\"custom-types_sync_option\";a:2:{s:10:\"attachment\";i:1;s:8:\"wp_block\";i:1;}s:29:\"language_selector_initialized\";i:1;s:15:\"languages_order\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:27:\"dont_show_help_admin_notice\";b:1;s:8:\"site_key\";s:10:\"62PcN7ptS9\";s:14:\"xliff_newlines\";i:2;s:16:\"tm_xliff_version\";s:2:\"12\";s:21:\"site_does_not_use_icl\";b:1;s:31:\"language_per_domain_sso_enabled\";b:0;s:28:\"custom_posts_unlocked_option\";a:13:{s:4:\"post\";s:1:\"0\";s:4:\"page\";s:1:\"0\";s:10:\"attachment\";s:1:\"0\";s:10:\"custom_css\";s:1:\"0\";s:19:\"customize_changeset\";s:1:\"0\";s:12:\"oembed_cache\";s:1:\"0\";s:12:\"user_request\";s:1:\"0\";s:8:\"wp_block\";s:1:\"0\";s:15:\"acf-field-group\";s:1:\"0\";s:7:\"country\";s:1:\"0\";s:6:\"assets\";s:1:\"0\";s:9:\"statement\";s:1:\"0\";s:14:\"section_blocks\";s:1:\"0\";}}","yes"),
("3099","_wpml_media","a:2:{s:20:\"new_content_settings\";a:3:{s:22:\"always_translate_media\";b:1;s:15:\"duplicate_media\";b:0;s:18:\"duplicate_featured\";b:0;}s:13:\"starting_help\";i:1;}","yes"),
("3101","wpml_dependencies:needs_validation","","yes"),
("3102","wpml_dependencies:valid_plugins","a:3:{i:0;s:26:\"sitepress-multilingual-cms\";i:1;s:23:\"wpml-string-translation\";i:2;s:27:\"wpml-translation-management\";}","yes"),
("3103","wpml_dependencies:invalid_plugins","a:0:{}","yes"),
("3104","wpml_dependencies:expected_versions","a:8:{s:26:\"sitepress-multilingual-cms\";s:6:\"4.4.10\";s:23:\"wpml-string-translation\";s:5:\"3.1.8\";s:27:\"wpml-translation-management\";s:6:\"2.10.6\";s:24:\"woocommerce-multilingual\";s:5:\"4.7.8\";s:22:\"wpml-media-translation\";s:5:\"2.6.4\";s:17:\"wpml-sticky-links\";s:5:\"1.5.0\";s:12:\"wpml-cms-nav\";s:5:\"1.5.0\";s:25:\"gravityforms-multilingual\";s:5:\"1.5.0\";}","yes"),
("3105","wpml_config_index","O:8:\"stdClass\":2:{s:7:\"plugins\";a:77:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:33:\"10bit WooCommerce Gateway Yaadpay\";s:14:\"override_local\";b:1;s:4:\"path\";s:61:\"wpml-config/10bit-woocommerce-gateway-yaadpay/wpml-config.xml\";s:7:\"updated\";i:1464939780;s:4:\"hash\";s:32:\"ebdce80f3b6bfa13112b1d4c6a31b560\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Atomic Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/atomic-blocks/wpml-config.xml\";s:7:\"updated\";i:1585156226;s:4:\"hash\";s:32:\"8d93d53d0fa037f291aaf9aa5980c287\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Book Now\";s:14:\"override_local\";b:0;s:4:\"path\";s:36:\"wpml-config/book-now/wpml-config.xml\";s:7:\"updated\";i:1505319840;s:4:\"hash\";s:32:\"d123c0bb22d447095c3c443cb41c273a\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"Beaver Builder Plugin (Lite Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Beaver Builder Plugin (Pro Version)\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/beaver-builder/wpml-config.xml\";s:7:\"updated\";i:1605029057;s:4:\"hash\";s:32:\"63175e4d72e6069035ea9c118b6d7386\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Cornerstone\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/cornerstone/wpml-config.xml\";s:7:\"updated\";i:1615980863;s:4:\"hash\";s:32:\"72c530c79ebe68006852d7969faa920d\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/custom-post-type-ui/wpml-config.xml\";s:7:\"updated\";i:1604075857;s:4:\"hash\";s:32:\"c35b9664bea4b9d9b83b5748e14be9b0\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"Divi Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/divi-builder/wpml-config.xml\";s:7:\"updated\";i:1587547708;s:4:\"hash\";s:32:\"cbb7d6199720d2d35490e99404e6fc70\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Event Tickets Plus\";s:14:\"override_local\";b:0;s:4:\"path\";s:46:\"wpml-config/event-tickets-plus/wpml-config.xml\";s:7:\"updated\";i:1477310580;s:4:\"hash\";s:32:\"f333802d6c6c9836466d3ff52cfe2bd7\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WPBakery Visual Composer\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1591616888;s:4:\"hash\";s:32:\"8ae0f8b6e9e2a4f4320e5fb325adf900\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:37:\"Uncode Page Builder (Visual Composer)\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Uncode WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/uncode-js_composer/wpml-config.xml\";s:7:\"updated\";i:1580467972;s:4:\"hash\";s:32:\"3d429187f051bcc1910b6549c06e93d8\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"The7 WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/js_composer-dt-the7/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"caf05daa7509c1127194c88dee427879\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"MailChimp for WordPress\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/mailchimp-for-wp/wpml-config.xml\";s:7:\"updated\";i:1509614640;s:4:\"hash\";s:32:\"c4f8573312cdf0f71d9329ae82d4ec49\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Members\";s:14:\"override_local\";b:0;s:4:\"path\";s:35:\"wpml-config/members/wpml-config.xml\";s:7:\"updated\";i:1497367620;s:4:\"hash\";s:32:\"37e638f5a56f59208150c3649c291e41\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:46:\"Multibanco (IfthenPay gateway) for WooCommerce\";s:14:\"override_local\";b:0;s:4:\"path\";s:72:\"wpml-config/multibanco-ifthenpay-gateway-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1441014780;s:4:\"hash\";s:32:\"3cddef77fd163e090472f995aa2388d4\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"NW ADCart for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:53:\"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734260;s:4:\"hash\";s:32:\"91d62df0659fc7b561a3932a7a52de6a\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:22:\"PayPal for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:50:\"wpml-config/paypal-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1504696980;s:4:\"hash\";s:32:\"8d98b39c86e95094e6b7727fda7a6f00\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Product Enquiry Pro for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734500;s:4:\"hash\";s:32:\"305232f06370d52a29c346d6b711f50a\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Sensei\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1608203125;s:4:\"hash\";s:32:\"fa341db21f78fc003f66f7b13a239fd2\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Sensei LMS\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1608203125;s:4:\"hash\";s:32:\"fa341db21f78fc003f66f7b13a239fd2\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Subscriptio\";s:14:\"override_local\";b:0;s:4:\"path\";s:39:\"wpml-config/subscriptio/wpml-config.xml\";s:7:\"updated\";i:1519647600;s:4:\"hash\";s:32:\"a23128c1dde651ef63093336042948e5\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPML Multilingual CMS\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/sitepress-multilingual-cms/wpml-config.xml\";s:7:\"updated\";i:1611515848;s:4:\"hash\";s:32:\"262f1fffdf41236fd99cfab04ed45b26\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"The Events Calendar\";s:14:\"override_local\";b:1;s:4:\"path\";s:47:\"wpml-config/the-events-calendar/wpml-config.xml\";s:7:\"updated\";i:1597940433;s:4:\"hash\";s:32:\"9dc1b1aa9bdd03cb5f8057ebb4976651\";}i:25;O:8:\"stdClass\":5:{s:4:\"name\";s:31:\"The Events Calendar: Filter Bar\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/events-filterbar/wpml-config.xml\";s:7:\"updated\";i:1529671740;s:4:\"hash\";s:32:\"787231e7b7cdb54ca447512234be0768\";}i:26;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Woocomerce Brands Pro\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/woo-brand/wpml-config.xml\";s:7:\"updated\";i:1442243400;s:4:\"hash\";s:32:\"dc7eeb10cd6e0eb80b7960eb8b6058a4\";}i:27;O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"WooCommerce Additional Variation Images\";s:14:\"override_local\";b:1;s:4:\"path\";s:67:\"wpml-config/woocommerce-additional-variation-images/wpml-config.xml\";s:7:\"updated\";i:1479214860;s:4:\"hash\";s:32:\"39b5f72684021b09b12b53b7ff9c7100\";}i:28;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"WooCommerce Advanced Product Labels\";s:14:\"override_local\";b:0;s:4:\"path\";s:63:\"wpml-config/woocommerce-advanced-product-labels/wpml-config.xml\";s:7:\"updated\";i:1441177080;s:4:\"hash\";s:32:\"4b29c29516a1a33b328d90ffc5c4aad7\";}i:29;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Bookings\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-bookings/wpml-config.xml\";s:7:\"updated\";i:1518696060;s:4:\"hash\";s:32:\"cf704fa60399163e82de88dfca25b644\";}i:30;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"WooCommerce Catalog Visibility Options\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml\";s:7:\"updated\";i:1408625580;s:4:\"hash\";s:32:\"d10bd6388a88521e488f7e4ba295c94c\";}i:31;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Composite Products\";s:14:\"override_local\";b:0;s:4:\"path\";s:58:\"wpml-config/woocommerce-composite-products/wpml-config.xml\";s:7:\"updated\";i:1491207900;s:4:\"hash\";s:32:\"a6c0ed6554be69f56779f64506ab96d1\";}i:32;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Currency Converter\";s:14:\"override_local\";b:1;s:4:\"path\";s:58:\"wpml-config/woocommerce-currency-converter/wpml-config.xml\";s:7:\"updated\";i:1452009180;s:4:\"hash\";s:32:\"b2191d7affaf1efe74e6a3ca4b0494c6\";}i:33;O:8:\"stdClass\":5:{s:4:\"name\";s:32:\"WooCommerce DIBS FlexWin Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:60:\"wpml-config/woocommerce-dibs-flexwin-gateway/wpml-config.xml\";s:7:\"updated\";i:1459514460;s:4:\"hash\";s:32:\"d9237f895f0f133c8e11f4753d96eeca\";}i:34;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Embed Slides\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-embed-slides/wpml-config.xml\";s:7:\"updated\";i:1499457300;s:4:\"hash\";s:32:\"243e3a54d920cc2ddf96f17f4ff38f2d\";}i:35;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Local Pickup Plus\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-local-pickup-plus/wpml-config.xml\";s:7:\"updated\";i:1442582820;s:4:\"hash\";s:32:\"816774f477bfa1c481cdba021d33f705\";}i:36;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Multilingual\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-multilingual/wpml-config.xml\";s:7:\"updated\";i:1582106737;s:4:\"hash\";s:32:\"11b7488184353144fae7147f143b5150\";}i:37;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Memberships\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-memberships/wpml-config.xml\";s:7:\"updated\";i:1585587094;s:4:\"hash\";s:32:\"b12275a5491bc1858f181f56158b7a91\";}i:38;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Name Your Price\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-name-your-price/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"055de38e55802236ee636eec63bdde5e\";}i:39;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Paymill Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-paymill-gateway/wpml-config.xml\";s:7:\"updated\";i:1408626540;s:4:\"hash\";s:32:\"46409842584ff8df43a2aa922ad1d388\";}i:40;O:8:\"stdClass\":5:{s:4:\"name\";s:40:\"WooCommerce PDF Invoices & Packing Slips\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-pdf-invoices-packing-slips/wpml-config.xml\";s:7:\"updated\";i:1461579300;s:4:\"hash\";s:32:\"34ecf8066c5c9042a0bd60b5d40c4c55\";}i:41;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"WooCommerce Plivo\";s:14:\"override_local\";b:1;s:4:\"path\";s:45:\"wpml-config/woocommerce-plivo/wpml-config.xml\";s:7:\"updated\";i:1409734680;s:4:\"hash\";s:32:\"539d172825c4714d69b8a42ad1826c5d\";}i:42;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce PostePay\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-postepay/wpml-config.xml\";s:7:\"updated\";i:1409063100;s:4:\"hash\";s:32:\"b08722979a25b15ba4a02a16fb555ccc\";}i:43;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"WooCommerce Price by Country\";s:14:\"override_local\";b:1;s:4:\"path\";s:56:\"wpml-config/woocommerce-price-by-country/wpml-config.xml\";s:7:\"updated\";i:1415282880;s:4:\"hash\";s:32:\"9b296d64ba8afee80cb1ff4fac80144b\";}i:44;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Add-ons\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-add-ons/wpml-config.xml\";s:7:\"updated\";i:1476961740;s:4:\"hash\";s:32:\"69f94bed6e4b3546cc7be2fbd2bf392b\";}i:45;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Bundles\";s:14:\"override_local\";b:0;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-bundles/wpml-config.xml\";s:7:\"updated\";i:1487080740;s:4:\"hash\";s:32:\"7cddba745169acd899b12f24e3580dcc\";}i:46;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Product Gift Wrap\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml\";s:7:\"updated\";i:1429639980;s:4:\"hash\";s:32:\"dd3371d64d2ee01e6e42fd7e0bd134cf\";}i:47;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"Woocommerce Social Media Share Buttons\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-social-media-share-buttons/wpml-config.xml\";s:7:\"updated\";i:1464934800;s:4:\"hash\";s:32:\"3130bbf2a35424d9ecd8d6c3255bf817\";}i:48;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"WooCommerce Stripe Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/woocommerce-gateway-stripe/wpml-config.xml\";s:7:\"updated\";i:1409061480;s:4:\"hash\";s:32:\"4139e23bcdd0bb3e78cb079fa851ce85\";}i:49;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Tab Manager\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-tab-manager/wpml-config.xml\";s:7:\"updated\";i:1505158140;s:4:\"hash\";s:32:\"477be025d13abe1c1b89bb7666564ed6\";}i:50;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WooCommerce Video Tab\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/woocommerce-video-tab/wpml-config.xml\";s:7:\"updated\";i:1415284320;s:4:\"hash\";s:32:\"7f9769bc2769e07ae730f3b4cd307741\";}i:51;O:8:\"stdClass\":5:{s:4:\"name\";s:14:\"WP Job Manager\";s:14:\"override_local\";b:0;s:4:\"path\";s:42:\"wpml-config/wp-job-manager/wpml-config.xml\";s:7:\"updated\";i:1499098260;s:4:\"hash\";s:32:\"36842c6b8a11a733ef00ef8d9bc410b9\";}i:52;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"WPML Test Config\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/wpml-test-config/wpml-config.xml\";s:7:\"updated\";i:1429103280;s:4:\"hash\";s:32:\"9c3bb313d5a4f028bebfa8fc8af990a3\";}i:53;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/yoast-seo/wpml-config.xml\";s:7:\"updated\";i:1530098880;s:4:\"hash\";s:32:\"4014a9b37ac42f0cc726390fb9088ebc\";}i:54;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/wordpress-seo/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:55;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"Yoast SEO Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/wordpress-seo-premium/wpml-config.xml\";s:7:\"updated\";i:1592553706;s:4:\"hash\";s:32:\"207e931d1df921957c81fe2554bbf4e9\";}i:56;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Elementor\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/elementor/wpml-config.xml\";s:7:\"updated\";i:1615983959;s:4:\"hash\";s:32:\"8e4061e7a2a47e83af0f14ee2bc8c361\";}i:57;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Exit Popup\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/exit-popup/wpml-config.xml\";s:7:\"updated\";i:1532441340;s:4:\"hash\";s:32:\"9759f24db8621dfa772d7222c9c336dd\";}i:58;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Ninja Forms\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/ninja-forms/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"7b3321902299b49238e59d0741ce1f8d\";}i:59;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Rezgo Online Booking\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/rezgo/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"6f3433a4c5eafa13eaf125eea7d84239\";}i:60;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"MasterSlider\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/master-slider/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"2b5b8d5c1d934ee19a547b66d6c76b69\";}i:61;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Advanced Comment Form\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/comment-form/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a84c0e28e4c97dec1a3053c316c27892\";}i:62;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Search & Filter\";s:14:\"override_local\";b:1;s:4:\"path\";s:41:\"wpml-config/search-filter/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"104b64d62b408a4ae7c5da7ff0acd0b2\";}i:63;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"KingComposer\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/kingcomposer/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"cadb27cc7ba0e61d3fd2acaf27fef4df\";}i:64;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"Ultimate Member\";s:14:\"override_local\";b:1;s:4:\"path\";s:43:\"wpml-config/ultimate-member/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"c80a46117b6be17e1099cb0640f8e722\";}i:65;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"Google Analytics Opt-Out\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/google-analytics-opt-out/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"823965222ce323c88eadbcf95dcde0ff\";}i:66;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"Ajax Search Lite\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/ajax-search-lite/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"79dc60103bbc2eaaf6ac2ff25ca8dfa7\";}i:67;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"Paid Memberships Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/paid-memberships-pro/wpml-config.xml\";s:7:\"updated\";i:1535127720;s:4:\"hash\";s:32:\"a26838992708887d6825bd1fbdceca59\";}i:68;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Forminator\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/forminator/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"ae0a6b1f1bc9fc80ada4833f9ee8917c\";}i:69;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"WooCommerce Mix and Match\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/woocommerce-mix-and-match-products/wpml-config.xml\";s:7:\"updated\";i:1578929211;s:4:\"hash\";s:32:\"82f7fa28a3b0a601056911af209995a2\";}i:70;O:8:\"stdClass\":5:{s:4:\"name\";s:47:\"Kadence Blocks - Gutenberg Page Builder Toolkit\";s:14:\"override_local\";b:1;s:4:\"path\";s:42:\"wpml-config/kadence-blocks/wpml-config.xml\";s:7:\"updated\";i:1589279268;s:4:\"hash\";s:32:\"e3fa847064d1728f8cc936efdbb8077d\";}i:71;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"Ultimate Addons for Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/ultimate-addons-for-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1611145301;s:4:\"hash\";s:32:\"af52385e3657708d91a1d28c046342a1\";}i:72;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Advanced Gutenberg\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1597406669;s:4:\"hash\";s:32:\"76d5552bcf5216438a355122de2a4b76\";}i:73;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"PublishPress Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/advanced-gutenberg/wpml-config.xml\";s:7:\"updated\";i:1597406669;s:4:\"hash\";s:32:\"76d5552bcf5216438a355122de2a4b76\";}i:74;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Click to Chat\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/click-to-chat-for-whatsapp/wpml-config.xml\";s:7:\"updated\";i:1595252694;s:4:\"hash\";s:32:\"ddd29301ed98494707ce5145d2f25ecd\";}i:75;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"Rank Math SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/seo-by-rank-math/wpml-config.xml\";s:7:\"updated\";i:1595411877;s:4:\"hash\";s:32:\"0afae267f73a47afd09ae1d322c41735\";}i:76;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"Stackable - Gutenberg Blocks\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/stackable-ultimate-gutenberg-blocks/wpml-config.xml\";s:7:\"updated\";i:1610535270;s:4:\"hash\";s:32:\"81a1302839deec3105eb9bebcedb4270\";}}s:6:\"themes\";a:25:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Avada\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/avada/wpml-config.xml\";s:7:\"updated\";i:1617612951;s:4:\"hash\";s:32:\"57f25f9087aafe2c8f171f8734107152\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Astra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/astra/wpml-config.xml\";s:7:\"updated\";i:1611238423;s:4:\"hash\";s:32:\"fcaa309ae11fe39ec0e9c99c34bc3efb\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Brooklyn\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/brooklyn/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"960edb3057ad96e2863221e82a4c69d2\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Canvas\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/canvas/wpml-config.xml\";s:7:\"updated\";i:1476729660;s:4:\"hash\";s:32:\"ea1da43b18f87c4aa73982113067cd95\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Customizr\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/customizr/wpml-config.xml\";s:7:\"updated\";i:1440909000;s:4:\"hash\";s:32:\"d63f73a0df72ab558bdbfaadaeb9c737\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Divi\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/Divi/wpml-config.xml\";s:7:\"updated\";i:1616685880;s:4:\"hash\";s:32:\"9f2375958a1e554d632883d25e891da4\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"The7\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/dt-the7/wpml-config.xml\";s:7:\"updated\";i:1534160160;s:4:\"hash\";s:32:\"b99fe39e5d53275b0237a65894036893\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Extra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/extra/wpml-config.xml\";s:7:\"updated\";i:1576677617;s:4:\"hash\";s:32:\"6f40ff074142d6392f49267cbb1176f2\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Emerald CV\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/emerald-cv/wpml-config.xml\";s:7:\"updated\";i:1460387160;s:4:\"hash\";s:32:\"3ab5fd101b71e7b306e48a07801c7557\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Enfold\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/enfold/wpml-config.xml\";s:7:\"updated\";i:1617117834;s:4:\"hash\";s:32:\"a9a32a365b8191be61a5151099f07559\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Function\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/function/wpml-config.xml\";s:7:\"updated\";i:1476729720;s:4:\"hash\";s:32:\"bb6dd583fb2a28ee5c4e2a264a770d60\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Genesis\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/genesis/wpml-config.xml\";s:7:\"updated\";i:1456825680;s:4:\"hash\";s:32:\"795657d127a84e450ad21218284bdd28\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"IDStore - Responsive WordPress Theme\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml\";s:7:\"updated\";i:1499457240;s:4:\"hash\";s:32:\"1c49e6754e661e5eb1c301f8874829da\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Luster\";s:14:\"override_local\";b:0;s:4:\"path\";s:34:\"wpml-config/luster/wpml-config.xml\";s:7:\"updated\";i:1574177482;s:4:\"hash\";s:32:\"82a924b258dea8a7d87ba0002b561b1a\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Port\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/port/wpml-config.xml\";s:7:\"updated\";i:1426496160;s:4:\"hash\";s:32:\"788cce209545b94cfede660d543d7013\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:3:\"Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:31:\"wpml-config/pro/wpml-config.xml\";s:7:\"updated\";i:1532099940;s:4:\"hash\";s:32:\"dcb42604ed20598ed1bee40a90e45f39\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Relevanssi\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/relevanssi/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Relevanssi Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:46:\"wpml-config/relevanssi-premium/wpml-config.xml\";s:7:\"updated\";i:1519735440;s:4:\"hash\";s:32:\"c630dfd3df777607e8f43ea201b413d0\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Resort\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/resort/wpml-config.xml\";s:7:\"updated\";i:1491314280;s:4:\"hash\";s:32:\"363adea9467157a4e0b49d50c2be3b3f\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Reveal\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/reveal/wpml-config.xml\";s:7:\"updated\";i:1461595980;s:4:\"hash\";s:32:\"58db88b09a090c9fcff3d65bd031d14a\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"ReWalk Parent\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/rewalk-parent/wpml-config.xml\";s:7:\"updated\";i:1480345020;s:4:\"hash\";s:32:\"7b17377ed5e4226bc7e3d44270bc7924\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Scrollider\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/scrollider/wpml-config.xml\";s:7:\"updated\";i:1479395940;s:4:\"hash\";s:32:\"83fbe85052a8e7eb7ac61496187c7271\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Uncode\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/uncode/wpml-config.xml\";s:7:\"updated\";i:1612368753;s:4:\"hash\";s:32:\"5fc00f036d83b26035262343c7d3d2db\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:1:\"X\";s:14:\"override_local\";b:1;s:4:\"path\";s:29:\"wpml-config/x/wpml-config.xml\";s:7:\"updated\";i:1534248540;s:4:\"hash\";s:32:\"0d41ca410c22810705838d664c5fa296\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"GeneratePress\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/generatepress/wpml-config.xml\";s:7:\"updated\";i:1591094953;s:4:\"hash\";s:32:\"4fba6e5837b20c7b3e763a4edb85dc47\";}}}","no");

INSERT INTO `wp_options` VALUES 
("3106","wpml_config_index_updated","1618837152","no"),
("3107","wpml_config_files_arr","O:8:\"stdClass\":2:{s:6:\"themes\";a:0:{}s:7:\"plugins\";a:2:{s:19:\"Custom Post Type UI\";s:316:\"<wpml-config>\n    <admin-texts>\n        <key name=\"cptui_*\">\n            <key name=\"*\">\n                <key name=\"label\"/>\n                <key name=\"singular_label\"/>\n                <key name=\"labels\">\n                    <key name=\"*\" /></key>\n            </key>\n        </key>\n    </admin-texts>\n</wpml-config>\n\";s:21:\"WPML Multilingual CMS\";s:13980:\"<wpml-config>\n	<custom-fields>\n		<custom-field action=\"translate\">title</custom-field>\n		<custom-field action=\"translate\">description</custom-field>\n		<custom-field action=\"translate\">keywords</custom-field>\n		<custom-field action=\"ignore\">_edit_last</custom-field>\n		<custom-field action=\"ignore\">_edit_lock</custom-field>\n		<custom-field action=\"ignore\">_wp_page_template</custom-field>\n		<custom-field action=\"ignore\">_wp_attachment_metadata</custom-field>\n		<custom-field action=\"ignore\">original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wpml_original_post_id</custom-field>\n		<custom-field action=\"ignore\">_wp_old_slug</custom-field>\n		<custom-field action=\"ignore\">_icl_translator_note</custom-field>\n		<custom-field action=\"ignore\">_alp_processed</custom-field>\n		<custom-field action=\"ignore\">_pingme</custom-field>\n		<custom-field action=\"ignore\">_encloseme</custom-field>\n		<custom-field action=\"ignore\">_icl_lang_duplicate_of</custom-field>\n		<custom-field action=\"ignore\">_thumbnail_id</custom-field>\n		<custom-field action=\"ignore\">_wp_attached_file</custom-field>\n		<custom-field action=\"translate\">_wp_attachment_image_alt</custom-field>\n	</custom-fields>\n	<taxonomies>\n		<taxonomy translate=\"1\">translation_priority</taxonomy>\n	</taxonomies>\n	<language-switcher-settings>\n		<key name=\"link_empty\">0</key>\n		<key name=\"statics\">\n			<key name=\"footer\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">1</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n				<key name=\"font_current_normal\">#444444</key>\n				<key name=\"font_current_hover\">#000000</key>\n				<key name=\"background_current_normal\">#ffffff</key>\n				<key name=\"background_current_hover\">#eeeeee</key>\n				<key name=\"font_other_normal\">#444444</key>\n				<key name=\"font_other_hover\">#000000</key>\n				<key name=\"background_other_normal\">#ffffff</key>\n				<key name=\"background_other_hover\">#eeeeee</key>\n				<key name=\"border\">#cdcdcd</key>\n			</key>\n			<key name=\"post_translations\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">0</key>\n				<key name=\"display_before_content\">1</key>\n				<key name=\"display_after_content\">0</key>\n				<key name=\"availability_text\">This post is also available in: %s</key>\n			</key>\n			<key name=\"shortcode_actions\">\n				<key name=\"show\">0</key>\n				<key name=\"display_flags\">0</key>\n				<key name=\"display_names_in_current_lang\">1</key>\n				<key name=\"display_names_in_native_lang\">1</key>\n				<key name=\"display_link_for_current_lang\">1</key>\n			</key>\n		</key>\n	</language-switcher-settings>\n	<custom-types>\n		<custom-type translate=\"1\">attachment</custom-type>\n		<custom-type translate=\"1\">wp_block</custom-type>\n	</custom-types>\n	<shortcode-list>call_to_action,newsletter,tours_shortcode,cta_button,woocommerce_thankyou,woocommerce_shop,table,custom_profile,symple_heading,row,tagcloud,sform,nano,add_eventon_list,che,era,essa,nel,gli,per,come,anima,ella,quel,show_gd_mylist_btn,su_spoiler,email,vul,wpv-view,wpv-post-field,accordion_item,citation,gallery,foogallery,user-submitted-posts,chronologie,adresse,get_unit_label,get_reference_label,woocommerce_api_manager_lost_api_key,wp-knowledgebase,testimonials_slider,rpwe,posts,nowotworu,intima-media,dostarcza,standaryzowany,jako,czarny,ekstrakt,kwas,std,dwuwodzian,stm_icon_box,ess_grid,rev_slider,linkview,dropcap,permalinklist,testimonial_slider,woocommerce_software_lost_license,text-blocks,wp_sitemap_page,wcmp_vendor,vendor_registration,efsrow,efscolumn,efsbutton,md_rev_slider,md_live_text,md_imagebox_full,flagallery,pbr_quicklinksmenu,rev_slider_vc,opalhotel_reservation_form,pbr_title_heading,pbr_testimonials,embedyt,yith_wcwl_wishlist,wcm_content_restricted,feature_box,woocommerce_en_check,wc_box,wc_row,wc_column,wc_fullwidth,wc_center,wp_social_sharing,infoboxes,testimonials,woocommerce_social_media_share_buttons,wcv_vendor_dashboard,wcv_shop_settings,wcv_orders,inplayer,useyourdrive,wp_blog_designer,us_blog,tt_address,tt_dashboard,envira-gallery,hotspotitem,woocommerce_klarna_checkout,wpml_mailto,contact-field,ux_banner,advanced_iframe,siteorigin_widget,ec_store,simpay_payment_receipt,su-mensaje,borlabs_cookie,contact_info,stm_boats_video,packages_orderdata,yith_ywraq_request_quote,woocommerce_pay,button,supsystic-tables,clean-login,woocommerce_pay,pdf-embedder,insertgenerator,youzer_register,wysija_form,video,customer-area,customer-area-dashboard,customer-area-private-files-home,customer-area-private-files,customer-account-home,customer-area-account,customer-area-logout,bookly-form,bookly-cancellation-confirmation,stm_classic_filter,popup_trigger,mainwp_archived_lists,wcv_vendorslist,dotpay_content,formularz,cyberactive_school_courses_selection_form,cyberactive_school_session_timeout,ditty_news_ticker,donationcampaign,das-list-events,event_embed,sectiontitle,learn_press_profile,ticket-submit,tickets,aanduiding,datum,thim-icon-box,ngg_images,wpdomainchecker,visualizer,mk_page_section,rssreviews,animate_this,simple-sitemap,gravityform,stm_tech_info,fep_submission_form,ucaddon_diagonal_event_box,wcv_feedback_form,newsletters_management,wcv_pro_dashboard,tm_pb_section,wwof_product_listing,res_map,jssupportticket,socialbar,socialbar_service,front-end-pm,stm_sidebar,give_receipt,donation_history,simpay_error,tm_pb_contact_field,jwp,woocommerce_checkout,mk_custom_list,sg_popup,icon,extra_wrap,frontier-post,invierno,appbox,highlight,ci_alert,vc_mad_products,dt_list,geoip-continent,geoip-country,geoip-region,geoip-city,geoip-postalcode,geoip-latitude,geoip-longitude,geoip-location,woocommerce_notices,stm_icon_box,post-timeline,tt_address,private-message,visualizer,ga_optout,manage_serial_key_usage,ut_header,site_name,bfname,order_id,menu-country,menu-prefer,accordion-item,mini-icon,gvlogic,stm_gmap,contact-form,iconbox,woocommerce_my_account,super_form,wpdm-all-packages,photoblocks,et_pb_map_pin,ginger_reset_cookie,su_divider,fbl_login_button,gmw_single_location,one_full,recent_products,custom_list,endif,jours,wpuf-login,lyte,product_table,wpuf-registration,wpuf_dashboard,amazon,member-pricing-table,rozinky,ngg_images,add_to_cart_url,srizonfbgallery,wysija_form,cl-itext,embedyt,icon_counter,text_block,vtftable,header_static,bookingcalendar,flexslider,anova-geoip-meta,zp_vc_slideshow_element,zp_scrollto,my_calendar_upcoming,wpv-post-url,fusion_button,su_tab,freeconsultation_technical_forum_link,vc_images_carousel,otgs_logo_url,wpv-conditional,wpv-view,teaser,dt_fancy_image,fusion_tagline_box,contact_us_add,content_box,tagline_box,us_iconbox,fusion_tab,fisicamente,one_half_sidebar,action-btn,invicta_contacts,pricing_price,button,icon_link,slideshow,vcex_milestone,secondary-demo,vh_pricing_table,category_name,blogurl,q_team,tab_nav_item</shortcode-list>\n\n	<built-with-page-builder><![CDATA[/<!-- wp:/]]></built-with-page-builder>\n\n	<gutenberg-blocks>\n		<gutenberg-block type=\"core/paragraph\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/heading\" translate=\"1\">\n			<xpath>//*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/button\" translate=\"1\">\n			<xpath>//a</xpath>\n			<xpath type=\'link\'>//a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/image\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure//img/@alt</xpath>\n			<xpath>//figure//img/@title</xpath>\n			<xpath type=\'link\'>//figure/a/@href</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/gallery\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/media-text\" translate=\"1\">\n			<xpath>//figure/img/@alt</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/list\" translate=\"1\">\n			<xpath>//ul/li|//ol/li</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/quote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/audio\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/video\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/file\" translate=\"1\">\n			<xpath>//div/a</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/cover\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<!-- Since WP 5.0.0 core/cover-image is replaced with core/cover -->\n		<gutenberg-block type=\"core/cover-image\" translate=\"1\">\n			<xpath>//div/p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/subhead\" translate=\"1\">\n			<xpath>//p</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/verse\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/table\" translate=\"1\">\n			<xpath>//th</xpath>\n			<xpath>//td</xpath>\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/preformatted\" translate=\"1\">\n			<xpath>//pre</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/pullquote\" translate=\"1\">\n			<xpath>//blockquote/p</xpath>\n			<xpath>//blockquote/cite</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/column\" translate=\"0\" />\n		<gutenberg-block type=\"core/columns\" translate=\"0\" />\n		<gutenberg-block type=\"core/code\" translate=\"0\" />\n		<gutenberg-block type=\"core/more\" translate=\"0\" />\n		<gutenberg-block type=\"core/nextpage\" translate=\"0\" />\n		<gutenberg-block type=\"core/separator\" translate=\"0\" />\n		<gutenberg-block type=\"core/spacer\" translate=\"0\" />\n		<gutenberg-block type=\"core/shortcode\" translate=\"0\" />\n		<gutenberg-block type=\"core-embed/twitter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/youtube\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/facebook\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/instagram\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/vimeo\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/soundcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/spotify\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/flickr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/animoto\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/collegehumor\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/dailymotion\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/funnyordie\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/hulu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/imgur\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/issuu\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/kickstarter\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/meetup-com\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/mixcloud\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/photobucket\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/polldaddy\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reddit\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/reverbnation\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/screencast\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/scribd\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/slideshare\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/smugmug\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/speaker\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/ted\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/tumblr\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/videopress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core-embed/wordpress-tv\" translate=\"1\">\n			<xpath>//figure/figcaption</xpath>\n		</gutenberg-block>\n		<gutenberg-block type=\"core/html\" translate=\"1\">\n			<xpath>/*</xpath>\n		</gutenberg-block>\n	</gutenberg-blocks>\n</wpml-config>\n\";}}","no"),
("3108","icl_admin_messages","a:2:{s:8:\"messages\";a:0:{}s:16:\"instant_messages\";a:0:{}}","yes"),
("3109","wp_installer_settings","eJzs/dtyI0mWHgpfS2Z6hzBI6szUJkiC52RX1RiLmVnNnjywk8yq7l9bhg4CQTA6gQh0BJBMlvaYzdV+gH21ZbZlpmfRo8yT/OvovjzCAwCzq2t6ZkqamaoiAA8PP6zjt76Vnh6c/vf6dLB32quyeVnni7LKs7r36/R0Dz84OO3dz2dT/O9D+e9xukjxvwf0B/hhPu79uj7dP+Gv9hd3Wf++rMbzKqvr/mw5XeTTvJgs02l/Pl1O8gK/DeMU6Syjf9097f1w+eZ10k+u77LkB/jpJf40eWN+mly6n+Jc51U5Xo4WfTcGD0HzOO0tqyl98ei0d7dYzOvTnR2c2XZZTfDve/BteNFs+DF7qIeztEgn2SwrFkP53f6g/buddDQql8ViB39Y7+g86uV8XlaL4SKd0JoNTv97frprFm/lBPefRx50W1bLWb2zKOf5qA/j0ifwwH/4h/oUlniejj7CfOlp+/i0vYP9o6OjffjP42A/3M51zWMArznO6lGVzxd5yUu7C0/ATRiVs/k0W2SJPG47ucyq22y0SGB6SVo8JHZfE1yULfjzOEmndZnkxWi6hKHDL/1QluflbJZVoyyRddvGh8Ii5DN4hi7/UWz57+f9UVksYJd2lvNpmY7rnb3dwcHO7gl9pz8tJ+WgvzvYnhe0x4enPThHWdX7Ne4HDIorV8HP9Q8n7hDRUtIt2IMnZ8W4v6yzql8vb8zawNbuN7fUn9vFRue2vd4wgkx2XuWjTOc2OMaT5R8/XDzM6cPBYH+AX9jbi3xhuMg+L3r8ai9hKz7U+PqR0fLitqQPYOX/kKXV9CEJXxYecBJ7QPbnZf4pndIquskPdvG14LKP0kUGJ++GXsEf8oOTyHa6VR7dZaOP5XKx83dwhGZfHx4O9o/2B/IWsF/ZPZwoXP7d0//OF2A5n1TpODN/hPdjwcJX8JjvILzEEd/ziCAazWpaT/zWvsitelHBp/1FlRb1NOWVgOuFXzlW0eY/63u5gV/bl12hr82ycZ42BzoQyXNfliO5BsGc8DuH+B04DfCGn/LFA9y1Wd360pHMCO9DCjIQv9U/bn3tWCQgzajIiz+l9E167xMRX/TZ/dz9/bmsx81yPH5oLxst2S4f2HR0O+M/4CKCLuDB0um0n8/wbtNntHoDXZY0n47u4FOcCDyWvrEvBxEueJ2V7ccd8OPw/PGWHcqRlj3LRx8f+vCDj/zpkX0z2GXQEJ9AdpKUGZf3BYkOPTr/wI8OTgbsaTF6iF74PRGe4QU/kx9sesEHh89XXvHjweBk7RXHaXfN4q903eHlj473Bptc+f3jyJX/u3Q87i/K/iitFl+z0vrlnv9yz3+ue37SuOf4m734NR/Ervn5m6vN7/jxyit+dDx4vv6GHzVuuE7gn1ebb3q1d3+52r9c7X8mFX4DzkDX3d6L3e1v4QebX+69dZd7A/V93Ljcbgb/Im734fO/5HY/9nKvvJJ764/7fvfhPlh3tg9XH+2j4GR3HdF/+Ad40uFgFw5G00nH291+8eDIdiqCX9x3777TOssqH7VX+TgiIZrL3Hkl2+t8uMfLfJPW+SghefIpq2r4dCuZlOWYVjlYPHxg/Te2XJHjOsBla+vi9Vc1RZ33CDMKI3DwjN4GUiB+0vFW8Emv4JTTdJPFsipqE4exY20nF4sEBFlNsRreOCNKElzuqpzWcgum5X3tPy8miWyHbuHoLi0mmZyQvaOTXTgRX90dfHOwfbA92P1qB/71q7v9b15lKUwqq+EP+9/8h3//1XIK//fffTXNvzkbj7NxUtILJYsyqefZKL99SEbLelHOkttpOqnhXv4It/D+LisS2EzYX5wJzn+a4ktN4CLe54vRXVZtf7UDg8ITdugR+P/p+fnn2MPxz2Ma6Dav6kUComKRVckorbOkvKUPcBdr/Q99XG2XrNZnNoasM1zoGeyHm2VaJyC7aR3d3+Dzr8BcK4vJNxio+mpH/iP5p//7/3GfXFblbT7N/Id4sepyZqc0zT9myfd5tqApZ5FZzfK6xmef3+UFfEMWt/QTeAmT8yP6p81RdLbHu81gzXHAeVkvYH/yxZ0b6n4+nGSLYVrBNz7ZsXDmsrn4s4R0Bi0W7L7++kVZPFkk17LI/r0jk9CfwOlaDHHE4V1ZfjQPREG+SMZlVuOYcPSTYgnSOx/BLYTdntW4BVlVlVVk9LRIYNGWGR4+vGD0orcVTL6EPa7M8t/j50W5UK0xtjsLqzHNcX7husKc4WrywXavntfzafqAZ0UPWTb2P5Gbcp/SmnUcd9BPczibN3DpFw9dx969GizQ4i5dJOcvzq7P4G/0FindS7yQi4dpRtKABU+CIX58NzzjVnLgyW6s4X99OSWvoqz+W8IXXRQmnQJ9YxgLDsnUvOQiA7UN743SBu+LuWT0piphnnsBs+qCo1jHYwq3+P3Lq2tc9nIJ6ltEConHPopefN5tPllW/EZ0oMf57W2GKsTsNazRss7Gwbvy++GiVNmsBIsTH+decTQdsk82vElRUJlDgEtrv2fWdOiUkvl6DdcRVhBGJ63yPsO7U/J+6DjXVbm8mWY1XAWUNitu8nucLEx8ySJPB8jgBfyvzEl2i7D9p3rVtUwT0LMwhRmvIl8cOljzOZjvtB0FHC54z5F8inPjHRFpcMMXShckheEiTypgiE9GFeDR+jYrJuk0j3ybNgefTtKTzjJdZ3uSaQ4qqMsqB50K20nSakkCVBfjd0tw2RKUmvGl0MWljRql85RuZK4HL8VVr57UCSjcDA8Va1O6din/kS7mCK5qUcIxhg/BniJnXQRB/RdJgCVIYdoA+/ZwCsgH5Y1TUQ2CMsU/s5rRBdj5z+hATcrq4T/v/GdcINQ9/3ln5cFwEhWHfwlu3XQMS3D2KU+Tb5cgBuAVaXXwPNOao6zLC1g3MEceaF9gGPr1d0uwRW6yahJ5zms9D1diGuCpwh2t6YQ4yYTPAX3ZsY4f6nT1GlYwn4ocCjxFdIRhAUUh4mvwieEvwTrRw8fZbYqCX89sVLidbCDcklu4FlPWXmof3Vc5OTxVOsMzdQuuDFkZqde30ecdd1lrkbdGpSAS9Xya1mhEviTxDw+aLxdbMJd8dEc7d1OVH2FeMAFvkB5uH609GW5vdWTWwFbKXVHEhF7L2Bdg1NCDUXTcZGyzznO+VV6j0q8ik5DprrjhTgX73b021+eNi6VtYIuGpjBa27i46SdZ2xFYMigt8MxcXb2jhSmXC78AcNuucmMfyba7+0NKTU0fFPFXV68jWkvH+9Ofl1n10F/m/TFcttLojXE2R8O7GD0EqvtP9Q5bBevUAZnSoIvAZ+bDalTKlTo9p6ejOYEPhotymI/x3zaTJHQyWGjZTU5gF5Y13L2alU5DY/MoNIQIuwqDRRUeDlzGDKxDXHvcFtoQ2ndU7EUWM/o/gVpDHUVXDF/w8jeXL96dd6hbkRTGQmTvbQiiwq87GCSgI4vYSb1Pq8KJs3mVf+I3hhMCzt0srT7iEsGnpLzQyIAHV1UOG14Eo12hsoXtcUKpBMs4w4Wcp8OLtzT85bL4EwhCVNlFdg/vBpOaTms1QmIbHmoUNn7ITDGmSdsceZOO/f3GoYdnN3U5BVkw/ADn4hKjCzVc39PT4fA+/Zgt50+fmdMPI4Moor1c3FW8bV2mvVu/9AbvFK9Tcx1hFfgA4GYmJ2iwFOO0Gsf2/yYdfYRBxxR1csqXZ8O/rjKWPTCqjz66132f3U5BScCKXerxOz0FJ4ok7NNnMqfVloY7o2C/4bEmrZRWkyUKpJrNCfJU/FGvsk95uaynDxHBoB7jGoGDU2XHTgRWoPnUfh6DsQG3Ym7cJl4cb4fU+aTo58UjjJqIcsK1ls0VO2s8ti9RpJ+GKBn8S2RsDJDwQK9G3I+oWRturlVYZTmBe4PLk/x9Ll4dxyU0XNEIB8DjenCNepGFB609xfMEt3GC9llJ0hvHuM/HcCb4ChajzFs1+JcsHWusYjItbyikOc5u0obx85jQSdMCiiy46ExjFNgbHI9oXKefy6KcPVhBETgcUWuhMbezy4vuWan/MeE3b+r+JB+rFd4MRyR3KYfHajjaFAFCQeq+t5CpR62oo81c0tDW8TEMMt6G1XJqPURxAtDlhFmQTkfH/A6kEsZTNSaH0hWODQnV1nFIRwsMO2r4Ljb1w+jUdfIJ/L+u+TsNi+tMzo54ENaRwlngtdNnhwOuUZ6Np+tW/B79KvLZUeDlY9Y3PLPs8xylKTw5Ta5f/v767P3LM7sq+N8dwwcvt5yPOfRJeZdkvJyDjhHFxj4Ya2AXA0Ntki4W6eiOhG7XKwT+sQpaOKD1HfqBFQxBS5YVYxe4AIOoOdpfW2GGs/5pdGY45l9ZbfqX5fk1J/FozekVplOiHVsMaq3ftIPw8prLwToS9/ls/Anl+ThwJl4GMbVweJuH0rWYPfQFn+tfm58GN0rDvk2vc9XhB31cVoEF8DGfO9/aBFlFyDZjOnofYvHylRfC28Wz6dBFH8wD7/iwkkrEP/kQxUbjuziQJhrybDqGyzYqyVbQ98GohBcyEhhsPoBVdqp+wm+u4QfsgpnECYeaTfpm3TTFDTRqC4fggXNYWswboYPvFJUoLRewwq9vtBb6JG9dRAMT62NLLSn9k9lK8fdAqQn/8LEcvJp17IzxFsFk7lwIOvAUafvplvjBZC0Q5r/JVTn7lI7TJ3XyGqORHAynGAQsNRxNxCvIka1ZWnXdg/j9g4OdgaGVpR83CL6HI/o3cukkvJv+LsmLgt2QFyYCSsEs+xBvarYSNtcmRpv02Vg1v8xvk/RTmk/pY5iIM29JpIfBMO/gyIus2HlQjvMyLxbhwwrJIoIUolQe38V7MJnyGcyhcj+rwUjIfRhIH/Hy8wKDHRy1wNtPK3EjwUmxN9ACk5NECYT5VE8RODB9BHEn5Wi0rMD1GWWtvb6YwbH4JI+4Tx/onyMwGSgOPMmKrKIrf/MgKqIspvylixebnJtUjACS/jhlycv70NCH9yTVFuCSoW37f5DvFR8av35eVjAnEJVwDM+vrjgtZNUiHvUquwWL/Y5zX40jGhUl8fCqV83wvEom4PJjYn8Z5XOzXMC8gsDUmiyazzxGLeGDzYx4tE4kqMUCjOUoGcDurtxkt5iaB1Mpr0m4Xb+BLfoRDJ5Y+ghDS3i0vquy7GOgNSku75Iv9qcXxQjkAl6HWfo5ny1nmOC8gZPqA9F4JOgkBCPS5qU0OXyd8bKyCkcS8oeNOAMsK1opY4riJH9elguNnuE59X+CE3D1u9dkDWRiQpUgBMrcWJEoUzANA4u1nHfl0flUqxsTetDqu9Lpc4Z6eovxCGeokwfALl/RTNuGkbAUJDfnaiSOQVlWuMSxUIATzT9cDn+HcVO/53QaKJZKFganSPIsbg6RvMow05nCGB4rAHa/OMn4S2sVtsXvTyNv4+lMuaH4UzKaMu9+sdHEmQ+6Ufa1xFDB9JaY2JxosyYK/QrflDEYOFpE4azQNyuhASlecYRxwTvfoLFU3JbxmI7TEtaoDvA6mFHQPLJcaTopOHnnvOFZvpXkyZcl5q69tZePQ0v4rHhAEx6W6N1tECDmDHkMn2GSQ7cUc4eDKLntEXpHmZcBmCDA92vEyDk/F2bn+klD42gwgi2dUIBknxdyH+HrdEOzLT0aXv98h7Y7fD6bgtNUJxKi+lVSP8xuymnk1cATdqkup9LS8ZgCRnBcSL2TNCvZbBYgCqtyOnH415zCOrSoIGDSgqWDNZyDc/LbK9L+IFbALOQX9+FN0bAOLFRn6Jbugdy9qeBmr4+R4wWdVOC8wd7PJIZjjDdrhKyNh0XylDWlVqKYk9cGjKSZytxGoMKLGNWZ+5vpTJtuoZgGzBnuHyYTaEoP5bIi2wSB3HA021f/RSOgXAcR5RBXYXxsZxLWWfXJmXHi0cXNgL11r3TGBw5e64IzIpTNR5PgVkNEdL9cKm6UFqip4NkF5ozhrSh9UlYTmzL1sbQZypkSrg8NRHcGbtpyGktktVLBC1Y/JLclSS0BbhXICxeEjZ94BsARvKJxVvGT17CHy7TI07abFizjYMUyJo11HJX1LMPwAUsWOI9uZSXNl2NKjDbX3BdJacCyLdj4JIn+FTjz2TdX5+8vLq+HL15+++G7r3boTwqfYh9w6b3LxmxIoKOV95asvFpQUapQtjH4KnJAo1h4aSOBrMl06eCZsBOoYoqxKErRGMHLhjMyWkE074S+BRuXL6ZNQXFZlUn4+yjyIvh+naGAVE+Qjg9eQn/7LIYx9Vmf6IZ34j4jyM+0MODPrECDZQfDyRQKtuETTFmUuHy49VU2Ab9NVFkriaiJdIwFLGzw6n7epzFCPJSGP01OZA6eTP4ZlxVXgZbDfbahcDJosbhQjebv8HiKJOCUOxnJVrX4vAh/LRXfS5xRWtIHlBvR8e+z6QgPtbot1sB4DWegSFCRN5Lo4zwNw4kRS/Hsx6y6SfM/gTxoSYOGQcnYguSm/CzZgwyMgCndK17XwE9FiBRmLyjGXLvJfluV97XNJKqMC5GmHtu7yGfhhJwLDuqDnovZNPVI2M/gTAr+LXdezg34/t6/wtl1mXqdQA8vXI1tzdgvFrlueElMEoYB/VmebeTEx6x1v4UeS8MBmlEagsfMrA52D0SHlKELn0VuXTOG/QW3QG+/OAFwmPlAO+uOcmHGm9Fd5dBKO1QZyQBqjgpXUOHKSQZr7OIU7H+tOrhq488rsM1A8ObFOPscwlhH0yFjJ4azdN7plySgr0C4FPRwGOPUDeDB/xRc8UvElzXygm6jfrjsn7++wHjrDBcy+wxOq4ewOtPHyw78lni6kcB2DC/J2S+T13JqlrOo7gMNBnCojbKnFGWrw6wu4tnrh3qRtQwPfwZr1a6oUyuyYCRspeGsueS3igVFz2CikXcIUnZBTKQZRv1TeUPTjAO62Ji7wyjBTZbh24PIQMHFDmHw5Besw8YmVrEAXViT/aJ3i+4QAsOdFB/BRD/SOY9J8eBYK2YJthIMApCoE4oTLikPHAko1MsbNZhpx644XHOFkAsOKpCUXf9Ec5NAe9M9Img3533AyS8Y2MOgw1VXqylyGmYrZdqye7I3JoKFzVmSVOBTcmwp6qi1bGFRIC485yJPdAJjgtC+ZXID0/+IAHjcdiodSyrFL4WuFInm+d3cQOfKjMGIdAtcZBRRp6uiSgHQ8XFJN2fUdGXeVlUBYFGch9LBJO5wnXQ/jTZQ1AEeXXbsxyRWJCBfNrWHGyd2wFKWrqkxwRywCGMPcHj7gh+CkclxfJ/9GTzJGDKuAQw05TVrcLg2JYJBdF1WvwT36HwxFgM+5sSjWh4+cVLBxjz4hGRNa9SwFA1eelUMy5xhZ85aJIvACGmtnTfHYqpmKTXOsAJy3DAHJYxLaFlVqWcVWA+jVVeVX9jtERdHYWq5KmGh0pUKBITlHYp0igI6s9otHl/5m4ZZt/piXr1859bzDkx2/JU1LYrGAfYhyZbZzumC12hjLpJGfozAkxJiknqm4CA/Fqa2xlpjqRc6dR3OeRDzJceYXAFJNIoKof2l7GRyrLAweFkQDlGB0J21/eHy2/Qjep2XuJgaDqTThqKajALxTyU9JAArDr7bVIwHyqyrIbK+LwIbEMi/vEXvjIQNO2rOTl6zZhWde2/ONCaUvKG/Wu1fNkNwXwLc6HTCKaGrAymSvj0OP1IFrsnaLdJJ01bV0dySwNnCmFpg6G05cV9n09v+XYkQIRAw46xM2ICEdcYAPUYM+c9YhHITCPTNasCih9WVAk1zXfqwEqQR5+xcQPtwD/h3Awd1JLp+JBnLoMTgBgz3j2wVB7leuEnVAn3y+E1RxGM8rPL+HdZOjz5SQiyWCv13QbLZer9lYQC6XIPsggCN3N+CyplRlOdTvBxY/RiiZ3A1HoY1mK1Db6UPUwYhGJShxl8EqoKLYfM8IDQfQITDl/MfjY+eBrY/RkTgQV2lcUEuiVQQ57Qx3M3nP7l4QfLKOwoUC3cQ3ZbZTtjB6TLms+kqnPPG968wlQeP71+WYGY/+Fe/y1KSZCVmQhvWLmc1+7WYyRqsUwMSrw77hSXekyoQD6H3y8b3l8Bsz7UuzJx2yZYhWhLXy59lgh/RgeY6Mk7BgKDRC9stZ9zc3Blv6mNT74RFVLA0eX2XPP3w98+4RFS8PvaDu951JWyXROrlheRoqNwW01d8uINzjfXFaF5htQgKHls5ucqkMgYEWE7etQzkk3prReKQyna9VLJIvILULEXoB7u7u2qJ5VF4wf72YMO61T9xWlnT5adUdOo9jaqcW8S0A7bqF+BaVqER43HGGA08Cz5nW7nIsmYKkOfCKZoQgSnzu10Woy734md9BRfMWSznDYxFuP5rS+skBcDFYy1rSCSDRagfelXeLjxUmDD6wxhXjE/qeCX82uY+C4Y2464gayQGUm+yu/RTbiImsvAcVeTQyyXOM/7so66IfRzX5wJrdGackpQqH6mF14hZp5ngzUPScGiVu5EoREZ5bVDXY3ZkMtWU4pxJOkVodhqypiPdtBIGyeWE7LHZ6kGMNuFqk8vogUV6FCMAo41gl90PorJ7MxnFlwtZgsPtdFVH62PPWbLZKBQO9SL/lDsT58OF27aGflgFPo57CTDAK9AOt3QgF/e4aX8oU4F4rB7WqThE/CBpD2p7F7LTGo4RmHVgBFAuFV3IG9iI6X36UIv+VeNXHXvKYWk2UHEUq0uSjDipxSDqwnfDnqBdkWOZjZgWsaoOAQJ0Hg42VlQLtfOtvP8fPlYwVeNjr4L/Neu20Df8ZDIjIrG7wmDmDiXr0b5tZodXYMgmV4ts3s5Mxl/e/vh1CXudJT9ondPa3we/PluCX1kl31JyCUeIC7zVtS6NNHADWilSXHNopjrBxuym+c3n2dTmzQIYSDgdARy2qoQwClabklnMRR9uH6mQh/khmGHsN5TC7ToFWI+XYJi3Dl74bAVuHLilOGht8QeJ7zUM72ZOAHFnAb4L3QG0BMcm9MJETt2XqhW7dTQzqdJ4NWP2XUMp/AvnBKLVozK4qk7iZgFeMz6UGj1MvWJKC9HbktCVo85AU1RpEYbo07kN2PKGzXiMXOnhx4h7UgvamFnEZ7O9AgxtDqd30bTmAMteUtwYp67gj0ONFQ7zcSxS/WeEvAU/yLuV24tswUpGlrkWod11E8hRwDRzqlcIZkdHo1wu6Jy15NBBK6jWPqOx82PuppMi8JzxA9wTRIeH1XBt1LNTm/A6bUVp9Wj3GOyK6U/pQosJ8/vL1KiJHXTU1tcrtQVmAM3GQip51Y6zbH+KbwDrcY3JCA3obaJf6M09IBQhghpdabGpYE5t3ZhMrhSPvHh4ua6dRnX0kYSZAp33mSqs/A8FKbLE+4SL21X6RSILAfPIFGhBkhLRSdEYI0s//h6mcMIVW1l6CXOMrZsfOcJlNdKTh4H2RoCKXqJ2cEtrgsIH6OLXLWdoJFZX2/w2InlSIXCqYg/2ZJfqD1dKHKvo0A2niJGxL9hbZ+YtWDf0VrQ4CTdX1ISOQH+8eQgsrzjMENTV3hpXpRFxgn2o81iUXWWAr/zhEPnR9l4LDhYfy4KuycSmkHojS8YZubWjt+L4Pmb/WsbF03zVKB1a7eysSBYwBuef/vF/1EQLcYvVmpQG8ohz9lHKBaGOgkBgDFyGDxA+ltfss0igzNfGktuCi/ZP//j//SWA9X/6x//ZUY/XnQPMRUoIMgyvUNYwsh0ygDBmjoFQSmQ5HhR7EuXXJJhkTCHCN3hZ1fvhTnNxviBhS5Jz4URSFHnTaa/B9eYxG+gR7+MqUdhJl8J4ebHzscKO3wAj6HFyVIhEtSRycwS3qkLakTkQW5PzabvODGdcQG2VcCSmUqRCRUVC4fOI8cLJZ7M53NNvsxTRvi5Z1ap/kWwKvxeqUMmQzcrxcpqtf0zjAXzcUo6CyyDuXayvLjmdKnPZJ+ZoImuDzwxBKfpYAN4o77P4SWePzkA/uSSnB1HgTxtZttbwvn4xebUk861pC9jX5xxTqwaHFJNcGsGRkkoKx3gqpZ9YVofln7N0Xj+jggJPTWEQlkEGZ4cWp133OqpAMMdLjOmZf59l8yhmTNnmKKuLJr3aNo2VpmL2ICLD7HSY9KwkFUYmkZydrGmAdeev7ghsWmcEPgxZRn11k+hyZE9wtRO5gko4FNh1v3zgh3WyDyiFB5dUgRKf1DujcrqcFfUOhv93+BSveRs695Exg+sURggJTWAKYyORQjAedVk0g++luUKPut5dY3UwgJNkNCcM+oBlRYhPmNjqW66Z0qK834J5J/fETbpAaJXUA4kVTZAeUyZq42MU1BSzJ/ye7CMfgkV0JgkWL0mGXW41cQuIMETUDIpNLz9uLI+eU31wGcedEtTRIDzODg4kESbPcG50XSx4O1rZQhdGzlnXDgqMICDse+LP6Yo7L76Oo1Lzqoxm8MQhFQQLG9GYHcWpnXdZg26m3i+OxPNGwThWptqjMxkJP4aG8KAZM+ItxCLcjIuOG+maJy4ogcfliUiE+OC7G2SoGmmAhtgiIx4utoFyM4gsVIUdb/c8HhDD+Ncr79+fJh+KUbqc3C2Sl/zf50iAQ2nPWUYgahcZA3309BluyE0JBzxlxPEPrDtP4TwO06pKH+ArLFFrA0DbE3FP3whqijB2KrjTaAxVX2dVwqn7QIFAIPmyxGoh1O4VU45QVlRqh56wY3ANLwU2IsInLi+kxCk+lU6aRzsbYpURscbha4xJY3AplOd1w6RRlbaCw6QTe18HRdSpYDytH934bVEW/Qb+t1nJQ5KIA444KBNeY2Xy99+JhfFoTyr1ODutKfwzp0FD90kQZl1X3FWnpa4S0XiNN0suGqPSxAq/xdb1eoOC8DyjaYmBkrPzV4JsiauVTqAX/rBFYJIK5AAF+dxvteQrfDI0Zqs26+UpX8OwlZsHZ99xNl+lVEM+8UDvQFjP8h+zRtUGZYiGXOhZMNSUih15iOjrM5QxHf8J1AA5bOi+Je7huQEOefJbQVbO5xnj91UC1E3rKOB3UAmBT7C8DB3bYmgFiJOp0Mp8411G0ER2EGRo0Co9FcsUB8ZcsX018g4sljHYL/zGNaUceSHlJZo33CDkX6T13U2JQUj4+2VawFcxhcsgmejldDg6wnSoEhmy1CmrobgSPjUs3kvV5I9sL6JId11FV37u6k4F5EFZdB2XPOwriZF2j3/+7v2VTVIoy1lqeaIJ/qUYPiaUUjw8Zx7DsV+yuudAmSuKA/3dRwGGkoIsxzfvKLhAbAaV4Jbu4NhPMzltWpPBqT2xuFGCcJ7ZyhmuZO/h+NSUh6fVIzJqLDHU+znbwBOWxhp4gcPK0kCwd9CCdA9rS/KVD520jTbycNavr+Sx5lYUufdpOUWKFRV9Rdzx+oIwiviKrDPFN3AhPHmOvTvuwnSJaLQECwwJkpobuckiacx9xskx+gO6Sgie42PWhopJPZuPsDMlKwbVW3fT5vvGlN5RZnB6kw4Ht52aaFZwXnN87zYRSF4dS9LyQl96+d6pi60OaDjVcGrGM+TJjxze9xmrHkfCy8Q7YDGWjQTtekdAiKUcdaQidQuPaY85KYFJtgZ9E/hn5DaQAJMqWbAlRFlQx5ZxE0oqaWkSa984wfZNcgHfgX94ve2YEeSAMWeGZb8KqHtWItdSiZVPvRPuwgQF1dOgYER0V36z5L4LCml2gj5yb9V4sH5FYKHQO8hgVq9IQzybHDKpwSv+8LotlTbkPWvYOFotLnonWoB0jnLXcRwebx9ExVQ3PsnBzTSP0QQzR8bDJ9lMti7n0z9+4Oob9G+wGfiQC/bYXypv/kT+UF4bZ/KPzwKten2fS0K8AmcFx+p+K/nEPT2Clw0iX0TiveIw6CqbtbRj/nCevCMtecXKno2VULRj86Lj057krnvcOIpbGMl/IBI1G0vX8sPtY+ndhFJSu9Lt7e4N+rv7/cFhsnuCvdN398Iu5weRNuw7f6cq7euj3ZOTX8kUvvYPH8AAt1WW9cHbuZ9T53bpGrcHH0iapB/9Bv5Ukfx97GpvOuCdnPZuwFBwTarWNp+iVo5g+cuCYC+80rXzdpQGuEbcrg47zSHrwZCsK2kLSM9VTnNt6ma+RUhubZp1cf56eHVx/fISxN3V8PuX768u3r11zQHxJg+DbljaZa/xZO2vpa3/wk91AeRTbEYZ8jMMLZ2Hf8j+wLcMGzZ+IQR/+jTu3wjCoyxQ5dGhsL+WFpp5Oh2CG21/LZM65j5bRTbV3oVi+uhDDmifq3QoXzMtB/EMgKhDfrB+gcRcvGW7x9in65fGXL805gpm/ktjLp7aL425CDX66MZc1PtzZRfiSINEbEndNsGa3RFXDRptjbi/L60R22MrdFz7G1pcCOY9qlusTFLPmQtepg98vCRTa2hYpJLxTvxbBoZsz0qGAGzj3m80DV9EgjGpwLKVOmTC/3AHR+xPClKxRsIsM3vkI+l7+lABDCleHJ3QfGw6FGnBGwz6CjY++5wi9HpLyoknRDpLuJOX79gTiLV9BGVy9JzbPu5vDzbqWxSCFu1lxMIhUCpD3srOjgDHEZHg2DBiK+2zvfyh8ziI8hl+TWVTmGBbxMp28MXWRM7DuJ/jgrSuO7nEGBAR/ITE1B7vX2nhITUGar8tbhVad1obodiAyKJR4EjiepRZDwIHfwmjakS/GaCckcHdTSLar7ZRPyCVmxyXR1QCoSzsOVvVkI9zGXnNkBBwaOBfovQrqaGuYI5DuhctG4gjyw3V+oQZvKMnLd5EohEPkAp+X782LkdLXzXR4mnSCugva3HknueCJiaz6JJsusJkYiDbNtbmRTt8NC++Dz4OhWbI4AEJxBh5mdA9bp5e5mJwkRn6/I6gomJncOEoHsU8RiMRdFW4ZOT58OXnUTZvvEoEcNNFfKw7vEH9gaRzHbU/HtNICQe1Z6I2CUE6J/I+Qt5AeYxSAHt6v0YcSwhOUIdx+dsrL2nPyIxmLcOxF+5SgrTVcIJG6ZyEFT2F+yp0GEYbdJnxKQgKoEgpQFxUryVwvkIA7ROsdqyFvOQJM/PkTkPYo/ThAuVes92DLY+UOjvagyqveaSw5IkPio/TKCsCdzT8iyzGn4SZNFjB/WYC/jeUYRCnLCjRIBY6abDmasJZkoCQ4zvm2Ei0xSXZUuDnkHdRZHWrjjuYzV4cDoCSb2m68Sncw9Rbeins14NsLFunEn3mKtrKsJqYszbERmTrHs49o5tVBbz67l50dILVH1sbpspLqjFbPQgpIp+AaNQsRKyFdmNVDTbD2oyC5qriYkUGcWZzTE8yYtBhv5j0LwT1ittGW6Nl5SKl7GO+TeuPEWQ47tdjWCeNIaKHhRwp8IA0aE/MHijdrmTavEyJK1QkK6ES/4FIwW7ZospyBKQwjcZcuGOI1yu6xstiycSn44wXN3hq8BNnXI7K+UNFT5Fd5d9ckxy2y8WMVfFBXLuu1UO0tIAuQOczmUrU9+/FqE2/zgpkL/oU42loMEOEiN+nVfZMHRo1oiQDWgui7oFr8MXIRM0UryPakJjRVdu1j7kBdHddJO9ZBOedWfFjESnj5gUk96xVkQxF8lkuC3qlvsVlc298KwCSOlkxQcT2rda5ukSg5SyclUNazCF/qWkHO0Cfi2wpIYlnw6NiFXkGBblW2WoUr9EcdmCvBU1bfbdKSkE32D6IUEO8nEdozshuN9jntGlhxNlhWB5325TMM1MQ0X8k5HCBOt+RP+z8Z5MQ/8878UtI6rhpuIa4HHzgfkUG+0Jy8fJg3ocvsaiMm0qXNXrYhXgRY2YcbxDDiBviFVLy9TlmOgeGeWRks9SUa6CCbqLSt0QayPpGzKsReb/rimbXKejHMFeED4hTmv/VGRno2b7MKdmAxuAvqkNfn+lu1X41hFaqR8M1p3IVwD6c7tqbx1+4BWf9eUqg6dlqOqwqgVaQ8yxLMcF5u5yyw0A8NWWJHYAcoK/Rq2ORT6ci1eBijKioPFIbuGmJq/f4ZTTZBa7GblNWBe96Erfrkwn4gBm8lHQZahVh//blC9G5qGtdhDH6jI0gplw13FD2WAZWOOUgUBZRLEx8j0aFIqIiq7gevdnGjMDYPfLxWVANjaCiRoIaKHLYNPZEe8bZ9VvSYKG1z1YUqi+na3uajhPF3Rtpx5w7wDoeODQalw2/5ZFlXry3pqqAVrvGDgVN77dRyoY3UMu8MUqmLIBFcgybHzsQG8SzvGyRsyWAI2/xvcoNo6CsHIVzCin1cjKH/UgMk4/oyDBgk3lbybSqI8a1q7XgZrYaJsGKMJgGMui1oyPaB9OeKYr3jrNYX4lH+fRxoMYrA2cfzsCLGQ3ZshxO5qOnz1ogjS/EZKwB2JiiNS35UVQZns53l+fayWzZFHV6JOIBsBWIeEK1NE8mQ7YihyI0t0MJ4KLjlnSYgELDiD0sjl+Txvchi4Kxm7k31/rcEE5T0RpbsYjz9nEJpVOlHA3Bs2dl0UCKBot4sJHL69qoqYpM29XQEWSg+vrXyYeLpvHK2UO+L5yat3kE9cQM6dB0zIHmqunChe4gc/mo9U31oe9I3BuhIN3eXKLTt5OXFIMvsKkwyp4ifABJiPAqawvnNVCvNWLKF12SFUfIOuZQwON/Kf7Ra85lhYRxmvO7T11frFVOYXiEmnSlf8Tz6v74R/+QUBRq6phCyM18k54lG/AL70ubTFuVkttg8Xnp69K94Gm2PdlOerfV/vDV+96zDYoHo9pQk/cskdqVqz6lx5YJJw+ySpeIXNPAJw3e2pvZG6fmC2ImQ8Vczv2qVBzo64nbmg1bkGopwGQGaWGtqjK4tWB+YBOa3laCulirBOHgM/LO+cURk8dZsBt2HW+1BPM5VR8k9vr8EIbeDYvbnJkN0rJG24jytDbHE1eremEo0z9a+KbQpwTMQyIGGXl7e7vXAvWZHvB/qRmjQ37Vaa7sGt9rFR2eugRNGcTUquyd9K0w6xlR5mIgdU87omh9aGvOcLD5qfj/hM/blzNwtdd2lK6ja4oe1zWiYrjlnFmupbxGii9N4NMFkDuiLpt5qrpfUnlvjDPuvqfI2K1I0GCLC93idScakyJ5IUFrLaISPki5RRhcwQWMr1e0RrssqeuLQN5IEOWFidTN0yKbCvLbo+OEuJbc42laIRYOV1aNojXsKvdct+zUqu+qKZxCE+79RItikC+U/PZqwopG30NGnJXpw7pZhLb4pYZdRQz3vM7T9Z8andfj2HHyVgqnNZZEaXWd2E2GElqC7qnPa7DU3LKkoFjaGZgmSgEZvsVa8rp55wviX7bvFulopB1KjN72bP6uT+/tdIndbuEqzPWJpmyhQ2g0yp56Z3DScBXN21FQVbMgqssdH0jJ/CRO+WKYjuN51hGJb20QeGyU0ClYRLrItHsWe67p1F0j2Moiu3fHFV4tEu7j6iQXESfXjGySe4qaUobEeXhmx10LVRQ6XuC9UBEERhcMc5dN58yKlE8KguoWiNaqqMqj4ZvViw5eI5+JeOMCkrZTOCJO5T0jL4iq2Qf8eXOdhcsXgCkbXFkE89ogvsrkJa3lg5yUNAtlxSC3gR8Rf4XvVLFgpBiDgS5NYktxrFDASELNhASW3LSRNmwAKsM7OdIAVKAbVp09t5YOSeLTOV2plVrNZtN125suZsdQ1DfP7VVwLPIg9I4/avT/4ti09hLWuvUtIeyh3i82GaPhf9chRdVCTEGujq8yuJZbqQrR4frsLfVHa2VfnT2ztz1wAblOoCmpOdN1qXFeONTBp3qUVUSXYx3GOnlaLxEEUBOlyzsSWM+MVUwZDnK578OMCjsJNqXyLP4G8QhSzMYwxbb2yMMMSG/5dINhmOeui7Em7c7RbdTxMkCYV4pjh/CAMHIoDcyG1MBMYobqBLhW2KjxPhGA2RxCnyrz0AqJfEmdf3LGKkpuhfZushFZfYmXn1nrFiU4JVq1bzqxiQvlDGZS6bghotEDXV+vU/arq2oOT3uEEP3Sopq9g9P9k0ZRzeGaoprne66oxj37Z6qpWQ1Z/okKarSspaOQRj/uKpkZIBgb3jrjsif42hmjkQlXbENErAa4ja0QL95kGKqqNRZaCN3dNsHAfynDWVeGs7e7L1U4/zqA0oz+P5alNse9P3OeWrQCAK9d3LFrVgGsGzxeCbALQ/zguksziTgGX0ZZzvZIXqFFgvxyEtq2FXB05rf4t/dl9TGhtqzSsDKXv91klIvHMOBqH1XMVc54o52AdFQF97fD0QJEBIxMQ2IXYSS2wWBRgWpiyp1HUfH7Owqqe4tIY7iPIZutnDBaIMQTFcuEzoUCAWESTPxl8TvMdBhF+h89Pz5ipP9ardwCnobJSjpFfF0XroKMQ3fW/IRvuKBOq11PUGEeieS2CsljQNBFOUeQKuYhNUGHS3OXpZ8ePJ6ZyCkW82E6z4evy8nE1oOVMQKpLhjGGiMM8aITUsQSSTCVbcFGq17WGdoz91vY/XiNWGhUrcrBxGZI6TDha2tFqub56ONyLtRVt40sOIaoiOhZm0xysfoSBikw99vsTxdbmmVh7DlpUeQapYdmpUPFbdaZK3CKA7oDVOdHB30VfS4ipuYb2Ao1FZ8RtG1df8XUdSLNHPiXYtthjd1F4S6q30V4+3wa9K5rNuPiftEZOjnx7d4sW9SI1EUoK6J0L5fllOJURLxPdms5IrrFcbtZylHHXVmTdQmIv1xp5mMIwGyYeggykgvci+V0uqquRJvXiJ9CZraQc6Psrj7iemG4CBMuFEV10LU44lP9XqPOWTcMwS43VQ9SJx2Zkm1D8xdXdIwpNKwRRtP0qhF0vPrda47IdNTVKqSXgdC4WLgQhNMxp8facetrOkI6e2UtEt6e0FNPY7ogKEIq8Dx7geJrlIVriN6UVGeEGm+lQglOq5KnNEVzRszIyTXGgm17SXdCnXzFXnvteM2Xl0509swDNQJCQxKZa0SmCYVih8oSNgApZ9CjV6vJlDx0i9xQKG2MsVP6oDAz6jscsNDxRCLE1Udu0FZCUQZF5hGbVTYNFQ6HXjRCbfomFMETtXERNSwgbSasmm06w0gh0RWdM4z0mkuueMFG1+nfLbPlX4hs7e6UKPcHdY+7PrZV532qVSkdXMEhz2h8Z/ceaV34cJE5+o6PzYFOba5jnI9dxOyROv9RD1/zzPVnviEpfQuRoHZm5fVRwKPUylhenrAaxfS20xcAo4FOM5dg6bRtG4Cwvt+jfpun2xfmx6vMW/XwudCrdTUg3kT5oOIhpeIamrL15RRzqVxnGP7tkpNrEvzRUgTsS520amAi9Eor5WZAcfXlZVtdON7OOi66hnFowGYX0epqUujCEYzsxnNssErobI9+BN2l0UqqFqBPDT99oHY5xRHriunm/piSHm5zSXA8XcIRHx/woqV3sOtKRolm8YtbTopv5RkxfsMCJPN8pV/nKTDtSVBLtE6xGpydOMfS3URxYxuq1g3sabVE2xXDKu+vZC2m1LL+Vij2akZadtxkD69/84BXFkyLCn3V5Mn/9X894dd48u79k+DXWIcJP7jjQg9TZgY/a/scvCUYnAVNFLlQYI+AqJumN9k0unmBUjW/a29wYGI6JJmIw9C3Nf2n+JWczWqAXGg0aFn6vYtEURAIt4KFGmXFPrx/TbEmarhMtcT01cBo++Lm09gJuIWxCjwRF642PC2OetNGY77IwR7D+hGphORB5LShHcknzVBaepliyC0bA4SFaa7b4bJu+ld1epsNtXfto0gEjO7j7L82XnTk/1xxGcDu1Lvn0uLVsQ3BvtFxg0njWgiZAK7tVEOBGP+jhDli3ATQyeygbItrm8PA16JurjKLNS9rt5CyTIj74YANhe2IE+F2rSxzEZ4VdvC1MSfKePnrdctabXYXil7wWGiiuyA1JQppz62NrLkE+rA4PM6vKgJvMiE77YtqrpR+qJMgUzlTrbnJbZDVHSEcxKdGi3pZ+SY6SkR46GNr8WZK50xOHdV59V1w2GI8WyG+Gh0fn2P/Ms8EJczcKbpFOllj+n7KsdohdNuMpfDcVQ/9VWrB6AFxQvy/ei0YPvt5lxUUpr+9+FP8WFPKWyPyvxpR/9/Wyfrz65edx4vkIUvodq86abekEBZjWTfo5CTZ5FX3BqrlUcjDMK7EGQllsTVxZGQcA4N0GoapnBnwwADDmho8hdkHEdoa4c3t+M0b68XUqhUzZKVSE9DKgDTDwM3hfpoCwUa3O15IcdYcAf8oU1zcSrHcUcCP5zxOHBWFMdvGnsJ+a0pWyLrnOH6tKxXUrAiEcvSxwY0WTEer2A7stYvUBRKez8XukbPy+v3F2++G1+/P3l69Pru+ePd2+OIPb8/eXJwPz9+9vX75+2tTY00b2A4Ym7LA7pLEWJhHhmoZefY6K9QugnfxeZAQGanw72bZRjiVGUUfRpny6TtuDBN7o+5qi35AOhGs+7pe5HQQlCq9R+xNFCfuKe66aVSqNmedl9cOu/gl5YON+yMWGL5vj6VTL+630MLTIaQSajD0e0SggExHKf3MuArxuqVAgilswW40fOv3ry9evfIoXYqKCPv+JqOyyUmSuKX9gz6e3QnM5G458QgRg8JidAHD2lwo2dKkEa5MKF0aEa7u5zmqy6VSlttT/xhP5S/o/GMunY+6OWyVBlUptmVkes1N4qKX4HCTS9DEpwUHjyvjbBdGsEvKqnFIFJxqa7jT2nkVUxv726LK7gCfwIXNVKE1L+fLIPsafVywnwqFlt5xTeKsJvNiEIfecryLnxDOp/4wAbcwTE28sY+/3y7Vja6f3OzMEZMKgQYzo7LonrsC9FYUZ23PzFQN8JDgX5rSFU0h7lAdKVWOLTIXsRIsCuFFqJUnYtPT3NK7MOilT2aEdH1A9EW+MEsHN2ldmRZxO63y/1DEqmzi4vflyDVn+DPGX9QGRpIo4Wnxv7Csdc26Sp/U5ComLOKRbHCvlQZGZyJ5QtBMhEMMf//m9fvL8+ErFBeI4HhCDt0t9iTrdQhGZzPFgoQGu0CCTaSovFtefEqn+Vhw60GjoeZbsbmJSEJxCTVpauWtpUEzFVyytwsGhW6PkJ40I8oMmHOOKJXMdRkiPxYc2Lrtvq5vt+BaiwkgWA4nHUim2cPqiILAB80mp7EXv8snd8l7uPBaTME5cazE/z9pz67fDNGUshDw01MrG3pRsekhDhuV8zUo5IVdwhHIB6XP2sF3zlAtEA8iW5FQ8DtuiqVlkF15HysRTG7bVIjmCypfJvgZCHfN2BA5VbR/ig0/Bkuxv1Hs/BKviUPCf8weXLwaXD5OXDxhDtNFtRx1mco+1bcC7qShh1E5xaPL7qgW8wr1XnekPfTGN2qY0Qctm0+KrCEbybUKcAV8jNUx2DSoCdpL8fKml8Qq2ciRw3vpDUvsdHWGqI2F1qLD/Yy+8KYViUGJDhmZrbBej+N6XU4aUsexGZ2qtBUksEZhg/LcDRZN2rBLmPsOpQjrdZM+U0Q1HcPtR1curZsBbXDjvrVw8gXTXd35LkN6OqlsXX0GGawUuwWj9NyDhw1QtTnbKqPlM71xr7Ni7k8EZk8aosa/YO1cWUnhF+8yfoOzrfEazVjDeyW46K1aODXPe67Q/VeTxa89ARn9118QlfnnrbOMZDwpKtoQzOXKgEaf1sAD4aQFDZa2YiUBI3Rxm0Ct90VvUum4xJfd0ceGZON8LLmFel4WjyjUbMBiBCRAIBjD3MKKh6AUGKenQjFaOALLgPTv8OvbPYt9voK9ateyuw0ZIDbxIuH+tu2o2STNCzVgC3FAYduSV3iNUFpi5S98Vmcqp6dTkxsCE9xD8Jy0y8Co27i+12AmUokMmuC45GKQv9GVbJ5Twzj9AswdO9QF1omKjtVnJzw1Us7IM3NNBt3mObCVLJGrb1btoz63bsFdyv69JIgsOu5xl+IR74sTpMgajcQ9OmntSLji5oPPVilxI4l77OebzxxJxXdvrsPpra3nXVtoHq6lsuHg83/nsXmgX9BdJUJb0QOrcfw+07WioJQcgDotwEP9MQCM2LEvq/LzA7ljy0IdCrTUH19BqA1PTfHiCNQt+zF8XQufxrbw65jGagoD2xWOUB0KghHsQ21KzFcYGDeBYRfV7zYDxjlRi7TtvTW8zb3YHUOXz92pcDgUKcRm6KCCQeZWDjlTSLXPIRtkJwGNmgRjvOnlvGkWtdzjWjeeQpJdUwa1veWFrGm+g85hWigJtjZN9Q8JnaxgLRWYEijUgLHOc5ezbGGaE7V4WPAQUo2bmxQLtjxWnJhgrY6jcf3V9gDJnt9evXvryo4ohsaxFM8KoxTjQnqsrYM7/KNmVsRmESZIY/R50ezLGZ+eifqGlCrGEYjgVR2BszaOrdAjCLvHNng7bm1L9SDme5e18nsaaGyRMKpmyLHJyDiHVWyn6hoPHHMPkoZpIfGvktBWMPm0i+U8DX1dod1HUxXBG6M7cHpGtrlvfBa6yBoMs82v0UGFf6AmQjzezNlqbC7b6IkN/63ncyFnkcp9ZlgjMKQ3GOa1Kx5gVeYLeWlvbN7ljjqtzJdkW3E8Q/rt2ICGthQ4PeWxhqArg2cMG5HDxhrpvSYVJ4K3bl5ojqm2oCl8nVGD3acSPG1j56OSGcF0Wl7NMoQSDXHhG5MGR11k7phiIpANghlzwYCd8yn6PePhCEfYrvXyQ68JDIRqUlEgxQMHxzh/oWxhPVw66ltVI9PjXHPXdJLtneDqvarp3LG2usvoulLai+PgKMXP+ezmcKqpGAjb63jyCozAbRC2DkgDFLHbUI2kOFUVv7H2JldrITiBkJGdjoUI/syBnlzbEQ1CNyPUXafHt4zS7Pa93paL87QQtjTk8Z5I3pG9PsnvUmWEh+NRMMUVvXt2pJjj3ZjRpWUA5dmRXYdQ0XlfXc1J63e2mFH1p7N8bKbHOTqRFbItJ6LjWwXYYYDCGUEEuscZWtrkQ7sJwfU49Antdkq5gxuezXRDl4+qpEJ02Eqra23ajpx6qnWcNdKEprYxOrasdNi/D2kvw/YOwp4TmwntOWKPTZLSeI5gXPXUZvuiZwWL3ll0124inJpKIJTpVYZEczndCrZSWbWtCtiYKBG4WGEylclBF4QRaiTixlahlAXx+Egjs9iF8v73lvdPSYZan6IpKDV1omggbu2Ivt+X5+kM8duiVKVMUk9zI2YCnH6iCWOcv0ZYI7V+UI5BBuY1V2eTRyqSOnp2ox7/XzoNlhAchPQQcVKXMB+4ohlLbZJXCMznM1bbi9aVk9K05EiCn6vjk0H8h5XELZzzu2z8uPBH/G1Xg01NT2nKYOAUXJEthyCQ9tN95hDQ4dF8ylgEVFHKcIEBPEoRugbr42yaf6KUmvnpGmJL3Bjq1o3RPUYfOsRCAFLxWTSPMlb4TFd+UlC5t9P03h+B3sgEa3pJPc+LAhGso7XRqPH67RDt1zFAhbkNg5sXdUil3g76QdxmtNzoG1+82ACV4iPAYguopGLjxDHz4noRkg9lHzlYJAn8Xt6odZHZ0GpkAkbhMcoNn8bEpnUyISiZUGQOdnd31x8Bt+fltAuhAm98y5IgnnEOiNFIGaCIXQR1vav1bVydysJpBBQW+QLJpArwq15+nk/BsKiSwSC+S3BY0ZKSTKqrFPrw/vU6sbGGKOjotMcEE38BU9Cj228/P3BMQf7hPxNV0Hpek79FuqDB7mGTLwjb+FpTDv7kS12UcM7TB4ZpWZtw978SM+0XVqHNWIUO9vc2YBX6hZPlb4qThamT9uQ8USeP9X2T4ei8oZ4f1/abIWHSiiGjXEkDPL2UhwqbE/uSM8/k8R18hmUM2IvJeURucbaTP0gVm/iMGnWascOMeTwlRyZ4YjryxaFR+qGjk/1dZR86Wt/jkfcSTWxfb+2tkjsyVrmsJgy0fcFpCcjRHdoT0Yl4lGbiNkYToB2Jks4yJuNdHnWwJ7RnqE1WmnnidDnOSxLLWPFaSgsZrVuIPnI1Y3oUrR8Yc4y75244CpOLNZrARQQBsaS+MMKo2jzs0QkOHj3B4LbzEgQoV/Vw0a5p1sAGj96sXvkNkuzWMwQHcJid5S0eDCoAvXBgizY/25cx5xC+TVBs9qh6Zwj9EHSoKAnKf/KwXU2V8d9HqRBNu1IhlpLahuXiRcLxlcYiPbpKjGON+FDeE3qMSA9aPmeDH+4mn+n/zj9H9uVwU56yL6wOO9ygmckZbTSMR/vq2qxImM0QDOuflB8f8SOaV2wRKe1HZ+MF4xo1+zfAi6tzXiXI2kFp00kp5oouiuQ2VXrTVEAS1C6zK9i0WVbIlK9ZVn/smiVCntboDnNBvEbgMRZpPq3djd5EhB06GdsdqW0kyrKiXlaZO1cYPGCQoY+au+bFDdJsockmEzMhxlplDsQWD9odtatc53Bl64luf3Q51z2UC91Qi8z78f13DfB08OR4SWb7yYSywjwYxkAQbSKxe7HWWlvSlbs6aGeuOJF08+C4r1JjCfGRoN7jnAxwtVHRwVcTdXTiWwi5PF76xtj8PkLm3kYA1uX0k4ygrcwbVxsvNIN+mX+C8DBm6FaJd/AanTowxJOjEctb81U2+2Z7Vn61A/+Uvm/wYh8+VqhxUhN4BxtghEFN0ZoYyV/U2ooG+fNggOVHGqcDDhE21kTm8dbe+3CPI7e2pAQgV/DHmLRrNj5q0omgebVYgFHbZUvt24rHpr2QBFBmFmeKFv3t2e9l5j5XJp5cRONuZCE0wsqpSrTaFLyKVPAOj6usQ9/fdW5gCjMq7wWD04angnePo0Lix90ihhnMZSjL2phx3sT23kqbFbY9sWwIZFpn4pNvL5h8dTMHasrt2r3kgndcyVreKRvZNefnM5Q1ICFrRPswWichTXNHF80jLQAEsvFwYGYCj4f1CAhjxBVmw6Z5bbwVHkMswXCQFyUtEhx9NAc92s5MCDYBT8YtoQPJ0HeV0kQIv5V8V6Wf8Iq+AulfN0LsHrIXFFhZI1WN9dLykCLEANcmulNiwYl/Lrsl/2VO5b8LZGgoTrw4VZYhnH0+JrgIvQgC/UhM+I1qbYDTTrQJeRHxR1CNtfJ3me9CGv3RnPuwhb6nOuYM3oxVG5kMC/OdeHMc2QoVVKIVZYqSlWPSu8Jgf2syihaN7sRallJf66BkfZ/FezLiNsZQJhmIeE/GVUJIqp96fvwhJml6tJc96hCaYjhz6PI3PUdSIhRvlSdTQ8QULFb05TdmQ0xhCScNq5KunRZtuKpKZIu1VolULY3lDutZdVtp1VimhO6dB8PLKyujGaKvhyGws7gZU5DNQRzzHaPlSHdgws4pfSFfkzddfUI97IkYNGnqehDMOtWjKpN2oCbtZ12DDiJcabCrrRI810CER51QAmH6bt21agoqNSD9PYuemVU8i1auYyDMYhWfKFXusuBONGPb3G02HeLBpo0ail/x9NmTRp8ueBGEovAmxSa3qXfQnBwdLO7Ke4mMu6OH4Tnboz1fuBmfjCsEL5MDbubWkLAHu/tJ7y0McrZc3MHS/piNe1w3agAmzhrmrcAzOuJn0PMP3LjB625k/DpztFHFxGheZk3zMCkutZGj64OrwVshi5qKWfU520E1+QKJy0atXZiU0wbNlKBx6r7mJD+KMragHBaMZK89vl5QhkM63jklSWEzmd+Nahwz8tZnUlzt4OT9tO778cNBz4XZA6MnHrzVyidF1O37zFUIGvFw82D4obJ7Hq0tV910dHXmpkkSDsIxy4Y72KyAH68ihBJ3q23mmsI6dACXk7uVzE//svaT14THuBJm5uZ5NaCD9s6M7sqyVnCAmMPcQqG+Y41YjJum0GMBSKh9sf13q85fKUxn+TStGP8/kSuMYSEMsCyywiflp4g15S6tkQBbyRjsB2mTR1KtuQXq0Ec6m/OILnOj+ZpPeXYfMfxdDb23ZJ9ccIT+rJoQvOmlfvJEoXF0UVwNmxystF7hsLTsBzkuC1CiIGYFy8FHEjGODt7v8ihMTRxRhntrDKjQy/urve9qbMMhYhuOtg++GNqwfzo4elQTpOODYwttkGf/TMiGlQnIv0VQw/F+E9MgAqUpyqUuWEor4jnQXzALm3VCOjjaALPwrzKVy5l/WLD7spSFz/q2/VA0978PW2CzLV/V87T45o352Vc79KcmHmDlgzq6J+1h1n3+DeUNfvUfT/YGR7/GA0v/evxrBQrM0o8ZsUPaHpfVsqD8yEPYUSnr6wyEJJqV1Fdpcldlt197YVZWY2TYqUmiSd+5HfMCO71vzDJ8tZMKjagdyAjFHlZofd0rSuaSgR+D3Ye/2tYWrgff/D2o2yjjWxh8Qucpku/CXog5BgO2QKtXOTqAWwnJOKyEVqH5TE8A/N+XaR1QNSYe9xV0RtyyxFKEqXQa04z291k2rz2+0jeJFTuRajdR0OCJlqCx+fkV9bYiThq2paRXFj2Pu1XxKc+9sWt+LnIzLz5RrPGB+07RfZVLdAPWOv3BrRcVyDuJaRem4MbTGkJMlRneLjsx4UrmXklTqO9MMcqzumnWHYS5Z82o+uFewgYVNStx3vo5vNSsZBo5eKH2s8HurBltmrkfbwffs9eSqJnoQmj0cCrTZwKtyoyyJWU98MtTOZ/uILoTvvN36KAM8/HXg8Hg6PnR8/YZN1P5tixx9Ws882ap46Md7+7urhztmmKb76mE6S6fI6XrRgMfPR8crxz4annjZNBmcz16frC/cshLyUefkY2x4aAnBwfrFkDLmu2Actzm37zm5WZeJ6xbMrvr3a+FsDUU49ahQPn0d+AGZVJ0LajJyHSPjo53n++1ZsvlxrfBeYzNIfbghmD8QJjrC6ECCu/IKwxVLLI5Or70z9x8jZgIxQnC4F+ju95dOd8CJYIWQTIpKZPXIb53AsL6Ham2RebiPyHX506XZttZuYnB9XxDkCNSJJIGnosUYB+EW8XCl7eEj0wKJlDqKsVuNvtGes7nP4K658xmEDLg36D0mHNLZdckASyPdGGdIVgehK8HNK+gSDxbDb1oX2TeAzdgo7oHOm/K4OJf5BpMG3og/J1rmXEU0etyS2rV7ST3iwejeraQr7mpgPgcobm8rM2aac9FqnojyMHWuh2Gm7Kc1TuLcp6P+vCkUNlvvI0mpLKcNc7xC7FzzfEl00Y8pOZtCcZFuHLdVhvEAbPPAUB5dwQ/EsaRyAZoAR5tlcBal5OM9tEFDCKxZqX/64iQSNPfLZOLUOIXOq5dWzFfVmC+15FlD5bk/M2VXBdKr5iFfpMX+Ww5841MtFsyzVim5Tehc9HJXpEzRoAbRwRoW6T4nh5knXj/xpeKZi01ynG/xutIKSndgcGvbaxXfxHZBPuLPczsh7/o2Bv/i6OW8vhBTCbJjVC0nnhwxCDaWnFMuVsAVbyk3hSXvYlha/cOng8EXHuwPRhoQnQ1VtLUjbB6opIaY39RUJTBE5qHMVPmD3zZUdgox8V1aD4bon2lkoY0PdHmU/EVU5c1Wh3hx6A44/0H6EMl5A+/VZlIQCxhFOQxBJ+DB59mIgwGqBF/yIsxGstEH1rFcmzhYoecdfqSVNjZbusWxhKRfxwfH818rmFKvHQkqMQKcos1qcg5BJtM0tLka/BWzDHMuMiQfh7X87LMucD2CkE6WBzSzDNbUpmZCAx7SFQqwwne336ux4hdwSc1FdhTKe8sgNk0joTSVxuNJQPJriDdVs1JA0fSrEtMfpwsq0ph1y9LcIBB/1F/WFAZRxd9fSQiOdg9sMEIy1KlgCRXPMZuGrbqoDZHuZIrY2YTO1s4WH30bm2KIsdqkIpr1DRAgggO6YpB9b/c9yirTQIXTkEA7RcyEEXMqeHyJWezkQvH+NCJIxbgFXS5IHBs53gY1180u79vs3tea7+nrj+AxqiVEIflM16NfJ5HMV+02i5fm4DV3rvFFe/xwv/v/xW8YpdMcXh0Z/OJhOXIOYOvEYNlZKkZyoVnZNX0mN8sUUh28iTiEL/hNg+2/h3RjXC9eQblDdnhOCrdq3Se82ypbahzhPC7EXIWWo8AU9MLD8Cm60PW2XlyNkKpUI4FGiaeb3xTBk1194a7hXp6iI4frsn4moyWKwO26b5ZaXwvE5MQ1UP2dlsObQlfMPxLthhtUBPQmoyAFyNPliAbW1uztMiZ1psPHJiNG10fnbLroMjno8msqOCTVlp75eC1hBqYuaR6kHuIbI+2RhZeamq/JRhZDX4Fj7ooUOrjAOtV0PZuZJZ88nBHDYbMplCNEiG3Ff8N3sPUhME/sBUiiK+S04UBuI6eZSd1VqTTh0U+qk0ZPXKbOdPPQdQNmEdjbko7Ow17ufHZ0DcoSmwq/dnNcMd/wBZ40MYCxR9SDWb3XFjMLiIXsztsEKNz8kXylPFRqYs3uF5do9l0KE8ewphDGXM4p0hj2APq2WaHMX0gW3sidskiX0xbdc+tBuIMJZBIqNbmhKKLsRfZwukyp+K8mNNjJ4GDtLWnrrJeEhsckTFdFKuUuVaJ1vN+Gt3Q2IhafO3uYIXuls0J2+M0fijSWT5CjjIsuXlE5c66vrNcuDnWd+jN05zS7z1JnJNv8KlEJJisttetbYyAeY4eGSRi1riFPyFcZ4YA3U4rKEr8XyqVV0ZI2NmcpB8B07jrr7Jc+KYtCn/ErYvcp1DIjoiZnjzhd+9eJf0kEqSssT8LymcWxitPOeG1xfyNUdf6lvOaqnR8CaNyHga0MYPWaiy7GqOiDPfsb3PdkAj/epQVIPXK5OJFHRkxVfwfnchGFEv7VmC2X1q9cChKAYFMG++pOJvENo8qOOY1RYSFKy0iSlIrzy+lTLVhDf7gw1PtupHHZR7B/lr63sCYDhB+xmnmqd8b6+T6p8yb51oWWU6dgh39D9lQZwY7Js0ovW/85kF9iXjNcsO9Ui7pdgcPxG3aePlqIgixqnbXg4AZ+eUulk/l+OK4I4Zam6cfbJ/EH7epA9SmxgWPiJI2KDYzz8KHJKUY9AantxfKIB8biazlb698YwfdCnvA/un//n889zb+x0sSmGv3KDJxBu22TKkclTUseCEwMOPf5YWyDXkNksLWz6hPeEPJxtd5w5bg6q0bmwnn8h31mKBdfQF2aX3XthvDx23c+vin7dl3EG1d3GWJNwoLfV88F0PDF9bl1Xq8GzJWhe1yw8LgjvYXgq6yF+VcpQTxTXPfhsixwiPjTRHwDXLiqb9FaC57yaL4GQu4JO9wI5MtlrKUIaVLkbcRFO/rgh5yPxjmHbW1MFBglU+AOBc3uiZiUeqXEwhOT/5gUiurg4CCcqtG6bi8TCdEktL3dExB4rNTnntpy71SNulvG4Q04VvxLyzSj5nQ1Ev8iCWbiAEGJ4qJk30mutCYB0TF3y7Axq0cW2WdzR8GTWCMYInE16474mucN9WgXepgF2qHrDsBhLLG9H2I49Qwkhyr87XNtxu7JMRw3q8hPL3MaYjxZSO3ebFJx2PQGlE+Ad8TwnfWO8cOANF7TUxcYAD32jY1HIAsR8SokEgHRdl27MZWNpBOKo1rbor3CBPbO/Ip7RJuApE5M8lvTF2S7U2AFvoNN9og4AWFQMX/ijwUSYREJeGCCp2iM47N3UDDzx4tbib45VHJTjFWZTP0biuRZ445r8585Ja186MWc4XI1CfWNmLpDgtauivPlrtbfMUd/86Ei/SGaFgP0Q8wdgixdyAer/QBxggtULeNUpQ+WnFPGXClduuKbROQQOgGboWwr+GW+2848nfSt5gwfpjdlNPu+tmu/lgh0UkLgS22gyNVYqnQdLDZanjejkJ+iDU1lLztD+dvXqPYhmemo9YZaeWh4JSVI7pOpqdEAGBjX0rdW8etG53pukIXz50gVRTq0HF4I4DXoqZlphdvj5JUqNeZzhsRJHeawHouvaBDMetPizZjYQNDG4GgNaTOGHcJiJYQN59nXGYPyF/FbcmshdTSXe1h7ULoJ8ztwdbNQEUExjb7GMOFVcejMUqno6UluWGnkNVoMy/TJM9XUh/aUCyF0CCnUb3aJLFcLvrlbZ80kl7OHhUtUVzFX3TqQcpqePUJ6GlzBB8g2GgfHC89NsHSnsDtaJjBdTULIjdqeaWXSDp9qTjyXSiaNEId9A6Wam2UVdQhVYxHjdNzdy3XdoAlw5AcQ8nHNJ/huUPIQqFQFMiSIfxMUrf16SkaK7zci6Eo0KHejKfPNlrrCTfFg5VutF/uWmlXYW+orcfCPyHtFCK6hLLbazZkszuK9cIwHTZ3dAvVvWhc/9w18YiGYNZdRTaqqT5dDqS/1PbdWGHbyiEKK7hwkKf1D43d9S8aMlX46B0F9DhEjkfLHlraHzsXXpOgZGnDCSW/TT+lVzQydRdEumJXZ+tcLCk83f4TKc7W4vJB9kF31a18pM0h8xmSKxJBDDSJqZFHNBiyK1ojOBheepYRRSwmdsRqucnc2Y8gYN647zdCvUbZnmxMdBOsKtyhRfrZx5NcaBkRoXSVNiJqZz5nJoGED3uw5kTij0gpLcgVx1wQnkRcwCeDGb75uMYrB4mGBpmH4CzWdx7QgCV6YucY2YtRD1bS1LCYGcfpEOTRNqOhR9dwYCJiG8/N9z7oxOV3D/MNlsmlMs5dn0Bj3lNrizoWDWkTdYQByw24hQ3dtfOWiJYNu6m+aKAsesm4Kud9LPVxdfkbRJS7n+5tay3VbPWAEqpRrC3VZ156outHPo9rJuWZRn46nJkQUPPqu2/6huPoAkjLDvYghb2fdkX/XWJAPt3QdMVWULJb7G4jHTNLH7gAojMdvMH4oX3kdaaaGg2ykBYfOvJawxsJC0KmTOqOwGeDKTjfkVxy7+xhB0GeUTtxt5mQbQRG3TJp6UdPB0aTr9e84GVLtXlQauydYj3isH7aVB/A9oD7AtIOrYzL9OHSszCsWCCcxstP5PGdp1Osw4PH5CPkJqKFitqHgShAHnsMS2I1eqy4O6IojreffxHfkHZXWhZFhuVAaGnbTkuIX33ChuY1d5qG/yIgS4hcDKbSSW1lZ/MGI4/kDBi1MlK1Is2mzIYzkIsCWpu5gOadTb0RYRV8HNcLLJFO6K/eSOWGZxTY5Oq33oI1Gpvs+KQx0WVwJMM6FWGh9iaWbHe0uUHtaY8V0XwW7L2RHS1gI+6XgUFRh6g+3h7QlmOr7mhDa/bmmiKOl8PFVFm5i68SGYS8UTA7Z4zHyFh1sr+DHyl7JAdobac0M8gZGl8TKkQiR46sO02hN7c7CpWYOY43LEk14EUyYwLFwumQyCh0nyVo7D1acqt9YAqjpeBhT6VPrJg48L7FYucO37Ej7q9gHlBPRBJya7Er4qd59c8ukxSrE26liA0KdrpPPFHu9omE+WFwygQ8kUtYsqKQleiYo8+gYK8J6ztRs6h02qekujnrm7ba5vE1M67dH/y9lboANjRmZYticTO14+O2Coaxtpjwmze44OBNkb7HGzu6F6sMBqrVgCPx3mJ4xCmx++o42p3gWo3qXW01BTV1IpJAkIMkmj44LcfR+Byp2dBE9WpQPvBmgpsOHO71E3AWA5EXMtGuSFs6/DZuK829fICaxNM8KzqK7JuJaspSx85PEFQnr7fhetOcvNyxNQ4NgBglnhSZYqt0I8/9XqNiwYL2sMFxj0VdgB4gtm5zsGTlfTJIZm3udKB5VxMrWtlr/W56dXYFzqOuAGVgMECwpOQFVWjHBHozmtFOHgX61oFbc6XaMW9qYiJSisHDxQRkw9FBCwp1bSWOJq1zl6vTjO2EoJUVeV4+Umi9cPfUauE6IRP/IOieCsT9J6nzi8PRWCL2vNLBBa/Asl5w/V6v88GcraXjl9KdaOBu86whNVallBp+lM22++TU2sQUf0EA6ajX87HT35pr6dLjvW/JN0Kr4+ymxLVkyCK5YmrQxJcQ1yBSjdyhptHzxOOHsxwyGpFyZkHsWn8r1o7PVeZFK8oljHdaV+99hbjtsjabGLmtSAzOAqp9ZTwPmsvcRHdYkaCcX0ZnwlkmjIPgmARm42mpW7F1M9gfCanL9Mwgpoa0Nn/UoHITXduSZ7xgTcOFgHx8keMmC5qob4XlGnfNVHW7sqcnApJ5QkhHapWY8S1J8VuRUV1UmdIiuNU1+2kdtRBNq8+Gq3X+HOGlHqYutnrZOFqB3N6QpF7wL60GBWLt9WpsMYWdRT/lYyT1cC/ne0QiJy8LxFVSQUN002ySakgJX6fZhdjdQfS1V0JruaIAI1ML6jTgaUKwMMz7+iJKA70qZoR7h/1dE0P5y7L01iIg5MQVIyeI3fNt6f7TAMLjkB9Mc3pHrNbiv6DrPB7g4+0DJrpN/vjKf//UE1K95P9WgsZU4sqen5E4R1ktPX2GF7lYTqd/fMZQGM7F3TwEOzdPpc2PlOjcoM1HllQ7d0ynmDsg5KXSdNbJ0z++ss+fpZN8NPzzEjl8hpP5CCZC11dbJ8B0Ym8ev0P0AF0v3GldJwtXx4S3Fve4MG1ydZ9yyRnVG96VizK2PRs+I4TXroMOtUOdVPBPORokQehZv0akUm8LLSl+WmNJHlchGLofsOp9Z5qLiGWHQgOFYYI3Wnanouhwk+BNnMbSlmdGwiZXH/O5hxdeKQhZNQ7e+Lfwy8/nCAh7dIzn/fVr37q24ANzxW47GAcxL0VgsCxTp9yC2KGDSHEHNTfovKRhIxA72jnmMNDC5U6RD0nvUnCboE3uynHAitGLkImzB9m2w6JPU1iAE5FlEGoomtLdR2WQktEdCUqngJ045r6tU26AEiJnvtibbniBRoOZElGPTbN9Qhr2McYfVgP8VgTmvG5xqp4ynBhmBVcuv81dhtdfkVA3CAxQncMtWmBluQftvuzmOmz74mQ7cdHu0Bk/d2CBmrVAizfPxnELMmnVgznMV1hu0scWITiHT3CMNNzDfoNl7eSI0cpMLsnXG30KRUBYma90MLrXgYuHZ6mstt8iClA2S+fMfhuD1QlY+rzfaliM6RB+8Sm+UKK0hrEz3mOnHo9EzLGn1xdIg/FLEcfZlfLY6EAGCfbUAjVN3oa3x22YLpddFLQTCuZ8ie+Bq7rBLkNKScrPJcEQ0Avg1rT4qJsbI49+UnMMp58Vm7x6O+iCj3fv8y2VIRu7T0NtVsNtcrpYtGskU7Xi2Cjt0Dhv+n1G1nVWDwUJBqMGpTp+mlaubyzBeBXexupAuvwy+XbksXETYEUS2lgDclO8rxVw1WoppIuAMNU03eAW8GvFVnosmakkqXXX/HwW9xJWlOcHz3X4XPqRLfdiBN49X2sD6HQik9DHvmjMDxZZzbPLixXICbHoTPWlpmV8TzTuiBbybBjEWkgu4SMeqCDa7r/aWnFik4i9FzBf0ugKAeOt/SMa5SSP/ujY9v6ocbM/wlFjStvoJFa232pZv3Gn5TV29XCEuafJmXdXZrBAREVTcB2sEJ7/n9f3+WSoTsWFQllRUPNHV8SkqF/4CW5IG1vtjSIxAstG8E/PdRgMbcIlQ4PFZ/I8PEJM3ejyb1gX1ZGxDrlefG7PtuxsF7OX07H2z9vH1oVrq1joobhSBBjvejxFoQ62B9u7mjqG/9r3w3+Zi+5KSl3PwW4YuJF2VDbhax81/OUuanRSq0tF3ytJOqWt7+fDHog5sIlwjiDIP0vngvt5vxfd6lUNEVandFcxSmqiTdJ3KxinOl1jEXZjU/wkHohTzRTPtfXBwZt5lFrS9BrnftnoquHldrXVIkTniA5H6eL/ntZSSUMoMnSoFyVIwXEtBUqz8hO8PjYBxPHG2Ry5ohUgPhcRkXwBMtwrM6z66YrbG9tEkdRoXsRpJlY+U10+BQ0y6I7KdILO6i6ar0xbLUtvDeyU7QGJ0Up8wOatYc/gZDFGYlWicd0COvtCXD2p4JiSmlc4IT7FAa7C3vZokD2p226oPHqzl+Wistvpsr7TXWmIYwtLXDNYJztp6Fl1iyX2LoVTTwVzkBGU3zq/63FvTWuvcpID/B0dy7yH3YgtrL0WspsqUHV75kGQIzDZhYrITEAdacdB/Lg3JLH7ajNulV4Hpwr5WSQ+Qo4JG1FeNSMLs3X4WuZmROlLPeMWPt5k7JXkC/HFhJl05C2+8a74i8hKacIn6y+uxvYJiYDCk90gZONTKUrGdb4g+xtWNeeEEX3ZoXRJz1BbnBC9vOoyadTKo0UKTiKpI9p0rkNjJ1KFE9bvPPIsfXt2fuXEVUBaG7s90rGpr5C5IF5nJbWkT91KcZHl48SXujWmQ1QZ3DvEBz5S3VAL5ULVB6sDcdM0/mrOmgLX1oyqjVC0ERh1kZXcrQTVfMWCT7pT1/Fao3oatExNzI2iGWSimtd+5Aaze8pvqrKnRVXCNr3cpgp7S0Ud8qTTNgxhq2wXikEo3EhsJSJTuJzokmH4nLJhNwLDEhVWQxdedDJ3JYVs3YymfxvNm2VR4k4YTlKrtykOUrmOoiuaJLcKJKyh6yRgG5Rp59N09Jt7QwxT2f2Q0//c4Yyu69CHAsVE4r0rfcCsmS+U6mrHAcgU+Z4uylnmEdI7NpyPOgA7G2iFH/5wdfHDH74LUNDM4IEQHfx+rd085bNo1UMDfCoY3+T6YY4ErhsLdkWrUbaphal1EUJLX8ixIIOsqNXzGJWzm7wwZREpFX0nlQVfmtmssM/CeLiZ8LkK7vcCfruwNFREUxnGCmIldHS/A7o1PGO/QdoIZWsf9zzbjlMIj69RwykPCXQ7FChqE3sbxFFDCGqPmykIaNd0mEg9aGgKembai5YCNOwf9AGpFsdZP3b53zM3oQZKqKOzK826eWilbVYd8UvjsJCKUZDk2Bk+TbgWRTMSvoFo0EgFtqdtuRPSdhmLKL03moypRvBn1kH5s1ZDmNpnem+W048NSoF2f/lWeNOSbr0g5o7k27T4yIfnNqtacdyNXgPRT10phMABQT1EaAIXedrYVUByQdcYRvC6ulJwU8gIvGlX9MUj+SbjLtJEFuMGF2Ohi7FBIaYfSexKMvIEN8pcW52LE2totrIm8KMEEVyx/g+MDtDDO5qWEtfWCAwxQm+8xqNyORdnhuQU2AGaMyTQiMemIWRZsVB32JI33+z2GbY7i9aRxqZcqnB5gWU/TAHHAj37zJeND0Ed1qusd+7eUdApnaS5axTsStUeiNQVk5ffJN8j/O2dA6TXLW8oKg43kzqM3dPkvVZF+xOGvY6SZSH3MzOVdz7dCAs1T5m4xH0NLfb18jWcjMfo4bpraqKlVvPASG7GHQLT78qCBDZzGDuEc5sgO1rCTSQP8fRwMH5EVdfyLM3j8SMI1HeHQB5nJ3fwWr4QKP8l81q2OOG+hWtNpWPcZ6FL4ynbAT2F1s8VrStfhux5iwNvExkXjAji9071tqIeYgNaWMw6Eg4yejFBZNppeOSBpLVdvgZeY2JoTX849+dbYI1oxrz4NqrJUn6Y3pXhMh/SGRzqcKl7SKt83hvcrpsnQgMV8T6PLqg8tgi7Srdi5s2T8Kt0Nv81aBI9V6KtwEB5jxvANIJ5rcytfIw5WAGbXVJD4PZxDTan3fzx6LTH7RUe2/3xoD/YTwYDbNA22G90fzxZ2f3xaP94/3jX9X/0j//CBpCDRzaAXNNxzraAPOBOiI9vAAnPxGqGBXjDqxpBYl/CH86Hl68/fHfxdvjq4vXLx/SFPGn2hfT9fB6QZ6rdGoy479nwjjQnW9kcEt/fLNuKRpH4TfPoDZtGNt4Nxnib8RFf+1YMpG4xkbKS+zt6qQ2bUR7unYaE731JafeFGbxPrSphGfsUC9KP/wY6Vg724Gr+s7dH4eaRdIWIiwuFU71B90iY+3f8i+QV/mTz/pGrnxVtIDkwN8fyIAUz2E5cwyTTs4apMxJiGJ7hGtGRDHpLmD7cCzZO211Yk7fSgQk+B9+eqL8cZwe9xxaZZraF93asS87+/vMjbpIDMnRlT5o1xeG9KzTDcf7n0ohLaTTQnjA0bZZj84tL6dlIanK+UCj07PL6/DdnHB9qRafwJddy40ZpTP2u9LQWp6dl+mQ8yObz3see6zERX5A0ETSUq8ZWTkeJvdJtvMNYz5NaLBqszOX0JKLnozNalboPJ0KGOIWrPDFTGpx3dTZrk5OzIaFWr1h9wEuBR0U4fOhcnSt/7WsslOv5gFPvHDvcFBIK7G3mj5m0HWfOmHDMm/lUagBvJxxpds2niAdq966xg+LViy71xow3hradfLLaccxRRz3NKxHvhU3PSEyCEXgao2VQT8BWY2Z1sJb0LsK73er6J0kBjsdquqX3FgWzL4d+1bqNq9Hvnhq1IVxclz/8EBn37aK42j5J/ru4T4NVTnAvqDx4fGxwuD0rua/hbS68DB8+ViBW89TgoMAbQ0sccwd/WvJRRwIihNnTluFAy480TmTB97cHK0PjDYzQi2+TGiyjWWpifQtS8nzFQoW3B8M3XlBQCaFS4czHGJ2BJ0yYL1cgbM8RTltKubQTiDss8od2Q3rNx5rsq+vCmVziUn67zBGwtUVZ2ZqysmAlMC/3oow0pGtCm+BffWeSlZOROjPCnEcdcvJYl9Wn7IG6qb4rootwGC5C46EBpAp8jPpOAXhC2ULpZiGh9K8TsGLSFC3sZ0v4BpvNTCmqWTBl7JiZu9+87p+riZ5qS9jIWxysfIsIcks6Id06SnXRPSjkLVt2jLWcnqgKV/5T9OD8m69u9PE33zC8KbwJVyV3LIDDDcYq04022AoCLpUtOkQY4w16i0plWtxIAa1CcoTDcs/CG9SJXFPAT+5KbeQQfShywjHAha1gq2MJMlqDwaZHiaeAja2kpXJtehCxzOXJVO16zneUbZ5R3ycc4ZYfE5nObrBDz4P/OnH/FZ9u0FHccnGo2i2S1GbyTPU6W8GnAn7jzdLlTGmH7/UH9r2wgV9eLjnhXmAykHfP/4j7UdvDEXttlsXUKVW8IcOii2fPLRoz1lsuXNtGC8/tGfZE5ebWrbCfu7G/W+Y/yt2kH7kuyGqRb8/GrH6CpoDYHpQkpWpXfL1E+yCLbtjWtzpylLssiupyigvOfudyUfaJF7rant/NRf7R2gQrw5LuB9MaFsU2toMd6FcOgkPCV/zKZHewxy7vOuNH0ToFxVX3kqfEeCBwCVI9z3SYvY7n7sEnelY7v6JToy98qDMGVWLW+pIFcGCPisykX/IP9+Tx7fYwoaIdbD/f/ryNuwd+L7UiwSOy3Q6NgWdJTtWjImO7/d29/t5BAv774eHp7mEjMna4MjJ2cnKy5+Ji7tlfGBbbfWRYbJ0j/ZPExeCvBGFdFRSDXfjuFe3VI4Jhh8fdwTDWQQHja+jqr4x77YXrsirwtd+IYnxR6OtgPxb64newnio/4t9KeGsP1/xfaWSDg2bHFDJegNnRx83uH68Pmx3Aup7zb9iJP948brbucfHI2eFuNHLWmMQtB9AuDEWQUvb7aJicaCTQs91YtzTGxp+XBROcnL86bjtCM69CotGxg+f7GhxzvX6COFHY+pIp3+3WPe3okk0OD/XnwvRY9udlXmXjdvM/VmG+4Zkkj8U6cF4pMnvclJ87fi59f5aVHiTOKi3KeXKTVk0EeaSgB19+sCZS0IoWVWCGYa5vh0hdpMQ8Fhgyq9KKEQVTWB9C4RskGF5rganh1DhmEYbiDi0Ou/9YLT7o7z1PQPiDkj08eVR+a39weHT0/LlR5PL4n0mRr7/ZP2uKC2b+wyVc3+H3L99fXbx7+wilfnTwKKUelUIrdftBc6lWafeDprD9MvV+sEa9h8/4N6Pf98P01b8F4cxHE+4N7UqRF39K+2JjxnJksOZv8TuPzJDFH9CRGDuKqnfz2H8ZabG9g2NW/KD5AsXf5HOOUDMnIziaRX85b2kxHKzVEcexzsASjFNHcgFysfKtPGhZiOGjbmIy3WP54+hDd1sP5cZRGvdYrwJpHR6rAvf7g70E7vbu/unh80epwMP9g72Dk2OnAt3jfx4V2HXkfzYXFkekSzN8tB97+CiVZ2/mOvRG8/53ozfMqF+m46LoDaPjzAP+rSi4o33Vb18sg3iD9+Rs389X6Aoyuh6pJ1oDd+iIvaiOkMf9C9EPR0f/qvXDipyv7tNfTWUM0GuCy7Y3eKTKODp5/vzwn01lRE7/z+omHdKNfff+zdUXOEqHg0dpDT0DqzSGLFOHlpBPH60ZyIhdpRlkao/SCjKZfyUCfg/GuVmOxw9zzPFvgJ2DE/Utfp8BwhsHAFc9piP4dwK//2r+zbVPbUnjxBsEAzi6Si2P/CpN7qrs9mt/7ctqTI+juy+6ecfPYqf3jX+Tr3bSb6h0VBJFwWhWhvTQDP66V5S3JSO1J6PeNxhFwhG2kwupqJLeIjm2belTSSq6lYQZpf8yaygIa0G3J9+W2q+Q9A1+mbAs1DbhBlQKV8hWyyJ4f+X8mH/zHbYuMd8c3ZVSaZM3tKAoymAZpXMHTMQ3JZk+bHHYdEJDh4M22X88+e70IfGzes+uMSVBT+Wvrj5VkmtH259xmaTnBul24k4SEPGv/uPJ3uDo156ABDUvt3Qmsm/6/PjXOET8qyUuqXwrqCZm17+2u+I6gSyRdyXZ2/7cDNIf2OjmQfA+sHR10x2XCnYshjaP4dqdp2eI9ADtuZV8hzoALIvLqqTkLu6TA+fgt5+ZiatlVEpNTRhMoHQ6RlTx0dQtbM6D1maIv8+yeR3+DjUIPq9QYu9pPvoo5FDGUKL+VU+xQ8+4zYYMU6IvxGfrhTHnRgKWl+jkkJ2zCq4NXrNbvIEdrSeSp3K8SatuSeobK5TAGKqTbDHaftbeUlIXch7+Tvd1/s0lZ/zr5c0MDEYNFdk2QYp36BQcoHaWs5r/sZMx8UtfRuqWKgl9H2WLw1Bsw3kQRmR4bkXlpq0bhVLTHeHy1izcFse8uRKoGvNiEmYQlLlcjkpIvOwlOSNOf3giWdMol7Yk73WfkUioM9dYloqFmLSiNYplfISJ3cuTk+zzPOMqTBwopVLp5qTgEyH6mCNiptkI6j/8+6j5vefyMkfdqYkAlOKzb4rI8Et1CKO0Mw5HcaPYBhXflstPWbr0DE9BlK/9fdqyFxWyILFQiGJF+cEdmQh430fa1IO9/u4xVtqAsbW3+yibeg8k7t6hzUTI43+mSpvVJsbPF43ZtRbSY/IP+02zuqnjk7qkDhJFtjBGhn/Y6qDMrl2fVTGZ1gs82vA+PIkZ3oEKYpQUN7BBU9w/8d9KjOb4SDAGP5EgomWDLU1Ht7OODD5WoijKmvkfGGy9uSHvx49b7QjsIZDcP/3j/4tn65/+8X+4Qvj0Y0acSrAMOSsvfzY8Oktbx2EgIx8zYFVApIFbGX+RaADm+fG+UwEn7dT8OX0Xhe9kQmIy9KFcowCSyu+zOU6CgdKvptlnwtn6FoxqB5wjWPod/MrpbbL+PpX5OEASu6pmxqBTX+ycJnPDg0ak/kk78BMrAWFEnQC2lXgq7yQk4a+TkFQqkrR272Oppv0rCcoezUUyM1ydH899S1COTPqLJMrhO3UzlUY3QAE0+aQoKy6gcBBQrF3VHmXyQoR/zfVHUuYQXc7O0obgMn6bLRaU5BuVkyJXA0ZapJ6dv3JuKnfvxb8QfHKsVI4IImHThrmdlMF2mt9UaRX2WzBFDXPiFGa4qmYaZ2n1kQfGECWXdmsZiluAdLm4I4IS8MTqu+Xt7ZQig3KAWycseG5z5fHxhl/BHRhaeXzV75ZwbcEonSTf0j602EUZ2PTtctJJ+6nNtfF1cEja0HavF9rXixfaprbOYrSeAQyb5AUMKKLihRK4UM+kGts0ZkXdREQHyGR/n7qOZlj276mKs4UVCy9KLN53cs8b9SufDIed3FzxIVc0DpSKo+wGZFne3cTIgm/tIJfmhcLbVSOnjzs7svXCOsBCGhc43Hpj2M7ySeVpemLnxTTbkpJ40eDJYJvRWHBT1acJniD3kqjClPlC+wQRi1MwuVZN1oeLVhQ8yhQVvpU7njptKSUw3cIRXI7HjOgq9AD8p+F3L6//6xP40fjJf/OClKR05BBYyhaeuOk/1GLkpg6ntlc8jfQ9a4Cc6V30GMPK0KU2NOUlXK2cqbyaxRpsrqEg2uSOCGi70QYrzoVl1A5LGVE86RrV02pPbiR60MMlXrf5PpO3XhbIkcTIfbJE8ecH0UEP/krOo2MgX63PrXjskkJ4kqO31H6JKmJwmUujKIm5g9tiR6fYMpu0aos38C4vlLXD1W94GjSskOBgQYPVkKw29m8d20c4CTHRpK4TwwOeWyWizLQ8jJSen4CUltCb3tHpCldpIx2Ii3urJh9eiOZK4/FFUkf6HCl8gmGd6dhkLhvp2yGzGVPkUGdsfsSMakzIbkMKcvoK09pwycJnISpEqRDdubXGIm0MGp6uvC9VZmcxjanKTu8jdtvy91Dhkvop7aX52Emb6NzWFJWG64brcds0uVfZK1PlLWpa5oFRDrp/WXmCAjnPqk2EYrSRWgm1aYSJrsqoFE7vR43OPFoaCADLkbSy1O7z2KkPNrlwLXgolOtoE8zJH8PhL9dEjdAZRgZPs/B1oKI3tNPWUfEbuYTdUrSI+OIFHVVppSivHl9C/nFbz8bbyxkWtJDNE99JqHH4HqjUkyYQXQekaTa6skqVJE86f0ph13quAfdQCuDGNucUeyUimm281KJ6EBOPeZTMtcIh380lQO50YBPPELsFMRv5alGC0zkOtLPWP8v6MTEAivWYUlnrwaE7UozKea43QLkGrJLwCn+l59xxRNf0TzArRkXE9akrdbc82cZ3Z4IXV2BoaJrkPK/hn7fx4EDqrmoiA2+bS2MvXHA1enH23sEinAmVc4pAxml8cnadvVniMLLITpPfXr1725/mH5W/PDrXjUr7MR2HRi7VzeIeBcSrqjhqilG6KA15/WGh7G9SEIyF54lIWcY5yz3woewzOoX9llT6zpErGs0QsuO086KTos1Qh2xqQA2YNtTAxYtw8m2Bu8oS00PeWBTXzpkovmMP6OQT4b5AzLUatDT1DvO6Ca92Y8UkbF2eR/AxXFg6ZubBYE4K3AS6/mwDlr7nt2vvw9RiJLJSb1x2THbDAmwKK0qwIOwObH8YkwncZHKuQrkViVj4du3BXmh9MrYMiadtNrpx59p01rhsFdXo4oTuqKAMQwzYJ4ib+PE9MH0sOuqQG2fk/BU1T76n5uvIjzGi7D0I5ppOQv1QY/MTLyl7uCq9Lb1xdHcNvc0ax+8RZ+l9w8K2bPRx88HVdctFDtyArpnIQWjYlozhmKcjlrLcViIyvO9UB0sTNqFrnNEXflHMrwxHAtYdYYYJ7kzk1eQQu8wqFk7jyYudZxzK6OO3y1lWwagip32fvYAVwVWfryBopmd8h5yAlt4hGh9qr5VYBGIRkqIyjRjDZ5gQaBBW+PINNiOWL2c3bmDxGR8z4GNqNb0gF9iMR1FwVFyWjx4UnMFw+j+wjehhsMZ7pn5BLiYCKhHpwz9lJvaQuTMkERbtKLCC7Me8xSUHt0cYhdDbtyzQSs1MVMieQLRuRa538Q2ni0U6umO2DuowGR4r3OmcIoxNthoy1aLcCf6FKRlBAKoQYhWhd+gA5Vq1ucp30llpIC2mQL1HqTYl0h0oiOUpyxqHFGrV8uhBfGfcimeRV2nji2PWeQ2yAJv9ZrrkeSAT3PFfr2FH0qUbm0ZQJ0fPo5qOboez9OEmI+rVy3dX10+jnCk2HbacTUEHaQDE9eqYRvsx/tVVdhLkBxngVGO4pQJVsMhcHRZaGEPY8SFdyOGVRLBPT2lSjA0YivPx9FnANHuTiadIEL6oIfjd2w/Jd5evE5CSWVFnQYC3KfGtdLBHkDzFp/nCWfDw3DG+t3AGX1Kv6CaL0gYUN3SvyxGhrwIOMY4swmN3Goz35rC2IlPqYxCd/Eo7lRMiHEeJBRJjUcRLYvF2wvgOZS7bPvystIDTI1TON45WPlFENX93+JuLFy+Hry5evn4xPHv79t312fXFu7dXtJdliUBbmPMy5hPuagC5lVJ0DlDOaUOk4+O0IjYXIF70aAghrPtvipw1WTHNqyfp2L12dNYdwenQZMfOe1RZX5btWoVoRbyQXne9+qrK8uYgLZPfZGOFrj1aJh4fTVPl7bhOw8cWmdVTN8ZnJ/N6e3v7ifNvsBlQZDeMmZyNG65uWbTC8jz+61JI/LjD0H1Kzqs3XSoh8YnECW2kXlXaZRVGFH+znCG6mMpHppkPQ4j1CwsaNKU5F7QGiDy4eCAUm9WrmiWwiSzyEbDm1l7ayH09a3ojMpWmm+2D//3Q043aUtYQd01kvAkeMbv7LUPArJqpjXnePE8WUmHPQi2ZN90zTazbeII7YyCt7cxbLtpmuSC/Ri4l6T4jpDl9ah+kEw4DgxKmMiFdZtsQ6pFw8nY4/rXE+lBD95ltozbr4GI/OEONhDlXKhztsw9fEucH3x5vAXNclCMtOZ/cwF4QxDScVw1JCs6iGO/gNvhfmhilu+qpdUV7dmYuuLPKNWrsv3hFqJc7PKNm7tkazvKgp9xgastbdFtkKqAoekbRgqCl+SKl2FsZ6+3JQev2Aff0brvat8kKz8Dnqx9GhdvLFBnP5NVQl46R0ZkDmnp6uC8WzLKHAeCeDVmbGbRwthee5TJIg0zRuOGV2YCy4+SRxWeWkn7/9GDvUUDZwe7z48MTC5Q9+TmLzyyE72dDxSK29fzVY9CwRyuKzAQOCNezmKg26UADdgNicVFT+VmfxUefR14BjsUfxZ/1ZUDZOP2WCaXFH/ZvBSM7ONkLiDr+BUE13dHjxZ1O+/kMxVMnJf0Plwkc+OSCvrV5IXXsCVFs7jH8SgaPVXxRw3KNnWCNCdVr1Uk4rV8x/1W80mJwMpBK573tvZUUTKsQTvwSRPR19T1rMEkpep23Nv0Y7FVoWQsUJNbwsQss2hGs8DPtbLS02YsG2hxOlrFiJFaHOXYbqd0IKga3aeHqJBGVy74JPXb9EnIbbmkTLM0r1Svh9emCDnQiOT4U+Z+RbX6MOYPbnBs/UOxBiG9wB4gjnDrOuGi0absjLOLM6cqv0jIT9hql8UmQ4Kf8bjrPlfkYxoVbSL304AqIUk4GOIbkU24dA4+6hjdgtXxkLA6xAKmtOkqRSvQJHtonJHae0MI9iU2xacno/Dab225kSDXQYk4xEcW6A8fbqb86VpJldRM/s43uzFPt7469kKxh7FBIPHLyFCVRmvePT7YS/dfBM6xN00dtUCflZ7lIpVGugMbck1ef/ujKHNrzEBDQCT6CoWfyzyE1cXIpmmF5O/TtD/GsatM30zM79tRWwEeECEjcqlrOKeDISwcuTLt5ZR4zzlt2+V53jAZX5RWdg5faq9JJBZED8aV8awUJ3dB7bt8nKajbHAz7u5BqWQ+w3PK/zyjKJv914e+8SebEXmXPnOH46eXO2Hw3g4aT5KmliLFn1ESrl7w+Y9DxDGVcV/R2qPzSG6Tu1DFYv0lahPosU/QFEZoLysqiHeKv7G7U9SBF+Vjei+f9PXA99k/3T073m5y/xytdj2MYYG/gPA/39J+J9iJuq1gn5AhtcpR8HW7IbrcbohwSHR6IfvylHBdyT9VayguvVn2y9+fnuEAKJ/Ug8hXWnRRYmeP8L5H1Atup/WJR/mJR/pwWJfOkDER0IV/B6A6+htxmIAnj7hxcyjfwxXP84uYkKd3PiBdb4h356Yst/cTx4Ph0uhDgRh2/3YEyXEVMkTfUVEIqLJQGReVTpK2bDrRnoo2qsqNKlJ76GCU6OOnvnvT3dpPd50iRuvc4yt3BwcHe3t5zQx4lj/+ZKHdXHZO/RV1K53RNZTvzgIzS2TzNJ0WtjWl8I9SghaB8Dcw1+NPYYyrygInt51bF8TaSRXZfTznNW8Ocl3NLQNVx1/4FqubDkFH3sXeed+s5nux+nZUbEFHB3v2hRDTG1ct3m0fLup4QFbAYfCT52mPp+j8bRFRMJ8/yNUzFE0cKTkwFrIdZxDsrHp24zor7GxXFaLdh0zOLQc6NXnAMTkmo25M6I5Rz0x5RLZX7yOoPeHSJU/nw/jVf21EKpgWmJ+m/NMhaTk5BupoIa0ctjYeybDYOlzRaCwe8QJCKnzqLLojaMNgwLWGqM/ypg8/OmxiKdqxi7rgSaZJocwQEN8GxKLRTO0GQCFEofchdjZKmF5G9K1Juqcl0rQf2mLL8Vu2YWb6c2Z1Go8s1cY5u9po6Cr9yiKWbpSyrzPTxzXnCtBrWIWerdPGkDhpwwXAPWH1YWVs0h1P8ucMQTZOD3QNx1LFeTntazR3NFdFjI2phVC1nNy6OgyddUgaUDqZjpT/mXoS+z1QMTbeyy2k3vI4XynARuMwqkigRIpu6R2IhojKY+c4DzS720YlFIz518HuzIPFDv8GdqWO9Nlu/EzYwJGFwz4yBifa6YEAdDT11ePMmuTgMXT3kIpFV/wieOK0F3VXpEAdHUItrMXRz8+C/rDOgH0WPZrvhmxSeeNMZNYFeyXmVl2SPDw4iQdxBmDhZI/4bZSIInxAxAN5V9eDPOgYHFkH9TLvub+0Zp0Av3lLKf92GN50Bm7BypOMiXm4B1mPuRZdhc8E1u8+0/mbz6xAgQUUg0kNCuKe/e9wazXAiPOYRHQQlkgyQw8nXgERNQKC70ThCyUslPl6H1B03lb4nhRntu7ChbHedN30xgpNdltSRVy523WKZFr0Zkf6Z/NYYWIiXwg8eX4uGboIEE8RPMHrmDlvzsZItrA57RAmKvs09Ghwkv2UoJr6U+k1qY6fQLH/KowDasFCy9SO/6Y55oYVuimGFU5BpqO3yekZcDlybo/SMngsTPmsGfyIjxyCgG6xSCxvMxSp6zzmVkK4rxqJWWpRnwFrmHo/XlQ9ZBTddJ9OMvBCVY3YhDo5qXWpG82sfeylFFGqftMqUBOgpe0M23OeOSbthyNhRjcsPAg4Yf8DBGI4vwJomTPSghOlo0BvH6tB53ymM8OpSm1Jvyymk1s45IYoGtENVYzLNAtnnN9ktdZsdj5tqSK+sXMtgRIEgjF1HY7wTy7nAftj5Ez/0EbosOSNgB95jpj6pnbKwWOTU65T6rlwi926mKivYrKQDgszzEwMcOfcwdRTZp7UwiTcgoRNQurWA0Vsbg8viXWGq+q0zrFFYZI/oWrX/yDzUAPnXd/cwD3V4eDp4ZNeqw6OjwfGxgcDt/6yJqO4wwM/frQo27QtI2I9PuvFxWJLjDwTBPKm4CsRw1SJ8Vn2/mjwSZur4tHHdVoTP8G390zk/+kXxtCMDjsMamRkyvlBkxQ+v8RUXYwrycf9WYHInzw+iXJK/xIt+iRf9Ei/6WeJFyr5KNjRFrI8aEWvK1pXlFN/hmr/VpFZd6J8jwei9XZATVxlmStvuwFYjI21qHx7a8Xfqc7CdvCz+VD5IYYKr4Bcmti0ePKiYMMSV5T3ieETYbClDCcKakOYPqz+kGbkmWFHEVEQR2hkD39s7wYavaBftbx8oKG1l13vn/aBaakfhuA6Ria3skoVo3RVVsppMJ0dvVE6XM64MLKSYfoOBmPkiJQYmqb3HRWiWHVGNCAOWyR+zlVFwzyew71Ocuju8nqe1pJpjon6aTkGRt/sJy6pddvSk715W6f/Q2c0e12KUcsWy720YHJo/L6kUpeWi4Ba3izksc4h9KCwZDvTApTGo8ZEHW3lVSHQ8ZRO+BH3JTpIzmUkuPpNyKD81TxElZ2OUYi4xJcN6CtZGQ5i+SaVEf6z0ocs5nPYxnXutQcECMkJZwPsl6H/DKbzNqtPkLXYqIH9gTlWo3KpqKT00qEq9wLedEqGEK666vysZAzKingcy4bSAe5vXH6nwKeXcEpl5WDAtzRtGD9vJ1TwbkYFFLTwceiPFDBYKvwfh5cQD69fSoVkX96Wrc+QWW9hwOp0o1QXzz937BeGzq5LTDkkDgFJ54FlkYwMe1WXUt0RbA78TJwKriBTA4HLCh7OUxp4a/4n+MOQ/PJOLWHIbL1DJYKHhrzg1yxLzzcPV715jbfwnSjrjD6oMRFwhY7sSyCnKP/z5dkL5QVjFOyEQkqsuTRBqjzhpnRpeAHdatjid+DnFl+9+886YGj7j2wrszxGVqAsskVgX0tqdEth646N6vrEb/8tSOlqMsmqhLWiQw40OrAKg8dZnGtTlLRYu6FuQAu7aIR9c9F3otXeYmQfBsNjHPA1eyk2d4m7TB398ceAhmU6B7cAZdA/BuuwGTqVw8dL2EgY8ndrdAtf1vZADaLWrYov4WGSfR+Cl1K7g3WDuxojp8o3JJ2JmpAk4ePmPeBinWPgKgntVpNjqENUcHRRmU9/qx7KtdYrFqFw+3Fgut2WqyPvkpqRXT9BfR65X4m6saGHaiTZ8aAsqHTzU3R5PJAwKEN4jc9Y4DvI5ShDsRorQhfzpd6hX4MeH8GOCDSNhOUvyKG/r2hHJtCRqYGFcWYDRh/15NYwVqosvf8j1PRyyB/kH2l/ML15lk5RBMRQV18NBELcsyiOQup4tNDZsMF1zZ5B7MfHnZS7v5Qgzuo9RK0OpAPFxOVqi/cD7SDmTkKfBan52/M0dJ5+M7ehhePZ+uBzybjpCbw2z1tpbxnt9PvxNy7rp/VP1JTYDCS8i8UEPwYMsiSKS8aKaLjCfTuEKNj1F1fipZQuilkWEV8wdcwVyzhcdD/YGdyAfaMNa7ukGUsaXxcdt05opTEaYZVkWuM5ofnxS5SYG9BYz2abjvIyLKopEoKu8MBjQpjO5eJhK4jFttM9uJWI2tdDi9p06aa1R5AliZ+cdvmdsPdHJ4sUL7iRCiVi56E6pprnEHZXIES4WlQARp7Fegdu8qsVTL0ZtiAC+3YpcO5qnEZlKrABkg07TapKJp7iCeQRrZnDzGwfGlPnbEN1MUiVSlkHHdlXK1cslUmKVOKopWZ3+0HPtBhs4mFo8buysf21GXiyUa7Ixa6HJJV9MskHSUyILKNCCRY6hDVblPvlyjnBFfBjTtepyVg9VmKlMCObpiLw6L2Vsnp3atWV+qfXv2oS1IgH1aUKhZyEcdqZFK6PoPZaKcjn6Ps10u4s/IfPt56ZwXJtOluW0/c6sIejWlKOsfIJQBrz0lrD3jWjiwfNVbXFyn3iYjf4KvnptXk4g5horxJC+pmsQ/QPHsMpBjmUu4kSyu8fMQm/P3rw8Tfjfvz97/eFlj+gn7B8iu7y/PWgp3VVWhLU9DuPj7W0chlm7TZoT5bRwWX5kjlrLcnyTT4YkIYd1/mM2XNzB5MADHls+8Smc1/hcB4+cq6eCNW6MNpJx1pueHoxIohgm25luDIjJ/NaRa8N73+SFobbGxLFGUPgxEq5dHzBqntZWdpGFHS3dzTdqDU2aFtHTZ1/t3HyTnF1eGFY2uNEuliJIp7gxsT5AJkYQSQqPFZmmk7pJJBeU4+He4h+wxgWLLuArQrF53cY2mEC8BDT7zGBjl9cQwfgInzaVKJtd1KxSC88uudiiQux+GAd/roZEqvaAWCH+MrE9gq4zqsZRXoG4YDW9JuhIDifoNqy5FXRUGNcd52NHVcxn0Ikb2gSbP9A+Ko+BioSZGge6iL0eq2QTVQ0szjAqwzgIVzy9XIjdR7I+ExqgFJ4MZ3A7OSP1zhfdHu/Z3mxYf8znQw7suB9z/pFOujRhoSvZgMDISeEYj3qpZO9Ms0/I7qbdPJudbxtrNQbzf7RgfzbHfrVz+Ez1aMQTeEoHaFx6imkM3tm1ItaKylcxzJ55bl+k9qVYa+aoSK/hVOOaggRlP76JEI1GfDsE4VU+KShCiMmZeJQ3IPUztGep2IjFknqRwtUTFFZehKf2EQfwpirvsUsgqULM8vtGSp64MU3ulsFzLV2vkwrOuo6ZSB3r9UGjQh2r5XTpvZSdiJXYe0FeYTLNbhcIJG0fhrrn4hUrttEuBYbSljaUITSsSgqHSR00Jxx37TzPwj4necD4hAcWVkS5KU0SsXeZcTq019gptPFMtSMmqqTAORMas0ZpYYNyizwADriSCYSV2bDp2LqVQq61ESrIwt6xKy+LOzyTq3IVP2RPCCSzIHRGp17MxkPaDNGLcHyXLo8B3+8RiOvmYViV06xHX2E0V+r7LFNE/QF/IFzbGJ93ADDyhxguxLg3SUvIhPgBveDhuBEor55tJxe34ReDmdjvG0jRFrspGYgWxBUrmb12Oy7UykFn0SHcMKaNXmk5JUAay0vcS32JuH21u7F9pYlnzH1Lbm6cwb8JdaEWlVoGJ5wZdjUm8XB9n0+0LZ6y+8u6EpXYTcV20YzKjFYKLraUOC70pizUdXJxgw5DgF2KmC3rsiMwgvfgTO+/IMnbDsH/Nv2UXlFmVzWsmecaj67NZHIhqXrp/FIIk0/KOdEAbXibCbmwzFXCGjF3cV+5DHWvHa6kK1XIdkw514CFxFEFdDR1i+K6u8ke8CJlnxkikbfwJcFpkxxDAD+IT4i7aNOSfvfy2jP20nMJeqL6ytHnwSW4XU7pGtyVtaFJMQptKuSb9VZCPTXOZumP8L5X+89iO/RTb5BoAFYQipK9ny++d97LKywt3J4v6zvX8MBZ/r3WyVNVhDSXHHGytoTbWom3fIXe6zck6Id1ig0wwUNjgmMmZv9qh76hlhs3u0dKQ4KLqr8iP3WY26CLiDK8u/5F2kWn1DyUZOWY+PeOjZLfXFMp81hMcYwr8kDbiTRuR6QU/1Qdp7zWeXKjslG5rNKJiEF83U4vISITauHv9g094Wy8T4uPyZsU/gzyIcjuPdOw4M0D+cucM8PF8En0rABrdCk2hiQp/D5j00Kwl7NNAOaeVJwDyfBuZDjAuF1BXRG4C/LcFO2LcV6cNv5wWXC9h6Q0tjjVzUFf0O5L5ibl3fFpD85RknMd6ylgxVpUE1jzSJ20iFrpkCDnZQ0iIB91CTHXAEoaOmqCg0L5bp1ax9JdIAvZiBcnoVw92ViHyj2HtS4yzIvjAojHKZTLEXZZY/5qJxe4wG9hzzvutz5lXMHukVT8HrNEkfYdKsFfpPXdTZlW4+ZAEhIhjFlGzZSYKM/Rx04zJ3oVq9nnKFkzKm4DU/tfrPxulxXBlYLRovc3bgSs/V08WPOFYhYe2aMMXt1TcAXmiXC1PmYP6HHgmSR0AhdaeYfcNAXyrXTsU68VC8b4QYa3y1Bk1osRKHgGWUBSuOBsYEobpWgrZrjvDEwxEMa6k6JzGEyz9ub/oDaynjFp1Sp60HGCb3H1HKkeRNOQr/U6fSixZcBmx/TCwpdkYt4VDRo6ceRNTi2dK9uwAltD8Wox3gT0xdKiGMnA9N/+7sPFC2+dI5EB5socjIaFJj+tXt7MUW0QtXVJGd20Bj8wYS+HDOBUvOimF+lSRngw1W2pYDdS11FQvSKCUUyW+XiYjwXJkDODncStSqIoy0um5XUc/+RImrBEWjAoUIFgGO8j7a/XT0zywEznQkn01qpmpjoqNkM04PkGJuAGcsI1flwZGN9v3tQ/LWvWEw/azmOWLkZ3Dg4V3hD5WuTAi35Ebe1fX2MrLBcFtKSnpY6dwi19D/oyToJrW4IfBXk3fpzmXHA/CW2LhSNfpcldld1+7Yo3ELi57aD/VMYBQ2c7e7uD5zuD3Z3d5zuaXIWX6SvAuF/e9m/ySZ8t6H5e9H35wGF/fwdEHAaPFl/3hjdTMJR6qG6/7hVlicViVe+bepSCzdFHUD1iS7/aSb9RR3BEfuAUMTVoEFjnj42xdT17Gn2Fc9tTseMQWfR3rpEPrLMQdDemh6L1aA0PZm3uhG2UIMguHUARN8DmsdfsOyTdMdYU0ymcg5dTpl0BW6J4Cz3rex/OZuNCk1IRw8J3JHMBds6EwMgPJKHUApRBwmm965DT9AZbEill0eBTbtwP04SWSL5VQb9tsqbBsqehqkU0zUKYSngdKsPHsANLeO6QGLgiYfSMuynaa8ciTGpqZIUZYrOdnIGI3gKpMJayCr5wisCRV8zgiM8VAXGDdY4pxaTJlCYVDe7otM/Jkpng/pd1czm5hE+2kPQH+BAl3A3BSFCOtk1XRsBLDLUG7Q/t7w0MaDt54cwL0E5YvkAeFR+V9vf5EdrPOb7AHTZX7AakpLPAXrSRkpTRBQQHsZ0JXDCpxf4YZHYD7XL0mGAHYvCbd8i001IHsp3D6areNRT27GlLFMV1VvaOt7rYPpvs08j8NTwIVIr19ZP8FiuE+oR/f6K/ZIsV0biwdfPlwq0e/oZvsgm3o+UlvemtrdPIAmqLYsX2+LtZcAtk3jGNobAQo3MpuB9UQWCjWBQQuNR+IdnacS9dN6ItNtrDq9Af6PumNNteXiBj6eKhx8hulIOyrKtixDyEQF/n5Xw5TStp1ryd/Ka8xwrdLQ4mwP/c5ZM77h3nggnGZbZ6aoStL6oWB8MmmoLjZbSBBcdW5F6CsEJCVhHzt1xFozBvFLSUDiH3472jSX/VbjLHnogac1qe65YeDVkn9ZrJiS6MtmgrdspYumIQCDuQuaQ7fsegYilO0R2i6Ah7UHM6lKtczBO4aA5Rg9VDr1Fm22QEZ5wC514m1dPGFnBIyTfuwaqn03KyPvRiXYmO4o6w9yMlcdf1XnSBiilmpacI4q/RGiKnj0WHuWM47HlwQ+OjzTDEQHwDrP8j2XXfIA483HzK8RB8BNofdIfrVoNo18bzrkqlRAdu+jSji+QL3yQ1ISKCySCHcI2KxXAkVb//+3+5iiZ+y/jZm0wx3CVGiiqeVgAnL+boM9LhAHlDBpxvq0lXRVIA53cVekMNXLF9phbqg4Qu497L4WP0y0vKYlnJLyJKkFZN8eSQHaIr52GXM81YmaIPBwFv56zJrAXLpXjoL8r+rJmrjsndjeWobXsndRUdl4Ka8Gllk2BUYC7oITPPgsgzZ8TQi9ymo2yFZp2Dowx2BYFhCLYOijP71GRzdfVvgtjJSG9wyN+34bUhaoVgRvPcQafou8zXKFPeUCroCPki5vDZiGpgiOrA3SaZ1BeoC58ssGHE67x4eHP+simFWfEvpa1bQJvSUQGxnUQBuvBLRUJhAhjetbZ4n6lWIDAdCVyw5YRQgrIIrU2kmn5lLLXOOpgjp3iIEEDkU4zwr3wo89F0yLny4eh2iBPMnF1QxL+EZlCYyGhaazaAJHgQMHyLzDULMJ6Rp47wSCi+Yg7B2kSow9GfUxW/97gaQgdB1bcPopdTIsjA9jvEJENcI1WAffGgJokMRkVUjKl+FZgPDwKozgQzTskxC1KBRtUBNKrB9ePHdpVI1EMv0j8URQnFnEAJcHe4p896WhzHdlBI1+tl8mlyvgp/67ILGgOBM2sTDe3Jct24XoaXV9ckRxyYYpypJgt++hvt6ssxda4gZVOj7f6CzdYIf7Z6IZr5CPordEkZm+Sucur1KXtoGFXUdP9ThgJg6Tpr37zWZUpFMUr6MwI6S6cLz3LlfZDag96wEUaE1eZU5HwkrBDHVxZt3R0KQxa2xOkSWH+hJdRINIJ34cMqW1ya8ExDGA60gioT7yhM5i6GsN9vl7hc+WQb8bCAjxoeMy7ciee0oplFObR5Ne5TVAPW93YBNzkOmDeGNzlwiMPrK+eDpowiiy97TGUGdvHJAEZ8EDoOvQB41MChjqRteQiVDybnKvmcLFS/3uYqpNEVeSrNnFoUl90R4Y1uWLs9si02cjassyfEFK1NQ6m2LyJFoES5jRkcbi2MEUxXD7usNcBOn3GJ62f4TlagUoTzSGA6uFkzNHrpwOLebRlWEzgkfJKLrOayGveZFgjw4mM+djHabreHJhRPd2OcaJCTSpcoD/OkXmlsRcGsgWllDX7yyFoY4SnpURXTBhMQxxBKp5qIqhP90yhfS9m4SskFFPzowspQ0shSYDUT80eKVYNXibsejEYSB4TeosO+pZRbC3keuQRd5z98rppzrsM7rj8LM43hhBUkgh1bhZBk/cBDgXAg6SyQNpLJE4qFRCznjp7RzZCATXks7pazmwI8yjpx4psyVfp3DY8+xE506zwbq79RUIcwo7oRhmwq9XD634vJauqFrf3XDK6qX0mvyG1VS/gctzZIcbHEEIwUXgTiBx9X6YT4hcYggcMc6pbo8Nw2X+BLiv23QXhxkR1Klw2uZVC8mdyTpsCwFTmYCiMlXUifaWzJxVa7CqKfIrYbhNN0usU/ohwJh7htsfYzjZHfc7NQasVtI1i1oQ6RsfH1yAbJmyhcIpRRBCTe3ttbfg2E1uRYbYPXi4M2TTBVB7PFaaI7HxagkuuKZ4uzfQ6C7PDuiixnnNKSbjXGBx4UX548RSAQ/YWB9ORmyYfPNp3dhSZg0cigbCycpv4smxF5nwTvfF6bOVbFuGKsmXVTqDij4Teg+nJRtFrFGWHlQc830pl2F9FiePPg/Ji61yxPfckzLyu/x70fuNbeMxqRPWrkkQbdtJB8tkmyX+Y1F6xDYmvPUJU9qT0ekepGnSqSQ6f182ES7VHFMS0xH7VzG2Adx3C85bM1Qb4hmgqKzQJt4r6TqkYDb7HxvsXVN3dMjcvcs7Z+rWk4byBcKIngUcddMR713lTcmOY1yRuQ31OX/iZrHLVYRCtyCCUQi48LGZu10gIVqnKn5nMYmAmUax2pG40rvJvlhOfvgBMNY4Qryb2TZuFcXNE6zSbp6CFSf8mNzhZMyoLDtc8Cd0TQyTBaLoph2pZOCR0Xhx0TV3lbCJ0SazNmAfGMzex1LhbUGZXfkkO9+UKbuC0o4UiXgAwwZPba4EyRU5l9Fm4GU3JAGoFKZTDzJcHbOO4pKht8AqWd/uazGHYNR8styJLJPSG2U81703yiyW/dEJL/JYaGlhPPY2M8tZaP1k672wJzgeB4h47q8pN8AhZpcw6NzU2dvjBX4SpfZHhtQB68E+pFUwopP12R1hAuaxLUfEQJMBpbjKD/VQFS2SWNVxIPEKVAIzTAUG3hrWnhMboeGisB7UbGUhVSQSFqVxbKbwjWZUrlJ2VhR6MoF1tnNpvJMW7/a/kFRWrhZrPfJWU8nWvXuCX4m0aGr/VyOudFlU8mlJ1dD8/jA2NpIrGkDdZ3Gs0isHwKiZ5WJBUIgc1fXveOBXtmojZmrCWMgug4jdLA7ZYWZSEylhLeRKIOd7qFZeV2WClp6pQvAgduv1uCxQtW38RLeFvd4Ymf4lVz3rBAN4oYnTBUtp1cZRnL7P/9v1QiN7FYExhgebMNQnzHYcx2JjqfHT7TO4PD/aPjNfgq5BqjqkOEWn3B8AjHYl7BktIXXNPelZMLD6lix8lVMiFLIYn2cPXu7bSEVkTHkXuyl7NP6Zj5bt9nn8rpksa+guOfVetPl0E9Y6qsT5Le0/Y151NbYRS7eM67jJQaxW9Vk40gZhxwnq9jcYSG65PI0VyAfS0jggvHYKWnRp+ujFqwxGK2l1rSaRGHfE/Bmt08sHQOAmNOVJow5owzacTqq15tziiEAbUZ2jvIP8B7QM5GtPMlZ8PFpY/I2mAENh9R6KNFE/HSVh/aZKP48XVic6RcOMMPfPqMg+nxj+XTMPQWQeH5jKRJWm4nFwvuksBYYFf5Lz9CzFyNfcmsVRXd1BZZow2/3izz6aIPZ93HYa1PqYD8tPCMPB6cwe56LYmDad7VjtNZsYpwZ1MNqbbhaCwzlXlyLEiOxAl6TLaJaGR7TdB8z1ZN9FqHrgXTeJMW8JWZiTo3qgkn+P5kxaFFhOt5KNdAEr4ePeddUrJt2ULICu8rwiWZ5lyY0pkd1l1rUbm9QXFjoBYSEFzpAwa8Lp/ylN//asGJuA5i5s6o8l93a825cvbY+1ffSZDrLgfbC1UNKBiPXNdk9ooBvaEoRi2NqQ4jVUA0UEIarwigkKmLmF1rmldRG3jE8BoZPWXTZu9MHt65gRwhoLALJ0gddknqljnUx/wGAXsUeUcB8xQPEHv0GxKCGE71yPaAIiXwnHRNTBXMurBh7KEudepEi9aEeAY3ylGa6mUtOaoySbcYW41//AUBp7XHbO4gFoJ1mLL/YkSzdL8t+tMm7IzNg7xiaxSkMYuDzjvSUYgU3P1ogweiVH5sg4c9bPCwe3J6eHB6+Mgeqfsnh893j1yDB/f4L2zwMOhq8AAvKnoz0ufBUmrDF/O6D0uW6RNtqwfsuuA57oXa//GNH37SvqlI6h+2eIC37G9A/+3+0wHm4jRe/xw9UuGHYiM06+RLwUvHXi9Ca/6Y1g4H8BLazAF75Y4xlVpiRLTPD+tTtW8f7yl1efgb6OlwcIQdVX+hP//XR3/Ot+5YujiDWzP6+NCnSpdop9sBXJ4r+lLymr8UtrSNDxTvIXB0gB1ts8SOp1WWH7OMUkGCtuPSG1KYmK1y8GnyKFzTMgp3wqlG5Yq/yMaC6oMBqVULMZvjveXh8d4jSTnxfvAjlnOMClH394Tq4lDYCX8JWsUpQa9gj+AygZuM9k5WYeMNFmtULkPWE64IyIroI4iOIZ9RlGqRTR+2/8O/j/YgODzc1z68h5v2/sRFECigwx9Kxb7z/VrGOY7vu6olkbZq8P8kFjXi692gAuOsh57uq1FaeJY82wHlPW7fwn9GNOtjBCBHJ+W7ruucDlpzOuf4QqaciNSlrcX7lMzSiqo7ajcXCUwMF+WQj6ublpMirUfwF30pmDsTdStm0zSuTZNJFGiqcL63PMjByw9W7HizjEwZCMT6bTS7U4vPQWwJKC6OneDAIrcwOqtVLcJ4Vq+xqMWFOVLlpvrtFSL84BqOMqnSk3qO4Mk+DR15umMDX/H092RwCWQ9m32zPSu/2oF/cjkZWuYfPlYprERqWkqCk4AAHQyNSUEttoZDghVujYADLT/SONFpxS9n86S+BzOymmASXOZHritI72UYoCAku0v62Dwxfxej/Vrrzr+SPaSgWHSC63smvoe9mX7Kmm0TDfGErujZTY2hzIw2jNeW8HYtaLKrynbZUDBVQFIwVjp65R1PcHd5QntVpW2obybFZdO4uJe4u9+yJ7tFlOrMUAY2w0QrKduxg9i8NuHzDCtiMILkJpWj5ch5MG/ae3RZWWSO8pdm3qemV7jL6RhDv3VsTptwYDmYrmkwiNa7F2QWOGSqWqOtPgOcazG6wyQ0OvYYGPJGkQn5SsciYWADQZgLybodibcwFAQhawN71MSF0oQfB3Tx769fOycaAWVOmoh8bpA40EYV2YKgpvdg9zUHl0IkCScI6L/KbKLNdO9N+aSTmSFtq9rbtr89eO7UGv3nSfifPmId3Etu+Aa2Tp9x9dvzu7mkDukh4SM4QvoDvFdtrgPDhPU7h53f2XPfOQjnxnLkRbNvmyS/hOZpikEZ3C2hphxn6VQzTiB4Z8uZUDB7NPK2e8Jex6T2zKQGnd8ZuO/sdn1Hv8GbYCxrLieFU0q8ME5pvsTMYn1nAiU6Au/blco0Nuz0w+OO5w+2T0BdyJe6dgm/1NEaEyzBR0VOdvu7J/293WT3+enh0enhoBE5OVwZOTnafb5r+mLKs3+mvphdvoQNlcAysHzsCI/s/tXCI+It/3XjFfyQDQMLMuw/d/vHPen++JN6Keym7smJGM3qfpF+inuo8O/nb66St+mnfJK6oIvxUVujRN3TAYY80D0NB3PcimPwKQr3Z7SXpuKIc7j7QbqCY8U1qR6KpzviuXyRNYG3qWkCSHwP+XQrQfQtE4+g7SeN1kFRYQ8X//h4D7vD50fef1xlORscuzIdixWBCwXn9hM8Tg9PbfpgSrvOfBE0EsPWymQ6klbnTK126PJTjjkXP5+TG7PTzROWRfZ5LrhdrVdWVK/rPyWPNJxyP1xGyeuNK2setETEnNlxqohC/RkmejXCQN1EO9kbop7jge3B2vacHYOwjSlhGAlhcmy8je4sDwMl+0a2z+UjXcNmQK70dEGZ8Q6fnl9d7fz26pntWO5nobZD3H1YdYT+GT3EvdVH72/ARdwzXerDzr3NScariXuOlsWS1fS0rjiMg7Y79TYf4qCrVfkRpafvj0pUHGBYBJng88trtqDu0nqoXd+VLTL+vg2P7m/G09zb2K37GV3NwGc5CH2WA+ezdE47kD809z/+JxRi/W+oWh3BzH/k4iAPdeKsJSk8xsCw04WRq3ZGEvFvDG7ODUl70iOHCTFePfL4BHNYLYsi115Qit6iVQRt33979j06szW3sZTY5ly5zuE/2o+3nUXQ23wit877iVJVnY2jq8uOANkDYlF5JKEQ4I0zEszFcr6NR/MqE+iEqvzt2ZglmLb4kq63JZ9I16oJ1Y5yOYrq2nbz8BCNR/me8DpuKaiwMhGimTcPF1dnb0DKT7go3XZOInE0mg7BDkMTY8jahq5z06E9UEd0hUN7oN7pCof2wPWQ0f8c/HUd2oMVjqif1PNuf9aNc7Lan9UexVFv9GClo3nQ7WoePtbVfA7/g67mwf7p4eFjXc2jwNU8/BldzYhL8LfhZYYJ66OTZhIeTW1vU7su2Ez6bI1L4zf8PKn2f4Gu6+BwsNJ3/ef0kGDL/gHmvbffWnh9KL7cPjnDjwcYpHiq/UkDt7rhVePKkK1gLAolGLfh45CORsM13GkCV/i0t0+HD29v5Q5411fG2dqv5IvVX8G1WPRv1j8rq9d+pVqu/Uq6/kF3a14KjvWPd8hdun5Cf0pXfUXuOAs2JSKoN9hs/JXjt9FftR4xWL+Rg/UbOVi/kYONNnKwfiMH6zdysH4jB+s3crDhRg7Wb+SAN/Jwz0PCCGrX1xsuHUD6bKIVoKUQRqofb7DbexgwC1B8K7d9b/22763f9r3127630bbvrd/2vfXbvrd+2/fWb/vehtu+t37b91Te877PsqYerN1WwvOkr0nTYGjvNXz3O/1u65m7fNTAUuFaz/XDwVdfy1fjEghFENgs9fLGWTU1dUt3Y6Pazj7P88pi9HI4s/uDXX0immfj9KEeCiC7YabIX4eSq3Of8uPhtxSlkap5YwLAJwQKQWdkOJqHn4gpUfdnKX2yt6uzJcn4BrE7anbQ1ZvpX/ZhSmfjT+jXjoO6kjp5Yzr/yZKlo1tG+O3BYn5XgfKHC0idU1rfhoWf6Jfh321X0chX70f8VSfMwXDESn0wMt3CkciYTvu5//OefFui3l3W8d5AF8I2M4QfSSBalE7lMjmC0g+RYy7Dwy+1777WDJMEX16oBbqi8sH+YDGjbdm3G9U3lQA7gnYBnza+o3iEaZ92eMVGt/pdu4H7aOLzBmIwFU6OWZrGM8xWorV2X5Zi7Wbhr+h55lPze93f/fZG7jT+271ZfM/39sP9ba5HZPsPYI3QiGQOdTtl/NaO+0jHaJ6IvZNIbq/x3PBw7B+4X+DhWLF/4TnZ1yeZH2DVp5yTjt/ikfkHWua7tL6jcWAVnj8/fj7eTQ/HN/s3e+Obo+eD/fHubnZ7lO7t7z8fnLBYR48X40lDFSFD9VN7v74hVxFh4vUQCxWdGMTcDRUbDfOxSNaDwdHJyaFLfFkZij87wJ/Bsz5mD3pqj/YuR2+P54ur594/hwP8Dt3dejE+R5BOj39IDqcZUfzV/PToePCcp0hSWRyjXQHhD+B/dmV+yIy8rL2ZQrfB+VIsgdXRUlr04c2DgtZP+AQNJTqAy4bRgdOdHRLX2PVqZ5aDrztncDW8Dsx/MayXVJRwu5wOgxegflU0+NHg5Hh/d/9gV7Sxg+R7BcYLk+KNYP3Gq34wcN/uWw/KtwsQX0pFjNGFB/ACiunrJ5fGNzJ9BcNfGz3TNxr62pcQ+OgJhlg0eiJTxOJYVQa0lHAUQLu6s61Li0sX+elOOiJOW7qt9Y5OSML6Q6ScMIoWtmsORxhjm7hwx6ik9w+fD452+b/MKg5OjNPBSdG0emgs155q0j6xIwZfi2RjZRawCNyRWV7taD/+avfzvnR632Gqohp7ROzt7B7sMO1Wf1pOysH2nI0Jb7qg5cHHe55WtE356d7hLhwpWQO5095+6XjZFMMPobWEX3Vu1boXHqA64WKE/8PxsFYZ9jOgXeOTRaNJkWLyh3LJXNw3iFfiQENYxbAQvm6En9K/mkaBUi+ktGRIrOhKWGWN5lU+cgUrnRLk8Ghw9Gu2XFufDxfZ50Vj+9ur0RyZJSXr/CvzgWJ0EhJVD6pY2k/F2OyndCrXTk3HXVx0zR+rbPY3bj9+43b+DkOBi7I/SqvF1/uHgyMOdJ6gnCuy+9SGmeCP2jfP//HYhWdEJLkKIKkPkqqePflDn7eExOBzHyAzI2KElps12QH3jDRjWumqTyXWtm6o8QWymv8BzvzJ4PnJYetqH6MQpg5HjesMH7z2H0TOM97UFxkW9yZI1lFl0kLPF84Xn7Iil+5fhnnME/xFBUCHbFshAOQFVkiA/U0lAK4+Ltbh4GC3LQcxaiw71/SaztzfI0uFqP9zuY33RG7hyCKw7romWIlc09JUNsQX6K8gIXcfvz77z5+31geWBMTTuLE68CRyfzoW55gKkZCRgnKtCZnaHIL0vEBjV+Mq76g9nKUHj2uJRwNFl23w6GXDd1mxaHtfsmjHrUWDMalvS3vVvtc/x1btwN0+R4UWdGrTdcKE4TT7zBljcLlJxCL0FRst44Je/uYyfs72HrNggx1YM3qPn0IRuxXbPdprX0Nbdxmu2LX+OQr/QgdT6G5r6ezDQQrKvSAhf07thegeMiYjwatIWtphWbYE3+VpopkzjrO3s8zqbe4m7JU3VprdZdM5QT+WxCY7W2LjEIu9WM5+qv1gZdO5HydfsB3wcUSFmBrZUIUYyze2JQfwFb71okLusxvWIq6U2vQhJOh37Pgy7G4O23OHeXaHv7vm8k66R1scg9kS02tLSeA4wsC8BKLwfgKxe7yze6Rfow3Yrj+11v/gsLkBu+21J38G9fqymHIZDid74gYpfO+Dfo9Ytrpug5hM1gbce/58lRV4fLh3stYK7JpAlwGITtAfshR5J0J3eDPDD1798Hj/eBPjDwMca42/we7JczCU/hLrb9Bt/h1444wJA2jVxXYmZUP6DNRZn6kP8PN9NRzll7N0Tr87iBqUYKzz3OFYilbJT49kB2xQyn14/Gt26en5+rFKB2sd5qd4PNCr16mkEhPtc39tZ0mg+zrLYZkWWV+VU9+MQ3oAd/4W22ZjpUY/V2KXn80mppfbX3GX8OPHXqHBwbordLz2CjWe+1e9Oc9/4puz+8vN+bdwc2C8Ad2c6MXBT+kAb35vjtZdm/Xxh/Cpf6Vbs2GgYfMbc/z8L7oxu/+qb8w//0HHOwvGGAIl78qq34zYt+0vWNzLqkzO6PuPML1W643Do+cbmF7tZ//z3oKNwm3Hg4OT3V8Mrn8TagNnsOlNwpDaIy/RYLX/ApdovfEVPvavaXsd7P6Ud2jwfH/TO8QAkNWC7XgjuYZFW3tpE8S5yWbRKw5OjqOr3JB6XyxQcGAXqhly8lPAvf/wixT5FypFCALUfJCiphr7afcyVldq8rvXJp6ouGkbZowF9XdRlLhu7wHb2DTD9rgYVURc8DpCNUvMYJuQl7EA2HZyFqRWXIM3eCY/UvN+1AVkQfRRFE0ri4yZOLdt7dE4/8RkH1/3qG8dHLFZVvao32L2dQ8FYz+d5pPiNMGGpVn16943X+V0BJK6Gnn6aCpwrLbp53QtkeO63BkcHx3snRweD3pIx7C4+7p3BKIvucuwu+zXvf0j+A8a7YbiYl/34L+pGA7LWpg18ute4w8wgx2eAvwLvAC+x93BN+fv3ly+fnn9Mnnx7vzDm5dvr8+uL9693Uou3/3w8v2rD6+RL3crubrAb1Gj4Vfv3idv373tn7978fL9lVQ0XdziKv7TP/4PZmLHqtEqzwj7hZw8kvHHAhz+GoZ55yjBkfpJmzmVM/jLXVbUGFF2TNs7f4dpimE+/vpoz1Fm35b4cr1v5CzAHJH+miqCXBz5NqcalUWaIzHFZJmPiXEnNvLB4Hh3cNwaHc6h6UW6hvxOj55Lr+CMTNz7NCy/jM3i8PnBYL81i3NXKeRyFsQDAn+aBsx8NT4x7DjR8ZDBpg9pvnoiNYUbP2r3qPtR2gkRWZRBrxIT7cbjPo+Pm5n9oBbI7flK7SXxcW18FJBU3R0xI7+S2XJ0B48a3RVUmVwvlre3eBSweLj4O18Cca1FZy0KeYtjaT5WJCRxuwvwxMssKqUX4MDCyjyTDcDIv+U797JvW+7/h6vrd2+SVxcvX7+4ost9/u7tNciBreT67Pfv3r5784fk+uX7N1fJ2dsXyYcrf+ed1G4JbSXlLSuh2X86y1KuNPSTpE+2hJXGCHPNwdFNe7YV7mfteLclY0RJ4DHWR2ql5EKpK8N8sTth8t5n5+cvr67oZd+/e00vzmsgb/eBW9e3D8jh7sHuycF/FCukuWGcKOGr/xBDotiMttLGRRLbaBTRu6LxIrma+/RhyxEqMEc91kQGtLambhSvr/TdoHG5zBPP4APZXK5XODMu86Li8X6F3bA+p3ispNeRP21pMkONVzE/MZyzLUfk4HJNjTdm2kDzM+maeKtNt1DHum3l39ecGMwr+zsVuuYtZTPfv3x9cfYtKKirD5eX795f6wnl5KEt0Zbs1pyLS/9USk5x1aXcofRivdPaa3PrbSKSxIRPZ2qKVL/DrXlwg8i+WFZeO8LEMNGJBw9XfJxNc6R5nKBgk0uNtFW5NMkYlRUPFbvKwSV1yT27FClRPfki2KClVENZKaMh6Zw+tYREI8cUNluRLX8kUPSmXxb+US8wn3pR8X1eI66a+6A8i/78XOgpNpkRM6ifu2azq3/zHhvR8vVa/cUXjqPkKpvCvqz+9iusUebk5+ovXmBC1SxLY0fTpCpvlrV0Bu7DeuU/yvEQGlSuOo4v2wssjvVjm1F/e4V131l/no8+Zh2L/nIGttXq2b+ldnyrv3N5BxJg9VeuPsJbr/7Kh/evV3/hDMywcvVXvkfre/VXXmqfasLFr/7ueTktK17ANSvAPNDSp8RsCOPCeMsvKeOd7MDJRUkcdh/zeNdnoZnTbpRKtAfSHj7FLh3jhlbuY2kKV6BvoZ6RniWjqqxrW/nINPnFA0M4sJJTYOSJpxObPjD7qzwZNRfoBn1vbhbluNn9TQwl2uW7q+vk+g+XL9kIEbvk4mWHJQKiPccoU7aIEXNboz3PjBkhIFHXBX4hF026mTjTQ4wpKW1xBKKo6uhZeP+kmSRxHTRkKRHeqBmArQDlyyFBiBAe13XJLpJxcW0nwxYloWu3mlFMYhw+qUFXK6gnbrOoNkhrSOVshqX+9sPF6xcJaFtyEs9eg1943bUL3M0jmeupHbVObSJFe9GH076wpxjsJ4gK17GKuqt2tbDi/WKrZV7eZxVYPqxE5XC9+fD6+uL1xdvvPsCLvH959uIPoc6shSdk+hCJPJgTIuhhJJuF+dbcHSEJqkHQXnkglmZccIIV37IRQJsZWB+GF6BlcSBW2JkXvDjG0nJ0MyaKYYFXqIR59tKBXRyDJlpIbbG+gw1yX1Bwa4mR1p+Fa7Kbr67PvoWFvG6tH7bmoeavyW06wy2Ef5dwk50XIaDxoeLtbDmLaCxbnBMHCPKbPLQX6/5+G6Z2l03K+qEmXp+YJ/WuAA/su/KKv8KL+G5ZufJtOiJ8Sw53d7d2d3cTX3rP52ZLW8349aoJsysO2PmbK6TLRsV+j4RNYPQpEwF11f2IRDjESQyCl4tMtyzp1JZpaUxEBUpiQS3JELoFtuY2VbCVZuYTjDuAeTK5a4RQFtqT/HdnjfFAMD/Uea39vbQZLhnFcRK1g73d58yitu9YOL6aozH7NZHL9LhZIsP94HJ83RucDvrwv7s9dOHBb+rZI9XXhelpHC0lGtWe7O1/9J+nVZ72uUnM171FtcwwkJV2ExZ9tTNX0qJV09uD6e2fwuxEZnZ/QemFWo1tyc1H6xkv0bn2ecQCwBbnNS6/PzZnEpTgOA7oCKSMaDi6Tcb8lWt9AHM9OD3uWGqkcehcZ/5w3SI3WIw2WuFDPACHp8cn3WuMXzk8fQ6LHOlJzr3XiPKIsX0cWiQ+5kbfVrg+3OVT2mUTt1qzBaI0XWN9RP6P77QWkDZvME3TSYcnpM2CRWHn1FssvVG+Ma443XlJyYN259PWE4/giUen+7t7+khSRVzuwWx4jkOxq+83RV/C3miisJ7arvaX2tb42XbygbpcgpTaou6waS2kTdrdKmhXREGV+7uSO2H63pgUJpSeRyCspJ8TnHvufQELkqXYB0kbgvsfIc1QhuET3LGA5w2ez+2LxdoiedxH93X1Mh7DMh6fPj/wlzhlrmcY1DfOTsblaEmVN7S+3ACNut45FckqjSMtavGtfvQJPBr+d3Dci7Xd4qt/NUeKu7ut5BXa/XccoPkOufQL6aXKTGutHxLImtY13lG1NZvnMBv4391BL+xNko3BZxwRzxbRTuWF7bnq2bxM/7xWzxqMvq9++mAXRcHu6XMQBY5t0TYhQ4ossZfYd31MN5I1rz4gRYSa6EQvk5ZFrOgoS9v+oOxjaMHQF8iYKZD/C3Rj1ad2yXQRm+3H29NAfYL/Z8B7QGcRyXd62J25ym+WC7PWritoT/q9ER/j+9cN0507OUgbBmpsPc+oVy46MfBi65ZmH+e0Txck2g/SHPvaBWapa1sBqo/WQFrnSvLjD2UKp+Pq5Tu4+GxjrJkBai78P3hPXhIJ5pjfxFE2itBY2QAzr11D+bH32Gz/SbLV7rPpdM18jNJa20Ceu6WGTYpde7NI6z8lJ/ulg9C/wg5CusWtnpxe4N1lwUNhyVzrz3mJVws9jdRaEE+1jwAaNdzPWnuuYvbkGYmF0OnVUg/NpoCdmkv3AKowCPvYvUmlpR9eBOSC881AMWyARhddKBYE8H7c26dOwV8/Td6CP5NTvz/L6uWiS5gTKPBt0TIT/kj8AIwG5M3iJjpuwuS/5/VHikULFyUxT2LjIDhL4LcVI3Cir8Re5tiSb8sLQnpKfnYieIyxXUsXa1jcl673M7vP2MQzndj2Hig93YLw2VUWWTskZyoW6UOjrzZZR7KM+pbqJMbbCBqr1zWeNw8H2cas/E//E/1hyH94JhdRdNQSTJaKdDk8iDoZ4qTfPFz97nVCorESJVFl4DEVMjYCO8jMmaIDjD+XbNMMsQbc71Suuu+jrWqqdWp4AdxpYb5NySV1v3mke6J/xrdVmY5HqFZMoCXsN93hFdz4X9KGY4ROEmKcTBECa22PGTGBpCT8FqSAu3bJxYv4LtJr71A0g5wPTOmkwUu5qRM76PTBH18ceMhx16axZxluLqXIKfp8Hz0wS+i9zsPtoy3TlL7Lb+BjkX0eZdmYQ2DUyctpf8SjUFsPuGt4VydikqcJ+JX5j3gYp9i5tPS6dp0OUc0RCFlRI+hjl7VmA0XbrBaLUbnc6rrbKZfbMlXkfXJT0qsnyGKSFWOpYWQYW/ShBysf6m4PCyw8b6AAF2gDq5OFg3z2ZKpmOd1I4eWhPRdG9v3tQ/hx6pJFTHVsz8PGI1LXV9tfFvOjSL7vWd+tuvjyh1zfwyF7kH9gYphzC1U2IUU24TSXHg7s82obhwXXIeiI43s5100x8edlLu/l2jx1H6P9rpbboQ9JJnkwK2uooHc8Eyau2u219hoPz94Pl0PeTSRxLWrH9yBEytROyLffdVzgtKyb3j9VX2IzRCIniqkABcvt4JVd2X+KkbDggWdjF6NQueThAPjXT3mt+49+VTRkg2/lyloD+UAbZiMpm0oZZ592+n/EGj5CbMWywHUuOZ7Kyk0MaHbWK0oOR0UVMcZSrzxso9ieIyfgHqbi36QJeIALdiI8Wkca2VGGZkMLLW7fafCyNYo8Qezs/Caup2Prick7XrzgTpK3HLSxVk1DoSYh7sPFonZTQUzpNq8wk40A2WIU63l/EGkg4VYTzdOITEWxmpENOsWG5ZIDimyIKl4lQW8cGFw+QvDMPVEAXmlxVfNJTm4FvqSjjFkplwIa8DRMPGL7FAQI1FKujW0NOw4RiRXWwWQuhLMWinvyxSQYKY23WZJHF3kQWWTJdHTaaYhzgRXxEQDRWrW3erRfKWed7DxVrXRfytg8O7Vry/xS69+lmtqdl08T4pRm3JQ3LYL2Cuo4sMfCZOfNzhOuV4ZpM0f2SfQwdC6pLKdbRHSwjSHo1pRD43yCUAa89Jaw942CGHegtlwLz0B/BV+9Ni/ng1EkvpCrmyj5+QyaSBaL+THL7h5BkoZvz968PGV40vD7s9cfXvbwwT37h8guu3ZrsY2OWBHW9mj3oNn3zdU2CcOs3SZNwnGr0bL8yC0uqKmKjHiTT4bMioDQnOHiDiYHHrCH/QiXdnyumzRcbLZB5SsVBqZC601PD9L6oxgm25luDIjJ/NY1xoD3vgGx5mmmRibNxY+RUOT6gFHztNr+mnReWdjR0t18o9bQpGkRPX321c7NNxh0dl2O6Ea7WMoNpwrixsT6AJkYQSQp3F2+naYTzYb42CvlKETuE+wK/vAprfJyWXPRQO00c+y5ZPRJ0q+PSmscLK/CMzBp7iJ8ivOEl7YIg1CphWeXXGztjGv2wzj4czUkUrUHOqAB6DpTH468AnHBanpN0JEcTtBtmJ2Tzr9NGMq4eOIngpRrKm5oE2yiIJp7ceH0WYZiJ69nZBVXGKpaNHaXjlsn8oFVsomqBhZnGJXhjp8aOwChJ3YfyfqMoooYdK5Bqo6x/gTVu5Lm++M925sN64/5fMiBHfdjbjhAJ10wU3Ql7Xv5UCbHeNRLJXuHclusojL0ZZqQrHCtxmD+S1OPW9D0ZTWHz1SPRjyBp3SAxqXbtyb4hsFslXhY6MM9w5ZE8B6YnzA9cSUVeQ2nGtcUJCj78c3Ox9GIb4cgvMonBUUIEVAUj/LyTksw3Wt1TA+SjVgQbBGvHknuutVI+xEH8KYq7zFXKuRbWfaj7c2DBTP4v8ndMniuXI5Q6DrrOmYidazXB40KdayW06VI7ynOCDeyIq8wmWa3C4LFtA4Dot8lXrFiG+1SYChtaUMZPIVLbSoEmmCG5oQ0jQJTG9PO3HSNz19uu2rRgc0RbysYvNxZ6b3LjHPevcZOoY1nik+wbg0OKxIjgQm7nGa+bCEKF1QMfyoSpMaSLt8TFaMthui0zFo4DoWRFnd4JlflKn7InnzK2O0fa5+2iF7MxkPaDNGLcHyXLo8B32fmpJuHYVVOsx59hTszptxBBZsgU0T9AX/AH+FXwwSctJ7iXuqSlpAJCTVT8HDcCJRXz7aTi9vwi8FM7PfRFKEkXrHgmgJtNEjLiJJGQgcaimdnUU4rx7TRKy2nDD4jeUnlDfIScftqky5j2jCPs/GIoZfcnFYho2pixUmRflc9iDPLFDB8fZ9PwN6+AX38sCUrLevKlGcV20XwczyBqwQXW0ocF3pTFuo6ubhBhyHALkXMlnXZkSCHa3hRw1LNVgi+iYep7Tw3Sdt7kASiZbRC1vdgkHYxdK244xaLRuI7JlHDc9Wi7ehmP1/X6q6RKmQ7RmA3MAGJoybSaMAtisMAB2gRrhSmZmQdQoBOm+QYzJ50TYjcU17S715eI7gHhA9JHXgudWtWfaXa4ylcAoS9EmSo5BB5S6Eh0TQply3ul3Q2S3+E973afxbboZ96g0QDsIKQ/e/dzxffO++FKOi258v6TsVE6iz/XicSKwQ3tdS1xFu+Qu/1GxL0wxo09wI9NFq8IWNkv9qhb6jl5ppOck9F18eWf+rALAFMQMC2rh2QgqNwppyHkqwcAmQLtKdw2N9cE0XyWExxjCvyQNvJJRcvIck4/1Qdp7zWeeYEERmVyyqdiBjE1+30EiIyAbPP1sOls/E+LT4mb7BDK8iHILv3TMOCoEVSlzPDxfBJ9KwAa3QpNoYkKfw+Jx8u0F7OFpugGOD/8rHiQDK8GxkOnUAR7UeM6dps7FpiYpw3lSZ9y4KRbJLS2OJUNwd9QbszwFBMRtPslnKU5Fy/DAJqbbEW1QTWPFInLaJWOiTIeVmDCMhHXULMtcakdgG1S3BQKN+tU+tYugtkIRtzCzML5OrJxjpU7jmstUf6iceZ3mBMzTi5lpVVzV+FWcIFfgt73nG/9SnjCnaPpCKxWeqAdACLICzuML3NgSQkAts9nmK8vmQ8knr91GlSRS855HAVpMCsGRW3gan9L1Z+t8uKgH/BaNH7GzcC1v4uHqz5QjELj1QiCwVXaL3hx+wBPQ48kwLcAslhHHJDy5sm0twmeOq14qXJy8hvycKRocisFyNQ8AyygKRwCfeYEFaiFTPcdwamGAhj3UnROQymWXvzf1AbWc/Ytxx2Fz2IM4LhPmVbsM5g5ZLqQTQN+VpCqrrhMb2w8CWZmHdFKVprchupO7V0rgqM2qajO7IuL17IajHeBPTFUrKUzuQ33/7uw8ULb51jNSrmyhyMhoUmP61e3lBjb0K8l5TRTWvwAxP2csgATsWLbnqRLmVEwFxxWyrYDd9AVb0iglEg1cMwHwuSAQ0d3GjpH1tVS7bnMBzBrXLVkTRhiVRgywoEI5oOfC+9fmKSB2a6tOUuxGey9z8qNkM04PkGJuAGckI6ia8JjO83b6p089aEJGHqF6M7B4cKb4h8LXLgRT+itvavr7EVlosCWtLTUsdO4ZbviC5YUDyujR8FeTd+nOZccD/RUiTIf6u4G2vnt103E+rAii15kIP4+c5gd2f3+Y4mV7HJDgl//Jfytn+TT/psQffzwnREOezv74CIw+DR4uve8GYKhpKrQRIo7zc1tkkfc40wlbwiSwDbJSPyA6eIqUGDwDp/bIyJJHDsIh0GgekDtc4msHFVYkZw0HKpEsf0UBNeHvNg1uZO2EYJguyu+FrNY6/Zd0i6E3tHRKdwDl5OmcSE2qJ4Cz3rex/OZuNCk1IRw4JK3MIAO2dCEAZOEkotQBkknNa7DjlNb7AlkVIWDT7lRggGG1oi+VZlie8UxNY0WPY0VLWIplkIUwmvQ/hwDDuwhO+TxR4iloPoGWWqgmvHIozdW80cMsQGy87qEsuBxyjMKzVvFIEjr5jBEZ8rAgLWHEHY+GpkSpOKRv6JPidLaABV0sF7vaDBZAtvfaW8YiQMNY3GSVU9UVmK6iSKTdvfGxjQdvLCmRegnRZT8aj4qLS/z4/Q0oH4AnfYXLEbkJLOAnvRRkpSRhdwyaQm8ZYGAePEnctM2cxuoF2OHhPsuMoWrTuEsUxNxIgD2c7hmILdZgWyySmBAjHFSxQP9I63utg+m+zTyPw1PAjUe/nrJ/ktNiruE/79if6SLdac6iIXiMnX1cPf8E024Xa0vHhdA1unkQUUAeWwPf5u4iXOxrJjGkNhIUbnUnA/VEVbBCggcKn9QrK14166bkRbbLSHV6E/0PdNaba9vLjNsQ9Cj5HdKAdlWVfFiHkIgb7OyzlVh40zUDZgKf+mvMdi0C0OJsD/3OWTO8SpmmCCcZmtngJhOsqq4ks0xbU0ZJpS8Zkx+0FY1XeCx0PxkSNDnMK8UdBSOoTcj/fKnsA+a8wTUWNOTAe/9MRrplKvmZzowmiLtmKnTOpBcoTwaxxI1JJBxVKcojtE0RH2QIeA5CoZlaGL5hA1RVn0X6PMtskIzjgFzr1MqvfKl7JzxxRY9XRaTtaHXqwr0VHc4X1eSrI2+1OuipPUU8xKTxHEX6M1RE4fiw5zx6jgNrih8dGkF2qt+j+SXUcrUaocP6X51JEiMXuYVMJHpTu8/F2VSokO3HRk/EoM36GmJpTmjOY0pLZlw5H0Qvzf/8tV/fJbxs/eZIrhLjFSVPG0AjhUjySiitkfNWNDJ6fwKYDzuwq9oQau2D6zRjEAywQSuox7L4eP0S8vKYtlJb+IKEFaNcWTQ3aIruT6Egci1YyVKfpwEPB2zprJjjqJImJyd2M56iZKETWqq1hZqSaVTYJR4bplKXQVeeaMGN/yq1uzSk0mgWEItg6KM/tkFJO1abcUsZOR3uCQvyVN8yFqhWBG89yWRIreQuJenDeUyn1Cvog5rI37ysrcJpnUF6gLnyywYcTrvHh4c/6yKYVZ8S85fJRKrKhYVQGxnUQBuvBLRUIJp0pt8T5TrUAgeSOEDCh0ZBFamwi6ErbedUL0zjqYI6d4iBBA5FOM8K98KPPRdMi58uHodkiMo84uKOJfQjMoTGQ0rTUbQBI8CBi+RSbeaeAZSc7yJjNIKL5iDsHaRKgrqaTxuBpCB0HVt1LjDQoMtTXyFSRILYCWOEdfHPbFg5okMhgVUS2A6BoYKx4EUJ3U9Cg5ZkEq0Kg6gEbhg5uVDTS2q0TC4Xrg/hAJztiLCRQlFHMCJcC8rE+f9bQ4TohTuFtxCy16mpyvwt+67ILGQODM2kRDe7JcCq+X4eXVNckRB6YYZ6rJgp/+JhdIOcfUuYKUTY22+ws2WyP86eKekfkI+it0SRmb5K5y6vUpe2gYVdR0/1OGAtTospD2zWtdplQUo6Q/I6CzdMoIqEWOvqDzQWoPegNl7810uzGvLBLShhXi+MqirbtDYcjC9lOZj0PrL7SEmqR9yVMfVtni0oRnGsLwlezwP3hHYTJ3MYT9frvE5con2zCcBp7APDxmXLgTz2lFM4tyaPNq3KeoBqzv7QJuchwwbwxvcuCoaBvkInpihaaMIosve0xlBnbxyQBGfBA6Dr0AeNTAoZIMAv0aQuWDyblKPicL1a+3uYpz3ifyVJo5tSguuyPCG90wWxKRtIqNnA3r7AkxRVkhd/kiUgSafiRtls0SZMBNMILp6mGXtQbY6TMucf0M38kKVIpwHglMBzdrhkYvHVjcuy1vMQgVKHxQKFmR+0wLBHjxMR+7GG0/i67AoLUCq4OcVLpEeZgn9UpjKwpmDUwra/B7xhSLESZSCyemDSYgjiFEAGZc1Yn+aZSvSevFlFxAwY8urAwljSwFVjMxf1Ll3DavEnc9GI0kDgi9RYd9Sym3FvI8cgm6zn/4XDXntDCE1p+FmcZwwgoSwY6tQkiyfuChQDiQdBZIG8nkCcVCIpbzs/gcmyEBm/JY3C1nNwV4lHXixDdlqvTvGh59iJ1oPc/K2nSff0Qm1XrhCausI9CosUPkUd2ITDb1fPhG34sVa0qIrUnYjLeqq0lvjfRs8A34HHc7yHqxEHGsojdUl97obBykVbdEreNqOUHA9xbZTYgkjSjhymqTmxrUczJxCUWyyOdUZCmpR/pMw00u3NpVI/0U4d4gr6bTLf4RpU046m3rt59p2Pw+o8jWHdlOJqhlenbq2Ph6ZJbkTWAu8RkqKBIvtFIoIdomxwIcvHEcx2niqzrILk4T3fmwJpW8WaLcogSgQyU7CLyCzRm6tKSLrjRyBDlPniq9s2DryfOSD59tOrsLzcmi3UEJWjhN/VkG++9ZOnyqm/ZT7S2Gn1nPxXJKqXxFjeYCa7VKOKWGamQ47S6iEfHmwfPl95oVqy955mXl97j3A5ffl85cIRPViCiNw2lt+WyT/L/MSylwEluOhtrtSe0hikz2qdpJDp2W1Id5tUfVy7Qkf9T0beB35goc2fIJnCAFEc0OxWaBZnLfCVqjlLfYnt/ighysu5K+tWFJW4sAe71wobyCByJ3hX3UoVNxw//FyyztdC2NByq2iKLkqEogFh8XRTZrpTUrVPi+SBm3GurbOlJKGteBN8sJz99hKRr2CReXe7/NIry4yHWaTdLRQ6Qkkyx/ErNiVrXPAjdB18kwgC4Ka9qWNucdF4d9Fd87XRiWWJsxMQgTt6PgYUd0gVd/IW/J0V9kzaNXyheUg6RLQDZZ8tAMAUXPFPmZ2WehazBVCKQRqHoGk2ESz41DoaKywedU2hlxPotB+Q4Zc0HiTO4JomZcKpzmE82H64aQ/C8xWrSceGob47y13LZ2Jt7WnAsqx/t4VKqf5BMwUptzaGxu6vSFuQrY+xKvDciDd6wAM1MdKT9dkekg2SJKnI8oYUhji2EVDFzzrHJ55JVcBMwDGEYLGL0tVDZxBsDIQ2NVoSsY8LiTD0atXaUovyFYlylVpJSFHY0CX2yd2QQnh739r+UXFLxFtsmFskhg7U7X2jVuCf6mkfRrvZzOeVHlkwklbNcj9vjAcGcNBz4aw/pOo4kFlk8h99OKPAOBsvnL696xYGdN1MaMtYRREB2nkS+YI9NmGUs5cKL/hTvdgrdivykKY4CmTvkicCzXEdl5CW8LPjwXVLyQzhsW6FkRyRNGz7aTqyxjmf2//5dK5CY8awIDLG+o9YaDne1MdD47fKZ3Bof7R8drIFdIP0aFiIi++oLhqe/OLQWHKKPBZe5dabrwkCqcnFkCfRRTOJc9gr17Oy3HFTF05J7/5exTOk5pX99nn8rpksa+guOfVetPlwFC+4YxnsmvOZ/aCqPYxXPeZaT6KH6rmgQFMeOAU38diyPMXJ9EjuZK79s0IriWzDP9CrvGikAGSywmgKklwxbx0fcUv9mkImmcg8CYE5UmJDrjjELhqSmEtWmkEBnU5rTs4AMB7wFpHNHOlzQO15s+IpHT4A0OHvTSFiTa/KP48XVi06ZcS8MPfPqM4+vxj+XTMBoXAeb5JKXJYxK3Ph4zgQc7MgD5EcLowOidFNaqim5qi7/RRmSJ2r8PZ92HZgOeYoGDpIUn6fF4DXbXa8klTLETYZy4Sq1YBb2zqdZD+Z8Xy0xlnhwLkiNxzh6TgMrh3z73mjj6ni2k6LUOXQu58cZ1GYlOvMom+P5kxaFFhOt5KNdAcsAeUOddUrJt2UKARztfUVmnF2V3wrjHjTslFyENKImhXhrTIgc+NjCllqiH28fSrhK3VJvS7u3uDfq7B/3BQbL7HDteDg57YWfy444WqtpP8+ujw8NfyRy+dk/HVplY7g3StX8/x3YOv5Y2nnvwgQBA+q1vDOSnWPiLKeI+WH+laQh7ctrDCIw25LQNN+HfaY0ajWWrjDoZ4KXVKWCj0AmIe6YZkO6x/kdHwaekGOzH2HwWwVPDoLun9i5tjK2dQfXH4af6GvLp3rGZLp25IforWMwfPmR/4NuZDhu/kHoBM2zwbd/WAUkXIt8+5uYHRTbVNr6cBNavYXNb2J0qHcrXTONW3DlppIBARd6Xvf0DWNFf2iX80i7hl3YJv7RL+KVdwi/tElY+/Zd2Cb+0S/g33S6h9+t/YCtLe9kzY2W8If2Bb0j/rXwt6EgfGyfam/4EbLQXGTqJIMdBR+fInOHSe1uulbQHzWuIwraWD3LbghuKddQaHO0/H3BHrUGbnFoKFoyRxO7rTNuxtWymEDrWwumO6cXIqfsiuyqAqNznP4o9h+1q/TXk/AkLqPZj1szwDKwiDK6NkhcPsLnwzys6aKRU/h58aYw28QZuMRM3uk5M5lmVweDrSKZ1tGviltZy75/uGYaoM/4b0g8NynE9xLBm/N4RF1tR+TfLSa01yzyi6yjXCmoMuklzU6RgRgC6wHsosEFK5ZWpqms2vQMvOvqQGGlsG5tCRlGJIWp4G7xSrjTFV3Gp/cpITjoAAjaV4jM0tWiXOkJgDWXJP5bHNQDQq3+Jf/qNlKEwg6YsCU+C7ON0UqXzWAQGf3xVcv9AxDTzCB1fBLEo19tNOIY4R4PLV3DGKTkGEWZcX87cul4vMUlHCuy0uVlY5qXnUtRaigEs/CFLDTmQ8xwtUZwdTviTXipXthrbLjun4NhtMg2uXaWWIVilDu54GyQZyCxU8byskk5Rw/xF/innNqFZFfllYypYvwGj4UhyIKhCN2ies34Uj/5oHq8Vh2ql9GibmbFzHgyhnQsM6AtHwvAx29Nz0DmIPTLNhYnod8WYWi+hi/st1+vyu5UKE+O+9uiUaGFkNJwYEGWrEWpLZM0uuGw7fSpoLF8uS99seiLxhwU1bsI5g7abZLfExOWp+AlsMCaSGJx9xx7kd1U+lplrPh87blTzaEiYXoUrW0PN+l4UuLhdqsEQr7uae1z3h5qLy0QoUVeMyxnSHHHm8fuO5goUwmalodChmWf2PuclAgkvNyRjjtBa3Mn1my0ri2ADyryBaiiS53qkqUNTDKzTPWBQrJuPZFuFCD1fxaXbvaGqT7BYRHUYu0L3pcnC+jPC+eJ5lVvmUyKQ7GpjEL6EEmmZs6cKUQ6AIGk8mfpG7xUUOvFAimEn79lXQmivF0kVUpC/oU4i2mi/bd+aB8uQIBXx+irFHhdOVr4pdO5OxRR8vY63oGzgCK3lqTWWPcWEk3kbGQN8HZDLFim7c2Vt9aLICCDUTXBc5SfSJKLr6vjpCUDDFbWGV6fr97pbzizA38sZw1VUmUIvQTTPGYMRO98U3AOipRWiKybB595wEk3Ar3mxFd3mbkL+DZrUzBWMENBA/dxNaoL36eadb6pftiwEGvF4Vfzh9+4EiI2C5EjVQ1xlBT/tWAfGt9R/n2vbrM1MCTF5yZ4KrojHgcmfNbzhUCmuZNQRCGMb8//CzHM9X22/8UQUB27XFr82wUM4JYKsgBUHrzWcnWWhP7TVoVQn2bGMHUu4nAuVa/dp9BdIZQLM+6YqP8JatbMaxnSwnn3XTUcthQW1llDVA8fYojX6O54CbgQleyGnWS8Zi/QWm55RAvcpsaeQl8Z3RUQdqQPLnqa1PmsfjlQuSrnMB8ilf3tX+CH5hb4EXxUqMUym5JuC+dMjnFIdXBa58rSJFYfWUlWE+Pnaqdk1pQGJP4rjxUxgbQCIqiuZCdolrclgJKDReKN94H1juE7LsTTrjQoWf0R/Ot/g0LQf1bTGPIQOqXj+C/dz4+K3VGiPfAIjuF1/4eMUcD1PuTFUo//ERqOP0oBawRz/LWlZp1KCkbv0dmtHNkwgnMggnHVJOY4qVxAsw7xVuEgpOf1eNK/0rAxuVNSOjC1auLPBaSD1KydCoOLLqZSvkrbuffV1Ty5AXuutIbLebvu4NYfuw+gQ50bEb2C8tp7wBrOLyYvsE+KPa7BIEE3dslfEpmE8DdLS0V/5mEok8+OinKsMmGVKHY7mgzN6tAFCBLO3co6ylWpgEduwvw0akGKsp8ZnvOTgE3D227Pff6EU2Gr4ek4eO9C+aYb2k82FLBZV6IRxCs61Pjpf+IX5a0xDftEQhLDz4HZo50qRvWnFiCHHxuQN4LWPEf0sZjuP56wbngEBL8G3XS/yviMUmMS3iJwIKd0mftGaFgrjZblJAca1XCcxXNAvkR1gZn36LwgpmBsjK2kzBOF3f3vFlNJBEspNTY6dcJOEN2GjqZioBtepkRGWfZ5T6lrlaEPHGSE4neJ9ENOOdmajx+IwsPR4xmzMtEXN6ToCmAiqLP9aOBv8ihi5dfKWjEgTJm4hNU6h7tnKtwihGWJtq2v5oIUZLvPPjVdsaUkwujYpsFVjTJpnSg0lRnupYcYVLl0rc7BRDkO4HjDO1xEe2NCR8QFkEfXeDTiHgzzLCU0SY7gIxg76smCCZfop4P/SeL7GNcKoB9obZA36X3R4AY4NEUcwxkndqc87ghlO5Qbyxb7+G/EQQ0dolUI2ExSYrxe3npZoVSybxyGYhdQMlff+VLWDA7YQhbnqMukMLJKxO0kYHMKOzFKkhZjgqXWRhGuZtUtBhUiWHSXoaRFUnsVvrHmQ4rTDCmPFaq+MCxPwqSGrfAxBNrqUXoUbBibN5XkwUco77Q3wbZYirfS3kTRH4+3kIIlRQgib2BEUGhWhG7Wr0PHGN+X4QTh9pKGZX66mq6zmAFWhMWuLlpBzKfIKMRKJZhgvMYjf5Y5vSxo6xw7fo1oP4o7dYNSmcJaoeTjqW5NeXJRg16BY8ZAh7226qMoi/qpdT/eNklsoqI1hlhpUbhrFERaUYOntOjNC4EZSvXJTtCeZ0M8SFoUaMOPx4ppAEQzea6RBc4XWydTicwAN07SgAq0kr3HzIMeJ7FjwgQnWwkc52gC6/ZTzCJGgywYKqCEI88BTiSkQr/qmT9S77avvXcZFjq3eTNzHti/x2NHM9nnJFLkSe/D/OyQyBadlmZmGkCh8a+Vdz8b+BvJqtOWbrT24WuSjjw/Ja9tNO5zJT9cZdBB7reB8h3nSls8MW4/ZLS17DkCSZYMjZ1l32hDCX+dUtQixWajvw3DxKlWDhI/EbmUzIuNyEcUXdGWH0GLJpH5FmlVTBbIQSTI6VZGmbgs7YDBtcwSjpnxqGFSdcBNIDhTkP27w8yAtEpAdkAAzaeiuZZLIEqqCCRdCjsppSyGuGiI4DVHrxvisXonGTmIcD8Yx30Af0yvyOFtKx8IHhQvkrEsVB3PhkMHM/YiR7+O3VzzBGzKdz/IP+QP8YnmD7XvGWdn1MNN/HbaIL6D04Wuk0qJnOLjAJYFVpm3PsJHRM8GP7sGamqZBcE3eGrjld9K6/S8biIJ5q4cxIA1j99TeK2XIsrc0V4OpWpq9biVP1a+8YRZdGFmaxdwsir7HlJLRh3DN7vH9lYgiBykWSGx4tOWm4XnY6aZxH++olQqeUmYc1GBPDJyyJi3uNqMhcTqBWl2ZWxQv92lF+GCroMJ6apaf6K7wA0RDu+sTtcWi0IzOCPNKuAFXHLryVClI1XfMo6JtE2xeV9QDrbMfs6p0PrjvE9NMdXdslAB36X3V3oOrUDnCP3d4mY0I08JlmAM+WOdZhZybP1y+ROoM6n2KNuGUK0MEMtVKdxrpHvEqzN4FkEy2zjTDJcl+32jNtCFb+ybB0numE4043UQIWKxl2G1kdI78Pcp1xbUhzmzukyd4lEnubwaciooy7QurjQVJSLocf904P7RUa6cvualUEbDU+xKz4Q4jtW6hbaorgkcR2bwyWLJ+ASRUy+tQFsI6HGDTNrnxbfXjJF0AvhE9dvFivSGGhOEUVPTgBTWhmqnBDRfTYtS8oghq45tZbFg1FGCID+VGD+vBvohDXOJNGiPEyvQIj7jNJEFspX40BEtUIOOUGIO+K8sJwWqKhQ/NE6/xuCWgbh70/ERlRxeWW4+xsBYTc03NtWBkE4e6L6Ib6d3EuF+pGIPIuLTtMypZmCBUL/BRXX/KTYeCFkoLQac+aZHGCgq6kgOebgtL6bQASdWq1DhOnDBRcKkNPbC3uoF2CN6H2pZqn41UWa0boepgZzvDnCueYnwseam97ZPo6LstjtTAqWjJI/sd6h2qCEGF61Mr1EZwZcuEVpjemvw3l+2tG8UoxrqP9Ca1E2yktjBuXnOvPAYs0QmRctLMdRyb5Nh4iGWYbyhYS/xFsSX46/DJbaB0X/UOvdpDvRAULS86XaTGsVw5UmDxpi07V7OCefEnLvukpJxmQ/I42VPE9LO5TrpabWnG8X/HRuPC+SGWVHKF3eRJjftnGo2OqnLu6E9992Faj7DDYju/Eh07QjcXAgiWBfdiR6JQ16/K9G8mkIuLR5q+p35/WPKEZm0srt89QSaW1Qk6OUyycfwJfU/huDfOrE0BrHwCMz0FeOBWEF2SzDeZhtvoR1TugOVWyB8UERS73cEHS3VMB97p/YYs+HaNO4kZ4SrP2P0mBkCxCwneR+ENdPGdldAJQtok8q/jNK1TFCoKaKHG2V2ZC2PcOEyDzeO1Fj6TFnQhqIDj284YYupLHtobATpGx1S4xNtPRDjHiuTs7PcJ09y5dB7VlDDhXxHm9CRUIGeaA8JR7WZZnyMxA5fXXDQI5pVmWhZopHZf5CENVe9ih9qQ3qKa9OHCoMUz2ocTG1+s9tAakl5SaTKWoMUlgcC90C+SVZSqIw6waW6Ws8VrU4X8QqZg1Bu9Nxk2mzmMvsIK1xPfzgN86xjCd43pELrfvLBeDRH3pzEshP5kbeoRnmCPjLSzjgqZFcWCDqLKhv8LVNVi2EdaE3tidBb4Dd5GCuKIZ8PpFtcLpnhooj/sDLsq6LJxE+XA5IqY1WmYSKfatoYGWAXtt76aonAixnfEIw2+EZSSBZ9cwZ9drwkmjZuLJOS/7TTSvMGvOwNlXfDjM7AAy8jfTUQgnN4irRJpORlbHVDo1DS1/dllVZIr4h232PCdRZhKF2PfKaRV93WDpkBPYjTYdBOJgz1trCdLoN+EJ+A77jDHJG9ybkxYjTgafeKwHe1yvw/cIrZ0peBtSfMSm9T3M4vUH7zOP2XNHBOjn5cLZL7b0iY+6TQIPG+2YpH4oFm+VevmhBCv8bSB6gkfRT0H5xRUaVa11mXzno5SR3xo8q+tWIfydaN8UDIWtmVZjnTNhy0Kwbi7VMWDla/ymmGCpIPHbP+0N9g+/GIWs5PT3SaL2fN1LGaDvb3944N9x2Qmz/9CHrPdx/GYxWkafmE0+9tkNDt8Dr/4ha/iF76Kn5avgohf9uB4ws6M+2rA99mhitO/7Hv6F4q4NdhfugeLcsAcwddfpnXuGh1vscTmhgFEZB8Atn3AgKkYokwv+/u7B8z0srd91MEaS60ueGkk2kl8mXm4SPb7qjB9w70wmoLQ7VLKt85fvCXmhh8uUeQnT9kl+W22mIPojnY0axJ7G1Zq3+MmD5rxxoahX5mxbrEhjjZ5ycZCf37PDP9Eoo8Rk2UEEnvKDXrhmjVbM2uzbxxbquRqajSSUwN1sKXRRwrbPWBUFwn+Y8/587LUrm8UtWRuMeymZntyR477KfVMAZldeLYMakLD+QBp+7bIKd5OXckZFHZryFaaaxV7ymhaFpKUnnkPnLsiOdYpChCVSzT/+IViI6Wef09H49I/PDpUBMUNdH0qhxxrKoRa5LNMee8C4vaOYwQy1m0KudC8utF5faAuoRxA51tH9HnI1Sc9oGQrZLoS2PO5lNIHdJ1Th5evxe4rD7QqWRoF1S6agu68Jg58nwItX7M9KeyQVl7CtDgdINFUyQpolX1Hh0YcpadrhqSTk+VMOlzx2mhRt2cA0e0nU5MJJaK5KW254XuimPIA7IbtRiR6g2B5ogu7osI/qF9wZV8lo278Q+Lj/gwl5Y3QKoM41I5x5e+84g77ni/qZvSgM6fsC0yJX9Nvm5xWp1E8Zx6terMtTCNaHuDzg0WLwwtOnXdJ98ix86sioWfOud8JRTiptSH/ufNVT03qACGb2GoIYf5KJBcmeceOCxblf+37rLwyF9YOLrc/ACV4Cumo7BD4VA9kCPlwXHX4WjpTkti1mX7WQFh541Q5d2kkY4IoSKjC9xZHj95zZkhVHgu8OP6u419WsPvjV/CD2Lj2zjUlksermTMTB9+fmswZW0J2Mfu4u32ErfY4Ja0AVoRX0PbHi0mEoskxMfb4Xg+ROKCn4YTGg5nsvYdaylJYCd139CB35LqZQT1SHl8vb2b5QpcGD24YsaV/4Uu4qjLWWjyymYLgrwR6yOm74KJ6ikdSFiuYNmCUkaKC2RLTKbleMjYqIcyxXIHsyn/CU81lGC7iHaLDgiXtSjJHQtbcK4ta3bHfk7nyGQIKXP7mMvaIL6mY8HVNcbp515bK1FBkETIqcz7CVrNZckVnQ7ENVMxrKTo6hrKA+WaomU9eZAkOt09+Olw6DtfyGdgdtSQJjkfnjiHTegldiK/RmjHiJxcqOwWRR1lgrHN0F/qRSxjCXMUA5xEp997wrJiYtS45nzRuEwJxZ2aZTMCIHDsEXhY4u7NyUW8rBBJn/bI9F71jq59gh7MYiHaSe8s/rSvN8ogpqHL25gqnBDsEoS3DDg5Y69Ja6AX3naTWnQaFUbJDRoFN3UEy5loUXx5DEprZofVJfT7AsdiCEyJwDUqqkPhbDR+uH8BGoq65t1mm/pmboaY96WjJKeRo8A3Cx/mPucvUu34rUcIaL8ithcNl+uHbpYHGthtScPkfbQvVQaMU7M/L+8z5RloRc5/doDnVMQWyyj4vjB52GCkSrMy9E8LcfNFrCwgatcE47+zkAtx47LoeRM0dfCo4dS3ZEKECCM5gy4VYVx7cKHjTTWbYAwG5FtSRVc4Dob1sVVznqq4oRM4J/zfO3eN41DtXVM2SYFaO02nH+CYxwJ5BdLEEmxYFFyiWI0zVBYvZ8pv4+dnneV5J+WE+s8QH5hMEZ5RE3G79aWVlRU+EkLYlU1RUHbhaIbD3LemNtLUab397wJe9rO5NZ1MzksfG5wvNetlOb/oK1IjYfMCRPbQ3JdokbT+JpkdtpvMXb6ML2AHRXgUIty/F0c5FzQUztvwcG86i9KgmWazMZgUS3JkyCsdrI7/3u8YK6ws8KPKVzyHS94jkAKXtGOHzXGrDhyCvOtPluF6dFMOd62U6CqTucMjxZg55x6dACiwTzg/XIKjK+tTWaA1NB1nO9JomFUdryJZ15rhE0EpwpeOK5O8qgw+xWN0P2IrAEiNaf4vZS1Uc4y9rjHWJTOUgxrScTHh16PPoRrQM/HNu0BkCiEht2jK5rABHlN3V83QOBy7d/g//vp+I2BB/swpRA7XOZIX5HKBVyT4wkmacaqSVygbpOwUIdJKkKKB+LIuNqDhZ1jQD4KUOjGFMAo3rDZoscyXUIMecuQ7XhIX4rsizpD+sJb1rrs7jQD3IZ/GG+SxC8uQ8oL0QNRMtA7LnIG7Q2QTWt2W5AAshnScH3aaVxgJ9DEtWYR0VRhj5xUOCUqVxYgighh3bBIikxv6IOiQ6pxMOY5WOVhB1qiGEM2VbBeSmxK61R6zpAXGbLSImsgD2xnDk2tbyZnsoAciA5obdfWJYCwZ7oeVss7wgtk3i5UHCKw4OovofYWa3HIuvm1zf5wirLueMs6e4pCa/UJ5EyrX32pZAlJEaqYjwT16ZBPaMRKipjtl6Thas35YB/CRxHdz3bIoDW2va8UIHLDqFTR7ZeDkGZaBT3MBzrn6XLVLXVMGuzrP8dktSEFOCL2wlUlRB/gpFGD+8fx3NRLM1wDkVF2J3bQ+dErmh4Nk9ldoRz6K1t4k5m3ujEz0Z3h82+nUTW5b8OpyslFBJIaeicXOilUklZo8unAuFCGGGlMLMW1ZM8EAk+LtFoCNWYPjIJSp1wjyF2HNuEUk/PFOc9Ju4G9au9ogpGM834o0L/K6+QxmoH6d1DIUz0U9/uD5fO4VGHx7f9djxlG0cdwrGbeldP7Kzhriv1Kbja2beRskIFgxjblnZWFbuwham+bxCpejcUiBHrox0fV7H1hzZusDgioqLMtAdHOmgWBGlflO3o/4nGz1ZQ2dcyoQMBJzpm7EgpjtATi7bFx3u7dpHYZGocb9Rs+LRQxXgYgkBaYtkCTkOz748nGHwH1D+r3oct+TyckHidvSuqRRQuxPAfiAWk07zkQv+h6E+HM41HK/n2QYWt0cXE+G5XngFhUsMZCTwMfXGDOPXFkj8j5kuvTRoUAH8iMeHoXpDZl0vuSWpymNMogjt60b7SXbktLxBrg6Xe/2srY19h+Vw2fnU5tzv3Nn2cXvjQ1Flk7xeZJVI0jc2NqShgatssZz7Pna4kBQZKYuoeuGsa5R4Yg/8x3iGfDUa3bO0sSJRe1XMoRVGUMuaD/duXHKwIUWghOup68EKTN/LpCoL79BEX6wjQ93wJGwytFVxAMOgN8cyh/zGsIQTmz/9yjZ+is2jO6PNMYyAxYEBAptVOoabTdvMEXUXIOG+we2YEsZgGdrhJDkDdU0T+M5a0FFZw9nLRy2qXqV9MJWbFF2AswD+LjYh1S7gCvUzu7pqOVf4gSa6SZ62J/HDLcrqRSNIm83iIJukVToau0otoqyNDkBXZKlNyRq5uZgD84fuJRZS8bUyJgF5tCj2ybBSY2qjuXXUflXa7p0z5QzMcf6UwhhsPFgeGqNliDAxEFND1GA2OQJXu3zxQu1W3QBJJmWyXFjwFGxzd5hCngN2u6sCEhNL3kAQO9zJMLt3wMCx+IwYAchSSsETWbHLNXVFLhqGXdNWQwwZ/J4TxCaZQ4CHrZC8jHP+O/qLHbzcLta4JpjRjjjbGicw+ucMrwXheqMVCrgILtXAUfUtpfYSTTcjmwZM0bUaOlUzy2OGpVk7Bb5pSnyevdluzvt6YUDCxlW+ktpv0e5bS7oDxNaSMURBw2sl943F2z2yVZnLxuHmx4iv2DUNjd5TpGIoNfHmoYMaw3RsexywDQrafD3oKrjcatVoxREql0z49iMBzTBWq76FBDaFrMNppnn6QDpvUi4SVecb74U5vCbzel8mBGlPlsU9XOuxVQZ6AL/gVNntn5a1X2vNbwdrrthPB+poba+guXU66SSNV/KZq2v2gMjTOSAZRHRxUxSfTp2eXa7WzH/NY5r7jcgVRoXqq6LY9gmC9rvp9uaVtzppi1mDPe41G0ebNLdJKfkghcVNaWPljdxAVfYGVVGVU5+4yjfGjLRPDB9Cf2M1LODM+1vDS60kS2jFx3FN658a0SxyBvwaWmifyK8YG8D3nIeCM2XtDdZNclld7b1WVHDJRdTGWE2y6LssxAJVGD9baRZeqGgL3t/TT6jEE3j2WNCheqI1l7vuMUGKM7LULZXVEcGKaD/Rvz765KNunk50yzqyG842omxiv3RNvrBD8KJ5INIw8sOyFw+Jy1zBEqoTtYpcPZhLA6cx8Vgmn76XCIEz8TdeAnv4VsFcYjrbwzlP7a98aBlOkEXv2Tc9b+1t+Cl31+ISADgo1/c5xcldWsZ+m2yZc4sTru3bhfWY7VSPdt5hjiNZUI0PrMFttdmOOG2jRFmcOvNnitA7ICFACMMILndBRCuCfF6RbgodToOmhUc66LVeU0r4S+wajwSuJXeFD2l4G8dLZMAmoSR7OE3Rgo7ky9BTQgfep1Rb3qhpapZ2Hp72qBDoi4s7D0/3Th5d3Pn8+d6RK+10z/95ijtXVWH9UuL5t1nieXL8PCjx/KVM7ZcytV/K1IKf/eRlalT/OtjzlfCzdF7H6173fN3rG/pSUPbaHiNa7rp/uOfqXZUaAWtmULQSJ5LvnoXmgrAY4vO2Ycbj/BNHeb/upVPCMeL/7YsS7JHzJB/1vjG/pZN69iOSctF/wpp9IlD9V2lyV2W3X/d2/g7tjGE+/vrkZP9gMPiPmAPoI9c0+Xj9xR1ojMkd/DPr29fsszHQk0j3173hzTTF2haQbl/3irJERi5sOVYxCrDqfSODuuyWeeWvdtJvJCn4gMk7AeM+qSWI4bmPsKMvIlS8FYSzga2FJfomWhMM/+9Ya4J3O2qCpcWvcM65Rk4vciGtEuZW09Y2OKSv0x8fXC4f5pOcXV6QvPBGljFyBaVhfa6nVEdeoniH8wG/piuaittThwL5vbiyzomlKLRmLXPKiAXTztJqmmeVgpW3BPhf4foWJVjk4hRT0EBgx5FXNdb9blfyCjeDYggmK0cutjDtE4F5yUFcT7EqudmbqryvlU7uh8tos1h8djd8+aeoVAwetaIoEpUO53/hXXELarxjjkpNQVziOnX0qdEqUYlc4FbAf51fXeE+No5f9IfMdZYVowfGzYGkP7vPuCynNQKX6s3wrIrBJGnniGXe+/+VYBhMs09SQoJYrVlafYSbLCqTD2cDaUUrMTYH3yFLxJCiwfxC9VFjjFKU2QheaRWpmRn5H+HrcTKdUExzgUyQlBBfg28iTpf4vz3mJeydAgck6JUaPQQdaSS4QuQsupzbG3peclnOP8yl0xU1Fzpb573QoC8LXjp4Aa2ScNv3SjoDKz1cZ5LQFk5JVV2EdZgXhvLiEsvbIrOInNDRghqE8LcF+aQTegAd+BQkvzA+B2EjUHWz/EcXUmOBFzElk6s5tkC4ffBy9lUJm5BQGdrcSXgpg4AH0OjwLhegMH7IC7DUo9skGTUQhGUx+Ua4zcB5lz8EBFGv5QIk1Ow2yH0RsoDe+x5hEr5+kiVskIeyJwuk9nYYKYB/0cnAi3fM5MOFUnXMMqUsRu4Ux62GFtztsnb4+9Sx5boue7KfvGfsluOUK84+mbh4hEEZzRpUWUzhyecC/W3450uOIZQOjq4Ij6dYolu7++WvY9A6E3VBbP8bRQaqBRpaC7TUfCoMTr5EiRSIpDToxQs8rOmf0s/y1+bbUf+5SNsxMgytPaOP74tw62SV3/OcehsdNS+24A4JqxyWRCGEEGWDZMda+xhJnjL1HZP9+uatkwknof2DPnzRSfTpeMZBgbm5nLkmwLQPF2PhnyZniGqD03Z/nWJshFTkzdDoQA5r+ANCPsdZNmfjjnqNUowGx2eAUIQk7z3iqYiXn1pfilmFizPkxRnq4vgiunlagT2Pj3wKvyE/RY2FqWmcbW1nNMPoCaRn7sOj/AZRKhmSOwgHBCZn0bpFxjXE0+CzZti0ANwTUrtvHpLXTu1KTRxDT7vMSg3g2u6YeLEG2yenYQWdu0QvmpcIxXqjaS+f+iGe+qGe+iG6syCDP7x/7Zdqy8FcpVMENU5lt9n9MrrGRkRSNX9ymHycNbnW2Z669WVPuU/W1NiHlioGOTYeVGir9dLJOC/lSNKzGR05EqLTXP2GVyAJ6PguHM8Tiw8+/3+qwQMqP+ZZlC/kB5bCYKBSTcJU0kjYaAoZYPsaWEAsPc7dNe9x5g9GaMh1JdN9y3VftjsDVgVu+pAbDxjIMQHcHH311e9eN6qjaY5XnC+RQZiED9OBbAMtF6VDcqELjmgdBjZMGcWNz9xOru/yOmFRT4vlmtGzEGPNUktWgE0ghJEVdHMwGeq0UEyIxhME94xZFFnnmzmwfIu1xpDEgk8UeDmINGR42WOGYIcZ1RqNBvDhbBFk4Ccu6uRXsJPzJSsT99RguHdsFQXW62+vgk5bhgr1pAs6538cLc605WjBcC335YM55U0yNYX9Gx9VKgVjT20zK+pDu83llkFrebUZOA4rKfy9Xr55TLae5zCrHjy9ozpO9u1ibM0V+/iyawv97H3/Fif8TNUAh9scrtV9N1UPo6u8bf3QTPSSK9gT/Iw8ffEtGkBvHlAAKLnxcZRvh8Zv9nmIPE+K/X0JHXeLlK86eha2uRBoIpmn6DZ0kF+Etp/LZGLMR1bJYVA5rKGxgaBngX1Sq9eC89AbSW09O3CnQSztTDFrSnJOBuVfv1nC6uQdQzRMVC4xH3Opn3HnGvMIGhCoKLISo0GdIqF0V+8W6e1snY2AtR4p+efM3BCtaY09PjZQd1UsRxObzg5vxnG3wHlx1fmblrxwQqqrgrwlpNmJ4VeLtHdvyA25RivWlHUoYmUxtVSgWqxnxNocynGpG8ht/Cm3TdyDF+2k+7+/Q3odqjXOCI0siZta1dkqdHBYu8+XqBn3GefptJw48oR7us0BC8ks/Zj58y2dLPkkepwlxnPXk3CpUTpn060VxCBRqaVVzpbDrAEBj2A89HupIlfEHmGvsoqqbrAPyW+ury+v1sxDmtr2OPwHgs6vCYEoYgZlz1HNpTUFJq6uXlsSLLqKLBXh3YjcgvCA6fQeW5303pbJBbXafYVdLXsbGvPHfLEw+ocZvpRHz38UiXH59jvnmI82QVhxLo3zSRSl5DCkiXY6aiHkw2dOgLt8Qg2S6YRQLxM43+/ecvE7j8Xjhs9/kcEuj+i2IiVTf1lQUMJVnITf/h4UV4nBI7xLYlkarlJXjYkbRxtDsaDbtOEM/31BBXv4xqf+PjZA4mQt4uLCIcPLN+CkIm4uBRoZVOVih/BUuqLbyW/Ke/Qvt2BrEwofCJtUiYBJpGtjhBQcS15zosLHJ2q/cxrHEi1s8dfd87lfCaV/sFVtVFa09CfLimnJbWEfIyDegz8y4sxv7z1F9zXsq3JBJUKRj2BNPkTFdGdPoxiQ5E3qKyka2vDq+++wgtaYkz4+ICpGnHCQxxzLyoiBmGwO/O4FHooCJMvLz3AiK5jxYNDxMMk78F2SZJGrSs0LpxcURUkBKTqW2iem4fMEVJP+1MZ1sbnqLJDiXqyYZE/57om0rVnIPYvKRWcSsqjFb0ZnEIpDfPdmasiimjkYweBEgRw26mADYe0iHDEDsIvlqAgIbrBBhJOk2NQWnT/BH0pAwkQSJJNi0xqv2okRPZY+LHHLAcx2G3HtE958vTXjaakyAXFz39YmLUI7g/Ha2hcrb4CxeNw76SNBZ4tqSAx2mtSyGNsSIqgXVZbhhjTQVC2LiOkngtyGW2lr9ZMOcvsq8Hzu4hL6KmuNMnfpPlxIdOqf/vH/a+Sb/ukf/ydhErD+EZMOehXxaKLzFACpJSIT0XfClKB2d/BClFCSPFoapDTtvvXOiFxHftSTUxk5yJ38PhFbwx9tXn07LbrG2ALH94rgO2ZmGHnTiMfxK//eQlywFOb3dX5y075nOoQACt3V5BdJC1USCpSkIUlSZuZeUy/LGFcJTlG0zPH96pzjXgafcoPQZRsCTwLK6y2rJAij6Gtp/IDRA/0ROypRMhfXsPlaXMZBvlkfw1opKPQOfjSjG041HQZ/BjcB1wZzugIRiB6zlhfkxjX4DZyBqH6MtrpgTCNsfdpIP9g+6N7SOg2Aq/WoKqdT2B/Eb4DC6W2huqkeFndiPvZwpB9L4Q1gD6GnWV348mIUBsg1OSTPEFFEJiwaHJEvazQNzRH9GWVYY+jmMzkuQTCzbIMfXOTDnCvtHsRnss036xNfYhionOJgdseBekWcFOHuNAyMHOeJQzeVZuRcmsz+rWkCwLksOJbNdlyKCMAzgmeaNsiFO7VcmMTN05uMLdl7x/0ipsQeQ1da6Q4dPAwEOvXKIbuvEgS7Jk+1O+YRJXRSlDP5bDlT08Z1qhCE0gM4T7E8YaMFn9O0Kv3wGPZe5zOhtnx3ewvro6LcBRI3dMIOjZGku63OoKWUuHUstAIxq1t6P3q91/WSdXCmCGedb6fpgxxYzxQGNWxwGxvRgRnxKXeZ/FjsLMJgtcGssHjHwSiMhmtaO1viTLre5pnvcG+aMcXmtZ5R6YrtoPYOy1etsZYV1JUykGZkSZJDRvF9R7LCPAXwI7EJ61VGoTuJOTn9TymCvSWQtV812qU8s4sVGSwSYg+vPNz35Clol4f+ouzjP8OE9rPImCE4KOQvcuF+ssRRGIz47y0iTsuAC+dpD9bJe2gkalhJMpO5EDKhL5dy3kZ5mOnrssKYSSGdOi6ptAAWe9kZ6ANDHUN5Zvtt0Y5TjP3kTQ5KrC5vF0ZnxnV1GtMe1Fuzdo7JDYpE5meadZHuuPhKW0TjtQ2q6ZpBOXDk5JtSUsr9oeMPslgMe1D6TRXFwqpmJF4UTaUKppnr1vgF7SNHyTExKE7g/7+9b91t68jS/T0N9Dtw+KPjdIuSqLvV6Qxs+dLusRPBspNuHBwIm+SWuGOKm8NNWlYaAeYd5tf5l2fJo8yTnFrXWlW7iqRym2DgwWAmosmq2rWr1vVb39pi5ceM4Ileh3GSXqMOxvQRewpZxxbQtHtOoms2qTSTjqDvVF1VrNvJXA1bv10sb27wWBNBCEggDs+B8Q/2HjIuLKdRF9KzwFVydmWYqgCISXg0Z87YJj1kQ6kQVKCuRuikNVusV5ySElg6hJ+ih8OnMbQCM7cd5jLB67guMa8U8zkmYGthiZLiMt2+Lhvs1gu6H6Zx/plFXoFzRjQWCLvif/B4EO/9w7KoZBKePTi1qwpxdn9CIc7RaX8vLMQ53F1XiLN/eHR8uG8qcXZ/zUqcFDD8YwXOb7MCZ79/0K7A+QgK3xQU7ospQJ/1SMeniykOfDHFI/5au5wiGCXdPcxJiNeQNGN7QgBfhtSHvHmxEoiBVBWz2GbpNmK7+/0TKRk42e6v6KAbkgiZSZgC4qoGbjDsc9L4VpVVkhHKzdQCxfiZaLewMhUelKi67nybHIwJL6rhuzsMKqLrTTAowuow/hi+Ni6r6zFtEB0TwN1ngAMaQdeaHfAtZsvBxJlk5nmJHHyCAZwxqSqF9EkTbLdcfoowkxjswcNfvg2RVq5nmgCevX51ihsNdSamM8YFuO9UbPvf//lfnbfvlsvzskaOvlxbaJs8jM5mch/TbrDiqQCbhaEq2ePC/xYCqK2dTm5xvmUGKnVIul3PbeyMhuqIU0HwNj+xfcjqKlgT2DTZRZmHRNKKIBI5FGIIrIquoE57EaPcMkdDOprzYcMmQ8+p5J8qS16lKENFLGnPqAetTppbid6VW52XxR3kLj5Vw1mcde02xTX8ZEpCkZPfMXKboeYbUwhoS/klsP0lS3uiTZ3SvYIixx342giUat+QMsE8shuLiFR4W0QfMkeHnTFZGFIgWFOODPskkSCUYMuVU0YTLhrFyEk9RJ9iJHh2f1zAnjRMHUwG5zcdQIF3XiYlUk+wlKPcUsKQ/SNRHcvJCEscy4Wnh0yfbgyrmIIAyFV0xs4jsu/jnlPKO8K7ZydjIdGT+9OWEumZiNVCoPhQEYKlg1xagLln0e3Jh2REKN1YpBzsBZSDP+I5CQnip5MmJtHTsj2UP2RhxCq3gKl3y42GSjQz0wESES+5c5Qp91QGxbxwwnHGLSE+UdMjs+DsrQgyyZ5LVN8PPoeYj7yfMetiJyG97Z7ajJeebGIYIcPVdgejq17Pgyy1npr3iNqH0u5gBqkawn12W4QnB8QaAowk6E93n/oU+zsbrd6L6VwHkm36DnpQOhoJUJkfc7La/oifGON8GNmBNjTsW0cdSjoPqu1yu7Uhn66/ahJ4CZ4V/ejMg4bIFnsQMj+wR0X4xQgyG4qmoJ9NAJi0iI04nFsugqXTGQAS2EXPBDNyNKYhxtjuUpbFFCTS8fZBamdJ+URS4fFjEv4byj88sLeF1k+1CJOQYNCcNhaYWCYQ/BiwSpCHbkgUCrTX/3SD7SXJF91feouYDuatJ/YrApONRvEd2YAYtqTbn+npFtqnwevbXytQcXumneVUqgDBNFtAtO6TFxeX56+/fPbi5dPL80fPn36icN3guKxQFAXdBmd8ML9aWylQjFT4ipi30Aqll5DzTnQu2Hhacv5WTczzbq75pDYCYHU9KqIlcaq1B00UulsxJnEDKX4FzgpF3qTwtBCZEhJk4nN5dieR6/U0bar4GpnIgG7pFemL/o8aGIjcVbmpljerDtleO9P0mAIeEQvvuLQqG1+z02DOiqAAOcZc8STOvY2B6jc97UZnu5pegUVZIoG6kAlKwhzDn7P3PVgVUulgC88IXcT7T01VPCmXsfLV9b/DzSsCX+ebetCBRE0LQn7OFaCgxGUx3Ysy4VJ1BcrHGAYuJfYLEKo91pHE9MSRtfQRNC3keauhLLVFlJzf18W4DBwdWBM0raUghZBZkQtAcQgwGjCEgG0A9vk7G0xFjxNPllPABfCGjOsR9a2zdilYzMtJwWiWyRJY24PsT24k8M69Q8NCPXDNvVuTDv0EgriF66aTL0izKM5T6U1t7QDBUDWa8x5ICYbFhNEekrgyTRkKgJgiwjRoFL3SHPHazbPq2FhX6GsEATgbCYufObKTrtSErGx7BNKcVB83b7W5keaaXTBeQW4Ss3FFvZNbuK81Un3mzc/Ao0YBhQFiuNfNmNMoQvvGjG5Ne5pY5RC/HQO4+TDhNhAtZcNNclf394PDlO0RttYZp4pI9gGbjIuItDLxnjThV7ApI2OL0CSoTaveaLk5HMLPtFyOI0AETbQGeMSceg0pUsOV/eh1geNOfH6kGvCIaENHJrd5fXGBfTRTc8vMwvtzW72renCSdrsqhz5rZsWU7c7otohXqtUx4X3xWsvNjaOs93Ois9os3Sf0jA3Z1ETiBJo0dGUZsSz2xwPzy095e7Tswjt19ie2M+dmK0RsBA1kGEFi9y4xZNbGfrl0Mvfr884bqku7EpLIhg2fhC+gjeRpQyjz0qA8aKRXF76h8oO03q0FX0nvicsyUB/aDeE3t2ZDWu46mFgpl/+abg+ly8Oj3PYo6HWVTFeCxSMF4wIiqwZVk5PoCLZKOUtv380LZ3u5Vaf6siR+0AXbqkvQLwoidVsHsx323e58Ud9uGasfr8QmY4GcnUSyi9bzBrQK/eyyvp3an1LJEoEctHjKKiMM+zfj4DfGjoRXv97FRQRfLIuoZ/0HoeMM/c7UGygM0JXtxoBiXBjv5UZ2X6HJCZjjrulHyysHAy6MbfseKB3PjrqhJx9Fv0flYHnNPQ/MBsS+NfhD5CcEhH5WYtI8QUOmUDxarBGPj+Al6RbYCohaEWqk+HGuoJsUfSssz9vIlVb8LUarPaYiJ/yeTyFXMQDDwmXq4RI8K7qPQUjKQsEBNw39B3Dq+AKsiP8Gz7kWJZ+URzDD66cXbzi7Xc6rKAV2nq63ocgK9Mjls6XwoupmfT8EqVwJAsRCD+Wj395nS2JI/1a8Ly4ow2rsgDB+66SAtXuTuVBtPUIM73FjU3S+r220Kdj3dS1OjB5su6Uty9zGVaa9SRRY8e1pjWu0NguVfOlh7ikI+GcHIqOXRciEkm423da1YcyuCJ2px2EmY5npUwJ6kOOHbFs1dOYgrGPTYlbLpN5PyxDPnOi1T58xbqgISV1/7yAV7KhgeMiosbUTCQsJIyt8pINwBNHLpICpNMUwwfVHwMkkdnl7zrgBTyvy60FmKuJS+7s2HxTeSomSU2Ux0bc0oZNHpjrwXt6mlCsh9KblAmB8PYU2pyNqptnW3CsyMVDs0yZ2kE4ZGIulh970AKbsDswyedziw/aq+EYans4Zj6mkBYavLZENp1CTjTN0TX1TK9zQRBGXDGxbLxLRsgRKd7tzjqgs2AbR8GTtTu6k3paojAgSRXhdPO+x+vZ9TR8J3FjqiDsvKEi6BYhMjBQ0nNqWCgk/ahRzBT8SNDEx3gAfohNB8l32yHP4hiie4NEAUQIAQzDOTW1dh6EGQemf8GwspxwtK7HSBJoHwhZiiHf9ZQ8i4T7G6sYBvaN0LKiENAOPVoiWs1zpDWV3IDGhNbNUFEc3fV6G++CXw5liN5mzo4fvegQUaQWPwrBcchrEtxULKZC4ZfPyztdlE1xewzaJhHE4zauWEeejbeltjt94/FoheEsPjKZfelosrhfJmi1FC9StdNhc83r4a+2fm3eTEDtHm1W3HOwehElSTbYlBJ+E2TKquhtkhcx6uxxKZnPapo0ow4d17mrcTDALkX6odspiTq02kqAxRsvjfWDE8RpM9BFgogFe+BO6Exw+vC8out8/ObbdCWQBvyIoOoJ3fgRF/zZB0Q/7CUz0zwd6RdCwOx63sx5WSqTxwvseL/wVfSuACwe/TyKF+ydH0RDiaHp8nrYME+4pU3LXYAdZSFS5e/geg193qPiH47puym0k1yxvPm+BBT/bcZ96rne1wSF+AePDj3A94Rc1OEiiL4lPPtmDNh8gpxLNVqWczBMekImiwNPWStcYbb5raBv9SEEyiSCEFW+JYQvuVoUmIGQTfQ9Tg85oT7NmhY+EN6DF6eRe3L8XUAFXMknMVmdQI+tsSW/B3ZFNIKW6ThntjRJH2k9/+hwm9paxbcYh77ItPHN7FhZ72jAPN6EeLK8D0h2EMYZhDtWC+9sH+UxSwA4GG/1iOgG+02emeQVZxRaJfZycZAXC3nJaAGAGy+mkTEuy2mRJgB1HMq9UrgvlExRyoKJJUcr6+WwIm2lvm5A1b8Nfwkd/ZXoPpnnTci4ExymUMDPeBfDwAYctxI1W8RJ6lkxdsK+v9ZmgCO+XBHSlmibDz7l6IL5eT6GmFi3c0/hlQUWp9qHl3ieNJSGXAzmrgPYKO8kWiH7WKCt3uk68Lrum4NhtsgznDNZIvjSHKA/WCcJFdD5TkqKFwnC0rTduUk0iA53l+0r6pWd86FzhNB4IZIecLm98y6z1o4ieaB+vFYdqpfRABR521kuc87B1oJAqLJvCsDg5/QSQQWQCaZpbd+2joodV3c+ElEE29zFRVNGzYYIEKhJhcKzNJsGVbGMTdzmXwCcgnGZ3lKs0bwHqMtEFwX/FMgvw7+cVXKEJfTNG3qYnQyVhQaUQdq+V2xRuYlFxdG4ljX+igeDbR88l2FiNpA8C44LKD8NyPku6d/goywWQ3Iea9TUrcAYEiQbDfPrKFcn7eYF9n6TdRcc99qi+AaJEd8zLUZZ8AfOEnlJyjIyi7yRec0ZbJLzfzL9NRxsSGOtfNu8suHmYgMPU6UPNvQ7uAjrWDU5PEHamshQ5lr6OPYm6zb9Q0SeA5Qi62EIvXV+0ZlnUQQnM5tWUg4HKBJ2rBAkfwjLd8g6JQuQDAFTmwzuN7Gz4XPbi8qoYIEbhaE9mJZ0mbY/JSJ0ktFHCvjUTS/PKGq8vE3IEeXLBhfMzA8Iv8xQKjfLaFEVaMShJd6YpdHObQtcBoq7uuo21O4kXRUYAIUl4Iz/h5ri5q+OXx5EbuY/R1cn9Xt6WmgUI9/Ydui3WcI51glKNlHtS4apkunWKN1HLTdM31Iut5Gte0WjnZyv7W2PaD2xoE07xoJgzNhiNBrIsRyGVZqpxEDxPns4pVr9kWZCU+RGq+O3f9QSwjVI09XR+l1ZZIVlseh+e4g40/17FuPHVpgSbvGhPhSzTWnHGH4vfzfqwMVzHPIhz6m8mf6Tq5W67F8fahUg62O4tfO0aDiGlDkVc6bV2Z2c5lR9aMlakQN2o8FC3cDljNp78afQXSGSCWzcSr07bHro1Haxnn7vpoKUgvMwVHdQDUVtSkUVr9Pf6nCC8k2dBN8luzLFMSVPuvyeMlV70ojqwLHLNsJwCH+zayaGCKSQyVKxH92KMgfyAV892FcdeuNjjp4u8G01wWSynPmN0ClGEX23SsNbuKQ5YT7VMpAVUEV1JSX5i+yjZJ8MeeSvbtOt7oPd2MalGaiV5x9LsNyhY+BF+dLbBoWlPFVtjvhwBCjH/eFuNADoD2UVPb8hh/Oh2/cTptOaYeyFL0gBe6TrGQY0wFTPrmpvjv4UGdDkSKUEdTfHp1o6ssqlh1BGCk2uE3cyh2SO+G99qnamxaYLFWDQviajwRq1HRPCmhW82OA2ofvlE0FmUkkzW1t3P/tLlC1A1cmuolXTWPm6tIX8YNTFrRPwGxmtrBkq1PSmhe6X2mG/ZK74nkrZUGfOLlEjmu0U9ExkgDeRMbxy0Z5BcZ2H7U260Rn6VYmDZpFbtaW6V9RPjM15ytCHd95QCW5Gvp/I47MrFJtvPtRa0WEShY9VgcK5lasCuq4P/CyyDfxEJQvfmr8uFUDCx7BW2LWX18wbw2mlYP7PZTuOpdfOVcAZiW4n1Iu85NhS400LiYgKZ7Wu/abGFIrWfEtcK8hc/RnY4M+v9H4ECbda1lHmSllXKG/ju3y4IR6JFZ8HS+NgN7hI3YaOlmKgGdfVCI6z8MMP2hCJHIx1nhOBkgq1FybTDN7PRtDCM23pMqZuYaavERVvtmQhqipU0RTBZz4nFVBbPLiXRr3DCRDdS4hRxVXkWzLiY37EPLES8Ss1YKFCMcnTYq1SCXci7G4wuHJ8WcyvV73pnOUZ7HpbBJ12gVuZgoxwGw1wTTU/u6cj4ADKLeu8GnLmDfFNxoXa7wVcw9k0JLmDV3HA1LzYUNFpf4vkS1wijHrW0sfO/yHgBXKVAIxjjpMnq80wwQ1VuIF/s479iDzF0hFYpZLNABqp7ccvxvjWxbBpH2YoK4Bzyp6odHLAIFanP9EVr9XRFkjA4hBtV8FDgkKB8sknk+mr1cw1t3pkg0SnXkOoxIOJM31gzEZeDBZdTXs+auDBC2iJZ5WMI/KJrxk1uGJg0l+fORCnHQgn8uCwg7f04keaIno4PEhslcIOTRxDN68bjrf0uZJ54UI/umMOE8QZ+u2JXWcwBAAh0Qp5e4g5fIUYS0QzbLNjG7yplm2Dq2NThu09IC9/YAKI2U7VEzeQhW0VEB4lr996mRlUW6UfNzU4UXrZMSt3odkACiZTacICgBYsxBSiqlt/6oCkzIgQGd545VU1yOSxEuOs2hZrxEHCPBYP3GqVPLkF2eWnpNUADssiCCrQSP8bgjo8T2rHA942dFfEoB9c5P8tZqhOFZAMZ1BCEeRrfqGLjGeVue7p8zbjwsZWbCe+x7UvcdzTz+lYwOzuTIMUEYILTvM1S938LihX4kZYzPFRyA0sP5A7km+AN4DQzdvmlrXoJV3Kv62nieIfJ4VqPFdUy2zxpy2ce3GF2iw25sG4HnhQSWURT/AH7jGYEJRNjqapmIXYT6vswXLxK1XAbsDAjMoIWRAl8QS47BBZL6W7ycMFlolDF5c7N2XiO+Qz8J3jy4BVmYDBtcwSipnRqxpVzTdB2dwKBAgWmzWb+50FaREOLsksDk4bObRNHlkAVAJKR+r22FOKqIYLTkLRujM/qlWjqJOaazEHMN9DH+Ig0zpZ0B6SDoh1r1aVKg7lgyGDlfsTE96fY6CU7gzdksnP5Sf7hfrEcAMfyqKxzk7n9mzn5Cf5KQEcgvZ38uU6e4eAC1whWmbQ9wyijZ4If+cFiTcOFFXLk0FtzbvmYQnEZGPimA2Ewb/UwbRIWkg3qlVITYm9prgZTtTR700qeil/pBB+cazfykDZxsJj2mhKUH6Re0OhrVZkF4wfdNRPXRjsl4yuniB6ZcLleNzDqGPsMIlULUTJysCcFTlmTFteXEUmcLFArl7kF8XKrfOlt+nULVwB3hSZgDa3XJ2mLJaEZ2QjzSrhBMQAdo00fMKvpn7FKirZNsHm5qAdYZ9+W81p9cM84Eae6My/qCeJbw5YL7irM72Tv9PASoQOkheswB3yQ3JIslcDX50+BmAkrnMEmnGC5iUCmWulOI937uYLPZMPWSkKVmuznVBSgYDSxvf5JQm5FadqrpeNutHbi2liGeSMjO/JXINcF14bd2X3yBI4yyv3NgFNJUSbMo+TkU6cxn+NvovODW7V2+ZybKgQBC+t+A9lwxUit22ib6krgUVg2rwyWrN8ADtXSPkCsE73xAJu2yY1vqx+VdAH4hvXYiyfrDbHF3azGoKIHL4gJFacGN9xMi1HziiLoUhtnsZmhF/ChKE42APsCDhFbFY4AYlVroXTKbUYJIhGgVrRNQrAFqOQRjHUnbTqu6unCh+aJs6YloKDFDJ2fpOxYV6aFw3PZM+YzJyhlI92X0I34bGzcr1SMQWScVIVVyfQ4hegFOqrrT7khN2uhtJAZzDPlpQoKcsmB6kaccfdo2qdO1CrxjhoGDAGX2tADeasbaIfgeYjOjJtLF4QAH8Wh6uDNZsOcK2axNB/SsuskOfpuq8g6cCpa8sh+B7taC0JQ4Po1wmzD4MqWCa00ThVAaNn5b5rtbaJiFGPdZ7lOaYFRagvi5g01kibAEp4Q3/aeI4jSygpkmC0HoviLYEvg1+HMbaB0T/QOPtpds2AULW06XqToWK4cKbB4i5adK1nBavoN5s6UxRmzIVU8Sdb0s7lOvFptaUbxf+QTDhK7IZaUc4VUOfw0MD6TFfuG3WA4r2ezAJahsvUqQCMl8it5NoCQ4CgEECynmH6Dl3LjRGwHW4dhLzYClyLIReORcqCD6nxunxqYtam4/gZ0BSRZRA6jbBy9B99zpAxm4szaFMDKGaibXoAHbgXROck8KCXchj/Ccgcot3pfjIqEoNjNBx9MUR4TYIrej2TB4zXuJGSE51VJ7jd0JVfmF4D3YXgDXHy1ErIgpE0i/zJObJ1OsXu07/xb5TIXxrhRTIPN47U2nq7MVgQqoPi2GkNUnU5DeyNAxsgshVrS+oUQ6AKaSzz6e4doRjWdhzUld8RiF+b0lL8GzzQFhJPajcvC8NwkYgaa11xABT4bn3hG8TbrBg3F7ktMEql6jR0Ke61FNcnkzARIK4o7aPrNag9tqWipBC0tCRjuJc163S5Ki+2AZoqyxWtThfRAtNooDj0oocb2MPkIa5iiPcC3yXcuyZoOofstXEW2HtQaFlyDvDb16GawRybiCA+EzIpiQYWokuH/BFQ1G/aG2Vsqx2ASqNMecj4rQRoung2lW6AtIEqAqTb3SK0wV0FXjmKUAzWch6xOZCKFPe1WQfutryYonITxnfBIg28EpWTBv1xUWLdM1x9GeK1tpumznSjNG/w6GyjLwY8fOQuwTnxuIgLh8hbFvDOn9aR2xyl0qKFP/Ns5ExN6xy01fLYIM9Frz7xoiblZNYIyk2M0UEXuhLFXKtORhpLxN+EJeO7MgTlcNCoPJ+idD6vBrxufOGxHu/T3gVukdDOUolpytVtjwNSp+oOXSKIV5pgI/bx0JthNuaXEX5Mg8LzZjiXig2b7Vu2bCiHa46jtZTSV26ZhOcOgSlzV2tTxPQXKSEnW+vxrK9ZRzxnV4OQDwX7EliU5klsPWRSMcTdU4Ua+8mMmEiSBIbOoFpMy7jTVNtzZqvOQoGRo2LChPFxRoBOGSBukgWarDLvK3ZadUa1hfq5i68Be0mFeJHkIguGfv31BjzdWoqCr5XQodFTSfJbNBlMhsUEtHp14CcmEFAbcR77yBYByywqD1RvQt8G/yuEBV8x4U44KgIw5/5CaPl3TXWWkOF8zNlzQuwKaekBA5EL4cRi4lcHe14bHYW1L8MLz8BX0Q2wHERQpr589J4AEpodbO5H7dfta4UA0QtMJIG/3S89BkFucbq41n6vqQh4XJ1CuASqzQBXwvhp5CUidcxcxxZQx7eHCKxK9AAK0+XXps+u8K0EYnPDI+BXfz/eB00PJ9ufGPomtLhjFoAy153cYpEq+1o2omrjADiHsvq5mGkGR/XroSuPhQ4oZ38GMUV6ttyeRTjqwMBmkrDhwgPEWYBpMZkHgKVo2oDiagp1+fHEgba8ghDYvwKqwlb9UFRQAWEx52op0kVxPAgLiORrUH9oIXg3IjOolbB/BftcAa0xn34QJn1tSKFCQ7A75w+Z3YYtGjavY6FZmzCBw1qAEVsp1D63lBArR1WrjAz4+7idETdmwnBmXZW668LoYe5WejSkujVOEWgsaV5bzntZ/UrcdikEH56bNvrV/2t3fPvzR1FvHpwcR9dbB4dp+xLsnSrzFc/86rFsRS9JHwq2fRrjlHpsE1S9Cu3X4MOxF/JHP6SOfU8rSuyefE/Vodqf1tq75aJcriNf2DGuajeeQQxQ3bU4Pm+7c7D56RLyryJwD57DsyU9tKxo7LTwgh4ZTjGgnB3sHQojWCr+8LheV9nICK0MdDmWQIA5uH9wt6ACW9ruYcg3jkK/K+bUJ6rT3yeexZxTWXHjX8iJVn4934ZRXcU6CpHOxAPf3grLMmczqaedFqzXABfsqXG0MxbJgxMmwj1bTYZ/Cneg0xQSQR1C1bX5KwRvK6CiB5+QW02Nkz+NtwMamUrvFRnNFfYWB7wLYJVLzhrP4YrtVqK1T6E6MDrOzSxRehufoP5bFdEHIP6BZhuJXhmpQiB4MfWOCKbacoJ3z5BKDyQi0KQFgnoL3AdP8NEXY/U+9bkgT570cnq9rJuxGM6LI5iQWP+sdWbepkV56nDErKkaAVPHrFTg+l5BbiD4V+XP1NT/fJEGTf9p5RmFFAgDLwZSJOaPHrSeoaUMUQJfOyPk4snsZMUKGN+vMv52ESbg+sPFrMY/cSH6BwySj0nkuULBqVGJCj6z21klLBDthCbUUVbSZk7hOjbrljW5gkkWLPyoErDK6KYKU6LEV18y+Rn/JNkJt2F9huNrEhhsts9vMqxQHDXv+AQMhlIlYdH5ymJYG8kgI2vwbdKmgZBP7WeNmuNvktUeScuc12vNsMZDfFSiUtvrJvweVRSZUGGXz6WDmh8if5Un1zr0GaO7AZUL16JWRo5v2/srmsNAl3LKVovcDzKzs7PVLzpo+F2rJ0chyJ8JYuCUnSgx9vN1fXYDiBOwQg2T8YCQpoWWTGjjIBciSeRVOKgxmJjBupomXiG0+XFTXzQIjAh/dQAY4Ji0KH7F1sTSAQlEyDs0I5gXLbq5LSnprvHhUOhkwFOozu479JEXPSuy1ZU83A8tkDCTBHpHu7DQLoCgVBC4OzBGvJEBnHUTPaFKPfOBUpUCEYt0cbOjDTWKBoUnhidzM44q5RZgCA0fBWlWCE66V3e+LeYVxRj0zzM2B6/fAgw3mCB6ydeuyQFno8+osw96i7oH26N0AAZTFFqVvg3HegiT5oFhgF5kaiKT4XdCDbUI9GPeh17YPpIyksRz7o3gIGIdqGfZWmw3H7Y4hnnPU3owICkDKh9qCAGXFVocazUAd3IeEb58xGgwEXfCHR6YKNVMy/xbB2snuVtQ8oKL+UCYGl3z0o7yWNnFPJAeBm0Sp1eRzOP8MeP4AoKsu27jQTiuJfz43qdvRKG4w0Q6IxO/jYjlQp7qhIYIRnk4x1dZ+kUxnTCl9gzzUMwQ5h4UR5djXAC1d7rrCeekNMabUIfri6ZdxzyI4PCAYC6I8qdAnS3RIXTk6YqydgwrFQtW35YvFv8ZNqDdR7DCKezGh6UpH5b7Imr+zUjUPa0r2Fo3cGcwe1vUiV09vK11YMDnzsMcvqccEVQWzT3ie0xq7SiX5HLITFL6/NRbae7SsTqDuqZwSwZiusEcyvJ2hzE8cTX/1DGsdob1uAoFombe0LgfrdpLrsW4eLOeL8hbdeHPTtJ78ax/LItxcY0xAe7ZwkNCw5rEw7FkvxsubQUP9dEhocvy/2e486Bw4L3K386fOp2bEt1IofNp5VbwrMxeYC2+orQkDzKA1Vw9Aadvp4Z7UJixBLVAgkawIBb+dtchjpOy7W7A7UCw8CFpaGpOtv4KLY9UaVsz/kmtCE+HtaCUIw5PeClGQYOXsdlcJHJleSjQ23l19/EGJIQ13tz8hewXuS/L8eQfdRC6+nJr4msZAuBSi+KZwX+oxzMcYe+Hmu9XOzD3Pdp/T8/rllKUU+XpbyCUFYNYRRPLbh0189tBTqG4wxbiIjIPW7XCz8dGXisB6uiUBVihwmkCafjJckqJx9rFdAR/00GDSsS+MipTNAXJwFs78prc6NTGiNRhHlfcfGf8KHkLeONzZaqrPnrKjVIhQNNvHrDLLsbNpZkVsn5bGOu18ffZV+PxKXbZkE6ieetuveF8mxkjZX3XCNHWi79kLLnj50WvJE86Ykc4mNTImgd3qXosZWDApMgFUatwCtKCeM1aEUxyeTSExPod7msXcbQtYyIAIKDE5LcXEpFnYbvcA26Cduo1gKlEQ6yTTUNqrRFQQaa6cbMPCf0lP0xktyXeL741l0p3DRMrmhSzpw7evXwL+opxieVW2JZtTLULLpyUVKlNs344zPf+m5oQwplS1lRr7MdWNEGa9nEIdCAGaY4U/BLPl7OIiHTaO2JkkUzMvbj3yBQ6dkHW6wdUJzkTsIThDXbpSibozxIPvo7L+RivslANv5eDnk2JYjmt46VKPQpzYIGRw4D8l1+SkYA/5s6V24U5eSe1fSTI1IzG/80edL1F5Pb6T6v/BndSogdkyxUwvVjsFHgTIzQFfoH/hwVtCVWQlWTP6Y9iU0XDubBtjLdpDlG4uAsd/dSnZZ+7a1tPrz2+HGKS9dEf9UtQOYgA+2+FvCEAr6u+8YSq2g0v5U/DT9VXb8e+l1t1negp9jYn3t6Jxvc2HUNVb0BsPSt2wlmvzoTCaQiX3dKB8Xo6rSFJFqPlxkWqhuJXrD21GbqCNsoymby7lqvi3psflv//z/8X1nfnJ/cOY8IzkM/jBkqNIYNCXvafWOlje9ep5j8B8ibWuWqfMQEfh67NLdvFPT2F/Lz1Ib4sJWavGRs6cnB2WSiyHpypxbY4ykbrIgPzbBbP6Qv+GxAUQVc2eVraliVPS2SDn47pGcfiHzqMZhlowdXBOmmp9ouooE447lcwal+IzC3Hho4/E7WAL7SXJExVUhw8UPMmp8VQOEq2oYH3HsYAiu+Ev3Vm/S+3j5YPGfRBlrM/c2q9rkeKd28DhiBhMW79hC3Q7203+iGNWGTDb7k8As+33IzDb8do+kkf7h4cGzrb7KzaRzMFNPgLbfhqwzU1OKZTJL4Js6+8engTQto/InI/InI/InI/InBZYmyXIcF6OFBqYhinueZgipePP9OshRLE9XBKeeODEHCxyVtwxM9xkUmqhkXYSxFZ2KSTi3vHDE0Ii9rdP2tgiD3h3a6nm5VAJMRSvgnqhXsrL53zncnBTkURst9ETQOhCy1apcROh8aUBD/FHen7jpRMy0IeFo0DYuoQ6kmHW4tq9XmQTn1LVejuaAQ+YgR1FNT7LxieY8BEnVUklYOI1E3cLvkCr79o+JEx6L3TSvRFbwVStaM1rZ1zVc7T8mSDj0fmLzthZxWzfXxNNIyJ13Jb2vZkZ/l4KVQo6XNRYrpp2PBLWMlHmXrqWi3sPR4mNvJeBkRbBJKSeM35KybHOS+xEN5R08tnrp0/sPXjWWtaa7OyqpGy/nY2+l0+O3JeJDaKvk4NmDxdSq1Lw5JxvO2fQzwLCL7PARFP4bIYb96pPAMPWOJskx9zJvKmWN5237vJ1XuOF5Lqjq0md6k0Eudsv0B097XTeOnP3qpqitzEqP5xSjuPSmd1w4xK/3jDucWiTm9fl4lLk1aVzHfB244dOmuEHLV93L8Gf289lCzd87/2IBWEl6kDfSx83S05D5xUCTFJi7qAVs3Kro0sGXLY4cveNOzPvgJe084pgI13CcqqxEYYPXlVTQBYsoYj+QyJWFhL9dVJXHih54FmAzoEOCVxH5g6RGIc7ys4SVnUmvRFQqtxorOOH7zl2CNZfFDc2S2oJ3rPssT8BOicCNEFqZ27ZxeUlPPqm+IDrSExF9+yx7I9Ww6+KTyHvc6IL85loVOQ/gPfUgwbuDO9J7T1FKXGReszcp4QEaQJoBu9sY56ehLW7ssWo81nRGTsp+pfuzr/N/rJ/dHx0sNf9nPcIrxK4SB10kT7bKdyLgDExoW/aD1GQraJEMiN/tqHx/Bv4UKJHxaRRniJmMOSECS2QSpbtZgaVmJ9BqOvzf/4TrKRLQBO8c5t0yZv03Xef7eC/m6gYwkcSUBW4B2Z/qSMgna8V8tmfD3kv9ENnnhVAAXUvLIZN4IPA2Ytf8a67/ySEE0cYdlk0XJS2j3jvDwjwxAOSELtgOCduNRMd527Jvv72QM67+5kcC/1HEgUSKEdjg7pwDJyN4O49BqScJCtHDebd5Hd75neRSUa4iijXink38km9XCxvigrqVnlMupjPsKEZr7Mdjzo87aL5+6MjUoenB3FE6uG6iNTJw8OHRxqR0vl/pZhUyr/4GI/6afEo/vbPHojag7fwv9ArQ8fZ7RYzqic9ZnjfItxeyvcCV9kOkPSRj6GErzOaFxSeG83rmRKXYZSrIEQERA+IW5mf0iKFCB+QcqH7h0dw2VenPkieef7RpfaOdWeoMywnE5vJflzXC7CeZ52QKbbFIQFxempgTKAj4aavTFgoyaAd8BlAKax7S0ROT1syrbETvPs0aLy1QWokltxO5RJdjHtGBigxFyPAgd2SS4Bc1lPthgat0LHTKPeZDsk5ssmPX6gWyuvuJRChuZfm6UpsS5GbelRMjKYq9KGTKz9qWcviiarvmSzcCXLQQ4TDAAadeHQMxYbQLFZXkPhM5baPNoM8EnqDaUOYv5wiBzMJuUG4hElIfYuuuMEJUutU1CYF0C1XE3cdbwpfvMPjTQrA42R6xAd9gjsJ7knDsw4IE4C7ABZFzlZiUBR00JT36goeLVp54iIGW7iaZSjD8uLhOHhViIHIFzatwVaDFI3p+eZ13PHZP1y7WUIoLNg0M/SxObL44Mnv0y8vajyBk+A+aHc1f7u4wASArXkym/CZmK8R5Yu7jX8tB3MAxQeArnDprahIwqpOM3yGA60chmL7SOwSjM4JAW5EYiVEagznKNvsAkO/zl8orY7y3Xh63ja+dQv5P8HBc/uFoOEqanQZTXtBfQOz9ExKuSI8gOGZ2Q/GPvdnAVCtXDQK0Z4IpMknklWFU2SUy+CPE2osGPkMKeIFK4KHidWh4YdD8qMmKibFsZwz03PezGnHnbNs+wb6rV8TsWrjgcauXSB2FIBOsPb3pQRNobBLum3XGaXaulWJR3RrwkEsoRtBZDEDtCivsapsy5AsgzmI6RPkLlpUceUAz55C+9GNK6fLtplysR9f0IT2+PLN84sd4NbxCDsf/fUMSFfVJLmm1ooonoA4dio7DcRjznSKzjfFs7hDLEBoKeYAGzYEA79WWMeb2woIvusZ4ePwxYpsAF80KmWJ5smpVMiIIhG5gCaZyePr8w732mAusPsO/ng5Gt3RNdTsoG9Hfm0aCqcazD2D80+2IVSIArFK4ck+o5oYlZC65Qxxcs/zpprevTp7is9l2pfSFU5J08ME05e8aUQslyPDLygge8HdY7T/ubN8poNyfi1M3pgqhxUMvKdEw8jvUr1lZNan0wa5WcO5ZGyxvsnCbk2Nex/9suLyFDc/VcfB8kQZY3TKPyfZdtE6iTcTOoLT/YvG9/6LHTkr40pfysvl7dqZB869Ti3UaO6tJnc4+TITddKP5ytq0hjoiiFRDomkx22NiiEoeSBzEcaVezRQf9CU5Bx9CNkoIAeTPLdv2gwYbL7joimFyxHfpnOJzsbVZCSjnIE0rLBEvyECe/z+y7alGa6R+8kJEXhTOn0MVhL164VsW+dNMSBN/sgJo/kIuy2hTuQm6SVfYQb9FtM7DMFKdQcyXBJIfQF81fj9MSPhEDoCcXNp9u6pGu84PlqtWj5BnZ96qLNXjk5qVld3enKesNjx8uGsnixvnKWAHe6TgL5wrq8LJDCmA9m9nV2WU7dZy/KS/Psu7hF87tZ9WU2dkPL/BKUaqIoVPZI6UGssuHPyEZv4qiVOsb8bTU2uibIbyh3XFu5BJbpsF5C2DkotHHZHBAwsbUpQt1d/kMhni/T6Avhtg/4VNUVgSEwMQY2JHSErOLu4gB3dcfP97ULYwwelHDOwqHu38MOa6cQ9HAcEDj0eG4gvE334AlNG1Tfkbd1X3btrGEvizJcbU20zKYtpbznjPvWySlgi2Aws/KnjUoeEfB11yI7EnpESaJ5JG3bNYMNe4VKIaB7ig/ORb0IQqfz86CjOzovhO3JtwSplcJOIH6zNqJeNrAFBpJIhcVYcmXnF1NStlBtO3g3qJLsh9L1VpeZtO3mNBfv9ALMhzFn7Fkwh55G4VwertLnWLXMSDwA2GH9dkBcHH0zKBTMiYHtMPK5K3DmUb0+L99U1h/0r3CsWZqArrxZiIsvXJ3ELeVNsx1kHZ9I4lxoPotMLk4KFupNrjCxQun41PaCrA3dJcT+pOQBL9rgeR/6nRmENha0HSi/mqixHEOz3GaarqLyEjDkqg8IwAVoNyNKSv3ivpRFD2DQEAhXAF0Pys2FbA+0C6VPUQcbkuQoELwNAdSJAb1rCCoDJ8wHYOp+mzyqUijY0rdiYw3Exd24SHjwxUOvpeyqmhbehyLux2XzSiph4M3VemIMD/4dabhCNBSyRm7MUTEHXFNCAFqsJ56pmmtK5VPG7Sa1c1qDvYvtvF19+QefBmQUEbR9RzQ8dC0h4kvs0E82N16xixvpJKaV/RWf722pGH0W37B7r+aZJrYZO4s4vuKhnmErU3uMGjv8Mj9FTZgeX06xxrImTtxPqmo4Gm7NZ6MBFNpbWip92yu3rbZFHjwD5g2F9/oDMPv2TzLdyMdxQgmqLQ6eTFiwJsZs7JjjwK97bFjYhX3qmjwXudqgJn9jY7mlHYr/ISUkBYMurGMCWAim7OpAFx2PkD8aXbA5A9EgMmAk/6itYKyj4SCqwzmWODuCFKJtxgDuFF8yluZEzuWotQh6P93cedmiQPYS3/X9uZzeTHt/P/ys19hlFhBRVyNluURWgwzvVlbe+tONUw4+3atUkiqnOnh0EZX7p/puTT3/56unrixdfftHFqDMKT5GPuLPQqQJuorEnZFNZzYsnQMWatsVjyzaWSy+vB80XcUWrhkKqbugeaEDio6nQwqIsl/u8umJ/SyNtOxD+HmHpx9z5IhWytGA1t/u7x6/C9jKnLiCqEBI+dHSlbsWMx1EkKIfmEFe7Qs7ni7cvXzJmGtBC+B+Vr/3Cr1JEUuMZSnqO6J2XZmCprrENUh4XQH3t7KdXzghCK8NJmQbqkJzYXuUltGGxYsu8Lnvscicn5/i2GnmNpGrRCVuAlxcAI/Dukf1y7XQTBAt4eKw/NiF1g5RZHyEyIk2WqQS6QtiPr8biUNxponxlYkPWRdB98EQ0q1xIOT5dc6/ZNOVo3LxkDcUWilo37BChkPIVAagZ5sLTVc19d8vOBV3XN0YWLPDeFkFXOvfNZ9IM7V576e7NDtqraLQ/ALNiS/uc4dJHn2p4EyprwRuIvT4jqVZWgsmGKsOws4gH7vhqqyhyOIix/5H7TCIGUKshk8Nkk6YQr7DeZMKEq/tVNV9ghUjMnbj5ED5ZAFZu09npvHZuXbq1Rl5BU8oD46ix/wJ7LmWf2A4MVDa9+MbJjqZlStCd3FNTX9IQqVDbpvYDGgt4dckBrOvGH1Tfw8EdYyWhU4eMVZuo2mqeCCditgFl31XxHox3jlnFg1iKOxoLROK89HT7Gz6RWCSvilljby1V/cq+R/U6vobwK0olUUMvemVWp+g13ECnmEXFP4tWw+qxCXrvaIdpy0h+r5dbTZ1RVI1Ie7RHEbjMDEJsO2BKai8DpNeJOxlEE1GWqLkBpT2sG3eI3RlmS7qa2nhw/PQJad2Cy3tP8+kHiGlUC2Ssm78D/AEt/10FAmwIeJ4GCiCG71R0EnACt5YsyowXq/lg5b8gbQcsAs3y+hoCvoE7TEZv4W4bC1F+S1a506Wk/gqZeQXbopFrAvmwV+k9VOVxIyFOLRsgjAlERqiGm1kxLFf66FNsCYlBAxszkOCz6QwNe3kf7YICm1WYD92IpQvvAblBDOZDSvNY3fCOrZizRPls4rMYd75CrCTAkioakw+GOwddsgi6dLgpSj23t5+SevKu8M7LH/qFGVbY3+eKxToTr9xyVk+phzHeLX+16rmPvMI121CyYbxGXCQ11ODR3Et12x0KNsCJQAK/B7DAzWYAIJR/kZwqG1fuGKFLg5btrJ4tZ81m4xkgSJfT0j4pzT5O17fnqviE4DUG1M60p8lsURMYMqNEtqiMTRWxFeyYGfECeF/br4jnFTLArYghmCnwVTtBNBvUwPuEJxAPAtyHAgwePq5O9y3u0n4TNSuHtM0zMAy03cvB7uwDlfvMrJ8mDNTFnLt28dsalOOKOtNDcJLkBtHjJad9XaAlX34oh0u0Qi1HEEU0iRFOEVUogaiVL4guOfc+f6tuHb4xQGdvtomfXPjsISL0aehPiKRTtPUccxEY3eMjQl/b9NYCAA6vS9OoPawCiST4BklJaXVpss4SSvIQBGq8+WHFcAEDIz0O/NDnTJnHYAvQaZAXo0eh2Kb29vxTqAXKeQ/bFl0VFFGl+rlkuVkytyxMygspq6Yilh2oXsX7OS4v5bIIjxWmuN++SI4H2R6rIcFr0uxKjxb2umQ3YwxBPKr5eIFmpHBlui2/NRDG9q/ggTim7XYHVySz0usQzGNykZxM05gZFvCIMzBDZ4BaBUdhNywhY/5YsBBe+JgbSu2mbfK0sg/54/quLDEqDPX8RNoBVY2N5tzhL0A4E0cudXCiUEtNwENOOcBgcKI4RrahFSkQaVgB0GExwITL4usPJEuxUMU7iqvGDo67OJ/llFPNznOsJ1Lq/dc3zsKw8fdO9w//sawX3Q3XLu7MJHIyLHf2k7kTUavG46pUtHYE+ynhxDl3oMulSajuESRrcYNdirHnKooy99b+US/fLAdlG2EXmqh6TboXBZg2LPSJ0AgSB3BAsECo9nHHAJEm6Hp6YgMfUHQ+8PlDIgf5fpskki2WKc/AsLxz38bCnDAwQbZK0oAMXv+Xw7KYfn3OuSifbRvDEWsogJDrgJyDdnDgZ9wH9i25lkFHH7S53bf68MPxPq9W7WAGa7kv7MMXuKJPxIibYMuU+RUAQqeHkW8K9fKhfk3+ZStg26K8fcRKrNvQCL8F5tzZz4AECdUNt0nik7DK7Q5WtN24bW7wiMB44rSE083c65XwBn0V4zYIizYhB56YOuDBaCL4/Hd4xG0oqPsHz3lVMX4sacZC9Bej9fUCgu4cJAixRVshSneiYh32BDYv2Arl24dFPMO9rcRz4PKVLeFtojfQECqlBhxCpe0atLSPcO1afZiqnArw8DumKKlHY+2gCurxT3pwaJyF68Qm/ftO93Ps8QBliwGY/qdNKtO5XekV74sRz9bjDcTPKdmhr7/psa7oOU/ALRlWBr/8mVeW2A5pOIDKVrdFmi3j2f6FtgdCXT2j+N20T9xHP/NssunwnE3VRBM+p09/+W2uQe7eznSDWQ6bibm1tLutTRkm899Bk2e8iiAkSBHyZXHm2hWJDtR78J9zp+KnI45rQrt31TOF9MtA9mEurbdEL0UbA4KftqTcFnpMOJn61Z6BBjQkwiuFZwKWQ8iybZD/ewzpAivN/fH73/UEthpZ5p1ve1j535kvGae9KK596YlAqhlXKijMaSTGSG3BLBIFovgYpJzZO2UF36ZG5RqR/BIj5wFdtVtQOB7FiZYAp9YpWYkWdunDbOAYdInaGbB6NGnXzhpSjp9/FTRTjAnHUUB7XniwLh6HtOj1NK/fc7Ny9v8NhJo4pxAwPAp8SQ4UPTcmLd3HP3zvDxFjhRnfKdDO3LyvgKOZZ6TycYBfcqieF4L23MYvCRZwsHvAvvMVRoenvVbaPj8e1exhrm5WQLEmo0FLCujC5568t9J8jF+hs2KiIX/4Pjjrgv1Ge/wCmyuZY6+HrR08D3YhrI2a1NfXZasoSrqzxxFvGAcrPlqPD84vp28DVLDp6dnudet+dByszQeAmdyEn5hfkeQgK0iHVW7hcwUXKT64vIKwEdwYDEYLj6f2Gydapty5up1B1Hn2w/cP/MnEODRkiNxBmI2bH75nU+tTztjIP5hIFuxA+zXApD4lHyEcAK0oIBxGr2IolS5Fw63F5IiPDfBYNA+9HUYlWSMbPGoKVDHsAARmqr08w98ocIyRsimeAYO5+6mTJJ5anBx0G3ZDfhD3P4RL87C0L+F9w+9sBvXFE0IDLQeTqgHMhJrQWtozp7BFM4RSam5h4QQclKzcAPCOeypBcBSYRW7LQVAZJkuJ3FJ7trBtNrV+QWBMC3/SBGgmAlLPSx/xxu2Oc3IRgqq1DtFfBbWJqoadLgD7AIC7GHf9Tpkin3p65e6GcHvsR12vG49L3OjpmWEPxTydyC4jVbqd5y+eWTAHpSIAPOdmohQ+pvWiau8E7QJWTP8EItD+QUi7cLi7jnZhb/fo4dG+8i7oAn4d3oWwWP0j4cJvubP13t5uhnbhf0khP/Iv7LlHVyd29B6E8ahHCJw0heG+J2R4xN+HNDJ+PyBmWDlykqlhD8gIMaQiZXHEzABOD2VXBV7NJjZA8QhYJS7U1OP7hMD6978jNPF7yU+iMal2wN9fveSRt7Esb7acO9mHxcj0ccW8rjSnpE5+/zuE/VRReQUeB3SWeJN6cP0FD47aaVjC4QFerA8FNiea3emPQDf9/ncSSx5zA0Iquxdj2ylMBI0k2SgO+0Ln2Oo++ALQzsXE0/WsFM77wIlzL47m/nFvt9/bO+i4e+Pe/d5hxIhzsk40Hxwf7vf7hhLnVyRpXnNYP0rq3yY1zv7DQESvPuIg7dwENxW6fhqP66lGTom7Nv9M51XFQaVY4K0cPCnx9g/6LPGWi6BbIQZWEA+O3GQ0qqoFFO0+ikwhWun8BJ7uljje4ENH1uo20v6hfzUtUTR5gVtRhAla3S+wCmARAUeBp+oDYiyK+aRizCr8BKw+CQAo6TEXpwvS2Uk5zWVT4zuIH1vOObf2y2r0l8Pd/t5xv/v5XykhKY+PwXkJ8kFEHYF7WD8UPCFE2lLC8WD3JCsdfW426PUE59p3IJQUVwJbk/k9vaCmpdjxUQQYbAGAk1aqPTMylXSECFLeqZi6TgY4m2CmYjnDkB6hoUrIRJMqQy4+yYVKVi+YkxMJgDZjq4eJn5LTQRriBuprCD5PEGNI9Cm2+JdQQfu9/hF4B04c7kXewXoV5A7e0f7R/5AKWiM+Puqg36oOOgr9hI+S5H9aknxHAgHJrwAS2YOsPLY6Siv5Y0PLLr/pvPC/CbnZcyOn2efcjXgJ0WxQknJKPcOcUlYz7xQ6GjQk+gwQuSLPAFuoJW3+g72DPdJrwC3cz5Cchz25IZI/JhQvbuQtx9zB4eRjgEikIFhGINIJsOvLdjGCVnhpprJ4Sqm81qe7cOO04AS43BZWJ0uHHO8VPgiEhPEJkC9BHFJb9PG07TUL/ct87ityZOUCTPoWYIYQomuX3uG6053xINIXgOSphLa9NVCqtaAnCYEgfw9pcONfTmNuqxyBFfPdvd9PLz/TnD7Dz5HoSBK1LraDZzgQtW6rnN8UVOboUydgwUYvOGJqd/IIoFFy3zKppfA3WXb3ZBClUDx6R7q2Irc0J1VAfQfhAB/DwUwb+Olj7AGJXF22B2Nwtq6IoTaxcScZWkCcwz85vKR6WlLj8GI0wjiGrbO9KplYT8sJcfPSk+ZZFDENAYIAAHDBIwjfp5A0J7nPGwOg3N7H746r63GCtByW0WJ60mWgG4Q30dZIUuxfIG7cdRwdFi5jbKiwrrDuByqa4OCy32jzgWanZ75TmFP6FRalmm3Adj9UqgmjhyzMm3RJX87cvqkQPtje/1OW/gb26LBdzCE0yx7I5wwv9gdVSEphpywQtyVaZTRRm8AhSo8m6BcTupPOxZw3VpSlQBZwVaMWa/XtGAJw8tqoo05DTUMPOkI4DrmNpvOg2i63eRLYx/72AdRFRz92N3nkWxcpjP/TzLPnRHvUiBwPG5SuenCWPgKfNSwvC4/Fg+ZTvw/bnS/q2y0WIbgqXbmYNuTfA7QqvVoG5NFfrVJVEYEYocYaaXhtlW2vxE/DL0F7tGK8WPKsLTUlx+6mXIzrkSUvwl1RqbFG+mXGoipuoyec0Q1mExf4WS3BXY94OxPDToV+D9eIwyxCSCJvwAbjBjufs7PCDLq/CTjqu/IuY0/k+yfooZPdbe+n1u+era/fDat307Ip3gs7obRORup2HjtzR6ppdYkNiESt0sEjpQp9opxqgLRldb0MnI3seFIMPPFJ1AJUATWAaj/pbrivnO5sYQTwAHDfYidEUnIM3aw3iMvUD+M0Ku3jqGjGVKSycC7P3All0pO35WQIWRppNMCw4Q3OWstW88Vnz9++8KsQtamYZqqIUkvFXzBxMTIWV6fTNgRuqbGuUklG0pueUeRfCjmsLQcCyCc2jwwm4twOLzZhF4YFfVLNYmgZoXBBtXymO2VfuxjY5ehCtIbNLibzVO3WJ2uexyef2O3KDLyXOLspeMvb1y+19RsjMEjEmXbV4e+DxtaWK77jxphCSCbZD7yvHRXCRbUFiG1KgY6QWFKMGE8vi81GW/LjPZ/4FDhxcnHx0pCz4MdbLCiH5RxEA9OpKGUesX0K0Puvb96cwyzw/1s7JeUFSBEdykPuZ87k1wTeciPgWuphPZHuuVeZp5I4gJzczDUMdz5/ygq0a5C2DPbeJypXtLi3Q58kX2oSGDirplP35FCrYiQyzIWRgDVJxSNo/AohivtCPtz/Hnb6u6f77n+P7wv56B/tH5yY3q+ygF+p1UY+XPQxovvbbgB7lAKA/MbiaN0/f/cd3SVEdmF8E8Kb8N4koe1GclYTxj77JysabFzI99LojMM9aKSBfIxMVTNyF8CDXAKoAxHXkLjTPCbgd2kxo5BQQnxRUI3vaPdukVC0bE59FCpMHhr36MEU4yACkrYVhmKmEKxTkBWaClXPH3QEgHdSES+2JZKx1yMFXCjpIf/Vt3+Z/94XUc5/nQR/HQd/HQV/HQZ/hWPuB3/tBX/Zldjv0bew8RdgCzvY/mwizQcXY+Z4OY3agu32dx+edD+PTs1p5xHWoT5z8pLrkNyrf65fiN449WCnaoyxb6G2fjE/fP/LrqattbA9lHu7ci8YGHopWcU+KSCnf67q5Xxx1+sfHO3v9gaL3t6283YQeeTUB2olEUTuZpXl1EnlhQxzdJTWY7ezHqd8doiir9nZ2+0f7uwe7ET3e3s2vWbFWizdOZ/LZF9O3Q48ry+QpbKRT3E7LzHlHj1JvISxc1viyXayCdhDwADtnpzuH5zuPbyvrt57+PDh/rFJwMq+/zq6OiU0w+RP+hs/u+7B9QFgpd+arzcEHsOkMIdvRxeBWA8zIr2/jyJ9Ap2ebkvq94QkiSTDLQmhDEesT50LKetD3lCpK5qT58H0jTwKyN1JufiESyTRP6m+LaE0BjNbzrFMitZ9SIhb2QDVRE/KBcY7SCowLptLi8hgB+VBzQEl6tBsz8Yzbgj4+98BSzTUHbpb7P6qrjoPCEh9iQGv5kHnk6/Pnzy5ZA3xSefTzh+Km9mf8f90/lXG9N/mFoaXo9HkcuJ/9Gnnn6ChaZahuBJ1NDNXZj3AOV9eMpfgJz99TotyySAr+r+sPDvOgC02l2d00KmM7rcg244Qet7vOHPb3fCDvfuCS/b3D/ZOLL6x/yuCS/JyJMSwrfrezw+d2AUL++O13nhOsPYZtJ12osyOw/nBr8Suk3cSrAPl1Al85H5UTvULRre47z73zpZTg9ihGV/7aXdX3RAB5K8b7ghgEYLdj0bb58d0+q3bLAeqsprLG3dOdGw4gOWHWTVXX9N9XJ0eH+4dqRe0B7f4rrnkIrbIseVPpW2sV7w4u/vtpB4Wk+rbyJmFf0FWLAh8XA5n4b/wnWh6NwX+i5Me/6S7obh55OkWcaZ/wI9tDJOvJvTpFEERUMvE/25moBw9zzDQPzLdFMOqlD2zjFfuUZwNzs2mZZYb/LR3Yz41a8MgOb/Vhfy3/QL6uvyF9/Lf9uEhYMgPd8P/uQFExwnpILqy95Dn79EW79g/QHa0XgCEHbArKrLbuqvVo4qLHXYA+Tdmz/cNbJy2eSf808zjXwPsMG/4zmgkGD/5avg27AzhvkeryryYA94Ep3eHV/Jd+2ZA4judjC9iR/7DfFHf0P6RWYl7LTv2jx5yHs/NFsmbO9hPxr92Ep/Jr8M3+R0ONy6aMVmFp93Dg8Hx3tXh8GA4Onx4fFIcl/3D0eB4sHtQ9Acnu0da2IK5gUu5kJeiTbt/Hjj9+R3jwaEM8xK0ZwPvuiqbS0rpg5btH/VPHu4enfT7fyYsOH45lEmZb0PUzU1dXvYvdy8xaHIJkb7Baf/P3/1/KtYAng==","no"),
("3111","wpml_dependencies:installed_plugins","a:3:{s:26:\"sitepress-multilingual-cms\";s:6:\"4.4.10\";s:23:\"wpml-string-translation\";s:5:\"3.1.8\";s:27:\"wpml-translation-management\";s:6:\"2.10.6\";}","yes"),
("3115","WPML(ST)","a:1:{s:50:\"WPML\\ST\\Batch\\Translation\\Records_schema_installed\";b:1;}","yes"),
("3116","WPML_Group_Keys","a:1:{i:0;s:8:\"WPML(ST)\";}","yes"),
("3121","acfml_options_page_revert_done","1","yes"),
("3123","acfml_block_migration_result","done","yes"),
("3125","_icl_admin_option_names","a:2:{s:16:\"cptui_post_types\";a:4:{s:7:\"country\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:6:\"assets\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:9:\"statement\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}s:14:\"section_blocks\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:29:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:7:\"add_new\";i:1;s:12:\"add_new_item\";i:1;s:9:\"edit_item\";i:1;s:8:\"new_item\";i:1;s:9:\"view_item\";i:1;s:10:\"view_items\";i:1;s:12:\"search_items\";i:1;s:9:\"not_found\";i:1;s:18:\"not_found_in_trash\";i:1;s:17:\"parent_item_colon\";i:1;s:14:\"featured_image\";i:1;s:18:\"set_featured_image\";i:1;s:21:\"remove_featured_image\";i:1;s:18:\"use_featured_image\";i:1;s:8:\"archives\";i:1;s:16:\"insert_into_item\";i:1;s:21:\"uploaded_to_this_item\";i:1;s:17:\"filter_items_list\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:10:\"attributes\";i:1;s:14:\"name_admin_bar\";i:1;s:14:\"item_published\";i:1;s:24:\"item_published_privately\";i:1;s:22:\"item_reverted_to_draft\";i:1;s:14:\"item_scheduled\";i:1;s:12:\"item_updated\";i:1;}}}s:16:\"cptui_taxonomies\";a:1:{s:6:\"region\";a:3:{s:5:\"label\";i:1;s:14:\"singular_label\";i:1;s:6:\"labels\";a:19:{s:9:\"menu_name\";i:1;s:9:\"all_items\";i:1;s:9:\"edit_item\";i:1;s:9:\"view_item\";i:1;s:11:\"update_item\";i:1;s:12:\"add_new_item\";i:1;s:13:\"new_item_name\";i:1;s:11:\"parent_item\";i:1;s:17:\"parent_item_colon\";i:1;s:12:\"search_items\";i:1;s:13:\"popular_items\";i:1;s:26:\"separate_items_with_commas\";i:1;s:19:\"add_or_remove_items\";i:1;s:21:\"choose_from_most_used\";i:1;s:9:\"not_found\";i:1;s:8:\"no_terms\";i:1;s:21:\"items_list_navigation\";i:1;s:10:\"items_list\";i:1;s:13:\"back_to_items\";i:1;}}}}","yes"),
("3127","wpml_language_switcher","a:9:{s:8:\"migrated\";i:0;s:18:\"converted_menu_ids\";i:0;s:15:\"languages_order\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"da\";}s:10:\"link_empty\";i:0;s:14:\"additional_css\";s:0:\"\";s:15:\"copy_parameters\";s:0:\"\";s:5:\"menus\";a:0:{}s:8:\"sidebars\";a:0:{}s:7:\"statics\";a:3:{s:6:\"footer\";O:19:\"WPML_LS_Footer_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:21:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:6:\"footer\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:1;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:7:\"#444444\";s:18:\"font_current_hover\";s:7:\"#000000\";s:25:\"background_current_normal\";s:7:\"#ffffff\";s:24:\"background_current_hover\";s:7:\"#eeeeee\";s:17:\"font_other_normal\";s:7:\"#444444\";s:16:\"font_other_hover\";s:7:\"#000000\";s:23:\"background_other_normal\";s:7:\"#ffffff\";s:22:\"background_other_hover\";s:7:\"#eeeeee\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"post_translations\";O:30:\"WPML_LS_Post_Translations_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:24:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"post_translations\";s:4:\"show\";i:0;s:8:\"template\";s:29:\"wpml-legacy-post-translations\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;s:22:\"display_before_content\";i:0;s:21:\"display_after_content\";i:0;s:17:\"availability_text\";s:34:\"This post is also available in: %s\";}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"shortcode_actions\";O:30:\"WPML_LS_Shortcode_Actions_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:21:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"shortcode_actions\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:18:\"include_flag_width\";i:18;s:19:\"include_flag_height\";i:12;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:0:\"\";s:18:\"font_current_hover\";s:0:\"\";s:25:\"background_current_normal\";s:0:\"\";s:24:\"background_current_hover\";s:0:\"\";s:17:\"font_other_normal\";s:0:\"\";s:16:\"font_other_hover\";s:0:\"\";s:23:\"background_other_normal\";s:0:\"\";s:22:\"background_other_hover\";s:0:\"\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}}}","yes"),
("3128","category_children_en","a:0:{}","yes"),
("3129","category_children_all","a:0:{}","yes"),
("3133","otgs_share_local_components","a:1:{s:4:\"wpml\";i:0;}","yes"),
("3134","otgs_active_components","a:2:{s:6:\"plugin\";a:11:{i:0;a:3:{s:4:\"File\";s:48:\"advanced-custom-fields-table-field/acf-table.php\";s:4:\"Name\";s:35:\"Advanced Custom Fields: Table Field\";s:7:\"Version\";s:6:\"1.3.12\";}i:1;a:3:{s:4:\"File\";s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";s:4:\"Name\";s:38:\"Advanced Custom Fields: Theme Code Pro\";s:7:\"Version\";s:5:\"2.5.2\";}i:2;a:3:{s:4:\"File\";s:18:\"acfml/wpml-acf.php\";s:4:\"Name\";s:35:\"Advanced Custom Fields Multilingual\";s:7:\"Version\";s:5:\"1.8.2\";}i:3;a:3:{s:4:\"File\";s:34:\"advanced-custom-fields-pro/acf.php\";s:4:\"Name\";s:26:\"Advanced Custom Fields PRO\";s:7:\"Version\";s:5:\"5.9.5\";}i:4;a:3:{s:4:\"File\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:4:\"Name\";s:19:\"Custom Post Type UI\";s:7:\"Version\";s:5:\"1.9.0\";}i:5;a:3:{s:4:\"File\";s:33:\"duplicator-pro/duplicator-pro.php\";s:4:\"Name\";s:14:\"Duplicator Pro\";s:7:\"Version\";s:5:\"4.0.2\";}i:6;a:3:{s:4:\"File\";s:28:\"real-media-library/index.php\";s:4:\"Name\";s:18:\"Real Media Library\";s:7:\"Version\";s:6:\"4.13.4\";}i:7;a:3:{s:4:\"File\";s:40:\"sitepress-multilingual-cms/sitepress.php\";s:4:\"Name\";s:21:\"WPML Multilingual CMS\";s:7:\"Version\";s:6:\"4.4.10\";}i:8;a:3:{s:4:\"File\";s:34:\"wpml-string-translation/plugin.php\";s:4:\"Name\";s:23:\"WPML String Translation\";s:7:\"Version\";s:5:\"3.1.8\";}i:9;a:3:{s:4:\"File\";s:38:\"wpml-translation-management/plugin.php\";s:4:\"Name\";s:27:\"WPML Translation Management\";s:7:\"Version\";s:6:\"2.10.6\";}i:10;a:3:{s:4:\"File\";s:33:\"duplicate-post/duplicate-post.php\";s:4:\"Name\";s:20:\"Yoast Duplicate Post\";s:7:\"Version\";s:5:\"4.1.2\";}}s:5:\"theme\";a:1:{i:0;a:3:{s:8:\"Template\";s:4:\"milo\";s:4:\"Name\";s:4:\"Milo\";s:7:\"Version\";s:3:\"1.0\";}}}","yes");

INSERT INTO `wp_options` VALUES 
("3136","wpml_start_version","4.4.10","yes"),
("3137","wpml_string_table_ok_for_mo_import","yes","yes"),
("3140","wpml_update_statuses","a:36:{s:31:\"wpml-upgrade-localization-files\";b:1;s:41:\"wpml-upgrade-fix-non-admin-with-admin-cap\";b:1;s:42:\"wpml-upgrade-table-translate-job-for-3-9-0\";b:1;s:50:\"wpml-upgrade-remove-translation-services-transient\";b:1;s:35:\"wpml-upgrade-display-mode-for-posts\";b:1;s:42:\"wpml-add-uuid-column-to-translation-status\";b:1;s:46:\"wpml-upgrade-element-type-length-and-collation\";b:1;s:45:\"wpml-upgrade-add-word-count-column-to-strings\";b:1;s:35:\"wpml-upgrade-media-without-language\";b:1;s:38:\"wpml-upgrade-media-duplication-in-core\";b:1;s:26:\"wpml-upgrade-chinese-flags\";b:1;s:51:\"wpml-upgrade-add-editor-column-to-icl-translate-job\";b:1;s:25:\"wpml-upgrade-wpml-site-id\";b:1;s:35:\"wpml-upgrade-wpml-site-id-remaining\";b:1;s:43:\"wpml-upgrade-add-location-column-to-strings\";b:1;s:41:\"wpml-upgrade-add-wrap-column-to-translate\";b:1;s:39:\"wpml-upgrade-add-wrap-column-to-strings\";b:1;s:46:\"wpml\\upgrade\\commands\\addcontextindextostrings\";b:1;s:56:\"wpml\\upgrade\\commands\\addstatusindextostringtranslations\";b:1;s:54:\"wpml\\upgrade\\commands\\addstringpackageidindextostrings\";b:1;s:46:\"wpml\\upgrade\\command\\disableoptionsautoloading\";b:1;s:46:\"wpml\\upgrade\\commands\\removerestdisablednotice\";b:1;s:54:\"wpml\\upgrade\\commands\\dropcodelocaleindexfromlocalemap\";b:1;s:46:\"wpml\\upgrade\\commands\\addprimarykeytolocalemap\";b:1;s:48:\"wpml-tm-upgrade-translation-priorities-for-posts\";b:1;s:43:\"wpml-tm-upgrade-default-editor-for-old-jobs\";b:1;s:41:\"wpml-tm-upgrade-service-redirect-to-field\";b:1;s:46:\"wpml-tm-add-tp-id-column-to-translation-status\";b:1;s:67:\"wpml-tm-add-tp-revision-and-ts-status-columns-to-translation-status\";b:1;s:60:\"wpml-tm-add-tp-revision-and-ts-status-columns-to-core-status\";b:1;s:32:\"wpml-tm-upgrade-wpml-site-id-ate\";b:1;s:45:\"wpml\\tm\\upgrade\\commands\\migrateaterepository\";b:1;s:61:\"wpml\\tm\\upgrade\\commands\\synchronizesourceidofatejobs\\command\";b:1;s:52:\"wpml\\tm\\upgrade\\commands\\createatedownloadqueuetable\";b:1;s:51:\"wpml\\tm\\upgrade\\commands\\refreshtranslationservices\";b:1;s:34:\"wpml-tm-upgrade-cancel-orphan-jobs\";b:1;}","yes"),
("3143","wpml_st_display_strings_scan_notices","1","yes"),
("3144","acfml_field_groups_default_editor","1","yes"),
("3145","WPML_Upgrade_All_Admins_To_Manage_Translations_Has_Run","1","yes"),
("3146","wpml-package-translation-string-packages-table-updated","0.0.2","yes"),
("3147","wpml-package-translation-string-table-updated","1","yes"),
("3148","wpml-package-translation-db-updates-run","a:1:{i:0;s:5:\"0.0.2\";}","yes"),
("3149","wpml-package-translation-refresh-required","no","no"),
("3150","wpml_base_slug_translation","1","yes"),
("3151","widget_text_icl","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("3152","widget_icl_lang_sel_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("3155","translation_priority_children_en","a:0:{}","yes"),
("3156","translation_priority_children_da","a:0:{}","yes"),
("3157","translation_priority_children_all","a:0:{}","yes"),
("3158","wpml-old-jobs-editor","wpml","yes"),
("3159","wpml_translation_services_timestamp","1618577941","yes"),
("3160","wpml_tp_com_log","front.net/production/logos/memoq.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_memoq.png\",\"project_details_url\":\"\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"c6e1c5624529722f2bc138dcd0c63ee5\",\"doc_url\":\"https://wpml.org/translation-service/memoq\",\"notification\":true,\"tms\":true,\"has_language_pairs\":true,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"Your translation provider will provide your memoQ Connection key and Connection url\",\"how_to_get_credentials_url\":\"https://wpml.org/translation-service/memoq/#requesting-an-account\",\"client_create_account_page_url\":\"https://wpml.org/translation-service/memoq/#requesting-an-account\",\"partner\":false,\"review_url\":\"https://wpml.org/submit-your-review/?parent_translation-service_id=1403359\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Connection key\",\"name\":\"api_key\",\"type\":\"text\"},{\"label\":\"Connection url\",\"name\":\"api_url\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":true,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":false},{\"id\":82,\"name\":\"Pseudo Translation Services\",\"description\":\"This is a demo service for learning and practicing the WPML workflow for professional translation. To authenticate please use any string as an API Token.\",\"url\":\"http://lvh.me/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pseudo-translation-services.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pseudo-translation-services.png\",\"project_details_url\":\"\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"a31f833a7b129003abe76987b06c8e44\",\"doc_url\":\"http://lvh.me/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"API Key\",\"name\":\"api_key\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":false},{\"id\":83,\"name\":\"Lilt\",\"description\":\"Lilt is the new engine for enterprise translation workflows. We increase quality and speed with the neural feedback loop which combines human ingenuity and machine intelligence in a virtuous cycle.\",\"url\":\"https://lilt.com\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lilt.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lilt.png\",\"project_details_url\":\"https://lilt.com/app/projects/details/{project_id}/documents\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"ffad5fa853bba0b6c9eda94b382b0201\",\"doc_url\":\"https://wpml.org/translation-service/lilt/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"API Key\",\"name\":\"api_key\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":117,\"name\":\"Smartcat\",\"description\":\"Smartcat is an all-in-one platform connecting businesses and translators into a continuous translation delivery loop by combining a collaborative workflow solution, a marketplace, and a network of translation professionals.\\r\\n\",\"url\":\"https://www.smartcat.ai/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartcat.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartcat.png\",\"project_details_url\":\"%{server_url}/projects/%{project_id}\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"d1c696251639dde597dd81b6fec113a9\",\"doc_url\":\"https://wpml.org/translation-service/smartcat/\",\"notification\":true,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":null,\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Server URL\",\"name\":\"server_url\",\"type\":\"text\"},{\"label\":\"API key\",\"name\":\"api_key\",\"type\":\"text\"},{\"label\":\"Account ID\",\"name\":\"account_id\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"api\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":121,\"name\":\"Smartling\",\"description\":\"Smartling is a translation management platform and language services provider to localize content across devices and platforms. Author of Enterprise Translation Cloud, a data-driven approach to localization that helps customers achieve higher quality translation at a lower total cost.\",\"url\":\"https://www.smartling.com/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartling.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartling.png\",\"project_details_url\":\"https://dashboard.smartling.com/app/accounts/{account_id}/account-jobs/{project_id}:{job_id}\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"3f1d34db7a1c34e0840e81b4aceb97db\",\"doc_url\":\"https://wpml.org/translation-service/smartling/\",\"notification\":true,\"tms\":true,\"has_language_pairs\":true,\"deadline\":false,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"\",\"how_to_get_credentials_url\":\"\",\"client_create_account_page_url\":\"\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"User Identifier\",\"name\":\"user_identifier\",\"type\":\"text\"},{\"label\":\"User Secret\",\"name\":\"user_secret\",\"type\":\"text\"},{\"label\":\"Account UID\",\"name\":\"account_uid\",\"type\":\"text\"},{\"label\":\"Project ID\",\"name\":\"project_id\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":false,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true},{\"id\":144,\"name\":\"SDL Language Cloud TMS\",\"description\":\"The SDL Language Cloud TMS connector for WPML provides a seamless link between WPML and SDL Language Cloud TMS, allowing fast and easy management of multilingual web content and translation projects from within WordPress.\",\"url\":\"https://languagecloud.sdl.com/\",\"logo_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/sdl-language-cloud-tms.png\",\"logo_preview_url\":\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_sdl-language-cloud-tms.png\",\"project_details_url\":\"https://languagecloud.sdl.com/en/cp/dashboard\",\"add_language_pair_url\":\"\",\"custom_text_url\":\"\",\"select_translator_iframe_url\":\"\",\"translator_contact_iframe_url\":\"\",\"quote_iframe_url\":\"\",\"has_translator_selection\":false,\"project_name_length\":128,\"suid\":\"a87dad5a887e062d5a269574bd54fc3b\",\"doc_url\":\"https://wpml.org/translation-service/sdl-language-cloud/\",\"notification\":false,\"tms\":true,\"has_language_pairs\":false,\"deadline\":true,\"oauth\":false,\"oauth_url\":\"\",\"popup_message\":\"\",\"how_to_get_credentials_desc\":\"Your username and password are the same as the credentials you use to login to SDL Language Cloud\",\"how_to_get_credentials_url\":\"https://wpml.org/translation-service/sdl-language-cloud/#connecting-to-language-cloud\",\"client_create_account_page_url\":\"https://oos.sdl.com/asp/products/ssl/RegisterUser.aspx\",\"partner\":false,\"review_url\":\"\",\"uses_ate\":false,\"custom_fields\":[{\"label\":\"Username\",\"name\":\"username\",\"type\":\"text\"},{\"label\":\"Password\",\"name\":\"password\",\"type\":\"text\"},{\"label\":\"Client ID\",\"name\":\"client_id\",\"type\":\"text\"},{\"label\":\"Client Secret\",\"name\":\"client_secret\",\"type\":\"text\"}],\"default_service\":0,\"translation_feedback\":true,\"feedback_forward_method\":\"manual\",\"rankings\":{\"quality\":0,\"quality_ranking\":0.0,\"speed\":0,\"speed_ranking\":0.0,\"popularity\":0,\"popularity_ranking\":0.0,\"primary\":0.0,\"primary_ranking\":0.0},\"ratings\":{\"wpml_average_user_rating\":0.0},\"specializations\":[],\"countries\":[],\"certifications\":[],\"redirect_to_ts?\":true}]\n}\r\n","no"),
("3161","wpml_translation_services","a:102:{i:0;C:15:\"WPML_TP_Service\":2570:{a:38:{s:2:\"id\";i:67;s:8:\"logo_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/icanlocalize.png\";s:16:\"logo_preview_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_icanlocalize.png\";s:4:\"name\";s:12:\"ICanLocalize\";s:11:\"description\";s:300:\"	\r\nICanLocalize\'s seamless WPML integration ensures quick delivery of translations while our professional linguists focus on quality and accuracy. ICanLocalize provides a safe environment for the translation of your website in 45+ languages. Choose ICanLocalize by OnTheGoSystems, the makers of WPML.\";s:7:\"doc_url\";s:50:\"https://wpml.org/translation-service/icanlocalize/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API Token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:4;s:15:\"quality_ranking\";d:4;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4154;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:42.95;s:7:\"primary\";d:4.85;s:15:\"primary_ranking\";d:42.95;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:51:\"https://www.icanlocalize.com/wpml/registrations/new\";s:19:\"project_details_url\";s:73:\"https://www.icanlocalize.com/wpml/websites/%{website_id}/translation_jobs\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"dd17d48516ca4bce0b83043583fabd2e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:272:\"<a href=\"https://www.icanlocalize.com/wpml/registrations/new\" target=\"_blank\">Sign up</a> to ICanLocalize to receive your API token.<br />Already have an account? Log-in and <a href=\"https://www.icanlocalize.com/wpml/websites/api_token\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:52:\"Your API Token is found on your ICanLocalize account\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/icanlocalize/#creating-account\";s:30:\"client_create_account_page_url\";s:51:\"https://www.icanlocalize.com/users/new?utype=Client\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}}}}i:1;C:15:\"WPML_TP_Service\":2851:{a:38:{s:2:\"id\";i:12;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/blend.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_blend.png\";s:4:\"name\";s:5:\"BLEND\";s:11:\"description\";s:254:\"BLEND is a global localization service provider brought by the makers of OneHourTranslation. As an end-to-end AI-powered multi-market enabler, BLEND is empowering global brands to establish a native presence in fundamentally different markets, worldwide.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/blend/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Secret Key\";s:4:\"name\";s:10:\"secret_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Public Key\";s:4:\"name\";s:10:\"public_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5443;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:38.57;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:38.57;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:44:\"https://app.getblend.com/affiliate/wpml_otgs\";s:19:\"project_details_url\";s:56:\"https://www.onehourtranslation.com/my-projects/customer/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8850fd4bfdaae2a2d63e51fb1f2ac3e4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:246:\"<a href=\"https://app.getblend.com/affiliate/wpml_otgs\" target=\"_blank\">Register</a> to BLEND to generate your API Keys.<br />Already have an account? Log-in and <a href=\"https://wpml.org/go/onehourtranslation/\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:110:\"Your Secret Key and Public Key are located under \"Profile > API Keys\" on your OneHourTranslation Control panel\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/onehourtranslation/#api-secret-public-keys\";s:30:\"client_create_account_page_url\";s:71:\"https://wpml.org/translation-service/onehourtranslation/#create-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Israel\";s:4:\"code\";s:2:\"IL\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Romania\";s:4:\"code\";s:2:\"RO\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Ukraine\";s:4:\"code\";s:2:\"UA\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:2;C:15:\"WPML_TP_Service\":2243:{a:38:{s:2:\"id\";i:45;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/avanti-language-services.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_avanti-language-services.png\";s:4:\"name\";s:24:\"Avanti Language Services\";s:11:\"description\";s:279:\"Why choose Avanti?\r\n1. Ultra-fast service (offer within the hour, rapid turnaround time)\r\n2. Top quality (3x ISO certified, watertight QA processes)\r\n3. Competitive charges (incl. 70% discount on repetitions)\r\nAvanti: 100% satisfaction guarantee. Ask for a free test translation!\";s:7:\"doc_url\";s:62:\"https://wpml.org/translation-service/avanti-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5168;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:37.38;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:37.38;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/avanti/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"65ead6792983d81081190fb784e73b0a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:51:\"The AVANTI team will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:49:\"https://www.avanti-nl.com/en/wpml/#content-sturen\";s:30:\"client_create_account_page_url\";s:88:\"https://wpml.org/translation-service/avanti-language-services/#requesting-avanti-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}}}}i:3;C:15:\"WPML_TP_Service\":1954:{a:38:{s:2:\"id\";i:78;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/alfabeta.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_alfabeta.png\";s:4:\"name\";s:8:\"AlfaBeta\";s:11:\"description\";s:254:\"AlfaBeta is an Italian language services consultancy specializing in international communication, mainly in the food, wine, tourism, fashion industries. We provide web translation and copywriting, multilingual SEO/SEM and social media marketing services.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/alfabeta/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:36.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/alfabeta/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e00168c56d4b60275ee38701221c5911\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:4;C:15:\"WPML_TP_Service\":2160:{a:38:{s:2:\"id\";i:58;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acstraduction.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acstraduction.png\";s:4:\"name\";s:13:\"ACSTraduction\";s:11:\"description\";s:255:\"Nous sommes votre partenaire idéal pour la traduction spécialisée multilingue de sites Internet. Une équipe réactive à taille humaine est à votre écoute. The new standard in specialised website translation. It’s simple:  Click. Quality. Connect.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/acstraduction/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5480;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.15;s:7:\"primary\";d:4.75;s:15:\"primary_ranking\";d:36.15;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/acstraduction/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cba138bf154930c7878e8b5ba61ec7d4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:33:\"Request your API Token to connect\";s:26:\"how_to_get_credentials_url\";s:66:\"https://www.acs-traduction.com/web/traduction-site-wordpress-wpml/\";s:30:\"client_create_account_page_url\";s:70:\"https://wpml.org/translation-service/acstraduction/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}}}}i:5;C:15:\"WPML_TP_Service\":2099:{a:38:{s:2:\"id\";i:122;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/commit-global.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_commit-global.png\";s:4:\"name\";s:13:\"Commit Global\";s:11:\"description\";s:296:\"Commit Global provides translation and localization in 80+ language combinations. As an ISO-certified company, it applies strict QA procedures in its everyday work. Its key strengths include experienced personnel, responsiveness and flexibility, competitive prices and commitment to high quality.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/commit-global/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:5;s:18:\"popularity_ranking\";d:36.03;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:36.03;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/commit-global/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"14dde982a9f3acf6c185ab11b06cb41c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:6;C:15:\"WPML_TP_Service\":2271:{a:38:{s:2:\"id\";i:101;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/k-j-translations.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_k-j-translations.png\";s:4:\"name\";s:16:\"K&J Translations\";s:11:\"description\";s:249:\"K&J Translations is currently active on markets in Germany, Slovenia, Slovakia, Czechia and ex-Yugoslavian countries. It is known for its fast, quality translation services for businesses and effective communication during whole translation process.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/kj-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:34.78;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:34.78;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:35:\"https://wpml.org/go/kjtranslations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"37bf80898cc416edd1eb8bab6d4bb11d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Croatia\";s:4:\"code\";s:2:\"HR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"Czech Republic\";s:4:\"code\";s:2:\"CZ\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovakia\";s:4:\"code\";s:2:\"SK\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovenia\";s:4:\"code\";s:2:\"SI\";}}}}i:7;C:15:\"WPML_TP_Service\":2145:{a:38:{s:2:\"id\";i:69;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/leemeta.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_leemeta.png\";s:4:\"name\";s:7:\"Leemeta\";s:11:\"description\";s:255:\"Leemeta is known for its turnkey translations™. Their job is to make sure you don’t have any additional work: they translate and proofread the texts, design them for printing or prepare for digital distribution and transfer them onto the website/apps.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/leemeta\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4282;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:34.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:34.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/leemeta/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"dff20624a4352b67c960083b3a5df494\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:58:\"A Leemeta team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/leemeta/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:64:\"https://wpml.org/translation-service/leemeta/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovenia\";s:4:\"code\";s:2:\"SI\";}}}}i:8;C:15:\"WPML_TP_Service\":1975:{a:38:{s:2:\"id\";i:127;s:8:\"logo_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/gte-localize.png\";s:16:\"logo_preview_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_gte-localize.png\";s:4:\"name\";s:12:\"GTE Localize\";s:11:\"description\";s:251:\"GTE Localize is an ISO qualified translation and localization agency specializing in Asian languages. We offer professional website translation services for a full range of contents including life-science, legal-business, engineering, IT and software.\";s:7:\"doc_url\";s:50:\"https://wpml.org/translation-service/gte-localize/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:33.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:33.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/gtelocalize/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c2fcfc33c5f86c92027cf7e5c0e64448\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Viet Nam\";s:4:\"code\";s:2:\"VN\";}}}}i:9;C:15:\"WPML_TP_Service\":2691:{a:38:{s:2:\"id\";i:33;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/semantix.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_semantix.png\";s:4:\"name\";s:8:\"Semantix\";s:11:\"description\";s:195:\"Semantix is a market-leading language technology company in the Nordics, offering a broad range of translation and interpretation services. We help people and businesses to shine in any language.\";s:7:\"doc_url\";s:24:\"https://www.semantix.eu/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Customer ID\";s:4:\"name\";s:11:\"customer_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5490;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:33.23;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:33.23;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:29:\"https://wpml.org/go/semantix/\";s:19:\"project_details_url\";s:44:\"https://xtrf.semantix.eu/customers/main.html\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cf3d9e7244ec6d0a5192462c93e81bee\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:72:\"Amesto will send you a Username, Password, and Customer ID to your email\";s:26:\"how_to_get_credentials_url\";s:79:\"https://www.semantix.eu/translation/technology/api/multilingual-wordpress-site/\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/amesto/#connecting-to-amesto\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Norway\";s:4:\"code\";s:2:\"NO\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Sweden\";s:4:\"code\";s:2:\"SE\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:10;C:15:\"WPML_TP_Service\":2106:{a:38:{s:2:\"id\";i:75;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/okodia.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_okodia.png\";s:4:\"name\";s:6:\"Okodia\";s:11:\"description\";s:242:\"Okodia is a human-translation company certified by ISO 9001 & ISO 17100 certificates working with 80+ languages around the world. Our 1500+ specialized professional native linguists translate over 10+ millon words yearly in almost all fields.\";s:7:\"doc_url\";s:26:\"https://wpml.org/go/okodia\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5475;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:32.45;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:32.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/okodia/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"94ee301596730c533be57728ca1634ef\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:59:\"An Okodia team member will email a unique API Token to you.\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/okodia/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/okodia/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:11;C:15:\"WPML_TP_Service\":1964:{a:38:{s:2:\"id\";i:99;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/euro-text.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_euro-text.png\";s:4:\"name\";s:9:\"Euro:Text\";s:11:\"description\";s:262:\"Your partner for multilingual translation – fast, cost-efficient and reliable, with particular expertise in Spanish and Portuguese, including European and other variants (Mexican, Chilean,Peruvian, Argentinian and Colombian Spanish, Brazilian Portuguese, etc.)\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/eurotext/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:32.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:32.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/eurotext\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"aef0362e0b668d69886108e01a4c2930\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:12;C:15:\"WPML_TP_Service\":2148:{a:38:{s:2:\"id\";i:48;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/spokenhere.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_spokenhere.png\";s:4:\"name\";s:10:\"SpokenHere\";s:11:\"description\";s:226:\"SpokenHere is an American service offering translations, telephonic interpreting, and voiceovers in more than 250 languages. For the last 15 years, it has worked with small to medium-size businesses in a variety of industries.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/spokenhere/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5510;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/spokenhere/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"4d967c459583c6811cc325aaf1fbcd8d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A SpokenHere team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/spokenhere/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/spokenhere/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:13;C:15:\"WPML_TP_Service\":1961:{a:38:{s:2:\"id\";i:120;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/trusted-translations.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_trusted-translations.png\";s:4:\"name\";s:20:\"Trusted Translations\";s:11:\"description\";s:179:\"Trusted Translations, Inc. is an internationally recognized multilingual translation and interpretation service with over 10,000 expert linguists and over 5,000 satisfied clients.\";s:7:\"doc_url\";s:70:\"https://wpml.org/?post_type=translation-service&p=4277301&preview=true\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/trustedtranslations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a967159995deeeb503da9761406a542e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:14;C:15:\"WPML_TP_Service\":1981:{a:38:{s:2:\"id\";i:109;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/jublo-translations.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_jublo-translations.png\";s:4:\"name\";s:18:\"Jublo Translations\";s:11:\"description\";s:233:\"Jublo is translation agency born in Yorkshire, England specialising in IT, travel, machinery and marketing. It provides services all over the globe, bringing only high quality and professionalism to some of the worlds biggest brands.\";s:7:\"doc_url\";s:55:\"https://wpml.org/translation-service/jublo-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/jublo/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"d9d4148b846f06d38f17b6bf80faa269\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:15;C:15:\"WPML_TP_Service\":1918:{a:38:{s:2:\"id\";i:79;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ad-verbum.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ad-verbum.png\";s:4:\"name\";s:9:\"AD VERBUM\";s:11:\"description\";s:213:\"AD VERBUM is a northern European translation and localization company working in 90+ target languages. It specializes in various fields including pharmacy, healthcare and legal for small to medium-size businesses.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/ad-verbum/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:31.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:31.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/adverbum/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"456cf5b648e41fadadd6f94c13605dbe\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Latvia\";s:4:\"code\";s:2:\"LV\";}}}}i:16;C:15:\"WPML_TP_Service\":2118:{a:38:{s:2:\"id\";i:110;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transline.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transline.png\";s:4:\"name\";s:10:\"Transline \";s:11:\"description\";s:258:\"With its experienced teams of specialized translators, proofreaders and project managers, language service provider Transline has been helping companies in the DACH region to successfully market their products on an international scale for the past 30 years.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/transline-deutschland/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5368;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.87;s:7:\"primary\";d:4.5;s:15:\"primary_ranking\";d:30.87;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/transline/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"7485434837a20872046f85e7e77b5f89\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:17;C:15:\"WPML_TP_Service\":2201:{a:38:{s:2:\"id\";i:94;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/morningside-translations.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_morningside-translations.png\";s:4:\"name\";s:24:\"Morningside Translations\";s:11:\"description\";s:213:\"Morningside Translations is an American language service provider. Specializing in highly regulated industries, Morningside provides ISO-certified translation and localization solutions in more than 150 languages.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/morningside-translations\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5408;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.6;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.6;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/morningside/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fa41303ea2e844c16f7e20bd5e12cf8c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Israel\";s:4:\"code\";s:2:\"IL\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:18;C:15:\"WPML_TP_Service\":2041:{a:38:{s:2:\"id\";i:84;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translation-boulevard.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translation-boulevard.png\";s:4:\"name\";s:21:\"Translation Boulevard\";s:11:\"description\";s:271:\"Translation Boulevard LLC provides translation, website localization, subtitling, transcription, transcreation, voice over, and other services in all major languages pairs. Our company is operated according to Christian values and we provide quality translation services.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/translation-boulevard/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://wpml.org/go/translation-blvd/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e85c18272a7e00b0cd4b941ea1340d5d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:19;C:15:\"WPML_TP_Service\":2123:{a:38:{s:2:\"id\";i:91;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/language-insight.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_language-insight.png\";s:4:\"name\";s:16:\"Language Insight\";s:11:\"description\";s:295:\"Quality and security are a priority for Language Insight as demonstrated by their ISO 9001, 27001 and 17100 accreditations. Their specialist teams provide language services to clients worldwide, including a variety of digital services such as website translation, multilingual SEO, PPC and more.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/language-insight/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5484;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:36:\"https://wpml.org/go/language-insight\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"9cd6dacb4cfa2c94991babf0ffdb88f3\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:20;C:15:\"WPML_TP_Service\":2094:{a:38:{s:2:\"id\";i:108;s:8:\"logo_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/quality-translation-services.png\";s:16:\"logo_preview_url\";s:95:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_quality-translation-services.png\";s:4:\"name\";s:28:\"Quality Translation Services\";s:11:\"description\";s:299:\"Quality Translation Services is a professional translation company which offers high quality translation and website localization services at very attractive prices. They employ the latest translation tools and apply a rigorous translation process to ensure quality, consistency and timely delivery.\";s:7:\"doc_url\";s:66:\"https://wpml.org/translation-service/quality-translation-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:30.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:30.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/quality-translation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8853226d14818dfdc7d325c53a290436\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Lebanon\";s:4:\"code\";s:2:\"LB\";}}}}i:21;C:15:\"WPML_TP_Service\":3058:{a:38:{s:2:\"id\";i:23;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/textmaster.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_textmaster.png\";s:4:\"name\";s:10:\"TextMaster\";s:11:\"description\";s:220:\"TextMaster was founded in 2011 and offers 40 languages with specializations like fashion, electronics and home décor. Clients can create a dedicated team of translators and communicate through a live messaging system.  \";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/textmaster/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"API secret\";s:4:\"name\";s:10:\"api_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:4831;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:28.97;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:28.97;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:56:\"https://www.textmaster.com/?pid=57be8e7208104100441aa3fc\";s:19:\"project_details_url\";s:47:\"https://www.app.textmaster.com/clients/projects\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3db36a7c23cefa52d577ab4307882110\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:255:\"<a href=\"https://www.textmaster.com/?pid=57be8e7208104100441aa3fc\" target=\"_blank\">Register</a> to TextMaster to receive your API token.<br />Already have an account? Log-in and <a href=\"https://wpml.org/go/textmaster/\" target=\"_blank\">get your token</a>.\";s:27:\"how_to_get_credentials_desc\";s:110:\"Your API Key and API Secret are located under  \"lightning menu icon > API & Loop\" on your TextMaster dashboard\";s:26:\"how_to_get_credentials_url\";s:83:\"https://wpml.org/translation-service/textmaster/#connecting-your-site-to-textmaster\";s:30:\"client_create_account_page_url\";s:67:\"https://www.app.textmaster.com/sign_up?pid=57be8e7208104100441aa3fc\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:6;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:22;C:15:\"WPML_TP_Service\":1977:{a:38:{s:2:\"id\";i:123;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ontranslation.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ontranslation.png\";s:4:\"name\";s:13:\"Ontranslation\";s:11:\"description\";s:247:\"Ontranslation translation agency is a multilingual communication company based in Barcelona with 10 years experience. 9001 ISO-certified for the management of multilingual communication projects. Experts in digital marketing and international SEO.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/ontranslation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5427;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:34:\"https://wpml.org/go/ontranslation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8a78f966b150358b51ec34d653badfd1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:23;C:15:\"WPML_TP_Service\":1873:{a:38:{s:2:\"id\";i:135;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/berba.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_berba.png\";s:4:\"name\";s:5:\"Berba\";s:11:\"description\";s:250:\"With over 1000 native translators working in 700+ language combinations, Berba delivers high-quality translations 3x faster than the industry average. Its AI tools and a dedicated project manager guarantee quality and consistency across your website.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/berba/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5485;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.77;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.77;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/berba/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6e66d4c5c83a5db041820eabbbed19fb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:24;C:15:\"WPML_TP_Service\":1970:{a:38:{s:2:\"id\";i:95;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ubiqus.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ubiqus.png\";s:4:\"name\";s:6:\"Ubiqus\";s:11:\"description\";s:277:\"Ubiqus is an international Paris-based ISO-certified translation service. Providing translation services for all types of media ranging from websites to video to text, Ubiqus has vast experience translating content for various industries such as corporate, legal and financial.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/ubiqus\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5395;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.43;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.43;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/ubiqus/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"00f941032a272372a9aaa2485f8d1786\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}}}}i:25;C:15:\"WPML_TP_Service\":1953:{a:38:{s:2:\"id\";i:136;s:8:\"logo_url\";s:62:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ast.png\";s:16:\"logo_preview_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ast.png\";s:4:\"name\";s:3:\"AST\";s:11:\"description\";s:249:\"AST is a specialist provider of quality-certified and innovative website translation and software localisation services to fintech developers, e-retailers, food & drink brands, engineering companies, and marketing agencies in the UK and worldwide.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/ast-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:4;s:18:\"popularity_ranking\";d:27.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/ast/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"02689341577b112381f20556ad8520ce\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:26;C:15:\"WPML_TP_Service\":1972:{a:38:{s:2:\"id\";i:80;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/bigtranslation.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_bigtranslation.png\";s:4:\"name\";s:14:\"BigTranslation\";s:11:\"description\";s:247:\"BigTranslation – Translation agency with years of experience in the market and competitive rates. They work exclusively with native translators in over 50 target languages, offering tailored services that adapt perfectly to our clients’ needs.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/bigtranslation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:27;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:27;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:35:\"https://wpml.org/go/bigtranslation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a12d879958cec6a27953c1ed284f8032\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:27;C:15:\"WPML_TP_Service\":2363:{a:38:{s:2:\"id\";i:133;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/skrivanek.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_skrivanek.png\";s:4:\"name\";s:9:\"Skrivanek\";s:11:\"description\";s:242:\"Skrivanek helps businesses reach new foreign clients and partners by providing trusthworthy language solutions. Our specialists also have relevant experience in SEO and SEM, essential in maximizing traffic and return on marketing investments.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/skrivanek/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:5143;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.97;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:26.97;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/skrivanek/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"0438c6682b3419cdec4599252fc0fddb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Bulgaria\";s:4:\"code\";s:2:\"BG\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Latvia\";s:4:\"code\";s:2:\"LV\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Lithuania\";s:4:\"code\";s:2:\"LT\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}i:6;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Slovakia\";s:4:\"code\";s:2:\"SK\";}}}}i:28;C:15:\"WPML_TP_Service\":2005:{a:38:{s:2:\"id\";i:125;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/2m-language-services.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_2m-language-services.png\";s:4:\"name\";s:20:\"2M Language Services\";s:11:\"description\";s:256:\"2M Language Services is one of Australia\'s leading translation company with offices in Europe & South America. Covering over 250 languages and with a network of carefully selected translators, 2M is the go-to for quality technical and general translations.\";s:7:\"doc_url\";s:58:\"https://wpml.org/translation-service/2m-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5249;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.9;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:26.9;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"https://wpml.org/go/2m/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"5a492ffae3952aabc1b3d62dc1b42027\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Australia\";s:4:\"code\";s:2:\"AU\";}}}}i:29;C:15:\"WPML_TP_Service\":2364:{a:38:{s:2:\"id\";i:89;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/simply-translate.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_simply-translate.png\";s:4:\"name\";s:16:\"Simply Translate\";s:11:\"description\";s:260:\"Simply Translate is a professional translation agency for online companies. The combination of in-house language expertise, its user-friendly client platform, and professional translators make it a reliable business partner for your multilingual communication.\";s:7:\"doc_url\";s:53:\"https://wpml.org/translation-service/simply-translate\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:5:\"Email\";s:4:\"name\";s:5:\"email\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5368;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26.27;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:26.27;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:68:\"https://www.simplytranslate.com/services/ecommerce-translation/wpml/\";s:19:\"project_details_url\";s:77:\"https://platform.simplytranslate.nl/Client/Project/TranslationProjectOverview\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"edc57d14528262a9d1f19999aef77aef\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:30;C:15:\"WPML_TP_Service\":2072:{a:38:{s:2:\"id\";i:65;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/at-language-solutions.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_at-language-solutions.png\";s:4:\"name\";s:21:\"AT Language Solutions\";s:11:\"description\";s:243:\"AT Language Solutions is a translation services and technology provider with over 20 years’ experience. Specialized in the translation of websites and apps, the development of CAT-tools, cloud and machine translation and tech custom projects\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/at-language-solutions/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API Token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:26;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:26;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:41:\"https://wpml.org/go/at-languagesolutions/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e5ad0596522cb049733698b311916864\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:31;C:15:\"WPML_TP_Service\":2069:{a:38:{s:2:\"id\";i:107;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/inpokulis-translations.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_inpokulis-translations.png\";s:4:\"name\";s:22:\"Inpokulis Translations\";s:11:\"description\";s:304:\"Founded almost 20 years ago, Inpokulis is an experienced Portuguese LSP with ISO17100 certification. The skilled in-house team works daily with a network of over 200 translators specialised in different language combinations and areas such as localisation, SEO, legal, tourism, marketing, technical, etc.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/inpokulis-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5460;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/inpokulis/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"420cbf3ca2b01f664c1346c0f80c5cfe\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Portugal\";s:4:\"code\";s:2:\"PT\";}}}}i:32;C:15:\"WPML_TP_Service\":1991:{a:38:{s:2:\"id\";i:131;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/star-translation.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/star-translation.png\";s:4:\"name\";s:16:\"STAR Translation\";s:11:\"description\";s:285:\"STAR is the Technical Translation Specialist, supporting 200+ languages. Particular expertise in Automotive, Cyber-Security Software, Engineering, Heavy Equipment,  Machinery, Agri-Tech, Rail and Transport.  ISO 9001 | ISO 17100 Quality Certified. 50 offices | 35 Countries | 1 Partner\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/star-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:75:\"https://www.star-ts.com/how-do-you-translate-a-wordpress-website-with-wpml/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"f807fe74b8dcd708a354eca5dd3b0e05\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:33;C:15:\"WPML_TP_Service\":2112:{a:38:{s:2:\"id\";i:124;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/traduality.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_traduality.png\";s:4:\"name\";s:11:\"Traduality \";s:11:\"description\";s:251:\"Get your web content translated by professionals who specialize in what you are selling, whether it is products or services. Traduality handpicks the best and offers you Satisfaction Warranty for any language. Globalize your success! We got your back.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/traduality/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/traduality/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"917176f33fae512fbd05bac36acd851e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:10:\"Costa Rica\";s:4:\"code\";s:2:\"CR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Mexico\";s:4:\"code\";s:2:\"MX\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:34;C:15:\"WPML_TP_Service\":2403:{a:38:{s:2:\"id\";i:35;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/cultures-connection.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_cultures-connection.png\";s:4:\"name\";s:19:\"Cultures Connection\";s:11:\"description\";s:295:\"Cultures Connection is a global company which offers SEO-optimized website translations in more than 250 different languages for companies of all sizes. It was founded in 2007 and has more than 740 professional translators. It specializes in finance, medicine, law, e-commerce and IT industries.\";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/cultures-connection/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.45;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:40:\"https://wpml.org/go/cultures-connection/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"7ed3f4bbe8a3193a8c81252f3f5a199a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:34:\"Request your API Token to connect!\";s:26:\"how_to_get_credentials_url\";s:70:\"https://culturesconnection.com/wordpress-website-translation-services/\";s:30:\"client_create_account_page_url\";s:99:\"https://wpml.org/translation-service/cultures-connection/#requesting-an-cultures-connection-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Argentina\";s:4:\"code\";s:2:\"AR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:35;C:15:\"WPML_TP_Service\":1967:{a:38:{s:2:\"id\";i:112;s:8:\"logo_url\";s:63:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/mtlt.png\";s:16:\"logo_preview_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_mtlt.png\";s:4:\"name\";s:4:\"MTLT\";s:11:\"description\";s:282:\"MTLT is a network of professional translators offering high-end language services to communicate effectively across different markets & cultures. Take advantage of their skills in translating your content into the language of your target audience with culturally sensitive accuracy.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/mtlt/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5488;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.43;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.43;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:25:\"https://wpml.org/go/mtlt/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c569723b18f7a32e5fe64d152931a331\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}}}}i:36;C:15:\"WPML_TP_Service\":2316:{a:38:{s:2:\"id\";i:102;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/powerling.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_powerling.png\";s:4:\"name\";s:9:\"Powerling\";s:11:\"description\";s:251:\"Powerling supports its customers’ global development by providing high quality multilingual solutions in various business sectors. The company offers services in 75+ languages, including translation, localization, desktop publishing or interpreting.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/powerling\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/powerling/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"94114df20b2adeb581e0c7f3fd7ed85d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:37;C:15:\"WPML_TP_Service\":2740:{a:38:{s:2:\"id\";i:51;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lingo24.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lingo24.png\";s:4:\"name\";s:7:\"Lingo24\";s:11:\"description\";s:277:\"Lingo24 makes it easy for global companies to work in multiple languages. Since 2001, it has provided a technology-led translation approach to enterprises in e-commerce, marketing, and product information content among others. Its 4,000 native translators are spread worldwide.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/lingo24/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:18:\"Authorization Code\";s:4:\"name\";s:18:\"authorization_code\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5447;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.13;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.13;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:28:\"https://wpml.org/go/lingo24/\";s:19:\"project_details_url\";s:33:\"https://ease.lingo24.com/projects\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"26f9d66db808f184a585c9b1ebc854d1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:1;s:9:\"oauth_url\";s:40:\"https://ease.lingo24.com/oauth/authorize\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:101:\"Lingo24 will email you information on how to complete your registration and retrieve your credentials\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/lingo24/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/lingo24/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Panama\";s:4:\"code\";s:2:\"PA\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Philippines\";s:4:\"code\";s:2:\"PH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Romania\";s:4:\"code\";s:2:\"RO\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:38;C:15:\"WPML_TP_Service\":2166:{a:38:{s:2:\"id\";i:105;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/quicksilver-translate.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_quicksilver-translate.png\";s:4:\"name\";s:21:\"Quicksilver Translate\";s:11:\"description\";s:258:\"Multilingual translation and desktop publishing solutions that make multilingual documentation easier. Global reach, all languages, all formats. State-of-the-art software and qualified, bilingual translators carry out large projects in very short timeframes.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/quicksilver-translate/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:25.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:25.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/quicksilver/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"be1c1d266f78c4dd7778d8afec990b1c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:39;C:15:\"WPML_TP_Service\":2562:{a:38:{s:2:\"id\";i:6;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translatemedia.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translatemedia.png\";s:4:\"name\";s:14:\"TranslateMedia\";s:11:\"description\";s:90:\"Connect your Wordpress site to STREAM™ - TranslateMedia\'s translation management service\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/translatemedia/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:3972;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.87;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.87;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:35:\"https://wpml.org/go/translatemedia/\";s:19:\"project_details_url\";s:85:\"https://services.translatemedia.com/2_0/CorporatePortal/CPFileManager.aspx?platform=3\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"37cfcdf04d20f326391990eee25dd54d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:106:\"Your API key is located under \"Development Center page > API KEY\" on your TranslateMedia account Dashboard\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/translatemedia/#connect-site\";s:30:\"client_create_account_page_url\";s:92:\"https://www.tm-stream.com/2_0/DeveloperCentre/Registration.aspx?platform=uyvm2o1gQZ4!$%C2%A3\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Portugal\";s:4:\"code\";s:2:\"PT\";}}}}i:40;C:15:\"WPML_TP_Service\":2002:{a:38:{s:2:\"id\";i:106;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/world-translation.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_world-translation.png\";s:4:\"name\";s:17:\"World Translation\";s:11:\"description\";s:250:\"World Translation is a Danish company supplying translations and other language services in all languages to companies all over the world. They act as a dynamic partner to their customers and provide quality solutions to strengthen their reputations.\";s:7:\"doc_url\";s:55:\"https://wpml.org/translation-service/world-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5327;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.73;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.73;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/world-translation/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e04c35767882abf1c91cfef3695a24a9\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}}}}i:41;C:15:\"WPML_TP_Service\":1990:{a:38:{s:2:\"id\";i:130;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/dadan-translations.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_dadan-translations.png\";s:4:\"name\";s:18:\"DADAN Translations\";s:11:\"description\";s:250:\"Polish company offering translation and localization into European languages. 15 years of experience. Coverage of world\'s biggest brands. Deep knowledge of IT and technical terminology. SEO-compliant. Good marketing taste. Quick delivery, low prices.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/dadan-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/dadan/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3c161bc121001abe14643dea46159b92\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:42;C:15:\"WPML_TP_Service\":2023:{a:38:{s:2:\"id\";i:118;s:8:\"logo_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/datasource-international.png\";s:16:\"logo_preview_url\";s:91:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_datasource-international.png\";s:4:\"name\";s:24:\"DataSource International\";s:11:\"description\";s:251:\"DataSource offers professional website translations using native linguists for retail, e-commerce, luxury, finance. They serve clients globally since 2002 and are praised for being accurate, reliable, and flexible.  Easy WPML integration.  Try it now!\";s:7:\"doc_url\";s:62:\"https://wpml.org/translation-service/datasource-international/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/datasource/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"441e5f269caaed31ecd7db9e88e973cc\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}}}}i:43;C:15:\"WPML_TP_Service\":2199:{a:38:{s:2:\"id\";i:104;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/elite-asia.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_elite-asia.png\";s:4:\"name\";s:10:\"Elite Asia\";s:11:\"description\";s:285:\"Headquartered in Singapore, Elite Asia offers translation services in over 70 language pairs, as well as global digital marketing solutions and mass localization technology. It has since managed over 26,000 projects in 26 countries with a talented network of more than 4,000 linguists.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/elite-asia\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:24;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:24;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/elite-asia/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"b14cb2eee9c013ce014629e5ead4839c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Malaysia\";s:4:\"code\";s:2:\"MY\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Singapore\";s:4:\"code\";s:2:\"SG\";}}}}i:44;C:15:\"WPML_TP_Service\":2223:{a:38:{s:2:\"id\";i:42;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lat-multilingual.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lat-multilingual.png\";s:4:\"name\";s:16:\"LAT Multilingual\";s:11:\"description\";s:246:\"Founded in 1999, LAT provides translation services in most languages, including French Canadian. We work for a wide variety of clients across multiple industries such as tourism, education, food and health, engineering, pharmaceutical and retail.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/lat-multilingual/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5475;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.7;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:23.7;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://wpml.org/go/lat-multilingual/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"17e8abb612636cdd96e60afba259d884\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:64:\"A LAT Multilingual team member will email you a unique API Token\";s:26:\"how_to_get_credentials_url\";s:75:\"https://wpml.org/translation-service/lat-multilingual/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:92:\"https://wpml.org/translation-service/lat-multilingual/#requesting-a-lat-multilingual-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Canada\";s:4:\"code\";s:2:\"CA\";}}}}i:45;C:15:\"WPML_TP_Service\":1957:{a:38:{s:2:\"id\";i:100;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translators-family.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translators-family.png\";s:4:\"name\";s:18:\"Translators Family\";s:11:\"description\";s:205:\"Boutique translation agency specialising in business/marketing and technical translations. It will transcreate and localize your message so that it appeals to your clients. Working with all main languages.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/translators-family/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:23.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/translatorsfamily/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fe7a207a617ad4d4e9a989004eeb6b58\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:46;C:15:\"WPML_TP_Service\":1999:{a:38:{s:2:\"id\";i:126;s:8:\"logo_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/maris-multilingual.png\";s:16:\"logo_preview_url\";s:85:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_maris-multilingual.png\";s:4:\"name\";s:18:\"Maris Multilingual\";s:11:\"description\";s:258:\"Maris Multilingual is a Finnish company founded in 2001, with a reputation of a highly professional and quality oriented service provider. It specialises in translations to and from Finnish, but it offers services in all major European and Asian languages.\r\n\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/maris-multilingual/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:23.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:23.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/maris/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ebe12b1e2e227a99097e47c2ef401fc5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}}}}i:47;C:15:\"WPML_TP_Service\":2299:{a:38:{s:2:\"id\";i:37;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/espresso-translations.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_espresso-translations.png\";s:4:\"name\";s:21:\"Espresso Translations\";s:11:\"description\";s:275:\"Espresso Translations is a professional translation agency offering a full range of translation services to businesses and individuals worldwide. We offer translation, proofreading, transcription and interpretation services in all languages across a vast array of industries.\";s:7:\"doc_url\";s:59:\"https://wpml.org/translation-service/espresso-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:42:\"https://wpml.org/go/espresso-translations/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ab06600c2ae77b6fb2945304f3ea8b87\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:33:\"Request your API Token to connect\";s:26:\"how_to_get_credentials_url\";s:65:\"https://www.espressotranslations.com/translate-website-with-wpml/\";s:30:\"client_create_account_page_url\";s:81:\"https://wpml.org/translation-service/espresso-translations/#requesting-an-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:48;C:15:\"WPML_TP_Service\":2330:{a:38:{s:2:\"id\";i:55;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translate-by-humans.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translate-by-humans.png\";s:4:\"name\";s:19:\"Translate By Humans\";s:11:\"description\";s:247:\"Translate By Humans is a London-based translation service with more than a 1,000 language pairs available. Since it was created five years ago, it has served small to medium-size businesses in the legal, medical and travel industries among others.\";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/translate-by-humans/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:65:\"https://www.translatebyhumans.com/en/translation-integration/wpml\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"829a35138840fe2563d620278b5f2239\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:70:\"A Translate by Humans team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:77:\"https://wpml.org/translation-service/translate-by-humans/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:76:\"https://wpml.org/translation-service/translate-by-humans/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"India\";s:4:\"code\";s:2:\"IN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:49;C:15:\"WPML_TP_Service\":1931:{a:38:{s:2:\"id\";i:86;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/alba-translating.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_alba-translating.png\";s:4:\"name\";s:16:\"Alba Translating\";s:11:\"description\";s:189:\"Alba is a Russian ISO qualified translation company with more than 10 years of experience. With an in-house team of expert linguists we can ensure fast and professional-quality translation.\";s:7:\"doc_url\";s:53:\"https://wpml.org/translation-service/alba-translating\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:25:\"https://wpml.org/go/alba/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"14b2bc872d010f0faa5a20fecfbf9ade\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Russian Federation\";s:4:\"code\";s:2:\"RU\";}}}}i:50;C:15:\"WPML_TP_Service\":1956:{a:38:{s:2:\"id\";i:98;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/brightlines-translation.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_brightlines-translation.png\";s:4:\"name\";s:23:\"Brightlines Translation\";s:11:\"description\";s:179:\"Brightlines is a full-service translation agency. We work with the world’s most discerning brands to deliver exceptional marketing translation and multilingual artwork services.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/brightlines-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5501;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:22.48;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:22.48;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/brightlines/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"56c2d53d830b84e03980730ae13fbf2a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:51;C:15:\"WPML_TP_Service\":1996:{a:38:{s:2:\"id\";i:81;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/comtec.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_comtec.png\";s:4:\"name\";s:6:\"Comtec\";s:11:\"description\";s:296:\"Comtec supports businesses to reach new markets online in over 200 languages. Comtec provides website translation services by a global network of professional linguists specializing in translation for all key business sectors and complying with ISO 9001:2015 and ISO 17100:2015 quality standards.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/comtec/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:21.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:21.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/comtec/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e18d99ce7d5a481a040f56872065cbb4\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:52;C:15:\"WPML_TP_Service\":1968:{a:38:{s:2:\"id\";i:119;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translabel.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translabel.png\";s:4:\"name\";s:10:\"Translabel\";s:11:\"description\";s:249:\"Translabel is a Dutch company which supports businesses throughout the world to reach new markets in over 150 languages. It provides high-quality translations for various industries such as tourism, technology, financial, legal, healthcare and more.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/translabel/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:21.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:21.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/translabel/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6bbbf512b0002189f00c51e120001360\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Netherlands\";s:4:\"code\";s:2:\"NL\";}}}}i:53;C:15:\"WPML_TP_Service\":1946:{a:38:{s:2:\"id\";i:103;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lengoo.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lengoo.png\";s:4:\"name\";s:6:\"Lengoo\";s:11:\"description\";s:251:\"Lengoo is a large European platform for expert translations with an AI edge. Lengoo rethinks the concept of translation by uniting human creativity with the precision of AI for the highest quality, consistency, and fast results at an unbeatable price.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/lengoo\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5497;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:20.45;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:20.45;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/lengoo/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e10eca4deecddfa2957f68f5d2f71f28\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}}}}i:54;C:15:\"WPML_TP_Service\":2816:{a:38:{s:2:\"id\";i:87;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/mars-translation.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_mars-translation.png\";s:4:\"name\";s:16:\"Mars Translation\";s:11:\"description\";s:256:\"Mars Translation is an international leader in the translation marketplace that offers a transparent, intuitive and cost-effective online portal to customers who need documents, web content, and video content translated guaranteeing high-quality and speed.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/mars-translation/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:20.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:20.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:36:\"https://wpml.org/go/marstranslation/\";s:19:\"project_details_url\";s:47:\"https://www.marstranslation.com/client/list/all\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"79fe9fda7f31390d11dc1db053cf7f40\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:78:\"Visit our Customer Support online resource to learn more about API Credentials\";s:26:\"how_to_get_credentials_url\";s:106:\"https://www.marstranslation.com/detail/additional-support/how-to-get-api-credentials?affiliate=GgyhEa8h39Y\";s:30:\"client_create_account_page_url\";s:61:\"https://www.marstranslation.com/contact?affiliate=GgyhEa8h39Y\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Hong Kong\";s:4:\"code\";s:2:\"HK\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Pakistan\";s:4:\"code\";s:2:\"PK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:55;C:15:\"WPML_TP_Service\":2477:{a:38:{s:2:\"id\";i:27;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acclaro.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acclaro.png\";s:4:\"name\";s:7:\"Acclaro\";s:11:\"description\";s:178:\"Acclaro specializes in adapting global brands, products, and services to new markets. Acclaro was founded in 2002 and now has offices and affiliates on four different continents.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/acclaro/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:3;s:18:\"popularity_ranking\";d:18.78;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:18.78;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/acclaro/\";s:19:\"project_details_url\";s:59:\"https://my.acclaro.com/portal/vieworder.php?id={project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ec87968ba4f260c3872d0edccd130d16\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:43:\"Acclaro will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:66:\"https://wpml.org/translation-service/acclaro/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:75:\"https://wpml.org/translation-service/acclaro/#requesting-an-acclaro-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:9:\"Argentina\";s:4:\"code\";s:2:\"AR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:56;C:15:\"WPML_TP_Service\":1858:{a:38:{s:2:\"id\";i:129;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nexya.png\";s:16:\"logo_preview_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nexya.png\";s:4:\"name\";s:5:\"Nexya\";s:11:\"description\";s:249:\"The NEXYA team consists of language specialists and localisation engineers. They use technology and agile principles to deliver projects faster and to guarantee quality. NEXYA specialises in localisation for websites, software and digital marketing.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/nexya/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:16.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:16.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"http://www.nexyaloc.com\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ba0378d80e17720d3b96889b29c0ce0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:57;C:15:\"WPML_TP_Service\":2112:{a:38:{s:2:\"id\";i:30;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/language-solutions-inc.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_language-solutions-inc.png\";s:4:\"name\";s:22:\"Language Solutions Inc\";s:11:\"description\";s:190:\"Language Solutions Inc is an American translation and localization firm which specializes in working with healthcare, technical and marketing businesses of all sizes. It was founded in 1998.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/language-solutions-inc/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:15.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:15.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:39:\"https://wpml.org/go/language-solutions/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"265c044355b0bff5f17755503470b225\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:63:\"Language Solutions Inc team will send you an API Token by email\";s:26:\"how_to_get_credentials_url\";s:81:\"https://wpml.org/translation-service/language-solutions-inc/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:58;C:15:\"WPML_TP_Service\":1963:{a:38:{s:2:\"id\";i:93;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/tomedes.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_tomedes.png\";s:4:\"name\";s:7:\"TOMEDES\";s:11:\"description\";s:259:\"TOMEDES is an Israel-based professional human translation service. Over 10,000 expert translators and linguists will carry out your translation, localization, content and SEO needs. Tomedes provides 24/7 human support and 1-year guarantee on all translations.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/tomedes/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:15.18;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:15.18;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:28:\"https://wpml.org/go/tomedes/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"0fb9b77c89fae9d873ec66aa9a5c08aa\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:59;C:15:\"WPML_TP_Service\":2522:{a:38:{s:2:\"id\";i:72;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/betranslated-com.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_betranslated-com.png\";s:4:\"name\";s:16:\"BeTranslated.com\";s:11:\"description\";s:294:\"BeTranslated is a network of translation project managers operating as a decentralized translation agency to serve the website and document translation needs of small, medium and large companies across Europe and North America. We specialize in marketing, travel, IT and technical translations.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/betranslated\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:33:\"https://wpml.org/go/betranslated/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fa663ae2188d9dfc589f5b8f6a5c2b0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:63:\"A BeTranslated team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:70:\"https://wpml.org/translation-service/betranslated/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:69:\"https://wpml.org/translation-service/betranslated/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Dominican Republic\";s:4:\"code\";s:2:\"DO\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:60;C:15:\"WPML_TP_Service\":2659:{a:38:{s:2:\"id\";i:10;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translations-com.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translations-com.png\";s:4:\"name\";s:16:\"Translations.com\";s:11:\"description\";s:254:\"Translations.com is one of the largest providers of enterprise localization services and technology solutions. More than 5,000 global organizations employ Translations.com’s GlobalLink® Product Suite to simplify the management of multilingual content.\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/translations-com/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:19:\"GlobalLink (GL) URL\";s:4:\"name\";s:3:\"url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:17:\"Project Shortcode\";s:4:\"name\";s:17:\"project_shortcode\";s:4:\"type\";s:4:\"text\";}i:4;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"File Format\";s:4:\"name\";s:11:\"file_format\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.63;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.63;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"http://translations.com/\";s:19:\"project_details_url\";s:37:\"%{connector_url}/#userMenuSUBMISSIONS\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"523d1d409ecdbfb1afa1d29e20b1917b\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:135:\"Your Project Director URL, username, password, and project code are found in the “GlobalLink Technology Configuration” PDF document\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/translations-com/#create-account\";s:30:\"client_create_account_page_url\";s:69:\"https://wpml.org/translation-service/translations-com/#create-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:61;C:15:\"WPML_TP_Service\":1942:{a:38:{s:2:\"id\";i:115;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/tatutrad.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_tatutrad.png\";s:4:\"name\";s:8:\"Tatutrad\";s:11:\"description\";s:241:\"Tatutrad is a language services company with +10 years of experience. They offer creative translation and website localization services of the best quality. Their priority is to make customers’ life easier and let their products go global.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/tatutrad/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:14.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:14.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/tatutrad/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"553da43ae096e5bf40a25d587618aaf0\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:62;C:15:\"WPML_TP_Service\":2515:{a:38:{s:2:\"id\";i:63;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/simultrans.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_simultrans.png\";s:4:\"name\";s:10:\"SimulTrans\";s:11:\"description\";s:248:\"SimulTrans provides website, software, and document localization services, translating text into over 100 languages. Established in 1984, SimulTrans has international offices and focuses on quality, exemplified by ISO 9001 and 17100 certifications.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/simultrans/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5144;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:13.73;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:13.73;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/simultrans/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c52494d5479d5a888ec98b78965ea2fb\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A SimulTrans team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/simultrans/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/simultrans/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Ireland\";s:4:\"code\";s:2:\"IE\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:4;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:5;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:63;C:15:\"WPML_TP_Service\":2395:{a:38:{s:2:\"id\";i:74;s:8:\"logo_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/the-geo-group.png\";s:16:\"logo_preview_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_the-geo-group.png\";s:4:\"name\";s:13:\"The Geo Group\";s:11:\"description\";s:239:\"The Geo Group Corporation is a full-service translation agency based in Madison, WI, since 1991. It has more than 500 translators working in more than 120 languages. It works with small to medium-size businesses in a variety of industries.\";s:7:\"doc_url\";s:51:\"https://wpml.org/translation-service/the-geo-group/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5426;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.93;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.93;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/thegeogroup/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"cd018f1ac09ae85bc8dfec7a72eb56c3\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:60:\"A Geo Group team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:71:\"https://wpml.org/translation-service/the-geo-group/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:70:\"https://wpml.org/translation-service/the-geo-group/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Korea, Republic of\";s:4:\"code\";s:2:\"KR\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}}}}i:64;C:15:\"WPML_TP_Service\":2218:{a:38:{s:2:\"id\";i:53;s:8:\"logo_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/geacom-gmbh.png\";s:16:\"logo_preview_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_geacom-gmbh.png\";s:4:\"name\";s:11:\"Geacom GmbH\";s:11:\"description\";s:303:\"Geacom offers translations into European, Asian as well as rare languages. Itsnative translators are specialized in areas such as technology, software, law, science, marketing and politics. Geacom\'s project management flow is fast and we are happy to help with any technical or organizational questions.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/geacom-gmbh/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/geacom/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"db61e1e11638127f0e69871d38d15d4b\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:62:\"A Geacom GmbH team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/geacom-gmbh/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/geacom-gmbh/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}}}}i:65;C:15:\"WPML_TP_Service\":1903:{a:38:{s:2:\"id\";i:132;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pantoglot.png\";s:16:\"logo_preview_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pantoglot.png\";s:4:\"name\";s:9:\"Pantoglot\";s:11:\"description\";s:275:\"Its passion for innovation drives Pantoglot to bring effective and efficient technology solutions to market. Today’s leading technology, quality control and agile management practices benefit Pantoglot customers and employee’s improving their experience and satisfaction.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/pantoglot/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11.42;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11.42;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.pantoglot.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"351817da1692629dc6a43a4c6b71f48a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:66;C:15:\"WPML_TP_Service\":2313:{a:38:{s:2:\"id\";i:8;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/gengo.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_gengo.png\";s:4:\"name\";s:5:\"Gengo\";s:11:\"description\";s:148:\"Gengo’s people-powered translation platform helps you translate content into over 36 languages through a selective, global network of translators.\";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/gengo/\";s:3:\"tms\";b:0;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Public key\";s:4:\"name\";s:10:\"public_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:2;s:13:\"speed_ranking\";d:5229;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:17:\"http://gengo.com/\";s:19:\"project_details_url\";s:34:\"https://gengo.com/auth/form/login/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"63f155572eb659a462aac247ee1bbf8d\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:70:\"Your public and secret keys are found on your Gengo Customer Dashboard\";s:26:\"how_to_get_credentials_url\";s:61:\"https://wpml.org/translation-service/gengo/#generate-api-keys\";s:30:\"client_create_account_page_url\";s:64:\"https://wpml.org/translation-service/gengo/#create-gengo-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Philippines\";s:4:\"code\";s:2:\"PH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:67;C:15:\"WPML_TP_Service\":1831:{a:38:{s:2:\"id\";i:139;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/innovalang.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_innovalang.png\";s:4:\"name\";s:10:\"InnovaLang\";s:11:\"description\";s:245:\"InnovaLang, professional translation: rooted in the patent world, and with burgeoning expertise, we’ve branched out in every field. Helping you to communicate quickly and easily, candidly and effectively. From every language to every language.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:11;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:11;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.innovalang.eu/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"49f481c1478679b4d4841de986c74b58\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:68;C:15:\"WPML_TP_Service\":2170:{a:38:{s:2:\"id\";i:114;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lionbridge.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lionbridge.png\";s:4:\"name\";s:10:\"Lionbridge\";s:11:\"description\";s:39:\"Lionbridge Connector for Wordpress WPML\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/lionbridge\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Base API URL\";s:4:\"name\";s:12:\"base_api_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:1;s:13:\"speed_ranking\";d:3902;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:10.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:10.58;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:31:\"https://wpml.org/go/lionbridge/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fc480f21118190585ff5d5e5384ae931\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Belgium\";s:4:\"code\";s:2:\"BE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"China\";s:4:\"code\";s:2:\"CN\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Denmark\";s:4:\"code\";s:2:\"DK\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:69;C:15:\"WPML_TP_Service\":1992:{a:38:{s:2:\"id\";i:76;s:8:\"logo_url\";s:70:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/rws-moravia.png\";s:16:\"logo_preview_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_rws-moravia.png\";s:4:\"name\";s:11:\"RWS Moravia\";s:11:\"description\";s:124:\"Based in Germany, RWS Moravia has more than 60 years of experience working with medium to large businesses around the world.\";s:7:\"doc_url\";s:60:\"https://wpml.org/translation-service/rws-language-solutions/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:10.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:10.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/rws/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"1bdc360fc2fe2ebb177e8a6cb2952d9c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:70;C:15:\"WPML_TP_Service\":1951:{a:38:{s:2:\"id\";i:142;s:8:\"logo_url\";s:80:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/translations-universe.png\";s:16:\"logo_preview_url\";s:88:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_translations-universe.png\";s:4:\"name\";s:21:\"Translations Universe\";s:11:\"description\";s:251:\"Translations Universe supports businesses with professional translation skills. It combines human know-how and software to offer translation solutions in 33 languages and 16 expertise areas. Their tools are built to save time and optimize investments.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:2;s:18:\"popularity_ranking\";d:9.75;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:9.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:37:\"https://www.translationsuniverse.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"630c5775afcee39ae7f29ef3861f7e1a\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Italy\";s:4:\"code\";s:2:\"IT\";}}}}i:71;C:15:\"WPML_TP_Service\":2481:{a:38:{s:2:\"id\";i:50;s:8:\"logo_url\";s:79:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/meridian-linguistics.png\";s:16:\"logo_preview_url\";s:87:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_meridian-linguistics.png\";s:4:\"name\";s:20:\"Meridian Linguistics\";s:11:\"description\";s:257:\"Meridian Linguistics is a Hong Kong-based translation services company with stringent quality assurance procedures, specializing in technology, law, business, and more. We offer 200+ languages, with particular expertise in Asia, the Middle East, and Europe.\";s:7:\"doc_url\";s:58:\"https://wpml.org/translation-service/meridian-linguistics/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.67;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:8.67;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/meridian/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"edecb5dee7049e4f69459611e2573779\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:68:\"A Meridian Linguistics team member will email you a unique API Token\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/meridian-linguistics/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:101:\"https://wpml.org/translation-service/meridian-linguistics/#requesting-an-meridian-linguistics-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:18:\"Korea, Republic of\";s:4:\"code\";s:2:\"KR\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:8:\"Thailand\";s:4:\"code\";s:2:\"TH\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:72;C:15:\"WPML_TP_Service\":2005:{a:38:{s:2:\"id\";i:137;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/abroadlink-translations.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_abroadlink-translations.png\";s:4:\"name\";s:23:\"AbroadLink Translations\";s:11:\"description\";s:250:\"AbroadLink is an ISO 13485 (medical devices), ISO 9001 (project management) and ISO 17100 (translation services) certified company offering localization, translation and desktop publishing to multinational corporations and SMB’s into 90+ languages.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/abroadlink-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:8.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.abroadlink.com\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"fbd36b346006a2c4bf00c192b0bf7a06\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:73;C:15:\"WPML_TP_Service\":2223:{a:38:{s:2:\"id\";i:138;s:8:\"logo_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/act-translations.png\";s:16:\"logo_preview_url\";s:83:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_act-translations.png\";s:4:\"name\";s:16:\"ACT Translations\";s:11:\"description\";s:272:\"ACT Translations uses state-of-the-art strategies and technologies to adapt your content to its target country in terms of its language and culture. The professional processing of e.g. websites, newsletters, blogs and social media content is part of our everyday business.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/a-c-t-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:3;s:13:\"speed_ranking\";d:5400;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:8.25;s:7:\"primary\";d:5;s:15:\"primary_ranking\";d:8.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:24:\"https://wpml.org/go/act/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"1c9ee90afe1cd16780a64a199860d004\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Austria\";s:4:\"code\";s:2:\"AT\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:2;O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"Switzerland\";s:4:\"code\";s:2:\"CH\";}i:3;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}}}}i:74;C:15:\"WPML_TP_Service\":2074:{a:38:{s:2:\"id\";i:70;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/speakt.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_speakt.png\";s:4:\"name\";s:6:\"Speakt\";s:11:\"description\";s:199:\"Speakt is a British translation service founded in 2010 and works with small to medium-size businesses. It offers professional human translations for more than 35 languages and 2,000 language pairs. \";s:7:\"doc_url\";s:43:\"https://wpml.org/translation-service/speakt\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:7.92;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:7.92;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/speakt/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"4a52b62404d73d86b86e9cbb05a38eaa\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:57:\"A Speakt team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/speakt/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/speakt/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Greece\";s:4:\"code\";s:2:\"GR\";}}}}i:75;C:15:\"WPML_TP_Service\":2234:{a:38:{s:2:\"id\";i:64;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pluslingua.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pluslingua.png\";s:4:\"name\";s:10:\"PlusLingua\";s:11:\"description\";s:226:\"PlusLingua has offices across Europe and predominantly deals with small to medium-size businesses. Since 2006, it has offered a range of translations for technical documentation, legal documents, marketing and business papers.\";s:7:\"doc_url\";s:80:\"https://wpml.org/translation-service/pluslingua-technical-communication-services\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:7.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:7.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/pluslingua/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ba11f752696ef6a4f922417b1fddb42f\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:61:\"A PlusLingua team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:101:\"https://wpml.org/translation-service/pluslingua-technical-communication-services/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:100:\"https://wpml.org/translation-service/pluslingua-technical-communication-services/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Spain\";s:4:\"code\";s:2:\"ES\";}}}}i:76;C:15:\"WPML_TP_Service\":2098:{a:38:{s:2:\"id\";i:29;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pozena.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pozena.png\";s:4:\"name\";s:6:\"Pozena\";s:11:\"description\";s:214:\"POZENA is a Polish localization and translation service with more than 20 years\' experience adapting small to medium-size businesses to new language markets. It has more than 400 clients in 22 different countries. \";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/pozena/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5509;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:5.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:5.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:19:\"https://pozena.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3dbcaf177b3b8a0ffd38c4f077f17df7\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:60:\"A POZENA team member will email your unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/pozena/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:72:\"https://wpml.org/translation-service/pozena/#requesting-a-pozena-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Poland\";s:4:\"code\";s:2:\"PL\";}}}}i:77;C:15:\"WPML_TP_Service\":2239:{a:38:{s:2:\"id\";i:62;s:8:\"logo_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transfluent-translation-agency.png\";s:16:\"logo_preview_url\";s:97:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transfluent-translation-agency.png\";s:4:\"name\";s:30:\"Transfluent Translation Agency\";s:11:\"description\";s:189:\"Transfluent was founded in 2011 and has bases in USA and Finland. It works with small to medium-size businesses from small game developers to Nasdaq listed companies in dozens of countries.\";s:7:\"doc_url\";s:49:\"https://wpml.org/translation-service/transfluent/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.83;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:32:\"https://wpml.org/go/transfluent/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"84e36198cb7f9085ca621971ba0c205b\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:62:\"A Transfluent team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:69:\"https://wpml.org/translation-service/transfluent/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/transfluent/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Finland\";s:4:\"code\";s:2:\"FI\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:78;C:15:\"WPML_TP_Service\":2665:{a:38:{s:2:\"id\";i:21;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/capita.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_capita.png\";s:4:\"name\";s:6:\"Capita\";s:11:\"description\";s:236:\"CAPITA TI is a British company which has been translating content for commercial businesses and public sector organizations since 1984. It specializes in legal, financial, manufacturing and e-Learning translations in over 180 languages.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/capita/\";s:3:\"tms\";b:0;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Customer Name\";s:4:\"name\";s:13:\"customer_name\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Contact Name\";s:4:\"name\";s:12:\"contact_name\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:5;s:13:\"speed_ranking\";d:5486;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.63;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.63;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:27:\"https://wpml.org/go/capita/\";s:19:\"project_details_url\";s:97:\"https://mtpflow.capita-ti.com/module/client/default/request_overview.jsp?request_id=%{request_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3393562c8687d38db9c447854bd20957\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:103:\"The username, password, customer name, and contact name will be provided upon creating a Capita account\";s:26:\"how_to_get_credentials_url\";s:75:\"https://wpml.org/translation-service/capita/#connecting-your-site-to-capita\";s:30:\"client_create_account_page_url\";s:57:\"https://www.capitatranslationinterpreting.com/contact-us/\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:14:\"United Kingdom\";s:4:\"code\";s:2:\"GB\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:79;C:15:\"WPML_TP_Service\":2038:{a:38:{s:2:\"id\";i:77;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/moncur-consulting.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_moncur-consulting.png\";s:4:\"name\";s:17:\"Moncur Consulting\";s:11:\"description\";s:286:\"Moncur Consulting is a localization agency in Minneapolis, MN. Their leadership has 20+ years of experience in the industry, having worked with agency clients (GMMB, Merkley+Partners, Momentum) and enterprise clients alike (Abbott, General Mills, Mayo Medical Laboratories, Target, etc)\";s:7:\"doc_url\";s:54:\"https://wpml.org/translation-service/moncur-consulting\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.33;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.33;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:38:\"https://wpml.org/go/moncur-consulting/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ef1de71437e8348003fc227feb22838f\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:80;C:15:\"WPML_TP_Service\":2041:{a:38:{s:2:\"id\";i:111;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/linguarum.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_linguarum.png\";s:4:\"name\";s:9:\"Linguarum\";s:11:\"description\";s:257:\"As a German agency, Linguarum provides handcrafted translations that are completed by native and specialist translators. Along with individual consulting goes the localization and SEO for your website. Choosing Linguarum means your website is in safe hands.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/linguarum/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:4;s:13:\"speed_ranking\";d:5483;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.18;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.18;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:30:\"https://wpml.org/go/linguarum/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"5ecaa5833688ffb39f39d58b174985f1\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Germany\";s:4:\"code\";s:2:\"DE\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:81;C:15:\"WPML_TP_Service\":2006:{a:38:{s:2:\"id\";i:134;s:8:\"logo_url\";s:82:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/glyph-language-services.png\";s:16:\"logo_preview_url\";s:90:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_glyph-language-services.png\";s:4:\"name\";s:23:\"Glyph Language Services\";s:11:\"description\";s:240:\"Glyph Language Services is a translation and localization company that specializes in high-quality output for complex business cases by utilizing technology and scalable, repeatable workflows with professional talent of the highest caliber.\";s:7:\"doc_url\";s:61:\"https://wpml.org/translation-service/glyph-language-services/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:4.08;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:4.08;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/glyph/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"99935b523062655817b5579fd3c6fb3c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:82;C:15:\"WPML_TP_Service\":2315:{a:38:{s:2:\"id\";i:56;s:8:\"logo_url\";s:78:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/nativy-translations.png\";s:16:\"logo_preview_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_nativy-translations.png\";s:4:\"name\";s:19:\"Nativy Translations\";s:11:\"description\";s:194:\"Nativy is a Vienna-based online translation agency offering professional translation services for over 500 language combinations in over 52 areas of specialization like tourism, IT, legal, etc. \";s:7:\"doc_url\";s:57:\"https://wpml.org/translation-service/nativy-translations/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Private key\";s:4:\"name\";s:11:\"private_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.75;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/nativy/\";s:19:\"project_details_url\";s:36:\"https://www.nativy.com/client/orders\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"406abbd6c5ab8df7b17f8acc68415b0c\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:5:\"email\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:76:\"Contact your Nativy project manager and request your API Key and Private Key\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/nativy-translations/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:79:\"https://wpml.org/translation-service/nativy-translations/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:7:\"Austria\";s:4:\"code\";s:2:\"AT\";}}}}i:83;C:15:\"WPML_TP_Service\":1997:{a:38:{s:2:\"id\";i:113;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/versacom.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_versacom.png\";s:4:\"name\";s:8:\"Versacom\";s:11:\"description\";s:297:\"Versacom defines what world class means in the translation industry. In addition to multilingual translation services, Versacom offers consulting and numerous specialized services. A whole universe of languages and dialects is within your reach with Versacom\'s professional quality and efficiency.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/versacom/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/versacom/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ea5d9737d96c68da0921eddf3496ca3e\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"Canada\";s:4:\"code\";s:2:\"CA\";}}}}i:84;C:15:\"WPML_TP_Service\":1862:{a:38:{s:2:\"id\";i:143;s:8:\"logo_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/europa-traduction.png\";s:16:\"logo_preview_url\";s:84:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_europa-traduction.png\";s:4:\"name\";s:17:\"Europa Traduction\";s:11:\"description\";s:244:\"Europa Traduction and Tradest are translation companies based in Lyon, France with 25 years + experience in the field of commercial and technical translation.\r\nWe translate multi-language websites with a focus on quality and technical accuracy.\";s:7:\"doc_url\";s:0:\"\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:3.58;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:3.58;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:33:\"https://www.europatraduction.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"9e2f7bbd05eae396b78ffa05cf4d6061\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:85;C:15:\"WPML_TP_Service\":2196:{a:38:{s:2:\"id\";i:73;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/atenao.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_atenao.png\";s:4:\"name\";s:6:\"Atenao\";s:11:\"description\";s:253:\"Trusted translation partner for groups such as Lacoste, L’Oréal, Olympus and Fujifilm Medical Systems, Atenao’s team of professional, native, experienced translators has translated hundreds of marketing, e-commerce, tourism and technology websites.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/atenao/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:2.25;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:2.25;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:27:\"https://wpml.org/go/atenao/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"f249d570e4a79bf3e32907034b4f2f61\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:58:\"An Atenao team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/atenao/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/atenao/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:6:\"France\";s:4:\"code\";s:2:\"FR\";}i:1;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Japan\";s:4:\"code\";s:2:\"JP\";}}}}i:86;C:15:\"WPML_TP_Service\":1879:{a:38:{s:2:\"id\";i:140;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/amplexor.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_amplexor.png\";s:4:\"name\";s:8:\"Amplexor\";s:11:\"description\";s:246:\"At Amplexor, content is a passion. For the past 30 years we have been helping organizations across industries and geographies to leverage content as a strategic differentiator, ensuring efficiency, compliance and exceptional customer experiences.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/amplexor/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:2.17;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:2.17;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:29:\"https://wpml.org/go/amplexor/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"6179437065c3a0e537dafd5e967b7bbc\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:87;C:15:\"WPML_TP_Service\":1983:{a:38:{s:2:\"id\";i:116;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/topcontent.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_topcontent.png\";s:4:\"name\";s:10:\"Topcontent\";s:11:\"description\";s:275:\"Topcontent fully integrates with WPML and delivers human made translations of the Northern European languages. Specialized in translations to and from German, Swedish, Norwegian, Finnish, English, Danish, Dutch and Russian. Also experts in iGaming content for online casinos.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/topcontent/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:1.5;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:1.5;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/topcontent/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"07e1ea00b30ff50fa156de5853018024\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"Malta\";s:4:\"code\";s:2:\"MT\";}}}}i:88;C:15:\"WPML_TP_Service\":2289:{a:38:{s:2:\"id\";i:57;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/acculing.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_acculing.png\";s:4:\"name\";s:8:\"Acculing\";s:11:\"description\";s:150:\"AccuLing brings together the right combination of people, processes, and technology to provide accuracy, speed, and cost-effectiveness in translation.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/acculing/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:15:\"client_username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:15:\"client_password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:0.83;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0.83;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:19:\"http://acculing.com\";s:19:\"project_details_url\";s:84:\"https://fluencyserver.com/Acculing/FluencyFlow/CustomerPortal/CustomerDashboard.aspx\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"38a623f611a08d65a565ec91588e74ba\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:102:\"Acculing will email you information on how to complete your registration and retrieve your credentials\";s:26:\"how_to_get_credentials_url\";s:68:\"https://wpml.org/translation-service/acculing/#receiving-credentials\";s:30:\"client_create_account_page_url\";s:68:\"https://wpml.org/translation-service/acculing/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:89;C:15:\"WPML_TP_Service\":2097:{a:38:{s:2:\"id\";i:49;s:8:\"logo_url\";s:65:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/ulatus.png\";s:16:\"logo_preview_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_ulatus.png\";s:4:\"name\";s:6:\"Ulatus\";s:11:\"description\";s:217:\"Ulatus is an American company focusing on Asian languages - explicitly Japanese, Chinese, Korean and Indic languages.  It was founded in 2005 and has 1200 in-territory translators working with a variety of industries.\";s:7:\"doc_url\";s:44:\"https://wpml.org/translation-service/ulatus/\";s:3:\"tms\";b:0;s:7:\"partner\";b:1;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:1;s:18:\"popularity_ranking\";d:0.75;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0.75;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"https://www.ulatus.com/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a922e13546c96ba8d78160d7adc2f9be\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:57:\"A Ulatus team member will email a unique API Token to you\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/ulatus/#receiving-api-token\";s:30:\"client_create_account_page_url\";s:63:\"https://wpml.org/translation-service/ulatus/#requesting-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:13:\"United States\";s:4:\"code\";s:2:\"US\";}}}}i:90;C:15:\"WPML_TP_Service\":2159:{a:38:{s:2:\"id\";i:2;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/cloudwords.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_cloudwords.png\";s:4:\"name\";s:10:\"Cloudwords\";s:11:\"description\";s:268:\"Cloudwords offers quality translation for both small and large websites. In-context review guarantees that all published content meets high standards and you can work with your favorite translation service or locate a translation service in the Cloudwords Marketplace.\";s:7:\"doc_url\";s:48:\"https://wpml.org/translation-service/cloudwords/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:26:\"http://www.cloudwords.com/\";s:19:\"project_details_url\";s:56:\"https://app.cloudwords.com/cust.htm#project/{project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:50;s:4:\"suid\";s:32:\"b0a9c2513a2d679dfae1d5ec9846a0d5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:102:\"Your API Token is located under \"Settings >My Account  > API\" tab on your Cloudwords account Dashboard\";s:26:\"how_to_get_credentials_url\";s:61:\"https://wpml.org/translation-service/cloudwords/#connect-site\";s:30:\"client_create_account_page_url\";s:34:\"https://www.cloudwords.com/contact\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:91;C:15:\"WPML_TP_Service\":2434:{a:38:{s:2:\"id\";i:14;s:8:\"logo_url\";s:73:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/wordbee-beebox.png\";s:16:\"logo_preview_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_wordbee-beebox.png\";s:4:\"name\";s:14:\"Wordbee Beebox\";s:11:\"description\";s:187:\"Translation service connector. Send content for translation to your preferred language service provider (LSP). Ask your LSP for your authentication details and click below to get started.\";s:7:\"doc_url\";s:52:\"https://wpml.org/translation-service/wordbee-beebox/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API URL\";s:4:\"name\";s:7:\"api_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:15:\"API Project Key\";s:4:\"name\";s:15:\"api_project_key\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"API Username\";s:4:\"name\";s:12:\"api_username\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"API Password\";s:4:\"name\";s:12:\"api_password\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:23:\"http://www.wordbee.com/\";s:19:\"project_details_url\";s:27:\"Translation Service API URL\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"582b86fafdf60f1eba580abc6c56f8ad\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:111:\"Your API URL, API Project Key, API Username and API Password will be provided by your Language Service Provider\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/wordbee-beebox/#connect-site\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/wordbee-beebox/#connect-site\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:92;C:15:\"WPML_TP_Service\":2356:{a:38:{s:2:\"id\";i:15;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/transifex.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_transifex.png\";s:4:\"name\";s:9:\"Transifex\";s:11:\"description\";s:165:\"The Transifex platform enables companies to produce high-quality translations by connecting their sources of digital content to the translation team of their choice.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/transifex/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:17:\"Organization slug\";s:4:\"name\";s:8:\"org_slug\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Repository URL\";s:4:\"name\";s:8:\"repo_url\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:20:\"http://transifex.com\";s:19:\"project_details_url\";s:33:\"https://www.transifex.com/signin/\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"581080d8aad81654458e7d9efa8b9c5a\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:108:\"Your username, password, and organization slug are what you have created during your Transifex account setup\";s:26:\"how_to_get_credentials_url\";s:79:\"https://wpml.org/translation-service/transifex/#transifex-account-configuration\";s:30:\"client_create_account_page_url\";s:33:\"https://www.transifex.com/signup/\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:93;C:15:\"WPML_TP_Service\":2191:{a:38:{s:2:\"id\";i:26;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/poeditor.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_poeditor.png\";s:4:\"name\";s:8:\"POEditor\";s:11:\"description\";s:273:\"Warning! To achieve the best results please use POEditor for strings translation only. POEditor is a collaborative platform, built to easily manage the translation of apps, websites or related software, in a team or independently, and to automate the localization workflow.\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/poeditor/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"API token\";s:4:\"name\";s:9:\"api_token\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:29:\"https://wpml.org/go/poeditor/\";s:19:\"project_details_url\";s:50:\"https://poeditor.com/projects/view?id={project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"97956a8eed5fa652b8c2ec2b9eda6988\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:94:\"Your API Token is located under \"Account Settings > API Access\" tab on your POEditor Dashboard\";s:26:\"how_to_get_credentials_url\";s:67:\"https://wpml.org/translation-service/poeditor/#retrieving-api-token\";s:30:\"client_create_account_page_url\";s:74:\"https://wpml.org/translation-service/poeditor/#creating-a-poeditor-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:94;C:15:\"WPML_TP_Service\":2288:{a:38:{s:2:\"id\";i:32;s:8:\"logo_url\";s:69:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/multitrans.png\";s:16:\"logo_preview_url\";s:77:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_multitrans.png\";s:4:\"name\";s:10:\"MultiTrans\";s:11:\"description\";s:214:\"MultiTrans TMS includes Terminology Management, Translation Memories and many other project management and BI modules. With over 25 years of experience, it provides a full range of linguistic products and services.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/multitrans\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:5:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Flow URL\";s:4:\"name\";s:8:\"flow_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Customer name\";s:4:\"name\";s:13:\"customer_name\";s:4:\"type\";s:4:\"text\";}i:4;O:8:\"stdClass\":3:{s:5:\"label\";s:12:\"Contact name\";s:4:\"name\";s:12:\"contact_name\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:31:\"https://wpml.org/go/multitrans/\";s:19:\"project_details_url\";s:22:\"Project\'s custom field\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"e036dae66d3cc50ba9119f3770256b9d\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:95;C:15:\"WPML_TP_Service\":2104:{a:38:{s:2:\"id\";i:46;s:8:\"logo_url\";s:66:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/matecat.png\";s:16:\"logo_preview_url\";s:74:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_matecat.png\";s:4:\"name\";s:7:\"MateCat\";s:11:\"description\";s:142:\"MateCat is a free translation platform to translate your WordPress content yourself or to assign the translation to a professional translator.\";s:7:\"doc_url\";s:45:\"https://wpml.org/translation-service/matecat/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"API Secret\";s:4:\"name\";s:10:\"api_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:28:\"https://wpml.org/go/matecat/\";s:19:\"project_details_url\";s:30:\"https://www.matecat.com/manage\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"8cce487cb1cb5f6c7643235e2da82fa4\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:73:\"A member of the MateCat team will email you an API Key and API Secret Key\";s:26:\"how_to_get_credentials_url\";s:64:\"https://wpml.org/translation-service/matecat/#receiving-api-keys\";s:30:\"client_create_account_page_url\";s:67:\"https://wpml.org/translation-service/matecat/#requesting-an-account\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:96;C:15:\"WPML_TP_Service\":2149:{a:38:{s:2:\"id\";i:59;s:8:\"logo_url\";s:64:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/memoq.png\";s:16:\"logo_preview_url\";s:72:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_memoq.png\";s:4:\"name\";s:5:\"memoQ\";s:11:\"description\";s:212:\"The memoQ connector for WordPress offers a fully automated translation workflow between WPML and memoQ server and provides an easy way to manage multilingual web content and translation projects within WordPress.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/memoq\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:2:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Connection key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:14:\"Connection url\";s:4:\"name\";s:7:\"api_url\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://wpml.org/go/memoq/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"c6e1c5624529722f2bc138dcd0c63ee5\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:83:\"Your translation provider will provide your memoQ Connection key and Connection url\";s:26:\"how_to_get_credentials_url\";s:65:\"https://wpml.org/translation-service/memoq/#requesting-an-account\";s:30:\"client_create_account_page_url\";s:65:\"https://wpml.org/translation-service/memoq/#requesting-an-account\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:97;C:15:\"WPML_TP_Service\":1789:{a:38:{s:2:\"id\";i:82;s:8:\"logo_url\";s:86:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/pseudo-translation-services.png\";s:16:\"logo_preview_url\";s:94:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_pseudo-translation-services.png\";s:4:\"name\";s:27:\"Pseudo Translation Services\";s:11:\"description\";s:153:\"This is a demo service for learning and practicing the WPML workflow for professional translation. To authenticate please use any string as an API Token.\";s:7:\"doc_url\";s:14:\"http://lvh.me/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:14:\"http://lvh.me/\";s:19:\"project_details_url\";s:0:\"\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a31f833a7b129003abe76987b06c8e44\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:0;s:9:\"countries\";a:0:{}}}i:98;C:15:\"WPML_TP_Service\":1854:{a:38:{s:2:\"id\";i:83;s:8:\"logo_url\";s:63:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/lilt.png\";s:16:\"logo_preview_url\";s:71:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_lilt.png\";s:4:\"name\";s:4:\"Lilt\";s:11:\"description\";s:197:\"Lilt is the new engine for enterprise translation workflows. We increase quality and speed with the neural feedback loop which combines human ingenuity and machine intelligence in a virtuous cycle.\";s:7:\"doc_url\";s:42:\"https://wpml.org/translation-service/lilt/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:1:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API Key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:16:\"https://lilt.com\";s:19:\"project_details_url\";s:60:\"https://lilt.com/app/projects/details/{project_id}/documents\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"ffad5fa853bba0b6c9eda94b382b0201\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:99;C:15:\"WPML_TP_Service\":2088:{a:38:{s:2:\"id\";i:117;s:8:\"logo_url\";s:67:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartcat.png\";s:16:\"logo_preview_url\";s:75:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartcat.png\";s:4:\"name\";s:8:\"Smartcat\";s:11:\"description\";s:225:\"Smartcat is an all-in-one platform connecting businesses and translators into a continuous translation delivery loop by combining a collaborative workflow solution, a marketplace, and a network of translation professionals.\r\n\";s:7:\"doc_url\";s:46:\"https://wpml.org/translation-service/smartcat/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:3:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Server URL\";s:4:\"name\";s:10:\"server_url\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:7:\"API key\";s:4:\"name\";s:7:\"api_key\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Account ID\";s:4:\"name\";s:10:\"account_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:24:\"https://www.smartcat.ai/\";s:19:\"project_details_url\";s:36:\"%{server_url}/projects/%{project_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"d1c696251639dde597dd81b6fec113a9\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:3:\"api\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:100;C:15:\"WPML_TP_Service\":2339:{a:38:{s:2:\"id\";i:121;s:8:\"logo_url\";s:68:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/smartling.png\";s:16:\"logo_preview_url\";s:76:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_smartling.png\";s:4:\"name\";s:9:\"Smartling\";s:11:\"description\";s:285:\"Smartling is a translation management platform and language services provider to localize content across devices and platforms. Author of Enterprise Translation Cloud, a data-driven approach to localization that helps customers achieve higher quality translation at a lower total cost.\";s:7:\"doc_url\";s:47:\"https://wpml.org/translation-service/smartling/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:15:\"User Identifier\";s:4:\"name\";s:15:\"user_identifier\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"User Secret\";s:4:\"name\";s:11:\"user_secret\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:11:\"Account UID\";s:4:\"name\";s:11:\"account_uid\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:10:\"Project ID\";s:4:\"name\";s:10:\"project_id\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:1;s:3:\"url\";s:26:\"https://www.smartling.com/\";s:19:\"project_details_url\";s:92:\"https://dashboard.smartling.com/app/accounts/{account_id}/account-jobs/{project_id}:{job_id}\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"3f1d34db7a1c34e0840e81b4aceb97db\";s:12:\"notification\";b:1;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:0;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:0;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:0:\"\";s:26:\"how_to_get_credentials_url\";s:0:\"\";s:30:\"client_create_account_page_url\";s:0:\"\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}i:101;C:15:\"WPML_TP_Service\":2496:{a:38:{s:2:\"id\";i:144;s:8:\"logo_url\";s:81:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/sdl-language-cloud-tms.png\";s:16:\"logo_preview_url\";s:89:\"https://d1lsub6zbh43gv.cloudfront.net/production/logos/preview_sdl-language-cloud-tms.png\";s:4:\"name\";s:22:\"SDL Language Cloud TMS\";s:11:\"description\";s:221:\"The SDL Language Cloud TMS connector for WPML provides a seamless link between WPML and SDL Language Cloud TMS, allowing fast and easy management of multilingual web content and translation projects from within WordPress.\";s:7:\"doc_url\";s:56:\"https://wpml.org/translation-service/sdl-language-cloud/\";s:3:\"tms\";b:1;s:7:\"partner\";b:0;s:13:\"custom_fields\";a:4:{i:0;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Username\";s:4:\"name\";s:8:\"username\";s:4:\"type\";s:4:\"text\";}i:1;O:8:\"stdClass\":3:{s:5:\"label\";s:8:\"Password\";s:4:\"name\";s:8:\"password\";s:4:\"type\";s:4:\"text\";}i:2;O:8:\"stdClass\":3:{s:5:\"label\";s:9:\"Client ID\";s:4:\"name\";s:9:\"client_id\";s:4:\"type\";s:4:\"text\";}i:3;O:8:\"stdClass\":3:{s:5:\"label\";s:13:\"Client Secret\";s:4:\"name\";s:13:\"client_secret\";s:4:\"type\";s:4:\"text\";}}s:18:\"custom_fields_data\";N;s:23:\"requires_authentication\";b:1;s:8:\"rankings\";O:8:\"stdClass\":8:{s:7:\"quality\";i:0;s:15:\"quality_ranking\";d:0;s:5:\"speed\";i:0;s:13:\"speed_ranking\";d:0;s:10:\"popularity\";i:0;s:18:\"popularity_ranking\";d:0;s:7:\"primary\";d:0;s:15:\"primary_ranking\";d:0;}s:18:\"has_language_pairs\";b:0;s:3:\"url\";s:30:\"https://languagecloud.sdl.com/\";s:19:\"project_details_url\";s:45:\"https://languagecloud.sdl.com/en/cp/dashboard\";s:21:\"add_language_pair_url\";s:0:\"\";s:15:\"custom_text_url\";s:0:\"\";s:28:\"select_translator_iframe_url\";s:0:\"\";s:29:\"translator_contact_iframe_url\";s:0:\"\";s:16:\"quote_iframe_url\";s:0:\"\";s:24:\"has_translator_selection\";b:0;s:19:\"project_name_length\";i:128;s:4:\"suid\";s:32:\"a87dad5a887e062d5a269574bd54fc3b\";s:12:\"notification\";b:0;s:14:\"preview_bundle\";N;s:8:\"deadline\";b:1;s:5:\"oauth\";b:0;s:9:\"oauth_url\";s:0:\"\";s:15:\"default_service\";i:0;s:20:\"translation_feedback\";b:1;s:23:\"feedback_forward_method\";s:6:\"manual\";s:12:\"last_refresh\";N;s:13:\"popup_message\";s:0:\"\";s:27:\"how_to_get_credentials_desc\";s:97:\"Your username and password are the same as the credentials you use to login to SDL Language Cloud\";s:26:\"how_to_get_credentials_url\";s:85:\"https://wpml.org/translation-service/sdl-language-cloud/#connecting-to-language-cloud\";s:30:\"client_create_account_page_url\";s:54:\"https://oos.sdl.com/asp/products/ssl/RegisterUser.aspx\";s:14:\"redirect_to_ts\";b:1;s:9:\"countries\";a:0:{}}}}","no");

INSERT INTO `wp_options` VALUES 
("3162","wpml_shortcode_list","a:291:{i:0;s:14:\"call_to_action\";i:1;s:10:\"newsletter\";i:2;s:15:\"tours_shortcode\";i:3;s:10:\"cta_button\";i:4;s:20:\"woocommerce_thankyou\";i:5;s:16:\"woocommerce_shop\";i:6;s:5:\"table\";i:7;s:14:\"custom_profile\";i:8;s:14:\"symple_heading\";i:9;s:3:\"row\";i:10;s:8:\"tagcloud\";i:11;s:5:\"sform\";i:12;s:4:\"nano\";i:13;s:16:\"add_eventon_list\";i:14;s:3:\"che\";i:15;s:3:\"era\";i:16;s:4:\"essa\";i:17;s:3:\"nel\";i:18;s:3:\"gli\";i:19;s:3:\"per\";i:20;s:4:\"come\";i:21;s:5:\"anima\";i:22;s:4:\"ella\";i:23;s:4:\"quel\";i:24;s:18:\"show_gd_mylist_btn\";i:25;s:10:\"su_spoiler\";i:26;s:5:\"email\";i:27;s:3:\"vul\";i:28;s:8:\"wpv-view\";i:29;s:14:\"wpv-post-field\";i:30;s:14:\"accordion_item\";i:31;s:8:\"citation\";i:32;s:7:\"gallery\";i:33;s:10:\"foogallery\";i:34;s:20:\"user-submitted-posts\";i:35;s:11:\"chronologie\";i:36;s:7:\"adresse\";i:37;s:14:\"get_unit_label\";i:38;s:19:\"get_reference_label\";i:39;s:36:\"woocommerce_api_manager_lost_api_key\";i:40;s:16:\"wp-knowledgebase\";i:41;s:19:\"testimonials_slider\";i:42;s:4:\"rpwe\";i:43;s:5:\"posts\";i:44;s:9:\"nowotworu\";i:45;s:12:\"intima-media\";i:46;s:9:\"dostarcza\";i:47;s:14:\"standaryzowany\";i:48;s:4:\"jako\";i:49;s:6:\"czarny\";i:50;s:8:\"ekstrakt\";i:51;s:4:\"kwas\";i:52;s:3:\"std\";i:53;s:10:\"dwuwodzian\";i:54;s:12:\"stm_icon_box\";i:55;s:8:\"ess_grid\";i:56;s:10:\"rev_slider\";i:57;s:8:\"linkview\";i:58;s:7:\"dropcap\";i:59;s:13:\"permalinklist\";i:60;s:18:\"testimonial_slider\";i:61;s:33:\"woocommerce_software_lost_license\";i:62;s:11:\"text-blocks\";i:63;s:15:\"wp_sitemap_page\";i:64;s:11:\"wcmp_vendor\";i:65;s:19:\"vendor_registration\";i:66;s:6:\"efsrow\";i:67;s:9:\"efscolumn\";i:68;s:9:\"efsbutton\";i:69;s:13:\"md_rev_slider\";i:70;s:12:\"md_live_text\";i:71;s:16:\"md_imagebox_full\";i:72;s:10:\"flagallery\";i:73;s:18:\"pbr_quicklinksmenu\";i:74;s:13:\"rev_slider_vc\";i:75;s:26:\"opalhotel_reservation_form\";i:76;s:17:\"pbr_title_heading\";i:77;s:16:\"pbr_testimonials\";i:78;s:7:\"embedyt\";i:79;s:18:\"yith_wcwl_wishlist\";i:80;s:22:\"wcm_content_restricted\";i:81;s:11:\"feature_box\";i:82;s:20:\"woocommerce_en_check\";i:83;s:6:\"wc_box\";i:84;s:6:\"wc_row\";i:85;s:9:\"wc_column\";i:86;s:12:\"wc_fullwidth\";i:87;s:9:\"wc_center\";i:88;s:17:\"wp_social_sharing\";i:89;s:9:\"infoboxes\";i:90;s:12:\"testimonials\";i:91;s:38:\"woocommerce_social_media_share_buttons\";i:92;s:20:\"wcv_vendor_dashboard\";i:93;s:17:\"wcv_shop_settings\";i:94;s:10:\"wcv_orders\";i:95;s:8:\"inplayer\";i:96;s:12:\"useyourdrive\";i:97;s:16:\"wp_blog_designer\";i:98;s:7:\"us_blog\";i:99;s:10:\"tt_address\";i:100;s:12:\"tt_dashboard\";i:101;s:14:\"envira-gallery\";i:102;s:11:\"hotspotitem\";i:103;s:27:\"woocommerce_klarna_checkout\";i:104;s:11:\"wpml_mailto\";i:105;s:13:\"contact-field\";i:106;s:9:\"ux_banner\";i:107;s:15:\"advanced_iframe\";i:108;s:17:\"siteorigin_widget\";i:109;s:8:\"ec_store\";i:110;s:22:\"simpay_payment_receipt\";i:111;s:10:\"su-mensaje\";i:112;s:14:\"borlabs_cookie\";i:113;s:12:\"contact_info\";i:114;s:15:\"stm_boats_video\";i:115;s:18:\"packages_orderdata\";i:116;s:24:\"yith_ywraq_request_quote\";i:117;s:15:\"woocommerce_pay\";i:118;s:6:\"button\";i:119;s:16:\"supsystic-tables\";i:120;s:11:\"clean-login\";i:121;s:15:\"woocommerce_pay\";i:122;s:12:\"pdf-embedder\";i:123;s:15:\"insertgenerator\";i:124;s:15:\"youzer_register\";i:125;s:11:\"wysija_form\";i:126;s:5:\"video\";i:127;s:13:\"customer-area\";i:128;s:23:\"customer-area-dashboard\";i:129;s:32:\"customer-area-private-files-home\";i:130;s:27:\"customer-area-private-files\";i:131;s:21:\"customer-account-home\";i:132;s:21:\"customer-area-account\";i:133;s:20:\"customer-area-logout\";i:134;s:11:\"bookly-form\";i:135;s:32:\"bookly-cancellation-confirmation\";i:136;s:18:\"stm_classic_filter\";i:137;s:13:\"popup_trigger\";i:138;s:21:\"mainwp_archived_lists\";i:139;s:15:\"wcv_vendorslist\";i:140;s:14:\"dotpay_content\";i:141;s:9:\"formularz\";i:142;s:41:\"cyberactive_school_courses_selection_form\";i:143;s:34:\"cyberactive_school_session_timeout\";i:144;s:17:\"ditty_news_ticker\";i:145;s:16:\"donationcampaign\";i:146;s:15:\"das-list-events\";i:147;s:11:\"event_embed\";i:148;s:12:\"sectiontitle\";i:149;s:19:\"learn_press_profile\";i:150;s:13:\"ticket-submit\";i:151;s:7:\"tickets\";i:152;s:10:\"aanduiding\";i:153;s:5:\"datum\";i:154;s:13:\"thim-icon-box\";i:155;s:10:\"ngg_images\";i:156;s:15:\"wpdomainchecker\";i:157;s:10:\"visualizer\";i:158;s:15:\"mk_page_section\";i:159;s:10:\"rssreviews\";i:160;s:12:\"animate_this\";i:161;s:14:\"simple-sitemap\";i:162;s:11:\"gravityform\";i:163;s:13:\"stm_tech_info\";i:164;s:19:\"fep_submission_form\";i:165;s:26:\"ucaddon_diagonal_event_box\";i:166;s:17:\"wcv_feedback_form\";i:167;s:22:\"newsletters_management\";i:168;s:17:\"wcv_pro_dashboard\";i:169;s:13:\"tm_pb_section\";i:170;s:20:\"wwof_product_listing\";i:171;s:7:\"res_map\";i:172;s:15:\"jssupportticket\";i:173;s:9:\"socialbar\";i:174;s:17:\"socialbar_service\";i:175;s:12:\"front-end-pm\";i:176;s:11:\"stm_sidebar\";i:177;s:12:\"give_receipt\";i:178;s:16:\"donation_history\";i:179;s:12:\"simpay_error\";i:180;s:19:\"tm_pb_contact_field\";i:181;s:3:\"jwp\";i:182;s:20:\"woocommerce_checkout\";i:183;s:14:\"mk_custom_list\";i:184;s:8:\"sg_popup\";i:185;s:4:\"icon\";i:186;s:10:\"extra_wrap\";i:187;s:13:\"frontier-post\";i:188;s:8:\"invierno\";i:189;s:6:\"appbox\";i:190;s:9:\"highlight\";i:191;s:8:\"ci_alert\";i:192;s:15:\"vc_mad_products\";i:193;s:7:\"dt_list\";i:194;s:15:\"geoip-continent\";i:195;s:13:\"geoip-country\";i:196;s:12:\"geoip-region\";i:197;s:10:\"geoip-city\";i:198;s:16:\"geoip-postalcode\";i:199;s:14:\"geoip-latitude\";i:200;s:15:\"geoip-longitude\";i:201;s:14:\"geoip-location\";i:202;s:19:\"woocommerce_notices\";i:203;s:12:\"stm_icon_box\";i:204;s:13:\"post-timeline\";i:205;s:10:\"tt_address\";i:206;s:15:\"private-message\";i:207;s:10:\"visualizer\";i:208;s:9:\"ga_optout\";i:209;s:23:\"manage_serial_key_usage\";i:210;s:9:\"ut_header\";i:211;s:9:\"site_name\";i:212;s:6:\"bfname\";i:213;s:8:\"order_id\";i:214;s:12:\"menu-country\";i:215;s:11:\"menu-prefer\";i:216;s:14:\"accordion-item\";i:217;s:9:\"mini-icon\";i:218;s:7:\"gvlogic\";i:219;s:8:\"stm_gmap\";i:220;s:12:\"contact-form\";i:221;s:7:\"iconbox\";i:222;s:22:\"woocommerce_my_account\";i:223;s:10:\"super_form\";i:224;s:17:\"wpdm-all-packages\";i:225;s:11:\"photoblocks\";i:226;s:13:\"et_pb_map_pin\";i:227;s:19:\"ginger_reset_cookie\";i:228;s:10:\"su_divider\";i:229;s:16:\"fbl_login_button\";i:230;s:19:\"gmw_single_location\";i:231;s:8:\"one_full\";i:232;s:15:\"recent_products\";i:233;s:11:\"custom_list\";i:234;s:5:\"endif\";i:235;s:5:\"jours\";i:236;s:10:\"wpuf-login\";i:237;s:4:\"lyte\";i:238;s:13:\"product_table\";i:239;s:17:\"wpuf-registration\";i:240;s:14:\"wpuf_dashboard\";i:241;s:6:\"amazon\";i:242;s:20:\"member-pricing-table\";i:243;s:7:\"rozinky\";i:244;s:10:\"ngg_images\";i:245;s:15:\"add_to_cart_url\";i:246;s:15:\"srizonfbgallery\";i:247;s:11:\"wysija_form\";i:248;s:8:\"cl-itext\";i:249;s:7:\"embedyt\";i:250;s:12:\"icon_counter\";i:251;s:10:\"text_block\";i:252;s:8:\"vtftable\";i:253;s:13:\"header_static\";i:254;s:15:\"bookingcalendar\";i:255;s:10:\"flexslider\";i:256;s:16:\"anova-geoip-meta\";i:257;s:23:\"zp_vc_slideshow_element\";i:258;s:11:\"zp_scrollto\";i:259;s:20:\"my_calendar_upcoming\";i:260;s:12:\"wpv-post-url\";i:261;s:13:\"fusion_button\";i:262;s:6:\"su_tab\";i:263;s:37:\"freeconsultation_technical_forum_link\";i:264;s:18:\"vc_images_carousel\";i:265;s:13:\"otgs_logo_url\";i:266;s:15:\"wpv-conditional\";i:267;s:8:\"wpv-view\";i:268;s:6:\"teaser\";i:269;s:14:\"dt_fancy_image\";i:270;s:18:\"fusion_tagline_box\";i:271;s:14:\"contact_us_add\";i:272;s:11:\"content_box\";i:273;s:11:\"tagline_box\";i:274;s:10:\"us_iconbox\";i:275;s:10:\"fusion_tab\";i:276;s:11:\"fisicamente\";i:277;s:16:\"one_half_sidebar\";i:278;s:10:\"action-btn\";i:279;s:16:\"invicta_contacts\";i:280;s:13:\"pricing_price\";i:281;s:6:\"button\";i:282;s:9:\"icon_link\";i:283;s:9:\"slideshow\";i:284;s:14:\"vcex_milestone\";i:285;s:14:\"secondary-demo\";i:286;s:16:\"vh_pricing_table\";i:287;s:13:\"category_name\";i:288;s:7:\"blogurl\";i:289;s:6:\"q_team\";i:290;s:12:\"tab_nav_item\";}","yes"),
("3163","wpml_built_with_page_builder","a:1:{i:0;s:10:\"/<!-- wp:/\";}","yes"),
("3164","wpml-gutenberg-config","a:59:{s:14:\"core/paragraph\";a:1:{s:5:\"xpath\";a:1:{i:0;s:3:\"//p\";}}s:12:\"core/heading\";a:1:{s:5:\"xpath\";a:1:{i:0;s:73:\"//*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]\";}}s:11:\"core/button\";a:1:{s:5:\"xpath\";a:2:{i:0;s:3:\"//a\";i:1;a:2:{s:5:\"value\";s:9:\"//a/@href\";s:4:\"type\";s:4:\"LINK\";}}}s:10:\"core/image\";a:1:{s:5:\"xpath\";a:4:{i:0;s:19:\"//figure/figcaption\";i:1;s:18:\"//figure//img/@alt\";i:2;s:20:\"//figure//img/@title\";i:3;a:2:{s:5:\"value\";s:16:\"//figure/a/@href\";s:4:\"type\";s:4:\"LINK\";}}}s:12:\"core/gallery\";a:1:{s:5:\"xpath\";a:2:{i:0;s:19:\"//figure/figcaption\";i:1;s:17:\"//figure/img/@alt\";}}s:15:\"core/media-text\";a:1:{s:5:\"xpath\";a:1:{i:0;s:17:\"//figure/img/@alt\";}}s:9:\"core/list\";a:1:{s:5:\"xpath\";a:1:{i:0;s:15:\"//ul/li|//ol/li\";}}s:10:\"core/quote\";a:1:{s:5:\"xpath\";a:2:{i:0;s:14:\"//blockquote/p\";i:1;s:17:\"//blockquote/cite\";}}s:10:\"core/audio\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:10:\"core/video\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:9:\"core/file\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/a\";}}s:10:\"core/cover\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/p\";}}s:16:\"core/cover-image\";a:1:{s:5:\"xpath\";a:1:{i:0;s:7:\"//div/p\";}}s:12:\"core/subhead\";a:1:{s:5:\"xpath\";a:1:{i:0;s:3:\"//p\";}}s:10:\"core/verse\";a:1:{s:5:\"xpath\";a:1:{i:0;s:5:\"//pre\";}}s:10:\"core/table\";a:1:{s:5:\"xpath\";a:3:{i:0;s:4:\"//th\";i:1;s:4:\"//td\";i:2;s:19:\"//figure/figcaption\";}}s:17:\"core/preformatted\";a:1:{s:5:\"xpath\";a:1:{i:0;s:5:\"//pre\";}}s:14:\"core/pullquote\";a:1:{s:5:\"xpath\";a:2:{i:0;s:14:\"//blockquote/p\";i:1;s:17:\"//blockquote/cite\";}}s:11:\"core/column\";a:0:{}s:12:\"core/columns\";a:0:{}s:9:\"core/code\";a:0:{}s:9:\"core/more\";a:0:{}s:13:\"core/nextpage\";a:0:{}s:14:\"core/separator\";a:0:{}s:11:\"core/spacer\";a:0:{}s:14:\"core/shortcode\";a:0:{}s:18:\"core-embed/twitter\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/youtube\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:19:\"core-embed/facebook\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/instagram\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/vimeo\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/soundcloud\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/spotify\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/flickr\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/animoto\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/collegehumor\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/dailymotion\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/funnyordie\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:15:\"core-embed/hulu\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/imgur\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:16:\"core-embed/issuu\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/kickstarter\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/meetup-com\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:19:\"core-embed/mixcloud\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:22:\"core-embed/photobucket\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/polldaddy\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/reddit\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/reverbnation\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/screencast\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/scribd\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/slideshare\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/smugmug\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:18:\"core-embed/speaker\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:14:\"core-embed/ted\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:17:\"core-embed/tumblr\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:21:\"core-embed/videopress\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:20:\"core-embed/wordpress\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:23:\"core-embed/wordpress-tv\";a:1:{s:5:\"xpath\";a:1:{i:0;s:19:\"//figure/figcaption\";}}s:9:\"core/html\";a:1:{s:5:\"xpath\";a:1:{i:0;s:2:\"/*\";}}}","yes"),
("3165","wpml-tm-translation-jobs-migration","1","yes"),
("3166","wpml-tm-all-translation-jobs-migration","3","yes"),
("3178","wpml_strings_need_links_fixed","a:0:{}","yes"),
("3197","otgs-installer-log","a:3:{i:0;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-20-04 08:04:11\";}i:1;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:61:\"wpml: Site key does not match for https://milo.sgsmedia.dk/wp\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-19-04 08:04:13\";}i:2;a:5:{s:12:\"request_args\";N;s:11:\"request_url\";N;s:8:\"response\";s:35:\"Subscriptions updated successfully.\";s:9:\"component\";s:21:\"subscription-fetching\";s:4:\"time\";s:19:\"2021-18-04 07:04:00\";}}","yes"),
("3207","installer_repositories_with_theme","a:1:{i:0;s:7:\"toolset\";}","yes"),
("3221","wpml_registered_endpoints","a:0:{}","yes"),
("3270","icl_translation_jobs_basket","a:1:{s:16:\"target_languages\";a:0:{}}","no"),
("3297","options_theme_settings_group_theme_header_scripts_head","<script>\r\nconsole.log(\"head tag here\");\r\n</script>","no"),
("3298","_options_theme_settings_group_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("3299","options_theme_settings_group_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"after body opening\");\r\n</script>","no"),
("3300","_options_theme_settings_group_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("3301","options_theme_settings_group_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"in the footer\");\r\n</script>","no"),
("3302","_options_theme_settings_group_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("3303","options_theme_settings_group_social_media_icons_0_social_media_item_name","Facebook","no"),
("3304","_options_theme_settings_group_social_media_icons_0_social_media_item_name","field_607c285af4ce0","no"),
("3305","options_theme_settings_group_social_media_icons_0_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>","no"),
("3306","_options_theme_settings_group_social_media_icons_0_social_media_item_icon","field_607c2867f4ce1","no"),
("3307","options_theme_settings_group_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("3308","_options_theme_settings_group_social_media_icons_0_social_media_item_url","field_607c287af4ce2","no"),
("3309","options_theme_settings_group_social_media_icons_1_social_media_item_name","Youtube","no"),
("3310","_options_theme_settings_group_social_media_icons_1_social_media_item_name","field_607c285af4ce0","no"),
("3311","options_theme_settings_group_social_media_icons_1_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>","no"),
("3312","_options_theme_settings_group_social_media_icons_1_social_media_item_icon","field_607c2867f4ce1","no"),
("3313","options_theme_settings_group_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("3314","_options_theme_settings_group_social_media_icons_1_social_media_item_url","field_607c287af4ce2","no"),
("3315","options_theme_settings_group_social_media_icons_2_social_media_item_name","Instagram","no"),
("3316","_options_theme_settings_group_social_media_icons_2_social_media_item_name","field_607c285af4ce0","no"),
("3317","options_theme_settings_group_social_media_icons_2_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>","no"),
("3318","_options_theme_settings_group_social_media_icons_2_social_media_item_icon","field_607c2867f4ce1","no"),
("3319","options_theme_settings_group_social_media_icons_2_social_media_item_url","https://instagram","no"),
("3320","_options_theme_settings_group_social_media_icons_2_social_media_item_url","field_607c287af4ce2","no"),
("3321","options_theme_settings_group_social_media_icons","3","no"),
("3322","_options_theme_settings_group_social_media_icons","field_607c284af4cdf","no"),
("3323","options_theme_settings_group_theme_404_header_theme","dark","no"),
("3324","_options_theme_settings_group_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3325","options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("3326","_options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("3327","options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("3328","_options_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("3329","options_theme_settings_group_theme_404_reuseable_section_rules","","no"),
("3330","_options_theme_settings_group_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("3331","options_theme_settings_group_theme_404_theme_404_text","<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.","no"),
("3332","_options_theme_settings_group_theme_404_theme_404_text","field_606eff990ac3e","no"),
("3333","options_theme_settings_group_theme_404","","no"),
("3334","_options_theme_settings_group_theme_404","field_606eff05095e9","no"),
("3335","options_theme_settings_group","","no"),
("3336","_options_theme_settings_group","field_607c280aa71fc","no"),
("3394","options_da_theme_settings_group_theme_header_scripts_head","<script>\r\nconsole.log(\"head tag\");\r\n</script>","no"),
("3395","_options_da_theme_settings_group_theme_header_scripts_head","field_606df4d8c1f9d","no"),
("3396","options_da_theme_settings_group_theme_header_scripts_body_after_opening","<script>\r\nconsole.log(\"after body opening\");\r\n</script>","no"),
("3397","_options_da_theme_settings_group_theme_header_scripts_body_after_opening","field_606df57ec1f9e","no"),
("3398","options_da_theme_settings_group_theme_header_scripts_body_before_end","<script>\r\nconsole.log(\"in the footer\");\r\n</script>","no"),
("3399","_options_da_theme_settings_group_theme_header_scripts_body_before_end","field_606df5c2c1f9f","no"),
("3400","options_da_theme_settings_group_social_media_icons_0_social_media_item_name","Facebook","no"),
("3401","_options_da_theme_settings_group_social_media_icons_0_social_media_item_name","field_607c285af4ce0","no"),
("3402","options_da_theme_settings_group_social_media_icons_0_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>","no"),
("3403","_options_da_theme_settings_group_social_media_icons_0_social_media_item_icon","field_607c2867f4ce1","no"),
("3404","options_da_theme_settings_group_social_media_icons_0_social_media_item_url","https://facebook.com","no"),
("3405","_options_da_theme_settings_group_social_media_icons_0_social_media_item_url","field_607c287af4ce2","no"),
("3406","options_da_theme_settings_group_social_media_icons_1_social_media_item_name","Youtube","no"),
("3407","_options_da_theme_settings_group_social_media_icons_1_social_media_item_name","field_607c285af4ce0","no"),
("3408","options_da_theme_settings_group_social_media_icons_1_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>","no"),
("3409","_options_da_theme_settings_group_social_media_icons_1_social_media_item_icon","field_607c2867f4ce1","no"),
("3410","options_da_theme_settings_group_social_media_icons_1_social_media_item_url","https://youtube.com","no"),
("3411","_options_da_theme_settings_group_social_media_icons_1_social_media_item_url","field_607c287af4ce2","no"),
("3412","options_da_theme_settings_group_social_media_icons_2_social_media_item_name","Instagram","no"),
("3413","_options_da_theme_settings_group_social_media_icons_2_social_media_item_name","field_607c285af4ce0","no"),
("3414","options_da_theme_settings_group_social_media_icons_2_social_media_item_icon","<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>","no"),
("3415","_options_da_theme_settings_group_social_media_icons_2_social_media_item_icon","field_607c2867f4ce1","no"),
("3416","options_da_theme_settings_group_social_media_icons_2_social_media_item_url","https://instagram","no"),
("3417","_options_da_theme_settings_group_social_media_icons_2_social_media_item_url","field_607c287af4ce2","no"),
("3418","options_da_theme_settings_group_social_media_icons","3","no"),
("3419","_options_da_theme_settings_group_social_media_icons","field_607c284af4cdf","no"),
("3420","options_da_theme_settings_group_theme_404_header_theme","dark","no"),
("3421","_options_da_theme_settings_group_theme_404_header_theme","field_606f0135bbcfd_field_606cc823a35b8","no"),
("3422","options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","","no"),
("3423","_options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_styling","field_606469f51d054","no"),
("3424","options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","default","no"),
("3425","_options_da_theme_settings_group_theme_404_reuseable_section_rules_section_rules_theme","field_60646a081d055","no"),
("3426","options_da_theme_settings_group_theme_404_reuseable_section_rules","","no"),
("3427","_options_da_theme_settings_group_theme_404_reuseable_section_rules","field_606eff6d0ac3d_field_606469c2a9cc1","no"),
("3428","options_da_theme_settings_group_theme_404_theme_404_text","<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.","no"),
("3429","_options_da_theme_settings_group_theme_404_theme_404_text","field_606eff990ac3e","no"),
("3430","options_da_theme_settings_group_theme_404","","no"),
("3431","_options_da_theme_settings_group_theme_404","field_606eff05095e9","no"),
("3432","options_da_theme_settings_group","a:5:{s:19:\"field_606df4d8c1f9d\";s:45:\"<script>\r\nconsole.log(\"head tag\");\r\n</script>\";s:19:\"field_606df57ec1f9e\";s:55:\"<script>\r\nconsole.log(\"after body opening\");\r\n</script>\";s:19:\"field_606df5c2c1f9f\";s:50:\"<script>\r\nconsole.log(\"in the footer\");\r\n</script>\";s:19:\"field_607c284af4cdf\";a:3:{i:0;a:3:{s:19:\"field_607c285af4ce0\";s:8:\"Facebook\";s:19:\"field_607c2867f4ce1\";s:386:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-facebook\" viewBox=\"0 0 512 512\">\r\n<path d=\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:20:\"https://facebook.com\";}i:1;a:3:{s:19:\"field_607c285af4ce0\";s:7:\"Youtube\";s:19:\"field_607c2867f4ce1\";s:592:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-youtube\" viewBox=\"0 0 576 512\">\r\n	<path d=\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:19:\"https://youtube.com\";}i:2;a:3:{s:19:\"field_607c285af4ce0\";s:9:\"Instagram\";s:19:\"field_607c2867f4ce1\";s:1046:\"<!--?xml version=\"1.0\" encoding=\"UTF-8\"?-->\r\n<svg class=\"icon-instagram\" viewBox=\"0 0 448 512\">\r\n	<path d=\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\"></path>\r\n</svg>\";s:19:\"field_607c287af4ce2\";s:17:\"https://instagram\";}}s:19:\"field_606eff05095e9\";a:3:{s:39:\"field_606f0135bbcfd_field_606cc823a35b8\";s:4:\"dark\";s:39:\"field_606eff6d0ac3d_field_606469c2a9cc1\";a:2:{s:19:\"field_606469f51d054\";s:0:\"\";s:19:\"field_60646a081d055\";s:7:\"default\";}s:19:\"field_606eff990ac3e\";s:82:\"<h1>404</h1>\r\n<h2>Something went wrong</h2>\r\nPlease reload the page and try again.\";}}","no"),
("3433","_options_da_theme_settings_group","field_607c280aa71fc","no"),
("3566","wpml-previous-default-language","en","yes"),
("3685","category_children_da","a:0:{}","yes"),
("3690","_wpml_batch_report","a:1:{i:1;a:1:{s:5:\"en|da\";a:5:{i:0;a:3:{s:10:\"element_id\";s:3:\"586\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"1\";}i:1;a:3:{s:10:\"element_id\";s:3:\"822\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"2\";}i:2;a:3:{s:10:\"element_id\";s:3:\"426\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"3\";}i:3;a:3:{s:10:\"element_id\";s:3:\"305\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"4\";}i:4;a:3:{s:10:\"element_id\";s:3:\"266\";s:4:\"type\";s:4:\"post\";s:6:\"job_id\";s:1:\"5\";}}}}","no"),
("3727","acfml_synchronise_repeater_fields","a:2:{i:822;b:0;i:266;b:1;}","yes"),
("3776","wpml_notices","a:1:{s:26:\"taxonomy-term-help-notices\";a:2:{s:8:\"post_tag\";O:11:\"WPML_Notice\":24:{s:30:\"\0WPML_Notice\0display_callbacks\";a:1:{i:0;a:2:{i:0;O:37:\"WPML_Taxonomy_Translation_Help_Notice\":2:{s:57:\"\0WPML_Taxonomy_Translation_Help_Notice\0wpml_admin_notices\";O:12:\"WPML_Notices\":6:{s:27:\"\0WPML_Notices\0notice_render\";O:18:\"WPML_Notice_Render\":3:{s:38:\"\0WPML_Notice_Render\0dismiss_html_added\";b:0;s:35:\"\0WPML_Notice_Render\0hide_html_added\";b:0;s:39:\"\0WPML_Notice_Render\0collapse_html_added\";b:0;}s:21:\"\0WPML_Notices\0notices\";a:1:{s:26:\"taxonomy-term-help-notices\";N;}s:31:\"\0WPML_Notices\0notices_to_remove\";a:1:{s:12:\"requirements\";a:0:{}}s:23:\"\0WPML_Notices\0dismissed\";a:0:{}s:28:\"\0WPML_Notices\0user_dismissed\";a:0:{}s:34:\"\0WPML_Notices\0original_notices_md5\";s:32:\"40cd750bba9870f18aada2478b24840a\";}s:45:\"\0WPML_Taxonomy_Translation_Help_Notice\0notice\";r:3;}i:1;s:26:\"should_display_help_notice\";}}s:15:\"\0WPML_Notice\0id\";s:8:\"post_tag\";s:17:\"\0WPML_Notice\0text\";s:218:\"Translating Tags? Use the <a href=\"https://milo.sgsmedia.dk/wp/wp-admin/admin.php?page=sitepress-multilingual-cms/menu/taxonomy-translation.php&#038;taxonomy=post_tag\"> Tag translation</a> table for easier translation.\";s:27:\"\0WPML_Notice\0collapsed_text\";N;s:18:\"\0WPML_Notice\0group\";s:26:\"taxonomy-term-help-notices\";s:35:\"\0WPML_Notice\0restricted_to_user_ids\";a:0:{}s:20:\"\0WPML_Notice\0actions\";a:1:{i:0;O:18:\"WPML_Notice_Action\":9:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:0;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:0;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:7:\"Dismiss\";s:23:\"\0WPML_Notice_Action\0url\";s:1:\"#\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";s:26:\"taxonomy-term-help-notices\";s:31:\"\0WPML_Notice_Action\0js_callback\";s:40:\"wpml_dismiss_taxonomy_translation_notice\";s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:1;s:31:\"\0WPML_Notice_Action\0link_target\";N;}}s:28:\"\0WPML_Notice\0css_class_types\";a:1:{i:0;s:4:\"info\";}s:24:\"\0WPML_Notice\0css_classes\";a:0:{}s:24:\"\0WPML_Notice\0dismissible\";b:0;s:31:\"\0WPML_Notice\0exclude_from_pages\";a:0:{}s:21:\"\0WPML_Notice\0hideable\";b:0;s:24:\"\0WPML_Notice\0collapsable\";b:0;s:30:\"\0WPML_Notice\0restrict_to_pages\";a:0:{}s:38:\"\0WPML_Notice\0restrict_to_page_prefixes\";a:0:{}s:35:\"\0WPML_Notice\0restrict_to_screen_ids\";a:0:{}s:34:\"\0WPML_Notice\0hide_if_notice_exists\";N;s:43:\"\0WPML_Notice\0dismissible_for_different_text\";b:1;s:31:\"\0WPML_Notice\0default_group_name\";s:7:\"default\";s:25:\"\0WPML_Notice\0capabilities\";a:0:{}s:26:\"\0WPML_Notice\0dismiss_reset\";b:0;s:18:\"\0WPML_Notice\0flash\";b:0;s:25:\"\0WPML_Notice\0nonce_action\";N;s:22:\"\0WPML_Notice\0text_only\";b:0;}s:8:\"category\";O:11:\"WPML_Notice\":24:{s:30:\"\0WPML_Notice\0display_callbacks\";a:1:{i:0;a:2:{i:0;O:37:\"WPML_Taxonomy_Translation_Help_Notice\":2:{s:57:\"\0WPML_Taxonomy_Translation_Help_Notice\0wpml_admin_notices\";O:12:\"WPML_Notices\":6:{s:27:\"\0WPML_Notices\0notice_render\";O:18:\"WPML_Notice_Render\":3:{s:38:\"\0WPML_Notice_Render\0dismiss_html_added\";b:0;s:35:\"\0WPML_Notice_Render\0hide_html_added\";b:0;s:39:\"\0WPML_Notice_Render\0collapse_html_added\";b:0;}s:21:\"\0WPML_Notices\0notices\";a:1:{s:26:\"taxonomy-term-help-notices\";N;}s:31:\"\0WPML_Notices\0notices_to_remove\";a:1:{s:12:\"requirements\";a:0:{}}s:23:\"\0WPML_Notices\0dismissed\";a:0:{}s:28:\"\0WPML_Notices\0user_dismissed\";a:0:{}s:34:\"\0WPML_Notices\0original_notices_md5\";s:32:\"6234fbbebe4298eece45ef9cc4a493be\";}s:45:\"\0WPML_Taxonomy_Translation_Help_Notice\0notice\";r:55;}i:1;s:26:\"should_display_help_notice\";}}s:15:\"\0WPML_Notice\0id\";s:8:\"category\";s:17:\"\0WPML_Notice\0text\";s:229:\"Translating Categories? Use the <a href=\"https://milo.sgsmedia.dk/wp/wp-admin/admin.php?page=sitepress-multilingual-cms/menu/taxonomy-translation.php&#038;taxonomy=category\"> Category translation</a> table for easier translation.\";s:27:\"\0WPML_Notice\0collapsed_text\";N;s:18:\"\0WPML_Notice\0group\";s:26:\"taxonomy-term-help-notices\";s:35:\"\0WPML_Notice\0restricted_to_user_ids\";a:0:{}s:20:\"\0WPML_Notice\0actions\";a:1:{i:0;O:18:\"WPML_Notice_Action\":9:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:0;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:0;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:7:\"Dismiss\";s:23:\"\0WPML_Notice_Action\0url\";s:1:\"#\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";s:26:\"taxonomy-term-help-notices\";s:31:\"\0WPML_Notice_Action\0js_callback\";s:40:\"wpml_dismiss_taxonomy_translation_notice\";s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:1;s:31:\"\0WPML_Notice_Action\0link_target\";N;}}s:28:\"\0WPML_Notice\0css_class_types\";a:1:{i:0;s:4:\"info\";}s:24:\"\0WPML_Notice\0css_classes\";a:0:{}s:24:\"\0WPML_Notice\0dismissible\";b:0;s:31:\"\0WPML_Notice\0exclude_from_pages\";a:0:{}s:21:\"\0WPML_Notice\0hideable\";b:0;s:24:\"\0WPML_Notice\0collapsable\";b:0;s:30:\"\0WPML_Notice\0restrict_to_pages\";a:0:{}s:38:\"\0WPML_Notice\0restrict_to_page_prefixes\";a:0:{}s:35:\"\0WPML_Notice\0restrict_to_screen_ids\";a:0:{}s:34:\"\0WPML_Notice\0hide_if_notice_exists\";N;s:43:\"\0WPML_Notice\0dismissible_for_different_text\";b:1;s:31:\"\0WPML_Notice\0default_group_name\";s:7:\"default\";s:25:\"\0WPML_Notice\0capabilities\";a:0:{}s:26:\"\0WPML_Notice\0dismiss_reset\";b:0;s:18:\"\0WPML_Notice\0flash\";b:0;s:25:\"\0WPML_Notice\0nonce_action\";N;s:22:\"\0WPML_Notice\0text_only\";b:0;}}}","no"),
("3824","category_children","a:0:{}","yes"),
("3866","_icl_cache","a:2:{s:25:\"language_name_cache_class\";a:77:{s:21:\"language_details_sqen\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:21:\"language_details_aren\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:21:\"language_details_hyen\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:21:\"language_details_azen\";a:10:{s:4:\"code\";s:2:\"az\";s:2:\"id\";s:2:\"65\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:11:\"Azərbaycan\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"az\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"az\";s:12:\"display_name\";s:11:\"Azerbaijani\";}s:21:\"language_details_euen\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:21:\"language_details_bnen\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:24:\"বাংলাদেশ\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:21:\"language_details_bsen\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:21:\"language_details_bgen\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:21:\"language_details_caen\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:26:\"language_details_zh-hansen\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:26:\"language_details_zh-hanten\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:21:\"language_details_hren\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:21:\"language_details_csen\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:21:\"language_details_daen\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:21:\"language_details_nlen\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:21:\"language_details_enen\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:21:\"language_details_eoen\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:21:\"language_details_eten\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:21:\"language_details_fien\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:21:\"language_details_fren\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:21:\"language_details_glen\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:21:\"language_details_deen\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:21:\"language_details_elen\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:21:\"language_details_heen\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:21:\"language_details_hien\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:21:\"language_details_huen\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:21:\"language_details_isen\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:21:\"language_details_iden\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:21:\"language_details_gaen\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:21:\"language_details_iten\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:21:\"language_details_jaen\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:21:\"language_details_koen\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:21:\"language_details_kuen\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:21:\"language_details_lven\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:21:\"language_details_lten\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:9:\"Lietuvių\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:21:\"language_details_mken\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:21:\"language_details_msen\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:21:\"language_details_mten\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:21:\"language_details_mnen\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:21:\"language_details_neen\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:21:\"language_details_noen\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:21:\"language_details_faen\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:21:\"language_details_plen\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:24:\"language_details_pt-bren\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:24:\"language_details_pt-pten\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:21:\"language_details_paen\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pa_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:21:\"language_details_quen\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:21:\"language_details_roen\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:21:\"language_details_ruen\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:21:\"language_details_sren\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:21:\"language_details_sken\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:21:\"language_details_slen\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:21:\"language_details_soen\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:21:\"language_details_esen\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:21:\"language_details_sven\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:21:\"language_details_taen\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:21:\"language_details_then\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:21:\"language_details_tren\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:21:\"language_details_uken\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:21:\"language_details_uren\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ur\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:21:\"language_details_uzen\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:21:\"language_details_vien\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:21:\"language_details_cyen\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:21:\"language_details_yien\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:21:\"language_details_zuen\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}s:29:\"all_language_en__english_name\";a:65:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"az\";a:10:{s:4:\"code\";s:2:\"az\";s:2:\"id\";s:2:\"65\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:11:\"Azərbaycan\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"az\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"az\";s:12:\"display_name\";s:11:\"Azerbaijani\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:24:\"বাংলাদেশ\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:9:\"Lietuvių\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pa_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ur\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}s:28:\"in_language_en__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}s:21:\"language_details_dada\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Dansk\";}s:21:\"language_details_enda\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:28:\"in_language_da__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Dansk\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}s:4:\"dada\";s:5:\"Dansk\";s:4:\"enen\";s:7:\"English\";s:4:\"enda\";s:7:\"English\";s:4:\"daen\";s:6:\"Danish\";s:22:\"language_details_daall\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:22:\"language_details_enall\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:29:\"in_language_all__english_name\";a:2:{s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}}}s:17:\"flags_cache_class\";a:2:{s:2:\"da\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"da.png\";s:13:\"from_template\";s:1:\"0\";}s:2:\"en\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"en.png\";s:13:\"from_template\";s:1:\"0\";}}}","no"),
("4324","aDBc_settings","a:5:{s:9:\"left_menu\";s:1:\"1\";s:16:\"menu_under_tools\";s:1:\"1\";s:14:\"plugin_version\";s:5:\"3.0.3\";s:12:\"installed_on\";s:10:\"2021/04/18\";s:9:\"keep_last\";a:1:{s:8:\"revision\";i:0;}}","no"),
("4350","wpml_language_switcher_template_objects","a:6:{s:20:\"wpml-legacy-dropdown\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:124:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:8:\"Dropdown\";s:4:\"slug\";s:20:\"wpml-legacy-dropdown\";s:8:\"base_uri\";s:113:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/\";s:3:\"css\";a:1:{i:1;s:126:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/style.min.css\";}s:2:\"js\";a:1:{i:1;s:126:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown/script.min.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:124:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:26:\"wpml-legacy-dropdown-click\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:130:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:14:\"Dropdown click\";s:4:\"slug\";s:26:\"wpml-legacy-dropdown-click\";s:8:\"base_uri\";s:119:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/\";s:3:\"css\";a:1:{i:1;s:132:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/style.min.css\";}s:2:\"js\";a:1:{i:1;s:132:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click/script.min.js\";}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:2:{i:0;s:8:\"sidebars\";i:1;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:1:{s:29:\"display_link_for_current_lang\";i:1;}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:130:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-dropdown-click\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:27:\"wpml-legacy-horizontal-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:131:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:15:\"Horizontal List\";s:4:\"slug\";s:27:\"wpml-legacy-horizontal-list\";s:8:\"base_uri\";s:120:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/\";s:3:\"css\";a:1:{i:1;s:133:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:131:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:25:\"wpml-legacy-vertical-list\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:129:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:13:\"Vertical List\";s:4:\"slug\";s:25:\"wpml-legacy-vertical-list\";s:8:\"base_uri\";s:118:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/\";s:3:\"css\";a:1:{i:1;s:131:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:3:{i:0;s:8:\"sidebars\";i:1;s:6:\"footer\";i:2;s:17:\"shortcode_actions\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:129:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-vertical\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:29:\"wpml-legacy-post-translations\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:133:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:17:\"Post translations\";s:4:\"slug\";s:29:\"wpml-legacy-post-translations\";s:8:\"base_uri\";s:122:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/\";s:3:\"css\";a:1:{i:1;s:135:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:17:\"post_translations\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:133:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-post-translations\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}s:14:\"wpml-menu-item\";O:16:\"WPML_LS_Template\":10:{s:26:\"\0WPML_LS_Template\0template\";a:12:{s:4:\"path\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:118:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:7:\"version\";s:1:\"1\";s:4:\"name\";s:9:\"Menu Item\";s:4:\"slug\";s:14:\"wpml-menu-item\";s:8:\"base_uri\";s:107:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/\";s:3:\"css\";a:1:{i:1;s:120:\"//milo.sgsmedia.dk/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item/style.min.css\";}s:2:\"js\";a:0:{}s:14:\"flags_base_uri\";N;s:14:\"flag_extension\";N;s:7:\"is_core\";b:1;s:3:\"for\";a:1:{i:0;s:5:\"menus\";}s:14:\"force_settings\";a:0:{}}s:23:\"\0WPML_LS_Template\0model\";a:0:{}s:24:\"\0WPML_LS_Template\0prefix\";s:8:\"wpml-ls-\";s:17:\"\0*\0custom_filters\";a:0:{}s:19:\"\0*\0custom_functions\";a:0:{}s:17:\"\0*\0template_paths\";a:2:{i:0;s:108:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers\";i:1;s:118:\"/var/www/milo.sgsmedia.dk/html/wp/wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/menu-item\";}s:18:\"\0*\0cache_directory\";N;s:18:\"\0*\0template_string\";N;s:30:\"\0WPML_Templates_Factory\0wp_api\";N;s:7:\"\0*\0twig\";N;}}","yes"),
("4427","wpml_wp_updated_mo_files","a:3:{s:4:\"core\";a:1:{s:7:\"default\";i:1618771080;}s:6:\"plugin\";a:4:{s:34:\"advanced-custom-fields-table-field\";i:1618771080;s:7:\"akismet\";i:1618771080;s:11:\"hello-dolly\";i:1618771080;s:14:\"duplicate-post\";i:1618771080;}s:5:\"theme\";a:2:{s:12:\"twentytwenty\";i:1618771080;s:15:\"twentytwentyone\";i:1618771080;}}","no"),
("4463","duplicator_pro_exe_safe_mode","0","yes"),
("4466","duplicator_pro_migration_data","{\n    \"archivePath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/20210418_milo_571_2847e58e825cacda1618_20210418184128_archive.zip\",\n    \"packageHash\": \"2847e58-18184128\",\n    \"installerPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/installer(5).php\",\n    \"installerBootLog\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer-bootlog__c497ba3-18184128.txt\",\n    \"installerLog\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\\/dup-installer-log__c497ba3-18184128.txt\",\n    \"dupInstallerPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/var\\/www\\/milo.sgsmedia.dk\\/html\\/wp\\/dup-installer\\/original_files_2847e58-18184128\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"restoreBackupMode\": false\n}","no"),
("4475","_transient_timeout_acf_plugin_updates","1618944284","no"),
("4476","_transient_acf_plugin_updates","a:4:{s:7:\"plugins\";a:0:{}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.9.5\";}}","no"),
("4487","_site_transient_timeout_browser_66ec6a80fa7013fddb1e67d9da0622a8","1619376304","no"),
("4488","_site_transient_browser_66ec6a80fa7013fddb1e67d9da0622a8","a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"87.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("4489","_site_transient_timeout_php_check_75809dde56e3fe2c2fb740f1b55807ac","1619376304","no"),
("4490","_site_transient_php_check_75809dde56e3fe2c2fb740f1b55807ac","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no"),
("4625","_transient_health-check-site-status-result","{\"good\":\"12\",\"recommended\":\"7\",\"critical\":\"1\"}","yes"),
("4628","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.7.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.7.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.7.1\";s:7:\"version\";s:5:\"5.7.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1618904726;s:15:\"version_checked\";s:5:\"5.7.1\";s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:4:\"core\";s:4:\"slug\";s:7:\"default\";s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.7.1\";s:7:\"updated\";s:19:\"2021-04-20 06:42:13\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.7.1/da_DK.zip\";s:10:\"autoupdate\";b:1;}}}","no"),
("4629","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1618904727;s:7:\"checked\";a:4:{s:4:\"milo\";s:3:\"1.0\";s:14:\"twentynineteen\";s:3:\"2.0\";s:12:\"twentytwenty\";s:3:\"1.7\";s:15:\"twentytwentyone\";s:3:\"1.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.2.0.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.1.7.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.2.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","no"),
("4652","_transient_timeout_wp-rest-enabled-ping","1618910735","no"),
("4653","_transient_wp-rest-enabled-ping","enabled","no"),
("4654","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1618908132;s:7:\"checked\";a:13:{s:48:\"advanced-custom-fields-table-field/acf-table.php\";s:6:\"1.3.12\";s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";s:5:\"2.5.2\";s:18:\"acfml/wpml-acf.php\";s:5:\"1.8.2\";s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.9.5\";s:19:\"akismet/akismet.php\";s:5:\"4.1.9\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:5:\"1.9.0\";s:33:\"duplicator-pro/duplicator-pro.php\";s:5:\"4.0.2\";s:9:\"hello.php\";s:5:\"1.7.2\";s:28:\"real-media-library/index.php\";s:6:\"4.13.4\";s:40:\"sitepress-multilingual-cms/sitepress.php\";s:6:\"4.4.10\";s:34:\"wpml-string-translation/plugin.php\";s:5:\"3.1.8\";s:38:\"wpml-translation-management/plugin.php\";s:6:\"2.10.6\";s:33:\"duplicate-post/duplicate-post.php\";s:5:\"4.1.2\";}s:8:\"response\";a:1:{s:43:\"custom-post-type-ui/custom-post-type-ui.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:33:\"w.org/plugins/custom-post-type-ui\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:6:\"plugin\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"new_version\";s:5:\"1.9.1\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/custom-post-type-ui/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/custom-post-type-ui.1.9.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/custom-post-type-ui/assets/icon-256x256.png?rev=1069557\";s:2:\"1x\";s:72:\"https://ps.w.org/custom-post-type-ui/assets/icon-128x128.png?rev=1069557\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/custom-post-type-ui/assets/banner-1544x500.png?rev=1069557\";s:2:\"1x\";s:74:\"https://ps.w.org/custom-post-type-ui/assets/banner-772x250.png?rev=1069557\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.7.0\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:48:\"advanced-custom-fields-table-field/acf-table.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:48:\"w.org/plugins/advanced-custom-fields-table-field\";s:4:\"slug\";s:34:\"advanced-custom-fields-table-field\";s:6:\"plugin\";s:48:\"advanced-custom-fields-table-field/acf-table.php\";s:11:\"new_version\";s:6:\"1.3.12\";s:3:\"url\";s:65:\"https://wordpress.org/plugins/advanced-custom-fields-table-field/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/advanced-custom-fields-table-field.1.3.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:87:\"https://ps.w.org/advanced-custom-fields-table-field/assets/icon-256x256.png?rev=1962986\";s:2:\"1x\";s:87:\"https://ps.w.org/advanced-custom-fields-table-field/assets/icon-128x128.png?rev=1962986\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:89:\"https://ps.w.org/advanced-custom-fields-table-field/assets/banner-772x250.png?rev=1962986\";}s:11:\"banners_rtl\";a:0:{}}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.1.9\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.1.9.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:5:\"4.1.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/duplicate-post.4.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"real-media-library-lite/index.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:37:\"w.org/plugins/real-media-library-lite\";s:4:\"slug\";s:23:\"real-media-library-lite\";s:6:\"plugin\";s:33:\"real-media-library-lite/index.php\";s:11:\"new_version\";s:6:\"4.13.4\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/real-media-library-lite/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/real-media-library-lite.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/real-media-library-lite/assets/icon-256x256.gif?rev=2293211\";s:2:\"1x\";s:76:\"https://ps.w.org/real-media-library-lite/assets/icon-128x128.gif?rev=2293211\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/real-media-library-lite/assets/banner-1544x500.png?rev=2251436\";s:2:\"1x\";s:78:\"https://ps.w.org/real-media-library-lite/assets/banner-772x250.png?rev=2251436\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:0:\"\";s:4:\"slug\";s:18:\"acf_theme_code_pro\";s:6:\"plugin\";s:41:\"acf-theme-code-pro/acf_theme_code_pro.php\";s:11:\"new_version\";s:5:\"2.5.2\";s:3:\"url\";s:49:\"https://hookturn.io/downloads/acf-theme-code-pro/\";s:7:\"package\";s:192:\"https://hookturn.io/edd-sl/package_download/MTYxOTAyOTUzNzoxOWM4NGE2Zjc1MzdjMjMzMjFhY2U2MGY1YjA0NjZhMjoxNTplZTljNmE5YWM1MzgyY2FkMDE5YjVhYTcwZGE2NzllNzpodHRwc0AvL21pbG8uc2dzbWVkaWEuZGsvd3A6MA==\";s:5:\"icons\";a:2:{s:2:\"1x\";s:81:\"https://hookturn.io/wp-content/uploads/edd/2020/05/acf-theme-code-pro-128x128.jpg\";s:2:\"2x\";s:81:\"https://hookturn.io/wp-content/uploads/edd/2020/05/acf-theme-code-pro-256x256.jpg\";}s:7:\"banners\";O:8:\"stdClass\":2:{s:4:\"high\";s:0:\"\";s:3:\"low\";s:0:\"\";}s:11:\"banners_rtl\";a:0:{}}}}","no"),
("4655","_site_transient_timeout_browser_d4e252f9cf1badbf8d0f65373387d123","1619511937","no"),
("4656","_site_transient_browser_d4e252f9cf1badbf8d0f65373387d123","a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:6:\"13.1.2\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("4657","_site_transient_timeout_community-events-3297ba3b526ea94edc92131fa24bfa21","1618950339","no"),
("4658","_site_transient_community-events-3297ba3b526ea94edc92131fa24bfa21","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"152.115.89.0\";}s:6:\"events\";a:3:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:64:\"Demo + Discussion group: Creating and Registering Block Patterns\";s:3:\"url\";s:68:\"https://www.meetup.com/learn-wordpress-discussions/events/277669249/\";s:6:\"meetup\";s:27:\"Learn WordPress Discussions\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/learn-wordpress-discussions/\";s:4:\"date\";s:19:\"2021-04-23 07:00:00\";s:8:\"end_date\";s:19:\"2021-04-23 08:00:00\";s:20:\"start_unix_timestamp\";i:1619186400;s:18:\"end_unix_timestamp\";i:1619190000;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:37.779998779297;s:9:\"longitude\";d:-122.41999816895;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:15:\"WordCamp Europe\";s:3:\"url\";s:33:\"https://europe.wordcamp.org/2021/\";s:6:\"meetup\";s:0:\"\";s:10:\"meetup_url\";s:0:\"\";s:4:\"date\";s:19:\"2021-06-07 00:00:00\";s:8:\"end_date\";s:19:\"2021-06-10 00:00:00\";s:20:\"start_unix_timestamp\";i:1623020400;s:18:\"end_unix_timestamp\";i:1623279600;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"PT\";s:8:\"latitude\";d:41.1622022;s:9:\"longitude\";d:-8.6570588;}}i:2;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:22:\"April WordPress Meetup\";s:3:\"url\";s:61:\"https://www.meetup.com/WordPress-Copenhagen/events/277651430/\";s:6:\"meetup\";s:20:\"WordPress Copenhagen\";s:10:\"meetup_url\";s:44:\"https://www.meetup.com/WordPress-Copenhagen/\";s:4:\"date\";s:19:\"2021-04-27 17:00:00\";s:8:\"end_date\";s:19:\"2021-04-27 19:00:00\";s:20:\"start_unix_timestamp\";i:1619535600;s:18:\"end_unix_timestamp\";i:1619542800;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"DK\";s:8:\"latitude\";d:55.680000305176;s:9:\"longitude\";d:12.569999694824;}}}}","no"),
("4659","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1618950339","no"),
("4660","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Apr 2021 03:05:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.8-alpha-50770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 5.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2021/04/wordpress-5-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Apr 2021 03:05:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10144\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:365:\"WordPress 5.7.1 is now available! This security and maintenance release features 26 bug fixes in addition to two security fixes. Because this is a security release, it is recommended that you update your sites immediately. All versions since WordPress 4.7 have also been updated. WordPress 5.7.1 is a short-cycle security and maintenance release. The next [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Peter Wilson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8461:\"\n<p>WordPress 5.7.1 is now available!</p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?milestone=5.7.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">26 bug fixes</a> in addition to two security fixes. Because this is a <strong>security release</strong>, it is recommended that you update your sites immediately. All versions since WordPress 4.7 have also been updated.</p>\n\n\n\n<p>WordPress 5.7.1 is a short-cycle security and maintenance release. The next major release will be version 5.8.</p>\n\n\n\n<p>You can download WordPress 5.7.1 by downloading from WordPress.org, or visit your Dashboard → Updates and click Update Now.</p>\n\n\n\n<p>If you have sites that support automatic background updates, they’ve already started the update process.</p>\n\n\n\n<h3>Security Updates</h3>\n\n\n\n<p>Two security issues affect WordPress versions between 4.7 and 5.7. If you haven’t yet updated to 5.7, all WordPress versions since 4.7 have also been updated to fix the following security issues:</p>\n\n\n\n<ul><li>Thank you <a href=\"https://www.sonarsource.com/\">SonarSource</a> for reporting an XXE vulnerability within the media library affecting PHP 8.</li><li>Thanks <a href=\"https://mikaelkorpela.fi/\">Mikael Korpela</a> for reporting a data exposure vulnerability within the REST API.</li></ul>\n\n\n\n<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing the vulnerabilities</a>. This gave the security team time to fix the vulnerabilities before WordPress sites could be attacked.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> and the WordPress security team for their work on these issues.</p>\n\n\n\n<p>For more information, browse the <a href=\"https://core.trac.wordpress.org/query?milestone=5.7.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">full list of changes</a> on Trac, or check out the <a href=\"https://wordpress.org/support/wordpress-version/version-5-7-1/\">version 5.7.1 HelpHub documentation page</a>.</p>\n\n\n\n<h2>Thanks and props!</h2>\n\n\n\n<p>The 5.7.1 release was led by <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">@peterwilsoncc</a> and <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, thank you to everyone who helped make WordPress 5.7.1 happen:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/ninetyninew/\">99w</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/annalamprou/\">annalamprou</a>, <a href=\"https://profiles.wordpress.org/anotherdave/\">anotherdave</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/brechtvds/\">Brecht</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dkoo/\">dkoo</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dragongate/\">dragongate</a>, <a href=\"https://profiles.wordpress.org/eatsleepcode/\">eatsleepcode</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>, <a href=\"https://profiles.wordpress.org/fabianpimminger/\">Fabian Pimminger</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/gab81/\">gab81</a>, <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>, <a href=\"https://profiles.wordpress.org/geoffrey1963/\">Geoffrey</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/grzim/\">grzim</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jaymanpandya/\">Jayman Pandya</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/jonkastonka/\">Johan Jonk Stenström</a>, <a href=\"https://profiles.wordpress.org/goaroundagain/\">Johannes Kinast</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joseeyoast/\">Josee Wouters</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/k3nsai/\">k3nsai</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/mihdan/\">Mikhail Kobzarev</a>, <a href=\"https://profiles.wordpress.org/mmuyskens/\">mmuyskens</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/nicegamer7/\">nicegamer7</a>, <a href=\"https://profiles.wordpress.org/otshelnik-fm/\">Otshelnik-Fm</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pwallner/\">pwallner</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat Khaziev</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rogertheriault/\">Roger Theriault</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/yakimun/\">Sergey Yakimov</a>, <a href=\"https://profiles.wordpress.org/sirstuey/\">SirStuey</a>, <a href=\"https://profiles.wordpress.org/stefanjoebstl/\">stefanjoebstl</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a>, <a href=\"https://profiles.wordpress.org/terriann/\">Terri Ann</a>, <a href=\"https://profiles.wordpress.org/tigertech/\">tigertech</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a>, and <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10144\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"People of WordPress: Tyler Lau\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2021/04/people-of-wordpress-tyler-lau/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Apr 2021 13:47:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"ContributorStory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10102\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"In this People of WordPress contributor story, we chat with Tyler Lau from Kansas, US, on his journey with WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10363:\"\n<p><em>WordPress is open source software, maintained by a global network of contributors. There are many examples of how WordPress has changed people’s lives for the better. In this monthly series, we share some of the amazing stories that are lesser-known.</em></p>\n\n\n\n<h2><strong>Embrace Who You Are and Your Journey</strong></h2>\n\n\n\n<p>In this People of WordPress contributor story, we chat to Tyler Lau from the US on his relationship building work in marketing and his WordPress journey.</p>\n\n\n\n<p>Read on to discover his story which shows it is often what you have learned from negative experiences in your life that can make you a major asset to a product team.</p>\n\n\n\n<figure class=\"wp-block-image size-large is-resized\"><img loading=\"lazy\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-thumb.jpg?resize=632%2C464&#038;ssl=1\" alt=\"Tyler Lau stood in front of a colorful mural\" class=\"wp-image-10116\" width=\"632\" height=\"464\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-thumb.jpg?zoom=2&amp;resize=640%2C470&amp;ssl=1 1280w, https://i1.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-thumb.jpg?zoom=3&amp;resize=640%2C470&amp;ssl=1 1920w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2><strong>An Entrepreneurial Mindset</strong></h2>\n\n\n\n<p>Tyler recalls he always had a knack for spotting a enterprise ideas. As an industrious seven-year-old, he was already finding ways to make sales during the school breaks.&nbsp;</p>\n\n\n\n<p>While many entrepreneurs have similar stories, Tyler’s path took many turns before he discovered and thrived in the WordPress community.</p>\n\n\n\n<p>He was drawn to both the software and the community that surrounds it from his search for personal and professional freedom. He ultimately was able to combine his various business interests and people skills into professional marketing work.</p>\n\n\n\n<h2><strong>Using your skills to uncover your journey</strong></h2>\n\n\n\n<figure class=\"wp-block-image size-large is-resized\"><img loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-2.jpg?resize=632%2C758&#038;ssl=1\" alt=\"Tyler Lau pictured sat on a chair using his mobile phone in his social media work\" class=\"wp-image-10118\" width=\"632\" height=\"758\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-2.jpg?zoom=2&amp;resize=640%2C768&amp;ssl=1 1280w, https://i0.wp.com/wordpress.org/news/files/2021/04/people-of-wp-tyler-2.jpg?zoom=3&amp;resize=640%2C768&amp;ssl=1 1920w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Tyler’s current role is as a Marketing Relationship Builder, based in Kansas, USA. His responsibilities span across all digital properties and products, leveraging his broad set of business and people skills.</p>\n\n\n\n<p>These skills are amplified by his creativity and adaptability. Tyler says that one reason he is always looking for new projects is his Attention Deficit Hyperactivity Disorder (ADHD), a diagnosis he received in 2005.</p>\n\n\n\n<p>In an industry built by programmers and developers who often have a strong sense of focus, Tyler felt that someone with ADHD wouldn’t be seen as a natural fit. He found the WordPress community to be a place where everyone can find the right spot for their unique skills. Tyler’s skill is people, and this has translated into many opportunities and responsibilities in his work life. His skills have also helped him give back to the WordPress community as a speaker and volunteer, and through multiple contributor days.</p>\n\n\n\n<h2><strong>Relationship-building as a career</strong></h2>\n\n\n\n<p>Most of Tyler’s experience was in the restaurant industry, and his resume did not exactly point to a career in tech. But the service industry actually prepared him well for everything he has taken on since.</p>\n\n\n\n<p>When he is at work events, he meets people from across the world and builds connections with them. As an extrovert, he enjoys this and couldn’t imagine a job where he was isolated from getting to know others and relationship-building.</p>\n\n\n\n<p>Understanding people and being able to operate in any setting are key competencies. Social skills and tact are useful for community building in the WordPress space too, and in Tyler’s life at different times it has been necessary for survival. </p>\n\n\n\n<h2><strong>The true meaning of freedom</strong></h2>\n\n\n\n<p>In the WordPress community, the concept of freedom comes up often. WordPress is built on GPL, free software, and open-source values. Practically speaking, anyone can work remotely or be their own boss to gain more freedom in work and life.&nbsp;Tyler feels that he never fitted into a traditional work mould. With his strong focus on freedom, he found this resonated with the freedom and opportunities he believes WordPress provides him and thousands of others.</p>\n\n\n\n<p>Tyler describes how in 2013 his ‘inner opportunist’ got him into trouble. After dropping out of college following a brain aneurysm, he needed capital to fund his first startup.&nbsp;He shares that he found a quick but unlawful way to make money. Alongside this between shifts as a waiter, he worked on prototypes for his first product. The company was growing fast, and to protect his patents and take research and development to the next level, he had to work hard. Everything came to a halt when some of the actions he took resulted in being sent to prison.  </p>\n\n\n\n<p>He says that meeting other inmates reminded him that he was in a much better situation than most. He was educated, well-off, loved, and knew he had a future once he was released. He found that many inmates never graduated from high school and were computer illiterate. While inside, Tyler taught subjects like science, math, writing, reading, and social studies. He found that due to the lack of skills and support, many inmates would struggle upon release. He believes getting the mental health support and job training needed to thrive after prison is not easy for many.</p>\n\n\n\n<p>“<em>There’s more to freedom than just being on the outside. You also need a sense of agency and enfranchisement,</em>” says Tyler. He considered his sense of purpose and support network were plenty to keep him going and was ready to take on his next (legal) business challenge as soon as he could.</p>\n\n\n\n<h2>Going forward positively&nbsp;</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"632\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/04/FF50DF21-38AA-4778-B465-C2DF0B441AD7.jpeg?resize=632%2C632&#038;ssl=1\" alt=\"Tyler Lau portrait picture\" class=\"wp-image-10139\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/04/FF50DF21-38AA-4778-B465-C2DF0B441AD7.jpeg?w=640&amp;ssl=1 640w, https://i0.wp.com/wordpress.org/news/files/2021/04/FF50DF21-38AA-4778-B465-C2DF0B441AD7.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/04/FF50DF21-38AA-4778-B465-C2DF0B441AD7.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>The idea that your past doesn’t define you and you can choose to embrace it, is a key driver for Tyler.</p>\n\n\n\n<p>He describes himself as an outlier in many ways. He recalls how politics influenced his life from the day he was born. Tyler’s father is a semi-dissident Chinese visual anthropologist, his mother is an art professor who left her home country of Japan to break free from traditional Japanese gender roles. Tyler feels he inherited a lot of this fearlessness.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>“<em>I’ve never fitted in, and yet this is what makes me able to adapt to most situations and relate to just about anyone. I embrace my eclectic, dissonant past and see beauty in the person those experiences shaped me to be</em>,” says Tyler.&nbsp;</p></blockquote>\n\n\n\n<p>Now, he’s able to put those skills to good use in the WordPress community and beyond.&nbsp;</p>\n\n\n\n<p>He says: “<em>Regardless of your physical abilities, mental health struggles, upbringing, and even your run-ins with the law, no one is excluded from carving their place in the WordPress industry</em>”.<br></p>\n\n\n\n<h2><strong>Contributors</strong></h2>\n\n\n\n<p>Thank you to Tyler Lau (<a href=\'https://profiles.wordpress.org/tylermaximus/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tylermaximus</a>) for sharing his #ContributorStory.</p>\n\n\n\n<p>Thanks to Larissa Murillo (<a href=\"https://profiles.wordpress.org/lmurillom/\">@lmurillom</a>), Surendra Thakor (<a href=\'https://profiles.wordpress.org/sthakor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sthakor</a>), Olga Gleckler (<a href=\'https://profiles.wordpress.org/oglekler/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>oglekler</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\">@meher</a>), Yvette Sonneveld (<a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>), Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a>), Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a>), Chloé Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\">@cbringmann</a>) and Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\">@topher1kenobe</a>) for working on the People of WordPress series.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://lh3.googleusercontent.com/Y3odYTyvSfJbVxUxUWEgKxOprox2zxVwhk7_vdW-AIs4IlE-jK0Zt1itCj867x0dIAbIiK-VeuTLMZr6BjNEY0fkTf--4dT1hkLbnGtsPFNfyrVBYIN59IirTkNnqiQgqxk6E1MI\" alt=\"HeroPress logo\" /></figure>\n\n\n\n<p><em>This post is based on an article originally published on HeroPress.com, a community initiative created by&nbsp;</em><a href=\"https://profiles.wordpress.org/topher1kenobe/\"><em>Topher DeRosia</em></a><em>. It highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.</em></p>\n\n\n\n<p><em>Meet more WordPress community members in our&nbsp;<a href=\"https://wordpress.org/news/category/heropress/\">People of WordPress</a>&nbsp;series.</em></p>\n\n\n\n<p><em>#ContributorStory #HeroPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WP Briefing: Who Is WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/news/2021/04/who-is-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Apr 2021 14:36:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=10099\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"In this episode, Josepha explores the five groups within the WordPress ecosystem and provides a high-level example of how they interact and support one another. As always, stay tuned for the small list of big things and a contributor highlight.  \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/04/WP-Briefing-006.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9292:\"\n<p>In this episode, Josepha explores the five groups within the WordPress ecosystem and provides a high-level example of how they interact and support one another. As always, stay tuned for the small list of big things and a contributor highlight.&nbsp;&nbsp;</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2><strong>Credits</strong></h2>\n\n\n\n<ul><li>Editor:<a href=\"https://profiles.wordpress.org/dustinhartzler/\"> Dustin Hartzler</a></li><li>Logo:<a href=\"https://profiles.wordpress.org/beafialho/\"> Beatriz Fialho</a></li><li>Production:<a href=\"https://profiles.wordpress.org/mkaz/\"> </a><a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2>References</h2>\n\n\n\n<ul><li>Get to know<a href=\"https://make.wordpress.org/\"> WordPress Teams</a></li><li><a href=\"https://wordpress.tv/2017/12/10/josepha-haden-beginners-guide-to-contributions/\">Five Steps of Volunteer Engagement </a></li><li><a href=\"https://twitter.com/CoachBirgit/status/1339516878495117313\">Community Highlight </a></li><li><a href=\"https://centroamerica.wordcamp.org/2021/\">WordCamp Centroamérica 2021 Online</a> (<a href=\"https://centroamerica.wordcamp.org/2021/sesiones/\">Schedule</a>)</li><li><a href=\"https://wordpress.org/news/2021/03/so-you-want-to-make-block-patterns/\">So you want to make block patterns?</a></li><li><a href=\"https://docs.google.com/spreadsheets/d/1h73xMwjSRkJJsn7ooiwXFeZpd0hxXh26pJ7qXzI5iUg/edit#gid=0\">Gutenberg Tutorial sign-up</a></li></ul>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-10099\"></span>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress briefing, the podcast where you can catch quick explanations of some of the ideas behind the WordPress open source project and the community around it, as well as get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>In the first episode of this podcast, I said that there&#8217;s a lot that goes into WordPress, that&#8217;s really hard to see. One of the hardest things to see about the WordPress project as you get started is the overall structure. There is quite a bit of documentation that can clarify the basics: the names of teams, what they work on, and where, and when they meet. The way that they influence and support each other can really feel like a bit of a mystery. So today, I&#8217;m going to break down the WordPress community into five big groups; I want you to keep a couple of things in mind.&nbsp;</p>\n\n\n\n<p>Firstly, these are high-level and based on my observations. Each of these groups can be further broken down into subgroups. So while you may not feel represented in this exact five, you are included if you were to dig a little bit deeper. The second thing to keep in mind is that the makeup of these groups is pretty fluid. Many community members find themselves in more than one group, but generally not far off. Some group two folks end up in group three, depending on the situation, people in group four can also end up in group five, and so on. As with so many things that I share, I&#8217;m not trying to insist that one size fits all. I&#8217;m not trying to put the WordPress community into a box. This is just a basic framework to understand how it all fits together. Alright, are you ready? I&#8217;m ready. Let&#8217;s do it!</p>\n\n\n\n<p>Okay, I have a broad definition of the community, which I have mentioned before. I believe that the community is anyone who has interacted with WordPress, whether they know it or not. So, I&#8217;ll start from way out there and work my way in that first group; we’re going to call our <strong>Visitors</strong>.&nbsp;</p>\n\n\n\n<p><strong>Visitors</strong> are people who arrive at a WordPress site to gain information or engage in an activity. Sometimes they know it&#8217;s a WordPress site, but most of the time, they don&#8217;t. The second group are <strong>Users</strong>, people who use WordPress as their CMS. So, that&#8217;s website builders, website designers, small businesses, content creators, and the list goes on and on. The third group I like to refer to is the <strong>Extenders</strong>. Those are people who extend WordPress through the creation of blocks, themes, plugins, and more. There are also people who teach WordPress to others through WordPress podcasts, and newsletters and tutorials. The fourth group I refer to as our <strong>Contributors</strong> is the people who contribute to the open source software and the infrastructure supporting it, but not necessarily the same people who contribute directly to their own product. And then there&#8217;s group five, <strong>Leaders</strong>. Those are people who help drive the vision and strategy for WordPress; the most notable member of that group is of course, Matt Mullenweg. And I&#8217;m also in that group.&nbsp;</p>\n\n\n\n<p>Each of these groups directly influenced the groups on either side. For example, a WordPress user is affected by both visitors and extenders. Imagine a content creator who shares their passion for photography through a WordPress site; this photographer may have visitors that need to purchase photos. In response, the user now has a need to make it possible for visitors to purchase photos on a site. So they go to what we consider the extenders, people who have built a plugin that supports that need. And as a result, that user can install that on their site. And they have have satisfied the need of the visitors to their site, the people who now can purchase photos.&nbsp;</p>\n\n\n\n<p>There are a lot of examples like this in the WordPress project. Every small pattern that you see is mirrored in the larger patterns across our ecosystem. And every large pattern you see in the ecosystem can be seen among our teams. It&#8217;s pretty cool to look at really. So, why should this matter to you? From a very practical standpoint, this matters for anyone who&#8217;s trying to learn more about contributing to the WordPress project. These five groups mirror very closely the five steps of volunteer engagement that we see across the ecosystem and from a more philosophical standpoint, it&#8217;s just kind of nice to know who your neighbors are. Without the influence and support of the groups around us, it can be hard to know whether we&#8217;re on the right track or not. So take a look to your left and look to your right, and get to know your partners in this project.</p>\n\n\n\n<p>That brings us now to our community highlight, the segment where I share a note about contributors who have helped others along the way, or WordPress success story. This week&#8217;s highlight is from @CoachBirgit, <a href=\"https://profiles.wordpress.org/coachbirgit/\">Birgit Olzem</a>, a longtime contributor and a friend of mine. Her success story goes like this.&nbsp;</p>\n\n\n\n<p>WordPress has allowed me as a mother of five to leave a toxic marriage for good.&nbsp;</p>\n\n\n\n<p>Later, the community picked me up when I became seriously ill.&nbsp;</p>\n\n\n\n<p>So I can say from the bottom of my heart, that working with WordPress has saved my life.</p>\n\n\n\n<p>And now our small list of big things. I&#8217;ve got three things for you this week. I think that they&#8217;re all very important. And I hope you check them all out. The first one is a reminder that word camp Central America is coming up on April 15 and 16th. If you have not registered for tickets, you still have time, I will share a link to the registration page and the schedule in the show notes below.&nbsp;</p>\n\n\n\n<p>The second thing on our small list of big things is that the Gutenberg 10.4 release is coming out later this week on April 14th. It&#8217;s an important release because it&#8217;s when we take a look at the current iteration of full site editing tools that we have, and decide if it&#8217;s ready to get into the WordPress 5.8 release. There&#8217;s a post that has a little more information about that which I will share in the show notes below as well. If you haven&#8217;t checked out the Gutenberg plugin lately, obviously I think it&#8217;s a good idea to do that in general, but definitely a good idea to check it out now.&nbsp;</p>\n\n\n\n<p>The third thing on our list today is a reminder to check out our most recent block pattern tutorial, I&#8217;ll share a link to that in the show notes. It&#8217;s this kind of tips and tricks, tutorial, the “show me how to do it,” kind of thing in the style of <a href=\"https://css-tricks.com/css-style-guides/\">CSS-Tricks</a>. If you or anyone that you know might be interested in sharing a similar style of tutorial, there&#8217;s a link to a form in that show notes as well so that you can share with us your name and the topic that you&#8217;re interested in. We&#8217;ll take a look and see if it&#8217;s something that we definitely need to make sure our users know how to do. So, that my friends is your small list of big things.&nbsp;</p>\n\n\n\n<p>Thank you for joining in today for the WordPress briefing. I&#8217;m your host, Josepha Haden Chomphosy. I&#8217;ll see you again in a couple of weeks!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10099\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"The Month in WordPress: March 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/04/the-month-in-wordpress-march-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 03 Apr 2021 16:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=10084\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"This way of iterating improves WordPress and ties back to one of my favorite open-source principles. The idea that with many eyes, all bugs are shallow. To me, that means that with enough people looking at a problem, someone is bound to be able to see the solution. These words from Josepha Haden Chomphosy on [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9821:\"\n<blockquote class=\"wp-block-quote\"><p>This way of iterating improves WordPress and ties back to one of my favorite open-source principles. The idea that with many eyes, all bugs are shallow. To me, that means that with enough people looking at a problem, someone is bound to be able to see the solution.</p></blockquote>\n\n\n\n<p class=\"has-drop-cap\">These words from <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a> on the <a href=\"https://wordpress.org/news/2021/03/how-wordpress-improves/\">How WordPress Improves</a> episode of the <a href=\"https://wordpress.org/news/podcast/\">WP Briefing Podcast</a> point to the factors that differentiate building software in an open-source environment. Our updates this month are closely tied to the philosophy behind those core principles of open source software.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.7 released</h2>\n\n\n\n<p>WordPress <a href=\"https://wordpress.org/news/2021/03/esperanza/\">version 5.7</a> “Esperanza,” came out on March 9. The release offers fresher admin colors, several improvements to the block editor, single-click HTTP to HTTPS migration, and a new Robots API. Read more about it in the <a href=\"https://wordpress.org/news/2021/03/esperanza/\">release post</a>, the <a href=\"https://make.wordpress.org/core/2021/02/23/wordpress-5-7-field-guide/\">field guide</a>, and the <a href=\"https://make.wordpress.org/community/2021/03/12/meetup-group-resources-talking-points-for-wordpress-5-7/\">talking points post for meetup groups</a>. The Core Team has also <a href=\"https://make.wordpress.org/core/2021/03/30/5-8-pre-planning/\">started work on WordPress 5.8 pre-planning</a>.</p>\n\n\n\n<p>Want to contribute to WordPress 5.8? Join the WordPress <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a> and follow the <a href=\"https://make.wordpress.org/core/\">Core Team blog</a>. The Core Team hosts weekly chats on Wednesdays at <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=5&amp;min=00&amp;sec=0\">5 AM</a> and <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?hour=20&amp;min=00&amp;sec=0\">8 PM</a> UTC.&nbsp;</p>\n\n\n\n<h2>Gutenberg Version 10.1 and 10.2 are out</h2>\n\n\n\n<p>Contributor teams released Gutenberg <a href=\"https://make.wordpress.org/core/2021/03/02/whats-new-in-gutenberg-10-1-3-march/\">Version 10.1</a> on March 3 and <a href=\"https://make.wordpress.org/core/2021/03/17/whats-new-in-gutenberg-10-2-17-march/\">Version 10.2</a> on March 17.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/03/02/whats-new-in-gutenberg-10-1-3-march/\">Version 10.1</a> showcases significant improvements to reusable blocks, a clearer image toolbar, and spatial options for the social media block. <a href=\"https://make.wordpress.org/core/2021/03/17/whats-new-in-gutenberg-10-2-17-march/\">Version 10.2</a> offers block pattern options to display contents from the query block and removes writing prompts from empty paragraphs in the editor. It also adds width adjustment for spacer blocks in horizontal parent blocks and the ability to transform media and text blocks into columns.</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core Team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Make WordPress Slack</a>. The “<a href=\"https://make.wordpress.org/core/2021/03/08/whats-next-in-gutenberg-march-2021/\">What’s next in Gutenberg</a>” post offers more details on the latest updates. Don’t miss the monthly Gutenberg tutorial on <a href=\"https://wordpress.org/news/2021/03/so-you-want-to-make-block-patterns/\">How to make block patterns</a>!</p>\n\n\n\n<h2>Full Site Editing updates</h2>\n\n\n\n<p>March saw a plethora of updates to the <a href=\"https://make.wordpress.org/core/tag/full-site-editing/\">Full Site Editing</a> project!</p>\n\n\n\n<ul><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> published a <a href=\"https://make.wordpress.org/updates/2021/03/12/full-site-editing-pre-merge-overview/\">Full Site Editing pre-merge overview</a>. She shares the project’s current status, go/no-go dates for core merge, communication plans, and challenges.&nbsp;</li><li>March saw two calls for testing as part of the <a href=\"https://make.wordpress.org/test/handbook/full-site-editing-outreach-experiment/\">Full Site Editing outreach program</a>. The first test of the month — <a href=\"https://make.wordpress.org/test/2021/03/09/fse-program-testing-call-3-create-a-fun-custom-404-%20page/\">creating a custom 404 page</a>,&nbsp; wrapped up successfully.&nbsp; Participate in the latest testing initiative — <a href=\"https://make.wordpress.org/test/2021/03/25/fse-program-testing-call-4-building-a-restaurant-themed-header/\">&nbsp;build a restaurant-themed website header</a> to help improve the future of WordPress! Deadline: April 8.&nbsp;</li><li>You can also find <a href=\"https://make.wordpress.org/core/2021/03/16/high-level-feedback-from-the-fse-program-march/\">high-level feedback on the FSE Program</a> in this March 2021 post.</li></ul>\n\n\n\n<h2>Proposal launched for a WordPress contributor handbook</h2>\n\n\n\n<p>A proposal has been kicked off on <a href=\"https://make.wordpress.org/updates/2021/03/16/proposal-a-wordpress-project-contributor-handbook/\">building a project-wide WordPress contributor handbook</a>. The handbook will have content around the WordPress project’s underlying philosophies and commitments, along with shared expectations on working together and building products. It will also contain modern open source best practices for WordPress.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading</h2>\n\n\n\n<ul><li>You can now schedule office hours with Matt Mullenweg and Josepha Haden as part of their <a href=\"https://make.wordpress.org/core/2021/03/12/q2-listening-hours-april-7th-2021/\">Q2 Quarterly listening hours initiative</a>. This quarter’s listening session is scheduled for April 7th, 2021, from <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210407T2200\">22:00</a>&#8211;<a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20210408T0000\">24:00</a> UTC. Slots are still available — <a href=\"https://calendly.com/mmullenweg/team-lead-office-hours?month=2021-04&amp;date=2021-04-08\">sign up now</a>!&nbsp;</li><li>The Themes Team is working on <a href=\"https://make.wordpress.org/themes/2021/03/17/next-steps-on-themes-and-reviews/\">automating the theme review process</a>. The team has shared a detailed post on these changes and is requesting feedback.</li><li>The Core Team has <a href=\"https://make.wordpress.org/core/2021/03/05/dual-licensing-gutenberg-next-steps/\">kicked-off plans</a> on dual licensing Gutenberg under GPL and MPL.</li><li><a href=\"https://buddypress.org/2021/03/buddypress-7-2-1-security-release/\">Version 7.2.1</a> of BuddyPress (security release) is out! Update all your BuddyPresses!</li><li>The Docs Team shipped the <a href=\"https://make.wordpress.org/docs/2021/03/07/wordpress-documentation-style-guide-google-season-of-docs-2020-project-report-tacitonic/\">WordPress documentation style guide</a> as part of its Google Season of Docs 2020 effort. The team has also kicked off work on applying for <a href=\"https://href.li/?https://make.wordpress.org/docs/tag/season-of-docs-2021/\">Google Season of Docs 2021</a>!</li><li>The Polyglots Team is making <a href=\"https://make.wordpress.org/polyglots/2021/03/26/polyglots-training-working-group-update-2/\">significant progress on building their contributor training program</a>. The team is also requesting feedback on <a href=\"https://make.wordpress.org/polyglots/2021/03/30/request-for-feedback-polyglots-team-stats-dashboard/\">building their dashboard</a>.</li><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> shared an <a href=\"https://make.wordpress.org/updates/2021/03/19/experiment-coordinating-sponsored-contributor-teams/\">experiment to coordinate sponsored contributors</a> by adding them to a private Slack channel to offer them better support.</li><li>The Community Team announced its revamped <a href=\"https://make.wordpress.org/community/2021-wordpress-global-community-sponsorship-program/\">2021 Global Sponsorship Program</a>. The team also published a <a href=\"https://make.wordpress.org/community/2021/03/12/2021-financial-update-for-the-wordpress-community/\">financial update for WP Communities in 2021</a>.</li><li>The Core Team is moving ahead to <a href=\"https://make.wordpress.org/core/2021/03/04/discussion-dropping-support-for-ie11/\">drop support for Internet Explorer 11</a> for upcoming versions of WordPress.</li><li>The Design Team shared <a href=\"https://make.wordpress.org/design/2021/03/30/wordpress-org-patterns-directory/\">initial designs for the Block pattern directory</a>.</li><li>The <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a> workspace briefly went down on March 30 due to a Slack ToS issue, which was subsequently resolved. More details on <a href=\"https://make.wordpress.org/updates/2021/03/30/journal-entry-wordpress-slack-workspace-unavailability/\">this explainer post</a>.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it using this form</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"10084\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:68:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"So you want to make block patterns?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2021/03/so-you-want-to-make-block-patterns/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Mar 2021 17:01:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"tutorials\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9995\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Learn how to make block patterns!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2021/03/reusable-block.mp4\";s:6:\"length\";s:6:\"273436\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2021/03/waves-pattern.mp4\";s:6:\"length\";s:6:\"493389\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Beatriz Fialho\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:22433:\"\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"356\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?resize=632%2C356&#038;ssl=1\" alt=\"\" class=\"wp-image-9998\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?w=1441&amp;ssl=1 1441w, https://i2.wp.com/wordpress.org/news/files/2021/03/Block-Patterns.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>If you&#8217;ve ever built something for the WordPress block editor — a theme or a plugin — you may have also heard about <strong>block patterns</strong>. </p>\n\n\n\n<p>Looking at the patterns that come bundled with WordPress, I thought it would be nice to dedicate to them a short post. They&#8217;re pretty nice, useful shortcuts when you know them, but there&#8217;s a good chance you may not know what they are or why you might want to use them.</p>\n\n\n\n<h2>What&#8217;s a block pattern?</h2>\n\n\n\n<p>Patterns are&nbsp;<strong>collections of pre-arranged blocks</strong>&nbsp;that can be combined and arranged in many ways making it easier to create beautiful content. They act as a head-start, leaving you to plug and play with your content as you see fit and be as simple as single blocks or as complex as a full-page layout.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"632\" height=\"414\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=632%2C414&#038;ssl=1\" alt=\"\" class=\"wp-image-10021\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=1024%2C670&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=300%2C196&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=768%2C503&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=1536%2C1005&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?resize=2048%2C1340&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2021/03/block-library.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>They live in a tab in the block library. You can click or drag and you&#8217;re able to preview them with your site&#8217;s styles.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"632\" height=\"413\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=632%2C413&#038;ssl=1\" alt=\"\" class=\"wp-image-10022\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=1024%2C669&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=300%2C196&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=768%2C502&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=1536%2C1003&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?resize=2048%2C1338&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/03/block-pattern.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>Basically, a block pattern is just a bunch of blocks put together in advance:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>	&lt;!-- wp:group --&gt;\n&lt;div class=\"wp-block-group\"&gt;&lt;div class=\"wp-block-group__inner-container\"&gt;&lt;!-- wp:separator {\"className\":\"is-style-default\"} --&gt;\n&lt;hr class=\"wp-block-separator is-style-default\"/&gt;\n&lt;!-- /wp:separator --&gt;\n&lt;!-- wp:image {\"align\":\"center\",\"id\":553,\"width\":150,\"height\":150,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} --&gt;\n&lt;div class=\"wp-block-image is-style-rounded\"&gt;&lt;figure class=\"aligncenter size-large is-resized\"&gt;&lt;img src=\"https://blockpatterndesigns.mystagingwebsite.com/wp-content/uploads/2021/02/StockSnap_HQR8BJFZID-1.jpg\" alt=\"\" class=\"wp-image-553\" width=\"150\" height=\"150\"/&gt;&lt;/figure&gt;&lt;/div&gt;\n&lt;!-- /wp:image --&gt;\n&lt;!-- wp:quote {\"align\":\"center\",\"className\":\"is-style-large\"} --&gt;\n&lt;blockquote class=\"wp-block-quote has-text-align-center is-style-large\"&gt;&lt;p&gt;\"Contributing makes me feel like I\'m being useful to the planet.\"&lt;/p&gt;&lt;cite&gt;— Anna Wong, &lt;em&gt;Volunteer&lt;/em&gt;&lt;/cite&gt;&lt;/blockquote&gt;\n&lt;!-- /wp:quote --&gt;\n&lt;!-- wp:separator {\"className\":\"is-style-default\"} --&gt;\n&lt;hr class=\"wp-block-separator is-style-default\"/&gt;\n&lt;!-- /wp:separator --&gt;&lt;/div&gt;&lt;/div&gt;\n&lt;!-- /wp:group --&gt;</code></pre>\n\n\n\n<p>That&#8217;s also how you create them: just use the block editor to configure a smattering of blocks to your liking, and the hard part&#8217;s over.</p>\n\n\n\n<h2>How do I get them in the block library?</h2>\n\n\n\n<p>There&#8217;s <a href=\"https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/\">more documentation in the handbook</a>, but what it boils down to is this:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>&lt;?php \n/*\nPlugin Name: Quote Pattern Example Plugin\n*/\n\nregister_block_pattern(\n	\'my-plugin/my-quote-pattern\',\n	array(\n		\'title\'       =&gt; __( \'Quote with Avatar\', \'my-plugin\' ),\n		\'categories\'  =&gt; array( \'text\' ),\n		\'description\' =&gt; _x( \'A big quote with an avatar\".\', \'Block pattern description\', \'my-plugin\' ),\n		\'content\'     =&gt; \'&lt;!-- wp:group --&gt;&lt;div class=\"wp-block-group\"&gt;&lt;div class=\"wp-block-group__inner-container\"&gt;&lt;!-- wp:separator {\"className\":\"is-style-default\"} --&gt;&lt;hr class=\"wp-block-separator is-style-default\"/&gt;&lt;!-- /wp:separator --&gt;&lt;!-- wp:image {\"align\":\"center\",\"id\":553,\"width\":150,\"height\":150,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} --&gt;&lt;div class=\"wp-block-image is-style-rounded\"&gt;&lt;figure class=\"aligncenter size-large is-resized\"&gt;&lt;img src=\"https://blockpatterndesigns.mystagingwebsite.com/wp-content/uploads/2021/02/StockSnap_HQR8BJFZID-1.jpg\" alt=\"\" class=\"wp-image-553\" width=\"150\" height=\"150\"/&gt;&lt;/figure&gt;&lt;/div&gt;&lt;!-- /wp:image --&gt;&lt;!-- wp:quote {\"align\":\"center\",\"className\":\"is-style-large\"} --&gt;&lt;blockquote class=\"wp-block-quote has-text-align-center is-style-large\"&gt;&lt;p&gt;\"Contributing makes me feel like I\\\'m being useful to the planet.\"&lt;/p&gt;&lt;cite&gt;— Anna Wong, &lt;em&gt;Volunteer&lt;/em&gt;&lt;/cite&gt;&lt;/blockquote&gt;&lt;!-- /wp:quote --&gt;&lt;!-- wp:separator {\"className\":\"is-style-default\"} --&gt;&lt;hr class=\"wp-block-separator is-style-default\"/&gt;&lt;!-- /wp:separator --&gt;&lt;/div&gt;&lt;/div&gt;&lt;!-- /wp:group --&gt;\',\n	)\n);\n\n?&gt;</code></pre>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f446.png\" alt=\"👆\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> That&#8217;s a snippet of PHP, which means you can drop it in a WordPress plugin, or perhaps more simply, paste it into the <strong>functions.php</strong> file from your theme. Done:</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"632\" height=\"430\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?resize=632%2C430&#038;ssl=1\" alt=\"\" class=\"wp-image-10047\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?resize=1024%2C696&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?resize=300%2C204&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?resize=768%2C522&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?resize=1536%2C1043&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?w=1908&amp;ssl=1 1908w, https://i2.wp.com/wordpress.org/news/files/2021/03/Quote.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>For patterns that include images, it&#8217;s worth thinking about where those are stored. The <a href=\"https://wordpress.org/themes/tt1-blocks/\">TT1 Blocks theme</a> (which is a fancy name for &#8220;TwentyTwentyOne Blocks&#8221;) stores images in the theme library.</p>\n\n\n\n<h2>Now what?</h2>\n\n\n\n<p>The thing about a block pattern is, as soon as you insert it from the block library, it stops being <em>a cohesive unit</em> — now it&#8217;s just a smattering of blocks, detached from the pattern you created and meant to be customized to your liking. It&#8217;s a <em>shortcut</em>, not a <em>template</em>. That also means you don&#8217;t have to worry about switching themes or deactivating pattern plugins: the blocks you already inserted won&#8217;t go anywhere.</p>\n\n\n\n<p>That being said, if you like this one pattern so much you want to use it again and again, with no customization at all, you can make it into a <a href=\"https://wordpress.org/news/2021/02/gutenberg-tutorial-reusable-blocks/\">reusable block</a>:</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls loop src=\"https://wordpress.org/news/files/2021/03/reusable-block.mp4\"></video></figure>\n\n\n\n<p>Reusable blocks are created, as the name implies, to be reused. The feature is a great way to store small bits of commonly used snippets that you can edit in one place to update in all. &#8220;<strong>Follow me on Twitter</strong>,&#8221; &#8220;<strong>Article series</strong>,<strong>&#8220;</strong> or <strong>&#8220;Subscribe to my podcast&#8221;</strong> are great examples of that.</p>\n\n\n\n<h2>What makes a good block pattern?</h2>\n\n\n\n<p>Patterns, as they ship today, are limited by the features available. If the block editor doesn&#8217;t allow you to customize letter-spacing, your block pattern can&#8217;t either. While the Global Styles project will expand what&#8217;s to blocks, in the meantime, we have to work with the available tools.</p>\n\n\n\n<p>Even then, with the most basic ingredients — color, photography, typography — it is possible to do a lot:</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter\"><img src=\"https://lh5.googleusercontent.com/W3RKCu5c7ONKnmuLdChmOhD40iZAFseq30i-qGwqFaq0dPTj_U5b1JXhhRR96-jRvJvKgC8BBZA4p_-EBYF-WoMRPoDLgCX8FG3RIWQhv6zX6-H7xBj4FZGGRm7cl_qdVgRy9G8q\" alt=\"\" /><figcaption>Three columns with images and text<br></figcaption></figure></div>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"632\" height=\"397\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=632%2C397&#038;ssl=1\" alt=\"\" class=\"wp-image-10036\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=1024%2C644&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=300%2C189&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=768%2C483&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=1536%2C965&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?resize=2048%2C1287&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2021/03/Media-and-text-with-image-on-the-right-1.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /><figcaption>Media and text with image on the right</figcaption></figure></div>\n\n\n\n<p>I designed these patterns to potentially land in WordPress core, which all have a few properties in common:</p>\n\n\n\n<h3><strong>They share a theme.</strong></h3>\n\n\n\n<p>You can think of a pattern as a section of a website: it is meant to be part of a whole, and so it works best when it can exist in the context of other patterns that share the same theme. There are a few sharing a Nature theme in the patterns above, a few sharing an Art theme, and others sharing an Architecture theme. When seen together, it becomes easier to see how you might be able to piece together multiple pages of your site, one page at a time.</p>\n\n\n\n<figure class=\"wp-block-gallery columns-2\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"406\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=632%2C406&#038;ssl=1\" alt=\"\" data-id=\"10033\" data-full-url=\"https://wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png\" data-link=\"https://wordpress.org/news/?attachment_id=10033\" class=\"wp-image-10033\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=1024%2C658&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=300%2C193&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=768%2C493&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=1536%2C987&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?resize=2048%2C1315&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2021/03/Large-header-with-text-and-a-button.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"405\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=632%2C405&#038;ssl=1\" alt=\"\" data-id=\"10034\" data-full-url=\"https://wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png\" data-link=\"https://wordpress.org/news/?attachment_id=10034\" class=\"wp-image-10034\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=1024%2C657&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=300%2C193&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=768%2C493&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=1536%2C986&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?resize=2048%2C1314&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-with-image-on-the-right.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li></ul></figure>\n\n\n\n<h3><strong>They share a minimalist color palette.</strong></h3>\n\n\n\n<p>By being parts of a whole, patterns will inevitably land in a context that uses different colors. With a reduced color palette, there&#8217;s both a better chance of fitting in and less to customize to make it just right.</p>\n\n\n\n<figure class=\"wp-block-gallery columns-2\"><ul class=\"blocks-gallery-grid\"><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"535\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?resize=632%2C535&#038;ssl=1\" alt=\"\" data-id=\"10042\" data-full-url=\"https://wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg\" data-link=\"https://wordpress.org/news/?attachment_id=10042\" class=\"wp-image-10042\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?resize=1024%2C867&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?resize=300%2C254&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?resize=768%2C651&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?resize=1536%2C1301&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?w=1903&amp;ssl=1 1903w, https://i2.wp.com/wordpress.org/news/files/2021/03/Heading-and-a-paragraph.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li><li class=\"blocks-gallery-item\"><figure><img loading=\"lazy\" width=\"632\" height=\"271\" src=\"https://i0.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container.jpg?resize=632%2C271&#038;ssl=1\" alt=\"\" data-id=\"10043\" data-full-url=\"https://wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg\" data-link=\"https://wordpress.org/news/?attachment_id=10043\" class=\"wp-image-10043\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?resize=1024%2C439&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?resize=300%2C129&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?resize=768%2C330&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?resize=1536%2C659&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?resize=2048%2C879&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/03/Media-text-in-a-full-height-container-scaled.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></li></ul></figure>\n\n\n\n<h3><strong>The best patterns <strong>do things you might have not done otherwise</strong>.</strong></h3>\n\n\n\n<p>Whether that&#8217;s images offset to create a unique silhouette, or just using less visible features (like fixed positioning in the Cover block), it&#8217;s a way to surface creativity.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><em>Tip: You can use any block in your patterns, including blocks that came from a plugin. And if that block is in the block directory, it will prompt you to install it with one click if it&#8217;s missing from your self-hosted WordPress:</em></p></blockquote>\n\n\n\n<figure class=\"wp-block-video\"><video controls loop src=\"https://wordpress.org/news/files/2021/03/waves-pattern.mp4\"></video></figure>\n\n\n\n<h2>Here’s a plugin for you</h2>\n\n\n\n<pre class=\"wp-block-code\"><code>&lt;?php \n/*\nPlugin Name: Quote Pattern Example Plugin\n*/\n\nregister_block_pattern(\n	\'my-plugin/my-quote-pattern\',\n	array(\n		\'title\'       =&gt; __( \'Quote with Avatar\', \'my-plugin\' ),\n		\'categories\'  =&gt; array( \'text\' ),\n		\'description\' =&gt; _x( \'A big quote with an avatar\".\', \'Block pattern description\', \'my-plugin\' ),\n		\'content\'     =&gt; \'&lt;!-- wp:group --&gt;&lt;div class=\"wp-block-group\"&gt;&lt;div class=\"wp-block-group__inner-container\"&gt;&lt;!-- wp:separator {\"className\":\"is-style-default\"} --&gt;&lt;hr class=\"wp-block-separator is-style-default\"/&gt;&lt;!-- /wp:separator --&gt;&lt;!-- wp:image {\"align\":\"center\",\"id\":553,\"width\":150,\"height\":150,\"