<?php
   $custom_footer_logo_id = get_theme_mod( 'theme_logo_footer' );
?>
		<footer class="footer">
		    <div class="container">
		        <div class="footer-top">
		            <div class="footer-logo">
		                <a href="<?php echo get_home_url(); ?>">
		                    <img src="<?php echo $custom_footer_logo_id; ?>" class="attachment-full size-full" alt="Milo" loading="lazy" />
		                </a>
		            </div>
		            
					<nav class="footer-navigation">
						<?php 
							// Footer Menu
							wp_nav_menu(
									array(
									'theme_location'  => 'footer-menu',
									'container'       => false,
									'container_id'    => false,
									'container_class' => false,
									'menu_id'         => 'footer-menu-nav',
									'menu_class'      => 'footer-menu-nav',
									'walker' => new Footer_Menu_Nav_Walker()
								)
							);
						?>
					</nav>
					
		            <ul class="footer-social-links list-icon-links">
						<?php get_template_part('parts/section-social_icons'); ?>
		            </ul>
		        </div>
		        <div class="footer-bottom">© <?php echo date("Y"); ?> <?php echo get_bloginfo( 'name' ); ?>. <?php global $label_copyright; echo $label_copyright; ?></div>
		    </div>
		</footer>

		<?php get_template_part('parts/section-modal'); ?>

		<?php wp_footer(); ?>

	</body>
</html>