<?php
	
	// args are received through get_template_part in various /parts/
	$args = wp_parse_args($args);
	
	// size: small, medium, large, full
	$section_img_size = $args['img_size'];
	if( $section_img_size == "" || $section_img_size == null || $section_img_size == "undefined") :
		$section_img_size = 'full';
	endif;

	// possible custom class
	$custom_class = $args['img_custom_class'];

	// img object
	$section_img_id = $args['img_object']['id'];
	$section_img_src = wp_get_attachment_image_src( $section_img_id, $section_img_size, array( 'loading' => true ) );
	$section_img_src_url = $section_img_src[0];
	$section_img_src_width = $section_img_src[1];
	$section_img_src_height = $section_img_src[2];
	$section_img_srcset = wp_get_attachment_image_srcset( $section_img_id, $section_img_size	);
	$section_attachment_alt = get_post_meta( $section_img_id, '_wp_attachment_image_alt', TRUE);

	// lazyload
	$section_lazy_loading = $args['img_lazy_load'];
	$section_lazy_load_attr = "lazy";
	if( $section_lazy_loading != "" && $section_lazy_loading == 'false') :
		$section_lazy_load_attr = "";
	endif;

	// define size logic
	$section_img_size_attr = $args['img_size_attr'];
	$section_img_sizes = "(max-width: 1024px) 100vw, 1024px";
	if( $section_img_size_attr == "false" ) :
		$section_img_sizes = "";
	endif;
?>

<img src="<?php echo esc_url( $section_img_src_url ); ?>" width="<?php echo $section_img_src_width; ?>" height="<?php echo $section_img_src_height; ?>" alt="<?php echo esc_attr( $section_attachment_alt ); ?>" class="<?php echo $custom_class; ?>" srcset="<?php echo $section_img_srcset; ?>" sizes="<?php echo $section_img_sizes; ?>" loading="<?php echo $section_lazy_load_attr; ?>" />