<?php if ( get_row_layout() == 'content_2col' ) : ?>
	<?php
		// section rules
		get_template_part('parts/_code_loop_section_rules');

		$images_right = false;
		$images_right_class = "";
		$img_max_width_class = "info-row-product";
		$img_max_height_class = "";
		$container_center_class = "";

		if ( get_sub_field( 'content_gridcol2_images_to_the_right' ) == 1 ) :
			$images_right = true;
			$images_right_class = " info-content-image-right";
		endif;

		if ( get_sub_field( 'content_gridcol2_no_image_max-width' ) == 1 ) :
			$img_max_width_class = "";
		endif;

		if ( get_sub_field( 'content_gridcol2_no_image_max-height' ) == 1 ) :
			$img_max_height_class = " no-max-height";
		endif;

		if ( get_sub_field( 'content_gridcol2_center_content' ) == 1 ) :
			$container_center_class = " info-row-centered";
		endif;
	?>

	<?php if ( have_rows( 'content_gridcol2' ) ) : ?>
		<section class="section-presentation<?php echo getSectionRules_Theme(); ?><?php echo getSectionRules_Styling(); ?>">
		    <div class="info-rows">
				<?php while ( have_rows( 'content_gridcol2' ) ) : the_row(); ?>
			        <div class="info-row info-content-left-right<?php echo $images_right_class; ?><?php echo $container_center_class; ?><?php echo $img_max_height_class; ?>">
			            <div class="container-smaller">

			            	<?php if(!$images_right) : ?>
			            		<?php $content_gridcol2_row_image_gallery_images = get_sub_field( 'content_gridcol2_row_image_gallery' ); ?>
			            		<?php if ( $content_gridcol2_row_image_gallery_images ) :  ?>
			            			<div class="info-row-col">
				            			<?php foreach ( $content_gridcol2_row_image_gallery_images as $content_gridcol2_row_image_gallery_image ): ?>

				            				<?php
				            					$section_img = $content_gridcol2_row_image_gallery_image;

				            					// print <img> with srcset
												get_template_part( 
												    'parts/_element-img_src_srcset', 
												    null,
													array( 
													    'img_object' => $section_img,
													    'img_custom_class' => $img_max_width_class,
													    'img_size' => 'large',
													    'img_lazy_load' => '',
													    'img_size_attr' => ''
													)
												);
				            				?>

						                <?php endforeach; ?>
					                </div>
								<?php endif; ?>

				                <div class="info-row-col">
				                    <div class="info-row-text rellax" data-rellax-speed="1" data-rellax-mobile-speed="0.5">
										<?php the_sub_field( 'content_gridcol2_row_content' ); ?>

										<?php get_template_part('parts/_code_loop_list_price_display_dom'); ?>
										<?php get_template_part('parts/_code_loop_buttons_display_dom'); ?>
				                    </div>
				                </div>

			            	<?php else : ?>

				                <div class="info-row-col">
				                    <div class="info-row-text rellax" data-rellax-speed="1" data-rellax-mobile-speed="0.5">
										<?php the_sub_field( 'content_gridcol2_row_content' ); ?>

										<?php get_template_part('parts/_code_loop_list_price_display_dom'); ?>
										<?php get_template_part('parts/_code_loop_buttons_display_dom'); ?>
				                    </div>
				                </div>

			            		<?php $content_gridcol2_row_image_gallery_images = get_sub_field( 'content_gridcol2_row_image_gallery' ); ?>
			            		<?php if ( $content_gridcol2_row_image_gallery_images ) :  ?>
			            			<div class="info-row-col">
				            			<?php foreach ( $content_gridcol2_row_image_gallery_images as $content_gridcol2_row_image_gallery_image ): ?>

				            				<?php
				            					$section_img = $content_gridcol2_row_image_gallery_image;

				            					// print <img> with srcset
												get_template_part( 
												    'parts/_element-img_src_srcset', 
												    null,
													array( 
													    'img_object' => $section_img,
													    'img_custom_class' => $img_max_width_class,
													    'img_size' => 'large',
													    'img_lazy_load' => '',
													    'img_size_attr' => ''
													)
												);
				            				?>

						                <?php endforeach; ?>
					                </div>
								<?php endif; ?>

			            	<?php endif; ?>

						</div>
					</div>
				<?php endwhile; ?>

		    </div>
		</section>
		<?php endif; ?>
<?php endif; ?>