<?php
    $args = array(
                'taxonomy' => 'region',
                //'orderby' => 'publish_date',
			    'orderby' => 'id', 
                'order'   => 'ASC'
            );
    $cats = get_categories($args);

    global $label_country_introduction_text;
    global $label_country_footer_text;
?>
<div class="location-modal modal-item">
    <div class="modal-close-layer js-close-location-modal--layer modal-close-trigger"></div>
    <div class="location-modal-container">
        <a class="button-close js-close-location-modal--button modal-close-trigger" href="javascript:void(0)">
            <div class="close-x"></div>
        </a>
        <?php echo $label_country_introduction_text; ?>
        <div class="locations-wrap">

			<?php foreach($cats as $cat) : ?>
				<?php if( get_field( 'region_disable', $cat ) != 1) : ?>
			        <nav class="locations-navigation">
			            <h3><?php echo $cat->name; ?></h3>
			            <ul>

						<?php
					        $args = array(
					            'post_type' => 'country', // the post type
					            'orderby'=> 'title',
					            'order'   => 'ASC',
							    'tax_query' => array(

							        array(
							            'taxonomy' => 'region',
							            'field' => 'term_id',
							            'terms' => $cat->term_id,
							        )

							    )
					        );

					        // The query
					        $the_query = new WP_Query( $args );
					        $country_count = $the_query->found_posts;

					        if ( $the_query->have_posts() ) :
					        	while( $the_query->have_posts() ) : $the_query->the_post(); ?>
					        		<?php if ( get_field( 'country_disable_from_menu' ) != 1 ) : ?>
					                    <li>
					                        <a href="<?php echo get_home_url() ."/". get_field( 'country_shortcode' ); ?>">

					                            <i class="flag">
													<?php $country_flag = get_field( 'country_flag' ); ?>
													<?php if ( $country_flag ) : ?>
														<img src="<?php echo esc_url( $country_flag['url'] ); ?>" alt="<?php echo esc_attr( $country_flag['alt'] ); ?>" />
													<?php endif; ?>
					                            </i>
					                            <span><?php the_title(); ?></span>
					                        </a>
					                    </li>
					                <?php endif; ?>

								<?php endwhile; ?>
							<?php endif; ?>
							<?php wp_reset_postdata(); ?>
		                </ul>
		            </nav>
		        <?php endif; ?>
			<?php endforeach; ?>

        </div>
        <div class="location-modal-footer">
			<?php echo $label_country_footer_text; ?>
        </div>
    </div>
</div>